// Persistence of Vision Ray Tracer Scene Description File
// File: Zwembad.pov
// Vers: 1
// Desc: Zwembad met draak
// Date: 10 oct 1998
// Auth: Ingo Janssen
//

#version 3.1;

#include "colors.inc"
#include "metals.inc"
#include "glass.inc"
#include "draak.inc"

global_settings {
    assumed_gamma 1
    radiosity {
        count 150
        error_bound 0.1
        gray_threshold 0.4
        distance_maximum 0
        low_error_factor 0.85
        nearest_count 6
        minimum_reuse 0.01
        brightness 3.3
        recursion_limit 1
    }
}

light_source {
    <0.0, 0.0, 0.0> 
    color rgb <1.0, 0.95, 0.90>
    area_light
    <10, 0.0, 0.0> <0.0, 0.0, 10>
    4, 4
    adaptive 0
    jitter
    translate <50, 30, -20>
}

sky_sphere {
    pigment {
        gradient y
        color_map { [0.0 color blue 0.6] [1.0 color rgb 0.9] }
    }
}

camera {
	location <9.0, 1.6,-10> 
	look_at  <0.0, 1.6, 0.0>  
	angle 70
}

#declare DakElement = height_field {
	tga
	"dak1.tga"
	smooth
	translate <-0.5, 0.0, -0.5>
	scale <6.40, 2.0, 6.40>
	rotate <0, 270, 0>
	texture { T_Glass3 }
	interior { ior 1.7 }
}          

#declare GlazenDak = union {
    object {DakElement translate <-6.4, 4.0, 9.6>}
    object {DakElement translate < 0.0, 4.0, 9.6>}
    object {DakElement translate < 6.4, 4.0, 9.6>}
    object {DakElement translate <-6.4, 4.0, 3.2>}
    object {DakElement translate < 6.4, 4.0, 3.2>}
    object {DakElement translate <-6.4, 4.0,-3.2>}
    object {DakElement translate < 6.4, 4.0,-3.2>}    
    object {DakElement translate <-6.4, 4.0,-9.6>}
    object {DakElement translate < 0.0, 4.0,-9.6>}
    object {DakElement translate < 6.4, 4.0,-9.6>}
}    

#declare Palen = union {
    #declare xCount=0;
    #declare zCount=0;
    #while (xCount<4)
        #while (zCount<5)
            cone {
                <-9.6,-4.0, 12.8>, 0.3 
                <-9.6, 4.2, 12.8>, 0.05
                translate <xCount*6.4, 0.0, -zCount*6.4>
            }
            #declare zCount=zCount+1;     
        #end
        #declare zCount=0;
        #declare xCount=xCount+1;
    #end
    pigment {color White}
    finish {
        ambient 0.1
        diffuse 0.3
        reflection 0.3
        phong 0.3
        phong_size 50
    }
}

#declare Zwembad= height_field {
    tga
	"pool.tga"
	smooth
	translate <-0.5, 0.000, -0.5>
	scale <25.6, 4.0, 19.2>
	translate <0,-3.935,0>
	rotate <0, 270, 0>
    pigment {
        checker color rgb <1, 1, 1> color rgb <0, 0.15, 0.1> 
        scale 0.25
    }
    finish {reflection 0.3}
}

#declare Water = box {
    <-6,-4, 9>, <6,-0.5,-9>
    texture {
        pigment { color rgbt <0.3, 0.35, 0.37, 1> }
        finish {
            diffuse 0.2
            ambient 0.05
            reflection 0.8
            specular 1.5
            roughness 0.01
            brilliance 0.01
        }
        normal{
            bozo
            normal_map {
                [ 0.3 waves translate -0.5 scale <1, 0.05, 1>*100000 frequency 100000]
                [ 0.7 ripples translate -0.5 scale <1, 0.7, 1>*100000 frequency 100000]
                [ 0.85 ripples translate -0.5 scale <1, 0.6, 1>*100000 frequency 100000]
                [ 1.0 ripples translate -0.5  scale 100000 frequency 100000]
            }
            scale 1
        }
    }
    interior {ior 1.33}
}

#declare Luchtbed=union{
    height_field {
	    tga
	    "LuchtbedOnder.tga"
	    smooth
	    translate <-0.5, 0.446, -0.5>
	    scale <1.0, 0.0798, 2.00>
	    rotate <0, 270, 0>
	    pigment {color rgbt <1, 1, 0.1, 0.6> }
    }
    height_field {
	    tga
	    "LuchtbedBoven.tga"
	    smooth
	    translate <-0.5, 0.446, -0.5>
	    scale <1.0, 0.0798, 2.00>
	    rotate <0.0, 270, 0.0>
	    translate <0.0, 0.08, 0.0>
	    pigment{ color rgbt <1, 1, 1, 0.8>}
        finish {
            ambient 0
            diffuse 0
            reflection 0.5
            phong 0.3
            phong_size 60
        }
        interior { ior 1.7}

    }
}

#declare Tafel = union {
    cylinder {
        <0.0, 0.0, 0.0>, <0.0, 0.035, 0.0>, 0.6 
        translate <0.0, 0.8, 0.0>
        pigment {color White}
    }
    cylinder {
        <0.0, 0.0, 0.0>, <0.0, 0.81, 0.0>,0.05
        pigment {color White}
    }    
    cone {
        <0.0, 0.0, 0.0>, 0.4, <0.0, 0.2, 0.0>, 0.09
        texture {T_Chrome_2C}
    }    
}
 
#declare Bankje= difference {
    box {< 0.0, 0.0, 0.0>, <2.0, 0.45, 0.45>}    
    box {<0.05,-0.1,-0.05>, <1.95, 0.4, 0.5>}
    translate <-1.0, 0.0,-0.225>
    pigment{ color Pink}   
}
       
#declare Kruk= union {
    cylinder {
        <0.0, 0.0, 0.0>, <0.0, 0.05, 0.0>, 0.2
        translate <0.0, 0.6, 0.0>
        pigment {color White}
    }
    torus { 
        0.15, 0.025
        translate <0.0, 0.35, 0.0>
    } 
    cylinder { < 0.2, 0.0, 0.0>, < 0.1, 0.6, 0.0>, 0.025 }    
    cylinder { <-0.2, 0.0, 0.0>, <-0.1, 0.6, 0.0>, 0.025 }    
    cylinder { < 0.0, 0.0, 0.2>, < 0.0, 0.6, 0.1>, 0.025 }    
    cylinder { < 0.0, 0.0,-0.2>, < 0.0, 0.6,-0.1>, 0.025 }
    texture {T_Chrome_2C}
}


    // Alles op z'n plaats gezet

object {Zwembad}

object {Water}

object {Palen}        

object {GlazenDak}

object {
    Draak 
    scale <0.9, 0.9, 0.9>
    rotate <-35, -25, 0.0>
    translate <0.0, 4.0, -1.5>  
}

object {
    Luchtbed
    rotate <0.0, 160, 0.0>
    translate <8.0, 0.0,-6.5>
}

object {
    Tafel
    translate <7.85, 0.0,-1.50>
}    

object {
    Kruk
    rotate <0.0, 45, 87>
    translate <0.0, 0.17, 0.0>
    translate <7.45, 0.0,-2.0>
}

object {
    Kruk
    rotate <0.0, 20, 0.0>
    translate <7.9, 0.0,-3.2>
}

object {
    Bankje
    rotate <0.0, 35, 0.0>
    translate <-7.5, 0.0,-4.0>
}

object {
    Bankje
    rotate <0.0, 30, 0.0>
    translate <-7.8, 0.0,-2.8>
}
