// Persistence of Vision Ray Tracer Scene Description File
// File: .pov
// Vers: 3.1
// Desc: First Encounter IRTC entry
// Date: Nov 98
// Auth: Nathan O'Brien
// Mail: no13@no13.net
// Webp: www.no13.net
// Copyright: (C) Nathan G B O'Brien 1998   

// ==== Standard POV-Ray Includes ====
#include "colors.inc"	// Standard Color definitions  
#include "my_woods.inc"

// no13 Standard light and camera setup
// control variables

#declare Alt_Camera = off;

#if (Alt_Camera = off)
		#declare Eye_Point 	= <-.7,.25,-.35>;
		#declare View_point 	= <-.1,.25,0>;  
	#else 
		#declare Eye_Point 	= <0,1.2,.2>;
		#declare View_point 	= <0,0,.2>;
#end     
#declare Light_Offset 	= <0,.5,0>;
#declare Model_Light 	= off; 

#declare Radiosity_effects 	= on;
#declare Effects_high 		= on;
#declare Main_Scene		= on;
#declare Cat_Body		= on;
    
// statements

camera {
	location Eye_Point
	look_at  View_point
}

#if (Model_Light = on)
	light_source {(Eye_Point + Light_Offset) color White}
	#else
	light_source
	{
  		<0,5,0>                 // light's position (translated below)
  		color White       // light's color
  		spotlight               // this kind of light source
  		point_at <0,0,0>      // direction of spotlight
  		radius 5                // hotspot (inner, in degrees)
  		tightness 50            // tightness of falloff (1...100) lower is softer, higher is tighter
  		falloff 8               // intensity falloff radius (outer, in degrees)
	}
#end        

#if (Radiosity_effects = on)
// Constants used by 'rad_def.inc' are set in 'const.inc'
#include "consts.inc"
#if (Effects_high = off)
	#declare Rad_Quality = Radiosity_Debug;
	#else
	#declare Rad_Quality = Radiosity_Normal;
#end

#include "rad_def.inc"
#end

#if (Main_Scene = on)

plane {y,0 
	// pigment{checker pigment{White},pigment{Black} scale .1} 
	texture{    
		gradient x
		texture_map {
			[0.01 T_Wood2]
			[0.01 T_Wood9 scale <2,1,1>]
			[0.32 T_Wood21]
			[0.32 T_Wood2]
			[0.34 T_Wood2]
			[0.34 T_Wood11]
			[0.65 T_Wood1]
			[0.65 T_Wood2]
			[0.67 T_Wood2]
			[0.67 T_Wood5]
			[0.99 T_Wood21]
			[0.99 T_Wood2] 
		}	
		scale .2
	}
}  

#include "mirror.inc"
object {Mirror rotate <5,10,0> translate <0,0,.4> rotate <0,10,0>}   

// ball of wool
#include "bow.inc"

#end

#if (Cat_Body = on)

#declare T_Cat_Skin =
texture {
  pigment
  {
    bozo
    turbulence 1.2
    color_map
    {
      [0.00 color rgb<0.824, 0.686, 0.580>]
      [0.10 color rgb<0.780, 0.729, 0.690>]
      [0.30 color rgb<0.847, 0.675, 0.518>]
      [0.54 color rgb<0.894, 0.765, 0.584>]
      [0.76 color rgb<0.725, 0.608, 0.522>]
      [0.89 color rgb<0.925, 0.792, 0.624>]
      [1.00 color rgb<1.000, 1.000, 1.000>]
    }
  }
}
texture {
  pigment
  {
    agate
    color_map
    {
      [0.00 color rgb<0.553, 0.427, 0.341>]
      [0.10 color rgbf<0.953, 0.878, 0.808, 0.529>]
      [0.60 color rgbf<0.961, 0.902, 0.867, 0.996>]
      [0.75 color rgbf<0.588, 0.506, 0.420, 0.486>]
      [0.79 color rgb<0.898, 0.749, 0.663>]
      [1.00 color rgbf<1.000, 1.000, 1.000, 0.996>]
    }
    scale <5.0, 5.0, 5.0>
  } 
  finish{phong 1 ambient .3 diffuse .7}
}

#declare T_Cat_Skin2 = texture{pigment{rgb <1,.9,.8>}finish{phong .5 ambient .2 diffuse .7}}

#include "kitten.inc"       
object {Wiskers pigment{rgb<2,2,2>} finish{phong 1 ambient .2 diffuse .7}}
object {Kitten
	texture{
		onion
		texture_map {
			[0.0 T_Cat_Skin2]
			[0.05 T_Cat_Skin2]
			[0.075 T_Cat_Skin scale .04]
			[1.0 T_Cat_Skin scale .04]
		}  
		scale <1.3,.7,1.3>
		translate <0.1184,0.2811,0.2639>
	}
}     

// cats eyes
#declare Cscale =   0.02075;
#include "eyes.inc"
object {Cats_Eye scale Cscale translate<0.07588006,0.35041793,0.24625795>}
object {Cats_Eye scale Cscale rotate <0,25,0> translate<0.12720801,0.34742644,0.22116939>}

#declare Fur_Debug = off;
#declare Mcolour = 1;     
#declare Min_Length = 0.003;
#declare B_Pigment = <1.5,1.5,1.5>;
#declare F_Ballistic = finish{phong 1}
#declare Ballistic_Rand = 13;
#declare B_Rand = seed(Ballistic_Rand);

#declare Strand_Length = 0.015;
#declare Strand_Radius = 0.0005;
#declare Strand_Density = 150;		// final density = 150
#declare Strand_Jitter = 0.3;
#declare Length_Plus = 0.75;
#declare Normal_Direction = 1;  

#declare Strand_Type = 0;		// 0 = cone, 1 = triangle

#include "ballistic3.inc"
#include "fur1.inc" 

#declare Mcolour = 1;
#declare Strand_Length = 0.03;
#declare Strand_Radius = 0.0005;
#declare Strand_Density = 100;
#declare Strand_Jitter = 0.75;
#declare Length_Plus = 1.0;
#declare Normal_Direction = -1;  

#declare Ballistic_Rand = 13;
#declare B_Rand = seed(Ballistic_Rand);

#include "fear1.inc"  

#declare Normal_Direction = 1;
#declare Mcolour = 1;

#include "fear2.inc"

#end
