// Persistence of Vision Ray Tracer Scene Description File
// Vers: 3.1
// Desc: IRTC First Encounter
// Date: 12/30/98
// Auth: Bob Franke                      

#version 3.1;
//#declare TestMode = 1;                                                      

#include "colors.inc"
#include "textures.inc"  
#include "golds.inc"  
#include "metals.inc"  
                   
#declare UseAsIncludeFile = 1;  

#include "earthbot.inc"        
#include "alienBot.inc"
#undef UseAsIncludeFile  

global_settings{
  assumed_gamma 3.0 
}
          
// ----------------------------------------

camera{
  location  <10/12, 4.5, -12.0>
  direction 1.5*z
  right     4/3*x
  look_at   <10/12,1.75,  6.0>  
}

#declare xClouds = 
texture{
  pigment {
    bozo
    turbulence .45
    color_map { 
        [0.0, 0.1 color rgbf <0.8, 0.8, 0.8, 0.0>
                  color rgbf <0.8, 0.8, 0.8, 0.0>]                     
        [0.1, 0.5 color rgbf <0.8, 0.8, 0.8, 0.0>
                  color rgbf <1.0, 1.0, 1.0, 1.0>]                   
        [0.5, 1.0 color rgbf <1.0, 1.0, 1.0, 1.0>          
                  color rgbf <1.0, 1.0, 1.0, 1.0>]    
    } 
  } 
  finish {ambient 1  diffuse 0}  
}  
  
  
sky_sphere{                             
    pigment{color rgb <0.2, 0.2, 0.8>*.85}
}

// add some clouds inside the sky_sphere and
// in front of the ringed planet
sphere{<10/12, 4.5, -12.0>, 45000          
  texture{xClouds scale <.6,.3,.3>*20000 rotate<0,8,0>}
  hollow  
  no_shadow
} 
       
light_source{
  <-10000, 40000, -60000>*100
  color White*1.1 
  area_light <10000*50, 0, 0>, <0, 0, 10000*50>, 5,5
  adaptive 1
  jitter                              
}  

light_source{
  <10000, 40000, 60000>/100 
  color White*0.1  // light's color
  shadowless
} 


#declare moonTexture = 
texture{
  pigment{
    bozo
    turbulence 0.6  omega 0.8  lambda 3.0
    color_map{
      [0.00 color rgb<0.65, 0.45, 0.45>*1.1]
      [1.00 color rgb<1.000, 1.000, 1.000>]
    }
  }
  normal{
    bumps 1.0
    turbulence 0.6  octaves 5  omega 0.65  lambda 3.0
    scale <0.75, 0.75, 1.0>
  }
  finish {
    ambient 0.3 
    diffuse .6
    specular 0.2
  }
}

#declare rockTexture = 
texture{
  pigment{
    bozo
    turbulence 0.6  omega 0.8  lambda 3.0
    color_map{
      [0.00 color rgb<0.8, 0.5, 0.5>*.75]
      [1.00 color rgb<1.000, 1.000, 1.000>*.5]
    }
  }
  normal{
    bumps 1.0
    turbulence 0.6  octaves 5  omega 0.65  lambda 3.0
    scale <0.75, 0.75, 1.0>
  }
  finish {
    ambient 0.15
    specular 0.2
  }
}


#macro rock(xx,yy,zz,theSeed,xscale,test)    
// creates a rock by putting together 
// a bunch of random spheres and boxes

  #declare R1 = seed(theSeed);
  #declare R2 = seed(theSeed+2365);
  #declare R3 = seed(theSeed+1475);    
  union{
    #declare xcount = 0;
    #declare xmax = rand(R1)*100;
    #while (xcount < xmax) 
      #declare sRadius = rand(R1)*.5;   
      sphere{<0,0,0>, sRadius 

        #declare PlusMinus = rand(R1);
        #if (PlusMinus <= .5)
          #declare PlusMinus = -1;
        #else  
          #declare PlusMinus = 1;
        #end  
        translate<rand(R1)*PlusMinus*.85*.5,0,0> 
            
        #declare PlusMinus = rand(R1);
        #if (PlusMinus <= .5)
          #declare PlusMinus = -1;
        #else  
          #declare PlusMinus = 1;
        #end  
        translate<0,rand(R1)*PlusMinus*.85*.5,0>
            
        #declare PlusMinus = rand(R1);
        #if (PlusMinus <= .5)
          #declare PlusMinus = -1;
        #else  
          #declare PlusMinus = 1;
        #end  
        translate<0,0,rand(R1)*PlusMinus*.85*.5>
      }  
      #declare xcount = xcount + 1;
    #end


    #declare xcount = 0;
    #declare xmax = rand(R1)*100;
    #while (xcount < xmax) 
      #declare sRadius = rand(R1)*.5;   
   
      box{<sRadius,sRadius,sRadius>,<-sRadius,-sRadius,-sRadius>
        rotate<rand(R1)*360,rand(R1)*360,rand(R1)*360>     
        #declare PlusMinus = rand(R1);
        #if (PlusMinus <= .5)
          #declare PlusMinus = -1;
        #else  
          #declare PlusMinus = 1;
        #end  
        translate<rand(R1)*PlusMinus*.85*.5,0,0> 
            
        #declare PlusMinus = rand(R1);
        #if (PlusMinus <= .5)
          #declare PlusMinus = -1;
        #else  
          #declare PlusMinus = 1;
        #end  
        translate<0,rand(R1)*PlusMinus*.85*.5,0>
            
        #declare PlusMinus = rand(R1);
        #if (PlusMinus <= .5)
          #declare PlusMinus = -1;
        #else  
          #declare PlusMinus = 1;
        #end  
        translate<0,0,rand(R1)*PlusMinus*.85*.5>
      }  
      #declare xcount = xcount + 1;
    #end

    translate<xx,yy,zz>
    #if (test = true)
      pigment{Red}
    #else  
      texture{rockTexture}    
    #end  
      
    normal{
      bump_map {
         gif "c:\pov-ra~1\include\plasma3.gif"
         bump_size 12
//         interpolate 2
      }
      scale 2  
      translate <-1, -1, 0>
    }    
    scale xscale            
    translate<xx,yy,zz>
  }
#end //#macro rock 


#declare treadHole=
 box{<-4.5,.5,-.2>/12, <2.5,-.8,.2>/12
   pigment{color rgbf <1,1,1,1> }
 }

#declare treadHoleFill=
box{<-4.5,.375,-.2>/12, <2.5,-.375,.2>/12  
  texture{
    pigment {color rgb <.65, .5, .5> }
    finish {
      crand 0.1
      ambient 0.5
      diffuse 0.5
    } 
  }      
} 

#declare planet=
union{
  #declare RingColor =
  texture{
    pigment{
      bozo
      turbulence 0.2
      color_map{   
        [0.00 color rgbf<1,1,1,.6>]
        [0.6 color rgbf<1,1,1,.6>]
        [1.0 color rgbf<1,1,1,.6>]       
      }
    }   
    normal{
      waves 1.0
      turbulence 0.4  octaves 5  omega 0.7  lambda 1.0
      frequency 10
      scale <4.0, 4.0, 7.0>
    }
    scale .005
  }

// add the rings
  disc{<0,0,0>,<0,1,0>, 70,68 texture{RingColor}}
  disc{<0,0,0>,<0,1,0>, 67,60 texture{RingColor}}
  disc{<0,0,0>,<0,1,0>, 77,71 texture{RingColor}}
  disc{<0,0,0>,<0,1,0>, 98,81 texture{RingColor}}

// create the planet
  sphere { <0,0,0>  50
    texture{
      pigment{
        bozo
        turbulence 0.4  
        color_map{
          [0.00 color rgbf<1,1,1,.6>] 
          [0.6 color rgbf<1,1,1,.6>]
          [1.0 color rgbf<1,1,1,.6>]  
        }
      }  
      normal{
        waves 1.0
        turbulence 0.4  octaves 5  omega 0.7  lambda 1.0
        frequency 10
        scale <4.0, 4.0, 7.0>
      }   
    scale<30,10,10>
    }
  }
}

//*******<<< assemble the scene >>>*********************

object{earthBot scale 1.2 rotate<0,0,-3.5> rotate<0,30,0> translate<-1.5,-.765,4>}  
object{ TheAlienBot scale 1.25 translate<4,1,2>}
object{planet scale 110 rotate<-5,0,0> rotate<0,0,-55> translate<-150,-20,1000>*50}


#ifndef (TestMode) // add a very toxic ground fog
  fog{color rgbft <.9, 0.502,.1,0, 0*.85>
      fog_type 2
      fog_alt 4.5
      fog_offset 0
      distance 55
      turbulence .8
      omega 0.40
      lambda 1.25
      octaves 10
  } 
#end  

//===================<<< start adding the rocks >>>===============
#ifndef (TestMode)
  object{rock(1,-.75,5,20,1,false) }
  object{rock(2.5,-.5,5,25,1,false) scale<2,1,1>}
  object{rock(-3,-.75,5.625,25,1,false) scale<2,1,1>*.5}  

  object{rock(3,-1.5,1.5,19,.45,false) }    
  object{rock(1,-1.0,5,15,.5,false) scale<2,1,1>}

  object{rock(8,.15,15,29,.5,false) }
  object{rock(9,.15,13,35,.5,false) }
  object{rock(8.5,.25,11,33,.5,false) }
  object{rock(6,.25,11,33,.5,false) }
  object{rock(7,0,9.5,50,.5,false) }

  object{rock(3,.15,15,129,.5,false) }
  object{rock(4,.15,13,135,.5,false) }
  object{rock(2.5,25,11,133,.5,false) }
  object{rock(0,.25,11,133,.5,false) }
  object{rock(1,0,9.5,150,.5,false) }
  object{rock(1.75,-.25,8.5,145,.5,false) scale<2,1,1>}

  object{rock(-2,.10,15,111,.5,false) }  
  object{rock(-1,.15,13,12,.5,false) }    
  object{rock(-3.5,.5,11,100,.5,false) }  
  object{rock(-5,.875,11,200,.5,false) }
  object{rock(-4,.875,9.5,225,.5,false) }

  object{rock(-2,-.05,10,100,.5,false) } 
  object{rock(-0.5,-.2,8,1111,.5,false) scale<2,1,1>} 
  object{rock(-3.5,0,6,70,.5,false) }   
  object{rock(-5,0,6,60,.5,false) }

  object{rock(-4,.6,8.5,125,.5,false) }
  object{rock(-2.25,.1,8,75,.5,false) }  
  object{rock(-5.5,1.25,9,99,.5,false) }
  object{rock(-6,.85,8,101,.5,false) }
  object{rock(-5,.6,7,59,.5,false) }
#end
//===================<<< end adding the rocks >>>===============


//========<<< start adding height fields & wheel tread holes >>>===== 
difference{
  object{
    union{ 
      height_field {     // middle ground hils
        tga "first.tga"
        smooth
        texture { moonTexture rotate<0,-90,0> scale .5  
          normal{
            bumps 40
            turbulence 0.6  octaves 5  omega 0.65  lambda 3.0
          scale <1,.5,1>
          }                                             
          finish {crand 0.16}
        }  
        translate <-.5, -.5, -.5>
        rotate<0,180,0>
      }  

      height_field {    // foreground flat area with cracks
        tga "first.tga"
        smooth
        texture { moonTexture rotate<0,-90,0> scale <3,1,1>} 
        texture{
          pigment {
            crackle
            colour_map {
              [0.02 colour rgbt<0, 0, 0, 0> ]
              [0.02 colour rgbt<1, 1, 1, 0> ]
              [0.10 colour rgbt<1, 1, 1, 0.7> ]
              [1.00 colour rgbt<.7,.7,.7,0.7> ]
            }        
            scale 0.01
          }           
          normal {
            bumps -0.5
            scale <0.000001,0.00001,0.0000001>
          }
        }
        translate <-.5, -.49, -.5>
        rotate<0,180,0> 
        clipped_by{plane{y,-.25 }}
        clipped_by{plane{z,.20}}
      }  
     
      height_field {
        tga "first2.tga"  // background hils
        texture { moonTexture rotate<0,-90,0> scale .5} 
        translate <-.5, -.5, -.5>
        scale <1.6,2.5,1> 
        translate <0,-.6,1.6>
      }      
      scale <17, 1.6, 17>*4   
      translate<0,1,25>
    }// union  
  }// object

  #declare yRot = -55;  //=========<<< start cutting holes for wheel treads >>>==========
  #while (yRot > -60)
    object{treadHole 
      translate<11.5,0,0> rotate<0,yRot,0> 
      translate<-7,-2.00,-7.3>
    }  
    #declare yRot = yRot - .32;
  #end  
  
  #declare yRot = yRot + .32;
  #while (yRot > -62.5)
    object{treadHole 
      translate<11.5,0,0> rotate<0,yRot,0> 
      translate<-7,-1.98,-7.3>
    }  
    #declare yRot = yRot - .32;
  #end 

  #declare yRot = yRot + .32;
  #while (yRot > -65)
    object{treadHole 
      translate<11.5,0,0> rotate<0,yRot,0> 
      translate<-7,-1.94,-7.3>
    }  
    #declare yRot = yRot - .32;
  #end 

  #declare yRot = yRot + .32; 
  #while (yRot > -67.5)
    object{treadHole 
      translate<11.5,0,0> rotate<0,yRot,0> 
      translate<-7,-1.90,-7.3>
    }  
    #declare yRot = yRot - .32;
  #end  

  #declare yRot = yRot + .32; 
  #while (yRot > -70)
    object{treadHole 
      translate<11.5,0,0> rotate<0,yRot,0> 
      translate<-7,-1.87,-7.3>
    }  
    #declare yRot = yRot - .32;
  #end  

  #declare yRot = yRot + .32;
  #while (yRot > -73)
    object{treadHole 
      translate<11.5,0,0> rotate<0,yRot,0> 
      translate<-7,-1.75,-7.3>
    }  
    #declare yRot = yRot - .32;
  #end 

  #declare yRot = yRot + .32;
  #while (yRot > -74)
    object{treadHole 
      translate<11.5,0,0> rotate<0,yRot,0> 
      translate<-7,-1.70,-7.3>
    }  
    #declare yRot = yRot - .32;
  #end 

  #declare yRot = yRot + .32; 
  #while (yRot > -76)
    object{treadHole 
      rotate<0,0,3>
      translate<11.5,0,0> rotate<0,yRot,0> 
      translate<-7,-1.68,-7.3>
    }  
    #declare yRot = yRot - .32;
  #end  

  #while (yRot > -79)
    object{treadHole 
      rotate<0,0,5>
      translate<11.5,0,0> rotate<0,yRot,0> 
      translate<-7,-1.60,-7.3>
    }  
    #declare yRot = yRot - .32;
  #end  
    
  #declare yRot = yRot + .32;
  #while (yRot > -82)
    object{treadHole 
      rotate<0,0,9>
      translate<11.5,0,0> rotate<0,yRot,0> 
      translate<-7,-1.55,-7.3>
    }  
    #declare yRot = yRot - .32;
  #end  

  #declare yRot = yRot + .32;
  #while (yRot > -83.5)
    object{treadHole 
      rotate<0,0,10.5>
      translate<11.5,0,0> rotate<0,yRot,0> 
      translate<-7,-1.47,-7.3>
    }  
    #declare yRot = yRot - .32;
  #end  

  #declare yRot = yRot + .32;
  #while (yRot > -85)
    object{treadHole 
      rotate<0,0,10>
      translate<11.5,0,0> rotate<0,yRot,0> 
      translate<-7,-1.44,-7.3>
    }  
    #declare yRot = yRot - .32;
  #end

  #declare yRot = yRot + .32;
  #while (yRot > -87.5)
    object{treadHole 
      rotate<0,0,10>
      translate<11.5,0,0> rotate<0,yRot,0> 
      translate<-7,-1.4,-7.3>
    }  
    #declare yRot = yRot - .32;
  #end  

  #declare yRot = yRot + .32;
  #while (yRot > -90)
    object{treadHole 
      rotate<0,0,10>
      translate<11.5,0,0> rotate<0,yRot,0> 
      translate<-7,-1.35,-7.3>
    }  
    #declare yRot = yRot - .32;
  #end

  #declare yRot = -72.5;
  #while (yRot > -75)
    object{treadHole 
      rotate<0,0,0>
      translate<13.08,0,0> rotate<0,yRot,0> 
      translate<-7,-1.55,-7.3>
    }  
    #declare yRot = yRot - .32;
  #end  

  #declare yRot = yRot + .32;
  #while (yRot > -76.5)
    object{treadHole 
      rotate<0,0,10>    
      translate<13.08,0,0> rotate<0,yRot,0> 
      translate<-7,-1.49,-7.3>
    }  
    #declare yRot = yRot - .32;
  #end 

  #declare yRot = yRot + .32;
  #while (yRot > -77.5)
    object{treadHole 
      rotate<0,0,10>    
      translate<13.08,0,0> rotate<0,yRot,0> 
      translate<-7,-1.43,-7.3>
    }  
    #declare yRot = yRot - .32;
  #end 

  #declare yRot = yRot + .32;
  #while (yRot > -78.5)
    object{treadHole 
      rotate<0,0,10>    
      translate<13.08,0,0> rotate<0,yRot,0> 
      translate<-7,-1.36,-7.3>
    }  
    #declare yRot = yRot - .32;
  #end 

  #declare yRot = yRot + .32;
  #while (yRot > -80)
    object{treadHole 
      rotate<0,0,10>    
      translate<13.08,0,0> rotate<0,yRot,0> 
      translate<-7,-1.29,-7.3>
    }  
    #declare yRot = yRot - .32;
  #end 

  #declare yRot = yRot + .32;
  #while (yRot > -82.5)
    object{treadHole 
      rotate<0,0,10>    
      translate<13.08,0,0> rotate<0,yRot,0> 
      translate<-7,-1.2,-7.3>
    }  
    #declare yRot = yRot - .32;
  #end   //=========<<< end cutting holes for wheel treads >>>===============
}// end of difference


//===========<<< start filling in the previous wheel tread holes >>>===============    
object{
  union{
  #declare yRot = -55;
  #while (yRot > -60)
    object{treadHoleFill 
      translate<11.5,0,0> rotate<0,yRot,0> 
      translate<-7,-2.00,-7.3>
    }  
    #declare yRot = yRot - .32;
  #end  

  #declare yRot = yRot + .32;
  #while (yRot > -62.5)
    object{treadHoleFill 
      translate<11.5,0,0> rotate<0,yRot,0> 
      translate<-7,-1.98,-7.3>
    }  
    #declare yRot = yRot - .32;
  #end 

  #declare yRot = yRot + .32;
  #while (yRot > -65)
    object{treadHoleFill 
      translate<11.5,0,0> rotate<0,yRot,0> 
      translate<-7,-1.94,-7.3>
    }  
    #declare yRot = yRot - .32;
  #end 

  #declare yRot = yRot + .32; 
  #while (yRot > -67.5)
    object{treadHoleFill 
      translate<11.5,0,0> rotate<0,yRot,0> 
      translate<-7,-1.90,-7.3>
    }  
    #declare yRot = yRot - .32;
  #end  

  #declare yRot = yRot + .32; 
  #while (yRot > -70)
    object{treadHoleFill 
      translate<11.5,0,0> rotate<0,yRot,0> 
      translate<-7,-1.87,-7.3>
    }  
    #declare yRot = yRot - .32;
  #end  

  #declare yRot = yRot + .32;
  #while (yRot > -73)
    object{treadHoleFill 
      translate<11.5,0,0> rotate<0,yRot,0> 
      translate<-7,-1.75-.0501,-7.3>
    }  
    #declare yRot = yRot - .32;
  #end 

  #declare yRot = yRot + .32;
  #while (yRot > -74)
    object{treadHoleFill 
      translate<11.5,0,0> rotate<0,yRot,0> 
      translate<-7,-1.70-.0501,-7.3>
    }  
    #declare yRot = yRot - .32;
  #end 

  #declare yRot = yRot + .32; 
  #while (yRot > -76)
    object{treadHoleFill 
      rotate<0,0,3>
      translate<11.5,0,0> rotate<0,yRot,0> 
      translate<-7,-1.68-.0501,-7.3>
    }  
    #declare yRot = yRot - .32;
  #end  

  #while (yRot > -79)
    object{treadHoleFill 
      rotate<0,0,5>
      translate<11.5,0,0> rotate<0,yRot,0> 
      translate<-7,-1.60-.0501,-7.3>
    }  
    #declare yRot = yRot - .32;
  #end  

  #declare yRot = yRot + .32;
  #while (yRot > -82)
    object{treadHoleFill 
      rotate<0,0,9>
      translate<11.5,0,0> rotate<0,yRot,0> 
      translate<-7,-1.55-.0501,-7.3>
    }  
    #declare yRot = yRot - .32;
  #end  

  #declare yRot = yRot + .32;
  #while (yRot > -83.5)
    object{treadHoleFill 
      rotate<0,0,10.5>
      translate<11.5,0,0> rotate<0,yRot,0> 
      translate<-7,-1.47-.0501,-7.3>
    }  
    #declare yRot = yRot - .32;
  #end  

  #declare yRot = yRot + .32;
  #while (yRot > -85)
    object{treadHoleFill 
      rotate<0,0,10>
      translate<11.5,0,0> rotate<0,yRot,0> 
      translate<-7,-1.44,-7.3>
    }  
    #declare yRot = yRot - .32;
  #end

  #declare yRot = yRot + .32;
  #while (yRot > -87.5)
    object{treadHoleFill 
      rotate<0,0,10>
      translate<11.5,0,0> rotate<0,yRot,0> 
      translate<-7,-1.4,-7.3>
    }  
    #declare yRot = yRot - .32;
  #end  

  #declare yRot = yRot + .32;
  #while (yRot > -90)
    object{treadHoleFill 
      rotate<0,0,10>
      translate<11.5,0,0> rotate<0,yRot,0> 
      translate<-7,-1.35,-7.3>
    }  
    #declare yRot = yRot - .32;
  #end

  #declare yRot = -72.5;
  #while (yRot > -75)
    object{treadHoleFill 
      translate<13.08,0,0> rotate<0,yRot,0> 
      translate<-7,-1.55,-7.3>
    }  
    #declare yRot = yRot - .32;
  #end  

  #declare yRot = yRot + .32;
  #while (yRot > -76.5)
    object{treadHoleFill 
      rotate<0,0,5>    
      translate<13.08,0,0> rotate<0,yRot,0> 
      translate<-7,-1.49,-7.3>
    }  
    #declare yRot = yRot - .32;
  #end 

  #declare yRot = yRot + .32;
  #while (yRot > -77.5)
    object{treadHoleFill 
      rotate<0,0,10>    
      translate<13.08,0,0> rotate<0,yRot,0> 
      translate<-7,-1.43,-7.3>
    }  
    #declare yRot = yRot - .32;
  #end 

  #declare yRot = yRot + .32;
  #while (yRot > -78.5)
    object{treadHoleFill 
      rotate<0,0,10>    
      translate<13.08,0,0> rotate<0,yRot,0> 
      translate<-7,-1.36,-7.3>
    }  
    #declare yRot = yRot - .32;
  #end 
  #declare yRot = yRot + .32;
  #while (yRot > -80)
    object{treadHoleFill 
      rotate<0,0,10>    
      translate<13.08,0,0> rotate<0,yRot,0> 
      translate<-7,-1.29,-7.3>
    }  
    #declare yRot = yRot - .32;
#end 

  #declare yRot = yRot + .32;
  #while (yRot > -82.5)
    object{treadHoleFill 
      rotate<0,0,10>    
      translate<13.08,0,0> rotate<0,yRot,0> 
      translate<-7,-1.2,-7.3>
    }  
    #declare yRot = yRot - .32;
  #end
  } 
      
  clipped_by{          // use the height field to clip
     height_field {    // off the tops of the wheel treads
      tga "first.tga"
      smooth
      translate <-.5, -.47, -.5>
      rotate<0,180,0> 
      scale <17, 1.6, 17>*4   
      translate<0,1.00,25>
     }
  }    
  rotate<0,0,-0.4>
  translate<0,-.079,0>   
}  
//===========<<< end filling in the previous wheel tread holes >>>===============    

