// Persistence of Vision Ray Tracer Scene Description File
// Desc: IRTC First Encounter
// Date: 12/30/98
// Auth: Bob Franke                      

#version 3.1;

#include "colors.inc"
#include "glass.inc"
  
  
#ifndef (UseAsIncludeFile)   
global_settings
{
  assumed_gamma 2.2
}

// ----------------------------------------
camera{
  location  <0.0, 1.5, -6.0>
  direction 1.5*z
  right     4/3*x
  look_at   <0.0, 0.0,  0.0>
}

sky_sphere{
  pigment{
    gradient y
    color_map { [0.0 color blue 0.03] [1.0 color rgb.04] }
  }
}

light_source{
  0*x 
  color red 1.0  green 1.0  blue 1.0  
  translate <-30, 30, -30>
}



// ----------------------------------------
plane { y, -1 pigment {color rgb <0.7,0.5,0.3>}}

#end

#declare  F_MetalA =
finish {
    ambient 0.35
    brilliance 2
    diffuse 0.3
    metallic
    specular 0.80
    roughness 1/500
    reflection 0.1
}

#declare F_MetalC  =
finish {
    ambient 0.25
    brilliance 4
    diffuse 0.5
    metallic
    specular 0.80
    roughness 1/80
    reflection 0.5
}
      
#declare cutout1=
superellipsoid{ <0.2,  0.2> scale<.1,.125,1>  translate <0,0,-1> 
    rotate<30,0,0>  
} 
        
        
#declare panel1 = 
union{ 
  difference{
    intersection{
      superellipsoid{ <0.2,  0.2> scale<.1,.125,1.25>  translate<0,0,-1>}
      sphere{<0,0,0>,0.995 }
    }  
    sphere{<0,0,0>,0.985 }  
    texture {
      finish { F_Glass4 }
      pigment { color rgbf <0.8, 0, 0, 0.5> }
    }
    interior{I_Glass}
  } 

  intersection{
    difference{
      box{<-.095,-.12,-1.5>,<.095,.12,-.75>  }
      box{<-.09,-.115,-1.75>,<.09,.115,-.76> }  
    }   
    sphere{<0,0,0>,0.985 }
    pigment{White}
  }  

  light_source{ <0,0,-.875>  
    color White*4
    fade_distance .5
    fade_power(2)   
  }
  rotate<30,0,0>
}


#declare panel2 =     
difference{
  superellipsoid{ <0.2,  0.2> scale<.1,.125,1.005>} 
  box{<-.25,-.25,0>,<.25,.25,2>}
  texture{
    pigment{color rgb <1.000, 0.706, 0.882>}
    finish{F_MetalC}
  }
  rotate<-30,0,0> 
}

#declare Density=
  density {
    spherical
    ramp_wave
    color_map {
      [0.0 color rgb <0.0, 0.0, .1>*40]
      [0.5 color rgb <0.1, 0.1, .3>*60]
      [1.0 color rgb <0.8, 0.8, 1>*80]
    }
  }

#declare blueGlow= 
merge{
  torus{1.25,.05}
  torus{1.25,.05 rotate<-10,0,45>}
  torus{1.25,.05 rotate<10,0,-45>}
  pigment { color rgbf<1, 1, 1, 1> }
  finish { ambient 0 diffuse 0 }
  interior {
    media {
      emission .75
      intervals 5
      samples 1, 5
      confidence 0.9999
      variance 1/1000
      density {Density}
    }
  }
  hollow
}


#declare TheAlienBot =
union{ 
  difference{
    sphere { 0.0, 1} 
    sphere { 0.0, .99}   
    superellipsoid{ <0.2,  0.2> scale<.1,.125,1>  translate <0,0,-1> 
      rotate<30,0,0> 
    }           
    #declare yrot = -100;    
    #while (yrot < 100) 
      object{cutout1 rotate<0,yrot,0>}
      #declare yrot = yrot + 20;
    #end

    texture{
      pigment{color rgb <0.506, 0.627, 0.420>*1.25}   
      finish {F_MetalA }
    }   
      
    texture{
      pigment{image_map{
               gif "a-plaque.gif" // the file to read (iff/gif/tga/png/sys)
               map_type 0         // 0=planar, 1=spherical, 2=cylindrical, 5=torus
               interpolate 2      // 0=none, 1=linear, 2=bilinear, 4=normalized distance 
               once  
               filter 4, 1.0
             }
      }       
      translate<-.5,0,0>
      scale<2,.2,1>
    } 
  }  
  object{blueGlow no_shadow}
  
  #declare yrot = -80;    
    #while (yrot < 80) 
      object{panel2 rotate<0,yrot,0>}
      #declare yrot = yrot + 20;
  #end


  #declare yrot = -100;    
    #while (yrot < 100) 
      object{panel1 rotate<0,yrot,0>}
      #declare yrot = yrot + 20;
  #end
} 


#ifndef (UseAsIncludeFile)    
  TheAlienBot 
#end           

