// Persistence of Vision Ray Tracer Scene Description File
// File: ?.pov
// Vers: 3
// Desc: Basic Scene Example
// Date: mm/dd/yy
// Auth: ?
//

#version 3.1;

#include "colors.inc"
#include "textures.inc"

#ifndef (UseAsIncludeFile)
global_settings
{
  assumed_gamma 2.2
}

// ----------------------------------------
camera
{
  location  <0.0, 0.5, -4.0>
  direction 1.5*z
  right     4/3*x
  look_at   <0.0, 0.0,  0.0>
}

sky_sphere{
  pigment{
    gradient y
    color_map { [0.0 color blue 0.6] [1.0 color rgb 1] }
  }
}
            
            
light_source{
  0*x // light's position (translated below)
  color red 1.0  green 1.0  blue 1.0  // light's color
  translate <-30, 30, -30>
}
 
// ----------------------------------------
plane { y, -1 pigment {color rgb <0.7,0.5,0.3>}}

#end

#declare boltHead=
union{
  intersection{
    prism {
      linear_sweep
      linear_spline
      0, 5.3,
      7,
      <3.55,6.15>,<7.1,0>,<3.55,-6.15>,<-3.55,-6.15>,
      <-7.01,0>,<-3.55,6.15>,<3.55,6.15>
    }
    cone { <0,4.61+4.0,0>, 0.0001, <0,0+4.0,0>, 8.0}
  }

  prism {
    linear_sweep
    linear_spline
    0, 4.35,
    7,
    <3.55,6.15>,<7.1,0>,<3.55,-6.15>,<-3.55,-6.15>,
    <-7.01,0>,<-3.55,6.15>,<3.55,6.15>
  }

  #ifndef (TestMode)
    texture{Soft_Silver}
  #else
    pigment{Green}
  #end
}

#declare blackBoltHead=
union{
  intersection{
    prism {
      linear_sweep
      linear_spline
      0, 5.3,
      7,
      <3.55,6.15>,<7.1,0>,<3.55,-6.15>,<-3.55,-6.15>,
      <-7.01,0>,<-3.55,6.15>,<3.55,6.15>
    }
    cone { <0,4.61+4.0,0>, 0.0001, <0,0+4.0,0>, 8.0}
  }

  prism {
    linear_sweep
    linear_spline
    0, 4.35,
    7,
    <3.55,6.15>,<7.1,0>,<3.55,-6.15>,<-3.55,-6.15>,
    <-7.01,0>,<-3.55,6.15>,<3.55,6.15>
  }
  #ifndef (TestMode)
    texture{
      pigment{White*.25}
      finish {
        ambient 0.35
        brilliance 2
        diffuse 0.3
        metallic
        specular 0.80
        roughness 1/10
        reflection 0.17
        crand 0.05
      }
    }
  #else
    pigment{Green}
  #end
}

#declare bolt=
union{
  object{boltHead}
  cylinder { <0,0,0>, <0,-35,0>, 3.85
    #ifndef (TestMode)
      texture{Soft_Silver}
    #else
      pigment{Green}
    #end
  }
}

  
#declare flatNut =
prism {
  linear_sweep
  linear_spline
  0, 4.35,
  7,
  <3.55,6.15>,<7.1,0>,<3.55,-6.15>,<-3.55,-6.15>,
    <-7.01,0>,<-3.55,6.15>,<3.55,6.15>
   
  #ifndef (TestMode)
    texture{Soft_Silver}
  #else
    pigment{Green}
  #end
}


  
  
  
#declare blackScrew =
difference{                 
  object{                 
    sphere{<0,-.09,0> .1875}
    clipped_by{plane{y,0 inverse}} 
  }
  box{<-.03,.03,-1>,<.03,1,1>}  
  #ifndef (TestMode)
    texture{
      pigment{White*.2}
      finish {
        ambient 0.35
        brilliance 2
        diffuse 0.3
        metallic
        specular 0.80
        roughness 1/10
        reflection 0.17
        crand 0.05
      }
    }
  #else
    pigment{Green}
  #end
}  


#declare silverScrew =
difference{                 
  object{                 
    sphere{<0,-.09,0> .1875}
    clipped_by{plane{y,0 inverse}} 
  }
  box{<-.03,.03,-1>,<.03,1,1>}  
  #ifndef (TestMode)
    texture{Soft_Silver}
  #else
    pigment{Green}
  #end
}  
