// Persistence of Vision Ray Tracer Scene Description File
// Vers: 3.1
// Desc: IRTC First Encounter
// Date: 12/30/98
// Auth: Bob Franke                      

#version 3.1;
//#declare TestMode = 1;                                                      

#include "colors.inc"
#include "textures.inc"  
#include "golds.inc"  
#include "metals.inc"  
                   
//#declare UseAsIncludeFile = 1;  //
#include "bolts.inc"         
#include "arm.inc"  
#include "ccdcam.inc"
#include "inputtwr.inc"
#include "panel.inc"

//#ifdef UseAsIncludeFile 
// #undef UseAsIncludeFile   
//#end  

#ifndef (UseAsIncludeFile) 

global_settings
{
  assumed_gamma 2.2
}
          
// ----------------------------------------
camera{
  location  <10/12, 4.5, -12.0>
  direction 1.5*z
  right     4/3*x
  look_at   <10/12,1.75,  6.0>
}

#declare Clouds = 
pigment {
    bozo
    turbulence .45
    color_map {
        [0.0, 0.1 color rgbf <0.8, 0.8, 0.8, 0.0>
                  color rgbf <0.8, 0.8, 0.8, 0.0>]
        [0.1, 0.5 color rgbf <0.8, 0.8, 0.8, 0.0>
                  color rgbf <1.0, 1.0, 1.0, 1.0>]
        [0.5, 1.0 color rgbf <1.0, 1.0, 1.0, 1.0>
                  color rgbf <1.0, 1.0, 1.0, 1.0>]
    }
}
  
  
sky_sphere{ 
  pigment{color rgb <0.392, 0.392, 0.784>}
  pigment{Clouds scale <.4,.3,.3>}
}

      
light_source{
  0*x // light's position (translated below)
  color White*1.5  // light's color
  translate <-10000, 40000, -60000>/100
}

// ----------------------------------------
//plane { y, -1 pigment {color rgb <0.7,0.5,0.3>}}

#end

#ifndef (TestMode)
  #declare strutTexture = Soft_Silver
#else
  #declare strutTexture = texture{pigment{White*.75}}  
#end 

#ifndef (TestMode)
  #declare strutPinTexture = Bright_Bronze
#else  
  #declare strutPinTexture = texture{pigment{Yellow*.65}}
#end

#ifndef (TestMode)
  #declare myGoldTexture = T_Gold_1A  
#else  
  #declare myGoldTexture = texture { pigment { P_Gold4*.5 }}
#end

    
#declare setiPlaque=
box{ <0,0,0>,<1,1,.01>
  pigment{image_map{
            gif "seti.gif" 
            map_type 0 
            interpolate 2  
            once  
            filter 2, 1.0             
         } 
  } 
}
  
#declare plaque=
box{ <0,0,0>,<1,1,.01>
  pigment{ image_map{
             gif "logo2.gif" 
             map_type 0 
             interpolate 2
           } 
         }
}   

#declare colorPlaque=
box{ <0,0,0>,<1,1,.01>
  pigment{ image_map{
             gif "color.gif" 
             map_type 0 
             interpolate 2 
         } 
  }
}   


#declare antenna=
union{  
  cylinder{<0,-4,0>/12,<0,8,0>/12, .4/12  texture{strutTexture} }
  cylinder{<0,8,0>/12,<0,16,0>/12, .3/12  texture{strutTexture} }
  cylinder{<0,16,0>/12,<0,25,0>/12, .2/12 texture{strutTexture} }
  cylinder{<0,22,0>/12,<0,24,0>/12, .4/12 
    texture{
      pigment{color rgb <0.686, 0.588, 1.000>}
      finish{F_MetalC}
    }
  }

  cylinder{<0,25,0>/12,<-3,28,0>/12, .1/12 texture{strutTexture}}
  cylinder{<0,25,0>/12,<-3,28,0>/12, .1/12 rotate<0,120,0> texture{strutTexture}}
  cylinder{<0,25,0>/12,<-3,28,0>/12, .1/12 rotate<0,240,0> texture{strutTexture }}
} 
 
#macro TorusSpline( TorRadius, Points, StartVect )
// promote the start vector to a vector, even if they gave us a scalar (e.g. 0)

#local V=<0,0,0>+StartVect;
#local Numpoints = dimension_size( Points, 1 );
#local Cur = 0;
union {
  #while (Cur < Numpoints-1 )
    #local A=Points[Cur];
    #local B=Points[Cur+1];
    #if (V.x=0&V.y=0&V.z=0)
      #local C=Points[Cur+2];
      #if (vlength(vcross(C-A,B-A))=0)
        #local V=B-A;
        #local Cos=0;
        #local Axis=<0,0,0>;
      #else
        #local Axis=vnormalize(vcross((C-A),(B-A)));
        #local Base1=vnormalize(C-A);
        #local Base2=vnormalize(vcross(Axis,Base1));
        #local VB=<0.5*vlength(C-A),0,0>;
        #local VA=vcross(VB,z);
        #local VD=.5*<vdot(B-A,Base1),vdot(B-A,Base2),0>;
        #local VC=vcross(VD,z);
        #local Beta=((VD-VB).y*VA.x-(VD-VB).x*VA.y)/(VC.x*VA.y-VC.y*VA.x);
        #local Center=A+VD.x*Base1+VD.y*Base2+Beta*(VC.x*Base1+VC.y*Base2);
        #local Radius=vlength(Center-A);
        #local Cos=1;
        #local V=vcross( Axis,Center-A );
      #end
      #local B=C;
      #local Cur=Cur+1;
    #else
      #local Axis=vnormalize(vcross((B-A),V));
      #local Dir=vnormalize(vcross(V, Axis ));
      #local Cos=vdot(vnormalize(B-A), Dir);
      #local Radius=abs(.5*vlength(B-A)/Cos);
      #local Center=A+Radius*Dir;
    #end
    #local V1=V;
    #if ( Cos & (Axis.x!=0|Axis.y!=0|Axis.z!=0))
      #if (Axis.y = 0 & vlength(<Axis.x,0,Axis.z>) = 0)
        #local RZ=0;
      #else
        #local RZ=-degrees(atan2(vlength(<Axis.x,0,Axis.z>), Axis.y));
      #end
      #if (Axis.z = 0 & Axis.x = 0 )
        #local RY=0;
      #else
        #local RY=-degrees(atan2(Axis.z, Axis.x));
      #end
      #local V1=vcross(B-Center, Axis);
      #if ( vdot(vcross(V,A-Center),vcross(V, V1))>0 )
        #local Planes =  union{
          plane{-V, vdot( A-.0001*TorRadius*V, vnormalize(-V) ) }
          plane{V1, vdot( .0001*TorRadius*V1+B, vnormalize(V1))}
        }
      #else
        #local Planes =  intersection {
          plane{-V, vdot( A-.0001*TorRadius*V, vnormalize(-V) ) }
          plane{V1, vdot( .0001*TorRadius*V1+B, vnormalize(V1))}
        }
      #end
      intersection{
        object {Planes}
        torus{ Radius, TorRadius rotate RZ*z rotate RY*y translate Center }
      }
    #else
      cylinder {A-.0001*TorRadius*V, B+.0001*TorRadius*V, TorRadius}
    #end
    #declare Cur=Cur+1;
    #declare V=V1;
  #end
}
#end

#declare armBracket =
union{
  union{
    box{<0,.5/12,-.5/12>,<.03125/12,-1.5/12,.5/12>} 
    box{<0,-1.46875/12,-.5/12>,<1.25/12,-1.5/12,.5/12>} 
    box{<1.21875/12,-1.0/12,-.5/12>,<1.25/12,-1.5/12,.5/12>} 
    texture{T_Silver_3A}
  }  
  object{blackScrew scale 1/10 rotate<0,0,-90> translate<.03125/12,.25/12,0>}
  object{blackScrew scale 1/10 rotate<0,0,-90> translate<.03125/12,-.5/12,0>}
}  


#declare wheel = 
union{ 
  union{
    difference{
      cylinder { <0,3/12,-2/12>, <0,3/12,2/12>, 3/12 }
      cylinder { <0,3/12,-2.5/12>, <0,3/12,2.5/12>, 2.875/12 } 
    }                                                          
    #declare zz = 0;
    #while (zz < 360)  
      box{<-.15,2.875,-2>/12 <0.15,3.25,2>/12 rotate<0,0,zz> translate<0,3/12,0>}    
      #declare zz = zz + 15;
    #end  
    texture{strutTexture}
    texture{
      pigment {
        bozo
        turbulence .45
        color_map { 
            [0.0, 0.5 color rgbf <0.5, 0.4, 0.4, 0.0>*1.05
                      color rgbf <0.5, 0.4, 0.4, 0.0>*1.05]                     
            [0.55, 0.8 color rgbf <0.5, 0.4, 0.4, 0.0>*1.05
                      color rgbf <1.0, 1.0, 1.0, 1.0>]                   
            [0.8, 1.0 color rgbf <1.0, 1.0, 1.0, 1.0>          
                       color rgbf <1.0, 1.0, 1.0, 1.0>]    
        } 
      } 
      finish {
        crand 0.1
        ambient 0.5
        diffuse 0.5
      } 
    scale <.02,.02,.2>
    }  
  }
  cone { <0,3/12,-2/12>, 3/12, <0,3/12,-1/12>, 1.5/12 open  texture{strutTexture}}
  cone { <0,3/12,2/12>, 3/12, <0,3/12,1/12>, 1.5/12 open  texture{strutTexture}}  
  sphere{<0,3/12,0> 2.5/12 scale<1,1,.45>   texture{strutTexture}}
}                        

#declare plasticTie =
union{
  difference{ 
    superellipsoid{ <0.01,  0.75> scale <.30,1.3,.5> /12}
    superellipsoid{ <0.1,  0.75> scale <1.5,1.3,.5> /16}
  }   
  box{<-.25/12,.7/12,-.75/12>,<.25/12,1.25/12,-.25/12>} 
  texture {
    pigment { rgb <1,1,.75> }
    finish {Shiny }
  }  
}  

#declare frontStrut=
union{ 
  difference{
    box{<.25/12,-.75/12,2.25/12>, <-7.8125/12,.75/12,2.75/12>}
    #declare xx = 0.0;
    #while (xx > -8.25)
      cylinder { <xx/12,0,1.25/12>, <xx/12,0,3.5/12>, .5/12 } 
      #declare xx = xx -1.25;
    #end  
    rotate<0,0,40> 
    //translate<4/12,6.25/12,0> 
    texture{strutTexture}  
  }                    

    object{plasticTie translate<-4.5/12,.125/12,2.5/12> rotate<0,0,40>  }

// add powere cable
  #declare Pts=array[6]{ <0,0,2.9/12>,
                         <0,0,1.0/12>,
                         <-2.5/12,-1/12,2/12>,
                         <-4.5/12,-2.6/12,2.5/12>,
                         <-6.5/12,-4.0/12,2.5/12>,
                         <-6.5/12,-6.0/12,2.5/12>
                       }
  object {TorusSpline( .01, Pts, <1,0,.5> )                   
          translate<-.25/12,0,0>
          texture {pigment{Red*1.2}}
         }    

  
  cylinder { <0,0,2.2/12>, <0,0,1.9/12>, 1.25/12 texture{strutPinTexture}}  
  cylinder { <0,0,2.8/12>, <0,0,3.1/12>, 1.25/12 texture{strutPinTexture}}  

  difference{
    box{<-9/12,-4.07/12,2.25/12>, <-5.5/12,-5.57/12,2.75/12>}
    #declare xx = -5.745;
    #while (xx > -9)
      cylinder { <xx/12,-4.821/12,1.25/12>, <xx/12,-4.821/12,3.5/12>, .5/12 } 
      #declare xx = xx -1.25;
    #end  
    texture{strutTexture}
  }

  box{<-7.5/12,-5.25/12,2.25/12>, <-6.5/12,-9.5/12,2.75/12> texture{strutTexture}}
}  

#declare rearStrut =
union{
   difference{
    box{<12.25/12,-4.07/12,2.25/12>, <22/12,-5.57/12,2.75/12>}
    #declare xx = 12.5;
    #while (xx < 22)
      cylinder { <xx/12,-4.821/12,1.25/12>, <xx/12,-4.821/12,3.5/12>, .5/12 } 
      #declare xx = xx + 1.25;
    #end 
    texture{strutTexture}
  }
 
  difference{ 
    box{<5/12,-4.07/12,2.25/12>, <12.75/12,-5.57/12,2.75/12>}
    #declare xx = 12.5;
    #while (xx > 5)
      cylinder { <xx/12,-4.821/12,1.25/12>, <xx/12,-4.821/12,3.5/12>, .5/12 } 
      #declare xx = xx - 1.25;
    #end 
    texture{strutTexture}  
    translate<-12.5/12,4.821/12,0>
    rotate<0,0,41>
    translate<12.5/12,-4.821/12,0>
  } 
  
  box{<19.5/12,-5.25/12,2.25/12>, <20.5/12,-9.5/12,2.75/12> texture{strutTexture}}  
  //cylinder{ <12.5/12,-4.821/12,2.2/12>, <12.5/12,-4.821/12,3.5/12>, .45/12 texture{strutPinTexture}} 
  cylinder{ <12.5/12,-4.821/12,2.2/12>, <12.5/12,-4.821/12,1.9/12>, 1.5/12 texture{strutPinTexture}} 
  cylinder{ <12.5/12,-4.821/12,2.8/12>, <12.5/12,-4.821/12,3.1/12>, 1.5/12 texture{strutPinTexture}} 
}  
//==============================================================
       
#declare rearRocker =
union{   
  difference{
    box{<-.25/12,-.75/12,2.25/12>, <9.125/12,.75/12,2.75/12>}
    #declare xx = 0.0;
    #while (xx < 9.75)
      cylinder { <xx/12,0,1.25/12>, <xx/12,0,3.5/12>, .5/12 } 
      #declare xx = xx + 1.25;
    #end  
    rotate<0,0,-5> 
    //translate<4/12,6.25/12,0> 
    texture{strutTexture}
  }

  difference{
    box{<-.25/12,-.75/12,2.25/12>, <5.75/12,.75/12,2.75/12>}
    #declare xx = 0.0;
    #while (xx < 5.75)
      cylinder { <xx/12,0,1.25/12>, <xx/12,0,3.5/12>, .5/12 } 
      #declare xx = xx + 1.4;
    #end  
    rotate<0,0,-45> 
    translate<8.7167/12,-0.7626/12,0> 
    texture{strutTexture}
  }
  object{rearStrut}
}


#declare leftRearStrutAssy= 
union{      
   union{
    object{rearStrut}
    object{wheel translate<8/12,-12/12,0>}
    object{wheel translate<20/12,-12/12,0>}   
  }        
  object{rearRocker}         
  object{plasticTie translate<16/12,-4.6875/12,2.5/12>}  
  object{plasticTie rotate<0,0,-5> translate<5.5/12,-.375/12,2.4/12>}  
  #declare Pts=array[11]{<0/12,.8/12,2.5/12>, 
                         <1/12,.8/12,2.5/12>, 
                         <4/12,.5/12,2.5/12>, 
                         <7/12,.2/12,2.5/12>, 
                         <9/12,.0/12,2.5/12>, 
                         <11/12,-2/12,2.5/12>, 
                         <12.5/12,-3.5/12,2.5/12>, 
                         <14/12,-4/12,2.25/12>,
                         <18/12,-4/12,2.25/12>,
                         <20/12,-4/12,2.75/12>,
                         <20/12,-7/12,3/12>, 
                        }  
                              
  object{ TorusSpline( .01, Pts, <1,0,-.5> )                                   
          texture {pigment{Red*1.2}}  
          rotate<0,0,1.5>
        }
}


#declare rightRearStrutAssy= 
union{      
   union{
    object{rearStrut}
    object{wheel translate<8/12,-12/12,4.5/12>}
    object{wheel translate<20/12,-12/12,4.5/12>}
  }        
  object{rearRocker}     
}
               
//==================================================================
#declare earthBot =
union{                  
  #debug concat("start parsing earthBot @ ",str(clock,5,3))
  #render "\n"

  superellipsoid{ <0.025,  0.025>  scale<1.5,0.33,0.667> translate<.5,0,0> texture{myGoldTexture}} 
  object{blackScrew rotate<0,0,-90> scale 1/8 translate<2,-3.5/12,-6.75/12>}
  object{blackScrew rotate<0,0,-90> scale 1/8 translate<2,-1.5/12,-6.75/12>}
  object{blackScrew rotate<0,0,-90> scale 1/8 translate<2,-3.5/12,-5.25/12>}
  object{blackScrew rotate<0,0,-90> scale 1/8 translate<2,-1.5/12,-5.25/12>}     
  object{armBracket translate<2,-2/12,1/12>}         
  object{        
    superellipsoid{ <0.025,  0.025>  scale<1.5,0.33,0.667>*1.01 translate<.5,0,0>} 
    clipped_by{plane{y,.25 inverse}}
    texture{myGoldTexture}
  }  
 
  #declare xx = -10;
  #while (xx < 24)  
    object{boltHead scale .004 translate<xx/12,.33,-7.25/12>}
    object{boltHead scale .004 translate<xx/12,.33,7.25/12>}
    #declare xx = xx + 4;
  #end    #declare xx = -10;
  
  #declare zz = -4;
  #while (zz < 8)  
    object{boltHead scale .004 translate<-11/12,.33,zz/12>}
    object{boltHead scale .004 translate<23/12,.33,zz/12>}
    #declare zz = zz + 4;
  #end  

  union{ 
    object{frontStrut }
    object{wheel translate<-7/12,-12/12,4.5/12>}
    rotate<0,0,0> translate<0,0,7/12>  
  }

  union{ 
    object{frontStrut }
    object{wheel translate<-7/12,-12/12,0>}
    rotate<0,0,0> translate<0,0,-12/12>  
  }

  object{setiPlaque scale <.75,.18,1> translate<-.75,.0625,-8.03/12> no_shadow} 
  object{plaque scale <.5,.5,1> translate<1.4,-.25,-8.03/12>} 
  object{colorPlaque rotate<90,0,0> scale <.5,.5,1> translate<1.35,.335,-6/12>} 
     
  object{blackScrew scale 1/10 rotate<-90,0,0> translate<-9,-1,-8.03>/12}
  object{blackScrew scale 1/10 rotate<-90,0,0> translate<-7,-1,-8.03>/12}
  object{blackScrew scale 1/10 rotate<-90,0,0> translate<-9,-2,-8.03>/12}
  object{blackScrew scale 1/10 rotate<-90,0,0> translate<-7,-2,-8.03>/12}

  object{blackScrew scale 1/10 rotate<-90,0,0> translate<15,0,-8.03>/12}
  object{blackScrew scale 1/10 rotate<-90,0,0> translate<15,-2,-8.03>/12}
  object{blackScrew scale 1/10 rotate<-90,0,0> translate<13.5,0,-8.03>/12}
  object{blackScrew scale 1/10 rotate<-90,0,0> translate<13.5,-2,-8.03>/12}
  object{blackScrew scale 1/10 rotate<-90,0,0> translate<12,0,-8.03>/12}
  object{blackScrew scale 1/10 rotate<-90,0,0> translate<12,-2,-8.03>/12}

  object{inputTower(-10,15) rotate<0,-90,0> translate<-10,6,-8>/12}    
  object{antenna translate<-10,6,8>/12}                            

  object{leftRearStrutAssy translate<0,0,-12/12>}   
  object{rightRearStrutAssy translate<0,0,7/12>} 
  
  object{arm scale 1.25  translate<24.5/12,-2/12,-7/12>}  
  object{object{cameraAssy(-15,20) } rotate<0,-90,0>translate<24.25/12,1.25/12,0/12>}  

  object{object{solarPanel(-25,25,0)} }

  #debug concat("end parsing earthBot @ ",str(clock,5,3))
  #render "\n"
}

#ifndef (UseAsIncludeFile)  
  object{earthBot scale 1.2 rotate<0,30,0> translate<-1.5,-.75,4>}  
#end  
  