// Persistence of Vision Ray Tracer Scene Description File
// Vers: 3.1
// Desc: IRTC First Encounter
// Date: 12/30/98
// Auth: Bob Franke                      

#version 3.1;        
//#declare TestMode = 1;

#declare UseAsIncludeFile = 1;
  #include "bolts.inc"                        
  #include "ccdcam.inc"
//#undef UseAsIncludeFile

#ifndef (UseAsIncludeFile)  

#include "colors.inc"
#include "metals.inc"
#include "finish.inc" 
#include "textures.inc"

global_settings
{
  assumed_gamma 2.2
}

// ----------------------------------------
camera{
  location  <0.0, 3, -4>
  direction 4*z
  right     4/3*x
  look_at   <0/12, 2,  0.0>
}

sky_sphere{
  pigment{
    gradient y
    color_map { [0.0 color blue 0.6] [1.0 color rgb 1] }
  }
}

light_source{
  0*x 
  color White * 2
  translate <5, 2, -30>
}
           
// ----------------------------------------
//plane { y, -1 pigment {color rgb <0.7,0.5,0.3>}}

#end // (UseAsIncludeFile)



#ifndef (TestMode)   
  #declare chrome = texture{T_Chrome_2D}
  #declare silverPlate = 
    texture {
      pigment { color  rgb <0.94, 0.93, 0.83>*1.25 }
      finish {
        metallic
        ambient 0.2
        diffuse 0.35
        specular 0.85
        roughness 0.01
        reflection 0.35
        brilliance 1.5
      }
    }

  #declare strutPinTexture = Bright_Bronze
  #declare myGoldTexture = T_Gold_1A  

  #declare Black_Plastic = texture {
    pigment { color rgb <.2, .2, .2> }
    finish { phong 1.0}
  }  

#else                                      
  #declare chrome = texture{pigment{White*.6}}
  #declare strutPinTexture = texture{pigment{Yellow*.65}}
  #declare myGoldTexture = texture { pigment { P_Gold4*.5 }}

  #declare Black_Plastic = texture {
    pigment { color rgb <.2, .2, .2> }  
  }  

#end
 
#declare oneCup = 
union{
  cylinder{<0,0,0>/12, <1.5,0,0>/12, .0625/12  }
  object{
    sphere{<1.5,0,-.3125>/12, .5/12}  
    clipped_by{plane{z,-.3125/12 inverse}}
  }
  texture{Black_Plastic}
  scale 1.5
}
  
#macro inputTower(rx,ry) 
// A macro is used so that the cameras
// can be easily rotated on the x & y axis

union{  
  object{cameraAssy(rx,ry) translate<0,2,0> }
  
  box{<-3,22.625,.2>/12,<3,25.375,0.2625>/12 texture{silverPlate}} 
  box{<-3,25.3125,.2>/12,<3,25.375,1.5>/12 texture{silverPlate}}
  cone{<0,25.375,.75>/12,  0.5/12, <0,26.25,.75>/12, .25/12   texture{Black_Plastic}}
  cylinder{<0,25.375,.75>/12,<0,26.5,.75>/12, .0625/12  texture{Black_Plastic} }
  
  object{ oneCup rotate<0,0,0> translate<0,26.5,.6875>/12}
  object{ oneCup rotate<0,120,0> translate<0,26.5,.6875>/12}
  object{ oneCup rotate<0,240,0> translate<0,26.5,.6875>/12}

  cylinder{<0,-4,.25>/12,<0,8,.25>/12, .4/12  texture{chrome} }
  cylinder{<0,8,.25>/12,<0,16,.25>/12, .3/12  texture{chrome} }
  cylinder{<0,16,.25>/12,<0,25,.25>/12, .2/12 texture{chrome} }

  #declare coil_type       = 3;  
  #declare coil_radius     = .46/12;
  #declare coil_radius2    = .25/12;
  #declare coil_thickness  = .06/12;
  #declare coil_thickness2 = .06/12;
  #declare coil_revolutions= 42;
  #declare coil_point1     = <0,-4,.25>/12;
  #declare coil_point2     = <0,25,.25>/12;          

  object {#include "Coil.inc"
      pigment{color rgb <0.784, 0.784, 0.710>*1.25}
      finish{Shiny}
  }
}  
#end

#ifndef (UseAsIncludeFile)
  object{inputTower(0,15)}  
#end    