#include "colors.inc"
#include "textures.inc"
#include "stones.inc"

#declare RocketShipSwitch = on
#declare RockSwitch = on
#declare TreeSwitch = on
#declare RobotSwitch = on
#declare AlienSwitch = on
#declare CameraSwitch = on
#declare SkySwitch = on

background { SkyBlue }

camera {
        location  <0, 60, -500>
        direction <0, 0,  1>
        up        <0, 1,  0>
        right   <4/3, 0,  0>
        look_at   <0, 100, 0>
}

light_source {<0, 1000, -1500> color White*.8}
light_source {<500, 1000, -1500> color White*.6}
//light_source {<0, 150, 0> color White} //Rocket Interior

//Aliens
#if ( AlienSwitch = on )
#declare _Layer0_DimGray = texture {pigment {color DimGray} finish {Dull}}
#declare _Layer0_Scarlet = texture {pigment {color White} finish {Dull}}
#include "alien.inc"   //from 'area51"
object { Alien //#1
         scale 40
         rotate <-90, 0, 0>
         rotate <0, 60, 0>
         translate <80, -5, -300>
       }  
object { Alien //#2
         scale 40
         rotate <-90, 0, 0>
         rotate <0, 90, 0>
         translate <220, 0, 0>
       }  
object { Alien //#3
         scale 40
         rotate <-90, 0, 0>
         rotate <0, -45, 0>
         translate <190, 110, 0>
       }  
#end

//Camera
#if ( CameraSwitch = on )
#declare Camera = union {
                  box {<-6,0,-2>,<7,4,2> texture { pigment { color Gray50 } } }
                  cylinder {<-3,6,-1.5>,<-3,6,1.5>,3 texture { pigment { color Gray20 } } }
                  cylinder {<4,6,-1.5>,<4,6,1.5>,3 texture { pigment { color Gray20 } } }
                  cylinder {<6,2,0>,<10,2,0>,1 texture { pigment { color Gray30 } } }
                  cylinder {<0,0,0>,<8,-22,0>,.25 texture { pigment { color Gray10 } } }      
                  cylinder {<0,0,0>,<-8,-22,-6>,.25 texture { pigment { color Gray10 } } }      
                  cylinder {<0,0,0>,<-8,-22,6>,.25 texture { pigment { color Gray30 } } }      
                        }
#declare AlienCamera = union { 
object { Camera scale 2
         translate <10, 0, 0>
       }                        
object { Alien scale 40
         rotate <-90, 0, 0>
         rotate <0, -90, 0>
         translate <-10, -8, 0>
       }  
}
object { AlienCamera
         rotate <0, -65, 0>
         translate <-50, -3, -175>
       }
#end                    

//Astronauts
#if ( RobotSwitch = on )
#declare _H1Chest_Green = texture {pigment {color Silver} finish {Dull}}
#declare _H1Neck_Green = texture {pigment {color Silver} finish {Dull}}
#declare _H1L_Arm_Red = texture {pigment {color Silver} finish {Dull}}
#declare _H1R_Arm_Red = texture {pigment {color Silver} finish {Dull}}
#declare _H1Abdomen_LightGray = texture {pigment {color LightGray} finish {Dull}}
#declare _H1L_Leg_Red = texture {pigment {color Silver} finish {Dull}}
#declare _H1R_Leg_Red = texture {pigment {color Silver} finish {Dull}}
#declare _H1L_F_Arm_Cyan = texture {pigment {color Silver} finish {Dull}}
#declare _H1R_F_Arm_Cyan = texture {pigment {color Silver} finish {Dull}}
#declare _H1L_Lowleg_Red = texture {pigment {color Silver} finish {Dull}}
#declare _H1R_Lowleg_Red = texture {pigment {color Silver} finish {Dull}}
#declare _H1L_Foot_Red = texture {pigment {color Silver} finish {Dull}}
#declare _H1R_Palm_Blue = texture {pigment {color Silver} finish {Dull}}
#declare _H1L_Palm_Blue = texture {pigment {color Silver} finish {Dull}}
#declare _H1R_Foot_Red = texture {pigment {color Silver} finish {Dull}}
#declare _H1Head_MediumVioletRed = texture {pigment {color Gray40} finish {Dull}}
#declare _H1L_Thumb_1_Blue = texture {pigment {color Silver} finish {Dull}}
#declare _H1L_Thumb_2_Blue = texture {pigment {color Silver} finish {Dull}}
#declare _H1L_Thumb_3_Blue = texture {pigment {color Silver} finish {Dull}}
#declare _H1L_Index_1_Blue = texture {pigment {color Silver} finish {Dull}}
#declare _H1L_Index_2_Blue = texture {pigment {color Silver} finish {Dull}}
#declare _H1L_Index_3_Blue = texture {pigment {color Silver} finish {Dull}}
#declare _H1L_Mid_1_Blue = texture {pigment {color Silver} finish {Dull}}
#declare _H1L_Mid_2_Blue = texture {pigment {color Silver} finish {Dull}}
#declare _H1L_Mid_3_Blue = texture {pigment {color Silver} finish {Dull}}
#declare _H1L_Ring_1_Blue = texture {pigment {color Silver} finish {Dull}}
#declare _H1L_Ring_2_Blue = texture {pigment {color Silver} finish {Dull}}
#declare _H1L_Ring_3_Blue = texture {pigment {color Silver} finish {Dull}}
#declare _H1L_Litt_1_Blue = texture {pigment {color Silver} finish {Dull}}
#declare _H1L_Litt_2_Blue = texture {pigment {color Silver} finish {Dull}}
#declare _H1L_Litt_3_Blue = texture {pigment {color Silver} finish {Dull}}
#declare _H1R_Thumb_1_Blue = texture {pigment {color Silver} finish {Dull}}
#declare _H1R_Thumb_2_Blue = texture {pigment {color Silver} finish {Dull}}
#declare _H1R_Thumb_3_Blue = texture {pigment {color Silver} finish {Dull}}
#declare _H1R_Index_1_Blue = texture {pigment {color Silver} finish {Dull}}
#declare _H1R_Index_2_Blue = texture {pigment {color Silver} finish {Dull}}
#declare _H1R_Index_3_Blue = texture {pigment {color Silver} finish {Dull}}
#declare _H1R_Mid_1_Blue = texture {pigment {color Silver} finish {Dull}}
#declare _H1R_Mid_2_Blue = texture {pigment {color Silver} finish {Dull}}
#declare _H1R_Mid_3_Blue = texture {pigment {color Silver} finish {Dull}}
#declare _H1R_Ring_1_Blue = texture {pigment {color Silver} finish {Dull}}
#declare _H1R_Ring_2_Blue = texture {pigment {color Silver} finish {Dull}}
#declare _H1R_Ring_3_Blue = texture {pigment {color Silver} finish {Dull}}
#declare _H1R_Litt_1_Blue = texture {pigment {color Silver} finish {Dull}}
#declare _H1R_Litt_2_Blue = texture {pigment {color Silver} finish {Dull}}
#declare _H1R_Litt_3_Blue = texture {pigment {color Silver} finish {Dull}}
#include "mrobot.inc"
object { Mrobot //#1
         scale .7
         rotate <-90, 0, 0>
         rotate <0, 180, 0>
         translate <150, 95, 108>
       }
object { Mrobot //#2
         scale .7
         rotate <-90, 0, 0>
         rotate <0, 180, 0>
         translate <125, 0, 75>
       }
#end

//The Tree
#if ( TreeSwitch = on )
#declare Tree =
height_field { gif "pvtree.gif" water_level 1/256
                 texture { pigment { color Gray20 } 
                           finish { crand 0.05 diffuse 0.7 ambient 0.3}
                         }
               //smooth             // comment out this line to speed rendering
               translate <-.5, 0, 0>
               rotate <-90, 0, 0>
               scale <300, 300, 5>
             }
object { Tree  translate <-150, -110, 25> }  //#1
object { Tree  scale 2 translate <175, -110, 325> }  //#2
object { Tree  scale 1.5 translate <200, -125, 0> }  //#3
object { Tree  scale 1.5 translate <-150, -125, 50> }  //#4
#end

//The Ground
#if ( RockSwitch = on )
plane { y, -100 texture { pigment { color White } } }
#include "brock2.inc"
#declare Brock2 = object { Rock texture { T_Stone8 scale 2 }
                           scale <50, 5, 100>
                           translate <150, -75, 200>
                         }
object { Brock2 }
#end

//The Rocket Ship
#if ( RocketShipSwitch = on )
#declare Rocket_Silver = texture { Soft_Silver finish { reflection .1 } }
#declare Bodyr = sor { 13,
                       <1.00, -.10>, <1.00, 0.00>, <1.00, 3.00>, <1.00, 3.50>, <1.00, 4.00>,
                       <0.98, 4.50>, <0.90, 4.90>, <0.80, 5.30>, <0.70, 5.60>, <0.50, 6.00>,
                       <0.30, 6.40>, <0.05, 6.90>, <0.00, 7.00>
                     }
#declare Body =
#object { Bodyr texture { Rocket_Silver } 
          scale 50
        }
#declare Bodyd =
difference { object { Body }
             box { <-10, 70, -55>, <10, 125, -40> }
           }
#declare Finp = prism { linear_sweep
                        linear_spline
                        -1, 1, 6,
                        <0.0, 0.0>, <0.0, 2.0>, <1.0, 0.0>,
                        <1.0, -1.0>, <0.5, -1.0>, <0.0, 0.0>
                      }
#declare Fin =
object { Finp texture { Rocket_Silver }
         translate <0.95, 0, 0>
         scale <50, 1, 50>
         rotate <-90, 0, 0>
       }
#declare Ladder =
         union { cylinder { <-7, 70, -55>, <-7, -60, -55>, .3 }
                 cylinder { <7, 70, -55>, <7, -60, -55>, .3  }
                 cylinder { <-7, 60, -55>, <7, 60, -55>, .2  }
                 cylinder { <-7, 50, -55>, <7, 50, -55>, .2  }
                 cylinder { <-7, 40, -55>, <7, 40, -55>, .2  }
                 cylinder { <-7, 30, -55>, <7, 30, -55>, .2  }
                 cylinder { <-7, 20, -55>, <7, 20, -55>, .2  }
                 cylinder { <-7, 10, -55>, <7, 10, -55>, .2  }
                 cylinder { <-7, 0, -55>, <7, 0, -55>, .2  }
                 cylinder { <-7, -10, -55>, <7, -10, -55>, .2 }
                 cylinder { <-7, -20, -55>, <7, -20, -55>, .2 }
                 cylinder { <-7, -30, -55>, <7, -30, -55>, .2 }
                 cylinder { <-7, -40, -55>, <7, -40, -55>, .2 }
                 cylinder { <-7, -50, -55>, <7, -50, -55>, .2 }
               }
#declare RocketShip =
         union { object { Bodyd }
                 object { Ladder 
                          texture { pigment { color Gray30 } finish { metallic  } }
                          rotate <5, 0, 0>
                        }                 
                 object { Fin rotate <0, -90, 0> } 
                 object { Fin rotate <0, 30, 0> } 
                 object { Fin rotate <0, 150, 0> } 
               }
#object { RocketShip 
          translate <150, 0, 150>
        }                                                
#end


//The Sky
#if ( SkySwitch = on )
// /* <<======= Temp Out Sky
sphere { <0, 0, 0>, 1
        inverse
        scale <6000, 6000, 6000>
        //texture { pigment { color Grey } }
        texture { finish { ambient .2  diffuse .5  //brilliance 1.0
                           //phong .6  phong_size 20  metallic
                         }
                           pigment { image_map { gif "coolblu.gif" interpolate 2 once }
                           translate <-0.5, -0.2, 0>
                           scale <6000, 5000, 1> } }
        translate <0, 0, -1500>                   
       }
// <<===== End Sky Out */
#end                                                                           
