
// Persistence of Vision Ray Tracer Scene Description File
// File: 86c_pi.pov
// Vers: 3
// Desc:
// Date: November, December 1998
// Auth: Matthias Opitz
// website: http://privat.swol.de/MatthiasOpitz/index.htm
*********************************************************************************************
*********************************************************************************************
This is only the master scene file of "Private Investigations". Please excuse the mess within
this file. The complete source code for "Private Investigations" is too extensive (more than
10 MB).
*********************************************************************************************
*********************************************************************************************


//*******************************************************************************************
// includes and global settings
//*******************************************************************************************

#include "colors.inc"
#include "textures.inc"
#include "shapes.inc"
#include "stones.inc"
#include "specialtex_pi.inc"
#include "golds.inc"
#include "glass.inc"
#include "woods.inc"



global_settings {
    adc_bailout 0.0039
    max_trace_level 12
    ambient_light color rgb <1,1,0.88>
    }


//*******************************************************************************************
// camera and lightsources
//*******************************************************************************************


  camera {
      location <0,1.30,-1.05>
      look_at <-0.35,0.80,3.00>
      angle 60
  }



   light_source { <0,2.2,0> color rgb <1,1,0.88>
   atmosphere off
   shadowless
   fade_distance 0.7
   fade_power 2}

   light_source { <0,2,0> color rgb <1,1,0.88>
   spotlight
   point_at <0,0.80,0>
   radius 23
   falloff 32
   tightness 10
   fade_distance 0.8
   fade_power 2}




   light_source { <0,2.2,4.1> color rgb <0.9,0.9,0.9>
   atmosphere off
   fade_distance 0.5
   fade_power 3}



//*******************************************************************************************
// the scene
//*******************************************************************************************

// ***Start Raum

// Nordwand mit Lcke fr Tre und angrenzendem Raum

difference {
box
{
  <-2.5, 0, 3.5>  // one corner position <X1 Y1 Z1>
  < 2.5,  2.50, 3.7>  // other corner position <X2 Y2 Z2>
    texture { pigment { color Gray85 } finish { rauh } normal { bumps 0.4 scale 0.025} }
  //texture { pigment { color rgb <0.98,0.933,0.796> } finish { rauh } }
}


box
{
  <1.1, 0, 3.48>  // one corner position <X1 Y1 Z1>
  <2, 2, 3.72>  // other corner position <X2 Y2 Z2>
  texture { pigment { color Gray85 } finish { rauh } normal { bumps 0.4 scale 0.025} }
} }


box //Rahmen
{
  <1.07, 0, 3.493>  // one corner position <X1 Y1 Z1>
  <1.1, 2.03, 3.50>  // other corner position <X2 Y2 Z2>
  texture { T_Wood9 finish { matt_glaenzend }  }}

box //Rahmen
{
  <1.1, 2, 3.493>  // one corner position <X1 Y1 Z1>
  <2, 2.03, 3.50>  // other corner position <X2 Y2 Z2>
  texture { T_Wood9 finish { matt_glaenzend } }}

  box //Rahmen
{
  <2.00, 0, 3.493>  // one corner position <X1 Y1 Z1>
  <2.03, 2.03, 3.50>  // other corner position <X2 Y2 Z2>
  texture { T_Wood9 finish { matt_glaenzend }  }}




box // Leiste
{
  <-2.5, 2.475, 3.493>  // one corner position <X1 Y1 Z1>
  < 2.5,  2.50, 3.50>  // other corner position <X2 Y2 Z2>
  texture { pigment { color rgb <1,0.647,0.29> } finish { matt_glaenzend } }
}


box  // Nordwand fr angrenzenden Raum
{
  <-2.5, 0, 5.7>  // one corner position <X1 Y1 Z1>
  < 2.5,  2.50, 5.9>  // other corner position <X2 Y2 Z2>
  texture { pigment { color rgb <0.957,0.866,0.596> } finish { rauh } }
}

box  // Westwand fr angrenzenden Raum
{
  <-2.5, 0, 3.7>  // one corner position <X1 Y1 Z1>
  <-2.7,  2.50, 5.7 >  // other corner position <X2 Y2 Z2>
  texture { pigment { color rgb <0.957,0.866,0.596> } finish { rauh } }
}

box  // Ostwand fr angrenzenden Raum
{
  <2.5, 0, 3.7>  // one corner position <X1 Y1 Z1>
  <2.7, 2.50, 5.7 >  // other corner position <X2 Y2 Z2>
  texture { pigment { color Gray85 } finish { rauh } }
}


box // Boden fr angrenzenden Raum
{
  <-2.5, 0, 3.7>  // one corner position <X1 Y1 Z1>
  < 2.5,  -0.01, 5.7>  // other corner position <X2 Y2 Z2>
 texture {
   checker texture { T_Stone31 finish { reflection 0.3 } },
           texture { T_Stone15 finish { reflection 0.3 } }

      scale 0.4 rotate y*45
      }
}

box // Decke fr angrenzenden Raum
{
  <-2.5, 2.50, 3.7>  // one corner position <X1 Y1 Z1>
  < 2.5, 2.51, 5.7>  // other corner position <X2 Y2 Z2>
  texture { pigment { color Gray85 } finish { rauh } }
}



 // Sdwand

box
{
  <-2.5, 0, -3.5>  // one corner position <X1 Y1 Z1>
  < 2.5,  2.50, -10>  // other corner position <X2 Y2 Z2>
  texture { pigment { color Gray85 } finish { rauh } normal { bumps 0.4 scale 0.025} } }

// Westwand mit  2 Fenstern

difference {  // Die Wand
box
{
  <-2.34, 0, -3.5>  // one corner position <X1 Y1 Z1>
  <-2.15, 2.50, 3.5>  // other corner position <X2 Y2 Z2>
  texture { pigment { color Gray85 } finish { rauh } normal { bumps 0.4 scale 0.025} }
}

box
{
  <-2.35, 0.87, 1.15>
  <-2.14, 2.20, 3.05>
  texture { pigment { color Gray85 } finish { rauh } normal { bumps 0.4 scale 0.025} }
}

box
{
  <-2.35, 0.87, -0.95>
  <-2.14, 2.20, 0.95>
  texture { pigment { color Gray85 } finish { rauh } normal { bumps 0.4 scale 0.025} }
} }

box // Leiste
{
  <-1.97, 2.475, -3.5>  // one corner position <X1 Y1 Z1>
  <-1.963,  2.50, 3.5>  // other corner position <X2 Y2 Z2>
  texture { pigment { color rgb <1,0.647,0.29> } finish { matt_glaenzend } }
}


// Vorsprung

box
{
  <-2.15, 2.30, -3.5>  // one corner position <X1 Y1 Z1>
  <-1.97, 2.61, 3.5>  // other corner position <X2 Y2 Z2>
  texture { pigment { color Gray85 } finish { rauh } normal { bumps 0.4 scale 0.025} }
}


  // end Vorsprung


//*********************Definition der Fenster********************************************

box
{ // 1. Fenster
  <-2.502, 1.0, 1.25>  // one corner position <X1 Y1 Z1>
  < -2.498, 2.1, 2.95>  // other corner position <X2 Y2 Z2>
  texture { Glass_Window }
  translate <-0.19, 0, 0>
}
box
{   // 2. Fenster
  <-2.152, 1.0, 0.85>  // one corner position <X1 Y1 Z1>
  < -2.148, 2.1, -0.85>  // other corner position <X2 Y2 Z2>
  texture { Glass_Window }
  translate <-0.19, 0, 0>
  }


 difference {   // Rahmen fr 1. Fenster
 box
{
  <0, 0, -0.95>
  < 0.03, 1.3, 0.95>
}
box
{
  <-0.03, 0.1, -0.85>
  < 0.035, 1.2, 0.85 >
}
texture { T_Wood9 scale <0.1,0.1,6> finish { matt_glaenzend } }
//texture { pigment { DMFWood3 } finish { matt_ref } scale <0.08,0.08,6> }
translate <-2.338, 0.9, 2.1 >
}

box  // Rahmen fr Fenstergriffe
{
  <-2.338, 1.0, 2.18>
  <-2.308, 2.1, 2.32 >
  texture { T_Wood9 scale <0.1,0.1,6> finish { matt_glaenzend } }}
//texture { pigment { DMFWood3 } finish { matt_ref } scale <0.08,0.08,6> } }

// Fenstergriff 1
union {
box
{
  <-2.308, 1.515,  2.20>
  <-2.293, 1.585,  2.23>
  texture { Polished_Chrome2 }
}

cylinder {  //Zylinder
    <-2.293, 1.55, 2.215>,     // Center of one end
    <-2.248, 1.55, 2.215>,     // Center of other end
    0.01            // Radius
    //open           // Remove end caps
    texture { Polished_Chrome2 }
  }

 cylinder {  //Handgriff
    <-2.233, 1.57, 2.215>,     // Center of one end
    <-2.233, 1.45, 2.215>,     // Center of other end
    0.015            // Radius
    //open           // Remove end caps
    texture { Polished_Chrome2 }
  } }

  // Fenstergriff 2
union {
box
{
  <-2.308, 1.515,  2.20>
  <-2.293, 1.585,  2.23>
  texture { Polished_Chrome2 }
}

cylinder {  //Zylinder
    <-2.293, 1.55, 2.215>,     // Center of one end
    <-2.248, 1.55, 2.215>,     // Center of other end
    0.01            // Radius
    //open           // Remove end caps
    texture { Polished_Chrome2 }
  }

 cylinder {  //Handgriff
    <-2.233, 1.57, 2.215>,     // Center of one end
    <-2.233, 1.45, 2.215>,     // Center of other end
    0.015            // Radius
    //open           // Remove end caps
    texture { Polished_Chrome2 }
  } translate <0, 0, 0.07> }


 difference {  // Rahmen fr 2. Fenster
 box
{
  <0, 0, -0.95>
  < 0.03, 1.3, 0.95>
}
box
{
  <-0.03, 0.1, -0.85>
  < 0.035, 1.2, 0.85 >
}
texture { T_Wood9 scale <0.1,0.1,6> finish { matt_glaenzend } }
//texture { pigment { DMFWood3 } finish { matt_ref } scale <0.08,0.08,6> }
translate <-2.338, 0.9, 0 >
}

box  // Rahmen fr Fenstergriffe
{
  <-2.338, 1.0, 0.08>
  <-2.308, 2.1, 0.22 >
  texture { T_Wood9 scale <0.1,0.1,6> finish { matt_glaenzend } }}
//texture { pigment { DMFWood3 } finish { matt_ref } scale <0.08,0.08,6> } }

 // Fenstergriff 3
union {
box
{
  <-2.308, 1.515,  2.20>
  <-2.293, 1.585,  2.23>
  texture { Polished_Chrome2 }
}

cylinder {  //Zylinder
    <-2.293, 1.55, 2.215>,     // Center of one end
    <-2.248, 1.55, 2.215>,     // Center of other end
    0.01            // Radius
    //open           // Remove end caps
    texture { Polished_Chrome2 }
  }

 cylinder {  //Handgriff
    <-2.233, 1.57, 2.215>,     // Center of one end
    <-2.233, 1.45, 2.215>,     // Center of other end
    0.015            // Radius
    //open           // Remove end caps
    texture { Polished_Chrome2 }
  } translate <0, 0, -2.10> }

   // Fenstergriff 4
union {
box
{
  <-2.308, 1.515,  2.20>
  <-2.293, 1.585,  2.23>
  texture { Polished_Chrome2 }
}

cylinder {  //Zylinder
    <-2.293, 1.55, 2.215>,     // Center of one end
    <-2.248, 1.55, 2.215>,     // Center of other end
    0.01            // Radius
    //open           // Remove end caps
    texture { Polished_Chrome2 }
  }

 cylinder {  //Handgriff
    <-2.233, 1.57, 2.215>,     // Center of one end
    <-2.233, 1.45, 2.215>,     // Center of other end
    0.015            // Radius
    //open           // Remove end caps
    texture { Polished_Chrome2 }
  } translate <0, 0, -2.03> }


box  // Fensterbank 1. Fenster
{
  <-2.15, 0.87, 1.15>  // one corner position <X1 Y1 Z1>
  <-1.91, 0.90, 3.05>  // other corner position <X2 Y2 Z2>
  texture { Fensterbank }
  translate <-0.19, 0, 0> }

box  // Fensterbank 2. Fenster
{
  <-2.15, 0.87, -0.95>  // one corner position <X1 Y1 Z1>
  <-1.91, 0.90, 0.95>  // other corner position <X2 Y2 Z2>
  texture { Fensterbank }
  translate <-0.19, 0, 0> }



//******************************
// Die Jalousien
//******************************

// schmale Jalousie 63 cm, 100 cm lang
#declare Jalousie1 = object {
union {
 cylinder {
    <-0.008,0,-0.195>,     // Center of one end
    <-0.008,1,-0.195>,     // Center of other end
    0.0015          // Radius
    //open           // Remove end caps
    texture { pigment { color rgb <1,1,1> } finish { matt_ref2 } }}
cylinder {
    <0.008,0,-0.195>,     // Center of one end
    <0.008,1,-0.195>,     // Center of other end
    0.0015          // Radius
    //open           // Remove end caps
    texture { pigment { color rgb <1,1,1> } finish { matt_ref2 } }}

cylinder {
    <-0.008,0,0.195>,     // Center of one end
    <-0.008,1,0.195>,     // Center of other end
    0.0015          // Radius
    //open           // Remove end caps
    texture { pigment { color rgb <1,1,1> } finish { matt_ref2 } }}
cylinder {
    <0.008,0,0.195>,     // Center of one end
    <0.008,1,0.195>,     // Center of other end
    0.0015          // Radius
    //open           // Remove end caps
    texture { pigment { color rgb <1,1,1> } finish { matt_ref2 } }}

#declare Step=0.02
#declare Y=0
#while (Y<1.00)
box
{
  <-0.0125,-0.001,-0.315>  // one corner position <X1 Y1 Z1>
  <0.0125,0.001,0.315>  // other corner position <X2 Y2 Z2>
texture { pigment { color rgbft <0.047, 0.816, 0.84, 0.3,0> } }
rotate <0,0,-25>
translate <0,Y,0> }
#declare Y=Y+Step
#end

#declare Step=0.004
#declare Y=0.98
#while (Y<1.015)
box
{
  <-0.0125,-0.001,-0.315>  // one corner position <X1 Y1 Z1>
  <0.0125,0.001,0.315>  // other corner position <X2 Y2 Z2>
texture { pigment { color rgbft <0.047, 0.816, 0.84, 0.3,0> } finish { matt_ref2 } }
rotate <0,0,-8>
translate <0,Y,0> }
#declare Y=Y+Step
#end

}
}

// breite Jalousie 93 cm, 100 cm lang
#declare Jalousie2 = object {
union {
 cylinder {
    <-0.008,0,-0.345>,     // Center of one end
    <-0.008,1.00,-0.345>,     // Center of other end
    0.0015          // Radius
    //open           // Remove end caps
    texture { pigment { color rgb <1,1,1> } finish { matt_ref2 } }}
cylinder {
    <0.008,0,-0.345>,     // Center of one end
    <0.008,1.00,-0.345>,     // Center of other end
    0.0015          // Radius
    //open           // Remove end caps
    texture { pigment { color rgb <1,1,1> } finish { matt_ref2 } }}

cylinder {
    <-0.008,0,0.345>,     // Center of one end
    <-0.008,1.00,0.345>,     // Center of other end
    0.0015          // Radius
    //open           // Remove end caps
    texture { pigment { color rgb <1,1,1> } finish { matt_ref2 } }}
cylinder {
    <0.008,0,0.345>,     // Center of one end
    <0.008,1.00,0.345>,     // Center of other end
    0.0015          // Radius
    //open           // Remove end caps
    texture { pigment { color rgb <1,1,1> } finish { matt_ref2 } }}


cylinder {
    <-0.008,0,0>,     // Center of one end
    <-0.008,1.00,0>,     // Center of other end
    0.0015          // Radius
    //open           // Remove end caps
    texture { pigment { color rgb <1,1,1> } finish { matt_ref2 } }}
cylinder {
    <0.008,0,0>,     // Center of one end
    <0.008,1.00,0>,     // Center of other end
    0.0015          // Radius
    //open           // Remove end caps
    texture { pigment { color rgb <1,1,1> } finish { matt_ref2 } }}


#declare Step=0.02
#declare Y=0
#while (Y<1.00)
box
{
  <-0.0125,-0.001,-0.465>  // one corner position <X1 Y1 Z1>
  <0.0125,0.001,0.465>  // other corner position <X2 Y2 Z2>
texture { pigment { color rgbft <0.047, 0.816, 0.84, 0.3,0> } }
rotate <0,0,-25>
translate <0,Y,0> }
#declare Y=Y+Step
#end

#declare Step=0.004
#declare Y=0.98
#while (Y<1.015)
box
{
  <-0.0125,-0.001,-0.465>  // one corner position <X1 Y1 Z1>
  <0.0125,0.001,0.465>  // other corner position <X2 Y2 Z2>
texture { pigment { color rgbft <0.047, 0.816, 0.84, 0.3,0> } finish { matt_ref2 } }
rotate <0,0,-8>
translate <0,Y,0> }
#declare Y=Y+Step
#end

}
}


object { Jalousie1 translate <-2.3255,1.087,2.635>  }
object { Jalousie1 translate <-2.3255,1.087,0.535>  }
object { Jalousie2 translate <-2.3255,1.087,1.715>  }
object { Jalousie2 translate <-2.3255,1.087,-0.385> }



 // Ostwand
plane { x, 2.5
texture { pigment { color Gray85 } finish { rauh } normal { bumps 0.4 scale 0.025} } hollow }

// Die Korkleiste

box
{
  <-2.15, 0, -3.5>  // one corner position <X1 Y1 Z1>
  <-2.145, 0.67, 3.5>  // other corner position <X2 Y2 Z2>
  texture {Cork scale <0.2,0.2,0.6> finish {matt_ref_crand2} normal {bumps 0.2 scale 0.025}}}

  box
{
  <-2.15, 0.67, -3.5>  // one corner position <X1 Y1 Z1>
  <-2.145, 0.70, 3.5>  // other corner position <X2 Y2 Z2>
  texture { pigment { color rgb <0.325,0.161,0> } finish { matt_ref_crand2 } }}

box
{
  <-2.15, 0, 3.5>  // one corner position <X1 Y1 Z1>
  <1.07, 0.67, 3.495>  // other corner position <X2 Y2 Z2>
  texture {Cork scale <0.6,0.2,0.2> finish {matt_ref_crand2} normal {bumps 0.2 scale 0.025}}}

  box
{
  <-2.15, 0.67, 3.5>  // one corner position <X1 Y1 Z1>
  <1.07, 0.70, 3.495>  // other corner position <X2 Y2 Z2>
  texture { pigment { color rgb <0.325,0.161,0> } finish { matt_ref_crand2 } }}

  box
{
  <2.03, 0, 3.5>  // one corner position <X1 Y1 Z1>
  <2.50, 0.67, 3.495>  // other corner position <X2 Y2 Z2>
  texture {Cork scale <0.6,0.2,0.2> finish {matt_ref_crand2} normal {bumps 0.2 scale 0.025}}}

  box
{
  <2.03, 0.67, 3.5>  // one corner position <X1 Y1 Z1>
  <2.50, 0.70, 3.495>  // other corner position <X2 Y2 Z2>
  texture { pigment { color rgb <0.325,0.161,0> } finish { matt_ref_crand2 } }}



 cylinder { // Eckleiste
    <-2.15, 0, 3.5>,     // Center of one end
    <-2.15, 0.67, 3.5>,     // Center of other end
    0.02            // Radius
    //open           // Remove end caps
    texture { pigment { color rgb <0.325,0.161,0> } finish { matt_ref_crand2 } }
  }


//***************************************
// Die Holzdecke
//***************************************

box
{
  <-2.5, 2.507, -3.5>  // one corner position <X1 Y1 Z1>
  < 2.5,  2.55,  3.5>  // other corner position <X2 Y2 Z2>
  texture { Holzdecke1 }}

 #declare Step=0.12
#declare Z=0
#while (Z<7.0)
box
{
  <-2.32,2.5,-3.5>  // one corner position <X1 Y1 Z1>
  <2.5,2.507,-3.4>  // other corner position <X2 Y2 Z2>
  texture { Holzdecke2 translate <Z,0,Z>  }
translate <0,0,Z> }
#declare Z=Z+Step
#end



 // Boden

/*box
{
  <-2.5, 0, -3.5>  // one corner position <X1 Y1 Z1>
  < 2.5,  -1,  3.5>  // other corner position <X2 Y2 Z2>
texture {
   checker texture { T_Stone31 finish { reflection 0.4 } },
           texture { T_Stone15 finish { reflection 0.4 } }

      scale 0.4 rotate y*45
      }
   }*/

   box
{
  <-2.5, -0.015, -3.5>  // one corner position <X1 Y1 Z1>
  < 2.5,  -0.1,  3.5>  // other corner position <X2 Y2 Z2>
  texture { pigment { color Black} finish { ambient 0.7 }}}

 #declare Step=0.156
#declare Z=0
#while (Z<7.0)
box
{
  <-2.5,-0.015,-3.5>  // one corner position <X1 Y1 Z1>
  <2.5,0,-3.35>  // other corner position <X2 Y2 Z2>
  texture { Fussboden translate <Z,0,Z>  }
translate <0,0,Z> }
#declare Z=Z+Step
#end


// ***Ende Raum

// ***Start Einzelobjekte

#include "flower.inc"
object { Blume scale 0.1 translate <-2.22,0.90,2.20> }




   #declare Vase = object {
lathe {
  cubic_spline
  12,
  <0.000000, 0.000000>,
  <0.000000, 0.000000>,
  <0.460606, 0.036364>,
  <0.515152, 0.303030>,
  <0.157576, 0.660606>,
  <0.248485, 1.000000>,
  <0.230303, 1.000000>,
  <0.139394, 0.660606>,
  <0.496970, 0.296970>,
  <0.448485, 0.054545>,
  <0.000000, 0.018182>,
  <0.000000, 0.018182>
  texture { Brass_Valley }


  scale <0.15, 0.2, 0.15>
}}

object { Vase translate <-2.22,0.90,2.75> }


#include "plant.inc"
object { Pflanze scale 0.18 translate <-1.5,0.876,3.75> }



 //***********************
 // Der Muelleimer

 #declare Sockel_Texture =
texture { Polished_Brass }

#declare Mitte_Texture =
texture { Brushed_Aluminum }

#declare Deckel1_Texture =
texture { Polished_Chrome2 }

#declare Deckel2_Texture =
texture { Polished_Brass }

#declare Sockel = object {
cylinder
{
  <0,0,0>,
  <0,0.06,0>,
  0.175
  // open
  texture {Sockel_Texture}
}}

#declare Mitte = object {
cylinder
{
  <0,0.06,0>,
  <0,0.6,0>,
  0.16
  // open
  texture {Mitte_Texture}
}}

#declare Deckel1 = object {
difference {

sphere { <0,0,0 >, 0.17
texture {Deckel1_Texture }}

box { <0.5,0,0.5>,
      <-0.5,-0.5,-0.5> }

superellipsoid
{ < 0.2, 0.2 >
  scale <0.1,0.5,0.07>
  translate <0,0,-0.065>
  }
} translate <0,0.6,0>}

#declare Deckel2 = object {
intersection {

sphere { <0,0,0 >, 0.17
texture {Deckel2_Texture }}

superellipsoid
{ < 0.2, 0.2 >
  scale <0.095,0.5,0.065>
  translate <0,0,-0.065>
  texture {Deckel2_Texture }
  }
} translate <0,0.6,0>}


 #declare Muelleimer = object {
 union {
 object {Sockel}
 object {Mitte}
 object {Deckel1}
 object {Deckel2}
 }}


 object {Muelleimer scale 0.88 rotate <0,-35,0> translate <-1.85,0,3.1> }

// Ende Muelleimer
//*******************************



// ***Ende Einzelobjekte

// ***Start Der Schreibtisch mit Objekten

box
{
  <-0.75, 0, -0.60>
  < 0,  0.80,  0.50>
texture { pigment { DMFWood3 turbulence 0.76 } scale <1.5,1,1> translate <0.60,0,0>
finish { matt_ref2 } }}

box
{
  <0, 0, -0.60>
  < 0.75,  0.80,  0.50>
texture { pigment { DMFWood3 turbulence 0.76 } scale <1.5,1,1> translate <-0.1,0,0>
finish { matt_ref2 } }}




 box // Auflage
{
  <-0.35, 0.80, -0.54>
  < 0.35,  0.804,  0.05>
  texture { pigment { color rgb <0,0,0.112> }
  finish { diffuse 0.38 ambient 0.25 specular 0.2 roughness 0.2 crand 0.1 reflection 0.01  }
  normal {bumps 0.2 scale 0.003 }
   }}

  #declare Papier1 = object {
 box
{
  <0,0,0>
  <1,1,-0.0005 >
texture {pigment {
image_map { tga "Papier1.tga" map_type 0  interpolate 2} }finish { sehr_matt }}
scale <0.208,0.297,1.0>
}}

  #declare Papier2 = object {
 box
{
  <0,0,0>
  <1,1,-0.0005 >
texture {pigment {
image_map { tga "Papier2.tga" map_type 0  interpolate 2} }finish { sehr_matt }}
scale <0.208,0.297,1.0>
}}

  #declare Papier3 = object {
 box
{
  <0,0,0>
  <1,1,-0.0005 >
texture {pigment {
image_map { tga "Papier3.tga" map_type 0  interpolate 2} }finish { sehr_matt }}
scale <0.208,0.297,1.0>
}}



object { Papier3 rotate <90,-22,0> translate <-0.3,0.804,-0.13> }
object { Papier2 rotate <90,8,0> translate <-0.32,0.8045,-0.12> }
object { Papier1 rotate <90,15,0> translate <-0.355,0.805,-0.1> }


  #declare Zettel1 = object {
 box
{
  <0,0,0>
  <1,1,-0.0007 >
texture { pigment { color rgb <1,0.51,0.48> } finish { sehr_matt } }
scale <0.14,0.1,1.0>
}}

  #declare Zettel2 = object {
 box
{
  <0,0,0>
  <1,1,-0.0007 >
texture {pigment {
image_map { tga "Brief.tga" map_type 0  interpolate 2} }finish { sehr_matt }}
scale <0.21,0.1,1.0>
}}

  #declare Zettel3 = object {
 box
{
  <0,0,0>
  <1,1,-0.0007 >
texture { pigment { color rgb <0.8,0.8,0.8> } finish { sehr_matt } }
scale <0.14,0.1,1.0>
}}

object { Zettel2 rotate <90,-22,0> translate <0.15,0.8,0.15> }
object { Zettel3 rotate <90,8,0> translate   <0.17,0.8007,0.13> }
object { Zettel3 rotate <90,15,0> translate  <0.18,0.8014,0.15> }
object { Zettel1 rotate <90,16,0> translate  <0.19,0.8021,0.16> }
object { Zettel1 rotate <90,19,0> translate  <0.18,0.8028,0.15> }
object { Zettel2 rotate <90,15,0> translate  <0.16,0.8035,0.15> }




// Der Briefbeschwerer


#declare Briefbeschwerer = object {
difference {
 sphere { <0,0,0>, 0.05 texture { T_Stone34 scale 0.45 finish {
 diffuse 0.56 ambient 0.22 reflection 0.05 phong 0.9
 phong_size 200 specular 0.25 roughness 0.004}}
 scale <1,1,1>
    translate <0,0,0> }
box
{ <-0.1,-0.025,-0.1>
  <0.1,-0.1,0.1>
texture { pigment { color Clear }}}}}



   object { Briefbeschwerer rotate <0,0,0> translate <0.25,0.8292,0.2> }

// Die Lupe


#include "Lupe.inc"

object { Lupe scale 1 rotate <0,0,0> translate <0,0.0714,0.1> } //y translate auf 0.8064 opt.


// Der Kugelschreiber

#include "Pencil.inc"

object { Pencil1 scale 0.000314 rotate <-45,0,90> translate <0.02,0.8085,-0.1> }

#declare Schale = object {
union {
difference {

superellipsoid
{ < 0.17, 0.17 >
  scale <0.115,0.0125,0.05>
  translate <0,0.0125,0>
  texture { DMFWood6_mod scale <3,0.08,0.08> }
  }

  superellipsoid
{ < 0.22, 0.22 >
  scale <0.09,0.0125,0.015>
  translate <0,0.0225,0.02>
  texture { DMFWood6_mod scale <3,0.08,0.08> }
  }

    superellipsoid
{ < 0.22, 0.22 >
  scale <0.09,0.0125,0.015>
  translate <0,0.0225,-0.02>
  texture { DMFWood6_mod scale <3,0.08,0.08> }
  }
  }}}

  object { Schale rotate <0,0,0> translate <-0.04,0.80,0.24> }
  object { Pencil1 scale 0.000314 rotate <-3,0,90> translate <0.02,0.8145,0.27> }
  object { Pencil2 scale 0.000314 rotate <184,0,90> translate <-0.095,0.8145,0.225> }



// Whisky

#declare Whiskyglas = object {
  union {
    cylinder {  //Glasboden
    <0,0,0>,     // Center of one end
    <0,0.013,0>,     // Center of other end
    0.0375            // Radius
    //open           // Remove end caps
    texture { Glass3 }
    translate <0.0,0.0,0.0>
  }

  lathe { // Whisky
 cubic_spline
 6,
    <0, 0>,
    <0, 0>,
    <3.5, 0>,
    <3.25, 2.175>,
    <0, 2.175>,
    <0, 2.175>
    texture { pigment { color rgbf <0.992, 0.384, 0.09, 0.89> }
     finish  {
        ambient 0.45
        diffuse 0.1
        reflection 0.15
        refraction on
        ior 1.25
        specular 0.8
        roughness 0.0003
        phong 1
        phong_size 400 }}

    scale <0.01,0.01,0.01>
    rotate <0,0,0>
    translate <0,0.013,0>}

 lathe { // Glaskoerper
 cubic_spline
 7,
    <3.75, 0>,
    <3.75, 0>,
    <3.5, 2.175>,
    <3.3, 4.35>,
    <3.5, 6.525>,
    <4, 8.7>,
    <4, 8.7>
    texture { GlassY }
    scale <0.01,0.01,0.01>
    rotate <0,0,0>
    translate <0,0.013,0>
    }}}

    object {Whiskyglas translate <-0.40,0.80,-0.16> }



     #include "JackDaniels.inc"
     object { Jack_Daniels rotate <0,-33,0> translate <-0.44,0.80,0.03> }



// Aschenbecher

#include "ashtray.inc"

// Revolver

#include "Revolver.inc"

object { Revolver scale 0.18 rotate <-12,-6,-25> translate <0.22,0.87,-0.20> }

#include "telephone.inc"

object { Telefon scale 2.185 rotate <0,0,0> translate <-0.58,0.839,-0.18> }



// ***Ende Der Schreibtisch mit Objekten

// ***Start weitere Raumobjekte

//  Die Tr
union {
difference {
box
{
  <0, 0.01, 0>  // one corner position <X1 Y1 Z1>
  <-0.9, 2, -0.04>  // other corner position <X2 Y2 Z2>
  texture { T_Wood9 scale <0.08,3,0.08> finish { matt_glaenzend } }
  }

  box
{
  <-0.14, 0.75, 0.06>  // one corner position <X1 Y1 Z1>
  <-0.76, 1.85, -0.06>  // other corner position <X2 Y2 Z2>
  }}

 difference {  // Umrandung Glasscheibe
 box
{
  <-0.125, 0.735, 0>
  <-0.775, 1.865, -0.055>
  texture { T_Wood4 finish { matt_glaenzend }}
  }
box
{
  <-0.138, 0.748, 0.06>
  <-0.762, 1.852, -0.06>
  }}

    box // Glasscheibe in Tr
{
  <-0.14, 0.75, -0.02>  // one corner position <X1 Y1 Z1>
  <-0.76, 1.85, -0.024>  // other corner position <X2 Y2 Z2>
  texture { GlassX normal { bumps 0.3 scale 0.001 }}
  }

   cylinder {  //Trgriff
    <-0.85, 1.1, 0.06>,     // Center of one end
    <-0.70, 1.1, 0.06>,     // Center of other end
    0.0125            // Radius
    //open           // Remove end caps
    texture { Polished_Chrome3 }
  }

  cylinder {  //Trgriff
    <-0.85, 1.1, -0.1>,     // Center of one end
    <-0.70, 1.1, -0.1>,     // Center of other end
    0.0125           // Radius
    //open           // Remove end caps
    texture { Polished_Chrome3 }
  }
   cylinder {
    <-0.82, 1.1, 0.007>,     // Center of one end
    <-0.82, 1.1, 0.0475>,     // Center of other end
    0.0125            // Radius
    //open           // Remove end caps
    texture { Polished_Chrome3 }
  }
   cylinder {
    <-0.82, 1.1, -0.047>,     // Center of one end
    <-0.82, 1.1, -0.0875>,     // Center of other end
    0.0125            // Radius
    //open           // Remove end caps
    texture { Polished_Chrome3 }
  }

  box
{
  <-0.85, 0.96, 0>  // one corner position <X1 Y1 Z1>
  <-0.79, 1.135, 0.007>  // other corner position <X2 Y2 Z2>
  texture { Polished_Chrome3 }
  }

   box
{
  <-0.85, 0.96, -0.04>  // one corner position <X1 Y1 Z1>
  <-0.79, 1.135, -0.047>  // other corner position <X2 Y2 Z2>
  texture { Polished_Chrome3 }
  }

     box // Schluesselloch
{
  <-0.824, 0.99, -0.04>  // one corner position <X1 Y1 Z1>
  <-0.817, 1.015, -0.049>  // other corner position <X2 Y2 Z2>
  texture { pigment { color Black } finish { ambient 0 } }
  }

   rotate <0, 0, 0>
  translate <2, 0, 3.5>
}

// Beschriftung auf Tuere

#declare Beschriftung = object {
union {

 text { ttf "timrom.ttf" "Rick Moranis" 0.1, 0
  texture { pigment { color Black} finish { ambient 0.6 } }
  scale 0.1
  translate <-0.375,1.4,0.0> }

   text { ttf "timrom.ttf" "** PRIVATE INVESTIGATIONS **" 0.1, 0
  texture { pigment { color Black} finish { ambient 0.6 } }
  scale 0.04
  translate <-0.4,1.33,0.0> }}}

  object { Beschriftung scale 0.95 rotate <0,180,0> translate <1.455,0.29,3.49> }
  //object { Beschriftung scale 1 rotate <0,0,0> translate <0,0,0> }

//*** Die Bilder ***



 difference {  // Rahmen fr Bild1
 box
{
  <-0.08,-0.08,0>
  <1.28,0.98,-0.04>
}
box
{
  <0,0,0.01>
  <1.20,0.90,-0.05 >
}
texture { Brushed_Aluminum scale <0.08,0.25,0.25> }
scale 0.55
translate <0.29,1.41,3.5 >
}

box   // Bild1
{
  <0,0,0>
  <1,1,-0.005 >
texture {pigment {
image_map { tga "Bild.tga" map_type 0  interpolate 2} }finish { matt }}
scale <0.66,0.51,1.0>
translate <0.29,1.41,3.5 >
}

 /*difference {  // Rahmen fr Bild2
 box
{
  <-0.08,-0.08,0>
  <1.28,0.98,-0.04>
}
box
{
  <0,0,0.01>
  <1.20,0.90,-0.05 >
}
texture { Brushed_Aluminum }
scale 0.25
translate <0.25,1.12,3.5 >
}

box   // Bild2
{
  <0,0,0>
  <1,1,-0.005 >
texture {pigment {
image_map { tga "Bild.tga" map_type 0  interpolate 2} }finish { matt }}
scale <0.3,0.225,1.0>
translate <0.25,1.12,3.5 >
}*/

 difference {  // Rahmen Diplom
 box
{
  <-0.08,-0.08,0>
  <0.98,1.28,-0.04>
}
box
{
  <0,0,0.01>
  <0.90,1.20,-0.05 >
}
texture { T_Wood4 finish { matt_glaenzend2 }}
scale 0.3333333333
translate <-0.25,1.34,3.5 >
}

box   // Diplom
{
  <0,0,0>
  <1,1,-0.005 >
texture {pigment {
image_map { tga "Diploma.tga" map_type 0  interpolate 2} }finish { matt }}
scale <0.30,0.40,1.0>
translate <-0.25,1.34,3.5 >
}



// Die Uhr

#include "Uhr.inc"

object { gesamte_Uhr scale 0.019 rotate <0,0,0> translate <-0.75,1.8,3.46> }



// Der Ventilator


#declare Fluegel1 = object {
  box
  {
  <0.30, 0.0025, 0.05>
  <-0.30, -0.0025, -0.05>
  texture { Texture2 }
  }}

  #declare Fluegel2 = object {
  box
  {
  <0.05, 0.0025, 0.30>
  <-0.05, -0.0025, -0.30>
  texture { Texture2 }
  }}

#declare Ventilator = object {
union {
 cylinder {
    <0,0,0>,     // Center of one end
    <0,0.13,0>,     // Center of other end
    0.055            // Radius
    //open           // Remove end caps
    texture { Polished_Chrome }
  }

 cylinder {
    <0,0.025,0>,     // Center of one end
    <0,0.105,0>,     // Center of other end
    0.08            // Radius
    //open           // Remove end caps
    texture { T_Wood32 finish { matt_glaenzend2 } }
  }

cylinder {
    <0,0,0>,     // Center of one end
    <0,0.53,0>,     // Center of other end
    0.02           // Radius
    //open           // Remove end caps
    texture { T_Wood32 finish { matt_glaenzend2 } }
  }

 cylinder {
    <0,0.53,0>,     // Center of one end
    <0,0.55,0>,     // Center of other end
    0.10           // Radius
    //open           // Remove end caps
    texture { Texture2 }
  }

 cylinder {
    <-0.13,0.065,0>,     // Center of one end
    <0.13,0.065,0>,     // Center of other end
    0.01           // Radius
    //open           // Remove end caps
    texture { Polished_Chrome }
  }

  cylinder {
    <0,0.065,-0.13>,     // Center of one end
    <0,0.065,0.13>,     // Center of other end
    0.01           // Radius
    //open           // Remove end caps
    texture { Polished_Chrome }
  }


  object { Fluegel1 rotate <15,0,0> translate <-0.43,0.065,0>  }
  object { Fluegel1 rotate <-15,0,0> translate <0.43,0.065,0>  }
  object { Fluegel2 rotate <0,0,15> translate <0,0.065,-0.43>  }
  object { Fluegel2 rotate <0,0,-15> translate <0,0.065,0.43>  }
  }}

  object { Ventilator rotate <0,35,0> translate <0,2.02,2.20> }

  // Der Stuhl

  #include "Stuhl.inc"

  object { Stuhl rotate <0,-5,0> translate <-0.05,0,3.17> }
  object { Stuhl rotate <0,30,0> translate <0.3,0,1> }



  // Die Garderobe mit Hut

  #include "Hut.inc"

#declare Stange_Texture =
texture { Polished_Chrome }

#declare Strebe_Texture =
texture { Polished_Chrome }

#declare Kugel_Texture =
texture { Polished_Brass }




#declare Stange = object {
union {
cylinder {
    <0,0,0>,
    <0,1.58,0>,
    0.0125
    //open
    texture { Stange_Texture}}
sphere {
<0,1.58,0>, 0.0225
texture { Kugel_Texture }}}}

#declare Strebe1 = object {
union {
cylinder {
    <0.1,0,0>,
    <-0.1,0,0>,
    0.01
    //open
    texture { Strebe_Texture}}
sphere {
<0.1,0,0>, 0.02
texture { Kugel_Texture }}}}


#declare Strebe2 = object {
union {
cylinder {
    <0.05,0,0>,
    <-0.05,0,0>,
    0.01
    //open
    texture { Strebe_Texture}}
sphere {
<0.05,0,0>, 0.02
texture { Kugel_Texture }}}}

#declare Strebe3 = object {
union {
cylinder {
    <0,0.11635,0>,
    <0,-0.11635,0>,
    0.0125
    //open
    texture { Stange_Texture}}
sphere {
<0,-0.11635,0>, 0.0225
texture { Kugel_Texture }}}}

#declare Ring = object {
torus {
  0.04,0.0075
  texture { Stange_Texture }}}



#declare Garderobe = object {
union {
object { Stange translate <0.06,0.22,0> }
object { Stange translate <-0.06,0.22,0> }
object { Stange translate <0,0.22,0.06> }
object { Stange translate <0,0.22,-0.06> }

object { Strebe1 rotate <0,0,0> translate <0.16,1.67,0> }
object { Strebe1 rotate <0,180,0> translate <-0.16,1.67,0> }
object { Strebe1 rotate <0,90,0> translate <0,1.67,-0.16> }
object { Strebe1 rotate <0,-90,0> translate <0,1.67,0.16> }

object { Strebe2 rotate <0,0,0> translate <0.11,1.06,0> }
object { Strebe2 rotate <0,180,0> translate <-0.11,1.06,0> }
object { Strebe2 rotate <0,90,0> translate <0,1.06,-0.11> }
object { Strebe2 rotate <0,-90,0> translate <0,1.06,0.11> }

object { Strebe3 rotate <0,0,30> translate <0.115,0.13885,0> }
object { Strebe3 rotate <0,0,-30> translate <-0.115,0.13885,0> }
object { Strebe3 rotate <30,0,0> translate <0,0.13885,-0.115> }
object { Strebe3 rotate <-30,0,0> translate <0,0.13885,0.115> }

object { Ring translate <0,0.26,0> }
object { Ring translate <0,1.06,0> }
object { Ring translate <0,1.67,0> }

object { Hut scale 0.79 rotate <0,0,0> translate <0.34,0.34,-2.55> }


}}

object { Garderobe rotate <0,10,0> translate <0.56,-0.015,2.9> }


// Die Schreibtischlampe

#declare Lamp1_Texture =
texture { pigment { DMFWood3 } scale <3,0.01,0.01>
translate <0,0,0>
finish { Lamp_Finish }}

#declare Lamp2_Texture =
texture { pigment {
        agate
        turbulence 2
        color_map {
        [0.1  color rgb <0.286,0.333,0.494> ]
        [0.1  color rgb <0.286,0.678,0.620> ]
        }
        scale 0.05 }
    finish{ Lamp_Finish }}

#declare Lamp3_Texture =
texture { pigment {
        agate
        turbulence 2
        color_map {
        [0.1  color rgb <0.286,0.333,0.494> ]
        [0.1  color rgb <0.286,0.678,0.620> ]
        }
        scale 0.05 }
    finish{ Lamp_Finish2 }}

#declare Lamp4_Texture =
texture { pigment { color rgb <0.85,0.85,0.85> }
finish { glaenzend }}



#declare Schalter1_Texture =
texture { pigment { color rgb <1,0.5,0.5> }
finish { matt_glaenzend }}

#declare Schalter2_Texture =
texture { pigment { color rgb <1,1,0.85> }
finish { matt_glaenzend }}

  #declare Lampensockel = object {
    union {
    prism { //unten
    cubic_spline
    0, // sweep the following shape from here ...
    0.01, // ... up through here
    6, // the number of points making up the shape ...

    < 0.035, -0.07>, // point#1 (control point... not on curve)
    < 0.035,  0.07>, // point#2  ... THIS POINT ...
    <-0.07,  0>, // point#3
    < 0.035, -0.07>, // point#4
    < 0.035,  0.07>, // point#5 ... MUST MATCH THIS POINT
    <-0.07,  0>  // point#6 (control point... not on curve)

    texture { Lamp1_Texture }
    rotate <0,90,0> translate <0,0,0>
  }
   difference {
   prism { //oben
    cubic_spline
    0.01, // sweep the following shape from here ...
    0.06, // ... up through here
    6, // the number of points making up the shape ...

    < 0.035, -0.07>, // point#1 (control point... not on curve)
    < 0.035,  0.07>, // point#2  ... THIS POINT ...
    <-0.07,  0>, // point#3
    < 0.035, -0.07>, // point#4
    < 0.035,  0.07>, // point#5 ... MUST MATCH THIS POINT
    <-0.07,  0>  // point#6 (control point... not on curve)

    texture { Lamp2_Texture }
    rotate <0,90,0> translate <0,0,0> }

    box // Aussparung fuer Schalter
  {
  <0.02,0,0.0075>
  <-0.02,0.02,-0.0075>
  translate <-0.035,0.043,-0.025>
  }}

     prism { // Verzierung
    cubic_spline
    0.055, // sweep the following shape from here ...
    0.063, // ... up through here
    6, // the number of points making up the shape ...

    < 0.035, -0.07>, // point#1 (control point... not on curve)
    < 0.035,  0.07>, // point#2  ... THIS POINT ...
    <-0.07,  0>, // point#3
    < 0.035, -0.07>, // point#4
    < 0.035,  0.07>, // point#5 ... MUST MATCH THIS POINT
    <-0.07,  0>  // point#6 (control point... not on curve)

    texture { Lamp1_Texture }
    scale <0.6,1,0.3> rotate <0,-90,0> translate <0,0,0.03>}

superellipsoid //Schalter 1
{ < 0.15, 0.15 >
  scale <0.009,0.0075,0.0065>
  translate <-0.045,0.0615,-0.025>
  texture {Schalter1_Texture }
  }

superellipsoid //Schalter 2
{ < 0.15, 0.15 >
  scale <0.009,0.0075,0.0065>
  translate <-0.025,0.0615,-0.025>
  texture {Schalter2_Texture }
  }

 cylinder {
    <-0.01,0,0.05>,     // Center of one end
    <-0.01,0.08,0.05>,     // Center of other end
    0.009           // Radius
    //open           // Remove end caps
    texture { Stange_Texture }
  }

  cylinder {
    <0.01,0,0.05>,     // Center of one end
    <0.01,0.08,0.05>,     // Center of other end
    0.009           // Radius
    //open           // Remove end caps
    texture { Stange_Texture }
  }
  }}

  #declare Zylinder1 = object {
  union {
  cylinder {
    <0,0,0>,
    <0,0.29,0>,
    0.0045
    //open
    texture { Stange_Texture}}

sphere {
<0,0.24,0>, 0.01
texture { Kugel_Texture }}

sphere {
<0,0.29,0>, 0.01
texture { Kugel_Texture }}translate <0,0.06,0>}}

 #declare Zylinder2 = object {
  union {
  cylinder {
    <0,0,0.06>,
    <0,0,-0.06>,
    0.0045
    //open
    texture { Stange_Texture}}

sphere {
<0,0,0.06>, 0.01
texture { Kugel_Texture }} rotate <15,0,0> translate <0,0,0>}}

#declare Lampenschirm = object {
difference {
sphere {
<0,0,0>, 0.5
texture { Lamp3_Texture }}
sphere {
<0,0,0>, 0.497
texture { Lamp4_Texture }}
box
  {
  <2,0.1,2>
  <-2,-2,-2>
  }}
scale <0.32,0.12,0.08>
rotate <15,0,0> translate <0,0,0>}

#declare Gluehbirne = object {

sphere { <0,0,0 >, 0.5 texture { Gluehbirne_Tex }
scale <0.06,0.03,0.03> }}

   #declare Birne1 = object {
   light_source { <-0.06,0.324,-0.05> color rgb <0.9,0.9,0.9>
   atmosphere off
   fade_distance 0.4
   fade_power 3
   looks_like { Gluehbirne }}}

   #declare Birne2 = object {
   light_source { <0.06,0.324,-0.05> color rgb <0.9,0.9,0.9>
   atmosphere off
   fade_distance 0.4
   fade_power 3
   looks_like { Gluehbirne }}}






  #declare Lampe = object {
  union {
  object { Lampensockel }
  object { Zylinder1 translate <-0.01,0,0.05> }
  object { Zylinder1 translate <0.01,0,0.05> }
  object { Zylinder2 translate <-0.01,0.302,0.04> }
  object { Zylinder2 translate <0.01,0.302,0.04> }
  object { Lampenschirm translate <0,0.304,-0.055> }
  object { Birne1 }
  object { Birne2 }
  }}

  object { Lampe rotate <0,-16,0> translate <-0.30,0.80,0.30> }

// Lampe auf Aktenschrank

#declare Lampenschirm2 = object {
union {
difference {
cone
{
 <0,0.1,0>, 0.075,
 <0,0.24,0>, 0.040
 texture { pigment { color rgbt <1,0.5,0.25,0.38> } finish { matt_rauh_ambient } }
 }
cone
{
 <0,0.09,0>, 0.0745,
 <0,0.237,0>, 0.03775
 texture { pigment { color rgbt <1,0.5,0.25,0.38> } finish { matt_rauh_ambient } }
 }}

 /*cylinder { // Abdeckung Lampenschirm
    <0,0.237,0>,
    <0,0.24,0>,
    0.0365
    //open
  texture { pigment { color rgbt <1,0.5,0.25,0.38> } finish { matt_rauh_ambient } }}*/

 cylinder { //Fuss
    <0,0,0>,
    <0,0.015,0>,
    0.06
    //open
    texture { Polished_Chrome3 }}

    cylinder { //Fuss
    <0,0.015,0>,
    <0,0.12,0>,
    0.01
    //open
    texture { Polished_Chrome3 }}
 }}


   #declare Birne3 = object {
   light_source { <0,0.155,0> color rgb <0.9,0.9,0.9>
   atmosphere off
   fade_distance 0.8
   fade_power 3 }}

   #declare Lampe2 = object {
   union {
   object { Lampenschirm2 }
   object { Birne3 }
   }}

   object { Lampe2 translate <-0.57,1.416,3> }






 // ***Ende weitere Raumobjekte






// Der Aktenschrank

#declare Schrank = object {
union {
 box // Sockel
{
  <-0.55, 0.0, -0.03>
  < 0.55,  0.074,  0.55>
  texture { T_Wood4 finish { matt_glaenzend }}}

 difference {
   box // aussen
{
  <-0.55, 0.074, 0.0>
  < 0.55,  1.416,  0.55>
  texture { T_Wood4 finish { matt_glaenzend }}}


     box // innen
{
  <-0.525, 0.099, -0.01>
  < 0.525,  1.381,  0.525>
  texture { T_Wood4 finish { matt_glaenzend }}}}}}


  #declare Schublade_voll = object {

 union {

  difference {
  box // Schublade aussen
{
  <-0.519, 0.111, 0.0>
  <-0.003, 0.52633333,  0.519>
  texture { T_Wood4 finish { matt_glaenzend }}}


    box // Schublade innen
{
  <-0.509, 0.121, 0.01>
  <-0.013, 0.53633333,  0.509>
  texture { T_Wood4 finish { matt_glaenzend }}}}

  difference { // Ordner1
  box
{
  <-0.493, 0.5, 0.02>
  <-0.413, 0.495,  0.34>
  texture { pigment { color rgb <0.37,0.37,0.37> }
  finish { matt }}}

cylinder //Loch
{
  <-0.453,0.49,0.105>
  <-0.453,0.55,0.105>, 0.014 }}

  box // Etikett
{
  <-0.483, 0.502, 0.135>
  <-0.423, 0.495,  0.325>
  texture { pigment { color rgb <0.97,0.97,0.97> }
  finish { matt }}}

    difference { // Ordner2
  box
{
  <-0.397, 0.5, 0.02>
  <-0.317, 0.495,  0.34>
  texture { pigment { color rgb <0.37,0.37,0.37> }
  finish { matt }}}

cylinder //Loch
{
  <-0.357,0.49,0.105>
  <-0.357,0.55,0.105>, 0.014 }}

  box // Etikett
{
  <-0.387, 0.502, 0.135>
  <-0.327, 0.495,  0.325>
  texture { pigment { color rgb <0.97,0.97,0.97> }
  finish { matt }}}

  difference { // Ordner3
  box
{
  <-0.301, 0.5, 0.02>
  <-0.221, 0.495,  0.34>
  texture { pigment { color rgb <0.37,0.37,0.37> }
  finish { matt }}}

cylinder //Loch
{
  <-0.261,0.49,0.105>
  <-0.261,0.55,0.105>, 0.014 }}

  box // Etikett
{
  <-0.291, 0.502, 0.135>
  <-0.231, 0.495,  0.325>
  texture { pigment { color rgb <0.97,0.97,0.97> }
  finish { matt }}}

  difference { // Ordner4
  box
{
  <-0.205, 0.5, 0.02>
  <-0.125, 0.495,  0.34>
  texture { pigment { color rgb <0.37,0.37,0.37> }
  finish { matt }}}

cylinder //Loch
{
  <-0.165,0.49,0.105>
  <-0.165,0.55,0.105>, 0.014 }}

  box // Etikett
{
  <-0.195, 0.502, 0.135>
  <-0.135, 0.495,  0.325>
  texture { pigment { color rgb <0.97,0.97,0.97> }
  finish { matt }}}

  difference { // Ordner5
  box
{
  <-0.109, 0.5, 0.02>
  <-0.029, 0.495,  0.34>
  texture { pigment { color rgb <0.37,0.37,0.37> }
  finish { matt }}}

cylinder //Loch
{
  <-0.069,0.49,0.105>
  <-0.069,0.55,0.105>, 0.014 }}

  box // Etikett
{
  <-0.099, 0.502, 0.135>
  <-0.039, 0.495,  0.325>
  texture { pigment { color rgb <0.97,0.97,0.97> }
  finish { matt }}}


     box // Umrahmung Schild
{
  <-0.308, 0.263, -0.01>
  <-0.214, 0.327,  0.008>
  texture { Special }}

  torus { // Handgriff
  0.042,0.0062
  scale <1.2,1.2,0.8>
  translate <-0.261,0.357,-0.008>
  texture { Texture2 }}


    box // Aufsatz
{
  <-0.499, 0.131, -0.008>
  <-0.023, 0.50633333,  0.008>
  texture { DMFWood6_mod scale <3,0.08,0.08> }}}}


 #declare Schublade_leer = object {

 union {

  difference {
  box // Schublade aussen
{
  <-0.519, 0.111, 0.0>
  <-0.003, 0.52633333,  0.519>
  texture { T_Wood4 finish { matt_glaenzend }}}


    box // Schublade innen
{
  <-0.509, 0.121, 0.01>
  <-0.013, 0.53633333,  0.509>
  texture { T_Wood4 finish { matt_glaenzend }}}}

       box // Umrahmung Schild
{
  <-0.308, 0.263, -0.01>
  <-0.214, 0.327,  0.008>
  texture { Special }}

  torus { // Handgriff
  0.042,0.0062
  scale <1.2,1.2,0.8>
  translate <-0.261,0.357,-0.008>
  texture { Texture2 }}


    box // Aufsatz
{
  <-0.499, 0.131, -0.008>
  <-0.023, 0.50633333,  0.008>
  texture { DMFWood6_mod scale <3,0.08,0.08> }}}}




#declare SchildAE = object {

 box
{
  <0, 0, -0.012>
  <1, 1,  0.008>
 texture { pigment {
image_map { tga "A_E.tga" map_type 0  interpolate 2  }}finish { sehr_matt }}
scale <0.08,0.05,1.0>
translate <-0.301,0.27,0 >
}}

#declare SchildFK = object {

 box
{
  <0, 0, -0.012>
  <1, 1,  0.008>
 texture { pigment {
image_map { tga "F_K.tga" map_type 0  interpolate 2  }}finish { sehr_matt }}
scale <0.08,0.05,1.0>
translate <-0.301,0.27,0 >
}}

#declare SchildLO = object {

 box
{
  <0, 0, -0.012>
  <1, 1,  0.008>
 texture { pigment {
image_map { tga "L_O.tga" map_type 0  interpolate 2  }}finish { sehr_matt }}
scale <0.08,0.05,1.0>
translate <-0.301,0.27,0 >
}}

#declare SchildPS = object {

 box
{
  <0, 0, -0.012>
  <1, 1,  0.008>
 texture { pigment {
image_map { tga "P_S.tga" map_type 0  interpolate 2  }}finish { sehr_matt }}
scale <0.08,0.05,1.0>
translate <-0.301,0.27,0 >
}}

#declare SchildTW = object {

 box
{
  <0, 0, -0.012>
  <1, 1,  0.008>
 texture { pigment {
image_map { tga "T_W.tga" map_type 0  interpolate 2  }}finish { sehr_matt }}
scale <0.08,0.05,1.0>
translate <-0.301,0.27,0 >
}}

#declare SchildXZ = object {

 box
{
  <0, 0, -0.012>
  <1, 1,  0.008>
 texture { pigment {
image_map { tga "X_Z.tga" map_type 0  interpolate 2  }}finish { sehr_matt }}
scale <0.08,0.05,1.0>
translate <-0.301,0.27,0 >
}}


  #declare Aktenschrank = object {
 union {
  object { Schrank }
  object { SchildTW translate <0,0,0> } //unten links
  object { SchildXZ translate <0.522,0,-0.35> } //unten rechts
  object { SchildLO translate <0,0.4273333,0> } //mitte links
  object { SchildPS translate <0.522,0.4273333,0> } //mitte rechts
  object { SchildAE translate <0,0.8486666,0> } //oben links
  object { SchildFK translate <0.522,0.8486666,0> } //oben rechts

  object { Schublade_leer translate <0,0,0> } //unten links
  object { Schublade_voll translate <0.522,0,-0.35> } //unten rechts
  object { Schublade_leer translate <0,0.4273333,0> } //mitte links
  object { Schublade_leer translate <0.522,0.4273333,0> } //mitte rechts
  object { Schublade_leer translate <0,0.8486666,0> } //oben links
  object { Schublade_leer translate <0.522,0.8486666,0> } //oben rechts
  }}

 object { Aktenschrank rotate <0,0,0> translate <-1,0,2.93> }


// Ende Aktenschrank

// Der ungebetene Besucher

#include "Human.inc"

object { Human scale 1 rotate <0,16,0> translate <0.65,0,4.5> }


// Die Strassenlaterne

#declare Licht = object {
cone
{
 <0,0,0>, 0.15,
 <0,0.6,0>, 0.23
 texture { Gluehbirne_Tex2 }
 }}

 #declare Deckel = object {

cylinder
{
  <0,0.6,0>,
  <0,0.63,0>,
  0.35
  texture { Polished_Chrome }
}}

#declare Pfahl = object {

cylinder
{
  <0,0,0>,
  <0,-2,0>,
  0.065
  texture { pigment { color rgb <0.6,0.6,0.6> } finish { matt_ref2 } }
}}

#declare Nebel = object {
box {
     <5,50,50>
     <-50,-50,-50>
    pigment { color rgbt <1, 1, 1, 1> }
    halo {
      dust
      dust_type 2
      box_mapping
      constant
      color_map {
       [ 0 color rgbt <0.86,0.86,0.86, 1> ]
       [ 1 color rgbt <0.86,0.86,0.86, 0.6> ]
      }
      samples 50
      aa_level 3
      aa_threshold 0.2
      jitter 0.1
      }
    hollow}}


   #declare Laterne = object {
   light_source { <0,0,0> color rgb <0.7,0.7,0.7>
   atmosphere off
   fade_distance 0.8
   fade_power 2
   looks_like { Licht }}}


   #declare Strassenlaterne = object {
   union {
   object { Laterne }
   object {Deckel }
   object { Pfahl }
   }}



   object { Strassenlaterne scale 0.85 translate <-8.35,0,12> }
   object { Strassenlaterne scale 0.85 translate <-10.5,0,17> }

   object { Nebel  translate <-8.35,0,12> }



























