/*


camera {direction <0,0,6> location <60,40, -80> look_at <0, 5, 0>}

light_source {
    <3000,1000,1000>
    color rgb <1.3,1.3,1.25>
    //area_light <0,1000,0>, <1000,0,0>,6, 6
    //adaptive 2
    spotlight
    point_at 0
    radius 50
    falloff 75

  } 
light_source {
    <-2000,2000,-2000>
    color rgb <1.3,1.3,1.25>*2
    //area_light <0,1000,0>, <1000,0,0>,6, 6
    //adaptive 2
    spotlight
    point_at 0
    radius 50
    falloff 75

  }  
*/
#declare BeakTex =
texture {
pigment {bozo
color_map {
[0 rgb <1,.475,0>*.75]
[1 rgb <1,.45,0>*.55]
}
}
normal {bumps bump_size .05}
finish {ambient .1 diffuse .5 phong .25 phong_size 5}
scale 5
}

#declare FeatherTex2 =
texture {
pigment {rgb <.5,.125,.125>*.5
}
normal {bumps bump_size .125}
finish {ambient .2 diffuse .25 phong .25}
scale 2
}
#declare FeatherTex =
texture {
pigment {gradient x
color_map {
[0 rgb <.75,.375,.1>*.75]
[1 rgb 0]
}
}
normal {bumps bump_size .125}
finish {ambient .1 diffuse .375 phong .25}
scale 2
}
#declare ChickenTex =
texture {
pigment {leopard
color_map {
[0 rgb <.75,.375,.1>*.75]
[.1 rgb <.75,.4,.1>]
[.15 rgb <.75,.425,.1>]
[1 rgb <.75,.45,.1>]
}
turbulence 1
scale <.5,2,.5>              
}
normal {bumps bump_size .25}
finish {ambient .2 diffuse .5}
scale .875
}
#declare ChickenTexB =
texture {
pigment { gradient y
pigment_map {
[0 leopard
color_map {
[0 rgb <.75,.375,.1>*.75]
[.1 rgb <.75,.4,.1>]
[.15 rgb <.75,.425,.1>]
[1 rgb <.75,.45,.1>]
}
turbulence 1
scale <.5,2,.5>]              
[1 leopard
color_map {
[0 rgb <.75,0,0>*.25]
[.15 rgb <.75,.25,0>*.5]
[.2 rgb <.75,.25,0>*.5]
[1 rgb <.75,.25,0>*.5]
} 
turbulence 1
scale <.45,1.5,.45>]
}
}
normal {bumps bump_size .25}
finish {ambient .2 diffuse .5}
scale .875
}
 
#declare ChickenTex1 =
texture {
pigment {leopard
color_map {
[0 rgb <.75,.45,.1>*.25]
[.15 rgb <.75,.45,.1>*.5]
[.2 rgb <.75,.45,.1>*.5]
[1 rgb <.75,.45,.1>*.5]
} 
turbulence 1
scale <.45,1.5,.45>               
}
normal {bumps bump_size .25}
finish {ambient .2 diffuse .5}
scale .875
}
#declare ChickenTex2 =
texture {
pigment {rgb <249,178,114>/255*.75}
normal {bumps bump_size .5}
finish {ambient .2 diffuse .5}
}
 
#declare LegTex =
texture {
pigment {gradient y triangle_wave
color_map {
[0 rgb <.75,.5,.1>*.25]
[1 rgb <.75,.55,.15>*.75]
}
}
normal {bumps bump_size .25}
finish {ambient .2 diffuse .5 phong .125}
scale 2
}


#declare Foot =
union {
blob {
threshold .01

               sphere { < 0, 0, 0 >, 1, .05
               scale 1.5
               scale < 1.25, 1.25, 1.25 >
               rotate < 0, 22.5, 0 >
               translate < -0.01903, 0, -0.095671 >
               texture {LegTex scale 1}
            }
            //  type: Sphere
            // Name: legs
            
               sphere { < 0, 0, 0 >, 1, .05
               scale 1.5
               scale < 1.25, 1.25, 1.25 >
               rotate < 0, 22.5, 0 >
               translate < -0.40171, -2.5, -1.0196 >
               texture {LegTex scale 1}
            }
            //  type: Sphere
            // Name: legs
            
               sphere { < 0, 0, 0 >, 1, .05
               scale 1.5
               scale < 1.25, 1.25, 1.25 >
               rotate < 0, 22.5, 0 >
               translate < -0.7844, -5, -1.9434 >
               texture {LegTex scale 1}
            }
            //  type: Sphere
            // Name: NoName
            
               sphere { < 0, 0, 0 >, 1, .05
               scale 1.5
               scale < 2, 2, 2 >
               rotate < 0, 22.5, 0 >
               translate < -1.3584, -7.5, -3.3292 >
               texture {LegTex scale 2 rotate 90*x}
            }
            //  type: Sphere
            // Name: NoName
            
               sphere { < 0, 0, 0 >, 1, .05
               scale 1.5
               rotate < 0, 22.5, 0 >
               translate < -0.59306, -8.5, -1.4815 >
               texture {LegTex scale 2 rotate 90*x}
            }
            //  type: Sphere
            // Name: NoName
            
               sphere { < 0, 0, 0 >, 1, .05
               scale 1.5
               rotate < 0, 22.5, 0 >
               translate < 0.076641, -8.5, 0.1353 >
               texture {LegTex scale 2 rotate 90*x}
            }
            //  type: Sphere
            // Name: NoName
            
               sphere { < 0, 0, 0 >, 1, .05
               scale 1.5
               scale < 1.25, 1.25, 1.25 >
               rotate < 0, 22.5, 0 >
               translate < 0.74634, -8.25, 1.7521 >
               texture {LegTex scale 2 rotate 90*x}
            }
            //  type: Sphere
            // Name: NoName
            
               sphere { < 0, 0, 0 >, 1, .05
               scale 1.5
               rotate < 0, 22.5, 0 >
               translate < 1.416, -8.5, 3.3689 >
               texture {LegTex scale 2 rotate 90*x}
            }
            //  type: Sphere
            // Name: NoName
            
               sphere { < 0, 0, 0 >, 1, .05
               scale 1.5
               scale < 1.25, 1.25, 1.25 >
               rotate < 0, 22.5, 0 >
               translate < -2.2195, -8.25, -5.408 >
               texture {LegTex scale 2 rotate 90*x}
            }
            //  type: Sphere
            // Name: NoName
            
               sphere { < 0, 0, 0 >, 1, .05
               scale 1.5
               scale < 1.5, 1.5, 1.5 >
               rotate < 0, 22.5, 0 >
               translate < -3.1762, -8, -7.7177 >
               texture {LegTex scale 2 rotate 90*x}
            }
            //  type: Sphere
            // Name: NoName
            
               sphere { < 0, 0, 0 >, 1, .05
               scale 1.5
               scale < 1.75, 1.75, 1.75 >
               rotate < 0, 22.5, 0 >
               translate < -4.3242, -7.75, -10.489 >
               texture {LegTex scale 2 rotate 90*x}
            }
            //  type: Sphere
            // Name: NoName
            
               sphere { < 0, 0, 0 >, 1, .05
               scale 1.5
               scale < 2, 2, 2 >
               rotate < 0, 22.5, 0 >
               translate < -5.5679, -7.5, -13.492 >
               texture {LegTex scale 2 rotate 90*x}
            }
            //  type: Sphere
            // Name: NoName
            
               sphere { < 0, 0, 0 >, 1, .05
               scale 1.5
               scale < 0.9375, 0.9375, 1.25 >
               rotate < 0, 67.5, 0 >
               translate < -3.2622, -8.5625, -3.3525 >
               texture {LegTex scale 2 rotate 90*x}
            }
            //  type: Sphere
            // Name: NoName
            
               sphere { < 0, 0, 0 >, 1, .05
               scale 1.5
               scale < 1.125, 1.125, 1.5 >
               rotate < 0, 67.5, 0 >
               translate < -5.5719, -8.375, -4.3092 >
               texture {LegTex scale 2 rotate 90*x}
            }
            //  type: Sphere
            // Name: NoName
            
               sphere { < 0, 0, 0 >, 1, .05
               scale 1.5
               scale < 1.3125, 1.3125, 1.75 >
               rotate < 0, 67.5, 0 >
               translate < -8.3436, -8.1875, -5.4572 >
               texture {LegTex scale 2 rotate 90*x}
            }
            //  type: Sphere
            // Name: NoName
            
               sphere { < 0, 0, 0 >, 1, .05
               scale 1.5
               scale < 1.5, 1.5, 2 >
               rotate < 0, 67.5, 0 >
               translate < -11.346, -8, -6.7009 >
               texture {LegTex scale 2 rotate 90*x}
            }
            //  type: Sphere
            // Name: NoName
            
               sphere { < 0, 0, 0 >, 1, .05
               scale 1.5
               scale < 0.9375, 0.9375, 1.25 >
               rotate < 0, -22.5, 0 >
               translate < -0.25962, -8.5625, -4.5962 >
               texture {LegTex scale 2 rotate 90*x}
            }
            //  type: Sphere
            // Name: NoName
            
               sphere { < 0, 0, 0 >, 1, .05
               scale 1.5
               scale < 1.125, 1.125, 1.5 >
               rotate < 0, -22.5, 0 >
               translate < 0.69709, -8.375, -6.9059 >
               texture {LegTex scale 2 rotate 90*x}
            }
            //  type: Sphere
            // Name: NoName
            
               sphere { < 0, 0, 0 >, 1, .05
               scale 1.5
               scale < 1.3125, 1.3125, 1.75 >
               rotate < 0, -22.5, 0 >
               translate < 1.8451, -8.1875, -9.6775 >
               texture {LegTex scale 2 rotate 90*x}
            }
            //  type: Sphere
            // Name: NoName
            
               sphere { < 0, 0, 0 >, 1, .05
               scale 1.5
               scale < 1.5, 1.5, 2 >
               rotate < 0, -22.5, 0 >
               translate < 3.0889, -8, -12.68 >
               texture {LegTex scale 2 rotate 90*x}
            }
         sphere { < 0, 0, 0 >, 1, -.01  

         translate < -6.301, -7.5, -15.75 >
      }
         sphere { < 0, 0, 0 >, 1, -.01  

         translate < -13.5, -8, -7.5611 >
      }
         sphere { < 0, 0, 0 >, 1, -.01  

         translate < 4, -8, -14.5 >
      }
         sphere { < 0, 0, 0 >, 1, -.01 

         scale < 0.5, 0.5, 0.5 >
         translate < 1.75, -8.5, 4.25 >
      }
      texture {LegTex scale 2 rotate 90*x}
            
     }
     // Object type: Cone
      // Name: NoName
      object
      {
         cone { < 0, 0, 0 >, 1, < 0, 1, 0 >, 0 open }

         scale < 0.675, 4, 0.675 >
         rotate < -121.67, 18.357, -10.995 >
         translate < -6, -7, -14.75 >
      }
      // Object type: Cone
      // Name: NoName
      object
      {
         cone { < 0, 0, 0 >, 1, < 0, 1, 0 >, 0 open }

         scale < 0.5, 3.5, 0.5 >
         rotate < -144.16, 40.163, -29.017 >
         translate < -12.5, -7.75, -7 >
      }
      // Object type: Cone
      // Name: NoName
      object
      {
         cone { < 0, 0, 0 >, 1, < 0, 1, 0 >, 0 open }

         scale < 0.5, 3.5, 0.5 >
         rotate < -112.26, -23.199, 8.5377e-07 >
         translate < 3.75, -7.75, -13.75 >
      }
      // Object type: Cone
      // Name: NoName
      object
      {
         cone { < 0, 0, 0 >, 1, < 0, 1, 0 >, 0 open }

         scale < 0.25, 2.5, 0.25 >
         rotate < 63.944, 15.686, -97.53 >
         translate < 1.5, -8.5, 3.75 >
      }
      pigment {rgb .05}
      finish {ambient 0 diffuse .5 phong 1}
     }

#declare Body =
union{
// Object type: World
// Name: Root
object
{
   union
   {
   blob {
   threshold .01
      // Object type: Sphere
      // Name: Breast
         sphere { < 0, 0, 0 >, 1, .01 
         scale 1.75
         scale < 13, 20, 14.558 >
         rotate < -61, 0, 0 >
         translate < 0, 8.75, -7.5 >
         texture {ChickenTexB scale <1,1.5,1>
         scale < 13, 20, 14.558 >
         rotate < -61, 0, 0 >
         translate < 0, 8.75, -7.5 >
         }
      }
      // Object type: Sphere
      // Name: Back
         sphere { < 0, 0, 0 >, 1, .01
         scale 1.75
         scale < 13, 20, 14.558 >
         rotate < -62, 0, 0 >
         translate < 0, 8, -1 >
      }
      // Object type: Sphere
      // Name: Filler between legs
         sphere { < 0, 0, 0 >, 1, .01 
         scale 1.75
         scale < 13, 15, 14.558 >
         translate < 0, 7, 0 >
      }
      // Object type: Sphere
      // Name: Tail
         sphere { < 0, 0, 0 >, 1, .02 
         scale 1.75
         scale < 8, 22, 8.8318 >
         rotate < -130, 0, 0 >
         translate < 0, 10, 12 >
         texture {ChickenTex2}
      }
      // Object type: Sphere
      // Name: Tail bump
         sphere { < 0, 0, 0 >, 1, .01 
         scale .75
         scale < 2, 2, 2 >
         translate < 0, 24, 25 >
         texture {ChickenTex2}
      }
      // Object type: Sphere
      // Name: Neck extension
         sphere { < 0, 0, 0 >, 1, .01 
         scale 1.75
         scale < 10, 20, 10.44 >
         rotate < -60, 0, 0 >
         translate < 0, 10, -11.5 >
         texture {ChickenTex1}
      }
      // Object type: Sphere
      // Name: Leg
         sphere { < 0, 0, 0 >, 1, .125 
         scale 1.25
         scale < 5, 13, 8 >
         rotate < -5.1981, 0, 7.3147 >
         translate < 8, -2, 3 >
         texture {ChickenTex scale .75 rotate 90*x}
      }
      // Object type: Sphere
      // Name: Leg
         sphere { < 0, 0, 0 >, 1, .125
         scale 1.25
         scale < 5, 13, 8 >
         rotate < -5.198, 0, -7.315 >
         translate < -8, -2, 3 >
         texture {ChickenTex scale .75 rotate 90*x}
      }
      // Object type: Sphere
      // Name: Wing flab 1
         sphere { < 0, 0, 0 >, 1, .05 
         scale 1.375
         scale < 2.5492, 7.12, 7.065 >
         rotate < 0, 0, 10.491 >
         translate < 12, 13, -4.5 >
         texture {ChickenTex1 rotate 90*x} 
         scale <-1,1,1>
      }
      // Object type: Sphere
      // Name: Wing flab 2
         sphere { < 0, 0, 0 >, 1, .05
         scale 1.375
         scale < 1.3236, 5.3842, 6.0026 >
         rotate < 0, 0, 20.691 >
         translate < 14, 14, -4 >
         texture {ChickenTex1 rotate 90*x}
         scale <-1,1,1>
      }
      //Wing 1
       // Object type: Sphere
            // Name: Wing part 1
               sphere { < 0, 0, 0 >, 1,.125
               scale 1.25
               scale < 9, 0.75, 3 >
               rotate < -1.7075e-06, -43.238, -53.873 >
               translate < 15.395, 14.46, -2.6613 >
               texture {FeatherTex rotate 90*x scale .5}
               scale <-1,1,1>
            }
            // Object type: Sphere
            // Name: Wing part 2
               sphere { < 0, 0, 0 >, 1,.125
               scale 1.25
               scale < 15.75, 0.75, 3.75 >
               rotate < -1.2074e-06, -26.848, -53.873 >
               translate < 19.939, 8.2339, -1.2816 >
               texture {FeatherTex rotate 90*x scale .5}
               scale <-1,1,1>
            }
            // Object type: Sphere
            // Name: feather
               sphere { < 0, 0, 0 >, 1,1
               texture {FeatherTex}
               scale < 1.1074, 0.075, 8.2585 >
               rotate < 8.5377e-07, -24.432, -53.873 >
               translate < 23.66, 3.1361, 11.16 >
               scale <-1,1,1>
            }
            // Object type: Sphere
            // Name: feather
               sphere { < 0, 0, 0 >, 1,1
               texture {FeatherTex}
               scale < 1.4944, 0.075, 10.152 >
               rotate < 1.7075e-06, -31.812, -53.873 >
               translate < 14.781, 15.3, 4.3773 >
               scale <-1,1,1>
            }
            // Object type: Sphere
            // Name: feather
               sphere { < 0, 0, 0 >, 1,1
               texture {FeatherTex}
               scale < 1.8897, 0.075, 10.132 >
               rotate < 1.4788e-06, -27.909, -53.873 >
               translate < 21.088, 6.6593, 11.474 >
               scale <-1,1,1>
            }
            // Object type: Sphere
            // Name: feather
               sphere { < 0, 0, 0 >, 1,1
               texture {FeatherTex}
               scale < 1.8897, 0.075, 10.5 >
               rotate < 8.5377e-07, -26.941, -53.873 >
               translate < 18.621, 10.039, 9.7761 >
               scale <-1,1,1>
            }
            // Object type: Sphere
            // Name: feather
               sphere { < 0, 0, 0 >, 1,1
               texture {FeatherTex}
               scale < 1.8897, 0.075, 11.272 >
               rotate < 8.5377e-07, -29.374, -53.873 >
               translate < 16.354, 13.145, 7.4092 >
               scale <-1,1,1>
            }
            // Object type: Sphere
            // Name: feather
               sphere { < 0, 0, 0 >, 1,1
               texture {FeatherTex}
               scale < 1.5, 0.075, 7.5333 >
               rotate < 8.5377e-07, -29.374, -53.873 >
               translate < 21.353, 7.2511, 8.7889 >
               scale <-1,1,1>
            }
            // Object type: Sphere
            // Name: feather
               sphere { < 0, 0, 0 >, 1,1
               texture {FeatherTex}
               scale < 1.5, 0.075, 7.5333 >
               rotate < 1.7075e-06, -25.843, -53.873 >
               translate < 23.174, 4.4381, 10.482 >
               scale <-1,1,1>
            }
            // Object type: Sphere
            // Name: feather
               sphere { < 0, 0, 0 >, 1 ,1
               texture {FeatherTex}
               scale < 1.5, 0.075, 6.75 >
               rotate < 0, -23.034, -53.873 >
               translate < 25.197, 1.3482, 10.668 >
               scale <-1,1,1>
            }
      // Object type: Sphere
      // Name: Wing flab 1
         sphere { < 0, 0, 0 >, 1, .05 
         scale 1.375
         scale < 2.5492, 7.12, 7.065 >
         rotate < 0, 0, 10.491 >
         translate < 12, 13, -4.5 >
         texture {FeatherTex rotate 90*x scale .5}
      }
      // Object type: Sphere
      // Name: Wing flab 2
         sphere { < 0, 0, 0 >, 1, .05
         scale 1.375
         scale < 1.3236, 5.3842, 6.0026 >
         rotate < 0, 0, 20.691 >
         translate < 14, 14, -4 >
         texture {FeatherTex rotate 90*x scale .5}
      }
      //Wing 1
       // Object type: Sphere
            // Name: Wing part 1
               sphere { < 0, 0, 0 >, 1,.125
               scale 1.25
               scale < 9, 0.75, 3 >
               rotate < -1.7075e-06, -43.238, -53.873 >
               translate < 15.395, 14.46, -2.6613 >
               texture {ChickenTex1 rotate 90*x}
            }
            // Object type: Sphere
            // Name: Wing part 2
               sphere { < 0, 0, 0 >, 1,.125
               scale 1.25
               scale < 15.75, 0.75, 3.75 >
               rotate < -1.2074e-06, -26.848, -53.873 >
               translate < 19.939, 8.2339, -1.2816 >
               texture {ChickenTex1 rotate 90*x}
            }
            // Object type: Sphere
            // Name: feather
               sphere { < 0, 0, 0 >, 1,1
               texture {FeatherTex}
               scale < 1.1074, 0.075, 8.2585 >
               rotate < 8.5377e-07, -24.432, -53.873 >
               translate < 23.66, 3.1361, 11.16 >
            }
            // Object type: Sphere
            // Name: feather
               sphere { < 0, 0, 0 >, 1,1
               texture {FeatherTex}
               scale < 1.4944, 0.075, 10.152 >
               rotate < 1.7075e-06, -31.812, -53.873 >
               translate < 14.781, 15.3, 4.3773 >
            }
            // Object type: Sphere
            // Name: feather
               sphere { < 0, 0, 0 >, 1,1
               texture {FeatherTex}
               scale < 1.8897, 0.075, 10.132 >
               rotate < 1.4788e-06, -27.909, -53.873 >
               translate < 21.088, 6.6593, 11.474 >
            }
            // Object type: Sphere
            // Name: feather
               sphere { < 0, 0, 0 >, 1,1
               texture {FeatherTex}
               scale < 1.8897, 0.075, 10.5 >
               rotate < 8.5377e-07, -26.941, -53.873 >
               translate < 18.621, 10.039, 9.7761 >
            }
            // Object type: Sphere
            // Name: feather
               sphere { < 0, 0, 0 >, 1,1
               texture {FeatherTex}
               scale < 1.8897, 0.075, 11.272 >
               rotate < 8.5377e-07, -29.374, -53.873 >
               translate < 16.354, 13.145, 7.4092 >
            }
            // Object type: Sphere
            // Name: feather
               sphere { < 0, 0, 0 >, 1,1
               texture {FeatherTex}
               scale < 1.5, 0.075, 7.5333 >
               rotate < 8.5377e-07, -29.374, -53.873 >
               translate < 21.353, 7.2511, 8.7889 >
            }
            // Object type: Sphere
            // Name: feather
               sphere { < 0, 0, 0 >, 1,1
               texture {FeatherTex}
               scale < 1.5, 0.075, 7.5333 >
               rotate < 1.7075e-06, -25.843, -53.873 >
               translate < 23.174, 4.4381, 10.482 >
            }
            // Object type: Sphere
            // Name: feather
               sphere { < 0, 0, 0 >, 1 ,1
               texture {FeatherTex}
               scale < 1.5, 0.075, 6.75 >
               rotate < 0, -23.034, -53.873 >
               translate < 25.197, 1.3482, 10.668 >
            }

sturm

      
      
     }
   }

   texture {ChickenTex}
//rotate 180*y
}

//Neck Feathers
      object
      {
         union
         {
// Object type: BiCubic Bezier Patch
            // Name: NoName
            object
            {
               bicubic_patch
               {
                  type 1
                  flatness 0.05
                  u_steps 4
                  v_steps 4
                  < -10.283, 10.962, -19.221 >, < -10.283, 10.962, -19.221 >, < -10.283, 10.962, -19.221 >, < -10.283, 10.962, -19.221 >, 
                  < -9.2871, 18.269, -28.869 >, < -8.9983, 20.309, -33.461 >, < -8.7096, 19.874, -33.709 >, < -8.4208, 16.965, -29.611 >, 
                  < -7.2293, 20.593, -28.528 >, < -6.4619, 20.399, -29.314 >, < -5.5957, 19.095, -30.056 >, < -5.569, 18.094, -29.951 >, 
                  < -6.3494, 19.229, -24.769 >, < -3.6696, 20.257, -25.806 >, < -2.8033, 18.953, -26.548 >, < -4.5448, 16.513, -26.316 >
               }
            }
            // Object type: BiCubic Bezier Patch
            // Name: NoName
            object
            {
               bicubic_patch
               {
                  type 1
                  flatness 0.05
                  u_steps 4
                  v_steps 4
                  < -9.2573, 5.185, -27.727 >, < -9.2573, 5.185, -27.727 >, < -9.2573, 5.185, -27.727 >, < -9.2573, 5.185, -27.727 >, 
                  < -6.754, 14.467, -30.248 >, < -4.9045, 17.733, -32.854 >, < -4.1881, 17.374, -33.059 >, < -4.6048, 13.388, -30.862 >, 
                  < -6.1104, 17.357, -28.057 >, < -4.6984, 17.476, -28.338 >, < -2.5493, 16.398, -28.952 >, < -1.9912, 15.291, -29.234 >, 
                  < -6.6, 15.251, -25.236 >, < -3.6961, 17.156, -24.268 >, < -1.547, 16.078, -24.882 >, < -2.1227, 13.004, -26.515 >
               }
            }
            // Object type: BiCubic Bezier Patch
            // Name: NoName
            object
            {
               bicubic_patch
               {
                  type 1
                  flatness 0.05
                  u_steps 4
                  v_steps 4
                  < -0.53286, 0.81622, -24.767 >, < -0.53286, 0.81622, -24.767 >, < -0.53286, 0.81622, -24.767 >, < -0.53286, 0.81622, -24.767 >, 
                  < -1.2408, 13.006, -31.112 >, < -0.4136, 16.729, -33.592 >, < 0.4136, 16.729, -33.592 >, < 1.2408, 13.006, -31.112 >, 
                  < -2.4816, 15.872, -29.15 >, < -1.2408, 16.607, -29.121 >, < 1.2408, 16.607, -29.121 >, < 2.2748, 15.872, -29.15 >, 
                  < -2.6884, 13.789, -26.284 >, < -1.2408, 16.784, -24.9 >, < 1.2408, 16.784, -24.9 >, < 2.4816, 13.789, -26.284 >
               }
            }
            // Object type: BiCubic Bezier Patch
            // Name: NoName
            object
            {
               bicubic_patch
               {
                  type 1
                  flatness 0.05
                  u_steps 4
                  v_steps 4
                  < 8.6405, 10.221, -19.596 >, < 8.6405, 10.221, -19.596 >, < 8.6405, 10.221, -19.596 >, < 8.6405, 10.221, -19.596 >, 
                  < 6.8118, 16.298, -29.982 >, < 7.0758, 19.176, -34.112 >, < 7.3398, 19.574, -33.886 >, < 7.6038, 17.49, -29.303 >, 
                  < 3.9182, 17.379, -30.352 >, < 3.9791, 18.434, -30.428 >, < 4.7711, 19.626, -29.749 >, < 5.4362, 19.664, -29.051 >, 
                  < 2.8976, 15.803, -26.702 >, < 1.1793, 18.292, -26.911 >, < 1.9713, 19.484, -26.232 >, < 4.5476, 18.286, -25.287 >
               }
            }
            // Object type: BiCubic Bezier Patch
            // Name: NoName
            object
            {
               bicubic_patch
               {
                  type 1
                  flatness 0.05
                  u_steps 4
                  v_steps 4
                  < -9.4661, 18.832, -14.693 >, < -9.4661, 18.832, -14.693 >, < -9.4661, 18.832, -14.693 >, < -9.4661, 18.832, -14.693 >, 
                  < -7.4125, 25.001, -25.026 >, < -7.8259, 26.859, -29.737 >, < -8.2395, 26.237, -30.091 >, < -8.6533, 23.133, -26.089 >, 
                  < -4.2945, 25.106, -25.952 >, < -4.5797, 24.295, -27.09 >, < -5.8205, 22.427, -28.154 >, < -6.6727, 21.526, -27.99 >, 
                  < -3.2367, 22.826, -22.702 >, < -1.78, 21.342, -25.173 >, < -3.0208, 19.475, -26.236 >, < -5.8217, 18.936, -24.917 >
               }
            }
            // Object type: BiCubic Bezier Patch
            // Name: NoName
            object
            {
               bicubic_patch
               {
                  type 1
                  flatness 0.05
                  u_steps 4
                  v_steps 4
                  < -6.0193, 26.013, -16.403 >, < -6.0193, 26.013, -16.403 >, < -6.0193, 26.013, -16.403 >, < -6.0193, 26.013, -16.403 >, 
                  < -3.9561, 27.116, -23.831 >, < -4.4897, 29.398, -28.285 >, < -5.0232, 29.206, -28.394 >, < -5.5567, 26.539, -24.159 >, 
                  < -2.0551, 25.517, -25.724 >, < -2.7077, 25.21, -26.574 >, < -4.3084, 24.634, -26.902 >, < -5.123, 24.413, -26.353 >, 
                  < -1.501, 22.732, -22.774 >, < -1.4738, 21.078, -25.338 >, < -3.0744, 20.502, -25.666 >, < -4.8357, 21.532, -23.458 >
               }
            }
            // Object type: BiCubic Bezier Patch
            // Name: NoName
            object
            {
               bicubic_patch
               {
                  type 1
                  flatness 0.05
                  u_steps 4
                  v_steps 4
                  < 4.3962e-07, 23.815, -8.4484 >, < 4.3962e-07, 23.815, -8.4484 >, < 4.3962e-07, 23.815, -8.4484 >, < 4.3962e-07, 23.815, -8.4484 >, 
                  < 1.2375, 27.876, -22.247 >, < 0.4125, 30.35, -26.592 >, < -0.4125, 30.35, -26.592 >, < -1.2375, 27.876, -22.247 >, 
                  < 2.475, 25.799, -24.413 >, < 1.2375, 25.754, -25.113 >, < -1.2375, 25.754, -25.113 >, < -2.2688, 25.799, -24.413 >, 
                  < 2.6812, 22.893, -21.532 >, < 1.2375, 21.409, -23.999 >, < -1.2375, 21.409, -23.999 >, < -2.475, 22.893, -21.532 >
               }
            }
            // Object type: BiCubic Bezier Patch
            // Name: NoName
            object
            {
               bicubic_patch
               {
                  type 1
                  flatness 0.05
                  u_steps 4
                  v_steps 4
                  < 6.1875, 22.942, -14.7 >, < 6.1875, 22.942, -14.7 >, < 6.1875, 22.942, -14.7 >, < 6.1875, 22.942, -14.7 >, 
                  < 6.0217, 25.49, -24.756 >, < 5.3072, 28.323, -28.897 >, < 4.5928, 28.681, -28.693 >, < 3.8783, 26.565, -24.144 >, 
                  < 5.6553, 23.211, -27.038 >, < 4.3906, 23.748, -27.406 >, < 2.2472, 24.823, -26.794 >, < 1.5471, 25.272, -25.864 >, 
                  < 5.2843, 20.343, -24.135 >, < 2.7784, 19.778, -26.078 >, < 0.63503, 20.854, -25.466 >, < 0.81881, 22.583, -22.859 >
               }
            }
            // Object type: BiCubic Bezier Patch
            // Name: NoName
            object
            {
               bicubic_patch
               {
                  type 1
                  flatness 0.05
                  u_steps 4
                  v_steps 4
                  < 10.283, 18.131, -15.138 >, < 10.283, 18.131, -15.138 >, < 10.283, 18.131, -15.138 >, < 10.283, 18.131, -15.138 >, 
                  < 9.2871, 22.7, -26.345 >, < 8.9983, 25.609, -30.442 >, < 8.7096, 26.044, -30.195 >, < 8.4208, 24.004, -25.603 >, 
                  < 7.2293, 21.222, -28.171 >, < 6.4619, 21.996, -28.404 >, < 5.5957, 23.3, -27.662 >, < 5.569, 23.721, -26.747 >, 
                  < 6.3494, 18.685, -25.079 >, < 3.6696, 19.052, -26.492 >, < 2.8033, 20.356, -25.75 >, < 4.5448, 21.401, -23.532 >
               }
            }
            // Object type: BiCubic Bezier Patch
            // Name: NoName
            object
            {
               bicubic_patch
               {
                  type 1
                  flatness 0.05
                  u_steps 4
                  v_steps 4
                  < -10.725, 15.536, -18.917 >, < -10.725, 15.536, -18.917 >, < -10.725, 15.536, -18.917 >, < -10.725, 15.536, -18.917 >, 
                  < -9.075, 21.022, -27.301 >, < -9.075, 23.138, -31.85 >, < -9.075, 22.78, -32.054 >, < -9.075, 19.947, -27.913 >, 
                  < -6.1987, 21.983, -27.737 >, < -5.8128, 21.735, -28.553 >, < -5.8128, 20.66, -29.165 >, < -6.1987, 19.922, -28.911 >, 
                  < -5.0994, 20.122, -24.261 >, < -2.5885, 20.192, -25.843 >, < -2.5885, 19.117, -26.455 >, < -5.0994, 17.881, -25.537 >
               }
            }
            // Object type: BiCubic Bezier Patch
            // Name: NoName
            object
            {
               bicubic_patch
               {
                  type 1
                  flatness 0.05
                  u_steps 4
                  v_steps 4
                  < 11.55, 17.515, -22.393 >, < 11.55, 17.515, -22.393 >, < 11.55, 17.515, -22.393 >, < 11.55, 17.515, -22.393 >, 
                  < 9.075, 19.409, -28.219 >, < 9.075, 22.6, -32.156 >, < 9.075, 23.317, -31.748 >, < 9.075, 21.56, -26.995 >, 
                  < 6.1987, 18.757, -29.574 >, < 5.8128, 20.122, -29.471 >, < 5.8128, 22.273, -28.246 >, < 6.1987, 22.879, -27.227 >, 
                  < 5.0994, 16.627, -26.251 >, < 2.5885, 18.579, -26.761 >, < 2.5885, 20.73, -25.537 >, < 5.0994, 21.108, -23.699 >
               }
            }             
      union {      
      // Object type: BiCubic Bezier Patch
      // Name: NoName
      object
      {
         bicubic_patch
         {
            type 1
            flatness 0.05
            u_steps 4
            v_steps 4
            < 1.1714, 22.904, 24.47 >, < 1.1714, 22.904, 24.47 >, < 1.1714, 22.904, 24.47 >, < 1.1714, 22.904, 24.47 >, 
            < -11.815, 38.317, 31.162 >, < -23.818, 49.479, 32.324 >, < -24.898, 48.573, 31.811 >, < -15.055, 35.599, 29.623 >, 
            < -19.653, 46.28, 34.431 >, < -21, 27, 39.246 >, < -21, 27, 39.246 >, < -23.297, 43.222, 32.7 >, 
            < -21, 27, 39.246 >, < -21, 27, 39.246 >, < -21, 27, 39.246 >, < -21, 27, 39.246 >
         }
      }
      // Object type: BiCubic Bezier Patch
      // Name: NoName
      object
      {
         bicubic_patch
         {
            type 1
            flatness 0.05
            u_steps 4
            v_steps 4
            < -1.6347, 23.132, 24.687 >, < -1.6347, 23.132, 24.687 >, < -1.6347, 23.132, 24.687 >, < -1.6347, 23.132, 24.687 >, 
            < 17.692, 35.476, 30.136 >, < 32.216, 46.512, 29.827 >, < 32.746, 45.982, 28.528 >, < 19.283, 33.885, 26.239 >, 
            < 28.638, 42.031, 32.259 >, < 32, 17, 33.985 >, < 32, 17, 33.985 >, < 30.428, 40.241, 27.875 >, 
            < 32, 17, 33.985 >, < 32, 17, 33.985 >, < 32, 17, 33.985 >, < 32, 17, 33.985 >
         }
      }
      // Object type: BiCubic Bezier Patch
      // Name: NoName
      object
      {
         bicubic_patch
         {
            type 1
            flatness 0.05
            u_steps 4
            v_steps 4
            < -0.39344, 21.769, 24.077 >, < -0.39344, 21.769, 24.077 >, < -0.39344, 21.769, 24.077 >, < -0.39344, 21.769, 24.077 >, 
            < 1.5965, 51, 35 >, < 7.4183, 66, 39 >, < 9.3879, 66, 39 >, < 7.5053, 51, 35 >, 
            < 1, 54, 40 >, < 0.95981, 34, 41 >, < 0.95981, 34, 41 >, < 11, 53, 40 >, 
            < 0.95981, 34, 41 >, < 0.95981, 34, 41 >, < 0.95981, 34, 41 >, < 0.95981, 34, 41 >
         }
      }
      // Object type: BiCubic Bezier Patch
      // Name: NoName
      object
      {
         bicubic_patch
         {
            type 1
            flatness 0.05
            u_steps 4
            v_steps 4
            < 0.30729, 22.257, 24.374 >, < 0.30729, 22.257, 24.374 >, < 0.30729, 22.257, 24.374 >, < 0.30729, 22.257, 24.374 >, 
            < -6.5359, 43.791, 31.375 >, < -7.7047, 61.937, 33.356 >, < -5.7351, 62.284, 33.356 >, < -0.62707, 44.833, 31.375 >, 
            < -9.0605, 55.911, 35.125 >, < -8.5378, 46, 42 >, < -8.5378, 46, 42 >, < -2.4131, 57.084, 35.125 >, 
            < -8.5378, 46, 42 >, < -8.5378, 46, 42 >, < -8.5378, 46, 42 >, < -8.5378, 46, 42 >
         }
      }
      // Object type: BiCubic Bezier Patch
      // Name: NoName
      object
      {
         bicubic_patch
         {
            type 1
            flatness 0.05
            u_steps 4
            v_steps 4
            < 1.4943, 23.886, 24.876 >, < 1.4943, 23.886, 24.876 >, < 1.4943, 23.886, 24.876 >, < 1.4943, 23.886, 24.876 >, 
            < -16.499, 26.851, 28.197 >, < -28.633, 31.23, 26.372 >, < -28.788, 30.731, 24.966 >, < -16.962, 25.352, 23.98 >, 
            < -26.453, 28.27, 29.09 >, < -24, 14, 29.03 >, < -24, 14, 29.03 >, < -26.973, 26.584, 24.345 >, 
            < -24, 14, 29.03 >, < -24, 14, 29.03 >, < -24, 14, 29.03 >, < -24, 14, 29.03 >
         }
          }
          translate <0,0,3>
      }
      
         }
       texture {FeatherTex2}
      }

//Neck 
#declare Smoothness = 50;

   #declare CurRadius = 4;
   #declare Smoothness = (1 / Smoothness);
   #declare Count = 0; #while (Count < 1)
      #declare spline_clock = Count; #include "Neck2.spl"
      #declare CurPoint = spline_pos;
      #declare CurRadius = CurRadius-.045;

               sphere {CurPoint, CurRadius texture {ChickenTex2} translate <0,20,-13>}
      
      #declare Count = Count + Smoothness; #end
}
//Head
#declare Head =
union {
union {
difference {
blob {
threshold .01
      // Object type: Sphere
      // Name: NoName
         sphere { < 0, 0, 0 >, 1, .05
         scale 1.5
         scale < 1, 16, 18 >
         translate < 0, 8, 12 >
      }
      // Object type: Sphere
      // Name: NoName
         sphere { < 0, 0, 0 >, 1, .05
         scale 1.5
         scale < 2.5, 15.556, 15.556 >
         rotate < -45, 0, 0 >
         translate < 0, 18, -13 >
      }
      // Object type: Sphere
      // Name: NoName
         sphere { < 0, 0, 0 >, 1, .05 
         scale 1.5
         scale < 2.5, 9.8995, 11 >
         rotate < -12.995, 0, 0 >
         translate < 0, 27, 6 >
      }
      // Object type: Sphere
      // Name: NoName
         sphere { < 0, 0, 0 >, 1, .05
         scale 1.5
         scale < 2.5, 9.8995, 11 >
         rotate < 13.57, 0, 0 >
         translate < 0, 25, 25 >
      }
      
      // Object type: Cylinder
      // Name: NoName
         cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1, -.05 

         scale < 13, 20, 24 >
         rotate < 0, -17.689, -67.666 >
         translate < -6, -3, -29 >
      }
      // Object type: Cylinder
      // Name: NoName
         cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1, -.05 

         scale < 4.5198, 20, 20.595 >
         rotate < 0, 30.993, -90 >
         translate < -6, 33, -18 >
      }
      // Object type: Cylinder
      // Name: NoName
         cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1, -.05 

         scale < 5.1526, 20, 20.595 >
         rotate < 0, 38.702, -90 >
         translate < -6, 35, -17 >
      }
      // Object type: Cylinder
      // Name: NoName
         cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1, -.05 

         scale < 6.0799, 20, 20.595 >
         rotate < 180, 78.772, 90 >
         translate < -6, 43, 20 >
      }
      // Object type: Cylinder
      // Name: NoName
         cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1, -.05 

         scale < 6.0799, 20, 7.0647 >
         rotate < 0, 84.3, -90 >
         translate < -6, 30, -8 >
      }
      // Object type: Cylinder
      // Name: NoName
         cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1, -.05 

         scale < 3.147, 20, 20.595 >
         rotate < 0, 77.194, -90 >
         translate < -6, 47, 10 >
      }
      // Object type: Cylinder
      // Name: NoName
         cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1, -.05 

         scale < 3.147, 20, 20.595 >
         rotate < 180, 49.249, 90 >
         translate < -6, 41, 30 >
      }
      // Object type: Cylinder
      // Name: NoName
         cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1, -.05 

         scale < 3.147, 20, 13.598 >
         rotate < 0, 37.388, -90 >
         translate < -6, 39, 9 >
      }
      // Object type: Cylinder
      // Name: NoName
         cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1, -.05 

         scale < 3.147, 20, 20.595 >
         rotate < 180, 77.942, 90 >
         translate < -6, 13, 32 >
      }
      // Object type: Cylinder
      // Name: NoName
         cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1, -.05 

         scale < 3.147, 20, 7.0545 >
         rotate < 0, 89.063, -90 >
         translate < -6, 31, 36 >
      }
      // Object type: Cylinder
      // Name: NoName
         cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1, -.05 

         scale < 6.2854, 20, 3.7029 >
         rotate < 180, 77.942, 90 >
         translate < -6, 37, 26 >
      }
      // Object type: Cylinder
      // Name: NoName
         cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1, -.05 

         scale < 3.147, 20, 6.2316 >
         rotate < 0, 25.368, -90 >
         translate < -6, 10, -28 >
      }
      // Object type: Cylinder
      // Name: NoName
         cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1, -.05 

         scale < 3.147, 20, 6.2316 >
         rotate < 0, -5.5956, -90 >
         translate < -6, 33, -22 >
      }
       
      
      
      
      
      // Object type: Cylinder
      // Name: NoName
         cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1, -.075 

         scale < 13, 20, 24 >
         rotate < 0, -17.689, -67.666 >
         translate < -6, -3, -29 >
      }
      // Object type: Cylinder
      // Name: NoName
         cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1, -.075 

         scale < 4.5198, 20, 20.595 >
         rotate < 0, 30.993, -90 >
         translate < -6, 33, -18 >
      }
      // Object type: Cylinder
      // Name: NoName
         cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1, -.075 

         scale < 5.1526, 20, 20.595 >
         rotate < 0, 38.702, -90 >
         translate < -6, 35, -17 >
      }
      // Object type: Cylinder
      // Name: NoName
         cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1, -.075 

         scale < 6.0799, 20, 20.595 >
         rotate < 180, 78.772, 90 >
         translate < -6, 43, 20 >
      }
      // Object type: Cylinder
      // Name: NoName
         cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1, -.075 

         scale < 6.0799, 20, 7.0647 >
         rotate < 0, 84.3, -90 >
         translate < -6, 30, -8 >
      }
      // Object type: Cylinder
      // Name: NoName
         cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1, -.075 

         scale < 3.147, 20, 20.595 >
         rotate < 0, 77.194, -90 >
         translate < -6, 47, 10 >
      }
      // Object type: Cylinder
      // Name: NoName
         cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1, -.075 

         scale < 3.147, 20, 20.595 >
         rotate < 180, 49.249, 90 >
         translate < -6, 41, 30 >
      }
      // Object type: Cylinder
      // Name: NoName
         cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1, -.075 

         scale < 3.147, 20, 13.598 >
         rotate < 0, 37.388, -90 >
         translate < -6, 39, 9 >
      }
      // Object type: Cylinder
      // Name: NoName
         cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1, -.075 

         scale < 3.147, 20, 20.595 >
         rotate < 180, 77.942, 90 >
         translate < -6, 13, 32 >
      }
      // Object type: Cylinder
      // Name: NoName
         cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1, -.075 

         scale < 3.147, 20, 7.0545 >
         rotate < 0, 89.063, -90 >
         translate < -6, 31, 36 >
      }
      // Object type: Cylinder
      // Name: NoName
         cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1, -.075 

         scale < 6.2854, 20, 3.7029 >
         rotate < 180, 77.942, 90 >
         translate < -6, 37, 26 >
      }                                           
      // Name: NoName
         cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1, -.075 

      // Object type: Cylinder
         scale < 3.147, 20, 6.2316 >
         rotate < 0, 25.368, -90 >
         translate < -6, 10, -28 >
      }
      // Object type: Cylinder
      // Name: NoName
         cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1, -.075 

         scale < 3.147, 20, 6.2316 >
         rotate < 0, -5.5956, -90 >
         translate < -6, 33, -22 >
      }
            
      texture {
      pigment {rgb <1,.125,0>*.75}
      normal {bumps bump_size .25}
      finish {ambient .1 diffuse .5 phong .25 phong_size 5}
      scale <1,5,1>
      rotate 45*x
      }
   }
disc { 0, y, 60 translate <0,5,0>} 
translate <0,10,-5>
}
#declare Gobbler =
blob {
threshold .01
      // Object type: Sphere
      // Name: NoName
         sphere { < 0, 0, 0 >, 1, .05
         scale 1.5
         scale < 0.2, 0.875, 0.875 >
         translate < 0, -1.5, 0 >
      }
      // Object type: Sphere
      // Name: NoName
         sphere { < 0, 0, 0 >, 1, .05
         scale 1.5
         scale < 0.075, 0.675, 0.675 >
         translate < 0, -1, 0 >
      }
      // Object type: Sphere
      // Name: NoName
         sphere { < 0, 0, 0 >, 1, .05
         scale 1.5
         scale < 0.075, 0.575, 0.575 >
         translate < 0, -0.5, 0 >
      }            
      texture {
      pigment {rgb <1,.125,0>*.75}
      normal {bumps bump_size .25}
      finish {ambient .1 diffuse .5 phong .25 phong_size 5}
      scale <1,5,1>
      rotate 45*x
      }
   }
   union {Gobbler scale 5 rotate <55,0,0> translate <5,-8,6> }
   union {Gobbler scale 5 rotate <55,0,0> translate <-5,-8,6> }
 //Object type: World
// Name: Root
object
{
   union
   {
    blob {
   threshold .01
      // Object type: Sphere
      // Name: NoName
         sphere { < 0, 0, 0 >, 1,.05
         scale 1.75
         scale < 7.5, 1, 17.5 >
         rotate < -15, 0, 0 >
         translate < 0, -2, 4 >
      }
            // Object type: Cylinder
      // Name: NoName
         cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1, -.125 

         scale < 38, 80, 30 >
         rotate < 0, 0, -90 >
         translate < -40, 1, 47 >
      }
      texture {BeakTex}
      }
   blob {
   threshold .01
      // Object type: Sphere
      // Name: NoName
         sphere { < 0, 0, 0 >, 1, .05
         scale 1.75
         scale < 11, 12, 22 >
         translate <0,0,4>
      }
      // Object type: Cylinder
      // Name: NoName
         cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1, -2

         scale < 2, 36, 20 >
         rotate < 0, 0, -90 >
         translate < -18, -1, -16 >
      }
        sphere { < 0, 0, 0 >, 1, .05
         scale 1.75 
         scale < 5, 7, 23 >
         translate < 0, 0, 8 >
      }
         sphere { < 0, 0, 0 >, 1, .05
         scale 1.75 
         scale < 5, 14, 16 >
         translate < 0, 8, 10 >
      }
      // Object type: Cylinder
      // Name: NoName
         cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1, -2

         scale < 2, 80, 21 >
         rotate < 0, -3.7918, -90 >
         translate < -40, -2, -18 >
      }
      // Object type: Sphere
      // Name: NoName
         sphere { < 0, 0, 0 >, 1, .05
         scale 1.75
         scale < 5, 11, 10 >
         rotate < 0, 22.5, 0 >
         translate < 7, 14+6, 6 >
      }
      // Object type: Sphere
      // Name: NoName
         sphere { < 0, 0, 0 >, 1, .05
         scale 1.75
         scale < 5, 11, 10 >
         rotate < 0, -22.5, 0 >
         translate < -7, 14+6, 6 >
      }
      // Object type: Sphere
      // Name: NoName
         sphere { < 0, 0, 0 >, 1, .025
         scale 2.5
         scale 3.75
         translate < 12, 0, 8 >
      }
      // Object type: Sphere
      // Name: NoName
         sphere { < 0, 0, 0 >, 1, .025
         scale 2.5
         scale 3.75
         translate < -12, 0, 8 >
      }
            // Object type: Cylinder
      // Name: NoName
         cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1, -.125 

         scale < 38, 80, 30 >
         rotate < 0, 0, -90 >
         translate < -40, 1, 47 >
      }
      // Object type: Cylinder
      // Name: NoName
         cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1, -.125 

         scale < 2, 80, 21 >
         rotate < 0, -14.78, -90 >
         translate < -40, -6, -17 >
      }
      // Object type: Cylinder
      // Name: NoName
         cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1, -.125 

         scale < 5, 80, 5 >
         rotate < 0, 0, -90 >
         translate < -40, -5, 0 >
      }
      // Object type: Cylinder
      // Name: NoName
         cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1, -.125 

         scale < 5, 80, 5 >
         rotate < 0, 0, -90 >
         translate < -40, -9, 4 >
      }
      // Object type: Cylinder
      // Name: NoName
         cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1, -.125 

         scale < 5, 80, 5 >
         rotate < 0, 0, -90 >
         translate < -40, -8, 13 >
      }
      // Object type: Cylinder
      // Name: NoName
         cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1, -.125  

         scale < 5, 80, 5 >
         rotate < 0, 0, -90 >
         translate < -40, -5, 16 >
      }
      // Object type: Cylinder
      // Name: NoName
         cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1, -.125  
         
         scale < 15, 80, 30>
         rotate < 0, 0, -90 >
         translate < -40, -14, -16 >
      }
            // Object type: Cylinder
      // Name: NoName
         cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1, -.05

         scale < 1.5, 40, 1.5 >
         translate < 4, 4, -12 >
      }
      // Object type: Cylinder
      // Name: NoName
         cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1, -.05

         scale < 1.5, 40, 1.5 >
         translate < -4, 4, -12 >
      }
      // Object type: Sphere
      // Name: NoName
         sphere { < 0, 0, 0 >, 1, -.05 
         
         scale < 8, 11+2, 10+2 >
         rotate < 0, 22.5, 0 >
         translate < 9, 14+6, 4 >
      }
      // Object type: Sphere
      // Name: NoName
         sphere { < 0, 0, 0 >, 1, -.05  

         scale < 8, 11+2, 10+2 >
         rotate < 0, -22.5, 0 >
         translate < -9, 14+6, 4 >
      }
      texture {BeakTex}
      }
      // Object type: Sphere
      // Name: Eyes
      object
      {
         sphere { < 0, 0, 0 >, 1 }

         scale < 6, 9+2, 9.463 >
         rotate < 0, -22.5, 0 >
         translate < -8.5, 14+6, 6 >
      }
      // Object type: Sphere
      // Name: Eyes
      object
      {
         sphere { < 0, 0, 0 >, 1 }

         scale < 6, 9+2, 9.463 >
         rotate < 0, 22.5, 0 >
         translate < 8.5, 14+6, 6 >
      }
      
      object
      {
         sphere { < 0, 0, 0 >, 1 }

         scale <.5,2.25,2.25>
         rotate < 0, -22.5, 0 >
         translate < -8.5-6, 14+6.5, 1 >
         pigment {rgb 0} no_shadow
      }
      object
      {
         sphere { < 0, 0, 0 >, 1 }

         scale <.5,2.25,2.25>
         rotate < 0, 22.5, 0 >
         translate < 8.5+6, 14+6.5, 1 >
         pigment {rgb 0} no_shadow
      }
      
   }
pigment {rgb 1.25}
}
}
rotate 22.5*y
rotate <-55,0,0>
scale <1,1.25,1>
scale .375
translate <0,10,-17.5-35>
}
#declare ChickenB =
union {
union {
Head
}
union {
Body
}
union {
Foot
rotate 45*y
scale 1.5
translate <-10,-14,3>
}
union {
Foot
scale 1.5
translate <-10,-14,3>
scale <-1,1,1>
}
scale <.875,1,.875>
translate <0,28,0>
scale .15
}
//plane {y,0 pigment {rgb <.7,.5,.4>}}
