// Persistence of Vision data file created with GUM 0.92
#include "colors.inc"
#include "textures.inc"
#include "Woods.inc"

#declare Trace_Detail = off;
#declare Trace_Wire = off;
#declare Trace_Nails = off;
#declare Trace_Coop = on;
#declare Trace_Ground = on;
#declare Trace_Bots = off;
#declare Trace_Chickens = off;
#declare Trace_Light = off;
#declare Trace_LightBeams = on;
#declare Light_Detail = 5;
/*
// Object type: Camera
// Name: Tele
camera 
{
   right     < 1, 0, 0   >
   up        < 0, 1, 0   >
   direction < 0, 0, 0.5 >
   location  < 0, 0, 0   >
   scale < 17.546, 13.16, 31.145 >
   rotate < 16.668, 25.974, -3.0783e-06 >
   translate < -28.336, 35.39, 21.009 >
}*/
// Object type: Camera
// Name: Tele
camera 
{
   right     < 1, 0, 0   >
   up        < 0, 1, 0   >
   direction < 0, 0, 0.5 >
   location  < 0, 0, 0   >
   scale < 17.546, 13.16, 31.145 >
   rotate < 10.556, 26.738, -1.7075e-06 >
   translate < -30.117, 23.106, 19.139 >
}
light_source
{
   < -30.117, 23.106, 19.139 >
   color rgb .25
   shadowless
   media_interaction off
}

// Object type: OmniLight
// Name: Omni Light
light_source
{
   < 40, 50, 37.5 >
   color rgb < 1, 1, 1 >*3
   #if (Trace_Light = on)
    area_light <0,2.5,0>, <2.5,0,0>,Light_Detail/2,Light_Detail/2
    adaptive 1
    #end
   fade_distance 75
   fade_power 2
   media_interaction off
}
// Object type: OmniLight
// Name: Omni Light
light_source
{
   < -40, 50, 85 >
   color rgb < 1, 1, 1 >*3
   shadowless
   media_interaction off
}
// Object type: OmniLight
// Name: Omni Light
light_source
{
   < -45, 15, 85 >
   color rgb -2
   shadowless
   fade_distance 75
   fade_power 2 
   media_interaction off
}

light_source {
    <-20,40,180>*1.5
    color rgb <8,8,12>*5
    #if (Trace_Light = on)
    area_light <0,15,0>, <15,0,0>,Light_Detail,Light_Detail
    adaptive 1
    #end
    spotlight
    point_at <0,25,100>
    radius 500
    falloff 750
   }



#declare CrudTexture =
texture {
pigment {gradient y
pigment_map {
[0 bozo
color_map {
[0 rgbt <0,0,0,1>] 
[.25 rgbt <0,0,0,1>]
[1 rgbt <0,0,0,.375>]
}
turbulence 1
scale <1,4,1>
]
[.375 rgbt <0,0,0,1>]
[1 rgbt <0,0,0,1>]
}            
}
finish {ambient .1 diffuse 2 }
scale 1
scale <.4,65,.4>
}
texture {
pigment {gradient y
color_map {
[0 rgbt <0,0,0,.375>] 
[.1 rgbt <0,0,0,.375>]
[.4 rgbt <0,0,0,1>]
[1 rgbt <0,0,0,1>]
}
}
finish {ambient .1 diffuse 2 }
scale <100,65,100>
}
texture {
pigment {gradient y
pigment_map {
[0 bozo
color_map {
[0 rgbt <.5,.5,.5,1>] 
[.825 rgbt <.5,.5,.5,1>]
[1 rgbt <.5,.5,.5,.25>]
}
turbulence .5
scale <1,3/75,1>
]
[.25 bozo
color_map {
[0 rgbt <.5,.5,.5,1>] 
[.825 rgbt <.5,.5,.5,1>]
[1 rgbt <.5,.5,.5,.25>]
}
turbulence .5
scale <1,3/75,1>
]
[.3 rgbt <.5,.5,.5,1>]
[1 rgbt <.5,.5,.5,1>]
}
} 
finish {ambient .1 diffuse 1 }
scale 1
scale <.3,75,.3>
}
texture {
pigment {bozo
color_map {
[0 rgbt <0,0,0,1>] 
[.25 rgbt <0,0,0,1>]
[1 rgbt <0,0,0,.5>]
}
}
finish {ambient .1 diffuse 2 }
scale 10
}


#declare GroundTexture =
texture {
pigment {
image_map {
png "grndtext.png"
interpolate 2
}
}
normal {bumps bump_size .5 scale 1/< 100, 15, 175 >}
finish {
ambient 0
diffuse .375
phong .025
phong_size 15
}
}
texture {
pigment {
rgbt <0,0,0,.9>
}
normal {bumps bump_size 1 scale 1/< 100, 15, 175 >}
finish {
ambient 0
diffuse 1
}
}
texture {
pigment {bozo
color_map {
[0 rgbt <0,0,0,1>] 
[.25 rgbt <0,0,0,1>]
[1 rgbt <0,0,0,.5>]
}
}
finish {ambient .1 diffuse 1 }
scale 2.5
scale 1/< 100, 15, 175 >
translate < 50, 0, 0 >
}




#declare BoardTexture =
//texture {pigment {rgb <.5,.4,.3>}}
texture {T_Wood15 rotate 2 scale <2,1,2>}
texture {pigment {rgbt <0,.1,.1,.75>}}

#declare BoardTexture2 =
//texture {pigment {rgb <.5,.4,.3>}}
texture {T_Wood15 rotate -3 scale <2,1,2>}

#declare BoardTexture3 =
//texture {pigment {rgb <.5,.4,.3>}}
texture {T_Wood15 rotate 3 scale <2,1,2>}
texture {pigment {rgbt <.75,.5,.25,.75>}}


#declare RBox = 
#if (Trace_Detail = off)
box {0,1}
#else
superellipsoid {
<.125, .125>
translate <1,1,1>
scale .5
}
#end

#declare RBox2 =
superellipsoid {
<.25, .25>
translate <1,1,1>
scale .5
}


#if (Trace_Coop = on)
// Object type: World
// Name: Root
object
{
   union
   {
      // Object type: Polynomial
      // Name: NoName
      object
      {
         RBox

         scale < 2, 48, 4 >
         translate < -49.75, 0, 95.5 >

         texture
         {
            BoardTexture3
            rotate <90,0,0>
         }
         texture {CrudTexture}
      }
      // Object type: Polynomial
      // Name: NoName
      object
      {
         RBox

         scale < 2, 48, 4 >
         translate < 47.75, 0, 95.5 >

         texture
         {
            BoardTexture
            rotate <90,0,0>
         }
         texture {CrudTexture}
      }
      // Object type: Polynomial
      // Name: NoName
      object
      {
         RBox

         scale < 2, 52, 4 >
         rotate < 0, 90, 0 >
         translate < -47.5, -3, 99.75 >

         texture
         {
            BoardTexture
            rotate <90,0,0>            
            rotate < 0, 90, 0 >
         }
         texture {CrudTexture}
      }
      // Object type: Polynomial
      // Name: NoName
      object
      {
         RBox

         scale < 2, 52, 4 >
         rotate < 0, 90, 0 >
         translate < 43.5, -3, 99.75 >

         texture
         {
            BoardTexture2 
            rotate <90,0,0>            
            rotate < 0, 90, 0 >
         }
         texture {CrudTexture}
      }
      // Object type: Polynomial
      // Name: NoName
      object
      {
         RBox

         scale < 1, 17.311, 4 >
         rotate < -16.377, 90, 0 >
         translate < 35, 19.75, 99.75 >

         texture
         {
            BoardTexture
            
            rotate < -16.377, 90, 0 >
         }
         texture {CrudTexture}
      }
      // Object type: Polynomial
      // Name: NoName
      object
      {
         RBox

         scale < 1, 13.036, 4 >
         rotate < 10.911, 90, 0 >
         translate < -12.75, 12.75, 99.75 >

         texture
         {
            BoardTexture3
            
            rotate < 10.911, 90, 0 >
         }
         texture {CrudTexture}
      }
      // Object type: Polynomial
      // Name: NoName
      object
      {
         RBox

         scale < 1, 17.311, 4 >
         rotate < 37.224, 90, 0 >
         translate < -41.5, 13.5, 99.75 >

         texture
         {
            BoardTexture2
            
            rotate < 37.224, 90, 0 >
         }
         texture {CrudTexture}
      }
      // Object type: Polynomial
      // Name: NoName
      object
      {
         RBox

         scale < 1, 24.037, 4 >
         rotate < -15.767, 90, 0 >
         translate < -18, 12, 99.75 >

         texture
         {
            BoardTexture
            
            rotate < -15.767, 90, 0 >
         }
         texture {CrudTexture}
      }
      // Object type: Polynomial
      // Name: NoName
      object
      {
         RBox

         scale < 1, 15, 2 >
         rotate < 0, 90, 0 >
         translate < 12, 2.4722e-30, 99.75 >

         texture
         {
            BoardTexture
            
            rotate < 0, 90, 0 >
         }
         texture {CrudTexture}
      }
      // Object type: Polynomial
      // Name: NoName
      object
      {
         RBox

         scale < 1, 15, 2 >
         rotate < 0, 90, 0 >
         translate < -2, 0, 99.75 >

         texture
         {
            BoardTexture
            rotate < 0, 90, 0 >
         }
         texture {CrudTexture}
      }
      // Object type: Polynomial
      // Name: NoName
      object
      {
         RBox

         scale < 1, 2, 16.03 >
         rotate < 3.0128, 90, 0 >
         translate < -2, 13, 99.75 >

         texture
         {
            BoardTexture2
           
            rotate < 3.0128, 90, 0 >
         }
         texture {CrudTexture}
      }
      // Object type: Polynomial
      // Name: NoName
      object
      {
         RBox

         scale < 2, 8, 40 >
         rotate < 0, 90, 0 >
         translate < 12, 0, 102 >

         texture
         {
            BoardTexture3
            
            rotate < 0, 90, 0 >
         }
         texture {CrudTexture}
      }
      // Object type: Polynomial
      // Name: NoName
      object
      {
         RBox

         scale < 2, 8, 40 >
         rotate < 0, 90, 0 >
         translate < 12, 8, 101.75 >

         texture
         {
            BoardTexture
            rotate < 0, 90, 0 >
         }
         texture {CrudTexture}
      }
      // Object type: Polynomial
      // Name: NoName
      object
      {
         RBox

         scale < -2, -8, -100 >
         rotate < 180, 0, 0 >
         translate < -49.75, 0, 3.8147e-06 >

         texture
         {
            BoardTexture
            rotate < 180, 0, 0 >
         }
         texture {CrudTexture}
      }
      // Object type: Polynomial
      // Name: NoName
      object
      {
         RBox

         scale < -2, -8, -100 >
         rotate < 180, 0, 0 >
         translate < -50, 8, 3.8147e-06 >

         texture
         {
            BoardTexture
            rotate < 180, 0, 0 >
         }
         texture {CrudTexture}
      }
      // Object type: Polynomial
      // Name: NoName
      object
      {
         RBox

         scale < -2, -8, -100 >
         rotate < 180, 0, 0 >
         translate < -50, 16, 3.8147e-06 >

         texture
         {
            BoardTexture
            rotate < 180, 0, 0 >
         }
         texture {CrudTexture}
      }
      // Object type: Polynomial
      // Name: NoName
      object
      {
         RBox

         scale < -2, -8, -100 >
         rotate < 180, 0, 0 >
         translate < -50.25, 24, 3.8147e-06 >

         texture
         {
            BoardTexture
            rotate < 180, 0, 0 >
         }
         texture {CrudTexture}
      }
      // Object type: Polynomial
      // Name: NoName
      object
      {
         RBox

         scale < -2, -8, -100 >
         rotate < 180, 0, 0 >
         translate < -50, 32, 3.8147e-06 >

         texture
         {
            BoardTexture2
            rotate < 180, 0, 0 >
         }
         texture {CrudTexture}
      }
      // Object type: Polynomial
      // Name: NoName
      object
      {
         RBox

         scale < -2, -8, -100 >
         rotate < 180, 0, 0 >
         translate < -50, 40, 3.8147e-06 >

         texture
         {
            BoardTexture
            rotate < 180, 0, 0 >
         }
         texture {CrudTexture}
      }
      // Object type: Polynomial
      // Name: NoName
      object
      {
         RBox

         scale < 2, 8, 100 >
         translate < 50, 0, 0 >

         texture
         {
            BoardTexture3
         }
         texture {CrudTexture}
      }
      // Object type: Polynomial
      // Name: NoName
      object
      {
         RBox

         scale < 2, 8, 100 >
         translate < 50, 8, 0 >

         texture
         {
            BoardTexture
         }
         texture {CrudTexture}
      }
      // Object type: Polynomial
      // Name: NoName
      object
      {
         RBox

         scale < 2, 8, 100 >
         translate < 49.75, 16, 0 >

         texture
         {
            BoardTexture
         }
         texture {CrudTexture}
      }
      // Object type: Polynomial
      // Name: NoName
      object
      {
         RBox

         scale < 2, 8, 100 >
         translate < 50, 24, 0 >

         texture
         {
            BoardTexture
         }
         texture {CrudTexture}
      }
      // Object type: Polynomial
      // Name: NoName
      object
      {
         RBox

         scale < 2, 8, 100 >
         translate < 50.25, 32, 0 >

         texture
         {
            BoardTexture
         }
         texture {CrudTexture}
      }
      // Object type: Polynomial
      // Name: NoName
      object
      {
         RBox

         scale < 2, 8, 100 >
         translate < 50, 40, 0 >

         texture
         {
            BoardTexture2
         }
         texture {CrudTexture}
      }
      // Object type: Polynomial
      // Name: NoName
      object
      {
         RBox

         scale < 2, 8, 50 >
         rotate < 0, 90, 0 >
         translate < -50, 0, 102 >

         texture
         {
            BoardTexture
            rotate < 0, 90, 0 >
         }
         texture {CrudTexture}
      }
      // Object type: Polynomial
      // Name: NoName
      object
      {
         RBox

         scale < 2, 8, 50 >
         rotate < 0, 90, 0 >
         translate < -50, 8, 101.75 >

         texture
         {
            BoardTexture3
            rotate < 0, 90, 0 >
         }
         texture {CrudTexture}
      }
      // Object type: Polynomial
      // Name: NoName
      object
      {
         RBox

         scale < 2, 8, 100 >
         rotate < 4.6346, 90, 0 >
         translate < -50, 24, 102 >

         texture
         {
            BoardTexture
            rotate < 4.6346, 90, 0 >
         }
         texture {CrudTexture}
      }
      // Object type: Polynomial
      // Name: NoName
      object
      {
         RBox

         scale < 2, 8, 100 >
         rotate < 0, 90, 0 >
         translate < -50, 32, 102 >

         texture
         {
            BoardTexture2
            rotate < 0, 90, 0 >
         }
         texture {CrudTexture}
      }
      // Object type: Polynomial
      // Name: NoName
      object
      {
         RBox

         scale < 2, 8, 100 >
         rotate < 0, 90, 0 >
         translate < -50, 40, 102.25 >
         
         texture
         {
            BoardTexture
            rotate < 0, 90, 0 >
         }
         texture {CrudTexture}
      }
      // Object type: Polynomial
      // Name: NoName
      object
      {
         RBox

         scale < 1, 24.582, 4 >
         rotate < 46.642, 87.415, 56.296 >
         translate < 4, 13, 99 >

         texture
         {
            BoardTexture
            rotate < 46.642, 87.415, 56.296 >
         }
         texture {CrudTexture}
      }
      // Object type: Polynomial
      // Name: NoName
      object
      {
         RBox

         scale < 1, 22.738, 4 >
         rotate < 10.911, 90, 0 >
         translate < 17, 14, 99.75 >

         texture
         {
            BoardTexture2
            rotate < 10.911, 90, 0 >
         }
         texture {CrudTexture}
      }
      // Object type: Polynomial
      // Name: NoName
      object
      {
         RBox

         scale < 1, 13.036, 4 >
         rotate < 10.911, 90, 0 >
         translate < 17, 14, 99.75 >

         texture
         {
            BoardTexture
            rotate < 10.911, 90, 0 >
         }
         texture {CrudTexture}
      }
      // Object type: Polynomial
      // Name: NoName
      object
      {
         RBox

         scale < 1, 13.036, 4 >
         rotate < -7.524, 90, 0 >
         translate < 10, 22, 99.75 >

         texture
         {
            BoardTexture3
            rotate < -7.524, 90, 0 >
         }
         texture {CrudTexture}
      }
// Object type: Difference
      // Name: 'and not'
      object
      {
         difference
         {
            // Object type: Polynomial
            // Name: NoName
            object
            {
               RBox2

               scale < 15, 15, 15 >
               rotate < -6, 0, 0 >
               translate < 15, 2.0071, 84.325 >
            }
            // Object type: Polynomial
            // Name: NoName
            object
            {
               RBox2

               scale < 14.5, 14.5, 14.5 >
               rotate < -6, 0, 0 >
               translate < 15.25, 2.2819, 84.548 >
            }
            // Object type: Disc
            // Name: NoName
            object
            {
               disc { < 0, 0, 0 >, < 0, 1, 0 >, 1, 0 }

               scale < 20, 1, 20 >
               rotate < 147.15, 0, 0 >
               translate < 20, 12.5, 90.5 >
            }
         }
         texture {
         pigment {rgb <.5,.475,.375>}
         normal {bumps scale 2 bump_size .25}
         finish {ambient 0 diffuse .5 phong 0}
         }
         texture {CrudTexture}
      }
      // Object type: Difference
      // Name: 'and not'
      object
      {
         difference
         {
            // Object type: Polynomial
            // Name: NoName
            object
            {
               RBox2

               scale < 14.5, 14.5, 14.5 >
               rotate < -6, 0, 0 >
               translate < 15.25, 2.2819, 84.548 >
            }
            // Object type: Disc
            // Name: NoName
            object
            {
               disc { < 0, 0, 0 >, < 0, 1, 0 >, 1, 0 }

               scale < 20, 1, 20 >
               rotate < -180, 0, 0 >
               translate < 20, 7, 91.75 >
            }
         }
      texture {
      pigment {rgbt <0, 0, 0,.5>}
      normal {waves 1 scale 30 bump_size .75 frequency 15 phase -clock}
      finish {reflection .25 ambient 0 diffuse .25 phong 2 phong_size 40}
      scale .125
      }
      interior{ior 1.33 caustics 1}
      }
      // Object type: Composite
      // Name: group #1
      object
      {
         union
         {
            // Object type: Polynomial
            // Name: NoName
            object
            {
               RBox

               scale < 3, 15, 1 >
               rotate < 0, 90, 0 >
               translate < 30.5, -1.4432e-30, 88 >

               texture
               {
                  BoardTexture
                  rotate < 0, 90, 0 >
               }
               texture {CrudTexture}
            }
            // Object type: Polynomial
            // Name: NoName
            object
            {
               RBox

               scale < 3, 15, 1 >
               rotate < 0, 90, 0 >
               translate < 30.5, 2.8956e-38, 91 >

               texture
               {
                  BoardTexture2
                  rotate < 0, 90, 0 >
               }
               texture {CrudTexture}
            }
            // Object type: Polynomial
            // Name: NoName
            object
            {
               RBox

               scale < 3, 15, 1 >
               rotate < 0, 90, 0 >
               translate < 30.5, 0, 94 >

               texture
               {
                  BoardTexture3
                  rotate < 0, 90, 0 >
               }
               texture {CrudTexture}
            }
            // Object type: Polynomial
            // Name: NoName
            object
            {
               RBox

               scale < 3, 15, 1 >
               rotate < 0, 90, 0 >
               translate < 30.5, 0, 97 >

               texture
               {
                  BoardTexture2
                  rotate < 0, 90, 0 >
               }
               texture {CrudTexture}
            }
            // Object type: Polynomial
            // Name: NoName
            object
            {
               RBox

               scale < 3, 15, 1 >
               rotate < 0, 90, 0 >
               translate < 30.5, 0, 100 >

               texture
               {
                  BoardTexture2
                  rotate < 0, 90, 0 >
               }
               texture {CrudTexture}
            }
         }
      }
      // Object type: Composite
      // Name: group #1
      object
      {
         union
         {
            // Object type: Polynomial
            // Name: NoName
            object
            {
               RBox

               scale < 3, 15, 1 >
               rotate < 0, 90, 0 >
               translate < 46.5, -1.4432e-30, 88 >

               texture
               {
                  BoardTexture3
                  rotate < 0, 90, 0 >
               }
               texture {CrudTexture}
            }
            // Object type: Polynomial
            // Name: NoName
            object
            {
               RBox

               scale < 3, 15, 1 >
               rotate < 0, 90, 0 >
               translate < 46.5, 2.8956e-38, 91 >

               texture
               {
                  BoardTexture
                  rotate < 0, 90, 0 >
               }
               texture {CrudTexture}
            }
            // Object type: Polynomial
            // Name: NoName
            object
            {
               RBox

               scale < 3, 15, 1 >
               rotate < 0, 90, 0 >
               translate < 46.5, 0, 94 >

               texture
               {
                  BoardTexture3
                  rotate < 0, 90, 0 >
               }
               texture {CrudTexture}
            }
            // Object type: Polynomial
            // Name: NoName
            object
            {
               RBox

               scale < 3, 15, 1 >
               rotate < 0, 90, 0 >
               translate < 46.5, 0, 97 >

               texture
               {
                  BoardTexture2
                  rotate < 0, 90, 0 >
               }
               texture {CrudTexture}
            }
            // Object type: Polynomial
            // Name: NoName
            object
            {
               RBox

               scale < 3, 15, 1 >
               rotate < 0, 90, 0 >
               translate < 46.5, 0, 100 >

               texture
               {
                  BoardTexture2
                  rotate < 0, 90, 0 >
               }
               texture {CrudTexture}
            }
         }
      }
      // Object type: HeightField
      // Name: GRAIN.TGA
      object
      {
         height_field { tga "E:\POV\FUNNY\GRAIN.TGA" smooth }

         scale < 15, 1, 18.424 >
         rotate < -32.619, 0, 0 >
         translate < 31.5, 3, 85.5 >
         pigment {rgb <.75,.7,.25>*.25}
         texture {CrudTexture}
         pigment {rgb <.75,.7,.25>*.25 transmit .75}
         
      }
      // Object type: Polynomial
      // Name: NoName
      object
      {
         RBox

         scale < 2, 5, 17 >
         rotate < 0, 90, 0 >
         translate < 30.5, 0, 85 >

         texture
         {
            BoardTexture
            rotate < 0, 90, 0 >
         }
         texture {CrudTexture}
         }
      // Object type: Polynomial
      // Name: NoName
      object
      {
         RBox

         scale < -2, -6, -57.65 >
         rotate < -137.62, 0, 0 >
         translate < 49.75, 43.75, 47 >

         texture {BoardTexture
         rotate < -137.62, 0, 0 >}
         texture {CrudTexture}      
         }
      }

   texture {BoardTexture}   
   texture {CrudTexture}
}
#end
plane {y,0 texture {GroundTexture}scale < 100, 15, 175 >
translate < -50, -2, 0 >}
#if (Trace_Ground = on)
object {
height_field { tga "E:\POV\FUNNY\GROUND.TGA" smooth }
texture {GroundTexture}
scale < 100, 15, 175 >
translate < -50, 0, 0 >
}
/*object {
height_field { tga "E:\POV\FUNNY\GROUND.TGA" smooth }
texture {GroundTexture}
scale < 100, 15, 175 >
translate < -150, 0, 0 >
}
object {
height_field { tga "E:\POV\FUNNY\GROUND.TGA" smooth }
texture {GroundTexture}
scale < 100, 15, 175 >
translate < 50, 0, 0 >
}
object {
height_field { tga "E:\POV\FUNNY\GROUND.TGA" smooth }
texture {GroundTexture}
scale < 100, 15, -175 >
translate < -50, 0, 175 >
}*/
#end

#if (Trace_Wire = on)
      // Object type: BiCubic Bezier Patch
      // Name: Chicken Wire
      object
      {
         bicubic_patch
         {
            type 1
            flatness 0.05
            u_steps 4
            v_steps 4
            < -43, 33, 99 >, < -12, 34, 98 >, < 15, 36, 99 >, < 47, 33, 97 >, 
            < -44, 27, 97 >, < -14, 27, 99 >, < 14, 27, 97 >, < 47, 27, 97 >, 
            < -43, 21, 99 >, < -14, 21, 98 >, < 14.333, 21, 98 >, < 47, 21, 97 >, 
            < -43, 15, 99 >, < -17, 12, 98 >, < 14.333, 15, 98 >, < 44, 11, 98 >
         }
         texture {
         pigment {
         image_map {
         gif "ChknWire.gif"
         transmit 0 1
         interpolate 2
         }
         }
         normal {
         bump_map {
         gif "ChknWire.gif"
         }
         }
         finish {
         ambient .05
         diffuse .125
         phong .02 
         metallic
         }
         scale 1.5
         }
      }              
      #end
#if (Trace_Bots = on)
// brain sucker
#declare Beam = on
#include "bot.inc"
union {Bot rotate 144676*y translate < 13.5, 20, 58 >}
// by the door
#declare Beam = off      
#include "bot.inc"
union {Bot translate < 6, 6, 104 >}
// hoverin' high
union {Bot rotate <0,45,22.5> translate < -6, 35, 80 >}
// inqusitive bot
union {Bot rotate 120*y translate < -14, 1, 81 >}
#end

#if (Trace_Chickens = on)
#include "chicken2.inc"
// inqusitive chicken
union {ChickenB scale 1 rotate 180*y rotate -45*y translate < -8, 0, 70 >}
// hungry Chicken
union {ChickenB scale <1.25,1.5,1.25> rotate 180*y rotate 5*y translate < 22, 0, 80 >}

#include "chicken.inc"
// brain sucked chicken
union {ChickenA rotate 105*y translate  < 16, 0, 57.5 >}
#include "chicken1.inc"
// stand-by Chicken (not really doing anything)
union {ChickenC scale <-1,1,1> rotate -15*y translate  < -25, .5, 72 >}
#end

/* Bot Locations
   < 6, 6, 104 >
   < 16, 17, 57 >
   < -6, 38, 82 >
   < -14, 5, 81 >
*/
#if (Trace_Nails = on)
#declare Nail =
union {
cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1 
scale < 0.25, 0.05, 0.25 >
rotate < 90, 0, 0 >
translate < 0, 0, -0.05 >}
cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1 
scale < 0.1, 2, 0.1 >
rotate < 90, 0, 0 >}
pigment {rgb .125}
}

union {Nail rotate 5*x translate < 33, 34, 98.5 >}
union {Nail translate < 36, 22, 98.75 >}
union {Nail translate < 19, 14, 98.75 >}
union {Nail rotate -5*x translate < 23, 35, 98 >}
union {Nail translate < 21, 22, 98.75 >}

union {Nail rotate 10*x translate < 11, 33, 98.75 >}
union {Nail translate < 12, 25, 98.5 >}
union {Nail rotate 5*x translate < 4, 23, 98 >}
union {Nail translate < 1, 35, 98.75 >}
union {Nail translate < 3, 36, 98.75 >}

union {Nail translate < 5, 14, 98.75 >}
union {Nail rotate -5*x translate < 13, 13, 98.5 >}
union {Nail translate < -1, 14, 98.75 >}
union {Nail rotate 5*x translate < -1, 4, 98.5 >}
union {Nail translate < 14, 4, 98.75 >}

union {Nail translate < -11, 14, 98.75 >}
union {Nail translate < -9, 23, 98 >}
union {Nail rotate -5*x translate < -17, 14, 98.5 >}
union {Nail translate < -20, 26, 98.75 >}
union {Nail rotate 10*x translate < -21, 33, 98.75 >}

union {Nail translate < -19, 23, 98.5 >}
union {Nail rotate 5*x translate < -31, 24, 98.75 >}
union {Nail rotate 5*x translate < 45, 47, 97.5 >}
union {Nail translate < 45.25, 41, 96.5 >}
union {Nail translate < 45, 39, 97.75 >}

union {Nail translate < 44.5, 33, 97 >}
union {Nail translate < 45, 23, 97.75 >}
union {Nail translate < 45, 18, 97.5 >}
union {Nail rotate 5*x translate < 45.5, 15, 96.75 >}
union {Nail translate < 45, 9, 97.75 >}

union {Nail rotate -5*x translate < 45.5, 7, 97.75 >}
union {Nail translate < 45, 4, 97.5 >}
union {Nail translate < 45.375, 1, 96.5 >} 
union {Nail rotate 5*x translate < 11, 29.75, 97.5 >}
union {Nail translate < -9, 18.25, 97.75 >}

union {Nail rotate 10*x translate < -35.25, 18.5, 97.25 >} 
union {Nail rotate -5*x translate < -20.75, 31, 97.75 >}

union {Nail rotate 90*y translate < 47.5, 7.5, 96.25 >}
union {Nail rotate 90*y translate < 47.25, 8.5, 96.25 >}
union {Nail rotate -5*x rotate 90*y translate < 47.75, 15.25, 96.5 >}
union {Nail rotate 90*y translate < 47.75, 16.75, 96 >}
union {Nail rotate 10*x rotate 90*y translate  < 47.75, 23.5, 96.25 >}

union {Nail rotate 90*y translate < 47.5, 24.5, 96.25 >}
union {Nail rotate 90*y translate < 47.75, 31, 96 >}
union {Nail rotate 5*x rotate 90*y translate < 47.75, 32.75, 96.25 >}
union {Nail rotate 90*y translate < 47.5, 39, 96.5 >}
union {Nail rotate -5*x rotate 90*y translate  < 47.75, 40.75, 96.5 >}

union {Nail rotate 90*y translate < 47.75, 47, 96.5 >}
union {Nail rotate 90*y translate < 47.25, 42.25, 52.5 >}
union {Nail rotate -5*x rotate 90*y translate < 47.75, 35.5, 60 >}
union {Nail rotate 90*y translate  <7.25, 27, 73 >}
union {Nail rotate 10*x rotate 90*y translate  < 47.75, 21, 74.75 >}
union {Nail rotate -10*x rotate 90*y translate  < 47.75, 12.25, 85.25 >}
#end    
#include "skies.inc"
sky_sphere{
S_Cloud1   
scale <300,.5,300>
pigment {rgbt <0,0,0,.25>}  
}
  
#include "grass.inc"
union {plant scale 2 rotate 45646*y translate < 12.25, 0, 104.25 >}
union {plant scale 2 rotate 5646*y translate < -2.75, 0, 104.25 >}
union {plant scale 2 rotate 646*y translate < 48.5, 0, 71.75 >}
//union {plant scale <.75,1,.75> rotate 46*y translate < -19, 2.25, 46 >}
union {plant scale 2 rotate 6*y translate < -28, 0, 93.75 >}
union {plant scale 2 rotate 60*y translate < -22, 0, 93.75 >}
union {plant scale 2 rotate -60*y translate < -34, 0, 93.75 >}
 
   

  /* Nail Locations
   < 33, 34, 98.75 >
   < 36, 22, 98.75 >
   < 19, 14, 98.75 >
   < 23, 35, 98.75 >
   < 21, 22, 98.75 >
   
   < 11, 33, 98.75 >
   < 12, 25, 98.75 >
   < 4, 23, 98.75 >
   < 1, 35, 98.75 >
   < 3, 36, 98.75 >
   
   < 5, 14, 98.75 >
   < 13, 13, 98.75 >
   < -1, 14, 98.75 >
   < -1, 4, 98.75 >
   < 14, 4, 98.75 >
   
   < -11, 14, 98.75 >
   < -9, 23, 98.75 >
   < -17, 14, 98.75 >
   < -20, 26, 98.75 >
   < -21, 33, 98.75 >
   
   < -19, 23, 98.75 >
   < -31, 24, 98.75 >
   < 45, 47, 97.75 >
   < 45, 41, 98.75 >
   < 45, 39, 98.75 >
   
   < 45, 33, 98.75 >
   < 45, 23, 98.75 >
   < 45, 18, 98.75 >
   < 45, 15, 98.75 >
   < 45, 9, 98.75 >
   
   < 45, 7, 98.75 >
   < 45, 4, 98.75 >
   < 45, 1, 98.75 >
   < 11, 29.75, 98.75 >
   < -9, 18.25, 98.75 >
   < -35.25, 18.5, 98.75 >
   < -20.75, 31, 98.75 >
   */
   
#declare HazeGlow =
sphere {0, 1 hollow on
pigment {rgbt 1 }
interior {
media{ 
intervals 5 samples 1,5 confidence .99 variance 1/150 
ratio .25
scattering { 2, rgb 1 extinction 1 }
density { spherical
color_map{
[0.0 rgb 0]
[.5 rgb .035]
[1.0 rgb .07]
}
}
density { bozo
color_map{
[0.0 rgb 0]
[1.0 rgb .07]
}
turbulence .25
scale .25
}
}
}
}
    
#if (Trace_LightBeams)

object {HazeGlow
scale < 100, 100, 55>
translate < -50, 55, 110 >
}

#end
      