#declare Is_Inc_File = true

#if ( Is_Inc_File = false )

// Persistence of Vision Ray Tracer Scene Description File
// File: .pov
// Vers: 3
// Desc:
// Date:
// Auth: Chris Hernandez


// ==== Standard POV-Ray Includes ====
#include "colors.inc"	// Standard Color definitions
#include "textures.inc"	// Standard Texture definitions

// ==== Additional Includes ====
//#include "CHARS.INC"   // FIXME-add comments describing each of these
//#include "CONSTS.INC"
//#include "METALS.INC"
//#include "SHAPES.INC"
//#include "SHAPES2.INC"
//#include "SHAPESQ.INC"
//#include "SKIES.INC"
//#include "STONES.INC"
//#include "STONES2.INC"
//#include "WOODMAPS.INC"
//#include "WOODS.INC"

// -------------------------------- light sources ---------------
light_source { <0, 0.1, 0> color rgb <0.6, 0.6, 0.6> }
light_source { <0, 50, 0> color rgb <0.6, 0.6, 0.6> }
light_source { <0, -50, -50> color rgb <0.6, 0.6, 0.6> }
light_source { <-50, 0, -50> color rgb <0.6, 0.6, 0.6> }


background { color rgb <0.6, 0.6, 0.6> }


// ------------------------------------ Camera -------------------
camera {
  location  <0.0 , -0.1 ,-5.0>
  look_at   <0.0 , 0.180 , 0.0>
  //blur_samples 150  aperture 0.050  focal_point <0, 0, -2.75>  confidence 0.95
  angle 32.5
}

#declare TempTexture = texture {
	pigment { color rgb < 0.7, 0.7, 0.8 > }
	finish {
	   ambient 0.3
	   diffuse 0.25
	   specular 0.35
	   roughness 0.05
	   //reflection 0.05
	}
}

#declare RedT = texture { pigment { color rgb <1,0,0> } }

//#default { texture { TempTexture } }


#end


#declare Lamp_Chrome = texture{
   pigment { color rgb 0.75 }
   finish  {
      ambient 0.35
      diffuse 0.5
      //phong 0.5 phong_size 225
      specular 0.75 roughness 0.005
      brilliance 8
      metallic
      //reflection 0.10
      crand 0.01
   }
}

#declare Lamp_Rubber = texture {
   pigment { color rgb 0.15 }
      finish  {
      ambient 0.35
      diffuse 0.5
      //phong 0.5 phong_size 225
      specular 0.25 roughness 0.1
      crand 0.05
   }
   normal { gradient x 1.0 scale <0.05, 1, 1>}
}

#declare Lamp_Body = object {
   difference {
	  superellipsoid { <0.4, 0.4> }
	  plane { -y, 0.7 }
	  superellipsoid { <0.4, 0.4> scale <0.95, 0.9, 0.95> translate y*0.075 }
	  translate y
   }
   bounded_by { box { <-0.65, 0, -0.65> <0.65, 0.75, 0.65> scale 2 } }
   texture { Lamp_Chrome }
   scale <1.3, 3.3, 1.3>
   scale 0.5
}



#declare Lamp_Spacing = 0.225
#declare Lamp_Radius = 0.185
#declare Lamp_Dimmer = 0.75 // 0.9 //0.75
#declare Lamp_Color = <1.0, 0.9, 0.65>

#declare Lamp_LightSource = object {
   light_source {
      <0, 0.05, 0> color rgb Lamp_Color*Lamp_Dimmer
      //area_light 0.15*x, 0.15*z, 2, 2  adaptive 0  jitter
      looks_like {
         union {
            sphere {
               0*y, Lamp_Radius
               texture {
                  pigment { color rgb Lamp_Color }
                  finish  { ambient 1.0 }
               }
               scale <1, 0.5, 1>
            }
            torus { Lamp_Radius, 0.025 texture { Lamp_Chrome } }
         }
      }
   }
}

#declare Lamp = object {
   union {
      difference {
         object { Lamp_Body }
         sphere { 0*y, Lamp_Radius translate <-Lamp_Spacing, 0.25, -Lamp_Spacing> }
         sphere { 0*y, Lamp_Radius translate < Lamp_Spacing, 0.25, -Lamp_Spacing> }
         sphere { 0*y, Lamp_Radius translate <-Lamp_Spacing, 0.25,  Lamp_Spacing> }
         sphere { 0*y, Lamp_Radius translate < Lamp_Spacing, 0.25,  Lamp_Spacing> }
      }

      object { Lamp_LightSource translate <-Lamp_Spacing, 0.25, -Lamp_Spacing> }
      object { Lamp_LightSource translate < Lamp_Spacing, 0.25, -Lamp_Spacing> }
      object { Lamp_LightSource translate <-Lamp_Spacing, 0.25,  Lamp_Spacing> }
      object { Lamp_LightSource translate < Lamp_Spacing, 0.25,  Lamp_Spacing> }

      sphere { 0*y, 0.10 translate y*0.25 texture { Lamp_Chrome } }

      // -------- Support
      union {
         sphere { 0*y, 0.30 scale <1, 0.45, 1> }
         cylinder { 0*y, -0.3*y, 0.075 }
         torus { 0.075, 0.040 translate -y*0.25 }
         cylinder { -0.3*y, -0.6*y, 0.05 }
         cylinder { 0*x, 1.8*x, 0.0075 translate -y*0.225 }
         cylinder { 0*x, 1.8*x, 0.0075 translate -y*0.275 }
         rotate -y*25
         texture { Lamp_Chrome }
      }

      // -------- Handle
      union {
         cylinder { 0*x, 0.7*x, 0.0175 }
         cone { 0*x, 0.0175, 0.15*x, 0.05 translate x*0.9 }
         torus { 0.05, 0.01 rotate -z*90 translate x*1.05 }
         cylinder { 0*x, 0.25*x, 0.05 translate x*1.05 texture { Lamp_Rubber } }
         torus { 0.05, 0.01 rotate -z*90 translate x*1.30 }
         sphere { 0*x, 0.05 translate x*1.30 }
         texture { Lamp_Chrome }
         rotate z*20
         translate -y*0.25
         rotate -y*260 //225
      }

      //rotate -x*90
      //rotate y*45
   }
}


#if ( Is_Inc_File = false )
object { Lamp }
#end
