global_settings {max_trace_level 30}
#include "colors.inc"
#include "shapes.inc"

#declare camera_location = <0,-40, -300>
#declare camera_look_at = <0,0, 0>

camera {
        location camera_location
        look_at camera_look_at
}

// STARFIELD
#declare star_count = 2000
#declare star_scale = .5
#include "GALAXY.SF"
#declare galaxy_seed = 1
#declare star_count = 500
#declare star_type = 3
#declare star_colour = <1,.9,.7>
#declare star_scale = 1
#include "GALAXY.SF"
#declare galaxy_bgstars = 2
#declare galaxy_bgnebula = false
#declare galaxy_nebula_sphere = false
#include "GALAXY.BG"

//Sonne
#declare effect_type = "Sun"
#declare effect_always_on_top = false
#declare effect_falloff = 30
#declare rays_flicker = true
#declare effect_colour = <1.4, 1, 1>
#declare source_colour = <1.3, 1.3, .7>
#declare effect_brightness = 5
#declare effect_location = <-400,500,1000>
#declare effect_scale = .8
#include "LENS.INC"
light_source {effect_location rgb 2}

//Warptor
#declare effect_location = <200, 20, 100>
#declare effect_type = "Camera2" #include "LENS.INC"
light_source {effect_location rgb 1/2}
#declare glow_type = 1
#declare rays_type = 0
#declare streak_type = 0
#declare custom_effect_file = "SPIRAL.LFX"
#declare effect_colour = <6, 1, 4>
#declare source_colour = <1.3, 1.3, .9>
#declare effect_location = <240, 20, 200>
#include "LNSEFCTS.INC"
light_source {effect_location rgb 1}

#declare Mond =
sphere {0, 1 pigment {bozo color_map {[0 rgb .4] [1 rgb .8]} scale .4}
normal {bump_map {gif "map.gif" map_type 1 interpolate 2} bump_size 3}}

//Monde
object {Mond translate <5,10,10> scale 20}
object {Mond translate <8,-5,3> scale 25}

//Planet mit Atmosphre
sphere {0,1 pigment {image_map{tga "plantex.tga" map_type 1 interpolate 2}}
normal {bump_map {gif "map.gif" map_type 1 interpolate 2} bump_size 2}
scale 150 translate <-200,-10,0>}
sphere {0,1 pigment {color rgbt <1,1,1,1>} halo {attenuating spherical_mapping linear
color_map {[ 0 color rgbt <1,1,1,.8>][ 1 color rgbt <1,1,1,0>]}samples 10 }hollow
scale 250 translate <-200,-10,0>}

//Standardlicht
light_source {<100,20,-500>color rgb 1/4}

//Raumschiff
object {#include"nhawk.pov"scale .125
rotate <90,-90,0> rotate <-60,-60,0>translate <10,-15,-200>
}

//Feuer
sphere { 0,1 pigment { color rgbt <1,1,1,1>}halo { emitting spherical_mapping linear
turbulence 1 color_map {[ 0 color rgbt <1, 0, 0,  1> ][ 1 color rgbt <1, 1, 0, -1> ]}samples 20}hollow
rotate z*90 scale <15,15,10> translate <0,18,0>
rotate <90,-90,0> rotate <-60,-60,0>translate <10,-15,-200>
}
