global_settings {max_trace_level 30}
#include "colors.inc"
#include "shapes.inc"

#declare camera_location = <-5,20,-13>
#declare camera_look_at = <0,0,0>

camera {
location camera_location
look_at camera_look_at
aperture 0.2
blur_samples 4
focal_point <0,0,0>
}

light_source {<-20,40,-20> color White  area_light <5, 0, 0>, <0, 0, 5>, 5, 2  adaptive 1 atmosphere off}
light_source {<-20,40,-20> color rgb <1,1,1>/4 spotlight point_at <0, 0, 0> radius 1 tightness 1 falloff 20}

union {
union {
box {<10,.5,10><-10,0,-10>pigment {image_map {tga "cjmem1.tga"}rotate <90,0,0> translate -.5 scale 20}}
box{<11,0,10><16,.5,-10>pigment {image_map {tga "menu.tga"}rotate <90,0,0> translate -.5 scale <5,1,20>translate <3.5,0,0>}}
box{<-10,0,-11><16,.5,-16>pigment {image_map {tga "text.tga"}rotate <90,0,0> translate -.5 scale <26,1,5>translate <-23,0,11.5>}}
finish {ambient 1 diffuse 0 phong 1 phong_size 100000}
}

difference {
superellipsoid {<0.25, 0.25>scale <15,1,15>translate <3,0,-3>}
box{<10,0,10><-10,5,-10>}
box{<11,0,10><16,5,-10>}
box{<-10,0,-11><16,5,-16>}
pigment {GreenYellow} normal {crackle .1 bump_size .5 rotate x*90}
finish {diffuse .4 ambient .2}
}

box{<10,.6,10><-10,.9,-10>pigment {White filter 1}finish {ambient 1 diffuse 0  reflection .25}}
box{<11,.6,10><16,.9,-10>pigment {White filter 1}finish {ambient 1 diffuse 0  reflection .1}}
box{<-10,.6,-11><16,.9,-16>pigment {White filter 1}finish {ambient 1 diffuse 0 reflection .075}}
rotate y*30
translate z*3
scale .75
}

//Fusse
blob {threshold 0.6
component 1.0, 1.59972, <0.2, 0.0, 0.0>  component 1.0, 1.4348, <0.2, -1.8, 0.0>  component 1.0, 0.983246, <1.0, -1.2, 0.0>  component 1.0, 1.191502, <1.6, -0.8, 0.0>  component 1.0, 0.941965, <2.0, -0.2, 0.0>  component 1.0, 0.842519, <2.2, 0.4, 0.0>  component 1.0, 0.941965, <0.759494, 0.911392, 0.0>  component 1.0, 1.191502, <0.8, 1.4, 0.0>  component 1.0, 0.941965, <0.8, 2.2, 0.0>  component 1.0, 0.941965, <0.8, 2.8, 0.0>  component 1.0, 1.191502, <1.0, 3.4, 0.0>  component 1.0, 1.191502, <-0.8, 0.6, 0.0>  component 1.0, 1.263779, <-1.0, 1.6, 0.0>  component 1.0, 0.941965, <-1.0, 2.2, 0.0> component 1.0, 1.33214, <-1.0, 2.8, 0.0>  component 1.0, 1.33214, <-1.0, 3.4, 0.0>  component 1.0, 0.78531, <2.4, 1.2, 0.0>  component 1.0, 1.518873, <-0.6, -0.8, 0.0>  component 1.0, 0.42126, <2.6, 1.8, 0.0>  component 1.0, 0.42126, <-0.4, -2.4, 0.0>  component 1.0, 0.941965, <-0.8, -1.8, 0.0>  component 1.0, 1.88393, <0.0, -0.8, 1.6>  component 1.0, 0.941965, <0.0, -1.4, 1.0>  component 1.0, 1.191502, <0.0, -0.6, 2.8>  component 1.0, 1.787253, <0.0, -0.6, 4.4>  component 1.0, 1.787253, <0.0, -0.4, 6.4>  component 1.0, 1.736898, <0.0, -0.4, 8.8>  component 1.0, 2.148011, <0.0, -0.2, 10.2>  component 1.0, 1.787253, <0.0, -0.2, 7.8>  component 1.0, 1.33214, <0.0, -0.6, 5.6>  component 1.0, 1.33214, <0.0, -1.0, 3.4>  component 1.0, 0.941965, <0.0, 0.0, 0.8>  component 1.0, 1.191502, <0.8, 0.0, 0.8>  component 1.0, 0.842519, <-0.8, 0.0, 1.0>  component 1.0, 0.595751, <-0.6, 0.0, 2.6>  component 1.0, 0.595751, <0.0, 0.4, 4.2>  component 1.0, 0.595751, <0.0, 0.4, 5.0>  component 1.0, 0.42126, <0.0, 0.6, 6.0>  component 1.0, 0.42126, <0.0, 0.6, 7.2>  component 1.0, 0.595751, <0.0, 0.6, 8.4>  component 1.0, 0.595751, <0.0, 0.8, 9.6>  component 1.0, 0.941965, <0.6, 0.0, 2.4>  component 1.0, 0.941965, <-0.4, 0.0, 5.0>  component 1.0, 0.842519, <0.6, 0.0, 7.0>  component 1.0, 0.941965, <-0.6, 0.0, 7.2>  component 1.0, 0.595751, <-0.6, 0.0, 5.6>
component 1.0, 0.941965, <0.6, 0.0, 5.4>  component 1.0, 0.842519, <0.6, 0.0, 3.2>  component 1.0, 0.941965, <-0.4, 0.0, 3.6>  component 1.0, 0.941965, <0.6, 0.0, 9.4>  component 1.0, 0.842519, <0.6, 0.0, 8.4>  component 1.0, 0.941965, <-0.6, 0.0, 9.4>  component 1.0, 0.941965, <-0.6, 0.0, 8.2>
pigment {bozo turbulence 0.95
color_map
{
  [  0.1  color DarkOliveGreen]
  [  0.3  color DarkGreen]
  [  0.5  color PaleGreen]
  [  0.7  color SeaGreen]
  [  1.0  color MediumSeaGreen]
}
}
normal {bumps 1 bump_size 2}
normal {bump_map{ tga "bump2.tga" map_type 0 bump_size 2}}
rotate <-100,180,10>
scale 2
rotate y*50
translate <10,2.2,-5>
}

blob {threshold 0.6
component 1.0, 1.59972, <0.2, 0.0, 0.0>  component 1.0, 1.4348, <0.2, -1.8, -0.2>  component 1.0, 0.983246, <0.8, -1.2, -0.2>  component 1.0, 1.191502, <-1.6, -1.0, 0.0>  component 1.0, 0.941965, <-2.2, -0.4, 0.0>  component 1.0, 0.842519, <-2.4, 0.2, -0.4>  component 1.0, 0.941965, <0.8, 0.8, -0.2>  component 1.0, 1.191502, <1.0, 1.6, -0.4>
component 1.0, 0.941965, <1.0, 2.2, -0.6>  component 1.0, 0.941965, <1.2, 2.8, -0.8>  component 1.0, 1.191502, <1.0, 3.6, -1.0>  component 1.0, 1.191502, <-0.8, 0.6, -0.4>  component 1.0, 1.263779, <-0.8, 1.6, -0.6>  component 1.0, 0.941965, <-0.8, 2.2, -0.6>  component 1.0, 1.33214, <-0.8, 2.8, -1.0>  component 1.0, 1.33214, <-1.0, 3.6, -0.8>  component 1.0, 0.78531, <-2.4, 1.0, -0.4>  component 1.0, 1.518873, <-0.6, -0.8, 0.0>  component 1.0, 0.42126, <-2.6, 1.4, -0.6>  component 1.0, 0.42126, <-0.4, -2.4, -0.2>  component 1.0, 0.941965, <-0.8, -1.8, -0.2>  component 1.0, 1.88393, <0.0, -0.8, 1.6>  component 1.0, 0.941965, <0.0, -1.4, 1.0>  component 1.0, 1.191502, <0.0, -0.6, 2.8>  component 1.0, 1.787253, <0.0, -0.6, 4.4>  component 1.0, 1.787253, <0.0, -0.4, 6.4>  component 1.0, 1.736898, <0.0, -0.8, 9.0>  component 1.0, 2.148011, <0.0, -0.6, 10.4>  component 1.0, 1.787253, <0.0, -0.6, 7.8>  component 1.0, 1.33214, <0.0, -0.6, 5.6>  component 1.0, 1.33214, <0.0, -1.0, 3.4>  component 1.0, 0.941965, <0.0, 0.0, 0.8>  component 1.0, 1.191502, <0.8, 0.0, 0.8>  component 1.0, 0.842519, <-0.8, 0.0, 1.0>  component 1.0, 0.595751, <-0.6, 0.0, 2.6>  component 1.0, 0.595751, <0.0, 0.4, 4.2>  component 1.0, 0.595751, <0.0, 0.4, 5.0>  component 1.0, 0.42126, <0.0, 0.6, 6.0>  component 1.0, 0.42126, <0.0, 0.6, 7.2>  component 1.0, 0.595751, <0.0, 0.4, 8.4>  component 1.0, 0.595751, <0.0, 0.2, 9.6>  component 1.0, 0.941965, <0.6, 0.0, 2.4>  component 1.0, 0.941965, <-0.4, 0.0, 5.0>  component 1.0, 0.842519, <0.6, 0.0, 7.0>  component 1.0, 0.941965, <-0.6, 0.0, 7.2>  component 1.0, 0.595751, <-0.6, 0.0, 5.6>  component 1.0, 0.941965, <0.6, 0.0, 5.4>  component 1.0, 0.842519, <0.6, 0.0, 3.2>  component 1.0, 0.941965, <-0.4, 0.0, 3.6>  component 1.0, 0.941965, <0.6, -0.6, 9.4>  component 1.0, 0.842519, <0.6, -0.2, 8.4>  component 1.0, 0.941965, <-0.6, -0.6, 9.6>  component 1.0, 0.941965, <-0.6, -0.2, 8.0>
pigment {bozo turbulence 0.95
color_map
{
  [  0.1  color ForestGreen]
  [  0.3  color DarkGreen]
  [  0.5  color PaleGreen]
  [  0.7  color SeaGreen]
  [  1.0  color MediumSeaGreen]
}
}
normal {bumps 1 bump_size 2}
rotate <-80,180,-10>
scale 2
translate <-7,4.5,3>
rotate y*10
normal {bump_map{ tga "bump2.tga" map_type 0 bump_size 2}}
}
sphere {<0,0,0>,1 pigment {SeaGreen}normal {bump_map{ tga "bump2.tga" map_type 0 bump_size 2}}scale <8,10,5>translate <3,30,0>}

//Rest
plane {y,0 pigment {checker color DimGray color Gray20}
normal {bump_map{ tga "bump.tga" map_type 0 bump_size 1}rotate x*90}
finish{ambient .2 diffuse .5}
scale 10
}
box {<1000,50,1000>,<-1000,60,-1000> pigment {Black}finish{ambient .5}}

//Blut
prism { linear_sweep quadratic_spline  -1.0,0.0  18
<-1.629884, -2.212544>,<-1.042463, -1.997877>,<-0.565529, -2.175712>,<-0.042463, -1.846868>,
<0.531595, -1.673116>,<0.893843, -1.605096>,<0.846917, -0.367879>,<0.867834, 0.29724>,
<2.381469, 0.437915>,<1.636943, 2.072187>,<0.305503, 2.366604>,<-0.690021, 2.112261>,
<-1.337465, 2.095312>,<-1.870488, 1.583864>,<-2.212722, -0.37205>,<-1.982484, -1.528662>,
<-1.629884, -2.212544>,<-1.042463, -1.997877>
pigment {bozo turbulence 0.95
color_map
{
  [  0.1  color Red filter 1]
  [  0.3  color Firebrick filter 1]
  [  0.5  color IndianRed filter 1]
  [  0.7  color MediumVioletRed filter 1]
  [  1.0  color OrangeRed filter 1]
}
}

rotate <0,30,0>
scale <8,0,8>
translate <-10,.2,3>
normal {bumps 1 bump_size .5 rotate x*90}
finish { ambient 1 diffuse 1 reflection .5 specular .25}
//finish {irid {.35 thickness .1 turbulence 0}}
}

//hand
blob {threshold .65
  sphere { <-.23,-.32,0>,.43, 1 scale <1.95,1.05,.8> }   //palm
  sphere { <+.12,-.41,0>,.43, 1 scale <1.95,1.075,.8> }  //palm
  sphere { <-.23,-.63,0>, .45, .75 scale <1.78, 1.3,1> } //midhand
  sphere { <+.19,-.63,0>, .45, .75 scale <1.78, 1.3,1> } //midhand
  sphere { <-.22,-.73,0>, .45, .85 scale <1.4, 1.25,1> } //heel
  sphere { <+.19,-.73,0>, .45, .85 scale <1.4, 1.25,1> } //heel
  cylinder { <-.65,-.28,0>, <-.65,.28,-.1>, .26, 1 }    //lower pinky
  cylinder { <-.65,.28,-.1>, <-.65, .5,-.3>, .26, 1 }  //upper pinky
  cylinder { <-.3,-.28,0>, <-.3,.44,-.15>, .26, 1 }      //lower ring
  cylinder { <-.3,.44,-.15>, <-.3, .7,-.5>, .26, 1 }     //upper ring
  cylinder { <.05,-.28,0>, <.05, .49,-.15>, .26, 1 }     //lower middle
  cylinder { <.05,.49,-.15>, <.05, .75,-.6>, .26, 1 }    //upper middle
  cylinder { <.4,-.4,0>, <.4, .512, -.25>, .26, 1 }      //lower index
  cylinder { <.4,.512,-.25>, <.4, .55, -.5>, .26, 1 }    //upper index
  cylinder { <.41, -.95,0>, <.85, -.68, -.05>, .25, 1 }  //lower thumb
  cylinder { <.85,-.68,-.05>, <1.2, -.4, -.2>, .25, 1 }  //upper thumb
  cylinder { <0,-4,-.5>, <0,-1, -.2>, .8,1 scale <1,1,.6>}  //Arm
  cylinder { <0,-6,-.5>, <0,-2.1, -.2>, .9,1 scale <1,1,.6>}  //Arm
  cylinder { <0,-6,-.5>, <0,-3, -.2>, 1,1 scale <1,1,.6>}  //Arm
  cylinder { <0,-6,-.5>, <0,-4, -.2>, 1,1 scale <1,1,.6>}  //Arm
  sphere { <-.65,.28,-.1>, .26, -1 } //counteract pinky knuckle bulge
  sphere { <-.65,-.28,0>, .26, -1 }   //counteract pinky palm bulge
  sphere { <-.3,.44,-.15>, .26, -1 }  //counteract ring knuckle bulge
  sphere { <-.3,-.28,0>, .26, -1 }    //counteract ring palm bulge
  sphere { <.05,.49,-.15>, .26, -1 }  //counteract middle knuckle bulge
  sphere { <.05,-.28,0>, .26, -1 }    //counteract middle palm bulge
  sphere { <.4,.512,-.25>, .26, -1 }  //counteract index knuckle bulge
  sphere { <.4,-.4,0>, .26, -1 }      //counteract index palm bulge
  sphere { <.85,-.68,-.05>, .25, -1 } //counteract thumb knuckle bulge
pigment { Flesh }
normal {agate 1 bump_size .5}
scale 4
rotate <90,120,0>
translate <0,1.5,0>
}

//Kanone
union {
union {
difference {
cylinder {<-30,1.1,5><0,1.1,5>.8}
cylinder {<-31,1.1,5><1,1.1,5>.6}
pigment {Black}
normal {bumps .1 bump_size .1}
finish { specular .5 reflection .25 }
}
difference {
cylinder {<-4,1.1,5><-2,1.1,5>1}
cylinder {<-5,1.1,5><-1,1.1,5>.8}
pigment {Gray50}
finish { specular .5 reflection .25 }
}
difference {
cylinder {<-4,1.1,3><-3.5,1.1,3>1.1}
cylinder {<-5,1.1,3><-2,1.1,3>1}
pigment {Gray50}
finish { specular .5 reflection .25 }
}
difference {
cylinder {<-3.9,1.1,3><-2.1,1.1,3>1}
cylinder {<-5,1.1,3><-2,1.1,3>.9}
pigment {Gray50}
finish { specular .5 reflection .25 }
}
difference {
cylinder {<-3.5,1.1,3><-3.4,1.1,3>.9}
box {<-4,-3,-5><-2,3,3>}
pigment {White}
finish { specular .5 reflection .25 }
}
translate <0,1,0>
}
lathe {linear_spline 5 <0.51758, -4.479669>,<0.514483, 1.551823>,<0.693794, 2.137061>,<1.031871, 4.271575>,<1.035595, 4.814877>
rotate z*90 translate <0,2,-6.5> rotate y*180
translate <-4,0,1>
pigment {Black}
finish { specular .5 reflection .25 }
}
light_source { <0,0,0>color rgb <1,1,1> spotlight point_at <10,0,0> radius 10 tightness 10 falloff 10 translate <-5,2,7.5>}

lathe {linear_spline 14 <0.014085, -2.205008>,<0.209703, -2.111502>,<0.303599, -1.950724>,<0.233177, -1.793046>,<0.076682, -1.658842>,<0.661581, -1.421064>,<0.73192, -1.136781>,<0.71831, 1.061659>,<0.647887, 1.283192>,<0.71831, 1.490322>,<0.608764, 3.042254>,<0.418623, 3.99662>,<0.180829, 4.041897>,<0.00626, 3.054147>
rotate <0,0,90>rotate <0,180,0>
translate <-2.5,3.6,5>
pigment {Black}
finish { specular .5 reflection .25 }
}
light_source { <0,0,0>color Red*40 spotlight cylinder point_at <100,0,0> radius 3 tightness 50 falloff 7 translate <1,3.6,5>}
rotate y*20
translate <5,-.9,9>
}

atmosphere {type 1 samples 25 distance 100 scattering 0.05 aa_level 8 aa_threshold 0.3 jitter 1}

