//  Persistance of Vision Raytracer V3.0
//  World definition file.
//
//  Contains 13 lights, 52 textures and 412 primitives.
//
//  This file was generated for POV-Ray V3.0 by
//  Moray V3.01 For Windows (c) 1991-1998 Lutz + Kretzschmar
//

//  Date : 12/14/1998    (14.12.1998)
//

/*
  The text between these two comments is in MorayPOV.INC and is
  automatically included in all POV files that Moray exports.
*/

/* // Scene Comment

This scene was created with Moray For Windows.

*/ // End Scene Comment

global_settings {
  adc_bailout 0.003922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 1.9
  hf_gray_16 off
  irid_wavelength <0.247059,0.176471,0.137255>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
  radiosity {
    brightness       3.3
    count            100
    distance_maximum 0.0
    error_bound      0.4
    gray_threshold   0.5
    low_error_factor 0.8
    minimum_reuse    0.015
    nearest_count    6
    recursion_limit  1
  }
}

background { color <0.698,0.698,0.698> }

fog {
  fog_type 1    // Constant
  distance     275.0
  color <0.0,0.0,0.0,0.0,0.0>
}

camera {  //  Camera StdCam
  location  <178.028, 62.282, 115.486>
  direction <0.0,     0.0,  1.8317>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333,  0.0,  0.0>
  look_at   <26.970, 160.741, 101.298>
}

//    Other cameras are commented out.
/*
camera {  //  Camera SpotCam001
  location  <152.957, 68.789, 113.780> // Attached to HelmetLight1
  direction <0.0,     0.0,  0.8660>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333,  0.0,  0.0>
  look_at   <152.345, 69.401, 113.280> // Following HelmetLight1
}

*/

/*
camera {  //  Camera TableSpotCam
  location  <127.000, 113.999, 125.000> // Attached to TableSpot
  direction <0.0,     0.0,  0.7141>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333,  0.0,  0.0>
  look_at   <127.000, 114.000, 124.000> // Following TableSpot
}

*/

/*
camera {  //  Camera PaintSpotCam
  location  <-66.600, 140.866, 142.000> // Attached to PaintSpot1
  direction <0.0,     0.0,  0.7141>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333,  0.0,  0.0>
  look_at   <-67.495, 140.866, 141.555> // Following PaintSpot1
}

*/

/*
camera {  //  Camera ShipSpotCam
  location  <-21.424, 170.238, 136.066> // Attached to ShipSpot1
  direction <0.0,     0.0,  0.8660>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333,  0.0,  0.0>
  look_at   <-21.766, 170.238, 135.126> // Following ShipSpot1
}

*/

/*
camera {  //  Camera SpotCam002
  location  <85.805, 145.499, 124.238> // Attached to StatueSpot1
  direction <0.0,     0.0,  1.7437>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333,  0.0,  0.0>
  look_at   <85.805, 146.218, 123.543> // Following StatueSpot1
}

*/

//
// *******  L I G H T S *******
//

light_source {   // RoofLight2
  <24.133, 190.549, 135.000>
  color rgb <1.000, 1.000, 1.000>
  shadowless
}

light_source {   // RoofLight1
  <55.262, 143.986, 190.797>
  color rgb <0.850, 0.850, 0.850>
  shadowless
}

light_source {   // Spotlight StatueSpot3
  <94.051, 145.499, 124.238>
  color  rgb <0.700, 0.700, 0.700>
  spotlight
    point_at  <94.051, 146.218, 123.543>
    falloff   16.00  // outer radius (in deg)
      radius    14.00  // inner radius
}

light_source {   // Spotlight StatueSpot2
  <101.758, 145.499, 124.238>
  color  rgb <0.700, 0.700, 0.700>
  spotlight
    point_at  <101.758, 146.218, 123.543>
    falloff   16.00  // outer radius (in deg)
      radius    14.00  // inner radius
}

light_source {   // Spotlight StatueSpot1
  <85.805, 145.499, 124.238>
  color  rgb <0.700, 0.700, 0.700>
  spotlight
    point_at  <85.805, 146.218, 123.543>
    falloff   16.00  // outer radius (in deg)
      radius    14.00  // inner radius
}

light_source {   // Spotlight ShipSpot1
  <-21.424, 170.238, 136.066>
  color  rgb <1.000, 1.000, 1.000>
  spotlight
    point_at  <-21.766, 170.238, 135.126>
    falloff   30.00  // outer radius (in deg)
      radius    29.00  // inner radius
}

light_source {   // Spotlight PaintSpot2
  <-66.600, 156.783, 142.000>
  color  rgb <1.000, 1.000, 1.000>
  spotlight
    point_at  <-67.495, 156.783, 141.555>
    falloff   35.00  // outer radius (in deg)
      radius    34.50  // inner radius
}

light_source {   // Spotlight PaintSpot1
  <-66.600, 140.866, 142.000>
  color  rgb <1.000, 1.000, 1.000>
  spotlight
    point_at  <-67.495, 140.866, 141.555>
    falloff   35.00  // outer radius (in deg)
      radius    34.50  // inner radius
}

light_source {   // Spotlight TableSpot
  <127.000, 114.000, 125.000>
  color  rgb <1.000, 1.000, 1.000>
  spotlight
    point_at  <127.000, 114.000, 124.000>
    falloff   35.00  // outer radius (in deg)
      radius    34.00  // inner radius
  fade_distance  7.0
  fade_power 1.0
}

light_source {   // Spotlight HelmetLight2
  <152.957, 74.229, 113.780>
  color  rgb <1.000, 1.000, 1.000>
  spotlight
    point_at  <152.345, 73.617, 113.280>
    falloff   30.00  // outer radius (in deg)
      radius    29.00  // inner radius
  fade_distance  7.0
  fade_power 1.0
}

light_source {   // Spotlight HelmetLight1
  <152.957, 68.789, 113.780>
  color  rgb <0.800, 0.800, 0.800>
  spotlight
    point_at  <152.345, 69.401, 113.280>
    falloff   30.00  // outer radius (in deg)
      radius    29.00  // inner radius
  fade_distance  6.0
  fade_power 8.0
}

light_source {   // CameraLight
  <180.000, 60.000, 116.000>
  color rgb <0.650, 0.650, 0.650>
}

light_source {   // Spotlight ShipSpot2
  <-21.356, 191.034, 136.201>
  color  rgb <1.000, 1.000, 1.000>
  spotlight
    point_at  <-21.698, 191.034, 135.261>
    falloff   30.00  // outer radius (in deg)
      radius    29.00  // inner radius
  atmosphere off
}


//
// ********  TEXTURES  *******
//

#include "anexhibit.inc"


//
// ********  REFERENCED OBJECTS  *******
//

#declare CutBtm = object {
  cylinder { // CutBtm
    <0,0,1>, <0,0,0>, 1 
    translate  0.6*x
  }
}
#declare Cutmiddle = object {
  box { // Cutmiddle
    <-1, -1, -1>, <1, 1, 1>
    scale <1.8, 0.986223, 0.5>
    translate  <2.4, 0.0, 0.5>
  }
}
#declare CutTop = object {
  cylinder { // CutTop
    <0,0,1>, <0,0,0>, 1 
    translate  4.2*x
  }
}
#declare LampDone1 = union { // LampDone1
  torus { // LampEdge
    1.75, 0.25  rotate -x*90
    texture {
      Plastic_Black
    }
    scale <1.2, 1.2, 1.0>
    translate  <101.686724, 157.519745, 121.490499>
  }
  sphere { // Lamp1
    <0,0,0>,1
    texture {
      BrightLightYellow
    }
    scale <2.2, 2.2, 0.309427>
    translate  <101.702021, 157.53491, 121.423169>
  }
  translate  <0.0231, 10.2541, 0.0>
}


#declare WallTransmitNode = union {
  cylinder { // TransmitLeg7
    <0,0,1>, <0,0,0>, 1 
    scale <0.08, 0.08, 0.4>
    translate  0.031379*z
  }
  sphere { // TransmitCore3
    <0,0,0>,1
    scale 0.1
  }
  cylinder { // TransmitLeg8
    <0,0,1>, <0,0,0>, 1 
    scale <0.08, 0.08, 0.4>
    rotate -90.0*x
    translate  0.030318*y
  }
  cylinder { // TransmitLeg9
    <0,0,1>, <0,0,0>, 1 
    scale <0.08, 0.08, 0.4>
    rotate <-90.0, -0.0, -90.0>
    translate  0.000192*y
  }
  cylinder { // Beam3
    <0,0,1>, <0,0,0>, 1 
    texture {
      Lightning
    }
    scale <0.06, 0.06, 10.0>
    rotate <-90.0, -0.0, -90.0>
    translate  0.25*x
  }
  texture {
    Plastic_Black
  }
  no_shadow
  hollow
  scale 3.0
  rotate <-90.0, 0.0, -0.0>
  translate  <77.574188, 154.236597, 122.036647>
}
#declare WallTransmitNode2 = union {
  cylinder { // TransmitLeg10
    <0,0,1>, <0,0,0>, 1 
    scale <0.08, 0.08, 0.4>
    translate  0.031379*z
  }
  sphere { // TransmitCore4
    <0,0,0>,1
    scale 0.1
  }
  cylinder { // TransmitLeg11
    <0,0,1>, <0,0,0>, 1 
    scale <0.08, 0.08, 0.4>
    rotate -90.0*x
    translate  0.030318*y
  }
  cylinder { // TransmitLeg12
    <0,0,1>, <0,0,0>, 1 
    scale <0.08, 0.08, 0.4>
    rotate <-90.0, -0.0, -90.0>
    translate  0.000192*y
  }
  cylinder { // Beam4
    <0,0,1>, <0,0,0>, 1 
    texture {
      Lightning
    }
    scale <0.06, 0.06, 6.0>
    rotate <-90.0, -0.0, -90.0>
    translate  0.25*x
  }
  texture {
    Plastic_Black
  }
  no_shadow
  hollow
  scale 3.0
  rotate <-90.0, 90.0, -0.0>
  translate  <109.585271, 154.236597, 122.053951>
}


#declare FloorBoard1 = object {
  box { // FloorBoard1
    <-1, -1, -1>, <1, 1, 1>
    texture {
      LightOakwVarnish
    }
    scale <15.0, 1.5, 0.1>
    translate  <130.724448, 70.249481, 100.0>
  }
}
#declare Floor = union {
  object { FloorBoard1 }
  object { // FloorBoard2->FloorBoard1
    FloorBoard1
    rotate -0.0*x
    translate  <-15.0, 3.15, 0.0>
  }
  object { // FloorBoard3->FloorBoard1
    FloorBoard1
    rotate -0.0*x
    translate  <-30.0, 6.3, 0.0>
  }
  object { // FloorBoard4->FloorBoard1
    FloorBoard1
    rotate -0.0*x
    translate  <-45.0, 9.45, 0.0>
  }
  object { // FloorBoard5->FloorBoard1
    FloorBoard1
    rotate -0.0*x
    translate  <-60.0, 12.6, 0.0>
  }
  object { // FloorBoard6->FloorBoard1
    FloorBoard1
    rotate -0.0*x
    translate  <-75.0, 15.75, 0.0>
  }
  object { // FloorBoard7->FloorBoard1
    FloorBoard1
    rotate -0.0*x
    translate  <-90.0, 18.9, 0.0>
  }
  object { // FloorBoard8->FloorBoard1
    FloorBoard1
    rotate -0.0*x
    translate  <-105.0, 22.05, 0.0>
  }
  object { // FloorBoard9->FloorBoard1
    FloorBoard1
    rotate -0.0*x
    translate  <-120.0, 25.2, 0.0>
  }
  object { // FloorBoard10->FloorBoard1
    FloorBoard1
    rotate -0.0*x
    translate  <-135.0, 28.35, 0.0>
  }
  object { // FloorBoard11->FloorBoard1
    FloorBoard1
    rotate -0.0*x
    translate  <-150.0, 31.5, 0.0>
  }
  object { // FloorBoard12->FloorBoard1
    FloorBoard1
    rotate -0.0*x
    translate  <-165.0, 34.65, 0.0>
  }
  object { // FloorBoard13->FloorBoard1
    FloorBoard1
    rotate -0.0*x
    translate  <-180.0, 37.8, 0.0>
  }
  object { // FloorBoard14->FloorBoard1
    FloorBoard1
    rotate -0.0*x
    translate  <-195.0, 40.95, 0.0>
  }
  object { // FloorBoard15->FloorBoard1
    FloorBoard1
    rotate -0.0*x
    translate  <-210.0, 44.1, 0.0>
  }
  object { // FloorBoard16->FloorBoard1
    FloorBoard1
    rotate -0.0*x
    translate  <-225.0, 47.25, 0.0>
  }
  object { // FloorBoard17->FloorBoard1
    FloorBoard1
    rotate -0.0*x
    translate  <-240.0, 50.4, 0.0>
  }
  object { // FloorBoard18->FloorBoard1
    FloorBoard1
    rotate -0.0*x
    translate  <-255.0, 53.55, 0.0>
  }
  object { // FloorBoard19->FloorBoard1
    FloorBoard1
    rotate -0.0*x
    translate  <-270.0, 56.7, 0.0>
  }
  object { // FloorBoard20->FloorBoard1
    FloorBoard1
    rotate -0.0*x
    translate  <-285.0, 59.85, 0.0>
  }
  object { // FloorBoard21->FloorBoard1
    FloorBoard1
    rotate -0.0*x
    translate  <-300.0, 63.0, 0.0>
  }
  translate  <0.938429, 5.0, -20.182131>
}


#declare Engine1 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  15  // control points
  <-1.0, -0.2569>,
  <-0.575794, -0.584713>,
  <0.212017, -0.764331>,
  <1.002335, -0.830149>,
  <1.859204, -0.766454>,
  <2.557818, -0.55414>,
  <3.006369, -0.246285>,
  <3.006369, 0.246285>,
  <2.482133, 0.614358>,
  <1.825456, 0.755308>,
  <1.003397, 0.85138>,
  <0.238301, 0.77707>,
  <-0.563873, 0.585987>,
  <-1.0, 0.288747>,
  <-1.0, -0.2569>
  rotate -x*90
  texture {
    MottledBlueRed
  }
  scale <2.0, 1.5, 0.65>
  rotate <3.334414, 0.0, -90.0>
  translate  <-8.267781, 2.0, 0.0>
}
#declare ArmCutters = union {
  box { // EngineArm1
    <-1, -1, -1>, <1, 1, 1>
    scale <2.0, 0.35, 0.65>
    translate  <-5.256116, 0.64, 0.624552>
  }
  cylinder { // ArmCut1
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 1.282689>
    translate  <-3.248408, 1.28, -0.019536>
  }
  cylinder { // ArmCut2
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 1.282689>
    translate  <-3.248408, -1.28, -0.019536>
  }
  box { // EngineArm2
    <-1, -1, -1>, <1, 1, 1>
    scale <2.0, 0.35, 0.65>
    translate  <-5.256116, -0.64, 0.624552>
  }
}
#declare EngineArmDone = difference {
  box { // EngineArm
    <-1, -1, -1>, <1, 1, 1>
    scale <3.199199, 0.5, 0.6>
    translate  <-4.86898, 0.024291, 0.624552>
  }
  object { ArmCutters }
  texture {
    MottledBlueRed
  }
}
#declare EngineDone = union {
  object { EngineArmDone }
  torus { // EngineCurve
    1.9, 0.1  rotate -x*90
    texture {
      Plastic_Black
    }
    scale <0.65, 0.35, 0.35>
    translate  <-5.709925, 0.0, 0.751547>
  }
  sphere { // EngineBlimp
    <0,0,0>,1
    texture {
      Shiny_Red
    }
    scale <0.65, 0.15, 0.15>
    translate  <-6.440733, 0.0, 1.17858>
  }
  sphere { // EngineBlimp1
    <0,0,0>,1
    texture {
      Shiny_Red
    }
    scale <0.45, 0.15, 0.15>
    translate  <-4.774, 0.0, 1.175832>
  }
  sphere { // EngineBlimp2
    <0,0,0>,1
    texture {
      Shiny_Red
    }
    scale <0.25, 0.15, 0.15>
    translate  <-3.568189, 0.0, 1.170342>
  }
  torus { // EngineCurve1
    1.9, 0.1  rotate -x*90
    texture {
      Plastic_Black
    }
    scale <0.65, 0.35, 0.35>
    translate  <-4.887075, 0.0, 0.24463>
  }
  torus { // EngineCurve2
    1.9, 0.1  rotate -x*90
    texture {
      Plastic_Black
    }
    scale <0.65, 0.35, 0.35>
    translate  <-4.122564, 0.0, 0.525687>
  }
  rotate 64.665588*y
  translate  <-5.589866, 0.0, -7.262327>
}
#declare EngineBlock = union {
  object { Engine1 }
  box { // EngineLine
    <-1, -1, -1>, <1, 1, 1>
    texture {
      White_Plaster
    }
    scale <0.553045, 2.474392, 0.1>
    translate  <-8.077369, 0.0, 0.660889>
  }
  box { // EngineLine1
    <-1, -1, -1>, <1, 1, 1>
    texture {
      White_Plaster
    }
    scale <0.2, 2.474392, 0.1>
    rotate -16.560606*y
    translate  <-8.917891, 0.0, 0.623383>
  }
  box { // EngineBox
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Plastic_Black
    }
    scale <0.2, 0.2, 0.1>
    translate  <-7.852227, 1.80542, 0.723398>
  }
  box { // EngineBox1
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Ruby
    }
    scale <0.2, 0.2, 0.1>
    translate  <-7.814614, -1.80542, 0.723398>
  }
  sphere { // EngineBump
    <0,0,0>,1
    texture {
      Aluminum
    }
    scale 0.2
    rotate 68.0*y
    translate  <-8.293446, -3.949592, 0.315983>
  }
  sphere { // EngineBump1
    <0,0,0>,1
    texture {
      Aluminum
    }
    scale 0.2
    rotate 68.0*y
    translate  <-8.293446, 3.938266, 0.315983>
  }
  object { EngineDone }
  rotate -68.0*y
  translate  <-5.830695, 0.0, 7.647713>
}
#declare BodyBlock = object {
  box { // BodyBlock
    <-1, -1, -1>, <1, 1, 1>
    texture {
      FoggyLight
    }
    scale <0.2, 0.35, 0.5>
    rotate -56.293957*y
    translate  <-3.129913, 0.0, 2.794136>
  }
}
#declare Cutter1 = object {
  box { // Cutter1
    <-1, -1, -1>, <1, 1, 1>
    texture {
      MottledBlueRed
    }
    scale <0.6, 0.35, 1.8>
    translate  <-3.341304, 0.0, 3.6>
  }
}
#declare EngineWindow = object {
  sphere { // EngineWindow
    <0,0,0>,1
    texture {
      Plastic_Black
    }
    scale 0.393631
    translate  <-3.114445, -0.834513, 4.761437>
  }
}
#declare EngineSmWindow = object {
  sphere { // EngineSmWindow
    <0,0,0>,1
    texture {
      Plastic_Black
    }
    scale 0.25
    translate  <-3.398625, -1.161761, 3.972606>
  }
}
#declare PanelDone1 = merge {
  cylinder { // PanelNode4
    <0,0,1>, <0,0,0>, 1 
    scale <0.035354, 0.035354, 0.5>
    rotate -33.0*x
    translate  <-0.112371, -1.907821, 6.514601>
  }
  box { // PanelBack1
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Plastic_Black
    }
    scale <0.2, 0.06, 0.4>
    rotate -33.0*x
    translate  <0.0, -1.77796, 6.624729>
  }
  cylinder { // PanelNode5
    <0,0,1>, <0,0,0>, 1 
    scale <0.035354, 0.035354, 0.5>
    rotate -33.0*x
    translate  <0.0, -1.969515, 6.41545>
  }
  cylinder { // PanelNode6
    <0,0,1>, <0,0,0>, 1 
    scale <0.035354, 0.035354, 0.5>
    rotate -33.0*x
    translate  <0.112371, -1.907821, 6.514601>
  }
  rotate 28.333988*z
}
#declare PanelDone5 = merge {
  cylinder { // PanelNode1
    <0,0,1>, <0,0,0>, 1 
    scale <0.035354, 0.035354, 0.5>
    rotate -33.0*x
    translate  <-0.112371, -1.907821, 6.514601>
  }
  box { // PanelBack
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Plastic_Black
    }
    scale <0.2, 0.06, 0.4>
    rotate -33.0*x
    translate  <0.0, -1.77796, 6.624729>
  }
  cylinder { // PanelNode2
    <0,0,1>, <0,0,0>, 1 
    scale <0.035354, 0.035354, 0.5>
    rotate -33.0*x
    translate  <0.0, -1.969515, 6.41545>
  }
  cylinder { // PanelNode3
    <0,0,1>, <0,0,0>, 1 
    scale <0.035354, 0.035354, 0.5>
    rotate -33.0*x
    translate  <0.112371, -1.907821, 6.514601>
  }
  object { PanelDone1 }
  texture {
    MottledBlueRed
  }
}
#declare Node1 = object {
  sphere { // Node1
    <0,0,0>,1
    texture {
      Plastic_Black
    }
    scale 0.13
    translate  <-0.719691, 0.0, 7.562944>
  }
}


#declare TransmitNode1 = union {
  cylinder { // TransmitLeg1
    <0,0,1>, <0,0,0>, 1 
    scale <0.08, 0.08, 0.4>
    translate  0.031379*z
  }
  sphere { // TransmitCore1
    <0,0,0>,1
    scale 0.1
  }
  cylinder { // TransmitLeg2
    <0,0,1>, <0,0,0>, 1 
    scale <0.08, 0.08, 0.4>
    rotate -90.0*x
    translate  0.030318*y
  }
  cylinder { // TransmitLeg3
    <0,0,1>, <0,0,0>, 1 
    scale <0.08, 0.08, 0.4>
    rotate <-90.0, -0.0, -90.0>
    translate  0.000192*y
  }
  cylinder { // Beam1
    <0,0,1>, <0,0,0>, 1 
    texture {
      Lightning
    }
    scale <0.06, 0.06, 3.3>
    rotate <-90.0, -0.0, -90.0>
    translate  0.25*x
  }
  texture {
    Plastic_Black
  }
  no_shadow
  hollow
  scale 0.5
  translate  <-0.95, -0.95, -0.251412>
}
#declare CornerStand1 = object {
  cylinder { // CornerStand1
    <0,0,1>, <0,0,0>, 1 
    texture {
      Deep_Gold
    }
    scale <0.05, 0.05, 4.6>
    translate  <-0.769035, 0.267965, -5.305429>
  }
}
#declare Proj1 = object {
  cylinder { // Proj1
    <0,0,1>, <0,0,0>, 1 
    texture {
      Lightning
    }
    scale <0.021212, 0.021212, 1.060606>
    rotate -90.0*z
    translate  <0.956691, 0.947243, -0.044352>
  }
}
#declare TransmitNode5 = union {
  cylinder { // TransmitLeg4
    <0,0,1>, <0,0,0>, 1 
    scale <0.08, 0.08, 0.4>
    translate  0.031379*z
  }
  sphere { // TransmitCore2
    <0,0,0>,1
    scale 0.1
  }
  cylinder { // TransmitLeg5
    <0,0,1>, <0,0,0>, 1 
    scale <0.08, 0.08, 0.4>
    rotate -90.0*x
    translate  0.030318*y
  }
  cylinder { // TransmitLeg6
    <0,0,1>, <0,0,0>, 1 
    scale <0.08, 0.08, 0.4>
    rotate <-90.0, -0.0, -90.0>
    translate  0.000192*y
  }
  cylinder { // Beam2
    <0,0,1>, <0,0,0>, 1 
    texture {
      Lightning
    }
    scale <0.06, 0.06, 3.3>
    rotate <-90.0, -0.0, -90.0>
    translate  0.25*x
  }
  texture {
    Plastic_Black
  }
  no_shadow
  hollow
  scale 0.5
  rotate <-90.0, 0.0, 90.0>
  translate  <0.948039, -0.95, 1.215227>
}


#declare Sticker_power = object {
  torus { // Sticker_power
    1.85, 0.15  rotate -x*90
    texture {
      BulkPagesTxt
    }
    scale <0.15, 0.075, 0.15>
    translate  0.100957*z
  }
}
#declare DataCrystal = object {
  superellipsoid { // DataCrystal
    <0.1, 2.0>
    texture {
      TransGlass
    }
  }
}
#declare Wave1 = object {
  torus { // Wave1
    1.85, 0.15  rotate -x*90
    translate  <-10.073335, 3.53928, 0.0>
  }
}
#declare Bumps = union {
  object { Wave1 }
  object { // Wave2->Wave1
    Wave1
    translate  -0.692994*y
  }
  object { // Wave3->Wave1
    Wave1
    translate  -1.347488*y
  }
  object { // Wave4->Wave1
    Wave1
    translate  -1.963482*y
  }
}
#declare BumpsDone = intersection {
  cone { // InterBump
    <0,0,0>, 0.3, <0,0,1>, 1.0
    scale <2.06879, 1.0, 2.8>
    rotate <-90.0, -0.0, -0.0>
    translate  <-10.046894, 2.964909, 0.03142>
  }
  object { Bumps }
  texture {
    Spun_Gold
  }
  rotate <90.0, -6.939926, 0.0>
  translate  <17.469844, -4.094546, -3.451459>
}




//
// ********  OBJECTS  *******
//

box { // Wall2Upper
  <-1, -1, -1>, <1, 1, 1>
  texture {
    Sig_Green
  }
  scale <135.0, 3.0, 0.35>
  rotate -90.0*z
  translate  <-97.740904, 259.713969, 171.149186>
}


box { // Wall1Upper2
  <-1, -1, -1>, <1, 1, 1>
  texture {
    Sig_Green
  }
  scale <50.0, 3.1, 0.35>
  rotate -90.0*z
  translate  <47.916825, 198.006106, 139.085032>
}


box { // Wall1Upper
  <-1, -1, -1>, <1, 1, 1>
  texture {
    Sig_Green
  }
  scale <50.0, 3.25, 0.35>
  translate  <100.0, 158.261854, 139.095176>
}


box { // WallBaseBoard
  <-1, -1, -1>, <1, 1, 1>
  texture {
    SigBlue
  }
  scale <50.0, 3.1, 1.2>
  translate  <100.0, 158.239476, 81.001036>
}


box { // Wall1BaseBoard
  <-1, -1, -1>, <1, 1, 1>
  texture {
    SigBlue
  }
  scale <50.0, 3.1, 1.2>
  rotate -90.0*z
  translate  <47.916825, 197.983728, 80.998626>
}


box { // Wall2BaseBoard
  <-1, -1, -1>, <1, 1, 1>
  texture {
    SigBlue
  }
  scale <68.0, 3.1, 1.2>
  rotate -90.0*z
  translate  <-97.740904, 178.864712, 81.060982>
}


























union { // Statue
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.534038, 0.000000, -9.500000>, <3.534038, -1.499365, -9.500000>, <1.499365, -3.534038, -9.500000>, <0.000000, -3.534038, -9.500000>, 
      <3.664134, 0.000000, -9.275000>, <3.664134, -1.499365, -9.275000>, <1.499365, -3.664134, -9.275000>, <0.000000, -3.664134, -9.275000>, 
      <3.973798, 0.000000, -9.009832>, <3.973798, -1.683350, -9.009832>, <1.683350, -3.973798, -9.009832>, <0.000000, -3.973798, -9.009832>, 
      <3.967693, 0.000000, -8.750000>, <3.967693, -1.683350, -8.750000>, <1.683350, -3.967693, -8.750000>, <0.000000, -3.967693, -8.750000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 3.534038, -9.500000>, <1.499365, 3.534038, -9.500000>, <3.534038, 1.499365, -9.500000>, <3.534038, 0.000000, -9.500000>, 
      <0.000000, 3.664134, -9.275000>, <1.499365, 3.664134, -9.275000>, <3.664134, 1.499365, -9.275000>, <3.664134, 0.000000, -9.275000>, 
      <0.000000, 3.973798, -9.009832>, <1.683350, 3.973798, -9.009832>, <3.973798, 1.683350, -9.009832>, <3.973798, 0.000000, -9.009832>, 
      <0.000000, 3.967693, -8.750000>, <1.683350, 3.967693, -8.750000>, <3.967693, 1.683350, -8.750000>, <3.967693, 0.000000, -8.750000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.534038, 0.000000, -9.500000>, <-3.534038, 1.499365, -9.500000>, <-1.499365, 3.534038, -9.500000>, <0.000000, 3.534038, -9.500000>, 
      <-3.664134, 0.000000, -9.275000>, <-3.664134, 1.499365, -9.275000>, <-1.499365, 3.664134, -9.275000>, <0.000000, 3.664134, -9.275000>, 
      <-3.973798, 0.000000, -9.009832>, <-3.973798, 1.683350, -9.009832>, <-1.683350, 3.973798, -9.009832>, <0.000000, 3.973798, -9.009832>, 
      <-3.967693, 0.000000, -8.750000>, <-3.967693, 1.683350, -8.750000>, <-1.683350, 3.967693, -8.750000>, <0.000000, 3.967693, -8.750000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.534038, 0.000000, -9.500000>, <-3.664134, 0.000000, -9.275000>, <-3.973798, 0.000000, -9.009832>, <-3.967693, 0.000000, -8.750000>, 
      <-3.534038, -1.499365, -9.500000>, <-3.664134, -1.499365, -9.275000>, <-3.973798, -1.683350, -9.009832>, <-3.967693, -1.683350, -8.750000>, 
      <-1.499365, -3.534038, -9.500000>, <-1.499365, -3.664134, -9.275000>, <-1.683350, -3.973798, -9.009832>, <-1.683350, -3.967693, -8.750000>, 
      <0.000000, -3.534038, -9.500000>, <0.000000, -3.664134, -9.275000>, <0.000000, -3.973798, -9.009832>, <0.000000, -3.967693, -8.750000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.498797, 0.000000, -8.000000>, <3.663120, 0.000000, -8.208352>, <3.961460, 0.000000, -8.484719>, <3.967693, 0.000000, -8.750000>, 
      <3.498797, -1.484414, -8.000000>, <3.663120, -1.484414, -8.208352>, <3.961460, -1.683350, -8.484719>, <3.967693, -1.683350, -8.750000>, 
      <1.484414, -3.498797, -8.000000>, <1.484414, -3.663120, -8.208352>, <1.683350, -3.961460, -8.484719>, <1.683350, -3.967693, -8.750000>, 
      <0.000000, -3.498797, -8.000000>, <0.000000, -3.663120, -8.208352>, <0.000000, -3.961460, -8.484719>, <0.000000, -3.967693, -8.750000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 3.498797, -8.000000>, <0.000000, 3.663120, -8.208352>, <0.000000, 3.961460, -8.484719>, <0.000000, 3.967693, -8.750000>, 
      <1.484414, 3.498797, -8.000000>, <1.484414, 3.663120, -8.208352>, <1.683350, 3.961460, -8.484719>, <1.683350, 3.967693, -8.750000>, 
      <3.498797, 1.484414, -8.000000>, <3.663120, 1.484414, -8.208352>, <3.961460, 1.683350, -8.484719>, <3.967693, 1.683350, -8.750000>, 
      <3.498797, 0.000000, -8.000000>, <3.663120, 0.000000, -8.208352>, <3.961460, 0.000000, -8.484719>, <3.967693, 0.000000, -8.750000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.498797, 0.000000, -8.000000>, <-3.663120, 0.000000, -8.208352>, <-3.961460, 0.000000, -8.484719>, <-3.967693, 0.000000, -8.750000>, 
      <-3.498797, 1.484414, -8.000000>, <-3.663120, 1.484414, -8.208352>, <-3.961460, 1.683350, -8.484719>, <-3.967693, 1.683350, -8.750000>, 
      <-1.484414, 3.498797, -8.000000>, <-1.484414, 3.663120, -8.208352>, <-1.683350, 3.961460, -8.484719>, <-1.683350, 3.967693, -8.750000>, 
      <0.000000, 3.498797, -8.000000>, <0.000000, 3.663120, -8.208352>, <0.000000, 3.961460, -8.484719>, <0.000000, 3.967693, -8.750000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.498797, 0.000000, -8.000000>, <-3.498797, -1.484414, -8.000000>, <-1.484414, -3.498797, -8.000000>, <0.000000, -3.498797, -8.000000>, 
      <-3.663120, 0.000000, -8.208352>, <-3.663120, -1.484414, -8.208352>, <-1.484414, -3.663120, -8.208352>, <0.000000, -3.663120, -8.208352>, 
      <-3.961460, 0.000000, -8.484719>, <-3.961460, -1.683350, -8.484719>, <-1.683350, -3.961460, -8.484719>, <0.000000, -3.961460, -8.484719>, 
      <-3.967693, 0.000000, -8.750000>, <-3.967693, -1.683350, -8.750000>, <-1.683350, -3.967693, -8.750000>, <0.000000, -3.967693, -8.750000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.981844, 0.000000, -7.500000>, <3.064300, 0.000000, -7.699380>, <3.365186, 0.000000, -7.830590>, <3.498797, 0.000000, -8.000000>, 
      <2.981844, -1.265089, -7.500000>, <3.064300, -1.265089, -7.699380>, <3.365186, -1.484414, -7.830590>, <3.498797, -1.484414, -8.000000>, 
      <1.265089, -2.981844, -7.500000>, <1.265089, -3.064300, -7.699380>, <1.484414, -3.365186, -7.830590>, <1.484414, -3.498797, -8.000000>, 
      <0.000000, -2.981844, -7.500000>, <0.000000, -3.064300, -7.699380>, <0.000000, -3.365186, -7.830590>, <0.000000, -3.498797, -8.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 2.981844, -7.500000>, <0.000000, 3.064300, -7.699380>, <0.000000, 3.365186, -7.830590>, <0.000000, 3.498797, -8.000000>, 
      <1.265089, 2.981844, -7.500000>, <1.265089, 3.064300, -7.699380>, <1.484414, 3.365186, -7.830590>, <1.484414, 3.498797, -8.000000>, 
      <2.981844, 1.265089, -7.500000>, <3.064300, 1.265089, -7.699380>, <3.365186, 1.484414, -7.830590>, <3.498797, 1.484414, -8.000000>, 
      <2.981844, 0.000000, -7.500000>, <3.064300, 0.000000, -7.699380>, <3.365186, 0.000000, -7.830590>, <3.498797, 0.000000, -8.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.981844, 0.000000, -7.500000>, <-3.064300, 0.000000, -7.699380>, <-3.365186, 0.000000, -7.830590>, <-3.498797, 0.000000, -8.000000>, 
      <-2.981844, 1.265089, -7.500000>, <-3.064300, 1.265089, -7.699380>, <-3.365186, 1.484414, -7.830590>, <-3.498797, 1.484414, -8.000000>, 
      <-1.265089, 2.981844, -7.500000>, <-1.265089, 3.064300, -7.699380>, <-1.484414, 3.365186, -7.830590>, <-1.484414, 3.498797, -8.000000>, 
      <0.000000, 2.981844, -7.500000>, <0.000000, 3.064300, -7.699380>, <0.000000, 3.365186, -7.830590>, <0.000000, 3.498797, -8.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.981844, 0.000000, -7.500000>, <-2.981844, -1.265089, -7.500000>, <-1.265089, -2.981844, -7.500000>, <0.000000, -2.981844, -7.500000>, 
      <-3.064300, 0.000000, -7.699380>, <-3.064300, -1.265089, -7.699380>, <-1.265089, -3.064300, -7.699380>, <0.000000, -3.064300, -7.699380>, 
      <-3.365186, 0.000000, -7.830590>, <-3.365186, -1.484414, -7.830590>, <-1.484414, -3.365186, -7.830590>, <0.000000, -3.365186, -7.830590>, 
      <-3.498797, 0.000000, -8.000000>, <-3.498797, -1.484414, -8.000000>, <-1.484414, -3.498797, -8.000000>, <0.000000, -3.498797, -8.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.981844, 0.000000, -6.750000>, <2.981844, 0.000000, -6.975000>, <2.895856, 0.000000, -7.292079>, <2.981844, 0.000000, -7.500000>, 
      <2.087291, -0.894553, -6.750000>, <2.087291, -0.894553, -6.975000>, <2.895856, -1.265089, -7.292079>, <2.981844, -1.265089, -7.500000>, 
      <0.894553, -2.087291, -6.750000>, <0.894553, -2.087291, -6.975000>, <1.265089, -2.895856, -7.292079>, <1.265089, -2.981844, -7.500000>, 
      <0.000000, -2.981844, -6.750000>, <0.000000, -2.981844, -6.975000>, <0.000000, -2.895856, -7.292079>, <0.000000, -2.981844, -7.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 2.981844, -6.750000>, <0.000000, 2.981844, -6.975000>, <0.000000, 2.895856, -7.292079>, <0.000000, 2.981844, -7.500000>, 
      <0.894553, 2.087291, -6.750000>, <0.894553, 2.087291, -6.975000>, <1.265089, 2.895856, -7.292079>, <1.265089, 2.981844, -7.500000>, 
      <2.087291, 0.894553, -6.750000>, <2.087291, 0.894553, -6.975000>, <2.895856, 1.265089, -7.292079>, <2.981844, 1.265089, -7.500000>, 
      <2.981844, 0.000000, -6.750000>, <2.981844, 0.000000, -6.975000>, <2.895856, 0.000000, -7.292079>, <2.981844, 0.000000, -7.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.981844, 0.000000, -6.750000>, <-2.981844, 0.000000, -6.975000>, <-2.895856, 0.000000, -7.292079>, <-2.981844, 0.000000, -7.500000>, 
      <-2.087291, 0.894553, -6.750000>, <-2.087291, 0.894553, -6.975000>, <-2.895856, 1.265089, -7.292079>, <-2.981844, 1.265089, -7.500000>, 
      <-0.894553, 2.087291, -6.750000>, <-0.894553, 2.087291, -6.975000>, <-1.265089, 2.895856, -7.292079>, <-1.265089, 2.981844, -7.500000>, 
      <0.000000, 2.981844, -6.750000>, <0.000000, 2.981844, -6.975000>, <0.000000, 2.895856, -7.292079>, <0.000000, 2.981844, -7.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.981844, 0.000000, -6.750000>, <-2.087291, -0.894553, -6.750000>, <-0.894553, -2.087291, -6.750000>, <0.000000, -2.981844, -6.750000>, 
      <-2.981844, 0.000000, -6.975000>, <-2.087291, -0.894553, -6.975000>, <-0.894553, -2.087291, -6.975000>, <0.000000, -2.981844, -6.975000>, 
      <-2.895856, 0.000000, -7.292079>, <-2.895856, -1.265089, -7.292079>, <-1.265089, -2.895856, -7.292079>, <0.000000, -2.895856, -7.292079>, 
      <-2.981844, 0.000000, -7.500000>, <-2.981844, -1.265089, -7.500000>, <-1.265089, -2.981844, -7.500000>, <0.000000, -2.981844, -7.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.827142, 0.000000, -5.500000>, <1.159056, 0.000000, -6.169556>, <2.335433, 0.000000, -6.375000>, <2.981844, 0.000000, -6.750000>, 
      <0.827142, -0.350927, -5.500000>, <1.159056, -0.350927, -6.169556>, <1.440880, -0.894553, -6.375000>, <2.087291, -0.894553, -6.750000>, 
      <0.350927, -0.827142, -5.500000>, <0.350927, -1.159056, -6.169556>, <0.894553, -1.440880, -6.375000>, <0.894553, -2.087291, -6.750000>, 
      <0.000000, -0.827142, -5.500000>, <0.000000, -1.159056, -6.169556>, <0.000000, -2.335433, -6.375000>, <0.000000, -2.981844, -6.750000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 0.827142, -5.500000>, <0.000000, 1.159056, -6.169556>, <0.000000, 2.335433, -6.375000>, <0.000000, 2.981844, -6.750000>, 
      <0.350927, 0.827142, -5.500000>, <0.350927, 1.159056, -6.169556>, <0.894553, 1.440880, -6.375000>, <0.894553, 2.087291, -6.750000>, 
      <0.827142, 0.350927, -5.500000>, <1.159056, 0.350927, -6.169556>, <1.440880, 0.894553, -6.375000>, <2.087291, 0.894553, -6.750000>, 
      <0.827142, 0.000000, -5.500000>, <1.159056, 0.000000, -6.169556>, <2.335433, 0.000000, -6.375000>, <2.981844, 0.000000, -6.750000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.827142, 0.000000, -5.500000>, <-1.159056, 0.000000, -6.169556>, <-2.335433, 0.000000, -6.375000>, <-2.981844, 0.000000, -6.750000>, 
      <-0.827142, 0.350927, -5.500000>, <-1.159056, 0.350927, -6.169556>, <-1.440880, 0.894553, -6.375000>, <-2.087291, 0.894553, -6.750000>, 
      <-0.350927, 0.827142, -5.500000>, <-0.350927, 1.159056, -6.169556>, <-0.894553, 1.440880, -6.375000>, <-0.894553, 2.087291, -6.750000>, 
      <0.000000, 0.827142, -5.500000>, <0.000000, 1.159056, -6.169556>, <0.000000, 2.335433, -6.375000>, <0.000000, 2.981844, -6.750000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.827142, 0.000000, -5.500000>, <-0.827142, -0.350927, -5.500000>, <-0.350927, -0.827142, -5.500000>, <0.000000, -0.827142, -5.500000>, 
      <-1.159056, 0.000000, -6.169556>, <-1.159056, -0.350927, -6.169556>, <-0.350927, -1.159056, -6.169556>, <0.000000, -1.159056, -6.169556>, 
      <-2.335433, 0.000000, -6.375000>, <-1.440880, -0.894553, -6.375000>, <-0.894553, -1.440880, -6.375000>, <0.000000, -2.335433, -6.375000>, 
      <-2.981844, 0.000000, -6.750000>, <-2.087291, -0.894553, -6.750000>, <-0.894553, -2.087291, -6.750000>, <0.000000, -2.981844, -6.750000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.494677, 0.000000, -3.750000>, <1.294416, 0.000000, -4.275000>, <0.577578, 0.000000, -4.996565>, <0.827142, 0.000000, -5.500000>, 
      <1.046274, -0.448403, -3.750000>, <0.846013, -0.448403, -4.275000>, <0.577578, -0.350927, -4.996565>, <0.827142, -0.350927, -5.500000>, 
      <0.448403, -1.046274, -3.750000>, <0.448403, -0.846013, -4.275000>, <0.350927, -0.577578, -4.996565>, <0.350927, -0.827142, -5.500000>, 
      <0.000000, -1.494677, -3.750000>, <0.000000, -1.294416, -4.275000>, <0.000000, -0.577578, -4.996565>, <0.000000, -0.827142, -5.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 1.494677, -3.750000>, <0.000000, 1.294416, -4.275000>, <0.000000, 0.577578, -4.996565>, <0.000000, 0.827142, -5.500000>, 
      <0.448403, 1.046274, -3.750000>, <0.448403, 0.846013, -4.275000>, <0.350927, 0.577578, -4.996565>, <0.350927, 0.827142, -5.500000>, 
      <1.046274, 0.448403, -3.750000>, <0.846013, 0.448403, -4.275000>, <0.577578, 0.350927, -4.996565>, <0.827142, 0.350927, -5.500000>, 
      <1.494677, 0.000000, -3.750000>, <1.294416, 0.000000, -4.275000>, <0.577578, 0.000000, -4.996565>, <0.827142, 0.000000, -5.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.494677, 0.000000, -3.750000>, <-1.294416, 0.000000, -4.275000>, <-0.577578, 0.000000, -4.996565>, <-0.827142, 0.000000, -5.500000>, 
      <-1.046274, 0.448403, -3.750000>, <-0.846013, 0.448403, -4.275000>, <-0.577578, 0.350927, -4.996565>, <-0.827142, 0.350927, -5.500000>, 
      <-0.448403, 1.046274, -3.750000>, <-0.448403, 0.846013, -4.275000>, <-0.350927, 0.577578, -4.996565>, <-0.350927, 0.827142, -5.500000>, 
      <0.000000, 1.494677, -3.750000>, <0.000000, 1.294416, -4.275000>, <0.000000, 0.577578, -4.996565>, <0.000000, 0.827142, -5.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.494677, 0.000000, -3.750000>, <-1.046274, -0.448403, -3.750000>, <-0.448403, -1.046274, -3.750000>, <0.000000, -1.494677, -3.750000>, 
      <-1.294416, 0.000000, -4.275000>, <-0.846013, -0.448403, -4.275000>, <-0.448403, -0.846013, -4.275000>, <0.000000, -1.294416, -4.275000>, 
      <-0.577578, 0.000000, -4.996565>, <-0.577578, -0.350927, -4.996565>, <-0.350927, -0.577578, -4.996565>, <0.000000, -0.577578, -4.996565>, 
      <-0.827142, 0.000000, -5.500000>, <-0.827142, -0.350927, -5.500000>, <-0.350927, -0.827142, -5.500000>, <0.000000, -0.827142, -5.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.494677, 0.000000, -3.000000>, <1.580636, 0.000000, -3.207933>, <1.494677, 0.000000, -3.525000>, <1.494677, 0.000000, -3.750000>, 
      <1.046274, -0.448403, -3.000000>, <1.132233, -0.448403, -3.207933>, <1.046274, -0.448403, -3.525000>, <1.046274, -0.448403, -3.750000>, 
      <0.448403, -1.046274, -3.000000>, <0.448403, -1.132233, -3.207933>, <0.448403, -1.046274, -3.525000>, <0.448403, -1.046274, -3.750000>, 
      <0.000000, -1.494677, -3.000000>, <0.000000, -1.580636, -3.207933>, <0.000000, -1.494677, -3.525000>, <0.000000, -1.494677, -3.750000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 1.494677, -3.000000>, <0.000000, 1.580636, -3.207933>, <0.000000, 1.494677, -3.525000>, <0.000000, 1.494677, -3.750000>, 
      <0.448403, 1.046274, -3.000000>, <0.448403, 1.132233, -3.207933>, <0.448403, 1.046274, -3.525000>, <0.448403, 1.046274, -3.750000>, 
      <1.046274, 0.448403, -3.000000>, <1.132233, 0.448403, -3.207933>, <1.046274, 0.448403, -3.525000>, <1.046274, 0.448403, -3.750000>, 
      <1.494677, 0.000000, -3.000000>, <1.580636, 0.000000, -3.207933>, <1.494677, 0.000000, -3.525000>, <1.494677, 0.000000, -3.750000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.494677, 0.000000, -3.000000>, <-1.580636, 0.000000, -3.207933>, <-1.494677, 0.000000, -3.525000>, <-1.494677, 0.000000, -3.750000>, 
      <-1.046274, 0.448403, -3.000000>, <-1.132233, 0.448403, -3.207933>, <-1.046274, 0.448403, -3.525000>, <-1.046274, 0.448403, -3.750000>, 
      <-0.448403, 1.046274, -3.000000>, <-0.448403, 1.132233, -3.207933>, <-0.448403, 1.046274, -3.525000>, <-0.448403, 1.046274, -3.750000>, 
      <0.000000, 1.494677, -3.000000>, <0.000000, 1.580636, -3.207933>, <0.000000, 1.494677, -3.525000>, <0.000000, 1.494677, -3.750000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.494677, 0.000000, -3.000000>, <-1.046274, -0.448403, -3.000000>, <-0.448403, -1.046274, -3.000000>, <0.000000, -1.494677, -3.000000>, 
      <-1.580636, 0.000000, -3.207933>, <-1.132233, -0.448403, -3.207933>, <-0.448403, -1.132233, -3.207933>, <0.000000, -1.580636, -3.207933>, 
      <-1.494677, 0.000000, -3.525000>, <-1.046274, -0.448403, -3.525000>, <-0.448403, -1.046274, -3.525000>, <0.000000, -1.494677, -3.525000>, 
      <-1.494677, 0.000000, -3.750000>, <-1.046274, -0.448403, -3.750000>, <-0.448403, -1.046274, -3.750000>, <0.000000, -1.494677, -3.750000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.977930, 0.000000, -2.500000>, <1.076959, 0.000000, -2.691639>, <1.412266, 0.000000, -2.800649>, <1.494677, 0.000000, -3.000000>, 
      <0.684551, -0.293379, -2.500000>, <0.783580, -0.293379, -2.691639>, <0.963862, -0.448403, -2.800649>, <1.046274, -0.448403, -3.000000>, 
      <0.293379, -0.684551, -2.500000>, <0.293379, -0.783580, -2.691639>, <0.448403, -0.963862, -2.800649>, <0.448403, -1.046274, -3.000000>, 
      <0.000000, -0.977930, -2.500000>, <0.000000, -1.076959, -2.691639>, <0.000000, -1.412266, -2.800649>, <0.000000, -1.494677, -3.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 0.977930, -2.500000>, <0.000000, 1.076959, -2.691639>, <0.000000, 1.412266, -2.800649>, <0.000000, 1.494677, -3.000000>, 
      <0.293379, 0.684551, -2.500000>, <0.293379, 0.783580, -2.691639>, <0.448403, 0.963862, -2.800649>, <0.448403, 1.046274, -3.000000>, 
      <0.684551, 0.293379, -2.500000>, <0.783580, 0.293379, -2.691639>, <0.963862, 0.448403, -2.800649>, <1.046274, 0.448403, -3.000000>, 
      <0.977930, 0.000000, -2.500000>, <1.076959, 0.000000, -2.691639>, <1.412266, 0.000000, -2.800649>, <1.494677, 0.000000, -3.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.977930, 0.000000, -2.500000>, <-1.076959, 0.000000, -2.691639>, <-1.412266, 0.000000, -2.800649>, <-1.494677, 0.000000, -3.000000>, 
      <-0.684551, 0.293379, -2.500000>, <-0.783580, 0.293379, -2.691639>, <-0.963862, 0.448403, -2.800649>, <-1.046274, 0.448403, -3.000000>, 
      <-0.293379, 0.684551, -2.500000>, <-0.293379, 0.783580, -2.691639>, <-0.448403, 0.963862, -2.800649>, <-0.448403, 1.046274, -3.000000>, 
      <0.000000, 0.977930, -2.500000>, <0.000000, 1.076959, -2.691639>, <0.000000, 1.412266, -2.800649>, <0.000000, 1.494677, -3.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.977930, 0.000000, -2.500000>, <-0.684551, -0.293379, -2.500000>, <-0.293379, -0.684551, -2.500000>, <0.000000, -0.977930, -2.500000>, 
      <-1.076959, 0.000000, -2.691639>, <-0.783580, -0.293379, -2.691639>, <-0.293379, -0.783580, -2.691639>, <0.000000, -1.076959, -2.691639>, 
      <-1.412266, 0.000000, -2.800649>, <-0.963862, -0.448403, -2.800649>, <-0.448403, -0.963862, -2.800649>, <0.000000, -1.412266, -2.800649>, 
      <-1.494677, 0.000000, -3.000000>, <-1.046274, -0.448403, -3.000000>, <-0.448403, -1.046274, -3.000000>, <0.000000, -1.494677, -3.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.977930, 0.000000, -2.000000>, <1.014400, 0.000000, -2.145499>, <0.909069, 0.000000, -2.366740>, <0.977930, 0.000000, -2.500000>, 
      <0.977930, -0.414901, -2.000000>, <1.014400, -0.414901, -2.145499>, <0.615690, -0.293379, -2.366740>, <0.684551, -0.293379, -2.500000>, 
      <0.414901, -0.977930, -2.000000>, <0.414901, -1.014400, -2.145499>, <0.293379, -0.615690, -2.366740>, <0.293379, -0.684551, -2.500000>, 
      <0.000000, -0.977930, -2.000000>, <0.000000, -1.014400, -2.145499>, <0.000000, -0.909069, -2.366740>, <0.000000, -0.977930, -2.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 0.977930, -2.000000>, <0.000000, 1.014400, -2.145499>, <0.000000, 0.909069, -2.366740>, <0.000000, 0.977930, -2.500000>, 
      <0.414901, 0.977930, -2.000000>, <0.414901, 1.014400, -2.145499>, <0.293379, 0.615690, -2.366740>, <0.293379, 0.684551, -2.500000>, 
      <0.977930, 0.414901, -2.000000>, <1.014400, 0.414901, -2.145499>, <0.615690, 0.293379, -2.366740>, <0.684551, 0.293379, -2.500000>, 
      <0.977930, 0.000000, -2.000000>, <1.014400, 0.000000, -2.145499>, <0.909069, 0.000000, -2.366740>, <0.977930, 0.000000, -2.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.977930, 0.000000, -2.000000>, <-1.014400, 0.000000, -2.145499>, <-0.909069, 0.000000, -2.366740>, <-0.977930, 0.000000, -2.500000>, 
      <-0.977930, 0.414901, -2.000000>, <-1.014400, 0.414901, -2.145499>, <-0.615690, 0.293379, -2.366740>, <-0.684551, 0.293379, -2.500000>, 
      <-0.414901, 0.977930, -2.000000>, <-0.414901, 1.014400, -2.145499>, <-0.293379, 0.615690, -2.366740>, <-0.293379, 0.684551, -2.500000>, 
      <0.000000, 0.977930, -2.000000>, <0.000000, 1.014400, -2.145499>, <0.000000, 0.909069, -2.366740>, <0.000000, 0.977930, -2.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.977930, 0.000000, -2.000000>, <-0.977930, -0.414901, -2.000000>, <-0.414901, -0.977930, -2.000000>, <0.000000, -0.977930, -2.000000>, 
      <-1.014400, 0.000000, -2.145499>, <-1.014400, -0.414901, -2.145499>, <-0.414901, -1.014400, -2.145499>, <0.000000, -1.014400, -2.145499>, 
      <-0.909069, 0.000000, -2.366740>, <-0.615690, -0.293379, -2.366740>, <-0.293379, -0.615690, -2.366740>, <0.000000, -0.909069, -2.366740>, 
      <-0.977930, 0.000000, -2.500000>, <-0.684551, -0.293379, -2.500000>, <-0.293379, -0.684551, -2.500000>, <0.000000, -0.977930, -2.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.727273, 0.000000, -1.500000>, <0.768069, 0.000000, -1.662758>, <0.937133, 0.000000, -1.837242>, <0.977930, 0.000000, -2.000000>, 
      <0.509091, -0.218182, -1.500000>, <0.549888, -0.218182, -1.662758>, <0.937133, -0.414901, -1.837242>, <0.977930, -0.414901, -2.000000>, 
      <0.218182, -0.509091, -1.500000>, <0.218182, -0.549888, -1.662758>, <0.414901, -0.937133, -1.837242>, <0.414901, -0.977930, -2.000000>, 
      <0.000000, -0.727273, -1.500000>, <0.000000, -0.768069, -1.662758>, <0.000000, -0.937133, -1.837242>, <0.000000, -0.977930, -2.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 0.727273, -1.500000>, <0.000000, 0.768069, -1.662758>, <0.000000, 0.937133, -1.837242>, <0.000000, 0.977930, -2.000000>, 
      <0.218182, 0.509091, -1.500000>, <0.218182, 0.549888, -1.662758>, <0.414901, 0.937133, -1.837242>, <0.414901, 0.977930, -2.000000>, 
      <0.509091, 0.218182, -1.500000>, <0.549888, 0.218182, -1.662758>, <0.937133, 0.414901, -1.837242>, <0.977930, 0.414901, -2.000000>, 
      <0.727273, 0.000000, -1.500000>, <0.768069, 0.000000, -1.662758>, <0.937133, 0.000000, -1.837242>, <0.977930, 0.000000, -2.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.727273, 0.000000, -1.500000>, <-0.768069, 0.000000, -1.662758>, <-0.937133, 0.000000, -1.837242>, <-0.977930, 0.000000, -2.000000>, 
      <-0.509091, 0.218182, -1.500000>, <-0.549888, 0.218182, -1.662758>, <-0.937133, 0.414901, -1.837242>, <-0.977930, 0.414901, -2.000000>, 
      <-0.218182, 0.509091, -1.500000>, <-0.218182, 0.549888, -1.662758>, <-0.414901, 0.937133, -1.837242>, <-0.414901, 0.977930, -2.000000>, 
      <0.000000, 0.727273, -1.500000>, <0.000000, 0.768069, -1.662758>, <0.000000, 0.937133, -1.837242>, <0.000000, 0.977930, -2.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.727273, 0.000000, -1.500000>, <-0.509091, -0.218182, -1.500000>, <-0.218182, -0.509091, -1.500000>, <0.000000, -0.727273, -1.500000>, 
      <-0.768069, 0.000000, -1.662758>, <-0.549888, -0.218182, -1.662758>, <-0.218182, -0.549888, -1.662758>, <0.000000, -0.768069, -1.662758>, 
      <-0.937133, 0.000000, -1.837242>, <-0.937133, -0.414901, -1.837242>, <-0.414901, -0.937133, -1.837242>, <0.000000, -0.937133, -1.837242>, 
      <-0.977930, 0.000000, -2.000000>, <-0.977930, -0.414901, -2.000000>, <-0.414901, -0.977930, -2.000000>, <0.000000, -0.977930, -2.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.727273, 0.000000, -1.000000>, <0.760516, 0.000000, -1.146270>, <0.690803, 0.000000, -1.354501>, <0.727273, 0.000000, -1.500000>, 
      <0.509091, -0.218182, -1.000000>, <0.542334, -0.218182, -1.146270>, <0.472621, -0.218182, -1.354501>, <0.509091, -0.218182, -1.500000>, 
      <0.218182, -0.509091, -1.000000>, <0.218182, -0.542334, -1.146270>, <0.218182, -0.472621, -1.354501>, <0.218182, -0.509091, -1.500000>, 
      <0.000000, -0.727273, -1.000000>, <0.000000, -0.760516, -1.146270>, <0.000000, -0.690803, -1.354501>, <0.000000, -0.727273, -1.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 0.727273, -1.000000>, <0.000000, 0.760516, -1.146270>, <0.000000, 0.690803, -1.354501>, <0.000000, 0.727273, -1.500000>, 
      <0.218182, 0.509091, -1.000000>, <0.218182, 0.542334, -1.146270>, <0.218182, 0.472621, -1.354501>, <0.218182, 0.509091, -1.500000>, 
      <0.509091, 0.218182, -1.000000>, <0.542334, 0.218182, -1.146270>, <0.472621, 0.218182, -1.354501>, <0.509091, 0.218182, -1.500000>, 
      <0.727273, 0.000000, -1.000000>, <0.760516, 0.000000, -1.146270>, <0.690803, 0.000000, -1.354501>, <0.727273, 0.000000, -1.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.727273, 0.000000, -1.000000>, <-0.760516, 0.000000, -1.146270>, <-0.690803, 0.000000, -1.354501>, <-0.727273, 0.000000, -1.500000>, 
      <-0.509091, 0.218182, -1.000000>, <-0.542334, 0.218182, -1.146270>, <-0.472621, 0.218182, -1.354501>, <-0.509091, 0.218182, -1.500000>, 
      <-0.218182, 0.509091, -1.000000>, <-0.218182, 0.542334, -1.146270>, <-0.218182, 0.472621, -1.354501>, <-0.218182, 0.509091, -1.500000>, 
      <0.000000, 0.727273, -1.000000>, <0.000000, 0.760516, -1.146270>, <0.000000, 0.690803, -1.354501>, <0.000000, 0.727273, -1.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.727273, 0.000000, -1.000000>, <-0.509091, -0.218182, -1.000000>, <-0.218182, -0.509091, -1.000000>, <0.000000, -0.727273, -1.000000>, 
      <-0.760516, 0.000000, -1.146270>, <-0.542334, -0.218182, -1.146270>, <-0.218182, -0.542334, -1.146270>, <0.000000, -0.760516, -1.146270>, 
      <-0.690803, 0.000000, -1.354501>, <-0.472621, -0.218182, -1.354501>, <-0.218182, -0.472621, -1.354501>, <0.000000, -0.690803, -1.354501>, 
      <-0.727273, 0.000000, -1.500000>, <-0.509091, -0.218182, -1.500000>, <-0.218182, -0.509091, -1.500000>, <0.000000, -0.727273, -1.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.500000, 0.000000, -0.500000>, <0.571884, 0.000000, -0.648261>, <0.690757, 0.000000, -0.839329>, <0.727273, 0.000000, -1.000000>, 
      <0.500000, -0.272899, -0.500000>, <0.571884, -0.272899, -0.648261>, <0.472575, -0.218182, -0.839329>, <0.509091, -0.218182, -1.000000>, 
      <0.272899, -0.500000, -0.500000>, <0.272899, -0.568182, -0.650000>, <0.218182, -0.472575, -0.839329>, <0.218182, -0.509091, -1.000000>, 
      <0.000000, -0.500000, -0.500000>, <0.000000, -0.568182, -0.650000>, <0.000000, -0.690757, -0.839329>, <0.000000, -0.727273, -1.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 0.500000, -0.500000>, <0.000000, 0.568182, -0.650000>, <0.000000, 0.690757, -0.839329>, <0.000000, 0.727273, -1.000000>, 
      <0.272899, 0.500000, -0.500000>, <0.272899, 0.568182, -0.650000>, <0.218182, 0.472575, -0.839329>, <0.218182, 0.509091, -1.000000>, 
      <0.500000, 0.272899, -0.500000>, <0.571884, 0.272899, -0.648261>, <0.472575, 0.218182, -0.839329>, <0.509091, 0.218182, -1.000000>, 
      <0.500000, 0.000000, -0.500000>, <0.571884, 0.000000, -0.648261>, <0.690757, 0.000000, -0.839329>, <0.727273, 0.000000, -1.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 0.500000, -0.500000>, <0.000000, 0.200000, -0.500000>, <0.000000, -0.200000, -0.500000>, <0.000000, -0.500000, -0.500000>, 
      <0.000000, 0.500000, -0.500000>, <0.272899, 0.200000, -0.500000>, <0.272899, -0.200000, -0.500000>, <0.272899, -0.500000, -0.500000>, 
      <0.000000, 0.500000, -0.500000>, <0.272899, 0.200000, -0.500000>, <0.500000, 0.000000, -0.500000>, <0.500000, -0.272899, -0.500000>, 
      <0.000000, 0.500000, -0.500000>, <0.272899, 0.500000, -0.500000>, <0.500000, 0.272899, -0.500000>, <0.500000, 0.000000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.500000, 0.000000, -0.500000>, <-0.571884, 0.000000, -0.648261>, <-0.690757, 0.000000, -0.839329>, <-0.727273, 0.000000, -1.000000>, 
      <-0.500000, 0.272899, -0.500000>, <-0.571884, 0.272899, -0.648261>, <-0.472575, 0.218182, -0.839329>, <-0.509091, 0.218182, -1.000000>, 
      <-0.272899, 0.500000, -0.500000>, <-0.272899, 0.568182, -0.650000>, <-0.218182, 0.472575, -0.839329>, <-0.218182, 0.509091, -1.000000>, 
      <0.000000, 0.500000, -0.500000>, <0.000000, 0.568182, -0.650000>, <0.000000, 0.690757, -0.839329>, <0.000000, 0.727273, -1.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.500000, 0.000000, -0.500000>, <-0.500000, -0.272899, -0.500000>, <-0.272899, -0.500000, -0.500000>, <0.000000, -0.500000, -0.500000>, 
      <-0.571884, 0.000000, -0.648261>, <-0.571884, -0.272899, -0.648261>, <-0.272899, -0.568182, -0.650000>, <0.000000, -0.568182, -0.650000>, 
      <-0.690757, 0.000000, -0.839329>, <-0.472575, -0.218182, -0.839329>, <-0.218182, -0.472575, -0.839329>, <0.000000, -0.690757, -0.839329>, 
      <-0.727273, 0.000000, -1.000000>, <-0.509091, -0.218182, -1.000000>, <-0.218182, -0.509091, -1.000000>, <0.000000, -0.727273, -1.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.500000, 0.000000, -0.500000>, <-0.500000, -0.272899, -0.500000>, <-0.272899, -0.500000, -0.500000>, <0.000000, -0.500000, -0.500000>, 
      <-0.500000, 0.000000, -0.500000>, <-0.500000, 0.000000, -0.500000>, <-0.272899, -0.200000, -0.500000>, <0.000000, -0.200000, -0.500000>, 
      <-0.500000, 0.000000, -0.500000>, <-0.500000, 0.000000, -0.500000>, <-0.272899, 0.200000, -0.500000>, <0.000000, 0.200000, -0.500000>, 
      <-0.500000, 0.000000, -0.500000>, <-0.500000, 0.272899, -0.500000>, <-0.272899, 0.500000, -0.500000>, <0.000000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 0.000000, 0.500000>, <0.150000, 0.000000, 0.200000>, <0.353669, 0.000000, -0.198193>, <0.500000, 0.000000, -0.500000>, 
      <0.000000, 0.000000, 0.500000>, <0.150000, 0.000000, 0.200000>, <0.353669, -0.272899, -0.198193>, <0.500000, -0.272899, -0.500000>, 
      <0.000000, 0.000000, 0.500000>, <0.000000, -0.150000, 0.200000>, <0.272899, -0.350000, -0.200000>, <0.272899, -0.500000, -0.500000>, 
      <0.000000, 0.000000, 0.500000>, <0.000000, -0.150000, 0.200000>, <0.000000, -0.350000, -0.200000>, <0.000000, -0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 0.000000, 0.500000>, <0.000000, 0.000000, 0.500000>, <0.000000, 0.000000, 0.500000>, <0.000000, 0.000000, 0.500000>, 
      <0.150000, 0.000000, 0.200000>, <0.150000, 0.000000, 0.200000>, <0.000000, 0.150000, 0.200000>, <0.000000, 0.150000, 0.200000>, 
      <0.353669, 0.000000, -0.198193>, <0.353669, 0.272899, -0.198193>, <0.272899, 0.350000, -0.200000>, <0.000000, 0.350000, -0.200000>, 
      <0.500000, 0.000000, -0.500000>, <0.500000, 0.272899, -0.500000>, <0.272899, 0.500000, -0.500000>, <0.000000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 0.000000, 0.500000>, <-0.150000, 0.000000, 0.200000>, <-0.353669, 0.000000, -0.198193>, <-0.500000, 0.000000, -0.500000>, 
      <0.000000, 0.000000, 0.500000>, <-0.150000, 0.000000, 0.200000>, <-0.353669, 0.272899, -0.198193>, <-0.500000, 0.272899, -0.500000>, 
      <0.000000, 0.000000, 0.500000>, <0.000000, 0.150000, 0.200000>, <-0.272899, 0.350000, -0.200000>, <-0.272899, 0.500000, -0.500000>, 
      <0.000000, 0.000000, 0.500000>, <0.000000, 0.150000, 0.200000>, <0.000000, 0.350000, -0.200000>, <0.000000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 0.000000, 0.500000>, <0.000000, 0.000000, 0.500000>, <0.000000, 0.000000, 0.500000>, <0.000000, 0.000000, 0.500000>, 
      <-0.150000, 0.000000, 0.200000>, <-0.150000, 0.000000, 0.200000>, <0.000000, -0.150000, 0.200000>, <0.000000, -0.150000, 0.200000>, 
      <-0.353669, 0.000000, -0.198193>, <-0.353669, -0.272899, -0.198193>, <-0.272899, -0.350000, -0.200000>, <0.000000, -0.350000, -0.200000>, 
      <-0.500000, 0.000000, -0.500000>, <-0.500000, -0.272899, -0.500000>, <-0.272899, -0.500000, -0.500000>, <0.000000, -0.500000, -0.500000>
    }
  }
  texture {
    Filigree
  }
  scale <0.6, 0.6, 1.4>
  translate  <101.66353, 157.687004, 116.719534>
}


union { // TrackDone3
  cylinder { // LightShade4
    <0,0,1>, <0,0,0>, 1 
    texture {
      Plastic_Black
    }
    scale <1.0, 0.689249, 1.706931>
    rotate -139.0*x
    translate  <0.89506, 0.203345, -0.129401>
  }
  cylinder { // TrackPost2
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Black
    }
    scale <0.3, 0.3, 10.0>
    rotate -90.0*y
    translate  <2.138825, -0.0, 0.0>
  }
  cylinder { // LightShade5
    <0,0,1>, <0,0,0>, 1 
    texture {
      Plastic_Black
    }
    scale <1.0, 0.689249, 1.706931>
    rotate -139.0*x
    translate  <-7.079876, 0.203345, -0.129401>
  }
  cylinder { // Support4
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Black
    }
    scale <0.07, 0.07, 25.0>
    translate  <-7.286637, -0.0385, 0.0>
  }
  cylinder { // Support5
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Black
    }
    scale <0.07, 0.07, 25.0>
    translate  <1.526268, -0.0385, 0.0>
  }
  cylinder { // LightShade6
    <0,0,1>, <0,0,0>, 1 
    texture {
      Plastic_Black
    }
    scale <1.0, 0.689249, 1.706931>
    rotate -139.0*x
    translate  <-2.966762, 0.203345, -0.129401>
  }
  no_shadow
  scale 2.0
  translate  <99.978005, 142.126374, 127.859986>
}


union { // TrackDone2
  cylinder { // LightShade2
    <0,0,1>, <0,0,0>, 1 
    texture {
      Plastic_Black
    }
    scale <1.0, 0.689249, 1.706931>
    rotate -120.0*x
    translate  <0.0, 0.203345, -0.129401>
  }
  cylinder { // TrackPost1
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Black
    }
    scale <0.3, 0.3, 15.0>
    rotate -90.0*y
    translate  <3.697107, -0.0, 0.0>
  }
  cylinder { // LightShade3
    <0,0,1>, <0,0,0>, 1 
    texture {
      Plastic_Black
    }
    scale <1.0, 0.689249, 1.706931>
    rotate -120.0*x
    translate  <-8.026158, 0.203345, -0.129401>
  }
  cylinder { // Support2
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Black
    }
    scale <0.07, 0.07, 25.0>
    translate  <-9.537995, -0.0385, -0.0>
  }
  cylinder { // Support3
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Black
    }
    scale <0.07, 0.07, 25.0>
    translate  <1.526268, -0.0385, 0.0>
  }
  no_shadow
  scale 2.0
  rotate 90.0*z
  translate  <-62.183344, 156.937208, 145.30529>
}




union { // TrackDone1
  cylinder { // LightShade
    <0,0,1>, <0,0,0>, 1 
    texture {
      Plastic_Black
    }
    scale <1.0, 0.689249, 1.706931>
    rotate -160.0*x
    translate  <4.990395, 0.203345, -0.129401>
  }
  cylinder { // TrackPost
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Black
    }
    scale <0.3, 0.3, 20.0>
    rotate <-180.0, -90.0, 0.0>
    translate  <-7.738429, 0.0, 0.0>
  }
  cylinder { // LightShade1
    <0,0,1>, <0,0,0>, 1 
    texture {
      Plastic_Black
    }
    scale <1.0, 0.689249, 1.706931>
    rotate -160.0*x
    translate  <-5.389225, 0.203345, -0.129401>
  }
  cylinder { // Support1
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Black
    }
    scale <0.07, 0.07, 25.0>
    translate  <-6.467941, -0.0385, 0.0>
  }
  cylinder { // Support6
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Black
    }
    scale <0.07, 0.07, 25.0>
    translate  <15.988835, -0.0385, -0.0>
  }
  no_shadow
  scale 2.0
  rotate 90.0*z
  translate  <-19.793368, 181.030821, 140.0>
}


sphere { // Planet
  <0,0,0>,1
  texture {
    PlanetForm
  }
  scale <2.0, 14.5, 13.0>
  rotate 6.7*x
  translate  <-93.518726, 152.606411, 124.16667>
}


#declare StandCutPieces3 = union {
  cylinder { // CutBtm6
    <0,0,1>, <0,0,0>, 1 
    translate  0.6*x
  }
  box { // Cutmiddle6
    <-1, -1, -1>, <1, 1, 1>
    scale <1.8, 0.986223, 0.5>
    translate  <2.4, 0.0, 0.5>
  }
  cylinder { // CutTop6
    <0,0,1>, <0,0,0>, 1 
    translate  4.2*x
  }
  object { // CutBtm7->CutBtm
    CutBtm
    translate  <9.0, 0.0, 0.0>
  }
  object { // Cutmiddle7->Cutmiddle
    Cutmiddle
    translate  9.0*x
  }
  object { // CutTop7->CutTop
    CutTop
    translate  9.0*x
  }
  scale <1.0, 1.3, 2.2>
  rotate <-0.0, 90.0, -90.0>
  translate  <91.14922, 91.06532, 102.477741>
}
#declare StandCut3 = difference {
  box { // SmallDisplayPost3
    <-1, -1, -1>, <1, 1, 1>
    scale <2.64, 0.99, 7.59>
    translate  <91.131964, 89.953155, 94.950956>
  }
  object { StandCutPieces3 }
  scale <0.6, 0.1, 0.6>
  rotate <-0.0, -0.0, 0.0>
  translate  <-54.676087, -9.127287, -67.498296>
}
#declare MatWords = object { 
  height_field {
    tga "C:\Program Files\Moray For Windows\AllMyMDLs\Souvenirs\MatTalk.tga"
    water_level 0.1
  }
  rotate    <-90, 0, 0> // Turn onto XY plane. Now points along -Z
  scale     <  2, 2,-2> // Scale to Cube size. Now points along +Z
  translate < -1,-1,-1> // Center around origin
  texture {
    BrightLightYellow
  }
  scale <3.0, 1.5, 0.01>
  rotate 35.0*x
  translate  <0.0, 0.98679, -4.876852>
}
union { // MuralSign
  box { // MuralTextpart
    <-1, -1, -1>, <1, 1, 1>
    scale <4.0, 3.0, 0.1>
    rotate 35.0*x
    translate  <-0.089615, 0.049673, -5.704109>
  }
  box { // MuralPost
    <-1, -1, -1>, <1, 1, 1>
    scale <2.0, 2.0, 0.1>
    translate  -15.0*z
  }
  object { StandCut3 }
  object { MatWords }
  box { // TVFrame1
    <-1, -1, -1>, <1, 1, 1>
    scale <3.5, 0.1, 0.1>
    rotate 35.0*x
    translate  <-0.089615, -0.510987, -5.978475>
  }
  box { // TVFrame2
    <-1, -1, -1>, <1, 1, 1>
    scale <3.5, 0.1, 0.1>
    rotate 35.0*x
    translate  <-0.089615, -2.2884, -7.217177>
  }
  box { // TVFrame3
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 1.18, 0.1>
    rotate 35.0*x
    translate  <-3.487762, -1.404464, -6.601882>
  }
  box { // TVFrame4
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 1.18, 0.1>
    rotate 35.0*x
    translate  <3.314248, -1.404464, -6.601882>
  }
  superellipsoid { // Screen
    <0.1, 1.0>
    texture {
      TVScreenGrey
    }
    scale <3.308113, 1.014323, 0.1>
    rotate 35.0*x
    translate  <-0.080951, -1.419286, -6.55422>
  }
  texture {
    Iron
  }
  scale 2.1
  translate  <64.372295, 135.948784, 111.730638>
}


object { // LampDone3->LampDone1
  LampDone1
  translate  -16.445174*x
}


object { // LampDone2->LampDone1
  LampDone1
  translate  -8.16588*x
}


object { LampDone1 }


union { // WallProtector
  object { WallTransmitNode }
  object { // WallTransmitNode1->WallTransmitNode
    WallTransmitNode
    rotate <0.0, -180.0, -0.0>
    translate  <187.154223, 0.0, 224.343034>
  }
  object { WallTransmitNode2 }
  object { // WallTransmitNode3->WallTransmitNode2
    WallTransmitNode2
    rotate -180.0*y
    translate  <187.13752, 0.0, 224.299871>
  }
}


object {   // Mural
  height_field {
    tga "C:\Program Files\Moray For Windows\AllMyMDLs\Souvenirs\mural.tga"
    water_level 0.2
  }
  rotate    <-90, 0, 0> // Turn onto XY plane. Now points along -Z
  scale     <  2, 2,-2> // Scale to Cube size. Now points along +Z
  translate < -1,-1,-1> // Center around origin
  texture {
    LeftHand
  }
  scale <6.0, 23.0, 0.3>
  rotate <90.0, 0.0, -0.0>
  translate  <64.008918, 154.939077, 114.0>
}


box { // WorldPicture
  <-1, -1, -1>, <1, 1, 1>
  texture {
    PlanetBackGrnd
    scale <2.002595, 1.996178, 0.899741>
    rotate <-90.0, 0.0, 90.0>
    translate <0.000000, -0.996178, 1.011163>
  }
  scale <0.5, 25.0, 18.0>
  translate  <-93.580218, 151.5, 123.7>
}


union { // FloorDone
  object { Floor }
  object { // Floor1->Floor
    Floor
    translate  <0.1, 6.1, 0.0>
  }
  object { // Floor2->Floor
    Floor
    translate  <0.2, 12.2, 0.0>
  }
  object { // Floor3->Floor
    Floor
    translate  <0.3, 18.3, 0.0>
  }
  object { // Floor4->Floor
    Floor
    translate  <0.4, 24.4, 0.0>
  }
  object { // Floor5->Floor
    Floor
    translate  <0.5, 30.5, 0.0>
  }
  object { // Floor6->Floor
    Floor
    translate  <0.6, 36.6, 0.0>
  }
  object { // Floor7->Floor
    Floor
    translate  <0.7, 42.7, 0.0>
  }
  object { // Floor8->Floor
    Floor
    translate  <0.8, 48.8, 0.0>
  }
  object { // Floor9->Floor
    Floor
    translate  <0.9, 54.9, 0.0>
  }
  object { // Floor10->Floor
    Floor
    translate  <1.0, 61.0, 0.0>
  }
  object { // Floor11->Floor
    Floor
    translate  <1.1, 67.1, 0.0>
  }
  object { // Floor12->Floor
    Floor
    translate  <1.2, 73.2, 0.0>
  }
  object { // Floor13->Floor
    Floor
    translate  <1.3, 79.3, 0.0>
  }
  object { // Floor14->Floor
    Floor
    translate  <1.4, 85.4, 0.0>
  }
  object { // Floor15->Floor
    Floor
    translate  <1.5, 91.5, 0.0>
  }
  object { // Floor16->Floor
    Floor
    translate  <1.6, 97.6, 0.0>
  }
  object { // Floor17->Floor
    Floor
    translate  <1.7, 103.7, 0.0>
  }
  object { // Floor18->Floor
    Floor
    translate  <1.8, 109.8, 0.0>
  }
  object { // Floor19->Floor
    Floor
    translate  <1.9, 115.9, 0.0>
  }
  object { // Floor20->Floor
    Floor
    translate  <2.0, 122.0, 0.0>
  }
  object { // Floor21->Floor
    Floor
    translate  <2.1, 128.1, 0.0>
  }
  object { // Floor22->Floor
    Floor
    translate  <2.2, 134.2, 0.0>
  }
  object { // Floor23->Floor
    Floor
    translate  <2.3, 140.3, 0.0>
  }
  object { // Floor24->Floor
    Floor
    translate  <2.4, 146.4, 0.0>
  }
  object { // Floor25->Floor
    Floor
    translate  <2.5, 152.5, 0.0>
  }
}


box { // Wall2
  <-1, -1, -1>, <1, 1, 1>
  texture {
    White_Plaster
  }
  scale <135.0, 3.0, 45.0>
  rotate -90.0*z
  translate  <-97.740904, 259.713969, 125.823071>
}


#declare GuardPost2 = union {
  cylinder { // Post3
    <0,0,1>, <0,0,0>, 1 
    texture {
      Aluminum
    }
    scale <1.0, 1.0, 18.0>
    translate  -4.042463*z
  }
  cylinder { // Cap2
    <0,0,1>, <0,0,0>, 1 
    texture {
      Spun_Gold
    }
    scale <1.15, 1.15, 1.0>
    translate  13.1*z
  }
  sphere { // Knob2
    <0,0,0>,1
    texture {
      Spun_Gold
    }
    scale 1.2
    translate  15.146348*z
  }
  cone { // Base2
    <0,0,0>, 1.0, <0,0,1>, 0.1
    texture {
      Aluminum
    }
    scale <5.5, 5.5, 1.0>
    translate  -4.44034*z
  }
  translate  <-38.070047, 100.112058, 84.254882>
}
#declare GuardPost1 = union {
  cylinder { // Post2
    <0,0,1>, <0,0,0>, 1 
    texture {
      Aluminum
    }
    scale <1.0, 1.0, 18.0>
    translate  -4.042463*z
  }
  cylinder { // Cap1
    <0,0,1>, <0,0,0>, 1 
    texture {
      Spun_Gold
    }
    scale <1.15, 1.15, 1.0>
    translate  13.1*z
  }
  sphere { // Knob1
    <0,0,0>,1
    texture {
      Spun_Gold
    }
    scale 1.2
    translate  15.146348*z
  }
  cone { // Base1
    <0,0,0>, 1.0, <0,0,1>, 0.1
    texture {
      Aluminum
    }
    scale <5.5, 5.5, 1.0>
    translate  -4.44034*z
  }
  translate  <15.264253, 145.736423, 84.254882>
}
#declare VelvetRope = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-9.447783, 0.000000, 6.548202>, <-9.447783, -0.384149, 6.548202>, <-9.513855, -0.860668, 6.453039>, <-9.732943, -0.860668, 6.137491>, 
      <-8.171611, 0.000000, 5.662140>, <-8.171611, -0.384149, 5.662140>, <-8.237683, -0.860668, 5.566977>, <-8.456772, -0.860668, 5.251429>, 
      <-6.593728, 0.000000, 4.268556>, <-6.593728, -0.384149, 4.268556>, <-6.662492, -0.860668, 4.167774>, <-6.881581, -0.860668, 3.852226>, 
      <-5.193875, 0.000000, 3.594662>, <-5.193875, -0.384149, 3.594662>, <-5.259948, -0.860668, 3.499499>, <-5.479037, -0.860668, 3.183951>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-9.732943, 0.860668, 6.137491>, <-9.513855, 0.860668, 6.453039>, <-9.447783, 0.384149, 6.548202>, <-9.447783, 0.000000, 6.548202>, 
      <-8.456772, 0.860668, 5.251429>, <-8.237683, 0.860668, 5.566977>, <-8.171611, 0.384149, 5.662140>, <-8.171611, 0.000000, 5.662140>, 
      <-6.881581, 0.860668, 3.852226>, <-6.662492, 0.860668, 4.167774>, <-6.593728, 0.384149, 4.268556>, <-6.593728, 0.000000, 4.268556>, 
      <-5.479037, 0.860668, 3.183951>, <-5.259948, 0.860668, 3.499499>, <-5.193875, 0.384149, 3.594662>, <-5.193875, 0.000000, 3.594662>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-10.018105, 0.000000, 5.726781>, <-10.018105, 0.384149, 5.726781>, <-9.952031, 0.860668, 5.821943>, <-9.732943, 0.860668, 6.137491>, 
      <-8.741933, 0.000000, 4.840719>, <-8.741933, 0.384149, 4.840719>, <-8.675859, 0.860668, 4.935881>, <-8.456772, 0.860668, 5.251429>, 
      <-7.169269, 0.000000, 3.436187>, <-7.169269, 0.384149, 3.436187>, <-7.100670, 0.860668, 3.536678>, <-6.881581, 0.860668, 3.852226>, 
      <-5.764198, 0.000000, 2.773241>, <-5.764198, 0.384149, 2.773241>, <-5.698125, 0.860668, 2.868403>, <-5.479037, 0.860668, 3.183951>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-10.018105, 0.000000, 5.726781>, <-8.741933, 0.000000, 4.840719>, <-7.169269, 0.000000, 3.436187>, <-5.764198, 0.000000, 2.773241>, 
      <-10.018105, -0.384149, 5.726781>, <-8.741933, -0.384149, 4.840719>, <-7.169269, -0.384149, 3.436187>, <-5.764198, -0.384149, 2.773241>, 
      <-9.952031, -0.860668, 5.821943>, <-8.675859, -0.860668, 4.935881>, <-7.100670, -0.860668, 3.536678>, <-5.698125, -0.860668, 2.868403>, 
      <-9.732943, -0.860668, 6.137491>, <-8.456772, -0.860668, 5.251429>, <-6.881581, -0.860668, 3.852226>, <-5.479037, -0.860668, 3.183951>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 0.000000, 2.000000>, <-1.629417, 0.000000, 2.041655>, <-3.725243, 0.000000, 2.887656>, <-5.193875, 0.000000, 3.594662>, 
      <0.000000, -0.384149, 2.000000>, <-1.629417, -0.384149, 2.041655>, <-3.725243, -0.384149, 2.887656>, <-5.193875, -0.384149, 3.594662>, 
      <0.000000, -0.860668, 1.884149>, <-1.719021, -0.860668, 1.928461>, <-3.707566, -0.860668, 2.759830>, <-5.259948, -0.860668, 3.499499>, 
      <0.000000, -0.860668, 1.500000>, <-1.719021, -0.860668, 1.544312>, <-3.926655, -0.860668, 2.444282>, <-5.479037, -0.860668, 3.183951>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 0.860668, 1.500000>, <-1.719021, 0.860668, 1.544312>, <-3.926655, 0.860668, 2.444282>, <-5.479037, 0.860668, 3.183951>, 
      <0.000000, 0.860668, 1.884149>, <-1.719021, 0.860668, 1.928461>, <-3.707566, 0.860668, 2.759830>, <-5.259948, 0.860668, 3.499499>, 
      <0.000000, 0.384149, 2.000000>, <-1.629417, 0.384149, 2.041655>, <-3.725243, 0.384149, 2.887656>, <-5.193875, 0.384149, 3.594662>, 
      <0.000000, 0.000000, 2.000000>, <-1.629417, 0.000000, 2.041655>, <-3.725243, 0.000000, 2.887656>, <-5.193875, 0.000000, 3.594662>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 0.000000, 1.000000>, <-1.808626, 0.000000, 1.046971>, <-4.127948, 0.000000, 2.001219>, <-5.764198, 0.000000, 2.773241>, 
      <0.000000, 0.384149, 1.000000>, <-1.808626, 0.384149, 1.046971>, <-4.127948, 0.384149, 2.001219>, <-5.764198, 0.384149, 2.773241>, 
      <0.000000, 0.860668, 1.115851>, <-1.719021, 0.860668, 1.160164>, <-4.145744, 0.860668, 2.128735>, <-5.698125, 0.860668, 2.868403>, 
      <0.000000, 0.860668, 1.500000>, <-1.719021, 0.860668, 1.544312>, <-3.926655, 0.860668, 2.444282>, <-5.479037, 0.860668, 3.183951>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 0.000000, 1.000000>, <0.000000, -0.384149, 1.000000>, <0.000000, -0.860668, 1.115851>, <0.000000, -0.860668, 1.500000>, 
      <-1.808626, 0.000000, 1.046971>, <-1.808626, -0.384149, 1.046971>, <-1.719021, -0.860668, 1.160164>, <-1.719021, -0.860668, 1.544312>, 
      <-4.127948, 0.000000, 2.001219>, <-4.127948, -0.384149, 2.001219>, <-4.145744, -0.860668, 2.128735>, <-3.926655, -0.860668, 2.444282>, 
      <-5.764198, 0.000000, 2.773241>, <-5.764198, -0.384149, 2.773241>, <-5.698125, -0.860668, 2.868403>, <-5.479037, -0.860668, 3.183951>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <4.972663, 0.000000, 3.334763>, <3.553156, 0.000000, 2.725824>, <1.544101, 0.000000, 1.960526>, <0.000000, 0.000000, 2.000000>, 
      <4.972663, -0.384149, 3.334763>, <3.553156, -0.384149, 2.725824>, <1.544101, -0.384149, 1.960526>, <0.000000, -0.384149, 2.000000>, 
      <5.032960, -0.860668, 3.235839>, <3.463091, -0.860668, 2.813493>, <1.625149, -0.860668, 1.842256>, <0.000000, -0.860668, 1.884149>, 
      <5.232897, -0.860668, 2.907822>, <3.663028, -0.860668, 2.485475>, <1.625149, -0.860668, 1.458107>, <0.000000, -0.860668, 1.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <5.232897, 0.860668, 2.907822>, <3.663028, 0.860668, 2.485475>, <1.625149, 0.860668, 1.458107>, <0.000000, 0.860668, 1.500000>, 
      <5.032960, 0.860668, 3.235839>, <3.463091, 0.860668, 2.813493>, <1.625149, 0.860668, 1.842256>, <0.000000, 0.860668, 1.884149>, 
      <4.972663, 0.384149, 3.334763>, <3.553156, 0.384149, 2.725824>, <1.544101, 0.384149, 1.960526>, <0.000000, 0.384149, 2.000000>, 
      <4.972663, 0.000000, 3.334763>, <3.553156, 0.000000, 2.725824>, <1.544101, 0.000000, 1.960526>, <0.000000, 0.000000, 2.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <5.232897, 0.860668, 2.907822>, <5.232897, 0.344267, 2.907822>, <5.232897, -0.344267, 2.907822>, <5.232897, -0.860668, 2.907822>, 
      <5.232897, 0.860668, 2.907822>, <5.032960, 0.344267, 3.235839>, <5.032960, -0.344267, 3.235839>, <5.032960, -0.860668, 3.235839>, 
      <5.232897, 0.860668, 2.907822>, <5.032960, 0.344267, 3.235839>, <4.972663, 0.000000, 3.334763>, <4.972663, -0.384149, 3.334763>, 
      <5.232897, 0.860668, 2.907822>, <5.032960, 0.860668, 3.235839>, <4.972663, 0.384149, 3.334763>, <4.972663, 0.000000, 3.334763>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <5.493131, 0.000000, 2.480881>, <3.920190, 0.000000, 1.818362>, <1.706198, 0.000000, 0.955689>, <0.000000, 0.000000, 1.000000>, 
      <5.493131, 0.384149, 2.480881>, <3.920190, 0.384149, 1.818362>, <1.706198, 0.384149, 0.955689>, <0.000000, 0.384149, 1.000000>, 
      <5.432834, 0.860668, 2.579804>, <3.862965, 0.860668, 2.157458>, <1.625149, 0.860668, 1.073959>, <0.000000, 0.860668, 1.115851>, 
      <5.232897, 0.860668, 2.907822>, <3.663028, 0.860668, 2.485475>, <1.625149, 0.860668, 1.458107>, <0.000000, 0.860668, 1.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <5.493131, 0.000000, 2.480881>, <5.493131, -0.384149, 2.480881>, <5.432834, -0.860668, 2.579804>, <5.232897, -0.860668, 2.907822>, 
      <3.920190, 0.000000, 1.818362>, <3.920190, -0.384149, 1.818362>, <3.862965, -0.860668, 2.157458>, <3.663028, -0.860668, 2.485475>, 
      <1.706198, 0.000000, 0.955689>, <1.706198, -0.384149, 0.955689>, <1.625149, -0.860668, 1.073959>, <1.625149, -0.860668, 1.458107>, 
      <0.000000, 0.000000, 1.000000>, <0.000000, -0.384149, 1.000000>, <0.000000, -0.860668, 1.115851>, <0.000000, -0.860668, 1.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <5.493131, 0.000000, 2.480881>, <5.493131, -0.384149, 2.480881>, <5.432834, -0.860668, 2.579804>, <5.232897, -0.860668, 2.907822>, 
      <5.493131, 0.000000, 2.480881>, <5.493131, 0.000000, 2.480881>, <5.432834, -0.344267, 2.579804>, <5.232897, -0.344267, 2.907822>, 
      <5.493131, 0.000000, 2.480881>, <5.493131, 0.000000, 2.480881>, <5.432834, 0.344267, 2.579804>, <5.232897, 0.344267, 2.907822>, 
      <5.493131, 0.000000, 2.480881>, <5.493131, 0.384149, 2.480881>, <5.432834, 0.860668, 2.579804>, <5.232897, 0.860668, 2.907822>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <9.394674, 0.000000, 6.030119>, <8.068070, 0.000000, 5.221512>, <6.400450, 0.000000, 3.947254>, <4.972663, 0.000000, 3.334763>, 
      <9.394674, -0.384149, 6.030119>, <8.068070, -0.384149, 5.221512>, <6.400450, -0.384149, 3.947254>, <4.972663, -0.384149, 3.334763>, 
      <9.454971, -0.860668, 5.931196>, <8.128367, -0.860668, 5.122589>, <6.359563, -0.860668, 4.044446>, <5.032960, -0.860668, 3.235839>, 
      <9.654908, -0.860668, 5.603179>, <8.328304, -0.860668, 4.794572>, <6.559500, -0.860668, 3.716429>, <5.232897, -0.860668, 2.907822>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <9.394674, 0.000000, 6.030119>, <9.394674, 0.384149, 6.030119>, <9.454971, 0.860668, 5.931196>, <9.654908, 0.860668, 5.603179>, 
      <8.068070, 0.000000, 5.221512>, <8.068070, 0.384149, 5.221512>, <8.128367, 0.860668, 5.122589>, <8.328304, 0.860668, 4.794572>, 
      <6.400450, 0.000000, 3.947254>, <6.400450, 0.384149, 3.947254>, <6.359563, 0.860668, 4.044446>, <6.559500, 0.860668, 3.716429>, 
      <4.972663, 0.000000, 3.334763>, <4.972663, 0.384149, 3.334763>, <5.032960, 0.860668, 3.235839>, <5.232897, 0.860668, 2.907822>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <9.394674, 0.000000, 6.030119>, <9.394674, -0.384149, 6.030119>, <9.454971, -0.860668, 5.931196>, <9.654908, -0.860668, 5.603179>, 
      <9.394674, 0.000000, 6.030119>, <9.394674, 0.000000, 6.030119>, <9.454971, -0.344267, 5.931196>, <9.654908, -0.344267, 5.603179>, 
      <9.394674, 0.000000, 6.030119>, <9.394674, 0.000000, 6.030119>, <9.454971, 0.344267, 5.931196>, <9.654908, 0.344267, 5.603179>, 
      <9.394674, 0.000000, 6.030119>, <9.394674, 0.384149, 6.030119>, <9.454971, 0.860668, 5.931196>, <9.654908, 0.860668, 5.603179>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <9.915142, 0.000000, 5.176238>, <8.588539, 0.000000, 4.367631>, <6.924924, 0.000000, 3.083949>, <5.493131, 0.000000, 2.480881>, 
      <9.915142, 0.384149, 5.176238>, <8.588539, 0.384149, 4.367631>, <6.924924, 0.384149, 3.083949>, <5.493131, 0.384149, 2.480881>, 
      <9.854846, 0.860668, 5.275162>, <8.528242, 0.860668, 4.466555>, <6.759438, 0.860668, 3.388412>, <5.432834, 0.860668, 2.579804>, 
      <9.654908, 0.860668, 5.603179>, <8.328304, 0.860668, 4.794572>, <6.559500, 0.860668, 3.716429>, <5.232897, 0.860668, 2.907822>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <9.915142, 0.000000, 5.176238>, <9.915142, 0.384149, 5.176238>, <9.854846, 0.860668, 5.275162>, <9.654908, 0.860668, 5.603179>, 
      <9.915142, 0.000000, 5.176238>, <9.915142, 0.000000, 5.176238>, <9.854846, 0.344267, 5.275162>, <9.654908, 0.344267, 5.603179>, 
      <9.915142, 0.000000, 5.176238>, <9.915142, 0.000000, 5.176238>, <9.854846, -0.344267, 5.275162>, <9.654908, -0.344267, 5.603179>, 
      <9.915142, 0.000000, 5.176238>, <9.915142, -0.384149, 5.176238>, <9.854846, -0.860668, 5.275162>, <9.654908, -0.860668, 5.603179>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <9.915142, 0.000000, 5.176238>, <9.915142, -0.384149, 5.176238>, <9.854846, -0.860668, 5.275162>, <9.654908, -0.860668, 5.603179>, 
      <8.588539, 0.000000, 4.367631>, <8.588539, -0.384149, 4.367631>, <8.528242, -0.860668, 4.466555>, <8.328304, -0.860668, 4.794572>, 
      <6.924924, 0.000000, 3.083949>, <6.924924, -0.384149, 3.083949>, <6.759438, -0.860668, 3.388412>, <6.559500, -0.860668, 3.716429>, 
      <5.493131, 0.000000, 2.480881>, <5.493131, -0.384149, 2.480881>, <5.432834, -0.860668, 2.579804>, <5.232897, -0.860668, 2.907822>
    }
  }
  texture {
    FireCape
  }
  scale <3.3, 1.0, 2.2>
  translate  <-10.946523, 99.933238, 85.735896>
}
#declare RopeDone = union {
  cylinder { // RopeCap1
    <0,0,1>, <0,0,0>, 1 
    texture {
      Spun_Gold
    }
    scale <1.3, 1.3, 2.5>
    rotate <180.0, -65.0, 180.0>
    translate  <21.297193, 100.0, 98.267448>
  }
  object { VelvetRope }
  cylinder { // RopeCap2
    <0,0,1>, <0,0,0>, 1 
    texture {
      Spun_Gold
    }
    scale <1.3, 1.3, 2.5>
    rotate <180.0, 65.0, 180.0>
    translate  <-43.665514, 100.0, 99.498947>
  }
  cylinder { // Line1
    <0,0,1>, <0,0,0>, 1 
    texture {
      Spun_Gold
    }
    scale <0.5, 0.5, 3.0>
    rotate <180.0, -65.0, 180.0>
    translate  <23.558676, 100.0, 99.359929>
  }
  cylinder { // Line2
    <0,0,1>, <0,0,0>, 1 
    texture {
      Spun_Gold
    }
    scale <0.5, 0.5, 3.0>
    rotate <180.0, 65.0, 180.0>
    translate  <-45.930041, 100.0, 100.577294>
  }
  scale <1.0, 0.6, 0.6>
  rotate <0.0, -0.92701, 40.5>
  translate  <37.188545, 85.402683, 39.85497>
}
#declare BodyDone = merge {
  cone { // BtmTop1
    <0,0,0>, 0.66, <0,0,1>, 0.94
    scale <4.0, 4.0, 1.25>
    translate  2.197941*z
  }
  cone { // BtmTop
    <0,0,0>, 0.66, <0,0,1>, 0.94
    scale <4.0, 4.0, 1.8>
    rotate 180.0*x
    translate  5.25*z
  }
  texture {
    MottledBlueRed
  }
}
#declare Cutters = union {
  object { Cutter1 }
  object { // Cutter3->Cutter1
    Cutter1
    rotate -90.0*z
    translate  <0.0, -0.0, 0.0>
  }
  object { // Cutter5->Cutter1
    Cutter1
    rotate 180.0*z
    translate  <-0.0, -0.0, 0.0>
  }
  object { // Cutter7->Cutter1
    Cutter1
    rotate 90.0*z
    translate  <-0.0, 0.0, 0.0>
  }
  object { EngineWindow }
  object { // EngineWindow1->EngineWindow
    EngineWindow
    rotate <0.0, -0.0, -45.0>
  }
  object { // EngineWindow2->EngineWindow
    EngineWindow
    rotate <0.0, -0.0, -90.0>
    translate  0.0*x
  }
  object { // EngineWindow3->EngineWindow
    EngineWindow
    rotate <0.0, -0.0, -135.0>
    translate  0.0*x
  }
  object { // EngineWindow4->EngineWindow
    EngineWindow
    rotate <0.0, -0.0, 180.0>
    translate  <-0.0, -0.0, 0.0>
  }
  object { // EngineWindow5->EngineWindow
    EngineWindow
    rotate <0.0, -0.0, 135.0>
    translate  <-0.0, -0.0, 0.0>
  }
  object { // EngineWindow6->EngineWindow
    EngineWindow
    rotate <0.0, -0.0, 90.0>
    translate  -0.0*x
  }
  object { // EngineWindow7->EngineWindow
    EngineWindow
    rotate <0.0, -0.0, 45.0>
    translate  <-0.0, 0.0, 0.0>
  }
  object { EngineSmWindow }
  object { // EngineSmWindow1->EngineSmWindow
    EngineSmWindow
    rotate -36.0*z
    translate  <0.0, -0.0, -0.0>
  }
  object { // EngineSmWindow2->EngineSmWindow
    EngineSmWindow
    rotate -72.0*z
    translate  <0.0, -0.0, -0.0>
  }
  object { // EngineSmWindow3->EngineSmWindow
    EngineSmWindow
    rotate -108.0*z
    translate  <-0.0, -0.0, -0.0>
  }
  object { // EngineSmWindow4->EngineSmWindow
    EngineSmWindow
    rotate -144.0*z
    translate  <-0.0, -0.0, -0.0>
  }
  object { // EngineSmWindow5->EngineSmWindow
    EngineSmWindow
    rotate 180.0*z
    translate  <-0.0, 0.0, -0.0>
  }
  object { // EngineSmWindow6->EngineSmWindow
    EngineSmWindow
    rotate 144.0*z
    translate  <-0.0, 0.0, -0.0>
  }
  object { // EngineSmWindow7->EngineSmWindow
    EngineSmWindow
    rotate 108.0*z
    translate  <0.0, 0.0, -0.0>
  }
  object { // EngineSmWindow8->EngineSmWindow
    EngineSmWindow
    rotate 72.0*z
    translate  <0.0, 0.0, -0.0>
  }
  object { // EngineSmWindow9->EngineSmWindow
    EngineSmWindow
    rotate 36.0*z
    translate  <0.0, 0.0, -0.0>
  }
  rotate -14.61492*z
}
#declare BodywWindows = difference {
  object { BodyDone }
  object { Cutters }
}
#declare TopBit = union {
  object { Node1 }
  cone { // TipTop
    <0,0,0>, 1.0, <0,0,1>, 0.6
    texture {
      Pale_Gray
    }
    translate  6.985334*z
  }
  object { // Node2->Node1
    Node1
    rotate <0.0, -0.0, -45.0>
    translate  0.0*x
  }
  object { // Node3->Node1
    Node1
    rotate <0.0, -0.0, -90.0>
    translate  0.0*x
  }
  object { // Node4->Node1
    Node1
    rotate <0.0, -0.0, -135.0>
    translate  <0.0, -0.0, 0.0>
  }
  object { // Node5->Node1
    Node1
    rotate <0.0, -0.0, 180.0>
    translate  -0.0*y
  }
  object { // Node6->Node1
    Node1
    rotate <0.0, -0.0, 135.0>
    translate  <-0.0, -0.0, 0.0>
  }
  object { // Node7->Node1
    Node1
    rotate <0.0, -0.0, 90.0>
    translate  -0.0*x
  }
  object { // Node8->Node1
    Node1
    rotate <0.0, -0.0, 45.0>
    translate  <-0.0, 0.0, 0.0>
  }
}
#declare AlienShip = union {
  torus { // RotatorCuff
    1.5, 0.5  rotate -x*90
    texture {
      MottledBlueRed
    }
    scale <1.068623, 1.068623, 0.742099>
    translate  2.082137*z
  }
  object { // EngineBlock1->EngineBlock
    EngineBlock
    rotate 180.0*z
  }
  object { // BodyBlock7->BodyBlock
    BodyBlock
    rotate 45.0*z
    translate  <0.0, 0.0, -0.0>
  }
  object { // BodyBlock6->BodyBlock
    BodyBlock
    rotate 90.0*z
    translate  <-0.0, 0.0, -0.0>
  }
  object { // BodyBlock5->BodyBlock
    BodyBlock
    rotate 135.0*z
    translate  <-0.0, -0.0, -0.0>
  }
  object { // BodyBlock4->BodyBlock
    BodyBlock
    rotate -180.0*z
    translate  <0.0, -0.0, -0.0>
  }
  object { // BodyBlock3->BodyBlock
    BodyBlock
    rotate -135.0*z
    translate  <0.0, -0.0, -0.0>
  }
  object { // BodyBlock2->BodyBlock
    BodyBlock
    rotate -90.0*z
    translate  <0.0, 0.0, -0.0>
  }
  object { // BodyBlock1->BodyBlock
    BodyBlock
    rotate -45.0*z
    translate  -0.0*z
  }
  object { BodyBlock }
  object { BodywWindows }
  torus { // RotatingCuff
    1.5, 0.5  rotate -x*90
    texture {
      MottledBlueRed
    }
    scale 1.682793
    translate  0.398296*z
  }
  object { EngineBlock }
  torus { // LandingLeg
    1.675, 0.325  rotate -x*90
    texture {
      Plastic_Black
    }
    scale <1.0, 0.5, 1.0>
    rotate -90.0*x
    translate  <0.014437, 0.0, -0.653373>
  }
  cylinder { // centralShaft
    <0,0,1>, <0,0,0>, 1 
    texture {
      Plastic_Black
    }
    scale <2.2, 2.2, 2.55>
    rotate 180.0*x
    translate  1.815832*z
  }
  cylinder { // MidBit1
    <0,0,1>, <0,0,0>, 1 
    texture {
      Plastic_Black
    }
    scale <2.2, 2.2, 0.35>
    rotate 180.0*x
    translate  5.634596*z
  }
  cone { // MidRing
    <0,0,0>, 1.0, <0,0,1>, 0.9
    texture {
      MottledBlueRed
    }
    scale <2.65, 2.65, 0.442888>
    translate  5.1*z
  }
  cylinder { // MidBit
    <0,0,1>, <0,0,0>, 1 
    texture {
      Plastic_Black
    }
    scale <1.7, 1.7, 0.55>
    rotate 180.0*x
    translate  6.171772*z
  }
  object { // PanelDone4->PanelDone5
    PanelDone5
    rotate 90.0*z
  }
  object { // PanelDone3->PanelDone5
    PanelDone5
    rotate -180.0*z
  }
  object { // PanelDone2->PanelDone5
    PanelDone5
    rotate -90.0*z
  }
  object { PanelDone5 }
  cone { // TopMiddle
    <0,0,0>, 1.0, <0,0,1>, 0.7
    texture {
      MottledBlueRed
    }
    scale <2.1, 2.1, 1.0>
    translate  6.139079*z
  }
  object { TopBit }
  scale 2.8
  rotate 42.161682*z
  translate  <-29.259245, 141.901469, 103.337018>
}
#declare GuardPost = union {
  cylinder { // Post
    <0,0,1>, <0,0,0>, 1 
    texture {
      Aluminum
    }
    scale <1.0, 1.0, 18.0>
    translate  -4.042463*z
  }
  cylinder { // Cap
    <0,0,1>, <0,0,0>, 1 
    texture {
      Spun_Gold
    }
    scale <1.15, 1.15, 1.0>
    translate  13.1*z
  }
  sphere { // Knob
    <0,0,0>,1
    texture {
      Spun_Gold
    }
    scale 1.2
    translate  15.146348*z
  }
  cone { // Base
    <0,0,0>, 1.0, <0,0,1>, 0.1
    texture {
      Aluminum
    }
    scale <5.5, 5.5, 1.0>
    translate  -4.44034*z
  }
  translate  <-70.269945, 134.768675, 84.254882>
}
#declare GuardPost3 = union {
  cylinder { // Post4
    <0,0,1>, <0,0,0>, 1 
    texture {
      Aluminum
    }
    scale <1.0, 1.0, 18.0>
    translate  -4.042463*z
  }
  cylinder { // Cap3
    <0,0,1>, <0,0,0>, 1 
    texture {
      Spun_Gold
    }
    scale <1.15, 1.15, 1.0>
    translate  13.1*z
  }
  sphere { // Knob3
    <0,0,0>,1
    texture {
      Spun_Gold
    }
    scale 1.2
    translate  15.146348*z
  }
  cone { // Base3
    <0,0,0>, 1.0, <0,0,1>, 0.1
    texture {
      Aluminum
    }
    scale <5.5, 5.5, 1.0>
    translate  -4.44034*z
  }
  translate  <-16.11011, 179.962563, 84.254882>
}
#declare VelvetRope1 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-9.447783, 0.000000, 6.548202>, <-9.447783, -0.384149, 6.548202>, <-9.513855, -0.860668, 6.453039>, <-9.732943, -0.860668, 6.137491>, 
      <-8.171611, 0.000000, 5.662140>, <-8.171611, -0.384149, 5.662140>, <-8.237683, -0.860668, 5.566977>, <-8.456772, -0.860668, 5.251429>, 
      <-6.593728, 0.000000, 4.268556>, <-6.593728, -0.384149, 4.268556>, <-6.662492, -0.860668, 4.167774>, <-6.881581, -0.860668, 3.852226>, 
      <-5.193875, 0.000000, 3.594662>, <-5.193875, -0.384149, 3.594662>, <-5.259948, -0.860668, 3.499499>, <-5.479037, -0.860668, 3.183951>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-9.732943, 0.860668, 6.137491>, <-9.513855, 0.860668, 6.453039>, <-9.447783, 0.384149, 6.548202>, <-9.447783, 0.000000, 6.548202>, 
      <-8.456772, 0.860668, 5.251429>, <-8.237683, 0.860668, 5.566977>, <-8.171611, 0.384149, 5.662140>, <-8.171611, 0.000000, 5.662140>, 
      <-6.881581, 0.860668, 3.852226>, <-6.662492, 0.860668, 4.167774>, <-6.593728, 0.384149, 4.268556>, <-6.593728, 0.000000, 4.268556>, 
      <-5.479037, 0.860668, 3.183951>, <-5.259948, 0.860668, 3.499499>, <-5.193875, 0.384149, 3.594662>, <-5.193875, 0.000000, 3.594662>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-10.018105, 0.000000, 5.726781>, <-10.018105, 0.384149, 5.726781>, <-9.952031, 0.860668, 5.821943>, <-9.732943, 0.860668, 6.137491>, 
      <-8.741933, 0.000000, 4.840719>, <-8.741933, 0.384149, 4.840719>, <-8.675859, 0.860668, 4.935881>, <-8.456772, 0.860668, 5.251429>, 
      <-7.169269, 0.000000, 3.436187>, <-7.169269, 0.384149, 3.436187>, <-7.100670, 0.860668, 3.536678>, <-6.881581, 0.860668, 3.852226>, 
      <-5.764198, 0.000000, 2.773241>, <-5.764198, 0.384149, 2.773241>, <-5.698125, 0.860668, 2.868403>, <-5.479037, 0.860668, 3.183951>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-10.018105, 0.000000, 5.726781>, <-8.741933, 0.000000, 4.840719>, <-7.169269, 0.000000, 3.436187>, <-5.764198, 0.000000, 2.773241>, 
      <-10.018105, -0.384149, 5.726781>, <-8.741933, -0.384149, 4.840719>, <-7.169269, -0.384149, 3.436187>, <-5.764198, -0.384149, 2.773241>, 
      <-9.952031, -0.860668, 5.821943>, <-8.675859, -0.860668, 4.935881>, <-7.100670, -0.860668, 3.536678>, <-5.698125, -0.860668, 2.868403>, 
      <-9.732943, -0.860668, 6.137491>, <-8.456772, -0.860668, 5.251429>, <-6.881581, -0.860668, 3.852226>, <-5.479037, -0.860668, 3.183951>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 0.000000, 2.000000>, <-1.629417, 0.000000, 2.041655>, <-3.725243, 0.000000, 2.887656>, <-5.193875, 0.000000, 3.594662>, 
      <0.000000, -0.384149, 2.000000>, <-1.629417, -0.384149, 2.041655>, <-3.725243, -0.384149, 2.887656>, <-5.193875, -0.384149, 3.594662>, 
      <0.000000, -0.860668, 1.884149>, <-1.719021, -0.860668, 1.928461>, <-3.707566, -0.860668, 2.759830>, <-5.259948, -0.860668, 3.499499>, 
      <0.000000, -0.860668, 1.500000>, <-1.719021, -0.860668, 1.544312>, <-3.926655, -0.860668, 2.444282>, <-5.479037, -0.860668, 3.183951>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 0.860668, 1.500000>, <-1.719021, 0.860668, 1.544312>, <-3.926655, 0.860668, 2.444282>, <-5.479037, 0.860668, 3.183951>, 
      <0.000000, 0.860668, 1.884149>, <-1.719021, 0.860668, 1.928461>, <-3.707566, 0.860668, 2.759830>, <-5.259948, 0.860668, 3.499499>, 
      <0.000000, 0.384149, 2.000000>, <-1.629417, 0.384149, 2.041655>, <-3.725243, 0.384149, 2.887656>, <-5.193875, 0.384149, 3.594662>, 
      <0.000000, 0.000000, 2.000000>, <-1.629417, 0.000000, 2.041655>, <-3.725243, 0.000000, 2.887656>, <-5.193875, 0.000000, 3.594662>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 0.000000, 1.000000>, <-1.808626, 0.000000, 1.046971>, <-4.127948, 0.000000, 2.001219>, <-5.764198, 0.000000, 2.773241>, 
      <0.000000, 0.384149, 1.000000>, <-1.808626, 0.384149, 1.046971>, <-4.127948, 0.384149, 2.001219>, <-5.764198, 0.384149, 2.773241>, 
      <0.000000, 0.860668, 1.115851>, <-1.719021, 0.860668, 1.160164>, <-4.145744, 0.860668, 2.128735>, <-5.698125, 0.860668, 2.868403>, 
      <0.000000, 0.860668, 1.500000>, <-1.719021, 0.860668, 1.544312>, <-3.926655, 0.860668, 2.444282>, <-5.479037, 0.860668, 3.183951>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 0.000000, 1.000000>, <0.000000, -0.384149, 1.000000>, <0.000000, -0.860668, 1.115851>, <0.000000, -0.860668, 1.500000>, 
      <-1.808626, 0.000000, 1.046971>, <-1.808626, -0.384149, 1.046971>, <-1.719021, -0.860668, 1.160164>, <-1.719021, -0.860668, 1.544312>, 
      <-4.127948, 0.000000, 2.001219>, <-4.127948, -0.384149, 2.001219>, <-4.145744, -0.860668, 2.128735>, <-3.926655, -0.860668, 2.444282>, 
      <-5.764198, 0.000000, 2.773241>, <-5.764198, -0.384149, 2.773241>, <-5.698125, -0.860668, 2.868403>, <-5.479037, -0.860668, 3.183951>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <4.972663, 0.000000, 3.334763>, <3.553156, 0.000000, 2.725824>, <1.544101, 0.000000, 1.960526>, <0.000000, 0.000000, 2.000000>, 
      <4.972663, -0.384149, 3.334763>, <3.553156, -0.384149, 2.725824>, <1.544101, -0.384149, 1.960526>, <0.000000, -0.384149, 2.000000>, 
      <5.032960, -0.860668, 3.235839>, <3.463091, -0.860668, 2.813493>, <1.625149, -0.860668, 1.842256>, <0.000000, -0.860668, 1.884149>, 
      <5.232897, -0.860668, 2.907822>, <3.663028, -0.860668, 2.485475>, <1.625149, -0.860668, 1.458107>, <0.000000, -0.860668, 1.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <5.232897, 0.860668, 2.907822>, <3.663028, 0.860668, 2.485475>, <1.625149, 0.860668, 1.458107>, <0.000000, 0.860668, 1.500000>, 
      <5.032960, 0.860668, 3.235839>, <3.463091, 0.860668, 2.813493>, <1.625149, 0.860668, 1.842256>, <0.000000, 0.860668, 1.884149>, 
      <4.972663, 0.384149, 3.334763>, <3.553156, 0.384149, 2.725824>, <1.544101, 0.384149, 1.960526>, <0.000000, 0.384149, 2.000000>, 
      <4.972663, 0.000000, 3.334763>, <3.553156, 0.000000, 2.725824>, <1.544101, 0.000000, 1.960526>, <0.000000, 0.000000, 2.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <5.232897, 0.860668, 2.907822>, <5.232897, 0.344267, 2.907822>, <5.232897, -0.344267, 2.907822>, <5.232897, -0.860668, 2.907822>, 
      <5.232897, 0.860668, 2.907822>, <5.032960, 0.344267, 3.235839>, <5.032960, -0.344267, 3.235839>, <5.032960, -0.860668, 3.235839>, 
      <5.232897, 0.860668, 2.907822>, <5.032960, 0.344267, 3.235839>, <4.972663, 0.000000, 3.334763>, <4.972663, -0.384149, 3.334763>, 
      <5.232897, 0.860668, 2.907822>, <5.032960, 0.860668, 3.235839>, <4.972663, 0.384149, 3.334763>, <4.972663, 0.000000, 3.334763>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <5.493131, 0.000000, 2.480881>, <3.920190, 0.000000, 1.818362>, <1.706198, 0.000000, 0.955689>, <0.000000, 0.000000, 1.000000>, 
      <5.493131, 0.384149, 2.480881>, <3.920190, 0.384149, 1.818362>, <1.706198, 0.384149, 0.955689>, <0.000000, 0.384149, 1.000000>, 
      <5.432834, 0.860668, 2.579804>, <3.862965, 0.860668, 2.157458>, <1.625149, 0.860668, 1.073959>, <0.000000, 0.860668, 1.115851>, 
      <5.232897, 0.860668, 2.907822>, <3.663028, 0.860668, 2.485475>, <1.625149, 0.860668, 1.458107>, <0.000000, 0.860668, 1.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <5.493131, 0.000000, 2.480881>, <5.493131, -0.384149, 2.480881>, <5.432834, -0.860668, 2.579804>, <5.232897, -0.860668, 2.907822>, 
      <3.920190, 0.000000, 1.818362>, <3.920190, -0.384149, 1.818362>, <3.862965, -0.860668, 2.157458>, <3.663028, -0.860668, 2.485475>, 
      <1.706198, 0.000000, 0.955689>, <1.706198, -0.384149, 0.955689>, <1.625149, -0.860668, 1.073959>, <1.625149, -0.860668, 1.458107>, 
      <0.000000, 0.000000, 1.000000>, <0.000000, -0.384149, 1.000000>, <0.000000, -0.860668, 1.115851>, <0.000000, -0.860668, 1.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <5.493131, 0.000000, 2.480881>, <5.493131, -0.384149, 2.480881>, <5.432834, -0.860668, 2.579804>, <5.232897, -0.860668, 2.907822>, 
      <5.493131, 0.000000, 2.480881>, <5.493131, 0.000000, 2.480881>, <5.432834, -0.344267, 2.579804>, <5.232897, -0.344267, 2.907822>, 
      <5.493131, 0.000000, 2.480881>, <5.493131, 0.000000, 2.480881>, <5.432834, 0.344267, 2.579804>, <5.232897, 0.344267, 2.907822>, 
      <5.493131, 0.000000, 2.480881>, <5.493131, 0.384149, 2.480881>, <5.432834, 0.860668, 2.579804>, <5.232897, 0.860668, 2.907822>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <9.394674, 0.000000, 6.030119>, <8.068070, 0.000000, 5.221512>, <6.400450, 0.000000, 3.947254>, <4.972663, 0.000000, 3.334763>, 
      <9.394674, -0.384149, 6.030119>, <8.068070, -0.384149, 5.221512>, <6.400450, -0.384149, 3.947254>, <4.972663, -0.384149, 3.334763>, 
      <9.454971, -0.860668, 5.931196>, <8.128367, -0.860668, 5.122589>, <6.359563, -0.860668, 4.044446>, <5.032960, -0.860668, 3.235839>, 
      <9.654908, -0.860668, 5.603179>, <8.328304, -0.860668, 4.794572>, <6.559500, -0.860668, 3.716429>, <5.232897, -0.860668, 2.907822>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <9.394674, 0.000000, 6.030119>, <9.394674, 0.384149, 6.030119>, <9.454971, 0.860668, 5.931196>, <9.654908, 0.860668, 5.603179>, 
      <8.068070, 0.000000, 5.221512>, <8.068070, 0.384149, 5.221512>, <8.128367, 0.860668, 5.122589>, <8.328304, 0.860668, 4.794572>, 
      <6.400450, 0.000000, 3.947254>, <6.400450, 0.384149, 3.947254>, <6.359563, 0.860668, 4.044446>, <6.559500, 0.860668, 3.716429>, 
      <4.972663, 0.000000, 3.334763>, <4.972663, 0.384149, 3.334763>, <5.032960, 0.860668, 3.235839>, <5.232897, 0.860668, 2.907822>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <9.394674, 0.000000, 6.030119>, <9.394674, -0.384149, 6.030119>, <9.454971, -0.860668, 5.931196>, <9.654908, -0.860668, 5.603179>, 
      <9.394674, 0.000000, 6.030119>, <9.394674, 0.000000, 6.030119>, <9.454971, -0.344267, 5.931196>, <9.654908, -0.344267, 5.603179>, 
      <9.394674, 0.000000, 6.030119>, <9.394674, 0.000000, 6.030119>, <9.454971, 0.344267, 5.931196>, <9.654908, 0.344267, 5.603179>, 
      <9.394674, 0.000000, 6.030119>, <9.394674, 0.384149, 6.030119>, <9.454971, 0.860668, 5.931196>, <9.654908, 0.860668, 5.603179>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <9.915142, 0.000000, 5.176238>, <8.588539, 0.000000, 4.367631>, <6.924924, 0.000000, 3.083949>, <5.493131, 0.000000, 2.480881>, 
      <9.915142, 0.384149, 5.176238>, <8.588539, 0.384149, 4.367631>, <6.924924, 0.384149, 3.083949>, <5.493131, 0.384149, 2.480881>, 
      <9.854846, 0.860668, 5.275162>, <8.528242, 0.860668, 4.466555>, <6.759438, 0.860668, 3.388412>, <5.432834, 0.860668, 2.579804>, 
      <9.654908, 0.860668, 5.603179>, <8.328304, 0.860668, 4.794572>, <6.559500, 0.860668, 3.716429>, <5.232897, 0.860668, 2.907822>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <9.915142, 0.000000, 5.176238>, <9.915142, 0.384149, 5.176238>, <9.854846, 0.860668, 5.275162>, <9.654908, 0.860668, 5.603179>, 
      <9.915142, 0.000000, 5.176238>, <9.915142, 0.000000, 5.176238>, <9.854846, 0.344267, 5.275162>, <9.654908, 0.344267, 5.603179>, 
      <9.915142, 0.000000, 5.176238>, <9.915142, 0.000000, 5.176238>, <9.854846, -0.344267, 5.275162>, <9.654908, -0.344267, 5.603179>, 
      <9.915142, 0.000000, 5.176238>, <9.915142, -0.384149, 5.176238>, <9.854846, -0.860668, 5.275162>, <9.654908, -0.860668, 5.603179>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <9.915142, 0.000000, 5.176238>, <9.915142, -0.384149, 5.176238>, <9.854846, -0.860668, 5.275162>, <9.654908, -0.860668, 5.603179>, 
      <8.588539, 0.000000, 4.367631>, <8.588539, -0.384149, 4.367631>, <8.528242, -0.860668, 4.466555>, <8.328304, -0.860668, 4.794572>, 
      <6.924924, 0.000000, 3.083949>, <6.924924, -0.384149, 3.083949>, <6.759438, -0.860668, 3.388412>, <6.559500, -0.860668, 3.716429>, 
      <5.493131, 0.000000, 2.480881>, <5.493131, -0.384149, 2.480881>, <5.432834, -0.860668, 2.579804>, <5.232897, -0.860668, 2.907822>
    }
  }
  texture {
    FireCape
  }
  scale <3.3, 1.0, 2.2>
  translate  <-10.946523, 99.933238, 85.735896>
}
#declare RopeDone1 = union {
  cylinder { // RopeCap3
    <0,0,1>, <0,0,0>, 1 
    texture {
      Spun_Gold
    }
    scale <1.3, 1.3, 2.5>
    rotate <180.0, -65.0, 180.0>
    translate  <21.297193, 100.0, 98.267448>
  }
  object { VelvetRope1 }
  cylinder { // RopeCap4
    <0,0,1>, <0,0,0>, 1 
    texture {
      Spun_Gold
    }
    scale <1.3, 1.3, 2.5>
    rotate <180.0, 65.0, 180.0>
    translate  <-43.665514, 100.0, 99.498947>
  }
  cylinder { // Line3
    <0,0,1>, <0,0,0>, 1 
    texture {
      Spun_Gold
    }
    scale <0.5, 0.5, 3.0>
    rotate <180.0, -65.0, 180.0>
    translate  <23.558676, 100.0, 99.359929>
  }
  cylinder { // Line4
    <0,0,1>, <0,0,0>, 1 
    texture {
      Spun_Gold
    }
    scale <0.5, 0.5, 3.0>
    rotate <180.0, 65.0, 180.0>
    translate  <-45.930041, 100.0, 100.577294>
  }
  scale <1.0, 0.6, 0.6>
  rotate <0.0, -0.92701, 40.5>
  translate  <4.74502, 119.932159, 39.773109>
}
#declare VelvetRope2 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-9.447783, 0.000000, 6.548202>, <-9.447783, -0.384149, 6.548202>, <-9.513855, -0.860668, 6.453039>, <-9.732943, -0.860668, 6.137491>, 
      <-8.171611, 0.000000, 5.662140>, <-8.171611, -0.384149, 5.662140>, <-8.237683, -0.860668, 5.566977>, <-8.456772, -0.860668, 5.251429>, 
      <-6.593728, 0.000000, 4.268556>, <-6.593728, -0.384149, 4.268556>, <-6.662492, -0.860668, 4.167774>, <-6.881581, -0.860668, 3.852226>, 
      <-5.193875, 0.000000, 3.594662>, <-5.193875, -0.384149, 3.594662>, <-5.259948, -0.860668, 3.499499>, <-5.479037, -0.860668, 3.183951>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-9.732943, 0.860668, 6.137491>, <-9.513855, 0.860668, 6.453039>, <-9.447783, 0.384149, 6.548202>, <-9.447783, 0.000000, 6.548202>, 
      <-8.456772, 0.860668, 5.251429>, <-8.237683, 0.860668, 5.566977>, <-8.171611, 0.384149, 5.662140>, <-8.171611, 0.000000, 5.662140>, 
      <-6.881581, 0.860668, 3.852226>, <-6.662492, 0.860668, 4.167774>, <-6.593728, 0.384149, 4.268556>, <-6.593728, 0.000000, 4.268556>, 
      <-5.479037, 0.860668, 3.183951>, <-5.259948, 0.860668, 3.499499>, <-5.193875, 0.384149, 3.594662>, <-5.193875, 0.000000, 3.594662>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-10.018105, 0.000000, 5.726781>, <-10.018105, 0.384149, 5.726781>, <-9.952031, 0.860668, 5.821943>, <-9.732943, 0.860668, 6.137491>, 
      <-8.741933, 0.000000, 4.840719>, <-8.741933, 0.384149, 4.840719>, <-8.675859, 0.860668, 4.935881>, <-8.456772, 0.860668, 5.251429>, 
      <-7.169269, 0.000000, 3.436187>, <-7.169269, 0.384149, 3.436187>, <-7.100670, 0.860668, 3.536678>, <-6.881581, 0.860668, 3.852226>, 
      <-5.764198, 0.000000, 2.773241>, <-5.764198, 0.384149, 2.773241>, <-5.698125, 0.860668, 2.868403>, <-5.479037, 0.860668, 3.183951>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-10.018105, 0.000000, 5.726781>, <-8.741933, 0.000000, 4.840719>, <-7.169269, 0.000000, 3.436187>, <-5.764198, 0.000000, 2.773241>, 
      <-10.018105, -0.384149, 5.726781>, <-8.741933, -0.384149, 4.840719>, <-7.169269, -0.384149, 3.436187>, <-5.764198, -0.384149, 2.773241>, 
      <-9.952031, -0.860668, 5.821943>, <-8.675859, -0.860668, 4.935881>, <-7.100670, -0.860668, 3.536678>, <-5.698125, -0.860668, 2.868403>, 
      <-9.732943, -0.860668, 6.137491>, <-8.456772, -0.860668, 5.251429>, <-6.881581, -0.860668, 3.852226>, <-5.479037, -0.860668, 3.183951>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 0.000000, 2.000000>, <-1.629417, 0.000000, 2.041655>, <-3.725243, 0.000000, 2.887656>, <-5.193875, 0.000000, 3.594662>, 
      <0.000000, -0.384149, 2.000000>, <-1.629417, -0.384149, 2.041655>, <-3.725243, -0.384149, 2.887656>, <-5.193875, -0.384149, 3.594662>, 
      <0.000000, -0.860668, 1.884149>, <-1.719021, -0.860668, 1.928461>, <-3.707566, -0.860668, 2.759830>, <-5.259948, -0.860668, 3.499499>, 
      <0.000000, -0.860668, 1.500000>, <-1.719021, -0.860668, 1.544312>, <-3.926655, -0.860668, 2.444282>, <-5.479037, -0.860668, 3.183951>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 0.860668, 1.500000>, <-1.719021, 0.860668, 1.544312>, <-3.926655, 0.860668, 2.444282>, <-5.479037, 0.860668, 3.183951>, 
      <0.000000, 0.860668, 1.884149>, <-1.719021, 0.860668, 1.928461>, <-3.707566, 0.860668, 2.759830>, <-5.259948, 0.860668, 3.499499>, 
      <0.000000, 0.384149, 2.000000>, <-1.629417, 0.384149, 2.041655>, <-3.725243, 0.384149, 2.887656>, <-5.193875, 0.384149, 3.594662>, 
      <0.000000, 0.000000, 2.000000>, <-1.629417, 0.000000, 2.041655>, <-3.725243, 0.000000, 2.887656>, <-5.193875, 0.000000, 3.594662>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 0.000000, 1.000000>, <-1.808626, 0.000000, 1.046971>, <-4.127948, 0.000000, 2.001219>, <-5.764198, 0.000000, 2.773241>, 
      <0.000000, 0.384149, 1.000000>, <-1.808626, 0.384149, 1.046971>, <-4.127948, 0.384149, 2.001219>, <-5.764198, 0.384149, 2.773241>, 
      <0.000000, 0.860668, 1.115851>, <-1.719021, 0.860668, 1.160164>, <-4.145744, 0.860668, 2.128735>, <-5.698125, 0.860668, 2.868403>, 
      <0.000000, 0.860668, 1.500000>, <-1.719021, 0.860668, 1.544312>, <-3.926655, 0.860668, 2.444282>, <-5.479037, 0.860668, 3.183951>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 0.000000, 1.000000>, <0.000000, -0.384149, 1.000000>, <0.000000, -0.860668, 1.115851>, <0.000000, -0.860668, 1.500000>, 
      <-1.808626, 0.000000, 1.046971>, <-1.808626, -0.384149, 1.046971>, <-1.719021, -0.860668, 1.160164>, <-1.719021, -0.860668, 1.544312>, 
      <-4.127948, 0.000000, 2.001219>, <-4.127948, -0.384149, 2.001219>, <-4.145744, -0.860668, 2.128735>, <-3.926655, -0.860668, 2.444282>, 
      <-5.764198, 0.000000, 2.773241>, <-5.764198, -0.384149, 2.773241>, <-5.698125, -0.860668, 2.868403>, <-5.479037, -0.860668, 3.183951>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <4.972663, 0.000000, 3.334763>, <3.553156, 0.000000, 2.725824>, <1.544101, 0.000000, 1.960526>, <0.000000, 0.000000, 2.000000>, 
      <4.972663, -0.384149, 3.334763>, <3.553156, -0.384149, 2.725824>, <1.544101, -0.384149, 1.960526>, <0.000000, -0.384149, 2.000000>, 
      <5.032960, -0.860668, 3.235839>, <3.463091, -0.860668, 2.813493>, <1.625149, -0.860668, 1.842256>, <0.000000, -0.860668, 1.884149>, 
      <5.232897, -0.860668, 2.907822>, <3.663028, -0.860668, 2.485475>, <1.625149, -0.860668, 1.458107>, <0.000000, -0.860668, 1.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <5.232897, 0.860668, 2.907822>, <3.663028, 0.860668, 2.485475>, <1.625149, 0.860668, 1.458107>, <0.000000, 0.860668, 1.500000>, 
      <5.032960, 0.860668, 3.235839>, <3.463091, 0.860668, 2.813493>, <1.625149, 0.860668, 1.842256>, <0.000000, 0.860668, 1.884149>, 
      <4.972663, 0.384149, 3.334763>, <3.553156, 0.384149, 2.725824>, <1.544101, 0.384149, 1.960526>, <0.000000, 0.384149, 2.000000>, 
      <4.972663, 0.000000, 3.334763>, <3.553156, 0.000000, 2.725824>, <1.544101, 0.000000, 1.960526>, <0.000000, 0.000000, 2.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <5.232897, 0.860668, 2.907822>, <5.232897, 0.344267, 2.907822>, <5.232897, -0.344267, 2.907822>, <5.232897, -0.860668, 2.907822>, 
      <5.232897, 0.860668, 2.907822>, <5.032960, 0.344267, 3.235839>, <5.032960, -0.344267, 3.235839>, <5.032960, -0.860668, 3.235839>, 
      <5.232897, 0.860668, 2.907822>, <5.032960, 0.344267, 3.235839>, <4.972663, 0.000000, 3.334763>, <4.972663, -0.384149, 3.334763>, 
      <5.232897, 0.860668, 2.907822>, <5.032960, 0.860668, 3.235839>, <4.972663, 0.384149, 3.334763>, <4.972663, 0.000000, 3.334763>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <5.493131, 0.000000, 2.480881>, <3.920190, 0.000000, 1.818362>, <1.706198, 0.000000, 0.955689>, <0.000000, 0.000000, 1.000000>, 
      <5.493131, 0.384149, 2.480881>, <3.920190, 0.384149, 1.818362>, <1.706198, 0.384149, 0.955689>, <0.000000, 0.384149, 1.000000>, 
      <5.432834, 0.860668, 2.579804>, <3.862965, 0.860668, 2.157458>, <1.625149, 0.860668, 1.073959>, <0.000000, 0.860668, 1.115851>, 
      <5.232897, 0.860668, 2.907822>, <3.663028, 0.860668, 2.485475>, <1.625149, 0.860668, 1.458107>, <0.000000, 0.860668, 1.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <5.493131, 0.000000, 2.480881>, <5.493131, -0.384149, 2.480881>, <5.432834, -0.860668, 2.579804>, <5.232897, -0.860668, 2.907822>, 
      <3.920190, 0.000000, 1.818362>, <3.920190, -0.384149, 1.818362>, <3.862965, -0.860668, 2.157458>, <3.663028, -0.860668, 2.485475>, 
      <1.706198, 0.000000, 0.955689>, <1.706198, -0.384149, 0.955689>, <1.625149, -0.860668, 1.073959>, <1.625149, -0.860668, 1.458107>, 
      <0.000000, 0.000000, 1.000000>, <0.000000, -0.384149, 1.000000>, <0.000000, -0.860668, 1.115851>, <0.000000, -0.860668, 1.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <5.493131, 0.000000, 2.480881>, <5.493131, -0.384149, 2.480881>, <5.432834, -0.860668, 2.579804>, <5.232897, -0.860668, 2.907822>, 
      <5.493131, 0.000000, 2.480881>, <5.493131, 0.000000, 2.480881>, <5.432834, -0.344267, 2.579804>, <5.232897, -0.344267, 2.907822>, 
      <5.493131, 0.000000, 2.480881>, <5.493131, 0.000000, 2.480881>, <5.432834, 0.344267, 2.579804>, <5.232897, 0.344267, 2.907822>, 
      <5.493131, 0.000000, 2.480881>, <5.493131, 0.384149, 2.480881>, <5.432834, 0.860668, 2.579804>, <5.232897, 0.860668, 2.907822>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <9.394674, 0.000000, 6.030119>, <8.068070, 0.000000, 5.221512>, <6.400450, 0.000000, 3.947254>, <4.972663, 0.000000, 3.334763>, 
      <9.394674, -0.384149, 6.030119>, <8.068070, -0.384149, 5.221512>, <6.400450, -0.384149, 3.947254>, <4.972663, -0.384149, 3.334763>, 
      <9.454971, -0.860668, 5.931196>, <8.128367, -0.860668, 5.122589>, <6.359563, -0.860668, 4.044446>, <5.032960, -0.860668, 3.235839>, 
      <9.654908, -0.860668, 5.603179>, <8.328304, -0.860668, 4.794572>, <6.559500, -0.860668, 3.716429>, <5.232897, -0.860668, 2.907822>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <9.394674, 0.000000, 6.030119>, <9.394674, 0.384149, 6.030119>, <9.454971, 0.860668, 5.931196>, <9.654908, 0.860668, 5.603179>, 
      <8.068070, 0.000000, 5.221512>, <8.068070, 0.384149, 5.221512>, <8.128367, 0.860668, 5.122589>, <8.328304, 0.860668, 4.794572>, 
      <6.400450, 0.000000, 3.947254>, <6.400450, 0.384149, 3.947254>, <6.359563, 0.860668, 4.044446>, <6.559500, 0.860668, 3.716429>, 
      <4.972663, 0.000000, 3.334763>, <4.972663, 0.384149, 3.334763>, <5.032960, 0.860668, 3.235839>, <5.232897, 0.860668, 2.907822>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <9.394674, 0.000000, 6.030119>, <9.394674, -0.384149, 6.030119>, <9.454971, -0.860668, 5.931196>, <9.654908, -0.860668, 5.603179>, 
      <9.394674, 0.000000, 6.030119>, <9.394674, 0.000000, 6.030119>, <9.454971, -0.344267, 5.931196>, <9.654908, -0.344267, 5.603179>, 
      <9.394674, 0.000000, 6.030119>, <9.394674, 0.000000, 6.030119>, <9.454971, 0.344267, 5.931196>, <9.654908, 0.344267, 5.603179>, 
      <9.394674, 0.000000, 6.030119>, <9.394674, 0.384149, 6.030119>, <9.454971, 0.860668, 5.931196>, <9.654908, 0.860668, 5.603179>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <9.915142, 0.000000, 5.176238>, <8.588539, 0.000000, 4.367631>, <6.924924, 0.000000, 3.083949>, <5.493131, 0.000000, 2.480881>, 
      <9.915142, 0.384149, 5.176238>, <8.588539, 0.384149, 4.367631>, <6.924924, 0.384149, 3.083949>, <5.493131, 0.384149, 2.480881>, 
      <9.854846, 0.860668, 5.275162>, <8.528242, 0.860668, 4.466555>, <6.759438, 0.860668, 3.388412>, <5.432834, 0.860668, 2.579804>, 
      <9.654908, 0.860668, 5.603179>, <8.328304, 0.860668, 4.794572>, <6.559500, 0.860668, 3.716429>, <5.232897, 0.860668, 2.907822>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <9.915142, 0.000000, 5.176238>, <9.915142, 0.384149, 5.176238>, <9.854846, 0.860668, 5.275162>, <9.654908, 0.860668, 5.603179>, 
      <9.915142, 0.000000, 5.176238>, <9.915142, 0.000000, 5.176238>, <9.854846, 0.344267, 5.275162>, <9.654908, 0.344267, 5.603179>, 
      <9.915142, 0.000000, 5.176238>, <9.915142, 0.000000, 5.176238>, <9.854846, -0.344267, 5.275162>, <9.654908, -0.344267, 5.603179>, 
      <9.915142, 0.000000, 5.176238>, <9.915142, -0.384149, 5.176238>, <9.854846, -0.860668, 5.275162>, <9.654908, -0.860668, 5.603179>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <9.915142, 0.000000, 5.176238>, <9.915142, -0.384149, 5.176238>, <9.854846, -0.860668, 5.275162>, <9.654908, -0.860668, 5.603179>, 
      <8.588539, 0.000000, 4.367631>, <8.588539, -0.384149, 4.367631>, <8.528242, -0.860668, 4.466555>, <8.328304, -0.860668, 4.794572>, 
      <6.924924, 0.000000, 3.083949>, <6.924924, -0.384149, 3.083949>, <6.759438, -0.860668, 3.388412>, <6.559500, -0.860668, 3.716429>, 
      <5.493131, 0.000000, 2.480881>, <5.493131, -0.384149, 2.480881>, <5.432834, -0.860668, 2.579804>, <5.232897, -0.860668, 2.907822>
    }
  }
  texture {
    FireCape
  }
  scale <3.3, 1.0, 2.2>
  translate  <-10.946523, 99.933238, 85.735896>
}
#declare RopeDone2 = union {
  cylinder { // RopeCap5
    <0,0,1>, <0,0,0>, 1 
    texture {
      Spun_Gold
    }
    scale <1.3, 1.3, 2.5>
    rotate <180.0, -65.0, 180.0>
    translate  <21.297193, 100.0, 98.267448>
  }
  object { VelvetRope2 }
  cylinder { // RopeCap6
    <0,0,1>, <0,0,0>, 1 
    texture {
      Spun_Gold
    }
    scale <1.3, 1.3, 2.5>
    rotate <180.0, 65.0, 180.0>
    translate  <-43.665514, 100.0, 99.498947>
  }
  cylinder { // Line5
    <0,0,1>, <0,0,0>, 1 
    texture {
      Spun_Gold
    }
    scale <0.5, 0.5, 3.0>
    rotate <180.0, -65.0, 180.0>
    translate  <23.558676, 100.0, 99.359929>
  }
  cylinder { // Line6
    <0,0,1>, <0,0,0>, 1 
    texture {
      Spun_Gold
    }
    scale <0.5, 0.5, 3.0>
    rotate <180.0, 65.0, 180.0>
    translate  <-45.930041, 100.0, 100.577294>
  }
  scale <0.65, 0.6, 0.6>
  rotate <0.493658, -0.510808, -47.550186>
  translate  <-38.980793, 117.284843, 39.276919>
}
#declare VelvetRope3 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-9.447783, 0.000000, 6.548202>, <-9.447783, -0.384149, 6.548202>, <-9.513855, -0.860668, 6.453039>, <-9.732943, -0.860668, 6.137491>, 
      <-8.171611, 0.000000, 5.662140>, <-8.171611, -0.384149, 5.662140>, <-8.237683, -0.860668, 5.566977>, <-8.456772, -0.860668, 5.251429>, 
      <-6.593728, 0.000000, 4.268556>, <-6.593728, -0.384149, 4.268556>, <-6.662492, -0.860668, 4.167774>, <-6.881581, -0.860668, 3.852226>, 
      <-5.193875, 0.000000, 3.594662>, <-5.193875, -0.384149, 3.594662>, <-5.259948, -0.860668, 3.499499>, <-5.479037, -0.860668, 3.183951>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-9.732943, 0.860668, 6.137491>, <-9.513855, 0.860668, 6.453039>, <-9.447783, 0.384149, 6.548202>, <-9.447783, 0.000000, 6.548202>, 
      <-8.456772, 0.860668, 5.251429>, <-8.237683, 0.860668, 5.566977>, <-8.171611, 0.384149, 5.662140>, <-8.171611, 0.000000, 5.662140>, 
      <-6.881581, 0.860668, 3.852226>, <-6.662492, 0.860668, 4.167774>, <-6.593728, 0.384149, 4.268556>, <-6.593728, 0.000000, 4.268556>, 
      <-5.479037, 0.860668, 3.183951>, <-5.259948, 0.860668, 3.499499>, <-5.193875, 0.384149, 3.594662>, <-5.193875, 0.000000, 3.594662>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-10.018105, 0.000000, 5.726781>, <-10.018105, 0.384149, 5.726781>, <-9.952031, 0.860668, 5.821943>, <-9.732943, 0.860668, 6.137491>, 
      <-8.741933, 0.000000, 4.840719>, <-8.741933, 0.384149, 4.840719>, <-8.675859, 0.860668, 4.935881>, <-8.456772, 0.860668, 5.251429>, 
      <-7.169269, 0.000000, 3.436187>, <-7.169269, 0.384149, 3.436187>, <-7.100670, 0.860668, 3.536678>, <-6.881581, 0.860668, 3.852226>, 
      <-5.764198, 0.000000, 2.773241>, <-5.764198, 0.384149, 2.773241>, <-5.698125, 0.860668, 2.868403>, <-5.479037, 0.860668, 3.183951>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-10.018105, 0.000000, 5.726781>, <-8.741933, 0.000000, 4.840719>, <-7.169269, 0.000000, 3.436187>, <-5.764198, 0.000000, 2.773241>, 
      <-10.018105, -0.384149, 5.726781>, <-8.741933, -0.384149, 4.840719>, <-7.169269, -0.384149, 3.436187>, <-5.764198, -0.384149, 2.773241>, 
      <-9.952031, -0.860668, 5.821943>, <-8.675859, -0.860668, 4.935881>, <-7.100670, -0.860668, 3.536678>, <-5.698125, -0.860668, 2.868403>, 
      <-9.732943, -0.860668, 6.137491>, <-8.456772, -0.860668, 5.251429>, <-6.881581, -0.860668, 3.852226>, <-5.479037, -0.860668, 3.183951>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 0.000000, 2.000000>, <-1.629417, 0.000000, 2.041655>, <-3.725243, 0.000000, 2.887656>, <-5.193875, 0.000000, 3.594662>, 
      <0.000000, -0.384149, 2.000000>, <-1.629417, -0.384149, 2.041655>, <-3.725243, -0.384149, 2.887656>, <-5.193875, -0.384149, 3.594662>, 
      <0.000000, -0.860668, 1.884149>, <-1.719021, -0.860668, 1.928461>, <-3.707566, -0.860668, 2.759830>, <-5.259948, -0.860668, 3.499499>, 
      <0.000000, -0.860668, 1.500000>, <-1.719021, -0.860668, 1.544312>, <-3.926655, -0.860668, 2.444282>, <-5.479037, -0.860668, 3.183951>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 0.860668, 1.500000>, <-1.719021, 0.860668, 1.544312>, <-3.926655, 0.860668, 2.444282>, <-5.479037, 0.860668, 3.183951>, 
      <0.000000, 0.860668, 1.884149>, <-1.719021, 0.860668, 1.928461>, <-3.707566, 0.860668, 2.759830>, <-5.259948, 0.860668, 3.499499>, 
      <0.000000, 0.384149, 2.000000>, <-1.629417, 0.384149, 2.041655>, <-3.725243, 0.384149, 2.887656>, <-5.193875, 0.384149, 3.594662>, 
      <0.000000, 0.000000, 2.000000>, <-1.629417, 0.000000, 2.041655>, <-3.725243, 0.000000, 2.887656>, <-5.193875, 0.000000, 3.594662>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 0.000000, 1.000000>, <-1.808626, 0.000000, 1.046971>, <-4.127948, 0.000000, 2.001219>, <-5.764198, 0.000000, 2.773241>, 
      <0.000000, 0.384149, 1.000000>, <-1.808626, 0.384149, 1.046971>, <-4.127948, 0.384149, 2.001219>, <-5.764198, 0.384149, 2.773241>, 
      <0.000000, 0.860668, 1.115851>, <-1.719021, 0.860668, 1.160164>, <-4.145744, 0.860668, 2.128735>, <-5.698125, 0.860668, 2.868403>, 
      <0.000000, 0.860668, 1.500000>, <-1.719021, 0.860668, 1.544312>, <-3.926655, 0.860668, 2.444282>, <-5.479037, 0.860668, 3.183951>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 0.000000, 1.000000>, <0.000000, -0.384149, 1.000000>, <0.000000, -0.860668, 1.115851>, <0.000000, -0.860668, 1.500000>, 
      <-1.808626, 0.000000, 1.046971>, <-1.808626, -0.384149, 1.046971>, <-1.719021, -0.860668, 1.160164>, <-1.719021, -0.860668, 1.544312>, 
      <-4.127948, 0.000000, 2.001219>, <-4.127948, -0.384149, 2.001219>, <-4.145744, -0.860668, 2.128735>, <-3.926655, -0.860668, 2.444282>, 
      <-5.764198, 0.000000, 2.773241>, <-5.764198, -0.384149, 2.773241>, <-5.698125, -0.860668, 2.868403>, <-5.479037, -0.860668, 3.183951>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <4.972663, 0.000000, 3.334763>, <3.553156, 0.000000, 2.725824>, <1.544101, 0.000000, 1.960526>, <0.000000, 0.000000, 2.000000>, 
      <4.972663, -0.384149, 3.334763>, <3.553156, -0.384149, 2.725824>, <1.544101, -0.384149, 1.960526>, <0.000000, -0.384149, 2.000000>, 
      <5.032960, -0.860668, 3.235839>, <3.463091, -0.860668, 2.813493>, <1.625149, -0.860668, 1.842256>, <0.000000, -0.860668, 1.884149>, 
      <5.232897, -0.860668, 2.907822>, <3.663028, -0.860668, 2.485475>, <1.625149, -0.860668, 1.458107>, <0.000000, -0.860668, 1.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <5.232897, 0.860668, 2.907822>, <3.663028, 0.860668, 2.485475>, <1.625149, 0.860668, 1.458107>, <0.000000, 0.860668, 1.500000>, 
      <5.032960, 0.860668, 3.235839>, <3.463091, 0.860668, 2.813493>, <1.625149, 0.860668, 1.842256>, <0.000000, 0.860668, 1.884149>, 
      <4.972663, 0.384149, 3.334763>, <3.553156, 0.384149, 2.725824>, <1.544101, 0.384149, 1.960526>, <0.000000, 0.384149, 2.000000>, 
      <4.972663, 0.000000, 3.334763>, <3.553156, 0.000000, 2.725824>, <1.544101, 0.000000, 1.960526>, <0.000000, 0.000000, 2.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <5.232897, 0.860668, 2.907822>, <5.232897, 0.344267, 2.907822>, <5.232897, -0.344267, 2.907822>, <5.232897, -0.860668, 2.907822>, 
      <5.232897, 0.860668, 2.907822>, <5.032960, 0.344267, 3.235839>, <5.032960, -0.344267, 3.235839>, <5.032960, -0.860668, 3.235839>, 
      <5.232897, 0.860668, 2.907822>, <5.032960, 0.344267, 3.235839>, <4.972663, 0.000000, 3.334763>, <4.972663, -0.384149, 3.334763>, 
      <5.232897, 0.860668, 2.907822>, <5.032960, 0.860668, 3.235839>, <4.972663, 0.384149, 3.334763>, <4.972663, 0.000000, 3.334763>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <5.493131, 0.000000, 2.480881>, <3.920190, 0.000000, 1.818362>, <1.706198, 0.000000, 0.955689>, <0.000000, 0.000000, 1.000000>, 
      <5.493131, 0.384149, 2.480881>, <3.920190, 0.384149, 1.818362>, <1.706198, 0.384149, 0.955689>, <0.000000, 0.384149, 1.000000>, 
      <5.432834, 0.860668, 2.579804>, <3.862965, 0.860668, 2.157458>, <1.625149, 0.860668, 1.073959>, <0.000000, 0.860668, 1.115851>, 
      <5.232897, 0.860668, 2.907822>, <3.663028, 0.860668, 2.485475>, <1.625149, 0.860668, 1.458107>, <0.000000, 0.860668, 1.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <5.493131, 0.000000, 2.480881>, <5.493131, -0.384149, 2.480881>, <5.432834, -0.860668, 2.579804>, <5.232897, -0.860668, 2.907822>, 
      <3.920190, 0.000000, 1.818362>, <3.920190, -0.384149, 1.818362>, <3.862965, -0.860668, 2.157458>, <3.663028, -0.860668, 2.485475>, 
      <1.706198, 0.000000, 0.955689>, <1.706198, -0.384149, 0.955689>, <1.625149, -0.860668, 1.073959>, <1.625149, -0.860668, 1.458107>, 
      <0.000000, 0.000000, 1.000000>, <0.000000, -0.384149, 1.000000>, <0.000000, -0.860668, 1.115851>, <0.000000, -0.860668, 1.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <5.493131, 0.000000, 2.480881>, <5.493131, -0.384149, 2.480881>, <5.432834, -0.860668, 2.579804>, <5.232897, -0.860668, 2.907822>, 
      <5.493131, 0.000000, 2.480881>, <5.493131, 0.000000, 2.480881>, <5.432834, -0.344267, 2.579804>, <5.232897, -0.344267, 2.907822>, 
      <5.493131, 0.000000, 2.480881>, <5.493131, 0.000000, 2.480881>, <5.432834, 0.344267, 2.579804>, <5.232897, 0.344267, 2.907822>, 
      <5.493131, 0.000000, 2.480881>, <5.493131, 0.384149, 2.480881>, <5.432834, 0.860668, 2.579804>, <5.232897, 0.860668, 2.907822>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <9.394674, 0.000000, 6.030119>, <8.068070, 0.000000, 5.221512>, <6.400450, 0.000000, 3.947254>, <4.972663, 0.000000, 3.334763>, 
      <9.394674, -0.384149, 6.030119>, <8.068070, -0.384149, 5.221512>, <6.400450, -0.384149, 3.947254>, <4.972663, -0.384149, 3.334763>, 
      <9.454971, -0.860668, 5.931196>, <8.128367, -0.860668, 5.122589>, <6.359563, -0.860668, 4.044446>, <5.032960, -0.860668, 3.235839>, 
      <9.654908, -0.860668, 5.603179>, <8.328304, -0.860668, 4.794572>, <6.559500, -0.860668, 3.716429>, <5.232897, -0.860668, 2.907822>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <9.394674, 0.000000, 6.030119>, <9.394674, 0.384149, 6.030119>, <9.454971, 0.860668, 5.931196>, <9.654908, 0.860668, 5.603179>, 
      <8.068070, 0.000000, 5.221512>, <8.068070, 0.384149, 5.221512>, <8.128367, 0.860668, 5.122589>, <8.328304, 0.860668, 4.794572>, 
      <6.400450, 0.000000, 3.947254>, <6.400450, 0.384149, 3.947254>, <6.359563, 0.860668, 4.044446>, <6.559500, 0.860668, 3.716429>, 
      <4.972663, 0.000000, 3.334763>, <4.972663, 0.384149, 3.334763>, <5.032960, 0.860668, 3.235839>, <5.232897, 0.860668, 2.907822>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <9.394674, 0.000000, 6.030119>, <9.394674, -0.384149, 6.030119>, <9.454971, -0.860668, 5.931196>, <9.654908, -0.860668, 5.603179>, 
      <9.394674, 0.000000, 6.030119>, <9.394674, 0.000000, 6.030119>, <9.454971, -0.344267, 5.931196>, <9.654908, -0.344267, 5.603179>, 
      <9.394674, 0.000000, 6.030119>, <9.394674, 0.000000, 6.030119>, <9.454971, 0.344267, 5.931196>, <9.654908, 0.344267, 5.603179>, 
      <9.394674, 0.000000, 6.030119>, <9.394674, 0.384149, 6.030119>, <9.454971, 0.860668, 5.931196>, <9.654908, 0.860668, 5.603179>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <9.915142, 0.000000, 5.176238>, <8.588539, 0.000000, 4.367631>, <6.924924, 0.000000, 3.083949>, <5.493131, 0.000000, 2.480881>, 
      <9.915142, 0.384149, 5.176238>, <8.588539, 0.384149, 4.367631>, <6.924924, 0.384149, 3.083949>, <5.493131, 0.384149, 2.480881>, 
      <9.854846, 0.860668, 5.275162>, <8.528242, 0.860668, 4.466555>, <6.759438, 0.860668, 3.388412>, <5.432834, 0.860668, 2.579804>, 
      <9.654908, 0.860668, 5.603179>, <8.328304, 0.860668, 4.794572>, <6.559500, 0.860668, 3.716429>, <5.232897, 0.860668, 2.907822>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <9.915142, 0.000000, 5.176238>, <9.915142, 0.384149, 5.176238>, <9.854846, 0.860668, 5.275162>, <9.654908, 0.860668, 5.603179>, 
      <9.915142, 0.000000, 5.176238>, <9.915142, 0.000000, 5.176238>, <9.854846, 0.344267, 5.275162>, <9.654908, 0.344267, 5.603179>, 
      <9.915142, 0.000000, 5.176238>, <9.915142, 0.000000, 5.176238>, <9.854846, -0.344267, 5.275162>, <9.654908, -0.344267, 5.603179>, 
      <9.915142, 0.000000, 5.176238>, <9.915142, -0.384149, 5.176238>, <9.854846, -0.860668, 5.275162>, <9.654908, -0.860668, 5.603179>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <9.915142, 0.000000, 5.176238>, <9.915142, -0.384149, 5.176238>, <9.854846, -0.860668, 5.275162>, <9.654908, -0.860668, 5.603179>, 
      <8.588539, 0.000000, 4.367631>, <8.588539, -0.384149, 4.367631>, <8.528242, -0.860668, 4.466555>, <8.328304, -0.860668, 4.794572>, 
      <6.924924, 0.000000, 3.083949>, <6.924924, -0.384149, 3.083949>, <6.759438, -0.860668, 3.388412>, <6.559500, -0.860668, 3.716429>, 
      <5.493131, 0.000000, 2.480881>, <5.493131, -0.384149, 2.480881>, <5.432834, -0.860668, 2.579804>, <5.232897, -0.860668, 2.907822>
    }
  }
  texture {
    FireCape
  }
  scale <3.3, 1.0, 2.2>
  translate  <-10.946523, 99.933238, 85.735896>
}
#declare RopeDone3 = union {
  cylinder { // RopeCap7
    <0,0,1>, <0,0,0>, 1 
    texture {
      Spun_Gold
    }
    scale <1.3, 1.3, 2.5>
    rotate <180.0, -65.0, 180.0>
    translate  <21.297193, 100.0, 98.267448>
  }
  object { VelvetRope3 }
  cylinder { // RopeCap8
    <0,0,1>, <0,0,0>, 1 
    texture {
      Spun_Gold
    }
    scale <1.3, 1.3, 2.5>
    rotate <180.0, 65.0, 180.0>
    translate  <-43.665514, 100.0, 99.498947>
  }
  cylinder { // Line7
    <0,0,1>, <0,0,0>, 1 
    texture {
      Spun_Gold
    }
    scale <0.5, 0.5, 3.0>
    rotate <180.0, -65.0, 180.0>
    translate  <23.558676, 100.0, 99.359929>
  }
  cylinder { // Line8
    <0,0,1>, <0,0,0>, 1 
    texture {
      Spun_Gold
    }
    scale <0.5, 0.5, 3.0>
    rotate <180.0, 65.0, 180.0>
    translate  <-45.930041, 100.0, 100.577294>
  }
  scale <0.65, 0.6, 0.6>
  rotate <0.493658, -0.510808, -47.550186>
  translate  <-92.559152, 71.203767, 38.961847>
}
union { // ShipDisplay
  object { GuardPost2 }
  object { GuardPost1 }
  object { RopeDone }
  object { AlienShip }
  object { GuardPost }
  object { GuardPost3 }
  object { RopeDone1 }
  object { RopeDone2 }
  object { RopeDone3 }
  rotate 48.0*z
  translate  <97.273275, 117.982755, 0.0>
}


#declare WallCutter = union {
  box { // WallCut
    <-1, -1, -1>, <1, 1, 1>
    scale <12.5, 1.4, 9.0>
    translate  <101.0, 137.5, 100.0>
  }
  box { // WallCut1
    <-1, -1, -1>, <1, 1, 1>
    scale <1.577529, 1.4, 6.0>
    translate  <87.085738, 137.5, 99.979833>
  }
  cylinder { // WallCutLeft1
    <0,0,1>, <0,0,0>, 1 
    scale <3.0, 3.0, 2.8>
    rotate -90.0*x
    translate  <88.483793, 136.047258, 105.9949>
  }
  cylinder { // WallCutLeft
    <0,0,1>, <0,0,0>, 1 
    scale <3.0, 3.0, 2.8>
    rotate -90.0*x
    translate  <88.512668, 136.047258, 94.003818>
  }
  cylinder { // WallCutLeft2
    <0,0,1>, <0,0,0>, 1 
    scale <3.0, 3.0, 2.8>
    rotate -90.0*x
    translate  <113.511146, 136.047258, 105.9949>
  }
  cylinder { // WallCutLeft3
    <0,0,1>, <0,0,0>, 1 
    scale <3.0, 3.0, 2.8>
    rotate -90.0*x
    translate  <113.51267, 136.047258, 94.003818>
  }
  box { // WallCut2
    <-1, -1, -1>, <1, 1, 1>
    scale <1.577529, 1.4, 6.0>
    translate  <114.952866, 137.5, 99.979833>
  }
  texture {
    Pale_Gray
  }
  scale <1.0, 2.0, 1.0>
  translate  <-7.621719, -137.770801, 12.429365>
}
difference { // WallwHole
  box { // Wall
    <-1, -1, -1>, <1, 1, 1>
    texture {
      White_Plaster
    }
    scale <50.0, 3.0, 30.0>
    translate  <100.0, 137.584675, 108.990996>
  }
  object { WallCutter }
  translate  20.7*y
}


box { // Wall1
  <-1, -1, -1>, <1, 1, 1>
  texture {
    White_Plaster
  }
  scale <50.0, 3.0, 30.0>
  rotate -90.0*z
  translate  <47.916825, 198.006106, 108.990996>
}


union { // AlienCommpad
  torus { // Lower
    1.5, 0.5  rotate -x*90
    texture {
      White_Plaster
    }
  }
  torus { // Upper
    1.5, 1.1  rotate -x*90
    texture {
      Aluminum
    }
    scale <1.0, 0.719024, 0.408068>
    rotate <0.0, 0.0, 45.718609>
    translate  <0.0, 1.082803, 0.923992>
  }
  torus { // Lower2
    1.5, 0.5  rotate -x*90
    texture {
      MottledBlueRed
    }
    translate  <1.636235, 2.131918, 0.0>
  }
  torus { // Lower3
    1.5, 0.5  rotate -x*90
    texture {
      Filigree
    }
    scale 0.307006
    translate  <1.636235, 1.674837, 1.495466>
  }
  torus { // Lower4
    1.9, 0.1  rotate -x*90
    texture {
      Plastic_Black
    }
    scale 0.307006
    rotate -90.0*y
    translate  <0.396832, 2.154368, 1.495466>
  }
  torus { // Lower5
    1.9, 0.1  rotate -x*90
    texture {
      Plastic_Black
    }
    scale 0.307006
    rotate -90.0*y
    translate  <-1.314723, 0.619869, 1.495466>
  }
  torus { // Lower6
    1.9, 0.1  rotate -x*90
    texture {
      Shiny_Blue
    }
    scale 0.307006
    rotate <-24.111374, -74.849205, 0.0>
    translate  <0.308304, 0.088697, 1.495466>
  }
  scale 1.1
  rotate 125.698189*z
  translate  <95.805607, 158.066763, 104.119862>
}


#declare CrazyString = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.250000, -0.500000, -3.250000>, <1.189771, -0.511695, -3.386878>, <1.362886, -0.500000, -3.651224>, <1.250000, -0.500000, -3.750000>, 
      <0.977101, -0.500000, -3.250000>, <0.916871, -0.511695, -3.386878>, <1.089987, -0.500000, -3.651224>, <0.977101, -0.500000, -3.750000>, 
      <0.750000, -0.272899, -3.250000>, <0.687639, -0.283865, -3.385981>, <0.862887, -0.272899, -3.651224>, <0.750000, -0.272899, -3.750000>, 
      <0.750000, 0.000000, -3.250000>, <0.687639, -0.010966, -3.385981>, <0.862887, 0.000000, -3.651224>, <0.750000, 0.000000, -3.750000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.250000, 0.500000, -3.250000>, <0.977101, 0.500000, -3.250000>, <0.750000, 0.272899, -3.250000>, <0.750000, 0.000000, -3.250000>, 
      <1.189771, 0.488305, -3.386878>, <0.916871, 0.488305, -3.386878>, <0.687639, 0.261934, -3.385981>, <0.687639, -0.010966, -3.385981>, 
      <1.250000, 0.500000, -3.600000>, <0.977101, 0.500000, -3.600000>, <0.862887, 0.272899, -3.651224>, <0.862887, 0.000000, -3.651224>, 
      <1.250000, 0.500000, -3.750000>, <0.977101, 0.500000, -3.750000>, <0.750000, 0.272899, -3.750000>, <0.750000, 0.000000, -3.750000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <4.695837, 0.693842, 4.854101>, <3.063190, 1.984280, 3.114932>, <1.877526, 0.198266, -0.791372>, <0.750000, 0.000000, -3.250000>, 
      <4.695837, 0.966741, 4.854101>, <3.063190, 2.257179, 3.114932>, <1.877526, 0.471165, -0.791372>, <0.750000, 0.272899, -3.250000>, 
      <4.753703, 1.193842, 4.634497>, <3.210220, 2.480077, 3.091014>, <1.994410, 0.697538, -0.938045>, <0.977101, 0.500000, -3.250000>, 
      <4.823238, 1.193842, 4.370605>, <3.279756, 2.480077, 2.827123>, <2.267309, 0.697538, -0.938045>, <1.250000, 0.500000, -3.250000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <4.695837, 0.693842, 4.854101>, <3.063190, 1.984280, 3.114932>, <1.877526, 0.198266, -0.791372>, <0.750000, 0.000000, -3.250000>, 
      <4.695837, 0.420943, 4.854101>, <3.063190, 1.711380, 3.114932>, <1.877526, -0.074634, -0.791372>, <0.750000, -0.272899, -3.250000>, 
      <4.753703, 0.193842, 4.634497>, <3.210220, 1.480077, 3.091014>, <1.994410, -0.302462, -0.938045>, <0.977101, -0.500000, -3.250000>, 
      <4.823238, 0.193842, 4.370605>, <3.279756, 1.480077, 2.827123>, <2.267309, -0.302462, -0.938045>, <1.250000, -0.500000, -3.250000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.750000, 0.000000, -3.250000>, <2.657378, 0.196704, -1.084887>, <3.499742, 1.972378, 2.541751>, <4.950639, 0.693842, 3.887108>, 
      <1.750000, -0.272899, -3.250000>, <2.657378, -0.076196, -1.084887>, <3.499742, 1.699478, 2.541751>, <4.950639, 0.420943, 3.887108>, 
      <1.522899, -0.500000, -3.250000>, <2.540209, -0.302462, -0.938045>, <3.349291, 1.480077, 2.563231>, <4.892773, 0.193842, 4.106713>, 
      <1.250000, -0.500000, -3.250000>, <2.267309, -0.302462, -0.938045>, <3.279756, 1.480077, 2.827123>, <4.823238, 0.193842, 4.370605>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.750000, 0.000000, -3.250000>, <1.692225, -0.012525, -3.387859>, <1.862887, 0.000000, -3.651224>, <1.750000, 0.000000, -3.750000>, 
      <1.750000, -0.272899, -3.250000>, <1.692225, -0.285424, -3.387859>, <1.862887, -0.272899, -3.651224>, <1.750000, -0.272899, -3.750000>, 
      <1.522899, -0.500000, -3.250000>, <1.462670, -0.511695, -3.386878>, <1.635786, -0.500000, -3.651224>, <1.522899, -0.500000, -3.750000>, 
      <1.250000, -0.500000, -3.250000>, <1.189771, -0.511695, -3.386878>, <1.362886, -0.500000, -3.651224>, <1.250000, -0.500000, -3.750000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.750000, 0.000000, -3.250000>, <2.657378, 0.196704, -1.084887>, <3.499742, 1.972378, 2.541751>, <4.950639, 0.693842, 3.887108>, 
      <1.750000, 0.272899, -3.250000>, <2.657378, 0.469603, -1.084887>, <3.499742, 2.245277, 2.541751>, <4.950639, 0.966741, 3.887108>, 
      <1.522899, 0.500000, -3.250000>, <2.540209, 0.697538, -0.938045>, <3.349291, 2.480077, 2.563231>, <4.892773, 1.193842, 4.106713>, 
      <1.250000, 0.500000, -3.250000>, <2.267309, 0.697538, -0.938045>, <3.279756, 2.480077, 2.827123>, <4.823238, 1.193842, 4.370605>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.750000, 0.000000, -3.250000>, <1.750000, 0.272899, -3.250000>, <1.522899, 0.500000, -3.250000>, <1.250000, 0.500000, -3.250000>, 
      <1.692225, -0.012525, -3.387859>, <1.692225, 0.260375, -3.387859>, <1.462670, 0.488305, -3.386878>, <1.189771, 0.488305, -3.386878>, 
      <1.862887, 0.000000, -3.651224>, <1.862887, 0.272899, -3.651224>, <1.522899, 0.500000, -3.600000>, <1.250000, 0.500000, -3.600000>, 
      <1.750000, 0.000000, -3.750000>, <1.750000, 0.272899, -3.750000>, <1.522899, 0.500000, -3.750000>, <1.250000, 0.500000, -3.750000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <4.587029, -2.500000, -0.619340>, <4.587029, -2.772900, -0.619340>, <4.433950, -3.000000, -0.451585>, <4.250000, -3.000000, -0.250000>, 
      <5.786138, -1.379807, -0.364417>, <5.786138, -1.652706, -0.364417>, <5.674939, -1.894189, -0.125613>, <5.490989, -1.894189, 0.075972>, 
      <5.973395, -0.207415, 4.835468>, <5.973395, -0.480314, 4.835468>, <5.924680, -0.666080, 5.138620>, <5.855144, -0.666080, 5.402512>, 
      <4.950639, 0.693842, 3.887108>, <4.950639, 0.420943, 3.887108>, <4.892773, 0.193842, 4.106713>, <4.823238, 0.193842, 4.370605>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <4.250000, -2.000000, -0.250000>, <4.433950, -2.000000, -0.451585>, <4.587029, -2.227100, -0.619340>, <4.587029, -2.500000, -0.619340>, 
      <5.490989, -0.894189, 0.075972>, <5.674939, -0.894189, -0.125613>, <5.786138, -1.106907, -0.364417>, <5.786138, -1.379807, -0.364417>, 
      <5.855144, 0.333920, 5.402512>, <5.924680, 0.333920, 5.138620>, <5.973395, 0.065485, 4.835468>, <5.973395, -0.207415, 4.835468>, 
      <4.823238, 1.193842, 4.370605>, <4.892773, 1.193842, 4.106713>, <4.950639, 0.966741, 3.887108>, <4.950639, 0.693842, 3.887108>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.912971, -2.500000, 0.119340>, <3.912971, -2.227100, 0.119340>, <4.066050, -2.000000, -0.048415>, <4.250000, -2.000000, -0.250000>, 
      <5.194690, -1.408281, 0.514532>, <5.194690, -1.135381, 0.514532>, <5.307039, -0.894189, 0.277557>, <5.490989, -0.894189, 0.075972>, 
      <5.736914, -0.129021, 5.963104>, <5.736914, 0.143878, 5.963104>, <5.785609, 0.333920, 5.666403>, <5.855144, 0.333920, 5.402512>, 
      <4.695837, 0.693842, 4.854101>, <4.695837, 0.966741, 4.854101>, <4.753703, 1.193842, 4.634497>, <4.823238, 1.193842, 4.370605>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.912971, -2.500000, 0.119340>, <5.194690, -1.408281, 0.514532>, <5.736914, -0.129021, 5.963104>, <4.695837, 0.693842, 4.854101>, 
      <3.912971, -2.772900, 0.119340>, <5.194690, -1.681180, 0.514532>, <5.736914, -0.401921, 5.963104>, <4.695837, 0.420943, 4.854101>, 
      <4.066050, -3.000000, -0.048415>, <5.307039, -1.894189, 0.277557>, <5.785609, -0.666080, 5.666403>, <4.753703, 0.193842, 4.634497>, 
      <4.250000, -3.000000, -0.250000>, <5.490989, -1.894189, 0.075972>, <5.855144, -0.666080, 5.402512>, <4.823238, 0.193842, 4.370605>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.750000, -6.500000, 2.250000>, <-2.750000, -6.772899, 2.250000>, <-2.977101, -7.000000, 2.250000>, <-3.250000, -7.000000, 2.250000>, 
      <-0.427694, -7.072654, 1.107713>, <-0.427694, -7.345554, 1.107713>, <-0.610821, -7.610822, 1.204716>, <-0.883720, -7.610822, 1.204716>, 
      <2.673053, -4.288013, -1.026239>, <2.673053, -4.560913, -1.026239>, <2.486578, -4.735250, -0.963103>, <2.302628, -4.735250, -0.761518>, 
      <4.587029, -2.500000, -0.619340>, <4.587029, -2.772900, -0.619340>, <4.433950, -3.000000, -0.451585>, <4.250000, -3.000000, -0.250000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.250000, -6.000000, 2.250000>, <-2.977101, -6.000000, 2.250000>, <-2.750000, -6.227101, 2.250000>, <-2.750000, -6.500000, 2.250000>, 
      <-0.895266, -6.610158, 1.178582>, <-0.622367, -6.610158, 1.178582>, <-0.427694, -6.799755, 1.107713>, <-0.427694, -7.072654, 1.107713>, 
      <2.302628, -3.735250, -0.761518>, <2.486578, -3.735250, -0.963103>, <2.673053, -4.015113, -1.026239>, <2.673053, -4.288013, -1.026239>, 
      <4.250000, -2.000000, -0.250000>, <4.433950, -2.000000, -0.451585>, <4.587029, -2.227100, -0.619340>, <4.587029, -2.500000, -0.619340>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.750000, -6.500000, 2.250000>, <-3.750000, -6.227101, 2.250000>, <-3.522899, -6.000000, 2.250000>, <-3.250000, -6.000000, 2.250000>, 
      <-1.348850, -7.149626, 1.277405>, <-1.348850, -6.876727, 1.277405>, <-1.168166, -6.610158, 1.178582>, <-0.895266, -6.610158, 1.178582>, 
      <1.933508, -4.186031, -0.490987>, <1.933508, -3.913132, -0.490987>, <2.118678, -3.735250, -0.559933>, <2.302628, -3.735250, -0.761518>, 
      <3.912971, -2.500000, 0.119340>, <3.912971, -2.227100, 0.119340>, <4.066050, -2.000000, -0.048415>, <4.250000, -2.000000, -0.250000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.750000, -6.500000, 2.250000>, <-1.348850, -7.149626, 1.277405>, <1.933508, -4.186031, -0.490987>, <3.912971, -2.500000, 0.119340>, 
      <-3.750000, -6.772899, 2.250000>, <-1.348850, -7.422526, 1.277405>, <1.933508, -4.458931, -0.490987>, <3.912971, -2.772900, 0.119340>, 
      <-3.522899, -7.000000, 2.250000>, <-1.156620, -7.610822, 1.204716>, <2.118678, -4.735250, -0.559933>, <4.066050, -3.000000, -0.048415>, 
      <-3.250000, -7.000000, 2.250000>, <-0.883720, -7.610822, 1.204716>, <2.302628, -4.735250, -0.761518>, <4.250000, -3.000000, -0.250000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-9.849805, 1.059961, 6.481795>, <-9.966867, 0.813444, 6.481795>, <-10.246054, 0.694615, 6.376514>, <-10.464479, 0.798338, 6.250000>, 
      <-8.212959, -1.855022, 6.822026>, <-8.330022, -2.101539, 6.822026>, <-8.587214, -2.259537, 6.721316>, <-8.805639, -2.155814, 6.594803>, 
      <-5.694138, -5.774009, 3.698151>, <-5.694138, -6.046908, 3.698151>, <-6.008862, -6.217393, 3.589255>, <-6.281761, -6.217393, 3.589255>, 
      <-2.750000, -6.500000, 2.250000>, <-2.750000, -6.772899, 2.250000>, <-2.977101, -7.000000, 2.250000>, <-3.250000, -7.000000, 2.250000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-10.035521, 1.701662, 6.250000>, <-9.817095, 1.597939, 6.376514>, <-9.732742, 1.306477, 6.481795>, <-9.849805, 1.059961, 6.481795>, 
      <-8.425703, -1.165187, 6.584613>, <-8.207278, -1.268910, 6.711126>, <-8.095897, -1.608506, 6.822026>, <-8.212959, -1.855022, 6.822026>, 
      <-6.177809, -5.241346, 3.582171>, <-5.904909, -5.241346, 3.582171>, <-5.694138, -5.501110, 3.698151>, <-5.694138, -5.774009, 3.698151>, 
      <-3.250000, -6.000000, 2.250000>, <-2.977101, -6.000000, 2.250000>, <-2.750000, -6.227101, 2.250000>, <-2.750000, -6.500000, 2.250000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-10.650195, 1.440039, 6.018205>, <-10.533133, 1.686556, 6.018205>, <-10.253946, 1.805385, 6.123486>, <-10.035521, 1.701662, 6.250000>, 
      <-9.017346, -1.467826, 6.357606>, <-8.900284, -1.221309, 6.357606>, <-8.644129, -1.061464, 6.458099>, <-8.425703, -1.165187, 6.584613>, 
      <-6.763666, -5.684658, 3.470697>, <-6.763666, -5.411759, 3.470697>, <-6.450708, -5.241346, 3.582171>, <-6.177809, -5.241346, 3.582171>, 
      <-3.750000, -6.500000, 2.250000>, <-3.750000, -6.227101, 2.250000>, <-3.522899, -6.000000, 2.250000>, <-3.250000, -6.000000, 2.250000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-10.650195, 1.440039, 6.018205>, <-9.017346, -1.467826, 6.357606>, <-6.763666, -5.684658, 3.470697>, <-3.750000, -6.500000, 2.250000>, 
      <-10.767258, 1.193523, 6.018205>, <-9.134409, -1.714342, 6.357606>, <-6.763666, -5.957557, 3.470697>, <-3.750000, -6.772899, 2.250000>, 
      <-10.682905, 0.902061, 6.123486>, <-9.024065, -2.052091, 6.468289>, <-6.554661, -6.217393, 3.589255>, <-3.522899, -7.000000, 2.250000>, 
      <-10.464479, 0.798338, 6.250000>, <-8.805639, -2.155814, 6.594803>, <-6.281761, -6.217393, 3.589255>, <-3.250000, -7.000000, 2.250000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-7.099700, 1.246181, 1.345881>, <-7.099700, 0.973282, 1.345881>, <-7.326801, 0.746181, 1.345881>, <-7.599700, 0.746181, 1.345881>, 
      <-8.591900, 1.495271, 2.222851>, <-8.591900, 1.222372, 2.222851>, <-8.802378, 1.042539, 2.144788>, <-9.075276, 1.042539, 2.144788>, 
      <-10.701576, 2.576841, 6.304748>, <-10.818639, 2.330324, 6.304748>, <-11.076044, 2.172708, 6.203993>, <-11.294470, 2.276431, 6.077480>, 
      <-9.849805, 1.059961, 6.481795>, <-9.966867, 0.813444, 6.481795>, <-10.246054, 0.694615, 6.376514>, <-10.464479, 0.798338, 6.250000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-7.599700, 1.746181, 1.345881>, <-7.326801, 1.746181, 1.345881>, <-7.099700, 1.519080, 1.345881>, <-7.099700, 1.246181, 1.345881>, 
      <-9.000190, 2.025016, 2.158026>, <-8.727291, 2.025016, 2.158026>, <-8.591900, 1.768171, 2.222851>, <-8.591900, 1.495271, 2.222851>, 
      <-10.835718, 3.126696, 6.083673>, <-10.617293, 3.022973, 6.210186>, <-10.584514, 2.823357, 6.304748>, <-10.701576, 2.576841, 6.304748>, 
      <-10.035521, 1.701662, 6.250000>, <-9.817095, 1.597939, 6.376514>, <-9.732742, 1.306477, 6.481795>, <-9.849805, 1.059961, 6.481795>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-8.099701, 1.246181, 1.345881>, <-8.099701, 1.519081, 1.345881>, <-7.872600, 1.746181, 1.345881>, <-7.599700, 1.746181, 1.345881>, 
      <-9.481599, 1.569746, 2.080220>, <-9.481599, 1.842646, 2.080220>, <-9.273090, 2.025016, 2.158026>, <-9.000190, 2.025016, 2.158026>, 
      <-11.428582, 2.826231, 5.856412>, <-11.311518, 3.072748, 5.856412>, <-11.054144, 3.230419, 5.957160>, <-10.835718, 3.126696, 6.083673>, 
      <-10.650195, 1.440039, 6.018205>, <-10.533133, 1.686556, 6.018205>, <-10.253946, 1.805385, 6.123486>, <-10.035521, 1.701662, 6.250000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-8.099701, 1.246181, 1.345881>, <-9.481599, 1.569746, 2.080220>, <-11.428582, 2.826231, 5.856412>, <-10.650195, 1.440039, 6.018205>, 
      <-8.099701, 0.973281, 1.345881>, <-9.481599, 1.296846, 2.080220>, <-11.545644, 2.579715, 5.856412>, <-10.767258, 1.193523, 6.018205>, 
      <-7.872600, 0.746181, 1.345881>, <-9.348176, 1.042539, 2.144788>, <-11.512895, 2.380154, 5.950966>, <-10.682905, 0.902061, 6.123486>, 
      <-7.599700, 0.746181, 1.345881>, <-9.075276, 1.042539, 2.144788>, <-11.294470, 2.276431, 6.077480>, <-10.464479, 0.798338, 6.250000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.500000, 0.000000, 2.750000>, <-3.500000, -0.272899, 2.750000>, <-3.727101, -0.500000, 2.750000>, <-4.000000, -0.500000, 2.750000>, 
      <-4.051324, -0.745839, 1.960583>, <-4.051324, -1.018738, 1.960583>, <-4.280339, -1.219097, 1.937449>, <-4.553239, -1.219097, 1.937449>, 
      <-6.060367, 1.072687, 0.735063>, <-6.060367, 0.799788, 0.735063>, <-6.272077, 0.534348, 0.774832>, <-6.544976, 0.534348, 0.774832>, 
      <-7.099700, 1.246181, 1.345881>, <-7.099700, 0.973282, 1.345881>, <-7.326801, 0.746181, 1.345881>, <-7.599700, 0.746181, 1.345881>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-4.000000, 0.500000, 2.750000>, <-3.727101, 0.500000, 2.750000>, <-3.500000, 0.272899, 2.750000>, <-3.500000, 0.000000, 2.750000>, 
      <-4.553239, -0.219097, 1.937449>, <-4.280339, -0.219097, 1.937449>, <-4.051324, -0.472940, 1.960583>, <-4.051324, -0.745839, 1.960583>, 
      <-6.561374, 1.539452, 0.743756>, <-6.288475, 1.539452, 0.743756>, <-6.060367, 1.345587, 0.735063>, <-6.060367, 1.072687, 0.735063>, 
      <-7.599700, 1.746181, 1.345881>, <-7.326801, 1.746181, 1.345881>, <-7.099700, 1.519080, 1.345881>, <-7.099700, 1.246181, 1.345881>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-4.500000, 0.000000, 2.750000>, <-4.500000, 0.272899, 2.750000>, <-4.272899, 0.500000, 2.750000>, <-4.000000, 0.500000, 2.750000>, 
      <-5.054601, -0.693679, 1.916549>, <-5.054601, -0.420780, 1.916549>, <-4.826138, -0.219097, 1.937449>, <-4.553239, -0.219097, 1.937449>, 
      <-7.046451, 0.999568, 0.786185>, <-7.046451, 1.272467, 0.786185>, <-6.834274, 1.539452, 0.743756>, <-6.561374, 1.539452, 0.743756>, 
      <-8.099701, 1.246181, 1.345881>, <-8.099701, 1.519081, 1.345881>, <-7.872600, 1.746181, 1.345881>, <-7.599700, 1.746181, 1.345881>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-4.500000, 0.000000, 2.750000>, <-5.054601, -0.693679, 1.916549>, <-7.046451, 0.999568, 0.786185>, <-8.099701, 1.246181, 1.345881>, 
      <-4.500000, -0.272899, 2.750000>, <-5.054601, -0.966579, 1.916549>, <-7.046451, 0.726668, 0.786185>, <-8.099701, 0.973281, 1.345881>, 
      <-4.272899, -0.500000, 2.750000>, <-4.826138, -1.219097, 1.937449>, <-6.817876, 0.534348, 0.774832>, <-7.872600, 0.746181, 1.345881>, 
      <-4.000000, -0.500000, 2.750000>, <-4.553239, -1.219097, 1.937449>, <-6.544976, 0.534348, 0.774832>, <-7.599700, 0.746181, 1.345881>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.400882, 6.250000, 6.642066>, <-3.400882, 5.977100, 6.642066>, <-3.559452, 5.750000, 6.804640>, <-3.750000, 5.750000, 7.000000>, 
      <-5.035437, 6.250000, 5.156107>, <-5.035437, 5.977100, 5.156107>, <-5.238134, 5.750000, 5.278566>, <-5.428682, 5.750000, 5.473926>, 
      <-2.500050, 1.352748, 4.181788>, <-2.500050, 1.079849, 4.181788>, <-2.696588, 0.839455, 4.263532>, <-2.969487, 0.839455, 4.263532>, 
      <-3.500000, 0.000000, 2.750000>, <-3.500000, -0.272899, 2.750000>, <-3.727101, -0.500000, 2.750000>, <-4.000000, -0.500000, 2.750000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.750000, 6.750000, 7.000000>, <-3.559452, 6.750000, 6.804640>, <-3.400882, 6.522900, 6.642066>, <-3.400882, 6.250000, 6.642066>, 
      <-5.428682, 6.750000, 5.473926>, <-5.238134, 6.750000, 5.278566>, <-5.035437, 6.522900, 5.156107>, <-5.035437, 6.250000, 5.156107>, 
      <-2.969487, 1.839455, 4.263532>, <-2.696588, 1.839455, 4.263532>, <-2.500050, 1.625648, 4.181788>, <-2.500050, 1.352748, 4.181788>, 
      <-4.000000, 0.500000, 2.750000>, <-3.727101, 0.500000, 2.750000>, <-3.500000, 0.272899, 2.750000>, <-3.500000, 0.000000, 2.750000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-4.099118, 6.250000, 7.357934>, <-4.099118, 6.522900, 7.357934>, <-3.940548, 6.750000, 7.195360>, <-3.750000, 6.750000, 7.000000>, 
      <-5.825109, 6.250000, 5.788851>, <-5.825109, 6.522900, 5.788851>, <-5.619230, 6.750000, 5.669285>, <-5.428682, 6.750000, 5.473926>, 
      <-3.437837, 1.328525, 4.346213>, <-3.437837, 1.601424, 4.346213>, <-3.242386, 1.839455, 4.263532>, <-2.969487, 1.839455, 4.263532>, 
      <-4.500000, 0.000000, 2.750000>, <-4.500000, 0.272899, 2.750000>, <-4.272899, 0.500000, 2.750000>, <-4.000000, 0.500000, 2.750000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-4.099118, 6.250000, 7.357934>, <-5.825109, 6.250000, 5.788851>, <-3.437837, 1.328525, 4.346213>, <-4.500000, 0.000000, 2.750000>, 
      <-4.099118, 5.977100, 7.357934>, <-5.825109, 5.977100, 5.788851>, <-3.437837, 1.055625, 4.346213>, <-4.500000, -0.272899, 2.750000>, 
      <-3.940548, 5.750000, 7.195360>, <-5.619230, 5.750000, 5.669285>, <-3.242386, 0.839455, 4.263532>, <-4.272899, -0.500000, 2.750000>, 
      <-3.750000, 5.750000, 7.000000>, <-5.428682, 5.750000, 5.473926>, <-2.969487, 0.839455, 4.263532>, <-4.000000, -0.500000, 2.750000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.750000, 0.000000, 5.250000>, <-0.750000, -0.272899, 5.250000>, <-0.977101, -0.500000, 5.250000>, <-1.250000, -0.500000, 5.250000>, 
      <-1.425431, 1.624394, 6.357977>, <-1.425431, 1.351495, 6.357977>, <-1.670360, 1.131199, 6.351059>, <-1.943260, 1.131199, 6.351059>, 
      <-1.862505, 6.250000, 8.040591>, <-1.862505, 5.977100, 8.040591>, <-2.015519, 5.750000, 8.208216>, <-2.206068, 5.750000, 8.403575>, 
      <-3.400882, 6.250000, 6.642066>, <-3.400882, 5.977100, 6.642066>, <-3.559452, 5.750000, 6.804640>, <-3.750000, 5.750000, 7.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.250000, 0.500000, 5.250000>, <-0.977101, 0.500000, 5.250000>, <-0.750000, 0.272899, 5.250000>, <-0.750000, 0.000000, 5.250000>, 
      <-1.943260, 2.131199, 6.351059>, <-1.670360, 2.131199, 6.351059>, <-1.425431, 1.897294, 6.357977>, <-1.425431, 1.624394, 6.357977>, 
      <-2.206068, 6.750000, 8.403575>, <-2.015519, 6.750000, 8.208216>, <-1.862505, 6.522900, 8.040591>, <-1.862505, 6.250000, 8.040591>, 
      <-3.750000, 6.750000, 7.000000>, <-3.559452, 6.750000, 6.804640>, <-3.400882, 6.522900, 6.642066>, <-3.400882, 6.250000, 6.642066>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.750000, 0.000000, 5.250000>, <-1.750000, 0.272899, 5.250000>, <-1.522899, 0.500000, 5.250000>, <-1.250000, 0.500000, 5.250000>, 
      <-2.463348, 1.642920, 6.347329>, <-2.463348, 1.915819, 6.347329>, <-2.216159, 2.131199, 6.351059>, <-1.943260, 2.131199, 6.351059>, 
      <-2.544860, 6.250000, 8.770896>, <-2.544860, 6.522900, 8.770896>, <-2.396616, 6.750000, 8.598934>, <-2.206068, 6.750000, 8.403575>, 
      <-4.099118, 6.250000, 7.357934>, <-4.099118, 6.522900, 7.357934>, <-3.940548, 6.750000, 7.195360>, <-3.750000, 6.750000, 7.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.750000, 0.000000, 5.250000>, <-2.463348, 1.642920, 6.347329>, <-2.544860, 6.250000, 8.770896>, <-4.099118, 6.250000, 7.357934>, 
      <-1.750000, -0.272899, 5.250000>, <-2.463348, 1.370021, 6.347329>, <-2.544860, 5.977100, 8.770896>, <-4.099118, 5.977100, 7.357934>, 
      <-1.522899, -0.500000, 5.250000>, <-2.216159, 1.131199, 6.351059>, <-2.396616, 5.750000, 8.598934>, <-3.940548, 5.750000, 7.195360>, 
      <-1.250000, -0.500000, 5.250000>, <-1.943260, 1.131199, 6.351059>, <-2.206068, 5.750000, 8.403575>, <-3.750000, 5.750000, 7.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.757163, -3.750000, -0.178798>, <0.757163, -4.022900, -0.178798>, <0.640359, -4.250000, 0.015963>, <0.500000, -4.250000, 0.250000>, 
      <2.454729, -4.850529, -0.006646>, <2.454729, -5.123429, -0.006646>, <2.268290, -5.305385, 0.181053>, <2.127930, -5.305385, 0.415090>, 
      <-0.090376, -1.586379, 4.167952>, <-0.090376, -1.859279, 4.167952>, <-0.330174, -2.022181, 4.222528>, <-0.603073, -2.022181, 4.222528>, 
      <-0.750000, 0.000000, 5.250000>, <-0.750000, -0.272899, 5.250000>, <-0.977101, -0.500000, 5.250000>, <-1.250000, -0.500000, 5.250000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.500000, -3.250000, 0.250000>, <0.640359, -3.250000, 0.015963>, <0.757163, -3.477100, -0.178798>, <0.757163, -3.750000, -0.178798>, 
      <2.127930, -4.305385, 0.415090>, <2.268290, -4.305385, 0.181053>, <2.454729, -4.577630, -0.006646>, <2.454729, -4.850529, -0.006646>, 
      <-0.603073, -1.022181, 4.222528>, <-0.330174, -1.022181, 4.222528>, <-0.090376, -1.313480, 4.167952>, <-0.090376, -1.586379, 4.167952>, 
      <-1.250000, 0.500000, 5.250000>, <-0.977101, 0.500000, 5.250000>, <-0.750000, 0.272899, 5.250000>, <-0.750000, 0.000000, 5.250000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.242837, -3.750000, 0.678798>, <0.242837, -3.477100, 0.678798>, <0.359641, -3.250000, 0.484037>, <0.500000, -3.250000, 0.250000>, 
      <1.807810, -4.764570, 0.837504>, <1.807810, -4.491670, 0.837504>, <1.987571, -4.305385, 0.649128>, <2.127930, -4.305385, 0.415090>, 
      <-1.114322, -1.464037, 4.272150>, <-1.114322, -1.191137, 4.272150>, <-0.875972, -1.022181, 4.222528>, <-0.603073, -1.022181, 4.222528>, 
      <-1.750000, 0.000000, 5.250000>, <-1.750000, 0.272899, 5.250000>, <-1.522899, 0.500000, 5.250000>, <-1.250000, 0.500000, 5.250000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.242837, -3.750000, 0.678798>, <1.807810, -4.764570, 0.837504>, <-1.114322, -1.464037, 4.272150>, <-1.750000, 0.000000, 5.250000>, 
      <0.242837, -4.022900, 0.678798>, <1.807810, -5.037469, 0.837504>, <-1.114322, -1.736936, 4.272150>, <-1.750000, -0.272899, 5.250000>, 
      <0.359641, -4.250000, 0.484037>, <1.987571, -5.305385, 0.649128>, <-0.875972, -2.022181, 4.222528>, <-1.522899, -0.500000, 5.250000>, 
      <0.500000, -4.250000, 0.250000>, <2.127930, -5.305385, 0.415090>, <-0.603073, -2.022181, 4.222528>, <-1.250000, -0.500000, 5.250000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-5.750830, 3.242031, 4.742860>, <-5.750830, 2.969132, 4.742860>, <-5.977931, 2.742031, 4.742860>, <-6.250830, 2.742031, 4.742860>, 
      <-3.254125, 2.985788, 2.719825>, <-3.254125, 2.712888, 2.719825>, <-3.528798, 2.484228, 2.680433>, <-3.801698, 2.484228, 2.680433>, 
      <-1.938040, -2.002704, -0.452122>, <-1.938040, -2.275604, -0.452122>, <-2.045289, -2.508898, -0.256392>, <-2.185648, -2.508898, -0.022355>, 
      <0.757163, -3.750000, -0.178798>, <0.757163, -4.022900, -0.178798>, <0.640359, -4.250000, 0.015963>, <0.500000, -4.250000, 0.250000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-6.250830, 3.742031, 4.742860>, <-5.977931, 3.742031, 4.742860>, <-5.750830, 3.514930, 4.742860>, <-5.750830, 3.242031, 4.742860>, 
      <-3.801698, 3.484228, 2.680433>, <-3.528798, 3.484228, 2.680433>, <-3.254125, 3.258687, 2.719825>, <-3.254125, 2.985788, 2.719825>, 
      <-2.185648, -1.508898, -0.022355>, <-2.045289, -1.508898, -0.256392>, <-1.938040, -1.729805, -0.452122>, <-1.938040, -2.002704, -0.452122>, 
      <0.500000, -3.250000, 0.250000>, <0.640359, -3.250000, 0.015963>, <0.757163, -3.477100, -0.178798>, <0.757163, -3.750000, -0.178798>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-6.750830, 3.242031, 4.742860>, <-6.750830, 3.514930, 4.742860>, <-6.523729, 3.742031, 4.742860>, <-6.250830, 3.742031, 4.742860>, 
      <-4.345543, 2.982183, 2.636784>, <-4.345543, 3.255082, 2.636784>, <-4.074597, 3.484228, 2.680433>, <-3.801698, 3.484228, 2.680433>, 
      <-2.438926, -2.011417, 0.406837>, <-2.438926, -1.738518, 0.406837>, <-2.326007, -1.508898, 0.211683>, <-2.185648, -1.508898, -0.022355>, 
      <0.242837, -3.750000, 0.678798>, <0.242837, -3.477100, 0.678798>, <0.359641, -3.250000, 0.484037>, <0.500000, -3.250000, 0.250000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-6.750830, 3.242031, 4.742860>, <-4.345543, 2.982183, 2.636784>, <-2.438926, -2.011417, 0.406837>, <0.242837, -3.750000, 0.678798>, 
      <-6.750830, 2.969132, 4.742860>, <-4.345543, 2.709284, 2.636784>, <-2.438926, -2.284317, 0.406837>, <0.242837, -4.022900, 0.678798>, 
      <-6.523729, 2.742031, 4.742860>, <-4.074597, 2.484228, 2.680433>, <-2.326007, -2.508898, 0.211683>, <0.359641, -4.250000, 0.484037>, 
      <-6.250830, 2.742031, 4.742860>, <-3.801698, 2.484228, 2.680433>, <-2.185648, -2.508898, -0.022355>, <0.500000, -4.250000, 0.250000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-4.114580, -3.250000, 3.768688>, <-4.114580, -3.522899, 3.768688>, <-4.176088, -3.750000, 3.987300>, <-4.250000, -3.750000, 4.250000>, 
      <-5.793455, -2.379241, 4.505377>, <-5.793455, -2.652141, 4.505377>, <-5.866293, -2.873365, 4.728962>, <-5.940205, -2.873365, 4.991661>, 
      <-7.322805, 3.403367, 6.016602>, <-7.322805, 3.130468, 6.016602>, <-7.535882, 2.906026, 6.054819>, <-7.808782, 2.906026, 6.054819>, 
      <-5.750830, 3.242031, 4.742860>, <-5.750830, 2.969132, 4.742860>, <-5.977931, 2.742031, 4.742860>, <-6.250830, 2.742031, 4.742860>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-4.250000, -2.750000, 4.250000>, <-4.176088, -2.750000, 3.987300>, <-4.114580, -2.977101, 3.768688>, <-4.114580, -3.250000, 3.768688>, 
      <-5.940205, -1.873365, 4.991661>, <-5.866293, -1.873365, 4.728962>, <-5.793455, -2.106342, 4.505377>, <-5.793455, -2.379241, 4.505377>, 
      <-7.808782, 3.906026, 6.054819>, <-7.535882, 3.906026, 6.054819>, <-7.322805, 3.676266, 6.016602>, <-7.322805, 3.403367, 6.016602>, 
      <-6.250830, 3.742031, 4.742860>, <-5.977931, 3.742031, 4.742860>, <-5.750830, 3.514930, 4.742860>, <-5.750830, 3.242031, 4.742860>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-4.385420, -3.250000, 4.731312>, <-4.385420, -2.977101, 4.731312>, <-4.323912, -2.750000, 4.512700>, <-4.250000, -2.750000, 4.250000>, 
      <-6.100024, -2.360710, 5.483679>, <-6.100024, -2.087811, 5.483679>, <-6.014117, -1.873365, 5.254361>, <-5.940205, -1.873365, 4.991661>, 
      <-8.305226, 3.409956, 6.103893>, <-8.305226, 3.682855, 6.103893>, <-8.081680, 3.906026, 6.054819>, <-7.808782, 3.906026, 6.054819>, 
      <-6.750830, 3.242031, 4.742860>, <-6.750830, 3.514930, 4.742860>, <-6.523729, 3.742031, 4.742860>, <-6.250830, 3.742031, 4.742860>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-4.385420, -3.250000, 4.731312>, <-6.100024, -2.360710, 5.483679>, <-8.305226, 3.409956, 6.103893>, <-6.750830, 3.242031, 4.742860>, 
      <-4.385420, -3.522899, 4.731312>, <-6.100024, -2.633609, 5.483679>, <-8.305226, 3.137056, 6.103893>, <-6.750830, 2.969132, 4.742860>, 
      <-4.323912, -3.750000, 4.512700>, <-6.014117, -2.873365, 5.254361>, <-8.081680, 2.906026, 6.054819>, <-6.523729, 2.742031, 4.742860>, 
      <-4.250000, -3.750000, 4.250000>, <-5.940205, -2.873365, 4.991661>, <-7.808782, 2.906026, 6.054819>, <-6.250830, 2.742031, 4.742860>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.500000, 0.000000, 2.000000>, <0.500000, -0.272899, 2.000000>, <0.272899, -0.500000, 2.000000>, <0.000000, -0.500000, 2.000000>, 
      <-0.268920, -1.222785, 3.030640>, <-0.268920, -1.495685, 3.030640>, <-0.427029, -1.699876, 3.049892>, <-0.699928, -1.699876, 3.049892>, 
      <-2.646816, -4.011265, 3.124634>, <-2.646816, -4.284164, 3.124634>, <-2.735801, -4.497014, 3.355304>, <-2.809713, -4.497014, 3.618003>, 
      <-4.114580, -3.250000, 3.768688>, <-4.114580, -3.522899, 3.768688>, <-4.176088, -3.750000, 3.987300>, <-4.250000, -3.750000, 4.250000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 0.500000, 2.000000>, <0.272899, 0.500000, 2.000000>, <0.500000, 0.272899, 2.000000>, <0.500000, 0.000000, 2.000000>, 
      <-0.699928, -0.699877, 3.049892>, <-0.427029, -0.699877, 3.049892>, <-0.268920, -0.949886, 3.030640>, <-0.268920, -1.222785, 3.030640>, 
      <-2.809713, -3.497014, 3.618003>, <-2.735801, -3.497014, 3.355304>, <-2.646816, -3.738366, 3.124634>, <-2.646816, -4.011265, 3.124634>, 
      <-4.250000, -2.750000, 4.250000>, <-4.176088, -2.750000, 3.987300>, <-4.114580, -2.977101, 3.768688>, <-4.114580, -3.250000, 3.768688>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.500000, 0.000000, 2.000000>, <-0.500000, 0.272899, 2.000000>, <-0.272899, 0.500000, 2.000000>, <0.000000, 0.500000, 2.000000>, 
      <-1.138923, -1.187944, 3.077628>, <-1.138923, -0.915044, 3.077628>, <-0.972827, -0.699877, 3.049892>, <-0.699928, -0.699877, 3.049892>, 
      <-2.957337, -3.990684, 4.104670>, <-2.957337, -3.717785, 4.104670>, <-2.883626, -3.497014, 3.880703>, <-2.809713, -3.497014, 3.618003>, 
      <-4.385420, -3.250000, 4.731312>, <-4.385420, -2.977101, 4.731312>, <-4.323912, -2.750000, 4.512700>, <-4.250000, -2.750000, 4.250000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.500000, 0.000000, 2.000000>, <-1.138923, -1.187944, 3.077628>, <-2.957337, -3.990684, 4.104670>, <-4.385420, -3.250000, 4.731312>, 
      <-0.500000, -0.272899, 2.000000>, <-1.138923, -1.460843, 3.077628>, <-2.957337, -4.263583, 4.104670>, <-4.385420, -3.522899, 4.731312>, 
      <-0.272899, -0.500000, 2.000000>, <-0.972827, -1.699876, 3.049892>, <-2.883626, -4.497014, 3.880703>, <-4.323912, -3.750000, 4.512700>, 
      <0.000000, -0.500000, 2.000000>, <-0.699928, -1.699876, 3.049892>, <-2.809713, -4.497014, 3.618003>, <-4.250000, -3.750000, 4.250000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.341619, 2.750000, -1.288488>, <-0.341619, 2.477101, -1.288488>, <-0.527106, 2.250000, -1.157456>, <-0.750000, 2.250000, -1.000000>, 
      <0.877890, 2.982795, -0.868664>, <0.877890, 2.709896, -0.868664>, <0.628087, 2.470518, -0.759774>, <0.405193, 2.470518, -0.602318>, 
      <1.067918, 0.903138, 1.238778>, <1.067918, 0.630239, 1.238778>, <0.771938, 0.355495, 1.251442>, <0.499039, 0.355495, 1.251442>, 
      <0.500000, 0.000000, 2.000000>, <0.500000, -0.272899, 2.000000>, <0.272899, -0.500000, 2.000000>, <0.000000, -0.500000, 2.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.750000, 3.250000, -1.000000>, <-0.527106, 3.250000, -1.157456>, <-0.341619, 3.022899, -1.288488>, <-0.341619, 2.750000, -1.288488>, 
      <0.405193, 3.470518, -0.602318>, <0.628087, 3.470518, -0.759774>, <0.877890, 3.255695, -0.868664>, <0.877890, 2.982795, -0.868664>, 
      <0.499039, 1.355495, 1.251442>, <0.771938, 1.355495, 1.251442>, <1.067918, 1.176038, 1.238778>, <1.067918, 0.903138, 1.238778>, 
      <0.000000, 0.500000, 2.000000>, <0.272899, 0.500000, 2.000000>, <0.500000, 0.272899, 2.000000>, <0.500000, 0.000000, 2.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.158381, 2.750000, -0.711512>, <-1.158381, 3.022899, -0.711512>, <-0.972894, 3.250000, -0.842544>, <-0.750000, 3.250000, -1.000000>, 
      <-0.064755, 2.958765, -0.335025>, <-0.064755, 3.231664, -0.335025>, <0.182300, 3.470518, -0.444862>, <0.405193, 3.470518, -0.602318>, 
      <-0.065050, 0.808698, 1.266400>, <-0.065050, 1.081597, 1.266400>, <0.226139, 1.355495, 1.251442>, <0.499039, 1.355495, 1.251442>, 
      <-0.500000, 0.000000, 2.000000>, <-0.500000, 0.272899, 2.000000>, <-0.272899, 0.500000, 2.000000>, <0.000000, 0.500000, 2.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.158381, 2.750000, -0.711512>, <-0.064755, 2.958765, -0.335025>, <-0.065050, 0.808698, 1.266400>, <-0.500000, 0.000000, 2.000000>, 
      <-1.158381, 2.477101, -0.711512>, <-0.064755, 2.685866, -0.335025>, <-0.065050, 0.535799, 1.266400>, <-0.500000, -0.272899, 2.000000>, 
      <-0.972894, 2.250000, -0.842544>, <0.182300, 2.470518, -0.444862>, <0.226139, 0.355495, 1.251442>, <-0.272899, -0.500000, 2.000000>, 
      <-0.750000, 2.250000, -1.000000>, <0.405193, 2.470518, -0.602318>, <0.499039, 0.355495, 1.251442>, <0.000000, -0.500000, 2.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-9.687595, -1.944736, -1.507140>, <-9.687595, -2.217635, -1.507140>, <-9.914696, -2.444736, -1.507140>, <-10.187595, -2.444736, -1.507140>, 
      <-9.749830, -0.076753, 1.013966>, <-9.749830, -0.349653, 1.013966>, <-9.914696, -0.651161, 1.101696>, <-10.187595, -0.651161, 1.101696>, 
      <-3.261860, 2.192548, -2.293798>, <-3.261860, 1.919648, -2.293798>, <-3.472989, 1.687653, -2.171594>, <-3.695883, 1.687653, -2.014138>, 
      <-0.341619, 2.750000, -1.288488>, <-0.341619, 2.477101, -1.288488>, <-0.527106, 2.250000, -1.157456>, <-0.750000, 2.250000, -1.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-10.187595, -1.444736, -1.507140>, <-9.914696, -1.444736, -1.507140>, <-9.687595, -1.671837, -1.507140>, <-9.687595, -1.944736, -1.507140>, 
      <-10.187595, 0.348839, 1.101696>, <-9.914696, 0.348839, 1.101696>, <-9.749830, 0.196146, 1.013966>, <-9.749830, -0.076753, 1.013966>, 
      <-3.695883, 2.687653, -2.014138>, <-3.472989, 2.687653, -2.171594>, <-3.261860, 2.465447, -2.293798>, <-3.261860, 2.192548, -2.293798>, 
      <-0.750000, 3.250000, -1.000000>, <-0.527106, 3.250000, -1.157456>, <-0.341619, 3.022899, -1.288488>, <-0.341619, 2.750000, -1.288488>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-10.687595, -1.944736, -1.507140>, <-10.687595, -1.671837, -1.507140>, <-10.460495, -1.444736, -1.507140>, <-10.187595, -1.444736, -1.507140>, 
      <-10.630130, -0.219917, 1.182628>, <-10.630130, 0.052982, 1.182628>, <-10.460495, 0.348839, 1.101696>, <-10.187595, 0.348839, 1.101696>, 
      <-4.132087, 2.182342, -1.735228>, <-4.132087, 2.455241, -1.735228>, <-3.918777, 2.687653, -1.856681>, <-3.695883, 2.687653, -2.014138>, 
      <-1.158381, 2.750000, -0.711512>, <-1.158381, 3.022899, -0.711512>, <-0.972894, 3.250000, -0.842544>, <-0.750000, 3.250000, -1.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-10.687595, -1.944736, -1.507140>, <-10.630130, -0.219917, 1.182628>, <-4.132087, 2.182342, -1.735228>, <-1.158381, 2.750000, -0.711512>, 
      <-10.687595, -2.217635, -1.507140>, <-10.630130, -0.492817, 1.182628>, <-4.132087, 1.909442, -1.735228>, <-1.158381, 2.477101, -0.711512>, 
      <-10.460495, -2.444736, -1.507140>, <-10.460495, -0.651161, 1.101696>, <-3.918777, 1.687653, -1.856681>, <-0.972894, 2.250000, -0.842544>, 
      <-10.187595, -2.444736, -1.507140>, <-10.187595, -0.651161, 1.101696>, <-3.695883, 1.687653, -2.014138>, <-0.750000, 2.250000, -1.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.250000, 0.000000, -5.000000>, <-0.250000, -0.272899, -5.000000>, <-0.477101, -0.500000, -5.000000>, <-0.750000, -0.500000, -5.000000>, 
      <-3.226210, -0.506046, -4.416379>, <-3.226210, -0.778945, -4.416379>, <-3.308379, -1.083421, -3.952142>, <-3.581279, -1.083421, -3.952142>, 
      <-9.626622, -3.774909, -3.977216>, <-9.626622, -4.047809, -3.977216>, <-9.914696, -4.186711, -4.040922>, <-10.187595, -4.186711, -4.040922>, 
      <-9.687595, -1.944736, -1.507140>, <-9.687595, -2.217635, -1.507140>, <-9.914696, -2.444736, -1.507140>, <-10.187595, -2.444736, -1.507140>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.250000, 0.000000, -5.000000>, <-0.250000, -0.272899, -5.000000>, <-0.477101, -0.500000, -5.000000>, <-0.750000, -0.500000, -5.000000>, 
      <0.434857, 0.116446, -5.134297>, <0.434857, -0.156453, -5.134297>, <0.122899, -0.500000, -4.625000>, <-0.150000, -0.500000, -4.625000>, 
      <1.217516, 0.000000, -4.215924>, <1.217516, -0.272899, -4.215924>, <0.990415, -0.500000, -4.215924>, <0.717515, -0.500000, -4.215924>, 
      <1.750000, 0.000000, -3.750000>, <1.750000, -0.272899, -3.750000>, <1.522899, -0.500000, -3.750000>, <1.250000, -0.500000, -3.750000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.750000, 0.500000, -5.000000>, <-0.477101, 0.500000, -5.000000>, <-0.250000, 0.272899, -5.000000>, <-0.250000, 0.000000, -5.000000>, 
      <-0.150000, 0.500000, -4.625000>, <0.122899, 0.500000, -4.625000>, <0.434857, 0.389346, -5.134297>, <0.434857, 0.116446, -5.134297>, 
      <0.650000, 0.500000, -4.125000>, <0.922899, 0.500000, -4.125000>, <1.217516, 0.272899, -4.215924>, <1.217516, 0.000000, -4.215924>, 
      <1.250000, 0.500000, -3.750000>, <1.522899, 0.500000, -3.750000>, <1.750000, 0.272899, -3.750000>, <1.750000, 0.000000, -3.750000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.750000, 0.500000, -5.000000>, <-0.477101, 0.500000, -5.000000>, <-0.250000, 0.272899, -5.000000>, <-0.250000, 0.000000, -5.000000>, 
      <-3.581279, -0.083421, -3.952142>, <-3.308379, -0.083421, -3.952142>, <-3.226210, -0.233146, -4.416379>, <-3.226210, -0.506046, -4.416379>, 
      <-10.187595, -3.186711, -4.040922>, <-9.914696, -3.186711, -4.040922>, <-9.626622, -3.502010, -3.977216>, <-9.626622, -3.774909, -3.977216>, 
      <-10.187595, -1.444736, -1.507140>, <-9.914696, -1.444736, -1.507140>, <-9.687595, -1.671837, -1.507140>, <-9.687595, -1.944736, -1.507140>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.750000, 0.500000, -5.000000>, <-0.750000, 0.200000, -5.000000>, <-0.750000, -0.200000, -5.000000>, <-0.750000, -0.500000, -5.000000>, 
      <-0.750000, 0.500000, -5.000000>, <-0.477101, 0.200000, -5.000000>, <-0.477101, -0.200000, -5.000000>, <-0.477101, -0.500000, -5.000000>, 
      <-0.750000, 0.500000, -5.000000>, <-0.477101, 0.200000, -5.000000>, <-0.250000, 0.000000, -5.000000>, <-0.250000, -0.272899, -5.000000>, 
      <-0.750000, 0.500000, -5.000000>, <-0.477101, 0.500000, -5.000000>, <-0.250000, 0.272899, -5.000000>, <-0.250000, 0.000000, -5.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.250000, 0.000000, -5.000000>, <-1.250000, 0.272899, -5.000000>, <-1.022899, 0.500000, -5.000000>, <-0.750000, 0.500000, -5.000000>, 
      <-0.565143, 0.116446, -5.134297>, <-0.565143, 0.389346, -5.134297>, <-0.422899, 0.500000, -4.625000>, <-0.150000, 0.500000, -4.625000>, 
      <0.217515, 0.000000, -4.215924>, <0.217515, 0.272899, -4.215924>, <0.377101, 0.500000, -4.125000>, <0.650000, 0.500000, -4.125000>, 
      <0.750000, 0.000000, -3.750000>, <0.750000, 0.272899, -3.750000>, <0.977101, 0.500000, -3.750000>, <1.250000, 0.500000, -3.750000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.250000, 0.000000, -5.000000>, <-1.250000, 0.272899, -5.000000>, <-1.022899, 0.500000, -5.000000>, <-0.750000, 0.500000, -5.000000>, 
      <-4.226210, -0.506046, -4.416379>, <-4.226210, -0.233146, -4.416379>, <-3.854178, -0.083421, -3.952142>, <-3.581279, -0.083421, -3.952142>, 
      <-10.742885, -3.604259, -4.095084>, <-10.742885, -3.331360, -4.095084>, <-10.460495, -3.186711, -4.040922>, <-10.187595, -3.186711, -4.040922>, 
      <-10.687595, -1.944736, -1.507140>, <-10.687595, -1.671837, -1.507140>, <-10.460495, -1.444736, -1.507140>, <-10.187595, -1.444736, -1.507140>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.250000, 0.000000, -5.000000>, <-4.226210, -0.506046, -4.416379>, <-10.742885, -3.604259, -4.095084>, <-10.687595, -1.944736, -1.507140>, 
      <-1.250000, -0.272899, -5.000000>, <-4.226210, -0.778945, -4.416379>, <-10.742885, -3.877158, -4.095084>, <-10.687595, -2.217635, -1.507140>, 
      <-1.022899, -0.500000, -5.000000>, <-3.854178, -1.083421, -3.952142>, <-10.460495, -4.186711, -4.040922>, <-10.460495, -2.444736, -1.507140>, 
      <-0.750000, -0.500000, -5.000000>, <-3.581279, -1.083421, -3.952142>, <-10.187595, -4.186711, -4.040922>, <-10.187595, -2.444736, -1.507140>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.250000, 0.000000, -5.000000>, <-0.565143, 0.116446, -5.134297>, <0.217515, 0.000000, -4.215924>, <0.750000, 0.000000, -3.750000>, 
      <-1.250000, -0.272899, -5.000000>, <-0.565143, -0.156453, -5.134297>, <0.217515, -0.272899, -4.215924>, <0.750000, -0.272899, -3.750000>, 
      <-1.022899, -0.500000, -5.000000>, <-0.422899, -0.500000, -4.625000>, <0.444616, -0.500000, -4.215924>, <0.977101, -0.500000, -3.750000>, 
      <-0.750000, -0.500000, -5.000000>, <-0.150000, -0.500000, -4.625000>, <0.717515, -0.500000, -4.215924>, <1.250000, -0.500000, -3.750000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.250000, 0.000000, -5.000000>, <-1.250000, -0.272899, -5.000000>, <-1.022899, -0.500000, -5.000000>, <-0.750000, -0.500000, -5.000000>, 
      <-1.250000, 0.000000, -5.000000>, <-1.250000, 0.000000, -5.000000>, <-1.022899, -0.200000, -5.000000>, <-0.750000, -0.200000, -5.000000>, 
      <-1.250000, 0.000000, -5.000000>, <-1.250000, 0.000000, -5.000000>, <-1.022899, 0.200000, -5.000000>, <-0.750000, 0.200000, -5.000000>, 
      <-1.250000, 0.000000, -5.000000>, <-1.250000, 0.272899, -5.000000>, <-1.022899, 0.500000, -5.000000>, <-0.750000, 0.500000, -5.000000>
    }
  }
  texture {
    Bumpy_Black_Stone
  }
  scale <0.3, 0.2, 0.3>
  rotate <-0.0, -87.407852, 145.616318>
  translate  <99.785316, 100.068455, 104.278709>
}
union { // StringSculpt
  object { CrazyString }
  box { // GlassBlock
    <-1, -1, -1>, <1, 1, 1>
    texture {
      FoggyLight
    }
    scale <0.907641, 0.871014, 1.5>
    translate  <100.126042, 99.878083, 101.435893>
  }
  scale 2.3
  translate  <-144.642507, -72.196556, -126.470948>
}


#declare PanelEdgedone3 = intersection {
  torus { // PanelEdge4
    0.55, 0.05  rotate -x*90
    scale 0.4
    translate  <-0.417609, -1.267342, 0.0>
  }
  box { // PanelEdgeCut3
    <-1, -1, -1>, <1, 1, 1>
    scale <0.13, 0.13, 0.1>
    translate  <-0.546542, -1.396983, 0.0>
  }
}
#declare PanelBorderDone3 = union {
  object { PanelEdgedone3 }
  cylinder { // PanelBorder4
    <0,0,1>, <0,0,0>, 1 
    scale <0.02, 0.02, 1.0>
    rotate -90.0*x
    translate  <-0.637529, -1.267424, 0.0>
  }
  texture {
    Deep_Gold
  }
  rotate -270.0*z
  translate  <-0.684642, -0.849864, 0.0>
}
#declare PanelEdgedone2 = intersection {
  torus { // PanelEdge3
    0.55, 0.05  rotate -x*90
    scale 0.4
    translate  <-0.417609, -1.267342, 0.0>
  }
  box { // PanelEdgeCut2
    <-1, -1, -1>, <1, 1, 1>
    scale <0.13, 0.13, 0.1>
    translate  <-0.546542, -1.396983, 0.0>
  }
}
#declare PanelBorderDone2 = union {
  object { PanelEdgedone2 }
  cylinder { // PanelBorder3
    <0,0,1>, <0,0,0>, 1 
    scale <0.02, 0.02, 1.0>
    rotate -90.0*x
    translate  <-0.637529, -1.267424, 0.0>
  }
  texture {
    Deep_Gold
  }
  rotate -90.0*z
  translate  <0.850147, -1.284031, 0.0>
}
#declare PanelEdgedone1 = intersection {
  torus { // PanelEdge2
    0.55, 0.05  rotate -x*90
    scale 0.4
    translate  <-0.417609, -1.267342, 0.0>
  }
  box { // PanelEdgeCut1
    <-1, -1, -1>, <1, 1, 1>
    scale <0.13, 0.13, 0.1>
    translate  <-0.546542, -1.396983, 0.0>
  }
}
#declare PanelBorderDone1 = union {
  object { PanelEdgedone1 }
  cylinder { // PanelBorder2
    <0,0,1>, <0,0,0>, 1 
    scale <0.02, 0.02, 0.4>
    rotate -90.0*x
    translate  <-0.637529, -1.267424, 0.0>
  }
  texture {
    Deep_Gold
  }
  rotate -180.0*z
  translate  <0.165139, -2.135068, 0.0>
}
#declare PanelEdgedone = intersection {
  torus { // PanelEdge1
    0.55, 0.05  rotate -x*90
    scale 0.4
    translate  <-0.417609, -1.267342, 0.0>
  }
  box { // PanelEdgeCut
    <-1, -1, -1>, <1, 1, 1>
    scale <0.13, 0.13, 0.1>
    translate  <-0.546542, -1.396983, 0.0>
  }
}
#declare PanelBorderDone = union {
  object { PanelEdgedone }
  cylinder { // PanelBorder1
    <0,0,1>, <0,0,0>, 1 
    scale <0.02, 0.02, 0.4>
    rotate -90.0*x
    translate  <-0.637529, -1.267424, 0.0>
  }
  texture {
    Deep_Gold
  }
}
#declare HelmetText = object { 
  height_field {
    tga "C:\Program Files\Moray For Windows\AllMyMDLs\Souvenirs\HelmetTalk.tga"
    water_level 0.1
    smooth
  }
  rotate    <-90, 0, 0> // Turn onto XY plane. Now points along -Z
  scale     <  2, 2,-2> // Scale to Cube size. Now points along +Z
  translate < -1,-1,-1> // Center around origin
  texture {
    BrightLightYellow
  }
  scale <0.55, 0.275, 0.01>
  translate  <0.093658, -1.071868, 0.025272>
}
#declare PanelDone = union {
  box { // PanelBase
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Plastic_Black
    }
    scale <0.6, 0.31, 0.02>
    translate  <0.090299, -1.069948, 0.0>
  }
  object { PanelBorderDone3 }
  object { PanelBorderDone2 }
  object { PanelBorderDone1 }
  object { PanelBorderDone }
  object { HelmetText }
  rotate <50.0, -0.0, -0.0>
  translate  <0.0, -0.682092, 0.184314>
}
#declare SmBaseDone = intersection {
  box { // SmallBaseMake
    <-1, -1, -1>, <1, 1, 1>
    scale <1.1, 1.1, 0.35>
    translate  -0.659306*z
  }
  cylinder { // SmallBase
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 2.0>
    rotate -90.0*y
    translate  1.010616*x
  }
  texture {
    Iron
  }
}
#declare Projectors = union {
  object { Proj1 }
  object { // Proj2->Proj1
    Proj1
    translate  <0.0, -1.9, 0.0>
  }
  object { // Proj3->Proj1
    Proj1
    translate  <-1.9, -1.9, 0.0>
  }
  object { // Proj4->Proj1
    Proj1
    translate  <-1.9, 0.0, 0.0>
  }
}
#declare StandCutPieces = union {
  object { CutBtm }
  object { Cutmiddle }
  object { CutTop }
  object { // CutBtm1->CutBtm
    CutBtm
    translate  <9.0, 0.0, 0.0>
  }
  object { // Cutmiddle1->Cutmiddle
    Cutmiddle
    translate  9.0*x
  }
  object { // CutTop1->CutTop
    CutTop
    translate  9.0*x
  }
  scale <1.0, 1.3, 2.2>
  rotate <-0.0, 90.0, -90.0>
  translate  <91.14922, 91.06532, 104.164025>
}
#declare StandCut = difference {
  box { // SmallDisplayPost
    <-1, -1, -1>, <1, 1, 1>
    scale <2.64, 0.99, 7.59>
    translate  <91.131964, 89.953155, 94.950956>
  }
  object { StandCutPieces }
  texture {
    Iron
  }
  scale 0.30303
  rotate <-0.0, -0.0, 0.0>
  translate  <-27.615747, -27.258532, -31.773017>
}
#declare FacePlate = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.677826, -0.116482, -0.181331>, <-0.672378, -0.112299, -0.123317>, <-0.665113, -0.106721, -0.045964>, <-0.659665, -0.102537, 0.012050>, 
      <-0.698136, -0.097742, -0.182154>, <-0.692688, -0.093559, -0.124140>, <-0.694676, -0.087995, -0.077605>, <-0.689228, -0.083811, -0.019590>, 
      <-0.718375, -0.069439, -0.198774>, <-0.722785, -0.067621, -0.167449>, <-0.728348, -0.070994, -0.094849>, <-0.730950, -0.063767, -0.064108>, 
      <-0.735753, -0.049277, -0.206250>, <-0.740163, -0.047460, -0.174925>, <-0.747852, -0.050446, -0.132573>, <-0.750454, -0.043219, -0.101832>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.556141, -0.159149, -0.028102>, <-0.587198, -0.142165, -0.016056>, <-0.628608, -0.119521, 0.000004>, <-0.659665, -0.102537, 0.012050>, 
      <-0.565291, -0.164085, -0.080375>, <-0.596349, -0.147101, -0.068330>, <-0.634056, -0.123704, -0.058010>, <-0.665113, -0.106721, -0.045964>, 
      <-0.585137, -0.179185, -0.147841>, <-0.612037, -0.162364, -0.141586>, <-0.648622, -0.134217, -0.122354>, <-0.672378, -0.112299, -0.123317>, 
      <-0.593363, -0.180656, -0.200479>, <-0.620263, -0.163835, -0.194224>, <-0.654070, -0.138401, -0.180368>, <-0.677826, -0.116482, -0.181331>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.733817, -0.024416, -0.131375>, <-0.731762, -0.030860, -0.154064>, <-0.735172, -0.041819, -0.183787>, <-0.735753, -0.049277, -0.206250>, 
      <-0.733817, -0.024416, -0.131375>, <-0.736753, -0.036501, -0.145201>, <-0.739583, -0.040001, -0.152462>, <-0.740163, -0.047460, -0.174925>, 
      <-0.733817, -0.024416, -0.131375>, <-0.736753, -0.036501, -0.145201>, <-0.752660, -0.045380, -0.141874>, <-0.747852, -0.050446, -0.132573>, 
      <-0.733817, -0.024416, -0.131375>, <-0.738808, -0.030057, -0.122512>, <-0.755262, -0.038153, -0.111133>, <-0.750454, -0.043219, -0.101832>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.637035, -0.081089, -0.624478>, <-0.636665, -0.078847, -0.598122>, <-0.634423, -0.070400, -0.562846>, <-0.635801, -0.073617, -0.536624>, 
      <-0.651241, -0.061069, -0.615909>, <-0.650871, -0.058827, -0.589553>, <-0.649516, -0.049937, -0.557541>, <-0.650894, -0.053154, -0.531320>, 
      <-0.670928, -0.025340, -0.614034>, <-0.679405, -0.012548, -0.593594>, <-0.667138, -0.023641, -0.541794>, <-0.670384, -0.027959, -0.516812>, 
      <-0.679551, -0.012327, -0.593241>, <-0.688028, 0.000466, -0.572801>, <-0.681960, -0.004073, -0.533303>, <-0.685205, -0.008391, -0.508321>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.376778, -0.272790, -0.425257>, <-0.376344, -0.269047, -0.462881>, <-0.375765, -0.264057, -0.513046>, <-0.375331, -0.260314, -0.550669>, 
      <-0.381879, -0.247112, -0.414391>, <-0.381445, -0.243370, -0.452014>, <-0.404343, -0.242122, -0.523998>, <-0.403909, -0.238379, -0.561622>, 
      <-0.388680, -0.212876, -0.399902>, <-0.411723, -0.212876, -0.459345>, <-0.492550, -0.209133, -0.511629>, <-0.442014, -0.209133, -0.576225>, 
      <-0.393781, -0.187198, -0.389036>, <-0.416824, -0.187198, -0.448478>, <-0.521128, -0.187198, -0.522582>, <-0.470592, -0.187198, -0.587177>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.466810, -0.119485, 0.022962>, <-0.455910, -0.144651, 0.005721>, <-0.444191, -0.178451, -0.019005>, <-0.430477, -0.203371, -0.034507>, 
      <-0.452232, -0.146318, 0.015856>, <-0.441332, -0.171484, -0.001385>, <-0.435769, -0.193754, -0.028524>, <-0.422056, -0.218674, -0.044027>, 
      <-0.442953, -0.187752, 0.034025>, <-0.431232, -0.198373, 0.004476>, <-0.408868, -0.233453, -0.019179>, <-0.404704, -0.237700, -0.052163>, 
      <-0.432728, -0.217010, 0.038766>, <-0.421007, -0.227631, 0.009217>, <-0.397822, -0.248165, -0.026746>, <-0.393659, -0.252412, -0.059730>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.438168, -0.226232, -0.057952>, <-0.424912, -0.233841, -0.060532>, <-0.408550, -0.248960, -0.057159>, <-0.393659, -0.252412, -0.059730>, 
      <-0.438168, -0.226232, -0.057952>, <-0.422605, -0.226982, -0.053499>, <-0.419595, -0.234248, -0.049592>, <-0.404704, -0.237700, -0.052163>, 
      <-0.438168, -0.226232, -0.057952>, <-0.422605, -0.226982, -0.053499>, <-0.424363, -0.225532, -0.051060>, <-0.422056, -0.218674, -0.044027>, 
      <-0.438168, -0.226232, -0.057952>, <-0.435861, -0.219374, -0.050918>, <-0.432784, -0.210229, -0.041541>, <-0.430477, -0.203371, -0.034507>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.458563, -0.169457, 0.051360>, <-0.457203, -0.166088, 0.034323>, <-0.474909, -0.104577, 0.026910>, <-0.466810, -0.119485, 0.022962>, 
      <-0.458563, -0.169457, 0.051360>, <-0.444741, -0.175345, 0.028252>, <-0.460332, -0.131410, 0.019804>, <-0.452232, -0.146318, 0.015856>, 
      <-0.458563, -0.169457, 0.051360>, <-0.444741, -0.175345, 0.028252>, <-0.450703, -0.173487, 0.037803>, <-0.442953, -0.187752, 0.034025>, 
      <-0.458563, -0.169457, 0.051360>, <-0.446101, -0.178714, 0.045288>, <-0.440479, -0.202744, 0.042544>, <-0.432728, -0.217010, 0.038766>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.659140, -0.065019, 0.145121>, <-0.689108, -0.040903, 0.122200>, <-0.730858, -0.010231, 0.092296>, <-0.759032, 0.015368, 0.068718>, 
      <-0.659297, -0.076274, 0.105200>, <-0.689265, -0.052158, 0.082279>, <-0.729615, -0.026299, 0.040589>, <-0.757789, -0.000701, 0.017011>, 
      <-0.659508, -0.091282, 0.051971>, <-0.689071, -0.072556, 0.020331>, <-0.735399, -0.051413, -0.011562>, <-0.754903, -0.030866, -0.049287>, 
      <-0.659665, -0.102537, 0.012050>, <-0.689228, -0.083811, -0.019590>, <-0.730950, -0.063767, -0.064108>, <-0.750454, -0.043219, -0.101832>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.549068, -0.130590, 0.095448>, <-0.549198, -0.127259, 0.086106>, <-0.549371, -0.122817, 0.073649>, <-0.549501, -0.119485, 0.064307>, 
      <-0.521917, -0.142250, 0.082222>, <-0.522046, -0.138919, 0.072879>, <-0.524375, -0.122817, 0.061632>, <-0.524505, -0.119485, 0.052289>, 
      <-0.482766, -0.151478, 0.063152>, <-0.481407, -0.148109, 0.046115>, <-0.499717, -0.104577, 0.039314>, <-0.491617, -0.119485, 0.035366>, 
      <-0.458563, -0.169457, 0.051360>, <-0.457203, -0.166088, 0.034323>, <-0.474909, -0.104577, 0.026910>, <-0.466810, -0.119485, 0.022962>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.549068, -0.130590, 0.095448>, <-0.549198, -0.127259, 0.086106>, <-0.549371, -0.122817, 0.073649>, <-0.549501, -0.119485, 0.064307>, 
      <-0.582090, -0.110919, 0.110350>, <-0.582220, -0.107587, 0.101008>, <-0.573996, -0.122817, 0.085488>, <-0.574126, -0.119485, 0.076146>, 
      <-0.626118, -0.084690, 0.130219>, <-0.618035, -0.101030, 0.117425>, <-0.615470, -0.103145, 0.103818>, <-0.607386, -0.119485, 0.091024>, 
      <-0.659140, -0.065019, 0.145121>, <-0.651056, -0.081359, 0.132327>, <-0.640278, -0.103145, 0.115268>, <-0.632194, -0.119485, 0.102474>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.759940, 0.026565, 0.060765>, <-0.752103, 0.011271, 0.003123>, <-0.739038, -0.008044, -0.073733>, <-0.733817, -0.024416, -0.131375>, 
      <-0.759668, 0.023206, 0.063151>, <-0.751831, 0.007912, 0.005509>, <-0.744030, -0.013684, -0.064870>, <-0.738808, -0.030057, -0.122512>, 
      <-0.761630, 0.017729, 0.066544>, <-0.760388, 0.001660, 0.014836>, <-0.759711, -0.025800, -0.058587>, <-0.755262, -0.038153, -0.111133>, 
      <-0.759032, 0.015368, 0.068718>, <-0.757789, -0.000701, 0.017011>, <-0.754903, -0.030866, -0.049287>, <-0.750454, -0.043219, -0.101832>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.559112, -0.162181, -0.004817>, <-0.558221, -0.161271, -0.011803>, <-0.554922, -0.158491, -0.021138>, <-0.556141, -0.159149, -0.028102>, 
      <-0.520521, -0.174538, -0.013724>, <-0.519630, -0.173628, -0.020709>, <-0.519530, -0.178616, -0.030093>, <-0.520749, -0.179274, -0.037057>, 
      <-0.469068, -0.191014, -0.025600>, <-0.471375, -0.197872, -0.032634>, <-0.471511, -0.198911, -0.043979>, <-0.473818, -0.205769, -0.051013>, 
      <-0.430477, -0.203371, -0.034507>, <-0.432784, -0.210229, -0.041541>, <-0.435861, -0.219374, -0.050918>, <-0.438168, -0.226232, -0.057952>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.630049, -0.119485, 0.027033>, <-0.638934, -0.114401, 0.022538>, <-0.652659, -0.106975, 0.019548>, <-0.659665, -0.102537, 0.012050>, 
      <-0.630692, -0.119485, 0.049665>, <-0.639577, -0.114401, 0.045170>, <-0.652502, -0.095719, 0.059469>, <-0.659508, -0.091282, 0.051971>, 
      <-0.631551, -0.119485, 0.079842>, <-0.639634, -0.103145, 0.092636>, <-0.651214, -0.092614, 0.092406>, <-0.659297, -0.076274, 0.105200>, 
      <-0.632194, -0.119485, 0.102474>, <-0.640278, -0.103145, 0.115268>, <-0.651056, -0.081359, 0.132327>, <-0.659140, -0.065019, 0.145121>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.630049, -0.119485, 0.027033>, <-0.608768, -0.132294, 0.017478>, <-0.580393, -0.149372, 0.004738>, <-0.559112, -0.162181, -0.004817>, 
      <-0.638934, -0.114401, 0.022538>, <-0.617653, -0.127209, 0.012983>, <-0.579502, -0.148463, -0.002247>, <-0.558221, -0.161271, -0.011803>, 
      <-0.652659, -0.106975, 0.019548>, <-0.621602, -0.123958, 0.007502>, <-0.585979, -0.141508, -0.009092>, <-0.554922, -0.158491, -0.021138>, 
      <-0.659665, -0.102537, 0.012050>, <-0.628608, -0.119521, 0.000004>, <-0.587198, -0.142165, -0.016056>, <-0.556141, -0.159149, -0.028102>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.520013, -0.215167, -0.218028>, <-0.508131, -0.215476, -0.165314>, <-0.462722, -0.222913, -0.105975>, <-0.438168, -0.226232, -0.057952>, 
      <-0.543033, -0.206711, -0.213819>, <-0.531151, -0.207021, -0.161104>, <-0.498371, -0.202450, -0.099035>, <-0.473818, -0.205769, -0.051013>, 
      <-0.572665, -0.193599, -0.205292>, <-0.564439, -0.192128, -0.152654>, <-0.529900, -0.184210, -0.089330>, <-0.520749, -0.179274, -0.037057>, 
      <-0.593363, -0.180656, -0.200479>, <-0.585137, -0.179185, -0.147841>, <-0.565291, -0.164085, -0.080375>, <-0.556141, -0.159149, -0.028102>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.398021, -0.252412, -0.236198>, <-0.391833, -0.254046, -0.183630>, <-0.387081, -0.259122, -0.111846>, <-0.393659, -0.252412, -0.059730>, 
      <-0.435442, -0.242924, -0.234298>, <-0.429254, -0.244559, -0.181729>, <-0.401972, -0.255670, -0.109276>, <-0.408550, -0.248960, -0.057159>, 
      <-0.484255, -0.228302, -0.224567>, <-0.472373, -0.228612, -0.171852>, <-0.449466, -0.230521, -0.108555>, <-0.424912, -0.233841, -0.060532>, 
      <-0.520013, -0.215167, -0.218028>, <-0.508131, -0.215476, -0.165314>, <-0.462722, -0.222913, -0.105975>, <-0.438168, -0.226232, -0.057952>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.304145, -0.269897, -0.228990>, <-0.314750, -0.273205, -0.290788>, <-0.354988, -0.271922, -0.366377>, <-0.376778, -0.272790, -0.425257>, 
      <-0.283231, -0.272439, -0.228537>, <-0.293836, -0.275747, -0.290336>, <-0.312010, -0.269675, -0.364283>, <-0.333800, -0.270543, -0.423163>, 
      <-0.255072, -0.271608, -0.231551>, <-0.254915, -0.269496, -0.287240>, <-0.276652, -0.269660, -0.364683>, <-0.276495, -0.267548, -0.420372>, 
      <-0.234040, -0.272341, -0.232649>, <-0.233883, -0.270229, -0.288338>, <-0.233674, -0.267413, -0.362589>, <-0.233517, -0.265301, -0.418278>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.304145, -0.269897, -0.228990>, <-0.296465, -0.267501, -0.184238>, <-0.312904, -0.258810, -0.123836>, <-0.317328, -0.254243, -0.078813>, 
      <-0.332657, -0.266432, -0.229607>, <-0.324978, -0.264036, -0.184855>, <-0.336346, -0.256655, -0.122030>, <-0.340770, -0.252088, -0.077007>, 
      <-0.370207, -0.259464, -0.237610>, <-0.364019, -0.261098, -0.185042>, <-0.364399, -0.264380, -0.115762>, <-0.370977, -0.257670, -0.063646>, 
      <-0.398021, -0.252412, -0.236198>, <-0.391833, -0.254046, -0.183630>, <-0.387081, -0.259122, -0.111846>, <-0.393659, -0.252412, -0.059730>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.332209, -0.240929, 0.056606>, <-0.362907, -0.236263, 0.051568>, <-0.402572, -0.224186, 0.044118>, <-0.432728, -0.217010, 0.038766>, 
      <-0.329473, -0.244344, 0.015775>, <-0.360171, -0.239678, 0.010737>, <-0.390852, -0.234806, 0.014569>, <-0.421007, -0.227631, 0.009217>, 
      <-0.321324, -0.250119, -0.038151>, <-0.344766, -0.247964, -0.036346>, <-0.375140, -0.253423, -0.030662>, <-0.397822, -0.248165, -0.026746>, 
      <-0.317328, -0.254243, -0.078813>, <-0.340770, -0.252088, -0.077007>, <-0.370977, -0.257670, -0.063646>, <-0.393659, -0.252412, -0.059730>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.403642, -0.199181, 0.250713>, <-0.412368, -0.204530, 0.187129>, <-0.424002, -0.211661, 0.102350>, <-0.432728, -0.217010, 0.038766>, 
      <-0.384159, -0.207580, 0.250009>, <-0.392884, -0.212928, 0.186425>, <-0.393846, -0.218837, 0.107702>, <-0.402572, -0.224186, 0.044118>, 
      <-0.359638, -0.222356, 0.244952>, <-0.357606, -0.226471, 0.188625>, <-0.366672, -0.231563, 0.107760>, <-0.362907, -0.236263, 0.051568>, 
      <-0.338981, -0.227212, 0.244365>, <-0.336949, -0.231327, 0.188037>, <-0.335974, -0.236229, 0.112799>, <-0.332209, -0.240929, 0.056606>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.767915, 0.079485, 0.240948>, <-0.765523, 0.063609, 0.186893>, <-0.762332, 0.042441, 0.114820>, <-0.759940, 0.026565, 0.060765>, 
      <-0.765250, 0.075951, 0.245195>, <-0.762858, 0.060075, 0.191140>, <-0.762060, 0.039082, 0.117206>, <-0.759668, 0.023206, 0.063151>, 
      <-0.763345, 0.072007, 0.254387>, <-0.763345, 0.056306, 0.198471>, <-0.762963, 0.034960, 0.121992>, <-0.761630, 0.017729, 0.066544>, 
      <-0.759032, 0.067704, 0.255106>, <-0.759032, 0.052003, 0.199190>, <-0.760365, 0.032599, 0.124166>, <-0.759032, 0.015368, 0.068718>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.673589, -0.014632, 0.256664>, <-0.699808, 0.009442, 0.257310>, <-0.734004, 0.042732, 0.259276>, <-0.759032, 0.067704, 0.255106>, 
      <-0.669254, -0.029748, 0.223201>, <-0.695473, -0.005674, 0.223847>, <-0.734004, 0.027031, 0.203360>, <-0.759032, 0.052003, 0.199190>, 
      <-0.663475, -0.049903, 0.178584>, <-0.693442, -0.025787, 0.155663>, <-0.732190, 0.007001, 0.147744>, <-0.760365, 0.032599, 0.124166>, 
      <-0.659140, -0.065019, 0.145121>, <-0.689108, -0.040903, 0.122200>, <-0.730858, -0.010231, 0.092296>, <-0.759032, 0.015368, 0.068718>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.558892, -0.116066, 0.250176>, <-0.594896, -0.087505, 0.251517>, <-0.639729, -0.045722, 0.255830>, <-0.673589, -0.014632, 0.256664>, 
      <-0.555945, -0.120423, 0.203758>, <-0.591948, -0.091863, 0.205098>, <-0.635395, -0.060838, 0.222367>, <-0.669254, -0.029748, 0.223201>, 
      <-0.552015, -0.126233, 0.141866>, <-0.585037, -0.106562, 0.156768>, <-0.630453, -0.069574, 0.163682>, <-0.663475, -0.049903, 0.178584>, 
      <-0.549068, -0.130590, 0.095448>, <-0.582090, -0.110919, 0.110350>, <-0.626118, -0.084690, 0.130219>, <-0.659140, -0.065019, 0.145121>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.484904, -0.164310, 0.249637>, <-0.508265, -0.151803, 0.249556>, <-0.538141, -0.132527, 0.249403>, <-0.558892, -0.116066, 0.250176>, 
      <-0.477002, -0.165854, 0.190154>, <-0.500363, -0.153347, 0.190073>, <-0.535194, -0.136884, 0.202985>, <-0.555945, -0.120423, 0.203758>, 
      <-0.463249, -0.181066, 0.110066>, <-0.487453, -0.163087, 0.121858>, <-0.524864, -0.137893, 0.128640>, <-0.552015, -0.126233, 0.141866>, 
      <-0.458563, -0.169457, 0.051360>, <-0.482766, -0.151478, 0.063152>, <-0.521917, -0.142250, 0.082222>, <-0.549068, -0.130590, 0.095448>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.484904, -0.164310, 0.249637>, <-0.477002, -0.165854, 0.190154>, <-0.463249, -0.181066, 0.110066>, <-0.458563, -0.169457, 0.051360>, 
      <-0.461515, -0.176832, 0.249718>, <-0.453612, -0.178376, 0.190235>, <-0.450787, -0.190323, 0.103994>, <-0.446101, -0.178714, 0.045288>, 
      <-0.427992, -0.188685, 0.251593>, <-0.436718, -0.194033, 0.188009>, <-0.431753, -0.197395, 0.106128>, <-0.440479, -0.202744, 0.042544>, 
      <-0.403642, -0.199181, 0.250713>, <-0.412368, -0.204530, 0.187129>, <-0.424002, -0.211661, 0.102350>, <-0.432728, -0.217010, 0.038766>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.594373, -0.132362, -0.644619>, <-0.594716, -0.131650, -0.613186>, <-0.593987, -0.126014, -0.570995>, <-0.595518, -0.129990, -0.539842>, 
      <-0.607172, -0.116980, -0.638577>, <-0.607515, -0.116269, -0.607144>, <-0.606534, -0.109519, -0.569124>, <-0.608065, -0.113495, -0.537971>, 
      <-0.625614, -0.097183, -0.631367>, <-0.625244, -0.094942, -0.605011>, <-0.622332, -0.086793, -0.567095>, <-0.623710, -0.090010, -0.540874>, 
      <-0.637035, -0.081089, -0.624478>, <-0.636665, -0.078847, -0.598122>, <-0.634423, -0.070400, -0.562846>, <-0.635801, -0.073617, -0.536624>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.594373, -0.132362, -0.644619>, <-0.570162, -0.161893, -0.666401>, <-0.545634, -0.204556, -0.702317>, <-0.513669, -0.230799, -0.717226>, 
      <-0.594716, -0.131650, -0.613186>, <-0.570505, -0.161182, -0.634968>, <-0.545207, -0.206132, -0.653664>, <-0.513242, -0.232375, -0.668573>, 
      <-0.593987, -0.126014, -0.570995>, <-0.569441, -0.158284, -0.574655>, <-0.543470, -0.212037, -0.595461>, <-0.512401, -0.237014, -0.603719>, 
      <-0.595518, -0.129990, -0.539842>, <-0.570972, -0.162260, -0.543502>, <-0.543315, -0.211075, -0.546790>, <-0.512246, -0.236051, -0.555048>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435474, -0.258651, -0.582383>, <-0.435077, -0.261882, -0.624070>, <-0.431516, -0.264815, -0.679673>, <-0.429820, -0.267457, -0.721368>, 
      <-0.415393, -0.262210, -0.581741>, <-0.414996, -0.265441, -0.623427>, <-0.403059, -0.269865, -0.680476>, <-0.401363, -0.272507, -0.722171>, 
      <-0.393374, -0.259815, -0.560183>, <-0.380843, -0.260548, -0.611676>, <-0.374994, -0.262843, -0.670748>, <-0.362463, -0.263576, -0.722240>, 
      <-0.375331, -0.260314, -0.550669>, <-0.362800, -0.261047, -0.602161>, <-0.346093, -0.262025, -0.670818>, <-0.333562, -0.262758, -0.722310>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435474, -0.258651, -0.582383>, <-0.460443, -0.254226, -0.583182>, <-0.492884, -0.251617, -0.560195>, <-0.512246, -0.236051, -0.555048>, 
      <-0.435077, -0.261882, -0.624070>, <-0.460046, -0.257457, -0.624868>, <-0.493039, -0.252579, -0.608866>, <-0.512401, -0.237014, -0.603719>, 
      <-0.431516, -0.264815, -0.679673>, <-0.458565, -0.260016, -0.678909>, <-0.493260, -0.248779, -0.677892>, <-0.513242, -0.232375, -0.668573>, 
      <-0.429820, -0.267457, -0.721368>, <-0.456869, -0.262657, -0.720604>, <-0.493687, -0.247204, -0.726546>, <-0.513669, -0.230799, -0.717226>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.709370, -0.052003, -0.363702>, <-0.701862, -0.045930, -0.408566>, <-0.691032, -0.016144, -0.463466>, <-0.685205, -0.008391, -0.508321>, 
      <-0.691681, -0.070095, -0.365594>, <-0.684174, -0.064022, -0.410458>, <-0.676211, -0.035712, -0.471957>, <-0.670384, -0.027959, -0.516812>, 
      <-0.667038, -0.093148, -0.370335>, <-0.661031, -0.087022, -0.421116>, <-0.653576, -0.059417, -0.480271>, <-0.650894, -0.053154, -0.531320>, 
      <-0.650407, -0.112308, -0.370008>, <-0.644400, -0.106181, -0.420790>, <-0.638484, -0.079880, -0.485575>, <-0.635801, -0.073617, -0.536624>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.709370, -0.052003, -0.363702>, <-0.691681, -0.070095, -0.365594>, <-0.667038, -0.093148, -0.370335>, <-0.650407, -0.112308, -0.370008>, 
      <-0.717206, -0.058341, -0.316873>, <-0.699517, -0.076433, -0.318765>, <-0.673710, -0.099954, -0.313923>, <-0.657080, -0.119114, -0.313596>, 
      <-0.727838, -0.050095, -0.253486>, <-0.710460, -0.070256, -0.246010>, <-0.689911, -0.096490, -0.238757>, <-0.669600, -0.115230, -0.237934>, 
      <-0.735753, -0.049277, -0.206250>, <-0.718375, -0.069439, -0.198774>, <-0.698136, -0.097742, -0.182154>, <-0.677826, -0.116482, -0.181331>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.608276, -0.168472, -0.361717>, <-0.624649, -0.155165, -0.359547>, <-0.636505, -0.128324, -0.369735>, <-0.650407, -0.112308, -0.370008>, 
      <-0.608620, -0.160380, -0.415919>, <-0.624993, -0.147073, -0.413750>, <-0.630499, -0.122197, -0.420517>, <-0.644400, -0.106181, -0.420790>, 
      <-0.598186, -0.136921, -0.485543>, <-0.610733, -0.120426, -0.483673>, <-0.626393, -0.096273, -0.489825>, <-0.638484, -0.079880, -0.485575>, 
      <-0.595518, -0.129990, -0.539842>, <-0.608065, -0.113495, -0.537971>, <-0.623710, -0.090010, -0.540874>, <-0.635801, -0.073617, -0.536624>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.608276, -0.168472, -0.361717>, <-0.607970, -0.175665, -0.313537>, <-0.600882, -0.182001, -0.248592>, <-0.593363, -0.180656, -0.200479>, 
      <-0.624649, -0.155165, -0.359547>, <-0.624343, -0.162359, -0.311367>, <-0.627782, -0.165179, -0.242337>, <-0.620263, -0.163835, -0.194224>, 
      <-0.636505, -0.128324, -0.369735>, <-0.643178, -0.135130, -0.313323>, <-0.645844, -0.137149, -0.236971>, <-0.654070, -0.138401, -0.180368>, 
      <-0.650407, -0.112308, -0.370008>, <-0.657080, -0.119114, -0.313596>, <-0.669600, -0.115230, -0.237934>, <-0.677826, -0.116482, -0.181331>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.608276, -0.168472, -0.361717>, <-0.581900, -0.189908, -0.365212>, <-0.543696, -0.211254, -0.382645>, <-0.512619, -0.224293, -0.388267>, 
      <-0.607970, -0.175665, -0.313537>, <-0.581595, -0.197102, -0.317032>, <-0.544873, -0.208088, -0.331564>, <-0.513796, -0.221128, -0.337185>, 
      <-0.600882, -0.182001, -0.248592>, <-0.580183, -0.194944, -0.253405>, <-0.554289, -0.206418, -0.263758>, <-0.531269, -0.214874, -0.267968>, 
      <-0.593363, -0.180656, -0.200479>, <-0.572665, -0.193599, -0.205292>, <-0.543033, -0.206711, -0.213819>, <-0.520013, -0.215167, -0.218028>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.608276, -0.168472, -0.361717>, <-0.608620, -0.160380, -0.415919>, <-0.598186, -0.136921, -0.485543>, <-0.595518, -0.129990, -0.539842>, 
      <-0.581900, -0.189908, -0.365212>, <-0.582245, -0.181816, -0.419415>, <-0.573640, -0.169191, -0.489204>, <-0.570972, -0.162260, -0.543502>, 
      <-0.543696, -0.211254, -0.382645>, <-0.542543, -0.214355, -0.432695>, <-0.543155, -0.210083, -0.496641>, <-0.543315, -0.211075, -0.546790>, 
      <-0.512619, -0.224293, -0.388267>, <-0.511466, -0.227394, -0.438316>, <-0.512086, -0.235059, -0.504899>, <-0.512246, -0.236051, -0.555048>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.432943, -0.242038, -0.393434>, <-0.455328, -0.234046, -0.387339>, <-0.490301, -0.233657, -0.392304>, <-0.512619, -0.224293, -0.388267>, 
      <-0.439063, -0.243058, -0.450003>, <-0.461448, -0.235066, -0.443908>, <-0.489148, -0.236759, -0.442354>, <-0.511466, -0.227394, -0.438316>, 
      <-0.436014, -0.254253, -0.525647>, <-0.460983, -0.249829, -0.526446>, <-0.492724, -0.250625, -0.510046>, <-0.512086, -0.235059, -0.504899>, 
      <-0.435474, -0.258651, -0.582383>, <-0.460443, -0.254226, -0.583182>, <-0.492884, -0.251617, -0.560195>, <-0.512246, -0.236051, -0.555048>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.432943, -0.242038, -0.393434>, <-0.439063, -0.243058, -0.450003>, <-0.436014, -0.254253, -0.525647>, <-0.435474, -0.258651, -0.582383>, 
      <-0.413374, -0.249025, -0.398763>, <-0.419494, -0.250044, -0.455332>, <-0.415934, -0.257812, -0.525005>, <-0.415393, -0.262210, -0.581741>, 
      <-0.393628, -0.263564, -0.415710>, <-0.393193, -0.259822, -0.453334>, <-0.393808, -0.263558, -0.522560>, <-0.393374, -0.259815, -0.560183>, 
      <-0.376778, -0.272790, -0.425257>, <-0.376344, -0.269047, -0.462881>, <-0.375765, -0.264057, -0.513046>, <-0.375331, -0.260314, -0.550669>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.432943, -0.242038, -0.393434>, <-0.413374, -0.249025, -0.398763>, <-0.393628, -0.263564, -0.415710>, <-0.376778, -0.272790, -0.425257>, 
      <-0.427736, -0.241171, -0.345302>, <-0.408166, -0.248157, -0.350631>, <-0.371838, -0.262697, -0.356830>, <-0.354988, -0.271922, -0.366377>, 
      <-0.403679, -0.250918, -0.284263>, <-0.375865, -0.257970, -0.285676>, <-0.343262, -0.269740, -0.291405>, <-0.314750, -0.273205, -0.290788>, 
      <-0.398021, -0.252412, -0.236198>, <-0.370207, -0.259464, -0.237610>, <-0.332657, -0.266432, -0.229607>, <-0.304145, -0.269897, -0.228990>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.432943, -0.242038, -0.393434>, <-0.427736, -0.241171, -0.345302>, <-0.403679, -0.250918, -0.284263>, <-0.398021, -0.252412, -0.236198>, 
      <-0.455328, -0.234046, -0.387339>, <-0.450120, -0.233179, -0.339207>, <-0.441100, -0.241430, -0.282363>, <-0.435442, -0.242924, -0.234298>, 
      <-0.490301, -0.233657, -0.392304>, <-0.491478, -0.230492, -0.341223>, <-0.495511, -0.228009, -0.274506>, <-0.484255, -0.228302, -0.224567>, 
      <-0.512619, -0.224293, -0.388267>, <-0.513796, -0.221128, -0.337185>, <-0.531269, -0.214874, -0.267968>, <-0.520013, -0.215167, -0.218028>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.214663, -0.116482, -0.181331>, <0.234973, -0.097742, -0.182154>, <0.255212, -0.069439, -0.198774>, <0.272590, -0.049277, -0.206250>, 
      <0.209215, -0.112299, -0.123317>, <0.229525, -0.093559, -0.124140>, <0.259622, -0.067621, -0.167449>, <0.277000, -0.047460, -0.174925>, 
      <0.201950, -0.106721, -0.045964>, <0.231513, -0.087995, -0.077605>, <0.265185, -0.070994, -0.094849>, <0.284688, -0.050446, -0.132573>, 
      <0.196502, -0.102537, 0.012050>, <0.226065, -0.083811, -0.019590>, <0.267787, -0.063767, -0.064108>, <0.287291, -0.043219, -0.101832>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.092978, -0.159149, -0.028102>, <0.102129, -0.164085, -0.080375>, <0.121974, -0.179185, -0.147841>, <0.130200, -0.180656, -0.200479>, 
      <0.124035, -0.142165, -0.016056>, <0.133186, -0.147101, -0.068330>, <0.148874, -0.162364, -0.141586>, <0.157100, -0.163835, -0.194224>, 
      <0.165445, -0.119521, 0.000004>, <0.170893, -0.123704, -0.058010>, <0.185459, -0.134217, -0.122354>, <0.190907, -0.138401, -0.180368>, 
      <0.196502, -0.102537, 0.012050>, <0.201950, -0.106721, -0.045964>, <0.209215, -0.112299, -0.123317>, <0.214663, -0.116482, -0.181331>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.270654, -0.024416, -0.131375>, <0.275645, -0.030057, -0.122512>, <0.292099, -0.038153, -0.111133>, <0.287291, -0.043219, -0.101832>, 
      <0.270654, -0.024416, -0.131375>, <0.273590, -0.036501, -0.145201>, <0.289497, -0.045380, -0.141874>, <0.284688, -0.050446, -0.132573>, 
      <0.270654, -0.024416, -0.131375>, <0.273590, -0.036501, -0.145201>, <0.276419, -0.040001, -0.152462>, <0.277000, -0.047460, -0.174925>, 
      <0.270654, -0.024416, -0.131375>, <0.268599, -0.030860, -0.154064>, <0.272009, -0.041819, -0.183787>, <0.272590, -0.049277, -0.206250>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.173872, -0.081089, -0.624478>, <0.188078, -0.061069, -0.615909>, <0.207765, -0.025340, -0.614034>, <0.216388, -0.012327, -0.593241>, 
      <0.173502, -0.078847, -0.598122>, <0.187708, -0.058827, -0.589553>, <0.216242, -0.012548, -0.593594>, <0.224864, 0.000466, -0.572801>, 
      <0.171260, -0.070400, -0.562846>, <0.186353, -0.049937, -0.557541>, <0.203975, -0.023641, -0.541794>, <0.218797, -0.004073, -0.533303>, 
      <0.172638, -0.073617, -0.536624>, <0.187731, -0.053154, -0.531320>, <0.207221, -0.027959, -0.516812>, <0.222042, -0.008391, -0.508321>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.236214, -0.187198, -0.398939>, <-0.235405, -0.210629, -0.404741>, <-0.234326, -0.241870, -0.412476>, <-0.233517, -0.265301, -0.418278>, 
      <-0.283484, -0.187198, -0.395968>, <-0.282675, -0.210629, -0.401770>, <-0.277304, -0.244117, -0.414570>, <-0.276495, -0.267548, -0.420372>, 
      <-0.346511, -0.187198, -0.392007>, <-0.341410, -0.212876, -0.402873>, <-0.338901, -0.244866, -0.412297>, <-0.333800, -0.270543, -0.423163>, 
      <-0.393781, -0.187198, -0.389036>, <-0.388680, -0.212876, -0.399902>, <-0.381879, -0.247112, -0.414391>, <-0.376778, -0.272790, -0.425257>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.235785, -0.262623, -0.547707>, <-0.239521, -0.251184, -0.525991>, <-0.241351, -0.209826, -0.570887>, <-0.243737, -0.187198, -0.580821>, 
      <-0.277664, -0.262623, -0.547707>, <-0.281400, -0.251184, -0.525991>, <-0.328903, -0.209826, -0.573340>, <-0.331289, -0.187198, -0.583274>, 
      <-0.333467, -0.261007, -0.549781>, <-0.362046, -0.239072, -0.560733>, <-0.388044, -0.209133, -0.645208>, <-0.416623, -0.187198, -0.656160>, 
      <-0.375331, -0.260314, -0.550669>, <-0.403909, -0.238379, -0.561622>, <-0.442014, -0.209133, -0.576225>, <-0.470592, -0.187198, -0.587177>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.235785, -0.262623, -0.547707>, <-0.191451, -0.262623, -0.547707>, <-0.132372, -0.261007, -0.549781>, <-0.088052, -0.260314, -0.550669>, 
      <-0.239521, -0.251184, -0.525991>, <-0.195187, -0.251184, -0.525991>, <-0.104473, -0.239072, -0.560733>, <-0.060153, -0.238379, -0.561622>, 
      <-0.241351, -0.209826, -0.570887>, <-0.145376, -0.209826, -0.573340>, <-0.087028, -0.209133, -0.647722>, <-0.022956, -0.209133, -0.576225>, 
      <-0.243737, -0.187198, -0.580821>, <-0.147762, -0.187198, -0.583274>, <-0.059130, -0.187198, -0.658675>, <0.004943, -0.187198, -0.587177>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.235785, -0.262623, -0.547707>, <-0.277664, -0.262623, -0.547707>, <-0.333467, -0.261007, -0.549781>, <-0.375331, -0.260314, -0.550669>, 
      <-0.227887, -0.286804, -0.593610>, <-0.269767, -0.286804, -0.593610>, <-0.320937, -0.261740, -0.601273>, <-0.362800, -0.261047, -0.602161>, 
      <-0.224364, -0.261839, -0.669624>, <-0.258592, -0.262215, -0.669755>, <-0.311876, -0.261056, -0.670900>, <-0.346093, -0.262025, -0.670818>, 
      <-0.219469, -0.261503, -0.721874>, <-0.253697, -0.261879, -0.722005>, <-0.299346, -0.261790, -0.722392>, <-0.333562, -0.262758, -0.722310>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.088870, -0.272790, -0.425257>, <-0.132264, -0.270543, -0.423163>, <-0.190123, -0.267548, -0.420372>, <-0.233517, -0.265301, -0.418278>, 
      <-0.083769, -0.247112, -0.414391>, <-0.127164, -0.244866, -0.412297>, <-0.190932, -0.244117, -0.414570>, <-0.234326, -0.241870, -0.412476>, 
      <-0.076969, -0.212876, -0.399902>, <-0.126272, -0.212876, -0.402873>, <-0.186101, -0.210629, -0.401770>, <-0.235405, -0.210629, -0.404741>, 
      <-0.071868, -0.187198, -0.389036>, <-0.121172, -0.187198, -0.392007>, <-0.186910, -0.187198, -0.395968>, <-0.236214, -0.187198, -0.398939>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.088870, -0.272790, -0.425257>, <-0.083769, -0.247112, -0.414391>, <-0.076969, -0.212876, -0.399902>, <-0.071868, -0.187198, -0.389036>, 
      <-0.088625, -0.269047, -0.462881>, <-0.083524, -0.243370, -0.452014>, <-0.053925, -0.212876, -0.459345>, <-0.048825, -0.187198, -0.448478>, 
      <-0.088297, -0.264057, -0.513046>, <-0.060399, -0.242122, -0.523998>, <0.031780, -0.209133, -0.515147>, <0.059678, -0.187198, -0.526099>, 
      <-0.088052, -0.260314, -0.550669>, <-0.060153, -0.238379, -0.561622>, <-0.022956, -0.209133, -0.576225>, <0.004943, -0.187198, -0.587177>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.003647, -0.119485, 0.022962>, <-0.010931, -0.146318, 0.015856>, <-0.020210, -0.187752, 0.034025>, <-0.030435, -0.217010, 0.038766>, 
      <-0.007253, -0.144651, 0.005721>, <-0.021831, -0.171484, -0.001385>, <-0.031931, -0.198373, 0.004476>, <-0.042156, -0.227631, 0.009217>, 
      <-0.018973, -0.178451, -0.019005>, <-0.027394, -0.193754, -0.028524>, <-0.054295, -0.233453, -0.019179>, <-0.065341, -0.248165, -0.026746>, 
      <-0.032686, -0.203371, -0.034507>, <-0.041107, -0.218674, -0.044027>, <-0.058459, -0.237700, -0.052163>, <-0.069504, -0.252412, -0.059730>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.225095, -0.267904, -0.072714>, <-0.253126, -0.267904, -0.072714>, <-0.289496, -0.256801, -0.080957>, <-0.317328, -0.254243, -0.078813>, 
      <-0.225915, -0.271729, -0.120629>, <-0.253947, -0.271729, -0.120629>, <-0.285072, -0.261368, -0.125980>, <-0.312904, -0.258810, -0.123836>, 
      <-0.231356, -0.271010, -0.184669>, <-0.252388, -0.270277, -0.183571>, <-0.275551, -0.270043, -0.183785>, <-0.296465, -0.267501, -0.184238>, 
      <-0.234040, -0.272341, -0.232649>, <-0.255072, -0.271608, -0.231551>, <-0.283231, -0.272439, -0.228537>, <-0.304145, -0.269897, -0.228990>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.024995, -0.226232, -0.057952>, <-0.027302, -0.219374, -0.050918>, <-0.030379, -0.210229, -0.041541>, <-0.032686, -0.203371, -0.034507>, 
      <-0.024995, -0.226232, -0.057952>, <-0.040558, -0.226982, -0.053499>, <-0.038800, -0.225532, -0.051060>, <-0.041107, -0.218674, -0.044027>, 
      <-0.024995, -0.226232, -0.057952>, <-0.040558, -0.226982, -0.053499>, <-0.043568, -0.234248, -0.049592>, <-0.058459, -0.237700, -0.052163>, 
      <-0.024995, -0.226232, -0.057952>, <-0.038251, -0.233841, -0.060532>, <-0.054613, -0.248960, -0.057159>, <-0.069504, -0.252412, -0.059730>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.004600, -0.169457, 0.051360>, <-0.017062, -0.178714, 0.045288>, <-0.022685, -0.202744, 0.042544>, <-0.030435, -0.217010, 0.038766>, 
      <-0.004600, -0.169457, 0.051360>, <-0.018422, -0.175345, 0.028252>, <-0.012460, -0.173487, 0.037803>, <-0.020210, -0.187752, 0.034025>, 
      <-0.004600, -0.169457, 0.051360>, <-0.018422, -0.175345, 0.028252>, <-0.002831, -0.131410, 0.019804>, <-0.010931, -0.146318, 0.015856>, 
      <-0.004600, -0.169457, 0.051360>, <-0.005960, -0.166088, 0.034323>, <0.011747, -0.104577, 0.026910>, <0.003647, -0.119485, 0.022962>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.195977, -0.065019, 0.145121>, <0.196134, -0.076274, 0.105200>, <0.196345, -0.091282, 0.051971>, <0.196502, -0.102537, 0.012050>, 
      <0.225945, -0.040903, 0.122200>, <0.226102, -0.052158, 0.082279>, <0.225908, -0.072556, 0.020331>, <0.226065, -0.083811, -0.019590>, 
      <0.267695, -0.010231, 0.092296>, <0.266452, -0.026299, 0.040589>, <0.272236, -0.051413, -0.011562>, <0.267787, -0.063767, -0.064108>, 
      <0.295869, 0.015368, 0.068718>, <0.294626, -0.000701, 0.017011>, <0.291739, -0.030866, -0.049287>, <0.287291, -0.043219, -0.101832>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.085905, -0.130590, 0.095448>, <0.058754, -0.142250, 0.082222>, <0.019603, -0.151478, 0.063152>, <-0.004600, -0.169457, 0.051360>, 
      <0.086035, -0.127259, 0.086106>, <0.058883, -0.138919, 0.072879>, <0.018243, -0.148109, 0.046115>, <-0.005960, -0.166088, 0.034323>, 
      <0.086208, -0.122817, 0.073649>, <0.061212, -0.122817, 0.061632>, <0.036554, -0.104577, 0.039314>, <0.011747, -0.104577, 0.026910>, 
      <0.086338, -0.119485, 0.064307>, <0.061342, -0.119485, 0.052289>, <0.028454, -0.119485, 0.035366>, <0.003647, -0.119485, 0.022962>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.085905, -0.130590, 0.095448>, <0.086035, -0.127259, 0.086106>, <0.086208, -0.122817, 0.073649>, <0.086338, -0.119485, 0.064307>, 
      <0.118927, -0.110919, 0.110350>, <0.119057, -0.107587, 0.101008>, <0.110833, -0.122817, 0.085488>, <0.110963, -0.119485, 0.076146>, 
      <0.162955, -0.084690, 0.130219>, <0.154872, -0.101030, 0.117425>, <0.152307, -0.103145, 0.103818>, <0.144223, -0.119485, 0.091024>, 
      <0.195977, -0.065019, 0.145121>, <0.187893, -0.081359, 0.132327>, <0.177115, -0.103145, 0.115268>, <0.169031, -0.119485, 0.102474>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.228822, -0.248002, 0.072233>, <-0.260262, -0.248002, 0.072233>, <-0.301527, -0.245592, 0.061642>, <-0.332209, -0.240929, 0.056606>, 
      <-0.227704, -0.253973, 0.028749>, <-0.259144, -0.253973, 0.028749>, <-0.298791, -0.249008, 0.020811>, <-0.329473, -0.244344, 0.015775>, 
      <-0.224346, -0.264411, -0.028953>, <-0.252378, -0.264411, -0.028953>, <-0.293492, -0.252677, -0.040295>, <-0.321324, -0.250119, -0.038151>, 
      <-0.225095, -0.267904, -0.072714>, <-0.253126, -0.267904, -0.072714>, <-0.289496, -0.256801, -0.080957>, <-0.317328, -0.254243, -0.078813>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.228822, -0.248002, 0.072233>, <-0.227443, -0.246009, 0.124247>, <-0.225605, -0.243353, 0.193599>, <-0.224226, -0.241360, 0.245613>, 
      <-0.260262, -0.248002, 0.072233>, <-0.258883, -0.246009, 0.124247>, <-0.260031, -0.239108, 0.193225>, <-0.258653, -0.237116, 0.245239>, 
      <-0.301527, -0.245592, 0.061642>, <-0.305292, -0.240892, 0.117834>, <-0.303194, -0.239263, 0.187078>, <-0.305225, -0.235148, 0.243406>, 
      <-0.332209, -0.240929, 0.056606>, <-0.335974, -0.236229, 0.112799>, <-0.336949, -0.231327, 0.188037>, <-0.338981, -0.227212, 0.244365>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.296777, 0.026565, 0.060765>, <0.296505, 0.023206, 0.063151>, <0.298467, 0.017729, 0.066544>, <0.295869, 0.015368, 0.068718>, 
      <0.288940, 0.011271, 0.003123>, <0.288668, 0.007912, 0.005509>, <0.297225, 0.001660, 0.014836>, <0.294626, -0.000701, 0.017011>, 
      <0.275875, -0.008044, -0.073733>, <0.280867, -0.013684, -0.064870>, <0.296548, -0.025800, -0.058587>, <0.291739, -0.030866, -0.049287>, 
      <0.270654, -0.024416, -0.131375>, <0.275645, -0.030057, -0.122512>, <0.292099, -0.038153, -0.111133>, <0.287291, -0.043219, -0.101832>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.095949, -0.162181, -0.004817>, <0.057359, -0.174538, -0.013724>, <0.005905, -0.191014, -0.025600>, <-0.032686, -0.203371, -0.034507>, 
      <0.095058, -0.161271, -0.011803>, <0.056467, -0.173628, -0.020709>, <0.008212, -0.197872, -0.032634>, <-0.030379, -0.210229, -0.041541>, 
      <0.091759, -0.158491, -0.021138>, <0.056367, -0.178616, -0.030093>, <0.008348, -0.198911, -0.043979>, <-0.027302, -0.219374, -0.050918>, 
      <0.092978, -0.159149, -0.028102>, <0.057586, -0.179274, -0.037057>, <0.010655, -0.205769, -0.051013>, <-0.024995, -0.226232, -0.057952>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.166886, -0.119485, 0.027033>, <0.175771, -0.114401, 0.022538>, <0.189496, -0.106975, 0.019548>, <0.196502, -0.102537, 0.012050>, 
      <0.167530, -0.119485, 0.049665>, <0.176414, -0.114401, 0.045170>, <0.189339, -0.095719, 0.059469>, <0.196345, -0.091282, 0.051971>, 
      <0.168388, -0.119485, 0.079842>, <0.176471, -0.103145, 0.092636>, <0.188051, -0.092614, 0.092406>, <0.196134, -0.076274, 0.105200>, 
      <0.169031, -0.119485, 0.102474>, <0.177115, -0.103145, 0.115268>, <0.187893, -0.081359, 0.132327>, <0.195977, -0.065019, 0.145121>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.166886, -0.119485, 0.027033>, <0.145605, -0.132294, 0.017478>, <0.117230, -0.149372, 0.004738>, <0.095949, -0.162181, -0.004817>, 
      <0.175771, -0.114401, 0.022538>, <0.154490, -0.127209, 0.012983>, <0.116339, -0.148463, -0.002247>, <0.095058, -0.161271, -0.011803>, 
      <0.189496, -0.106975, 0.019548>, <0.158439, -0.123958, 0.007502>, <0.122816, -0.141508, -0.009092>, <0.091759, -0.158491, -0.021138>, 
      <0.196502, -0.102537, 0.012050>, <0.165445, -0.119521, 0.000004>, <0.124035, -0.142165, -0.016056>, <0.092978, -0.159149, -0.028102>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.056850, -0.215167, -0.218028>, <0.079870, -0.206711, -0.213819>, <0.109502, -0.193599, -0.205292>, <0.130200, -0.180656, -0.200479>, 
      <0.044969, -0.215476, -0.165314>, <0.067988, -0.207021, -0.161104>, <0.101276, -0.192128, -0.152654>, <0.121974, -0.179185, -0.147841>, 
      <-0.000442, -0.222913, -0.105975>, <0.035208, -0.202450, -0.099035>, <0.066737, -0.184210, -0.089330>, <0.102129, -0.164085, -0.080375>, 
      <-0.024995, -0.226232, -0.057952>, <0.010655, -0.205769, -0.051013>, <0.057586, -0.179274, -0.037057>, <0.092978, -0.159149, -0.028102>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.065142, -0.252412, -0.236198>, <-0.027721, -0.242924, -0.234298>, <0.021092, -0.228302, -0.224567>, <0.056850, -0.215167, -0.218028>, 
      <-0.071330, -0.254046, -0.183630>, <-0.033910, -0.244559, -0.181729>, <0.009210, -0.228612, -0.171852>, <0.044969, -0.215476, -0.165314>, 
      <-0.076082, -0.259122, -0.111846>, <-0.061191, -0.255670, -0.109276>, <-0.013697, -0.230521, -0.108555>, <-0.000442, -0.222913, -0.105975>, 
      <-0.069504, -0.252412, -0.059730>, <-0.054613, -0.248960, -0.057159>, <-0.038251, -0.233841, -0.060532>, <-0.024995, -0.226232, -0.057952>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.159018, -0.269897, -0.228990>, <-0.181403, -0.272538, -0.228520>, <-0.211533, -0.271608, -0.231551>, <-0.234040, -0.272341, -0.232649>, 
      <-0.148886, -0.273196, -0.290609>, <-0.171271, -0.275837, -0.290139>, <-0.211376, -0.269496, -0.287240>, <-0.233883, -0.270229, -0.288338>, 
      <-0.109914, -0.271922, -0.366377>, <-0.153308, -0.269675, -0.364283>, <-0.190280, -0.269660, -0.364683>, <-0.233674, -0.267413, -0.362589>, 
      <-0.088870, -0.272790, -0.425257>, <-0.132264, -0.270543, -0.423163>, <-0.190123, -0.267548, -0.420372>, <-0.233517, -0.265301, -0.418278>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.159018, -0.269897, -0.228990>, <-0.166385, -0.267498, -0.184185>, <-0.150259, -0.258810, -0.123836>, <-0.145835, -0.254243, -0.078813>, 
      <-0.181403, -0.272538, -0.228520>, <-0.188770, -0.270140, -0.183715>, <-0.174255, -0.261199, -0.125838>, <-0.169831, -0.256632, -0.080815>, 
      <-0.211533, -0.271608, -0.231551>, <-0.208850, -0.270277, -0.183571>, <-0.201717, -0.271729, -0.120629>, <-0.200897, -0.267904, -0.072714>, 
      <-0.234040, -0.272341, -0.232649>, <-0.231356, -0.271010, -0.184669>, <-0.225915, -0.271729, -0.120629>, <-0.225095, -0.267904, -0.072714>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.159018, -0.269897, -0.228990>, <-0.130494, -0.266531, -0.229589>, <-0.092956, -0.259464, -0.237610>, <-0.065142, -0.252412, -0.236198>, 
      <-0.166385, -0.267498, -0.184185>, <-0.137861, -0.264133, -0.184785>, <-0.099144, -0.261098, -0.185042>, <-0.071330, -0.254046, -0.183630>, 
      <-0.150259, -0.258810, -0.123836>, <-0.126845, -0.256478, -0.121882>, <-0.098764, -0.264380, -0.115762>, <-0.076082, -0.259122, -0.111846>, 
      <-0.145835, -0.254243, -0.078813>, <-0.122421, -0.251912, -0.076859>, <-0.092186, -0.257670, -0.063646>, <-0.069504, -0.252412, -0.059730>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.130954, -0.240929, 0.056606>, <-0.160004, -0.245467, 0.061507>, <-0.199014, -0.248002, 0.072233>, <-0.228822, -0.248002, 0.072233>, 
      <-0.133690, -0.244344, 0.015775>, <-0.162740, -0.248882, 0.020675>, <-0.197896, -0.253973, 0.028749>, <-0.227704, -0.253973, 0.028749>, 
      <-0.141839, -0.250119, -0.038151>, <-0.165836, -0.252508, -0.040154>, <-0.200148, -0.264411, -0.028953>, <-0.224346, -0.264411, -0.028953>, 
      <-0.145835, -0.254243, -0.078813>, <-0.169831, -0.256632, -0.080815>, <-0.200897, -0.267904, -0.072714>, <-0.225095, -0.267904, -0.072714>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.130954, -0.240929, 0.056606>, <-0.133690, -0.244344, 0.015775>, <-0.141839, -0.250119, -0.038151>, <-0.145835, -0.254243, -0.078813>, 
      <-0.100298, -0.236140, 0.051434>, <-0.103033, -0.239555, 0.010603>, <-0.118426, -0.247787, -0.036198>, <-0.122421, -0.251912, -0.076859>, 
      <-0.060591, -0.224186, 0.044118>, <-0.072311, -0.234806, 0.014569>, <-0.088023, -0.253423, -0.030662>, <-0.092186, -0.257670, -0.063646>, 
      <-0.030435, -0.217010, 0.038766>, <-0.042156, -0.227631, 0.009217>, <-0.065341, -0.248165, -0.026746>, <-0.069504, -0.252412, -0.059730>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.124182, -0.227212, 0.244365>, <-0.153548, -0.234732, 0.244181>, <-0.194213, -0.237116, 0.245239>, <-0.224226, -0.241360, 0.245613>, 
      <-0.126214, -0.231327, 0.188037>, <-0.155580, -0.238847, 0.187854>, <-0.195592, -0.239108, 0.193225>, <-0.225605, -0.243353, 0.193599>, 
      <-0.127189, -0.236229, 0.112799>, <-0.156239, -0.240767, 0.117699>, <-0.197635, -0.246009, 0.124247>, <-0.227443, -0.246009, 0.124247>, 
      <-0.130954, -0.240929, 0.056606>, <-0.160004, -0.245467, 0.061507>, <-0.199014, -0.248002, 0.072233>, <-0.228822, -0.248002, 0.072233>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.059521, -0.199181, 0.246644>, <-0.078936, -0.207550, 0.245943>, <-0.103690, -0.221964, 0.244493>, <-0.124182, -0.227212, 0.244365>, 
      <-0.050795, -0.204530, 0.184281>, <-0.070210, -0.212899, 0.183579>, <-0.105722, -0.226079, 0.188166>, <-0.126214, -0.231327, 0.188037>, 
      <-0.039161, -0.211661, 0.101129>, <-0.069317, -0.218837, 0.106481>, <-0.096533, -0.231440, 0.107627>, <-0.127189, -0.236229, 0.112799>, 
      <-0.030435, -0.217010, 0.038766>, <-0.060591, -0.224186, 0.044118>, <-0.100298, -0.236140, 0.051434>, <-0.130954, -0.240929, 0.056606>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.304752, 0.079485, 0.240948>, <0.302087, 0.075951, 0.245195>, <0.300182, 0.072007, 0.254387>, <0.295869, 0.067704, 0.255106>, 
      <0.302360, 0.063609, 0.186893>, <0.299695, 0.060075, 0.191140>, <0.300182, 0.056306, 0.198471>, <0.295869, 0.052003, 0.199190>, 
      <0.299169, 0.042441, 0.114820>, <0.298897, 0.039082, 0.117206>, <0.299800, 0.034960, 0.121992>, <0.297202, 0.032599, 0.124166>, 
      <0.296777, 0.026565, 0.060765>, <0.296505, 0.023206, 0.063151>, <0.298467, 0.017729, 0.066544>, <0.295869, 0.015368, 0.068718>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.210426, -0.014632, 0.256664>, <0.206091, -0.029748, 0.223201>, <0.200312, -0.049903, 0.178584>, <0.195977, -0.065019, 0.145121>, 
      <0.236645, 0.009442, 0.257310>, <0.232310, -0.005674, 0.223847>, <0.230279, -0.025787, 0.155663>, <0.225945, -0.040903, 0.122200>, 
      <0.270841, 0.042732, 0.259276>, <0.270841, 0.027031, 0.203360>, <0.269027, 0.007001, 0.147744>, <0.267695, -0.010231, 0.092296>, 
      <0.295869, 0.067704, 0.255106>, <0.295869, 0.052003, 0.199190>, <0.297202, 0.032599, 0.124166>, <0.295869, 0.015368, 0.068718>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.095729, -0.116066, 0.250176>, <0.092782, -0.120423, 0.203758>, <0.088852, -0.126233, 0.141866>, <0.085905, -0.130590, 0.095448>, 
      <0.131733, -0.087505, 0.251517>, <0.128786, -0.091863, 0.205098>, <0.121874, -0.106562, 0.156768>, <0.118927, -0.110919, 0.110350>, 
      <0.176566, -0.045722, 0.255830>, <0.172232, -0.060838, 0.222367>, <0.167290, -0.069574, 0.163682>, <0.162955, -0.084690, 0.130219>, 
      <0.210426, -0.014632, 0.256664>, <0.206091, -0.029748, 0.223201>, <0.200312, -0.049903, 0.178584>, <0.195977, -0.065019, 0.145121>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.021741, -0.164310, 0.249637>, <-0.001655, -0.176836, 0.249105>, <-0.035159, -0.188680, 0.247524>, <-0.059521, -0.199181, 0.246644>, 
      <0.013839, -0.165854, 0.190154>, <-0.009558, -0.178380, 0.189622>, <-0.026433, -0.194028, 0.185161>, <-0.050795, -0.204530, 0.184281>, 
      <0.000086, -0.181066, 0.110066>, <-0.012376, -0.190323, 0.103994>, <-0.031410, -0.197395, 0.104908>, <-0.039161, -0.211661, 0.101129>, 
      <-0.004600, -0.169457, 0.051360>, <-0.017062, -0.178714, 0.045288>, <-0.022685, -0.202744, 0.042544>, <-0.030435, -0.217010, 0.038766>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.021741, -0.164310, 0.249637>, <0.013839, -0.165854, 0.190154>, <0.000086, -0.181066, 0.110066>, <-0.004600, -0.169457, 0.051360>, 
      <0.045098, -0.151806, 0.250168>, <0.037195, -0.153350, 0.190685>, <0.024289, -0.163087, 0.121858>, <0.019603, -0.151478, 0.063152>, 
      <0.074978, -0.132527, 0.249403>, <0.072031, -0.136884, 0.202985>, <0.061701, -0.137893, 0.128640>, <0.058754, -0.142250, 0.082222>, 
      <0.095729, -0.116066, 0.250176>, <0.092782, -0.120423, 0.203758>, <0.088852, -0.126233, 0.141866>, <0.085905, -0.130590, 0.095448>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.131210, -0.132362, -0.644619>, <0.131553, -0.131650, -0.613186>, <0.130824, -0.126014, -0.570995>, <0.132355, -0.129990, -0.539842>, 
      <0.106999, -0.161893, -0.666401>, <0.107342, -0.161182, -0.634968>, <0.106278, -0.158284, -0.574655>, <0.107809, -0.162260, -0.543502>, 
      <0.082471, -0.204556, -0.702317>, <0.082044, -0.206132, -0.653664>, <0.080307, -0.212037, -0.595461>, <0.080152, -0.211075, -0.546790>, 
      <0.050506, -0.230799, -0.717226>, <0.050079, -0.232375, -0.668573>, <0.049238, -0.237014, -0.603719>, <0.049083, -0.236051, -0.555048>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.131210, -0.132362, -0.644619>, <0.144009, -0.116980, -0.638577>, <0.162451, -0.097183, -0.631367>, <0.173872, -0.081089, -0.624478>, 
      <0.131553, -0.131650, -0.613186>, <0.144352, -0.116269, -0.607144>, <0.162081, -0.094942, -0.605011>, <0.173502, -0.078847, -0.598122>, 
      <0.130824, -0.126014, -0.570995>, <0.143371, -0.109519, -0.569124>, <0.159169, -0.086793, -0.567095>, <0.171260, -0.070400, -0.562846>, 
      <0.132355, -0.129990, -0.539842>, <0.144902, -0.113495, -0.537971>, <0.160547, -0.090010, -0.540874>, <0.172638, -0.073617, -0.536624>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.129601, -0.262758, -0.722310>, <-0.117136, -0.262025, -0.670818>, <-0.100517, -0.261047, -0.602161>, <-0.088052, -0.260314, -0.550669>, 
      <-0.156551, -0.261896, -0.722383>, <-0.144086, -0.261163, -0.670891>, <-0.144837, -0.261740, -0.601273>, <-0.132372, -0.261007, -0.549781>, 
      <-0.192509, -0.261879, -0.722005>, <-0.197403, -0.262215, -0.669755>, <-0.183553, -0.286804, -0.593610>, <-0.191451, -0.262623, -0.547707>, 
      <-0.219469, -0.261503, -0.721874>, <-0.224364, -0.261839, -0.669624>, <-0.227887, -0.286804, -0.593610>, <-0.235785, -0.262623, -0.547707>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.027689, -0.258651, -0.582383>, <-0.028086, -0.261882, -0.624070>, <-0.031647, -0.264815, -0.679673>, <-0.033343, -0.267457, -0.721368>, 
      <-0.002719, -0.254233, -0.583180>, <-0.003116, -0.257464, -0.624867>, <-0.004598, -0.260016, -0.678909>, <-0.006294, -0.262657, -0.720604>, 
      <0.029721, -0.251617, -0.560195>, <0.029876, -0.252579, -0.608866>, <0.030097, -0.248779, -0.677892>, <0.030524, -0.247204, -0.726546>, 
      <0.049083, -0.236051, -0.555048>, <0.049238, -0.237014, -0.603719>, <0.050079, -0.232375, -0.668573>, <0.050506, -0.230799, -0.717226>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.027689, -0.258651, -0.582383>, <-0.047828, -0.262214, -0.581740>, <-0.069943, -0.259815, -0.560183>, <-0.088052, -0.260314, -0.550669>, 
      <-0.028086, -0.261882, -0.624070>, <-0.048225, -0.265445, -0.623426>, <-0.082408, -0.260548, -0.611676>, <-0.100517, -0.261047, -0.602161>, 
      <-0.031647, -0.264815, -0.679673>, <-0.060104, -0.269865, -0.680476>, <-0.088238, -0.262949, -0.670739>, <-0.117136, -0.262025, -0.670818>, 
      <-0.033343, -0.267457, -0.721368>, <-0.061801, -0.272507, -0.722171>, <-0.100703, -0.263682, -0.722232>, <-0.129601, -0.262758, -0.722310>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.246207, -0.052003, -0.363702>, <0.228518, -0.070095, -0.365594>, <0.203874, -0.093148, -0.370335>, <0.187244, -0.112308, -0.370008>, 
      <0.238700, -0.045930, -0.408566>, <0.221011, -0.064022, -0.410458>, <0.197868, -0.087022, -0.421116>, <0.181237, -0.106181, -0.420790>, 
      <0.227869, -0.016144, -0.463466>, <0.213048, -0.035712, -0.471957>, <0.190413, -0.059417, -0.480271>, <0.175320, -0.079880, -0.485575>, 
      <0.222042, -0.008391, -0.508321>, <0.207221, -0.027959, -0.516812>, <0.187731, -0.053154, -0.531320>, <0.172638, -0.073617, -0.536624>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.246207, -0.052003, -0.363702>, <0.254043, -0.058341, -0.316873>, <0.264675, -0.050095, -0.253486>, <0.272590, -0.049277, -0.206250>, 
      <0.228518, -0.070095, -0.365594>, <0.236354, -0.076433, -0.318765>, <0.247297, -0.070256, -0.246010>, <0.255212, -0.069439, -0.198774>, 
      <0.203874, -0.093148, -0.370335>, <0.210547, -0.099954, -0.313923>, <0.226748, -0.096490, -0.238757>, <0.234973, -0.097742, -0.182154>, 
      <0.187244, -0.112308, -0.370008>, <0.193917, -0.119114, -0.313596>, <0.206437, -0.115230, -0.237934>, <0.214663, -0.116482, -0.181331>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.145113, -0.168472, -0.361717>, <0.145457, -0.160380, -0.415919>, <0.135023, -0.136921, -0.485543>, <0.132355, -0.129990, -0.539842>, 
      <0.161486, -0.155165, -0.359547>, <0.161830, -0.147073, -0.413750>, <0.147570, -0.120426, -0.483673>, <0.144902, -0.113495, -0.537971>, 
      <0.173342, -0.128324, -0.369735>, <0.167336, -0.122197, -0.420517>, <0.163230, -0.096273, -0.489825>, <0.160547, -0.090010, -0.540874>, 
      <0.187244, -0.112308, -0.370008>, <0.181237, -0.106181, -0.420790>, <0.175320, -0.079880, -0.485575>, <0.172638, -0.073617, -0.536624>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.145113, -0.168472, -0.361717>, <0.161486, -0.155165, -0.359547>, <0.173342, -0.128324, -0.369735>, <0.187244, -0.112308, -0.370008>, 
      <0.144807, -0.175665, -0.313537>, <0.161180, -0.162359, -0.311367>, <0.180015, -0.135130, -0.313323>, <0.193917, -0.119114, -0.313596>, 
      <0.137719, -0.182001, -0.248592>, <0.164619, -0.165179, -0.242337>, <0.182681, -0.137149, -0.236971>, <0.206437, -0.115230, -0.237934>, 
      <0.130200, -0.180656, -0.200479>, <0.157100, -0.163835, -0.194224>, <0.190907, -0.138401, -0.180368>, <0.214663, -0.116482, -0.181331>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.145113, -0.168472, -0.361717>, <0.144807, -0.175665, -0.313537>, <0.137719, -0.182001, -0.248592>, <0.130200, -0.180656, -0.200479>, 
      <0.118737, -0.189908, -0.365212>, <0.118432, -0.197102, -0.317032>, <0.117020, -0.194944, -0.253405>, <0.109502, -0.193599, -0.205292>, 
      <0.080533, -0.211254, -0.382645>, <0.081710, -0.208088, -0.331564>, <0.091126, -0.206418, -0.263758>, <0.079870, -0.206711, -0.213819>, 
      <0.049456, -0.224293, -0.388267>, <0.050633, -0.221128, -0.337185>, <0.068106, -0.214874, -0.267968>, <0.056850, -0.215167, -0.218028>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.145113, -0.168472, -0.361717>, <0.118737, -0.189908, -0.365212>, <0.080533, -0.211254, -0.382645>, <0.049456, -0.224293, -0.388267>, 
      <0.145457, -0.160380, -0.415919>, <0.119082, -0.181816, -0.419415>, <0.079380, -0.214355, -0.432695>, <0.048303, -0.227394, -0.438316>, 
      <0.135023, -0.136921, -0.485543>, <0.110477, -0.169191, -0.489204>, <0.079992, -0.210083, -0.496641>, <0.048923, -0.235059, -0.504899>, 
      <0.132355, -0.129990, -0.539842>, <0.107809, -0.162260, -0.543502>, <0.080152, -0.211075, -0.546790>, <0.049083, -0.236051, -0.555048>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.030220, -0.242038, -0.393434>, <-0.050388, -0.249109, -0.398827>, <-0.071275, -0.263564, -0.415710>, <-0.088870, -0.272790, -0.425257>, 
      <-0.024100, -0.243058, -0.450003>, <-0.044268, -0.250128, -0.455396>, <-0.071030, -0.259822, -0.453334>, <-0.088625, -0.269047, -0.462881>, 
      <-0.027149, -0.254253, -0.525647>, <-0.047288, -0.257817, -0.525004>, <-0.070189, -0.263558, -0.522560>, <-0.088297, -0.264057, -0.513046>, 
      <-0.027689, -0.258651, -0.582383>, <-0.047828, -0.262214, -0.581740>, <-0.069943, -0.259815, -0.560183>, <-0.088052, -0.260314, -0.550669>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.030220, -0.242038, -0.393434>, <-0.024100, -0.243058, -0.450003>, <-0.027149, -0.254253, -0.525647>, <-0.027689, -0.258651, -0.582383>, 
      <-0.007768, -0.234167, -0.387430>, <-0.001648, -0.235186, -0.443999>, <-0.002178, -0.249835, -0.526445>, <-0.002719, -0.254233, -0.583180>, 
      <0.027138, -0.233657, -0.392304>, <0.025984, -0.236759, -0.442354>, <0.029561, -0.250625, -0.510046>, <0.029721, -0.251617, -0.560195>, 
      <0.049456, -0.224293, -0.388267>, <0.048303, -0.227394, -0.438316>, <0.048923, -0.235059, -0.504899>, <0.049083, -0.236051, -0.555048>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.030220, -0.242038, -0.393434>, <-0.007768, -0.234167, -0.387430>, <0.027138, -0.233657, -0.392304>, <0.049456, -0.224293, -0.388267>, 
      <-0.035427, -0.241171, -0.345302>, <-0.012976, -0.233299, -0.339298>, <0.028315, -0.230492, -0.341223>, <0.050633, -0.221128, -0.337185>, 
      <-0.059484, -0.250918, -0.284263>, <-0.022063, -0.241430, -0.282363>, <0.032348, -0.228009, -0.274506>, <0.068106, -0.214874, -0.267968>, 
      <-0.065142, -0.252412, -0.236198>, <-0.027721, -0.242924, -0.234298>, <0.021092, -0.228302, -0.224567>, <0.056850, -0.215167, -0.218028>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.030220, -0.242038, -0.393434>, <-0.035427, -0.241171, -0.345302>, <-0.059484, -0.250918, -0.284263>, <-0.065142, -0.252412, -0.236198>, 
      <-0.050388, -0.249109, -0.398827>, <-0.055595, -0.248242, -0.350695>, <-0.087298, -0.257970, -0.285676>, <-0.092956, -0.259464, -0.237610>, 
      <-0.071275, -0.263564, -0.415710>, <-0.092319, -0.262697, -0.356830>, <-0.120362, -0.269830, -0.291209>, <-0.130494, -0.266531, -0.229589>, 
      <-0.088870, -0.272790, -0.425257>, <-0.109914, -0.271922, -0.366377>, <-0.148886, -0.273196, -0.290609>, <-0.159018, -0.269897, -0.228990>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.112271, -0.266127, -0.523417>, <-0.135838, -0.266127, -0.516671>, <-0.167260, -0.266127, -0.507675>, <-0.190826, -0.266127, -0.500929>, 
      <-0.116819, -0.266127, -0.503178>, <-0.140386, -0.266127, -0.496431>, <-0.167260, -0.266127, -0.499514>, <-0.190826, -0.266127, -0.492768>, 
      <-0.122884, -0.266127, -0.476192>, <-0.141902, -0.266127, -0.481524>, <-0.171808, -0.266127, -0.476555>, <-0.190826, -0.266127, -0.481886>, 
      <-0.127432, -0.266127, -0.455953>, <-0.146450, -0.266127, -0.461285>, <-0.171808, -0.266127, -0.468393>, <-0.190826, -0.266127, -0.473725>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.270035, -0.266127, -0.473725>, <-0.246272, -0.266127, -0.473725>, <-0.214589, -0.266127, -0.473725>, <-0.190826, -0.266127, -0.473725>, 
      <-0.270035, -0.266127, -0.481886>, <-0.246272, -0.266127, -0.481886>, <-0.214589, -0.266127, -0.481886>, <-0.190826, -0.266127, -0.481886>, 
      <-0.270035, -0.266127, -0.492768>, <-0.246272, -0.266127, -0.492768>, <-0.214589, -0.266127, -0.492768>, <-0.190826, -0.266127, -0.492768>, 
      <-0.270035, -0.266127, -0.500929>, <-0.246272, -0.266127, -0.500929>, <-0.214589, -0.266127, -0.500929>, <-0.190826, -0.266127, -0.500929>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.333430, -0.266127, -0.455953>, <-0.314412, -0.266127, -0.461285>, <-0.289054, -0.266127, -0.468393>, <-0.270035, -0.266127, -0.473725>, 
      <-0.337978, -0.266127, -0.476192>, <-0.318959, -0.266127, -0.481524>, <-0.289054, -0.266127, -0.476555>, <-0.270035, -0.266127, -0.481886>, 
      <-0.344041, -0.266127, -0.503178>, <-0.320475, -0.266127, -0.496431>, <-0.293601, -0.266127, -0.499514>, <-0.270035, -0.266127, -0.492768>, 
      <-0.348589, -0.266127, -0.523417>, <-0.325023, -0.266127, -0.516671>, <-0.293601, -0.266127, -0.507675>, <-0.270035, -0.266127, -0.500929>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.285195, -0.266127, -0.523417>, <-0.304213, -0.266127, -0.523417>, <-0.329571, -0.266127, -0.523417>, <-0.348589, -0.266127, -0.523417>, 
      <-0.285195, -0.266127, -0.523417>, <-0.299665, -0.266127, -0.516671>, <-0.306005, -0.266127, -0.516671>, <-0.325023, -0.266127, -0.516671>, 
      <-0.285195, -0.266127, -0.523417>, <-0.299665, -0.266127, -0.516671>, <-0.298149, -0.266127, -0.514422>, <-0.293601, -0.266127, -0.507675>, 
      <-0.285195, -0.266127, -0.523417>, <-0.280647, -0.266127, -0.516671>, <-0.274583, -0.266127, -0.507675>, <-0.270035, -0.266127, -0.500929>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.261117, -0.266127, -0.455953>, <-0.263792, -0.266127, -0.461285>, <-0.267360, -0.266127, -0.468393>, <-0.270035, -0.266127, -0.473725>, 
      <-0.261117, -0.266127, -0.455953>, <-0.285486, -0.266127, -0.461285>, <-0.286378, -0.266127, -0.463062>, <-0.289054, -0.266127, -0.468393>, 
      <-0.261117, -0.266127, -0.455953>, <-0.285486, -0.266127, -0.461285>, <-0.292718, -0.266127, -0.461285>, <-0.314412, -0.266127, -0.461285>, 
      <-0.261117, -0.266127, -0.455953>, <-0.282811, -0.266127, -0.455953>, <-0.311736, -0.266127, -0.455953>, <-0.333430, -0.266127, -0.455953>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.199743, -0.266127, -0.455953>, <-0.178050, -0.266127, -0.455953>, <-0.149125, -0.266127, -0.455953>, <-0.127432, -0.266127, -0.455953>, 
      <-0.199743, -0.266127, -0.455953>, <-0.175375, -0.266127, -0.461285>, <-0.168144, -0.266127, -0.461285>, <-0.146450, -0.266127, -0.461285>, 
      <-0.199743, -0.266127, -0.455953>, <-0.175375, -0.266127, -0.461285>, <-0.174483, -0.266127, -0.463062>, <-0.171808, -0.266127, -0.468393>, 
      <-0.199743, -0.266127, -0.455953>, <-0.197068, -0.266127, -0.461285>, <-0.193501, -0.266127, -0.468393>, <-0.190826, -0.266127, -0.473725>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.175665, -0.266127, -0.523417>, <-0.180213, -0.266127, -0.516671>, <-0.186278, -0.266127, -0.507675>, <-0.190826, -0.266127, -0.500929>, 
      <-0.175665, -0.266127, -0.523417>, <-0.161195, -0.266127, -0.516671>, <-0.162711, -0.266127, -0.514422>, <-0.167260, -0.266127, -0.507675>, 
      <-0.175665, -0.266127, -0.523417>, <-0.161195, -0.266127, -0.516671>, <-0.154856, -0.266127, -0.516671>, <-0.135838, -0.266127, -0.516671>, 
      <-0.175665, -0.266127, -0.523417>, <-0.156647, -0.266127, -0.523417>, <-0.131289, -0.266127, -0.523417>, <-0.112271, -0.266127, -0.523417>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.348589, -0.247580, -0.523417>, <-0.348589, -0.253144, -0.523417>, <-0.348589, -0.260563, -0.523417>, <-0.348589, -0.266127, -0.523417>, 
      <-0.329571, -0.247580, -0.523417>, <-0.329571, -0.253144, -0.523417>, <-0.329571, -0.260563, -0.523417>, <-0.329571, -0.266127, -0.523417>, 
      <-0.304213, -0.247580, -0.523417>, <-0.304213, -0.253144, -0.523417>, <-0.304213, -0.260563, -0.523417>, <-0.304213, -0.266127, -0.523417>, 
      <-0.285195, -0.247580, -0.523417>, <-0.285195, -0.253144, -0.523417>, <-0.285195, -0.260563, -0.523417>, <-0.285195, -0.266127, -0.523417>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.333430, -0.247580, -0.455953>, <-0.333430, -0.253144, -0.455953>, <-0.333430, -0.260563, -0.455953>, <-0.333430, -0.266127, -0.455953>, 
      <-0.337978, -0.247580, -0.476192>, <-0.337978, -0.253144, -0.476192>, <-0.337978, -0.260563, -0.476192>, <-0.337978, -0.266127, -0.476192>, 
      <-0.344041, -0.247580, -0.503178>, <-0.344041, -0.253144, -0.503178>, <-0.344041, -0.260563, -0.503178>, <-0.344041, -0.266127, -0.503178>, 
      <-0.348589, -0.247580, -0.523417>, <-0.348589, -0.253144, -0.523417>, <-0.348589, -0.260563, -0.523417>, <-0.348589, -0.266127, -0.523417>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.261117, -0.247580, -0.455953>, <-0.261117, -0.253144, -0.455953>, <-0.261117, -0.260563, -0.455953>, <-0.261117, -0.266127, -0.455953>, 
      <-0.282811, -0.247580, -0.455953>, <-0.282811, -0.253144, -0.455953>, <-0.282811, -0.260563, -0.455953>, <-0.282811, -0.266127, -0.455953>, 
      <-0.311736, -0.247580, -0.455953>, <-0.311736, -0.253144, -0.455953>, <-0.311736, -0.260563, -0.455953>, <-0.311736, -0.266127, -0.455953>, 
      <-0.333430, -0.247580, -0.455953>, <-0.333430, -0.253144, -0.455953>, <-0.333430, -0.260563, -0.455953>, <-0.333430, -0.266127, -0.455953>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.270035, -0.247580, -0.473725>, <-0.270035, -0.253144, -0.473725>, <-0.270035, -0.260563, -0.473725>, <-0.270035, -0.266127, -0.473725>, 
      <-0.267360, -0.247580, -0.468393>, <-0.267360, -0.253144, -0.468393>, <-0.267360, -0.260563, -0.468393>, <-0.267360, -0.266127, -0.468393>, 
      <-0.263792, -0.247580, -0.461285>, <-0.263792, -0.253144, -0.461285>, <-0.263792, -0.260563, -0.461285>, <-0.263792, -0.266127, -0.461285>, 
      <-0.261117, -0.247580, -0.455953>, <-0.261117, -0.253144, -0.455953>, <-0.261117, -0.260563, -0.455953>, <-0.261117, -0.266127, -0.455953>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.190826, -0.247580, -0.473725>, <-0.190826, -0.253144, -0.473725>, <-0.190826, -0.260563, -0.473725>, <-0.190826, -0.266127, -0.473725>, 
      <-0.214589, -0.247580, -0.473725>, <-0.214589, -0.253144, -0.473725>, <-0.214589, -0.260563, -0.473725>, <-0.214589, -0.266127, -0.473725>, 
      <-0.246272, -0.247580, -0.473725>, <-0.246272, -0.253144, -0.473725>, <-0.246272, -0.260563, -0.473725>, <-0.246272, -0.266127, -0.473725>, 
      <-0.270035, -0.247580, -0.473725>, <-0.270035, -0.253144, -0.473725>, <-0.270035, -0.260563, -0.473725>, <-0.270035, -0.266127, -0.473725>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.199743, -0.247580, -0.455953>, <-0.199743, -0.253144, -0.455953>, <-0.199743, -0.260563, -0.455953>, <-0.199743, -0.266127, -0.455953>, 
      <-0.197068, -0.247580, -0.461285>, <-0.197068, -0.253144, -0.461285>, <-0.197068, -0.260563, -0.461285>, <-0.197068, -0.266127, -0.461285>, 
      <-0.193501, -0.247580, -0.468393>, <-0.193501, -0.253144, -0.468393>, <-0.193501, -0.260563, -0.468393>, <-0.193501, -0.266127, -0.468393>, 
      <-0.190826, -0.247580, -0.473725>, <-0.190826, -0.253144, -0.473725>, <-0.190826, -0.260563, -0.473725>, <-0.190826, -0.266127, -0.473725>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.127432, -0.247580, -0.455953>, <-0.127432, -0.253144, -0.455953>, <-0.127432, -0.260563, -0.455953>, <-0.127432, -0.266127, -0.455953>, 
      <-0.149125, -0.247580, -0.455953>, <-0.149125, -0.253144, -0.455953>, <-0.149125, -0.260563, -0.455953>, <-0.149125, -0.266127, -0.455953>, 
      <-0.178050, -0.247580, -0.455953>, <-0.178050, -0.253144, -0.455953>, <-0.178050, -0.260563, -0.455953>, <-0.178050, -0.266127, -0.455953>, 
      <-0.199743, -0.247580, -0.455953>, <-0.199743, -0.253144, -0.455953>, <-0.199743, -0.260563, -0.455953>, <-0.199743, -0.266127, -0.455953>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.112271, -0.247580, -0.523417>, <-0.112271, -0.253144, -0.523417>, <-0.112271, -0.260563, -0.523417>, <-0.112271, -0.266127, -0.523417>, 
      <-0.116819, -0.247580, -0.503178>, <-0.116819, -0.253144, -0.503178>, <-0.116819, -0.260563, -0.503178>, <-0.116819, -0.266127, -0.503178>, 
      <-0.122884, -0.247580, -0.476192>, <-0.122884, -0.253144, -0.476192>, <-0.122884, -0.260563, -0.476192>, <-0.122884, -0.266127, -0.476192>, 
      <-0.127432, -0.247580, -0.455953>, <-0.127432, -0.253144, -0.455953>, <-0.127432, -0.260563, -0.455953>, <-0.127432, -0.266127, -0.455953>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.175665, -0.247580, -0.523417>, <-0.175665, -0.253144, -0.523417>, <-0.175665, -0.260563, -0.523417>, <-0.175665, -0.266127, -0.523417>, 
      <-0.156647, -0.247580, -0.523417>, <-0.156647, -0.253144, -0.523417>, <-0.156647, -0.260563, -0.523417>, <-0.156647, -0.266127, -0.523417>, 
      <-0.131289, -0.247580, -0.523417>, <-0.131289, -0.253144, -0.523417>, <-0.131289, -0.260563, -0.523417>, <-0.131289, -0.266127, -0.523417>, 
      <-0.112271, -0.247580, -0.523417>, <-0.112271, -0.253144, -0.523417>, <-0.112271, -0.260563, -0.523417>, <-0.112271, -0.266127, -0.523417>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.190826, -0.247580, -0.500929>, <-0.190826, -0.253144, -0.500929>, <-0.190826, -0.260563, -0.500929>, <-0.190826, -0.266127, -0.500929>, 
      <-0.186278, -0.247580, -0.507675>, <-0.186278, -0.253144, -0.507675>, <-0.186278, -0.260563, -0.507675>, <-0.186278, -0.266127, -0.507675>, 
      <-0.180213, -0.247580, -0.516671>, <-0.180213, -0.253144, -0.516671>, <-0.180213, -0.260563, -0.516671>, <-0.180213, -0.266127, -0.516671>, 
      <-0.175665, -0.247580, -0.523417>, <-0.175665, -0.253144, -0.523417>, <-0.175665, -0.260563, -0.523417>, <-0.175665, -0.266127, -0.523417>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.270035, -0.247580, -0.500929>, <-0.270035, -0.253144, -0.500929>, <-0.270035, -0.260563, -0.500929>, <-0.270035, -0.266127, -0.500929>, 
      <-0.246272, -0.247580, -0.500929>, <-0.246272, -0.253144, -0.500929>, <-0.246272, -0.260563, -0.500929>, <-0.246272, -0.266127, -0.500929>, 
      <-0.214589, -0.247580, -0.500929>, <-0.214589, -0.253144, -0.500929>, <-0.214589, -0.260563, -0.500929>, <-0.214589, -0.266127, -0.500929>, 
      <-0.190826, -0.247580, -0.500929>, <-0.190826, -0.253144, -0.500929>, <-0.190826, -0.260563, -0.500929>, <-0.190826, -0.266127, -0.500929>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.270035, -0.247580, -0.500929>, <-0.274583, -0.247580, -0.507675>, <-0.280647, -0.247580, -0.516671>, <-0.285195, -0.247580, -0.523417>, 
      <-0.270035, -0.253144, -0.500929>, <-0.274583, -0.253144, -0.507675>, <-0.280647, -0.253144, -0.516671>, <-0.285195, -0.253144, -0.523417>, 
      <-0.270035, -0.260563, -0.500929>, <-0.274583, -0.260563, -0.507675>, <-0.280647, -0.260563, -0.516671>, <-0.285195, -0.260563, -0.523417>, 
      <-0.270035, -0.266127, -0.500929>, <-0.274583, -0.266127, -0.507675>, <-0.280647, -0.266127, -0.516671>, <-0.285195, -0.266127, -0.523417>
    }
  }
  texture {
    Shiny_White
  }
}
#declare Ears = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.835632, 0.479682, -0.116346>, <-0.830685, 0.480455, -0.116561>, <-0.824791, 0.483864, -0.113142>, <-0.819780, 0.483864, -0.113142>, 
      <-0.835632, 0.479682, -0.120477>, <-0.830685, 0.480455, -0.120692>, <-0.824484, 0.489590, -0.113539>, <-0.819472, 0.489590, -0.113539>, 
      <-0.835632, 0.479682, -0.125984>, <-0.830943, 0.480269, -0.125589>, <-0.824721, 0.488694, -0.131918>, <-0.819979, 0.488694, -0.131918>, 
      <-0.835632, 0.479682, -0.130115>, <-0.830943, 0.480269, -0.129720>, <-0.825065, 0.482968, -0.132272>, <-0.820323, 0.482968, -0.132272>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.835632, 0.479682, -0.116346>, <-0.835632, 0.479682, -0.120477>, <-0.835632, 0.479682, -0.125984>, <-0.835632, 0.479682, -0.130115>, 
      <-0.848460, 0.371931, -0.113922>, <-0.848460, 0.371931, -0.118052>, <-0.848460, 0.371931, -0.128409>, <-0.848460, 0.371931, -0.132539>, 
      <-0.865565, 0.228262, -0.110689>, <-0.865565, 0.228262, -0.119669>, <-0.865565, 0.228262, -0.126792>, <-0.865565, 0.228262, -0.135772>, 
      <-0.878393, 0.120511, -0.108265>, <-0.878393, 0.120511, -0.117244>, <-0.878393, 0.120511, -0.129217>, <-0.878393, 0.120511, -0.138196>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.801180, 0.479682, -0.116346>, <-0.801180, 0.479682, -0.120477>, <-0.801180, 0.479682, -0.125984>, <-0.801180, 0.479682, -0.130115>, 
      <-0.806918, 0.480495, -0.116572>, <-0.806918, 0.480495, -0.120703>, <-0.806993, 0.480317, -0.125557>, <-0.806993, 0.480317, -0.129688>, 
      <-0.813981, 0.483864, -0.113142>, <-0.813673, 0.489590, -0.113539>, <-0.814117, 0.488694, -0.131918>, <-0.814460, 0.482968, -0.132272>, 
      <-0.819780, 0.483864, -0.113142>, <-0.819472, 0.489590, -0.113539>, <-0.819979, 0.488694, -0.131918>, <-0.820323, 0.482968, -0.132272>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.801180, 0.479682, -0.116346>, <-0.801180, 0.479682, -0.120477>, <-0.801180, 0.479682, -0.125984>, <-0.801180, 0.479682, -0.130115>, 
      <-0.801877, 0.371931, -0.113922>, <-0.801877, 0.371931, -0.118052>, <-0.801877, 0.371931, -0.128409>, <-0.801877, 0.371931, -0.132539>, 
      <-0.802806, 0.228262, -0.110689>, <-0.802806, 0.228262, -0.119669>, <-0.802806, 0.228262, -0.126792>, <-0.802806, 0.228262, -0.135772>, 
      <-0.803503, 0.120511, -0.108265>, <-0.803503, 0.120511, -0.117244>, <-0.803503, 0.120511, -0.129217>, <-0.803503, 0.120511, -0.138196>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.835632, 0.479682, -0.157653>, <-0.835632, 0.479682, -0.161784>, <-0.835632, 0.479682, -0.167291>, <-0.835632, 0.479682, -0.171422>, 
      <-0.831845, 0.479673, -0.154317>, <-0.831845, 0.479673, -0.158448>, <-0.832539, 0.480122, -0.163728>, <-0.832539, 0.480122, -0.167859>, 
      <-0.824036, 0.479620, -0.155203>, <-0.823761, 0.484706, -0.154871>, <-0.824728, 0.488426, -0.170771>, <-0.825028, 0.483423, -0.171734>, 
      <-0.818989, 0.479620, -0.155203>, <-0.818714, 0.484706, -0.154871>, <-0.819990, 0.488426, -0.170771>, <-0.820289, 0.483423, -0.171734>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.835632, 0.479682, -0.157653>, <-0.835632, 0.479682, -0.149392>, <-0.835632, 0.479682, -0.138376>, <-0.835632, 0.479682, -0.130115>, 
      <-0.831845, 0.479673, -0.154317>, <-0.831845, 0.479673, -0.146056>, <-0.830943, 0.480269, -0.137981>, <-0.830943, 0.480269, -0.129720>, 
      <-0.824036, 0.479620, -0.155203>, <-0.824436, 0.480624, -0.148324>, <-0.824665, 0.481964, -0.139151>, <-0.825065, 0.482968, -0.132272>, 
      <-0.818989, 0.479620, -0.155203>, <-0.819389, 0.480624, -0.148324>, <-0.819923, 0.481964, -0.139151>, <-0.820323, 0.482968, -0.132272>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.878393, 0.120511, -0.198057>, <-0.878393, 0.120511, -0.207036>, <-0.878393, 0.120511, -0.219009>, <-0.878393, 0.120511, -0.227988>, 
      <-0.865565, 0.228262, -0.185936>, <-0.865565, 0.228262, -0.194915>, <-0.865565, 0.228262, -0.202039>, <-0.865565, 0.228262, -0.211018>, 
      <-0.848460, 0.371931, -0.169774>, <-0.848460, 0.371931, -0.173905>, <-0.848460, 0.371931, -0.184261>, <-0.848460, 0.371931, -0.188392>, 
      <-0.835632, 0.479682, -0.157653>, <-0.835632, 0.479682, -0.161784>, <-0.835632, 0.479682, -0.167291>, <-0.835632, 0.479682, -0.171422>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.878393, 0.120511, -0.198057>, <-0.865565, 0.228262, -0.185936>, <-0.848460, 0.371931, -0.169774>, <-0.835632, 0.479682, -0.157653>, 
      <-0.878393, 0.120511, -0.180099>, <-0.865565, 0.228262, -0.167978>, <-0.848460, 0.371931, -0.161513>, <-0.835632, 0.479682, -0.149392>, 
      <-0.878393, 0.120511, -0.156154>, <-0.865565, 0.228262, -0.153730>, <-0.848460, 0.371931, -0.140801>, <-0.835632, 0.479682, -0.138376>, 
      <-0.878393, 0.120511, -0.138196>, <-0.865565, 0.228262, -0.135772>, <-0.848460, 0.371931, -0.132539>, <-0.835632, 0.479682, -0.130115>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.801180, 0.479682, -0.157653>, <-0.805299, 0.479673, -0.154172>, <-0.813596, 0.479620, -0.155203>, <-0.818989, 0.479620, -0.155203>, 
      <-0.801180, 0.479682, -0.149392>, <-0.805299, 0.479673, -0.145910>, <-0.813996, 0.480624, -0.148324>, <-0.819389, 0.480624, -0.148324>, 
      <-0.801180, 0.479682, -0.138376>, <-0.806993, 0.480317, -0.137949>, <-0.814060, 0.481964, -0.139151>, <-0.819923, 0.481964, -0.139151>, 
      <-0.801180, 0.479682, -0.130115>, <-0.806993, 0.480317, -0.129688>, <-0.814460, 0.482968, -0.132272>, <-0.820323, 0.482968, -0.132272>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.801180, 0.479682, -0.157653>, <-0.805299, 0.479673, -0.154172>, <-0.813596, 0.479620, -0.155203>, <-0.818989, 0.479620, -0.155203>, 
      <-0.801180, 0.479682, -0.161784>, <-0.805299, 0.479673, -0.158302>, <-0.813321, 0.484706, -0.154871>, <-0.818714, 0.484706, -0.154871>, 
      <-0.801180, 0.479682, -0.167291>, <-0.805280, 0.480193, -0.163161>, <-0.814148, 0.488426, -0.170771>, <-0.819990, 0.488426, -0.170771>, 
      <-0.801180, 0.479682, -0.171422>, <-0.805280, 0.480193, -0.167291>, <-0.814447, 0.483423, -0.171734>, <-0.820289, 0.483423, -0.171734>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.803503, 0.120511, -0.198057>, <-0.803503, 0.120511, -0.180099>, <-0.803503, 0.120511, -0.156154>, <-0.803503, 0.120511, -0.138196>, 
      <-0.802806, 0.228262, -0.185936>, <-0.802806, 0.228262, -0.167978>, <-0.802806, 0.228262, -0.153730>, <-0.802806, 0.228262, -0.135772>, 
      <-0.801877, 0.371931, -0.169774>, <-0.801877, 0.371931, -0.161513>, <-0.801877, 0.371931, -0.140801>, <-0.801877, 0.371931, -0.132539>, 
      <-0.801180, 0.479682, -0.157653>, <-0.801180, 0.479682, -0.149392>, <-0.801180, 0.479682, -0.138376>, <-0.801180, 0.479682, -0.130115>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.803503, 0.120511, -0.198057>, <-0.802806, 0.228262, -0.185936>, <-0.801877, 0.371931, -0.169774>, <-0.801180, 0.479682, -0.157653>, 
      <-0.803503, 0.120511, -0.207036>, <-0.802806, 0.228262, -0.194915>, <-0.801877, 0.371931, -0.173905>, <-0.801180, 0.479682, -0.161784>, 
      <-0.803503, 0.120511, -0.219009>, <-0.802806, 0.228262, -0.202039>, <-0.801877, 0.371931, -0.184261>, <-0.801180, 0.479682, -0.167291>, 
      <-0.803503, 0.120511, -0.227988>, <-0.802806, 0.228262, -0.211018>, <-0.801877, 0.371931, -0.188392>, <-0.801180, 0.479682, -0.171422>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.835632, 0.479682, -0.088807>, <-0.835632, 0.479682, -0.097069>, <-0.835632, 0.479682, -0.108084>, <-0.835632, 0.479682, -0.116346>, 
      <-0.832065, 0.479498, -0.092236>, <-0.832065, 0.479498, -0.100498>, <-0.830685, 0.480455, -0.108300>, <-0.830685, 0.480455, -0.116561>, 
      <-0.824631, 0.478296, -0.092809>, <-0.824661, 0.479966, -0.098909>, <-0.824761, 0.482194, -0.107042>, <-0.824791, 0.483864, -0.113142>, 
      <-0.819680, 0.478296, -0.092809>, <-0.819710, 0.479966, -0.098909>, <-0.819750, 0.482194, -0.107042>, <-0.819780, 0.483864, -0.113142>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.835632, 0.479682, -0.088807>, <-0.835632, 0.479682, -0.097069>, <-0.835632, 0.479682, -0.108084>, <-0.835632, 0.479682, -0.116346>, 
      <-0.848460, 0.371931, -0.076686>, <-0.848460, 0.371931, -0.084947>, <-0.848460, 0.371931, -0.105660>, <-0.848460, 0.371931, -0.113922>, 
      <-0.865565, 0.228262, -0.060524>, <-0.865565, 0.228262, -0.078483>, <-0.865565, 0.228262, -0.092731>, <-0.865565, 0.228262, -0.110689>, 
      <-0.878393, 0.120511, -0.048403>, <-0.878393, 0.120511, -0.066362>, <-0.878393, 0.120511, -0.090306>, <-0.878393, 0.120511, -0.108265>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.801180, 0.479682, -0.088807>, <-0.805455, 0.479481, -0.092562>, <-0.813986, 0.478296, -0.092809>, <-0.819680, 0.478296, -0.092809>, 
      <-0.801180, 0.479682, -0.097069>, <-0.805455, 0.479481, -0.100823>, <-0.814016, 0.479966, -0.098909>, <-0.819710, 0.479966, -0.098909>, 
      <-0.801180, 0.479682, -0.108084>, <-0.806918, 0.480495, -0.108311>, <-0.813951, 0.482194, -0.107042>, <-0.819750, 0.482194, -0.107042>, 
      <-0.801180, 0.479682, -0.116346>, <-0.806918, 0.480495, -0.116572>, <-0.813981, 0.483864, -0.113142>, <-0.819780, 0.483864, -0.113142>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.801180, 0.479682, -0.088807>, <-0.801180, 0.479682, -0.097069>, <-0.801180, 0.479682, -0.108084>, <-0.801180, 0.479682, -0.116346>, 
      <-0.801877, 0.371931, -0.076686>, <-0.801877, 0.371931, -0.084947>, <-0.801877, 0.371931, -0.105660>, <-0.801877, 0.371931, -0.113922>, 
      <-0.802806, 0.228262, -0.060524>, <-0.802806, 0.228262, -0.078483>, <-0.802806, 0.228262, -0.092731>, <-0.802806, 0.228262, -0.110689>, 
      <-0.803503, 0.120511, -0.048403>, <-0.803503, 0.120511, -0.066362>, <-0.803503, 0.120511, -0.090306>, <-0.803503, 0.120511, -0.108265>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.801180, 0.479682, -0.075038>, <-0.804381, 0.479724, -0.079355>, <-0.812452, 0.480040, -0.081652>, <-0.817827, 0.480040, -0.081652>, 
      <-0.801180, 0.479682, -0.079169>, <-0.804381, 0.479724, -0.083486>, <-0.812262, 0.483407, -0.082297>, <-0.817637, 0.483407, -0.082297>, 
      <-0.801180, 0.479682, -0.084676>, <-0.805455, 0.479481, -0.088431>, <-0.813794, 0.481710, -0.093116>, <-0.819487, 0.481710, -0.093116>, 
      <-0.801180, 0.479682, -0.088807>, <-0.805455, 0.479481, -0.092562>, <-0.813986, 0.478296, -0.092809>, <-0.819680, 0.478296, -0.092809>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.801180, 0.479682, -0.075038>, <-0.801180, 0.479682, -0.079169>, <-0.801180, 0.479682, -0.084676>, <-0.801180, 0.479682, -0.088807>, 
      <-0.801877, 0.371931, -0.058068>, <-0.801877, 0.371931, -0.062199>, <-0.801877, 0.371931, -0.072555>, <-0.801877, 0.371931, -0.076686>, 
      <-0.802806, 0.228262, -0.035442>, <-0.802806, 0.228262, -0.044421>, <-0.802806, 0.228262, -0.051545>, <-0.802806, 0.228262, -0.060524>, 
      <-0.803503, 0.120511, -0.018472>, <-0.803503, 0.120511, -0.027451>, <-0.803503, 0.120511, -0.039424>, <-0.803503, 0.120511, -0.048403>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.835632, 0.479682, -0.075038>, <-0.835632, 0.479682, -0.079169>, <-0.835632, 0.479682, -0.084676>, <-0.835632, 0.479682, -0.088807>, 
      <-0.832148, 0.479725, -0.079548>, <-0.832148, 0.479725, -0.083679>, <-0.832065, 0.479498, -0.088106>, <-0.832065, 0.479498, -0.092236>, 
      <-0.823526, 0.480040, -0.081652>, <-0.823336, 0.483407, -0.082297>, <-0.824438, 0.481710, -0.093116>, <-0.824631, 0.478296, -0.092809>, 
      <-0.817827, 0.480040, -0.081652>, <-0.817637, 0.483407, -0.082297>, <-0.819487, 0.481710, -0.093116>, <-0.819680, 0.478296, -0.092809>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.835632, 0.479682, -0.075038>, <-0.848460, 0.371931, -0.058068>, <-0.865565, 0.228262, -0.035442>, <-0.878393, 0.120511, -0.018472>, 
      <-0.835632, 0.479682, -0.079169>, <-0.848460, 0.371931, -0.062199>, <-0.865565, 0.228262, -0.044421>, <-0.878393, 0.120511, -0.027451>, 
      <-0.835632, 0.479682, -0.084676>, <-0.848460, 0.371931, -0.072555>, <-0.865565, 0.228262, -0.051545>, <-0.878393, 0.120511, -0.039424>, 
      <-0.835632, 0.479682, -0.088807>, <-0.848460, 0.371931, -0.076686>, <-0.865565, 0.228262, -0.060524>, <-0.878393, 0.120511, -0.048403>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.839886, 0.120511, -0.195444>, <-0.833519, 0.226960, -0.174965>, <-0.824832, 0.371420, -0.162272>, <-0.818989, 0.479620, -0.155203>, 
      <-0.851465, 0.120511, -0.195444>, <-0.845098, 0.226960, -0.174965>, <-0.829878, 0.371420, -0.162272>, <-0.824036, 0.479620, -0.155203>, 
      <-0.867251, 0.120511, -0.194908>, <-0.854422, 0.228262, -0.182787>, <-0.844673, 0.371922, -0.166438>, <-0.831845, 0.479673, -0.154317>, 
      <-0.878393, 0.120511, -0.198057>, <-0.865565, 0.228262, -0.185936>, <-0.848460, 0.371931, -0.169774>, <-0.835632, 0.479682, -0.157653>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.839886, 0.120511, -0.195444>, <-0.833519, 0.226960, -0.174965>, <-0.824832, 0.371420, -0.162272>, <-0.818989, 0.479620, -0.155203>, 
      <-0.828943, 0.120511, -0.195444>, <-0.822576, 0.226960, -0.174965>, <-0.819439, 0.371420, -0.162272>, <-0.813596, 0.479620, -0.155203>, 
      <-0.814007, 0.120511, -0.194989>, <-0.813310, 0.228262, -0.182867>, <-0.805996, 0.371922, -0.166293>, <-0.805299, 0.479673, -0.154172>, 
      <-0.803503, 0.120511, -0.198057>, <-0.802806, 0.228262, -0.185936>, <-0.801877, 0.371931, -0.169774>, <-0.801180, 0.479682, -0.157653>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.841444, 0.122774, -0.135469>, <-0.852580, 0.122774, -0.135469>, <-0.867312, 0.120906, -0.137170>, <-0.878393, 0.120511, -0.138196>, 
      <-0.835649, 0.230607, -0.142952>, <-0.846784, 0.230607, -0.142952>, <-0.854483, 0.228657, -0.134746>, <-0.865565, 0.228262, -0.135772>, 
      <-0.826793, 0.375119, -0.138940>, <-0.831535, 0.375119, -0.138940>, <-0.843772, 0.372518, -0.132144>, <-0.848460, 0.371931, -0.132539>, 
      <-0.820323, 0.482968, -0.132272>, <-0.825065, 0.482968, -0.132272>, <-0.830943, 0.480269, -0.129720>, <-0.835632, 0.479682, -0.130115>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.841444, 0.122774, -0.135469>, <-0.835649, 0.230607, -0.142952>, <-0.826793, 0.375119, -0.138940>, <-0.820323, 0.482968, -0.132272>, 
      <-0.830012, 0.122774, -0.135469>, <-0.824217, 0.230607, -0.142952>, <-0.820931, 0.375119, -0.138940>, <-0.814460, 0.482968, -0.132272>, 
      <-0.814881, 0.120910, -0.137159>, <-0.814184, 0.228661, -0.134735>, <-0.807689, 0.372566, -0.132112>, <-0.806993, 0.480317, -0.129688>, 
      <-0.803503, 0.120511, -0.138196>, <-0.802806, 0.228262, -0.135772>, <-0.801877, 0.371931, -0.132539>, <-0.801180, 0.479682, -0.130115>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.839681, 0.122765, -0.107276>, <-0.851318, 0.122765, -0.107276>, <-0.866769, 0.120912, -0.108651>, <-0.878393, 0.120511, -0.108265>, 
      <-0.840188, 0.114322, -0.107798>, <-0.851825, 0.114322, -0.107798>, <-0.866769, 0.120912, -0.117630>, <-0.878393, 0.120511, -0.117244>, 
      <-0.841898, 0.114332, -0.134883>, <-0.853033, 0.114332, -0.134883>, <-0.867312, 0.120906, -0.128191>, <-0.878393, 0.120511, -0.129217>, 
      <-0.841444, 0.122774, -0.135469>, <-0.852580, 0.122774, -0.135469>, <-0.867312, 0.120906, -0.137170>, <-0.878393, 0.120511, -0.138196>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.839681, 0.122765, -0.107276>, <-0.833195, 0.230873, -0.100592>, <-0.825589, 0.375771, -0.105641>, <-0.819780, 0.483864, -0.113142>, 
      <-0.851318, 0.122765, -0.107276>, <-0.844832, 0.230873, -0.100592>, <-0.830600, 0.375771, -0.105641>, <-0.824791, 0.483864, -0.113142>, 
      <-0.866769, 0.120912, -0.108651>, <-0.853941, 0.228663, -0.111075>, <-0.843514, 0.372703, -0.114137>, <-0.830685, 0.480455, -0.116561>, 
      <-0.878393, 0.120511, -0.108265>, <-0.865565, 0.228262, -0.110689>, <-0.848460, 0.371931, -0.113922>, <-0.835632, 0.479682, -0.116346>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.839681, 0.122765, -0.107276>, <-0.840188, 0.114322, -0.107798>, <-0.841898, 0.114332, -0.134883>, <-0.841444, 0.122774, -0.135469>, 
      <-0.828803, 0.122765, -0.107276>, <-0.829309, 0.114322, -0.107798>, <-0.830466, 0.114332, -0.134883>, <-0.830012, 0.122774, -0.135469>, 
      <-0.814368, 0.120901, -0.108640>, <-0.814368, 0.120901, -0.117620>, <-0.814881, 0.120910, -0.128180>, <-0.814881, 0.120910, -0.137159>, 
      <-0.803503, 0.120511, -0.108265>, <-0.803503, 0.120511, -0.117244>, <-0.803503, 0.120511, -0.129217>, <-0.803503, 0.120511, -0.138196>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.839681, 0.122765, -0.107276>, <-0.828803, 0.122765, -0.107276>, <-0.814368, 0.120901, -0.108640>, <-0.803503, 0.120511, -0.108265>, 
      <-0.833195, 0.230873, -0.100592>, <-0.822317, 0.230873, -0.100592>, <-0.813671, 0.228652, -0.111065>, <-0.802806, 0.228262, -0.110689>, 
      <-0.825589, 0.375771, -0.105641>, <-0.819790, 0.375771, -0.105641>, <-0.807615, 0.372743, -0.114148>, <-0.801877, 0.371931, -0.113922>, 
      <-0.819780, 0.483864, -0.113142>, <-0.813981, 0.483864, -0.113142>, <-0.806918, 0.480495, -0.116572>, <-0.801180, 0.479682, -0.116346>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.838140, 0.120511, -0.049347>, <-0.832144, 0.226678, -0.069699>, <-0.825763, 0.370634, -0.083135>, <-0.819680, 0.478296, -0.092809>, 
      <-0.850219, 0.120511, -0.049347>, <-0.844223, 0.226678, -0.069699>, <-0.830714, 0.370634, -0.083135>, <-0.824631, 0.478296, -0.092809>, 
      <-0.866675, 0.120511, -0.051335>, <-0.853847, 0.228262, -0.063457>, <-0.844893, 0.371747, -0.080115>, <-0.832065, 0.479498, -0.092236>, 
      <-0.878393, 0.120511, -0.048403>, <-0.865565, 0.228262, -0.060524>, <-0.848460, 0.371931, -0.076686>, <-0.835632, 0.479682, -0.088807>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.838140, 0.120511, -0.049347>, <-0.832144, 0.226678, -0.069699>, <-0.825763, 0.370634, -0.083135>, <-0.819680, 0.478296, -0.092809>, 
      <-0.827745, 0.120511, -0.049347>, <-0.821749, 0.226678, -0.069699>, <-0.820069, 0.370634, -0.083135>, <-0.813986, 0.478296, -0.092809>, 
      <-0.813531, 0.120511, -0.051143>, <-0.812834, 0.228262, -0.063264>, <-0.806152, 0.371729, -0.080440>, <-0.805455, 0.479481, -0.092562>, 
      <-0.803503, 0.120511, -0.048403>, <-0.802806, 0.228262, -0.060524>, <-0.801877, 0.371931, -0.076686>, <-0.801180, 0.479682, -0.088807>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.839886, 0.120511, -0.024222>, <-0.840310, 0.112998, -0.023547>, <-0.838558, 0.113102, -0.047927>, <-0.838140, 0.120511, -0.049347>, 
      <-0.851566, 0.120511, -0.024222>, <-0.851991, 0.112998, -0.023547>, <-0.850638, 0.113102, -0.047927>, <-0.850219, 0.120511, -0.049347>, 
      <-0.867654, 0.120511, -0.023066>, <-0.867654, 0.120511, -0.032045>, <-0.866675, 0.120511, -0.042356>, <-0.866675, 0.120511, -0.051335>, 
      <-0.878393, 0.120511, -0.018472>, <-0.878393, 0.120511, -0.027451>, <-0.878393, 0.120511, -0.039424>, <-0.878393, 0.120511, -0.048403>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.839886, 0.120511, -0.024222>, <-0.851566, 0.120511, -0.024222>, <-0.867654, 0.120511, -0.023066>, <-0.878393, 0.120511, -0.018472>, 
      <-0.833738, 0.229326, -0.033999>, <-0.845418, 0.229326, -0.033999>, <-0.854826, 0.228262, -0.040035>, <-0.865565, 0.228262, -0.035442>, 
      <-0.823887, 0.372735, -0.061082>, <-0.829586, 0.372735, -0.061082>, <-0.844976, 0.371974, -0.062578>, <-0.848460, 0.371931, -0.058068>, 
      <-0.817827, 0.480040, -0.081652>, <-0.823526, 0.480040, -0.081652>, <-0.832148, 0.479725, -0.079548>, <-0.835632, 0.479682, -0.075038>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.839886, 0.120511, -0.024222>, <-0.840310, 0.112998, -0.023547>, <-0.838558, 0.113102, -0.047927>, <-0.838140, 0.120511, -0.049347>, 
      <-0.828836, 0.120511, -0.024222>, <-0.829260, 0.112998, -0.023547>, <-0.828164, 0.113102, -0.047927>, <-0.827745, 0.120511, -0.049347>, 
      <-0.813609, 0.120511, -0.022941>, <-0.813609, 0.120511, -0.031920>, <-0.813531, 0.120511, -0.042163>, <-0.813531, 0.120511, -0.051143>, 
      <-0.803503, 0.120511, -0.018472>, <-0.803503, 0.120511, -0.027451>, <-0.803503, 0.120511, -0.039424>, <-0.803503, 0.120511, -0.048403>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.839886, 0.120511, -0.024222>, <-0.833738, 0.229326, -0.033999>, <-0.823887, 0.372735, -0.061082>, <-0.817827, 0.480040, -0.081652>, 
      <-0.828836, 0.120511, -0.024222>, <-0.822688, 0.229326, -0.033999>, <-0.818512, 0.372735, -0.061082>, <-0.812452, 0.480040, -0.081652>, 
      <-0.813609, 0.120511, -0.022941>, <-0.812913, 0.228262, -0.039911>, <-0.805078, 0.371972, -0.062386>, <-0.804381, 0.479724, -0.079355>, 
      <-0.803503, 0.120511, -0.018472>, <-0.802806, 0.228262, -0.035442>, <-0.801877, 0.371931, -0.058068>, <-0.801180, 0.479682, -0.075038>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.790251, 0.479682, -0.066966>, <-0.791189, 0.486617, -0.069136>, <-0.795678, 0.479941, -0.083975>, <-0.801180, 0.479682, -0.088807>, 
      <-0.790251, 0.479682, -0.060214>, <-0.791189, 0.486617, -0.062384>, <-0.795678, 0.479941, -0.079845>, <-0.801180, 0.479682, -0.084676>, 
      <-0.790251, 0.479682, -0.051212>, <-0.791449, 0.488537, -0.055091>, <-0.795378, 0.479607, -0.071344>, <-0.801180, 0.479682, -0.079169>, 
      <-0.790251, 0.479682, -0.044460>, <-0.791449, 0.488537, -0.048340>, <-0.795378, 0.479607, -0.067213>, <-0.801180, 0.479682, -0.075038>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.790251, 0.479682, -0.111977>, <-0.790724, 0.483174, -0.112196>, <-0.797687, 0.479187, -0.116208>, <-0.801180, 0.479682, -0.116346>, 
      <-0.790251, 0.479682, -0.098474>, <-0.790724, 0.483174, -0.098692>, <-0.797687, 0.479187, -0.107947>, <-0.801180, 0.479682, -0.108084>, 
      <-0.790251, 0.479682, -0.080469>, <-0.791189, 0.486617, -0.082639>, <-0.795678, 0.479941, -0.092237>, <-0.801180, 0.479682, -0.097069>, 
      <-0.790251, 0.479682, -0.066966>, <-0.791189, 0.486617, -0.069136>, <-0.795678, 0.479941, -0.083975>, <-0.801180, 0.479682, -0.088807>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.790251, 0.479682, -0.134483>, <-0.790724, 0.483174, -0.134264>, <-0.797679, 0.479299, -0.130372>, <-0.801180, 0.479682, -0.130115>, 
      <-0.790251, 0.479682, -0.127731>, <-0.790724, 0.483174, -0.127513>, <-0.797679, 0.479299, -0.126242>, <-0.801180, 0.479682, -0.125984>, 
      <-0.790251, 0.479682, -0.118729>, <-0.790724, 0.483174, -0.118947>, <-0.797687, 0.479187, -0.120339>, <-0.801180, 0.479682, -0.120477>, 
      <-0.790251, 0.479682, -0.111977>, <-0.790724, 0.483174, -0.112196>, <-0.797687, 0.479187, -0.116208>, <-0.801180, 0.479682, -0.116346>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.790251, 0.479682, -0.179494>, <-0.791189, 0.486617, -0.177324>, <-0.795584, 0.479694, -0.162383>, <-0.801180, 0.479682, -0.157653>, 
      <-0.790251, 0.479682, -0.165991>, <-0.791189, 0.486617, -0.163821>, <-0.795584, 0.479694, -0.154121>, <-0.801180, 0.479682, -0.149392>, 
      <-0.790251, 0.479682, -0.147986>, <-0.790724, 0.483174, -0.147768>, <-0.797679, 0.479299, -0.138634>, <-0.801180, 0.479682, -0.138376>, 
      <-0.790251, 0.479682, -0.134483>, <-0.790724, 0.483174, -0.134264>, <-0.797679, 0.479299, -0.130372>, <-0.801180, 0.479682, -0.130115>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.790251, 0.479682, -0.202000>, <-0.791449, 0.488537, -0.198121>, <-0.794344, 0.478831, -0.178310>, <-0.801180, 0.479682, -0.171422>, 
      <-0.790251, 0.479682, -0.195248>, <-0.791449, 0.488537, -0.191369>, <-0.794344, 0.478831, -0.174179>, <-0.801180, 0.479682, -0.167291>, 
      <-0.790251, 0.479682, -0.186246>, <-0.791189, 0.486617, -0.184076>, <-0.795584, 0.479694, -0.166514>, <-0.801180, 0.479682, -0.161784>, 
      <-0.790251, 0.479682, -0.179494>, <-0.791189, 0.486617, -0.177324>, <-0.795584, 0.479694, -0.162383>, <-0.801180, 0.479682, -0.157653>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.846561, 0.479682, -0.179494>, <-0.844026, 0.486243, -0.177441>, <-0.841130, 0.479694, -0.162496>, <-0.835632, 0.479682, -0.157653>, 
      <-0.846561, 0.479682, -0.186246>, <-0.844026, 0.486243, -0.184193>, <-0.841130, 0.479694, -0.166627>, <-0.835632, 0.479682, -0.161784>, 
      <-0.846561, 0.479682, -0.195248>, <-0.843311, 0.488094, -0.191563>, <-0.841990, 0.478777, -0.174616>, <-0.835632, 0.479682, -0.167291>, 
      <-0.846561, 0.479682, -0.202000>, <-0.843311, 0.488094, -0.198315>, <-0.841990, 0.478777, -0.178747>, <-0.835632, 0.479682, -0.171422>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.846561, 0.479682, -0.134483>, <-0.845291, 0.482970, -0.134277>, <-0.839123, 0.479245, -0.130409>, <-0.835632, 0.479682, -0.130115>, 
      <-0.846561, 0.479682, -0.147986>, <-0.845291, 0.482970, -0.147781>, <-0.839123, 0.479245, -0.138671>, <-0.835632, 0.479682, -0.138376>, 
      <-0.846561, 0.479682, -0.165991>, <-0.844026, 0.486243, -0.163938>, <-0.841130, 0.479694, -0.154235>, <-0.835632, 0.479682, -0.149392>, 
      <-0.846561, 0.479682, -0.179494>, <-0.844026, 0.486243, -0.177441>, <-0.841130, 0.479694, -0.162496>, <-0.835632, 0.479682, -0.157653>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.846561, 0.479682, -0.111977>, <-0.845291, 0.482970, -0.112183>, <-0.839117, 0.479138, -0.116194>, <-0.835632, 0.479682, -0.116346>, 
      <-0.846561, 0.479682, -0.118729>, <-0.845291, 0.482970, -0.118935>, <-0.839117, 0.479138, -0.120325>, <-0.835632, 0.479682, -0.120477>, 
      <-0.846561, 0.479682, -0.127731>, <-0.845291, 0.482970, -0.127525>, <-0.839123, 0.479245, -0.126278>, <-0.835632, 0.479682, -0.125984>, 
      <-0.846561, 0.479682, -0.134483>, <-0.845291, 0.482970, -0.134277>, <-0.839123, 0.479245, -0.130409>, <-0.835632, 0.479682, -0.130115>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.846561, 0.479682, -0.066966>, <-0.844026, 0.486243, -0.069019>, <-0.840910, 0.479954, -0.083733>, <-0.835632, 0.479682, -0.088807>, 
      <-0.846561, 0.479682, -0.080469>, <-0.844026, 0.486243, -0.082522>, <-0.840910, 0.479954, -0.091994>, <-0.835632, 0.479682, -0.097069>, 
      <-0.846561, 0.479682, -0.098474>, <-0.845291, 0.482970, -0.098680>, <-0.839117, 0.479138, -0.107933>, <-0.835632, 0.479682, -0.108084>, 
      <-0.846561, 0.479682, -0.111977>, <-0.845291, 0.482970, -0.112183>, <-0.839117, 0.479138, -0.116194>, <-0.835632, 0.479682, -0.116346>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.846561, 0.479682, -0.044460>, <-0.843311, 0.488094, -0.048145>, <-0.841588, 0.479608, -0.067329>, <-0.835632, 0.479682, -0.075038>, 
      <-0.846561, 0.479682, -0.051212>, <-0.843311, 0.488094, -0.054897>, <-0.841588, 0.479608, -0.071460>, <-0.835632, 0.479682, -0.079169>, 
      <-0.846561, 0.479682, -0.060214>, <-0.844026, 0.486243, -0.062267>, <-0.840910, 0.479954, -0.079602>, <-0.835632, 0.479682, -0.084676>, 
      <-0.846561, 0.479682, -0.066966>, <-0.844026, 0.486243, -0.069019>, <-0.840910, 0.479954, -0.083733>, <-0.835632, 0.479682, -0.088807>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.835632, 0.479682, -0.061269>, <-0.837823, 0.479682, -0.064771>, <-0.835632, 0.479682, -0.070907>, <-0.835632, 0.479682, -0.075038>, 
      <-0.838911, 0.479682, -0.049475>, <-0.841101, 0.479682, -0.052977>, <-0.841588, 0.479608, -0.063199>, <-0.841588, 0.479608, -0.067329>, 
      <-0.842655, 0.489791, -0.027649>, <-0.846236, 0.489791, -0.033373>, <-0.843311, 0.488094, -0.041394>, <-0.843311, 0.488094, -0.048145>, 
      <-0.846561, 0.479682, -0.021955>, <-0.850141, 0.479682, -0.027679>, <-0.846561, 0.479682, -0.037708>, <-0.846561, 0.479682, -0.044460>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.835632, 0.479682, -0.061269>, <-0.838911, 0.479682, -0.049475>, <-0.842655, 0.489791, -0.027649>, <-0.846561, 0.479682, -0.021955>, 
      <-0.832124, 0.479682, -0.055660>, <-0.835402, 0.479682, -0.043866>, <-0.836921, 0.489791, -0.018481>, <-0.840827, 0.479682, -0.012787>, 
      <-0.824549, 0.479682, -0.049955>, <-0.824651, 0.479619, -0.035540>, <-0.826965, 0.491493, -0.011593>, <-0.828447, 0.479682, -0.003462>, 
      <-0.818406, 0.479682, -0.047500>, <-0.818508, 0.479619, -0.033085>, <-0.816924, 0.491493, -0.007580>, <-0.818406, 0.479682, 0.000551>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.835632, 0.479682, -0.061269>, <-0.832124, 0.479682, -0.055660>, <-0.824549, 0.479682, -0.049955>, <-0.818406, 0.479682, -0.047500>, 
      <-0.837823, 0.479682, -0.064771>, <-0.834314, 0.479682, -0.059162>, <-0.824477, 0.479727, -0.060202>, <-0.818334, 0.479727, -0.057747>, 
      <-0.835632, 0.479682, -0.070907>, <-0.832148, 0.479725, -0.075417>, <-0.823700, 0.479933, -0.071406>, <-0.818001, 0.479933, -0.071406>, 
      <-0.835632, 0.479682, -0.075038>, <-0.832148, 0.479725, -0.079548>, <-0.823526, 0.480040, -0.081652>, <-0.817827, 0.480040, -0.081652>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.801180, 0.479682, -0.047500>, <-0.806348, 0.479682, -0.047500>, <-0.813607, 0.479682, -0.045582>, <-0.818406, 0.479682, -0.047500>, 
      <-0.797901, 0.479682, -0.033085>, <-0.803069, 0.479682, -0.033085>, <-0.813709, 0.479619, -0.031167>, <-0.818508, 0.479619, -0.033085>, 
      <-0.791889, 0.491784, -0.007781>, <-0.800335, 0.491784, -0.007781>, <-0.809080, 0.491493, -0.004445>, <-0.816924, 0.491493, -0.007580>, 
      <-0.790251, 0.479682, 0.000551>, <-0.798698, 0.479682, 0.000551>, <-0.810563, 0.479682, 0.003686>, <-0.818406, 0.479682, 0.000551>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.801180, 0.479682, -0.047500>, <-0.797901, 0.479682, -0.033085>, <-0.791889, 0.491784, -0.007781>, <-0.790251, 0.479682, 0.000551>, 
      <-0.801180, 0.479682, -0.055761>, <-0.797901, 0.479682, -0.041346>, <-0.791889, 0.491784, -0.021284>, <-0.790251, 0.479682, -0.012952>, 
      <-0.801180, 0.479682, -0.066777>, <-0.795378, 0.479607, -0.058951>, <-0.791449, 0.488537, -0.034836>, <-0.790251, 0.479682, -0.030957>, 
      <-0.801180, 0.479682, -0.075038>, <-0.795378, 0.479607, -0.067213>, <-0.791449, 0.488537, -0.048340>, <-0.790251, 0.479682, -0.044460>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.801180, 0.479682, -0.047500>, <-0.801180, 0.479682, -0.055761>, <-0.801180, 0.479682, -0.066777>, <-0.801180, 0.479682, -0.075038>, 
      <-0.806348, 0.479682, -0.047500>, <-0.806348, 0.479682, -0.055761>, <-0.804381, 0.479724, -0.071094>, <-0.804381, 0.479724, -0.079355>, 
      <-0.813607, 0.479682, -0.045582>, <-0.813535, 0.479727, -0.055829>, <-0.812626, 0.479933, -0.071406>, <-0.812452, 0.480040, -0.081652>, 
      <-0.818406, 0.479682, -0.047500>, <-0.818334, 0.479727, -0.057747>, <-0.818001, 0.479933, -0.071406>, <-0.817827, 0.480040, -0.081652>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.801180, 0.479682, -0.198961>, <-0.801180, 0.479682, -0.190699>, <-0.801180, 0.479682, -0.179684>, <-0.801180, 0.479682, -0.171422>, 
      <-0.797901, 0.479682, -0.213376>, <-0.797901, 0.479682, -0.205114>, <-0.794344, 0.478831, -0.186572>, <-0.794344, 0.478831, -0.178310>, 
      <-0.791889, 0.491784, -0.238680>, <-0.791889, 0.491784, -0.225177>, <-0.791449, 0.488537, -0.211624>, <-0.791449, 0.488537, -0.198121>, 
      <-0.790251, 0.479682, -0.247011>, <-0.790251, 0.479682, -0.233508>, <-0.790251, 0.479682, -0.215503>, <-0.790251, 0.479682, -0.202000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.801180, 0.479682, -0.198961>, <-0.797901, 0.479682, -0.213376>, <-0.791889, 0.491784, -0.238680>, <-0.790251, 0.479682, -0.247011>, 
      <-0.806348, 0.479682, -0.198961>, <-0.803069, 0.479682, -0.213376>, <-0.800335, 0.491784, -0.238680>, <-0.798698, 0.479682, -0.247011>, 
      <-0.813607, 0.479682, -0.200879>, <-0.813247, 0.478967, -0.215272>, <-0.809080, 0.491492, -0.242015>, <-0.810563, 0.479682, -0.250146>, 
      <-0.818406, 0.479682, -0.198961>, <-0.818046, 0.478967, -0.213354>, <-0.816924, 0.491492, -0.238880>, <-0.818406, 0.479682, -0.247011>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.801180, 0.479682, -0.198961>, <-0.806348, 0.479682, -0.198961>, <-0.813607, 0.479682, -0.200879>, <-0.818406, 0.479682, -0.198961>, 
      <-0.801180, 0.479682, -0.190699>, <-0.806348, 0.479682, -0.190699>, <-0.813814, 0.480092, -0.192628>, <-0.818612, 0.480092, -0.190710>, 
      <-0.801180, 0.479682, -0.179684>, <-0.805280, 0.480193, -0.175553>, <-0.813882, 0.482301, -0.179902>, <-0.819724, 0.482301, -0.179902>, 
      <-0.801180, 0.479682, -0.171422>, <-0.805280, 0.480193, -0.167291>, <-0.814447, 0.483423, -0.171734>, <-0.820289, 0.483423, -0.171734>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.835632, 0.479682, -0.185191>, <-0.832124, 0.479682, -0.190800>, <-0.824550, 0.479682, -0.196506>, <-0.818406, 0.479682, -0.198961>, 
      <-0.838911, 0.479682, -0.196985>, <-0.835402, 0.479682, -0.202594>, <-0.824189, 0.478967, -0.210898>, <-0.818046, 0.478967, -0.213354>, 
      <-0.842655, 0.489791, -0.218811>, <-0.836921, 0.489791, -0.227979>, <-0.826965, 0.491492, -0.234867>, <-0.816924, 0.491492, -0.238880>, 
      <-0.846561, 0.479682, -0.224505>, <-0.840827, 0.479682, -0.233673>, <-0.828447, 0.479682, -0.242998>, <-0.818406, 0.479682, -0.247011>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.835632, 0.479682, -0.185191>, <-0.837823, 0.479682, -0.181689>, <-0.835632, 0.479682, -0.175553>, <-0.835632, 0.479682, -0.171422>, 
      <-0.832124, 0.479682, -0.190800>, <-0.834314, 0.479682, -0.187298>, <-0.832539, 0.480122, -0.171990>, <-0.832539, 0.480122, -0.167859>, 
      <-0.824550, 0.479682, -0.196506>, <-0.824756, 0.480092, -0.188254>, <-0.824463, 0.482301, -0.179902>, <-0.825028, 0.483423, -0.171734>, 
      <-0.818406, 0.479682, -0.198961>, <-0.818612, 0.480092, -0.190710>, <-0.819724, 0.482301, -0.179902>, <-0.820289, 0.483423, -0.171734>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.835632, 0.479682, -0.185191>, <-0.838911, 0.479682, -0.196985>, <-0.842655, 0.489791, -0.218811>, <-0.846561, 0.479682, -0.224505>, 
      <-0.837823, 0.479682, -0.181689>, <-0.841101, 0.479682, -0.193483>, <-0.846236, 0.489791, -0.213087>, <-0.850141, 0.479682, -0.218781>, 
      <-0.835632, 0.479682, -0.175553>, <-0.841990, 0.478777, -0.182878>, <-0.843311, 0.488094, -0.205066>, <-0.846561, 0.479682, -0.208752>, 
      <-0.835632, 0.479682, -0.171422>, <-0.841990, 0.478777, -0.178747>, <-0.843311, 0.488094, -0.198315>, <-0.846561, 0.479682, -0.202000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.840468, 0.120511, -0.224291>, <-0.840934, 0.111886, -0.224855>, <-0.840394, 0.112026, -0.197076>, <-0.839886, 0.120511, -0.195444>, 
      <-0.851899, 0.120511, -0.224291>, <-0.852365, 0.111886, -0.224855>, <-0.851972, 0.112026, -0.197076>, <-0.851465, 0.120511, -0.195444>, 
      <-0.867778, 0.120511, -0.223744>, <-0.867778, 0.120511, -0.214765>, <-0.867251, 0.120511, -0.203888>, <-0.867251, 0.120511, -0.194908>, 
      <-0.878393, 0.120511, -0.227988>, <-0.878393, 0.120511, -0.219009>, <-0.878393, 0.120511, -0.207036>, <-0.878393, 0.120511, -0.198057>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.840468, 0.120511, -0.224291>, <-0.834540, 0.230293, -0.217119>, <-0.826749, 0.375417, -0.192513>, <-0.820289, 0.483423, -0.171734>, 
      <-0.851899, 0.120511, -0.224291>, <-0.845971, 0.230293, -0.217119>, <-0.831488, 0.375417, -0.192513>, <-0.825028, 0.483423, -0.171734>, 
      <-0.867778, 0.120511, -0.223744>, <-0.854950, 0.228262, -0.206775>, <-0.845367, 0.372371, -0.184829>, <-0.832539, 0.480122, -0.167859>, 
      <-0.878393, 0.120511, -0.227988>, <-0.865565, 0.228262, -0.211018>, <-0.848460, 0.371931, -0.188392>, <-0.835632, 0.479682, -0.171422>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.840468, 0.120511, -0.224291>, <-0.840934, 0.111886, -0.224855>, <-0.840394, 0.112026, -0.197076>, <-0.839886, 0.120511, -0.195444>, 
      <-0.829323, 0.120511, -0.224291>, <-0.829789, 0.111886, -0.224855>, <-0.829451, 0.112026, -0.197076>, <-0.828943, 0.120511, -0.195444>, 
      <-0.813830, 0.120511, -0.223797>, <-0.813830, 0.120511, -0.214818>, <-0.814007, 0.120511, -0.203968>, <-0.814007, 0.120511, -0.194989>, 
      <-0.803503, 0.120511, -0.227988>, <-0.803503, 0.120511, -0.219009>, <-0.803503, 0.120511, -0.207036>, <-0.803503, 0.120511, -0.198057>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.840468, 0.120511, -0.224291>, <-0.829323, 0.120511, -0.224291>, <-0.813830, 0.120511, -0.223797>, <-0.803503, 0.120511, -0.227988>, 
      <-0.834540, 0.230293, -0.217119>, <-0.823395, 0.230293, -0.217119>, <-0.813133, 0.228262, -0.206827>, <-0.802806, 0.228262, -0.211018>, 
      <-0.826749, 0.375417, -0.192513>, <-0.820907, 0.375417, -0.192513>, <-0.805977, 0.372441, -0.184261>, <-0.801877, 0.371931, -0.188392>, 
      <-0.820289, 0.483423, -0.171734>, <-0.814447, 0.483423, -0.171734>, <-0.805280, 0.480193, -0.167291>, <-0.801180, 0.479682, -0.171422>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.840948, 0.300097, 0.076134>, <-0.837341, 0.357570, 0.064039>, <-0.824457, 0.431472, 0.033741>, <-0.818406, 0.479682, 0.000551>, 
      <-0.862198, 0.300097, 0.070123>, <-0.858591, 0.357570, 0.058028>, <-0.834499, 0.431472, 0.029728>, <-0.828447, 0.479682, -0.003462>, 
      <-0.890394, 0.300097, 0.056434>, <-0.880952, 0.358109, 0.046445>, <-0.859847, 0.430452, 0.014942>, <-0.840827, 0.479682, -0.012787>, 
      <-0.905018, 0.300097, 0.039886>, <-0.895576, 0.358109, 0.029898>, <-0.865582, 0.430452, 0.005775>, <-0.846561, 0.479682, -0.021955>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.776878, 0.300097, 0.076134>, <-0.778871, 0.357398, 0.064074>, <-0.783761, 0.431719, 0.033571>, <-0.790251, 0.479682, 0.000551>, 
      <-0.796099, 0.300097, 0.076134>, <-0.798092, 0.357398, 0.064074>, <-0.792207, 0.431719, 0.033571>, <-0.798698, 0.479682, 0.000551>, 
      <-0.822453, 0.300097, 0.081366>, <-0.818846, 0.357570, 0.069271>, <-0.816614, 0.431472, 0.036876>, <-0.810563, 0.479682, 0.003686>, 
      <-0.840948, 0.300097, 0.076134>, <-0.837341, 0.357570, 0.064039>, <-0.824457, 0.431472, 0.033741>, <-0.818406, 0.479682, 0.000551>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.776878, 0.300097, 0.003638>, <-0.778940, 0.355483, -0.003779>, <-0.783373, 0.428852, -0.022191>, <-0.790251, 0.479682, -0.044460>, 
      <-0.776878, 0.300097, 0.025387>, <-0.778940, 0.355483, 0.017970>, <-0.783373, 0.428852, -0.008688>, <-0.790251, 0.479682, -0.030957>, 
      <-0.776878, 0.300097, 0.054385>, <-0.778871, 0.357398, 0.042326>, <-0.783761, 0.431719, 0.020067>, <-0.790251, 0.479682, -0.012952>, 
      <-0.776878, 0.300097, 0.076134>, <-0.778871, 0.357398, 0.064074>, <-0.783761, 0.431719, 0.033571>, <-0.790251, 0.479682, 0.000551>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.776878, 0.300097, -0.032610>, <-0.778915, 0.354809, -0.037843>, <-0.783207, 0.427625, -0.050676>, <-0.790251, 0.479682, -0.066966>, 
      <-0.776878, 0.300097, -0.021736>, <-0.778915, 0.354809, -0.026969>, <-0.783207, 0.427625, -0.043924>, <-0.790251, 0.479682, -0.060214>, 
      <-0.776878, 0.300097, -0.007236>, <-0.778940, 0.355483, -0.014653>, <-0.783373, 0.428852, -0.028943>, <-0.790251, 0.479682, -0.051212>, 
      <-0.776878, 0.300097, 0.003638>, <-0.778940, 0.355483, -0.003779>, <-0.783373, 0.428852, -0.022191>, <-0.790251, 0.479682, -0.044460>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.776878, 0.300097, -0.105106>, <-0.778889, 0.354114, -0.106139>, <-0.783015, 0.426209, -0.108630>, <-0.790251, 0.479682, -0.111977>, 
      <-0.776878, 0.300097, -0.083357>, <-0.778889, 0.354114, -0.084391>, <-0.783015, 0.426209, -0.095127>, <-0.790251, 0.479682, -0.098474>, 
      <-0.776878, 0.300097, -0.054359>, <-0.778915, 0.354809, -0.059592>, <-0.783207, 0.427625, -0.064179>, <-0.790251, 0.479682, -0.080469>, 
      <-0.776878, 0.300097, -0.032610>, <-0.778915, 0.354809, -0.037843>, <-0.783207, 0.427625, -0.050676>, <-0.790251, 0.479682, -0.066966>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.776878, 0.300097, -0.141354>, <-0.778889, 0.354114, -0.140321>, <-0.783015, 0.426209, -0.137829>, <-0.790251, 0.479682, -0.134483>, 
      <-0.776878, 0.300097, -0.130480>, <-0.778889, 0.354114, -0.129446>, <-0.783015, 0.426209, -0.131078>, <-0.790251, 0.479682, -0.127731>, 
      <-0.776878, 0.300097, -0.115980>, <-0.778889, 0.354114, -0.117014>, <-0.783015, 0.426209, -0.115382>, <-0.790251, 0.479682, -0.118729>, 
      <-0.776878, 0.300097, -0.105106>, <-0.778889, 0.354114, -0.106139>, <-0.783015, 0.426209, -0.108630>, <-0.790251, 0.479682, -0.111977>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.776878, 0.300097, -0.213850>, <-0.778915, 0.354809, -0.208617>, <-0.783207, 0.427625, -0.195784>, <-0.790251, 0.479682, -0.179494>, 
      <-0.776878, 0.300097, -0.192101>, <-0.778915, 0.354809, -0.186868>, <-0.783207, 0.427625, -0.182281>, <-0.790251, 0.479682, -0.165991>, 
      <-0.776878, 0.300097, -0.163103>, <-0.778889, 0.354114, -0.162070>, <-0.783015, 0.426209, -0.151333>, <-0.790251, 0.479682, -0.147986>, 
      <-0.776878, 0.300097, -0.141354>, <-0.778889, 0.354114, -0.140321>, <-0.783015, 0.426209, -0.137829>, <-0.790251, 0.479682, -0.134483>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.776878, 0.300097, -0.250098>, <-0.778940, 0.355483, -0.242681>, <-0.783373, 0.428852, -0.224269>, <-0.790251, 0.479682, -0.202000>, 
      <-0.776878, 0.300097, -0.239224>, <-0.778940, 0.355483, -0.231807>, <-0.783373, 0.428852, -0.217517>, <-0.790251, 0.479682, -0.195248>, 
      <-0.776878, 0.300097, -0.224724>, <-0.778915, 0.354809, -0.219491>, <-0.783207, 0.427625, -0.202536>, <-0.790251, 0.479682, -0.186246>, 
      <-0.776878, 0.300097, -0.213850>, <-0.778915, 0.354809, -0.208617>, <-0.783207, 0.427625, -0.195784>, <-0.790251, 0.479682, -0.179494>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.776878, 0.300097, -0.322594>, <-0.779011, 0.357393, -0.310537>, <-0.783761, 0.431719, -0.280030>, <-0.790251, 0.479682, -0.247011>, 
      <-0.776878, 0.300097, -0.300845>, <-0.779011, 0.357393, -0.288788>, <-0.783761, 0.431719, -0.266527>, <-0.790251, 0.479682, -0.233508>, 
      <-0.776878, 0.300097, -0.271847>, <-0.778940, 0.355483, -0.264430>, <-0.783373, 0.428852, -0.237772>, <-0.790251, 0.479682, -0.215503>, 
      <-0.776878, 0.300097, -0.250098>, <-0.778940, 0.355483, -0.242681>, <-0.783373, 0.428852, -0.224269>, <-0.790251, 0.479682, -0.202000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.840948, 0.300097, -0.322594>, <-0.837341, 0.357570, -0.310499>, <-0.824458, 0.431471, -0.280201>, <-0.818406, 0.479682, -0.247011>, 
      <-0.822453, 0.300097, -0.327826>, <-0.818846, 0.357570, -0.315731>, <-0.816614, 0.431471, -0.283336>, <-0.810563, 0.479682, -0.250146>, 
      <-0.796099, 0.300097, -0.322594>, <-0.798232, 0.357393, -0.310537>, <-0.792207, 0.431719, -0.280030>, <-0.798698, 0.479682, -0.247011>, 
      <-0.776878, 0.300097, -0.322594>, <-0.779011, 0.357393, -0.310537>, <-0.783761, 0.431719, -0.280030>, <-0.790251, 0.479682, -0.247011>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.905018, 0.300097, -0.286346>, <-0.895576, 0.358109, -0.276358>, <-0.865582, 0.430452, -0.252235>, <-0.846561, 0.479682, -0.224505>, 
      <-0.890394, 0.300097, -0.302894>, <-0.880952, 0.358109, -0.292905>, <-0.859847, 0.430452, -0.261402>, <-0.840827, 0.479682, -0.233673>, 
      <-0.862198, 0.300097, -0.316583>, <-0.858591, 0.357570, -0.304488>, <-0.834499, 0.431471, -0.276188>, <-0.828447, 0.479682, -0.242998>, 
      <-0.840948, 0.300097, -0.322594>, <-0.837341, 0.357570, -0.310499>, <-0.824458, 0.431471, -0.280201>, <-0.818406, 0.479682, -0.247011>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.905018, 0.300097, -0.250098>, <-0.895707, 0.357307, -0.242437>, <-0.866067, 0.429198, -0.224117>, <-0.846561, 0.479682, -0.202000>, 
      <-0.905018, 0.300097, -0.260972>, <-0.895707, 0.357307, -0.253311>, <-0.866067, 0.429198, -0.230869>, <-0.846561, 0.479682, -0.208752>, 
      <-0.912219, 0.300097, -0.278198>, <-0.902777, 0.358109, -0.268209>, <-0.869162, 0.430452, -0.246511>, <-0.850141, 0.479682, -0.218781>, 
      <-0.905018, 0.300097, -0.286346>, <-0.895576, 0.358109, -0.276358>, <-0.865582, 0.430452, -0.252235>, <-0.846561, 0.479682, -0.224505>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.905018, 0.300097, -0.213850>, <-0.895808, 0.356685, -0.208437>, <-0.866484, 0.428116, -0.195630>, <-0.846561, 0.479682, -0.179494>, 
      <-0.905018, 0.300097, -0.224724>, <-0.895808, 0.356685, -0.219311>, <-0.866484, 0.428116, -0.202382>, <-0.846561, 0.479682, -0.186246>, 
      <-0.905018, 0.300097, -0.239224>, <-0.895707, 0.357307, -0.231562>, <-0.866067, 0.429198, -0.217365>, <-0.846561, 0.479682, -0.195248>, 
      <-0.905018, 0.300097, -0.250098>, <-0.895707, 0.357307, -0.242437>, <-0.866067, 0.429198, -0.224117>, <-0.846561, 0.479682, -0.202000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.905018, 0.300097, -0.141354>, <-0.895912, 0.356046, -0.140284>, <-0.866959, 0.426887, -0.137787>, <-0.846561, 0.479682, -0.134483>, 
      <-0.905018, 0.300097, -0.163103>, <-0.895912, 0.356046, -0.162033>, <-0.866959, 0.426887, -0.151290>, <-0.846561, 0.479682, -0.147986>, 
      <-0.905018, 0.300097, -0.192101>, <-0.895808, 0.356685, -0.186688>, <-0.866484, 0.428116, -0.182127>, <-0.846561, 0.479682, -0.165991>, 
      <-0.905018, 0.300097, -0.213850>, <-0.895808, 0.356685, -0.208437>, <-0.866484, 0.428116, -0.195630>, <-0.846561, 0.479682, -0.179494>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.905018, 0.300097, -0.105106>, <-0.895912, 0.356046, -0.106176>, <-0.866959, 0.426887, -0.108673>, <-0.846561, 0.479682, -0.111977>, 
      <-0.905018, 0.300097, -0.115980>, <-0.895912, 0.356046, -0.117051>, <-0.866959, 0.426887, -0.115424>, <-0.846561, 0.479682, -0.118729>, 
      <-0.905018, 0.300097, -0.130480>, <-0.895912, 0.356046, -0.129409>, <-0.866959, 0.426887, -0.131035>, <-0.846561, 0.479682, -0.127731>, 
      <-0.905018, 0.300097, -0.141354>, <-0.895912, 0.356046, -0.140284>, <-0.866959, 0.426887, -0.137787>, <-0.846561, 0.479682, -0.134483>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.905018, 0.300097, -0.032610>, <-0.895808, 0.356685, -0.038023>, <-0.866484, 0.428116, -0.050830>, <-0.846561, 0.479682, -0.066966>, 
      <-0.905018, 0.300097, -0.054359>, <-0.895808, 0.356685, -0.059772>, <-0.866484, 0.428116, -0.064333>, <-0.846561, 0.479682, -0.080469>, 
      <-0.905018, 0.300097, -0.083357>, <-0.895912, 0.356046, -0.084428>, <-0.866959, 0.426887, -0.095169>, <-0.846561, 0.479682, -0.098474>, 
      <-0.905018, 0.300097, -0.105106>, <-0.895912, 0.356046, -0.106176>, <-0.866959, 0.426887, -0.108673>, <-0.846561, 0.479682, -0.111977>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.905018, 0.300097, 0.003638>, <-0.895707, 0.357307, -0.004023>, <-0.866067, 0.429198, -0.022343>, <-0.846561, 0.479682, -0.044460>, 
      <-0.905018, 0.300097, -0.007236>, <-0.895707, 0.357307, -0.014898>, <-0.866067, 0.429198, -0.029095>, <-0.846561, 0.479682, -0.051212>, 
      <-0.905018, 0.300097, -0.021736>, <-0.895808, 0.356685, -0.027148>, <-0.866484, 0.428116, -0.044078>, <-0.846561, 0.479682, -0.060214>, 
      <-0.905018, 0.300097, -0.032610>, <-0.895808, 0.356685, -0.038023>, <-0.866484, 0.428116, -0.050830>, <-0.846561, 0.479682, -0.066966>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.905018, 0.300097, 0.003638>, <-0.905018, 0.300097, 0.014512>, <-0.912219, 0.300097, 0.031738>, <-0.905018, 0.300097, 0.039886>, 
      <-0.895707, 0.357307, -0.004023>, <-0.895707, 0.357307, 0.006851>, <-0.902777, 0.358109, 0.021749>, <-0.895576, 0.358109, 0.029898>, 
      <-0.866067, 0.429198, -0.022343>, <-0.866067, 0.429198, -0.015591>, <-0.869162, 0.430452, 0.000051>, <-0.865582, 0.430452, 0.005775>, 
      <-0.846561, 0.479682, -0.044460>, <-0.846561, 0.479682, -0.037708>, <-0.850141, 0.479682, -0.027679>, <-0.846561, 0.479682, -0.021955>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.840948, 0.120511, 0.076134>, <-0.840948, 0.173406, 0.086367>, <-0.844251, 0.247475, 0.087208>, <-0.840948, 0.300097, 0.076134>, 
      <-0.862187, 0.120505, 0.070084>, <-0.862187, 0.173400, 0.080318>, <-0.865501, 0.247475, 0.081197>, <-0.862198, 0.300097, 0.070123>, 
      <-0.890394, 0.120511, 0.056434>, <-0.898200, 0.173163, 0.064768>, <-0.898926, 0.247672, 0.065460>, <-0.890394, 0.300097, 0.056434>, 
      <-0.905018, 0.120511, 0.039886>, <-0.912824, 0.173163, 0.048220>, <-0.913550, 0.247672, 0.048912>, <-0.905018, 0.300097, 0.039886>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.777759, 0.120550, 0.076134>, <-0.770000, 0.172883, 0.086259>, <-0.775046, 0.247418, 0.087221>, <-0.776878, 0.300097, 0.076134>, 
      <-0.796716, 0.120538, 0.076134>, <-0.788957, 0.172871, 0.086259>, <-0.794267, 0.247418, 0.087221>, <-0.796099, 0.300097, 0.076134>, 
      <-0.822716, 0.120517, 0.081327>, <-0.822716, 0.173412, 0.091561>, <-0.825755, 0.247475, 0.092439>, <-0.822453, 0.300097, 0.081366>, 
      <-0.840948, 0.120511, 0.076134>, <-0.840948, 0.173406, 0.086367>, <-0.844251, 0.247475, 0.087208>, <-0.840948, 0.300097, 0.076134>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.776878, 0.120511, 0.003638>, <-0.769035, 0.173413, 0.010151>, <-0.774891, 0.246734, 0.010784>, <-0.776878, 0.300097, 0.003638>, 
      <-0.777054, 0.120519, 0.025388>, <-0.769211, 0.173421, 0.031901>, <-0.774891, 0.246734, 0.032533>, <-0.776878, 0.300097, 0.025387>, 
      <-0.777495, 0.120538, 0.054385>, <-0.769736, 0.172871, 0.064510>, <-0.775046, 0.247418, 0.065472>, <-0.776878, 0.300097, 0.054385>, 
      <-0.777759, 0.120550, 0.076134>, <-0.770000, 0.172883, 0.086259>, <-0.775046, 0.247418, 0.087221>, <-0.776878, 0.300097, 0.076134>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.776878, 0.120511, -0.032610>, <-0.776878, 0.120511, -0.021736>, <-0.776790, 0.120507, -0.007236>, <-0.776878, 0.120511, 0.003638>, 
      <-0.778235, 0.111359, -0.033415>, <-0.778235, 0.111359, -0.022540>, <-0.778301, 0.110312, -0.008491>, <-0.778389, 0.110316, 0.002383>, 
      <-0.794544, 0.120511, -0.045956>, <-0.794544, 0.120511, -0.036976>, <-0.794007, 0.120511, -0.023253>, <-0.794007, 0.120511, -0.014273>, 
      <-0.803503, 0.120511, -0.048403>, <-0.803503, 0.120511, -0.039424>, <-0.803503, 0.120511, -0.027451>, <-0.803503, 0.120511, -0.018472>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.776878, 0.120511, -0.032610>, <-0.769007, 0.173604, -0.027941>, <-0.774883, 0.246503, -0.027484>, <-0.776878, 0.300097, -0.032610>, 
      <-0.776878, 0.120511, -0.021736>, <-0.769007, 0.173604, -0.017067>, <-0.774883, 0.246503, -0.016609>, <-0.776878, 0.300097, -0.021736>, 
      <-0.776790, 0.120507, -0.007236>, <-0.768947, 0.173409, -0.000723>, <-0.774891, 0.246734, -0.000090>, <-0.776878, 0.300097, -0.007236>, 
      <-0.776878, 0.120511, 0.003638>, <-0.769035, 0.173413, 0.010151>, <-0.774891, 0.246734, 0.010784>, <-0.776878, 0.300097, 0.003638>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.776878, 0.120511, -0.105106>, <-0.776878, 0.120511, -0.083357>, <-0.776878, 0.120511, -0.054359>, <-0.776878, 0.120511, -0.032610>, 
      <-0.778057, 0.112556, -0.105246>, <-0.778057, 0.112556, -0.083497>, <-0.778235, 0.111359, -0.055164>, <-0.778235, 0.111359, -0.033415>, 
      <-0.795469, 0.120223, -0.107987>, <-0.795469, 0.120223, -0.090029>, <-0.794544, 0.120511, -0.063914>, <-0.794544, 0.120511, -0.045956>, 
      <-0.803503, 0.120511, -0.108265>, <-0.803503, 0.120511, -0.090306>, <-0.803503, 0.120511, -0.066362>, <-0.803503, 0.120511, -0.048403>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.776878, 0.120511, -0.105106>, <-0.768978, 0.173796, -0.104169>, <-0.774874, 0.246268, -0.104076>, <-0.776878, 0.300097, -0.105106>, 
      <-0.776878, 0.120511, -0.083357>, <-0.768978, 0.173796, -0.082420>, <-0.774874, 0.246268, -0.082327>, <-0.776878, 0.300097, -0.083357>, 
      <-0.776878, 0.120511, -0.054359>, <-0.769007, 0.173604, -0.049690>, <-0.774883, 0.246503, -0.049232>, <-0.776878, 0.300097, -0.054359>, 
      <-0.776878, 0.120511, -0.032610>, <-0.769007, 0.173604, -0.027941>, <-0.774883, 0.246503, -0.027484>, <-0.776878, 0.300097, -0.032610>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.776878, 0.120511, -0.141354>, <-0.776878, 0.120511, -0.130480>, <-0.776878, 0.120511, -0.115980>, <-0.776878, 0.120511, -0.105106>, 
      <-0.778057, 0.112556, -0.141214>, <-0.778057, 0.112556, -0.130340>, <-0.778057, 0.112556, -0.116120>, <-0.778057, 0.112556, -0.105246>, 
      <-0.795498, 0.120230, -0.138926>, <-0.795498, 0.120230, -0.129946>, <-0.795469, 0.120223, -0.116967>, <-0.795469, 0.120223, -0.107987>, 
      <-0.803503, 0.120511, -0.138196>, <-0.803503, 0.120511, -0.129217>, <-0.803503, 0.120511, -0.117244>, <-0.803503, 0.120511, -0.108265>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.776878, 0.120511, -0.141354>, <-0.768978, 0.173796, -0.142291>, <-0.774874, 0.246268, -0.142384>, <-0.776878, 0.300097, -0.141354>, 
      <-0.776878, 0.120511, -0.130480>, <-0.768978, 0.173796, -0.131417>, <-0.774874, 0.246268, -0.131509>, <-0.776878, 0.300097, -0.130480>, 
      <-0.776878, 0.120511, -0.115980>, <-0.768978, 0.173796, -0.115043>, <-0.774874, 0.246268, -0.114951>, <-0.776878, 0.300097, -0.115980>, 
      <-0.776878, 0.120511, -0.105106>, <-0.768978, 0.173796, -0.104169>, <-0.774874, 0.246268, -0.104076>, <-0.776878, 0.300097, -0.105106>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.776878, 0.120511, -0.213850>, <-0.776878, 0.120511, -0.192101>, <-0.776878, 0.120511, -0.163103>, <-0.776878, 0.120511, -0.141354>, 
      <-0.778235, 0.111359, -0.213045>, <-0.778235, 0.111359, -0.191296>, <-0.778057, 0.112556, -0.162963>, <-0.778057, 0.112556, -0.141214>, 
      <-0.794589, 0.120511, -0.200661>, <-0.794589, 0.120511, -0.182703>, <-0.795498, 0.120230, -0.156884>, <-0.795498, 0.120230, -0.138926>, 
      <-0.803503, 0.120511, -0.198057>, <-0.803503, 0.120511, -0.180099>, <-0.803503, 0.120511, -0.156154>, <-0.803503, 0.120511, -0.138196>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.776878, 0.120511, -0.213850>, <-0.769007, 0.173604, -0.218519>, <-0.774883, 0.246503, -0.218976>, <-0.776878, 0.300097, -0.213850>, 
      <-0.776878, 0.120511, -0.192101>, <-0.769007, 0.173604, -0.196770>, <-0.774883, 0.246503, -0.197228>, <-0.776878, 0.300097, -0.192101>, 
      <-0.776878, 0.120511, -0.163103>, <-0.768978, 0.173796, -0.164040>, <-0.774874, 0.246268, -0.164133>, <-0.776878, 0.300097, -0.163103>, 
      <-0.776878, 0.120511, -0.141354>, <-0.768978, 0.173796, -0.142291>, <-0.774874, 0.246268, -0.142384>, <-0.776878, 0.300097, -0.141354>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.776878, 0.120511, -0.250098>, <-0.776878, 0.120511, -0.239224>, <-0.776878, 0.120511, -0.224724>, <-0.776878, 0.120511, -0.213850>, 
      <-0.778389, 0.110316, -0.248843>, <-0.778389, 0.110316, -0.237968>, <-0.778235, 0.111359, -0.223920>, <-0.778235, 0.111359, -0.213045>, 
      <-0.793883, 0.120511, -0.231892>, <-0.793883, 0.120511, -0.222913>, <-0.794589, 0.120511, -0.209640>, <-0.794589, 0.120511, -0.200661>, 
      <-0.803503, 0.120511, -0.227988>, <-0.803503, 0.120511, -0.219009>, <-0.803503, 0.120511, -0.207036>, <-0.803503, 0.120511, -0.198057>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.776878, 0.120511, -0.250098>, <-0.769035, 0.173413, -0.256611>, <-0.774891, 0.246734, -0.257244>, <-0.776878, 0.300097, -0.250098>, 
      <-0.776878, 0.120511, -0.239224>, <-0.769035, 0.173413, -0.245737>, <-0.774891, 0.246734, -0.246370>, <-0.776878, 0.300097, -0.239224>, 
      <-0.776878, 0.120511, -0.224724>, <-0.769007, 0.173604, -0.229394>, <-0.774883, 0.246503, -0.229851>, <-0.776878, 0.300097, -0.224724>, 
      <-0.776878, 0.120511, -0.213850>, <-0.769007, 0.173604, -0.218519>, <-0.774883, 0.246503, -0.218976>, <-0.776878, 0.300097, -0.213850>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.776878, 0.120511, -0.322594>, <-0.769118, 0.172854, -0.332721>, <-0.774916, 0.247411, -0.333681>, <-0.776878, 0.300097, -0.322594>, 
      <-0.776878, 0.120511, -0.300845>, <-0.769118, 0.172854, -0.310972>, <-0.774916, 0.247411, -0.311932>, <-0.776878, 0.300097, -0.300845>, 
      <-0.776878, 0.120511, -0.271847>, <-0.769035, 0.173413, -0.278360>, <-0.774891, 0.246734, -0.278993>, <-0.776878, 0.300097, -0.271847>, 
      <-0.776878, 0.120511, -0.250098>, <-0.769035, 0.173413, -0.256611>, <-0.774891, 0.246734, -0.257244>, <-0.776878, 0.300097, -0.250098>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.840948, 0.120511, -0.322594>, <-0.840948, 0.173406, -0.332828>, <-0.844251, 0.247475, -0.333668>, <-0.840948, 0.300097, -0.322594>, 
      <-0.822453, 0.120511, -0.327826>, <-0.822453, 0.173406, -0.338059>, <-0.825755, 0.247475, -0.338900>, <-0.822453, 0.300097, -0.327826>, 
      <-0.796099, 0.120511, -0.322594>, <-0.788339, 0.172854, -0.332721>, <-0.794137, 0.247411, -0.333681>, <-0.796099, 0.300097, -0.322594>, 
      <-0.776878, 0.120511, -0.322594>, <-0.769118, 0.172854, -0.332721>, <-0.774916, 0.247411, -0.333681>, <-0.776878, 0.300097, -0.322594>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.905018, 0.120511, -0.286346>, <-0.912824, 0.173163, -0.294680>, <-0.913550, 0.247672, -0.295372>, <-0.905018, 0.300097, -0.286346>, 
      <-0.890394, 0.120511, -0.302894>, <-0.898200, 0.173163, -0.311228>, <-0.898926, 0.247672, -0.311920>, <-0.890394, 0.300097, -0.302894>, 
      <-0.862198, 0.120511, -0.316583>, <-0.862198, 0.173406, -0.326816>, <-0.865501, 0.247475, -0.327656>, <-0.862198, 0.300097, -0.316583>, 
      <-0.840948, 0.120511, -0.322594>, <-0.840948, 0.173406, -0.332828>, <-0.844251, 0.247475, -0.333668>, <-0.840948, 0.300097, -0.322594>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.905018, 0.120511, -0.250098>, <-0.912861, 0.173413, -0.256611>, <-0.913598, 0.247379, -0.257158>, <-0.905018, 0.300097, -0.250098>, 
      <-0.905018, 0.120511, -0.260972>, <-0.912861, 0.173413, -0.267485>, <-0.913598, 0.247379, -0.268032>, <-0.905018, 0.300097, -0.260972>, 
      <-0.912219, 0.120511, -0.278198>, <-0.920025, 0.173163, -0.286532>, <-0.920752, 0.247672, -0.287224>, <-0.912219, 0.300097, -0.278198>, 
      <-0.905018, 0.120511, -0.286346>, <-0.912824, 0.173163, -0.294680>, <-0.913550, 0.247672, -0.295372>, <-0.905018, 0.300097, -0.286346>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.905018, 0.120511, -0.213850>, <-0.912889, 0.173604, -0.218519>, <-0.913634, 0.247156, -0.218914>, <-0.905018, 0.300097, -0.213850>, 
      <-0.905018, 0.120511, -0.224724>, <-0.912889, 0.173604, -0.229394>, <-0.913634, 0.247156, -0.229788>, <-0.905018, 0.300097, -0.224724>, 
      <-0.905018, 0.120511, -0.239224>, <-0.912861, 0.173413, -0.245737>, <-0.913598, 0.247379, -0.246283>, <-0.905018, 0.300097, -0.239224>, 
      <-0.905018, 0.120511, -0.250098>, <-0.912861, 0.173413, -0.256611>, <-0.913598, 0.247379, -0.257158>, <-0.905018, 0.300097, -0.250098>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.905018, 0.120511, -0.213850>, <-0.905018, 0.120511, -0.224724>, <-0.905018, 0.120511, -0.239224>, <-0.905018, 0.120511, -0.250098>, 
      <-0.903661, 0.111359, -0.213045>, <-0.903661, 0.111359, -0.223920>, <-0.903506, 0.110316, -0.237968>, <-0.903506, 0.110316, -0.248843>, 
      <-0.887330, 0.120511, -0.200583>, <-0.887330, 0.120511, -0.209562>, <-0.888034, 0.120511, -0.222863>, <-0.888034, 0.120511, -0.231842>, 
      <-0.878393, 0.120511, -0.198057>, <-0.878393, 0.120511, -0.207036>, <-0.878393, 0.120511, -0.219009>, <-0.878393, 0.120511, -0.227988>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.905018, 0.120511, -0.141354>, <-0.912918, 0.173796, -0.142291>, <-0.913671, 0.246930, -0.142371>, <-0.905018, 0.300097, -0.141354>, 
      <-0.905018, 0.120511, -0.163103>, <-0.912918, 0.173796, -0.164040>, <-0.913671, 0.246930, -0.164120>, <-0.905018, 0.300097, -0.163103>, 
      <-0.905018, 0.120511, -0.192101>, <-0.912889, 0.173604, -0.196770>, <-0.913634, 0.247156, -0.197165>, <-0.905018, 0.300097, -0.192101>, 
      <-0.905018, 0.120511, -0.213850>, <-0.912889, 0.173604, -0.218519>, <-0.913634, 0.247156, -0.218914>, <-0.905018, 0.300097, -0.213850>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.905018, 0.120511, -0.141354>, <-0.905018, 0.120511, -0.163103>, <-0.905018, 0.120511, -0.192101>, <-0.905018, 0.120511, -0.213850>, 
      <-0.903838, 0.112556, -0.141214>, <-0.903838, 0.112556, -0.162963>, <-0.903661, 0.111359, -0.191296>, <-0.903661, 0.111359, -0.213045>, 
      <-0.886397, 0.120226, -0.138937>, <-0.886397, 0.120226, -0.156895>, <-0.887330, 0.120511, -0.182624>, <-0.887330, 0.120511, -0.200583>, 
      <-0.878393, 0.120511, -0.138196>, <-0.878393, 0.120511, -0.156154>, <-0.878393, 0.120511, -0.180099>, <-0.878393, 0.120511, -0.198057>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.905018, 0.120511, -0.105106>, <-0.912918, 0.173796, -0.104169>, <-0.913671, 0.246930, -0.104089>, <-0.905018, 0.300097, -0.105106>, 
      <-0.905018, 0.120511, -0.115980>, <-0.912918, 0.173796, -0.115043>, <-0.913671, 0.246930, -0.114963>, <-0.905018, 0.300097, -0.115980>, 
      <-0.905018, 0.120511, -0.130480>, <-0.912918, 0.173796, -0.131417>, <-0.913671, 0.246930, -0.131497>, <-0.905018, 0.300097, -0.130480>, 
      <-0.905018, 0.120511, -0.141354>, <-0.912918, 0.173796, -0.142291>, <-0.913671, 0.246930, -0.142371>, <-0.905018, 0.300097, -0.141354>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.905018, 0.120511, -0.105106>, <-0.905018, 0.120511, -0.115980>, <-0.905018, 0.120511, -0.130480>, <-0.905018, 0.120511, -0.141354>, 
      <-0.903838, 0.112556, -0.105246>, <-0.903838, 0.112556, -0.116120>, <-0.903838, 0.112556, -0.130340>, <-0.903838, 0.112556, -0.141214>, 
      <-0.886427, 0.120234, -0.107998>, <-0.886427, 0.120234, -0.116978>, <-0.886397, 0.120226, -0.129958>, <-0.886397, 0.120226, -0.138937>, 
      <-0.878393, 0.120511, -0.108265>, <-0.878393, 0.120511, -0.117244>, <-0.878393, 0.120511, -0.129217>, <-0.878393, 0.120511, -0.138196>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.905018, 0.120511, -0.032610>, <-0.912889, 0.173604, -0.027941>, <-0.913634, 0.247156, -0.027546>, <-0.905018, 0.300097, -0.032610>, 
      <-0.905018, 0.120511, -0.054359>, <-0.912889, 0.173604, -0.049690>, <-0.913634, 0.247156, -0.049295>, <-0.905018, 0.300097, -0.054359>, 
      <-0.905018, 0.120511, -0.083357>, <-0.912918, 0.173796, -0.082420>, <-0.913671, 0.246930, -0.082340>, <-0.905018, 0.300097, -0.083357>, 
      <-0.905018, 0.120511, -0.105106>, <-0.912918, 0.173796, -0.104169>, <-0.913671, 0.246930, -0.104089>, <-0.905018, 0.300097, -0.105106>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.905018, 0.120511, -0.032610>, <-0.905018, 0.120511, -0.054359>, <-0.905018, 0.120511, -0.083357>, <-0.905018, 0.120511, -0.105106>, 
      <-0.903661, 0.111359, -0.033415>, <-0.903661, 0.111359, -0.055164>, <-0.903838, 0.112556, -0.083497>, <-0.903838, 0.112556, -0.105246>, 
      <-0.887402, 0.120511, -0.046148>, <-0.887402, 0.120511, -0.064107>, <-0.886427, 0.120234, -0.090040>, <-0.886427, 0.120234, -0.107998>, 
      <-0.878393, 0.120511, -0.048403>, <-0.878393, 0.120511, -0.066362>, <-0.878393, 0.120511, -0.090306>, <-0.878393, 0.120511, -0.108265>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.905018, 0.120511, 0.003638>, <-0.912861, 0.173413, 0.010151>, <-0.913598, 0.247379, 0.010698>, <-0.905018, 0.300097, 0.003638>, 
      <-0.905018, 0.120511, -0.007236>, <-0.912861, 0.173413, -0.000723>, <-0.913598, 0.247379, -0.000177>, <-0.905018, 0.300097, -0.007236>, 
      <-0.905018, 0.120511, -0.021736>, <-0.912889, 0.173604, -0.017067>, <-0.913634, 0.247156, -0.016672>, <-0.905018, 0.300097, -0.021736>, 
      <-0.905018, 0.120511, -0.032610>, <-0.912889, 0.173604, -0.027941>, <-0.913634, 0.247156, -0.027546>, <-0.905018, 0.300097, -0.032610>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.905018, 0.120511, 0.003638>, <-0.905018, 0.120511, -0.007236>, <-0.905018, 0.120511, -0.021736>, <-0.905018, 0.120511, -0.032610>, 
      <-0.903506, 0.110316, 0.002383>, <-0.903506, 0.110316, -0.008492>, <-0.903661, 0.111359, -0.022540>, <-0.903661, 0.111359, -0.033415>, 
      <-0.887939, 0.120511, -0.014389>, <-0.887939, 0.120511, -0.023368>, <-0.887402, 0.120511, -0.037169>, <-0.887402, 0.120511, -0.046148>, 
      <-0.878393, 0.120511, -0.018472>, <-0.878393, 0.120511, -0.027451>, <-0.878393, 0.120511, -0.039424>, <-0.878393, 0.120511, -0.048403>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.905018, 0.120511, 0.003638>, <-0.905018, 0.120511, 0.014512>, <-0.912219, 0.120511, 0.031738>, <-0.905018, 0.120511, 0.039886>, 
      <-0.912861, 0.173413, 0.010151>, <-0.912861, 0.173413, 0.021026>, <-0.920025, 0.173163, 0.040072>, <-0.912824, 0.173163, 0.048220>, 
      <-0.913598, 0.247379, 0.010698>, <-0.913598, 0.247379, 0.021572>, <-0.920752, 0.247672, 0.040764>, <-0.913550, 0.247672, 0.048912>, 
      <-0.905018, 0.300097, 0.003638>, <-0.905018, 0.300097, 0.014512>, <-0.912219, 0.300097, 0.031738>, <-0.905018, 0.300097, 0.039886>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.878393, 0.120511, 0.011459>, <-0.886381, 0.120511, 0.019987>, <-0.903325, 0.109092, 0.038079>, <-0.905018, 0.120511, 0.039886>, 
      <-0.883155, 0.120511, 0.003846>, <-0.891142, 0.120511, 0.012375>, <-0.910526, 0.109092, 0.029930>, <-0.912219, 0.120511, 0.031738>, 
      <-0.878393, 0.120511, -0.009493>, <-0.887939, 0.120511, -0.005410>, <-0.903506, 0.110316, 0.013257>, <-0.905018, 0.120511, 0.014512>, 
      <-0.878393, 0.120511, -0.018472>, <-0.887939, 0.120511, -0.014389>, <-0.903506, 0.110316, 0.002383>, <-0.905018, 0.120511, 0.003638>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.840948, 0.120511, 0.041390>, <-0.840948, 0.120511, 0.051813>, <-0.840948, 0.110278, 0.074154>, <-0.840948, 0.120511, 0.076134>, 
      <-0.854302, 0.120511, 0.036053>, <-0.854302, 0.120511, 0.046476>, <-0.862187, 0.110271, 0.068104>, <-0.862187, 0.120505, 0.070084>, 
      <-0.870766, 0.120511, 0.023651>, <-0.878754, 0.120511, 0.032180>, <-0.888701, 0.109092, 0.054626>, <-0.890394, 0.120511, 0.056434>, 
      <-0.878393, 0.120511, 0.011459>, <-0.886381, 0.120511, 0.019987>, <-0.903325, 0.109092, 0.038079>, <-0.905018, 0.120511, 0.039886>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.803503, 0.120511, 0.041390>, <-0.795780, 0.120523, 0.051813>, <-0.779628, 0.107946, 0.073696>, <-0.777759, 0.120550, 0.076134>, 
      <-0.814736, 0.120511, 0.041390>, <-0.807013, 0.120523, 0.051813>, <-0.798584, 0.107935, 0.073696>, <-0.796716, 0.120538, 0.076134>, 
      <-0.830517, 0.120511, 0.045559>, <-0.830517, 0.120511, 0.055982>, <-0.822716, 0.110283, 0.079347>, <-0.822716, 0.120517, 0.081327>, 
      <-0.840948, 0.120511, 0.041390>, <-0.840948, 0.120511, 0.051813>, <-0.840948, 0.110278, 0.074154>, <-0.840948, 0.120511, 0.076134>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.803503, 0.120511, 0.041390>, <-0.803503, 0.120511, 0.023431>, <-0.803503, 0.120511, -0.000513>, <-0.803503, 0.120511, -0.018472>, 
      <-0.795780, 0.120523, 0.051813>, <-0.795780, 0.120523, 0.033855>, <-0.794007, 0.120511, 0.003685>, <-0.794007, 0.120511, -0.014273>, 
      <-0.779628, 0.107946, 0.073696>, <-0.779363, 0.107935, 0.051947>, <-0.778566, 0.110324, 0.024133>, <-0.778389, 0.110316, 0.002383>, 
      <-0.777759, 0.120550, 0.076134>, <-0.777495, 0.120538, 0.054385>, <-0.777054, 0.120519, 0.025388>, <-0.776878, 0.120511, 0.003638>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.803503, 0.120511, -0.287850>, <-0.795516, 0.120511, -0.298273>, <-0.778770, 0.107753, -0.320126>, <-0.776878, 0.120511, -0.322594>, 
      <-0.803503, 0.120511, -0.269891>, <-0.795516, 0.120511, -0.280315>, <-0.778770, 0.107753, -0.298377>, <-0.776878, 0.120511, -0.300845>, 
      <-0.803503, 0.120511, -0.245947>, <-0.793883, 0.120511, -0.249851>, <-0.778389, 0.110316, -0.270592>, <-0.776878, 0.120511, -0.271847>, 
      <-0.803503, 0.120511, -0.227988>, <-0.793883, 0.120511, -0.231892>, <-0.778389, 0.110316, -0.248843>, <-0.776878, 0.120511, -0.250098>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.840948, 0.120511, -0.287850>, <-0.840948, 0.120511, -0.298273>, <-0.840948, 0.110278, -0.320614>, <-0.840948, 0.120511, -0.322594>, 
      <-0.830517, 0.120511, -0.292019>, <-0.830517, 0.120511, -0.302442>, <-0.822453, 0.110278, -0.325846>, <-0.822453, 0.120511, -0.327826>, 
      <-0.814736, 0.120511, -0.287850>, <-0.806749, 0.120511, -0.298273>, <-0.797991, 0.107753, -0.320126>, <-0.796099, 0.120511, -0.322594>, 
      <-0.803503, 0.120511, -0.287850>, <-0.795516, 0.120511, -0.298273>, <-0.778770, 0.107753, -0.320126>, <-0.776878, 0.120511, -0.322594>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.878393, 0.120511, -0.257919>, <-0.886381, 0.120511, -0.266447>, <-0.903325, 0.109092, -0.284539>, <-0.905018, 0.120511, -0.286346>, 
      <-0.870766, 0.120511, -0.270111>, <-0.878754, 0.120511, -0.278639>, <-0.888701, 0.109092, -0.301086>, <-0.890394, 0.120511, -0.302894>, 
      <-0.854302, 0.120511, -0.282513>, <-0.854302, 0.120511, -0.292936>, <-0.862198, 0.110278, -0.314603>, <-0.862198, 0.120511, -0.316583>, 
      <-0.840948, 0.120511, -0.287850>, <-0.840948, 0.120511, -0.298273>, <-0.840948, 0.110278, -0.320614>, <-0.840948, 0.120511, -0.322594>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.878393, 0.120511, -0.257919>, <-0.883155, 0.120511, -0.250306>, <-0.878393, 0.120511, -0.236967>, <-0.878393, 0.120511, -0.227988>, 
      <-0.886381, 0.120511, -0.266447>, <-0.891142, 0.120511, -0.258835>, <-0.888034, 0.120511, -0.240822>, <-0.888034, 0.120511, -0.231842>, 
      <-0.903325, 0.109092, -0.284539>, <-0.910526, 0.109092, -0.276390>, <-0.903506, 0.110316, -0.259717>, <-0.903506, 0.110316, -0.248843>, 
      <-0.905018, 0.120511, -0.286346>, <-0.912219, 0.120511, -0.278198>, <-0.905018, 0.120511, -0.260972>, <-0.905018, 0.120511, -0.250098>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.396132, 0.479682, -0.116346>, <0.391185, 0.480455, -0.116561>, <0.385291, 0.483864, -0.113142>, <0.380280, 0.483864, -0.113142>, 
      <0.396132, 0.479682, -0.120477>, <0.391185, 0.480455, -0.120692>, <0.384984, 0.489590, -0.113539>, <0.379972, 0.489590, -0.113539>, 
      <0.396132, 0.479682, -0.125984>, <0.391443, 0.480269, -0.125589>, <0.385221, 0.488694, -0.131918>, <0.380479, 0.488694, -0.131918>, 
      <0.396132, 0.479682, -0.130115>, <0.391443, 0.480269, -0.129720>, <0.385565, 0.482968, -0.132272>, <0.380823, 0.482968, -0.132272>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.396132, 0.479682, -0.116346>, <0.396132, 0.479682, -0.120477>, <0.396132, 0.479682, -0.125984>, <0.396132, 0.479682, -0.130115>, 
      <0.408960, 0.371931, -0.113922>, <0.408960, 0.371931, -0.118052>, <0.408960, 0.371931, -0.128409>, <0.408960, 0.371931, -0.132539>, 
      <0.426065, 0.228262, -0.110689>, <0.426065, 0.228262, -0.119669>, <0.426065, 0.228262, -0.126792>, <0.426065, 0.228262, -0.135772>, 
      <0.438893, 0.120511, -0.108265>, <0.438893, 0.120511, -0.117244>, <0.438893, 0.120511, -0.129217>, <0.438893, 0.120511, -0.138196>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.361680, 0.479682, -0.116346>, <0.361680, 0.479682, -0.120477>, <0.361680, 0.479682, -0.125984>, <0.361680, 0.479682, -0.130115>, 
      <0.367418, 0.480495, -0.116572>, <0.367418, 0.480495, -0.120703>, <0.367493, 0.480317, -0.125557>, <0.367493, 0.480317, -0.129688>, 
      <0.374480, 0.483864, -0.113142>, <0.374173, 0.489590, -0.113539>, <0.374617, 0.488694, -0.131918>, <0.374960, 0.482968, -0.132272>, 
      <0.380280, 0.483864, -0.113142>, <0.379972, 0.489590, -0.113539>, <0.380479, 0.488694, -0.131918>, <0.380823, 0.482968, -0.132272>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.361680, 0.479682, -0.116346>, <0.361680, 0.479682, -0.120477>, <0.361680, 0.479682, -0.125984>, <0.361680, 0.479682, -0.130115>, 
      <0.362377, 0.371931, -0.113922>, <0.362377, 0.371931, -0.118052>, <0.362377, 0.371931, -0.128409>, <0.362377, 0.371931, -0.132539>, 
      <0.363306, 0.228262, -0.110689>, <0.363306, 0.228262, -0.119669>, <0.363306, 0.228262, -0.126792>, <0.363306, 0.228262, -0.135772>, 
      <0.364003, 0.120511, -0.108265>, <0.364003, 0.120511, -0.117244>, <0.364003, 0.120511, -0.129217>, <0.364003, 0.120511, -0.138196>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.396132, 0.479682, -0.157653>, <0.396132, 0.479682, -0.161784>, <0.396132, 0.479682, -0.167291>, <0.396132, 0.479682, -0.171422>, 
      <0.392345, 0.479673, -0.154317>, <0.392345, 0.479673, -0.158448>, <0.393039, 0.480122, -0.163728>, <0.393039, 0.480122, -0.167859>, 
      <0.384536, 0.479620, -0.155203>, <0.384261, 0.484706, -0.154871>, <0.385228, 0.488426, -0.170771>, <0.385528, 0.483423, -0.171734>, 
      <0.379489, 0.479620, -0.155203>, <0.379214, 0.484706, -0.154871>, <0.380490, 0.488426, -0.170771>, <0.380789, 0.483423, -0.171734>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.396132, 0.479682, -0.157653>, <0.396132, 0.479682, -0.149392>, <0.396132, 0.479682, -0.138376>, <0.396132, 0.479682, -0.130115>, 
      <0.392345, 0.479673, -0.154317>, <0.392345, 0.479673, -0.146056>, <0.391443, 0.480269, -0.137981>, <0.391443, 0.480269, -0.129720>, 
      <0.384536, 0.479620, -0.155203>, <0.384936, 0.480624, -0.148324>, <0.385165, 0.481964, -0.139151>, <0.385565, 0.482968, -0.132272>, 
      <0.379489, 0.479620, -0.155203>, <0.379889, 0.480624, -0.148324>, <0.380423, 0.481964, -0.139151>, <0.380823, 0.482968, -0.132272>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.438893, 0.120511, -0.198057>, <0.438893, 0.120511, -0.207036>, <0.438893, 0.120511, -0.219009>, <0.438893, 0.120511, -0.227988>, 
      <0.426065, 0.228262, -0.185936>, <0.426065, 0.228262, -0.194915>, <0.426065, 0.228262, -0.202039>, <0.426065, 0.228262, -0.211018>, 
      <0.408960, 0.371931, -0.169774>, <0.408960, 0.371931, -0.173905>, <0.408960, 0.371931, -0.184261>, <0.408960, 0.371931, -0.188392>, 
      <0.396132, 0.479682, -0.157653>, <0.396132, 0.479682, -0.161784>, <0.396132, 0.479682, -0.167291>, <0.396132, 0.479682, -0.171422>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.438893, 0.120511, -0.198057>, <0.426065, 0.228262, -0.185936>, <0.408960, 0.371931, -0.169774>, <0.396132, 0.479682, -0.157653>, 
      <0.438893, 0.120511, -0.180099>, <0.426065, 0.228262, -0.167978>, <0.408960, 0.371931, -0.161513>, <0.396132, 0.479682, -0.149392>, 
      <0.438893, 0.120511, -0.156154>, <0.426065, 0.228262, -0.153730>, <0.408960, 0.371931, -0.140801>, <0.396132, 0.479682, -0.138376>, 
      <0.438893, 0.120511, -0.138196>, <0.426065, 0.228262, -0.135772>, <0.408960, 0.371931, -0.132539>, <0.396132, 0.479682, -0.130115>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.361680, 0.479682, -0.157653>, <0.365799, 0.479673, -0.154172>, <0.374096, 0.479620, -0.155203>, <0.379489, 0.479620, -0.155203>, 
      <0.361680, 0.479682, -0.149392>, <0.365799, 0.479673, -0.145910>, <0.374496, 0.480624, -0.148324>, <0.379889, 0.480624, -0.148324>, 
      <0.361680, 0.479682, -0.138376>, <0.367493, 0.480317, -0.137949>, <0.374560, 0.481964, -0.139151>, <0.380423, 0.481964, -0.139151>, 
      <0.361680, 0.479682, -0.130115>, <0.367493, 0.480317, -0.129688>, <0.374960, 0.482968, -0.132272>, <0.380823, 0.482968, -0.132272>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.361680, 0.479682, -0.157653>, <0.365799, 0.479673, -0.154172>, <0.374096, 0.479620, -0.155203>, <0.379489, 0.479620, -0.155203>, 
      <0.361680, 0.479682, -0.161784>, <0.365799, 0.479673, -0.158302>, <0.373821, 0.484706, -0.154871>, <0.379214, 0.484706, -0.154871>, 
      <0.361680, 0.479682, -0.167291>, <0.365780, 0.480193, -0.163161>, <0.374648, 0.488426, -0.170771>, <0.380490, 0.488426, -0.170771>, 
      <0.361680, 0.479682, -0.171422>, <0.365780, 0.480193, -0.167291>, <0.374947, 0.483423, -0.171734>, <0.380789, 0.483423, -0.171734>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.364003, 0.120511, -0.198057>, <0.364003, 0.120511, -0.180099>, <0.364003, 0.120511, -0.156154>, <0.364003, 0.120511, -0.138196>, 
      <0.363306, 0.228262, -0.185936>, <0.363306, 0.228262, -0.167978>, <0.363306, 0.228262, -0.153730>, <0.363306, 0.228262, -0.135772>, 
      <0.362377, 0.371931, -0.169774>, <0.362377, 0.371931, -0.161513>, <0.362377, 0.371931, -0.140801>, <0.362377, 0.371931, -0.132539>, 
      <0.361680, 0.479682, -0.157653>, <0.361680, 0.479682, -0.149392>, <0.361680, 0.479682, -0.138376>, <0.361680, 0.479682, -0.130115>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.364003, 0.120511, -0.198057>, <0.363306, 0.228262, -0.185936>, <0.362377, 0.371931, -0.169774>, <0.361680, 0.479682, -0.157653>, 
      <0.364003, 0.120511, -0.207036>, <0.363306, 0.228262, -0.194915>, <0.362377, 0.371931, -0.173905>, <0.361680, 0.479682, -0.161784>, 
      <0.364003, 0.120511, -0.219009>, <0.363306, 0.228262, -0.202039>, <0.362377, 0.371931, -0.184261>, <0.361680, 0.479682, -0.167291>, 
      <0.364003, 0.120511, -0.227988>, <0.363306, 0.228262, -0.211018>, <0.362377, 0.371931, -0.188392>, <0.361680, 0.479682, -0.171422>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.396132, 0.479682, -0.088807>, <0.396132, 0.479682, -0.097069>, <0.396132, 0.479682, -0.108084>, <0.396132, 0.479682, -0.116346>, 
      <0.392565, 0.479498, -0.092236>, <0.392565, 0.479498, -0.100498>, <0.391185, 0.480455, -0.108300>, <0.391185, 0.480455, -0.116561>, 
      <0.385131, 0.478296, -0.092809>, <0.385161, 0.479966, -0.098909>, <0.385261, 0.482194, -0.107042>, <0.385291, 0.483864, -0.113142>, 
      <0.380180, 0.478296, -0.092809>, <0.380210, 0.479966, -0.098909>, <0.380250, 0.482194, -0.107042>, <0.380280, 0.483864, -0.113142>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.396132, 0.479682, -0.088807>, <0.396132, 0.479682, -0.097069>, <0.396132, 0.479682, -0.108084>, <0.396132, 0.479682, -0.116346>, 
      <0.408960, 0.371931, -0.076686>, <0.408960, 0.371931, -0.084947>, <0.408960, 0.371931, -0.105660>, <0.408960, 0.371931, -0.113922>, 
      <0.426065, 0.228262, -0.060524>, <0.426065, 0.228262, -0.078483>, <0.426065, 0.228262, -0.092731>, <0.426065, 0.228262, -0.110689>, 
      <0.438893, 0.120511, -0.048403>, <0.438893, 0.120511, -0.066362>, <0.438893, 0.120511, -0.090306>, <0.438893, 0.120511, -0.108265>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.361680, 0.479682, -0.088807>, <0.365955, 0.479481, -0.092562>, <0.374486, 0.478296, -0.092809>, <0.380180, 0.478296, -0.092809>, 
      <0.361680, 0.479682, -0.097069>, <0.365955, 0.479481, -0.100823>, <0.374516, 0.479966, -0.098909>, <0.380210, 0.479966, -0.098909>, 
      <0.361680, 0.479682, -0.108084>, <0.367418, 0.480495, -0.108311>, <0.374451, 0.482194, -0.107042>, <0.380250, 0.482194, -0.107042>, 
      <0.361680, 0.479682, -0.116346>, <0.367418, 0.480495, -0.116572>, <0.374480, 0.483864, -0.113142>, <0.380280, 0.483864, -0.113142>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.361680, 0.479682, -0.088807>, <0.361680, 0.479682, -0.097069>, <0.361680, 0.479682, -0.108084>, <0.361680, 0.479682, -0.116346>, 
      <0.362377, 0.371931, -0.076686>, <0.362377, 0.371931, -0.084947>, <0.362377, 0.371931, -0.105660>, <0.362377, 0.371931, -0.113922>, 
      <0.363306, 0.228262, -0.060524>, <0.363306, 0.228262, -0.078483>, <0.363306, 0.228262, -0.092731>, <0.363306, 0.228262, -0.110689>, 
      <0.364003, 0.120511, -0.048403>, <0.364003, 0.120511, -0.066362>, <0.364003, 0.120511, -0.090306>, <0.364003, 0.120511, -0.108265>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.361680, 0.479682, -0.075038>, <0.364881, 0.479724, -0.079355>, <0.372952, 0.480040, -0.081652>, <0.378327, 0.480040, -0.081652>, 
      <0.361680, 0.479682, -0.079169>, <0.364881, 0.479724, -0.083486>, <0.372762, 0.483407, -0.082297>, <0.378137, 0.483407, -0.082297>, 
      <0.361680, 0.479682, -0.084676>, <0.365955, 0.479481, -0.088431>, <0.374294, 0.481710, -0.093116>, <0.379987, 0.481710, -0.093116>, 
      <0.361680, 0.479682, -0.088807>, <0.365955, 0.479481, -0.092562>, <0.374486, 0.478296, -0.092809>, <0.380180, 0.478296, -0.092809>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.361680, 0.479682, -0.075038>, <0.361680, 0.479682, -0.079169>, <0.361680, 0.479682, -0.084676>, <0.361680, 0.479682, -0.088807>, 
      <0.362377, 0.371931, -0.058068>, <0.362377, 0.371931, -0.062199>, <0.362377, 0.371931, -0.072555>, <0.362377, 0.371931, -0.076686>, 
      <0.363306, 0.228262, -0.035442>, <0.363306, 0.228262, -0.044421>, <0.363306, 0.228262, -0.051545>, <0.363306, 0.228262, -0.060524>, 
      <0.364003, 0.120511, -0.018472>, <0.364003, 0.120511, -0.027451>, <0.364003, 0.120511, -0.039424>, <0.364003, 0.120511, -0.048403>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.396132, 0.479682, -0.075038>, <0.396132, 0.479682, -0.079169>, <0.396132, 0.479682, -0.084676>, <0.396132, 0.479682, -0.088807>, 
      <0.392648, 0.479725, -0.079548>, <0.392648, 0.479725, -0.083679>, <0.392565, 0.479498, -0.088106>, <0.392565, 0.479498, -0.092236>, 
      <0.384026, 0.480040, -0.081652>, <0.383836, 0.483407, -0.082297>, <0.384939, 0.481710, -0.093116>, <0.385131, 0.478296, -0.092809>, 
      <0.378327, 0.480040, -0.081652>, <0.378137, 0.483407, -0.082297>, <0.379987, 0.481710, -0.093116>, <0.380180, 0.478296, -0.092809>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.396132, 0.479682, -0.075038>, <0.408960, 0.371931, -0.058068>, <0.426065, 0.228262, -0.035442>, <0.438893, 0.120511, -0.018472>, 
      <0.396132, 0.479682, -0.079169>, <0.408960, 0.371931, -0.062199>, <0.426065, 0.228262, -0.044421>, <0.438893, 0.120511, -0.027451>, 
      <0.396132, 0.479682, -0.084676>, <0.408960, 0.371931, -0.072555>, <0.426065, 0.228262, -0.051545>, <0.438893, 0.120511, -0.039424>, 
      <0.396132, 0.479682, -0.088807>, <0.408960, 0.371931, -0.076686>, <0.426065, 0.228262, -0.060524>, <0.438893, 0.120511, -0.048403>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.400386, 0.120511, -0.195444>, <0.394019, 0.226960, -0.174965>, <0.385332, 0.371420, -0.162272>, <0.379489, 0.479620, -0.155203>, 
      <0.411965, 0.120511, -0.195444>, <0.405598, 0.226960, -0.174965>, <0.390379, 0.371420, -0.162272>, <0.384536, 0.479620, -0.155203>, 
      <0.427751, 0.120511, -0.194908>, <0.414922, 0.228262, -0.182787>, <0.405174, 0.371922, -0.166438>, <0.392345, 0.479673, -0.154317>, 
      <0.438893, 0.120511, -0.198057>, <0.426065, 0.228262, -0.185936>, <0.408960, 0.371931, -0.169774>, <0.396132, 0.479682, -0.157653>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.400386, 0.120511, -0.195444>, <0.394019, 0.226960, -0.174965>, <0.385332, 0.371420, -0.162272>, <0.379489, 0.479620, -0.155203>, 
      <0.389443, 0.120511, -0.195444>, <0.383076, 0.226960, -0.174965>, <0.379939, 0.371420, -0.162272>, <0.374096, 0.479620, -0.155203>, 
      <0.374507, 0.120511, -0.194989>, <0.373810, 0.228262, -0.182867>, <0.366496, 0.371922, -0.166293>, <0.365799, 0.479673, -0.154172>, 
      <0.364003, 0.120511, -0.198057>, <0.363306, 0.228262, -0.185936>, <0.362377, 0.371931, -0.169774>, <0.361680, 0.479682, -0.157653>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.401944, 0.122774, -0.135469>, <0.413080, 0.122774, -0.135469>, <0.427812, 0.120906, -0.137170>, <0.438893, 0.120511, -0.138196>, 
      <0.396149, 0.230607, -0.142952>, <0.407284, 0.230607, -0.142952>, <0.414984, 0.228657, -0.134746>, <0.426065, 0.228262, -0.135772>, 
      <0.387294, 0.375119, -0.138940>, <0.392035, 0.375119, -0.138940>, <0.404272, 0.372518, -0.132144>, <0.408960, 0.371931, -0.132539>, 
      <0.380823, 0.482968, -0.132272>, <0.385565, 0.482968, -0.132272>, <0.391443, 0.480269, -0.129720>, <0.396132, 0.479682, -0.130115>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.401944, 0.122774, -0.135469>, <0.396149, 0.230607, -0.142952>, <0.387294, 0.375119, -0.138940>, <0.380823, 0.482968, -0.132272>, 
      <0.390512, 0.122774, -0.135469>, <0.384717, 0.230607, -0.142952>, <0.381431, 0.375119, -0.138940>, <0.374960, 0.482968, -0.132272>, 
      <0.375381, 0.120910, -0.137159>, <0.374684, 0.228661, -0.134735>, <0.368189, 0.372566, -0.132112>, <0.367493, 0.480317, -0.129688>, 
      <0.364003, 0.120511, -0.138196>, <0.363306, 0.228262, -0.135772>, <0.362377, 0.371931, -0.132539>, <0.361680, 0.479682, -0.130115>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.400181, 0.122765, -0.107276>, <0.411818, 0.122765, -0.107276>, <0.427269, 0.120912, -0.108651>, <0.438893, 0.120511, -0.108265>, 
      <0.400688, 0.114322, -0.107798>, <0.412325, 0.114322, -0.107798>, <0.427269, 0.120912, -0.117630>, <0.438893, 0.120511, -0.117244>, 
      <0.402398, 0.114332, -0.134883>, <0.413533, 0.114332, -0.134883>, <0.427812, 0.120906, -0.128191>, <0.438893, 0.120511, -0.129217>, 
      <0.401944, 0.122774, -0.135469>, <0.413080, 0.122774, -0.135469>, <0.427812, 0.120906, -0.137170>, <0.438893, 0.120511, -0.138196>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.400181, 0.122765, -0.107276>, <0.393695, 0.230873, -0.100592>, <0.386089, 0.375771, -0.105641>, <0.380280, 0.483864, -0.113142>, 
      <0.411818, 0.122765, -0.107276>, <0.405332, 0.230873, -0.100592>, <0.391101, 0.375771, -0.105641>, <0.385291, 0.483864, -0.113142>, 
      <0.427269, 0.120912, -0.108651>, <0.414441, 0.228663, -0.111075>, <0.404014, 0.372703, -0.114137>, <0.391185, 0.480455, -0.116561>, 
      <0.438893, 0.120511, -0.108265>, <0.426065, 0.228262, -0.110689>, <0.408960, 0.371931, -0.113922>, <0.396132, 0.479682, -0.116346>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.400181, 0.122765, -0.107276>, <0.400688, 0.114322, -0.107798>, <0.402398, 0.114332, -0.134883>, <0.401944, 0.122774, -0.135469>, 
      <0.389303, 0.122765, -0.107276>, <0.389809, 0.114322, -0.107798>, <0.390966, 0.114332, -0.134883>, <0.390512, 0.122774, -0.135469>, 
      <0.374868, 0.120901, -0.108640>, <0.374868, 0.120901, -0.117620>, <0.375381, 0.120910, -0.128180>, <0.375381, 0.120910, -0.137159>, 
      <0.364003, 0.120511, -0.108265>, <0.364003, 0.120511, -0.117244>, <0.364003, 0.120511, -0.129217>, <0.364003, 0.120511, -0.138196>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.400181, 0.122765, -0.107276>, <0.389303, 0.122765, -0.107276>, <0.374868, 0.120901, -0.108640>, <0.364003, 0.120511, -0.108265>, 
      <0.393695, 0.230873, -0.100592>, <0.382816, 0.230873, -0.100592>, <0.374171, 0.228652, -0.111065>, <0.363306, 0.228262, -0.110689>, 
      <0.386089, 0.375771, -0.105641>, <0.380290, 0.375771, -0.105641>, <0.368115, 0.372743, -0.114148>, <0.362377, 0.371931, -0.113922>, 
      <0.380280, 0.483864, -0.113142>, <0.374480, 0.483864, -0.113142>, <0.367418, 0.480495, -0.116572>, <0.361680, 0.479682, -0.116346>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.398640, 0.120511, -0.049347>, <0.392644, 0.226678, -0.069699>, <0.386263, 0.370634, -0.083135>, <0.380180, 0.478296, -0.092809>, 
      <0.410719, 0.120511, -0.049347>, <0.404723, 0.226678, -0.069699>, <0.391214, 0.370634, -0.083135>, <0.385131, 0.478296, -0.092809>, 
      <0.427175, 0.120511, -0.051335>, <0.414347, 0.228262, -0.063457>, <0.405393, 0.371747, -0.080115>, <0.392565, 0.479498, -0.092236>, 
      <0.438893, 0.120511, -0.048403>, <0.426065, 0.228262, -0.060524>, <0.408960, 0.371931, -0.076686>, <0.396132, 0.479682, -0.088807>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.398640, 0.120511, -0.049347>, <0.392644, 0.226678, -0.069699>, <0.386263, 0.370634, -0.083135>, <0.380180, 0.478296, -0.092809>, 
      <0.388245, 0.120511, -0.049347>, <0.382249, 0.226678, -0.069699>, <0.380569, 0.370634, -0.083135>, <0.374486, 0.478296, -0.092809>, 
      <0.374030, 0.120511, -0.051143>, <0.373334, 0.228262, -0.063264>, <0.366652, 0.371729, -0.080440>, <0.365955, 0.479481, -0.092562>, 
      <0.364003, 0.120511, -0.048403>, <0.363306, 0.228262, -0.060524>, <0.362377, 0.371931, -0.076686>, <0.361680, 0.479682, -0.088807>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.400386, 0.120511, -0.024222>, <0.400811, 0.112998, -0.023547>, <0.399058, 0.113102, -0.047927>, <0.398640, 0.120511, -0.049347>, 
      <0.412066, 0.120511, -0.024222>, <0.412491, 0.112998, -0.023547>, <0.411138, 0.113102, -0.047927>, <0.410719, 0.120511, -0.049347>, 
      <0.428154, 0.120511, -0.023066>, <0.428154, 0.120511, -0.032045>, <0.427175, 0.120511, -0.042356>, <0.427175, 0.120511, -0.051335>, 
      <0.438893, 0.120511, -0.018472>, <0.438893, 0.120511, -0.027451>, <0.438893, 0.120511, -0.039424>, <0.438893, 0.120511, -0.048403>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.400386, 0.120511, -0.024222>, <0.412066, 0.120511, -0.024222>, <0.428154, 0.120511, -0.023066>, <0.438893, 0.120511, -0.018472>, 
      <0.394238, 0.229326, -0.033999>, <0.405918, 0.229326, -0.033999>, <0.415326, 0.228262, -0.040035>, <0.426065, 0.228262, -0.035442>, 
      <0.384387, 0.372735, -0.061082>, <0.390086, 0.372735, -0.061082>, <0.405476, 0.371974, -0.062578>, <0.408960, 0.371931, -0.058068>, 
      <0.378327, 0.480040, -0.081652>, <0.384026, 0.480040, -0.081652>, <0.392648, 0.479725, -0.079548>, <0.396132, 0.479682, -0.075038>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.400386, 0.120511, -0.024222>, <0.400811, 0.112998, -0.023547>, <0.399058, 0.113102, -0.047927>, <0.398640, 0.120511, -0.049347>, 
      <0.389336, 0.120511, -0.024222>, <0.389760, 0.112998, -0.023547>, <0.388664, 0.113102, -0.047927>, <0.388245, 0.120511, -0.049347>, 
      <0.374109, 0.120511, -0.022941>, <0.374109, 0.120511, -0.031920>, <0.374030, 0.120511, -0.042163>, <0.374030, 0.120511, -0.051143>, 
      <0.364003, 0.120511, -0.018472>, <0.364003, 0.120511, -0.027451>, <0.364003, 0.120511, -0.039424>, <0.364003, 0.120511, -0.048403>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.400386, 0.120511, -0.024222>, <0.394238, 0.229326, -0.033999>, <0.384387, 0.372735, -0.061082>, <0.378327, 0.480040, -0.081652>, 
      <0.389336, 0.120511, -0.024222>, <0.383188, 0.229326, -0.033999>, <0.379012, 0.372735, -0.061082>, <0.372952, 0.480040, -0.081652>, 
      <0.374109, 0.120511, -0.022941>, <0.373413, 0.228262, -0.039911>, <0.365578, 0.371972, -0.062386>, <0.364881, 0.479724, -0.079355>, 
      <0.364003, 0.120511, -0.018472>, <0.363306, 0.228262, -0.035442>, <0.362377, 0.371931, -0.058068>, <0.361680, 0.479682, -0.075038>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.350751, 0.479682, -0.066966>, <0.351689, 0.486617, -0.069136>, <0.356178, 0.479941, -0.083975>, <0.361680, 0.479682, -0.088807>, 
      <0.350751, 0.479682, -0.060214>, <0.351689, 0.486617, -0.062384>, <0.356178, 0.479941, -0.079845>, <0.361680, 0.479682, -0.084676>, 
      <0.350751, 0.479682, -0.051212>, <0.351949, 0.488537, -0.055091>, <0.355878, 0.479607, -0.071344>, <0.361680, 0.479682, -0.079169>, 
      <0.350751, 0.479682, -0.044460>, <0.351949, 0.488537, -0.048340>, <0.355878, 0.479607, -0.067213>, <0.361680, 0.479682, -0.075038>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.350751, 0.479682, -0.111977>, <0.351224, 0.483174, -0.112196>, <0.358187, 0.479187, -0.116208>, <0.361680, 0.479682, -0.116346>, 
      <0.350751, 0.479682, -0.098474>, <0.351224, 0.483174, -0.098692>, <0.358187, 0.479187, -0.107947>, <0.361680, 0.479682, -0.108084>, 
      <0.350751, 0.479682, -0.080469>, <0.351689, 0.486617, -0.082639>, <0.356178, 0.479941, -0.092237>, <0.361680, 0.479682, -0.097069>, 
      <0.350751, 0.479682, -0.066966>, <0.351689, 0.486617, -0.069136>, <0.356178, 0.479941, -0.083975>, <0.361680, 0.479682, -0.088807>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.350751, 0.479682, -0.134483>, <0.351224, 0.483174, -0.134264>, <0.358179, 0.479299, -0.130372>, <0.361680, 0.479682, -0.130115>, 
      <0.350751, 0.479682, -0.127731>, <0.351224, 0.483174, -0.127513>, <0.358179, 0.479299, -0.126242>, <0.361680, 0.479682, -0.125984>, 
      <0.350751, 0.479682, -0.118729>, <0.351224, 0.483174, -0.118947>, <0.358187, 0.479187, -0.120339>, <0.361680, 0.479682, -0.120477>, 
      <0.350751, 0.479682, -0.111977>, <0.351224, 0.483174, -0.112196>, <0.358187, 0.479187, -0.116208>, <0.361680, 0.479682, -0.116346>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.350751, 0.479682, -0.179494>, <0.351689, 0.486617, -0.177324>, <0.356084, 0.479694, -0.162383>, <0.361680, 0.479682, -0.157653>, 
      <0.350751, 0.479682, -0.165991>, <0.351689, 0.486617, -0.163821>, <0.356084, 0.479694, -0.154121>, <0.361680, 0.479682, -0.149392>, 
      <0.350751, 0.479682, -0.147986>, <0.351224, 0.483174, -0.147768>, <0.358179, 0.479299, -0.138634>, <0.361680, 0.479682, -0.138376>, 
      <0.350751, 0.479682, -0.134483>, <0.351224, 0.483174, -0.134264>, <0.358179, 0.479299, -0.130372>, <0.361680, 0.479682, -0.130115>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.350751, 0.479682, -0.202000>, <0.351949, 0.488537, -0.198121>, <0.354844, 0.478831, -0.178310>, <0.361680, 0.479682, -0.171422>, 
      <0.350751, 0.479682, -0.195248>, <0.351949, 0.488537, -0.191369>, <0.354844, 0.478831, -0.174179>, <0.361680, 0.479682, -0.167291>, 
      <0.350751, 0.479682, -0.186246>, <0.351689, 0.486617, -0.184076>, <0.356084, 0.479694, -0.166514>, <0.361680, 0.479682, -0.161784>, 
      <0.350751, 0.479682, -0.179494>, <0.351689, 0.486617, -0.177324>, <0.356084, 0.479694, -0.162383>, <0.361680, 0.479682, -0.157653>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.407061, 0.479682, -0.179494>, <0.404526, 0.486243, -0.177441>, <0.401630, 0.479694, -0.162496>, <0.396132, 0.479682, -0.157653>, 
      <0.407061, 0.479682, -0.186246>, <0.404526, 0.486243, -0.184193>, <0.401630, 0.479694, -0.166627>, <0.396132, 0.479682, -0.161784>, 
      <0.407061, 0.479682, -0.195248>, <0.403811, 0.488094, -0.191563>, <0.402490, 0.478777, -0.174616>, <0.396132, 0.479682, -0.167291>, 
      <0.407061, 0.479682, -0.202000>, <0.403811, 0.488094, -0.198315>, <0.402490, 0.478777, -0.178747>, <0.396132, 0.479682, -0.171422>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.407061, 0.479682, -0.134483>, <0.405791, 0.482970, -0.134277>, <0.399623, 0.479245, -0.130409>, <0.396132, 0.479682, -0.130115>, 
      <0.407061, 0.479682, -0.147986>, <0.405791, 0.482970, -0.147781>, <0.399623, 0.479245, -0.138671>, <0.396132, 0.479682, -0.138376>, 
      <0.407061, 0.479682, -0.165991>, <0.404526, 0.486243, -0.163938>, <0.401630, 0.479694, -0.154235>, <0.396132, 0.479682, -0.149392>, 
      <0.407061, 0.479682, -0.179494>, <0.404526, 0.486243, -0.177441>, <0.401630, 0.479694, -0.162496>, <0.396132, 0.479682, -0.157653>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.407061, 0.479682, -0.111977>, <0.405791, 0.482970, -0.112183>, <0.399618, 0.479138, -0.116194>, <0.396132, 0.479682, -0.116346>, 
      <0.407061, 0.479682, -0.118729>, <0.405791, 0.482970, -0.118935>, <0.399618, 0.479138, -0.120325>, <0.396132, 0.479682, -0.120477>, 
      <0.407061, 0.479682, -0.127731>, <0.405791, 0.482970, -0.127525>, <0.399623, 0.479245, -0.126278>, <0.396132, 0.479682, -0.125984>, 
      <0.407061, 0.479682, -0.134483>, <0.405791, 0.482970, -0.134277>, <0.399623, 0.479245, -0.130409>, <0.396132, 0.479682, -0.130115>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.407061, 0.479682, -0.066966>, <0.404526, 0.486243, -0.069019>, <0.401410, 0.479954, -0.083733>, <0.396132, 0.479682, -0.088807>, 
      <0.407061, 0.479682, -0.080469>, <0.404526, 0.486243, -0.082522>, <0.401410, 0.479954, -0.091994>, <0.396132, 0.479682, -0.097069>, 
      <0.407061, 0.479682, -0.098474>, <0.405791, 0.482970, -0.098680>, <0.399618, 0.479138, -0.107933>, <0.396132, 0.479682, -0.108084>, 
      <0.407061, 0.479682, -0.111977>, <0.405791, 0.482970, -0.112183>, <0.399618, 0.479138, -0.116194>, <0.396132, 0.479682, -0.116346>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.407061, 0.479682, -0.044460>, <0.403811, 0.488094, -0.048145>, <0.402088, 0.479608, -0.067329>, <0.396132, 0.479682, -0.075038>, 
      <0.407061, 0.479682, -0.051212>, <0.403811, 0.488094, -0.054897>, <0.402088, 0.479608, -0.071460>, <0.396132, 0.479682, -0.079169>, 
      <0.407061, 0.479682, -0.060214>, <0.404526, 0.486243, -0.062267>, <0.401410, 0.479954, -0.079602>, <0.396132, 0.479682, -0.084676>, 
      <0.407061, 0.479682, -0.066966>, <0.404526, 0.486243, -0.069019>, <0.401410, 0.479954, -0.083733>, <0.396132, 0.479682, -0.088807>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.396132, 0.479682, -0.061269>, <0.398323, 0.479682, -0.064771>, <0.396132, 0.479682, -0.070907>, <0.396132, 0.479682, -0.075038>, 
      <0.399411, 0.479682, -0.049475>, <0.401601, 0.479682, -0.052977>, <0.402088, 0.479608, -0.063199>, <0.402088, 0.479608, -0.067329>, 
      <0.403156, 0.489791, -0.027649>, <0.406736, 0.489791, -0.033373>, <0.403811, 0.488094, -0.041394>, <0.403811, 0.488094, -0.048145>, 
      <0.407061, 0.479682, -0.021955>, <0.410641, 0.479682, -0.027679>, <0.407061, 0.479682, -0.037708>, <0.407061, 0.479682, -0.044460>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.396132, 0.479682, -0.061269>, <0.399411, 0.479682, -0.049475>, <0.403156, 0.489791, -0.027649>, <0.407061, 0.479682, -0.021955>, 
      <0.392624, 0.479682, -0.055660>, <0.395902, 0.479682, -0.043866>, <0.397421, 0.489791, -0.018481>, <0.401326, 0.479682, -0.012787>, 
      <0.385049, 0.479682, -0.049955>, <0.385151, 0.479619, -0.035540>, <0.387465, 0.491493, -0.011593>, <0.388947, 0.479682, -0.003462>, 
      <0.378906, 0.479682, -0.047500>, <0.379008, 0.479619, -0.033085>, <0.377424, 0.491493, -0.007580>, <0.378906, 0.479682, 0.000551>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.396132, 0.479682, -0.061269>, <0.392624, 0.479682, -0.055660>, <0.385049, 0.479682, -0.049955>, <0.378906, 0.479682, -0.047500>, 
      <0.398323, 0.479682, -0.064771>, <0.394814, 0.479682, -0.059162>, <0.384977, 0.479727, -0.060202>, <0.378834, 0.479727, -0.057747>, 
      <0.396132, 0.479682, -0.070907>, <0.392648, 0.479725, -0.075417>, <0.384200, 0.479933, -0.071406>, <0.378501, 0.479933, -0.071406>, 
      <0.396132, 0.479682, -0.075038>, <0.392648, 0.479725, -0.079548>, <0.384026, 0.480040, -0.081652>, <0.378327, 0.480040, -0.081652>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.361680, 0.479682, -0.047500>, <0.366848, 0.479682, -0.047500>, <0.374107, 0.479682, -0.045582>, <0.378906, 0.479682, -0.047500>, 
      <0.358401, 0.479682, -0.033085>, <0.363569, 0.479682, -0.033085>, <0.374209, 0.479619, -0.031167>, <0.379008, 0.479619, -0.033085>, 
      <0.352389, 0.491784, -0.007781>, <0.360835, 0.491784, -0.007781>, <0.369580, 0.491493, -0.004445>, <0.377424, 0.491493, -0.007580>, 
      <0.350751, 0.479682, 0.000551>, <0.359198, 0.479682, 0.000551>, <0.371063, 0.479682, 0.003686>, <0.378906, 0.479682, 0.000551>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.361680, 0.479682, -0.047500>, <0.358401, 0.479682, -0.033085>, <0.352389, 0.491784, -0.007781>, <0.350751, 0.479682, 0.000551>, 
      <0.361680, 0.479682, -0.055761>, <0.358401, 0.479682, -0.041346>, <0.352389, 0.491784, -0.021284>, <0.350751, 0.479682, -0.012952>, 
      <0.361680, 0.479682, -0.066777>, <0.355878, 0.479607, -0.058951>, <0.351949, 0.488537, -0.034836>, <0.350751, 0.479682, -0.030957>, 
      <0.361680, 0.479682, -0.075038>, <0.355878, 0.479607, -0.067213>, <0.351949, 0.488537, -0.048340>, <0.350751, 0.479682, -0.044460>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.361680, 0.479682, -0.047500>, <0.361680, 0.479682, -0.055761>, <0.361680, 0.479682, -0.066777>, <0.361680, 0.479682, -0.075038>, 
      <0.366848, 0.479682, -0.047500>, <0.366848, 0.479682, -0.055761>, <0.364881, 0.479724, -0.071094>, <0.364881, 0.479724, -0.079355>, 
      <0.374107, 0.479682, -0.045582>, <0.374035, 0.479727, -0.055829>, <0.373126, 0.479933, -0.071406>, <0.372952, 0.480040, -0.081652>, 
      <0.378906, 0.479682, -0.047500>, <0.378834, 0.479727, -0.057747>, <0.378501, 0.479933, -0.071406>, <0.378327, 0.480040, -0.081652>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.361680, 0.479682, -0.198961>, <0.361680, 0.479682, -0.190699>, <0.361680, 0.479682, -0.179684>, <0.361680, 0.479682, -0.171422>, 
      <0.358401, 0.479682, -0.213376>, <0.358401, 0.479682, -0.205114>, <0.354844, 0.478831, -0.186572>, <0.354844, 0.478831, -0.178310>, 
      <0.352389, 0.491784, -0.238680>, <0.352389, 0.491784, -0.225177>, <0.351949, 0.488537, -0.211624>, <0.351949, 0.488537, -0.198121>, 
      <0.350751, 0.479682, -0.247011>, <0.350751, 0.479682, -0.233508>, <0.350751, 0.479682, -0.215503>, <0.350751, 0.479682, -0.202000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.361680, 0.479682, -0.198961>, <0.358401, 0.479682, -0.213376>, <0.352389, 0.491784, -0.238680>, <0.350751, 0.479682, -0.247011>, 
      <0.366848, 0.479682, -0.198961>, <0.363569, 0.479682, -0.213376>, <0.360835, 0.491784, -0.238680>, <0.359198, 0.479682, -0.247011>, 
      <0.374107, 0.479682, -0.200879>, <0.373747, 0.478967, -0.215272>, <0.369580, 0.491492, -0.242015>, <0.371063, 0.479682, -0.250146>, 
      <0.378906, 0.479682, -0.198961>, <0.378546, 0.478967, -0.213354>, <0.377424, 0.491492, -0.238880>, <0.378906, 0.479682, -0.247011>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.361680, 0.479682, -0.198961>, <0.366848, 0.479682, -0.198961>, <0.374107, 0.479682, -0.200879>, <0.378906, 0.479682, -0.198961>, 
      <0.361680, 0.479682, -0.190699>, <0.366848, 0.479682, -0.190699>, <0.374314, 0.480092, -0.192628>, <0.379112, 0.480092, -0.190710>, 
      <0.361680, 0.479682, -0.179684>, <0.365780, 0.480193, -0.175553>, <0.374382, 0.482301, -0.179902>, <0.380224, 0.482301, -0.179902>, 
      <0.361680, 0.479682, -0.171422>, <0.365780, 0.480193, -0.167291>, <0.374947, 0.483423, -0.171734>, <0.380789, 0.483423, -0.171734>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.396132, 0.479682, -0.185191>, <0.392624, 0.479682, -0.190800>, <0.385049, 0.479682, -0.196506>, <0.378906, 0.479682, -0.198961>, 
      <0.399411, 0.479682, -0.196985>, <0.395902, 0.479682, -0.202594>, <0.384689, 0.478967, -0.210898>, <0.378546, 0.478967, -0.213354>, 
      <0.403156, 0.489791, -0.218811>, <0.397421, 0.489791, -0.227979>, <0.387465, 0.491492, -0.234867>, <0.377424, 0.491492, -0.238880>, 
      <0.407061, 0.479682, -0.224505>, <0.401326, 0.479682, -0.233673>, <0.388947, 0.479682, -0.242998>, <0.378906, 0.479682, -0.247011>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.396132, 0.479682, -0.185191>, <0.398323, 0.479682, -0.181689>, <0.396132, 0.479682, -0.175553>, <0.396132, 0.479682, -0.171422>, 
      <0.392624, 0.479682, -0.190800>, <0.394814, 0.479682, -0.187298>, <0.393039, 0.480122, -0.171990>, <0.393039, 0.480122, -0.167859>, 
      <0.385049, 0.479682, -0.196506>, <0.385256, 0.480092, -0.188254>, <0.384963, 0.482301, -0.179902>, <0.385528, 0.483423, -0.171734>, 
      <0.378906, 0.479682, -0.198961>, <0.379112, 0.480092, -0.190710>, <0.380224, 0.482301, -0.179902>, <0.380789, 0.483423, -0.171734>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.396132, 0.479682, -0.185191>, <0.399411, 0.479682, -0.196985>, <0.403156, 0.489791, -0.218811>, <0.407061, 0.479682, -0.224505>, 
      <0.398323, 0.479682, -0.181689>, <0.401601, 0.479682, -0.193483>, <0.406736, 0.489791, -0.213087>, <0.410641, 0.479682, -0.218781>, 
      <0.396132, 0.479682, -0.175553>, <0.402490, 0.478777, -0.182878>, <0.403811, 0.488094, -0.205066>, <0.407061, 0.479682, -0.208752>, 
      <0.396132, 0.479682, -0.171422>, <0.402490, 0.478777, -0.178747>, <0.403811, 0.488094, -0.198315>, <0.407061, 0.479682, -0.202000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.400968, 0.120511, -0.224291>, <0.401434, 0.111886, -0.224855>, <0.400894, 0.112026, -0.197076>, <0.400386, 0.120511, -0.195444>, 
      <0.412399, 0.120511, -0.224291>, <0.412865, 0.111886, -0.224855>, <0.412472, 0.112026, -0.197076>, <0.411965, 0.120511, -0.195444>, 
      <0.428279, 0.120511, -0.223744>, <0.428279, 0.120511, -0.214765>, <0.427751, 0.120511, -0.203888>, <0.427751, 0.120511, -0.194908>, 
      <0.438893, 0.120511, -0.227988>, <0.438893, 0.120511, -0.219009>, <0.438893, 0.120511, -0.207036>, <0.438893, 0.120511, -0.198057>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.400968, 0.120511, -0.224291>, <0.395040, 0.230293, -0.217119>, <0.387249, 0.375417, -0.192513>, <0.380789, 0.483423, -0.171734>, 
      <0.412399, 0.120511, -0.224291>, <0.406471, 0.230293, -0.217119>, <0.391988, 0.375417, -0.192513>, <0.385528, 0.483423, -0.171734>, 
      <0.428279, 0.120511, -0.223744>, <0.415450, 0.228262, -0.206775>, <0.405867, 0.372371, -0.184829>, <0.393039, 0.480122, -0.167859>, 
      <0.438893, 0.120511, -0.227988>, <0.426065, 0.228262, -0.211018>, <0.408960, 0.371931, -0.188392>, <0.396132, 0.479682, -0.171422>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.400968, 0.120511, -0.224291>, <0.401434, 0.111886, -0.224855>, <0.400894, 0.112026, -0.197076>, <0.400386, 0.120511, -0.195444>, 
      <0.389823, 0.120511, -0.224291>, <0.390289, 0.111886, -0.224855>, <0.389950, 0.112026, -0.197076>, <0.389443, 0.120511, -0.195444>, 
      <0.374330, 0.120511, -0.223797>, <0.374330, 0.120511, -0.214818>, <0.374507, 0.120511, -0.203968>, <0.374507, 0.120511, -0.194989>, 
      <0.364003, 0.120511, -0.227988>, <0.364003, 0.120511, -0.219009>, <0.364003, 0.120511, -0.207036>, <0.364003, 0.120511, -0.198057>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.400968, 0.120511, -0.224291>, <0.389823, 0.120511, -0.224291>, <0.374330, 0.120511, -0.223797>, <0.364003, 0.120511, -0.227988>, 
      <0.395040, 0.230293, -0.217119>, <0.383895, 0.230293, -0.217119>, <0.373633, 0.228262, -0.206827>, <0.363306, 0.228262, -0.211018>, 
      <0.387249, 0.375417, -0.192513>, <0.381407, 0.375417, -0.192513>, <0.366477, 0.372441, -0.184261>, <0.362377, 0.371931, -0.188392>, 
      <0.380789, 0.483423, -0.171734>, <0.374947, 0.483423, -0.171734>, <0.365780, 0.480193, -0.167291>, <0.361680, 0.479682, -0.171422>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.401448, 0.300097, 0.076134>, <0.397841, 0.357570, 0.064039>, <0.384958, 0.431472, 0.033741>, <0.378906, 0.479682, 0.000551>, 
      <0.422698, 0.300097, 0.070123>, <0.419091, 0.357570, 0.058028>, <0.394999, 0.431472, 0.029728>, <0.388947, 0.479682, -0.003462>, 
      <0.450894, 0.300097, 0.056434>, <0.441452, 0.358109, 0.046445>, <0.420347, 0.430452, 0.014942>, <0.401326, 0.479682, -0.012787>, 
      <0.465518, 0.300097, 0.039886>, <0.456076, 0.358109, 0.029898>, <0.426082, 0.430452, 0.005775>, <0.407061, 0.479682, -0.021955>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.337378, 0.300097, 0.076134>, <0.339371, 0.357398, 0.064074>, <0.344261, 0.431719, 0.033571>, <0.350751, 0.479682, 0.000551>, 
      <0.356599, 0.300097, 0.076134>, <0.358592, 0.357398, 0.064074>, <0.352707, 0.431719, 0.033571>, <0.359198, 0.479682, 0.000551>, 
      <0.382953, 0.300097, 0.081366>, <0.379346, 0.357570, 0.069271>, <0.377114, 0.431472, 0.036876>, <0.371063, 0.479682, 0.003686>, 
      <0.401448, 0.300097, 0.076134>, <0.397841, 0.357570, 0.064039>, <0.384958, 0.431472, 0.033741>, <0.378906, 0.479682, 0.000551>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.337378, 0.300097, 0.003638>, <0.339440, 0.355483, -0.003779>, <0.343873, 0.428852, -0.022191>, <0.350751, 0.479682, -0.044460>, 
      <0.337378, 0.300097, 0.025387>, <0.339440, 0.355483, 0.017970>, <0.343873, 0.428852, -0.008688>, <0.350751, 0.479682, -0.030957>, 
      <0.337378, 0.300097, 0.054385>, <0.339371, 0.357398, 0.042326>, <0.344261, 0.431719, 0.020067>, <0.350751, 0.479682, -0.012952>, 
      <0.337378, 0.300097, 0.076134>, <0.339371, 0.357398, 0.064074>, <0.344261, 0.431719, 0.033571>, <0.350751, 0.479682, 0.000551>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.337378, 0.300097, -0.032610>, <0.339415, 0.354809, -0.037843>, <0.343707, 0.427625, -0.050676>, <0.350751, 0.479682, -0.066966>, 
      <0.337378, 0.300097, -0.021736>, <0.339415, 0.354809, -0.026969>, <0.343707, 0.427625, -0.043924>, <0.350751, 0.479682, -0.060214>, 
      <0.337378, 0.300097, -0.007236>, <0.339440, 0.355483, -0.014653>, <0.343873, 0.428852, -0.028943>, <0.350751, 0.479682, -0.051212>, 
      <0.337378, 0.300097, 0.003638>, <0.339440, 0.355483, -0.003779>, <0.343873, 0.428852, -0.022191>, <0.350751, 0.479682, -0.044460>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.337378, 0.300097, -0.105106>, <0.339389, 0.354114, -0.106139>, <0.343515, 0.426209, -0.108630>, <0.350751, 0.479682, -0.111977>, 
      <0.337378, 0.300097, -0.083357>, <0.339389, 0.354114, -0.084391>, <0.343515, 0.426209, -0.095127>, <0.350751, 0.479682, -0.098474>, 
      <0.337378, 0.300097, -0.054359>, <0.339415, 0.354809, -0.059592>, <0.343707, 0.427625, -0.064179>, <0.350751, 0.479682, -0.080469>, 
      <0.337378, 0.300097, -0.032610>, <0.339415, 0.354809, -0.037843>, <0.343707, 0.427625, -0.050676>, <0.350751, 0.479682, -0.066966>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.337378, 0.300097, -0.141354>, <0.339389, 0.354114, -0.140321>, <0.343515, 0.426209, -0.137829>, <0.350751, 0.479682, -0.134483>, 
      <0.337378, 0.300097, -0.130480>, <0.339389, 0.354114, -0.129446>, <0.343515, 0.426209, -0.131078>, <0.350751, 0.479682, -0.127731>, 
      <0.337378, 0.300097, -0.115980>, <0.339389, 0.354114, -0.117014>, <0.343515, 0.426209, -0.115382>, <0.350751, 0.479682, -0.118729>, 
      <0.337378, 0.300097, -0.105106>, <0.339389, 0.354114, -0.106139>, <0.343515, 0.426209, -0.108630>, <0.350751, 0.479682, -0.111977>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.337378, 0.300097, -0.213850>, <0.339415, 0.354809, -0.208617>, <0.343707, 0.427625, -0.195784>, <0.350751, 0.479682, -0.179494>, 
      <0.337378, 0.300097, -0.192101>, <0.339415, 0.354809, -0.186868>, <0.343707, 0.427625, -0.182281>, <0.350751, 0.479682, -0.165991>, 
      <0.337378, 0.300097, -0.163103>, <0.339389, 0.354114, -0.162070>, <0.343515, 0.426209, -0.151333>, <0.350751, 0.479682, -0.147986>, 
      <0.337378, 0.300097, -0.141354>, <0.339389, 0.354114, -0.140321>, <0.343515, 0.426209, -0.137829>, <0.350751, 0.479682, -0.134483>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.337378, 0.300097, -0.250098>, <0.339440, 0.355483, -0.242681>, <0.343873, 0.428852, -0.224269>, <0.350751, 0.479682, -0.202000>, 
      <0.337378, 0.300097, -0.239224>, <0.339440, 0.355483, -0.231807>, <0.343873, 0.428852, -0.217517>, <0.350751, 0.479682, -0.195248>, 
      <0.337378, 0.300097, -0.224724>, <0.339415, 0.354809, -0.219491>, <0.343707, 0.427625, -0.202536>, <0.350751, 0.479682, -0.186246>, 
      <0.337378, 0.300097, -0.213850>, <0.339415, 0.354809, -0.208617>, <0.343707, 0.427625, -0.195784>, <0.350751, 0.479682, -0.179494>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.337378, 0.300097, -0.322594>, <0.339511, 0.357393, -0.310537>, <0.344261, 0.431719, -0.280030>, <0.350751, 0.479682, -0.247011>, 
      <0.337378, 0.300097, -0.300845>, <0.339511, 0.357393, -0.288788>, <0.344261, 0.431719, -0.266527>, <0.350751, 0.479682, -0.233508>, 
      <0.337378, 0.300097, -0.271847>, <0.339440, 0.355483, -0.264430>, <0.343873, 0.428852, -0.237772>, <0.350751, 0.479682, -0.215503>, 
      <0.337378, 0.300097, -0.250098>, <0.339440, 0.355483, -0.242681>, <0.343873, 0.428852, -0.224269>, <0.350751, 0.479682, -0.202000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.401448, 0.300097, -0.322594>, <0.397841, 0.357570, -0.310499>, <0.384958, 0.431471, -0.280201>, <0.378906, 0.479682, -0.247011>, 
      <0.382953, 0.300097, -0.327826>, <0.379346, 0.357570, -0.315731>, <0.377114, 0.431471, -0.283336>, <0.371063, 0.479682, -0.250146>, 
      <0.356599, 0.300097, -0.322594>, <0.358732, 0.357393, -0.310537>, <0.352707, 0.431719, -0.280030>, <0.359198, 0.479682, -0.247011>, 
      <0.337378, 0.300097, -0.322594>, <0.339511, 0.357393, -0.310537>, <0.344261, 0.431719, -0.280030>, <0.350751, 0.479682, -0.247011>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.465518, 0.300097, -0.286346>, <0.456076, 0.358109, -0.276358>, <0.426082, 0.430452, -0.252235>, <0.407061, 0.479682, -0.224505>, 
      <0.450894, 0.300097, -0.302894>, <0.441452, 0.358109, -0.292905>, <0.420347, 0.430452, -0.261402>, <0.401326, 0.479682, -0.233673>, 
      <0.422698, 0.300097, -0.316583>, <0.419091, 0.357570, -0.304488>, <0.394999, 0.431471, -0.276188>, <0.388947, 0.479682, -0.242998>, 
      <0.401448, 0.300097, -0.322594>, <0.397841, 0.357570, -0.310499>, <0.384958, 0.431471, -0.280201>, <0.378906, 0.479682, -0.247011>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.465518, 0.300097, -0.250098>, <0.456207, 0.357307, -0.242437>, <0.426567, 0.429198, -0.224117>, <0.407061, 0.479682, -0.202000>, 
      <0.465518, 0.300097, -0.260972>, <0.456207, 0.357307, -0.253311>, <0.426567, 0.429198, -0.230869>, <0.407061, 0.479682, -0.208752>, 
      <0.472719, 0.300097, -0.278198>, <0.463278, 0.358109, -0.268209>, <0.429662, 0.430452, -0.246511>, <0.410641, 0.479682, -0.218781>, 
      <0.465518, 0.300097, -0.286346>, <0.456076, 0.358109, -0.276358>, <0.426082, 0.430452, -0.252235>, <0.407061, 0.479682, -0.224505>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.465518, 0.300097, -0.213850>, <0.456308, 0.356685, -0.208437>, <0.426984, 0.428116, -0.195630>, <0.407061, 0.479682, -0.179494>, 
      <0.465518, 0.300097, -0.224724>, <0.456308, 0.356685, -0.219311>, <0.426984, 0.428116, -0.202382>, <0.407061, 0.479682, -0.186246>, 
      <0.465518, 0.300097, -0.239224>, <0.456207, 0.357307, -0.231562>, <0.426567, 0.429198, -0.217365>, <0.407061, 0.479682, -0.195248>, 
      <0.465518, 0.300097, -0.250098>, <0.456207, 0.357307, -0.242437>, <0.426567, 0.429198, -0.224117>, <0.407061, 0.479682, -0.202000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.465518, 0.300097, -0.141354>, <0.456412, 0.356046, -0.140284>, <0.427459, 0.426887, -0.137787>, <0.407061, 0.479682, -0.134483>, 
      <0.465518, 0.300097, -0.163103>, <0.456412, 0.356046, -0.162033>, <0.427459, 0.426887, -0.151290>, <0.407061, 0.479682, -0.147986>, 
      <0.465518, 0.300097, -0.192101>, <0.456308, 0.356685, -0.186688>, <0.426984, 0.428116, -0.182127>, <0.407061, 0.479682, -0.165991>, 
      <0.465518, 0.300097, -0.213850>, <0.456308, 0.356685, -0.208437>, <0.426984, 0.428116, -0.195630>, <0.407061, 0.479682, -0.179494>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.465518, 0.300097, -0.105106>, <0.456412, 0.356046, -0.106176>, <0.427459, 0.426887, -0.108673>, <0.407061, 0.479682, -0.111977>, 
      <0.465518, 0.300097, -0.115980>, <0.456412, 0.356046, -0.117051>, <0.427459, 0.426887, -0.115424>, <0.407061, 0.479682, -0.118729>, 
      <0.465518, 0.300097, -0.130480>, <0.456412, 0.356046, -0.129409>, <0.427459, 0.426887, -0.131035>, <0.407061, 0.479682, -0.127731>, 
      <0.465518, 0.300097, -0.141354>, <0.456412, 0.356046, -0.140284>, <0.427459, 0.426887, -0.137787>, <0.407061, 0.479682, -0.134483>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.465518, 0.300097, -0.032610>, <0.456308, 0.356685, -0.038023>, <0.426984, 0.428116, -0.050830>, <0.407061, 0.479682, -0.066966>, 
      <0.465518, 0.300097, -0.054359>, <0.456308, 0.356685, -0.059772>, <0.426984, 0.428116, -0.064333>, <0.407061, 0.479682, -0.080469>, 
      <0.465518, 0.300097, -0.083357>, <0.456412, 0.356046, -0.084428>, <0.427459, 0.426887, -0.095169>, <0.407061, 0.479682, -0.098474>, 
      <0.465518, 0.300097, -0.105106>, <0.456412, 0.356046, -0.106176>, <0.427459, 0.426887, -0.108673>, <0.407061, 0.479682, -0.111977>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.465518, 0.300097, 0.003638>, <0.456207, 0.357307, -0.004023>, <0.426567, 0.429198, -0.022343>, <0.407061, 0.479682, -0.044460>, 
      <0.465518, 0.300097, -0.007236>, <0.456207, 0.357307, -0.014898>, <0.426567, 0.429198, -0.029095>, <0.407061, 0.479682, -0.051212>, 
      <0.465518, 0.300097, -0.021736>, <0.456308, 0.356685, -0.027148>, <0.426984, 0.428116, -0.044078>, <0.407061, 0.479682, -0.060214>, 
      <0.465518, 0.300097, -0.032610>, <0.456308, 0.356685, -0.038023>, <0.426984, 0.428116, -0.050830>, <0.407061, 0.479682, -0.066966>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.465518, 0.300097, 0.003638>, <0.465518, 0.300097, 0.014512>, <0.472719, 0.300097, 0.031738>, <0.465518, 0.300097, 0.039886>, 
      <0.456207, 0.357307, -0.004023>, <0.456207, 0.357307, 0.006851>, <0.463278, 0.358109, 0.021749>, <0.456076, 0.358109, 0.029898>, 
      <0.426567, 0.429198, -0.022343>, <0.426567, 0.429198, -0.015591>, <0.429662, 0.430452, 0.000051>, <0.426082, 0.430452, 0.005775>, 
      <0.407061, 0.479682, -0.044460>, <0.407061, 0.479682, -0.037708>, <0.410641, 0.479682, -0.027679>, <0.407061, 0.479682, -0.021955>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.401448, 0.120511, 0.076134>, <0.401448, 0.173406, 0.086367>, <0.404751, 0.247475, 0.087208>, <0.401448, 0.300097, 0.076134>, 
      <0.422687, 0.120505, 0.070084>, <0.422687, 0.173400, 0.080318>, <0.426001, 0.247475, 0.081197>, <0.422698, 0.300097, 0.070123>, 
      <0.450894, 0.120511, 0.056434>, <0.458700, 0.173163, 0.064768>, <0.459426, 0.247672, 0.065460>, <0.450894, 0.300097, 0.056434>, 
      <0.465518, 0.120511, 0.039886>, <0.473324, 0.173163, 0.048220>, <0.474050, 0.247672, 0.048912>, <0.465518, 0.300097, 0.039886>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.338259, 0.120550, 0.076134>, <0.330500, 0.172883, 0.086259>, <0.335546, 0.247418, 0.087221>, <0.337378, 0.300097, 0.076134>, 
      <0.357216, 0.120538, 0.076134>, <0.349457, 0.172871, 0.086259>, <0.354767, 0.247418, 0.087221>, <0.356599, 0.300097, 0.076134>, 
      <0.383217, 0.120517, 0.081327>, <0.383217, 0.173412, 0.091561>, <0.386255, 0.247475, 0.092439>, <0.382953, 0.300097, 0.081366>, 
      <0.401448, 0.120511, 0.076134>, <0.401448, 0.173406, 0.086367>, <0.404751, 0.247475, 0.087208>, <0.401448, 0.300097, 0.076134>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.337378, 0.120511, 0.003638>, <0.329535, 0.173413, 0.010151>, <0.335391, 0.246734, 0.010784>, <0.337378, 0.300097, 0.003638>, 
      <0.337554, 0.120519, 0.025388>, <0.329711, 0.173421, 0.031901>, <0.335391, 0.246734, 0.032533>, <0.337378, 0.300097, 0.025387>, 
      <0.337995, 0.120538, 0.054385>, <0.330236, 0.172871, 0.064510>, <0.335546, 0.247418, 0.065472>, <0.337378, 0.300097, 0.054385>, 
      <0.338259, 0.120550, 0.076134>, <0.330500, 0.172883, 0.086259>, <0.335546, 0.247418, 0.087221>, <0.337378, 0.300097, 0.076134>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.337378, 0.120511, -0.032610>, <0.337378, 0.120511, -0.021736>, <0.337290, 0.120507, -0.007236>, <0.337378, 0.120511, 0.003638>, 
      <0.338735, 0.111359, -0.033415>, <0.338735, 0.111359, -0.022540>, <0.338801, 0.110312, -0.008491>, <0.338890, 0.110316, 0.002383>, 
      <0.355044, 0.120511, -0.045956>, <0.355044, 0.120511, -0.036976>, <0.354507, 0.120511, -0.023253>, <0.354507, 0.120511, -0.014273>, 
      <0.364003, 0.120511, -0.048403>, <0.364003, 0.120511, -0.039424>, <0.364003, 0.120511, -0.027451>, <0.364003, 0.120511, -0.018472>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.337378, 0.120511, -0.032610>, <0.329507, 0.173604, -0.027941>, <0.335382, 0.246503, -0.027484>, <0.337378, 0.300097, -0.032610>, 
      <0.337378, 0.120511, -0.021736>, <0.329507, 0.173604, -0.017067>, <0.335382, 0.246503, -0.016609>, <0.337378, 0.300097, -0.021736>, 
      <0.337290, 0.120507, -0.007236>, <0.329447, 0.173409, -0.000723>, <0.335391, 0.246734, -0.000090>, <0.337378, 0.300097, -0.007236>, 
      <0.337378, 0.120511, 0.003638>, <0.329535, 0.173413, 0.010151>, <0.335391, 0.246734, 0.010784>, <0.337378, 0.300097, 0.003638>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.337378, 0.120511, -0.105106>, <0.337378, 0.120511, -0.083357>, <0.337378, 0.120511, -0.054359>, <0.337378, 0.120511, -0.032610>, 
      <0.338558, 0.112556, -0.105246>, <0.338558, 0.112556, -0.083497>, <0.338735, 0.111359, -0.055164>, <0.338735, 0.111359, -0.033415>, 
      <0.355969, 0.120223, -0.107987>, <0.355969, 0.120223, -0.090029>, <0.355044, 0.120511, -0.063914>, <0.355044, 0.120511, -0.045956>, 
      <0.364003, 0.120511, -0.108265>, <0.364003, 0.120511, -0.090306>, <0.364003, 0.120511, -0.066362>, <0.364003, 0.120511, -0.048403>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.337378, 0.120511, -0.105106>, <0.329478, 0.173796, -0.104169>, <0.335374, 0.246268, -0.104076>, <0.337378, 0.300097, -0.105106>, 
      <0.337378, 0.120511, -0.083357>, <0.329478, 0.173796, -0.082420>, <0.335374, 0.246268, -0.082327>, <0.337378, 0.300097, -0.083357>, 
      <0.337378, 0.120511, -0.054359>, <0.329507, 0.173604, -0.049690>, <0.335382, 0.246503, -0.049232>, <0.337378, 0.300097, -0.054359>, 
      <0.337378, 0.120511, -0.032610>, <0.329507, 0.173604, -0.027941>, <0.335382, 0.246503, -0.027484>, <0.337378, 0.300097, -0.032610>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.337378, 0.120511, -0.141354>, <0.337378, 0.120511, -0.130480>, <0.337378, 0.120511, -0.115980>, <0.337378, 0.120511, -0.105106>, 
      <0.338557, 0.112556, -0.141214>, <0.338557, 0.112556, -0.130340>, <0.338558, 0.112556, -0.116120>, <0.338558, 0.112556, -0.105246>, 
      <0.355998, 0.120230, -0.138926>, <0.355998, 0.120230, -0.129946>, <0.355969, 0.120223, -0.116967>, <0.355969, 0.120223, -0.107987>, 
      <0.364003, 0.120511, -0.138196>, <0.364003, 0.120511, -0.129217>, <0.364003, 0.120511, -0.117244>, <0.364003, 0.120511, -0.108265>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.337378, 0.120511, -0.141354>, <0.329478, 0.173796, -0.142291>, <0.335374, 0.246268, -0.142384>, <0.337378, 0.300097, -0.141354>, 
      <0.337378, 0.120511, -0.130480>, <0.329478, 0.173796, -0.131417>, <0.335374, 0.246268, -0.131509>, <0.337378, 0.300097, -0.130480>, 
      <0.337378, 0.120511, -0.115980>, <0.329478, 0.173796, -0.115043>, <0.335374, 0.246268, -0.114951>, <0.337378, 0.300097, -0.115980>, 
      <0.337378, 0.120511, -0.105106>, <0.329478, 0.173796, -0.104169>, <0.335374, 0.246268, -0.104076>, <0.337378, 0.300097, -0.105106>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.337378, 0.120511, -0.213850>, <0.337378, 0.120511, -0.192101>, <0.337378, 0.120511, -0.163103>, <0.337378, 0.120511, -0.141354>, 
      <0.338735, 0.111359, -0.213045>, <0.338735, 0.111359, -0.191296>, <0.338557, 0.112556, -0.162963>, <0.338557, 0.112556, -0.141214>, 
      <0.355089, 0.120511, -0.200661>, <0.355089, 0.120511, -0.182703>, <0.355998, 0.120230, -0.156884>, <0.355998, 0.120230, -0.138926>, 
      <0.364003, 0.120511, -0.198057>, <0.364003, 0.120511, -0.180099>, <0.364003, 0.120511, -0.156154>, <0.364003, 0.120511, -0.138196>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.337378, 0.120511, -0.213850>, <0.329507, 0.173604, -0.218519>, <0.335382, 0.246503, -0.218976>, <0.337378, 0.300097, -0.213850>, 
      <0.337378, 0.120511, -0.192101>, <0.329507, 0.173604, -0.196770>, <0.335382, 0.246503, -0.197228>, <0.337378, 0.300097, -0.192101>, 
      <0.337378, 0.120511, -0.163103>, <0.329478, 0.173796, -0.164040>, <0.335374, 0.246268, -0.164133>, <0.337378, 0.300097, -0.163103>, 
      <0.337378, 0.120511, -0.141354>, <0.329478, 0.173796, -0.142291>, <0.335374, 0.246268, -0.142384>, <0.337378, 0.300097, -0.141354>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.337378, 0.120511, -0.250098>, <0.337378, 0.120511, -0.239224>, <0.337378, 0.120511, -0.224724>, <0.337378, 0.120511, -0.213850>, 
      <0.338890, 0.110316, -0.248843>, <0.338890, 0.110316, -0.237968>, <0.338735, 0.111359, -0.223920>, <0.338735, 0.111359, -0.213045>, 
      <0.354383, 0.120511, -0.231892>, <0.354383, 0.120511, -0.222913>, <0.355089, 0.120511, -0.209640>, <0.355089, 0.120511, -0.200661>, 
      <0.364003, 0.120511, -0.227988>, <0.364003, 0.120511, -0.219009>, <0.364003, 0.120511, -0.207036>, <0.364003, 0.120511, -0.198057>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.337378, 0.120511, -0.250098>, <0.329535, 0.173413, -0.256611>, <0.335391, 0.246734, -0.257244>, <0.337378, 0.300097, -0.250098>, 
      <0.337378, 0.120511, -0.239224>, <0.329535, 0.173413, -0.245737>, <0.335391, 0.246734, -0.246370>, <0.337378, 0.300097, -0.239224>, 
      <0.337378, 0.120511, -0.224724>, <0.329507, 0.173604, -0.229394>, <0.335382, 0.246503, -0.229851>, <0.337378, 0.300097, -0.224724>, 
      <0.337378, 0.120511, -0.213850>, <0.329507, 0.173604, -0.218519>, <0.335382, 0.246503, -0.218976>, <0.337378, 0.300097, -0.213850>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.337378, 0.120511, -0.322594>, <0.329618, 0.172854, -0.332721>, <0.335416, 0.247411, -0.333681>, <0.337378, 0.300097, -0.322594>, 
      <0.337378, 0.120511, -0.300845>, <0.329618, 0.172854, -0.310972>, <0.335416, 0.247411, -0.311932>, <0.337378, 0.300097, -0.300845>, 
      <0.337378, 0.120511, -0.271847>, <0.329535, 0.173413, -0.278360>, <0.335391, 0.246734, -0.278993>, <0.337378, 0.300097, -0.271847>, 
      <0.337378, 0.120511, -0.250098>, <0.329535, 0.173413, -0.256611>, <0.335391, 0.246734, -0.257244>, <0.337378, 0.300097, -0.250098>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.401448, 0.120511, -0.322594>, <0.401448, 0.173406, -0.332828>, <0.404751, 0.247475, -0.333668>, <0.401448, 0.300097, -0.322594>, 
      <0.382953, 0.120511, -0.327826>, <0.382953, 0.173406, -0.338059>, <0.386255, 0.247475, -0.338900>, <0.382953, 0.300097, -0.327826>, 
      <0.356599, 0.120511, -0.322594>, <0.348839, 0.172854, -0.332721>, <0.354637, 0.247411, -0.333681>, <0.356599, 0.300097, -0.322594>, 
      <0.337378, 0.120511, -0.322594>, <0.329618, 0.172854, -0.332721>, <0.335416, 0.247411, -0.333681>, <0.337378, 0.300097, -0.322594>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.465518, 0.120511, -0.286346>, <0.473324, 0.173163, -0.294680>, <0.474050, 0.247672, -0.295372>, <0.465518, 0.300097, -0.286346>, 
      <0.450894, 0.120511, -0.302894>, <0.458700, 0.173163, -0.311228>, <0.459426, 0.247672, -0.311920>, <0.450894, 0.300097, -0.302894>, 
      <0.422698, 0.120511, -0.316583>, <0.422698, 0.173406, -0.326816>, <0.426001, 0.247475, -0.327656>, <0.422698, 0.300097, -0.316583>, 
      <0.401448, 0.120511, -0.322594>, <0.401448, 0.173406, -0.332828>, <0.404751, 0.247475, -0.333668>, <0.401448, 0.300097, -0.322594>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.465518, 0.120511, -0.250098>, <0.473361, 0.173413, -0.256611>, <0.474098, 0.247379, -0.257158>, <0.465518, 0.300097, -0.250098>, 
      <0.465518, 0.120511, -0.260972>, <0.473361, 0.173413, -0.267485>, <0.474098, 0.247379, -0.268032>, <0.465518, 0.300097, -0.260972>, 
      <0.472719, 0.120511, -0.278198>, <0.480525, 0.173163, -0.286532>, <0.481252, 0.247672, -0.287224>, <0.472719, 0.300097, -0.278198>, 
      <0.465518, 0.120511, -0.286346>, <0.473324, 0.173163, -0.294680>, <0.474050, 0.247672, -0.295372>, <0.465518, 0.300097, -0.286346>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.465518, 0.120511, -0.213850>, <0.473389, 0.173604, -0.218519>, <0.474134, 0.247156, -0.218914>, <0.465518, 0.300097, -0.213850>, 
      <0.465518, 0.120511, -0.224724>, <0.473389, 0.173604, -0.229394>, <0.474134, 0.247156, -0.229788>, <0.465518, 0.300097, -0.224724>, 
      <0.465518, 0.120511, -0.239224>, <0.473361, 0.173413, -0.245737>, <0.474098, 0.247379, -0.246283>, <0.465518, 0.300097, -0.239224>, 
      <0.465518, 0.120511, -0.250098>, <0.473361, 0.173413, -0.256611>, <0.474098, 0.247379, -0.257158>, <0.465518, 0.300097, -0.250098>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.465518, 0.120511, -0.213850>, <0.465518, 0.120511, -0.224724>, <0.465518, 0.120511, -0.239224>, <0.465518, 0.120511, -0.250098>, 
      <0.464161, 0.111359, -0.213045>, <0.464161, 0.111359, -0.223920>, <0.464006, 0.110316, -0.237968>, <0.464006, 0.110316, -0.248843>, 
      <0.447830, 0.120511, -0.200583>, <0.447830, 0.120511, -0.209562>, <0.448534, 0.120511, -0.222863>, <0.448534, 0.120511, -0.231842>, 
      <0.438893, 0.120511, -0.198057>, <0.438893, 0.120511, -0.207036>, <0.438893, 0.120511, -0.219009>, <0.438893, 0.120511, -0.227988>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.465518, 0.120511, -0.141354>, <0.473418, 0.173796, -0.142291>, <0.474171, 0.246930, -0.142371>, <0.465518, 0.300097, -0.141354>, 
      <0.465518, 0.120511, -0.163103>, <0.473418, 0.173796, -0.164040>, <0.474171, 0.246930, -0.164120>, <0.465518, 0.300097, -0.163103>, 
      <0.465518, 0.120511, -0.192101>, <0.473389, 0.173604, -0.196770>, <0.474134, 0.247156, -0.197165>, <0.465518, 0.300097, -0.192101>, 
      <0.465518, 0.120511, -0.213850>, <0.473389, 0.173604, -0.218519>, <0.474134, 0.247156, -0.218914>, <0.465518, 0.300097, -0.213850>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.465518, 0.120511, -0.141354>, <0.465518, 0.120511, -0.163103>, <0.465518, 0.120511, -0.192101>, <0.465518, 0.120511, -0.213850>, 
      <0.464339, 0.112556, -0.141214>, <0.464339, 0.112556, -0.162963>, <0.464161, 0.111359, -0.191296>, <0.464161, 0.111359, -0.213045>, 
      <0.446897, 0.120226, -0.138937>, <0.446897, 0.120226, -0.156895>, <0.447830, 0.120511, -0.182624>, <0.447830, 0.120511, -0.200583>, 
      <0.438893, 0.120511, -0.138196>, <0.438893, 0.120511, -0.156154>, <0.438893, 0.120511, -0.180099>, <0.438893, 0.120511, -0.198057>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.465518, 0.120511, -0.105106>, <0.473418, 0.173796, -0.104169>, <0.474171, 0.246930, -0.104089>, <0.465518, 0.300097, -0.105106>, 
      <0.465518, 0.120511, -0.115980>, <0.473418, 0.173796, -0.115043>, <0.474171, 0.246930, -0.114963>, <0.465518, 0.300097, -0.115980>, 
      <0.465518, 0.120511, -0.130480>, <0.473418, 0.173796, -0.131417>, <0.474171, 0.246930, -0.131497>, <0.465518, 0.300097, -0.130480>, 
      <0.465518, 0.120511, -0.141354>, <0.473418, 0.173796, -0.142291>, <0.474171, 0.246930, -0.142371>, <0.465518, 0.300097, -0.141354>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.465518, 0.120511, -0.105106>, <0.465518, 0.120511, -0.115980>, <0.465518, 0.120511, -0.130480>, <0.465518, 0.120511, -0.141354>, 
      <0.464339, 0.112556, -0.105246>, <0.464339, 0.112556, -0.116120>, <0.464339, 0.112556, -0.130340>, <0.464339, 0.112556, -0.141214>, 
      <0.446927, 0.120234, -0.107998>, <0.446927, 0.120234, -0.116978>, <0.446897, 0.120226, -0.129958>, <0.446897, 0.120226, -0.138937>, 
      <0.438893, 0.120511, -0.108265>, <0.438893, 0.120511, -0.117244>, <0.438893, 0.120511, -0.129217>, <0.438893, 0.120511, -0.138196>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.465518, 0.120511, -0.032610>, <0.473389, 0.173604, -0.027941>, <0.474134, 0.247156, -0.027546>, <0.465518, 0.300097, -0.032610>, 
      <0.465518, 0.120511, -0.054359>, <0.473389, 0.173604, -0.049690>, <0.474134, 0.247156, -0.049295>, <0.465518, 0.300097, -0.054359>, 
      <0.465518, 0.120511, -0.083357>, <0.473418, 0.173796, -0.082420>, <0.474171, 0.246930, -0.082340>, <0.465518, 0.300097, -0.083357>, 
      <0.465518, 0.120511, -0.105106>, <0.473418, 0.173796, -0.104169>, <0.474171, 0.246930, -0.104089>, <0.465518, 0.300097, -0.105106>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.465518, 0.120511, -0.032610>, <0.465518, 0.120511, -0.054359>, <0.465518, 0.120511, -0.083357>, <0.465518, 0.120511, -0.105106>, 
      <0.464161, 0.111359, -0.033415>, <0.464161, 0.111359, -0.055164>, <0.464339, 0.112556, -0.083497>, <0.464339, 0.112556, -0.105246>, 
      <0.447902, 0.120511, -0.046148>, <0.447902, 0.120511, -0.064107>, <0.446927, 0.120234, -0.090040>, <0.446927, 0.120234, -0.107998>, 
      <0.438893, 0.120511, -0.048403>, <0.438893, 0.120511, -0.066362>, <0.438893, 0.120511, -0.090306>, <0.438893, 0.120511, -0.108265>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.465518, 0.120511, 0.003638>, <0.473361, 0.173413, 0.010151>, <0.474098, 0.247379, 0.010698>, <0.465518, 0.300097, 0.003638>, 
      <0.465518, 0.120511, -0.007236>, <0.473361, 0.173413, -0.000723>, <0.474098, 0.247379, -0.000177>, <0.465518, 0.300097, -0.007236>, 
      <0.465518, 0.120511, -0.021736>, <0.473389, 0.173604, -0.017067>, <0.474134, 0.247156, -0.016672>, <0.465518, 0.300097, -0.021736>, 
      <0.465518, 0.120511, -0.032610>, <0.473389, 0.173604, -0.027941>, <0.474134, 0.247156, -0.027546>, <0.465518, 0.300097, -0.032610>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.465518, 0.120511, 0.003638>, <0.465518, 0.120511, -0.007236>, <0.465518, 0.120511, -0.021736>, <0.465518, 0.120511, -0.032610>, 
      <0.464006, 0.110316, 0.002383>, <0.464006, 0.110316, -0.008492>, <0.464161, 0.111359, -0.022540>, <0.464161, 0.111359, -0.033415>, 
      <0.448439, 0.120511, -0.014389>, <0.448439, 0.120511, -0.023368>, <0.447902, 0.120511, -0.037169>, <0.447902, 0.120511, -0.046148>, 
      <0.438893, 0.120511, -0.018472>, <0.438893, 0.120511, -0.027451>, <0.438893, 0.120511, -0.039424>, <0.438893, 0.120511, -0.048403>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.465518, 0.120511, 0.003638>, <0.465518, 0.120511, 0.014512>, <0.472719, 0.120511, 0.031738>, <0.465518, 0.120511, 0.039886>, 
      <0.473361, 0.173413, 0.010151>, <0.473361, 0.173413, 0.021026>, <0.480525, 0.173163, 0.040072>, <0.473324, 0.173163, 0.048220>, 
      <0.474098, 0.247379, 0.010698>, <0.474098, 0.247379, 0.021572>, <0.481252, 0.247672, 0.040764>, <0.474050, 0.247672, 0.048912>, 
      <0.465518, 0.300097, 0.003638>, <0.465518, 0.300097, 0.014512>, <0.472719, 0.300097, 0.031738>, <0.465518, 0.300097, 0.039886>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.438893, 0.120511, 0.011459>, <0.446881, 0.120511, 0.019987>, <0.463825, 0.109092, 0.038079>, <0.465518, 0.120511, 0.039886>, 
      <0.443655, 0.120511, 0.003846>, <0.451642, 0.120511, 0.012375>, <0.471026, 0.109092, 0.029930>, <0.472719, 0.120511, 0.031738>, 
      <0.438893, 0.120511, -0.009493>, <0.448439, 0.120511, -0.005410>, <0.464006, 0.110316, 0.013257>, <0.465518, 0.120511, 0.014512>, 
      <0.438893, 0.120511, -0.018472>, <0.448439, 0.120511, -0.014389>, <0.464006, 0.110316, 0.002383>, <0.465518, 0.120511, 0.003638>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.401448, 0.120511, 0.041390>, <0.401448, 0.120511, 0.051813>, <0.401448, 0.110278, 0.074154>, <0.401448, 0.120511, 0.076134>, 
      <0.414802, 0.120511, 0.036053>, <0.414802, 0.120511, 0.046476>, <0.422687, 0.110271, 0.068104>, <0.422687, 0.120505, 0.070084>, 
      <0.431266, 0.120511, 0.023651>, <0.439254, 0.120511, 0.032180>, <0.449201, 0.109092, 0.054626>, <0.450894, 0.120511, 0.056434>, 
      <0.438893, 0.120511, 0.011459>, <0.446881, 0.120511, 0.019987>, <0.463825, 0.109092, 0.038079>, <0.465518, 0.120511, 0.039886>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.364003, 0.120511, 0.041390>, <0.356280, 0.120523, 0.051813>, <0.340128, 0.107946, 0.073696>, <0.338259, 0.120550, 0.076134>, 
      <0.375236, 0.120511, 0.041390>, <0.367513, 0.120523, 0.051813>, <0.359084, 0.107935, 0.073696>, <0.357216, 0.120538, 0.076134>, 
      <0.391017, 0.120511, 0.045559>, <0.391017, 0.120511, 0.055982>, <0.383217, 0.110283, 0.079347>, <0.383217, 0.120517, 0.081327>, 
      <0.401448, 0.120511, 0.041390>, <0.401448, 0.120511, 0.051813>, <0.401448, 0.110278, 0.074154>, <0.401448, 0.120511, 0.076134>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.364003, 0.120511, 0.041390>, <0.364003, 0.120511, 0.023431>, <0.364003, 0.120511, -0.000513>, <0.364003, 0.120511, -0.018472>, 
      <0.356280, 0.120523, 0.051813>, <0.356280, 0.120523, 0.033855>, <0.354507, 0.120511, 0.003685>, <0.354507, 0.120511, -0.014273>, 
      <0.340128, 0.107946, 0.073696>, <0.339863, 0.107935, 0.051947>, <0.339066, 0.110324, 0.024133>, <0.338890, 0.110316, 0.002383>, 
      <0.338259, 0.120550, 0.076134>, <0.337995, 0.120538, 0.054385>, <0.337554, 0.120519, 0.025388>, <0.337378, 0.120511, 0.003638>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.364003, 0.120511, -0.287850>, <0.356015, 0.120511, -0.298273>, <0.339270, 0.107753, -0.320126>, <0.337378, 0.120511, -0.322594>, 
      <0.364003, 0.120511, -0.269891>, <0.356015, 0.120511, -0.280315>, <0.339270, 0.107753, -0.298377>, <0.337378, 0.120511, -0.300845>, 
      <0.364003, 0.120511, -0.245947>, <0.354383, 0.120511, -0.249851>, <0.338890, 0.110316, -0.270592>, <0.337378, 0.120511, -0.271847>, 
      <0.364003, 0.120511, -0.227988>, <0.354383, 0.120511, -0.231892>, <0.338890, 0.110316, -0.248843>, <0.337378, 0.120511, -0.250098>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.401448, 0.120511, -0.287850>, <0.401448, 0.120511, -0.298273>, <0.401448, 0.110278, -0.320614>, <0.401448, 0.120511, -0.322594>, 
      <0.391017, 0.120511, -0.292019>, <0.391017, 0.120511, -0.302442>, <0.382953, 0.110278, -0.325846>, <0.382953, 0.120511, -0.327826>, 
      <0.375236, 0.120511, -0.287850>, <0.367249, 0.120511, -0.298273>, <0.358490, 0.107753, -0.320126>, <0.356599, 0.120511, -0.322594>, 
      <0.364003, 0.120511, -0.287850>, <0.356015, 0.120511, -0.298273>, <0.339270, 0.107753, -0.320126>, <0.337378, 0.120511, -0.322594>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.438893, 0.120511, -0.257919>, <0.446881, 0.120511, -0.266447>, <0.463825, 0.109092, -0.284539>, <0.465518, 0.120511, -0.286346>, 
      <0.431266, 0.120511, -0.270111>, <0.439254, 0.120511, -0.278639>, <0.449201, 0.109092, -0.301086>, <0.450894, 0.120511, -0.302894>, 
      <0.414802, 0.120511, -0.282513>, <0.414802, 0.120511, -0.292936>, <0.422698, 0.110278, -0.314603>, <0.422698, 0.120511, -0.316583>, 
      <0.401448, 0.120511, -0.287850>, <0.401448, 0.120511, -0.298273>, <0.401448, 0.110278, -0.320614>, <0.401448, 0.120511, -0.322594>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.438893, 0.120511, -0.257919>, <0.443655, 0.120511, -0.250306>, <0.438893, 0.120511, -0.236967>, <0.438893, 0.120511, -0.227988>, 
      <0.446881, 0.120511, -0.266447>, <0.451642, 0.120511, -0.258835>, <0.448534, 0.120511, -0.240822>, <0.448534, 0.120511, -0.231842>, 
      <0.463825, 0.109092, -0.284539>, <0.471026, 0.109092, -0.276390>, <0.464006, 0.110316, -0.259717>, <0.464006, 0.110316, -0.248843>, 
      <0.465518, 0.120511, -0.286346>, <0.472719, 0.120511, -0.278198>, <0.465518, 0.120511, -0.260972>, <0.465518, 0.120511, -0.250098>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.780474, 0.289138, 0.250512>, <-0.778268, 0.289483, 0.250351>, <-0.775830, 0.291006, 0.248529>, <-0.773607, 0.291006, 0.248269>, 
      <-0.780260, 0.289138, 0.252345>, <-0.778054, 0.289483, 0.252184>, <-0.775605, 0.290886, 0.251084>, <-0.773381, 0.290886, 0.250823>, 
      <-0.779973, 0.289138, 0.254788>, <-0.777914, 0.289400, 0.254370>, <-0.775184, 0.290726, 0.254476>, <-0.773081, 0.290726, 0.254230>, 
      <-0.779759, 0.289138, 0.256621>, <-0.777699, 0.289400, 0.256202>, <-0.774959, 0.290606, 0.257030>, <-0.772855, 0.290606, 0.256784>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.780474, 0.289138, 0.250512>, <-0.795101, 0.241010, 0.251275>, <-0.814604, 0.176839, 0.252293>, <-0.829231, 0.128711, 0.253056>, 
      <-0.780260, 0.289138, 0.252345>, <-0.794887, 0.241010, 0.253108>, <-0.815235, 0.176839, 0.256253>, <-0.829862, 0.128711, 0.257017>, 
      <-0.779973, 0.289138, 0.254788>, <-0.794349, 0.241010, 0.257702>, <-0.814840, 0.176839, 0.259716>, <-0.829215, 0.128711, 0.262630>, 
      <-0.779759, 0.289138, 0.256621>, <-0.794135, 0.241010, 0.259535>, <-0.813302, 0.176839, 0.263420>, <-0.827678, 0.128711, 0.266334>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.765189, 0.289138, 0.248724>, <-0.764975, 0.289138, 0.250557>, <-0.764689, 0.289138, 0.253000>, <-0.764475, 0.289138, 0.254833>, 
      <-0.767723, 0.289501, 0.249122>, <-0.767508, 0.289501, 0.250955>, <-0.767290, 0.289422, 0.253112>, <-0.767076, 0.289422, 0.254945>, 
      <-0.771034, 0.291006, 0.247968>, <-0.770809, 0.290886, 0.250522>, <-0.770480, 0.290726, 0.253925>, <-0.770254, 0.290606, 0.256480>, 
      <-0.773607, 0.291006, 0.248269>, <-0.773381, 0.290886, 0.250823>, <-0.773081, 0.290726, 0.254230>, <-0.772855, 0.290606, 0.256784>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.765189, 0.289138, 0.248724>, <-0.764975, 0.289138, 0.250557>, <-0.764689, 0.289138, 0.253000>, <-0.764475, 0.289138, 0.254833>, 
      <-0.765624, 0.241010, 0.247685>, <-0.765410, 0.241010, 0.249518>, <-0.764873, 0.241010, 0.254112>, <-0.764658, 0.241010, 0.255945>, 
      <-0.766204, 0.176839, 0.246299>, <-0.765738, 0.176839, 0.250283>, <-0.765369, 0.176839, 0.253443>, <-0.764903, 0.176839, 0.257427>, 
      <-0.766639, 0.128711, 0.245260>, <-0.766173, 0.128711, 0.249243>, <-0.765552, 0.128711, 0.254555>, <-0.765086, 0.128711, 0.258538>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.778329, 0.289138, 0.268837>, <-0.776822, 0.289134, 0.267161>, <-0.773312, 0.289111, 0.267149>, <-0.771073, 0.289111, 0.266887>, 
      <-0.778115, 0.289138, 0.270670>, <-0.776608, 0.289134, 0.268994>, <-0.773227, 0.289620, 0.269369>, <-0.770988, 0.289620, 0.269108>, 
      <-0.777828, 0.289138, 0.273114>, <-0.776641, 0.289335, 0.271373>, <-0.772978, 0.290300, 0.272315>, <-0.770876, 0.290300, 0.272068>, 
      <-0.777614, 0.289138, 0.274947>, <-0.776427, 0.289335, 0.273206>, <-0.772893, 0.290809, 0.274535>, <-0.770791, 0.290809, 0.274289>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.778329, 0.289138, 0.268837>, <-0.778758, 0.289138, 0.265172>, <-0.779330, 0.289138, 0.260286>, <-0.779759, 0.289138, 0.256621>, 
      <-0.776822, 0.289134, 0.267161>, <-0.777251, 0.289134, 0.263496>, <-0.777270, 0.289400, 0.259867>, <-0.777699, 0.289400, 0.256202>, 
      <-0.773312, 0.289111, 0.267149>, <-0.773846, 0.289560, 0.264118>, <-0.774424, 0.290158, 0.260061>, <-0.774959, 0.290606, 0.257030>, 
      <-0.771073, 0.289111, 0.266887>, <-0.771608, 0.289560, 0.263856>, <-0.772320, 0.290158, 0.259815>, <-0.772855, 0.290606, 0.256784>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.813322, 0.128711, 0.291394>, <-0.810790, 0.128711, 0.295319>, <-0.806729, 0.128711, 0.300083>, <-0.803645, 0.128711, 0.303591>, 
      <-0.802824, 0.176839, 0.284627>, <-0.800292, 0.176839, 0.288552>, <-0.798920, 0.176839, 0.291490>, <-0.795836, 0.176839, 0.294998>, 
      <-0.788827, 0.241010, 0.275604>, <-0.788612, 0.241010, 0.277437>, <-0.785638, 0.241010, 0.281707>, <-0.785423, 0.241010, 0.283540>, 
      <-0.778329, 0.289138, 0.268837>, <-0.778115, 0.289138, 0.270670>, <-0.777828, 0.289138, 0.273114>, <-0.777614, 0.289138, 0.274947>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.813322, 0.128711, 0.291394>, <-0.802824, 0.176839, 0.284627>, <-0.788827, 0.241010, 0.275604>, <-0.778329, 0.289138, 0.268837>, 
      <-0.818019, 0.128711, 0.284113>, <-0.807521, 0.176839, 0.277346>, <-0.789256, 0.241010, 0.271939>, <-0.778758, 0.289138, 0.265172>, 
      <-0.824357, 0.128711, 0.274337>, <-0.809982, 0.176839, 0.271423>, <-0.793706, 0.241010, 0.263200>, <-0.779330, 0.289138, 0.260286>, 
      <-0.827678, 0.128711, 0.266334>, <-0.813302, 0.176839, 0.263420>, <-0.794135, 0.241010, 0.259535>, <-0.779759, 0.289138, 0.256621>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.763045, 0.289138, 0.267050>, <-0.765053, 0.289134, 0.265719>, <-0.768680, 0.289111, 0.266607>, <-0.771073, 0.289111, 0.266887>, 
      <-0.763474, 0.289138, 0.263385>, <-0.765482, 0.289134, 0.262054>, <-0.769215, 0.289560, 0.263576>, <-0.771608, 0.289560, 0.263856>, 
      <-0.764046, 0.289138, 0.258498>, <-0.766647, 0.289422, 0.258610>, <-0.769720, 0.290158, 0.259511>, <-0.772320, 0.290158, 0.259815>, 
      <-0.764475, 0.289138, 0.254833>, <-0.767076, 0.289422, 0.254945>, <-0.770254, 0.290606, 0.256480>, <-0.772855, 0.290606, 0.256784>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.763045, 0.289138, 0.267050>, <-0.762831, 0.289138, 0.268882>, <-0.762544, 0.289138, 0.271326>, <-0.762330, 0.289138, 0.273158>, 
      <-0.765053, 0.289134, 0.265719>, <-0.764839, 0.289134, 0.267552>, <-0.764578, 0.289366, 0.269706>, <-0.764363, 0.289366, 0.271538>, 
      <-0.768680, 0.289111, 0.266607>, <-0.768596, 0.289620, 0.268828>, <-0.768284, 0.290300, 0.271765>, <-0.768199, 0.290809, 0.273986>, 
      <-0.771073, 0.289111, 0.266887>, <-0.770988, 0.289620, 0.269108>, <-0.770876, 0.290300, 0.272068>, <-0.770791, 0.290809, 0.274289>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.761978, 0.128711, 0.285094>, <-0.762910, 0.128711, 0.277127>, <-0.764154, 0.128711, 0.266505>, <-0.765086, 0.128711, 0.258538>, 
      <-0.762298, 0.176839, 0.279681>, <-0.763231, 0.176839, 0.271714>, <-0.763971, 0.176839, 0.265393>, <-0.764903, 0.176839, 0.257427>, 
      <-0.762725, 0.241010, 0.272463>, <-0.763154, 0.241010, 0.268798>, <-0.764230, 0.241010, 0.259610>, <-0.764658, 0.241010, 0.255945>, 
      <-0.763045, 0.289138, 0.267050>, <-0.763474, 0.289138, 0.263385>, <-0.764046, 0.289138, 0.258498>, <-0.764475, 0.289138, 0.254833>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.761978, 0.128711, 0.285094>, <-0.762298, 0.176839, 0.279681>, <-0.762725, 0.241010, 0.272463>, <-0.763045, 0.289138, 0.267050>, 
      <-0.761512, 0.128711, 0.289078>, <-0.761832, 0.176839, 0.283664>, <-0.762510, 0.241010, 0.274296>, <-0.762831, 0.289138, 0.268882>, 
      <-0.760890, 0.128711, 0.294389>, <-0.761462, 0.176839, 0.286825>, <-0.761973, 0.241010, 0.278890>, <-0.762544, 0.289138, 0.271326>, 
      <-0.760424, 0.128711, 0.298373>, <-0.760996, 0.176839, 0.290809>, <-0.761758, 0.241010, 0.280722>, <-0.762330, 0.289138, 0.273158>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.781903, 0.289138, 0.238296>, <-0.780143, 0.289056, 0.239632>, <-0.776815, 0.288519, 0.239500>, <-0.774619, 0.288519, 0.239243>, 
      <-0.781474, 0.289138, 0.241961>, <-0.779714, 0.289056, 0.243297>, <-0.776512, 0.289265, 0.242208>, <-0.774315, 0.289265, 0.241951>, 
      <-0.780903, 0.289138, 0.246847>, <-0.778697, 0.289483, 0.246686>, <-0.776134, 0.290260, 0.245821>, <-0.773911, 0.290260, 0.245561>, 
      <-0.780474, 0.289138, 0.250512>, <-0.778268, 0.289483, 0.250351>, <-0.775830, 0.291006, 0.248529>, <-0.773607, 0.291006, 0.248269>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.781903, 0.289138, 0.238296>, <-0.793660, 0.241010, 0.234308>, <-0.809335, 0.176839, 0.228991>, <-0.821092, 0.128711, 0.225003>, 
      <-0.781474, 0.289138, 0.241961>, <-0.793231, 0.241010, 0.237973>, <-0.812207, 0.176839, 0.237270>, <-0.823963, 0.128711, 0.233282>, 
      <-0.780903, 0.289138, 0.246847>, <-0.795530, 0.241010, 0.247610>, <-0.813225, 0.176839, 0.243639>, <-0.827852, 0.128711, 0.244402>, 
      <-0.780474, 0.289138, 0.250512>, <-0.795101, 0.241010, 0.251275>, <-0.814604, 0.176839, 0.252293>, <-0.829231, 0.128711, 0.253056>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.766619, 0.289138, 0.236507>, <-0.766190, 0.289138, 0.240172>, <-0.765618, 0.289138, 0.245059>, <-0.765189, 0.289138, 0.248724>, 
      <-0.768321, 0.289048, 0.238395>, <-0.767892, 0.289048, 0.242060>, <-0.768151, 0.289501, 0.245457>, <-0.767723, 0.289501, 0.249122>, 
      <-0.772093, 0.288519, 0.238947>, <-0.771790, 0.289265, 0.241655>, <-0.771338, 0.290260, 0.245260>, <-0.771034, 0.291006, 0.247968>, 
      <-0.774619, 0.288519, 0.239243>, <-0.774315, 0.289265, 0.241951>, <-0.773911, 0.290260, 0.245561>, <-0.773607, 0.291006, 0.248269>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.766619, 0.289138, 0.236507>, <-0.766190, 0.289138, 0.240172>, <-0.765618, 0.289138, 0.245059>, <-0.765189, 0.289138, 0.248724>, 
      <-0.767558, 0.241010, 0.231166>, <-0.767128, 0.241010, 0.234831>, <-0.766053, 0.241010, 0.244020>, <-0.765624, 0.241010, 0.247685>, 
      <-0.768809, 0.176839, 0.224044>, <-0.767876, 0.176839, 0.232011>, <-0.767136, 0.176839, 0.238332>, <-0.766204, 0.176839, 0.246299>, 
      <-0.769747, 0.128711, 0.218703>, <-0.768815, 0.128711, 0.226670>, <-0.767571, 0.128711, 0.237293>, <-0.766639, 0.128711, 0.245260>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.767334, 0.289138, 0.230398>, <-0.767120, 0.289138, 0.232231>, <-0.766834, 0.289138, 0.234674>, <-0.766619, 0.289138, 0.236507>, 
      <-0.768530, 0.289157, 0.232480>, <-0.768316, 0.289157, 0.234312>, <-0.768536, 0.289048, 0.236562>, <-0.768321, 0.289048, 0.238395>, 
      <-0.771991, 0.289298, 0.233918>, <-0.772064, 0.289064, 0.235432>, <-0.772020, 0.288753, 0.237434>, <-0.772093, 0.288519, 0.238947>, 
      <-0.774375, 0.289298, 0.234197>, <-0.774448, 0.289064, 0.235711>, <-0.774546, 0.288753, 0.237729>, <-0.774619, 0.288519, 0.239243>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.767334, 0.289138, 0.230398>, <-0.767120, 0.289138, 0.232231>, <-0.766834, 0.289138, 0.234674>, <-0.766619, 0.289138, 0.236507>, 
      <-0.768524, 0.241010, 0.222906>, <-0.768310, 0.241010, 0.224739>, <-0.767772, 0.241010, 0.229333>, <-0.767558, 0.241010, 0.231166>, 
      <-0.770111, 0.176839, 0.212917>, <-0.769645, 0.176839, 0.216900>, <-0.769275, 0.176839, 0.220061>, <-0.768809, 0.176839, 0.224044>, 
      <-0.771301, 0.128711, 0.205425>, <-0.770835, 0.128711, 0.209408>, <-0.770213, 0.128711, 0.214720>, <-0.769747, 0.128711, 0.218703>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.782618, 0.289138, 0.232187>, <-0.780838, 0.289157, 0.234007>, <-0.776904, 0.289298, 0.234493>, <-0.774375, 0.289298, 0.234197>, 
      <-0.782404, 0.289138, 0.234020>, <-0.780624, 0.289157, 0.235840>, <-0.776977, 0.289064, 0.236007>, <-0.774448, 0.289064, 0.235711>, 
      <-0.782118, 0.289138, 0.236463>, <-0.780357, 0.289056, 0.237799>, <-0.776742, 0.288753, 0.237986>, <-0.774546, 0.288753, 0.237729>, 
      <-0.781903, 0.289138, 0.238296>, <-0.780143, 0.289056, 0.239632>, <-0.776815, 0.288519, 0.239500>, <-0.774619, 0.288519, 0.239243>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.782618, 0.289138, 0.232187>, <-0.792189, 0.241010, 0.225724>, <-0.804951, 0.176839, 0.217106>, <-0.814522, 0.128711, 0.210643>, 
      <-0.782404, 0.289138, 0.234020>, <-0.791975, 0.241010, 0.227556>, <-0.807131, 0.176839, 0.221312>, <-0.816702, 0.128711, 0.214849>, 
      <-0.782118, 0.289138, 0.236463>, <-0.793874, 0.241010, 0.232475>, <-0.807783, 0.176839, 0.224515>, <-0.819540, 0.128711, 0.220527>, 
      <-0.781903, 0.289138, 0.238296>, <-0.793660, 0.241010, 0.234308>, <-0.809335, 0.176839, 0.228991>, <-0.821092, 0.128711, 0.225003>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.762905, 0.289138, 0.226251>, <-0.763209, 0.292235, 0.227262>, <-0.764429, 0.289254, 0.234078>, <-0.766619, 0.289138, 0.236507>, 
      <-0.763256, 0.289138, 0.223256>, <-0.763559, 0.292235, 0.224267>, <-0.764644, 0.289254, 0.232245>, <-0.766834, 0.289138, 0.234674>, 
      <-0.763722, 0.289138, 0.219262>, <-0.764053, 0.293093, 0.221045>, <-0.764952, 0.289104, 0.228458>, <-0.767120, 0.289138, 0.232231>, 
      <-0.764073, 0.289138, 0.216266>, <-0.764403, 0.293093, 0.218049>, <-0.765166, 0.289104, 0.226626>, <-0.767334, 0.289138, 0.230398>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.760568, 0.289138, 0.246219>, <-0.760766, 0.290698, 0.246340>, <-0.763647, 0.288917, 0.248481>, <-0.765189, 0.289138, 0.248724>, 
      <-0.761269, 0.289138, 0.240229>, <-0.761467, 0.290698, 0.240350>, <-0.764075, 0.288917, 0.244816>, <-0.765618, 0.289138, 0.245059>, 
      <-0.762204, 0.289138, 0.232241>, <-0.762508, 0.292235, 0.233253>, <-0.764000, 0.289254, 0.237743>, <-0.766190, 0.289138, 0.240172>, 
      <-0.762905, 0.289138, 0.226251>, <-0.763209, 0.292235, 0.227262>, <-0.764429, 0.289254, 0.234078>, <-0.766619, 0.289138, 0.236507>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.759400, 0.289138, 0.256204>, <-0.759621, 0.290698, 0.256132>, <-0.762909, 0.288967, 0.254765>, <-0.764475, 0.289138, 0.254833>, 
      <-0.759751, 0.289138, 0.253209>, <-0.759972, 0.290698, 0.253136>, <-0.763123, 0.288967, 0.252933>, <-0.764689, 0.289138, 0.253000>, 
      <-0.760217, 0.289138, 0.249215>, <-0.760416, 0.290698, 0.249336>, <-0.763432, 0.288917, 0.250314>, <-0.764975, 0.289138, 0.250557>, 
      <-0.760568, 0.289138, 0.246219>, <-0.760766, 0.290698, 0.246340>, <-0.763647, 0.288917, 0.248481>, <-0.765189, 0.289138, 0.248724>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.757063, 0.289138, 0.276171>, <-0.757592, 0.292235, 0.275257>, <-0.760317, 0.289143, 0.268858>, <-0.763045, 0.289138, 0.267050>, 
      <-0.757764, 0.289138, 0.270181>, <-0.758293, 0.292235, 0.269267>, <-0.760746, 0.289143, 0.265193>, <-0.763474, 0.289138, 0.263385>, 
      <-0.758699, 0.289138, 0.262194>, <-0.758920, 0.290698, 0.262122>, <-0.762480, 0.288967, 0.258431>, <-0.764046, 0.289138, 0.258498>, 
      <-0.759400, 0.289138, 0.256204>, <-0.759621, 0.290698, 0.256132>, <-0.762909, 0.288967, 0.254765>, <-0.764475, 0.289138, 0.254833>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.755894, 0.289138, 0.286156>, <-0.756627, 0.293093, 0.284497>, <-0.758940, 0.288758, 0.275859>, <-0.762330, 0.289138, 0.273158>, 
      <-0.756245, 0.289138, 0.283160>, <-0.756978, 0.293093, 0.281502>, <-0.759154, 0.288758, 0.274026>, <-0.762544, 0.289138, 0.271326>, 
      <-0.756712, 0.289138, 0.279166>, <-0.757241, 0.292235, 0.278253>, <-0.760103, 0.289143, 0.270690>, <-0.762831, 0.289138, 0.268882>, 
      <-0.757063, 0.289138, 0.276171>, <-0.757592, 0.292235, 0.275257>, <-0.760317, 0.289143, 0.268858>, <-0.763045, 0.289138, 0.267050>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.782044, 0.289138, 0.279095>, <-0.780500, 0.291831, 0.278056>, <-0.780517, 0.289143, 0.271271>, <-0.778329, 0.289138, 0.268837>, 
      <-0.781694, 0.289138, 0.282090>, <-0.780150, 0.291831, 0.281051>, <-0.780302, 0.289143, 0.273104>, <-0.778115, 0.289138, 0.270670>, 
      <-0.781226, 0.289138, 0.286084>, <-0.779576, 0.292744, 0.284293>, <-0.780269, 0.288734, 0.276693>, <-0.777828, 0.289138, 0.273114>, 
      <-0.780875, 0.289138, 0.289079>, <-0.779225, 0.292744, 0.287288>, <-0.780054, 0.288734, 0.278526>, <-0.777614, 0.289138, 0.274947>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.784380, 0.289138, 0.259127>, <-0.783447, 0.290394, 0.258931>, <-0.781292, 0.288943, 0.256933>, <-0.779759, 0.289138, 0.256621>, 
      <-0.783679, 0.289138, 0.265117>, <-0.782746, 0.290394, 0.264922>, <-0.780864, 0.288943, 0.260598>, <-0.779330, 0.289138, 0.260286>, 
      <-0.782745, 0.289138, 0.273105>, <-0.781201, 0.291831, 0.272066>, <-0.780946, 0.289143, 0.267607>, <-0.778758, 0.289138, 0.265172>, 
      <-0.782044, 0.289138, 0.279095>, <-0.780500, 0.291831, 0.278056>, <-0.780517, 0.289143, 0.271271>, <-0.778329, 0.289138, 0.268837>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.785549, 0.289138, 0.249142>, <-0.784597, 0.290395, 0.249103>, <-0.782028, 0.288895, 0.250626>, <-0.780474, 0.289138, 0.250512>, 
      <-0.785198, 0.289138, 0.252138>, <-0.784247, 0.290395, 0.252098>, <-0.781814, 0.288895, 0.252458>, <-0.780260, 0.289138, 0.252345>, 
      <-0.784731, 0.289138, 0.256132>, <-0.783798, 0.290394, 0.255936>, <-0.781507, 0.288943, 0.255100>, <-0.779973, 0.289138, 0.254788>, 
      <-0.784380, 0.289138, 0.259127>, <-0.783447, 0.290394, 0.258931>, <-0.781292, 0.288943, 0.256933>, <-0.779759, 0.289138, 0.256621>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.787886, 0.289138, 0.229174>, <-0.786144, 0.291835, 0.229810>, <-0.784508, 0.289260, 0.236319>, <-0.781903, 0.289138, 0.238296>, 
      <-0.787185, 0.289138, 0.235164>, <-0.785443, 0.291835, 0.235800>, <-0.784079, 0.289260, 0.239984>, <-0.781474, 0.289138, 0.241961>, 
      <-0.786250, 0.289138, 0.243152>, <-0.785299, 0.290395, 0.243112>, <-0.782457, 0.288895, 0.246961>, <-0.780903, 0.289138, 0.246847>, 
      <-0.785549, 0.289138, 0.249142>, <-0.784597, 0.290395, 0.249103>, <-0.782028, 0.288895, 0.250626>, <-0.780474, 0.289138, 0.250512>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.789054, 0.289138, 0.219189>, <-0.787035, 0.292749, 0.220538>, <-0.785660, 0.289105, 0.229076>, <-0.782618, 0.289138, 0.232187>, 
      <-0.788704, 0.289138, 0.222185>, <-0.786684, 0.292749, 0.223534>, <-0.785446, 0.289105, 0.230909>, <-0.782404, 0.289138, 0.234020>, 
      <-0.788237, 0.289138, 0.226179>, <-0.786494, 0.291835, 0.226815>, <-0.784723, 0.289260, 0.234486>, <-0.782118, 0.289138, 0.236463>, 
      <-0.787886, 0.289138, 0.229174>, <-0.786144, 0.291835, 0.229810>, <-0.784508, 0.289260, 0.236319>, <-0.781903, 0.289138, 0.238296>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.783333, 0.289138, 0.226079>, <-0.784123, 0.289138, 0.227746>, <-0.782833, 0.289138, 0.230355>, <-0.782618, 0.289138, 0.232187>, 
      <-0.785400, 0.289138, 0.221017>, <-0.786190, 0.289138, 0.222684>, <-0.785875, 0.289105, 0.227244>, <-0.785660, 0.289105, 0.229076>, 
      <-0.788194, 0.293653, 0.211529>, <-0.789485, 0.293653, 0.214254>, <-0.787385, 0.292749, 0.217543>, <-0.787035, 0.292749, 0.220538>, 
      <-0.790222, 0.289138, 0.209206>, <-0.791513, 0.289138, 0.211931>, <-0.789404, 0.289138, 0.216194>, <-0.789054, 0.289138, 0.219189>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.783333, 0.289138, 0.226079>, <-0.785400, 0.289138, 0.221017>, <-0.788194, 0.293653, 0.211529>, <-0.790222, 0.289138, 0.209206>, 
      <-0.782068, 0.289138, 0.223409>, <-0.784134, 0.289138, 0.218347>, <-0.786126, 0.293653, 0.207164>, <-0.788154, 0.289138, 0.204841>, 
      <-0.779004, 0.289138, 0.220484>, <-0.779798, 0.289110, 0.214095>, <-0.782066, 0.294413, 0.203592>, <-0.783146, 0.289138, 0.200062>, 
      <-0.776406, 0.289138, 0.219076>, <-0.777200, 0.289110, 0.212687>, <-0.777820, 0.294413, 0.201290>, <-0.778900, 0.289138, 0.197760>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.783333, 0.289138, 0.226079>, <-0.782068, 0.289138, 0.223409>, <-0.779004, 0.289138, 0.220484>, <-0.776406, 0.289138, 0.219076>, 
      <-0.784123, 0.289138, 0.227746>, <-0.782858, 0.289138, 0.225076>, <-0.778440, 0.289158, 0.225026>, <-0.775842, 0.289158, 0.223618>, 
      <-0.782833, 0.289138, 0.230355>, <-0.781052, 0.289157, 0.232175>, <-0.777513, 0.289250, 0.229957>, <-0.774984, 0.289250, 0.229661>, 
      <-0.782618, 0.289138, 0.232187>, <-0.780838, 0.289157, 0.234007>, <-0.776904, 0.289298, 0.234493>, <-0.774375, 0.289298, 0.234197>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.768763, 0.289138, 0.218182>, <-0.771056, 0.289138, 0.218450>, <-0.774376, 0.289138, 0.217976>, <-0.776406, 0.289138, 0.219076>, 
      <-0.768057, 0.289138, 0.211617>, <-0.770350, 0.289138, 0.211885>, <-0.775170, 0.289110, 0.211587>, <-0.777200, 0.289110, 0.212687>, 
      <-0.766704, 0.294544, 0.200078>, <-0.770451, 0.294544, 0.200517>, <-0.774504, 0.294413, 0.199492>, <-0.777820, 0.294413, 0.201290>, 
      <-0.766410, 0.289138, 0.196297>, <-0.770157, 0.289138, 0.196736>, <-0.775583, 0.289138, 0.195962>, <-0.778900, 0.289138, 0.197760>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.768763, 0.289138, 0.218182>, <-0.768057, 0.289138, 0.211617>, <-0.766704, 0.294544, 0.200078>, <-0.766410, 0.289138, 0.196297>, 
      <-0.768334, 0.289138, 0.221847>, <-0.767628, 0.289138, 0.215281>, <-0.766003, 0.294544, 0.206069>, <-0.765709, 0.289138, 0.202288>, 
      <-0.767763, 0.289138, 0.226733>, <-0.765595, 0.289104, 0.222961>, <-0.765104, 0.293093, 0.212059>, <-0.764774, 0.289138, 0.210275>, 
      <-0.767334, 0.289138, 0.230398>, <-0.765166, 0.289104, 0.226626>, <-0.764403, 0.293093, 0.218049>, <-0.764073, 0.289138, 0.216266>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.768763, 0.289138, 0.218182>, <-0.768334, 0.289138, 0.221847>, <-0.767763, 0.289138, 0.226733>, <-0.767334, 0.289138, 0.230398>, 
      <-0.771056, 0.289138, 0.218450>, <-0.770627, 0.289138, 0.222115>, <-0.768959, 0.289157, 0.228815>, <-0.768530, 0.289157, 0.232480>, 
      <-0.774376, 0.289138, 0.217976>, <-0.773812, 0.289158, 0.222518>, <-0.772600, 0.289250, 0.229382>, <-0.771991, 0.289298, 0.233918>, 
      <-0.776406, 0.289138, 0.219076>, <-0.775842, 0.289158, 0.223618>, <-0.774984, 0.289250, 0.229661>, <-0.774375, 0.289298, 0.234197>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.760900, 0.289138, 0.285375>, <-0.761329, 0.289138, 0.281710>, <-0.761901, 0.289138, 0.276823>, <-0.762330, 0.289138, 0.273158>, 
      <-0.758697, 0.289138, 0.291600>, <-0.759126, 0.289138, 0.287935>, <-0.758511, 0.288758, 0.279524>, <-0.758940, 0.288758, 0.275859>, 
      <-0.754717, 0.294544, 0.302514>, <-0.755418, 0.294544, 0.296523>, <-0.755926, 0.293093, 0.290488>, <-0.756627, 0.293093, 0.284497>, 
      <-0.753558, 0.289138, 0.306125>, <-0.754259, 0.289138, 0.300134>, <-0.755193, 0.289138, 0.292147>, <-0.755894, 0.289138, 0.286156>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.760900, 0.289138, 0.285375>, <-0.758697, 0.289138, 0.291600>, <-0.754717, 0.294544, 0.302514>, <-0.753558, 0.289138, 0.306125>, 
      <-0.763193, 0.289138, 0.285643>, <-0.760990, 0.289138, 0.291868>, <-0.758464, 0.294544, 0.302952>, <-0.757305, 0.289138, 0.306563>, 
      <-0.766314, 0.289138, 0.286871>, <-0.765407, 0.288818, 0.293237>, <-0.762170, 0.294413, 0.304885>, <-0.762406, 0.289138, 0.308570>, 
      <-0.768542, 0.289138, 0.286269>, <-0.767635, 0.288818, 0.292635>, <-0.765812, 0.294413, 0.303902>, <-0.766048, 0.289138, 0.307586>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.760900, 0.289138, 0.285375>, <-0.763193, 0.289138, 0.285643>, <-0.766314, 0.289138, 0.286871>, <-0.768542, 0.289138, 0.286269>, 
      <-0.761329, 0.289138, 0.281710>, <-0.763622, 0.289138, 0.281978>, <-0.766833, 0.289321, 0.283221>, <-0.769062, 0.289321, 0.282619>, 
      <-0.761901, 0.289138, 0.276823>, <-0.763934, 0.289366, 0.275203>, <-0.767525, 0.290308, 0.277580>, <-0.770116, 0.290308, 0.277883>, 
      <-0.762330, 0.289138, 0.273158>, <-0.764363, 0.289366, 0.271538>, <-0.768199, 0.290809, 0.273986>, <-0.770791, 0.290809, 0.274289>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.776900, 0.289138, 0.281055>, <-0.775052, 0.289138, 0.283361>, <-0.771395, 0.289138, 0.285499>, <-0.768542, 0.289138, 0.286269>, 
      <-0.777742, 0.289138, 0.286457>, <-0.775894, 0.289138, 0.288764>, <-0.770488, 0.288818, 0.291865>, <-0.767635, 0.288818, 0.292635>, 
      <-0.778270, 0.293653, 0.296334>, <-0.775250, 0.293653, 0.300104>, <-0.770475, 0.294413, 0.302643>, <-0.765812, 0.294413, 0.303902>, 
      <-0.779707, 0.289138, 0.299063>, <-0.776687, 0.289138, 0.302833>, <-0.770711, 0.289138, 0.306327>, <-0.766048, 0.289138, 0.307586>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.776900, 0.289138, 0.281055>, <-0.778054, 0.289138, 0.279615>, <-0.777400, 0.289138, 0.276779>, <-0.777614, 0.289138, 0.274947>, 
      <-0.775052, 0.289138, 0.283361>, <-0.776206, 0.289138, 0.281922>, <-0.776212, 0.289335, 0.275038>, <-0.776427, 0.289335, 0.273206>, 
      <-0.771395, 0.289138, 0.285499>, <-0.771915, 0.289321, 0.281849>, <-0.772219, 0.290308, 0.278129>, <-0.772893, 0.290809, 0.274535>, 
      <-0.768542, 0.289138, 0.286269>, <-0.769062, 0.289321, 0.282619>, <-0.770116, 0.290308, 0.277883>, <-0.770791, 0.290809, 0.274289>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.776900, 0.289138, 0.281055>, <-0.777742, 0.289138, 0.286457>, <-0.778270, 0.293653, 0.296334>, <-0.779707, 0.289138, 0.299063>, 
      <-0.778054, 0.289138, 0.279615>, <-0.778896, 0.289138, 0.285018>, <-0.780156, 0.293653, 0.293981>, <-0.781593, 0.289138, 0.296710>, 
      <-0.777400, 0.289138, 0.276779>, <-0.779840, 0.288734, 0.280359>, <-0.778875, 0.292744, 0.290284>, <-0.780524, 0.289138, 0.292074>, 
      <-0.777614, 0.289138, 0.274947>, <-0.780054, 0.288734, 0.278526>, <-0.779225, 0.292744, 0.287288>, <-0.780875, 0.289138, 0.289079>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.792824, 0.208925, 0.165398>, <-0.790596, 0.234596, 0.170576>, <-0.783308, 0.267604, 0.183350>, <-0.778900, 0.289138, 0.197760>, 
      <-0.801939, 0.208925, 0.169168>, <-0.799711, 0.234596, 0.174346>, <-0.787554, 0.267604, 0.185652>, <-0.783146, 0.289138, 0.200062>, 
      <-0.812605, 0.208925, 0.177623>, <-0.807898, 0.234837, 0.181564>, <-0.798032, 0.267149, 0.193527>, <-0.788154, 0.289138, 0.204841>, 
      <-0.819366, 0.208925, 0.184806>, <-0.814659, 0.234837, 0.188747>, <-0.800100, 0.267149, 0.197892>, <-0.790222, 0.289138, 0.209206>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.764401, 0.208925, 0.162073>, <-0.764659, 0.234519, 0.167526>, <-0.765245, 0.267715, 0.181312>, <-0.766410, 0.289138, 0.196297>, 
      <-0.772928, 0.208925, 0.163071>, <-0.773186, 0.234519, 0.168524>, <-0.768992, 0.267715, 0.181751>, <-0.770157, 0.289138, 0.196736>, 
      <-0.784891, 0.208925, 0.162117>, <-0.782663, 0.234596, 0.167295>, <-0.779991, 0.267604, 0.181552>, <-0.775583, 0.289138, 0.195962>, 
      <-0.792824, 0.208925, 0.165398>, <-0.790596, 0.234596, 0.170576>, <-0.783308, 0.267604, 0.183350>, <-0.778900, 0.289138, 0.197760>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.760637, 0.208925, 0.194234>, <-0.761167, 0.233664, 0.197631>, <-0.762177, 0.266434, 0.206030>, <-0.764073, 0.289138, 0.216266>, 
      <-0.761766, 0.208925, 0.184586>, <-0.762296, 0.233664, 0.187983>, <-0.762879, 0.266434, 0.200039>, <-0.764774, 0.289138, 0.210275>, 
      <-0.763272, 0.208925, 0.171721>, <-0.763530, 0.234519, 0.177175>, <-0.764544, 0.267715, 0.187303>, <-0.765709, 0.289138, 0.202288>, 
      <-0.764401, 0.208925, 0.162073>, <-0.764659, 0.234519, 0.167526>, <-0.765245, 0.267715, 0.181312>, <-0.766410, 0.289138, 0.196297>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.758755, 0.208925, 0.210315>, <-0.759387, 0.233362, 0.212743>, <-0.760625, 0.265886, 0.218659>, <-0.762905, 0.289138, 0.226251>, 
      <-0.759320, 0.208925, 0.205491>, <-0.759952, 0.233362, 0.207918>, <-0.760976, 0.265886, 0.215663>, <-0.763256, 0.289138, 0.223256>, 
      <-0.760072, 0.208925, 0.199058>, <-0.760602, 0.233664, 0.202456>, <-0.761827, 0.266434, 0.209026>, <-0.763722, 0.289138, 0.219262>, 
      <-0.760637, 0.208925, 0.194234>, <-0.761167, 0.233664, 0.197631>, <-0.762177, 0.266434, 0.206030>, <-0.764073, 0.289138, 0.216266>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.754992, 0.208925, 0.242476>, <-0.755831, 0.233052, 0.243039>, <-0.757532, 0.265254, 0.244359>, <-0.760568, 0.289138, 0.246219>, 
      <-0.756121, 0.208925, 0.232828>, <-0.756960, 0.233052, 0.233391>, <-0.758233, 0.265254, 0.238368>, <-0.761269, 0.289138, 0.240229>, 
      <-0.757626, 0.208925, 0.219963>, <-0.758258, 0.233362, 0.222391>, <-0.759925, 0.265886, 0.224649>, <-0.762204, 0.289138, 0.232241>, 
      <-0.758755, 0.208925, 0.210315>, <-0.759387, 0.233362, 0.212743>, <-0.760625, 0.265886, 0.218659>, <-0.762905, 0.289138, 0.226251>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.753110, 0.208925, 0.258558>, <-0.754056, 0.233052, 0.258204>, <-0.756016, 0.265254, 0.257313>, <-0.759400, 0.289138, 0.256204>, 
      <-0.753675, 0.208925, 0.253733>, <-0.754621, 0.233052, 0.253379>, <-0.756367, 0.265254, 0.254318>, <-0.759751, 0.289138, 0.253209>, 
      <-0.754428, 0.208925, 0.247301>, <-0.755266, 0.233052, 0.247863>, <-0.757181, 0.265254, 0.247354>, <-0.760217, 0.289138, 0.249215>, 
      <-0.754992, 0.208925, 0.242476>, <-0.755831, 0.233052, 0.243039>, <-0.757532, 0.265254, 0.244359>, <-0.760568, 0.289138, 0.246219>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.749346, 0.208925, 0.290719>, <-0.750522, 0.233362, 0.288503>, <-0.753092, 0.265886, 0.283032>, <-0.757063, 0.289138, 0.276171>, 
      <-0.750475, 0.208925, 0.281071>, <-0.751651, 0.233362, 0.278855>, <-0.753793, 0.265886, 0.277042>, <-0.757764, 0.289138, 0.270181>, 
      <-0.751981, 0.208925, 0.268206>, <-0.752927, 0.233052, 0.267852>, <-0.755315, 0.265254, 0.263303>, <-0.758699, 0.289138, 0.262194>, 
      <-0.753110, 0.208925, 0.258558>, <-0.754056, 0.233052, 0.258204>, <-0.756016, 0.265254, 0.257313>, <-0.759400, 0.289138, 0.256204>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.747464, 0.208925, 0.306799>, <-0.748764, 0.233664, 0.303616>, <-0.751686, 0.266435, 0.295678>, <-0.755894, 0.289138, 0.286156>, 
      <-0.748028, 0.208925, 0.301975>, <-0.749328, 0.233664, 0.298792>, <-0.752037, 0.266435, 0.292682>, <-0.756245, 0.289138, 0.283160>, 
      <-0.748781, 0.208925, 0.295543>, <-0.749957, 0.233362, 0.293327>, <-0.752741, 0.265886, 0.286027>, <-0.756712, 0.289138, 0.279166>, 
      <-0.749346, 0.208925, 0.290719>, <-0.750522, 0.233362, 0.288503>, <-0.753092, 0.265886, 0.283032>, <-0.757063, 0.289138, 0.276171>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.743701, 0.208925, 0.338961>, <-0.745273, 0.234517, 0.333723>, <-0.748965, 0.267715, 0.320436>, <-0.753558, 0.289138, 0.306125>, 
      <-0.744830, 0.208925, 0.329312>, <-0.746402, 0.234517, 0.324074>, <-0.749665, 0.267715, 0.314446>, <-0.754259, 0.289138, 0.300134>, 
      <-0.746335, 0.208925, 0.316448>, <-0.747635, 0.233664, 0.313264>, <-0.750985, 0.266435, 0.301668>, <-0.755193, 0.289138, 0.292147>, 
      <-0.747464, 0.208925, 0.306799>, <-0.748764, 0.233664, 0.303616>, <-0.751686, 0.266435, 0.295678>, <-0.755894, 0.289138, 0.286156>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.772125, 0.208925, 0.342287>, <-0.771153, 0.234596, 0.336734>, <-0.767010, 0.267605, 0.322624>, <-0.766048, 0.289138, 0.307586>, 
      <-0.763648, 0.208925, 0.343648>, <-0.762676, 0.234596, 0.338095>, <-0.763368, 0.267605, 0.323608>, <-0.762406, 0.289138, 0.308570>, 
      <-0.752228, 0.208925, 0.339959>, <-0.753801, 0.234517, 0.334721>, <-0.752712, 0.267715, 0.320875>, <-0.757305, 0.289138, 0.306563>, 
      <-0.743701, 0.208925, 0.338961>, <-0.745273, 0.234517, 0.333723>, <-0.748965, 0.267715, 0.320436>, <-0.753558, 0.289138, 0.306125>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.802430, 0.208925, 0.329533>, <-0.798760, 0.234837, 0.324612>, <-0.786706, 0.267149, 0.312352>, <-0.779707, 0.289138, 0.299063>, 
      <-0.794168, 0.208925, 0.334921>, <-0.790497, 0.234837, 0.329999>, <-0.783686, 0.267149, 0.316122>, <-0.776687, 0.289138, 0.302833>, 
      <-0.781864, 0.208925, 0.340724>, <-0.780892, 0.234596, 0.335171>, <-0.771673, 0.267605, 0.321365>, <-0.770711, 0.289138, 0.306327>, 
      <-0.772125, 0.208925, 0.342287>, <-0.771153, 0.234596, 0.336734>, <-0.767010, 0.267605, 0.322624>, <-0.766048, 0.289138, 0.307586>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.814309, 0.208925, 0.314781>, <-0.808829, 0.235219, 0.310569>, <-0.791183, 0.266606, 0.300268>, <-0.780875, 0.289138, 0.289079>, 
      <-0.810942, 0.208925, 0.319358>, <-0.805462, 0.235219, 0.315146>, <-0.790832, 0.266606, 0.303264>, <-0.780524, 0.289138, 0.292074>, 
      <-0.807190, 0.208925, 0.326429>, <-0.803520, 0.234837, 0.321508>, <-0.788591, 0.267149, 0.309999>, <-0.781593, 0.289138, 0.296710>, 
      <-0.802430, 0.208925, 0.329533>, <-0.798760, 0.234837, 0.324612>, <-0.786706, 0.267149, 0.312352>, <-0.779707, 0.289138, 0.299063>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.824314, 0.208925, 0.299782>, <-0.817260, 0.235697, 0.296330>, <-0.795203, 0.266185, 0.287950>, <-0.782044, 0.289138, 0.279095>, 
      <-0.821715, 0.208925, 0.304526>, <-0.814661, 0.235697, 0.301073>, <-0.794852, 0.266185, 0.290945>, <-0.781694, 0.289138, 0.282090>, 
      <-0.817514, 0.208925, 0.310424>, <-0.812034, 0.235219, 0.306211>, <-0.791533, 0.266606, 0.297273>, <-0.781226, 0.289138, 0.286084>, 
      <-0.814309, 0.208925, 0.314781>, <-0.808829, 0.235219, 0.310569>, <-0.791183, 0.266606, 0.300268>, <-0.780875, 0.289138, 0.289079>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.839326, 0.208925, 0.269117>, <-0.829842, 0.236617, 0.267393>, <-0.801727, 0.265779, 0.262766>, <-0.784380, 0.289138, 0.259127>, 
      <-0.835845, 0.208925, 0.278750>, <-0.826360, 0.236617, 0.277025>, <-0.801025, 0.265779, 0.268756>, <-0.783679, 0.289138, 0.265117>, 
      <-0.829235, 0.208925, 0.290799>, <-0.822181, 0.235697, 0.287347>, <-0.795904, 0.266185, 0.281959>, <-0.782745, 0.289138, 0.273105>, 
      <-0.824314, 0.208925, 0.299782>, <-0.817260, 0.235697, 0.296330>, <-0.795203, 0.266185, 0.287950>, <-0.782044, 0.289138, 0.279095>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.841208, 0.208925, 0.253036>, <-0.831603, 0.236611, 0.252364>, <-0.803238, 0.265776, 0.249877>, <-0.785549, 0.289138, 0.249142>, 
      <-0.841752, 0.208925, 0.257863>, <-0.832146, 0.236611, 0.257191>, <-0.802887, 0.265776, 0.252873>, <-0.785198, 0.289138, 0.252138>, 
      <-0.840977, 0.208925, 0.264549>, <-0.831492, 0.236617, 0.262825>, <-0.802077, 0.265779, 0.259770>, <-0.784731, 0.289138, 0.256132>, 
      <-0.839326, 0.208925, 0.269117>, <-0.829842, 0.236617, 0.267393>, <-0.801727, 0.265779, 0.262766>, <-0.784380, 0.289138, 0.259127>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.833724, 0.208925, 0.219378>, <-0.826080, 0.235678, 0.221012>, <-0.802722, 0.266174, 0.223758>, <-0.787886, 0.289138, 0.229174>, 
      <-0.836421, 0.208925, 0.229364>, <-0.828777, 0.235678, 0.230998>, <-0.802021, 0.266174, 0.229748>, <-0.787185, 0.289138, 0.235164>, 
      <-0.840050, 0.208925, 0.242757>, <-0.830445, 0.236611, 0.242085>, <-0.803939, 0.265776, 0.243887>, <-0.786250, 0.289138, 0.243152>, 
      <-0.841208, 0.208925, 0.253036>, <-0.831603, 0.236611, 0.252364>, <-0.803238, 0.265776, 0.249877>, <-0.785549, 0.289138, 0.249142>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.827482, 0.208925, 0.202217>, <-0.821187, 0.235203, 0.204997>, <-0.801661, 0.266598, 0.210767>, <-0.789054, 0.289138, 0.219189>, 
      <-0.829583, 0.208925, 0.207276>, <-0.823289, 0.235203, 0.210056>, <-0.801310, 0.266598, 0.213763>, <-0.788704, 0.289138, 0.222185>, 
      <-0.832296, 0.208925, 0.214089>, <-0.824652, 0.235678, 0.215723>, <-0.803073, 0.266174, 0.220762>, <-0.788237, 0.289138, 0.226179>, 
      <-0.833724, 0.208925, 0.219378>, <-0.826080, 0.235678, 0.221012>, <-0.802722, 0.266174, 0.223758>, <-0.787886, 0.289138, 0.229174>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.827482, 0.208925, 0.202217>, <-0.825272, 0.208925, 0.196895>, <-0.823316, 0.208925, 0.189002>, <-0.819366, 0.208925, 0.184806>, 
      <-0.821187, 0.235203, 0.204997>, <-0.818977, 0.235203, 0.199675>, <-0.818609, 0.234837, 0.192943>, <-0.814659, 0.234837, 0.188747>, 
      <-0.801661, 0.266598, 0.210767>, <-0.802011, 0.266598, 0.207773>, <-0.801391, 0.267149, 0.200617>, <-0.800100, 0.267149, 0.197892>, 
      <-0.789054, 0.289138, 0.219189>, <-0.789404, 0.289138, 0.216194>, <-0.791513, 0.289138, 0.211931>, <-0.790222, 0.289138, 0.209206>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.792824, 0.128711, 0.165398>, <-0.793355, 0.152337, 0.160858>, <-0.794864, 0.185421, 0.160657>, <-0.792824, 0.208925, 0.165398>, 
      <-0.801933, 0.128708, 0.169185>, <-0.802464, 0.152334, 0.164645>, <-0.803979, 0.185421, 0.164427>, <-0.801939, 0.208925, 0.169168>, 
      <-0.812605, 0.128711, 0.177623>, <-0.816500, 0.152228, 0.174332>, <-0.816859, 0.185509, 0.174062>, <-0.812605, 0.208925, 0.177623>, 
      <-0.819366, 0.128711, 0.184806>, <-0.823262, 0.152228, 0.181514>, <-0.823620, 0.185509, 0.181245>, <-0.819366, 0.208925, 0.184806>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.764791, 0.128729, 0.162118>, <-0.761875, 0.152104, 0.157224>, <-0.764164, 0.185395, 0.157059>, <-0.764401, 0.208925, 0.162073>, 
      <-0.773201, 0.128724, 0.163102>, <-0.770285, 0.152098, 0.158208>, <-0.772690, 0.185395, 0.158057>, <-0.772928, 0.208925, 0.163071>, 
      <-0.785005, 0.128714, 0.162148>, <-0.785536, 0.152340, 0.157608>, <-0.786931, 0.185421, 0.157376>, <-0.784891, 0.208925, 0.162117>, 
      <-0.792824, 0.128711, 0.165398>, <-0.793355, 0.152337, 0.160858>, <-0.794864, 0.185421, 0.160657>, <-0.792824, 0.208925, 0.165398>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.760637, 0.128711, 0.194234>, <-0.757496, 0.152340, 0.190937>, <-0.760127, 0.185090, 0.190961>, <-0.760637, 0.208925, 0.194234>, 
      <-0.761844, 0.128715, 0.184594>, <-0.758703, 0.152344, 0.181298>, <-0.761256, 0.185090, 0.181312>, <-0.761766, 0.208925, 0.184586>, 
      <-0.763545, 0.128724, 0.171753>, <-0.760628, 0.152098, 0.166859>, <-0.763034, 0.185395, 0.166708>, <-0.763272, 0.208925, 0.171721>, 
      <-0.764791, 0.128729, 0.162118>, <-0.761875, 0.152104, 0.157224>, <-0.764164, 0.185395, 0.157059>, <-0.764401, 0.208925, 0.162073>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.758755, 0.128711, 0.210315>, <-0.759320, 0.128711, 0.205491>, <-0.760034, 0.128709, 0.199054>, <-0.760637, 0.128711, 0.194234>, 
      <-0.759315, 0.124623, 0.210743>, <-0.759880, 0.124623, 0.205918>, <-0.760639, 0.124156, 0.199689>, <-0.761242, 0.124157, 0.194869>, 
      <-0.766449, 0.128711, 0.216187>, <-0.766916, 0.128711, 0.212203>, <-0.767636, 0.128711, 0.206051>, <-0.768102, 0.128711, 0.202068>, 
      <-0.769747, 0.128711, 0.218703>, <-0.770213, 0.128711, 0.214720>, <-0.770835, 0.128711, 0.209408>, <-0.771301, 0.128711, 0.205425>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.758755, 0.128711, 0.210315>, <-0.755505, 0.152425, 0.207835>, <-0.758136, 0.184987, 0.207937>, <-0.758755, 0.208925, 0.210315>, 
      <-0.759320, 0.128711, 0.205491>, <-0.756070, 0.152425, 0.203011>, <-0.758700, 0.184987, 0.203113>, <-0.759320, 0.208925, 0.205491>, 
      <-0.760034, 0.128709, 0.199054>, <-0.756892, 0.152339, 0.195757>, <-0.759562, 0.185090, 0.195785>, <-0.760072, 0.208925, 0.199058>, 
      <-0.760637, 0.128711, 0.194234>, <-0.757496, 0.152340, 0.190937>, <-0.760127, 0.185090, 0.190961>, <-0.760637, 0.208925, 0.194234>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.754992, 0.128711, 0.242476>, <-0.756121, 0.128711, 0.232828>, <-0.757626, 0.128711, 0.219963>, <-0.758755, 0.128711, 0.210315>, 
      <-0.755508, 0.125158, 0.242599>, <-0.756637, 0.125158, 0.232951>, <-0.758186, 0.124623, 0.220391>, <-0.759315, 0.124623, 0.210743>, 
      <-0.763145, 0.128711, 0.244425>, <-0.764077, 0.128711, 0.236458>, <-0.765517, 0.128711, 0.224154>, <-0.766449, 0.128711, 0.216187>, 
      <-0.766639, 0.128711, 0.245260>, <-0.767571, 0.128711, 0.237293>, <-0.768815, 0.128711, 0.226670>, <-0.769747, 0.128711, 0.218703>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.754992, 0.128711, 0.242476>, <-0.751536, 0.152511, 0.241650>, <-0.754156, 0.184882, 0.241915>, <-0.754992, 0.208925, 0.242476>, 
      <-0.756121, 0.128711, 0.232828>, <-0.752665, 0.152511, 0.232002>, <-0.755285, 0.184882, 0.232267>, <-0.756121, 0.208925, 0.232828>, 
      <-0.757626, 0.128711, 0.219963>, <-0.754376, 0.152425, 0.217484>, <-0.757007, 0.184987, 0.217585>, <-0.757626, 0.208925, 0.219963>, 
      <-0.758755, 0.128711, 0.210315>, <-0.755505, 0.152425, 0.207835>, <-0.758136, 0.184987, 0.207937>, <-0.758755, 0.208925, 0.210315>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.753110, 0.128711, 0.258558>, <-0.753675, 0.128711, 0.253733>, <-0.754428, 0.128711, 0.247301>, <-0.754992, 0.128711, 0.242476>, 
      <-0.753641, 0.125158, 0.258557>, <-0.754205, 0.125158, 0.253733>, <-0.754943, 0.125158, 0.247424>, <-0.755508, 0.125158, 0.242599>, 
      <-0.761493, 0.128711, 0.258544>, <-0.761959, 0.128711, 0.254561>, <-0.762679, 0.128711, 0.248408>, <-0.763145, 0.128711, 0.244425>, 
      <-0.765086, 0.128711, 0.258538>, <-0.765552, 0.128711, 0.254555>, <-0.766173, 0.128711, 0.249243>, <-0.766639, 0.128711, 0.245260>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.753110, 0.128711, 0.258558>, <-0.749557, 0.152511, 0.258564>, <-0.752167, 0.184882, 0.258911>, <-0.753110, 0.208925, 0.258558>, 
      <-0.753675, 0.128711, 0.253733>, <-0.750121, 0.152511, 0.253739>, <-0.752732, 0.184882, 0.254086>, <-0.753675, 0.208925, 0.253733>, 
      <-0.754428, 0.128711, 0.247301>, <-0.750972, 0.152511, 0.246475>, <-0.753592, 0.184882, 0.246740>, <-0.754428, 0.208925, 0.247301>, 
      <-0.754992, 0.128711, 0.242476>, <-0.751536, 0.152511, 0.241650>, <-0.754156, 0.184882, 0.241915>, <-0.754992, 0.208925, 0.242476>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.749346, 0.128711, 0.290719>, <-0.750475, 0.128711, 0.281071>, <-0.751981, 0.128711, 0.268206>, <-0.753110, 0.128711, 0.258558>, 
      <-0.749990, 0.124623, 0.290432>, <-0.751119, 0.124623, 0.280784>, <-0.752511, 0.125158, 0.268205>, <-0.753641, 0.125158, 0.258557>, 
      <-0.758188, 0.128711, 0.286782>, <-0.759121, 0.128711, 0.278815>, <-0.760561, 0.128711, 0.266511>, <-0.761493, 0.128711, 0.258544>, 
      <-0.761978, 0.128711, 0.285094>, <-0.762910, 0.128711, 0.277127>, <-0.764154, 0.128711, 0.266505>, <-0.765086, 0.128711, 0.258538>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.749346, 0.128711, 0.290719>, <-0.745612, 0.152425, 0.292382>, <-0.748194, 0.184987, 0.292890>, <-0.749346, 0.208925, 0.290719>, 
      <-0.750475, 0.128711, 0.281071>, <-0.746741, 0.152425, 0.282734>, <-0.749324, 0.184987, 0.283241>, <-0.750475, 0.208925, 0.281071>, 
      <-0.751981, 0.128711, 0.268206>, <-0.748428, 0.152511, 0.268212>, <-0.751038, 0.184882, 0.268559>, <-0.751981, 0.208925, 0.268206>, 
      <-0.753110, 0.128711, 0.258558>, <-0.749557, 0.152511, 0.258564>, <-0.752167, 0.184882, 0.258911>, <-0.753110, 0.208925, 0.258558>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.747464, 0.128711, 0.306799>, <-0.748028, 0.128711, 0.301975>, <-0.748781, 0.128711, 0.295543>, <-0.749346, 0.128711, 0.290719>, 
      <-0.748200, 0.124157, 0.306321>, <-0.748764, 0.124157, 0.301497>, <-0.749425, 0.124623, 0.295256>, <-0.749990, 0.124623, 0.290432>, 
      <-0.756536, 0.128711, 0.300901>, <-0.757002, 0.128711, 0.296917>, <-0.757722, 0.128711, 0.290765>, <-0.758188, 0.128711, 0.286782>, 
      <-0.760424, 0.128711, 0.298373>, <-0.760890, 0.128711, 0.294389>, <-0.761512, 0.128711, 0.289078>, <-0.761978, 0.128711, 0.285094>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.747464, 0.128711, 0.306799>, <-0.743646, 0.152340, 0.309281>, <-0.746212, 0.185090, 0.309866>, <-0.747464, 0.208925, 0.306799>, 
      <-0.748028, 0.128711, 0.301975>, <-0.744211, 0.152340, 0.304457>, <-0.746776, 0.185090, 0.305042>, <-0.748028, 0.208925, 0.301975>, 
      <-0.748781, 0.128711, 0.295543>, <-0.745047, 0.152425, 0.297206>, <-0.747630, 0.184987, 0.297714>, <-0.748781, 0.208925, 0.295543>, 
      <-0.749346, 0.128711, 0.290719>, <-0.745612, 0.152425, 0.292382>, <-0.748194, 0.184987, 0.292890>, <-0.749346, 0.208925, 0.290719>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.743701, 0.128711, 0.338961>, <-0.739732, 0.152091, 0.343051>, <-0.742255, 0.185392, 0.343778>, <-0.743701, 0.208925, 0.338961>, 
      <-0.744830, 0.128711, 0.329312>, <-0.740861, 0.152091, 0.333402>, <-0.743384, 0.185392, 0.334129>, <-0.744830, 0.208925, 0.329312>, 
      <-0.746335, 0.128711, 0.316448>, <-0.742517, 0.152340, 0.318930>, <-0.745082, 0.185090, 0.319515>, <-0.746335, 0.208925, 0.316448>, 
      <-0.747464, 0.128711, 0.306799>, <-0.743646, 0.152340, 0.309281>, <-0.746212, 0.185090, 0.309866>, <-0.747464, 0.208925, 0.306799>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.772125, 0.128711, 0.342287>, <-0.771594, 0.152337, 0.346827>, <-0.773015, 0.185421, 0.347371>, <-0.772125, 0.208925, 0.342287>, 
      <-0.763648, 0.128711, 0.343648>, <-0.763117, 0.152337, 0.348188>, <-0.764539, 0.185421, 0.348732>, <-0.763648, 0.208925, 0.343648>, 
      <-0.752228, 0.128711, 0.339959>, <-0.748260, 0.152091, 0.344049>, <-0.750782, 0.185392, 0.344776>, <-0.752228, 0.208925, 0.339959>, 
      <-0.743701, 0.128711, 0.338961>, <-0.739732, 0.152091, 0.343051>, <-0.742255, 0.185392, 0.343778>, <-0.743701, 0.208925, 0.338961>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.802430, 0.128711, 0.329533>, <-0.805460, 0.152228, 0.333636>, <-0.805747, 0.185509, 0.333980>, <-0.802430, 0.208925, 0.329533>, 
      <-0.794168, 0.128711, 0.334921>, <-0.797198, 0.152228, 0.339023>, <-0.797484, 0.185509, 0.339368>, <-0.794168, 0.208925, 0.334921>, 
      <-0.781864, 0.128711, 0.340724>, <-0.781333, 0.152337, 0.345264>, <-0.782755, 0.185421, 0.345808>, <-0.781864, 0.208925, 0.340724>, 
      <-0.772125, 0.128711, 0.342287>, <-0.771594, 0.152337, 0.346827>, <-0.773015, 0.185421, 0.347371>, <-0.772125, 0.208925, 0.342287>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.814309, 0.128711, 0.314781>, <-0.817450, 0.152340, 0.318077>, <-0.819159, 0.185652, 0.318510>, <-0.814309, 0.208925, 0.314781>, 
      <-0.810942, 0.128711, 0.319358>, <-0.814084, 0.152340, 0.322655>, <-0.815793, 0.185652, 0.323087>, <-0.810942, 0.208925, 0.319358>, 
      <-0.807190, 0.128711, 0.326429>, <-0.810220, 0.152228, 0.330532>, <-0.810506, 0.185509, 0.330877>, <-0.807190, 0.208925, 0.326429>, 
      <-0.802430, 0.128711, 0.329533>, <-0.805460, 0.152228, 0.333636>, <-0.805747, 0.185509, 0.333980>, <-0.802430, 0.208925, 0.329533>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.824314, 0.128711, 0.299782>, <-0.827564, 0.152425, 0.302262>, <-0.830398, 0.185834, 0.302760>, <-0.824314, 0.208925, 0.299782>, 
      <-0.821715, 0.128711, 0.304526>, <-0.824965, 0.152425, 0.307005>, <-0.827799, 0.185834, 0.307503>, <-0.821715, 0.208925, 0.304526>, 
      <-0.817514, 0.128711, 0.310424>, <-0.820655, 0.152340, 0.313720>, <-0.822364, 0.185652, 0.314153>, <-0.817514, 0.208925, 0.310424>, 
      <-0.814309, 0.128711, 0.314781>, <-0.817450, 0.152340, 0.318077>, <-0.819159, 0.185652, 0.318510>, <-0.814309, 0.208925, 0.314781>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.824314, 0.128711, 0.299782>, <-0.821715, 0.128711, 0.304526>, <-0.817514, 0.128711, 0.310424>, <-0.814309, 0.128711, 0.314781>, 
      <-0.823754, 0.124623, 0.299355>, <-0.821155, 0.124623, 0.304098>, <-0.816909, 0.124158, 0.309789>, <-0.813704, 0.124158, 0.314146>, 
      <-0.816620, 0.128711, 0.293910>, <-0.814088, 0.128711, 0.297835>, <-0.809928, 0.128711, 0.303440>, <-0.806844, 0.128711, 0.306948>, 
      <-0.813322, 0.128711, 0.291394>, <-0.810790, 0.128711, 0.295319>, <-0.806729, 0.128711, 0.300083>, <-0.803645, 0.128711, 0.303591>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.839326, 0.128711, 0.269117>, <-0.842782, 0.152511, 0.269943>, <-0.847110, 0.186198, 0.270532>, <-0.839326, 0.208925, 0.269117>, 
      <-0.835845, 0.128711, 0.278750>, <-0.839301, 0.152511, 0.279576>, <-0.843629, 0.186198, 0.280165>, <-0.835845, 0.208925, 0.278750>, 
      <-0.829235, 0.128711, 0.290799>, <-0.832485, 0.152425, 0.293279>, <-0.835319, 0.185834, 0.293777>, <-0.829235, 0.208925, 0.290799>, 
      <-0.824314, 0.128711, 0.299782>, <-0.827564, 0.152425, 0.302262>, <-0.830398, 0.185834, 0.302760>, <-0.824314, 0.208925, 0.299782>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.839326, 0.128711, 0.269117>, <-0.835845, 0.128711, 0.278750>, <-0.829235, 0.128711, 0.290799>, <-0.824314, 0.128711, 0.299782>, 
      <-0.838810, 0.125158, 0.268994>, <-0.835329, 0.125158, 0.278627>, <-0.828675, 0.124623, 0.290372>, <-0.823754, 0.124623, 0.299355>, 
      <-0.831172, 0.128711, 0.267169>, <-0.827852, 0.128711, 0.275172>, <-0.821316, 0.128711, 0.286629>, <-0.816620, 0.128711, 0.293910>, 
      <-0.827678, 0.128711, 0.266334>, <-0.824357, 0.128711, 0.274337>, <-0.818019, 0.128711, 0.284113>, <-0.813322, 0.128711, 0.291394>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.841208, 0.128711, 0.253036>, <-0.844762, 0.152511, 0.253030>, <-0.849094, 0.186196, 0.253588>, <-0.841208, 0.208925, 0.253036>, 
      <-0.841752, 0.128711, 0.257863>, <-0.845305, 0.152511, 0.257857>, <-0.849637, 0.186196, 0.258414>, <-0.841752, 0.208925, 0.257863>, 
      <-0.840977, 0.128711, 0.264549>, <-0.844433, 0.152511, 0.265375>, <-0.848761, 0.186198, 0.265964>, <-0.840977, 0.208925, 0.264549>, 
      <-0.839326, 0.128711, 0.269117>, <-0.842782, 0.152511, 0.269943>, <-0.847110, 0.186198, 0.270532>, <-0.839326, 0.208925, 0.269117>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.841208, 0.128711, 0.253036>, <-0.841752, 0.128711, 0.257863>, <-0.840977, 0.128711, 0.264549>, <-0.839326, 0.128711, 0.269117>, 
      <-0.840677, 0.125157, 0.253037>, <-0.841221, 0.125157, 0.257864>, <-0.840461, 0.125158, 0.264426>, <-0.838810, 0.125158, 0.268994>, 
      <-0.832824, 0.128711, 0.253050>, <-0.833455, 0.128711, 0.257011>, <-0.832710, 0.128711, 0.263465>, <-0.831172, 0.128711, 0.267169>, 
      <-0.829231, 0.128711, 0.253056>, <-0.829862, 0.128711, 0.257017>, <-0.829215, 0.128711, 0.262630>, <-0.827678, 0.128711, 0.266334>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.833724, 0.128711, 0.219378>, <-0.837459, 0.152425, 0.217715>, <-0.840324, 0.185827, 0.217968>, <-0.833724, 0.208925, 0.219378>, 
      <-0.836421, 0.128711, 0.229364>, <-0.840156, 0.152425, 0.227701>, <-0.843021, 0.185827, 0.227954>, <-0.836421, 0.208925, 0.229364>, 
      <-0.840050, 0.128711, 0.242757>, <-0.843604, 0.152511, 0.242751>, <-0.847936, 0.186196, 0.243309>, <-0.840050, 0.208925, 0.242757>, 
      <-0.841208, 0.128711, 0.253036>, <-0.844762, 0.152511, 0.253030>, <-0.849094, 0.186196, 0.253588>, <-0.841208, 0.208925, 0.253036>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.833724, 0.128711, 0.219378>, <-0.836421, 0.128711, 0.229364>, <-0.840050, 0.128711, 0.242757>, <-0.841208, 0.128711, 0.253036>, 
      <-0.833080, 0.124623, 0.219665>, <-0.835777, 0.124623, 0.229651>, <-0.839520, 0.125157, 0.242758>, <-0.840677, 0.125157, 0.253037>, 
      <-0.824882, 0.128711, 0.223316>, <-0.827753, 0.128711, 0.231595>, <-0.831445, 0.128711, 0.244396>, <-0.832824, 0.128711, 0.253050>, 
      <-0.821092, 0.128711, 0.225003>, <-0.823963, 0.128711, 0.233282>, <-0.827852, 0.128711, 0.244402>, <-0.829231, 0.128711, 0.253056>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.827482, 0.128711, 0.202217>, <-0.831300, 0.152340, 0.199735>, <-0.833058, 0.185646, 0.199754>, <-0.827482, 0.208925, 0.202217>, 
      <-0.829583, 0.128711, 0.207276>, <-0.833401, 0.152340, 0.204794>, <-0.835159, 0.185646, 0.204814>, <-0.829583, 0.208925, 0.207276>, 
      <-0.832296, 0.128711, 0.214089>, <-0.836030, 0.152425, 0.212426>, <-0.838895, 0.185827, 0.212679>, <-0.832296, 0.208925, 0.214089>, 
      <-0.833724, 0.128711, 0.219378>, <-0.837459, 0.152425, 0.217715>, <-0.840324, 0.185827, 0.217968>, <-0.833724, 0.208925, 0.219378>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.827482, 0.128711, 0.202217>, <-0.829583, 0.128711, 0.207276>, <-0.832296, 0.128711, 0.214089>, <-0.833724, 0.128711, 0.219378>, 
      <-0.826746, 0.124157, 0.202695>, <-0.828847, 0.124157, 0.207755>, <-0.831652, 0.124623, 0.214376>, <-0.833080, 0.124623, 0.219665>, 
      <-0.818410, 0.128711, 0.208115>, <-0.820590, 0.128711, 0.212321>, <-0.823329, 0.128711, 0.218840>, <-0.824882, 0.128711, 0.223316>, 
      <-0.814522, 0.128711, 0.210643>, <-0.816702, 0.128711, 0.214849>, <-0.819540, 0.128711, 0.220527>, <-0.821092, 0.128711, 0.225003>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.827482, 0.128711, 0.202217>, <-0.825272, 0.128711, 0.196895>, <-0.823316, 0.128711, 0.189002>, <-0.819366, 0.128711, 0.184806>, 
      <-0.831300, 0.152340, 0.199735>, <-0.829089, 0.152340, 0.194413>, <-0.827212, 0.152228, 0.185710>, <-0.823262, 0.152228, 0.181514>, 
      <-0.833058, 0.185646, 0.199754>, <-0.830848, 0.185646, 0.194432>, <-0.827570, 0.185509, 0.185441>, <-0.823620, 0.185509, 0.181245>, 
      <-0.827482, 0.208925, 0.202217>, <-0.825272, 0.208925, 0.196895>, <-0.823316, 0.208925, 0.189002>, <-0.819366, 0.208925, 0.184806>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.806079, 0.128711, 0.196034>, <-0.810065, 0.128711, 0.192666>, <-0.818521, 0.123611, 0.185520>, <-0.819366, 0.128711, 0.184806>, 
      <-0.809211, 0.128711, 0.200010>, <-0.813198, 0.128711, 0.196642>, <-0.822471, 0.123611, 0.189716>, <-0.823316, 0.128711, 0.189002>, 
      <-0.812193, 0.128711, 0.206149>, <-0.816081, 0.128711, 0.203621>, <-0.824536, 0.124157, 0.197373>, <-0.825272, 0.128711, 0.196895>, 
      <-0.814522, 0.128711, 0.210643>, <-0.818410, 0.128711, 0.208115>, <-0.826746, 0.124157, 0.202695>, <-0.827482, 0.128711, 0.202217>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.791021, 0.128711, 0.180812>, <-0.791562, 0.128711, 0.176188>, <-0.792721, 0.124140, 0.166276>, <-0.792824, 0.128711, 0.165398>, 
      <-0.796668, 0.128711, 0.183873>, <-0.797209, 0.128711, 0.179249>, <-0.801830, 0.124137, 0.170063>, <-0.801933, 0.128708, 0.169185>, 
      <-0.802104, 0.128711, 0.190988>, <-0.806090, 0.128711, 0.187620>, <-0.811760, 0.123611, 0.178337>, <-0.812605, 0.128711, 0.177623>, 
      <-0.806079, 0.128711, 0.196034>, <-0.810065, 0.128711, 0.192666>, <-0.818521, 0.123611, 0.185520>, <-0.819366, 0.128711, 0.184806>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.774409, 0.128711, 0.178868>, <-0.771524, 0.128716, 0.173843>, <-0.765493, 0.123099, 0.163297>, <-0.764791, 0.128729, 0.162118>, 
      <-0.779393, 0.128711, 0.179451>, <-0.776507, 0.128716, 0.174426>, <-0.773903, 0.123094, 0.164281>, <-0.773201, 0.128724, 0.163102>, 
      <-0.786610, 0.128711, 0.178421>, <-0.787151, 0.128711, 0.173797>, <-0.784903, 0.124143, 0.163026>, <-0.785005, 0.128714, 0.162148>, 
      <-0.791021, 0.128711, 0.180812>, <-0.791562, 0.128711, 0.176188>, <-0.792721, 0.124140, 0.166276>, <-0.792824, 0.128711, 0.165398>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.774409, 0.128711, 0.178868>, <-0.773477, 0.128711, 0.186835>, <-0.772233, 0.128711, 0.197458>, <-0.771301, 0.128711, 0.205425>, 
      <-0.771524, 0.128716, 0.173843>, <-0.770591, 0.128716, 0.181810>, <-0.769034, 0.128711, 0.194101>, <-0.768102, 0.128711, 0.202068>, 
      <-0.765493, 0.123099, 0.163297>, <-0.764247, 0.123094, 0.172931>, <-0.762450, 0.124161, 0.185230>, <-0.761242, 0.124157, 0.194869>, 
      <-0.764791, 0.128729, 0.162118>, <-0.763545, 0.128724, 0.171753>, <-0.761844, 0.128715, 0.184594>, <-0.760637, 0.128711, 0.194234>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.757317, 0.128711, 0.324929>, <-0.753232, 0.128711, 0.329139>, <-0.744668, 0.123012, 0.337964>, <-0.743701, 0.128711, 0.338961>, 
      <-0.758249, 0.128711, 0.316962>, <-0.754164, 0.128711, 0.321172>, <-0.745797, 0.123012, 0.328315>, <-0.744830, 0.128711, 0.329312>, 
      <-0.759492, 0.128711, 0.306340>, <-0.755604, 0.128711, 0.308868>, <-0.747071, 0.124157, 0.315969>, <-0.746335, 0.128711, 0.316448>, 
      <-0.760424, 0.128711, 0.298373>, <-0.756536, 0.128711, 0.300901>, <-0.748200, 0.124157, 0.306321>, <-0.747464, 0.128711, 0.306799>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.773928, 0.128711, 0.326873>, <-0.773387, 0.128711, 0.331497>, <-0.772228, 0.124140, 0.341409>, <-0.772125, 0.128711, 0.342287>, 
      <-0.769084, 0.128711, 0.328181>, <-0.768543, 0.128711, 0.332805>, <-0.763751, 0.124140, 0.342770>, <-0.763648, 0.128711, 0.343648>, 
      <-0.762300, 0.128711, 0.325512>, <-0.758216, 0.128711, 0.329722>, <-0.753196, 0.123012, 0.338962>, <-0.752228, 0.128711, 0.339959>, 
      <-0.757317, 0.128711, 0.324929>, <-0.753232, 0.128711, 0.329139>, <-0.744668, 0.123012, 0.337964>, <-0.743701, 0.128711, 0.338961>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.792094, 0.128711, 0.315539>, <-0.795195, 0.128711, 0.319737>, <-0.801773, 0.123610, 0.328643>, <-0.802430, 0.128711, 0.329533>, 
      <-0.787037, 0.128711, 0.319501>, <-0.790138, 0.128711, 0.323699>, <-0.793510, 0.123610, 0.334031>, <-0.794168, 0.128711, 0.334921>, 
      <-0.780130, 0.128711, 0.325199>, <-0.779589, 0.128711, 0.329823>, <-0.781967, 0.124140, 0.339845>, <-0.781864, 0.128711, 0.340724>, 
      <-0.773928, 0.128711, 0.326873>, <-0.773387, 0.128711, 0.331497>, <-0.772228, 0.124140, 0.341409>, <-0.772125, 0.128711, 0.342287>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.792094, 0.128711, 0.315539>, <-0.796019, 0.128711, 0.312464>, <-0.800353, 0.128711, 0.307335>, <-0.803645, 0.128711, 0.303591>, 
      <-0.795195, 0.128711, 0.319737>, <-0.799119, 0.128711, 0.316663>, <-0.803552, 0.128711, 0.310692>, <-0.806844, 0.128711, 0.306948>, 
      <-0.801773, 0.123610, 0.328643>, <-0.806532, 0.123610, 0.325540>, <-0.810337, 0.124158, 0.318723>, <-0.813704, 0.124158, 0.314146>, 
      <-0.802430, 0.128711, 0.329533>, <-0.807190, 0.128711, 0.326429>, <-0.810942, 0.128711, 0.319358>, <-0.814309, 0.128711, 0.314781>
    }
  }
  texture {
    Shiny_White
  }
}
#declare FaceSock = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.795019, 0.161717, -0.300488>, <-0.794722, 0.154109, -0.287379>, <-0.799095, 0.154995, -0.265552>, <-0.799872, 0.156361, -0.250474>, 
      <-0.810420, 0.193685, -0.269348>, <-0.810123, 0.186077, -0.256238>, <-0.804780, 0.167434, -0.263079>, <-0.805557, 0.168800, -0.248001>, 
      <-0.813821, 0.220661, -0.188378>, <-0.813821, 0.210068, -0.204967>, <-0.805460, 0.187904, -0.196242>, <-0.805460, 0.180118, -0.214319>, 
      <-0.799872, 0.200477, -0.148043>, <-0.799872, 0.189884, -0.164632>, <-0.799872, 0.178041, -0.188200>, <-0.799872, 0.170255, -0.206278>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.795019, 0.161717, -0.300488>, <-0.794722, 0.154109, -0.287379>, <-0.799095, 0.154995, -0.265552>, <-0.799872, 0.156361, -0.250474>, 
      <-0.810420, 0.193685, -0.269348>, <-0.810123, 0.186077, -0.256238>, <-0.799807, 0.156247, -0.251729>, <-0.800584, 0.157614, -0.236650>, 
      <-0.813821, 0.220661, -0.188378>, <-0.813821, 0.210068, -0.204967>, <-0.799872, 0.172543, -0.200965>, <-0.799872, 0.164757, -0.219043>, 
      <-0.799872, 0.200477, -0.148043>, <-0.799872, 0.189884, -0.164632>, <-0.799872, 0.178041, -0.188200>, <-0.799872, 0.170255, -0.206278>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.802609, 0.226397, -0.371154>, <-0.801595, 0.203781, -0.353304>, <-0.795584, 0.176185, -0.325418>, <-0.795019, 0.161717, -0.300488>, 
      <-0.824450, 0.283959, -0.284044>, <-0.823436, 0.261343, -0.266194>, <-0.810986, 0.208153, -0.294277>, <-0.810420, 0.193685, -0.269348>, 
      <-0.813647, 0.293454, -0.126729>, <-0.813647, 0.249449, -0.141304>, <-0.813821, 0.245609, -0.149309>, <-0.813821, 0.220661, -0.188378>, 
      <-0.799872, 0.288525, -0.021067>, <-0.799872, 0.244521, -0.035641>, <-0.799872, 0.225425, -0.108974>, <-0.799872, 0.200477, -0.148043>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.799872, 0.269971, -0.385931>, <-0.801431, 0.260309, -0.376163>, <-0.803095, 0.237245, -0.379716>, <-0.802609, 0.226397, -0.371154>, 
      <-0.816774, 0.317192, -0.306794>, <-0.818333, 0.307530, -0.297025>, <-0.824936, 0.294806, -0.292606>, <-0.824450, 0.283959, -0.284044>, 
      <-0.806006, 0.355056, -0.182813>, <-0.808005, 0.335727, -0.156350>, <-0.813647, 0.324620, -0.116407>, <-0.813647, 0.293454, -0.126729>, 
      <-0.799872, 0.372701, -0.091002>, <-0.801870, 0.353373, -0.064538>, <-0.799872, 0.319691, -0.010745>, <-0.799872, 0.288525, -0.021067>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.694199, 0.669373, 0.009620>, <-0.683618, 0.708499, -0.177313>, <-0.694199, 0.634664, -0.435341>, <-0.694199, 0.619788, -0.626039>, 
      <-0.733728, 0.615138, -0.076564>, <-0.723147, 0.654265, -0.263497>, <-0.718341, 0.612307, -0.443325>, <-0.718341, 0.597432, -0.634022>, 
      <-0.764032, 0.541535, -0.200449>, <-0.755903, 0.569693, -0.301422>, <-0.762612, 0.548803, -0.536232>, <-0.755496, 0.560229, -0.640508>, 
      <-0.779214, 0.488326, -0.294629>, <-0.771085, 0.516484, -0.395602>, <-0.762612, 0.514988, -0.537938>, <-0.755496, 0.526414, -0.642214>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.750020, 0.413367, 0.360173>, <-0.742324, 0.532383, 0.305265>, <-0.701462, 0.642516, 0.137935>, <-0.694199, 0.669373, 0.009620>, 
      <-0.772934, 0.391768, 0.227127>, <-0.765238, 0.510783, 0.172219>, <-0.740991, 0.588281, 0.051751>, <-0.733728, 0.615138, -0.076564>, 
      <-0.790920, 0.398450, 0.042974>, <-0.786628, 0.439968, -0.013870>, <-0.769485, 0.522649, -0.132722>, <-0.764032, 0.541535, -0.200449>, 
      <-0.799872, 0.372701, -0.091002>, <-0.795579, 0.414218, -0.147846>, <-0.784667, 0.469439, -0.226902>, <-0.779214, 0.488326, -0.294629>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.724647, 0.198503, 0.226856>, <-0.732451, 0.254078, 0.278461>, <-0.754489, 0.344258, 0.392056>, <-0.750020, 0.413367, 0.360173>, 
      <-0.759399, 0.224169, 0.156826>, <-0.767203, 0.279743, 0.208431>, <-0.777403, 0.322659, 0.259010>, <-0.772934, 0.391768, 0.227127>, 
      <-0.789246, 0.284723, 0.060439>, <-0.789246, 0.315889, 0.070761>, <-0.792919, 0.379122, 0.069438>, <-0.790920, 0.398450, 0.042974>, 
      <-0.799872, 0.288525, -0.021067>, <-0.799872, 0.319691, -0.010745>, <-0.801870, 0.353373, -0.064538>, <-0.799872, 0.372701, -0.091002>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.694199, 0.015833, -0.008964>, <-0.701068, 0.067414, 0.064411>, <-0.715440, 0.132932, 0.165969>, <-0.724647, 0.198503, 0.226856>, 
      <-0.732531, 0.057399, -0.060122>, <-0.739400, 0.108980, 0.013252>, <-0.750192, 0.158598, 0.095939>, <-0.759399, 0.224169, 0.156826>, 
      <-0.777342, 0.167877, -0.082897>, <-0.777342, 0.192825, -0.043829>, <-0.789246, 0.240719, 0.045865>, <-0.789246, 0.284723, 0.060439>, 
      <-0.799872, 0.200477, -0.148043>, <-0.799872, 0.225425, -0.108974>, <-0.799872, 0.244521, -0.035641>, <-0.799872, 0.288525, -0.021067>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.694199, -0.030152, -0.098410>, <-0.694199, -0.021068, -0.069638>, <-0.691895, -0.001468, -0.033576>, <-0.694199, 0.015833, -0.008964>, 
      <-0.737310, 0.014599, -0.140903>, <-0.737310, 0.023683, -0.112131>, <-0.730227, 0.040098, -0.084734>, <-0.732531, 0.057399, -0.060122>, 
      <-0.769605, 0.116834, -0.162724>, <-0.769605, 0.124620, -0.144646>, <-0.777342, 0.157284, -0.099487>, <-0.777342, 0.167877, -0.082897>, 
      <-0.799872, 0.170255, -0.206278>, <-0.799872, 0.178041, -0.188200>, <-0.799872, 0.189884, -0.164632>, <-0.799872, 0.200477, -0.148043>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.694199, -0.060983, -0.252256>, <-0.694199, -0.062999, -0.205228>, <-0.694199, -0.044325, -0.143297>, <-0.694199, -0.030152, -0.098410>, 
      <-0.740631, -0.006692, -0.264639>, <-0.740631, -0.008708, -0.217610>, <-0.737310, 0.000426, -0.185791>, <-0.737310, 0.014599, -0.140903>, 
      <-0.770217, 0.091470, -0.263377>, <-0.775902, 0.103909, -0.260903>, <-0.775193, 0.126697, -0.170765>, <-0.769605, 0.116834, -0.162724>, 
      <-0.799872, 0.156361, -0.250474>, <-0.805557, 0.168800, -0.248001>, <-0.805460, 0.180118, -0.214319>, <-0.799872, 0.170255, -0.206278>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.694199, -0.060983, -0.252256>, <-0.694199, -0.062999, -0.205228>, <-0.694199, -0.044325, -0.143297>, <-0.694199, -0.030152, -0.098410>, 
      <-0.740631, -0.006692, -0.264639>, <-0.740631, -0.008708, -0.217610>, <-0.737310, 0.000426, -0.185791>, <-0.737310, 0.014599, -0.140903>, 
      <-0.770217, 0.091470, -0.263377>, <-0.770930, 0.092722, -0.249553>, <-0.769605, 0.111336, -0.175489>, <-0.769605, 0.116834, -0.162724>, 
      <-0.799872, 0.156361, -0.250474>, <-0.800584, 0.157614, -0.236650>, <-0.799872, 0.164757, -0.219043>, <-0.799872, 0.170255, -0.206278>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.694199, -0.018867, -0.361708>, <-0.694671, -0.029441, -0.328155>, <-0.694199, -0.059477, -0.287406>, <-0.694199, -0.060983, -0.252256>, 
      <-0.736499, 0.029734, -0.355733>, <-0.736971, 0.019161, -0.322180>, <-0.740631, -0.005186, -0.299789>, <-0.740631, -0.006692, -0.264639>, 
      <-0.773910, 0.117901, -0.343169>, <-0.773613, 0.110293, -0.330060>, <-0.769441, 0.090103, -0.278455>, <-0.770217, 0.091470, -0.263377>, 
      <-0.795019, 0.161717, -0.300488>, <-0.794722, 0.154109, -0.287379>, <-0.799095, 0.154995, -0.265552>, <-0.799872, 0.156361, -0.250474>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.691363, 0.002545, -0.453849>, <-0.691363, -0.008670, -0.427766>, <-0.693818, -0.010334, -0.388784>, <-0.694199, -0.018867, -0.361708>, 
      <-0.738079, 0.063031, -0.433896>, <-0.738079, 0.051816, -0.407813>, <-0.736119, 0.038267, -0.382809>, <-0.736499, 0.029734, -0.355733>, 
      <-0.786436, 0.183773, -0.435658>, <-0.785422, 0.161157, -0.417808>, <-0.774475, 0.132369, -0.368099>, <-0.773910, 0.117901, -0.343169>, 
      <-0.802609, 0.226397, -0.371154>, <-0.801595, 0.203781, -0.353304>, <-0.795584, 0.176185, -0.325418>, <-0.795019, 0.161717, -0.300488>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.694199, 0.077474, -0.585767>, <-0.693745, 0.044000, -0.554920>, <-0.691363, 0.020527, -0.495669>, <-0.691363, 0.002545, -0.453849>, 
      <-0.740309, 0.133988, -0.534638>, <-0.739855, 0.100514, -0.503791>, <-0.738079, 0.081013, -0.475716>, <-0.738079, 0.063031, -0.433896>, 
      <-0.783803, 0.225078, -0.461167>, <-0.785362, 0.215416, -0.451398>, <-0.786923, 0.194621, -0.444220>, <-0.786436, 0.183773, -0.435658>, 
      <-0.799872, 0.269971, -0.385931>, <-0.801431, 0.260309, -0.376163>, <-0.803095, 0.237245, -0.379716>, <-0.802609, 0.226397, -0.371154>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.779214, 0.371412, -0.517767>, <-0.793314, 0.417285, -0.459387>, <-0.789718, 0.451512, -0.359789>, <-0.779214, 0.488326, -0.294629>, 
      <-0.766783, 0.330968, -0.569238>, <-0.780883, 0.376841, -0.510858>, <-0.781589, 0.479670, -0.460762>, <-0.771085, 0.516484, -0.395602>, 
      <-0.729692, 0.258123, -0.614560>, <-0.742605, 0.352694, -0.626451>, <-0.762612, 0.418924, -0.542785>, <-0.762612, 0.514988, -0.537938>, 
      <-0.694199, 0.211739, -0.646627>, <-0.707111, 0.306310, -0.658518>, <-0.755496, 0.430350, -0.647061>, <-0.755496, 0.526414, -0.642214>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.779214, 0.371412, -0.517767>, <-0.785411, 0.340980, -0.478216>, <-0.794203, 0.305109, -0.421456>, <-0.799872, 0.269971, -0.385931>, 
      <-0.793314, 0.417285, -0.459387>, <-0.799512, 0.386852, -0.419836>, <-0.811106, 0.352330, -0.342318>, <-0.816774, 0.317192, -0.306794>, 
      <-0.789718, 0.451512, -0.359789>, <-0.795170, 0.432626, -0.292062>, <-0.801714, 0.396573, -0.239658>, <-0.806006, 0.355056, -0.182813>, 
      <-0.779214, 0.488326, -0.294629>, <-0.784667, 0.469439, -0.226902>, <-0.795579, 0.414218, -0.147846>, <-0.799872, 0.372701, -0.091002>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.779214, 0.371412, -0.517767>, <-0.766783, 0.330968, -0.569238>, <-0.729692, 0.258123, -0.614560>, <-0.694199, 0.211739, -0.646627>, 
      <-0.785411, 0.340980, -0.478216>, <-0.772980, 0.300536, -0.529687>, <-0.723755, 0.214641, -0.609093>, <-0.688262, 0.168257, -0.641160>, 
      <-0.794203, 0.305109, -0.421456>, <-0.778134, 0.260215, -0.496692>, <-0.740749, 0.166508, -0.564606>, <-0.694640, 0.109994, -0.615735>, 
      <-0.799872, 0.269971, -0.385931>, <-0.783803, 0.225078, -0.461167>, <-0.740309, 0.133988, -0.534638>, <-0.694199, 0.077474, -0.585767>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.561841, 0.786566, 0.179302>, <-0.608590, 0.752725, 0.133768>, <-0.667596, 0.705872, 0.067621>, <-0.694199, 0.669373, 0.009620>, 
      <-0.533586, 0.835609, -0.042112>, <-0.580335, 0.801768, -0.087646>, <-0.657016, 0.744999, -0.119312>, <-0.683618, 0.708499, -0.177313>, 
      <-0.561841, 0.729991, -0.350933>, <-0.603721, 0.706140, -0.362116>, <-0.658921, 0.667332, -0.423676>, <-0.694199, 0.634664, -0.435341>, 
      <-0.561841, 0.705745, -0.578177>, <-0.603721, 0.681894, -0.589360>, <-0.658921, 0.652456, -0.614374>, <-0.694199, 0.619788, -0.626039>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.698856, 0.467920, 0.495521>, <-0.691511, 0.601819, 0.452574>, <-0.579250, 0.756348, 0.315724>, <-0.561841, 0.786566, 0.179302>, 
      <-0.721835, 0.453591, 0.457854>, <-0.714490, 0.587490, 0.414907>, <-0.625999, 0.722507, 0.270190>, <-0.608590, 0.752725, 0.133768>, 
      <-0.742245, 0.420696, 0.405317>, <-0.734549, 0.539712, 0.350409>, <-0.674859, 0.679015, 0.195936>, <-0.667596, 0.705872, 0.067621>, 
      <-0.750020, 0.413367, 0.360173>, <-0.742324, 0.532383, 0.305265>, <-0.701462, 0.642516, 0.137935>, <-0.694199, 0.669373, 0.009620>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.597363, 0.138965, 0.387014>, <-0.620787, 0.228815, 0.442728>, <-0.704504, 0.364949, 0.528548>, <-0.698856, 0.467920, 0.495521>, 
      <-0.637623, 0.159524, 0.341823>, <-0.661047, 0.249374, 0.397537>, <-0.727483, 0.350620, 0.490881>, <-0.721835, 0.453591, 0.457854>, 
      <-0.697651, 0.178565, 0.281256>, <-0.705455, 0.234140, 0.332861>, <-0.746714, 0.351587, 0.437200>, <-0.742245, 0.420696, 0.405317>, 
      <-0.724647, 0.198503, 0.226856>, <-0.732451, 0.254078, 0.278461>, <-0.754489, 0.344258, 0.392056>, <-0.750020, 0.413367, 0.360173>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.561841, -0.057638, 0.169636>, <-0.569331, -0.012139, 0.245259>, <-0.578203, 0.065472, 0.341443>, <-0.597363, 0.138965, 0.387014>, 
      <-0.611057, -0.027285, 0.129764>, <-0.618547, 0.018214, 0.205388>, <-0.618463, 0.086030, 0.296252>, <-0.637623, 0.159524, 0.341823>, 
      <-0.658890, -0.022455, 0.038160>, <-0.665759, 0.029126, 0.111534>, <-0.688444, 0.112994, 0.220369>, <-0.697651, 0.178565, 0.281256>, 
      <-0.694199, 0.015833, -0.008964>, <-0.701068, 0.067414, 0.064411>, <-0.715440, 0.132932, 0.165969>, <-0.724647, 0.198503, 0.226856>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.561841, -0.076828, 0.028343>, <-0.561841, -0.069235, 0.070441>, <-0.558224, -0.079612, 0.133113>, <-0.561841, -0.057638, 0.169636>, 
      <-0.608693, -0.058289, 0.002268>, <-0.608693, -0.050696, 0.044366>, <-0.607440, -0.049259, 0.093241>, <-0.611057, -0.027285, 0.129764>, 
      <-0.661708, -0.063878, -0.066385>, <-0.661708, -0.054794, -0.037613>, <-0.656586, -0.039756, 0.013548>, <-0.658890, -0.022455, 0.038160>, 
      <-0.694199, -0.030152, -0.098410>, <-0.694199, -0.021068, -0.069638>, <-0.691895, -0.001468, -0.033576>, <-0.694199, 0.015833, -0.008964>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.561841, -0.121959, -0.186995>, <-0.561841, -0.116619, -0.121206>, <-0.561841, -0.088543, -0.036614>, <-0.561841, -0.076828, 0.028343>, 
      <-0.603819, -0.099623, -0.192789>, <-0.603819, -0.094283, -0.127000>, <-0.608693, -0.070004, -0.062689>, <-0.608693, -0.058289, 0.002268>, 
      <-0.663522, -0.096852, -0.244075>, <-0.663522, -0.098868, -0.197047>, <-0.661708, -0.078051, -0.111272>, <-0.661708, -0.063878, -0.066385>, 
      <-0.694199, -0.060983, -0.252256>, <-0.694199, -0.062999, -0.205228>, <-0.694199, -0.044325, -0.143297>, <-0.694199, -0.030152, -0.098410>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.561841, -0.106193, -0.333427>, <-0.562341, -0.111121, -0.289522>, <-0.561841, -0.125534, -0.231034>, <-0.561841, -0.121959, -0.186995>, 
      <-0.603531, -0.082889, -0.340767>, <-0.604031, -0.087817, -0.296862>, <-0.603819, -0.103198, -0.236827>, <-0.603819, -0.099623, -0.192789>, 
      <-0.662610, -0.055161, -0.366170>, <-0.663082, -0.065734, -0.332617>, <-0.663522, -0.095346, -0.279225>, <-0.663522, -0.096852, -0.244075>, 
      <-0.694199, -0.018867, -0.361708>, <-0.694671, -0.029441, -0.328155>, <-0.694199, -0.059477, -0.287406>, <-0.694199, -0.060983, -0.252256>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.558559, -0.089589, -0.475391>, <-0.558559, -0.100645, -0.433950>, <-0.561356, -0.101409, -0.376047>, <-0.561841, -0.106193, -0.333427>, 
      <-0.599907, -0.063858, -0.470776>, <-0.599907, -0.074914, -0.429335>, <-0.603046, -0.078105, -0.383388>, <-0.603531, -0.082889, -0.340767>, 
      <-0.662431, -0.034915, -0.466206>, <-0.662431, -0.046130, -0.440124>, <-0.662230, -0.046628, -0.393247>, <-0.662610, -0.055161, -0.366170>, 
      <-0.691363, 0.002545, -0.453849>, <-0.691363, -0.008670, -0.427766>, <-0.693818, -0.010334, -0.388784>, <-0.694199, -0.018867, -0.361708>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.561841, -0.021771, -0.649873>, <-0.561221, -0.055210, -0.604747>, <-0.558559, -0.075111, -0.529661>, <-0.558559, -0.089589, -0.475391>, 
      <-0.604839, 0.006063, -0.635402>, <-0.604219, -0.027376, -0.590276>, <-0.599907, -0.049380, -0.525046>, <-0.599907, -0.063858, -0.470776>, 
      <-0.666646, 0.043704, -0.616319>, <-0.666192, 0.010230, -0.585472>, <-0.662431, -0.016934, -0.508026>, <-0.662431, -0.034915, -0.466206>, 
      <-0.694199, 0.077474, -0.585767>, <-0.693745, 0.044000, -0.554920>, <-0.691363, 0.020527, -0.495669>, <-0.691363, 0.002545, -0.453849>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.561841, 0.087339, -0.714154>, <-0.561841, 0.054606, -0.694870>, <-0.562261, 0.000847, -0.680395>, <-0.561841, -0.021771, -0.649873>, 
      <-0.608924, 0.117372, -0.697999>, <-0.608924, 0.084639, -0.678714>, <-0.605259, 0.028681, -0.665924>, <-0.604839, 0.006063, -0.635402>, 
      <-0.663230, 0.171267, -0.674606>, <-0.657293, 0.127786, -0.669139>, <-0.667087, 0.076224, -0.646287>, <-0.666646, 0.043704, -0.616319>, 
      <-0.694199, 0.211739, -0.646627>, <-0.688262, 0.168257, -0.641160>, <-0.694640, 0.109994, -0.615735>, <-0.694199, 0.077474, -0.585767>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.419453, 0.868260, 0.277226>, <-0.451253, 0.851258, 0.232639>, <-0.525374, 0.812964, 0.214822>, <-0.561841, 0.786566, 0.179302>, 
      <-0.383614, 0.922994, 0.035425>, <-0.415415, 0.905992, -0.009162>, <-0.497119, 0.862008, -0.006592>, <-0.533586, 0.835609, -0.042112>, 
      <-0.419453, 0.803859, -0.303705>, <-0.462240, 0.781821, -0.307484>, <-0.520975, 0.753265, -0.340021>, <-0.561841, 0.729991, -0.350933>, 
      <-0.419453, 0.776259, -0.552675>, <-0.462240, 0.754220, -0.556455>, <-0.520975, 0.729018, -0.567265>, <-0.561841, 0.705745, -0.578177>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.592920, 0.511332, 0.617697>, <-0.579337, 0.662237, 0.577079>, <-0.441896, 0.833984, 0.428647>, <-0.419453, 0.868260, 0.277226>, 
      <-0.627297, 0.500636, 0.582671>, <-0.613715, 0.651541, 0.542052>, <-0.473696, 0.816982, 0.384060>, <-0.451253, 0.851258, 0.232639>, 
      <-0.673976, 0.483435, 0.536305>, <-0.666632, 0.617334, 0.493358>, <-0.542783, 0.782747, 0.351244>, <-0.525374, 0.812964, 0.214822>, 
      <-0.698856, 0.467920, 0.495521>, <-0.691511, 0.601819, 0.452574>, <-0.579250, 0.756348, 0.315724>, <-0.561841, 0.786566, 0.179302>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.490498, 0.078934, 0.489685>, <-0.520685, 0.194649, 0.560004>, <-0.604932, 0.377873, 0.653620>, <-0.592920, 0.511332, 0.617697>, 
      <-0.522367, 0.094764, 0.457520>, <-0.552555, 0.210480, 0.527839>, <-0.639310, 0.367176, 0.618593>, <-0.627297, 0.500636, 0.582671>, 
      <-0.567151, 0.123537, 0.420927>, <-0.590575, 0.213387, 0.476640>, <-0.679624, 0.380464, 0.569332>, <-0.673976, 0.483435, 0.536305>, 
      <-0.597363, 0.138965, 0.387014>, <-0.620787, 0.228815, 0.442728>, <-0.704504, 0.364949, 0.528548>, <-0.698856, 0.467920, 0.495521>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.419453, -0.153611, 0.213617>, <-0.435396, -0.104734, 0.311276>, <-0.466483, -0.013122, 0.433744>, <-0.490498, 0.078934, 0.489685>, 
      <-0.458488, -0.141970, 0.179434>, <-0.474431, -0.093093, 0.277093>, <-0.498352, 0.002709, 0.401578>, <-0.522367, 0.094764, 0.457520>, 
      <-0.524579, -0.080618, 0.199823>, <-0.532069, -0.035120, 0.275446>, <-0.547991, 0.050044, 0.375356>, <-0.567151, 0.123537, 0.420927>, 
      <-0.561841, -0.057638, 0.169636>, <-0.569331, -0.012139, 0.245259>, <-0.578203, 0.065472, 0.341443>, <-0.597363, 0.138965, 0.387014>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.419453, -0.138870, 0.054497>, <-0.419453, -0.132917, 0.102066>, <-0.412528, -0.174842, 0.171196>, <-0.419453, -0.153611, 0.213617>, 
      <-0.463161, -0.121243, 0.051089>, <-0.463161, -0.115290, 0.098658>, <-0.451563, -0.163201, 0.137012>, <-0.458488, -0.141970, 0.179434>, 
      <-0.522820, -0.092269, 0.050060>, <-0.522820, -0.084676, 0.092158>, <-0.520962, -0.102592, 0.163300>, <-0.524579, -0.080618, 0.199823>, 
      <-0.561841, -0.076828, 0.028343>, <-0.561841, -0.069235, 0.070441>, <-0.558224, -0.079612, 0.133113>, <-0.561841, -0.057638, 0.169636>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.419453, -0.207170, -0.214337>, <-0.419453, -0.199606, -0.131469>, <-0.419453, -0.149203, -0.028071>, <-0.419453, -0.138870, 0.054497>, 
      <-0.465483, -0.186784, -0.210996>, <-0.465483, -0.179220, -0.128128>, <-0.463161, -0.131577, -0.031480>, <-0.463161, -0.121243, 0.051089>, 
      <-0.517628, -0.145484, -0.180893>, <-0.517628, -0.140144, -0.115104>, <-0.522820, -0.103984, -0.014897>, <-0.522820, -0.092269, 0.050060>, 
      <-0.561841, -0.121959, -0.186995>, <-0.561841, -0.116619, -0.121206>, <-0.561841, -0.088543, -0.036614>, <-0.561841, -0.076828, 0.028343>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.419453, -0.172445, -0.313334>, <-0.419907, -0.176833, -0.282171>, <-0.419453, -0.210031, -0.245680>, <-0.419453, -0.207170, -0.214337>, 
      <-0.462502, -0.153501, -0.319967>, <-0.462956, -0.157888, -0.288804>, <-0.465483, -0.189645, -0.242339>, <-0.465483, -0.186784, -0.210996>, 
      <-0.520862, -0.129100, -0.326212>, <-0.521362, -0.134028, -0.282307>, <-0.517628, -0.149059, -0.224932>, <-0.517628, -0.145484, -0.180893>, 
      <-0.561841, -0.106193, -0.333427>, <-0.562341, -0.111121, -0.289522>, <-0.561841, -0.125534, -0.231034>, <-0.561841, -0.121959, -0.186995>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.415516, -0.169114, -0.484634>, <-0.415516, -0.179076, -0.434195>, <-0.418712, -0.165278, -0.364240>, <-0.419453, -0.172445, -0.313334>, 
      <-0.460482, -0.149442, -0.481558>, <-0.460482, -0.159404, -0.431119>, <-0.461760, -0.146334, -0.370873>, <-0.462502, -0.153501, -0.319967>, 
      <-0.516992, -0.115456, -0.480030>, <-0.516992, -0.126512, -0.438588>, <-0.520377, -0.124316, -0.368832>, <-0.520862, -0.129100, -0.326212>, 
      <-0.558559, -0.089589, -0.475391>, <-0.558559, -0.100645, -0.433950>, <-0.561356, -0.101409, -0.376047>, <-0.561841, -0.106193, -0.333427>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.419453, -0.100377, -0.678232>, <-0.418714, -0.138950, -0.630154>, <-0.415516, -0.157170, -0.545109>, <-0.415516, -0.169114, -0.484634>, 
      <-0.460559, -0.074153, -0.669527>, <-0.459820, -0.112725, -0.621449>, <-0.460482, -0.137498, -0.542032>, <-0.460482, -0.149442, -0.481558>, 
      <-0.521829, -0.047672, -0.663339>, <-0.521208, -0.081111, -0.618213>, <-0.516992, -0.100978, -0.534300>, <-0.516992, -0.115456, -0.480030>, 
      <-0.561841, -0.021771, -0.649873>, <-0.561221, -0.055210, -0.604747>, <-0.558559, -0.075111, -0.529661>, <-0.558559, -0.089589, -0.475391>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.419453, 0.036486, -0.740898>, <-0.419453, -0.004573, -0.722098>, <-0.419994, -0.072120, -0.713453>, <-0.419453, -0.100377, -0.678232>, 
      <-0.461265, 0.054095, -0.732931>, <-0.461265, 0.013036, -0.714131>, <-0.461100, -0.045895, -0.704747>, <-0.460559, -0.074153, -0.669527>, 
      <-0.524536, 0.063543, -0.726954>, <-0.524536, 0.030810, -0.707670>, <-0.522248, -0.025055, -0.693861>, <-0.521829, -0.047672, -0.663339>, 
      <-0.561841, 0.087339, -0.714154>, <-0.561841, 0.054606, -0.694870>, <-0.562261, 0.000847, -0.680395>, <-0.561841, -0.021771, -0.649873>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.419527, 0.862656, 0.378839>, <-0.446022, 0.863774, 0.363712>, <-0.402522, 0.877312, 0.300964>, <-0.419453, 0.868260, 0.277226>, 
      <-0.377940, 0.928998, 0.107453>, <-0.404435, 0.930116, 0.092326>, <-0.366684, 0.932047, 0.059163>, <-0.383614, 0.922994, 0.035425>, 
      <-0.345261, 0.842383, -0.275711>, <-0.377345, 0.825700, -0.277114>, <-0.387380, 0.820380, -0.300871>, <-0.419453, 0.803859, -0.303705>, 
      <-0.313433, 0.833694, -0.556233>, <-0.345517, 0.817011, -0.557635>, <-0.387380, 0.792779, -0.549842>, <-0.419453, 0.776259, -0.552675>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.504888, 0.528273, 0.693150>, <-0.504617, 0.664766, 0.661849>, <-0.440145, 0.829765, 0.513387>, <-0.419527, 0.862656, 0.378839>, 
      <-0.531298, 0.523191, 0.670514>, <-0.531026, 0.659683, 0.639213>, <-0.466641, 0.830883, 0.498260>, <-0.446022, 0.863774, 0.363712>, 
      <-0.568862, 0.518818, 0.642209>, <-0.555279, 0.669723, 0.601591>, <-0.424965, 0.843036, 0.452385>, <-0.402522, 0.877312, 0.300964>, 
      <-0.592920, 0.511332, 0.617697>, <-0.579337, 0.662237, 0.577079>, <-0.441896, 0.833984, 0.428647>, <-0.419453, 0.868260, 0.277226>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.421140, 0.051431, 0.564873>, <-0.441947, 0.059682, 0.542317>, <-0.469385, 0.068447, 0.510994>, <-0.490498, 0.078934, 0.489685>, 
      <-0.403343, -0.021501, 0.527332>, <-0.424150, -0.013250, 0.504776>, <-0.445370, -0.023609, 0.455053>, <-0.466483, -0.013122, 0.433744>, 
      <-0.368697, -0.069931, 0.420382>, <-0.390666, -0.079431, 0.376930>, <-0.398980, -0.115595, 0.343166>, <-0.435396, -0.104734, 0.311276>, 
      <-0.346221, -0.121943, 0.358458>, <-0.368191, -0.131443, 0.315006>, <-0.383037, -0.164471, 0.245507>, <-0.419453, -0.153611, 0.213617>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.421140, 0.051431, 0.564873>, <-0.452999, 0.181988, 0.632076>, <-0.505179, 0.381821, 0.726735>, <-0.504888, 0.528273, 0.693150>, 
      <-0.441947, 0.059682, 0.542317>, <-0.473806, 0.190239, 0.609519>, <-0.531589, 0.376739, 0.704099>, <-0.531298, 0.523191, 0.670514>, 
      <-0.469385, 0.068447, 0.510994>, <-0.499572, 0.184162, 0.581313>, <-0.580874, 0.385358, 0.678132>, <-0.568862, 0.518818, 0.642209>, 
      <-0.490498, 0.078934, 0.489685>, <-0.520685, 0.194649, 0.560004>, <-0.604932, 0.377873, 0.653620>, <-0.592920, 0.511332, 0.617697>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.316822, -0.175643, 0.047449>, <-0.287546, -0.182798, 0.046107>, <-0.247259, -0.188327, 0.045219>, <-0.217091, -0.188327, 0.045219>, 
      <-0.322244, -0.157448, 0.140628>, <-0.292968, -0.164603, 0.139285>, <-0.249728, -0.170460, 0.138234>, <-0.219561, -0.170460, 0.138234>, 
      <-0.337401, -0.138053, 0.265155>, <-0.303276, -0.143274, 0.264671>, <-0.262377, -0.154040, 0.262729>, <-0.227857, -0.154040, 0.263356>, 
      <-0.346221, -0.121943, 0.358458>, <-0.312096, -0.127164, 0.357974>, <-0.266991, -0.139346, 0.356216>, <-0.232471, -0.139346, 0.356843>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.316822, -0.175643, 0.047449>, <-0.322244, -0.157448, 0.140628>, <-0.337401, -0.138053, 0.265155>, <-0.346221, -0.121943, 0.358458>, 
      <-0.348628, -0.167870, 0.048907>, <-0.354050, -0.149675, 0.142086>, <-0.359371, -0.147553, 0.221703>, <-0.368191, -0.131443, 0.315006>, 
      <-0.389137, -0.151096, 0.056861>, <-0.389137, -0.145143, 0.104430>, <-0.376112, -0.185702, 0.203086>, <-0.383037, -0.164471, 0.245507>, 
      <-0.419453, -0.138870, 0.054497>, <-0.419453, -0.132917, 0.102066>, <-0.412528, -0.174842, 0.171196>, <-0.419453, -0.153611, 0.213617>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.313433, -0.231975, -0.205025>, <-0.314196, -0.223005, -0.127938>, <-0.312397, -0.190493, -0.028600>, <-0.316822, -0.175643, 0.047449>, 
      <-0.345463, -0.225099, -0.203748>, <-0.346225, -0.216129, -0.126661>, <-0.344203, -0.182720, -0.027141>, <-0.348628, -0.167870, 0.048907>, 
      <-0.389543, -0.220417, -0.216508>, <-0.389543, -0.212853, -0.133640>, <-0.389137, -0.161430, -0.025707>, <-0.389137, -0.151096, 0.056861>, 
      <-0.419453, -0.207170, -0.214337>, <-0.419453, -0.199606, -0.131469>, <-0.419453, -0.149203, -0.028071>, <-0.419453, -0.138870, 0.054497>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.313433, -0.215509, -0.295153>, <-0.313863, -0.218659, -0.267852>, <-0.313163, -0.235152, -0.232325>, <-0.313433, -0.231975, -0.205025>, 
      <-0.346152, -0.203837, -0.296366>, <-0.346583, -0.206987, -0.269064>, <-0.345192, -0.228275, -0.231048>, <-0.345463, -0.225099, -0.203748>, 
      <-0.387949, -0.186309, -0.308480>, <-0.388403, -0.190696, -0.277317>, <-0.389543, -0.223278, -0.247851>, <-0.389543, -0.220417, -0.216508>, 
      <-0.419453, -0.172445, -0.313334>, <-0.419907, -0.176833, -0.282171>, <-0.419453, -0.210031, -0.245680>, <-0.419453, -0.207170, -0.214337>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.308904, -0.198809, -0.492472>, <-0.308904, -0.203934, -0.433271>, <-0.312503, -0.208699, -0.354177>, <-0.313433, -0.215509, -0.295153>, 
      <-0.338736, -0.185157, -0.486859>, <-0.338736, -0.190282, -0.427657>, <-0.345222, -0.197026, -0.355390>, <-0.346152, -0.203837, -0.296366>, 
      <-0.385082, -0.182428, -0.486716>, <-0.385082, -0.192390, -0.436277>, <-0.387207, -0.179142, -0.359386>, <-0.387949, -0.186309, -0.308480>, 
      <-0.415516, -0.169114, -0.484634>, <-0.415516, -0.179076, -0.434195>, <-0.418712, -0.165278, -0.364240>, <-0.419453, -0.172445, -0.313334>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.313433, -0.180249, -0.702481>, <-0.312550, -0.215632, -0.650046>, <-0.308904, -0.193353, -0.555499>, <-0.308904, -0.198809, -0.492472>, 
      <-0.348348, -0.160512, -0.696993>, <-0.347465, -0.195896, -0.644558>, <-0.338736, -0.179701, -0.549886>, <-0.338736, -0.185157, -0.486859>, 
      <-0.385857, -0.121810, -0.685347>, <-0.385118, -0.160383, -0.637269>, <-0.385082, -0.170485, -0.547191>, <-0.385082, -0.182428, -0.486716>, 
      <-0.419453, -0.100377, -0.678232>, <-0.418714, -0.138950, -0.630154>, <-0.415516, -0.157170, -0.545109>, <-0.415516, -0.169114, -0.484634>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.313433, -0.017277, -0.761486>, <-0.313433, -0.066169, -0.743784>, <-0.314159, -0.151167, -0.745579>, <-0.313433, -0.180249, -0.702481>, 
      <-0.344504, 0.000035, -0.754794>, <-0.344504, -0.048857, -0.737092>, <-0.349073, -0.131430, -0.740090>, <-0.348348, -0.160512, -0.696993>, 
      <-0.386600, 0.022650, -0.747158>, <-0.386600, -0.018409, -0.728358>, <-0.386398, -0.093553, -0.720568>, <-0.385857, -0.121810, -0.685347>, 
      <-0.419453, 0.036486, -0.740898>, <-0.419453, -0.004573, -0.722098>, <-0.419994, -0.072120, -0.713453>, <-0.419453, -0.100377, -0.678232>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.217091, -0.250614, -0.222406>, <-0.217091, -0.237559, -0.141013>, <-0.214942, -0.203872, -0.035707>, <-0.217091, -0.188327, 0.045219>, 
      <-0.246988, -0.250614, -0.222406>, <-0.246988, -0.237559, -0.141013>, <-0.245110, -0.203872, -0.035707>, <-0.247259, -0.188327, 0.045219>, 
      <-0.284224, -0.238246, -0.206190>, <-0.284987, -0.229276, -0.129102>, <-0.283121, -0.197648, -0.029942>, <-0.287546, -0.182798, 0.046107>, 
      <-0.313433, -0.231975, -0.205025>, <-0.314196, -0.223005, -0.127938>, <-0.312397, -0.190493, -0.028600>, <-0.316822, -0.175643, 0.047449>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.217091, -0.244636, -0.305834>, <-0.215466, -0.244592, -0.280794>, <-0.217091, -0.254588, -0.247182>, <-0.217091, -0.250614, -0.222406>, 
      <-0.247455, -0.244636, -0.305834>, <-0.245830, -0.244592, -0.280794>, <-0.246988, -0.254588, -0.247182>, <-0.246988, -0.250614, -0.222406>, 
      <-0.284852, -0.225705, -0.294094>, <-0.285282, -0.228855, -0.266792>, <-0.283954, -0.241422, -0.233490>, <-0.284224, -0.238246, -0.206190>, 
      <-0.313433, -0.215509, -0.295153>, <-0.313863, -0.218659, -0.267852>, <-0.313163, -0.235152, -0.232325>, <-0.313433, -0.231975, -0.205025>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.217091, -0.076263, -0.784483>, <-0.217091, -0.117815, -0.762150>, <-0.214251, -0.188911, -0.749393>, <-0.217091, -0.214768, -0.710041>, 
      <-0.251676, -0.076263, -0.784483>, <-0.251676, -0.117815, -0.762150>, <-0.243153, -0.178555, -0.747125>, <-0.245994, -0.204412, -0.707773>, 
      <-0.283742, -0.033820, -0.767881>, <-0.283742, -0.082711, -0.750179>, <-0.287606, -0.166176, -0.749752>, <-0.286880, -0.195259, -0.706655>, 
      <-0.313433, -0.017277, -0.761486>, <-0.313433, -0.066169, -0.743784>, <-0.314159, -0.151167, -0.745579>, <-0.313433, -0.180249, -0.702481>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.357578, 0.161717, -0.300488>, <0.372979, 0.193685, -0.269348>, <0.376380, 0.220661, -0.188378>, <0.362431, 0.200477, -0.148043>, 
      <0.357281, 0.154109, -0.287379>, <0.372682, 0.186077, -0.256238>, <0.376380, 0.210068, -0.204967>, <0.362431, 0.189884, -0.164632>, 
      <0.361654, 0.154995, -0.265552>, <0.367339, 0.167434, -0.263079>, <0.368019, 0.187904, -0.196242>, <0.362431, 0.178041, -0.188200>, 
      <0.362431, 0.156361, -0.250474>, <0.368116, 0.168800, -0.248001>, <0.368019, 0.180118, -0.214319>, <0.362431, 0.170255, -0.206278>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.357578, 0.161717, -0.300488>, <0.372979, 0.193685, -0.269348>, <0.376380, 0.220661, -0.188378>, <0.362431, 0.200477, -0.148043>, 
      <0.357281, 0.154109, -0.287379>, <0.372682, 0.186077, -0.256238>, <0.376380, 0.210068, -0.204967>, <0.362431, 0.189884, -0.164632>, 
      <0.361654, 0.154995, -0.265552>, <0.362366, 0.156247, -0.251729>, <0.362431, 0.172543, -0.200965>, <0.362431, 0.178041, -0.188200>, 
      <0.362431, 0.156361, -0.250474>, <0.363143, 0.157614, -0.236650>, <0.362431, 0.164757, -0.219043>, <0.362431, 0.170255, -0.206278>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.365168, 0.226397, -0.371154>, <0.387009, 0.283959, -0.284044>, <0.376206, 0.293454, -0.126729>, <0.362431, 0.288525, -0.021067>, 
      <0.364154, 0.203781, -0.353304>, <0.385995, 0.261343, -0.266194>, <0.376206, 0.249449, -0.141304>, <0.362431, 0.244521, -0.035641>, 
      <0.358143, 0.176185, -0.325418>, <0.373545, 0.208153, -0.294277>, <0.376380, 0.245609, -0.149309>, <0.362431, 0.225425, -0.108974>, 
      <0.357578, 0.161717, -0.300488>, <0.372979, 0.193685, -0.269348>, <0.376380, 0.220661, -0.188378>, <0.362431, 0.200477, -0.148043>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.362431, 0.269971, -0.385931>, <0.379333, 0.317192, -0.306794>, <0.368565, 0.355056, -0.182813>, <0.362431, 0.372701, -0.091002>, 
      <0.363990, 0.260309, -0.376163>, <0.380892, 0.307530, -0.297025>, <0.370564, 0.335727, -0.156350>, <0.364429, 0.353373, -0.064538>, 
      <0.365654, 0.237245, -0.379716>, <0.387495, 0.294806, -0.292606>, <0.376206, 0.324620, -0.116407>, <0.362431, 0.319691, -0.010745>, 
      <0.365168, 0.226397, -0.371154>, <0.387009, 0.283959, -0.284044>, <0.376206, 0.293454, -0.126729>, <0.362431, 0.288525, -0.021067>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.256758, 0.669373, 0.009620>, <0.296287, 0.615138, -0.076564>, <0.326591, 0.541535, -0.200449>, <0.341773, 0.488326, -0.294629>, 
      <0.246177, 0.708499, -0.177313>, <0.285706, 0.654265, -0.263497>, <0.318376, 0.554982, -0.299161>, <0.333558, 0.501773, -0.393341>, 
      <0.256758, 0.634664, -0.435341>, <0.289534, 0.590588, -0.443130>, <0.325170, 0.513636, -0.522531>, <0.325170, 0.458231, -0.525326>, 
      <0.256758, 0.619788, -0.626039>, <0.289534, 0.575713, -0.633828>, <0.318055, 0.500738, -0.621401>, <0.318055, 0.445333, -0.624196>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.312579, 0.413367, 0.360173>, <0.335493, 0.391768, 0.227127>, <0.353479, 0.398450, 0.042974>, <0.362431, 0.372701, -0.091002>, 
      <0.304883, 0.532383, 0.305265>, <0.327797, 0.510783, 0.172219>, <0.349187, 0.439968, -0.013870>, <0.358138, 0.414218, -0.147846>, 
      <0.264021, 0.642516, 0.137935>, <0.303550, 0.588281, 0.051751>, <0.332387, 0.532049, -0.130809>, <0.347569, 0.478840, -0.224989>, 
      <0.256758, 0.669373, 0.009620>, <0.296287, 0.615138, -0.076564>, <0.326591, 0.541535, -0.200449>, <0.341773, 0.488326, -0.294629>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.287206, 0.198503, 0.226856>, <0.321958, 0.224169, 0.156826>, <0.351805, 0.284723, 0.060439>, <0.362431, 0.288525, -0.021067>, 
      <0.295010, 0.254078, 0.278461>, <0.329762, 0.279743, 0.208431>, <0.351805, 0.315889, 0.070761>, <0.362431, 0.319691, -0.010745>, 
      <0.317048, 0.344258, 0.392056>, <0.339962, 0.322659, 0.259010>, <0.355478, 0.379122, 0.069438>, <0.364429, 0.353373, -0.064538>, 
      <0.312579, 0.413367, 0.360173>, <0.335493, 0.391768, 0.227127>, <0.353479, 0.398450, 0.042974>, <0.362431, 0.372701, -0.091002>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.256758, 0.015833, -0.008964>, <0.295090, 0.057399, -0.060122>, <0.339901, 0.167877, -0.082897>, <0.362431, 0.200477, -0.148043>, 
      <0.263627, 0.067414, 0.064411>, <0.301959, 0.108980, 0.013252>, <0.339901, 0.192825, -0.043829>, <0.362431, 0.225425, -0.108974>, 
      <0.277999, 0.132932, 0.165969>, <0.312751, 0.158598, 0.095939>, <0.351805, 0.240719, 0.045865>, <0.362431, 0.244521, -0.035641>, 
      <0.287206, 0.198503, 0.226856>, <0.321958, 0.224169, 0.156826>, <0.351805, 0.284723, 0.060439>, <0.362431, 0.288525, -0.021067>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.256758, -0.030152, -0.098410>, <0.299869, 0.014599, -0.140903>, <0.332164, 0.116834, -0.162724>, <0.362431, 0.170255, -0.206278>, 
      <0.256758, -0.021068, -0.069638>, <0.299869, 0.023683, -0.112131>, <0.332164, 0.124620, -0.144646>, <0.362431, 0.178041, -0.188200>, 
      <0.254454, -0.001468, -0.033576>, <0.292786, 0.040098, -0.084734>, <0.339901, 0.157284, -0.099487>, <0.362431, 0.189884, -0.164632>, 
      <0.256758, 0.015833, -0.008964>, <0.295090, 0.057399, -0.060122>, <0.339901, 0.167877, -0.082897>, <0.362431, 0.200477, -0.148043>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.256758, -0.060983, -0.252256>, <0.256758, -0.062999, -0.205228>, <0.256758, -0.044325, -0.143297>, <0.256758, -0.030152, -0.098410>, 
      <0.303190, -0.006692, -0.264639>, <0.303190, -0.008708, -0.217610>, <0.299869, 0.000426, -0.185791>, <0.299869, 0.014599, -0.140903>, 
      <0.332776, 0.091470, -0.263377>, <0.338461, 0.103909, -0.260903>, <0.337752, 0.126697, -0.170765>, <0.332164, 0.116834, -0.162724>, 
      <0.362431, 0.156361, -0.250474>, <0.368116, 0.168800, -0.248001>, <0.368019, 0.180118, -0.214319>, <0.362431, 0.170255, -0.206278>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.256758, -0.060983, -0.252256>, <0.303190, -0.006692, -0.264639>, <0.332776, 0.091470, -0.263377>, <0.362431, 0.156361, -0.250474>, 
      <0.256758, -0.062999, -0.205228>, <0.303190, -0.008708, -0.217610>, <0.333489, 0.092722, -0.249553>, <0.363143, 0.157614, -0.236650>, 
      <0.256758, -0.044325, -0.143297>, <0.299869, 0.000426, -0.185791>, <0.332164, 0.111336, -0.175489>, <0.362431, 0.164757, -0.219043>, 
      <0.256758, -0.030152, -0.098410>, <0.299869, 0.014599, -0.140903>, <0.332164, 0.116834, -0.162724>, <0.362431, 0.170255, -0.206278>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.256758, -0.018867, -0.361708>, <0.299058, 0.029734, -0.355733>, <0.336469, 0.117901, -0.343169>, <0.357578, 0.161717, -0.300488>, 
      <0.257230, -0.029441, -0.328155>, <0.299530, 0.019161, -0.322180>, <0.336172, 0.110293, -0.330060>, <0.357281, 0.154109, -0.287379>, 
      <0.256758, -0.059477, -0.287406>, <0.303190, -0.005186, -0.299789>, <0.332000, 0.090103, -0.278455>, <0.361654, 0.154995, -0.265552>, 
      <0.256758, -0.060983, -0.252256>, <0.303190, -0.006692, -0.264639>, <0.332776, 0.091470, -0.263377>, <0.362431, 0.156361, -0.250474>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.253922, 0.002545, -0.453849>, <0.300638, 0.063031, -0.433896>, <0.348995, 0.183773, -0.435658>, <0.365168, 0.226397, -0.371154>, 
      <0.253922, -0.008670, -0.427766>, <0.300638, 0.051816, -0.407813>, <0.347981, 0.161157, -0.417808>, <0.364154, 0.203781, -0.353304>, 
      <0.256377, -0.010334, -0.388784>, <0.298677, 0.038267, -0.382809>, <0.337034, 0.132369, -0.368099>, <0.358143, 0.176185, -0.325418>, 
      <0.256758, -0.018867, -0.361708>, <0.299058, 0.029734, -0.355733>, <0.336469, 0.117901, -0.343169>, <0.357578, 0.161717, -0.300488>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.256758, 0.077474, -0.585767>, <0.302868, 0.133988, -0.534638>, <0.346362, 0.225078, -0.461167>, <0.362431, 0.269971, -0.385931>, 
      <0.256304, 0.044000, -0.554920>, <0.302414, 0.100514, -0.503791>, <0.347921, 0.215416, -0.451398>, <0.363990, 0.260309, -0.376163>, 
      <0.253922, 0.020527, -0.495669>, <0.300638, 0.081013, -0.475716>, <0.349482, 0.194621, -0.444220>, <0.365654, 0.237245, -0.379716>, 
      <0.253922, 0.002545, -0.453849>, <0.300638, 0.063031, -0.433896>, <0.348995, 0.183773, -0.435658>, <0.365168, 0.226397, -0.371154>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.341773, 0.371412, -0.517767>, <0.329342, 0.330968, -0.569238>, <0.292251, 0.258123, -0.614560>, <0.256758, 0.211739, -0.646627>, 
      <0.355873, 0.417285, -0.459387>, <0.343442, 0.376841, -0.510858>, <0.304148, 0.329518, -0.622019>, <0.268655, 0.283134, -0.654085>, 
      <0.352277, 0.451512, -0.359789>, <0.344061, 0.464959, -0.458500>, <0.325170, 0.385561, -0.528992>, <0.318055, 0.372663, -0.627863>, 
      <0.341773, 0.488326, -0.294629>, <0.333558, 0.501773, -0.393341>, <0.325170, 0.458231, -0.525326>, <0.318055, 0.445333, -0.624196>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.341773, 0.371412, -0.517767>, <0.355873, 0.417285, -0.459387>, <0.352277, 0.451512, -0.359789>, <0.341773, 0.488326, -0.294629>, 
      <0.347970, 0.340980, -0.478216>, <0.362070, 0.386852, -0.419836>, <0.358073, 0.442026, -0.290148>, <0.347569, 0.478840, -0.224989>, 
      <0.356762, 0.305109, -0.421456>, <0.373665, 0.352330, -0.342318>, <0.364273, 0.396573, -0.239658>, <0.358138, 0.414218, -0.147846>, 
      <0.362431, 0.269971, -0.385931>, <0.379333, 0.317192, -0.306794>, <0.368565, 0.355056, -0.182813>, <0.362431, 0.372701, -0.091002>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.341773, 0.371412, -0.517767>, <0.347970, 0.340980, -0.478216>, <0.356762, 0.305109, -0.421456>, <0.362431, 0.269971, -0.385931>, 
      <0.329342, 0.330968, -0.569238>, <0.335539, 0.300536, -0.529687>, <0.340693, 0.260215, -0.496692>, <0.346362, 0.225078, -0.461167>, 
      <0.292251, 0.258123, -0.614560>, <0.285021, 0.214730, -0.610027>, <0.303308, 0.166508, -0.564606>, <0.302868, 0.133988, -0.534638>, 
      <0.256758, 0.211739, -0.646627>, <0.249527, 0.168346, -0.642094>, <0.257199, 0.109994, -0.615735>, <0.256758, 0.077474, -0.585767>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.124400, 0.786566, 0.179302>, <0.171149, 0.752725, 0.133768>, <0.230155, 0.705872, 0.067621>, <0.256758, 0.669373, 0.009620>, 
      <0.096145, 0.835609, -0.042112>, <0.142894, 0.801768, -0.087646>, <0.219575, 0.744999, -0.119312>, <0.246177, 0.708499, -0.177313>, 
      <0.124400, 0.729991, -0.350933>, <0.166280, 0.706140, -0.362116>, <0.227527, 0.673971, -0.428395>, <0.256758, 0.634664, -0.435341>, 
      <0.124400, 0.705745, -0.578177>, <0.166280, 0.681894, -0.589360>, <0.227527, 0.659096, -0.619093>, <0.256758, 0.619788, -0.626039>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.261415, 0.467920, 0.495521>, <0.286354, 0.453819, 0.459033>, <0.304804, 0.420696, 0.405317>, <0.312579, 0.413367, 0.360173>, 
      <0.254070, 0.601819, 0.452574>, <0.279009, 0.587717, 0.416087>, <0.297108, 0.539712, 0.350409>, <0.304883, 0.532383, 0.305265>, 
      <0.141809, 0.756348, 0.315724>, <0.188558, 0.722507, 0.270190>, <0.237418, 0.679015, 0.195936>, <0.264021, 0.642516, 0.137935>, 
      <0.124400, 0.786566, 0.179302>, <0.171149, 0.752725, 0.133768>, <0.230155, 0.705872, 0.067621>, <0.256758, 0.669373, 0.009620>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.159922, 0.138965, 0.387014>, <0.200182, 0.159524, 0.341823>, <0.260210, 0.178565, 0.281256>, <0.287206, 0.198503, 0.226856>, 
      <0.183346, 0.228815, 0.442728>, <0.223606, 0.249374, 0.397537>, <0.268014, 0.234140, 0.332861>, <0.295010, 0.254078, 0.278461>, 
      <0.267063, 0.364949, 0.528548>, <0.292002, 0.350847, 0.492060>, <0.309273, 0.351587, 0.437200>, <0.317048, 0.344258, 0.392056>, 
      <0.261415, 0.467920, 0.495521>, <0.286354, 0.453819, 0.459033>, <0.304804, 0.420696, 0.405317>, <0.312579, 0.413367, 0.360173>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.124400, -0.057638, 0.169636>, <0.173616, -0.027285, 0.129764>, <0.221449, -0.022455, 0.038160>, <0.256758, 0.015833, -0.008964>, 
      <0.131890, -0.012139, 0.245259>, <0.181106, 0.018214, 0.205388>, <0.228318, 0.029126, 0.111534>, <0.263627, 0.067414, 0.064411>, 
      <0.140762, 0.065472, 0.341443>, <0.181022, 0.086030, 0.296252>, <0.251003, 0.112994, 0.220369>, <0.277999, 0.132932, 0.165969>, 
      <0.159922, 0.138965, 0.387014>, <0.200182, 0.159524, 0.341823>, <0.260210, 0.178565, 0.281256>, <0.287206, 0.198503, 0.226856>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.124400, -0.076828, 0.028343>, <0.171252, -0.058289, 0.002268>, <0.224267, -0.063878, -0.066385>, <0.256758, -0.030152, -0.098410>, 
      <0.124400, -0.069235, 0.070441>, <0.171252, -0.050696, 0.044366>, <0.224267, -0.054794, -0.037613>, <0.256758, -0.021068, -0.069638>, 
      <0.120783, -0.079612, 0.133113>, <0.169999, -0.049259, 0.093241>, <0.219145, -0.039756, 0.013548>, <0.254454, -0.001468, -0.033576>, 
      <0.124400, -0.057638, 0.169636>, <0.173616, -0.027285, 0.129764>, <0.221449, -0.022455, 0.038160>, <0.256758, 0.015833, -0.008964>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.124400, -0.121959, -0.186995>, <0.166378, -0.099623, -0.192789>, <0.226081, -0.096852, -0.244075>, <0.256758, -0.060983, -0.252256>, 
      <0.124400, -0.116619, -0.121206>, <0.166378, -0.094283, -0.127000>, <0.226081, -0.098868, -0.197047>, <0.256758, -0.062999, -0.205228>, 
      <0.124400, -0.088543, -0.036614>, <0.171252, -0.070004, -0.062689>, <0.224267, -0.078051, -0.111272>, <0.256758, -0.044325, -0.143297>, 
      <0.124400, -0.076828, 0.028343>, <0.171252, -0.058289, 0.002268>, <0.224267, -0.063878, -0.066385>, <0.256758, -0.030152, -0.098410>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.124400, -0.106193, -0.333427>, <0.166090, -0.082889, -0.340767>, <0.225169, -0.055161, -0.366170>, <0.256758, -0.018867, -0.361708>, 
      <0.124900, -0.111121, -0.289522>, <0.166589, -0.087817, -0.296862>, <0.225641, -0.065734, -0.332617>, <0.257230, -0.029441, -0.328155>, 
      <0.124400, -0.125534, -0.231034>, <0.166378, -0.103198, -0.236827>, <0.226081, -0.095346, -0.279225>, <0.256758, -0.059477, -0.287406>, 
      <0.124400, -0.121959, -0.186995>, <0.166378, -0.099623, -0.192789>, <0.226081, -0.096852, -0.244075>, <0.256758, -0.060983, -0.252256>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.121118, -0.089589, -0.475391>, <0.162466, -0.063858, -0.470776>, <0.224990, -0.034915, -0.466206>, <0.253922, 0.002545, -0.453849>, 
      <0.121118, -0.100645, -0.433950>, <0.162466, -0.074914, -0.429335>, <0.224990, -0.046130, -0.440124>, <0.253922, -0.008670, -0.427766>, 
      <0.123915, -0.101409, -0.376047>, <0.165605, -0.078105, -0.383388>, <0.224789, -0.046628, -0.393247>, <0.256377, -0.010334, -0.388784>, 
      <0.124400, -0.106193, -0.333427>, <0.166090, -0.082889, -0.340767>, <0.225169, -0.055161, -0.366170>, <0.256758, -0.018867, -0.361708>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.124400, -0.021771, -0.649873>, <0.167398, 0.006063, -0.635402>, <0.229205, 0.043704, -0.616319>, <0.256758, 0.077474, -0.585767>, 
      <0.123780, -0.055210, -0.604747>, <0.166778, -0.027376, -0.590276>, <0.228751, 0.010230, -0.585472>, <0.256304, 0.044000, -0.554920>, 
      <0.121118, -0.075111, -0.529661>, <0.162466, -0.049380, -0.525046>, <0.224990, -0.016934, -0.508026>, <0.253922, 0.020527, -0.495669>, 
      <0.121118, -0.089589, -0.475391>, <0.162466, -0.063858, -0.470776>, <0.224990, -0.034915, -0.466206>, <0.253922, 0.002545, -0.453849>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.124400, 0.087339, -0.714154>, <0.171484, 0.117372, -0.697999>, <0.225789, 0.171267, -0.674606>, <0.256758, 0.211739, -0.646627>, 
      <0.124400, 0.054606, -0.694870>, <0.171484, 0.084639, -0.678714>, <0.218558, 0.127874, -0.670073>, <0.249527, 0.168346, -0.642094>, 
      <0.124820, 0.000847, -0.680395>, <0.167818, 0.028681, -0.665924>, <0.229646, 0.076224, -0.646287>, <0.257199, 0.109994, -0.615735>, 
      <0.124400, -0.021771, -0.649873>, <0.167398, 0.006063, -0.635402>, <0.229205, 0.043704, -0.616319>, <0.256758, 0.077474, -0.585767>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.017988, 0.868260, 0.277226>, <0.015054, 0.851561, 0.233434>, <0.087933, 0.812964, 0.214822>, <0.124400, 0.786566, 0.179302>, 
      <-0.050654, 0.923272, 0.035039>, <-0.017612, 0.906573, -0.008753>, <0.059678, 0.862008, -0.006592>, <0.096145, 0.835609, -0.042112>, 
      <-0.017988, 0.803859, -0.303705>, <0.024799, 0.781821, -0.307484>, <0.083534, 0.753265, -0.340021>, <0.124400, 0.729991, -0.350933>, 
      <-0.017988, 0.776259, -0.552675>, <0.024799, 0.754220, -0.556455>, <0.083534, 0.729018, -0.567265>, <0.124400, 0.705745, -0.578177>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.139325, 0.511332, 0.613658>, <0.179139, 0.501290, 0.580776>, <0.233136, 0.483910, 0.536895>, <0.261415, 0.467920, 0.495521>, 
      <0.125945, 0.659992, 0.573644>, <0.165759, 0.649950, 0.540762>, <0.225792, 0.617809, 0.493949>, <0.254070, 0.601819, 0.452574>, 
      <0.002164, 0.834323, 0.426632>, <0.035206, 0.817624, 0.382840>, <0.105342, 0.782747, 0.351244>, <0.141809, 0.756348, 0.315724>, 
      <-0.017988, 0.868260, 0.277226>, <0.015054, 0.851561, 0.233434>, <0.087933, 0.812964, 0.214822>, <0.124400, 0.786566, 0.179302>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.053057, 0.078934, 0.489685>, <0.086492, 0.094121, 0.458826>, <0.129710, 0.123537, 0.420927>, <0.159922, 0.138965, 0.387014>, 
      <0.080357, 0.194327, 0.559107>, <0.113792, 0.209514, 0.528248>, <0.153134, 0.213387, 0.476640>, <0.183346, 0.228815, 0.442728>, 
      <0.151223, 0.379148, 0.649237>, <0.191037, 0.369106, 0.616356>, <0.238784, 0.380939, 0.569923>, <0.267063, 0.364949, 0.528548>, 
      <0.139325, 0.511332, 0.613658>, <0.179139, 0.501290, 0.580776>, <0.233136, 0.483910, 0.536895>, <0.261415, 0.467920, 0.495521>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.017988, -0.153611, 0.213617>, <0.023160, -0.142956, 0.181663>, <0.087138, -0.080618, 0.199823>, <0.124400, -0.057638, 0.169636>, 
      <-0.002045, -0.104734, 0.311276>, <0.039103, -0.094080, 0.279322>, <0.094628, -0.035120, 0.275446>, <0.131890, -0.012139, 0.245259>, 
      <0.031130, -0.013750, 0.433924>, <0.064565, 0.001437, 0.403065>, <0.110550, 0.050044, 0.375356>, <0.140762, 0.065472, 0.341443>, 
      <0.053057, 0.078934, 0.489685>, <0.086492, 0.094121, 0.458826>, <0.129710, 0.123537, 0.420927>, <0.159922, 0.138965, 0.387014>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.017988, -0.138870, 0.054497>, <0.025720, -0.121243, 0.051089>, <0.085379, -0.092269, 0.050060>, <0.124400, -0.076828, 0.028343>, 
      <-0.017988, -0.132917, 0.102066>, <0.025720, -0.115290, 0.098658>, <0.085379, -0.084676, 0.092158>, <0.124400, -0.069235, 0.070441>, 
      <-0.024913, -0.174842, 0.171196>, <0.016235, -0.164188, 0.139241>, <0.083521, -0.102592, 0.163300>, <0.120783, -0.079612, 0.133113>, 
      <-0.017988, -0.153611, 0.213617>, <0.023160, -0.142956, 0.181663>, <0.087138, -0.080618, 0.199823>, <0.124400, -0.057638, 0.169636>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.017988, -0.207170, -0.214337>, <0.028042, -0.186784, -0.210996>, <0.080187, -0.145484, -0.180893>, <0.124400, -0.121959, -0.186995>, 
      <-0.017988, -0.199606, -0.131469>, <0.028042, -0.179220, -0.128128>, <0.080187, -0.140144, -0.115104>, <0.124400, -0.116619, -0.121206>, 
      <-0.017988, -0.149203, -0.028071>, <0.025720, -0.131577, -0.031480>, <0.085379, -0.103984, -0.014897>, <0.124400, -0.088543, -0.036614>, 
      <-0.017988, -0.138870, 0.054497>, <0.025720, -0.121243, 0.051089>, <0.085379, -0.092269, 0.050060>, <0.124400, -0.076828, 0.028343>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.017988, -0.172445, -0.313334>, <0.025061, -0.153501, -0.319967>, <0.083421, -0.129100, -0.326212>, <0.124400, -0.106193, -0.333427>, 
      <-0.017534, -0.176833, -0.282171>, <0.025515, -0.157888, -0.288804>, <0.083920, -0.134028, -0.282307>, <0.124900, -0.111121, -0.289522>, 
      <-0.017988, -0.210031, -0.245680>, <0.028042, -0.189645, -0.242339>, <0.080187, -0.149059, -0.224932>, <0.124400, -0.125534, -0.231034>, 
      <-0.017988, -0.207170, -0.214337>, <0.028042, -0.186784, -0.210996>, <0.080187, -0.145484, -0.180893>, <0.124400, -0.121959, -0.186995>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.021925, -0.169114, -0.484634>, <0.023041, -0.149442, -0.481558>, <0.079551, -0.115456, -0.480030>, <0.121118, -0.089589, -0.475391>, 
      <-0.021925, -0.179076, -0.434195>, <0.023041, -0.159404, -0.431119>, <0.079551, -0.126512, -0.438588>, <0.121118, -0.100645, -0.433950>, 
      <-0.018730, -0.165278, -0.364240>, <0.024319, -0.146334, -0.370873>, <0.082936, -0.124316, -0.368832>, <0.123915, -0.101409, -0.376047>, 
      <-0.017988, -0.172445, -0.313334>, <0.025061, -0.153501, -0.319967>, <0.083421, -0.129100, -0.326212>, <0.124400, -0.106193, -0.333427>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.017988, -0.100377, -0.678232>, <0.023118, -0.074153, -0.669527>, <0.084388, -0.047672, -0.663339>, <0.124400, -0.021771, -0.649873>, 
      <-0.018727, -0.138950, -0.630154>, <0.022379, -0.112725, -0.621449>, <0.083767, -0.081111, -0.618213>, <0.123780, -0.055210, -0.604747>, 
      <-0.021925, -0.157170, -0.545109>, <0.023041, -0.137498, -0.542032>, <0.079551, -0.100978, -0.534300>, <0.121118, -0.075111, -0.529661>, 
      <-0.021925, -0.169114, -0.484634>, <0.023041, -0.149442, -0.481558>, <0.079551, -0.115456, -0.480030>, <0.121118, -0.089589, -0.475391>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.017988, 0.036486, -0.740898>, <0.023824, 0.054095, -0.732931>, <0.087095, 0.063543, -0.726954>, <0.124400, 0.087339, -0.714154>, 
      <-0.017988, -0.004573, -0.722098>, <0.023824, 0.013036, -0.714131>, <0.087095, 0.030810, -0.707670>, <0.124400, 0.054606, -0.694870>, 
      <-0.017447, -0.072120, -0.713453>, <0.023659, -0.045895, -0.704747>, <0.084807, -0.025055, -0.693861>, <0.124820, 0.000847, -0.680395>, 
      <-0.017988, -0.100377, -0.678232>, <0.023118, -0.074153, -0.669527>, <0.084388, -0.047672, -0.663339>, <0.124400, -0.021771, -0.649873>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.026156, 0.862656, 0.378839>, <-0.058011, 0.929237, 0.106476>, <-0.094652, 0.842383, -0.275711>, <-0.124008, 0.833694, -0.556233>, 
      <0.000802, 0.863728, 0.364339>, <-0.031054, 0.930309, 0.091976>, <-0.061260, 0.828482, -0.276880>, <-0.090615, 0.819794, -0.557402>, 
      <-0.035636, 0.877179, 0.300616>, <-0.068302, 0.932191, 0.058429>, <-0.050061, 0.820380, -0.300871>, <-0.050061, 0.792779, -0.549842>, 
      <-0.017988, 0.868260, 0.277226>, <-0.050654, 0.923272, 0.035039>, <-0.017988, 0.803859, -0.303705>, <-0.017988, 0.776259, -0.552675>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.022119, 0.528273, 0.693150>, <0.023221, 0.663200, 0.662208>, <-0.010529, 0.829993, 0.512454>, <-0.026156, 0.862656, 0.378839>, 
      <0.057281, 0.523191, 0.669302>, <0.058383, 0.658118, 0.638360>, <0.016429, 0.831065, 0.497954>, <0.000802, 0.863728, 0.364339>, 
      <0.106940, 0.519500, 0.640404>, <0.093559, 0.668160, 0.600390>, <-0.015485, 0.843243, 0.450022>, <-0.035636, 0.877179, 0.300616>, 
      <0.139325, 0.511332, 0.613658>, <0.125945, 0.659992, 0.573644>, <0.002164, 0.834323, 0.426632>, <-0.017988, 0.868260, 0.277226>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.032784, 0.051431, 0.564873>, <-0.003519, 0.181704, 0.631121>, <0.020932, 0.382997, 0.726465>, <0.022119, 0.528273, 0.693150>, 
      <-0.007032, 0.059682, 0.542317>, <0.022233, 0.189955, 0.608564>, <0.056094, 0.377915, 0.702618>, <0.057281, 0.523191, 0.669302>, 
      <0.028511, 0.067784, 0.512340>, <0.055811, 0.183177, 0.581762>, <0.118837, 0.387315, 0.675984>, <0.106940, 0.519500, 0.640404>, 
      <0.053057, 0.078934, 0.489685>, <0.080357, 0.194327, 0.559107>, <0.151223, 0.379148, 0.649237>, <0.139325, 0.511332, 0.613658>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.123947, -0.121943, 0.362496>, <-0.092159, -0.131443, 0.317832>, <-0.061040, -0.164759, 0.247050>, <-0.017988, -0.153611, 0.213617>, 
      <-0.122949, -0.138053, 0.267982>, <-0.091161, -0.147553, 0.223318>, <-0.067966, -0.185990, 0.204629>, <-0.024913, -0.174842, 0.171196>, 
      <-0.120609, -0.157393, 0.141579>, <-0.088834, -0.149500, 0.143059>, <-0.048304, -0.145143, 0.104430>, <-0.017988, -0.132917, 0.102066>, 
      <-0.120619, -0.175643, 0.047449>, <-0.088844, -0.167750, 0.048930>, <-0.048304, -0.151096, 0.056861>, <-0.017988, -0.138870, 0.054497>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.123947, -0.121943, 0.362496>, <-0.156504, -0.127164, 0.360800>, <-0.199460, -0.139346, 0.357443>, <-0.232471, -0.139346, 0.356843>, 
      <-0.122949, -0.138053, 0.267982>, <-0.155506, -0.143274, 0.266286>, <-0.194846, -0.154040, 0.263956>, <-0.227857, -0.154040, 0.263356>, 
      <-0.120609, -0.157393, 0.141579>, <-0.148917, -0.164425, 0.140260>, <-0.190362, -0.170460, 0.138234>, <-0.219561, -0.170460, 0.138234>, 
      <-0.120619, -0.175643, 0.047449>, <-0.148927, -0.182675, 0.046130>, <-0.187893, -0.188327, 0.045219>, <-0.217091, -0.188327, 0.045219>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.123947, -0.121943, 0.362496>, <-0.096598, -0.069931, 0.423209>, <-0.049374, -0.022419, 0.527318>, <-0.032784, 0.051431, 0.564873>, 
      <-0.092159, -0.131443, 0.317832>, <-0.064810, -0.079431, 0.378545>, <-0.023621, -0.014168, 0.504762>, <-0.007032, 0.059682, 0.542317>, 
      <-0.061040, -0.164759, 0.247050>, <-0.045097, -0.115882, 0.344710>, <0.006584, -0.024900, 0.456579>, <0.028511, 0.067784, 0.512340>, 
      <-0.017988, -0.153611, 0.213617>, <-0.002045, -0.104734, 0.311276>, <0.031130, -0.013750, 0.433924>, <0.053057, 0.078934, 0.489685>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.124008, -0.231975, -0.205025>, <-0.092003, -0.224992, -0.203728>, <-0.047898, -0.220417, -0.216508>, <-0.017988, -0.207170, -0.214337>, 
      <-0.123245, -0.223005, -0.127938>, <-0.091240, -0.216021, -0.126640>, <-0.047898, -0.212853, -0.133640>, <-0.017988, -0.199606, -0.131469>, 
      <-0.120627, -0.190415, -0.028744>, <-0.088852, -0.182522, -0.027263>, <-0.048304, -0.161430, -0.025707>, <-0.017988, -0.149203, -0.028071>, 
      <-0.120619, -0.175643, 0.047449>, <-0.088844, -0.167750, 0.048930>, <-0.048304, -0.151096, 0.056861>, <-0.017988, -0.138870, 0.054497>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.124008, -0.231975, -0.205025>, <-0.123245, -0.223005, -0.127938>, <-0.120627, -0.190415, -0.028744>, <-0.120619, -0.175643, 0.047449>, 
      <-0.152273, -0.238142, -0.206171>, <-0.151510, -0.229172, -0.129083>, <-0.148935, -0.197447, -0.030063>, <-0.148927, -0.182675, 0.046130>, 
      <-0.188138, -0.250614, -0.222406>, <-0.188138, -0.237559, -0.141013>, <-0.185744, -0.203872, -0.035707>, <-0.187893, -0.188327, 0.045219>, 
      <-0.217091, -0.250614, -0.222406>, <-0.217091, -0.237559, -0.141013>, <-0.214942, -0.203872, -0.035707>, <-0.217091, -0.188327, 0.045219>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.124008, -0.215509, -0.295153>, <-0.123578, -0.218659, -0.267852>, <-0.124278, -0.235152, -0.232325>, <-0.124008, -0.231975, -0.205025>, 
      <-0.151663, -0.225536, -0.294111>, <-0.151233, -0.228686, -0.266810>, <-0.152543, -0.241319, -0.233471>, <-0.152273, -0.238142, -0.206171>, 
      <-0.187656, -0.244636, -0.305834>, <-0.186031, -0.244592, -0.280794>, <-0.188138, -0.254588, -0.247182>, <-0.188138, -0.250614, -0.222406>, 
      <-0.217091, -0.244636, -0.305834>, <-0.215466, -0.244592, -0.280794>, <-0.217091, -0.254588, -0.247182>, <-0.217091, -0.250614, -0.222406>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.124008, -0.215509, -0.295153>, <-0.091350, -0.203668, -0.296383>, <-0.049492, -0.186309, -0.308480>, <-0.017988, -0.172445, -0.313334>, 
      <-0.123578, -0.218659, -0.267852>, <-0.090920, -0.206818, -0.269082>, <-0.049038, -0.190696, -0.277317>, <-0.017534, -0.176833, -0.282171>, 
      <-0.124278, -0.235152, -0.232325>, <-0.092273, -0.228168, -0.231028>, <-0.047898, -0.223278, -0.247851>, <-0.017988, -0.210031, -0.245680>, 
      <-0.124008, -0.231975, -0.205025>, <-0.092003, -0.224992, -0.203728>, <-0.047898, -0.220417, -0.216508>, <-0.017988, -0.207170, -0.214337>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.128537, -0.198809, -0.492472>, <-0.097780, -0.187042, -0.487634>, <-0.052359, -0.182428, -0.486716>, <-0.021925, -0.169114, -0.484634>, 
      <-0.128537, -0.203934, -0.433271>, <-0.097780, -0.192167, -0.428432>, <-0.052359, -0.192390, -0.436277>, <-0.021925, -0.179076, -0.434195>, 
      <-0.124938, -0.208699, -0.354177>, <-0.092280, -0.196857, -0.355407>, <-0.050234, -0.179142, -0.359386>, <-0.018730, -0.165278, -0.364240>, 
      <-0.124008, -0.215509, -0.295153>, <-0.091350, -0.203668, -0.296383>, <-0.049492, -0.186309, -0.308480>, <-0.017988, -0.172445, -0.313334>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.124008, -0.180249, -0.702481>, <-0.089240, -0.160274, -0.696926>, <-0.051584, -0.121810, -0.685347>, <-0.017988, -0.100377, -0.678232>, 
      <-0.124891, -0.215632, -0.650046>, <-0.090123, -0.195657, -0.644491>, <-0.052323, -0.160383, -0.637269>, <-0.018727, -0.138950, -0.630154>, 
      <-0.128537, -0.193353, -0.555499>, <-0.097780, -0.181586, -0.550661>, <-0.052359, -0.170485, -0.547191>, <-0.021925, -0.157170, -0.545109>, 
      <-0.128537, -0.198809, -0.492472>, <-0.097780, -0.187042, -0.487634>, <-0.052359, -0.182428, -0.486716>, <-0.021925, -0.169114, -0.484634>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.124008, -0.017277, -0.761486>, <-0.093071, 0.000242, -0.754714>, <-0.050841, 0.022650, -0.747158>, <-0.017988, 0.036486, -0.740898>, 
      <-0.124008, -0.066169, -0.743784>, <-0.093071, -0.048649, -0.737012>, <-0.050841, -0.018409, -0.728358>, <-0.017988, -0.004573, -0.722098>, 
      <-0.123282, -0.151167, -0.745579>, <-0.088514, -0.131191, -0.740024>, <-0.051043, -0.093553, -0.720568>, <-0.017447, -0.072120, -0.713453>, 
      <-0.124008, -0.180249, -0.702481>, <-0.089240, -0.160274, -0.696926>, <-0.051584, -0.121810, -0.685347>, <-0.017988, -0.100377, -0.678232>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.124008, -0.017277, -0.761486>, <-0.124008, -0.066169, -0.743784>, <-0.123282, -0.151167, -0.745579>, <-0.124008, -0.180249, -0.702481>, 
      <-0.152876, -0.033625, -0.767805>, <-0.152876, -0.082516, -0.750104>, <-0.148937, -0.165906, -0.749677>, <-0.149662, -0.194988, -0.706580>, 
      <-0.183319, -0.076263, -0.784483>, <-0.183319, -0.117815, -0.762150>, <-0.186326, -0.178555, -0.747125>, <-0.189166, -0.204412, -0.707773>, 
      <-0.217091, -0.076263, -0.784483>, <-0.217091, -0.117815, -0.762150>, <-0.214251, -0.188911, -0.749393>, <-0.217091, -0.214768, -0.710041>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.240954, 0.869073, -0.544872>, <-0.204142, 0.869073, -0.544872>, <-0.157976, 0.847834, -0.555044>, <-0.124008, 0.833694, -0.556233>, 
      <-0.236080, 0.866363, -0.264886>, <-0.199267, 0.866363, -0.264886>, <-0.128620, 0.856522, -0.274523>, <-0.094652, 0.842383, -0.275711>, 
      <-0.229580, 0.862751, 0.108429>, <-0.170015, 0.863535, 0.105556>, <-0.110503, 0.927150, 0.134710>, <-0.058011, 0.929237, 0.106476>, 
      <-0.224706, 0.860041, 0.388415>, <-0.165141, 0.860826, 0.385542>, <-0.078647, 0.860569, 0.407073>, <-0.026156, 0.862656, 0.378839>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.240954, 0.869073, -0.544872>, <-0.236080, 0.866363, -0.264886>, <-0.229580, 0.862751, 0.108429>, <-0.224706, 0.860041, 0.388415>, 
      <-0.265389, 0.869073, -0.544872>, <-0.260514, 0.866363, -0.264886>, <-0.288027, 0.863535, 0.105556>, <-0.283152, 0.860826, 0.385542>, 
      <-0.291770, 0.844958, -0.555286>, <-0.323598, 0.853647, -0.274764>, <-0.327152, 0.926855, 0.136450>, <-0.368739, 0.860513, 0.407836>, 
      <-0.313433, 0.833694, -0.556233>, <-0.345261, 0.842383, -0.275711>, <-0.377940, 0.928998, 0.107453>, <-0.419527, 0.862656, 0.378839>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.236299, -0.251129, -0.518357>, <-0.264247, -0.251129, -0.518357>, <-0.283855, -0.210272, -0.497186>, <-0.308904, -0.198809, -0.492472>, 
      <-0.236299, -0.246795, -0.577011>, <-0.264247, -0.246795, -0.577011>, <-0.283855, -0.204817, -0.560213>, <-0.308904, -0.193353, -0.555499>, 
      <-0.220632, -0.247006, -0.660978>, <-0.249535, -0.236651, -0.658710>, <-0.285998, -0.230642, -0.654220>, <-0.312550, -0.215632, -0.650046>, 
      <-0.217091, -0.214768, -0.710041>, <-0.245994, -0.204412, -0.707773>, <-0.286880, -0.195259, -0.706655>, <-0.313433, -0.180249, -0.702481>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.236299, -0.251129, -0.518357>, <-0.236299, -0.255849, -0.454485>, <-0.221239, -0.244747, -0.369746>, <-0.217091, -0.244636, -0.305834>, 
      <-0.264247, -0.251129, -0.518357>, <-0.264247, -0.255849, -0.454485>, <-0.251603, -0.244747, -0.369746>, <-0.247455, -0.244636, -0.305834>, 
      <-0.283855, -0.210272, -0.497186>, <-0.283855, -0.215397, -0.437984>, <-0.283922, -0.218895, -0.353118>, <-0.284852, -0.225705, -0.294094>, 
      <-0.308904, -0.198809, -0.492472>, <-0.308904, -0.203934, -0.433271>, <-0.312503, -0.208699, -0.354177>, <-0.313433, -0.215509, -0.295153>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.236299, -0.251129, -0.518357>, <-0.236299, -0.246795, -0.577011>, <-0.220632, -0.247006, -0.660978>, <-0.217091, -0.214768, -0.710041>, 
      <-0.199532, -0.251129, -0.518357>, <-0.199532, -0.246795, -0.577011>, <-0.192707, -0.236651, -0.658710>, <-0.189166, -0.204412, -0.707773>, 
      <-0.162512, -0.211807, -0.497817>, <-0.162512, -0.206351, -0.560844>, <-0.150545, -0.230372, -0.654145>, <-0.149662, -0.194988, -0.706580>, 
      <-0.128537, -0.198809, -0.492472>, <-0.128537, -0.193353, -0.555499>, <-0.124891, -0.215632, -0.650046>, <-0.124008, -0.180249, -0.702481>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.236299, -0.251129, -0.518357>, <-0.199532, -0.251129, -0.518357>, <-0.162512, -0.211807, -0.497817>, <-0.128537, -0.198809, -0.492472>, 
      <-0.236299, -0.255849, -0.454485>, <-0.199532, -0.255849, -0.454485>, <-0.162512, -0.216932, -0.438615>, <-0.128537, -0.203934, -0.433271>, 
      <-0.221239, -0.244747, -0.369746>, <-0.191804, -0.244747, -0.369746>, <-0.152593, -0.218726, -0.353135>, <-0.124938, -0.208699, -0.354177>, 
      <-0.217091, -0.244636, -0.305834>, <-0.187656, -0.244636, -0.305834>, <-0.151663, -0.225536, -0.294111>, <-0.124008, -0.215509, -0.295153>
    }
  }
  texture {
    Shiny_Red
  }
}
#declare EyeShield = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.561841, -0.125802, -0.186995>, <-0.561841, -0.115740, -0.106745>, <-0.561841, -0.102324, 0.000256>, <-0.561841, -0.092262, 0.080506>, 
      <-0.603819, -0.103466, -0.192789>, <-0.603819, -0.093404, -0.112538>, <-0.614029, -0.079471, -0.038698>, <-0.614029, -0.069409, 0.041553>, 
      <-0.654492, -0.083119, -0.232678>, <-0.654492, -0.073870, -0.186524>, <-0.654492, -0.060724, -0.090889>, <-0.654492, -0.051475, -0.044735>, 
      <-0.694199, -0.064826, -0.252256>, <-0.694199, -0.055577, -0.206102>, <-0.694199, -0.043244, -0.144564>, <-0.694199, -0.033995, -0.098410>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.419453, -0.211013, -0.214337>, <-0.419453, -0.194000, -0.118038>, <-0.419453, -0.171317, 0.010361>, <-0.419453, -0.154304, 0.106660>, 
      <-0.465483, -0.190627, -0.210996>, <-0.465483, -0.173615, -0.114697>, <-0.463161, -0.153690, 0.006953>, <-0.463161, -0.136677, 0.103252>, 
      <-0.517628, -0.149327, -0.180893>, <-0.517628, -0.139265, -0.100643>, <-0.526111, -0.117970, 0.026925>, <-0.526111, -0.107908, 0.107175>, 
      <-0.561841, -0.125802, -0.186995>, <-0.561841, -0.115740, -0.106745>, <-0.561841, -0.102324, 0.000256>, <-0.561841, -0.092262, 0.080506>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.313433, -0.235818, -0.205025>, <-0.314450, -0.222396, -0.113634>, <-0.315805, -0.204499, 0.008221>, <-0.316822, -0.191077, 0.099612>, 
      <-0.345463, -0.228942, -0.203748>, <-0.346479, -0.215520, -0.112357>, <-0.347611, -0.196726, 0.009679>, <-0.348628, -0.183304, 0.101070>, 
      <-0.389543, -0.224260, -0.216508>, <-0.389543, -0.207247, -0.120209>, <-0.389137, -0.183543, 0.012725>, <-0.389137, -0.166530, 0.109024>, 
      <-0.419453, -0.211013, -0.214337>, <-0.419453, -0.194000, -0.118038>, <-0.419453, -0.171317, 0.010361>, <-0.419453, -0.154304, 0.106660>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.217091, -0.254457, -0.222406>, <-0.217091, -0.239248, -0.126470>, <-0.217091, -0.218970, 0.001446>, <-0.217091, -0.203761, 0.097382>, 
      <-0.246988, -0.254457, -0.222406>, <-0.246988, -0.239248, -0.126470>, <-0.247259, -0.218970, 0.001446>, <-0.247259, -0.203761, 0.097382>, 
      <-0.284224, -0.242089, -0.206190>, <-0.285241, -0.228666, -0.114799>, <-0.286529, -0.211654, 0.006879>, <-0.287546, -0.198232, 0.098270>, 
      <-0.313433, -0.235818, -0.205025>, <-0.314450, -0.222396, -0.113634>, <-0.315805, -0.204499, 0.008221>, <-0.316822, -0.191077, 0.099612>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.124400, -0.125802, -0.186995>, <0.167257, -0.103065, -0.193754>, <0.218003, -0.082912, -0.236616>, <0.258118, -0.064530, -0.257882>, 
      <0.124400, -0.115740, -0.106745>, <0.167257, -0.093003, -0.113504>, <0.217595, -0.073751, -0.188774>, <0.257710, -0.055370, -0.210040>, 
      <0.124400, -0.102324, 0.000256>, <0.176588, -0.079471, -0.038698>, <0.217459, -0.060636, -0.092577>, <0.257166, -0.043155, -0.146252>, 
      <0.124400, -0.092262, 0.080506>, <0.176588, -0.069409, 0.041553>, <0.217051, -0.051475, -0.044735>, <0.256758, -0.033995, -0.098410>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.017988, -0.211013, -0.214337>, <0.028042, -0.190627, -0.210996>, <0.080258, -0.149221, -0.180033>, <0.124400, -0.125802, -0.186995>, 
      <-0.017988, -0.194000, -0.118038>, <0.028042, -0.173615, -0.114697>, <0.080258, -0.139159, -0.099783>, <0.124400, -0.115740, -0.106745>, 
      <-0.017988, -0.171317, 0.010361>, <0.025720, -0.153690, 0.006953>, <0.088670, -0.117970, 0.026925>, <0.124400, -0.102324, 0.000256>, 
      <-0.017988, -0.154304, 0.106660>, <0.025720, -0.136677, 0.103252>, <0.088670, -0.107908, 0.107175>, <0.124400, -0.092262, 0.080506>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.124008, -0.235818, -0.205025>, <-0.092003, -0.228835, -0.203728>, <-0.047898, -0.224260, -0.216508>, <-0.017988, -0.211013, -0.214337>, 
      <-0.122991, -0.222396, -0.113634>, <-0.090986, -0.215412, -0.112337>, <-0.047898, -0.207247, -0.120209>, <-0.017988, -0.194000, -0.118038>, 
      <-0.121636, -0.204499, 0.008221>, <-0.089860, -0.196606, 0.009702>, <-0.048304, -0.183543, 0.012725>, <-0.017988, -0.171317, 0.010361>, 
      <-0.120619, -0.191077, 0.099612>, <-0.088844, -0.183184, 0.101093>, <-0.048304, -0.166530, 0.109024>, <-0.017988, -0.154304, 0.106660>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.124008, -0.235818, -0.205025>, <-0.122991, -0.222396, -0.113634>, <-0.121636, -0.204499, 0.008221>, <-0.120619, -0.191077, 0.099612>, 
      <-0.152273, -0.241985, -0.206171>, <-0.151256, -0.228563, -0.114779>, <-0.149944, -0.211531, 0.006902>, <-0.148927, -0.198109, 0.098293>, 
      <-0.188138, -0.254457, -0.222406>, <-0.188138, -0.239248, -0.126470>, <-0.187893, -0.218970, 0.001446>, <-0.187893, -0.203761, 0.097382>, 
      <-0.217091, -0.254457, -0.222406>, <-0.217091, -0.239248, -0.126470>, <-0.217091, -0.218970, 0.001446>, <-0.217091, -0.203761, 0.097382>
    }
  }
  texture {
    GrayGlass
  }
}
#declare HelmetDone = union {
  object { FacePlate }
  object { Ears }
  object { FaceSock }
  object { EyeShield }
  no_shadow
  scale 0.82
  translate  <0.213141, -0.222574, 0.554384>
}
#declare FlashLight = union {
  torus { // FlashEdge
    1.15, 0.85  rotate -x*90
    texture {
      Shiny_Black
    }
    scale <0.4, 0.4, 0.13>
    translate  <-0.31349, -0.091241, 0.314539>
  }
  sphere { // FlashRnd
    <0,0,0>,1
    texture {
      Shiny_Black
    }
    scale 0.3
    translate  <0.0, 0.0, 5.0>
  }
  cylinder { // FlashLightBody
    <0,0,1>, <0,0,0>, 1 
    texture {
      Plastic_Black
    }
    scale <0.3, 0.3, 5.0>
  }
  cylinder { // FlashLightBody1
    <0,0,1>, <0,0,0>, 1 
    texture {
      Plastic_Black
    }
    scale <0.3, 0.3, 5.0>
    translate  <-0.577122, 0.156536, 0.0>
  }
  cylinder { // FlashLightBody2
    <0,0,1>, <0,0,0>, 1 
    texture {
      Plastic_Black
    }
    scale <0.3, 0.3, 5.0>
    translate  <-0.41575, -0.423151, -0.0>
  }
  sphere { // FlashRnd1
    <0,0,0>,1
    texture {
      BrightLight_5
    }
    scale <0.3, 0.3, 0.04076>
    translate  <-0.0, 0.0, -0.003347>
  }
  no_shadow
  scale 0.090909
  rotate <-90.0, 50.0, 0.0>
  translate  <0.429628, -0.26483, 0.833734>
}
#declare SmallStand3 = union {
  cylinder { // SmStandBase2
    <0,0,1>, <0,0,0>, 1 
    texture {
      Plastic_Black
    }
    scale <2.0, 2.0, 0.3>
    translate  <100.0, 100.0, 100.0>
  }
  cylinder { // SmStandArm2
    <0,0,1>, <0,0,0>, 1 
    texture {
      Plastic_Black
    }
    scale <0.3, 0.3, 4.0>
    translate  <100.0, 100.0, 100.0>
  }
  sphere { // SmallStandTop2
    <0,0,0>,1
    texture {
      Plastic_Black
    }
    scale <0.355131, 0.307006, 0.41288>
    translate  <100.0, 100.0, 104.0>
  }
  scale 0.30303
  rotate <-0.0, -0.0, -90.0>
  translate  <-30.292354, 30.397675, -30.654619>
}
union { // HelmetDisplay
  object { PanelDone }
  object { // TransmitNode4->TransmitNode1
    TransmitNode1
    rotate -180.0*z
    translate  0.0*x
  }
  object { // TransmitNode3->TransmitNode1
    TransmitNode1
    rotate 90.0*z
    translate  0.0*x
  }
  object { // TransmitNode2->TransmitNode1
    TransmitNode1
    rotate -90.0*z
  }
  object { TransmitNode1 }
  object { SmBaseDone }
  object { CornerStand1 }
  object { // CornerStand2->CornerStand1
    CornerStand1
    translate  <1.535, 0.0, 0.0>
  }
  object { // CornerStand3->CornerStand1
    CornerStand1
    translate  <0.0, -0.535, 0.0>
  }
  object { // CornerStand4->CornerStand1
    CornerStand1
    rotate -0.0*z
    translate  <1.535, -0.535, 0.0>
  }
  object { Projectors }
  object { TransmitNode5 }
  object { // TransmitNode6->TransmitNode5
    TransmitNode5
    rotate <-0.0, 0.0, 90.0>
    translate  0.0*y
  }
  object { // TransmitNode7->TransmitNode5
    TransmitNode5
    rotate -90.0*z
    translate  0.0*y
  }
  object { // TransmitNode8->TransmitNode5
    TransmitNode5
    rotate -180.0*z
    translate  0.0*y
  }
  object { StandCut }
  torus { // HelmetCord2
    1.85, 0.15  rotate -x*90
    texture {
      Shiny_Black
    }
    scale 0.106061
    rotate <-62.830261, -0.0, -90.0>
    translate  <-0.282281, -0.021763, 0.89818>
  }
  torus { // HelmetCord1
    1.85, 0.15  rotate -x*90
    texture {
      Shiny_Blue
    }
    scale 0.106061
    rotate <-68.904305, -0.0, -90.0>
    translate  <-0.238658, -0.021763, 0.949118>
  }
  torus { // HelmetCord
    1.85, 0.15  rotate -x*90
    texture {
      Shiny_Black
    }
    scale 0.106061
    rotate <-54.222912, 0.0, -90.0>
    translate  <-0.309468, -0.021763, 0.813865>
  }
  sphere { // Glowball
    <0,0,0>,1
    texture {
      BrightLightYellow
    }
    no_shadow
    scale <0.3, 0.316476, 0.210488>
    rotate -90.0*z
    translate  <0.03, 0.13463, 0.920743>
  }
  object { HelmetDone }
  object { FlashLight }
  object { SmallStand3 }
  scale 3.3
  rotate 90.0*z
  translate  <150.165055, 71.50467, 110.0>
}


#declare DisplayPad = difference {
  box { // DisplayCase
    <-1, -1, -1>, <1, 1, 1>
    scale <18.0, 8.0, 1.8>
    rotate -0.0*z
    translate  <100.649682, 111.5138, 95.66879>
  }
  box { // BaseCut
    <-1, -1, -1>, <1, 1, 1>
    scale <19.0, 8.0, 1.5>
    rotate <11.0, 0.0, -0.0>
    translate  <100.649682, 110.981291, 97.473406>
  }
  texture {
    Iron
  }
}
#declare GlassCaseEdges = merge {
  cylinder { // Edge1
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 4.23>
    translate  <82.483282, 103.381389, 94.058047>
  }
  sphere { // Corner1
    <0,0,0>,1
    scale 0.1
    translate  <82.48204, 103.379876, 98.288803>
  }
  cylinder { // Edge2
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 4.23>
    translate  <118.78328, 103.381389, 94.058047>
  }
  sphere { // Corner2
    <0,0,0>,1
    scale 0.1
    translate  <118.78204, 103.379876, 98.288803>
  }
  cylinder { // Edge3
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 4.23>
    translate  <82.483282, 119.681389, 94.058047>
  }
  sphere { // Corner3
    <0,0,0>,1
    scale 0.1
    translate  <82.48204, 119.679876, 98.288803>
  }
  sphere { // Corner4
    <0,0,0>,1
    scale 0.1
    translate  <118.78204, 119.679876, 98.288803>
  }
  cylinder { // Edge4
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 4.23>
    translate  <118.783282, 119.681389, 94.058047>
  }
  cylinder { // Edge5
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 36.299999>
    rotate <0.0, 90.0, -0.0>
    translate  <82.483282, 103.380427, 98.287696>
  }
  cylinder { // Edge6
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 36.299999>
    rotate <0.0, 90.0, -0.0>
    translate  <82.483282, 119.679796, 98.287696>
  }
  cylinder { // Edge7
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 16.299999>
    rotate 90.0*x
    translate  <82.483282, 119.681389, 98.289723>
  }
  cylinder { // Edge8
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 16.299999>
    rotate 90.0*x
    translate  <118.783282, 119.681389, 98.289723>
  }
  texture {
    Plastic_Black
  }
  scale 0.99
  translate  <1.0, 1.101853, 1.012513>
}
#declare Sticker = union {
  object { Sticker_power }
  cone { // StickerPoint
    <0,0,0>, 1.0, <0,0,1>, 0.0
    texture {
      Bumpy_Black_Stone
    }
    scale <0.1, 0.1, 4.0>
    translate  2.003083*z
  }
  cylinder { // StickerCore
    <0,0,1>, <0,0,0>, 1 
    texture {
      Bumpy_Black_Stone
    }
    scale <0.1, 0.1, 2.0>
  }
  object { // Sticker_power1->Sticker power
    Sticker_power
    rotate -36.0*z
    translate  0.3*z
  }
  object { // Sticker_power2->Sticker power
    Sticker_power
    rotate -72.0*z
    translate  0.6*z
  }
  object { // Sticker_power3->Sticker power
    Sticker_power
    rotate -108.0*z
    translate  0.9*z
  }
  object { // Sticker_power4->Sticker power
    Sticker_power
    rotate -144.0*z
    translate  1.2*z
  }
  object { // Sticker_power5->Sticker power
    Sticker_power
    rotate 180.0*z
    translate  1.5*z
  }
  object { // Sticker_power6->Sticker power
    Sticker_power
    rotate 144.0*z
    translate  1.8*z
  }
  object { // Sticker_power7->Sticker power
    Sticker_power
    rotate 108.0*z
    translate  2.1*z
  }
  object { // Sticker_power8->Sticker power
    Sticker_power
    rotate 72.0*z
    translate  2.4*z
  }
  object { // Sticker_power9->Sticker power
    Sticker_power
    rotate 36.0*z
    translate  2.7*z
  }
  object { // Sticker_power10->Sticker power
    Sticker_power
    rotate -0.0*z
    translate  3.0*z
  }
  object { // Sticker_power11->Sticker power
    Sticker_power
    rotate -36.0*z
    translate  3.3*z
  }
  object { // Sticker_power12->Sticker power
    Sticker_power
    rotate -72.0*z
    translate  3.6*z
  }
  object { // Sticker_power13->Sticker power
    Sticker_power
    rotate -108.0*z
    translate  3.9*z
  }
  box { // Stand2
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Aluminum
    }
    scale <0.2, 0.3, 0.03>
    rotate <1.2, 0.0, 9.0>
    translate  <0.014437, 0.280385, 0.839798>
  }
  sphere { // Stickerend
    <0,0,0>,1
    texture {
      Bumpy_Black_Stone
    }
    scale <0.1, 0.1, 0.05>
  }
  box { // Stand1
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Aluminum
    }
    scale <0.2, 0.3, 0.03>
    rotate <1.21045, 0.060017, 9.009856>
    translate  <0.014437, 0.280385, 3.265909>
  }
  scale 3.0
  rotate <-79.0, 0.0, -49.0>
  translate  <100.181295, 106.432668, 96.048223>
}
#declare DataCrystals = union {
  object { DataCrystal }
  object { // DataCrystal1->DataCrystal
    DataCrystal
    rotate -36.0*z
  }
  object { // DataCrystal2->DataCrystal
    DataCrystal
    rotate -72.0*z
  }
  object { // DataCrystal3->DataCrystal
    DataCrystal
    rotate -108.0*z
  }
  box { // Slot
    <-1, -1, -1>, <1, 1, 1>
    texture {
      FoggyLight
    }
    scale <1.35, 0.1, 0.8>
    rotate -9.0*z
    translate  0.2*z
  }
  rotate 11.0*x
  translate  <95.992118, 116.186271, 97.764543>
}
#declare CubeAntenna = merge {
  cone { // Wand3
    <0,0,0>, 1.0, <0,0,1>, 0.6
    scale <0.2, 0.2, 3.0>
    rotate -68.638657*y
    translate  <3.112301, 0.0, -2.678591>
  }
  sphere { // joint4
    <0,0,0>,1
    scale 0.5
    translate  <3.366654, 0.0, -2.798744>
  }
  cylinder { // Wand4
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 2.0>
    translate  <0.334686, 0.0, -1.509804>
  }
  sphere { // joint3
    <0,0,0>,1
    scale 0.2
    translate  <0.335906, 0.0, 0.490069>
  }
  sphere { // joint2
    <0,0,0>,1
    scale 0.2
    translate  <0.335278, 0.0, -1.509764>
  }
  cone { // WandTip
    <0,0,0>, 1.0, <0,0,1>, 0.0
    scale <0.2, 0.2, 6.5>
    translate  <-1.5, 0.0, 1.35>
  }
  cylinder { // Wand2
    <0,0,1>, <0,0,0>, 1 
    scale <0.135, 0.1, 1.961621>
    rotate <180.0, 68.0, 180.0>
    translate  <-1.534058, 0.0, 1.299227>
  }
  sphere { // joint1
    <0,0,0>,1
    scale 0.2
    translate  <-1.5, 0.0, 1.35>
  }
  texture {
    Aluminum
  }
  scale 0.65
  rotate <38.502151, -0.0, 0.0>
  translate  <7.503802, -5.110406, -0.400597>
}
#declare Cubething = union {
  object { // BumpsDone2->BumpsDone
    BumpsDone
    rotate <-0.0, 18.981913, 90.0>
    translate  <7.290911, -6.428545, 0.0>
  }
  box { // Block1
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Spun_Brass1
    }
    scale <2.5, 2.5, 0.5>
    translate  <7.3276, 0.0, 2.064727>
  }
  sphere { // Btn2
    <0,0,0>,1
    texture {
      Aluminum
    }
    translate  <8.549257, -3.230671, -3.865001>
  }
  sphere { // Btn1
    <0,0,0>,1
    texture {
      Aluminum
    }
    translate  <7.882402, -3.164306, -2.939929>
  }
  object { // BumpsDone1->BumpsDone
    BumpsDone
    rotate <180.0, -27.954195, 180.0>
    translate  <11.488896, 0.0, -6.545265>
  }
  object { BumpsDone }
  sphere { // Btn
    <0,0,0>,1
    texture {
      Shiny_Red
    }
    translate  <9.825052, -3.164306, 1.3154>
  }
  object { CubeAntenna }
  box { // Block
    <-1, -1, -1>, <1, 1, 1>
    texture {
      FoggyLight
    }
    scale 4.0
    translate  <7.3276, 0.0, -1.857904>
  }
  scale 0.33
  rotate <-79.0, -0.0, -0.0>
  translate  <93.930182, 109.016021, 96.910049>
}
#declare RodBtns = union {
  box { // Flat
    <-1, -1, -1>, <1, 1, 1>
    scale <1.202953, 0.230007, 1.203602>
    translate  <-0.001297, -0.447813, -1.223877>
  }
  sphere { // Nub1
    <0,0,0>,1
    scale 0.197556
    translate  <0.0, -0.349543, -0.349533>
  }
  sphere { // Nub2
    <0,0,0>,1
    scale 0.197556
    translate  <0.0, -0.366768, -0.849047>
  }
  sphere { // Nub3
    <0,0,0>,1
    scale 0.197556
    translate  <-0.432653, -0.349543, -1.654736>
  }
  sphere { // Nub4
    <0,0,0>,1
    scale 0.197556
    translate  <0.305402, -0.349543, -1.400234>
  }
  torus { // Rimcut
    1.8, 0.2  rotate -x*90
    scale <0.565625, 1.744372, 0.7>
    rotate -90.0*x
  }
  texture {
    Plastic_Black
  }
}
#declare GreetingCut = difference {
  superellipsoid { // RodBase
    <0.1, 1.0>
    texture {
      Chrome__kindaDull_
    }
    scale <1.0, 0.546495, 2.930663>
  }
  object { RodBtns }
}
#declare GreetingDone = union {
  cone { // Lip1
    <0,0,0>, 0.6, <0,0,1>, 1.0
    open
    texture {
      Aluminum
    }
    hollow
    scale 0.4
    rotate 90.0*x
    translate  <0.0, -0.234542, 1.25089>
  }
  cone { // Lip2
    <0,0,0>, 0.6, <0,0,1>, 1.0
    open
    texture {
      BrightLight_5
    }
    hollow
    scale 0.4
    rotate -90.0*x
    translate  <-0.461117, -0.585762, 0.551141>
  }
  cone { // Lip3
    <0,0,0>, 0.6, <0,0,1>, 1.0
    open
    texture {
      Aluminum
    }
    hollow
    scale 0.4
    rotate -90.0*x
    translate  <-0.07205, -0.585762, 0.88257>
  }
  cone { // Lip4
    <0,0,0>, 0.6, <0,0,1>, 1.0
    open
    texture {
      CorkWhite
    }
    hollow
    scale <0.35, 0.35, 0.6>
    rotate 90.0*x
    translate  <0.504347, -0.070284, 0.003564>
  }
  sphere { // Nub6
    <0,0,0>,1
    texture {
      Aluminum
    }
    scale 0.197556
    translate  <0.171755, -0.070842, -2.040547>
  }
  object { GreetingCut }
  sphere { // Nub5
    <0,0,0>,1
    texture {
      BlueWax
    }
    scale 0.197556
    translate  <-0.412212, -0.070842, -1.078719>
  }
  rotate -79.0*x
  translate  <86.624575, 113.568642, 97.026826>
}
#declare Labels = union {
  box { // LabelBack1
    <-1, -1, -1>, <1, 1, 1>
    texture {
      NamePahser
      scale <2.0, 2.0, 1.0>
      translate <-1.000000, -1.000000, 0.000000>
    }
    scale <5.0, 0.6, 0.1>
    translate  <4.956114, -13.604147, -0.299618>
  }
  box { // LabelBack2
    <-1, -1, -1>, <1, 1, 1>
    texture {
      NameData
      scale <2.0, 2.0, 1.0>
      translate <-1.000000, -1.000000, 1.000000>
    }
    scale <5.0, 0.6, 0.1>
    translate  <23.666955, -5.146124, -0.306382>
  }
  box { // LabelCube
    <-1, -1, -1>, <1, 1, 1>
    texture {
      NameCube
      scale <2.0, 2.0, 1.0>
      translate <-1.000000, -1.000000, 1.000000>
    }
    scale <5.0, 0.6, 0.1>
    translate  <23.666955, -23.545441, -0.294812>
  }
  box { // LabelStick
    <-1, -1, -1>, <1, 1, 1>
    texture {
      NameWand
      scale <2.0, 2.0, 1.0>
      translate <-1.000000, -1.000000, 1.000000>
    }
    scale <5.0, 0.6, 0.1>
    translate  <43.663272, -23.545441, -0.294812>
  }
  box { // LabelStick1
    <-1, -1, -1>, <1, 1, 1>
    texture {
      NameSig
      scale <2.0, 2.0, 1.0>
      translate <-1.000000, -1.000000, 1.000000>
    }
    scale <5.0, 0.6, 0.1>
    translate  <58.232018, -23.545441, -0.294812>
  }
  scale 0.5
  rotate 11.0*x
  translate  <84.030491, 117.242465, 97.366205>
}
#declare Artifacts = union {
  object { Sticker }
  object { DataCrystals }
  object { Cubething }
  object { GreetingDone }
  object { Labels }
}
#declare StandCutPieces1 = union {
  cylinder { // CutBtm2
    <0,0,1>, <0,0,0>, 1 
    translate  0.6*x
  }
  box { // Cutmiddle2
    <-1, -1, -1>, <1, 1, 1>
    scale <1.8, 0.986223, 0.5>
    translate  <2.4, 0.0, 0.5>
  }
  cylinder { // CutTop2
    <0,0,1>, <0,0,0>, 1 
    translate  4.2*x
  }
  object { // CutBtm3->CutBtm
    CutBtm
    translate  <9.0, 0.0, 0.0>
  }
  object { // Cutmiddle3->Cutmiddle
    Cutmiddle
    translate  9.0*x
  }
  object { // CutTop3->CutTop
    CutTop
    translate  9.0*x
  }
  scale <1.0, 1.3, 2.2>
  rotate <-0.0, 90.0, -90.0>
  translate  <91.14922, 91.06532, 104.164025>
}
#declare StandCut1 = difference {
  box { // SmallDisplayPost1
    <-1, -1, -1>, <1, 1, 1>
    scale <2.64, 0.99, 12.0>
    translate  <91.131964, 89.953155, 95.797948>
  }
  object { StandCutPieces1 }
  texture {
    Plastic_Black
  }
  scale <1.8, 0.6, 0.6>
  rotate <0.0, -0.0, -90.0>
  translate  <31.030787, 275.75657, 29.768446>
}
#declare StandCutPieces2 = union {
  cylinder { // CutBtm4
    <0,0,1>, <0,0,0>, 1 
    translate  0.6*x
  }
  box { // Cutmiddle4
    <-1, -1, -1>, <1, 1, 1>
    scale <1.8, 0.986223, 0.5>
    translate  <2.4, 0.0, 0.5>
  }
  cylinder { // CutTop4
    <0,0,1>, <0,0,0>, 1 
    translate  4.2*x
  }
  object { // CutBtm5->CutBtm
    CutBtm
    translate  <9.0, 0.0, 0.0>
  }
  object { // Cutmiddle5->Cutmiddle
    Cutmiddle
    translate  9.0*x
  }
  object { // CutTop5->CutTop
    CutTop
    translate  9.0*x
  }
  scale <1.0, 1.3, 2.2>
  rotate <-0.0, 90.0, -90.0>
  translate  <91.14922, 91.06532, 104.164025>
}
#declare StandCut2 = difference {
  box { // SmallDisplayPost2
    <-1, -1, -1>, <1, 1, 1>
    scale <2.64, 0.99, 12.0>
    translate  <91.131964, 89.953155, 95.797948>
  }
  object { StandCutPieces2 }
  texture {
    Plastic_Black
  }
  scale <1.8, 0.6, 0.6>
  rotate <0.0, -0.0, -90.0>
  translate  <61.320125, 275.75657, 29.768446>
}
#declare S1 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  11  // control points
  <-1.0, -1.0>,
  <1.0, -1.0>,
  <1.0, -0.799687>,
  <-0.5577, 0.710485>,
  <2.5956, 0.710485>,
  <2.875796, 0.976526>,
  <-0.926478, 0.976526>,
  <-0.930133, 0.757433>,
  <0.677152, -0.807512>,
  <-1.0, -0.807512>,
  <-1.0, -1.0>
  rotate -x*90
  texture {
    SigRed
  }
}
#declare L1 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  10  // control points
  <2.5956, 0.710485>,
  <1.003777, -0.796667>,
  <1.006157, -1.007512>,
  <3.003491, -1.010638>,
  <3.002266, -0.788267>,
  <1.450215, -0.788716>,
  <2.999068, 0.727934>,
  <3.007532, 0.973396>,
  <2.852321, 0.976526>,
  <2.5956, 0.710485>
  rotate -x*90
  texture {
    Sig_Green
  }
}
#declare Signature7 = union {
  object { S1 }
  object { L1 }
  scale <1.0, 1.0, 0.3>
  rotate <11.0, 0.0, -0.0>
  translate  <111.94681, 107.890975, 95.340261>
}
union { // DisplayCaseDone
  box { // DisplayGlass2
    <-1, -1, -1>, <1, 1, 1>
    texture {
      TransGlass
    }
    scale <0.1, 8.15, 2.1>
    translate  <118.765759, 111.54047, 96.181631>
  }
  box { // DisplayGlass1
    <-1, -1, -1>, <1, 1, 1>
    texture {
      TransGlass
    }
    scale <0.1, 8.2, 2.1>
    translate  <82.510388, 111.54047, 96.181631>
  }
  object { DisplayPad }
  box { // DisplayGlass3
    <-1, -1, -1>, <1, 1, 1>
    texture {
      TransGlass
    }
    scale <18.15, 0.1, 2.1>
    translate  <100.640005, 119.637008, 96.181631>
  }
  box { // DisplayGlass4
    <-1, -1, -1>, <1, 1, 1>
    texture {
      TransGlass
    }
    scale <18.15, 0.1, 2.1>
    translate  <100.640005, 103.411595, 96.181631>
  }
  object { GlassCaseEdges }
  object { Artifacts }
  object { StandCut1 }
  object { StandCut2 }
  box { // StandFoot
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Plastic_Black
    }
    scale <3.5, 6.145478, 0.618854>
    translate  <86.624012, 111.935114, 80.593813>
  }
  box { // StandFoot1
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Plastic_Black
    }
    scale <3.5, 6.145478, 0.618854>
    translate  <113.837728, 111.935114, 80.593813>
  }
  object { Signature7 }
  translate  <25.803864, 2.356931, 0.0>
}


