/*------------------------------------------------------------------------------
  Script   : FirstEncounterK.pov pour IRTC, Novembre-dcembre 1998
  Titre    : "Tu veux jouer avec moi ?"
  Date     : 21-Nov-1998
  Auteur   : Fab
------------------------------------------------------------------------------*/
//#declare RenderLite = 1           // - Dcommenter pour allger les temps de rendu (arealights, smooth, blur...) -
//#declare RenderMedium = 1         // - Dcommenter pour allger les temps de rendu (blur...) -
//#declare VisuPorteDePres = 1      // - Dcommenter pour ne voir que la porte et de pres -
  #declare NoSmoothHF = 1           // - Dcommenter pour enlever le smooth des height fields - 

#declare Epsilon = 1E-6
#declare Transparent = color red 1.00 green 1.00 blue 1.00 filter 1.00
#declare Blanc = color red 1.0 green 1.0 blue 1.0
#declare Noir = color red 0.0 green 0.0 blue 0.0

#declare MursCol1 = color red 0.50 green 0.90 blue 0.70
#declare MursCol2 = color red 0.75 green 0.45 blue 0.20
#declare MursCol3 = color red 0.75 green 0.65 blue 0.20
#declare Pigment1 = pigment {
  marble turbulence 0.8 lambda 4 
  color_map {
    [0.35 color MursCol1]
    [0.43 color MursCol2]
    [0.57 color MursCol2]
    [0.65 color MursCol1] } }
#declare Pigment2 = pigment {
  marble turbulence 0.8 lambda 4.5 translate <100,0,0>
  color_map {
    [0.40 color Transparent]
    [0.50 color MursCol3 filter 0.20]
    [0.70 color Transparent] } }
#declare MursTex = 
  texture { pigment { Pigment1 scale <40,12,1> } finish { ambient 0.1 diffuse 0.5 } }
  texture { pigment { Pigment2 scale <40,12,1> } finish { ambient 0.1 diffuse 0.7 specular 0.50 roughness 0.10 } }
#declare MursFondTex = 
  texture { pigment { Pigment1 scale <40,12,1> rotate <0,90,0> } finish { ambient 0.1 diffuse 0.5 } }
  texture { pigment { Pigment2 scale <40,12,1> rotate <0,90,0> } finish { ambient 0.1 diffuse 0.4 specular 0.50 roughness 0.06 } }
#declare SolTex =
  texture { pigment { Pigment1 scale <40,12,1> rotate <0,0,90> } finish { ambient 0.1 diffuse 0.3 } }
  texture { pigment { Pigment2 scale <40,12,1> rotate <0,0,90> } finish { ambient 0.1 diffuse 0.2 specular 0.20 roughness 0.03 } }
#declare PlafondTex =
  texture { pigment { Pigment1 scale <40,12,1> rotate <0,0,90> } finish { ambient 0.1 diffuse 0.5 } }
  texture { pigment { Pigment2 scale <40,12,1> rotate <0,0,90> } finish { ambient 0.1 diffuse 0.4 specular 0.50 roughness 0.06 } }

#declare MetalCol = color red 0.50 green 0.50 blue 0.50
#declare MetalSupport = texture { 
  pigment { color MetalCol }
  normal { dents 0.20 scale <0.02, 0.2, 0.02> }
  normal { bumps 0.07 scale <2, 8, 2> turbulence 0.60 }
  finish { ambient 0.15 diffuse 0.6 reflection 0.50 specular 0.85 roughness 0.08 metallic } }
#declare MetalPorte = texture { 
  pigment { color MetalCol }
  normal { bumps 0.03 turbulence 0.20 scale <4, 8, 3> }
  finish { ambient 0.15 diffuse 0.6 reflection 0.20 specular 0.40 roughness 0.01 metallic } }

#declare MLarg = 50
#declare MHaut = 90
#declare MLong = 120
#declare MElevS = 1.8
#declare MElevM = 3.6
#declare PosFondFond = 500
#declare UnitForme = union {
  // --- Le sol : il est un peu plus large pour les jointures et plus lisse ---
  object {
    height_field {
      gif "FirstEncounterKMur1.gif"
      #ifndef(NoSmoothHF)
        smooth
      #end
      translate <-0.5, 0, 0> scale <MLarg*1.05, MElevS, MLong> translate <0,-MHaut/2,0> }
    texture { SolTex } }
  // --- Le plafond : pareil que le sol ---
  object {
    height_field {
      gif "FirstEncounterKMur4.gif"
      #ifndef(NoSmoothHF)
        smooth
      #end
      translate <-0.5,0,0> scale <MLarg*1.05, MElevM, MLong> rotate <0,0,180> translate <0,MHaut/2,0> }
    texture { PlafondTex } }
  // --- Les deux mrs ---
  object {
    union {
      // --- Le mur de gauche : un peu plus haut pour les jointures ---
      height_field {
        gif "FirstEncounterKMur2.gif"
        #ifndef(NoSmoothHF)
          smooth
        #end
        translate <-0.5,0,0> scale <MHaut*1.05, MElevM, MLong> rotate <0,0,-90> translate <-MLarg/2,0,0> }
      // --- Le mur de droite : pareil que celui de gauche ---
      height_field {
        gif "FirstEncounterKMur3.gif"
        #ifndef(NoSmoothHF)
          smooth
        #end
        translate <-0.5,0,0> scale <MHaut*1.05, MElevM, MLong> rotate <0,0,90> translate <MLarg/2,0,0> } }
    texture { MursTex } } }

#declare CHaut = 60
#declare CLarg = 36
#declare CEpa = 2.2
#declare PorteEpa = 5
#declare PorteOuvert = 8
#declare BarreH = difference {
  cylinder { <-CLarg, 0, 0>, <CLarg, 0, 0>, CEpa }
  plane { <1, 0, 0>, 0 rotate <0, 0, 45> translate <-CLarg/2, 0, 0> }
  plane { <1, 0, 0>, 0 inverse rotate <0, 0, -45> translate <CLarg/2, 0, 0> }
  translate <0, CHaut/2, 0> }
#declare BarreV = difference {
  cylinder { <-CHaut, 0, 0>, <CHaut, 0, 0>, CEpa }
  plane { <1, 0, 0>, 0 rotate <0, 0, 45> translate <-CHaut/2, 0, 0> }
  plane { <1, 0, 0>, 0 inverse rotate <0, 0, -45> translate <CHaut/2, 0, 0> }
  rotate <0, 0, 90> translate <-CLarg/2, 0, 0> }

#declare BattantGauche = object {
  prism {
    linear_sweep linear_spline -PorteEpa, 0, 14
    <0.00, 0.00>, <0.65, 0.00>, <0.65, 0.10>, <0.30, 0.20>, <0.30, 0.30>, <0.65, 0.40>, <0.65, 0.50>, <0.30, 0.60>,
    <0.30, 0.70>, <0.65, 0.80>, <0.65, 0.90>, <0.30, 1.00>, <0.00, 1.00>, <0.00, 0.00>
    rotate <-90, 0, 0> translate <-0.5, -0.5, 0> scale <CLarg, CHaut, 1> }
  texture { MetalPorte finish { diffuse 0.3 } } }
#declare BattantDroit = object {
  prism {
    linear_sweep linear_spline -PorteEpa, 0, 14
    <0.65, 0.00>, <0.65, 0.10>, <0.30, 0.20>, <0.30, 0.30>, <0.65, 0.40>, <0.65, 0.50>, <0.30, 0.60>, <0.30, 0.70>,
    <0.65, 0.80>, <0.65, 0.90>, <0.30, 1.00>, <1.00, 1.00>, <1.00, 0.00>, <0.65, 0.00>
    rotate <-90, 0, 0> translate <-0.5, -0.5, 0> scale <CLarg, CHaut, 1> }
  texture { MetalPorte finish { diffuse 0.3 } } }
#declare Cadre = union {
  object {
    union {
      object { BarreH }
      object { BarreH rotate <180, 0, 0> }
      object { BarreV }
      object { BarreV rotate <0, 180, 0> }
      // --- Une petite rotation vers l'avant, car le height_field est plus loin en bas qu'en haut... ---
      //rotate <-5, 0, 0>
      }
    texture { MetalSupport } }
  // --- Les deux battants sont inverss pour position le trou de droite en haut. J'aime mieux le perso sur la droite. ---
  union {
    object { BattantGauche translate <-PorteOuvert, 0, 0> }
    object { BattantDroit translate <PorteOuvert, 0, 0> }
    // --- Le fait d'ouvrir fait apparaitre les bords dans le height_field du mur... ---
    clipped_by { box { <-CLarg/2, -CHaut/2, -10>, <CLarg/2, CHaut/2, 10> } }
    scale <-1, 1, 1> } }

// --- Le personnage du fond, derrire la porte ---
#include "FirstEncounterKPerso.inc"
#declare PorteHaut = 15
#declare MurFond = union {
  object {
    difference {
      height_field {
        gif "FirstEncounterKMur4.gif"
        #ifndef(NoSmoothHF)
          smooth
        #end
        translate <-0.5, 0, -0.5> scale <MLarg * 1.10, MElevM, MHaut * 1.10> rotate <-90, 0, 0> }
      // --- Le trou pour la porte ---
      box { <-CLarg/2,-CHaut/2,-100>,<CLarg/2,CHaut/2,1000> translate <0, -(MHaut / 2 - CHaut / 2) + CEpa / 2 + PorteHaut, 0> } }
    texture { MursFondTex } }
  union {
    object { Cadre translate <0, -(MHaut/2-CHaut/2)+CEpa/2, -MElevM*0.3> }
    object { PersonnageHabille scale 2.6 rotate <0, 0, 17> translate <5.8, -5.0, 10> }
    translate <0, PorteHaut, 0> } }

#declare MurDerriereLaPorte = object {
  height_field {
    gif "FirstEncounterKMur4.gif"
    translate <-0.5, 0, -0.5> scale <MLarg*1.5, MElevM*1.5, MHaut> rotate <-90,0,0> }
  texture { MursFondTex } }

// --- Un mur qui se verra dans les reflets de la porte ---
#declare MurDerriereLaCamera = object {
  height_field {
    gif "FirstEncounterKMur4.gif"
    translate <-0.5, 0, -0.5> scale <MLarg*1.5, MElevM*1.5, MHaut> rotate <90,0,0> }
  texture { MursFondTex } }

/* --- Trois units les unes derrire les autres pour former le couloir : l'unit de base va selon z de 0 vers MLong. --- */
#declare MurFondPosZ = 3 * MLong - MElevM * 4
#declare Murs = union {
  #ifndef(VisuPorteDePres)
    object { UnitForme }
    object { UnitForme scale <1, 1, -1> translate <0, 0, 2 * MLong - Epsilon> }
    object { UnitForme translate <0, 0, 2 * MLong> }
    object { MurDerriereLaPorte translate <0, 0, PosFondFond> }
    object { MurDerriereLaCamera translate <0, 0, -MLong/2> }
  #end
  object { MurFond translate <0, 0, MurFondPosZ> }
 }

/* --- Les arcades mtalliques --- */
#declare OAngle = 15
#declare OLarg = 32
#declare REpa = 5
#declare Outils = difference {
  box { <-1000,0,-2*REpa>,<1000,100,2*REpa> }
  plane { <1,0,0>,0 rotate <0,0,OAngle> translate <-OLarg/2,0,0> }
  plane { <1,0,0>,0 inverse rotate <0,0,-OAngle> translate <OLarg/2,0,0> } }
#declare RHaut1 = 3
#declare RHaut2 = 15
#declare DemiRenfort = difference {
  box { <-1000,0,-REpa>,<1000,RHaut2,REpa> }
  object { Outils translate <0,RHaut1,0> }
  translate <0,-MHaut/2-0.1,0> }
#declare RDia = 4
#declare Colonne = cylinder { <0,-100,0>,<0,100,0>,RDia }
/* --- Une arcade compte --- */
#declare Renfort = object {
  union {
    object { DemiRenfort }
    object { DemiRenfort rotate <180,0,0> }
    object { Colonne translate <-MLarg+27,0,0> }
    object { Colonne translate <MLarg-27,0,0> } }
  texture { MetalSupport } }

// --- Les antennes ---
#declare AntenneCol1 = color red 0.65 green 0.55 blue 0.40
#declare AntenneCol2 = color red 0.45 green 0.25 blue 0.25
#declare AntenneCol3 = color red 0.65 green 0.20 blue 0.20
#declare AntenneTex =
  texture {
    pigment {
      bozo turbulence 0.50 lambda 6 scale 15
      color_map {
        [0.40 color AntenneCol1]
        [0.60 color AntenneCol2] } }
    finish { ambient 0.30 diffuse 0.80 } }
  texture {
    pigment {
      bozo turbulence 0.50 lambda 6 scale 12
      color_map {
        [0.30 color Transparent]
        [0.40 color AntenneCol3 filter 0.90]
        [0.50 color AntenneCol3 filter 0.20]
        [0.60 color AntenneCol3 filter 0.90]
        [0.70 color Transparent] } }
  finish { ambient 0.30 diffuse 0.80 specular 0.70 roughness 0.02 } }
#declare AntenneGauche_CntTex = texture { AntenneTex }
#declare AntenneGauche_EllTex = texture { AntenneTex }
#declare AntenneGaucheTex = texture { AntenneTex }
#declare AntenneDroite_CntTex = texture { AntenneTex }
#declare AntenneDroite_EllTex = texture { AntenneTex }
#declare AntenneDroiteTex = texture { AntenneTex }
#include "FirstEncounterKAntennes.cpp"

// --- Les lampes ---
#declare LampCol = color red 0.90 green 0.80 blue 0.60
#declare SmallLampCol = color red 0.65 green 0.58 blue 0.53
#declare LampTex = texture {
  pigment { LampCol filter 0.80 }
  finish { ambient 0.5 diffuse 0.9 specular 1.80 roughness 0.05 refraction 1 ior 5 } }
#declare LEpa1 = 5
#declare LHaut1 = 8
#declare DoorLight = light_source { 
  <0, 0, 0> color LampCol
  #ifndef(RenderLite)
    area_light <7, 0, 0>, <0, 11, 0>, 4, 4 jitter adaptive 2
  #end
  looks_like { 
    sphere { <0, 0, 0>, 1 scale <LEpa1, LHaut1, LEpa1> }
    texture { LampTex } } }
#declare SmallDoorLight = light_source {
  <0, 0, 0> color SmallLampCol
  #ifndef(RenderLite)
    area_light <7, 0, 0>, <0, 11, 0>, 4, 4 jitter adaptive 2
  #end
}

// --- Scne ---
//global_settings {
//  assumed_gamma 1.7
//  max_trace_level 5
//}

#declare FondCol = color red 0.0 green 0.0 blue 0.0
background { color FondCol }

/* --- Un appareil photo avec profondeur de champs. Les premiers plans sont flous. Ca amplifie l'impression de
       longueur du couloir, et ca gomme les effets du height_field utilis pour les mrs. --- */
#declare CameraNor1 = camera {
  location <3, -MHaut/2+12, -50> direction <0, 0, 1.62> look_at <0, -8, 100>
  #ifdef(RenderLite)
  #else
    aperture 2.0 focal_point <0, 15, 3 * MLong>
    #ifdef(RenderMedium)
      blur_samples 4 confidence 0.90 variance 1/128
    #else
      blur_samples 60 confidence 0.985 variance 1/500
    #end
  #end
}

#declare CameraDetailPorte = camera { location <3, -MHaut/2+12, -50> direction <0, 0, 6> look_at <0, -26, 100> }

#ifdef(VisuPorteDePres)
  camera { CameraDetailPorte }
  object { SmallDoorLight translate < 11, 32, -MLong/4> }
  object { Murs }

#else
  camera { CameraNor1 }
  // --- Lumires devant ---
  object { DoorLight translate < 11, 32, MurFondPosZ - LEpa1 * 1.0> }
  object { DoorLight translate <-11, 32, MurFondPosZ - LEpa1 * 1.0> }

  // --- Lumires derrire ---
  object { SmallDoorLight translate < 11, 32, -MLong/4> }
  //object { SmallDoorLight translate < 11, 32, -MLong/4> }
  //object { SmallDoorLight translate <-11, 32, -MLong/4> }

  object { Murs }
  object { Renfort translate <0, 0, 60> }
  object { Renfort translate <0, 0, 180> }
  object { AntenneGauche scale 0.50 translate <-5, -33, -50> }
  object { AntenneDroite scale 0.50 translate < 5, -30, -50> }
#end
