/*--------------------------------------------------------------------------------
  Script  : FirstEncounterKPerso.inc
  Date    : 27-Nov-1998
  Auteur  : Fab
  Descrip : la tte et le torse du visiteur.
--------------------------------------------------------------------------------*/
// --- Le crne et le haut du corps ---
#declare PeauCol1 = color red 1.00 green 0.65 blue 0.55
#declare PeauTex  = texture { 
  pigment { color PeauCol1 } 
  normal { bumps 0.30 scale 0.2 }
  finish { ambient 0.2 diffuse 0.7 specular 0.3 roughness 0.016 metallic brilliance 2 } }
#declare CostumeCol1 = color red 0.30 green 0.45 blue 0.60
#declare CostumeCol2 = color red 0.60 green 0.25 blue 0.30
#declare CostumeTex = texture { 
  pigment { color CostumeCol1 } 
  normal { bumps 0.40 scale <0.80, 1.00, 0.80> }
  finish { ambient 0.3 diffuse 0.7 specular 0.2 roughness 0.016 metallic } }

#declare Crane = blob {
  threshold 1.040
  // --- Centre ---
  component  1, 1.000 <  0.00,  0.00,  0.000>
  component  1, 0.800 <  0.30,  0.10,  0.800>
  component  1, 0.800 <  0.00,  0.70,  0.650>
  component  1, 0.800 < -0.30,  0.10,  0.800>
  component  1, 0.700 <  0.00,  0.30,  0.750>
  component  1, 0.700 <  0.15, -0.25,  0.700>
  component  1, 0.700 < -0.15, -0.25,  0.700>
  // --- Cot droit, oreille ---
  component  1, 1.000 <  1.00,  0.00,  0.000>
  component -1, 0.230 <  0.80,  0.00, -0.250>
  // --- Cot gauche, oreille ---
  component  1, 1.000 < -1.00,  0.00,  0.000>
  component -1, 0.230 < -0.80,  0.00, -0.250>
  // --- Haut ---
  component  1, 1.000 <  0.00,  1.00,  0.000>
  component  1, 0.610 <  0.40,  0.55,  0.370>
  component  1, 0.610 < -0.40,  0.55,  0.370>
  // --- Menton ---
  component  1, 1.000 <  0.00, -0.90,  0.000>
  // --- Bouche ---
  component -1, 0.320 <  0.00, -0.35, -0.290>
  // --- Nez ---
  component  1, 1.150 <  0.00, -0.20, -1.050>
  // --- Cou ---
  component  1, 0.600 <  0.00, -0.60,  0.600>  
  component  1, 0.500 <  0.00, -0.90,  0.800>  
  component  1, 0.500 <  0.00, -1.20,  0.900>  
  // --- Les paules et le dbut du torse ---
  component  1, 0.800 <  0.80, -1.20,  1.100>  
  component  1, 0.800 < -0.80, -1.20,  0.900>  
  component  1, 0.800 <  0.00, -1.40,  0.900>  
  component  1, 0.800 <  0.50, -1.90,  1.100>  
  component  1, 0.800 < -0.50, -1.90,  0.900>  
  // --- Le reste du torse, version droite ---
  //component  1, 0.800 <  0.30, -2.40,  1.300>    component  1, 0.800 < -0.30, -2.40,  1.300>  
  //component  1, 0.800 <  0.25, -2.80,  1.700>    component  1, 0.800 < -0.25, -2.80,  1.700>  
  //component  1, 0.800 <  0.30, -3.40,  2.000>    component  1, 0.800 < -0.30, -3.40,  2.000>  
  // --- Le reste du torse, version qui part sur le cot gauche (le sien) ---
  component  1, 0.800 <  0.35, -2.40,  1.300>    component  1, 0.800 < -0.25, -2.40,  1.300>  
  component  1, 0.800 <  0.40, -2.80,  1.700>    component  1, 0.800 < -0.10, -2.80,  1.700>  
  component  1, 0.800 <  0.45, -3.40,  2.000>    component  1, 0.800 < -0.05, -3.40,  2.000>  
  // --- Dbut du bras droit (le sien) ---       --- Dbut du bras gauche (le sien) ---
  component  1, 0.700 <  1.20, -1.40,  1.100>    component  1, 0.700 < -1.20, -1.40,  0.700>  
  component  1, 0.650 <  1.35, -1.65,  1.150>    component  1, 0.650 < -1.30, -1.65,  0.750>  
  component  1, 0.600 <  1.45, -1.90,  1.200>    component  1, 0.600 < -1.40, -1.90,  0.800>  
  component  1, 0.570 <  1.60, -2.10,  1.350>    component  1, 0.570 < -1.50, -2.10,  0.850>  
  component  1, 0.600 <  1.70, -2.30,  1.400>    component  1, 0.500 < -1.60, -2.30,  0.900>  
  component  1, 0.500 <  1.85, -2.45,  1.450>    component  1, 0.500 < -1.70, -2.45,  0.950>  
  component  1, 0.500 <  1.95, -2.60,  1.500>    component  1, 0.500 < -1.80, -2.60,  1.000>  
  component  1, 0.500 <  2.15, -2.75,  1.600>    component  1, 0.500 < -1.95, -2.75,  1.050>  
  component  1, 0.500 <  2.30, -2.90,  1.700>    component  1, 0.500 < -2.10, -2.90,  1.100>
  scale 3 
}                                               

// --- Les yeux ---
#declare OeilCol1 = color red 0.95 green 0.95 blue 1.00
#declare OeilCol2 = color red 1.00 green 1.00 blue 0.80
#declare OeilTexFond = texture {
  pigment {
    granite scale 0.03
    color_map {
      [0.20 color OeilCol1]
      [0.30 color OeilCol2]
      [0.70 color OeilCol2]
      [0.80 color OeilCol1] } }
  finish { ambient 0.20 diffuse 0.60 } }
#declare PigmentVeines = pigment { image_map { gif "FirstEncounterKOeil.gif" filter all 0.60 once map_type 1 } }
#declare OeilTexG =
  texture { OeilTexFond }
  texture {
    pigment { PigmentVeines rotate <0, 0, 180> }
    finish { ambient 0.20 diffuse 0.70 specular 5.0 roughness 0.002 } }
#declare OeilTexD =
  texture { OeilTexFond }
  texture {
    pigment { PigmentVeines }
    finish { ambient 0.20 diffuse 0.70 specular 5.0 roughness 0.002 } }
#declare IrisCol = color red 0.10 green 0.50 blue 0.80
#declare IrisTex = texture { pigment { IrisCol } finish { ambient 0.20 diffuse 0.80 } }
#declare PupiCol = color red 0.20 green 0.00 blue 0.00
#declare PupiTex = texture { pigment { PupiCol } finish { ambient 0.20 diffuse 0.30 } }
#declare OeilDia = 0.55
#declare IrisDia = 0.35
#declare PupiDia = 0.10
#declare OeilG = union {
  object { sphere { <0,0,0>,OeilDia } texture { OeilTexG } }
  union {
    object { sphere { <0,0,0>,IrisDia } texture { IrisTex } }
    object { sphere { <0,0,0>,PupiDia } texture { PupiTex } translate <0,0,-IrisDia+PupiDia-0.03> }
    translate <0,0,-OeilDia+IrisDia-0.03> rotate <0,0,0> } }
#declare OeilD = union {
  object { sphere { <0,0,0>,OeilDia } texture { OeilTexD } }
  union {
    object { sphere { <0,0,0>,IrisDia } texture { IrisTex } }
    object { sphere { <0,0,0>,PupiDia } texture { PupiTex } translate <0,0,-IrisDia+PupiDia-0.03> }
    translate <0,0,-OeilDia+IrisDia-0.03> rotate <0,0,0> } }

// --- Les dents ---
#declare DentsCol = color red 1.00 green 0.85 blue 0.60
#declare DentsTex = texture {
  pigment { color DentsCol }
  finish { ambient 0.3 diffuse 0.5 specular 0.3 roughness 0.001 } }
#declare Dents = object {
  union {
    cone { <0,0,0>,1,<0,-1,0>,0.5 scale <0.3,0.7,0.1> translate <-0.1,0,0> }
    cone { <0,0,0>,1,<0,-1,0>,0.5 scale <0.3,0.7,0.1> translate < 0.1,0,0> } }
  texture { DentsTex }
  bounded_by { box { <-0.4,-0.7,-0.1>,<0.4,0,0.1> } }
  rotate <-15,0,0> }

// --- La langue ---
#declare LangueCol1 = color red 0.80 green 0.30 blue 0.40
#declare LangueCol2 = color red 1.00 green 0.50 blue 0.60
#declare LangueTex = texture {
  pigment {
    bozo turbulence 0.3 scale 0.10
    color_map {
      [0.00 color LangueCol1]
      [0.70 color LangueCol2]
      [1.00 color LangueCol1] } }
  normal { bumps 0.8 scale <0.015,0.08,0.015> }
  finish { ambient 0.3 diffuse 0.5 specular 0.2 roughness 0.01 } }

#declare Langue = object {
  blob {
    threshold 1.040
    component  1, 0.380 <  0.00, -0.15,  0.080>
    component  1, 0.380 <  0.00, -0.45, -0.000>
    component  1, 0.300 <  0.00, -0.58, -0.180>
    component  1, 0.280 <  0.00, -0.65, -0.240> }
  texture { LangueTex }
  scale 3 }
#declare PersonnageBound = union { box { <-3, -2.5, -2.4>,<3, 3.6, 3.8> }  box { <-6, -8, -2>,<6, -2.5, 6.0> } }

// --- Le personnage nu ---
#declare Personnage = union {
  object { Crane texture { PeauTex } }
  object { OeilG rotate <0, 6,0> translate < 0.60,0.6,-0.40> }
  object { OeilD rotate <0,-6,0> translate <-0.60,0.6,-0.40> }
  object { Langue }
  object { Dents translate <0,-0.90,-1.7> }
//  bounded_by { object { PersonnageBound } }
}

// --- Le personnage habill
#declare ColHaut = -2.70
#declare PersonnageHabille = union {
  // --- La partie nue, visage et cou ---
  object {
    difference {
      object { Crane }
      plane { <0, 1, 0>, ColHaut } }
    texture { PeauTex } }
  // --- La partie habille ---
  object {
    difference {
      object { Crane }
      plane { <0, 1, 0>, ColHaut inverse } }
    texture { CostumeTex } }
  object { OeilG rotate <0, 6,0> translate < 0.60,0.6,-0.40> }
  object { OeilD rotate <0,-6,0> translate <-0.60,0.6,-0.40> }
  object { Langue }
  object { Dents translate <0,-0.90,-1.7> } }
