// Persistence of Vision Ray Tracer Scene Description File
// File: show.pov
// Vers: 3.1
// Desc: First encounter entry in the IRTC
// Date: 28.12.98
// Auth: J. BERGER

#include "colors.inc"

// set an overall brightness/ambient light level in the scene
//global_settings { ambient_light color <5,5,5> }

camera
{
  location  <4, 0.2,-9.0>
  look_at   <2, 0.1,-14.0>
  angle 40
}

light_source {
  <0, 5, -9>
  color <0.1, 0.1, 0.1>/5
}

global_settings
{
  assumed_gamma 1.0
  ambient_light color <0.1, 0.1, 0.1>
  max_trace_level 10
}

// create a point "spotlight" (conical directed) light source
light_source
{
  0*x                     // light's position (translated below)
  color <0.9, 0.9, 1>/1.5 // light's color
  spotlight               // this kind of light source
  translate <3, 4, -3>    // <x y z> position of light
  point_at <-4, 0.1, 0>   // direction of spotlight
  radius 12               // hotspot (inner, in degrees)
  tightness 50            // tightness of falloff (1...100) lower is softer, higher is tighter
  falloff 14              // intensity falloff radius (outer, in degrees)
  translate -7*z
}
light_source
{
  0*x                     // light's position (translated below)
  color <0.9, 0.9, 1>/1.5 // light's color
  spotlight               // this kind of light source
  translate <0, 4, -3>    // <x y z> position of light
  point_at <-4, 0.1, 0>   // direction of spotlight
  radius 12               // hotspot (inner, in degrees)
  tightness 50            // tightness of falloff (1...100) lower is softer, higher is tighter
  falloff 14              // intensity falloff radius (outer, in degrees)
  translate -7*z
}
light_source
{
  0*x                     // light's position (translated below)
  color <0.9, 0.9, 1>/1.5 // light's color
  spotlight               // this kind of light source
  translate <-3, 4, -3>   // <x y z> position of light
  point_at <-4, 0.1, 0>   // direction of spotlight
  radius 12               // hotspot (inner, in degrees)
  tightness 50            // tightness of falloff (1...100) lower is softer, higher is tighter
  falloff 14              // intensity falloff radius (outer, in degrees)
  translate -7*z
}

box { // girl
  <-0.5, -0.5, -0.01> <0.5, 0.5, 0.01>
  pigment {
    image_map {
      png "girl_col.png"
      transmit 215, 1
    }
    translate <-0.5, -0.5, 0>
  }
  scale <1, 700/225, 1>
  scale <1.2, 1.2, 1>
  translate 700/225*0.1*y
  translate -4*x-0.55*y
  translate -7*z
}

box { // stage
  <-10, -3, -1> <10, -680/450-0.5, 6>
  pigment { color rgb <200, 200, 200>/255 }
  translate -7*z
}

box { 
  <-10, -3, 4> <10, 5, 5>
  pigment { 
    granite
    color_map {
      [ 0.9 color <0.8, 0.8, 1> ]
      [ 0.93 color <0.99, 0.99, 1>*100 ]
    }
  }
  translate -7*z
}

box { // curtains
  <-10, -2.5, -1> <-5, 5, -1.1>
  pigment { color <180, 224, 254>/255 }
  normal { marble turbulence 0.1 }
  translate -7*z
  //no_shadow
}
box { 
  <10, -2.5, -1> <2, 5, -1.1>
  pigment { color <180, 224, 254>/255 }
  normal { marble turbulence 0.1 }
  translate -7*z
  //no_shadow
}
box {
  <-10, 4, -1.2> <10, 6, -1.3>
  pigment { color <180, 224, 254>/255 }
  normal { marble turbulence 0.1 }
  translate -7*z
  //no_shadow
}

box { // ground
  <-15, -3, 0> <15, -4, -40>
  pigment { color <220, 200, 180>/255 }
}

box { // walls
  <-16, -4, 10> <-10, 6, -21>
  pigment { color <240, 231, 168>/255 }
  no_shadow
}
box {
  <16, -4, 10> <10, 6, -21>
  pigment { color <240, 231, 168>/255 }
  no_shadow
}

box { // ceiling
  <-16, 5, -21> <16, 6, 10>
  pigment { color <240, 231, 168>/255 }
  no_shadow
}  

box { // back wall
  <-16, -4, -16> <16, 6, -15>
  pigment { color <240, 231, 168>/255 }
  no_shadow
}

difference { // mirror
  box { 
    <-10, 1.5, -20.5> <10, -1.5, -14.7> 
    pigment { color Black }
    finish { 
      reflection 1
      phong 1
    }
  }              
  #declare GrooveWidth = 0.0035 ;
  #declare i=19 ;
  #while(i>0)
    box { <-10-GrooveWidth+i, 2, -14.99> <-10+GrooveWidth+i, -2, -14> pigment { color Black } }
    #declare i=i-1 ;
  #end
  box { <-11, 0.5+GrooveWidth, -14.99> <11, 0.5-GrooveWidth, -14> pigment { color Black } }
  box { <-11,-0.5+GrooveWidth, -14.99> <11,-0.5-GrooveWidth, -14> pigment { color Black } }
  no_shadow
  translate -0.1*y
}

object { // the wolf
  #declare included=true ;
  #include "wolf.pov"
  scale 0.7
  rotate -120*y
  translate <3, 0.5, -14>
}

// create a point "spotlight" (conical directed) light source
light_source
{
  <-6, 6, -6>          // light's position (translated below)
  color rgb <1,1,1>       // light's color
  spotlight               // this kind of light source
  point_at <0, 0, 0>      // direction of spotlight
  radius 10               // hotspot (inner, in degrees)
  tightness 50            // tightness of falloff (1...100) lower is softer, higher is tighter
  falloff 12              // intensity falloff radius (outer, in degrees)
  rotate -165*y
  translate <3, 0.5, -14>
}

union { // table
  cylinder { <0, -4, 0> <0, -1.2, 0> 0.2 }
  cylinder { <0, -1.3, 0> <0, -1.1, 0> 1.4 }
  pigment { color <209, 207, 191>/255 }
  translate <2.34, 0, -13.04> 
}

box { // shadows
  <-0.5, -0.5, -0.001> <0.5, 0.5, 0.001>
  pigment {
    image_map {
      png "shadow1.png"
      transmit 38, 1
    }
    translate <-0.5, -0.5, 0>
  }
  scale <4, 2, 1>
  translate -3*x-1.5*y
  translate -12*z
}
box { // shadows
  <-0.5, -0.5, -0.001> <0.5, 0.5, 0.001>
  pigment {
    image_map {
      png "shadow2.png"
      transmit 18, 1
    }
    translate <-0.5, -0.5, 0>
  }
  scale <2, 2, 1>
  translate 0.2*x-1.5*y
  translate -12.5*z
}

