// Persistence of Vision Ray Tracer Scene Description File
// File: Wolf.pov
// Vers: 3.1
// Desc: First encounter entry in the IRTC
// Date: 06.11.98
// Auth: J. BERGER
//

#version 3.1 ;

#include "colors.inc"
#include "shapes.inc"

#ifndef (included)
  global_settings
  {
    assumed_gamma 1.0
  }
  
  // ----------------------------------------
  camera
  {
    location  <0.0, 0.0, -5.5>
    look_at   <0.0, 0.0,  0.0>
    angle 40
  }
  
  /*sky_sphere
  {
    pigment
    {
      gradient y
      color_map { [0.0 color rgb <0.6, 0.6, 0.0> ] [1.0 color rgb 1] }
    }
  }*/
  
  light_source
  {
    0*x // light's position (translated below)
    color red 1.0  green 1.0  blue 1.0  // light's color
    translate <-30, 30, -30>
  }
#end

// ----------------------------------------
#declare Eye = union {
  sphere {
    <0, 0, 0>, 0.5
    pigment { color White }
    finish {
      phong 0.5
      //phong_size 20
      #ifdef (included)
        ambient 1
      #end
    }
    scale <1, 1.1, 0.9>
  }
  sphere { 
    0*x, 0.1 
    scale <0.25, 1, 1>
    translate x/2
    pigment { color Black } 
    finish {
      phong 1
      phong_size 10
      #ifdef (included)
        ambient 1
      #end
    }
  }
  scale <1.2, 0.8, 0.7>*0.8
}

#declare WolfGrey  = color rgb <0.1, 0.1, 0.1> ;
#declare WolfWhite = color rgb <0.8, 0.8, 0.6> ;
#declare WolfRose  = color rgb <244, 156, 156>/255 ;
#declare WolfFinish = finish { 
  phong 0.2     
  #ifdef (included)
    ambient 1
  #end
}

union {
  blob // head
  {
    threshold 0.5
    
    // global shape
    cylinder {
      <-0.25, 0.6, 0> <0.5, 0.5, 0>, 2.1, 0.7
      pigment { color WolfGrey }
      finish { WolfFinish }
    }
    sphere { <0.73, 0.55, 1.6>, 1.2, -3 scale <20, 4, 1> }
    sphere { <0.73, 0.55, -1.6>, 1.2, -3 scale <20, 4, 1> }
    
    cylinder { 
      <0.4, 0, 0> <0.4, -2, 0>, 0.48, 0.7 
      pigment { color WolfGrey } 
      finish { WolfFinish }
    }
    
    // mouth
      // top
    #declare IncAlpha = 15 ;
    cylinder { 
      <1, 0, 0> <1.3, 0, 0>, 1.4, 0.7
      scale <1, 0.7, 0.75>
      pigment { color WolfWhite } 
      finish { WolfFinish }
      rotate 5*z
      translate 0.3*z+0.4*y
      translate -0.1*y      
    }
    cylinder { 
      <1, 0, 0> <1.3, 0, 0>, 1.4, 0.7
      scale <1, 0.7, 0.75>
      pigment { color WolfWhite } 
      finish { WolfFinish }
      rotate 5*z
      translate -0.3*z+0.4*y
      translate -0.1*y      
    }
    cylinder {
      <0, 0, 0.4> <0, 0, -0.4>, 0.8, 0.9
      scale <0.75, 1, 0.75>
      pigment { color WolfWhite } 
      finish { WolfFinish }
      translate <1.5, 0.4, 0>
      translate -0.1*y      
    }
    //-----------
    cylinder {
      <0, 0, 0.4> <0, 0, -0.4>, 0.8, 0.9
      scale <0.75, 1, 0.75>
      pigment { color WolfWhite } 
      finish { WolfFinish }
      translate <0.75, 0.0, 0>
      rotate IncAlpha*z
      translate 1.5*x+0.4*y
      translate -0.1*y      
    }
    //---------------
    cylinder { 
      <0.2, 0, 0.27> <0.7, 0, 0>, 1.4, 0.7
      scale <1, 0.7, 0.75>
      pigment { color WolfWhite } 
      finish { WolfFinish }
      rotate 5*z
      translate 0.1*z
      rotate IncAlpha*z
      translate 0.75*x
      rotate IncAlpha*z
      translate 1.5*x+0.4*y
      translate -0.1*y      
    }
    cylinder { 
      <0.2, 0, -0.27> <0.7, 0, 0>, 1.4, 0.7
      scale <1, 0.7, 0.75>
      pigment { color WolfWhite } 
      finish { WolfFinish }
      rotate 5*z
      translate -0.1*z
      rotate IncAlpha*z
      translate 0.75*x
      rotate IncAlpha*z
      translate 1.5*x+0.4*y
      translate -0.1*y      
    }    
    cylinder {
      <0, 0, 0.1> <0, 0, -0.1>, 0.8, 0.9
      scale <0.75, 1, 0.75>
      pigment { color WolfWhite } 
      finish { WolfFinish }
      translate <0.75, 0.0, 0>
      rotate IncAlpha*z
      translate 0.75*x
      rotate IncAlpha*z
      translate 1.5*x+0.4*y
      translate -0.1*y      
    }
    //---------------
    sphere { 
      <0, -0.3, 0.3>, 1.4, -0.5 
      scale <0.5, 1, 1>
      translate 1.55*x
      rotate IncAlpha*z
      translate 0.75*x
      rotate IncAlpha*z
      translate 1.5*x+0.4*y
    }
    sphere { 
      <0, -0.3, -0.3>, 1.4, -0.5 
      scale <0.5, 1, 1>
      translate 1.55*x
      rotate IncAlpha*z
      translate 0.75*x
      rotate IncAlpha*z
      translate 1.5*x+0.4*y
    }
    cylinder {
      <0, 0.7, -3>, <0, 0.7, 3>, 2, -1.5
      scale <0.5, 1, 1>           
      rotate -45*z
      translate 3.2*x+0.5*y 
    }
    //--------------
      // inside
    cylinder {
      <1.3, 0, 0> <2.9, 0, 0>, 0.8, -3
      scale <1, 0.75, 1.2>
      translate 0.3*y
    }
      // bottom
    cylinder {
      <0, 0, 0> <1.6, 0, 0>, 1, 1
      scale <1, 0.5, 1>
      pigment { color WolfWhite } 
      finish { WolfFinish }
      rotate -30*z
      translate x//-0.2*y
    }
    cylinder {
      <0, 0.21, 0> <1.55, 0.21, 0>, 0.6, -2
      scale <1, 0.5, 1.1>
      rotate -30*z
      translate x//-0.2*y
    }
    cylinder {
      <0, 0.27, 0> <0.7, 0.27, 0>, 0.6, -4
      scale <1, 0.67, 1.3>
      rotate -30*z
      translate x//-0.2*y
    }
      // opening
    cylinder {
      <0, 0, -1.3> <0, 0, 1.3>, 0.7, -0.5
      scale <1, 0.5, 1>
      rotate -30*z
      translate <1.6, 0.01, 0>
    }
      // eye sockets
    sphere {
      <0, 0, 0>, 0.55, -0.5
      scale <1, 1.1, 0.9>
      scale <1, 0.8, 0.7>*0.8
      rotate -60*z
      translate <1.4, -0.5, -0.15>
      scale 2
      translate 2*y
      rotate 60*z
      translate -2*y
    }
    sphere {
      <0, 0, 0>, 0.55, -0.5
      scale <1, 1.1, 0.9>
      scale <1, 0.8, 0.7>*0.8
      rotate -60*z
      translate <1.4, -0.5, 0.15>
      scale 2
      translate 2*y
      rotate 60*z
      translate -2*y
    }
    
    translate 2*y
    rotate -60*z
    translate -2*y
    sturm on
    scale 0.5
  }
    // nose
  sphere {
    <0, 0, 0> 0.2
    scale <0.5, 0.5, 1.1>
    translate <2.2, -1.3, 0>
    pigment { color Black }
    finish {
      phong 1
      phong_size 1
      #ifdef (included)
        ambient 1
      #end
    }
  }
  
    //Eyes
  object {
    Eye
    translate <1.4, -0.5, -0.15>
  }
  object {
    Eye
    translate <1.4, -0.5, 0.15>
  }
  
    //Ears
  union {
    #include "ear.inc"
    scale 0.2
    rotate 100*y
    rotate -10*x
    rotate -50*z
    translate <1.2, -0.1, -0.25>
  }
  union {
    #include "ear.inc"
    scale 0.2
    rotate 75*y
    rotate 20*x
    rotate -70*z
    translate <1.2, -0.1, 0.25>
  }
  
    // Tongue
  object {
    #include "tongue2.inc"
    scale 0.35
    rotate -90*y
    rotate -80*z
    translate <1.1, -0.6, 0>
  }
  
  union {
    union {
      difference {
        object {
          Paraboloid_Y
          scale <0.51, 1, 0.76>
          translate -0.5*y 
        }
        plane {
          z, -0.1
          rotate 30*x
          rotate 25*y
        }
        plane {
          -z, -0.1
          rotate -30*x
          rotate -25*y
        } 
      }
      difference {
        box {
          <-0.5, -0.01, -0.15>, <-0.1, 0.01, 0.15>
        }
        plane {
          -z, -0.13
          rotate -20*y
        }
        rotate 30*y
        rotate 30*x
        rotate -30*z
        translate -0.425*y-0.2*z
      }
      difference {
        box {
          <-0.5, -0.01, -0.15>, <-0.1, 0.01, 0.15>
        }
        plane {
          z, -0.13
          rotate 20*y
        }
        rotate -30*y
        rotate -30*x
        rotate -30*z
        translate -0.425*y+0.2*z
      }
      pigment { color Red }
      normal {
        gradient x
        normal_map {
          [0.7 bumps 0.7 scale 0.1 ]
          [0.9 gradient z, -1 turbulence 0.1 scale 0.2 translate 0.1*z ]
        }
        translate 0.5*x
      }  
      #ifdef (included)
        finish { ambient 1 }
      #end
    }
    blob {
      threshold 0.5
      
      sphere {<-0.55,-0.07, 0.0  >, 0.14, 1 }
      sphere {<-0.5 ,-0.06,-0.075>, 0.14, 1 }
      sphere {<-0.5 ,-0.06, 0.075>, 0.14, 1 }
      sphere {<-0.6 ,-0.04, 0.0  >, 0.14, 1 }

      rotate -30*z
      translate -0.425*y
      
      pigment { color Red }
      #ifdef (included)
        finish { ambient 1 }
      #end
    }
    object {
      #include "scarf1.inc"
      
      scale 0.12
      rotate 40*y
      rotate -20*x
      rotate 60*z
      translate <-0.5,-0.2,-0.06>
      pigment { color Red }
      #ifdef (included)
        finish { ambient 1 }
      #end
    }
    object {
      #include "scarf2.inc"
      
      scale 0.12
      rotate -40*y
      rotate 20*x
      rotate 60*z
      translate <-0.5,-0.2,0.06>
      pigment { color Red }
      #ifdef (included)
        finish { ambient 1 }
      #end
    }
    
    rotate 120*z
    translate -1.19*y
  }
  
  difference { // body
    object
    {
      Paraboloid_Y
      scale <0.5, 1, 0.75>
      translate -0.5*y 
    }
    plane { -y, -2 }
    rotate 120*z
    //rotate -60*z
    translate -1.2*y
    pigment { 
      gradient z
      color_map {
        [ 0.00 rgb <0.1, 0.1, 1> ]
        [ 0.38 rgb <0.1, 0.1, 1> ]
        [ 0.38 rgb <0.0, 0.0, 0> ]
        [ 0.41 rgb <0.0, 0.0, 0> ]
        [ 0.41 rgb <0.1, 0.1, 1> ]
        [ 0.59 rgb <0.1, 0.1, 1> ]
        [ 0.59 rgb <0.0, 0.0, 0> ]
        [ 0.62 rgb <0.0, 0.0, 0> ]
        [ 0.62 rgb <0.1, 0.1, 1> ]
        [ 1.00 rgb <0.1, 0.1, 1> ]
      }
      translate -0.5*z
      scale 2
    }
    #ifdef (included)
      finish { ambient 1 }
    #end
  }
  
#ifndef (included)
  translate -x+0.7*y
  rotate 45*y
#end
  //rotate 135*y
  //rotate -90*x
}
