//man_texture.inc
//Textures for use with man.inc
//Appears before '#include "man.inc"'iscard
//(c) 1998 Ben Jackson
ambient diffuse
//Hand Texture
#declare hand_tex=texture{
 pigment{
   gradient y
   color_map{
     [0.0 rgb<.2,.3,.6>]
     [0.7 rgb<.2,.2,.8>]
     [1.0 rgb<.2,.3,.7>]
   }
   turbulence 1
   scale .3
 }
 finish{ambient 0 diffuse .7 phong .1 phong_size 10}
 normal{
  average
  normal_map{
   [agate .1 scale .6 turbulence .3]
   [agate .1 scale .6 turbulence .3 rotate <90,90,90>]
  }
 }
}

//Finger Texture
#declare finger_tex=texture{
 pigment{
   gradient y
   color_map{
     [0.0 rgb<.2,.3,.6>]
     [0.7 rgb<.2,.2,.8>]
     [1.0 rgb<.2,.3,.7>]
   }
   turbulence 1
   scale .3
 }
 finish{ambient 0 diffuse .7 phong .1 phong_size 10}
 normal{
  average
  normal_map{
   [gradient y .2 scale .06 turbulence .1] 
   [agate .3 scale .6 turbulence .3]
   [agate .1 scale .6 turbulence .3 rotate <90,90,90>]
  }
 }
}

//Shoe Texture
#declare shoe_tex_1=texture{
 pigment{
   bozo
   color_map{
     [0.0 rgb<.2,.2,.6>]
     [0.5 rgb<.2,.3,.7>]
     [1.0 rgb<.2,.1,.6>]
   }
   turbulence 1
   scale .3
 }
 finish{ambient .1 diffuse .7 phong .2 phong_size 30}
 normal{
  average
  normal_map{
   [wood .5 scale .3]
   [agate .1 scale .6 turbulence .3]
   [agate .1 scale .6 turbulence .3 rotate <90,90,90>]
  }
 }
}


//Shoe Sole
#declare sole_tex=texture{
 pigment {color <.3,.3,.3>}
 finish {phong .2
        phong_size 10
        diffuse .7
 }
 normal {
  average
  normal_map{
    [bumps .2 scale .03]
  }
 }           
}

//A second shoe texture
#declare shoe_tex_2=texture{
 pigment{
   wood
   color_map{
     [0.0 rgb<.2,.2,.6>]
     [0.5 rgb<.2,.3,.7>]
     [1.0 rgb<.2,.1,.6>]
   }
   turbulence 1
   scale .2
 }
 finish{ambient .1 diffuse .7 phong .2 phong_size 30}
 normal{
  average
  normal_map{
   [agate .2 scale .4 turbulence .8]
   [agate .2 scale .4 turbulence .8 rotate <90,90,90>]
  }
 }
}

//The Leg Texture
#declare leg_tex=texture{
 pigment{gradient y
   color_map{
    [0.0 rgb<.45,.4,.2>]
    [1.0 rgb<.5,.4,.3>]
   }
 }
 normal{average
  normal_map{
    [gradient y .1 scale .3]
    [dents 2 scale .2]
  }
 }   
 finish {phong .1 phong_size 30}
}
     
//The Arm Texture
#declare arm_tex=texture{
 pigment{gradient y
   color_map{
    [0.0 rgb<.5,.4,.2>]
    [1.0 rgb<.6,.4,.3>]
   }
 }
 normal{average
  normal_map{
    [gradient y .1 scale .3]
    [dents 2 scale .2]
  }
 }   
 finish {phong .1 phong_size 30}
}

//The Body Texture
#declare body_tex=texture{
 pigment{gradient x
  color_map{
   [0.0 rgb<.2,.3,.6>]
   [1.0 rgb<.5,.4,.2>]
  }
 }
 normal{average
  normal_map{
    [dents 2 scale .1]
    [bumps .3 scale .2]
  }
 }
 finish {phong .1 phong_size 20}
}   

//The head texture
//Wrinkled on top and smoothing out as moving down
#declare head_tex=texture{
 pigment{gradient y
  pigment_map{
   [0.0 rgb<.6,.2,.4>]
   [1.0 rgb<.2,.3,.6>]
  }
  scale 7
  translate <0,4,0>
 }
 normal{ 
  gradient y
  normal_map{
   [0.0 agate .75 scale .1]
   [0.5 bumps .2 scale .02]
   [1.0 bumps .2 scale .1]  
  }
  scale 7
  translate <0,4,0>
 } 
 finish {phong .1 phong_size 30}
}   

//The Chin Texture
#declare chin_tex=texture{
 pigment{gradient y
  pigment_map{
   [0.0 rgb<.6,.2,.5>]
   [1.0 rgb<.2,.3,.6>]
  }
  scale 7
  translate <0,4,0>
 }
 normal{gradient y
  normal_map{
   [0.0 bumps  .1 scale .05]
   [0.5 bumps .2 scale .01]
   [1.0 bumps .1 scale .05]
  }
  scale 4
  translate <0,4,0>
 } 
 finish {phong .1 phong_size 50}
}

//The Eye lid texture
#declare eye_lid_tex=texture{
 pigment{gradient y
  pigment_map{
   [0.0 rgb<.6,.2,.5>]
   [1.0 rgb<.2,.3,.6>]
  }
  scale 3
  translate <0,4,0>
 }
 normal{
  average
  normal_map{
   [gradient y
    normal_map{
     [0.0 bumps  .1 scale .1]
     [0.5 bumps .2 scale .1]
     [1.0 bumps .1 scale .1]
    }]
   [wood .2 scale .05]
  }
  scale 5
  translate <0,4,0>
 } 
 finish {phong .1 phong_size 20}
}

//Nose Texture
#declare nose_tex=texture{
 pigment{gradient y
  pigment_map{
   [0.0 rgb<.6,.2,.5>]
   [1.0 rgb<.2,.3,.6>]
  }
  scale 3
  translate <0,4,0>
 }
 normal{
  gradient y
   normal_map{
     [0.0 bumps  .1 scale .1]
     [0.5 bumps .2 scale .1]
     [1.0 wood .5 scale .1]
   }
  scale .6
  rotate <20,0,0>
 } 
 finish {phong .1 phong_size 50}
}  

#declare eye_finish=finish{phong 1 phong_size 100 reflection .5 diffuse .7 ambient .2}
  