// Landing.POV            14/12/98             I @ E MacKay

// NOTE :-  the height field included in this file is "wrinc2.tga".
//            the pov file for this is at the end of this file .

#include "colors.inc"

global_settings { max_trace_level 10 } 

camera {                                                         // CAMERA  
        location < 0, 0.9, -14 > //< 57, 5, 275 >   
        look_at  < 0, -1.4, 100 > //< 57, 5, 350 > 
        angle 50
        }

light_source { < 1000, 4000, -5000 > color White }               // SUN 
light_source { < -100, 1.5, -100 > color Gray45 shadowless }     // FILL 
 
sphere { < 0, 0, 0 >,1                                           // SKY
           pigment { 
                    gradient y
                    color_map {
                               [ 0.0 color rgb < 0.56, 0.55, 0.4 > ]
                               [ 0.2 color rgb < 0.3, 0.3, 0.6 > ]  
                               [ 0.5 color rgb < 0.1, 0.1, 0.6 > ] 
                               [ 1.0 color rgb < 0.1, 0.1, 0.6 > ]
                               }
                    }
            finish { ambient 0.75 }
                   scale 10000
            hollow
        }


 
plane { y, 0                                                       // GRASS
         pigment { color rgb < 0.9, 0.7, 0.2 > }
         normal { wrinkles  1  scale 0.5 }
         finish { ambient 0.3 }  
         hollow
         }

                    // DISTANT HILLS
#declare Hills =
        height_field {
                 tga "wrinc2.tga"
                 translate < -0.5, -0.5, -0.5 >
                 scale < 1600, 250, 500 >
                 pigment {
                          granite
                          turbulence 0.5
                          color_map {
                               [ 0.0 color rgb < 0.7, 0.5, 0.23 > ]
                               [ 0.1 color rgb < 0.1, 0.3, 0.34 > ]  
                               [ 0.5 color rgb < 0.5, 0.5, 0.56 > ] 
                               [ 1.0 color rgb < 0.2, 0.3, 0.34 > ]
                                    }
                          scale 200
                         }   
                            finish { ambient 0.55 }
                            }
object { Hills rotate -10*x translate < 175, 10, 1100 > }

                          // 2 TREES
#declare Btree =
             union {
                   cone { < -2, -15, 0 >,0.8,< 1, 12, 0 >,0.2
                          pigment { color Gray50 }
                          finish { ambient 0.3 }
                        }
                   sphere { < 0, 0, 0 >,10
                             scale < 0.8, 0.4, 0.6 >
                             translate < -2, 0, 0 >
                          }
                   sphere { < 0, 0, 0 >,10
                             scale < 0.6, 0.5, 0.6 >
                             translate < 2, 2, 1 >
                          }
                   sphere { < 0, 0, 0 >,10
                             scale < 0.5, 0.3, 0.5 >
                             translate < 0, 5, 0 >
                          }                       

                             pigment {
                                      granite
                                      color_map {
                                         [ 0.0 color rgb < 0.2, 0.5, 0.4 > ]
                                         [ 0.3 color rgb < 0.2, 0.5, 0.4 > ]
                                         [ 0.3 color Clear ]
                                         [ 0.6 color Clear ] 
                                         [ 0.6 color rgb < 0.2, 0.5, 0.4 > ]
                                         [ 0.9 color rgb < 0.2, 0.5, 0.4 > ]
                                         [ 0.9 color Clear ] 
                                         [ 1.0 color Clear ] 
                                                }
                                      scale 14
                                     }
                                finish { ambient 0.3 }
                            
                        translate 15*y
                     }
#declare Bran =
            union {
                   cone { < 0, 0, 0 >,0.32,< 7, 6, 0 >,0.2
                          pigment { color Gray50 }
                          finish { ambient 0.3 }
                        }
                   sphere { < 0, 0, 0 >,10
                             clipped_by {
                                        box { < -9, -5, -9 >,< 9, 11, 9 > }
                                        }
                             scale < 1, 0.6, 1 >
                             translate < 7, 6, 0 >
                             pigment {
                                      granite
                                      color_map {
                                         [ 0.0 color rgb < 0.2, 0.6, 0.4 > ]
                                         [ 0.3 color rgb < 0.2, 0.6, 0.4 > ]
                                         [ 0.3 color Clear ]
                                         [ 0.6 color Clear ] 
                                         [ 0.6 color rgb < 0.2, 0.6, 0.4 > ]
                                         [ 0.9 color rgb < 0.2, 0.6, 0.4 > ]
                                         [ 0.9 color Clear ] 
                                         [ 1.0 color Clear ] 
                                                }
                                         scale 9
                                     }
                                finish { ambient 0.3 }  
                          }
                    }
#declare Ctree =
             union {
                   cone { < 0, 0, 0 >,0.8,< 6, 30, 0 >,0.2
                          pigment { color Gray50 }
                          finish { ambient 0.3 }
                        }
            object { Bran rotate 180*y translate < 1, 5, 0 > }
            object { Bran scale 0.9 translate < 1.5, 7.5, 0 > } 
            object { Bran scale 0.8 rotate 120*y translate < 2.6, 13, 0 > } 
            object { Bran scale 0.7 rotate -70*y translate < 3.6, 17, 0 > } 
            object { Bran scale 0.6 rotate 180*y translate <4.3, 23, 0 > }
            object { Bran scale 0.6 rotate 20*y translate < 4.6, 26, 0 > } 
            object { Bran scale 0.5 rotate -40*y translate < 4.8, 28, 0 > } 
                   }
#declare Treeline =
              union {
                 object { Ctree }
                 object { Btree scale < 1, 1.2, 1 >
                          rotate 100*y
                          translate -8*x
                        }
                 object { Btree scale < 0.8, 0.85, 0.8 >
                          rotate 180*y
                          translate -38*x
                        }
                 object { Btree scale 0.5 translate 8*x }
                 object { Btree scale < 0.5, 1.2, 0.5 >
                          rotate 100*y
                          translate -42*x
                        }
                 object { Ctree scale < 0.7, 0.9, 0.7 >
                          rotate 30*y
                          translate -48*x
                        }
                 object { Ctree scale < 0.8, 0.5, 0.8 >
                          rotate 90*y
                          translate -52*x
                        }
                 object { Btree scale < 0.8, 0.85, 0.8 >
                          rotate 180*y
                          translate -68*x
                        }
                 object { Ctree scale  0.8 
                          translate -30*x
                        }
                 object { Ctree scale  0.8 
                          translate 10*x
                        }

                 object { Ctree scale  0.7
                          rotate 120*y
                          translate -18*x
                        }  
                   }

                          // AIRSTRIP
#declare Gable =                               // GABLE MARKERS
               superellipsoid {  < 0.2, 0.2 >
                                 scale < 0.8, 0.8, 3.4 >
                                 rotate 45*z
                                 pigment { color White }
                                 finish { ambient 0.2 }
                              }
#declare Centr =                                        // CENTRE LINE
               box { < 3, 0.02, 0 >,< 4, -0.1, -45 >  
                    pigment { 
                              granite 
                              color_map {
                                         [ 0.0 color Gray75 ] 
                                         [ 0.2 color Gray95 ]  
                                         [ 0.6 color Gray75 ]
                                         [ 0.8 color Gray95 ] 
                                         [ 0.9 color Gray85 ] 
                                         [ 1.0 color Gray95 ] 
                                        } 
                              scale < 0.5, 1, 15 >
                              }     
                    finish { ambient 0.2 }
                   }
object { Treeline translate < 60, 0, 500 > }
object { Treeline rotate 150*y translate < 120, 0, 600 > } 
object { Treeline scale < 1.5, 0.8, 1 >  translate < 500, 0, 1000 > }  
object { Treeline scale < 1, 1.2, 1 >  translate < -200, 0, 500 > }  

                           // HANGER
#declare Letr =
             box { < 0, 1.5, -1.4 >,< 0.25, 4.5, 1.4 >
                      pigment { color rgb < 1, 0.3, 0.3 > }
                      finish { ambient 0.2 }
                 }
#declare Sign =                                    // Sign on hanger
               union {
                     object { Letr translate -18*z }
                     object { Letr translate -14*z } 
                     object { Letr translate -10*z } 
                     object { Letr translate -6*z } 
                     object { Letr translate -2*z } 
                     object { Letr translate 2*z } 
                     object { Letr translate 10*z } 
                     object { Letr translate 14*z } 
                     object { Letr translate 18*z } 
                     }
#declare Post =
             box { < 0, 0, 79.5 >,< -0.5, 15, 80 >
                    pigment { color Gray75 }
                    finish { ambient 0.2 }
                 }
#declare Hanger =                  
          union {
                 box { < -60, 0, 0 >,< 0, 15, 80 > 
                         clipped_by {
                                      box { < -65, -1, -1 >,< -1, 20, 85 > }
                                    }    
                     }               
                 object { Post translate -10*x }    
                 object { Post translate -20*x }     
                 object { Post translate -30*x }     
                 object { Post translate -40*x }     
                 object { Post translate -50*x }     
                 object { Post translate < -49.5, 0, -10 > }     
                 object { Post translate < -49.5, 0, -20 > }     
                 object { Post translate < -49.5, 0, -30 > }     
                 object { Post translate < -49.5, 0, -40 > }     
                 
                 box { < -60, -0.1, -1.5 >,< 0, 0, 42 >              // roof
                       rotate -11*x
                       translate 15*y
                       pigment { color White }
                       finish { ambient 0.3 }
                     }
                 box { < -1, 0, -20 >,< -0.5, 15, 0 > }             // doors
                 box { < -1, 0, 77 >,< -0.5, 15, 97 > }             // doors
                 box { < -0.5, 0, -19 >,< 0, 15, 4 > }              // doors
                 box { < -0.5, 0, 79.5 >,< 0, 15, 98 > }            // doors

                 cylinder { < 0, 15, -20 >,< 0, 15, 100 >,0.5 
                             scale < 2, 1, 1 >   
                          }
               triangle { < 0, 15, 0 >,< 0, 15, 80 >,< 0, 23, 40 > } // gable 
               object { Sign translate < 0, 15, 40 > }

                     pigment { color White }
                     finish { ambient 0.2 }
                     rotate 20*y
                     translate < -220, 0, 650 >
                 }
object { Hanger }

#declare Strip =                                       // RUNWAY
       union {
               box { < -20, 0.01, -50 >,< 30, -0.1, 400 > 
                  pigment { 
                         granite 
                         color_map {
                                  [ 0.0 color rgb < 0.4, 0.4, 0.6 > ]
                                  [ 0.2 color rgb < 0.4, 0.4, 0.6 > ] 
                                  [ 0.2 color rgb < 0.475, 0.45, 0.52 > ] 
                                  [ 0.6 color rgb < 0.475, 0.45, 0.52 > ] 
                                  [ 0.6 color rgb < 0.45, 0.4, 0.6 > ]
                                  [ 0.7 color rgb < 0.45, 0.4, 0.6 > ] 
                                  [ 0.7 color Gray65 ] 
                                  [ 1.0 color Gray65 ] 
                                        } 
                              scale < 0.2, 1, 15 >
                              }
                    finish { ambient 0.2 }
                   }
               object { Centr }
               object { Centr  translate 65*z }
               object { Centr  translate 130*z }  
               object { Centr  translate 195*z }  
               object { Centr  translate 260*z }  
               object { Centr  translate 325*z }  
               object { Centr  translate < -5, 0, 325 > }  
               object { Centr  translate < 6, 0, 325 > }  
               object { Gable translate < -26, 0, 20 > }   
               object { Gable translate < -26, 0, 80 > }
               object { Gable translate < -26, 0, 140 > } 
               object { Gable translate < -26, 0, 200 > } 
               object { Gable translate < -26, 0, 260 > } 
               object { Gable translate < -26, 0, 320 > }
               object { Gable translate < -26, 0, 380 > } 
             }
object { Strip  rotate 20*y translate 1.5*x }


                          // UNDERCART
#declare Bolt =
               cylinder { < 0, 0, 0 >,< 0, 0.05, 0 >,0.025 
                          pigment { color Gray45 }
                          finish { ambient 0.2 }
                        } 
#declare Ankle =                                        // torsion links etc.
         union {
                torus { 0.7, 0.025                      // brake hose
                       clipped_by {
                               box { < -1, -1, 0 >,< 1, 1, 1 > }
                                  }
                        translate < -0.65, 0, 0 > 
                pigment { color Gray25 }                 
                finish { ambient 0.2 }
                      }  
                cylinder { < 0, 0, 0 >,< -0.23, 0, 0 >,0.065 }
                torus { 0.065, 0.01  rotate 90*z
                        translate  -0.23*x  } 
                sphere { < 0, 0, 0 >,0.065 }        
                cylinder { < -0.15, 0, 0 >,< 0.05, 0, 0 >,0.13
                           scale < 1, 0.5, 1 >
                           translate 0.07*z
                         }
                cylinder { < 0, -0.04, 0 >,< 0, 0.04, 0 >,0.13
                           scale < 0.5, 1, 1 >
                           translate < -0.6, 0, 0.5 >
                         }
                object { Bolt translate < -0.6, 0, 0.5 > }
                cylinder { < 0, 0, 0.2 >,< -0.6, 0, 0.5 >,0.09
                            scale < 1, 0.2, 1 >
                          }
                object { Bolt translate < -0.1, 0.01, 0.2 > }    
                cylinder { < -0.6, 0, 0.5 >,< -1.2, 0, 0.1 >,0.09
                            scale < 1, 0.2, 1 >
                          }
                object { Bolt translate < -1.2, 0.1, 0.05 > }
                pigment { color rgb < 1, 0.2, 0 > }                 
                finish { ambient 0.2 }   
                }
#declare Grve =                        
              cylinder { < 0, -0.01, 0 >,< 0, 0.01, 0 >,0.75
                        pigment { color Gray25 }
                        finish { ambient 0.2 }
                       }
#declare Sev =
              union {
                 object { Grve }
                 object { Grve translate 0.06*y }  
                 object { Grve translate -0.06*y }  
                 object { Grve translate 0.12*y }  
                 object { Grve translate -0.12*y }  
                    }
#declare Tred =
              difference {
         torus { 0.42, 0.2  scale < 1, 0.9, 1 >
                pigment { color Gray40 }                       // tyre tread
                finish { ambient 0.2 }
               }
         object { Sev }
                          }
                        
#declare Wheel =
union {
         torus { 0.4, 0.2
                pigment { color Gray25 }                          // tyre
                finish { ambient 0.2 }
               }
         object { Tred }
         torus { 0.2, 0.03
                translate 0.125*y
                pigment { color Red }                             // rim
                finish { ambient 0.2 }
               }
         torus { 0.2, 0.03
                translate -0.125*y
                pigment { color Red }                             // rim
                finish { ambient 0.2 }
               }
         cylinder { < 0, 0, 0 >,< 0, 0.3, 0 >,0.05               // axle
                    pigment { color Red }
                    finish { ambient 0.2 }
                  }
         cylinder { < 0, 0.16, 0 >,< 0, 0.18, 0 >,0.2           // brake disc
                    pigment { color Gray65 }
                    finish { ambient 0.2 
                             reflection 0.2 }
                  }
         box { < -0.1, 0.12, -0.275 >,< 0.1, 0.22, 0 >          // calipers
                  pigment { color rgb < 0.5, 0.5, 0.7 > }
                  finish { ambient 0.2 }
             }
         sphere { < 0, 0.22, -0.1 >,0.05
                  pigment { color rgb < 0.5, 0.5, 0.7 > }
                  finish { ambient 0.2 }
                }

         sphere { < -0.08, 0.22, -0.2 >,0.02
                  pigment { color rgb < 0.5, 0.5, 0.7 > }
                  finish { ambient 0.2 }
                }
         sphere { < 0.08, 0.22, -0.2 >,0.02
                  pigment { color rgb < 0.5, 0.5, 0.7 > }
                  finish { ambient 0.2 }
                }  
         cylinder { < 0, -0.13, 0 >,< 0, 0.13, 0 >,0.2                // hub
                    pigment { color Red }
                    finish { ambient 0.2 }
                  }
         cylinder { < 0, 0.3, 0 >,< -1.8, 0.3, 0 >,0.05              // leg
                    pigment { color White }
                    finish { ambient 0.2 
                             reflection 0.5 }
                  }

         object { Ankle translate 0.3*y }

     difference {
         cylinder { < -0.8, 0, 0.2 >,< -2, 0, 0.2 >,0.3            // fairing
                    scale < 1, 0.5, 1 >
                  }
         cylinder { < -0.8, -0.5, 0.4 >,< -0.8, 0.5, 0.4 >,0.36 }
                    translate 0.3*y
                    pigment { color rgb < 1, 0.2, 0 > }
                    finish { ambient 0.2 }
                  
                }
         rotate -90*z
       }


                           // PLANE  ( only the visable parts )
#declare Rib =
           union {
                 sphere { < 0, 0, 0.15 >,0.05 }
                 sphere { < 0, 0, 0.7 >,0.05 } 
                 cylinder { < 0, 0, 0.1 >,< 0, 0, 0.75 >,0.05 } 
                       pigment { color rgb < 1, 0.2, 0 > }
                       finish  { ambient 0.2 
                                 reflection 0.2
                               }
                 }
#declare Ribrun =
          union {
               object { Rib }
               object { Rib translate -0.75*x }
               object { Rib translate -1.5*x }  
               object { Rib translate -2.25*x }  
               object { Rib translate -3*x }  
               object { Rib translate -3.75*x }  
               object { Rib translate -4.5*x }
               object { Rib translate -5.25*x }  
               object { Rib translate -6*x }  
               object { Rib translate -6.75*x }  
               object { Rib translate -7.5*x }  
               object { Rib translate -8.25*x }
               object { Rib translate -9*x }  
               object { Rib translate -9.75*x }  
                }
#declare Flarm =               
               union {
                      object { Bolt rotate -90*z translate < 0, -0.5, 0 > }
                      cone { < 0, 0, 0 >,0.08,< 0, -0.5, 0 >,0.04 
                              scale < 0.3, 1, 1 > }
                      cone { < 0, -0.5, 0 >,0.04,< 0, -0.75, -1 >,0.14 
                              scale < 0.3, 1, 1 > }
                       translate 0.4*z
                       pigment { color rgb < 1, 0.2, 0 > }
                       finish  { ambient 0.2 }
                     }     

#declare Cell =
             cylinder { < 0, 0, 0 >,< -1.975, 0, 0 >,2.5
                       scale < 1, 0.15, 1 >
                       pigment { color rgb < 1, 0.2, 0 > }
                       finish  { ambient 0.3 
                                 phong 1
                                 reflection 0.3
                               }
                      }
#declare Wing =
             union {
                    object { Cell }
                    object { Cell translate -2*x }
                    object { Cell translate -4*x } 
                    object { Cell translate -6*x } 
                    object { Cell translate -8*x }
                    object { Cell translate -10*x } 
                    object { Cell translate -12*x } 
                    object { Cell translate -14*x }  
                    sphere { < 0, 0, 0 >,2.45                   // wing tip
                             scale < 0.15, 0.15, 1 >
                             translate  -16*x
                       pigment { color rgb < 1, 0.2, 0 > }
                       finish  { ambient 0.2 
                                 reflection 0.2
                               }
                           }
                    union {
                    object { Flarm translate -3.4*x }
                    object { Flarm translate -7.1*x }  
                    box { < -10, 0, 0 >,< 0, 0.1, 0.85 >  }       // Flaps
                    object { Ribrun }
                          rotate 40*x
                          translate 2.25*z
                       pigment { color rgb < 1, 0.2, 0 > }
                       finish  { ambient 0.2 
                                 reflection 0.2
                               }
                        }
                   }

#declare Plane =
     union {
object { Wing rotate -5*z translate < 0, 1.5, -1 > }
object { Wing rotate 5*z translate < 16, 2.3, -1 > }
cone { < 0, 3, 0 >,2,< 0, 3, -10 >,1                             // nose  
          pigment { color White }
          finish { ambient 0.2 }
    }
cone { < 0, 3, 0 >,2,< 0, 3, 14 >,1                              // rear fus  
          pigment { color White }
          finish { ambient 0.2 }
    }
object { Wing scale 0.6                                          // Stab
         rotate -15*x
         translate < 4.8, 1.75, 14 >
       }

triangle { < 0, 3, 10 >,< 0, 3, 14 >,< 0, 9, 13 >                // fin
         pigment { color White }
         }
triangle { < 0, 3, 14 >,< 0, 9, 15 >,< 0, 9, 13 > 
         pigment { color White }
         }

object {  Wheel                                          // wheel in view
          translate < -5, -0.15, -1 >
      }   
object {  Wheel   rotate 180*y                        // wheel, out of sight
          translate < 5, -0.15, -1 >
      }   
object {  Wheel                                    // nosewheel, out of sight
          translate < 0, 0, -6 >                   // for reflection only
      }    
    }

 object { Plane rotate 20*y translate < 4.3, 0.75, -10 > }

                                                   // Smoke off tyre
 sphere { < 0, 0, 0 >,1
          pigment { color rgbt < 1, 1, 1, 1 > }
          halo {
               attenuating
               spherical_mapping
               linear
               turbulence 1
               color_map {
                   [ 0 color rgbt < 0, 0, 1, 1 > ]
                   [ 1 color rgbt < 0.75, 0.75, 1, 0 > ]
                         }
                   samples 10
                   scale 0.5
               }
          hollow
          scale < 1, 1, 5 >
          translate < -0.7, 0, -6.5 >
        }

#declare Cess =                                            // DISTANT PLANE
           union {
                 sphere { < 0, 0, 0 >,7                    // main fus
                          scale < 1, 0.2, 0.2 >
                        }
                 cylinder { < -2, 0, 0 >,< -7, 0, 0 >,1.4            // nose
                             scale < 1, 0.5, 1 >
                             translate 1*y 
                          }
                 cylinder { < 2, -2.5, -5 >,< 2, -2.5, -4.5 >,0.6    // wheel 
                            pigment { color Gray20 }
                          }
                 cylinder { < 2, -2.5, 5 >,< 2, -2.5, 4.5 >,0.6      // wheel 
                            pigment { color Gray20 }
                          }
             cylinder { < -4, -2.5, -0.25 >,< -4, -2.5, 0.25 >,0.6   // wheel 
                            pigment { color Gray20 }
                          }

                 
                 cone { < 0, 0, 0 >,1.4,< 13, 1.4, 0 >,0.8 }     // tailcone
                 cone { < 2, 1.4, 0 >,1.4,< 13, 1.4, 0 >,0.8 }   // tailcone  
                 
                 cone { < 0, 0, 0 >,3,< 0, 3, 0 >,2              // cabin
                           scale < 1, 1, 0.6 > 
                           pigment { color rgb < 0.6, 0.6, 1 > }
                           finish { ambient 0.2 }
                      }  
                 triangle { < 9, 1.4, 0 >,< 13, 1.4, 0 >,< 14.5, 7, 0 > }
                 triangle { < 9, 1.4, 0 >,< 12.5, 7, 0 >,< 14.5, 7, 0 > } 

                 triangle { < 12, 1.4, 0 >,< 12, 1.4, 7 >,< 14, 0.7, 1 > 
                            pigment { color Red }
                            finish { ambient 0.2 }
                           }
                 triangle { < 12, 1.4, 0 >,< 12, 1.4, -7 >,< 14, 0.7, -1 > 
                            pigment { color Red }
                            finish { ambient 0.2 }
                           }  
                 cone { < 0, 0, 0 >,3,< 0, 0, 20 >,1.2  
                           scale < 1, 0.3, 1 > 
                           rotate -5*x
                           translate 3*y
                      }  
                 cone { < 0, 0, 0 >,3,< 0, 0, -20 >,1.2 
                           scale < 1, 0.2, 1 > 
                           rotate 5*x
                           translate 3*y
                      }  
                 translate 3*y     
                 pigment { color White }     
                 finish { ambient 0.2 }
              }
object { Cess rotate 10*y translate  < -200, 0, 670 >  }


#declare Kone =                                                // cone marker
          cone { < 0, 0, 0 >,1.2,< 0, 1.4, 0 >,0.2
                  translate 20*x
                  pigment { color White }
                  finish { ambient 0.2 }
               }
#declare Sock =
              union { 
                      cylinder { < 0, 1.5, -2 >,< 0, 1.5, 0 >, 0.05 }
                      cylinder { < 0, -1.5, -2 >,< 0, -1.5, 0 >, 0.05 } 
                      cone { < 0, 0, 0 >,1.5,< 0, 0, 2 >,1.4 open }
                      cone { < 0, 0, 1.8 >,1.4,< 0, -1, 5 >,1.1 open }
                      cone { < 0, -1, 4.8 >,1.1,< 0, -2.1, 8 >,0.73 open }
                      cone { < 0, -2.05, 7.8 >,0.73,< 0, -4, 11 >,0.4 open }
                            translate < 0, 22, 2 >
                            pigment { color Yellow }
                            finish { ambient 0.3 }
                     }
#declare Windsock =
              union {
                     object { Sock }
                     cylinder { < 0, 0, 0 >,< 0, 26, 0 >,0.3 }
                     cylinder { < 0, 0, 0 >,< 0, 0.4, 0 >,5 } 
                     sphere { < 0, 0, 0 >,0.5  scale < 2, 1, 2 >
                               translate 26*y
                            }
                     object { Kone }
                     object { Kone rotate 45*y }
                     object { Kone rotate 90*y } 
                     object { Kone rotate 135*y } 
                     object { Kone rotate 180*y } 
                     object { Kone rotate 225*y } 
                     object { Kone rotate 270*y } 
                     object { Kone rotate 315*y } 
                     
                          pigment { color White }
                          finish { ambient 0.2 }
                    }
object { Windsock rotate 45*y translate < 54.6, 0, 350 > }

                             //  END of I_LAND   *******
/*

// WRINC2.POV ( to make height field for above file )
//Wrinc2.pov

#include "colors.inc"

global_settings {
                assumed_gamma 2.2
                hf_gray_16
                }
camera {
        location  < 0, 0, -10 >
        look_at  < 0, 0, 0 >
        angle 10
       }
plane { z, 10
        pigment {
                wrinkles
                color_map {
                           [ 0 0.3*White ]
                           [ 1 White ]
                          }
                rotate 90*z
                 }
       }
light_source { < 0, 20, -100 > White }

*/
