//  Persistance of Vision Raytracer V3.1
//  World definition file.
//
//  Contains 3 lights, 24 textures and 117 primitives.
//
//  This file was generated for POV-Ray V3.1 by
//  Moray V3.1 For Windows (c) 1991-1998 Lutz + Kretzschmar
//

//  Date : 12/30/1998    (30.12.1998)
//

/*
  The text between these two comments is in MorayPOV.INC and is
  automatically included in all POV files that Moray exports.
*/

default {
  texture {
    pigment { rgb <1,0,0> }
    normal { bumps 0.3 }
    finish { ambient 0.4 }
  }
}

/* // Scene Comment

This scene was created with Moray V3.01 For Windows.

*/ // End Scene Comment

global_settings {
  adc_bailout 0.003922
  ambient_light <1.0,0.819608,0.72549>
  assumed_gamma 1.9
  hf_gray_16 off
  irid_wavelength <0.247059,0.176471,0.137255>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
  radiosity {
    brightness       3.3
    count            100
    distance_maximum 0.0
    error_bound      0.4
    gray_threshold   0.5
    low_error_factor 0.8
    minimum_reuse    0.015
    nearest_count    6
    recursion_limit  1
  }
}

background { color <0.561,0.486,0.322> }

camera {  //  Camera Main_Cam
  location  <     20.600,     -54.200,       6.400>
  direction <        0.0,         0.0,      2.4880> // Aperture is 0.40 degrees
  sky       <    0.00000,     0.00000,     1.00000> // Use right handed-system 
  up        <        0.0,         0.0,         1.0> // Where Z is up
  right     <    1.33333,         0.0,         0.0> // Aspect ratio
  look_at   <     -3.236,      -0.959,       1.933>
  // Focal blur settings
  focal_point  <-3.236, -0.959, 1.933> // Always Lookat
  aperture     0.75
  blur_samples 78
  confidence   0.991
  variance     0.001733
}

//    Other cameras are commented out.
/*
camera {  //  Camera Close_Up_Cam
  location  <      0.300,     -28.200,       5.000>
  direction <        0.0,         0.0,      2.4880> // Aperture is 0.40 degrees
  sky       <    0.00000,     0.00000,     1.00000> // Use right handed-system 
  up        <        0.0,         0.0,         1.0> // Where Z is up
  right     <    1.33333,         0.0,         0.0> // Aspect ratio
  look_at   <     -6.182,      -2.110,     -10.578>
}

*/

//
// *******  L I G H T S *******
//

light_source {   // Light002
  <-8.200, 0.400, 1.900>
  color rgb <0.414, 0.000, 0.014>
  fade_distance  5.0
  fade_power 1.0
}

light_source {   // Light001
  <8555.600, -10146.600, 5313.600>
  color rgb <1.000, 1.000, 1.000>
}

light_source {   // Light3
  <8.200, 0.400, 1.900>
  color rgb <0.000, 0.414, 0.000>
  fade_distance  5.0
  fade_power 1.0
}


//
// ********  TEXTURES  *******
//

#include "helmet.inc"


//
// ********  REFERENCED OBJECTS  *******
//

#declare HgtFld005 = object { 
  height_field {
    tga "C:\Terrain\hf-lab90\Marsbase.tga"
    water_level 0.0
    smooth
  }
  rotate    <-90, 0, 0> // Turn onto XY plane. Now points along -Z
  scale     <  2, 2,-2> // Scale to Cube size. Now points along +Z
  translate < -1,-1,-1> // Center around origin
  material {
    MarsLand
  }
  scale <200.0, 200.0, 10.0>
  translate  <-400.0, 0.0, -90.0>
}
#declare HgtFld006 = object { 
  height_field {
    tga "C:\Terrain\hf-lab90\Marsbase.tga"
    water_level 0.0
    smooth
  }
  rotate    <-90, 0, 0> // Turn onto XY plane. Now points along -Z
  scale     <  2, 2,-2> // Scale to Cube size. Now points along +Z
  translate < -1,-1,-1> // Center around origin
  material {
    MarsLand
  }
  scale <200.0, 200.0, 10.0>
  translate  <-400.0, 400.0, -90.0>
}
#declare HgtFld007 = object { 
  height_field {
    tga "C:\Terrain\hf-lab90\Marsbase.tga"
    water_level 0.0
    smooth
  }
  rotate    <-90, 0, 0> // Turn onto XY plane. Now points along -Z
  scale     <  2, 2,-2> // Scale to Cube size. Now points along +Z
  translate < -1,-1,-1> // Center around origin
  material {
    MarsLand
  }
  scale <200.0, 200.0, 10.0>
  translate  <0.0, 400.0, -90.0>
}
#declare HgtFld008 = object { 
  height_field {
    tga "C:\Terrain\hf-lab90\Marsbase.tga"
    water_level 0.0
    smooth
  }
  rotate    <-90, 0, 0> // Turn onto XY plane. Now points along -Z
  scale     <  2, 2,-2> // Scale to Cube size. Now points along +Z
  translate < -1,-1,-1> // Center around origin
  material {
    MarsLand
  }
  scale <200.0, 200.0, 10.0>
  translate  -90.0*z
}
#declare Group009 = union {
  object { HgtFld005 }
  object { HgtFld006 }
  object { HgtFld007 }
  object { HgtFld008 }
  material {
    MarsLand
  }
}
#declare Group010 = union {
  object { // Group006->Group009
    Group009
    translate  <-800.0, 800.0, 0.0>
  }
  object { // Group007->Group009
    Group009
    translate  -800.0*x
  }
  object { // Group008->Group009
    Group009
    translate  800.0*y
  }
  object { Group009 }
  translate  -1600.0*y
}
#declare Group011 = object {
  object { // Group011->Group010
    Group010
    translate  1600.0*x
  }
}
#declare Group012 = object {
  object { // Group012->Group011
    Group011
    translate  <-1600.0, 3200.0, 0.0>
  }
}
#declare HgtFld004 = object { 
  height_field {
    tga "C:\Terrain\hf-lab90\Marsbase.tga"
    water_level 0.0
    smooth
  }
  rotate    <-90, 0, 0> // Turn onto XY plane. Now points along -Z
  scale     <  2, 2,-2> // Scale to Cube size. Now points along +Z
  translate < -1,-1,-1> // Center around origin
  material {
    MarsLand
  }
  scale <200.0, 200.0, 10.0>
  translate  <-400.0, 0.0, -90.0>
}
#declare HgtFld003 = object { 
  height_field {
    tga "C:\Terrain\hf-lab90\Marsbase.tga"
    water_level 0.0
    smooth
  }
  rotate    <-90, 0, 0> // Turn onto XY plane. Now points along -Z
  scale     <  2, 2,-2> // Scale to Cube size. Now points along +Z
  translate < -1,-1,-1> // Center around origin
  material {
    MarsLand
  }
  scale <200.0, 200.0, 10.0>
  translate  <-400.0, 400.0, -90.0>
}
#declare HgtFld002 = object { 
  height_field {
    tga "C:\Terrain\hf-lab90\Marsbase.tga"
    water_level 0.0
    smooth
  }
  rotate    <-90, 0, 0> // Turn onto XY plane. Now points along -Z
  scale     <  2, 2,-2> // Scale to Cube size. Now points along +Z
  translate < -1,-1,-1> // Center around origin
  material {
    MarsLand
  }
  scale <200.0, 200.0, 10.0>
  translate  <0.0, 400.0, -90.0>
}
#declare HgtFld001 = object { 
  height_field {
    tga "C:\Terrain\hf-lab90\Marsbase.tga"
    water_level 0.0
    smooth
  }
  rotate    <-90, 0, 0> // Turn onto XY plane. Now points along -Z
  scale     <  2, 2,-2> // Scale to Cube size. Now points along +Z
  translate < -1,-1,-1> // Center around origin
  material {
    MarsLand
  }
  scale <200.0, 200.0, 10.0>
  translate  -90.0*z
}
#declare Group001 = union {
  object { HgtFld004 }
  object { HgtFld003 }
  object { HgtFld002 }
  object { HgtFld001 }
  material {
    MarsLand
  }
}
#declare Group013 = object {
  object { // Group013->Group012
    Group012
    translate  -1600.0*x
  }
}
#declare Group014 = object {
  object { // Group014->Group013
    Group013
    translate  <3200.0, -1600.0, 0.0>
  }
}
#declare Group015 = object {
  object { // Group015->Group014
    Group014
    scale <2.0, 2.0, 1.0>
    translate  <-3400.0, 3400.0, 0.0>
  }
}


#declare Cylndr003 = object {
  cylinder { // Cylndr003
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 1.0>
    translate  <1.0, 0.0, 0.5>
  }
}


#declare Cylndr23 = object {
  cylinder { // Cylndr23
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 1.0>
    translate  <1.0, 0.0, 0.5>
  }
}


#declare Cylndr35 = object {
  cylinder { // Cylndr35
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 1.0>
    translate  <1.0, 0.0, 0.5>
  }
}


#declare Cylndr47 = object {
  cylinder { // Cylndr47
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 1.0>
    translate  <1.0, 0.0, 0.5>
  }
}




//
// ********  OBJECTS  *******
//

object { // Group020->Group010
  Group010
  translate  <1285.0, -1205.8, 0.0>
}


object { // Group019->Group010
  Group010
  translate  <-315.0, -1205.8, 0.0>
}


object { // Group018->Group010
  Group010
  translate  <1285.0, 394.2, 0.0>
}


object { // Group017->Group010
  Group010
  translate  <-315.0, 394.2, 0.0>
}


sphere { // Sphere005
  <0,0,0>,1
  material {
    Mars_Sky
    translate <-0.400000, 0.800000, 0.000000>
  }
  no_shadow
  scale 20000.0
}


#declare sPatchObj5 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.488857, -0.369275, -1.291640>, <-1.479889, -0.369601, -1.185691>, <-1.479311, -0.369609, -1.042837>, <-1.458965, -0.370362, -0.938476>, 
      <-1.571435, -0.362911, -1.276603>, <-1.562468, -0.363237, -1.170654>, <-1.560978, -0.364118, -1.027614>, <-1.540631, -0.364870, -0.923253>, 
      <-1.681259, -0.314571, -1.251665>, <-1.671052, -0.315056, -1.144307>, <-1.669298, -0.315850, -1.000786>, <-1.649180, -0.316670, -0.894839>, 
      <-1.741001, -0.255768, -1.243990>, <-1.730794, -0.256253, -1.136633>, <-1.727095, -0.256564, -0.992078>, <-1.706977, -0.257384, -0.886132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.914433, -0.319472, -1.394498>, <-0.902214, -0.317655, -1.288584>, <-0.894520, -0.314625, -1.146025>, <-0.873703, -0.313415, -1.041452>, 
      <-1.059438, -0.415677, -1.370203>, <-1.047219, -0.413860, -1.264289>, <-1.043390, -0.411983, -1.125211>, <-1.022573, -0.410773, -1.020639>, 
      <-1.316490, -0.382560, -1.323026>, <-1.307522, -0.382886, -1.217076>, <-1.303635, -0.381422, -1.075583>, <-1.283288, -0.382174, -0.971222>, 
      <-1.488857, -0.369275, -1.291640>, <-1.479889, -0.369601, -1.185691>, <-1.479311, -0.369609, -1.042837>, <-1.458965, -0.370362, -0.938476>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.870963, 0.040676, -1.395167>, <-0.858871, 0.040635, -1.284514>, <-0.847019, 0.042820, -1.136401>, <-0.830656, 0.040541, -1.026321>, 
      <-0.876408, -0.067998, -1.397137>, <-0.864316, -0.068039, -1.286483>, <-0.851440, -0.064124, -1.138958>, <-0.835077, -0.066403, -1.028878>, 
      <-0.824620, -0.259883, -1.409546>, <-0.812400, -0.258066, -1.303633>, <-0.805523, -0.256422, -1.158468>, <-0.784705, -0.255212, -1.053895>, 
      <-0.914433, -0.319472, -1.394498>, <-0.902214, -0.317655, -1.288584>, <-0.894520, -0.314625, -1.146025>, <-0.873703, -0.313415, -1.041452>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.877687, 0.413889, -1.381207>, <-0.867501, 0.413161, -1.274081>, <-0.862514, 0.408659, -1.130043>, <-0.843731, 0.411461, -1.024121>, 
      <-0.781952, 0.359131, -1.401050>, <-0.771765, 0.358402, -1.293924>, <-0.766154, 0.355432, -1.146770>, <-0.747371, 0.358234, -1.040847>, 
      <-0.865356, 0.152578, -1.393139>, <-0.853264, 0.152537, -1.282485>, <-0.842420, 0.154041, -1.133742>, <-0.826057, 0.151761, -1.023662>, 
      <-0.870963, 0.040676, -1.395167>, <-0.858871, 0.040635, -1.284514>, <-0.847019, 0.042820, -1.136401>, <-0.830656, 0.040541, -1.026321>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.474941, 0.386136, -1.269979>, <-1.465393, 0.383951, -1.164987>, <-1.464374, 0.378332, -1.023287>, <-1.443114, 0.378852, -0.920006>, 
      <-1.297343, 0.415247, -1.299954>, <-1.287795, 0.413061, -1.194962>, <-1.286571, 0.407845, -1.053613>, <-1.265311, 0.408365, -0.950332>, 
      <-1.033556, 0.503042, -1.348900>, <-1.023369, 0.502313, -1.241774>, <-1.020682, 0.496029, -1.102587>, <-1.001900, 0.498831, -0.996664>, 
      <-0.877687, 0.413889, -1.381207>, <-0.867501, 0.413161, -1.274081>, <-0.862514, 0.408659, -1.130043>, <-0.843731, 0.411461, -1.024121>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.748077, 0.271223, -1.234302>, <-1.734407, 0.270530, -1.127306>, <-1.725611, 0.268941, -0.983014>, <-1.702509, 0.268914, -0.877649>, 
      <-1.682787, 0.332327, -1.238866>, <-1.669117, 0.331635, -1.131871>, <-1.663687, 0.327544, -0.989015>, <-1.640585, 0.327518, -0.883650>, 
      <-1.562101, 0.371850, -1.255268>, <-1.552553, 0.369665, -1.150276>, <-1.547521, 0.364530, -1.009106>, <-1.526261, 0.365051, -0.905825>, 
      <-1.474941, 0.386136, -1.269979>, <-1.465393, 0.383951, -1.164987>, <-1.464374, 0.378332, -1.023287>, <-1.443114, 0.378852, -0.920006>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.875480, 0.011274, -1.241975>, <-1.862214, 0.011348, -1.134099>, <-1.851544, 0.012001, -0.989167>, <-1.831260, 0.011520, -0.882389>, 
      <-1.876647, 0.098129, -1.240378>, <-1.863380, 0.098203, -1.132502>, <-1.850811, 0.098338, -0.987776>, <-1.830527, 0.097858, -0.880998>, 
      <-1.811426, 0.211935, -1.229873>, <-1.797756, 0.211242, -1.122877>, <-1.788174, 0.209733, -0.976951>, <-1.765073, 0.209706, -0.871586>, 
      <-1.748077, 0.271223, -1.234302>, <-1.734407, 0.270530, -1.127306>, <-1.725611, 0.268941, -0.983014>, <-1.702509, 0.268914, -0.877649>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.875480, 0.011274, -1.241975>, <-1.874276, -0.078403, -1.243624>, <-1.804662, -0.193107, -1.235813>, <-1.741001, -0.255768, -1.243990>, 
      <-1.862214, 0.011348, -1.134099>, <-1.861010, -0.078328, -1.135748>, <-1.794455, -0.193592, -1.128455>, <-1.730794, -0.256253, -1.136633>, 
      <-1.851544, 0.012001, -0.989167>, <-1.852298, -0.076862, -0.990599>, <-1.788797, -0.193273, -0.982783>, <-1.727095, -0.256564, -0.992078>, 
      <-1.831260, 0.011520, -0.882389>, <-1.832014, -0.077343, -0.883822>, <-1.768679, -0.194093, -0.876836>, <-1.706977, -0.257384, -0.886132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.391558, -0.372873, -0.792582>, <-1.472065, -0.367365, -0.762166>, <-1.577907, -0.319805, -0.713907>, <-1.636290, -0.260036, -0.692558>, 
      <-1.409707, -0.366992, -0.836867>, <-1.490213, -0.361484, -0.806452>, <-1.596518, -0.315971, -0.772743>, <-1.654902, -0.256202, -0.751394>, 
      <-1.449738, -0.370703, -0.891148>, <-1.531404, -0.365211, -0.875926>, <-1.637645, -0.317140, -0.834098>, <-1.695443, -0.257854, -0.825391>, 
      <-1.458965, -0.370362, -0.938476>, <-1.540631, -0.364870, -0.923253>, <-1.649180, -0.316670, -0.894839>, <-1.706977, -0.257384, -0.886132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.834964, -0.314852, -0.995299>, <-0.974755, -0.412919, -0.943103>, <-1.224864, -0.384276, -0.855559>, <-1.391558, -0.372873, -0.792582>, 
      <-0.847416, -0.309393, -1.007221>, <-0.987207, -0.407460, -0.955024>, <-1.243012, -0.378395, -0.899845>, <-1.409707, -0.366992, -0.836867>, 
      <-0.870173, -0.313210, -1.023719>, <-1.019043, -0.410568, -1.002906>, <-1.274061, -0.382516, -0.923894>, <-1.449738, -0.370703, -0.891148>, 
      <-0.873703, -0.313415, -1.041452>, <-1.022573, -0.410773, -1.020639>, <-1.283288, -0.382174, -0.971222>, <-1.458965, -0.370362, -0.938476>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.813476, 0.032669, -1.008432>, <-0.817203, -0.071793, -1.008959>, <-0.753130, -0.257443, -1.025856>, <-0.834964, -0.314852, -0.995299>, 
      <-0.819332, 0.032901, -1.013589>, <-0.823059, -0.071560, -1.014117>, <-0.765581, -0.251984, -1.037777>, <-0.847416, -0.309393, -1.007221>, 
      <-0.829508, 0.040381, -1.018601>, <-0.833930, -0.066563, -1.021158>, <-0.781175, -0.255007, -1.036163>, <-0.870173, -0.313210, -1.023719>, 
      <-0.830656, 0.040541, -1.026321>, <-0.835077, -0.066403, -1.028878>, <-0.784705, -0.255212, -1.053895>, <-0.873703, -0.313415, -1.041452>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.808597, 0.424197, -0.991568>, <-0.714550, 0.364560, -1.029290>, <-0.809284, 0.150169, -1.007839>, <-0.813476, 0.032669, -1.008432>, 
      <-0.820146, 0.418961, -0.999331>, <-0.726100, 0.359324, -1.037053>, <-0.815140, 0.150401, -1.012996>, <-0.819332, 0.032901, -1.013589>, 
      <-0.841136, 0.411849, -1.009486>, <-0.744776, 0.358621, -1.026213>, <-0.824909, 0.151601, -1.015942>, <-0.829508, 0.040381, -1.018601>, 
      <-0.843731, 0.411461, -1.024121>, <-0.747371, 0.358234, -1.040847>, <-0.826057, 0.151761, -1.023662>, <-0.830656, 0.040541, -1.026321>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.374760, 0.388589, -0.783303>, <-1.207371, 0.419864, -0.845508>, <-0.953607, 0.516151, -0.933404>, <-0.808597, 0.424197, -0.991568>, 
      <-1.391164, 0.383888, -0.825961>, <-1.223776, 0.415163, -0.888166>, <-0.965156, 0.510914, -0.941168>, <-0.820146, 0.418961, -0.999331>, 
      <-1.433851, 0.379079, -0.875005>, <-1.256048, 0.408592, -0.905331>, <-0.999305, 0.499218, -0.982029>, <-0.841136, 0.411849, -1.009486>, 
      <-1.443114, 0.378852, -0.920006>, <-1.265311, 0.408365, -0.950332>, <-1.001900, 0.498831, -0.996664>, <-0.843731, 0.411461, -1.024121>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.628087, 0.271084, -0.687028>, <-1.566317, 0.331345, -0.707169>, <-1.456579, 0.373302, -0.752897>, <-1.374760, 0.388589, -0.783303>, 
      <-1.646045, 0.267110, -0.745602>, <-1.584275, 0.327371, -0.765743>, <-1.472983, 0.368601, -0.795555>, <-1.391164, 0.383888, -0.825961>, 
      <-1.689361, 0.268899, -0.817680>, <-1.627437, 0.327503, -0.823681>, <-1.516998, 0.365277, -0.860824>, <-1.433851, 0.379079, -0.875005>, 
      <-1.702509, 0.268914, -0.877649>, <-1.640585, 0.327518, -0.883650>, <-1.526261, 0.365051, -0.905825>, <-1.443114, 0.378852, -0.920006>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.764225, 0.008637, -0.656309>, <-1.762848, 0.097796, -0.655380>, <-1.690247, 0.210443, -0.666759>, <-1.628087, 0.271084, -0.687028>, 
      <-1.786684, 0.009782, -0.723388>, <-1.785307, 0.098940, -0.722459>, <-1.708205, 0.206469, -0.725333>, <-1.646045, 0.267110, -0.745602>, 
      <-1.818057, 0.011208, -0.812885>, <-1.817324, 0.097545, -0.811493>, <-1.751924, 0.209691, -0.811617>, <-1.689361, 0.268899, -0.817680>, 
      <-1.831260, 0.011520, -0.882389>, <-1.830527, 0.097858, -0.880998>, <-1.765073, 0.209706, -0.871586>, <-1.702509, 0.268914, -0.877649>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.764225, 0.008637, -0.656309>, <-1.786684, 0.009782, -0.723388>, <-1.818057, 0.011208, -0.812885>, <-1.831260, 0.011520, -0.882389>, 
      <-1.765614, -0.081280, -0.657245>, <-1.788073, -0.080136, -0.724324>, <-1.818811, -0.077656, -0.814317>, <-1.832014, -0.077343, -0.883822>, 
      <-1.697176, -0.197705, -0.670294>, <-1.715788, -0.193871, -0.729129>, <-1.757145, -0.194563, -0.816095>, <-1.768679, -0.194093, -0.876836>, 
      <-1.636290, -0.260036, -0.692558>, <-1.654902, -0.256202, -0.751394>, <-1.695443, -0.257854, -0.825391>, <-1.706977, -0.257384, -0.886132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.318171, -0.415986, -0.594909>, <-1.398740, -0.408791, -0.543361>, <-1.510007, -0.355003, -0.476870>, <-1.565605, -0.286502, -0.439230>, 
      <-1.346099, -0.403617, -0.651793>, <-1.426668, -0.396422, -0.600245>, <-1.538852, -0.345303, -0.550098>, <-1.594450, -0.276802, -0.512458>, 
      <-1.367258, -0.380747, -0.733284>, <-1.447765, -0.375240, -0.702869>, <-1.554035, -0.324721, -0.638446>, <-1.612419, -0.264952, -0.617096>, 
      <-1.391558, -0.372873, -0.792582>, <-1.472065, -0.367365, -0.762166>, <-1.577907, -0.319805, -0.713907>, <-1.636290, -0.260036, -0.692558>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.773810, -0.357211, -0.945814>, <-0.911705, -0.465900, -0.860759>, <-1.154294, -0.430620, -0.699756>, <-1.318171, -0.415986, -0.594909>, 
      <-0.791870, -0.345463, -0.961761>, <-0.929765, -0.454152, -0.876706>, <-1.182222, -0.418252, -0.756640>, <-1.346099, -0.403617, -0.651793>, 
      <-0.816507, -0.322945, -0.977628>, <-0.956298, -0.421012, -0.925431>, <-1.200564, -0.392150, -0.796261>, <-1.367258, -0.380747, -0.733284>, 
      <-0.834964, -0.314852, -0.995299>, <-0.974755, -0.412919, -0.943103>, <-1.224864, -0.384276, -0.855559>, <-1.391558, -0.372873, -0.792582>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.743371, 0.037074, -0.949452>, <-0.749621, -0.081404, -0.949130>, <-0.689953, -0.291115, -0.997538>, <-0.773810, -0.357211, -0.945814>, 
      <-0.766012, 0.036642, -0.965084>, <-0.772262, -0.081835, -0.964762>, <-0.708013, -0.279367, -1.013484>, <-0.791870, -0.345463, -0.961761>, 
      <-0.792835, 0.031849, -0.990254>, <-0.796562, -0.072613, -0.990781>, <-0.734672, -0.265535, -1.008184>, <-0.816507, -0.322945, -0.977628>, 
      <-0.813476, 0.032669, -1.008432>, <-0.817203, -0.071793, -1.008959>, <-0.753130, -0.257443, -1.025856>, <-0.834964, -0.314852, -0.995299>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.730554, 0.462776, -0.948040>, <-0.637119, 0.400433, -1.008936>, <-0.736640, 0.164665, -0.949798>, <-0.743371, 0.037074, -0.949452>, 
      <-0.751715, 0.450782, -0.964195>, <-0.658280, 0.388439, -1.025090>, <-0.759281, 0.164233, -0.965430>, <-0.766012, 0.036642, -0.965084>, 
      <-0.785916, 0.434480, -0.976321>, <-0.691870, 0.374844, -1.014043>, <-0.788643, 0.149349, -0.989661>, <-0.792835, 0.031849, -0.990254>, 
      <-0.808597, 0.424197, -0.991568>, <-0.714550, 0.364560, -1.029290>, <-0.809284, 0.150169, -1.007839>, <-0.813476, 0.032669, -1.008432>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.311938, 0.416444, -0.578896>, <-1.139547, 0.450191, -0.688535>, <-0.881980, 0.563813, -0.849351>, <-0.730554, 0.462776, -0.948040>, 
      <-1.337997, 0.407463, -0.637425>, <-1.165606, 0.441211, -0.747064>, <-0.903141, 0.551820, -0.865506>, <-0.751715, 0.450782, -0.964195>, 
      <-1.351660, 0.395209, -0.723236>, <-1.184272, 0.426483, -0.785441>, <-0.930926, 0.526434, -0.918158>, <-0.785916, 0.434480, -0.976321>, 
      <-1.374760, 0.388589, -0.783303>, <-1.207371, 0.419864, -0.845508>, <-0.953607, 0.516151, -0.933404>, <-0.808597, 0.424197, -0.991568>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.561973, 0.300016, -0.419266>, <-1.504963, 0.368180, -0.454529>, <-1.391529, 0.400863, -0.528277>, <-1.311938, 0.416444, -0.578896>, 
      <-1.592226, 0.292127, -0.496363>, <-1.535216, 0.360291, -0.531626>, <-1.417588, 0.391882, -0.586806>, <-1.337997, 0.407463, -0.637425>, 
      <-1.603752, 0.276470, -0.607654>, <-1.541982, 0.336731, -0.627795>, <-1.433480, 0.379922, -0.692830>, <-1.351660, 0.395209, -0.723236>, 
      <-1.628087, 0.271084, -0.687028>, <-1.566317, 0.331345, -0.707169>, <-1.456579, 0.373302, -0.752897>, <-1.374760, 0.388589, -0.783303>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.657985, 0.002693, -0.364855>, <-1.657396, 0.097779, -0.361618>, <-1.618709, 0.232180, -0.384173>, <-1.561973, 0.300016, -0.419266>, 
      <-1.694188, 0.003324, -0.450605>, <-1.693599, 0.098410, -0.447368>, <-1.648961, 0.224291, -0.461270>, <-1.592226, 0.292127, -0.496363>, 
      <-1.734677, 0.007132, -0.568055>, <-1.733300, 0.096291, -0.567126>, <-1.665911, 0.215829, -0.587385>, <-1.603752, 0.276470, -0.607654>, 
      <-1.764225, 0.008637, -0.656309>, <-1.762848, 0.097796, -0.655380>, <-1.690247, 0.210443, -0.666759>, <-1.628087, 0.271084, -0.687028>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.657985, 0.002693, -0.364855>, <-1.694188, 0.003324, -0.450605>, <-1.734677, 0.007132, -0.568055>, <-1.764225, 0.008637, -0.656309>, 
      <-1.658565, -0.091022, -0.368045>, <-1.694768, -0.090391, -0.453794>, <-1.736066, -0.082785, -0.568991>, <-1.765614, -0.081280, -0.657245>, 
      <-1.619958, -0.219534, -0.402433>, <-1.648803, -0.209835, -0.475661>, <-1.673305, -0.202621, -0.594832>, <-1.697176, -0.197705, -0.670294>, 
      <-1.565605, -0.286502, -0.439230>, <-1.594450, -0.276802, -0.512458>, <-1.612419, -0.264952, -0.617096>, <-1.636290, -0.260036, -0.692558>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.207077, -0.454574, -0.416832>, <-1.281346, -0.448042, -0.346232>, <-1.394454, -0.397264, -0.259651>, <-1.445968, -0.324035, -0.209384>, 
      <-1.246273, -0.443306, -0.466183>, <-1.320542, -0.436774, -0.395583>, <-1.439454, -0.389383, -0.323545>, <-1.490968, -0.316153, -0.273278>, 
      <-1.290478, -0.428250, -0.538504>, <-1.371047, -0.421055, -0.486957>, <-1.481436, -0.364610, -0.404337>, <-1.537034, -0.296109, -0.366697>, 
      <-1.318171, -0.415986, -0.594909>, <-1.398740, -0.408791, -0.543361>, <-1.510007, -0.355003, -0.476870>, <-1.565605, -0.286502, -0.439230>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.723109, -0.387611, -0.896533>, <-0.846223, -0.502536, -0.778936>, <-1.058500, -0.467642, -0.558069>, <-1.207077, -0.454574, -0.416832>, 
      <-0.741683, -0.378982, -0.907195>, <-0.864797, -0.493908, -0.789597>, <-1.097696, -0.456373, -0.607421>, <-1.246273, -0.443306, -0.466183>, 
      <-0.758253, -0.367330, -0.932078>, <-0.896148, -0.476019, -0.847023>, <-1.126602, -0.442885, -0.643351>, <-1.290478, -0.428250, -0.538504>, 
      <-0.773810, -0.357211, -0.945814>, <-0.911705, -0.465900, -0.860759>, <-1.154294, -0.430620, -0.699756>, <-1.318171, -0.415986, -0.594909>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.682441, 0.035168, -0.917961>, <-0.687389, -0.092316, -0.917423>, <-0.646644, -0.316231, -0.969573>, <-0.723109, -0.387611, -0.896533>, 
      <-0.701751, 0.034947, -0.925087>, <-0.706699, -0.092537, -0.924549>, <-0.665217, -0.307602, -0.980235>, <-0.741683, -0.378982, -0.907195>, 
      <-0.726434, 0.037397, -0.937759>, <-0.732684, -0.081081, -0.937437>, <-0.674396, -0.301234, -0.983801>, <-0.758253, -0.367330, -0.932078>, 
      <-0.743371, 0.037074, -0.949452>, <-0.749621, -0.081404, -0.949130>, <-0.689953, -0.291115, -0.997538>, <-0.773810, -0.357211, -0.945814>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.688972, 0.491997, -0.900245>, <-0.604351, 0.424927, -0.984834>, <-0.677122, 0.172229, -0.918540>, <-0.682441, 0.035168, -0.917961>, 
      <-0.705574, 0.482206, -0.908406>, <-0.620952, 0.415137, -0.992995>, <-0.696432, 0.172008, -0.925665>, <-0.701751, 0.034947, -0.925087>, 
      <-0.715386, 0.471373, -0.936461>, <-0.621951, 0.409029, -0.997356>, <-0.719703, 0.164988, -0.938105>, <-0.726434, 0.037397, -0.937759>, 
      <-0.730554, 0.462776, -0.948040>, <-0.637119, 0.400433, -1.008936>, <-0.736640, 0.164665, -0.949798>, <-0.743371, 0.037074, -0.949452>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.203023, 0.447774, -0.397577>, <-1.048130, 0.483186, -0.544045>, <-0.822290, 0.597663, -0.766978>, <-0.688972, 0.491997, -0.900245>, 
      <-1.243248, 0.437400, -0.446457>, <-1.088354, 0.472813, -0.592925>, <-0.838892, 0.587872, -0.775139>, <-0.705574, 0.482206, -0.908406>, 
      <-1.286099, 0.425348, -0.520862>, <-1.113709, 0.459096, -0.630501>, <-0.866812, 0.572410, -0.837772>, <-0.715386, 0.471373, -0.936461>, 
      <-1.311938, 0.416444, -0.578896>, <-1.139547, 0.450191, -0.688535>, <-0.881980, 0.563813, -0.849351>, <-0.730554, 0.462776, -0.948040>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.434955, 0.321446, -0.194839>, <-1.382712, 0.392249, -0.242109>, <-1.274617, 0.431406, -0.329877>, <-1.203023, 0.447774, -0.397577>, 
      <-1.480685, 0.315217, -0.257260>, <-1.428442, 0.386019, -0.304530>, <-1.314842, 0.421032, -0.378757>, <-1.243248, 0.437400, -0.446457>, 
      <-1.533744, 0.307377, -0.347326>, <-1.476734, 0.375541, -0.382588>, <-1.365691, 0.409767, -0.470243>, <-1.286099, 0.425348, -0.520862>, 
      <-1.561973, 0.300016, -0.419266>, <-1.504963, 0.368180, -0.454529>, <-1.391529, 0.400863, -0.528277>, <-1.311938, 0.416444, -0.578896>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.530057, 0.004557, -0.101670>, <-1.528299, 0.107632, -0.099347>, <-1.488888, 0.248353, -0.146039>, <-1.434955, 0.321446, -0.194839>, 
      <-1.579137, 0.005110, -0.174457>, <-1.577379, 0.108184, -0.172135>, <-1.534618, 0.242123, -0.208460>, <-1.480685, 0.315217, -0.257260>, 
      <-1.623839, 0.002098, -0.283979>, <-1.623250, 0.097184, -0.280743>, <-1.590480, 0.239541, -0.312233>, <-1.533744, 0.307377, -0.347326>, 
      <-1.657985, 0.002693, -0.364855>, <-1.657396, 0.097779, -0.361618>, <-1.618709, 0.232180, -0.384173>, <-1.561973, 0.300016, -0.419266>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.530057, 0.004557, -0.101670>, <-1.579137, 0.005110, -0.174457>, <-1.623839, 0.002098, -0.283979>, <-1.657985, 0.002693, -0.364855>, 
      <-1.531878, -0.102162, -0.104075>, <-1.580958, -0.101610, -0.176862>, <-1.624419, -0.091617, -0.287169>, <-1.658565, -0.091022, -0.368045>, 
      <-1.499530, -0.247893, -0.157118>, <-1.544530, -0.240012, -0.221012>, <-1.591387, -0.229142, -0.329900>, <-1.619958, -0.219534, -0.402433>, 
      <-1.445968, -0.324035, -0.209384>, <-1.490968, -0.316153, -0.273278>, <-1.537034, -0.296109, -0.366697>, <-1.565605, -0.286502, -0.439230>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.002865, -0.506635, -0.197907>, <-1.061710, -0.498560, -0.100351>, <-1.147004, -0.433981, 0.028068>, <-1.187910, -0.352649, 0.097038>, 
      <-1.075033, -0.499530, -0.253152>, <-1.133878, -0.491456, -0.155596>, <-1.240860, -0.429940, -0.047379>, <-1.281766, -0.348608, 0.021591>, 
      <-1.151266, -0.470620, -0.346559>, <-1.225535, -0.464088, -0.275959>, <-1.325424, -0.409353, -0.161639>, <-1.376937, -0.336124, -0.111372>, 
      <-1.207077, -0.454574, -0.416832>, <-1.281346, -0.448042, -0.346232>, <-1.394454, -0.397264, -0.259651>, <-1.445968, -0.324035, -0.209384>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.614154, -0.431380, -0.854164>, <-0.714441, -0.559720, -0.691867>, <-0.884402, -0.522891, -0.394302>, <-1.002865, -0.506635, -0.197907>, 
      <-0.646606, -0.422835, -0.870785>, <-0.746893, -0.551175, -0.708488>, <-0.956569, -0.515786, -0.449547>, <-1.075033, -0.499530, -0.253152>, 
      <-0.692985, -0.401605, -0.879240>, <-0.816098, -0.516531, -0.761643>, <-1.002688, -0.483688, -0.487797>, <-1.151266, -0.470620, -0.346559>, 
      <-0.723109, -0.387611, -0.896533>, <-0.846223, -0.502536, -0.778936>, <-1.058500, -0.467642, -0.558069>, <-1.207077, -0.454574, -0.416832>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.576513, 0.038982, -0.887884>, <-0.580355, -0.102846, -0.884459>, <-0.552254, -0.352165, -0.954339>, <-0.614154, -0.431380, -0.854164>, 
      <-0.607610, 0.040491, -0.898988>, <-0.611452, -0.101336, -0.895564>, <-0.584707, -0.343620, -0.970959>, <-0.646606, -0.422835, -0.870785>, 
      <-0.651432, 0.035522, -0.906520>, <-0.656380, -0.091962, -0.905982>, <-0.616519, -0.330225, -0.952280>, <-0.692985, -0.401605, -0.879240>, 
      <-0.682441, 0.035168, -0.917961>, <-0.687389, -0.092316, -0.917423>, <-0.646644, -0.316231, -0.969573>, <-0.723109, -0.387611, -0.896533>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.587649, 0.547052, -0.877791>, <-0.519721, 0.471900, -0.991767>, <-0.572385, 0.191369, -0.891564>, <-0.576513, 0.038982, -0.887884>, 
      <-0.619147, 0.535696, -0.888793>, <-0.551219, 0.460543, -1.002769>, <-0.603482, 0.192879, -0.902668>, <-0.607610, 0.040491, -0.898988>, 
      <-0.661017, 0.508483, -0.886503>, <-0.576396, 0.441414, -0.971092>, <-0.646113, 0.172584, -0.907098>, <-0.651432, 0.035522, -0.906520>, 
      <-0.688972, 0.491997, -0.900245>, <-0.604351, 0.424927, -0.984834>, <-0.677122, 0.172229, -0.918540>, <-0.682441, 0.035168, -0.917961>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.992218, 0.498897, -0.190383>, <-0.870370, 0.539068, -0.392883>, <-0.694438, 0.665198, -0.698613>, <-0.587649, 0.547052, -0.877791>, 
      <-1.065700, 0.490070, -0.241576>, <-0.943852, 0.530242, -0.444077>, <-0.725936, 0.653842, -0.709615>, <-0.619147, 0.535696, -0.888793>, 
      <-1.146593, 0.462326, -0.329004>, <-0.991699, 0.497739, -0.475473>, <-0.794335, 0.614149, -0.753235>, <-0.661017, 0.508483, -0.886503>, 
      <-1.203023, 0.447774, -0.397577>, <-1.048130, 0.483186, -0.544045>, <-0.822290, 0.597663, -0.766978>, <-0.688972, 0.491997, -0.900245>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.178508, 0.352255, 0.104159>, <-1.135968, 0.432773, 0.036530>, <-1.049874, 0.479888, -0.094564>, <-0.992218, 0.498897, -0.190383>, 
      <-1.272356, 0.347115, 0.031934>, <-1.229816, 0.427634, -0.035694>, <-1.123356, 0.471062, -0.145758>, <-1.065700, 0.490070, -0.241576>, 
      <-1.365129, 0.330958, -0.099528>, <-1.312886, 0.401761, -0.146798>, <-1.218187, 0.445958, -0.261305>, <-1.146593, 0.462326, -0.329004>, 
      <-1.434955, 0.321446, -0.194839>, <-1.382712, 0.392249, -0.242109>, <-1.274617, 0.431406, -0.329877>, <-1.203023, 0.447774, -0.397577>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.256761, -0.001821, 0.230178>, <-1.255225, 0.113331, 0.231341>, <-1.221699, 0.270503, 0.172823>, <-1.178508, 0.352255, 0.104159>, 
      <-1.357734, -0.000460, 0.149932>, <-1.356198, 0.114692, 0.151095>, <-1.315547, 0.265364, 0.100599>, <-1.272356, 0.347115, 0.031934>, 
      <-1.457948, 0.003746, 0.005272>, <-1.456189, 0.106821, 0.007595>, <-1.419062, 0.257865, -0.050728>, <-1.365129, 0.330958, -0.099528>, 
      <-1.530057, 0.004557, -0.101670>, <-1.528299, 0.107632, -0.099347>, <-1.488888, 0.248353, -0.146039>, <-1.434955, 0.321446, -0.194839>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.256761, -0.001821, 0.230178>, <-1.357734, -0.000460, 0.149932>, <-1.457948, 0.003746, 0.005272>, <-1.530057, 0.004557, -0.101670>, 
      <-1.258287, -0.116257, 0.229022>, <-1.359261, -0.114896, 0.148776>, <-1.459769, -0.102973, 0.002867>, <-1.531878, -0.102162, -0.104075>, 
      <-1.228900, -0.271148, 0.166152>, <-1.322757, -0.267107, 0.090704>, <-1.430500, -0.259983, -0.059106>, <-1.499530, -0.247893, -0.157118>, 
      <-1.187910, -0.352649, 0.097038>, <-1.281766, -0.348608, 0.021591>, <-1.376937, -0.336124, -0.111372>, <-1.445968, -0.324035, -0.209384>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.772648, -0.497342, -0.084274>, <-0.802352, -0.489417, 0.026608>, <-0.845765, -0.429661, 0.177358>, <-0.865884, -0.349011, 0.256924>, 
      <-0.843423, -0.499745, -0.114688>, <-0.873127, -0.491820, -0.003805>, <-0.943150, -0.427443, 0.131031>, <-0.963269, -0.346793, 0.210598>, 
      <-0.941854, -0.512641, -0.151202>, <-1.000698, -0.504567, -0.053646>, <-1.062981, -0.437599, 0.095611>, <-1.103887, -0.356267, 0.164581>, 
      <-1.002865, -0.506635, -0.197907>, <-1.061710, -0.498560, -0.100351>, <-1.147004, -0.433981, 0.028068>, <-1.187910, -0.352649, 0.097038>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.576950, -0.426097, -0.821678>, <-0.629573, -0.550516, -0.635685>, <-0.713308, -0.513173, -0.305793>, <-0.772648, -0.497342, -0.084274>, 
      <-0.588886, -0.426154, -0.830598>, <-0.641510, -0.550572, -0.644606>, <-0.784083, -0.515576, -0.336206>, <-0.843423, -0.499745, -0.114688>, 
      <-0.601240, -0.434781, -0.847551>, <-0.701527, -0.563121, -0.685254>, <-0.823390, -0.528897, -0.347597>, <-0.941854, -0.512641, -0.151202>, 
      <-0.614154, -0.431380, -0.854164>, <-0.714441, -0.559720, -0.691867>, <-0.884402, -0.522891, -0.394302>, <-1.002865, -0.506635, -0.197907>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.550139, 0.028745, -0.870717>, <-0.554668, -0.108601, -0.866715>, <-0.545478, -0.351687, -0.932913>, <-0.576950, -0.426097, -0.821678>, 
      <-0.558198, 0.028819, -0.876515>, <-0.562726, -0.108528, -0.872513>, <-0.557415, -0.351744, -0.941833>, <-0.588886, -0.426154, -0.830598>, 
      <-0.567174, 0.038528, -0.884549>, <-0.571016, -0.103299, -0.881124>, <-0.539341, -0.355565, -0.947725>, <-0.601240, -0.434781, -0.847551>, 
      <-0.576513, 0.038982, -0.887884>, <-0.580355, -0.102846, -0.884459>, <-0.552254, -0.352165, -0.954339>, <-0.614154, -0.431380, -0.854164>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.544968, 0.543915, -0.849946>, <-0.511937, 0.466105, -0.979490>, <-0.545044, 0.183280, -0.875221>, <-0.550139, 0.028745, -0.870717>, 
      <-0.558093, 0.544410, -0.857827>, <-0.525062, 0.466599, -0.987371>, <-0.553103, 0.183353, -0.881019>, <-0.558198, 0.028819, -0.876515>, 
      <-0.573960, 0.551988, -0.873010>, <-0.506031, 0.476835, -0.986985>, <-0.563046, 0.190916, -0.888229>, <-0.567174, 0.038528, -0.884549>, 
      <-0.587649, 0.547052, -0.877791>, <-0.519721, 0.471900, -0.991767>, <-0.572385, 0.191369, -0.891564>, <-0.576513, 0.038982, -0.887884>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.751066, 0.502062, -0.082705>, <-0.689320, 0.541062, -0.309920>, <-0.595932, 0.663969, -0.650072>, <-0.544968, 0.543915, -0.849946>, 
      <-0.824530, 0.502571, -0.112389>, <-0.762784, 0.541570, -0.339603>, <-0.609057, 0.664463, -0.657953>, <-0.558093, 0.544410, -0.857827>, 
      <-0.927518, 0.506668, -0.145307>, <-0.805670, 0.546840, -0.347808>, <-0.680749, 0.670134, -0.693831>, <-0.573960, 0.551988, -0.873010>, 
      <-0.992218, 0.498897, -0.190383>, <-0.870370, 0.539068, -0.392883>, <-0.694438, 0.665198, -0.698613>, <-0.587649, 0.547052, -0.877791>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.846139, 0.353692, 0.258306>, <-0.822868, 0.435102, 0.180258>, <-0.780859, 0.483245, 0.026926>, <-0.751066, 0.502062, -0.082705>, 
      <-0.945925, 0.354752, 0.212234>, <-0.922653, 0.436162, 0.134186>, <-0.854322, 0.483753, -0.002757>, <-0.824530, 0.502571, -0.112389>, 
      <-1.091485, 0.357020, 0.171130>, <-1.048945, 0.437539, 0.103501>, <-0.985174, 0.487660, -0.049489>, <-0.927518, 0.506668, -0.145307>, 
      <-1.178508, 0.352255, 0.104159>, <-1.135968, 0.432773, 0.036530>, <-1.049874, 0.479888, -0.094564>, <-0.992218, 0.498897, -0.190383>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.895722, -0.003993, 0.402450>, <-0.892446, 0.112604, 0.402680>, <-0.869711, 0.271229, 0.337363>, <-0.846139, 0.353692, 0.258306>, 
      <-1.004390, -0.005296, 0.351534>, <-1.001114, 0.111301, 0.351764>, <-0.969497, 0.272289, 0.291291>, <-0.945925, 0.354752, 0.212234>, 
      <-1.162811, -0.003087, 0.304842>, <-1.161275, 0.112065, 0.306005>, <-1.134676, 0.275269, 0.239795>, <-1.091485, 0.357020, 0.171130>, 
      <-1.256761, -0.001821, 0.230178>, <-1.255225, 0.113331, 0.231341>, <-1.221699, 0.270503, 0.172823>, <-1.178508, 0.352255, 0.104159>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.895722, -0.003993, 0.402450>, <-1.004390, -0.005296, 0.351534>, <-1.162811, -0.003087, 0.304842>, <-1.256761, -0.001821, 0.230178>, 
      <-0.898888, -0.116640, 0.402229>, <-1.007555, -0.117944, 0.351313>, <-1.164337, -0.117523, 0.303686>, <-1.258287, -0.116257, 0.229022>, 
      <-0.885589, -0.270025, 0.334850>, <-0.982974, -0.267807, 0.288523>, <-1.144878, -0.274766, 0.233694>, <-1.228900, -0.271148, 0.166152>, 
      <-0.865884, -0.349011, 0.256924>, <-0.963269, -0.346793, 0.210598>, <-1.103887, -0.356267, 0.164581>, <-1.187910, -0.352649, 0.097038>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.635732, -0.494168, -0.040142>, <-0.654721, -0.487123, 0.076181>, <-0.695954, -0.444933, 0.239220>, <-0.712947, -0.363466, 0.322979>, 
      <-0.678193, -0.494147, -0.047915>, <-0.697182, -0.487103, 0.068408>, <-0.745261, -0.444018, 0.230026>, <-0.762254, -0.362551, 0.313785>, 
      <-0.733008, -0.495995, -0.067240>, <-0.762711, -0.488071, 0.043643>, <-0.800473, -0.430692, 0.198903>, <-0.820592, -0.350043, 0.278469>, 
      <-0.772648, -0.497342, -0.084274>, <-0.802352, -0.489417, 0.026608>, <-0.845765, -0.429661, 0.177358>, <-0.865884, -0.349011, 0.256924>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.530935, -0.430988, -0.791975>, <-0.560977, -0.556652, -0.603490>, <-0.598980, -0.507802, -0.265273>, <-0.635732, -0.494168, -0.040142>, 
      <-0.546550, -0.430610, -0.797279>, <-0.576593, -0.556274, -0.608794>, <-0.641441, -0.507781, -0.273046>, <-0.678193, -0.494147, -0.047915>, 
      <-0.563736, -0.426035, -0.811803>, <-0.616359, -0.550454, -0.625811>, <-0.673668, -0.511827, -0.288758>, <-0.733008, -0.495995, -0.067240>, 
      <-0.576950, -0.426097, -0.821678>, <-0.629573, -0.550516, -0.635685>, <-0.713308, -0.513173, -0.305793>, <-0.772648, -0.497342, -0.084274>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.508420, 0.038363, -0.838891>, <-0.512003, -0.103158, -0.833529>, <-0.512310, -0.353083, -0.908824>, <-0.530935, -0.430988, -0.791975>, 
      <-0.523146, 0.038056, -0.845152>, <-0.526729, -0.103466, -0.839789>, <-0.527926, -0.352706, -0.914128>, <-0.546550, -0.430610, -0.797279>, 
      <-0.537149, 0.028627, -0.861370>, <-0.541677, -0.108719, -0.857368>, <-0.532264, -0.351625, -0.923038>, <-0.563736, -0.426035, -0.811803>, 
      <-0.550139, 0.028745, -0.870717>, <-0.554668, -0.108601, -0.866715>, <-0.545478, -0.351687, -0.932913>, <-0.576950, -0.426097, -0.821678>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.506250, 0.543984, -0.828916>, <-0.488930, 0.469188, -0.959773>, <-0.504583, 0.189923, -0.844633>, <-0.508420, 0.038363, -0.838891>, 
      <-0.518796, 0.543437, -0.833042>, <-0.501476, 0.468641, -0.963899>, <-0.519308, 0.189615, -0.850894>, <-0.523146, 0.038056, -0.845152>, 
      <-0.533642, 0.543488, -0.843145>, <-0.500611, 0.465678, -0.972689>, <-0.532054, 0.183162, -0.865874>, <-0.537149, 0.028627, -0.861370>, 
      <-0.544968, 0.543915, -0.849946>, <-0.511937, 0.466105, -0.979490>, <-0.545044, 0.183280, -0.875221>, <-0.550139, 0.028745, -0.870717>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.614462, 0.496284, -0.037750>, <-0.575185, 0.536092, -0.271130>, <-0.533648, 0.662296, -0.621925>, <-0.506250, 0.543984, -0.828916>, 
      <-0.656770, 0.496137, -0.046372>, <-0.617493, 0.535946, -0.279752>, <-0.546194, 0.661750, -0.626051>, <-0.518796, 0.543437, -0.833042>, 
      <-0.711033, 0.501786, -0.066530>, <-0.649287, 0.540785, -0.293744>, <-0.584606, 0.663542, -0.643271>, <-0.533642, 0.543488, -0.843145>, 
      <-0.751066, 0.502062, -0.082705>, <-0.689320, 0.541062, -0.309920>, <-0.595932, 0.663969, -0.650072>, <-0.544968, 0.543915, -0.849946>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.700433, 0.347176, 0.324890>, <-0.679474, 0.429485, 0.239521>, <-0.634171, 0.476309, 0.079359>, <-0.614462, 0.496284, -0.037750>, 
      <-0.747709, 0.347760, 0.316047>, <-0.726750, 0.430069, 0.230679>, <-0.676479, 0.476162, 0.070736>, <-0.656770, 0.496137, -0.046372>, 
      <-0.802472, 0.353228, 0.278467>, <-0.779200, 0.434638, 0.200419>, <-0.740826, 0.482968, 0.043101>, <-0.711033, 0.501786, -0.066530>, 
      <-0.846139, 0.353692, 0.258306>, <-0.822868, 0.435102, 0.180258>, <-0.780859, 0.483245, 0.026926>, <-0.751066, 0.502062, -0.082705>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.739721, 0.004379, 0.472436>, <-0.737739, 0.116940, 0.472738>, <-0.720027, 0.270228, 0.404697>, <-0.700433, 0.347176, 0.324890>, 
      <-0.790362, 0.003029, 0.464004>, <-0.788380, 0.115591, 0.464306>, <-0.767303, 0.270812, 0.395854>, <-0.747709, 0.347760, 0.316047>, 
      <-0.849221, -0.003435, 0.424238>, <-0.845945, 0.113162, 0.424468>, <-0.826044, 0.270765, 0.357524>, <-0.802472, 0.353228, 0.278467>, 
      <-0.895722, -0.003993, 0.402450>, <-0.892446, 0.112604, 0.402680>, <-0.869711, 0.271229, 0.337363>, <-0.846139, 0.353692, 0.258306>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.739721, 0.004379, 0.472436>, <-0.790362, 0.003029, 0.464004>, <-0.849221, -0.003435, 0.424238>, <-0.895722, -0.003993, 0.402450>, 
      <-0.741823, -0.114987, 0.472115>, <-0.792464, -0.116337, 0.463683>, <-0.852386, -0.116083, 0.424017>, <-0.898888, -0.116640, 0.402229>, 
      <-0.730128, -0.281094, 0.407670>, <-0.779436, -0.280180, 0.398475>, <-0.840297, -0.271056, 0.356395>, <-0.885589, -0.270025, 0.334850>, 
      <-0.712947, -0.363466, 0.322979>, <-0.762254, -0.362551, 0.313785>, <-0.820592, -0.350043, 0.278469>, <-0.865884, -0.349011, 0.256924>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.442387, -0.497502, -0.023818>, <-0.440978, -0.490034, 0.091758>, <-0.444618, -0.438960, 0.254055>, <-0.443240, -0.356850, 0.335734>, 
      <-0.500486, -0.497668, -0.027533>, <-0.499077, -0.490199, 0.088042>, <-0.525540, -0.441219, 0.250615>, <-0.524162, -0.359109, 0.332294>, 
      <-0.578465, -0.494196, -0.029659>, <-0.597454, -0.487151, 0.086664>, <-0.616313, -0.446410, 0.254070>, <-0.633306, -0.364943, 0.337830>, 
      <-0.635732, -0.494168, -0.040142>, <-0.654721, -0.487123, 0.076181>, <-0.695954, -0.444933, 0.239220>, <-0.712947, -0.363466, 0.322979>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.456853, -0.429004, -0.780887>, <-0.453151, -0.553814, -0.590011>, <-0.445161, -0.512209, -0.251416>, <-0.442387, -0.497502, -0.023818>, 
      <-0.479327, -0.428767, -0.781373>, <-0.475625, -0.553577, -0.590497>, <-0.503261, -0.512374, -0.255132>, <-0.500486, -0.497668, -0.027533>, 
      <-0.509655, -0.431503, -0.784747>, <-0.539697, -0.557167, -0.596262>, <-0.541713, -0.507830, -0.254790>, <-0.578465, -0.494196, -0.029659>, 
      <-0.530935, -0.430988, -0.791975>, <-0.560977, -0.556652, -0.603490>, <-0.598980, -0.507802, -0.265273>, <-0.635732, -0.494168, -0.040142>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.458052, 0.030667, -0.831565>, <-0.459991, -0.107965, -0.826518>, <-0.459105, -0.353087, -0.896989>, <-0.456853, -0.429004, -0.780887>, 
      <-0.473486, 0.030608, -0.832113>, <-0.475424, -0.108024, -0.827065>, <-0.481578, -0.352850, -0.897475>, <-0.479327, -0.428767, -0.781373>, 
      <-0.494211, 0.038659, -0.832850>, <-0.497794, -0.102862, -0.827488>, <-0.491030, -0.353598, -0.901597>, <-0.509655, -0.431503, -0.784747>, 
      <-0.508420, 0.038363, -0.838891>, <-0.512003, -0.103158, -0.833529>, <-0.512310, -0.353083, -0.908824>, <-0.530935, -0.430988, -0.791975>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.443188, 0.548346, -0.816472>, <-0.448978, 0.470490, -0.950876>, <-0.455881, 0.185983, -0.837221>, <-0.458052, 0.030667, -0.831565>, 
      <-0.462480, 0.547830, -0.817537>, <-0.468270, 0.469973, -0.951941>, <-0.471314, 0.185924, -0.837768>, <-0.473486, 0.030608, -0.832113>, 
      <-0.487906, 0.544782, -0.822882>, <-0.470585, 0.469986, -0.953739>, <-0.490374, 0.190219, -0.838592>, <-0.494211, 0.038659, -0.832850>, 
      <-0.506250, 0.543984, -0.828916>, <-0.488930, 0.469188, -0.959773>, <-0.504583, 0.189923, -0.844633>, <-0.508420, 0.038363, -0.838891>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.422911, 0.503200, -0.015828>, <-0.426881, 0.544271, -0.252915>, <-0.434223, 0.668889, -0.608379>, <-0.443188, 0.548346, -0.816472>, 
      <-0.480704, 0.501997, -0.018708>, <-0.484674, 0.543068, -0.255796>, <-0.453515, 0.668372, -0.609444>, <-0.462480, 0.547830, -0.817537>, 
      <-0.557751, 0.496480, -0.026192>, <-0.518473, 0.536289, -0.259572>, <-0.515304, 0.663095, -0.615892>, <-0.487906, 0.544782, -0.822882>, 
      <-0.614462, 0.496284, -0.037750>, <-0.575185, 0.536092, -0.271130>, <-0.533648, 0.662296, -0.621925>, <-0.506250, 0.543984, -0.828916>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.423869, 0.348477, 0.337290>, <-0.422054, 0.430226, 0.255493>, <-0.421003, 0.483461, 0.098118>, <-0.422911, 0.503200, -0.015828>, 
      <-0.506882, 0.346973, 0.335163>, <-0.505067, 0.428722, 0.253366>, <-0.478797, 0.482258, 0.095237>, <-0.480704, 0.501997, -0.018708>, 
      <-0.618801, 0.346168, 0.340158>, <-0.597842, 0.428477, 0.254790>, <-0.577460, 0.476505, 0.090916>, <-0.557751, 0.496480, -0.026192>, 
      <-0.700433, 0.347176, 0.324890>, <-0.679474, 0.429485, 0.239521>, <-0.634171, 0.476309, 0.079359>, <-0.614462, 0.496284, -0.037750>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.433898, 0.008317, 0.479349>, <-0.430861, 0.118905, 0.479593>, <-0.425605, 0.270282, 0.415531>, <-0.423869, 0.348477, 0.337290>, 
      <-0.525665, 0.009633, 0.478793>, <-0.522628, 0.120222, 0.479037>, <-0.508617, 0.268778, 0.413404>, <-0.506882, 0.346973, 0.335163>, 
      <-0.649221, 0.006791, 0.487505>, <-0.647239, 0.119353, 0.487808>, <-0.638396, 0.269220, 0.419966>, <-0.618801, 0.346168, 0.340158>, 
      <-0.739721, 0.004379, 0.472436>, <-0.737739, 0.116940, 0.472738>, <-0.720027, 0.270228, 0.404697>, <-0.700433, 0.347176, 0.324890>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.433898, 0.008317, 0.479349>, <-0.525665, 0.009633, 0.478793>, <-0.649221, 0.006791, 0.487505>, <-0.739721, 0.004379, 0.472436>, 
      <-0.437130, -0.109390, 0.479089>, <-0.528897, -0.108074, 0.478533>, <-0.651323, -0.112575, 0.487184>, <-0.741823, -0.114987, 0.472115>, 
      <-0.441839, -0.273375, 0.418772>, <-0.522761, -0.275634, 0.415332>, <-0.650488, -0.282571, 0.422520>, <-0.730128, -0.281094, 0.407670>, 
      <-0.443240, -0.356850, 0.335734>, <-0.524162, -0.359109, 0.332294>, <-0.633306, -0.364943, 0.337830>, <-0.712947, -0.363466, 0.322979>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.306163, -0.493229, -0.019065>, <-0.305679, -0.484962, 0.096334>, <-0.320334, -0.433963, 0.257742>, <-0.317642, -0.352431, 0.339783>, 
      <-0.346824, -0.494130, -0.023497>, <-0.346341, -0.485862, 0.091902>, <-0.358021, -0.433988, 0.256124>, <-0.355329, -0.352456, 0.338166>, 
      <-0.401558, -0.497386, -0.021207>, <-0.400149, -0.489918, 0.094369>, <-0.406944, -0.437908, 0.255656>, <-0.405566, -0.355798, 0.337336>, 
      <-0.442387, -0.497502, -0.023818>, <-0.440978, -0.490034, 0.091758>, <-0.444618, -0.438960, 0.254055>, <-0.443240, -0.356850, 0.335734>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.322364, -0.433187, -0.787464>, <-0.320649, -0.559884, -0.593990>, <-0.307129, -0.509755, -0.249746>, <-0.306163, -0.493229, -0.019065>, 
      <-0.362699, -0.431744, -0.789548>, <-0.360984, -0.558441, -0.596074>, <-0.347791, -0.510656, -0.254177>, <-0.346824, -0.494130, -0.023497>, 
      <-0.416451, -0.429430, -0.780013>, <-0.412749, -0.554240, -0.589137>, <-0.404333, -0.512093, -0.248805>, <-0.401558, -0.497386, -0.021207>, 
      <-0.456853, -0.429004, -0.780887>, <-0.453151, -0.553814, -0.590011>, <-0.445161, -0.512209, -0.251416>, <-0.442387, -0.497502, -0.023818>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.313371, 0.039107, -0.831975>, <-0.316039, -0.103142, -0.827591>, <-0.323420, -0.355209, -0.906542>, <-0.322364, -0.433187, -0.787464>, 
      <-0.356731, 0.037374, -0.834676>, <-0.359399, -0.104875, -0.830291>, <-0.363755, -0.353766, -0.908625>, <-0.362699, -0.431744, -0.789548>, 
      <-0.414602, 0.030832, -0.830025>, <-0.416540, -0.107799, -0.824977>, <-0.418702, -0.353513, -0.896115>, <-0.416451, -0.429430, -0.780013>, 
      <-0.458052, 0.030667, -0.831565>, <-0.459991, -0.107965, -0.826518>, <-0.459105, -0.353087, -0.896989>, <-0.456853, -0.429004, -0.780887>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.303935, 0.549405, -0.817751>, <-0.308086, 0.473334, -0.950637>, <-0.310500, 0.192182, -0.836694>, <-0.313371, 0.039107, -0.831975>, 
      <-0.345639, 0.550682, -0.819902>, <-0.349789, 0.474611, -0.952788>, <-0.353860, 0.190449, -0.839394>, <-0.356731, 0.037374, -0.834676>, 
      <-0.401488, 0.549464, -0.814171>, <-0.407278, 0.471608, -0.948575>, <-0.412430, 0.186148, -0.835680>, <-0.414602, 0.030832, -0.830025>, 
      <-0.443188, 0.548346, -0.816472>, <-0.448978, 0.470490, -0.950876>, <-0.455881, 0.185983, -0.837221>, <-0.458052, 0.030667, -0.831565>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.288059, 0.503077, -0.021480>, <-0.288977, 0.542983, -0.257460>, <-0.297451, 0.668264, -0.610120>, <-0.303935, 0.549405, -0.817751>, 
      <-0.328456, 0.503664, -0.024173>, <-0.329374, 0.543570, -0.260153>, <-0.339155, 0.669540, -0.612271>, <-0.345639, 0.550682, -0.819902>, 
      <-0.382479, 0.504041, -0.013812>, <-0.386449, 0.545113, -0.250900>, <-0.392523, 0.670006, -0.606078>, <-0.401488, 0.549464, -0.814171>, 
      <-0.422911, 0.503200, -0.015828>, <-0.426881, 0.544271, -0.252915>, <-0.434223, 0.668889, -0.608379>, <-0.443188, 0.548346, -0.816472>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.299449, 0.354440, 0.335162>, <-0.299141, 0.437131, 0.253863>, <-0.287614, 0.483742, 0.092859>, <-0.288059, 0.503077, -0.021480>, 
      <-0.336778, 0.353292, 0.333721>, <-0.336469, 0.435984, 0.252422>, <-0.328011, 0.484329, 0.090166>, <-0.328456, 0.503664, -0.024173>, 
      <-0.386513, 0.349154, 0.338247>, <-0.384698, 0.430902, 0.256450>, <-0.380571, 0.484302, 0.100133>, <-0.382479, 0.504041, -0.013812>, 
      <-0.423869, 0.348477, 0.337290>, <-0.422054, 0.430226, 0.255493>, <-0.421003, 0.483461, 0.098118>, <-0.422911, 0.503200, -0.015828>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.289946, -0.002072, 0.475160>, <-0.286989, 0.112827, 0.474409>, <-0.299756, 0.272478, 0.415743>, <-0.299449, 0.354440, 0.335162>, 
      <-0.333019, 0.000363, 0.471275>, <-0.330062, 0.115262, 0.470524>, <-0.337084, 0.271331, 0.414302>, <-0.336778, 0.353292, 0.333721>, 
      <-0.390587, 0.007696, 0.479611>, <-0.387550, 0.118284, 0.479855>, <-0.388249, 0.270959, 0.416488>, <-0.386513, 0.349154, 0.338247>, 
      <-0.433898, 0.008317, 0.479349>, <-0.430861, 0.118905, 0.479593>, <-0.425605, 0.270282, 0.415531>, <-0.423869, 0.348477, 0.337290>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.289946, -0.002072, 0.475160>, <-0.333019, 0.000363, 0.471275>, <-0.390587, 0.007696, 0.479611>, <-0.433898, 0.008317, 0.479349>, 
      <-0.292853, -0.115019, 0.475899>, <-0.335926, -0.112585, 0.472013>, <-0.393820, -0.110011, 0.479351>, <-0.437130, -0.109390, 0.479089>, 
      <-0.315013, -0.272807, 0.419904>, <-0.352700, -0.272833, 0.418286>, <-0.404165, -0.272323, 0.420373>, <-0.441839, -0.273375, 0.418772>, 
      <-0.317642, -0.352431, 0.339783>, <-0.355329, -0.352456, 0.338166>, <-0.405566, -0.355798, 0.337336>, <-0.443240, -0.356850, 0.335734>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.184498, -0.491793, 0.004288>, <-0.184033, -0.483677, 0.114501>, <-0.184024, -0.433677, 0.267749>, <-0.181376, -0.356674, 0.346973>, 
      <-0.221438, -0.490540, 0.000369>, <-0.220973, -0.482424, 0.110582>, <-0.224928, -0.434230, 0.265759>, <-0.222280, -0.357227, 0.344983>, 
      <-0.269222, -0.492412, -0.015039>, <-0.268739, -0.484144, 0.100360>, <-0.279415, -0.433935, 0.259498>, <-0.276723, -0.352403, 0.341539>, 
      <-0.306163, -0.493229, -0.019065>, <-0.305679, -0.484962, 0.096334>, <-0.320334, -0.433963, 0.257742>, <-0.317642, -0.352431, 0.339783>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.186068, -0.438694, -0.766895>, <-0.187642, -0.565359, -0.572646>, <-0.185472, -0.508823, -0.226987>, <-0.184498, -0.491793, 0.004288>, 
      <-0.227221, -0.439450, -0.771204>, <-0.228795, -0.566114, -0.576955>, <-0.222412, -0.507570, -0.230906>, <-0.221438, -0.490540, 0.000369>, 
      <-0.281061, -0.434665, -0.785330>, <-0.279345, -0.561362, -0.591856>, <-0.270189, -0.508938, -0.245720>, <-0.269222, -0.492412, -0.015039>, 
      <-0.322364, -0.433187, -0.787464>, <-0.320649, -0.559884, -0.593990>, <-0.307129, -0.509755, -0.249746>, <-0.306163, -0.493229, -0.019065>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.177867, 0.041863, -0.814116>, <-0.181634, -0.102878, -0.808938>, <-0.185085, -0.359561, -0.888254>, <-0.186068, -0.438694, -0.766895>, 
      <-0.218718, 0.042434, -0.817696>, <-0.222484, -0.102307, -0.812518>, <-0.226238, -0.360316, -0.892563>, <-0.227221, -0.439450, -0.771204>, 
      <-0.272472, 0.040741, -0.829428>, <-0.275140, -0.101508, -0.825044>, <-0.282117, -0.356687, -0.904407>, <-0.281061, -0.434665, -0.785330>, 
      <-0.313371, 0.039107, -0.831975>, <-0.316039, -0.103142, -0.827591>, <-0.323420, -0.355209, -0.906542>, <-0.322364, -0.433187, -0.787464>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.160606, 0.539698, -0.801898>, <-0.164297, 0.466634, -0.932259>, <-0.173981, 0.191203, -0.819459>, <-0.177867, 0.041863, -0.814116>, 
      <-0.203822, 0.540569, -0.805301>, <-0.207513, 0.467506, -0.935661>, <-0.214831, 0.191773, -0.823039>, <-0.218718, 0.042434, -0.817696>, 
      <-0.260654, 0.548080, -0.815519>, <-0.264804, 0.472010, -0.948405>, <-0.269601, 0.193817, -0.834146>, <-0.272472, 0.040741, -0.829428>, 
      <-0.303935, 0.549405, -0.817751>, <-0.308086, 0.473334, -0.950637>, <-0.310500, 0.192182, -0.836694>, <-0.313371, 0.039107, -0.831975>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.154759, 0.499301, 0.002046>, <-0.154196, 0.537319, -0.236436>, <-0.154643, 0.657733, -0.591300>, <-0.160606, 0.539698, -0.801898>, 
      <-0.195188, 0.499006, -0.001916>, <-0.194625, 0.537024, -0.240398>, <-0.197860, 0.658604, -0.594703>, <-0.203822, 0.540569, -0.805301>, 
      <-0.247529, 0.502488, -0.018779>, <-0.248447, 0.542394, -0.254759>, <-0.254170, 0.666940, -0.607888>, <-0.260654, 0.548080, -0.815519>, 
      <-0.288059, 0.503077, -0.021480>, <-0.288977, 0.542983, -0.257460>, <-0.297451, 0.668264, -0.610120>, <-0.303935, 0.549405, -0.817751>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.163320, 0.356487, 0.347347>, <-0.161265, 0.436132, 0.268445>, <-0.155021, 0.481648, 0.112777>, <-0.154759, 0.499301, 0.002046>, 
      <-0.204214, 0.356026, 0.344334>, <-0.202158, 0.435672, 0.265432>, <-0.195450, 0.481353, 0.108815>, <-0.195188, 0.499006, -0.001916>, 
      <-0.258493, 0.355699, 0.336743>, <-0.258184, 0.438391, 0.255444>, <-0.247084, 0.483152, 0.095560>, <-0.247529, 0.502488, -0.018779>, 
      <-0.299449, 0.354440, 0.335162>, <-0.299141, 0.437131, 0.253863>, <-0.287614, 0.483742, 0.092859>, <-0.288059, 0.503077, -0.021480>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.167819, -0.006723, 0.503350>, <-0.164817, 0.111835, 0.503412>, <-0.165494, 0.272249, 0.430799>, <-0.163320, 0.356487, 0.347347>, 
      <-0.205285, -0.007223, 0.499905>, <-0.202283, 0.111335, 0.499967>, <-0.206388, 0.271788, 0.427786>, <-0.204214, 0.356026, 0.344334>, 
      <-0.252530, -0.004187, 0.478535>, <-0.249573, 0.110713, 0.477784>, <-0.258799, 0.273737, 0.417324>, <-0.258493, 0.355699, 0.336743>, 
      <-0.289946, -0.002072, 0.475160>, <-0.286989, 0.112827, 0.474409>, <-0.299756, 0.272478, 0.415743>, <-0.299449, 0.354440, 0.335162>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.167819, -0.006723, 0.503350>, <-0.205285, -0.007223, 0.499905>, <-0.252530, -0.004187, 0.478535>, <-0.289946, -0.002072, 0.475160>, 
      <-0.170731, -0.121749, 0.503290>, <-0.208197, -0.122249, 0.499845>, <-0.255437, -0.117134, 0.479274>, <-0.292853, -0.115019, 0.475899>, 
      <-0.178620, -0.276501, 0.429459>, <-0.219524, -0.277054, 0.427469>, <-0.274094, -0.272780, 0.421660>, <-0.315013, -0.272807, 0.419904>, 
      <-0.181376, -0.356674, 0.346973>, <-0.222280, -0.357227, 0.344983>, <-0.276723, -0.352403, 0.341539>, <-0.317642, -0.352431, 0.339783>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.419804, -0.366642, -1.296251>, <1.505106, -0.360147, -1.281022>, <1.622321, -0.318499, -1.254076>, <1.682847, -0.256850, -1.244775>, 
      <1.407937, -0.367059, -1.188064>, <1.493240, -0.360565, -1.172834>, <1.608951, -0.319978, -1.146098>, <1.669477, -0.258328, -1.136797>, 
      <1.401651, -0.367399, -1.042337>, <1.485368, -0.361154, -1.028448>, <1.600648, -0.320428, -0.999253>, <1.661809, -0.261836, -0.991087>, 
      <1.380250, -0.368035, -0.935626>, <1.463967, -0.361790, -0.921738>, <1.577121, -0.320371, -0.893015>, <1.638282, -0.261778, -0.884849>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.840253, -0.320999, -1.395209>, <0.987593, -0.415977, -1.371376>, <1.246132, -0.379864, -1.327258>, <1.419804, -0.366642, -1.296251>, 
      <0.828249, -0.321987, -1.283808>, <0.975590, -0.416965, -1.259976>, <1.234266, -0.380282, -1.219070>, <1.407937, -0.367059, -1.188064>, 
      <0.819318, -0.323466, -1.134285>, <0.966614, -0.417787, -1.110673>, <1.228007, -0.380352, -1.071143>, <1.401651, -0.367399, -1.042337>, 
      <0.800242, -0.324293, -1.023875>, <0.947538, -0.418614, -1.000263>, <1.206606, -0.380988, -0.964433>, <1.380250, -0.368035, -0.935626>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.804245, 0.030159, -1.395820>, <0.809612, -0.075601, -1.396643>, <0.752054, -0.264145, -1.409475>, <0.840253, -0.320999, -1.395209>, 
      <0.790504, 0.030153, -1.287665>, <0.795871, -0.075608, -1.288487>, <0.740051, -0.265133, -1.298075>, <0.828249, -0.321987, -1.283808>, 
      <0.779462, 0.028306, -1.142266>, <0.782282, -0.078779, -1.142205>, <0.729919, -0.266219, -1.148616>, <0.819318, -0.323466, -1.134285>, 
      <0.758444, 0.030139, -1.035302>, <0.761264, -0.076945, -1.035241>, <0.710842, -0.267046, -1.038205>, <0.800242, -0.324293, -1.023875>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.802783, 0.417347, -1.389467>, <0.703196, 0.360511, -1.408121>, <0.798357, 0.146179, -1.394918>, <0.804245, 0.030159, -1.395820>, 
      <0.796154, 0.417619, -1.279916>, <0.696566, 0.360782, -1.298570>, <0.784617, 0.146173, -1.286763>, <0.790504, 0.030153, -1.287665>, 
      <0.797751, 0.418954, -1.132712>, <0.697934, 0.361400, -1.151055>, <0.776390, 0.144937, -1.142332>, <0.779462, 0.028306, -1.142266>, 
      <0.780687, 0.418253, -1.024297>, <0.680870, 0.360698, -1.042640>, <0.755373, 0.146770, -1.035369>, <0.758444, 0.030139, -1.035302>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.402943, 0.371848, -1.283675>, <1.225000, 0.401948, -1.315939>, <0.959943, 0.507042, -1.360029>, <0.802783, 0.417347, -1.389467>, 
      <1.393717, 0.375501, -1.175326>, <1.215774, 0.405601, -1.207591>, <0.953314, 0.507313, -1.250478>, <0.796154, 0.417619, -1.279916>, 
      <1.391044, 0.382455, -1.029657>, <1.215983, 0.413273, -1.060165>, <0.952048, 0.507921, -1.104356>, <0.797751, 0.418954, -1.132712>, 
      <1.372190, 0.384023, -0.922512>, <1.197130, 0.414842, -0.953020>, <0.934984, 0.507220, -0.995941>, <0.780687, 0.418253, -1.024297>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.670988, 0.270487, -1.232047>, <1.607063, 0.329569, -1.239379>, <1.487731, 0.357506, -1.268302>, <1.402943, 0.371848, -1.283675>, 
      <1.660968, 0.269561, -1.124923>, <1.597043, 0.328644, -1.132254>, <1.478505, 0.361159, -1.159953>, <1.393717, 0.375501, -1.175326>, 
      <1.659341, 0.268646, -0.980333>, <1.596316, 0.329938, -0.986475>, <1.476588, 0.367396, -1.014750>, <1.391044, 0.382455, -1.029657>, 
      <1.637587, 0.267401, -0.874966>, <1.574562, 0.328694, -0.881109>, <1.457734, 0.368964, -0.907605>, <1.372190, 0.384023, -0.922512>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.791896, 0.012361, -1.239069>, <1.789973, 0.097852, -1.237006>, <1.733584, 0.212634, -1.224869>, <1.670988, 0.270487, -1.232047>, 
      <1.784053, 0.009037, -1.132595>, <1.782131, 0.094528, -1.130532>, <1.723563, 0.211708, -1.117744>, <1.660968, 0.269561, -1.124923>, 
      <1.783000, 0.002115, -0.989565>, <1.782883, 0.090756, -0.987910>, <1.722743, 0.206987, -0.974154>, <1.659341, 0.268646, -0.980333>, 
      <1.765754, 0.001280, -0.884156>, <1.765637, 0.089920, -0.882501>, <1.700989, 0.205742, -0.868787>, <1.637587, 0.267401, -0.874966>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.791896, 0.012361, -1.239069>, <1.784053, 0.009037, -1.132595>, <1.783000, 0.002115, -0.989565>, <1.765754, 0.001280, -0.884156>, 
      <1.793854, -0.074746, -1.241172>, <1.786012, -0.078070, -1.134698>, <1.783115, -0.085564, -0.991203>, <1.765869, -0.086400, -0.885793>, 
      <1.743554, -0.195015, -1.235445>, <1.730184, -0.196494, -1.127468>, <1.724841, -0.201450, -0.982672>, <1.701315, -0.201392, -0.876433>, 
      <1.682847, -0.256850, -1.244775>, <1.669477, -0.258328, -1.136797>, <1.661809, -0.261836, -0.991087>, <1.638282, -0.261778, -0.884849>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.318382, -0.369657, -0.790551>, <1.335536, -0.362952, -0.834137>, <1.370945, -0.368312, -0.889234>, <1.380250, -0.368035, -0.935626>, 
      <1.397674, -0.362885, -0.759960>, <1.414829, -0.356181, -0.803545>, <1.454663, -0.362067, -0.875345>, <1.463967, -0.361790, -0.921738>, 
      <1.502814, -0.314938, -0.716843>, <1.521217, -0.311810, -0.775187>, <1.563876, -0.320339, -0.833207>, <1.577121, -0.320371, -0.893015>, 
      <1.561276, -0.256554, -0.695808>, <1.579678, -0.253426, -0.754152>, <1.625037, -0.261746, -0.825041>, <1.638282, -0.261778, -0.884849>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.772024, -0.323955, -1.000310>, <0.780469, -0.321196, -1.006846>, <0.798364, -0.324374, -1.013006>, <0.800242, -0.324293, -1.023875>, 
      <0.911338, -0.419669, -0.950872>, <0.919782, -0.416910, -0.957409>, <0.945660, -0.418695, -0.989395>, <0.947538, -0.418614, -1.000263>, 
      <1.154599, -0.383643, -0.853741>, <1.171753, -0.376939, -0.897326>, <1.197301, -0.381265, -0.918040>, <1.206606, -0.380988, -0.964433>, 
      <1.318382, -0.369657, -0.790551>, <1.335536, -0.362952, -0.834137>, <1.370945, -0.368312, -0.889234>, <1.380250, -0.368035, -0.935626>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.726579, 0.036934, -1.000559>, <0.737683, 0.035961, -1.009500>, <0.755690, 0.030379, -1.021283>, <0.758444, 0.030139, -1.035302>, 
      <0.731266, -0.072081, -1.001750>, <0.742370, -0.073053, -1.010691>, <0.758510, -0.076705, -1.021222>, <0.761264, -0.076945, -1.035241>, 
      <0.685700, -0.264648, -1.030942>, <0.694145, -0.261889, -1.037479>, <0.708965, -0.267127, -1.027337>, <0.710842, -0.267046, -1.038205>, 
      <0.772024, -0.323955, -1.000310>, <0.780469, -0.321196, -1.006846>, <0.798364, -0.324374, -1.013006>, <0.800242, -0.324293, -1.023875>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.740262, 0.414779, -0.992239>, <0.752191, 0.409671, -1.000740>, <0.778275, 0.418154, -1.008973>, <0.780687, 0.418253, -1.024297>, 
      <0.647094, 0.360486, -1.027510>, <0.659023, 0.355378, -1.036011>, <0.678458, 0.360599, -1.027316>, <0.680870, 0.360698, -1.042640>, 
      <0.721706, 0.150278, -0.999321>, <0.732809, 0.149305, -1.008262>, <0.752618, 0.147011, -1.021349>, <0.755373, 0.146770, -1.035369>, 
      <0.726579, 0.036934, -1.000559>, <0.737683, 0.035961, -1.009500>, <0.755690, 0.030379, -1.021283>, <0.758444, 0.030139, -1.035302>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.313993, 0.379247, -0.778177>, <1.331063, 0.375308, -0.821478>, <1.364096, 0.384697, -0.876514>, <1.372190, 0.384023, -0.922512>, 
      <1.143486, 0.410571, -0.839892>, <1.160556, 0.406631, -0.883193>, <1.189035, 0.415515, -0.907022>, <1.197130, 0.414842, -0.953020>, 
      <0.891375, 0.502839, -0.935030>, <0.903304, 0.497732, -0.943532>, <0.932572, 0.507121, -0.980617>, <0.934984, 0.507220, -0.995941>, 
      <0.740262, 0.414779, -0.992239>, <0.752191, 0.409671, -1.000740>, <0.778275, 0.418154, -1.008973>, <0.780687, 0.418253, -1.024297>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.560204, 0.264150, -0.695462>, <1.578882, 0.260210, -0.750919>, <1.625729, 0.266723, -0.817531>, <1.637587, 0.267401, -0.874966>, 
      <1.500664, 0.322014, -0.714712>, <1.519342, 0.318074, -0.770169>, <1.562704, 0.328016, -0.823674>, <1.574562, 0.328694, -0.881109>, 
      <1.392964, 0.364740, -0.749594>, <1.410034, 0.360800, -0.792894>, <1.449640, 0.369637, -0.861607>, <1.457734, 0.368964, -0.907605>, 
      <1.313993, 0.379247, -0.778177>, <1.331063, 0.375308, -0.821478>, <1.364096, 0.384697, -0.876514>, <1.372190, 0.384023, -0.922512>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.696269, 0.007730, -0.654584>, <1.718073, 0.007894, -0.723185>, <1.754131, 0.000717, -0.813119>, <1.765754, 0.001280, -0.884156>, 
      <1.696088, 0.095674, -0.654525>, <1.717892, 0.095838, -0.723127>, <1.754015, 0.089358, -0.811464>, <1.765637, 0.089920, -0.882501>, 
      <1.621641, 0.204441, -0.675599>, <1.640319, 0.200501, -0.731055>, <1.689131, 0.205064, -0.811352>, <1.700989, 0.205742, -0.868787>, 
      <1.560204, 0.264150, -0.695462>, <1.578882, 0.260210, -0.750919>, <1.625729, 0.266723, -0.817531>, <1.637587, 0.267401, -0.874966>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.696269, 0.007730, -0.654584>, <1.696454, -0.082154, -0.654644>, <1.622910, -0.195002, -0.673632>, <1.561276, -0.256554, -0.695808>, 
      <1.718073, 0.007894, -0.723185>, <1.718258, -0.081990, -0.723245>, <1.641312, -0.191874, -0.731976>, <1.579678, -0.253426, -0.754152>, 
      <1.754131, 0.000717, -0.813119>, <1.754247, -0.086962, -0.814757>, <1.688070, -0.201360, -0.816625>, <1.625037, -0.261746, -0.825041>, 
      <1.765754, 0.001280, -0.884156>, <1.765869, -0.086400, -0.885793>, <1.701315, -0.201392, -0.876433>, <1.638282, -0.261778, -0.884849>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.248128, -0.419671, -0.599931>, <1.273552, -0.406983, -0.655898>, <1.295627, -0.378550, -0.732735>, <1.318382, -0.369657, -0.790551>, 
      <1.330335, -0.412340, -0.547077>, <1.355759, -0.399653, -0.603043>, <1.374919, -0.371778, -0.702144>, <1.397674, -0.362885, -0.759960>, 
      <1.438643, -0.354803, -0.474031>, <1.467222, -0.346071, -0.549411>, <1.478455, -0.319078, -0.639613>, <1.502814, -0.314938, -0.716843>, 
      <1.496415, -0.285890, -0.435061>, <1.524994, -0.277158, -0.510441>, <1.536917, -0.260694, -0.618577>, <1.561276, -0.256554, -0.695808>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.700581, -0.356855, -0.946734>, <0.722947, -0.347642, -0.961900>, <0.750165, -0.331097, -0.983390>, <0.772024, -0.323955, -1.000310>, 
      <0.838624, -0.465423, -0.861180>, <0.860990, -0.456210, -0.876345>, <0.889479, -0.426811, -0.933953>, <0.911338, -0.419669, -0.950872>, 
      <1.084269, -0.434282, -0.705283>, <1.109693, -0.421595, -0.761249>, <1.131844, -0.392537, -0.795924>, <1.154599, -0.383643, -0.853741>, 
      <1.248128, -0.419671, -0.599931>, <1.273552, -0.406983, -0.655898>, <1.295627, -0.378550, -0.732735>, <1.318382, -0.369657, -0.790551>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.665897, 0.038246, -0.960779>, <0.685219, 0.038873, -0.970793>, <0.709662, 0.038416, -0.986936>, <0.726579, 0.036934, -1.000559>, 
      <0.669393, -0.080762, -0.960298>, <0.688715, -0.080135, -0.970311>, <0.714349, -0.070598, -0.988127>, <0.731266, -0.072081, -1.001750>, 
      <0.616449, -0.290685, -0.998877>, <0.638815, -0.281473, -1.014042>, <0.663841, -0.271790, -1.014023>, <0.685700, -0.264648, -1.030942>, 
      <0.700581, -0.356855, -0.946734>, <0.722947, -0.347642, -0.961900>, <0.750165, -0.331097, -0.983390>, <0.772024, -0.323955, -1.000310>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.676502, 0.462860, -0.950049>, <0.697607, 0.451374, -0.962572>, <0.719427, 0.423699, -0.977390>, <0.740262, 0.414779, -0.992239>, 
      <0.583697, 0.401523, -1.012275>, <0.604802, 0.390037, -1.024798>, <0.626259, 0.369406, -1.012662>, <0.647094, 0.360486, -1.027510>, 
      <0.662155, 0.165655, -0.961295>, <0.681476, 0.166282, -0.971308>, <0.704788, 0.151760, -0.985698>, <0.721706, 0.150278, -0.999321>, 
      <0.665897, 0.038246, -0.960779>, <0.685219, 0.038873, -0.970793>, <0.709662, 0.038416, -0.986936>, <0.726579, 0.036934, -1.000559>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.236460, 0.415350, -0.578212>, <1.265130, 0.403554, -0.635622>, <1.290150, 0.384751, -0.717694>, <1.313993, 0.379247, -0.778177>, 
      <1.068754, 0.449222, -0.685888>, <1.097425, 0.437426, -0.743298>, <1.119642, 0.416074, -0.779409>, <1.143486, 0.410571, -0.839892>, 
      <0.823688, 0.560140, -0.851360>, <0.844792, 0.548654, -0.863883>, <0.870540, 0.511760, -0.920182>, <0.891375, 0.502839, -0.935030>, 
      <0.676502, 0.462860, -0.950049>, <0.697607, 0.451374, -0.962572>, <0.719427, 0.423699, -0.977390>, <0.740262, 0.414779, -0.992239>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.487502, 0.299059, -0.429345>, <1.518176, 0.289967, -0.506387>, <1.533638, 0.269753, -0.616583>, <1.560204, 0.264150, -0.695462>, 
      <1.429680, 0.365120, -0.463642>, <1.460355, 0.356028, -0.540684>, <1.474098, 0.327618, -0.635833>, <1.500664, 0.322014, -0.714712>, 
      <1.314651, 0.399557, -0.528009>, <1.343322, 0.387761, -0.585420>, <1.369120, 0.370243, -0.689110>, <1.392964, 0.364740, -0.749594>, 
      <1.236460, 0.415350, -0.578212>, <1.265130, 0.403554, -0.635622>, <1.290150, 0.384751, -0.717694>, <1.313993, 0.379247, -0.778177>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.599978, 0.000035, -0.362588>, <1.635096, 0.001846, -0.447892>, <1.668320, 0.007520, -0.566651>, <1.696269, 0.007730, -0.654584>, 
      <1.598486, 0.097933, -0.361631>, <1.633604, 0.099743, -0.446935>, <1.668139, 0.095464, -0.566593>, <1.696088, 0.095674, -0.654525>, 
      <1.547569, 0.230433, -0.393715>, <1.578243, 0.221341, -0.470757>, <1.595075, 0.210045, -0.596720>, <1.621641, 0.204441, -0.675599>, 
      <1.487502, 0.299059, -0.429345>, <1.518176, 0.289967, -0.506387>, <1.533638, 0.269753, -0.616583>, <1.560204, 0.264150, -0.695462>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.599978, 0.000035, -0.362588>, <1.601407, -0.093735, -0.363504>, <1.551698, -0.219944, -0.397769>, <1.496415, -0.285890, -0.435061>, 
      <1.635096, 0.001846, -0.447892>, <1.636525, -0.091924, -0.448808>, <1.580278, -0.211213, -0.473149>, <1.524994, -0.277158, -0.510441>, 
      <1.668320, 0.007520, -0.566651>, <1.668505, -0.082364, -0.566711>, <1.598550, -0.199142, -0.596401>, <1.536917, -0.260694, -0.618577>, 
      <1.696269, 0.007730, -0.654584>, <1.696454, -0.082154, -0.654644>, <1.622910, -0.195002, -0.673632>, <1.561276, -0.256554, -0.695808>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.150175, -0.453597, -0.420270>, <1.189163, -0.442768, -0.467543>, <1.222923, -0.432249, -0.544445>, <1.248128, -0.419671, -0.599931>, 
      <1.225166, -0.446532, -0.349984>, <1.264155, -0.435704, -0.397257>, <1.305130, -0.424918, -0.491591>, <1.330335, -0.412340, -0.547077>, 
      <1.321690, -0.386765, -0.251253>, <1.368364, -0.379134, -0.316066>, <1.410364, -0.363443, -0.399445>, <1.438643, -0.354803, -0.474031>, 
      <1.373079, -0.314053, -0.199428>, <1.419753, -0.306422, -0.264242>, <1.468136, -0.294530, -0.360474>, <1.496415, -0.285890, -0.435061>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.624967, -0.384529, -0.900599>, <0.648285, -0.375325, -0.912708>, <0.678771, -0.365838, -0.931946>, <0.700581, -0.356855, -0.946734>, 
      <0.761034, -0.499771, -0.781332>, <0.784353, -0.490567, -0.793440>, <0.816814, -0.474407, -0.846392>, <0.838624, -0.465423, -0.861180>, 
      <0.994022, -0.468307, -0.566624>, <1.033011, -0.457478, -0.613897>, <1.059063, -0.446860, -0.649797>, <1.084269, -0.434282, -0.705283>, 
      <1.150175, -0.453597, -0.420270>, <1.189163, -0.442768, -0.467543>, <1.222923, -0.432249, -0.544445>, <1.248128, -0.419671, -0.599931>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.576738, 0.032073, -0.922904>, <0.603826, 0.030886, -0.933526>, <0.640054, 0.037408, -0.947386>, <0.665897, 0.038246, -0.960779>, 
      <0.582092, -0.093806, -0.922768>, <0.609180, -0.094993, -0.933389>, <0.643550, -0.081601, -0.946905>, <0.669393, -0.080762, -0.960298>, 
      <0.545052, -0.316845, -0.970647>, <0.568370, -0.307641, -0.982756>, <0.594639, -0.299669, -0.984089>, <0.616449, -0.290685, -0.998877>, 
      <0.624967, -0.384529, -0.900599>, <0.648285, -0.375325, -0.912708>, <0.678771, -0.365838, -0.931946>, <0.700581, -0.356855, -0.946734>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.587435, 0.497955, -0.901554>, <0.615375, 0.484844, -0.910712>, <0.651426, 0.476508, -0.935169>, <0.676502, 0.462860, -0.950049>, 
      <0.497886, 0.429541, -0.984535>, <0.525827, 0.416429, -0.993694>, <0.558621, 0.415170, -0.997395>, <0.583697, 0.401523, -1.012275>, 
      <0.570792, 0.171895, -0.923056>, <0.597879, 0.170708, -0.933677>, <0.636311, 0.164817, -0.947901>, <0.662155, 0.165655, -0.961295>, 
      <0.576738, 0.032073, -0.922904>, <0.603826, 0.030886, -0.933526>, <0.640054, 0.037408, -0.947386>, <0.665897, 0.038246, -0.960779>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.130159, 0.454883, -0.410067>, <1.168324, 0.445124, -0.456439>, <1.209723, 0.426350, -0.524674>, <1.236460, 0.415350, -0.578212>, 
      <0.969654, 0.491154, -0.556146>, <1.007819, 0.481395, -0.602519>, <1.042018, 0.460223, -0.632350>, <1.068754, 0.449222, -0.685888>, 
      <0.728231, 0.605522, -0.771083>, <0.756171, 0.592411, -0.780241>, <0.798612, 0.573788, -0.836480>, <0.823688, 0.560140, -0.851360>, 
      <0.587435, 0.497955, -0.901554>, <0.615375, 0.484844, -0.910712>, <0.651426, 0.476508, -0.935169>, <0.676502, 0.462860, -0.950049>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.361695, 0.322990, -0.196885>, <1.407913, 0.315649, -0.261301>, <1.458225, 0.307737, -0.355813>, <1.487502, 0.299059, -0.429345>, 
      <1.308401, 0.395407, -0.245835>, <1.354619, 0.388066, -0.310251>, <1.400403, 0.373798, -0.390110>, <1.429680, 0.365120, -0.463642>, 
      <1.204836, 0.438008, -0.342102>, <1.243001, 0.428249, -0.388475>, <1.287915, 0.410558, -0.474471>, <1.314651, 0.399557, -0.528009>, 
      <1.130159, 0.454883, -0.410067>, <1.168324, 0.445124, -0.456439>, <1.209723, 0.426350, -0.524674>, <1.236460, 0.415350, -0.578212>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.467898, -0.004047, -0.099857>, <1.518078, -0.003876, -0.172425>, <1.566398, -0.001697, -0.281019>, <1.599978, 0.000035, -0.362588>, 
      <1.465983, 0.103118, -0.099429>, <1.516162, 0.103289, -0.171997>, <1.564906, 0.096201, -0.280063>, <1.598486, 0.097933, -0.361631>, 
      <1.417492, 0.247171, -0.145636>, <1.463710, 0.239831, -0.210052>, <1.518292, 0.239111, -0.320183>, <1.547569, 0.230433, -0.393715>, 
      <1.361695, 0.322990, -0.196885>, <1.407913, 0.315649, -0.261301>, <1.458225, 0.307737, -0.355813>, <1.487502, 0.299059, -0.429345>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.467898, -0.004047, -0.099857>, <1.469716, -0.105769, -0.100263>, <1.423829, -0.242248, -0.148249>, <1.373079, -0.314053, -0.199428>, 
      <1.518078, -0.003876, -0.172425>, <1.519895, -0.105598, -0.172831>, <1.470503, -0.234616, -0.213063>, <1.419753, -0.306422, -0.264242>, 
      <1.566398, -0.001697, -0.281019>, <1.567827, -0.095467, -0.281936>, <1.523420, -0.228584, -0.323182>, <1.468136, -0.294530, -0.360474>, 
      <1.599978, 0.000035, -0.362588>, <1.601407, -0.093735, -0.363504>, <1.551698, -0.219944, -0.397769>, <1.496415, -0.285890, -0.435061>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.929233, -0.508240, -0.213275>, <1.003140, -0.500638, -0.268031>, <1.092346, -0.469658, -0.350154>, <1.150175, -0.453597, -0.420270>, 
      <0.991891, -0.499839, -0.113871>, <1.065798, -0.492237, -0.168628>, <1.167338, -0.462593, -0.279868>, <1.225166, -0.446532, -0.349984>, 
      <1.073895, -0.430719, 0.020176>, <1.166666, -0.423458, -0.050719>, <1.253638, -0.397892, -0.156753>, <1.321690, -0.386765, -0.251253>, 
      <1.116615, -0.347988, 0.092346>, <1.209385, -0.340728, 0.021451>, <1.305027, -0.325180, -0.104928>, <1.373079, -0.314053, -0.199428>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.520569, -0.427906, -0.853255>, <0.551656, -0.419456, -0.870979>, <0.594170, -0.396685, -0.884606>, <0.624967, -0.384529, -0.900599>, 
      <0.624407, -0.557350, -0.695346>, <0.655494, -0.548899, -0.713070>, <0.730237, -0.511926, -0.765339>, <0.761034, -0.499771, -0.781332>, 
      <0.807394, -0.524576, -0.406566>, <0.881301, -0.516974, -0.461323>, <0.936194, -0.484368, -0.496508>, <0.994022, -0.468307, -0.566624>, 
      <0.929233, -0.508240, -0.213275>, <1.003140, -0.500638, -0.268031>, <1.092346, -0.469658, -0.350154>, <1.150175, -0.453597, -0.420270>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.484470, 0.046198, -0.889640>, <0.511318, 0.043649, -0.902146>, <0.549085, 0.033286, -0.912061>, <0.576738, 0.032073, -0.922904>, 
      <0.489110, -0.096694, -0.884492>, <0.515958, -0.099243, -0.896999>, <0.554438, -0.092594, -0.911925>, <0.582092, -0.093806, -0.922768>, 
      <0.455720, -0.347066, -0.951874>, <0.486807, -0.338615, -0.969598>, <0.514255, -0.329001, -0.954654>, <0.545052, -0.316845, -0.970647>, 
      <0.520569, -0.427906, -0.853255>, <0.551656, -0.419456, -0.870979>, <0.594170, -0.396685, -0.884606>, <0.624967, -0.384529, -0.900599>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.488784, 0.550950, -0.888520>, <0.519556, 0.540722, -0.898133>, <0.558081, 0.511730, -0.891932>, <0.587435, 0.497955, -0.901554>, 
      <0.418047, 0.478152, -1.000895>, <0.448819, 0.467924, -1.010508>, <0.468533, 0.443315, -0.974914>, <0.497886, 0.429541, -0.984535>, 
      <0.479558, 0.197452, -0.895089>, <0.506407, 0.194903, -0.907596>, <0.543138, 0.173107, -0.912212>, <0.570792, 0.171895, -0.923056>, 
      <0.484470, 0.046198, -0.889640>, <0.511318, 0.043649, -0.902146>, <0.549085, 0.033286, -0.912061>, <0.576738, 0.032073, -0.922904>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.921444, 0.495902, -0.195449>, <0.994373, 0.488479, -0.248776>, <1.073300, 0.469422, -0.340979>, <1.130159, 0.454883, -0.410067>, 
      <0.792296, 0.535818, -0.400581>, <0.865226, 0.528395, -0.453908>, <0.912794, 0.505693, -0.487059>, <0.969654, 0.491154, -0.556146>, 
      <0.603540, 0.669049, -0.706215>, <0.634312, 0.658821, -0.715828>, <0.698877, 0.619297, -0.761461>, <0.728231, 0.605522, -0.771083>, 
      <0.488784, 0.550950, -0.888520>, <0.519556, 0.540722, -0.898133>, <0.558081, 0.511730, -0.891932>, <0.587435, 0.497955, -0.901554>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.109533, 0.359091, 0.097448>, <1.201969, 0.354379, 0.026243>, <1.293908, 0.333756, -0.102408>, <1.361695, 0.322990, -0.196885>, 
      <1.066764, 0.437996, 0.030111>, <1.159200, 0.433284, -0.041094>, <1.240615, 0.406174, -0.151358>, <1.308401, 0.395407, -0.245835>, 
      <0.980430, 0.477671, -0.101759>, <1.053359, 0.470248, -0.155086>, <1.147977, 0.452547, -0.273014>, <1.204836, 0.438008, -0.342102>, 
      <0.921444, 0.495902, -0.195449>, <0.994373, 0.488479, -0.248776>, <1.073300, 0.469422, -0.340979>, <1.130159, 0.454883, -0.410067>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.190973, -0.001357, 0.228905>, <1.293304, -0.001980, 0.150431>, <1.394554, -0.004296, 0.006212>, <1.467898, -0.004047, -0.099857>, 
      <1.189794, 0.116300, 0.229754>, <1.292126, 0.115677, 0.151280>, <1.392639, 0.102869, 0.006640>, <1.465983, 0.103118, -0.099429>, 
      <1.154384, 0.276344, 0.168063>, <1.246821, 0.271631, 0.096858>, <1.349705, 0.257938, -0.051159>, <1.417492, 0.247171, -0.145636>, 
      <1.109533, 0.359091, 0.097448>, <1.201969, 0.354379, 0.026243>, <1.293908, 0.333756, -0.102408>, <1.361695, 0.322990, -0.196885>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.190973, -0.001357, 0.228905>, <1.192114, -0.115321, 0.228082>, <1.157945, -0.267949, 0.162168>, <1.116615, -0.347988, 0.092346>, 
      <1.293304, -0.001980, 0.150431>, <1.294445, -0.115944, 0.149609>, <1.250716, -0.260688, 0.091273>, <1.209385, -0.340728, 0.021451>, 
      <1.394554, -0.004296, 0.006212>, <1.396372, -0.106018, 0.005806>, <1.355777, -0.253375, -0.053749>, <1.305027, -0.325180, -0.104928>, 
      <1.467898, -0.004047, -0.099857>, <1.469716, -0.105769, -0.100263>, <1.423829, -0.242248, -0.148249>, <1.373079, -0.314053, -0.199428>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.702959, -0.499593, -0.088934>, <0.773069, -0.501169, -0.121923>, <0.867173, -0.514622, -0.167296>, <0.929233, -0.508240, -0.213275>, 
      <0.733853, -0.493063, 0.019709>, <0.803963, -0.494639, -0.013280>, <0.929831, -0.506221, -0.067892>, <0.991891, -0.499839, -0.113871>, 
      <0.761356, -0.440662, 0.175534>, <0.863859, -0.441239, 0.131674>, <0.985479, -0.437639, 0.087744>, <1.073895, -0.430719, 0.020176>, 
      <0.781539, -0.360352, 0.252627>, <0.884041, -0.360929, 0.208767>, <1.028199, -0.354909, 0.159913>, <1.116615, -0.347988, 0.092346>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.477514, -0.424612, -0.816533>, <0.492261, -0.424581, -0.825002>, <0.506192, -0.431815, -0.845058>, <0.520569, -0.427906, -0.853255>, 
      <0.535143, -0.551814, -0.634256>, <0.549890, -0.551783, -0.642725>, <0.610029, -0.561258, -0.687149>, <0.624407, -0.557350, -0.695346>, 
      <0.640259, -0.512846, -0.309432>, <0.710369, -0.514422, -0.342421>, <0.745335, -0.530959, -0.360588>, <0.807394, -0.524576, -0.406566>, 
      <0.702959, -0.499593, -0.088934>, <0.773069, -0.501169, -0.121923>, <0.867173, -0.514622, -0.167296>, <0.929233, -0.508240, -0.213275>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.456935, 0.043449, -0.867098>, <0.466226, 0.044504, -0.872315>, <0.474799, 0.047117, -0.885135>, <0.484470, 0.046198, -0.889640>, 
      <0.460137, -0.097740, -0.860693>, <0.469428, -0.096685, -0.865910>, <0.479439, -0.095776, -0.879987>, <0.489110, -0.096694, -0.884492>, 
      <0.442035, -0.346298, -0.928754>, <0.456781, -0.346267, -0.937223>, <0.441342, -0.350974, -0.943677>, <0.455720, -0.347066, -0.951874>, 
      <0.477514, -0.424612, -0.816533>, <0.492261, -0.424581, -0.825002>, <0.506192, -0.431815, -0.845058>, <0.520569, -0.427906, -0.853255>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.455598, 0.541777, -0.860369>, <0.466631, 0.541661, -0.867870>, <0.476645, 0.554985, -0.884728>, <0.488784, 0.550950, -0.888520>, 
      <0.420115, 0.468785, -0.985936>, <0.431148, 0.468669, -0.993437>, <0.405908, 0.482187, -0.997103>, <0.418047, 0.478152, -1.000895>, 
      <0.453549, 0.192770, -0.873871>, <0.462839, 0.193824, -0.879088>, <0.469888, 0.198370, -0.890584>, <0.479558, 0.197452, -0.895089>, 
      <0.456935, 0.043449, -0.867098>, <0.466226, 0.044504, -0.872315>, <0.474799, 0.047117, -0.885135>, <0.484470, 0.046198, -0.889640>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.679256, 0.500779, -0.080363>, <0.753627, 0.499908, -0.111044>, <0.856716, 0.502490, -0.148120>, <0.921444, 0.495902, -0.195449>, 
      <0.613617, 0.539877, -0.311821>, <0.687988, 0.539007, -0.342502>, <0.727569, 0.542407, -0.353252>, <0.792296, 0.535818, -0.400581>, 
      <0.513445, 0.660772, -0.655664>, <0.524478, 0.660656, -0.663165>, <0.591401, 0.673084, -0.702423>, <0.603540, 0.669049, -0.706215>, 
      <0.455598, 0.541777, -0.860369>, <0.466631, 0.541661, -0.867870>, <0.476645, 0.554985, -0.884728>, <0.488784, 0.550950, -0.888520>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.772469, 0.353028, 0.257002>, <0.876078, 0.353025, 0.214756>, <1.020964, 0.363606, 0.165673>, <1.109533, 0.359091, 0.097448>, 
      <0.748295, 0.434185, 0.180718>, <0.851904, 0.434182, 0.138472>, <0.978195, 0.442512, 0.098336>, <1.066764, 0.437996, 0.030111>, 
      <0.709948, 0.482496, 0.027867>, <0.784319, 0.481625, -0.002814>, <0.915702, 0.484259, -0.054430>, <0.980430, 0.477671, -0.101759>, 
      <0.679256, 0.500779, -0.080363>, <0.753627, 0.499908, -0.111044>, <0.856716, 0.502490, -0.148120>, <0.921444, 0.495902, -0.195449>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.828468, -0.000158, 0.390495>, <0.939328, -0.001621, 0.347078>, <1.096490, -0.000783, 0.301360>, <1.190973, -0.001357, 0.228905>, 
      <0.827012, 0.114341, 0.391197>, <0.937872, 0.112878, 0.347781>, <1.095312, 0.116874, 0.302209>, <1.189794, 0.116300, 0.229754>, 
      <0.796757, 0.271489, 0.333645>, <0.900366, 0.271486, 0.291399>, <1.065815, 0.280859, 0.236289>, <1.154384, 0.276344, 0.168063>, 
      <0.772469, 0.353028, 0.257002>, <0.876078, 0.353025, 0.214756>, <1.020964, 0.363606, 0.165673>, <1.109533, 0.359091, 0.097448>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.828468, -0.000158, 0.390495>, <0.829950, -0.116703, 0.389780>, <0.802330, -0.277616, 0.332049>, <0.781539, -0.360352, 0.252627>, 
      <0.939328, -0.001621, 0.347078>, <0.940809, -0.118166, 0.346363>, <0.904833, -0.278193, 0.288190>, <0.884041, -0.360929, 0.208767>, 
      <1.096490, -0.000783, 0.301360>, <1.097631, -0.114747, 0.300537>, <1.069529, -0.274869, 0.229736>, <1.028199, -0.354909, 0.159913>, 
      <1.190973, -0.001357, 0.228905>, <1.192114, -0.115321, 0.228082>, <1.157945, -0.267949, 0.162168>, <1.116615, -0.347988, 0.092346>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.570143, -0.500167, -0.044311>, <0.611220, -0.501018, -0.053186>, <0.664933, -0.498738, -0.071042>, <0.702959, -0.499593, -0.088934>, 
      <0.590054, -0.491655, 0.069064>, <0.631131, -0.492506, 0.060189>, <0.695826, -0.492208, 0.037602>, <0.733853, -0.493063, 0.019709>, 
      <0.613136, -0.427480, 0.223548>, <0.662578, -0.428511, 0.213231>, <0.714913, -0.440401, 0.195406>, <0.761356, -0.440662, 0.175534>, 
      <0.621903, -0.345205, 0.304026>, <0.671344, -0.346236, 0.293708>, <0.735096, -0.360091, 0.272499>, <0.781539, -0.360352, 0.252627>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.427993, -0.428103, -0.800089>, <0.443124, -0.426792, -0.804025>, <0.463909, -0.424641, -0.808719>, <0.477514, -0.424612, -0.816533>, 
      <0.464920, -0.555202, -0.609888>, <0.480051, -0.553890, -0.613824>, <0.521538, -0.551843, -0.626443>, <0.535143, -0.551814, -0.634256>, 
      <0.530170, -0.517257, -0.271916>, <0.571247, -0.518107, -0.280792>, <0.602232, -0.511991, -0.291539>, <0.640259, -0.512846, -0.309432>, 
      <0.570143, -0.500167, -0.044311>, <0.611220, -0.501018, -0.053186>, <0.664933, -0.498738, -0.071042>, <0.702959, -0.499593, -0.088934>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.413735, 0.038169, -0.849922>, <0.427344, 0.038653, -0.853324>, <0.444756, 0.042066, -0.860259>, <0.456935, 0.043449, -0.867098>, 
      <0.416784, -0.102463, -0.845235>, <0.430393, -0.101979, -0.848637>, <0.447957, -0.099122, -0.853854>, <0.460137, -0.097740, -0.860693>, 
      <0.405564, -0.350905, -0.915614>, <0.420695, -0.349594, -0.919550>, <0.428430, -0.346327, -0.920941>, <0.442035, -0.346298, -0.928754>, 
      <0.427993, -0.428103, -0.800089>, <0.443124, -0.426792, -0.804025>, <0.463909, -0.424641, -0.808719>, <0.477514, -0.424612, -0.816533>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.406750, 0.551815, -0.832745>, <0.423142, 0.552801, -0.837522>, <0.441456, 0.541926, -0.850753>, <0.455598, 0.541777, -0.860369>, 
      <0.383622, 0.475984, -0.964997>, <0.400014, 0.476970, -0.969774>, <0.405972, 0.468934, -0.976320>, <0.420115, 0.468785, -0.985936>, 
      <0.410395, 0.192241, -0.855056>, <0.424004, 0.192725, -0.858458>, <0.441369, 0.191387, -0.867032>, <0.453549, 0.192770, -0.873871>, 
      <0.413735, 0.038169, -0.849922>, <0.427344, 0.038653, -0.853324>, <0.444756, 0.042066, -0.860259>, <0.456935, 0.043449, -0.867098>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.554651, 0.500197, -0.044133>, <0.592946, 0.499816, -0.051128>, <0.643270, 0.501200, -0.065518>, <0.679256, 0.500779, -0.080363>, 
      <0.513670, 0.539960, -0.278483>, <0.551964, 0.539578, -0.285478>, <0.577632, 0.540299, -0.296976>, <0.613617, 0.539877, -0.311821>, 
      <0.442929, 0.670438, -0.625863>, <0.459321, 0.671424, -0.630641>, <0.499302, 0.660921, -0.646048>, <0.513445, 0.660772, -0.655664>, 
      <0.406750, 0.551815, -0.832745>, <0.423142, 0.552801, -0.837522>, <0.441456, 0.541926, -0.850753>, <0.455598, 0.541777, -0.860369>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.605364, 0.359106, 0.303020>, <0.656500, 0.358389, 0.293443>, <0.724291, 0.353029, 0.276647>, <0.772469, 0.353028, 0.257002>, 
      <0.594156, 0.438852, 0.223117>, <0.645292, 0.438134, 0.213540>, <0.700117, 0.434186, 0.200363>, <0.748295, 0.434185, 0.180718>, 
      <0.573925, 0.481496, 0.066086>, <0.612220, 0.481114, 0.059091>, <0.673963, 0.482917, 0.042713>, <0.709948, 0.482496, 0.027867>, 
      <0.554651, 0.500197, -0.044133>, <0.592946, 0.499816, -0.051128>, <0.643270, 0.501200, -0.065518>, <0.679256, 0.500779, -0.080363>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.624088, 0.006124, 0.450917>, <0.686990, 0.006173, 0.439304>, <0.768912, 0.000628, 0.413819>, <0.828468, -0.000158, 0.390495>, 
      <0.621389, 0.121044, 0.450753>, <0.684291, 0.121092, 0.439140>, <0.767456, 0.115127, 0.414521>, <0.827012, 0.114341, 0.391197>, 
      <0.616720, 0.278301, 0.383985>, <0.667856, 0.277583, 0.374408>, <0.748579, 0.271490, 0.353290>, <0.796757, 0.271489, 0.333645>, 
      <0.605364, 0.359106, 0.303020>, <0.656500, 0.358389, 0.293443>, <0.724291, 0.353029, 0.276647>, <0.772469, 0.353028, 0.257002>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.624088, 0.006124, 0.450917>, <0.626770, -0.108086, 0.451080>, <0.630579, -0.263772, 0.383679>, <0.621903, -0.345205, 0.304026>, 
      <0.686990, 0.006173, 0.439304>, <0.689672, -0.108038, 0.439467>, <0.680021, -0.264803, 0.373362>, <0.671344, -0.346236, 0.293708>, 
      <0.768912, 0.000628, 0.413819>, <0.770394, -0.115917, 0.413104>, <0.755887, -0.277355, 0.351921>, <0.735096, -0.360091, 0.272499>, 
      <0.828468, -0.000158, 0.390495>, <0.829950, -0.116703, 0.389780>, <0.802330, -0.277616, 0.332049>, <0.781539, -0.360352, 0.252627>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.377140, -0.492845, -0.018535>, <0.435487, -0.493367, -0.022065>, <0.513017, -0.498984, -0.031968>, <0.570143, -0.500167, -0.044311>, 
      <0.377958, -0.484296, 0.096702>, <0.436305, -0.484818, 0.093171>, <0.532928, -0.490472, 0.081407>, <0.590054, -0.491655, 0.069064>, 
      <0.365558, -0.433279, 0.257831>, <0.443208, -0.431298, 0.251381>, <0.536853, -0.425889, 0.239466>, <0.613136, -0.427480, 0.223548>, 
      <0.364626, -0.351658, 0.339626>, <0.442276, -0.349678, 0.333177>, <0.545620, -0.343614, 0.319944>, <0.621903, -0.345205, 0.304026>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.356641, -0.435090, -0.785094>, <0.378526, -0.434962, -0.787061>, <0.406802, -0.429940, -0.794577>, <0.427993, -0.428103, -0.800089>, 
      <0.363260, -0.560506, -0.591574>, <0.385145, -0.560378, -0.593540>, <0.443729, -0.557039, -0.604376>, <0.464920, -0.555202, -0.609888>, 
      <0.375507, -0.509911, -0.248599>, <0.433854, -0.510433, -0.252129>, <0.473044, -0.516073, -0.259573>, <0.530170, -0.517257, -0.271916>, 
      <0.377140, -0.492845, -0.018535>, <0.435487, -0.493367, -0.022065>, <0.513017, -0.498984, -0.031968>, <0.570143, -0.500167, -0.044311>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.349038, 0.039612, -0.840128>, <0.368531, 0.039560, -0.842485>, <0.394697, 0.037492, -0.845163>, <0.413735, 0.038169, -0.849922>, 
      <0.351668, -0.103617, -0.834037>, <0.371161, -0.103669, -0.836394>, <0.397746, -0.103140, -0.840476>, <0.416784, -0.102463, -0.845235>, 
      <0.352527, -0.357143, -0.905368>, <0.374412, -0.357014, -0.907335>, <0.384373, -0.352742, -0.910103>, <0.405564, -0.350905, -0.915614>, 
      <0.356641, -0.435090, -0.785094>, <0.378526, -0.434962, -0.787061>, <0.406802, -0.429940, -0.794577>, <0.427993, -0.428103, -0.800089>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.338830, 0.534751, -0.826337>, <0.359873, 0.535597, -0.827585>, <0.386529, 0.550598, -0.826852>, <0.406750, 0.551815, -0.832745>, 
      <0.337686, 0.461427, -0.955618>, <0.358729, 0.462273, -0.956865>, <0.363401, 0.474767, -0.959104>, <0.383622, 0.475984, -0.964997>, 
      <0.346311, 0.188084, -0.846441>, <0.365804, 0.188032, -0.848799>, <0.391357, 0.191565, -0.850298>, <0.410395, 0.192241, -0.855056>, 
      <0.349038, 0.039612, -0.840128>, <0.368531, 0.039560, -0.842485>, <0.394697, 0.037492, -0.845163>, <0.413735, 0.038169, -0.849922>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.356281, 0.503993, -0.021364>, <0.416064, 0.503801, -0.025289>, <0.495717, 0.500783, -0.033367>, <0.554651, 0.500197, -0.044133>, 
      <0.353037, 0.540174, -0.260344>, <0.412821, 0.539982, -0.264269>, <0.454735, 0.540546, -0.267717>, <0.513670, 0.539960, -0.278483>, 
      <0.340690, 0.654002, -0.616083>, <0.361733, 0.654848, -0.617331>, <0.422709, 0.669221, -0.619970>, <0.442929, 0.670438, -0.625863>, 
      <0.338830, 0.534751, -0.826337>, <0.359873, 0.535597, -0.827585>, <0.386529, 0.550598, -0.826852>, <0.406750, 0.551815, -0.832745>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.354594, 0.358891, 0.335262>, <0.430161, 0.359891, 0.328796>, <0.530817, 0.360152, 0.316981>, <0.605364, 0.359106, 0.303020>, 
      <0.352107, 0.441220, 0.254285>, <0.427674, 0.442220, 0.247818>, <0.519609, 0.439898, 0.237078>, <0.594156, 0.438852, 0.223117>, 
      <0.357830, 0.486705, 0.092830>, <0.417614, 0.486513, 0.088905>, <0.514991, 0.482082, 0.076852>, <0.573925, 0.481496, 0.066086>, 
      <0.356281, 0.503993, -0.021364>, <0.416064, 0.503801, -0.025289>, <0.495717, 0.500783, -0.033367>, <0.554651, 0.500197, -0.044133>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.371519, -0.000510, 0.474855>, <0.447471, -0.001191, 0.469599>, <0.549217, 0.006067, 0.464739>, <0.624088, 0.006124, 0.450917>, 
      <0.369885, 0.115255, 0.474144>, <0.445836, 0.114574, 0.468888>, <0.546518, 0.120986, 0.464575>, <0.621389, 0.121044, 0.450753>, 
      <0.357086, 0.276367, 0.416430>, <0.432654, 0.277367, 0.409964>, <0.542173, 0.279347, 0.397946>, <0.616720, 0.278301, 0.383985>, 
      <0.354594, 0.358891, 0.335262>, <0.430161, 0.359891, 0.328796>, <0.530817, 0.360152, 0.316981>, <0.605364, 0.359106, 0.303020>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.371519, -0.000510, 0.474855>, <0.373113, -0.113402, 0.475548>, <0.363715, -0.271911, 0.419545>, <0.364626, -0.351658, 0.339626>, 
      <0.447471, -0.001191, 0.469599>, <0.449064, -0.114083, 0.470292>, <0.441365, -0.269930, 0.413095>, <0.442276, -0.349678, 0.333177>, 
      <0.549217, 0.006067, 0.464739>, <0.551899, -0.108144, 0.464902>, <0.554296, -0.262181, 0.399597>, <0.545620, -0.343614, 0.319944>, 
      <0.624088, 0.006124, 0.450917>, <0.626770, -0.108086, 0.451080>, <0.630579, -0.263772, 0.383679>, <0.621903, -0.345205, 0.304026>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.242843, -0.497239, -0.024507>, <0.283162, -0.496512, -0.025923>, <0.336865, -0.492484, -0.016098>, <0.377140, -0.492845, -0.018535>, 
      <0.244274, -0.489529, 0.091532>, <0.284593, -0.488802, 0.090116>, <0.337683, -0.483936, 0.099139>, <0.377958, -0.484296, 0.096702>, 
      <0.237642, -0.437631, 0.254211>, <0.276190, -0.438138, 0.251437>, <0.327052, -0.434261, 0.261029>, <0.365558, -0.433279, 0.257831>, 
      <0.235882, -0.355050, 0.336088>, <0.274430, -0.355557, 0.333313>, <0.326120, -0.352641, 0.342824>, <0.364626, -0.351658, 0.339626>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.222103, -0.429310, -0.781590>, <0.262399, -0.430350, -0.784468>, <0.316391, -0.435326, -0.781478>, <0.356641, -0.435090, -0.785094>, 
      <0.227157, -0.556006, -0.591953>, <0.267453, -0.557046, -0.594831>, <0.323010, -0.560742, -0.587958>, <0.363260, -0.560506, -0.591574>, 
      <0.240037, -0.512361, -0.252110>, <0.280356, -0.511634, -0.253526>, <0.335232, -0.509550, -0.246162>, <0.375507, -0.509911, -0.248599>, 
      <0.242843, -0.497239, -0.024507>, <0.283162, -0.496512, -0.025923>, <0.336865, -0.492484, -0.016098>, <0.377140, -0.492845, -0.018535>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.221467, 0.038683, -0.826669>, <0.259677, 0.038359, -0.831242>, <0.310831, 0.039714, -0.835507>, <0.349038, 0.039612, -0.840128>, 
      <0.223114, -0.102239, -0.820944>, <0.261325, -0.102563, -0.825518>, <0.313462, -0.103515, -0.829416>, <0.351668, -0.103617, -0.834037>, 
      <0.218978, -0.350974, -0.898843>, <0.259274, -0.352014, -0.901721>, <0.312277, -0.357378, -0.901752>, <0.352527, -0.357143, -0.905368>, 
      <0.222103, -0.429310, -0.781590>, <0.262399, -0.430350, -0.784468>, <0.316391, -0.435326, -0.781478>, <0.356641, -0.435090, -0.785094>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.210724, 0.543936, -0.821125>, <0.248944, 0.542439, -0.826026>, <0.300366, 0.533206, -0.824057>, <0.338830, 0.534751, -0.826337>, 
      <0.209832, 0.468331, -0.952546>, <0.248052, 0.466834, -0.957447>, <0.299223, 0.459881, -0.953338>, <0.337686, 0.461427, -0.955618>, 
      <0.219696, 0.190167, -0.832822>, <0.257906, 0.189843, -0.837395>, <0.308105, 0.188186, -0.841821>, <0.346311, 0.188084, -0.846441>, 
      <0.221467, 0.038683, -0.826669>, <0.259677, 0.038359, -0.831242>, <0.310831, 0.039714, -0.835507>, <0.349038, 0.039612, -0.840128>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.226923, 0.501248, -0.022615>, <0.265612, 0.501770, -0.025730>, <0.317546, 0.504118, -0.018821>, <0.356281, 0.503993, -0.021364>, 
      <0.223640, 0.540110, -0.259369>, <0.262329, 0.540632, -0.262484>, <0.314303, 0.540298, -0.257801>, <0.353037, 0.540174, -0.260344>, 
      <0.212135, 0.663585, -0.613146>, <0.250356, 0.662088, -0.618047>, <0.302226, 0.652456, -0.613803>, <0.340690, 0.654002, -0.616083>, 
      <0.210724, 0.543936, -0.821125>, <0.248944, 0.542439, -0.826026>, <0.300366, 0.533206, -0.824057>, <0.338830, 0.534751, -0.826337>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.226762, 0.354096, 0.335416>, <0.265043, 0.355108, 0.332903>, <0.316360, 0.358385, 0.338533>, <0.354594, 0.358891, 0.335262>, 
      <0.225915, 0.435456, 0.252558>, <0.264196, 0.436468, 0.250045>, <0.313874, 0.440714, 0.257556>, <0.352107, 0.441220, 0.254285>, 
      <0.228512, 0.482440, 0.091968>, <0.267201, 0.482962, 0.088853>, <0.319096, 0.486829, 0.095373>, <0.357830, 0.486705, 0.092830>, 
      <0.226923, 0.501248, -0.022615>, <0.265612, 0.501770, -0.025730>, <0.317546, 0.504118, -0.018821>, <0.356281, 0.503993, -0.021364>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.232043, 0.009641, 0.478049>, <0.273763, 0.008819, 0.473603>, <0.329657, -0.000134, 0.477752>, <0.371519, -0.000510, 0.474855>, 
      <0.230605, 0.121488, 0.477943>, <0.272325, 0.120667, 0.473497>, <0.328022, 0.115631, 0.477041>, <0.369885, 0.115255, 0.474144>, 
      <0.227579, 0.275729, 0.415227>, <0.265859, 0.276741, 0.412715>, <0.318853, 0.275861, 0.419702>, <0.357086, 0.276367, 0.416430>, 
      <0.226762, 0.354096, 0.335416>, <0.265043, 0.355108, 0.332903>, <0.316360, 0.358385, 0.338533>, <0.354594, 0.358891, 0.335262>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.232043, 0.009641, 0.478049>, <0.233553, -0.107759, 0.478160>, <0.234106, -0.271683, 0.418743>, <0.235882, -0.355050, 0.336088>, 
      <0.273763, 0.008819, 0.473603>, <0.275273, -0.108581, 0.473714>, <0.272654, -0.272191, 0.415968>, <0.274430, -0.355557, 0.333313>, 
      <0.329657, -0.000134, 0.477752>, <0.331250, -0.113026, 0.478446>, <0.325209, -0.272892, 0.422743>, <0.326120, -0.352641, 0.342824>, 
      <0.371519, -0.000510, 0.474855>, <0.373113, -0.113402, 0.475548>, <0.363715, -0.271911, 0.419545>, <0.364626, -0.351658, 0.339626>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.106574, -0.497723, -0.009028>, <0.147539, -0.497244, -0.012827>, <0.201731, -0.497980, -0.023062>, <0.242843, -0.497239, -0.024507>, 
      <0.108169, -0.489281, 0.109770>, <0.149135, -0.488802, 0.105971>, <0.203162, -0.490270, 0.092977>, <0.244274, -0.489529, 0.091532>, 
      <0.100303, -0.431559, 0.273646>, <0.141706, -0.432326, 0.271639>, <0.196294, -0.437086, 0.257187>, <0.237642, -0.437631, 0.254211>, 
      <0.099722, -0.348171, 0.358692>, <0.141125, -0.348937, 0.356685>, <0.194534, -0.354505, 0.339064>, <0.235882, -0.355050, 0.336088>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.084621, -0.428072, -0.765668>, <0.126075, -0.428114, -0.768046>, <0.180700, -0.428242, -0.778633>, <0.222103, -0.429310, -0.781590>, 
      <0.091182, -0.555680, -0.576781>, <0.132636, -0.555723, -0.579159>, <0.185754, -0.554938, -0.588996>, <0.227157, -0.556006, -0.591953>, 
      <0.103519, -0.513887, -0.236481>, <0.144484, -0.513408, -0.240280>, <0.198925, -0.513103, -0.250665>, <0.240037, -0.512361, -0.252110>, 
      <0.106574, -0.497723, -0.009028>, <0.147539, -0.497244, -0.012827>, <0.201731, -0.497980, -0.023062>, <0.242843, -0.497239, -0.024507>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.078830, 0.041902, -0.807786>, <0.121955, 0.042285, -0.809817>, <0.178599, 0.039046, -0.821538>, <0.221467, 0.038683, -0.826669>, 
      <0.079632, -0.099607, -0.803806>, <0.122758, -0.099224, -0.805837>, <0.180247, -0.101876, -0.815813>, <0.223114, -0.102239, -0.820944>, 
      <0.080549, -0.348854, -0.882926>, <0.122002, -0.348897, -0.885305>, <0.177576, -0.349906, -0.895886>, <0.218978, -0.350974, -0.898843>, 
      <0.084621, -0.428072, -0.765668>, <0.126075, -0.428114, -0.768046>, <0.180700, -0.428242, -0.778633>, <0.222103, -0.429310, -0.781590>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.079104, 0.544925, -0.793032>, <0.119365, 0.544808, -0.796078>, <0.170706, 0.545504, -0.815993>, <0.210724, 0.543936, -0.821125>, 
      <0.078683, 0.470469, -0.924366>, <0.118944, 0.470352, -0.927412>, <0.169814, 0.469898, -0.947414>, <0.209832, 0.468331, -0.952546>, 
      <0.077974, 0.192812, -0.812030>, <0.121100, 0.193195, -0.814061>, <0.176828, 0.190530, -0.827691>, <0.219696, 0.190167, -0.832822>, 
      <0.078830, 0.041902, -0.807786>, <0.121955, 0.042285, -0.809817>, <0.178599, 0.039046, -0.821538>, <0.221467, 0.038683, -0.826669>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.081419, 0.500285, 0.000766>, <0.125471, 0.499737, -0.002949>, <0.182858, 0.500654, -0.019067>, <0.226923, 0.501248, -0.022615>, 
      <0.080217, 0.539928, -0.234430>, <0.124270, 0.539380, -0.238145>, <0.179575, 0.539516, -0.255821>, <0.223640, 0.540110, -0.259369>, 
      <0.079768, 0.662555, -0.585541>, <0.120030, 0.662438, -0.588587>, <0.172117, 0.665152, -0.608014>, <0.212135, 0.663585, -0.613146>, 
      <0.079104, 0.544925, -0.793032>, <0.119365, 0.544808, -0.796078>, <0.170706, 0.545504, -0.815993>, <0.210724, 0.543936, -0.821125>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.084960, 0.351764, 0.352961>, <0.127761, 0.351341, 0.350560>, <0.183999, 0.352966, 0.338223>, <0.226762, 0.354096, 0.335416>, 
      <0.081444, 0.432226, 0.271331>, <0.124246, 0.431804, 0.268930>, <0.183151, 0.434326, 0.255365>, <0.225915, 0.435456, 0.252558>, 
      <0.081997, 0.481225, 0.113843>, <0.126049, 0.480677, 0.110129>, <0.184447, 0.481846, 0.095516>, <0.228512, 0.482440, 0.091968>, 
      <0.081419, 0.500285, 0.000766>, <0.125471, 0.499737, -0.002949>, <0.182858, 0.500654, -0.019067>, <0.226923, 0.501248, -0.022615>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.103069, 0.004778, 0.503462>, <0.142450, 0.005923, 0.501192>, <0.192810, 0.010413, 0.482230>, <0.232043, 0.009641, 0.478049>, 
      <0.100674, 0.118344, 0.502532>, <0.140055, 0.119490, 0.500262>, <0.191371, 0.122261, 0.482124>, <0.230605, 0.121488, 0.477943>, 
      <0.088442, 0.272057, 0.433824>, <0.131244, 0.271635, 0.431423>, <0.184815, 0.274599, 0.418034>, <0.227579, 0.275729, 0.415227>, 
      <0.084960, 0.351764, 0.352961>, <0.127761, 0.351341, 0.350560>, <0.183999, 0.352966, 0.338223>, <0.226762, 0.354096, 0.335416>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.103069, 0.004778, 0.503462>, <0.105483, -0.109643, 0.504399>, <0.099163, -0.268044, 0.440412>, <0.099722, -0.348171, 0.358692>, 
      <0.142450, 0.005923, 0.501192>, <0.144864, -0.108498, 0.502129>, <0.140566, -0.268810, 0.438404>, <0.141125, -0.348937, 0.356685>, 
      <0.192810, 0.010413, 0.482230>, <0.194319, -0.106986, 0.482341>, <0.192758, -0.271139, 0.421719>, <0.194534, -0.354505, 0.339064>, 
      <0.232043, 0.009641, 0.478049>, <0.233553, -0.107759, 0.478160>, <0.234106, -0.271683, 0.418743>, <0.235882, -0.355050, 0.336088>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.077453, -0.500984, 0.005200>, <-0.076032, -0.492891, 0.118299>, <-0.080662, -0.430324, 0.272141>, <-0.079376, -0.349212, 0.351375>, 
      <-0.109645, -0.500328, 0.006673>, <-0.108224, -0.492235, 0.119771>, <-0.111331, -0.431252, 0.270863>, <-0.110045, -0.350140, 0.350096>, 
      <-0.152463, -0.492879, 0.007687>, <-0.151999, -0.484763, 0.117900>, <-0.153353, -0.433263, 0.269241>, <-0.150705, -0.356260, 0.348465>, 
      <-0.184498, -0.491793, 0.004288>, <-0.184033, -0.483677, 0.114501>, <-0.184024, -0.433677, 0.267749>, <-0.181376, -0.356674, 0.346973>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.077453, -0.500984, 0.005200>, <-0.022141, -0.502111, 0.002670>, <0.051433, -0.498368, -0.003913>, <0.106574, -0.497723, -0.009028>, 
      <-0.076032, -0.492891, 0.118299>, <-0.020720, -0.494018, 0.115768>, <0.053028, -0.489925, 0.114885>, <0.108169, -0.489281, 0.109770>, 
      <-0.080662, -0.430324, 0.272141>, <-0.026958, -0.428700, 0.274380>, <0.046601, -0.430565, 0.276250>, <0.100303, -0.431559, 0.273646>, 
      <-0.079376, -0.349212, 0.351375>, <-0.025672, -0.347587, 0.353614>, <0.046019, -0.347176, 0.361296>, <0.099722, -0.348171, 0.358692>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.093382, -0.428985, -0.763488>, <-0.091111, -0.556174, -0.569874>, <-0.080355, -0.517517, -0.225856>, <-0.077453, -0.500984, 0.005200>, 
      <-0.121337, -0.430082, -0.763615>, <-0.119066, -0.557271, -0.570001>, <-0.112548, -0.516861, -0.224383>, <-0.109645, -0.500328, 0.006673>, 
      <-0.158248, -0.438184, -0.763983>, <-0.159822, -0.564848, -0.569733>, <-0.153437, -0.509909, -0.223588>, <-0.152463, -0.492879, 0.007687>, 
      <-0.186068, -0.438694, -0.766895>, <-0.187642, -0.565359, -0.572646>, <-0.185472, -0.508823, -0.226987>, <-0.184498, -0.491793, 0.004288>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.093382, -0.428985, -0.763488>, <-0.040018, -0.426891, -0.763246>, <0.031303, -0.428017, -0.762609>, <0.084621, -0.428072, -0.765668>, 
      <-0.091111, -0.556174, -0.569874>, <-0.037747, -0.554080, -0.569632>, <0.037864, -0.555625, -0.573721>, <0.091182, -0.555680, -0.576781>, 
      <-0.080355, -0.517517, -0.225856>, <-0.025044, -0.518644, -0.228386>, <0.048378, -0.514531, -0.231366>, <0.103519, -0.513887, -0.236481>, 
      <-0.077453, -0.500984, 0.005200>, <-0.022141, -0.502111, 0.002670>, <0.051433, -0.498368, -0.003913>, <0.106574, -0.497723, -0.009028>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.087038, 0.035944, -0.812140>, <-0.089887, -0.104184, -0.806941>, <-0.094757, -0.351983, -0.880705>, <-0.093382, -0.428985, -0.763488>, 
      <-0.114343, 0.035940, -0.812813>, <-0.117191, -0.104188, -0.807615>, <-0.122711, -0.353080, -0.880832>, <-0.121337, -0.430082, -0.763615>, 
      <-0.150661, 0.041483, -0.811732>, <-0.154428, -0.103258, -0.806554>, <-0.157265, -0.359050, -0.885341>, <-0.158248, -0.438184, -0.763983>, 
      <-0.177867, 0.041863, -0.814116>, <-0.181634, -0.102878, -0.808938>, <-0.185085, -0.359561, -0.888254>, <-0.186068, -0.438694, -0.766895>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.087038, 0.035944, -0.812140>, <-0.037244, 0.035951, -0.810912>, <0.029077, 0.041461, -0.805443>, <0.078830, 0.041902, -0.807786>, 
      <-0.089887, -0.104184, -0.806941>, <-0.040092, -0.104177, -0.805713>, <0.029880, -0.100049, -0.801464>, <0.079632, -0.099607, -0.803806>, 
      <-0.094757, -0.351983, -0.880705>, <-0.041392, -0.349889, -0.880463>, <0.027231, -0.348799, -0.879867>, <0.080549, -0.348854, -0.882926>, 
      <-0.093382, -0.428985, -0.763488>, <-0.040018, -0.426891, -0.763246>, <0.031303, -0.428017, -0.762609>, <0.084621, -0.428072, -0.765668>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.073590, 0.544760, -0.799615>, <-0.078620, 0.468526, -0.931879>, <-0.083936, 0.188552, -0.817802>, <-0.087038, 0.035944, -0.812140>, 
      <-0.099724, 0.544191, -0.800582>, <-0.104754, 0.467956, -0.932846>, <-0.111241, 0.188548, -0.818476>, <-0.114343, 0.035940, -0.812813>, 
      <-0.134534, 0.539172, -0.799845>, <-0.138225, 0.466108, -0.930206>, <-0.146775, 0.190822, -0.817074>, <-0.150661, 0.041483, -0.811732>, 
      <-0.160606, 0.539698, -0.801898>, <-0.164297, 0.466634, -0.932259>, <-0.173981, 0.191203, -0.819459>, <-0.177867, 0.041863, -0.814116>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.073590, 0.544760, -0.799615>, <-0.027781, 0.545759, -0.797921>, <0.033384, 0.545057, -0.789573>, <0.079104, 0.544925, -0.793032>, 
      <-0.078620, 0.468526, -0.931879>, <-0.032812, 0.469524, -0.930185>, <0.032963, 0.470602, -0.920907>, <0.078683, 0.470469, -0.924366>, 
      <-0.083936, 0.188552, -0.817802>, <-0.034142, 0.188559, -0.816574>, <0.028221, 0.192370, -0.809687>, <0.077974, 0.192812, -0.812030>, 
      <-0.087038, 0.035944, -0.812140>, <-0.037244, 0.035951, -0.810912>, <0.029077, 0.041461, -0.805443>, <0.078830, 0.041902, -0.807786>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.056105, 0.504768, 0.001251>, <-0.056836, 0.543480, -0.236230>, <-0.065666, 0.664852, -0.591261>, <-0.073590, 0.544760, -0.799615>, 
      <-0.085747, 0.504644, 0.001412>, <-0.086478, 0.543356, -0.236069>, <-0.091800, 0.664282, -0.592228>, <-0.099724, 0.544191, -0.800582>, 
      <-0.125259, 0.499516, 0.004937>, <-0.124695, 0.537534, -0.233545>, <-0.128571, 0.657207, -0.589247>, <-0.134534, 0.539172, -0.799845>, 
      <-0.154759, 0.499301, 0.002046>, <-0.154196, 0.537319, -0.236436>, <-0.154643, 0.657733, -0.591300>, <-0.160606, 0.539698, -0.801898>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.056105, 0.504768, 0.001251>, <-0.014826, 0.504940, 0.001027>, <0.040289, 0.500796, 0.004234>, <0.081419, 0.500285, 0.000766>, 
      <-0.056836, 0.543480, -0.236230>, <-0.015557, 0.543652, -0.236453>, <0.039087, 0.540439, -0.230962>, <0.080217, 0.539928, -0.234430>, 
      <-0.065666, 0.664852, -0.591261>, <-0.019858, 0.665851, -0.589567>, <0.034048, 0.662688, -0.582082>, <0.079768, 0.662555, -0.585541>, 
      <-0.073590, 0.544760, -0.799615>, <-0.027781, 0.545759, -0.797921>, <0.033384, 0.545057, -0.789573>, <0.079104, 0.544925, -0.793032>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.070044, 0.357024, 0.352064>, <-0.067876, 0.438595, 0.272066>, <-0.055757, 0.486383, 0.114035>, <-0.056105, 0.504768, 0.001251>, 
      <-0.098051, 0.357557, 0.351431>, <-0.095883, 0.439128, 0.271433>, <-0.085399, 0.486259, 0.114196>, <-0.085747, 0.504644, 0.001412>, 
      <-0.135379, 0.356802, 0.349406>, <-0.133323, 0.436447, 0.270503>, <-0.125520, 0.481863, 0.115668>, <-0.125259, 0.499516, 0.004937>, 
      <-0.163320, 0.356487, 0.347347>, <-0.161265, 0.436132, 0.268445>, <-0.155021, 0.481648, 0.112777>, <-0.154759, 0.499301, 0.002046>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.070044, 0.357024, 0.352064>, <-0.023536, 0.356139, 0.353116>, <0.038506, 0.352222, 0.355567>, <0.084960, 0.351764, 0.352961>, 
      <-0.067876, 0.438595, 0.272066>, <-0.021368, 0.437711, 0.273118>, <0.034991, 0.432685, 0.273936>, <0.081444, 0.432226, 0.271331>, 
      <-0.055757, 0.486383, 0.114035>, <-0.014479, 0.486555, 0.113811>, <0.040867, 0.481736, 0.117312>, <0.081997, 0.481225, 0.113843>, 
      <-0.056105, 0.504768, 0.001251>, <-0.014826, 0.504940, 0.001027>, <0.040289, 0.500796, 0.004234>, <0.081419, 0.500285, 0.000766>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.069497, 0.000872, 0.495431>, <-0.067976, 0.116039, 0.495543>, <-0.072229, 0.274807, 0.432696>, <-0.070044, 0.357024, 0.352064>, 
      <-0.099150, -0.000387, 0.495418>, <-0.097629, 0.114780, 0.495531>, <-0.100236, 0.275340, 0.432063>, <-0.098051, 0.357557, 0.351431>, 
      <-0.138267, -0.006329, 0.506067>, <-0.135265, 0.112230, 0.506130>, <-0.137553, 0.272564, 0.432858>, <-0.135379, 0.356802, 0.349406>, 
      <-0.167819, -0.006723, 0.503350>, <-0.164817, 0.111835, 0.503412>, <-0.165494, 0.272249, 0.430799>, <-0.163320, 0.356487, 0.347347>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.069497, 0.000872, 0.495431>, <-0.017705, 0.003071, 0.495452>, <0.051338, 0.003273, 0.506444>, <0.103069, 0.004778, 0.503462>, 
      <-0.067976, 0.116039, 0.495543>, <-0.016183, 0.118238, 0.495565>, <0.048943, 0.116840, 0.505514>, <0.100674, 0.118344, 0.502532>, 
      <-0.072229, 0.274807, 0.432696>, <-0.025721, 0.273922, 0.433748>, <0.041989, 0.272515, 0.436429>, <0.088442, 0.272057, 0.433824>, 
      <-0.070044, 0.357024, 0.352064>, <-0.023536, 0.356139, 0.353116>, <0.038506, 0.352222, 0.355567>, <0.084960, 0.351764, 0.352961>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.069497, 0.000872, 0.495431>, <-0.099150, -0.000387, 0.495418>, <-0.138267, -0.006329, 0.506067>, <-0.167819, -0.006723, 0.503350>, 
      <-0.070998, -0.112726, 0.495320>, <-0.100651, -0.113985, 0.495308>, <-0.141179, -0.121354, 0.506007>, <-0.170731, -0.121749, 0.503290>, 
      <-0.078088, -0.267949, 0.430756>, <-0.108757, -0.268877, 0.429477>, <-0.147948, -0.276087, 0.430951>, <-0.178620, -0.276501, 0.429459>, 
      <-0.079376, -0.349212, 0.351375>, <-0.110045, -0.350140, 0.350096>, <-0.150705, -0.356260, 0.348465>, <-0.181376, -0.356674, 0.346973>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.069497, 0.000872, 0.495431>, <-0.070998, -0.112726, 0.495320>, <-0.078088, -0.267949, 0.430756>, <-0.079376, -0.349212, 0.351375>, 
      <-0.017705, 0.003071, 0.495452>, <-0.019206, -0.110527, 0.495341>, <-0.024384, -0.266324, 0.432995>, <-0.025672, -0.347587, 0.353614>, 
      <0.051338, 0.003273, 0.506444>, <0.053751, -0.111147, 0.507381>, <0.045460, -0.267049, 0.443016>, <0.046019, -0.347176, 0.361296>, 
      <0.103069, 0.004778, 0.503462>, <0.105483, -0.109643, 0.504399>, <0.099163, -0.268044, 0.440412>, <0.099722, -0.348171, 0.358692>
    }
  }
  scale 10.0
  translate  -10.4*z
}
intersection { // CSG001
  box { // Cube004
    <-1, -1, -1>, <1, 1, 1>
    scale <1.5, 1.0, 1.0>
    translate  <-8.1, -3.7, -8.5>
  }
  object { sPatchObj5 }
  material {
    Flag
    scale 3.0
    rotate 90.0*x
    translate <-9.600000, -0.100000, -10.500000>
  }
  translate  -0.01*y
}


torus { // Torus005
  1.5, 0.1  rotate -x*90
  material {
    Listen__intside_
  }
  rotate <-90.0, -180.0, -180.0>
  translate  <7.2, 0.0, -6.4>
}


torus { // Torus002
  0.1, 0.1  rotate -x*90
  material {
    Listen__intside_
  }
  translate  <9.8, 0.1, 3.0>
}


#declare Group005 = union {
  object { // Group004->Group001
    Group001
    translate  <-800.0, 800.0, 0.0>
  }
  object { // Group003->Group001
    Group001
    translate  -800.0*x
  }
  object { // Group002->Group001
    Group001
    translate  800.0*y
  }
  object { Group001 }
}
#declare HgtFld009 = object { 
  height_field {
    tga "C:\Leveller 1.0\Mesa1.tga"
    water_level 0.0
    smooth
  }
  rotate    <-90, 0, 0> // Turn onto XY plane. Now points along -Z
  scale     <  2, 2,-2> // Scale to Cube size. Now points along +Z
  translate < -1,-1,-1> // Center around origin
  material {
    Mesa
  }
  scale <1000.0, 1000.0, 250.0>
  rotate -180.0*z
  translate  <-3406.5, 3434.9, 112.6>
}
#declare HgtFld010 = object { 
  height_field {
    tga "C:\Leveller 1.0\Mesa1.tga"
    water_level 0.0
    smooth
  }
  rotate    <-90, 0, 0> // Turn onto XY plane. Now points along -Z
  scale     <  2, 2,-2> // Scale to Cube size. Now points along +Z
  translate < -1,-1,-1> // Center around origin
  material {
    Mesa
  }
  scale <1000.0, 1000.0, 250.0>
  rotate -40.0*z
  translate  <-2258.5, 11765.1, 112.6>
}
union { // Land
  object { Group012 }
  object { Group011 }
  object { Group005 }
  object { Group010 }
  object { // Group016->Group015
    Group015
    scale <2.0, 2.0, 1.0>
    translate  <-1800.0, 200.0, 0.0>
  }
  object { Group015 }
  object { Group014 }
  object { Group013 }
  object { HgtFld009 }
  object { HgtFld010 }
  translate  <-315.0, 1994.2, 0.0>
}


plane { // Plane001
  z,0
  material {
    Flat_Mars_Land
  }
  scale 50.0
  translate  -100.0*z
}


merge {  // RndCube001
  sphere { <0.5750, 0.5750, 0.0750>, 0.0750 }
  sphere { <0.5750, -0.5750, 0.0750>, 0.0750 }
  sphere { <-0.5750, -0.5750, 0.0750>, 0.0750 }
  sphere { <-0.5750, 0.5750, 0.0750>, 0.0750 }
  sphere { <0.5750, 0.5750, -0.0750>, 0.0750 }
  sphere { <0.5750, -0.5750, -0.0750>, 0.0750 }
  sphere { <-0.5750, -0.5750, -0.0750>, 0.0750 }
  sphere { <-0.5750, 0.5750, -0.0750>, 0.0750 }
  cylinder { <0.5750, 0.5750, 0.0750>, <-0.5750, 0.5750, 0.0750>, 0.0750 }
  cylinder { <0.5750, -0.5750, 0.0750>, <-0.5750, -0.5750, 0.0750>, 0.0750 }
  cylinder { <0.5750, -0.5750, -0.0750>, <-0.5750, -0.5750, -0.0750>, 0.0750 }
  cylinder { <0.5750, 0.5750, -0.0750>, <-0.5750, 0.5750, -0.0750>, 0.0750 }
  cylinder { <0.5750, 0.5750, -0.0750>, <0.5750, 0.5750, 0.0750>, 0.0750 }
  cylinder { <0.5750, -0.5750, -0.0750>, <0.5750, -0.5750, 0.0750>, 0.0750 }
  cylinder { <-0.5750, -0.5750, -0.0750>, <-0.5750, -0.5750, 0.0750>, 0.0750 }
  cylinder { <-0.5750, 0.5750, -0.0750>, <-0.5750, 0.5750, 0.0750>, 0.0750 }
  cylinder { <0.5750, 0.5750, 0.0750>, <0.5750, -0.5750, 0.0750>, 0.0750 }
  cylinder { <0.5750, 0.5750, -0.0750>, <0.5750, -0.5750, -0.0750>, 0.0750 }
  cylinder { <-0.5750, 0.5750, -0.0750>, <-0.5750, -0.5750, -0.0750>, 0.0750 }
  cylinder { <-0.5750, 0.5750, 0.0750>, <-0.5750, -0.5750, 0.0750>, 0.0750 }
  box { <-0.5750, -0.5750, -0.1500> <0.5750, 0.5750, 0.1500> }
  box { <-0.5750, -0.6500, -0.0750> <0.5750, 0.6500, 0.0750> }
  box { <-0.6500, -0.5750, -0.0750> <0.6500, 0.5750, 0.0750> }
// Attributes returned success!
  material {
    White__Filler_Texture_
  }
  rotate <-0.0, 50.0, -20.0>
  translate  <4.6, -3.9, 4.3>
}


intersection { // Decal_1
  box { // Cube003
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 2.0, 1.0>
    rotate -35.0*y
    translate  <7.8, 0.1, 5.8>
  }
  sphere { // Sphere004
    <0,0,0>,1
    scale 10.0
  }
  material {
    Flag
    scale <4.0, 2.0, 1.0>
    rotate <-125.0, -180.0, -90.0>
    translate <9.300000, -1.900000, 5.400000>
  }
  translate  <0.001, 0.0, 0.001>
}


#declare Antenna_1 = union {
  sphere { // Sphere003
    <0,0,0>,1
    scale <0.1, 0.1, 0.05>
    translate  <9.8, 0.0, 7.6>
  }
  cylinder { // Cylndr004
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 5.0>
    translate  <9.8, 0.0, 2.6>
  }
}
#declare Antenna_2 = union {
  cylinder { // Cylndr14
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 5.0>
    translate  <9.8, 0.0, 2.6>
  }
  torus { // Torus004
    0.15, 0.025  rotate -x*90
    scale <1.333333, 1.333333, 2.0>
    rotate 0.0*y
    translate  <9.8, 0.0, 7.65>
  }
  cylinder { // Cylndr005
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 0.1>
    rotate 0.0*y
    translate  <9.8, 0.0, 7.6>
  }
  scale <0.75, 0.75, 1.0>
  translate  <2.45, 0.0, 5.0>
}
union { // Antenna
  object { Antenna_1 }
  object { Antenna_2 }
  rotate -0.0*y
  translate  <-9.8, 0.0, -2.6>
  material {
    Listen__intside_
  }
  rotate <-10.0, 0.0, 0.0>
  translate  <9.8, 0.0, 2.5>
}


union { // Tiny_Light_1
  sphere { // Light_1
    <0,0,0>,1
    material {
      Red_Light
    }
    no_shadow
    scale 0.2
    translate  <-8.5, 0.4, 1.9>
  }
}


#declare CSG003 = union {
  object { // Cylndr11->Cylndr003
    Cylndr003
    rotate 40.0*z
    translate  0.0*x
  }
  object { // Cylndr10->Cylndr003
    Cylndr003
    rotate 80.0*z
    translate  <-0.0, 0.0, 0.0>
  }
  object { // Cylndr9->Cylndr003
    Cylndr003
    rotate 120.0*z
    translate  <-0.0, 0.0, 0.0>
  }
  object { // Cylndr8->Cylndr003
    Cylndr003
    rotate 160.0*z
    translate  <-0.0, -0.0, 0.0>
  }
  object { // Cylndr7->Cylndr003
    Cylndr003
    rotate -160.0*z
    translate  <-0.0, 0.0, 0.0>
  }
  object { // Cylndr6->Cylndr003
    Cylndr003
    rotate -120.0*z
    translate  <-0.0, -0.0, 0.0>
  }
  object { // Cylndr5->Cylndr003
    Cylndr003
    rotate -80.0*z
    translate  <0.0, -0.0, 0.0>
  }
  object { // Cylndr4->Cylndr003
    Cylndr003
    rotate -40.0*z
  }
  object { Cylndr003 }
  object { // Cylndr12->Cylndr003
    Cylndr003
    rotate -40.0*z
  }
  cylinder { // Cylndr13
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 1.0>
    translate  0.5*z
  }
}
#declare CSG004 = difference {
  cylinder { // Cylndr002
    <0,0,1>, <0,0,0>, 1 
    scale <1.5, 1.5, 1.0>
  }
  object { CSG003 }
  material {
    White__Filler_Texture_
  }
  scale <1.0, 1.0, 0.5>
  rotate 90.0*y
  translate  <10.3, -0.5, 0.0>
}
union { // Ear_Piece
  torus { // Torus003
    1.5, 0.1  rotate -x*90
    scale <1.0, 1.0, 3.0>
    rotate 90.0*y
    translate  <10.5, -0.5, 0.0>
  }
  object { CSG004 }
  superellipsoid { // SuperQ001
    <0.5, 0.5>
    material {
      Plastic_1
    }
    scale <1.0, 2.0, 3.0>
    rotate <-0.0, -0.0, 0.0>
    translate  <9.5, -0.5, 0.0>
  }
  material {
    White__Filler_Texture_
  }
  rotate <0.0, 0.0, -0.0>
}


#declare Round_Hole_edges = union {
  torus { // Torus001
    9.7, 0.3  rotate -x*90
    rotate 45.0*x
  }
  torus { // Torus2
    9.7, 0.3  rotate -x*90
    rotate -45.0*x
  }
}
#declare Visor_Hole = difference {
  box { // Cube001
    <-1, -1, -1>, <1, 1, 1>
    scale 10.0
    rotate -45.0*x
    translate  -12.145*y
  }
  box { // Cube002
    <-1, -1, -1>, <1, 1, 1>
    scale <11.0, 2.0, 3.0>
    translate  1.0*y
  }
}
#declare Hollow_Sphere = union {
  sphere { // Sphere002
    <0,0,0>,1
    scale 9.5
    translate  2.0*y
  }
  object { Visor_Hole }
  translate  -2.0*y
}
#declare Helmet_Main = difference {
  sphere { // Sphere001
    <0,0,0>,1
    scale 10.0
  }
  object { Hollow_Sphere }
}
union { // Helmet
  object { Round_Hole_edges }
  torus { // Rounding_flat_edge
    9.24, 0.26  rotate -x*90
    scale <1.0, 1.0, 0.2>
    rotate -90.0*x
    translate  -3.0*y
  }
  sphere { // Shiny_Visor
    <0,0,0>,1
    material {
      Visor
    }
    scale 9.5
  }
  object { Helmet_Main }
  material {
    Helmet_Texture
  }
}




#declare CSG4 = union {
  object { // Cylndr15->Cylndr23
    Cylndr23
    rotate 40.0*z
    translate  0.0*x
  }
  object { // Cylndr16->Cylndr23
    Cylndr23
    rotate 80.0*z
    translate  <-0.0, 0.0, 0.0>
  }
  object { // Cylndr17->Cylndr23
    Cylndr23
    rotate 120.0*z
    translate  <-0.0, 0.0, 0.0>
  }
  object { // Cylndr18->Cylndr23
    Cylndr23
    rotate 160.0*z
    translate  <-0.0, -0.0, 0.0>
  }
  object { // Cylndr19->Cylndr23
    Cylndr23
    rotate -160.0*z
    translate  <-0.0, 0.0, 0.0>
  }
  object { // Cylndr20->Cylndr23
    Cylndr23
    rotate -120.0*z
    translate  <-0.0, -0.0, 0.0>
  }
  object { // Cylndr21->Cylndr23
    Cylndr23
    rotate -80.0*z
    translate  <0.0, -0.0, 0.0>
  }
  object { // Cylndr22->Cylndr23
    Cylndr23
    rotate -40.0*z
  }
  object { Cylndr23 }
  object { // Cylndr24->Cylndr23
    Cylndr23
    rotate -40.0*z
  }
  cylinder { // Cylndr25
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 1.0>
    translate  0.5*z
  }
}
#declare CSG5 = difference {
  cylinder { // Cylndr3
    <0,0,1>, <0,0,0>, 1 
    scale <1.5, 1.5, 1.0>
  }
  object { CSG4 }
  material {
    White__Filler_Texture_
  }
  scale <1.0, 1.0, 0.5>
  rotate 90.0*y
  translate  <10.3, -0.5, 0.0>
}
union { // Ear_Piece1
  torus { // Torus20
    1.5, 0.1  rotate -x*90
    scale <1.0, 1.0, 3.0>
    rotate 90.0*y
    translate  <10.5, -0.5, 0.0>
  }
  object { CSG5 }
  superellipsoid { // SuperQ2
    <0.5, 0.5>
    material {
      Plastic_1
    }
    scale <1.0, 2.0, 3.0>
    rotate <-0.0, -0.0, 0.0>
    translate  <9.5, -0.5, 0.0>
  }
  material {
    White__Filler_Texture_
  }
  rotate <180.0, 0.0, 180.0>
}


#declare CSG6 = union {
  object { // Cylndr27->Cylndr35
    Cylndr35
    rotate 40.0*z
    translate  0.0*x
  }
  object { // Cylndr28->Cylndr35
    Cylndr35
    rotate 80.0*z
    translate  <-0.0, 0.0, 0.0>
  }
  object { // Cylndr29->Cylndr35
    Cylndr35
    rotate 120.0*z
    translate  <-0.0, 0.0, 0.0>
  }
  object { // Cylndr30->Cylndr35
    Cylndr35
    rotate 160.0*z
    translate  <-0.0, -0.0, 0.0>
  }
  object { // Cylndr31->Cylndr35
    Cylndr35
    rotate -160.0*z
    translate  <-0.0, 0.0, 0.0>
  }
  object { // Cylndr32->Cylndr35
    Cylndr35
    rotate -120.0*z
    translate  <-0.0, -0.0, 0.0>
  }
  object { // Cylndr33->Cylndr35
    Cylndr35
    rotate -80.0*z
    translate  <0.0, -0.0, 0.0>
  }
  object { // Cylndr34->Cylndr35
    Cylndr35
    rotate -40.0*z
  }
  object { Cylndr35 }
  object { // Cylndr36->Cylndr35
    Cylndr35
    rotate -40.0*z
  }
  cylinder { // Cylndr37
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 1.0>
    translate  0.5*z
  }
}
difference { // Inner_Speaker_1
  cylinder { // Cylndr26
    <0,0,1>, <0,0,0>, 1 
    scale <1.5, 1.5, 1.0>
  }
  object { CSG6 }
  material {
    Listen__intside_
  }
  scale <1.0, 1.0, 0.5>
  rotate 90.0*y
  translate  <-8.8, -0.5, 0.0>
}


#declare CSG7 = union {
  object { // Cylndr39->Cylndr47
    Cylndr47
    rotate 40.0*z
    translate  0.0*x
  }
  object { // Cylndr40->Cylndr47
    Cylndr47
    rotate 80.0*z
    translate  <-0.0, 0.0, 0.0>
  }
  object { // Cylndr41->Cylndr47
    Cylndr47
    rotate 120.0*z
    translate  <-0.0, 0.0, 0.0>
  }
  object { // Cylndr42->Cylndr47
    Cylndr47
    rotate 160.0*z
    translate  <-0.0, -0.0, 0.0>
  }
  object { // Cylndr43->Cylndr47
    Cylndr47
    rotate -160.0*z
    translate  <-0.0, 0.0, 0.0>
  }
  object { // Cylndr44->Cylndr47
    Cylndr47
    rotate -120.0*z
    translate  <-0.0, -0.0, 0.0>
  }
  object { // Cylndr45->Cylndr47
    Cylndr47
    rotate -80.0*z
    translate  <0.0, -0.0, 0.0>
  }
  object { // Cylndr46->Cylndr47
    Cylndr47
    rotate -40.0*z
  }
  object { Cylndr47 }
  object { // Cylndr48->Cylndr47
    Cylndr47
    rotate -40.0*z
  }
  cylinder { // Cylndr49
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 1.0>
    translate  0.5*z
  }
}
difference { // Inside_Speaker_2
  cylinder { // Cylndr38
    <0,0,1>, <0,0,0>, 1 
    scale <1.5, 1.5, 1.0>
  }
  object { CSG7 }
  material {
    Listen__intside_
  }
  scale <1.0, 1.0, 0.5>
  rotate <-0.0, -90.0, 0.0>
  translate  <8.8, -0.5, 0.0>
}


union { // Tiny_Light_3
  sphere { // Light_3
    <0,0,0>,1
    material {
      Green_Light
    }
    no_shadow
    scale 0.2
    translate  <-8.5, 0.4, 1.9>
  }
  rotate 180.0*z
  translate  0.8*y
}


#declare Mouth = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.121909, -0.848534, -0.302626>, <0.145521, -0.836654, -0.301024>, <0.175135, -0.818280, -0.294252>, <0.197904, -0.805095, -0.291254>, 
      <0.121300, -0.845426, -0.305634>, <0.144912, -0.833546, -0.304032>, <0.174868, -0.817498, -0.295012>, <0.197636, -0.804313, -0.292014>, 
      <0.122496, -0.840615, -0.309018>, <0.145479, -0.829884, -0.305771>, <0.175316, -0.813360, -0.297911>, <0.198036, -0.802876, -0.292639>, 
      <0.122748, -0.837221, -0.311757>, <0.145731, -0.826490, -0.308510>, <0.175372, -0.812408, -0.298505>, <0.198092, -0.801924, -0.293232>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.071137, -0.877599, -0.336542>, <0.066503, -0.876172, -0.328719>, <0.057593, -0.872444, -0.320694>, <0.051789, -0.870234, -0.313902>, 
      <0.051158, -0.885271, -0.339592>, <0.046524, -0.883843, -0.331769>, <0.042841, -0.877204, -0.321118>, <0.037036, -0.874994, -0.314327>, 
      <0.022134, -0.890979, -0.341776>, <0.022134, -0.888233, -0.333174>, <0.016024, -0.880974, -0.323226>, <0.016024, -0.876692, -0.315276>, 
      <0.000517, -0.890932, -0.341772>, <0.000517, -0.888186, -0.333170>, <0.000517, -0.880941, -0.323223>, <0.000517, -0.876658, -0.315274>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.075112, -0.877281, -0.336518>, <-0.069638, -0.875830, -0.328450>, <-0.059234, -0.872190, -0.320677>, <-0.052429, -0.870007, -0.313888>, 
      <-0.053499, -0.884892, -0.339514>, <-0.048024, -0.883442, -0.331447>, <-0.043892, -0.876763, -0.321085>, <-0.037087, -0.874581, -0.314296>, 
      <-0.022592, -0.890882, -0.341768>, <-0.022592, -0.888136, -0.333167>, <-0.015497, -0.880906, -0.323221>, <-0.015497, -0.876624, -0.315272>, 
      <0.000517, -0.890932, -0.341772>, <0.000517, -0.888186, -0.333170>, <0.000517, -0.880941, -0.323223>, <0.000517, -0.876658, -0.315274>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.214808, -0.794740, -0.290392>, <0.210004, -0.797379, -0.291086>, <0.203000, -0.799659, -0.292093>, <0.198092, -0.801924, -0.293232>, 
      <0.214808, -0.794740, -0.290392>, <0.204933, -0.800485, -0.291344>, <0.202944, -0.800611, -0.291500>, <0.198036, -0.802876, -0.292639>, 
      <0.214808, -0.794740, -0.290392>, <0.204933, -0.800485, -0.291344>, <0.202755, -0.801350, -0.291340>, <0.197636, -0.804313, -0.292014>, 
      <0.214808, -0.794740, -0.290392>, <0.209737, -0.797847, -0.290651>, <0.203022, -0.802132, -0.290580>, <0.197904, -0.805095, -0.291254>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.214808, -0.794740, -0.290392>, <0.211425, -0.795933, -0.291478>, <0.206651, -0.797000, -0.292843>, <0.203530, -0.798714, -0.294012>, 
      <0.209737, -0.797847, -0.290651>, <0.206353, -0.799039, -0.291737>, <0.204907, -0.797164, -0.292086>, <0.201786, -0.798878, -0.293255>, 
      <0.203022, -0.802132, -0.290580>, <0.202755, -0.801350, -0.291340>, <0.199667, -0.801913, -0.292873>, <0.199723, -0.800961, -0.293466>, 
      <0.197904, -0.805095, -0.291254>, <0.197636, -0.804313, -0.292014>, <0.198036, -0.802876, -0.292639>, <0.198092, -0.801924, -0.293232>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.214808, -0.794740, -0.290392>, <0.211425, -0.795933, -0.291478>, <0.206651, -0.797000, -0.292843>, <0.203530, -0.798714, -0.294012>, 
      <0.214808, -0.794740, -0.290392>, <0.206621, -0.798571, -0.292171>, <0.204907, -0.797164, -0.292086>, <0.201786, -0.798878, -0.293255>, 
      <0.214808, -0.794740, -0.290392>, <0.206621, -0.798571, -0.292171>, <0.204632, -0.798697, -0.292327>, <0.199723, -0.800961, -0.293466>, 
      <0.214808, -0.794740, -0.290392>, <0.210004, -0.797379, -0.291086>, <0.203000, -0.799659, -0.292093>, <0.198092, -0.801924, -0.293232>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.219334, -0.794493, -0.290438>, <-0.215577, -0.795661, -0.291463>, <-0.210096, -0.796408, -0.292501>, <-0.206811, -0.798385, -0.293855>, 
      <-0.219334, -0.794493, -0.290438>, <-0.209346, -0.798752, -0.292246>, <-0.207244, -0.796667, -0.291489>, <-0.203959, -0.798643, -0.292843>, 
      <-0.219334, -0.794493, -0.290438>, <-0.209346, -0.798752, -0.292246>, <-0.206390, -0.797990, -0.291778>, <-0.200246, -0.800988, -0.293274>, 
      <-0.219334, -0.794493, -0.290438>, <-0.213103, -0.797585, -0.291221>, <-0.203577, -0.799106, -0.291529>, <-0.197432, -0.802104, -0.293025>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.081719, -0.879455, -0.364428>, <0.078544, -0.878899, -0.356062>, <0.075651, -0.878990, -0.344162>, <0.071137, -0.877599, -0.336542>, 
      <0.058607, -0.887728, -0.368684>, <0.055432, -0.887171, -0.360319>, <0.055672, -0.886661, -0.347212>, <0.051158, -0.885271, -0.339592>, 
      <0.025431, -0.894965, -0.372453>, <0.025431, -0.893772, -0.363250>, <0.022134, -0.893802, -0.350616>, <0.022134, -0.890979, -0.341776>, 
      <0.000517, -0.894911, -0.372447>, <0.000517, -0.893718, -0.363245>, <0.000517, -0.893755, -0.350612>, <0.000517, -0.890932, -0.341772>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.086699, -0.879090, -0.364390>, <-0.061585, -0.887154, -0.368539>, <-0.026184, -0.894853, -0.372441>, <0.000517, -0.894911, -0.372447>, 
      <-0.083223, -0.878548, -0.356028>, <-0.058109, -0.886612, -0.360177>, <-0.026184, -0.893660, -0.363239>, <0.000517, -0.893718, -0.363245>, 
      <-0.080150, -0.878617, -0.343943>, <-0.058537, -0.886228, -0.346939>, <-0.022592, -0.893704, -0.350608>, <0.000517, -0.893755, -0.350612>, 
      <-0.075112, -0.877281, -0.336518>, <-0.053499, -0.884892, -0.339514>, <-0.022592, -0.890882, -0.341768>, <0.000517, -0.890932, -0.341772>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.126552, -0.856621, -0.292982>, <0.149948, -0.844098, -0.293687>, <0.178279, -0.822788, -0.288634>, <0.200035, -0.807603, -0.287715>, 
      <0.125745, -0.855515, -0.296766>, <0.149141, -0.842992, -0.297471>, <0.177870, -0.822185, -0.289887>, <0.199625, -0.807000, -0.288968>, 
      <0.122471, -0.851398, -0.299855>, <0.146083, -0.839518, -0.298253>, <0.175481, -0.819290, -0.293271>, <0.198250, -0.806105, -0.290273>, 
      <0.121909, -0.848534, -0.302626>, <0.145521, -0.836654, -0.301024>, <0.175135, -0.818280, -0.294252>, <0.197904, -0.805095, -0.291254>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.230142, -0.784320, -0.288605>, <0.225004, -0.786485, -0.288969>, <0.219667, -0.792072, -0.289691>, <0.214808, -0.794740, -0.290392>, 
      <0.221110, -0.791305, -0.288338>, <0.215972, -0.793470, -0.288702>, <0.214595, -0.795178, -0.289949>, <0.209737, -0.797847, -0.290651>, 
      <0.209395, -0.801071, -0.287320>, <0.208985, -0.800468, -0.288573>, <0.203368, -0.803142, -0.289599>, <0.203022, -0.802132, -0.290580>, 
      <0.200035, -0.807603, -0.287715>, <0.199625, -0.807000, -0.288968>, <0.198250, -0.806105, -0.290273>, <0.197904, -0.805095, -0.291254>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.230142, -0.784320, -0.288605>, <0.224679, -0.789212, -0.291795>, <0.217670, -0.796636, -0.295352>, <0.211931, -0.800624, -0.299239>, 
      <0.225004, -0.786485, -0.288969>, <0.219540, -0.791376, -0.292159>, <0.215149, -0.796063, -0.293784>, <0.209411, -0.800052, -0.297671>, 
      <0.219667, -0.792072, -0.289691>, <0.216283, -0.793264, -0.290777>, <0.209414, -0.796740, -0.294042>, <0.206293, -0.798455, -0.295211>, 
      <0.214808, -0.794740, -0.290392>, <0.211425, -0.795933, -0.291478>, <0.206651, -0.797000, -0.292843>, <0.203530, -0.798714, -0.294012>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.233445, -0.784237, -0.288498>, <-0.228661, -0.786415, -0.288816>, <-0.224021, -0.792168, -0.289849>, <-0.219334, -0.794493, -0.290438>, 
      <-0.227970, -0.789114, -0.291747>, <-0.223186, -0.791291, -0.292066>, <-0.220264, -0.793335, -0.290874>, <-0.215577, -0.795661, -0.291463>, 
      <-0.220487, -0.796177, -0.295123>, <-0.217971, -0.795545, -0.293480>, <-0.212978, -0.796147, -0.293524>, <-0.210096, -0.796408, -0.292501>, 
      <-0.215195, -0.800491, -0.299329>, <-0.212680, -0.799859, -0.297687>, <-0.209693, -0.798123, -0.294878>, <-0.206811, -0.798385, -0.293855>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.130664, -0.840960, -0.321905>, <0.128420, -0.840411, -0.318614>, <0.125123, -0.838343, -0.314801>, <0.122748, -0.837221, -0.311757>, 
      <0.152706, -0.827827, -0.314824>, <0.150463, -0.827277, -0.311533>, <0.148106, -0.827612, -0.311554>, <0.145731, -0.826490, -0.308510>, 
      <0.181364, -0.810890, -0.302314>, <0.179619, -0.811054, -0.301556>, <0.177003, -0.811446, -0.298739>, <0.175372, -0.812408, -0.298505>, 
      <0.203530, -0.798714, -0.294012>, <0.201786, -0.798878, -0.293255>, <0.199723, -0.800961, -0.293466>, <0.198092, -0.801924, -0.293232>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.130664, -0.840960, -0.321905>, <0.152706, -0.827827, -0.314824>, <0.181364, -0.810890, -0.302314>, <0.203530, -0.798714, -0.294012>, 
      <0.135400, -0.842120, -0.328851>, <0.157442, -0.828987, -0.321770>, <0.184127, -0.810631, -0.303513>, <0.206293, -0.798455, -0.295211>, 
      <0.141312, -0.842309, -0.338546>, <0.162813, -0.829292, -0.327782>, <0.189790, -0.813688, -0.310960>, <0.209411, -0.800052, -0.297671>, 
      <0.145876, -0.842886, -0.345678>, <0.167376, -0.829870, -0.334914>, <0.192310, -0.814261, -0.312528>, <0.211931, -0.800624, -0.299239>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.130664, -0.840960, -0.321905>, <0.135400, -0.842120, -0.328851>, <0.141312, -0.842309, -0.338546>, <0.145876, -0.842886, -0.345678>, 
      <0.112922, -0.851532, -0.327604>, <0.117658, -0.852692, -0.334551>, <0.123338, -0.853190, -0.347545>, <0.127902, -0.853768, -0.354677>, 
      <0.090938, -0.869996, -0.333519>, <0.095452, -0.871387, -0.341139>, <0.099748, -0.871310, -0.352157>, <0.102923, -0.871866, -0.360523>, 
      <0.071137, -0.877599, -0.336542>, <0.075651, -0.878990, -0.344162>, <0.078544, -0.878899, -0.356062>, <0.081719, -0.879455, -0.364428>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.130664, -0.840960, -0.321905>, <0.112922, -0.851532, -0.327604>, <0.090938, -0.869996, -0.333519>, <0.071137, -0.877599, -0.336542>, 
      <0.128420, -0.840411, -0.318614>, <0.110678, -0.850982, -0.324314>, <0.086304, -0.868569, -0.325697>, <0.066503, -0.876172, -0.328719>, 
      <0.125123, -0.838343, -0.314801>, <0.104013, -0.848199, -0.317784>, <0.079938, -0.865235, -0.320051>, <0.057593, -0.872444, -0.320694>, 
      <0.122748, -0.837221, -0.311757>, <0.101638, -0.847078, -0.314739>, <0.074134, -0.863025, -0.313259>, <0.051789, -0.870234, -0.313902>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.143077, -0.840365, -0.321865>, <-0.140040, -0.839787, -0.318400>, <-0.135171, -0.838165, -0.314789>, <-0.131782, -0.837221, -0.311757>, 
      <-0.123558, -0.852059, -0.328188>, <-0.120521, -0.851480, -0.324723>, <-0.112032, -0.849000, -0.318119>, <-0.108644, -0.848057, -0.315086>, 
      <-0.097199, -0.869503, -0.333456>, <-0.091725, -0.868053, -0.325389>, <-0.083918, -0.864831, -0.320021>, <-0.077113, -0.862649, -0.313232>, 
      <-0.075112, -0.877281, -0.336518>, <-0.069638, -0.875830, -0.328450>, <-0.059234, -0.872190, -0.320677>, <-0.052429, -0.870007, -0.313888>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.143077, -0.840365, -0.321865>, <-0.149006, -0.841495, -0.328630>, <-0.155983, -0.842130, -0.338534>, <-0.161514, -0.842886, -0.345678>, 
      <-0.123558, -0.852059, -0.328188>, <-0.129488, -0.853189, -0.334953>, <-0.135967, -0.854373, -0.348669>, <-0.141498, -0.855130, -0.355812>, 
      <-0.097199, -0.869503, -0.333456>, <-0.102237, -0.870839, -0.340881>, <-0.107262, -0.870829, -0.352057>, <-0.110738, -0.871372, -0.360418>, 
      <-0.075112, -0.877281, -0.336518>, <-0.080150, -0.878617, -0.343943>, <-0.083223, -0.878548, -0.356028>, <-0.086699, -0.879090, -0.364390>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.143077, -0.840365, -0.321865>, <-0.140040, -0.839787, -0.318400>, <-0.135171, -0.838165, -0.314789>, <-0.131782, -0.837221, -0.311757>, 
      <-0.163235, -0.828290, -0.315335>, <-0.160198, -0.827711, -0.311870>, <-0.155854, -0.828479, -0.311814>, <-0.152465, -0.827536, -0.308781>, 
      <-0.187105, -0.810239, -0.301976>, <-0.184253, -0.810497, -0.300964>, <-0.180026, -0.810856, -0.298198>, <-0.177212, -0.811972, -0.297949>, 
      <-0.206811, -0.798385, -0.293855>, <-0.203959, -0.798643, -0.292843>, <-0.200246, -0.800988, -0.293274>, <-0.197432, -0.802104, -0.293025>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.143077, -0.840365, -0.321865>, <-0.163235, -0.828290, -0.315335>, <-0.187105, -0.810239, -0.301976>, <-0.206811, -0.798385, -0.293855>, 
      <-0.149006, -0.841495, -0.328630>, <-0.169164, -0.829419, -0.322100>, <-0.189987, -0.809977, -0.302999>, <-0.209693, -0.798123, -0.294878>, 
      <-0.155983, -0.842130, -0.338534>, <-0.175395, -0.830256, -0.328705>, <-0.196323, -0.813196, -0.310689>, <-0.212680, -0.799859, -0.297687>, 
      <-0.161514, -0.842886, -0.345678>, <-0.180926, -0.831012, -0.335849>, <-0.198839, -0.813828, -0.312331>, <-0.215195, -0.800491, -0.299329>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.197705, -0.804954, -0.291281>, <-0.197430, -0.804276, -0.291971>, <-0.197514, -0.802960, -0.292502>, <-0.197432, -0.802104, -0.293025>, 
      <-0.203860, -0.801288, -0.290448>, <-0.203585, -0.800609, -0.291138>, <-0.200328, -0.801844, -0.292751>, <-0.200246, -0.800988, -0.293274>, 
      <-0.212845, -0.797632, -0.290691>, <-0.209088, -0.798799, -0.291716>, <-0.207244, -0.796667, -0.291489>, <-0.203959, -0.798643, -0.292843>, 
      <-0.219334, -0.794493, -0.290438>, <-0.215577, -0.795661, -0.291463>, <-0.210096, -0.796408, -0.292501>, <-0.206811, -0.798385, -0.293855>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.197705, -0.804954, -0.291281>, <-0.197430, -0.804276, -0.291971>, <-0.197514, -0.802960, -0.292502>, <-0.197432, -0.802104, -0.293025>, 
      <-0.197705, -0.804954, -0.291281>, <-0.203585, -0.800609, -0.291138>, <-0.203659, -0.799961, -0.291006>, <-0.203577, -0.799106, -0.291529>, 
      <-0.197705, -0.804954, -0.291281>, <-0.203585, -0.800609, -0.291138>, <-0.206615, -0.800723, -0.291474>, <-0.213103, -0.797585, -0.291221>, 
      <-0.197705, -0.804954, -0.291281>, <-0.203860, -0.801288, -0.290448>, <-0.212845, -0.797632, -0.290691>, <-0.219334, -0.794493, -0.290438>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.197705, -0.804954, -0.291281>, <-0.203860, -0.801288, -0.290448>, <-0.212845, -0.797632, -0.290691>, <-0.219334, -0.794493, -0.290438>, 
      <-0.198111, -0.805956, -0.290263>, <-0.204266, -0.802289, -0.289430>, <-0.217533, -0.795306, -0.290102>, <-0.224021, -0.792168, -0.289849>, 
      <-0.199387, -0.806889, -0.288834>, <-0.209566, -0.799960, -0.288406>, <-0.218517, -0.793401, -0.288521>, <-0.228661, -0.786415, -0.288816>, 
      <-0.199630, -0.807525, -0.287514>, <-0.209809, -0.800596, -0.287086>, <-0.223301, -0.791224, -0.288203>, <-0.233445, -0.784237, -0.288498>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.197705, -0.804954, -0.291281>, <-0.198111, -0.805956, -0.290263>, <-0.199387, -0.806889, -0.288834>, <-0.199630, -0.807525, -0.287514>, 
      <-0.176866, -0.817370, -0.294101>, <-0.177272, -0.818371, -0.293083>, <-0.177809, -0.821579, -0.289741>, <-0.178052, -0.822215, -0.288421>, 
      <-0.151535, -0.837472, -0.301176>, <-0.150951, -0.840177, -0.298501>, <-0.150102, -0.843366, -0.297214>, <-0.150976, -0.844460, -0.293629>, 
      <-0.129541, -0.847989, -0.302590>, <-0.128957, -0.850695, -0.299914>, <-0.126800, -0.855148, -0.296530>, <-0.127674, -0.856242, -0.292944>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.197705, -0.804954, -0.291281>, <-0.176866, -0.817370, -0.294101>, <-0.151535, -0.837472, -0.301176>, <-0.129541, -0.847989, -0.302590>, 
      <-0.197430, -0.804276, -0.291971>, <-0.176591, -0.816691, -0.294791>, <-0.152187, -0.834453, -0.304162>, <-0.130193, -0.844971, -0.305576>, 
      <-0.197514, -0.802960, -0.292502>, <-0.177294, -0.812827, -0.297425>, <-0.151793, -0.830766, -0.306031>, <-0.131110, -0.840452, -0.309007>, 
      <-0.197432, -0.802104, -0.293025>, <-0.177212, -0.811972, -0.297949>, <-0.152465, -0.827536, -0.308781>, <-0.131782, -0.837221, -0.311757>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.034744, -0.882884, -0.301755>, <-0.063683, -0.873888, -0.301972>, <-0.102247, -0.861042, -0.304344>, <-0.129541, -0.847989, -0.302590>, 
      <-0.032776, -0.885803, -0.296755>, <-0.061715, -0.876807, -0.296972>, <-0.101662, -0.863747, -0.301669>, <-0.128957, -0.850695, -0.299914>, 
      <-0.039057, -0.886988, -0.288727>, <-0.065685, -0.878653, -0.292013>, <-0.101736, -0.867821, -0.295793>, <-0.126800, -0.855148, -0.296530>, 
      <-0.040204, -0.888135, -0.282831>, <-0.066833, -0.879801, -0.286117>, <-0.102610, -0.868915, -0.292208>, <-0.127674, -0.856242, -0.292944>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.034744, -0.882884, -0.301755>, <-0.037159, -0.879302, -0.307891>, <-0.047123, -0.873870, -0.310248>, <-0.052429, -0.870007, -0.313888>, 
      <-0.063683, -0.873888, -0.301972>, <-0.066098, -0.870306, -0.308109>, <-0.071807, -0.866512, -0.309592>, <-0.077113, -0.862649, -0.313232>, 
      <-0.102247, -0.861042, -0.304344>, <-0.102899, -0.858023, -0.307330>, <-0.107971, -0.851287, -0.312336>, <-0.108644, -0.848057, -0.315086>, 
      <-0.129541, -0.847989, -0.302590>, <-0.130193, -0.844971, -0.305576>, <-0.131110, -0.840452, -0.309007>, <-0.131782, -0.837221, -0.311757>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000517, -0.888420, -0.301615>, <-0.010191, -0.888397, -0.301613>, <-0.024519, -0.886063, -0.301678>, <-0.034744, -0.882884, -0.301755>, 
      <0.000517, -0.891965, -0.294753>, <-0.010191, -0.891942, -0.294751>, <-0.022551, -0.888982, -0.296678>, <-0.032776, -0.885803, -0.296755>, 
      <0.000517, -0.895505, -0.284801>, <-0.012063, -0.895482, -0.284753>, <-0.027133, -0.890720, -0.287256>, <-0.039057, -0.886988, -0.288727>, 
      <0.000517, -0.896365, -0.277125>, <-0.012063, -0.896343, -0.277077>, <-0.028280, -0.891868, -0.281360>, <-0.040204, -0.888135, -0.282831>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000517, -0.888420, -0.301615>, <0.000517, -0.885938, -0.306419>, <0.000517, -0.880187, -0.311176>, <0.000517, -0.876658, -0.315274>, 
      <-0.010191, -0.888397, -0.301613>, <-0.010191, -0.885915, -0.306418>, <-0.015497, -0.880152, -0.311174>, <-0.015497, -0.876624, -0.315272>, 
      <-0.024519, -0.886063, -0.301678>, <-0.026935, -0.882481, -0.307815>, <-0.031782, -0.878444, -0.310656>, <-0.037087, -0.874581, -0.314296>, 
      <-0.034744, -0.882884, -0.301755>, <-0.037159, -0.879302, -0.307891>, <-0.047123, -0.873870, -0.310248>, <-0.052429, -0.870007, -0.313888>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.042966, -0.883052, -0.301766>, <0.030772, -0.887059, -0.301665>, <0.013353, -0.888448, -0.301617>, <0.000517, -0.888420, -0.301615>, 
      <0.042539, -0.886135, -0.296523>, <0.030344, -0.890142, -0.296421>, <0.013353, -0.891993, -0.294754>, <0.000517, -0.891965, -0.294753>, 
      <0.048732, -0.887132, -0.289134>, <0.034585, -0.891593, -0.287354>, <0.015457, -0.895532, -0.284858>, <0.000517, -0.895505, -0.284801>, 
      <0.049285, -0.888297, -0.283175>, <0.035138, -0.892758, -0.281395>, <0.015457, -0.896393, -0.277182>, <0.000517, -0.896365, -0.277125>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.042966, -0.883052, -0.301766>, <0.043381, -0.880060, -0.306857>, <0.049142, -0.874080, -0.310261>, <0.051789, -0.870234, -0.313902>, 
      <0.030772, -0.887059, -0.301665>, <0.031186, -0.884066, -0.306756>, <0.034389, -0.878840, -0.310686>, <0.037036, -0.874994, -0.314327>, 
      <0.013353, -0.888448, -0.301617>, <0.013353, -0.885966, -0.306421>, <0.016024, -0.880221, -0.311178>, <0.016024, -0.876692, -0.315276>, 
      <0.000517, -0.888420, -0.301615>, <0.000517, -0.885938, -0.306419>, <0.000517, -0.880187, -0.311176>, <0.000517, -0.876658, -0.315274>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.042966, -0.883052, -0.301766>, <0.067523, -0.874984, -0.301971>, <0.098860, -0.860131, -0.304190>, <0.121909, -0.848534, -0.302626>, 
      <0.043381, -0.880060, -0.306857>, <0.067938, -0.871991, -0.307062>, <0.098251, -0.857023, -0.307198>, <0.121300, -0.845426, -0.305634>, 
      <0.049142, -0.874080, -0.310261>, <0.071487, -0.866870, -0.309618>, <0.101387, -0.850472, -0.312000>, <0.122496, -0.840615, -0.309018>, 
      <0.051789, -0.870234, -0.313902>, <0.074134, -0.863025, -0.313259>, <0.101638, -0.847078, -0.314739>, <0.122748, -0.837221, -0.311757>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.042966, -0.883052, -0.301766>, <0.042539, -0.886135, -0.296523>, <0.048732, -0.887132, -0.289134>, <0.049285, -0.888297, -0.283175>, 
      <0.067523, -0.874984, -0.301971>, <0.067096, -0.878066, -0.296727>, <0.072618, -0.879600, -0.292139>, <0.073170, -0.880765, -0.286180>, 
      <0.098860, -0.860131, -0.304190>, <0.099422, -0.862995, -0.301418>, <0.103514, -0.867415, -0.296097>, <0.104321, -0.868521, -0.292312>, 
      <0.121909, -0.848534, -0.302626>, <0.122471, -0.851398, -0.299855>, <0.125745, -0.855515, -0.296766>, <0.126552, -0.856621, -0.292982>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.200487, -0.812240, -0.276162>, <-0.200230, -0.810826, -0.279568>, <-0.200235, -0.809109, -0.284229>, <-0.199630, -0.807525, -0.287514>, 
      <-0.212899, -0.802943, -0.279630>, <-0.212642, -0.801529, -0.283036>, <-0.210413, -0.802179, -0.283801>, <-0.209809, -0.800596, -0.287086>, 
      <-0.230397, -0.792208, -0.285043>, <-0.233336, -0.792211, -0.285043>, <-0.225970, -0.790008, -0.288025>, <-0.223301, -0.791224, -0.288203>, 
      <-0.243216, -0.783622, -0.288849>, <-0.246155, -0.783626, -0.288849>, <-0.236115, -0.783022, -0.288320>, <-0.233445, -0.784237, -0.288498>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.139925, -0.860994, -0.259989>, <-0.136250, -0.859569, -0.269875>, <-0.130091, -0.859269, -0.283030>, <-0.127674, -0.856242, -0.292944>, 
      <-0.160482, -0.849951, -0.264789>, <-0.156806, -0.848525, -0.274675>, <-0.153392, -0.847487, -0.283715>, <-0.150976, -0.844460, -0.293629>, 
      <-0.181879, -0.826179, -0.270963>, <-0.181622, -0.824765, -0.274369>, <-0.178656, -0.823798, -0.285136>, <-0.178052, -0.822215, -0.288421>, 
      <-0.200487, -0.812240, -0.276162>, <-0.200230, -0.810826, -0.279568>, <-0.200235, -0.809109, -0.284229>, <-0.199630, -0.807525, -0.287514>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.046710, -0.894854, -0.240258>, <-0.044758, -0.892839, -0.253030>, <-0.042657, -0.890590, -0.270223>, <-0.040204, -0.888135, -0.282831>, 
      <-0.076230, -0.887974, -0.241463>, <-0.074278, -0.885958, -0.254235>, <-0.069286, -0.882255, -0.273509>, <-0.066833, -0.879801, -0.286117>, 
      <-0.113750, -0.875057, -0.253878>, <-0.110075, -0.873631, -0.263764>, <-0.105027, -0.871942, -0.282294>, <-0.102610, -0.868915, -0.292208>, 
      <-0.139925, -0.860994, -0.259989>, <-0.136250, -0.859569, -0.269875>, <-0.130091, -0.859269, -0.283030>, <-0.127674, -0.856242, -0.292944>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.046710, -0.894854, -0.240258>, <-0.032326, -0.898207, -0.239671>, <-0.014264, -0.893697, -0.254233>, <0.000517, -0.893727, -0.254255>, 
      <-0.044758, -0.892839, -0.253030>, <-0.030374, -0.896191, -0.252443>, <-0.014264, -0.894489, -0.261094>, <0.000517, -0.894519, -0.261116>, 
      <-0.042657, -0.890590, -0.270223>, <-0.030734, -0.894321, -0.268752>, <-0.012063, -0.897112, -0.270213>, <0.000517, -0.897134, -0.270261>, 
      <-0.040204, -0.888135, -0.282831>, <-0.028280, -0.891868, -0.281360>, <-0.012063, -0.896343, -0.277077>, <0.000517, -0.896365, -0.277125>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.048658, -0.895049, -0.240399>, <0.048846, -0.893024, -0.253232>, <0.050463, -0.890780, -0.270476>, <0.049285, -0.888297, -0.283175>, 
      <0.034089, -0.898704, -0.239759>, <0.034277, -0.896678, -0.252592>, <0.036316, -0.895241, -0.268696>, <0.035138, -0.892758, -0.281395>, 
      <0.015551, -0.893758, -0.254277>, <0.015551, -0.894550, -0.261138>, <0.015457, -0.897161, -0.270319>, <0.015457, -0.896393, -0.277182>, 
      <0.000517, -0.893727, -0.254255>, <0.000517, -0.894519, -0.261116>, <0.000517, -0.897134, -0.270261>, <0.000517, -0.896365, -0.277125>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.048658, -0.895049, -0.240399>, <0.075182, -0.888396, -0.241565>, <0.107371, -0.873669, -0.254508>, <0.131003, -0.860994, -0.259989>, 
      <0.048846, -0.893024, -0.253232>, <0.075371, -0.886370, -0.254397>, <0.106035, -0.872357, -0.264405>, <0.129668, -0.859683, -0.269887>, 
      <0.050463, -0.890780, -0.270476>, <0.074348, -0.883248, -0.273481>, <0.106341, -0.871289, -0.282840>, <0.128572, -0.859390, -0.283510>, 
      <0.049285, -0.888297, -0.283175>, <0.073170, -0.880765, -0.286180>, <0.104321, -0.868521, -0.292312>, <0.126552, -0.856621, -0.292982>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.202837, -0.812359, -0.276161>, <0.201996, -0.810933, -0.279627>, <0.201120, -0.809202, -0.284395>, <0.200035, -0.807603, -0.287715>, 
      <0.181644, -0.827243, -0.270669>, <0.180803, -0.825816, -0.274135>, <0.179365, -0.824386, -0.285314>, <0.178279, -0.822788, -0.288634>, 
      <0.153860, -0.848736, -0.265291>, <0.152525, -0.847424, -0.275189>, <0.151969, -0.846866, -0.284214>, <0.149948, -0.844098, -0.293687>, 
      <0.131003, -0.860994, -0.259989>, <0.129668, -0.859683, -0.269887>, <0.128572, -0.859390, -0.283510>, <0.126552, -0.856621, -0.292982>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.202837, -0.812359, -0.276161>, <0.214711, -0.804021, -0.279238>, <0.229648, -0.792262, -0.284818>, <0.241138, -0.783648, -0.288528>, 
      <0.201996, -0.810933, -0.279627>, <0.213870, -0.802594, -0.282704>, <0.232953, -0.792267, -0.284816>, <0.244443, -0.783653, -0.288526>, 
      <0.201120, -0.809202, -0.284395>, <0.210480, -0.802669, -0.283999>, <0.224149, -0.790025, -0.288123>, <0.233181, -0.783040, -0.288390>, 
      <0.200035, -0.807603, -0.287715>, <0.209395, -0.801071, -0.287320>, <0.221110, -0.791305, -0.288338>, <0.230142, -0.784320, -0.288605>
    }
  }
  material {
    Lips
  }
}
#declare Hood = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.467286, -0.492274, -0.501505>, <-0.404554, -0.493536, -0.561398>, <-0.290137, -0.460461, -0.594088>, <-0.214046, -0.447651, -0.633714>, 
      <-0.468930, -0.501591, -0.507856>, <-0.406198, -0.502853, -0.567750>, <-0.293942, -0.473709, -0.603379>, <-0.217851, -0.460900, -0.643005>, 
      <-0.468732, -0.531932, -0.516381>, <-0.408103, -0.532033, -0.577016>, <-0.297751, -0.509196, -0.607668>, <-0.223806, -0.498454, -0.649729>, 
      <-0.472766, -0.523332, -0.522676>, <-0.412137, -0.523433, -0.583310>, <-0.300675, -0.502555, -0.622624>, <-0.226730, -0.491813, -0.664685>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.593613, -0.440017, -0.271323>, <-0.571274, -0.455636, -0.346872>, <-0.525371, -0.491106, -0.446049>, <-0.467286, -0.492274, -0.501505>, 
      <-0.605324, -0.455352, -0.267546>, <-0.582985, -0.470971, -0.343095>, <-0.527015, -0.500423, -0.452400>, <-0.468930, -0.501591, -0.507856>, 
      <-0.620933, -0.506171, -0.263550>, <-0.591641, -0.522389, -0.350399>, <-0.534547, -0.531822, -0.450561>, <-0.468732, -0.531932, -0.516381>, 
      <-0.632650, -0.491135, -0.258732>, <-0.603358, -0.507352, -0.345582>, <-0.538581, -0.523222, -0.456856>, <-0.472766, -0.523332, -0.522676>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.662825, -0.355560, 0.159800>, <-0.670620, -0.325319, 0.030086>, <-0.630722, -0.414071, -0.145821>, <-0.593613, -0.440017, -0.271323>, 
      <-0.674764, -0.367714, 0.159510>, <-0.682559, -0.337473, 0.029795>, <-0.642433, -0.429407, -0.142043>, <-0.605324, -0.455352, -0.267546>, 
      <-0.694854, -0.403822, 0.145796>, <-0.707807, -0.377118, 0.019046>, <-0.661900, -0.483490, -0.142085>, <-0.620933, -0.506171, -0.263550>, 
      <-0.702622, -0.396074, 0.158833>, <-0.715576, -0.369369, 0.032083>, <-0.673617, -0.468454, -0.137267>, <-0.632650, -0.491135, -0.258732>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.543362, -0.634968, 0.564880>, <-0.579201, -0.551146, 0.443356>, <-0.653949, -0.389994, 0.307497>, <-0.662825, -0.355560, 0.159800>, 
      <-0.544808, -0.644059, 0.565748>, <-0.580647, -0.560236, 0.444224>, <-0.665888, -0.402148, 0.307206>, <-0.674764, -0.367714, 0.159510>, 
      <-0.548183, -0.674516, 0.567772>, <-0.594515, -0.593757, 0.445090>, <-0.679529, -0.435416, 0.295750>, <-0.694854, -0.403822, 0.145796>, 
      <-0.548183, -0.665270, 0.567772>, <-0.594515, -0.584511, 0.445090>, <-0.687297, -0.427668, 0.308788>, <-0.702622, -0.396074, 0.158833>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.543362, -0.634968, 0.564880>, <-0.543362, -0.634968, 0.564880>, <-0.543362, -0.634968, 0.564880>, <-0.543362, -0.634968, 0.564880>, 
      <-0.543362, -0.634968, 0.564880>, <-0.544808, -0.644059, 0.565748>, <-0.544808, -0.644059, 0.565748>, <-0.544808, -0.644059, 0.565748>, 
      <-0.543362, -0.634968, 0.564880>, <-0.544808, -0.644059, 0.565748>, <-0.548183, -0.683762, 0.567772>, <-0.548183, -0.674516, 0.567772>, 
      <-0.543362, -0.634968, 0.564880>, <-0.544808, -0.644059, 0.565748>, <-0.548183, -0.674516, 0.567772>, <-0.548183, -0.665270, 0.567772>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.311490, -0.744229, 0.780745>, <-0.398596, -0.725306, 0.734254>, <-0.473800, -0.667746, 0.629640>, <-0.543362, -0.634968, 0.564880>, 
      <-0.313311, -0.756831, 0.789880>, <-0.400417, -0.737907, 0.743388>, <-0.475247, -0.676837, 0.630507>, <-0.544808, -0.644059, 0.565748>, 
      <-0.315919, -0.795088, 0.798368>, <-0.405695, -0.769842, 0.746027>, <-0.478996, -0.710805, 0.640799>, <-0.548183, -0.674516, 0.567772>, 
      <-0.317561, -0.786235, 0.811194>, <-0.407336, -0.760989, 0.758853>, <-0.478996, -0.701560, 0.640799>, <-0.548183, -0.665270, 0.567772>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.024591, -0.747669, 0.841766>, <-0.112551, -0.750282, 0.842402>, <-0.235243, -0.760794, 0.821441>, <-0.311490, -0.744229, 0.780745>, 
      <-0.023321, -0.767479, 0.851888>, <-0.111281, -0.770092, 0.852524>, <-0.237064, -0.773395, 0.830576>, <-0.313311, -0.756831, 0.789880>, 
      <-0.020549, -0.825384, 0.856533>, <-0.112077, -0.827705, 0.859153>, <-0.239027, -0.816711, 0.843199>, <-0.315919, -0.795088, 0.798368>, 
      <-0.020359, -0.813702, 0.875507>, <-0.111888, -0.816023, 0.878127>, <-0.240669, -0.807858, 0.856024>, <-0.317561, -0.786235, 0.811194>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.280186, -0.726653, 0.776468>, <0.199469, -0.744167, 0.820757>, <0.069086, -0.744886, 0.841089>, <-0.024591, -0.747669, 0.841766>, 
      <0.285134, -0.739855, 0.781611>, <0.204417, -0.757370, 0.825901>, <0.070355, -0.764696, 0.851211>, <-0.023321, -0.767479, 0.851888>, 
      <0.295802, -0.778577, 0.780893>, <0.212846, -0.802087, 0.829700>, <0.078457, -0.822874, 0.853700>, <-0.020549, -0.825384, 0.856533>, 
      <0.296678, -0.770660, 0.793612>, <0.213722, -0.794170, 0.842419>, <0.078647, -0.811192, 0.872673>, <-0.020359, -0.813702, 0.875507>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.490812, -0.635833, 0.558964>, <0.427624, -0.663079, 0.624215>, <0.361859, -0.708931, 0.731654>, <0.280186, -0.726653, 0.776468>, 
      <0.494662, -0.644643, 0.561438>, <0.431474, -0.671889, 0.626690>, <0.366806, -0.722133, 0.736797>, <0.285134, -0.739855, 0.781611>, 
      <0.503644, -0.675125, 0.567212>, <0.441554, -0.706764, 0.635132>, <0.377278, -0.755487, 0.732957>, <0.295802, -0.778577, 0.780893>, 
      <0.503644, -0.665198, 0.567212>, <0.441554, -0.696837, 0.635132>, <0.378154, -0.747570, 0.745676>, <0.296678, -0.770660, 0.793612>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.490812, -0.635833, 0.558964>, <0.490812, -0.635833, 0.558964>, <0.490812, -0.635833, 0.558964>, <0.490812, -0.635833, 0.558964>, 
      <0.490812, -0.635833, 0.558964>, <0.494662, -0.644643, 0.561438>, <0.494662, -0.644643, 0.561438>, <0.494662, -0.644643, 0.561438>, 
      <0.490812, -0.635833, 0.558964>, <0.494662, -0.644643, 0.561438>, <0.503644, -0.685052, 0.567212>, <0.503644, -0.675125, 0.567212>, 
      <0.490812, -0.635833, 0.558964>, <0.494662, -0.644643, 0.561438>, <0.503644, -0.675125, 0.567212>, <0.503644, -0.665198, 0.567212>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.640490, -0.359768, 0.160716>, <0.627633, -0.395641, 0.308016>, <0.535715, -0.553014, 0.439490>, <0.490812, -0.635833, 0.558964>, 
      <0.646948, -0.371647, 0.163978>, <0.634091, -0.407520, 0.311278>, <0.539565, -0.561823, 0.441964>, <0.494662, -0.644643, 0.561438>, 
      <0.658881, -0.406642, 0.160159>, <0.642627, -0.439749, 0.306253>, <0.551155, -0.595375, 0.448525>, <0.503644, -0.675125, 0.567212>, 
      <0.662015, -0.399365, 0.171590>, <0.645761, -0.432471, 0.317685>, <0.551155, -0.585448, 0.448525>, <0.503644, -0.665198, 0.567212>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.562754, -0.435102, -0.265267>, <0.602562, -0.412814, -0.141555>, <0.651632, -0.328680, 0.033062>, <0.640490, -0.359768, 0.160716>, 
      <0.572737, -0.447680, -0.264632>, <0.612545, -0.425393, -0.140920>, <0.658090, -0.340559, 0.036324>, <0.646948, -0.371647, 0.163978>, 
      <0.588435, -0.490797, -0.266479>, <0.626587, -0.470564, -0.139673>, <0.673332, -0.377210, 0.030276>, <0.658881, -0.406642, 0.160159>, 
      <0.596030, -0.477030, -0.263151>, <0.634182, -0.456797, -0.136345>, <0.676466, -0.369932, 0.041707>, <0.662015, -0.399365, 0.171590>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.430133, -0.477544, -0.493018>, <0.487525, -0.473563, -0.437307>, <0.538577, -0.448639, -0.340404>, <0.562754, -0.435102, -0.265267>, 
      <0.437158, -0.487257, -0.501500>, <0.494550, -0.483276, -0.445789>, <0.548559, -0.461217, -0.339770>, <0.572737, -0.447680, -0.264632>, 
      <0.448366, -0.519285, -0.511239>, <0.512097, -0.513565, -0.449373>, <0.563087, -0.504240, -0.350731>, <0.588435, -0.490797, -0.266479>, 
      <0.453550, -0.509920, -0.521292>, <0.517281, -0.504200, -0.459426>, <0.570681, -0.490473, -0.347403>, <0.596030, -0.477030, -0.263151>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.187982, -0.461096, -0.629064>, <0.262918, -0.469893, -0.593362>, <0.370313, -0.481693, -0.551086>, <0.430133, -0.477544, -0.493018>, 
      <0.190479, -0.476639, -0.635699>, <0.265415, -0.485436, -0.599998>, <0.377339, -0.491406, -0.559568>, <0.437158, -0.487257, -0.501500>, 
      <0.193746, -0.518537, -0.635257>, <0.271642, -0.525822, -0.598459>, <0.386459, -0.524842, -0.571336>, <0.448366, -0.519285, -0.511239>, 
      <0.196305, -0.512907, -0.651182>, <0.274201, -0.520191, -0.614384>, <0.391643, -0.515477, -0.581388>, <0.453550, -0.509920, -0.521292>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.047044, -0.421527, -0.720358>, <0.029474, -0.424086, -0.719473>, <0.119245, -0.453027, -0.661812>, <0.187982, -0.461096, -0.629064>, 
      <-0.049079, -0.433811, -0.732543>, <0.027439, -0.436370, -0.731658>, <0.121742, -0.468570, -0.668448>, <0.190479, -0.476639, -0.635699>, 
      <-0.053676, -0.463411, -0.743580>, <0.029514, -0.467559, -0.740925>, <0.118663, -0.511516, -0.670726>, <0.193746, -0.518537, -0.635257>, 
      <-0.053827, -0.462474, -0.760976>, <0.029363, -0.466622, -0.758321>, <0.121222, -0.505886, -0.686651>, <0.196305, -0.512907, -0.651182>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.047044, -0.421527, -0.720358>, <-0.049079, -0.433811, -0.732543>, <-0.053676, -0.463411, -0.743580>, <-0.053827, -0.462474, -0.760976>, 
      <-0.103992, -0.419623, -0.721017>, <-0.106027, -0.431907, -0.733202>, <-0.113592, -0.460423, -0.745492>, <-0.113743, -0.459486, -0.762888>, 
      <-0.164059, -0.439236, -0.659746>, <-0.167865, -0.452485, -0.669037>, <-0.172045, -0.490935, -0.679171>, <-0.174970, -0.484294, -0.694127>, 
      <-0.214046, -0.447651, -0.633714>, <-0.217851, -0.460900, -0.643005>, <-0.223806, -0.498454, -0.649729>, <-0.226730, -0.491813, -0.664685>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.369790, -0.325482, -1.265332>, <-0.363957, -0.312422, -1.244167>, <-0.355056, -0.291896, -1.217835>, <-0.350346, -0.281947, -1.194783>, 
      <-0.305517, -0.350859, -1.266217>, <-0.299684, -0.337798, -1.245052>, <-0.296617, -0.320725, -1.221209>, <-0.291907, -0.310777, -1.198158>, 
      <-0.223778, -0.394375, -1.276383>, <-0.223442, -0.383339, -1.256545>, <-0.217637, -0.367754, -1.225603>, <-0.219075, -0.358636, -1.204861>, 
      <-0.163056, -0.426932, -1.271036>, <-0.162720, -0.415896, -1.251197>, <-0.160498, -0.399265, -1.225650>, <-0.161936, -0.390146, -1.204907>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.529614, -0.282204, -1.265991>, <-0.517658, -0.266070, -1.241987>, <-0.499545, -0.239012, -1.213754>, <-0.489760, -0.228423, -1.185976>, 
      <-0.512011, -0.328621, -1.267768>, <-0.500055, -0.312486, -1.243763>, <-0.483746, -0.280741, -1.218562>, <-0.473961, -0.270153, -1.190784>, 
      <-0.415990, -0.307241, -1.264696>, <-0.410156, -0.294181, -1.243532>, <-0.395250, -0.272068, -1.215514>, <-0.390540, -0.262119, -1.192462>, 
      <-0.369790, -0.325482, -1.265332>, <-0.363957, -0.312422, -1.244167>, <-0.355056, -0.291896, -1.217835>, <-0.350346, -0.281947, -1.194783>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.545039, 0.136620, -1.247643>, <-0.534805, 0.138288, -1.217126>, <-0.521712, 0.140341, -1.176237>, <-0.510925, 0.142179, -1.145921>, 
      <-0.556734, 0.011333, -1.249959>, <-0.546500, 0.013001, -1.219443>, <-0.532067, 0.029342, -1.187097>, <-0.521280, 0.031181, -1.156781>, 
      <-0.574213, -0.164605, -1.261489>, <-0.562257, -0.148470, -1.237485>, <-0.538977, -0.134863, -1.201755>, <-0.529192, -0.124274, -1.173977>, 
      <-0.529614, -0.282204, -1.265991>, <-0.517658, -0.266070, -1.241987>, <-0.499545, -0.239012, -1.213754>, <-0.489760, -0.228423, -1.185976>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.450003, 0.570670, -1.250222>, <-0.440349, 0.562270, -1.208315>, <-0.425935, 0.549270, -1.153083>, <-0.417824, 0.542669, -1.110532>, 
      <-0.478514, 0.440455, -1.249448>, <-0.468860, 0.432055, -1.207541>, <-0.453865, 0.429123, -1.163700>, <-0.445754, 0.422522, -1.121149>, 
      <-0.532652, 0.269323, -1.245189>, <-0.522418, 0.270990, -1.214673>, <-0.510266, 0.263032, -1.164233>, <-0.499479, 0.264870, -1.133917>, 
      <-0.545039, 0.136620, -1.247643>, <-0.534805, 0.138288, -1.217126>, <-0.521712, 0.140341, -1.176237>, <-0.510925, 0.142179, -1.145921>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.450003, 0.570670, -1.250222>, <-0.440349, 0.562270, -1.208315>, <-0.425935, 0.549270, -1.153083>, <-0.417824, 0.542669, -1.110532>, 
      <-0.450003, 0.570670, -1.250222>, <-0.440349, 0.562270, -1.208315>, <-0.425935, 0.549270, -1.153083>, <-0.417824, 0.542669, -1.110532>, 
      <-0.450003, 0.570670, -1.250222>, <-0.440349, 0.562270, -1.208315>, <-0.425935, 0.549270, -1.153083>, <-0.417824, 0.542669, -1.110532>, 
      <-0.450003, 0.570670, -1.250222>, <-0.440349, 0.562270, -1.208315>, <-0.425935, 0.549270, -1.153083>, <-0.417824, 0.542669, -1.110532>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.229152, 0.794501, -1.242506>, <-0.226585, 0.784218, -1.196132>, <-0.222934, 0.773407, -1.133573>, <-0.220595, 0.760224, -1.087927>, 
      <-0.308264, 0.743092, -1.244110>, <-0.305697, 0.732809, -1.197736>, <-0.296395, 0.724388, -1.136257>, <-0.294056, 0.711204, -1.090611>, 
      <-0.383748, 0.637819, -1.247907>, <-0.374094, 0.629419, -1.206000>, <-0.366766, 0.614536, -1.146302>, <-0.358655, 0.607935, -1.103751>, 
      <-0.450003, 0.570670, -1.250222>, <-0.440349, 0.562270, -1.208315>, <-0.425935, 0.549270, -1.153083>, <-0.417824, 0.542669, -1.110532>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.003241, 0.865200, -1.241034>, <0.000458, 0.850875, -1.197370>, <-0.004206, 0.831426, -1.139316>, <-0.006036, 0.817450, -1.095489>, 
      <-0.069555, 0.861831, -1.241038>, <-0.072338, 0.847506, -1.197374>, <-0.070790, 0.831786, -1.142413>, <-0.072620, 0.817810, -1.098586>, 
      <-0.168055, 0.834203, -1.241268>, <-0.165488, 0.823920, -1.194894>, <-0.167514, 0.810388, -1.131549>, <-0.165175, 0.797205, -1.085903>, 
      <-0.229152, 0.794501, -1.242506>, <-0.226585, 0.784218, -1.196132>, <-0.222934, 0.773407, -1.133573>, <-0.220595, 0.760224, -1.087927>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.210670, 0.814855, -1.242485>, <0.207977, 0.797781, -1.190224>, <0.204033, 0.773479, -1.121038>, <0.201694, 0.757941, -1.068283>, 
      <0.157826, 0.850843, -1.238872>, <0.155133, 0.833769, -1.186612>, <0.148905, 0.808426, -1.118104>, <0.146566, 0.792888, -1.065349>, 
      <0.067209, 0.868160, -1.241031>, <0.064426, 0.853835, -1.197367>, <0.061060, 0.831073, -1.136280>, <0.059230, 0.817097, -1.092453>, 
      <0.003241, 0.865200, -1.241034>, <0.000458, 0.850875, -1.197370>, <-0.004206, 0.831426, -1.139316>, <-0.006036, 0.817450, -1.095489>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.450989, 0.560278, -1.271644>, <0.441191, 0.556725, -1.225573>, <0.426484, 0.554465, -1.164207>, <0.418330, 0.548435, -1.118073>, 
      <0.378893, 0.636651, -1.262896>, <0.369096, 0.633098, -1.216825>, <0.361493, 0.617317, -1.149270>, <0.353339, 0.611287, -1.103136>, 
      <0.297640, 0.755627, -1.248431>, <0.294948, 0.738553, -1.196170>, <0.281351, 0.724465, -1.125153>, <0.279012, 0.708928, -1.072398>, 
      <0.210670, 0.814855, -1.242485>, <0.207977, 0.797781, -1.190224>, <0.204033, 0.773479, -1.121038>, <0.201694, 0.757941, -1.068283>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.450989, 0.560278, -1.271644>, <0.441191, 0.556725, -1.225573>, <0.426484, 0.554465, -1.164207>, <0.418330, 0.548435, -1.118073>, 
      <0.450989, 0.560278, -1.271644>, <0.441191, 0.556725, -1.225573>, <0.426484, 0.554465, -1.164207>, <0.418330, 0.548435, -1.118073>, 
      <0.450989, 0.560278, -1.271644>, <0.441191, 0.556725, -1.225573>, <0.426484, 0.554465, -1.164207>, <0.418330, 0.548435, -1.118073>, 
      <0.450989, 0.560278, -1.271644>, <0.441191, 0.556725, -1.225573>, <0.426484, 0.554465, -1.164207>, <0.418330, 0.548435, -1.118073>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.529908, 0.130702, -1.266378>, <0.517883, 0.129419, -1.228606>, <0.497955, 0.122818, -1.179121>, <0.489826, 0.126425, -1.140470>, 
      <0.520575, 0.261402, -1.267664>, <0.508550, 0.260119, -1.229891>, <0.487569, 0.250495, -1.167970>, <0.479439, 0.254101, -1.129319>, 
      <0.474665, 0.431405, -1.270064>, <0.464867, 0.427852, -1.223993>, <0.447933, 0.427862, -1.170926>, <0.439779, 0.421832, -1.124792>, 
      <0.450989, 0.560278, -1.271644>, <0.441191, 0.556725, -1.225573>, <0.426484, 0.554465, -1.164207>, <0.418330, 0.548435, -1.118073>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.511067, -0.281012, -1.263370>, <0.502434, -0.268041, -1.240381>, <0.490200, -0.247465, -1.211536>, <0.482291, -0.237776, -1.186741>, 
      <0.551980, -0.164418, -1.267898>, <0.543347, -0.151447, -1.244909>, <0.527899, -0.144858, -1.197897>, <0.519991, -0.135168, -1.173101>, 
      <0.538715, 0.007375, -1.265165>, <0.526690, 0.006092, -1.227393>, <0.506854, 0.013433, -1.188675>, <0.498725, 0.017040, -1.150024>, 
      <0.529908, 0.130702, -1.266378>, <0.517883, 0.129419, -1.228606>, <0.497955, 0.122818, -1.179121>, <0.489826, 0.126425, -1.140470>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.366828, -0.334045, -1.248329>, <0.358730, -0.318375, -1.232251>, <0.346754, -0.292122, -1.215119>, <0.339834, -0.281812, -1.194737>, 
      <0.408140, -0.313087, -1.248301>, <0.400042, -0.297418, -1.232223>, <0.386824, -0.272291, -1.212318>, <0.379904, -0.261981, -1.191935>, 
      <0.495739, -0.324694, -1.261674>, <0.487106, -0.311723, -1.238685>, <0.474870, -0.289190, -1.217083>, <0.466961, -0.279501, -1.192287>, 
      <0.511067, -0.281012, -1.263370>, <0.502434, -0.268041, -1.240381>, <0.490200, -0.247465, -1.211536>, <0.482291, -0.237776, -1.186741>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.168612, -0.454739, -1.263603>, <0.165664, -0.437682, -1.247330>, <0.160265, -0.411237, -1.228953>, <0.158786, -0.397884, -1.209359>, 
      <0.232633, -0.427077, -1.265644>, <0.229685, -0.410020, -1.249371>, <0.218705, -0.383550, -1.228905>, <0.217226, -0.370197, -1.209311>, 
      <0.304605, -0.365611, -1.248371>, <0.296507, -0.349941, -1.232294>, <0.288910, -0.320750, -1.219163>, <0.281990, -0.310440, -1.198781>, 
      <0.366828, -0.334045, -1.248329>, <0.358730, -0.318375, -1.232251>, <0.346754, -0.292122, -1.215119>, <0.339834, -0.281812, -1.194737>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.032230, -0.506469, -1.235606>, <-0.032024, -0.491856, -1.223437>, <-0.032542, -0.470429, -1.209189>, <-0.031542, -0.457758, -1.195042>, 
      <0.030318, -0.511713, -1.234204>, <0.030525, -0.497100, -1.222035>, <0.027446, -0.471876, -1.210021>, <0.028446, -0.459205, -1.195875>, 
      <0.111003, -0.479631, -1.261766>, <0.108055, -0.462574, -1.245493>, <0.106033, -0.436931, -1.228998>, <0.104554, -0.423578, -1.209404>, 
      <0.168612, -0.454739, -1.263603>, <0.165664, -0.437682, -1.247330>, <0.160265, -0.411237, -1.228953>, <0.158786, -0.397884, -1.209359>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.032230, -0.506469, -1.235606>, <-0.079199, -0.502531, -1.236659>, <-0.121630, -0.449143, -1.267388>, <-0.163056, -0.426932, -1.271036>, 
      <-0.032024, -0.491856, -1.223437>, <-0.078993, -0.487918, -1.224489>, <-0.121294, -0.438107, -1.247549>, <-0.162720, -0.415896, -1.251197>, 
      <-0.032542, -0.470429, -1.209189>, <-0.076688, -0.469364, -1.208576>, <-0.121825, -0.420592, -1.225681>, <-0.160498, -0.399265, -1.225650>, 
      <-0.031542, -0.457758, -1.195042>, <-0.075688, -0.456693, -1.194429>, <-0.123263, -0.411473, -1.204938>, <-0.161936, -0.390146, -1.204907>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.340955, -0.264574, -1.124207>, <-0.286727, -0.291180, -1.130538>, <-0.224641, -0.343857, -1.142461>, <-0.171581, -0.372873, -1.148066>, 
      <-0.347975, -0.270119, -1.144291>, <-0.293747, -0.296726, -1.150622>, <-0.225925, -0.352683, -1.158160>, <-0.172865, -0.381698, -1.163765>, 
      <-0.346292, -0.273384, -1.174943>, <-0.287853, -0.302214, -1.178317>, <-0.220218, -0.351384, -1.188365>, <-0.163080, -0.382894, -1.188411>, 
      <-0.350346, -0.281947, -1.194783>, <-0.291907, -0.310777, -1.198158>, <-0.219075, -0.358636, -1.204861>, <-0.161936, -0.390146, -1.204907>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.475573, -0.223724, -1.112575>, <-0.462405, -0.263469, -1.118920>, <-0.378766, -0.246023, -1.119793>, <-0.340955, -0.264574, -1.124207>, 
      <-0.481882, -0.230009, -1.133207>, <-0.468714, -0.269755, -1.139552>, <-0.385786, -0.251568, -1.139876>, <-0.347975, -0.270119, -1.144291>, 
      <-0.482734, -0.220820, -1.166030>, <-0.466935, -0.262549, -1.170838>, <-0.386486, -0.253556, -1.172622>, <-0.346292, -0.273384, -1.174943>, 
      <-0.489760, -0.228423, -1.185976>, <-0.473961, -0.270153, -1.190784>, <-0.390540, -0.262119, -1.192462>, <-0.350346, -0.281947, -1.194783>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.477680, 0.148098, -1.058334>, <-0.488708, 0.037354, -1.076276>, <-0.510627, -0.117923, -1.095687>, <-0.475573, -0.223724, -1.112575>, 
      <-0.480105, 0.148392, -1.086389>, <-0.491133, 0.037648, -1.104331>, <-0.516935, -0.124208, -1.116319>, <-0.481882, -0.230009, -1.133207>, 
      <-0.501500, 0.143785, -1.119432>, <-0.511855, 0.032787, -1.130292>, <-0.522166, -0.116671, -1.154032>, <-0.482734, -0.220820, -1.166030>, 
      <-0.510925, 0.142179, -1.145921>, <-0.521280, 0.031181, -1.156781>, <-0.529192, -0.124274, -1.173977>, <-0.489760, -0.228423, -1.185976>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.400478, 0.530365, -0.990403>, <-0.423639, 0.415685, -1.010782>, <-0.466062, 0.264764, -1.039433>, <-0.477680, 0.148098, -1.058334>, 
      <-0.404076, 0.535212, -1.026501>, <-0.427237, 0.420532, -1.046880>, <-0.468486, 0.265058, -1.067488>, <-0.480105, 0.148392, -1.086389>, 
      <-0.411049, 0.537156, -1.074991>, <-0.438980, 0.417009, -1.085607>, <-0.490054, 0.266476, -1.107428>, <-0.501500, 0.143785, -1.119432>, 
      <-0.417824, 0.542669, -1.110532>, <-0.445754, 0.422522, -1.121149>, <-0.499479, 0.264870, -1.133917>, <-0.510925, 0.142179, -1.145921>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.400478, 0.530365, -0.990403>, <-0.400478, 0.530365, -0.990403>, <-0.400478, 0.530365, -0.990403>, <-0.400478, 0.530365, -0.990403>, 
      <-0.404076, 0.535212, -1.026501>, <-0.404076, 0.535212, -1.026501>, <-0.404076, 0.535212, -1.026501>, <-0.404076, 0.535212, -1.026501>, 
      <-0.411049, 0.537156, -1.074991>, <-0.411049, 0.537156, -1.074991>, <-0.411049, 0.537156, -1.074991>, <-0.411049, 0.537156, -1.074991>, 
      <-0.417824, 0.542669, -1.110532>, <-0.417824, 0.542669, -1.110532>, <-0.417824, 0.542669, -1.110532>, <-0.417824, 0.542669, -1.110532>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.215066, 0.715118, -0.967647>, <-0.281748, 0.673418, -0.972866>, <-0.344854, 0.585791, -0.983576>, <-0.400478, 0.530365, -0.990403>, 
      <-0.218452, 0.723887, -1.005058>, <-0.285134, 0.682186, -1.010277>, <-0.348452, 0.590638, -1.019674>, <-0.404076, 0.535212, -1.026501>, 
      <-0.218698, 0.749534, -1.050913>, <-0.292159, 0.700514, -1.053597>, <-0.351881, 0.602422, -1.068209>, <-0.411049, 0.537156, -1.074991>, 
      <-0.220595, 0.760224, -1.087927>, <-0.294056, 0.711204, -1.090611>, <-0.358655, 0.607935, -1.103751>, <-0.417824, 0.542669, -1.110532>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.008504, 0.775493, -0.959721>, <-0.072956, 0.773764, -0.963823>, <-0.160410, 0.749298, -0.963369>, <-0.215066, 0.715118, -0.967647>, 
      <-0.007761, 0.783384, -1.001615>, <-0.072212, 0.781656, -1.005717>, <-0.163797, 0.758067, -1.000779>, <-0.218452, 0.723887, -1.005058>, 
      <-0.007731, 0.804506, -1.054899>, <-0.074314, 0.804866, -1.057996>, <-0.163278, 0.786515, -1.048888>, <-0.218698, 0.749534, -1.050913>, 
      <-0.006036, 0.817450, -1.095489>, <-0.072620, 0.817810, -1.098586>, <-0.165175, 0.797205, -1.085903>, <-0.220595, 0.760224, -1.087927>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.197319, 0.726179, -0.941403>, <0.143107, 0.759352, -0.936677>, <0.055076, 0.777198, -0.955675>, <-0.008504, 0.775493, -0.959721>, 
      <0.196599, 0.733785, -0.979913>, <0.142387, 0.766958, -0.975187>, <0.055820, 0.785090, -0.997569>, <-0.007761, 0.783384, -1.001615>, 
      <0.200025, 0.746859, -1.030656>, <0.144898, 0.781806, -1.027722>, <0.057535, 0.804154, -1.051863>, <-0.007731, 0.804506, -1.054899>, 
      <0.201694, 0.757941, -1.068283>, <0.146566, 0.792888, -1.065349>, <0.059230, 0.817097, -1.092453>, <-0.006036, 0.817450, -1.095489>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.402185, 0.524186, -0.995520>, <0.340725, 0.584784, -0.979285>, <0.272024, 0.680466, -0.947915>, <0.197319, 0.726179, -0.941403>, 
      <0.405551, 0.529631, -1.032764>, <0.344091, 0.590229, -1.016529>, <0.271305, 0.688071, -0.986425>, <0.196599, 0.733785, -0.979913>, 
      <0.411807, 0.543611, -1.081164>, <0.346816, 0.606462, -1.066227>, <0.277343, 0.697846, -1.034771>, <0.200025, 0.746859, -1.030656>, 
      <0.418330, 0.548435, -1.118073>, <0.353339, 0.611287, -1.103136>, <0.279012, 0.708928, -1.072398>, <0.201694, 0.757941, -1.068283>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.402185, 0.524186, -0.995520>, <0.402185, 0.524186, -0.995520>, <0.402185, 0.524186, -0.995520>, <0.402185, 0.524186, -0.995520>, 
      <0.405551, 0.529631, -1.032764>, <0.405551, 0.529631, -1.032764>, <0.405551, 0.529631, -1.032764>, <0.405551, 0.529631, -1.032764>, 
      <0.411807, 0.543611, -1.081164>, <0.411807, 0.543611, -1.081164>, <0.411807, 0.543611, -1.081164>, <0.411807, 0.543611, -1.081164>, 
      <0.418330, 0.548435, -1.118073>, <0.418330, 0.548435, -1.118073>, <0.418330, 0.548435, -1.118073>, <0.418330, 0.548435, -1.118073>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.492352, 0.147364, -1.087818>, <0.482152, 0.264638, -1.067305>, <0.429235, 0.411139, -1.023210>, <0.402185, 0.524186, -0.995520>, 
      <0.494661, 0.145880, -1.104611>, <0.484461, 0.263153, -1.084098>, <0.432601, 0.416584, -1.060454>, <0.405551, 0.529631, -1.032764>, 
      <0.486338, 0.127972, -1.123888>, <0.475951, 0.255649, -1.112736>, <0.433255, 0.417008, -1.087883>, <0.411807, 0.543611, -1.081164>, 
      <0.489826, 0.126425, -1.140470>, <0.479439, 0.254101, -1.129319>, <0.439779, 0.421832, -1.124792>, <0.418330, 0.548435, -1.118073>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.467584, -0.227741, -1.127046>, <0.508718, -0.122633, -1.116211>, <0.502031, 0.036079, -1.107284>, <0.492352, 0.147364, -1.087818>, 
      <0.471287, -0.234063, -1.144238>, <0.512420, -0.128956, -1.133403>, <0.504340, 0.034594, -1.124077>, <0.494661, 0.145880, -1.104611>, 
      <0.476969, -0.231256, -1.170055>, <0.514668, -0.128648, -1.156416>, <0.495237, 0.018587, -1.133441>, <0.486338, 0.127972, -1.123888>, 
      <0.482291, -0.237776, -1.186741>, <0.519991, -0.135168, -1.173101>, <0.498725, 0.017040, -1.150024>, <0.489826, 0.126425, -1.140470>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.327112, -0.274869, -1.131343>, <0.366796, -0.255125, -1.127760>, <0.451452, -0.268962, -1.131295>, <0.467584, -0.227741, -1.127046>, 
      <0.327740, -0.281437, -1.149702>, <0.367424, -0.261693, -1.146120>, <0.455155, -0.275284, -1.148487>, <0.471287, -0.234063, -1.144238>, 
      <0.334178, -0.273384, -1.178076>, <0.374248, -0.253553, -1.175275>, <0.461639, -0.272981, -1.175602>, <0.476969, -0.231256, -1.170055>, 
      <0.339834, -0.281812, -1.194737>, <0.379904, -0.261981, -1.191935>, <0.466961, -0.279501, -1.192287>, <0.482291, -0.237776, -1.186741>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.160397, -0.380577, -1.154780>, <0.214525, -0.355862, -1.150793>, <0.273892, -0.301348, -1.136148>, <0.327112, -0.274869, -1.131343>, 
      <0.163845, -0.389233, -1.169219>, <0.217973, -0.364517, -1.165232>, <0.274520, -0.307916, -1.154507>, <0.327740, -0.281437, -1.149702>, 
      <0.157716, -0.388226, -1.195186>, <0.216156, -0.360538, -1.195139>, <0.276334, -0.302012, -1.182120>, <0.334178, -0.273384, -1.178076>, 
      <0.158786, -0.397884, -1.209359>, <0.217226, -0.370197, -1.209311>, <0.281990, -0.310440, -1.198781>, <0.339834, -0.281812, -1.194737>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.026702, -0.436424, -1.157404>, <0.031852, -0.437783, -1.158588>, <0.107227, -0.404855, -1.158696>, <0.160397, -0.380577, -1.154780>, 
      <-0.029020, -0.445398, -1.166606>, <0.029535, -0.446756, -1.167790>, <0.110675, -0.413511, -1.173135>, <0.163845, -0.389233, -1.169219>, 
      <-0.030855, -0.449057, -1.185327>, <0.029132, -0.450504, -1.186160>, <0.103484, -0.413919, -1.195231>, <0.157716, -0.388226, -1.195186>, 
      <-0.031542, -0.457758, -1.195042>, <0.028446, -0.459205, -1.195875>, <0.104554, -0.423578, -1.209404>, <0.158786, -0.397884, -1.209359>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.026702, -0.436424, -1.157404>, <-0.029020, -0.445398, -1.166606>, <-0.030855, -0.449057, -1.185327>, <-0.031542, -0.457758, -1.195042>, 
      <-0.074223, -0.435321, -1.156443>, <-0.076541, -0.444295, -1.165645>, <-0.075002, -0.447991, -1.184714>, <-0.075688, -0.456693, -1.194429>, 
      <-0.130045, -0.395587, -1.152454>, <-0.131329, -0.404413, -1.168153>, <-0.124407, -0.404221, -1.188443>, <-0.123263, -0.411473, -1.204938>, 
      <-0.171581, -0.372873, -1.148066>, <-0.172865, -0.381698, -1.163765>, <-0.163080, -0.382894, -1.188411>, <-0.161936, -0.390146, -1.204907>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.313079, -0.252509, -1.088165>, <-0.264109, -0.275173, -1.093007>, <-0.203581, -0.314346, -1.103193>, <-0.154012, -0.335674, -1.108008>, 
      <-0.306906, -0.254861, -1.100668>, <-0.257937, -0.277525, -1.105509>, <-0.198640, -0.319137, -1.118984>, <-0.149071, -0.340465, -1.123800>, 
      <-0.336440, -0.261008, -1.111290>, <-0.282212, -0.287614, -1.117621>, <-0.223416, -0.335437, -1.127483>, <-0.170356, -0.364453, -1.133088>, 
      <-0.340955, -0.264574, -1.124207>, <-0.286727, -0.291180, -1.130538>, <-0.224641, -0.343857, -1.142461>, <-0.171581, -0.372873, -1.148066>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.456767, -0.195553, -1.078074>, <-0.437831, -0.236246, -1.090107>, <-0.355081, -0.233070, -1.084012>, <-0.313079, -0.252509, -1.088165>, 
      <-0.454525, -0.203043, -1.090291>, <-0.435590, -0.243736, -1.102324>, <-0.348908, -0.235421, -1.096515>, <-0.306906, -0.254861, -1.100668>, 
      <-0.471501, -0.219667, -1.099258>, <-0.458333, -0.259412, -1.105602>, <-0.374251, -0.242456, -1.106876>, <-0.336440, -0.261008, -1.111290>, 
      <-0.475573, -0.223724, -1.112575>, <-0.462405, -0.263469, -1.118920>, <-0.378766, -0.246023, -1.119793>, <-0.340955, -0.264574, -1.124207>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.495894, 0.140357, -0.971994>, <-0.505055, 0.039097, -1.003110>, <-0.500096, -0.102439, -1.050540>, <-0.456767, -0.195553, -1.078074>, 
      <-0.490793, 0.130727, -0.996231>, <-0.499954, 0.029467, -1.027347>, <-0.497855, -0.109929, -1.062757>, <-0.454525, -0.203043, -1.090291>, 
      <-0.475392, 0.147821, -1.031860>, <-0.486420, 0.037076, -1.049802>, <-0.506555, -0.113866, -1.082369>, <-0.471501, -0.219667, -1.099258>, 
      <-0.477680, 0.148098, -1.058334>, <-0.488708, 0.037354, -1.076276>, <-0.510627, -0.117923, -1.095687>, <-0.475573, -0.223724, -1.112575>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.393003, 0.509232, -0.861501>, <-0.423870, 0.398570, -0.894649>, <-0.485592, 0.254231, -0.937002>, <-0.495894, 0.140357, -0.971994>, 
      <-0.388534, 0.500250, -0.899448>, <-0.419401, 0.389587, -0.932596>, <-0.480491, 0.244601, -0.961239>, <-0.490793, 0.130727, -0.996231>, 
      <-0.396619, 0.525167, -0.951689>, <-0.419780, 0.410487, -0.972069>, <-0.463774, 0.264487, -1.012959>, <-0.475392, 0.147821, -1.031860>, 
      <-0.400478, 0.530365, -0.990403>, <-0.423639, 0.415685, -1.010782>, <-0.466062, 0.264764, -1.039433>, <-0.477680, 0.148098, -1.058334>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.393003, 0.509232, -0.861501>, <-0.393003, 0.509232, -0.861501>, <-0.393003, 0.509232, -0.861501>, <-0.393003, 0.509232, -0.861501>, 
      <-0.388534, 0.500250, -0.899448>, <-0.388534, 0.500250, -0.899448>, <-0.388534, 0.500250, -0.899448>, <-0.388534, 0.500250, -0.899448>, 
      <-0.396619, 0.525167, -0.951689>, <-0.396619, 0.525167, -0.951689>, <-0.396619, 0.525167, -0.951689>, <-0.396619, 0.525167, -0.951689>, 
      <-0.400478, 0.530365, -0.990403>, <-0.400478, 0.530365, -0.990403>, <-0.400478, 0.530365, -0.990403>, <-0.400478, 0.530365, -0.990403>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.194626, 0.692981, -0.801049>, <-0.263076, 0.648521, -0.816779>, <-0.333490, 0.564357, -0.843365>, <-0.393003, 0.509232, -0.861501>, 
      <-0.191573, 0.683290, -0.850813>, <-0.260022, 0.638830, -0.866543>, <-0.329021, 0.555375, -0.881313>, <-0.388534, 0.500250, -0.899448>, 
      <-0.210607, 0.703572, -0.918388>, <-0.277289, 0.661871, -0.923608>, <-0.340996, 0.580593, -0.944863>, <-0.396619, 0.525167, -0.951689>, 
      <-0.215066, 0.715118, -0.967647>, <-0.281748, 0.673418, -0.972866>, <-0.344854, 0.585791, -0.983576>, <-0.400478, 0.530365, -0.990403>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.011741, 0.756871, -0.773883>, <-0.070373, 0.755507, -0.775980>, <-0.146300, 0.724370, -0.789943>, <-0.194626, 0.692981, -0.801049>, 
      <-0.011383, 0.748389, -0.829275>, <-0.070015, 0.747024, -0.831372>, <-0.143247, 0.714679, -0.839707>, <-0.191573, 0.683290, -0.850813>, 
      <-0.009481, 0.765121, -0.904659>, <-0.073932, 0.763393, -0.908760>, <-0.155951, 0.737752, -0.914110>, <-0.210607, 0.703572, -0.918388>, 
      <-0.008504, 0.775493, -0.959721>, <-0.072956, 0.773764, -0.963823>, <-0.160410, 0.749298, -0.963369>, <-0.215066, 0.715118, -0.967647>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.206956, 0.702326, -0.786689>, <0.149851, 0.737251, -0.776378>, <0.055925, 0.758446, -0.771463>, <-0.011741, 0.756871, -0.773883>, 
      <0.204520, 0.693371, -0.832816>, <0.147415, 0.728295, -0.822505>, <0.056284, 0.749963, -0.826856>, <-0.011383, 0.748389, -0.829275>, 
      <0.198181, 0.717064, -0.895251>, <0.143969, 0.750237, -0.890525>, <0.054100, 0.766827, -0.900613>, <-0.009481, 0.765121, -0.904659>, 
      <0.197319, 0.726179, -0.941403>, <0.143107, 0.759352, -0.936677>, <0.055076, 0.777198, -0.955675>, <-0.008504, 0.775493, -0.959721>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.393841, 0.508823, -0.847119>, <0.337776, 0.566874, -0.828990>, <0.276698, 0.659673, -0.799282>, <0.206956, 0.702326, -0.786689>, 
      <0.389338, 0.498732, -0.890564>, <0.333273, 0.556783, -0.872435>, <0.274262, 0.650717, -0.845410>, <0.204520, 0.693371, -0.832816>, 
      <0.398192, 0.517727, -0.951340>, <0.336732, 0.578325, -0.935105>, <0.272887, 0.671351, -0.901763>, <0.198181, 0.717064, -0.895251>, 
      <0.402185, 0.524186, -0.995520>, <0.340725, 0.584784, -0.979285>, <0.272024, 0.680466, -0.947915>, <0.197319, 0.726179, -0.941403>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.393841, 0.508823, -0.847119>, <0.393841, 0.508823, -0.847119>, <0.393841, 0.508823, -0.847119>, <0.393841, 0.508823, -0.847119>, 
      <0.389338, 0.498732, -0.890564>, <0.389338, 0.498732, -0.890564>, <0.389338, 0.498732, -0.890564>, <0.389338, 0.498732, -0.890564>, 
      <0.398192, 0.517727, -0.951340>, <0.398192, 0.517727, -0.951340>, <0.398192, 0.517727, -0.951340>, <0.398192, 0.517727, -0.951340>, 
      <0.402185, 0.524186, -0.995520>, <0.402185, 0.524186, -0.995520>, <0.402185, 0.524186, -0.995520>, <0.402185, 0.524186, -0.995520>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.465925, 0.141790, -0.966632>, <0.456189, 0.254227, -0.932861>, <0.415466, 0.398713, -0.882973>, <0.393841, 0.508823, -0.847119>, 
      <0.460340, 0.128894, -1.001127>, <0.450604, 0.241331, -0.967356>, <0.410963, 0.388622, -0.926418>, <0.389338, 0.498732, -0.890564>, 
      <0.487298, 0.150613, -1.051058>, <0.477098, 0.267887, -1.030545>, <0.425242, 0.404681, -0.979029>, <0.398192, 0.517727, -0.951340>, 
      <0.492352, 0.147364, -1.087818>, <0.482152, 0.264638, -1.067305>, <0.429235, 0.411139, -1.023210>, <0.402185, 0.524186, -0.995520>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.454357, -0.190076, -1.057035>, <0.485718, -0.096488, -1.026744>, <0.474458, 0.043246, -0.996230>, <0.465925, 0.141790, -0.966632>, 
      <0.451462, -0.202075, -1.077824>, <0.482822, -0.108488, -1.047533>, <0.468872, 0.030350, -1.030725>, <0.460340, 0.128894, -1.001127>, 
      <0.462794, -0.219561, -1.104804>, <0.503928, -0.114454, -1.093969>, <0.496977, 0.039328, -1.070524>, <0.487298, 0.150613, -1.051058>, 
      <0.467584, -0.227741, -1.127046>, <0.508718, -0.122633, -1.116211>, <0.502031, 0.036079, -1.107284>, <0.492352, 0.147364, -1.087818>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.336315, -0.244995, -1.091820>, <0.372701, -0.228325, -1.086112>, <0.442077, -0.226722, -1.068896>, <0.454357, -0.190076, -1.057035>, 
      <0.330960, -0.248484, -1.105520>, <0.367346, -0.231815, -1.099811>, <0.439182, -0.238721, -1.089685>, <0.451462, -0.202075, -1.077824>, 
      <0.326626, -0.269780, -1.117117>, <0.366309, -0.250036, -1.113534>, <0.446662, -0.260782, -1.109053>, <0.462794, -0.219561, -1.104804>, 
      <0.327112, -0.274869, -1.131343>, <0.366796, -0.255125, -1.127760>, <0.451452, -0.268962, -1.131295>, <0.467584, -0.227741, -1.127046>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.134396, -0.336659, -1.107230>, <0.196306, -0.312297, -1.102681>, <0.276296, -0.272491, -1.101236>, <0.336315, -0.244995, -1.091820>, 
      <0.131230, -0.342627, -1.127036>, <0.193139, -0.318265, -1.122487>, <0.270941, -0.275980, -1.114935>, <0.330960, -0.248484, -1.105520>, 
      <0.156198, -0.370036, -1.137196>, <0.210326, -0.345321, -1.133210>, <0.273406, -0.296258, -1.121921>, <0.326626, -0.269780, -1.117117>, 
      <0.160397, -0.380577, -1.154780>, <0.214525, -0.355862, -1.150793>, <0.273892, -0.301348, -1.136148>, <0.327112, -0.274869, -1.131343>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.011991, -0.382055, -1.117413>, <0.034089, -0.382212, -1.117289>, <0.091616, -0.353493, -1.110373>, <0.134396, -0.336659, -1.107230>, 
      <-0.010593, -0.389097, -1.136853>, <0.035487, -0.389254, -1.136729>, <0.088450, -0.359461, -1.130180>, <0.131230, -0.342627, -1.127036>, 
      <-0.023025, -0.422185, -1.142803>, <0.035530, -0.423544, -1.143987>, <0.103027, -0.394314, -1.141113>, <0.156198, -0.370036, -1.137196>, 
      <-0.026702, -0.436424, -1.157404>, <0.031852, -0.437783, -1.158588>, <0.107227, -0.404855, -1.158696>, <0.160397, -0.380577, -1.154780>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.011991, -0.382055, -1.117413>, <-0.010593, -0.389097, -1.136853>, <-0.023025, -0.422185, -1.142803>, <-0.026702, -0.436424, -1.157404>, 
      <-0.056900, -0.381902, -1.117534>, <-0.055502, -0.388943, -1.136974>, <-0.070546, -0.421083, -1.141842>, <-0.074223, -0.435321, -1.156443>, 
      <-0.112922, -0.353353, -1.112000>, <-0.107981, -0.358144, -1.127791>, <-0.128820, -0.387167, -1.137476>, <-0.130045, -0.395587, -1.152454>, 
      <-0.154012, -0.335674, -1.108008>, <-0.149071, -0.340465, -1.123800>, <-0.170356, -0.364453, -1.133088>, <-0.171581, -0.372873, -1.148066>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.463516, -0.217880, -0.875957>, <-0.429154, -0.266245, -0.926433>, <-0.304325, -0.286509, -0.931145>, <-0.233511, -0.312826, -0.950134>, 
      <-0.429751, -0.221022, -0.947004>, <-0.395389, -0.269387, -0.997480>, <-0.283697, -0.288116, -0.980448>, <-0.212883, -0.314433, -0.999438>, 
      <-0.347444, -0.239416, -1.018557>, <-0.298475, -0.262080, -1.023399>, <-0.218917, -0.299476, -1.054176>, <-0.169349, -0.320804, -1.058991>, 
      <-0.313079, -0.252509, -1.088165>, <-0.264109, -0.275173, -1.093007>, <-0.203581, -0.314346, -1.103193>, <-0.154012, -0.335674, -1.108008>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.605689, 0.211028, -0.403422>, <-0.567130, 0.077989, -0.542295>, <-0.550039, -0.096095, -0.748858>, <-0.463516, -0.217880, -0.875957>, 
      <-0.556929, 0.153732, -0.631846>, <-0.518369, 0.020694, -0.770718>, <-0.516274, -0.099237, -0.819905>, <-0.429751, -0.221022, -0.947004>, 
      <-0.493935, -0.071367, -0.875505>, <-0.474998, -0.112060, -0.887538>, <-0.389446, -0.219977, -1.014404>, <-0.347444, -0.239416, -1.018557>, 
      <-0.456767, -0.195553, -1.078074>, <-0.437831, -0.236246, -1.090107>, <-0.355081, -0.233070, -1.084012>, <-0.313079, -0.252509, -1.088165>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.680642, 0.531255, -0.093972>, <-0.687165, 0.443862, -0.197282>, <-0.632322, 0.302916, -0.307504>, <-0.605689, 0.211028, -0.403422>, 
      <-0.617108, 0.506456, -0.379551>, <-0.623632, 0.419063, -0.482861>, <-0.583561, 0.245621, -0.535928>, <-0.556929, 0.153732, -0.631846>, 
      <-0.552253, 0.246754, -0.704206>, <-0.561415, 0.145494, -0.735322>, <-0.537264, 0.021747, -0.847971>, <-0.493935, -0.071367, -0.875505>, 
      <-0.495894, 0.140357, -0.971994>, <-0.505055, 0.039097, -1.003110>, <-0.500096, -0.102439, -1.050540>, <-0.456767, -0.195553, -1.078074>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.558192, 0.847351, 0.348794>, <-0.594927, 0.752522, 0.215964>, <-0.672587, 0.639172, 0.033600>, <-0.680642, 0.531255, -0.093972>, 
      <-0.494745, 0.873911, -0.025168>, <-0.531480, 0.779083, -0.157998>, <-0.609053, 0.614374, -0.251979>, <-0.617108, 0.506456, -0.379551>, 
      <-0.436295, 0.596244, -0.493896>, <-0.467162, 0.485581, -0.527044>, <-0.541951, 0.360627, -0.669214>, <-0.552253, 0.246754, -0.704206>, 
      <-0.393003, 0.509232, -0.861501>, <-0.423870, 0.398570, -0.894649>, <-0.485592, 0.254231, -0.937002>, <-0.495894, 0.140357, -0.971994>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.558192, 0.847351, 0.348794>, <-0.558192, 0.847351, 0.348794>, <-0.558192, 0.847351, 0.348794>, <-0.558192, 0.847351, 0.348794>, 
      <-0.494745, 0.873911, -0.025168>, <-0.494745, 0.873911, -0.025168>, <-0.494745, 0.873911, -0.025168>, <-0.494745, 0.873911, -0.025168>, 
      <-0.436295, 0.596244, -0.493896>, <-0.436295, 0.596244, -0.493896>, <-0.436295, 0.596244, -0.493896>, <-0.436295, 0.596244, -0.493896>, 
      <-0.393003, 0.509232, -0.861501>, <-0.393003, 0.509232, -0.861501>, <-0.393003, 0.509232, -0.861501>, <-0.393003, 0.509232, -0.861501>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.309843, 1.015939, 0.577090>, <-0.405290, 0.985174, 0.524716>, <-0.483687, 0.897927, 0.417283>, <-0.558192, 0.847351, 0.348794>, 
      <-0.283224, 1.066789, 0.154927>, <-0.378671, 1.036025, 0.102552>, <-0.420240, 0.924488, 0.043321>, <-0.494745, 0.873911, -0.025168>, 
      <-0.220238, 0.774272, -0.383614>, <-0.288687, 0.729812, -0.399345>, <-0.376782, 0.651368, -0.475761>, <-0.436295, 0.596244, -0.493896>, 
      <-0.194626, 0.692981, -0.801049>, <-0.263076, 0.648521, -0.816779>, <-0.333490, 0.564357, -0.843365>, <-0.393003, 0.509232, -0.861501>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.018883, 1.021182, 0.644729>, <-0.108509, 1.020449, 0.644922>, <-0.234227, 1.040312, 0.618583>, <-0.309843, 1.015939, 0.577090>, 
      <-0.014958, 1.079895, 0.215834>, <-0.104584, 1.079163, 0.216028>, <-0.207608, 1.091162, 0.196420>, <-0.283224, 1.066789, 0.154927>, 
      <-0.014509, 0.822398, -0.345967>, <-0.073141, 0.821033, -0.348064>, <-0.171911, 0.805661, -0.372508>, <-0.220238, 0.774272, -0.383614>, 
      <-0.011741, 0.756871, -0.773883>, <-0.070373, 0.755507, -0.775980>, <-0.146300, 0.724370, -0.789943>, <-0.194626, 0.692981, -0.801049>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.277447, 1.020741, 0.575823>, <0.200058, 1.046310, 0.616902>, <0.072385, 1.021928, 0.644532>, <-0.018883, 1.021182, 0.644729>, 
      <0.255859, 1.071701, 0.159183>, <0.178469, 1.097270, 0.200262>, <0.076310, 1.080642, 0.215637>, <-0.014958, 1.079895, 0.215834>, 
      <0.228717, 0.782322, -0.374647>, <0.171612, 0.817247, -0.364335>, <0.053157, 0.823972, -0.343547>, <-0.014509, 0.822398, -0.345967>, 
      <0.206956, 0.702326, -0.786689>, <0.149851, 0.737251, -0.776378>, <0.055925, 0.758446, -0.771463>, <-0.011741, 0.756871, -0.773883>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.541371, 0.836081, 0.347342>, <0.462194, 0.891479, 0.415886>, <0.377903, 0.987552, 0.522500>, <0.277447, 1.020741, 0.575823>, 
      <0.487934, 0.862462, -0.022053>, <0.408757, 0.917860, 0.046491>, <0.356315, 1.038512, 0.105860>, <0.255859, 1.071701, 0.159183>, 
      <0.431427, 0.593047, -0.484493>, <0.375361, 0.651098, -0.466364>, <0.298459, 0.739669, -0.387240>, <0.228717, 0.782322, -0.374647>, 
      <0.393841, 0.508823, -0.847119>, <0.337776, 0.566874, -0.828990>, <0.276698, 0.659673, -0.799282>, <0.206956, 0.702326, -0.786689>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.541371, 0.836081, 0.347342>, <0.541371, 0.836081, 0.347342>, <0.541371, 0.836081, 0.347342>, <0.541371, 0.836081, 0.347342>, 
      <0.487934, 0.862462, -0.022053>, <0.487934, 0.862462, -0.022053>, <0.487934, 0.862462, -0.022053>, <0.487934, 0.862462, -0.022053>, 
      <0.431427, 0.593047, -0.484493>, <0.431427, 0.593047, -0.484493>, <0.431427, 0.593047, -0.484493>, <0.431427, 0.593047, -0.484493>, 
      <0.393841, 0.508823, -0.847119>, <0.393841, 0.508823, -0.847119>, <0.393841, 0.508823, -0.847119>, <0.393841, 0.508823, -0.847119>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.653053, 0.518403, -0.095347>, <0.648399, 0.627313, 0.030986>, <0.574876, 0.740778, 0.214535>, <0.541371, 0.836081, 0.347342>, 
      <0.589441, 0.493613, -0.377443>, <0.584787, 0.602522, -0.251111>, <0.521439, 0.767159, -0.154860>, <0.487934, 0.862462, -0.022053>, 
      <0.509447, 0.242278, -0.697843>, <0.499712, 0.354715, -0.664073>, <0.453052, 0.482937, -0.520347>, <0.431427, 0.593047, -0.484493>, 
      <0.465925, 0.141790, -0.966632>, <0.456189, 0.254227, -0.932861>, <0.415466, 0.398713, -0.882973>, <0.393841, 0.508823, -0.847119>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.568889, 0.192095, -0.399667>, <0.597083, 0.283065, -0.302276>, <0.656852, 0.429494, -0.198479>, <0.653053, 0.518403, -0.095347>, 
      <0.526017, 0.138801, -0.619983>, <0.554211, 0.229771, -0.522592>, <0.593240, 0.404704, -0.480575>, <0.589441, 0.493613, -0.377443>, 
      <0.481983, -0.075585, -0.858676>, <0.513344, 0.018003, -0.828385>, <0.517980, 0.143734, -0.727441>, <0.509447, 0.242278, -0.697843>, 
      <0.454357, -0.190076, -1.057035>, <0.485718, -0.096488, -1.026744>, <0.474458, 0.043246, -0.996230>, <0.465925, 0.141790, -0.966632>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.427462, -0.209485, -0.874612>, <0.512931, -0.093207, -0.748954>, <0.529284, 0.064305, -0.536477>, <0.568889, 0.192095, -0.399667>, 
      <0.404968, -0.212180, -0.942392>, <0.490437, -0.095902, -0.816733>, <0.486412, 0.011012, -0.756793>, <0.526017, 0.138801, -0.619983>, 
      <0.361630, -0.228501, -1.027056>, <0.398016, -0.211831, -1.021347>, <0.469703, -0.112231, -0.870537>, <0.481983, -0.075585, -0.858676>, 
      <0.336315, -0.244995, -1.091820>, <0.372701, -0.228325, -1.086112>, <0.442077, -0.226722, -1.068896>, <0.454357, -0.190076, -1.057035>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.192691, -0.319711, -0.952761>, <0.267239, -0.293127, -0.934332>, <0.391165, -0.258866, -0.927976>, <0.427462, -0.209485, -0.874612>, 
      <0.176093, -0.320814, -0.999691>, <0.250641, -0.294231, -0.981263>, <0.368671, -0.261561, -0.995756>, <0.404968, -0.212180, -0.942392>, 
      <0.141929, -0.322461, -1.060105>, <0.203839, -0.298099, -1.055556>, <0.301611, -0.255997, -1.036471>, <0.361630, -0.228501, -1.027056>, 
      <0.134396, -0.336659, -1.107230>, <0.196306, -0.312297, -1.102681>, <0.276296, -0.272491, -1.101236>, <0.336315, -0.244995, -1.091820>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.038753, -0.375736, -0.989862>, <0.033537, -0.376904, -0.990308>, <0.126365, -0.343363, -0.969157>, <0.192691, -0.319711, -0.952761>, 
      <-0.029351, -0.374701, -1.027847>, <0.042938, -0.375869, -1.028292>, <0.109767, -0.344466, -1.016087>, <0.176093, -0.320814, -0.999691>, 
      <-0.014632, -0.368754, -1.080693>, <0.031448, -0.368911, -1.080568>, <0.099149, -0.339295, -1.063248>, <0.141929, -0.322461, -1.060105>, 
      <-0.011991, -0.382055, -1.117413>, <0.034089, -0.382212, -1.117289>, <0.091616, -0.353493, -1.110373>, <0.134396, -0.336659, -1.107230>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.038753, -0.375736, -0.989862>, <-0.029351, -0.374701, -1.027847>, <-0.014632, -0.368754, -1.080693>, <-0.011991, -0.382055, -1.117413>, 
      <-0.101290, -0.374726, -0.989477>, <-0.091888, -0.373691, -1.027461>, <-0.059541, -0.368601, -1.080814>, <-0.056900, -0.381902, -1.117534>, 
      <-0.176651, -0.333957, -0.965382>, <-0.156023, -0.335564, -1.014685>, <-0.128259, -0.338483, -1.062983>, <-0.112922, -0.353353, -1.112000>, 
      <-0.233511, -0.312826, -0.950134>, <-0.212883, -0.314433, -0.999438>, <-0.169349, -0.320804, -1.058991>, <-0.154012, -0.335674, -1.108008>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.511350, -0.234060, -0.670977>, <-0.466121, -0.275317, -0.749200>, <-0.339708, -0.299819, -0.813654>, <-0.257180, -0.327638, -0.861424>, 
      <-0.497505, -0.215001, -0.729765>, <-0.452276, -0.256258, -0.807989>, <-0.333753, -0.285572, -0.836891>, <-0.251225, -0.313390, -0.884661>, 
      <-0.490679, -0.215353, -0.818801>, <-0.456318, -0.263718, -0.869277>, <-0.315088, -0.285671, -0.905418>, <-0.244275, -0.311988, -0.924407>, 
      <-0.463516, -0.217880, -0.875957>, <-0.429154, -0.266245, -0.926433>, <-0.304325, -0.286509, -0.931145>, <-0.233511, -0.312826, -0.950134>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.646891, 0.027851, -0.187417>, <-0.606244, -0.044950, -0.335470>, <-0.588719, -0.163485, -0.537167>, <-0.511350, -0.234060, -0.670977>, 
      <-0.636269, 0.104114, -0.225403>, <-0.595622, 0.031314, -0.373456>, <-0.574874, -0.144426, -0.595955>, <-0.497505, -0.215001, -0.729765>, 
      <-0.623097, 0.231483, -0.321872>, <-0.584538, 0.098444, -0.460745>, <-0.577203, -0.093568, -0.691703>, <-0.490679, -0.215353, -0.818801>, 
      <-0.605689, 0.211028, -0.403422>, <-0.567130, 0.077989, -0.542295>, <-0.550039, -0.096095, -0.748858>, <-0.463516, -0.217880, -0.875957>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.782957, 0.252404, 0.318332>, <-0.775712, 0.200670, 0.155556>, <-0.687786, 0.101096, -0.038462>, <-0.646891, 0.027851, -0.187417>, 
      <-0.765954, 0.378656, 0.234599>, <-0.758708, 0.326922, 0.071824>, <-0.677163, 0.177359, -0.076448>, <-0.636269, 0.104114, -0.225403>, 
      <-0.713630, 0.544131, 0.054304>, <-0.720153, 0.456738, -0.049005>, <-0.649730, 0.323372, -0.225954>, <-0.623097, 0.231483, -0.321872>, 
      <-0.680642, 0.531255, -0.093972>, <-0.687165, 0.443862, -0.197282>, <-0.632322, 0.302916, -0.307504>, <-0.605689, 0.211028, -0.403422>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.696515, 0.382176, 0.927418>, <-0.722448, 0.343244, 0.744692>, <-0.790951, 0.309485, 0.497928>, <-0.782957, 0.252404, 0.318332>, 
      <-0.669217, 0.570839, 0.804982>, <-0.695150, 0.531907, 0.622256>, <-0.773948, 0.435737, 0.414196>, <-0.765954, 0.378656, 0.234599>, 
      <-0.595997, 0.831525, 0.571616>, <-0.632732, 0.736697, 0.438787>, <-0.705574, 0.652048, 0.181877>, <-0.713630, 0.544131, 0.054304>, 
      <-0.558192, 0.847351, 0.348794>, <-0.594927, 0.752522, 0.215964>, <-0.672587, 0.639172, 0.033600>, <-0.680642, 0.531255, -0.093972>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.696515, 0.382176, 0.927418>, <-0.696515, 0.382176, 0.927418>, <-0.696515, 0.382176, 0.927418>, <-0.696515, 0.382176, 0.927418>, 
      <-0.669217, 0.570839, 0.804982>, <-0.669217, 0.570839, 0.804982>, <-0.669217, 0.570839, 0.804982>, <-0.669217, 0.570839, 0.804982>, 
      <-0.595997, 0.831525, 0.571616>, <-0.595997, 0.831525, 0.571616>, <-0.595997, 0.831525, 0.571616>, <-0.595997, 0.831525, 0.571616>, 
      <-0.558192, 0.847351, 0.348794>, <-0.558192, 0.847351, 0.348794>, <-0.558192, 0.847351, 0.348794>, <-0.558192, 0.847351, 0.348794>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.324173, 0.445506, 1.253506>, <-0.452776, 0.428333, 1.178842>, <-0.584812, 0.401175, 1.025244>, <-0.696515, 0.382176, 0.927418>, 
      <-0.314978, 0.666671, 1.106931>, <-0.443582, 0.649498, 1.032267>, <-0.557514, 0.589838, 0.902808>, <-0.669217, 0.570839, 0.804982>, 
      <-0.326430, 0.984252, 0.840155>, <-0.421877, 0.953488, 0.787781>, <-0.521492, 0.882102, 0.640105>, <-0.595997, 0.831525, 0.571616>, 
      <-0.309843, 1.015939, 0.577090>, <-0.405290, 0.985174, 0.524716>, <-0.483687, 0.897927, 0.417283>, <-0.558192, 0.847351, 0.348794>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.030849, 0.471066, 1.313891>, <-0.121012, 0.470090, 1.313448>, <-0.246708, 0.455850, 1.298480>, <-0.324173, 0.445506, 1.253506>, 
      <-0.029859, 0.685855, 1.167555>, <-0.120022, 0.684879, 1.167112>, <-0.237514, 0.677015, 1.151906>, <-0.314978, 0.666671, 1.106931>, 
      <-0.021240, 0.985933, 0.902219>, <-0.110866, 0.985200, 0.902413>, <-0.250814, 1.008625, 0.881648>, <-0.326430, 0.984252, 0.840155>, 
      <-0.018883, 1.021182, 0.644729>, <-0.108509, 1.020449, 0.644922>, <-0.234227, 1.040312, 0.618583>, <-0.309843, 1.015939, 0.577090>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.312832, 0.452401, 1.256636>, <0.222715, 0.464128, 1.308580>, <0.073819, 0.472199, 1.314405>, <-0.030849, 0.471066, 1.313891>, 
      <0.301003, 0.673395, 1.108578>, <0.210886, 0.685121, 1.160523>, <0.074809, 0.686988, 1.168069>, <-0.029859, 0.685855, 1.167555>, 
      <0.291124, 0.988456, 0.839773>, <0.213734, 1.014025, 0.880853>, <0.070028, 0.986679, 0.902022>, <-0.021240, 0.985933, 0.902219>, 
      <0.277447, 1.020741, 0.575823>, <0.200058, 1.046310, 0.616902>, <0.072385, 1.021928, 0.644532>, <-0.018883, 1.021182, 0.644729>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.649708, 0.382506, 0.921613>, <0.548645, 0.403475, 1.022120>, <0.436862, 0.436261, 1.185144>, <0.312832, 0.452401, 1.256636>, 
      <0.631020, 0.566647, 0.799157>, <0.529957, 0.587616, 0.899663>, <0.425033, 0.657255, 1.037086>, <0.301003, 0.673395, 1.108578>, 
      <0.573066, 0.820434, 0.566439>, <0.493889, 0.875832, 0.634983>, <0.391580, 0.955267, 0.786451>, <0.291124, 0.988456, 0.839773>, 
      <0.541371, 0.836081, 0.347342>, <0.462194, 0.891479, 0.415886>, <0.377903, 0.987552, 0.522500>, <0.277447, 1.020741, 0.575823>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.649708, 0.382506, 0.921613>, <0.649708, 0.382506, 0.921613>, <0.649708, 0.382506, 0.921613>, <0.649708, 0.382506, 0.921613>, 
      <0.631020, 0.566647, 0.799157>, <0.631020, 0.566647, 0.799157>, <0.631020, 0.566647, 0.799157>, <0.631020, 0.566647, 0.799157>, 
      <0.573066, 0.820434, 0.566439>, <0.573066, 0.820434, 0.566439>, <0.573066, 0.820434, 0.566439>, <0.573066, 0.820434, 0.566439>, 
      <0.541371, 0.836081, 0.347342>, <0.541371, 0.836081, 0.347342>, <0.541371, 0.836081, 0.347342>, <0.541371, 0.836081, 0.347342>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.753288, 0.253779, 0.307723>, <0.757159, 0.313159, 0.488923>, <0.680782, 0.343888, 0.737446>, <0.649708, 0.382506, 0.921613>, 
      <0.733258, 0.374764, 0.225322>, <0.737129, 0.434143, 0.406522>, <0.662094, 0.528029, 0.614989>, <0.631020, 0.566647, 0.799157>, 
      <0.685434, 0.531022, 0.048252>, <0.680780, 0.639932, 0.174585>, <0.606570, 0.725131, 0.433632>, <0.573066, 0.820434, 0.566439>, 
      <0.653053, 0.518403, -0.095347>, <0.648399, 0.627313, 0.030986>, <0.574876, 0.740778, 0.214535>, <0.541371, 0.836081, 0.347342>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.626316, 0.023684, -0.173352>, <0.666780, 0.094305, -0.030453>, <0.749950, 0.202578, 0.151479>, <0.753288, 0.253779, 0.307723>, 
      <0.617363, 0.100802, -0.211190>, <0.657826, 0.171423, -0.068291>, <0.729920, 0.323562, 0.069078>, <0.733258, 0.374764, 0.225322>, 
      <0.584940, 0.212047, -0.317184>, <0.613134, 0.303017, -0.219794>, <0.689233, 0.442114, -0.054880>, <0.685434, 0.531022, 0.048252>, 
      <0.568889, 0.192095, -0.399667>, <0.597083, 0.283065, -0.302276>, <0.656852, 0.429494, -0.198479>, <0.653053, 0.518403, -0.095347>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.477174, -0.228118, -0.667383>, <0.557275, -0.157225, -0.532356>, <0.583931, -0.050290, -0.323037>, <0.626316, 0.023684, -0.173352>, 
      <0.463177, -0.206191, -0.726051>, <0.543279, -0.135298, -0.591024>, <0.574977, 0.026828, -0.360875>, <0.617363, 0.100802, -0.211190>, 
      <0.447662, -0.207065, -0.813746>, <0.533131, -0.090787, -0.688087>, <0.545334, 0.084257, -0.453994>, <0.584940, 0.212047, -0.317184>, 
      <0.427462, -0.209485, -0.874612>, <0.512931, -0.093207, -0.748954>, <0.529284, 0.064305, -0.536477>, <0.568889, 0.192095, -0.399667>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.226051, -0.330567, -0.848081>, <0.310621, -0.305425, -0.805953>, <0.431712, -0.268354, -0.744019>, <0.477174, -0.228118, -0.667383>, 
      <0.217371, -0.314858, -0.875918>, <0.301941, -0.289716, -0.833790>, <0.417715, -0.246427, -0.802687>, <0.463177, -0.206191, -0.726051>, 
      <0.203732, -0.318977, -0.921543>, <0.278280, -0.292393, -0.903115>, <0.411365, -0.256446, -0.867110>, <0.447662, -0.207065, -0.813746>, 
      <0.192691, -0.319711, -0.952761>, <0.267239, -0.293127, -0.934332>, <0.391165, -0.258866, -0.927976>, <0.427462, -0.209485, -0.874612>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.057460, -0.387059, -0.933706>, <0.032953, -0.387607, -0.931209>, <0.147813, -0.353826, -0.887055>, <0.226051, -0.330567, -0.848081>, 
      <-0.055363, -0.378545, -0.949516>, <0.035050, -0.379093, -0.947020>, <0.139133, -0.338118, -0.914891>, <0.217371, -0.314858, -0.875918>, 
      <-0.043095, -0.376214, -0.972319>, <0.029195, -0.377382, -0.972764>, <0.137406, -0.342629, -0.937939>, <0.203732, -0.318977, -0.921543>, 
      <-0.038753, -0.375736, -0.989862>, <0.033537, -0.376904, -0.990308>, <0.126365, -0.343363, -0.969157>, <0.192691, -0.319711, -0.952761>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.057460, -0.387059, -0.933706>, <-0.055363, -0.378545, -0.949516>, <-0.043095, -0.376214, -0.972319>, <-0.038753, -0.375736, -0.989862>, 
      <-0.123600, -0.386658, -0.935532>, <-0.121503, -0.378144, -0.951342>, <-0.105632, -0.375204, -0.971933>, <-0.101290, -0.374726, -0.989477>, 
      <-0.202207, -0.346168, -0.893244>, <-0.196252, -0.331921, -0.916481>, <-0.187415, -0.333118, -0.939655>, <-0.176651, -0.333957, -0.965382>, 
      <-0.257180, -0.327638, -0.861424>, <-0.251225, -0.313390, -0.884661>, <-0.244275, -0.311988, -0.924407>, <-0.233511, -0.312826, -0.950134>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.519012, -0.294275, -0.640310>, <-0.468110, -0.316342, -0.720999>, <-0.348175, -0.370769, -0.773132>, <-0.266171, -0.390967, -0.822690>, 
      <-0.517490, -0.276760, -0.650662>, <-0.466588, -0.298828, -0.731351>, <-0.351623, -0.359122, -0.791992>, <-0.269619, -0.379321, -0.841551>, 
      <-0.515810, -0.240200, -0.652039>, <-0.470581, -0.281457, -0.730262>, <-0.344496, -0.311275, -0.794970>, <-0.261968, -0.339094, -0.842740>, 
      <-0.511350, -0.234060, -0.670977>, <-0.466121, -0.275317, -0.749200>, <-0.339708, -0.299819, -0.813654>, <-0.257180, -0.327638, -0.861424>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.665430, -0.217877, -0.189790>, <-0.630440, -0.245286, -0.326707>, <-0.593841, -0.261835, -0.521692>, <-0.519012, -0.294275, -0.640310>, 
      <-0.662018, -0.144792, -0.179171>, <-0.627028, -0.172201, -0.316088>, <-0.592318, -0.244320, -0.532045>, <-0.517490, -0.276760, -0.650662>, 
      <-0.656038, -0.037817, -0.154709>, <-0.615391, -0.110618, -0.302762>, <-0.593179, -0.169625, -0.518229>, <-0.515810, -0.240200, -0.652039>, 
      <-0.646891, 0.027851, -0.187417>, <-0.606244, -0.044950, -0.335470>, <-0.588719, -0.163485, -0.537167>, <-0.511350, -0.234060, -0.670977>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.765789, -0.100967, 0.325329>, <-0.762445, -0.123831, 0.165692>, <-0.704638, -0.187165, -0.036371>, <-0.665430, -0.217877, -0.189790>, 
      <-0.773106, 0.004877, 0.328911>, <-0.769762, -0.017987, 0.169275>, <-0.701225, -0.114080, -0.025752>, <-0.662018, -0.144792, -0.179171>, 
      <-0.794798, 0.164487, 0.376640>, <-0.787552, 0.112753, 0.213864>, <-0.696932, 0.035427, -0.005753>, <-0.656038, -0.037817, -0.154709>, 
      <-0.782957, 0.252404, 0.318332>, <-0.775712, 0.200670, 0.155556>, <-0.687786, 0.101096, -0.038462>, <-0.646891, 0.027851, -0.187417>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.689002, -0.056705, 0.935498>, <-0.712038, -0.069984, 0.752447>, <-0.769624, -0.074747, 0.508393>, <-0.765789, -0.100967, 0.325329>, 
      <-0.698837, 0.073243, 0.954557>, <-0.721873, 0.059964, 0.771506>, <-0.776941, 0.031097, 0.511975>, <-0.773106, 0.004877, 0.328911>, 
      <-0.712384, 0.272501, 0.998594>, <-0.738317, 0.233569, 0.815868>, <-0.802792, 0.221568, 0.556236>, <-0.794798, 0.164487, 0.376640>, 
      <-0.696515, 0.382176, 0.927418>, <-0.722448, 0.343244, 0.744692>, <-0.790951, 0.309485, 0.497928>, <-0.782957, 0.252404, 0.318332>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.689002, -0.056705, 0.935498>, <-0.689002, -0.056705, 0.935498>, <-0.689002, -0.056705, 0.935498>, <-0.689002, -0.056705, 0.935498>, 
      <-0.698837, 0.073243, 0.954557>, <-0.698837, 0.073243, 0.954557>, <-0.698837, 0.073243, 0.954557>, <-0.698837, 0.073243, 0.954557>, 
      <-0.712384, 0.272501, 0.998594>, <-0.712384, 0.272501, 0.998594>, <-0.712384, 0.272501, 0.998594>, <-0.712384, 0.272501, 0.998594>, 
      <-0.696515, 0.382176, 0.927418>, <-0.696515, 0.382176, 0.927418>, <-0.696515, 0.382176, 0.927418>, <-0.696515, 0.382176, 0.927418>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.353913, -0.044122, 1.279634>, <-0.474511, -0.046312, 1.200704>, <-0.588475, -0.052930, 1.038739>, <-0.689002, -0.056705, 0.935498>, 
      <-0.349169, 0.101792, 1.299727>, <-0.469767, 0.099602, 1.220797>, <-0.598310, 0.077018, 1.057798>, <-0.698837, 0.073243, 0.954557>, 
      <-0.329277, 0.322740, 1.334868>, <-0.457880, 0.305567, 1.260203>, <-0.600682, 0.291500, 1.096420>, <-0.712384, 0.272501, 0.998594>, 
      <-0.324173, 0.445506, 1.253506>, <-0.452776, 0.428333, 1.178842>, <-0.584812, 0.401175, 1.025244>, <-0.696515, 0.382176, 0.927418>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.023797, -0.044625, 1.370866>, <-0.126445, -0.041665, 1.367452>, <-0.267952, -0.042561, 1.335895>, <-0.353913, -0.044122, 1.279634>, 
      <-0.025326, 0.110055, 1.388263>, <-0.127974, 0.113015, 1.384849>, <-0.263208, 0.103354, 1.355987>, <-0.349169, 0.101792, 1.299727>, 
      <-0.031442, 0.342423, 1.401536>, <-0.121605, 0.341447, 1.401093>, <-0.251812, 0.333084, 1.379842>, <-0.329277, 0.322740, 1.334868>, 
      <-0.030849, 0.471066, 1.313891>, <-0.121012, 0.470090, 1.313448>, <-0.246708, 0.455850, 1.298480>, <-0.324173, 0.445506, 1.253506>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.335510, -0.064002, 1.302562>, <0.243707, -0.062568, 1.362920>, <0.085973, -0.047790, 1.374516>, <-0.023797, -0.044625, 1.370866>, 
      <0.336902, 0.090226, 1.323736>, <0.245099, 0.091660, 1.384094>, <0.084444, 0.106890, 1.391914>, <-0.025326, 0.110055, 1.388263>, 
      <0.319748, 0.323191, 1.343202>, <0.229631, 0.334918, 1.395146>, <0.073226, 0.343556, 1.402050>, <-0.031442, 0.342423, 1.401536>, 
      <0.312832, 0.452401, 1.256636>, <0.222715, 0.464128, 1.308580>, <0.073819, 0.472199, 1.314405>, <-0.030849, 0.471066, 1.313891>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.631792, -0.054865, 0.939833>, <0.542907, -0.057606, 1.048652>, <0.452926, -0.065836, 1.225364>, <0.335510, -0.064002, 1.302562>, 
      <0.637964, 0.074960, 0.959389>, <0.549080, 0.072219, 1.068208>, <0.454318, 0.088392, 1.246538>, <0.336902, 0.090226, 1.323736>, 
      <0.660776, 0.273451, 0.994136>, <0.559713, 0.294419, 1.094643>, <0.443778, 0.307052, 1.271710>, <0.319748, 0.323191, 1.343202>, 
      <0.649708, 0.382506, 0.921613>, <0.548645, 0.403475, 1.022120>, <0.436862, 0.436261, 1.185144>, <0.312832, 0.452401, 1.256636>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.631792, -0.054865, 0.939833>, <0.631792, -0.054865, 0.939833>, <0.631792, -0.054865, 0.939833>, <0.631792, -0.054865, 0.939833>, 
      <0.637964, 0.074960, 0.959389>, <0.637964, 0.074960, 0.959389>, <0.637964, 0.074960, 0.959389>, <0.637964, 0.074960, 0.959389>, 
      <0.660776, 0.273451, 0.994136>, <0.660776, 0.273451, 0.994136>, <0.660776, 0.273451, 0.994136>, <0.660776, 0.273451, 0.994136>, 
      <0.649708, 0.382506, 0.921613>, <0.649708, 0.382506, 0.921613>, <0.649708, 0.382506, 0.921613>, <0.649708, 0.382506, 0.921613>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.754214, -0.092627, 0.320817>, <0.756603, -0.064485, 0.508342>, <0.668519, -0.066194, 0.754128>, <0.631792, -0.054865, 0.939833>, 
      <0.768228, 0.010403, 0.318920>, <0.770617, 0.038546, 0.506445>, <0.674691, 0.063632, 0.773685>, <0.637964, 0.074960, 0.959389>, 
      <0.767387, 0.168619, 0.365725>, <0.771258, 0.227998, 0.546925>, <0.691850, 0.234833, 0.809969>, <0.660776, 0.273451, 0.994136>, 
      <0.753288, 0.253779, 0.307723>, <0.757159, 0.313159, 0.488923>, <0.680782, 0.343888, 0.737446>, <0.649708, 0.382506, 0.921613>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.617333, -0.225162, -0.194937>, <0.661176, -0.191361, -0.039558>, <0.752136, -0.117105, 0.157710>, <0.754214, -0.092627, 0.320817>, 
      <0.620487, -0.151573, -0.180899>, <0.664329, -0.117772, -0.025520>, <0.766149, -0.014074, 0.155813>, <0.768228, 0.010403, 0.318920>, 
      <0.634089, -0.043269, -0.140501>, <0.674553, 0.027351, 0.002399>, <0.764049, 0.117417, 0.209481>, <0.767387, 0.168619, 0.365725>, 
      <0.626316, 0.023684, -0.173352>, <0.666780, 0.094305, -0.030453>, <0.749950, 0.202578, 0.151479>, <0.753288, 0.253779, 0.307723>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.485240, -0.299998, -0.632433>, <0.555960, -0.268899, -0.516968>, <0.580407, -0.253631, -0.325806>, <0.617333, -0.225162, -0.194937>, 
      <0.483736, -0.277947, -0.642040>, <0.554457, -0.246848, -0.526575>, <0.583560, -0.180042, -0.311767>, <0.620487, -0.151573, -0.180899>, 
      <0.482430, -0.236352, -0.645352>, <0.562531, -0.165459, -0.510325>, <0.591704, -0.117244, -0.290186>, <0.634089, -0.043269, -0.140501>, 
      <0.477174, -0.228118, -0.667383>, <0.557275, -0.157225, -0.532356>, <0.583931, -0.050290, -0.323037>, <0.626316, 0.023684, -0.173352>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.233671, -0.393875, -0.821340>, <0.318577, -0.376263, -0.774634>, <0.435103, -0.322045, -0.714292>, <0.485240, -0.299998, -0.632433>, 
      <0.236562, -0.379954, -0.836445>, <0.321468, -0.362343, -0.789738>, <0.433599, -0.299995, -0.723899>, <0.483736, -0.277947, -0.642040>, 
      <0.231487, -0.340406, -0.830647>, <0.316057, -0.315264, -0.788519>, <0.436968, -0.276588, -0.721988>, <0.482430, -0.236352, -0.645352>, 
      <0.226051, -0.330567, -0.848081>, <0.310621, -0.305425, -0.805953>, <0.431712, -0.268354, -0.744019>, <0.477174, -0.228118, -0.667383>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.047304, -0.410460, -0.925382>, <0.042717, -0.410984, -0.925139>, <0.156065, -0.409972, -0.864030>, <0.233671, -0.393875, -0.821340>, 
      <-0.048314, -0.407524, -0.932809>, <0.041708, -0.408048, -0.932566>, <0.158957, -0.396051, -0.879135>, <0.236562, -0.379954, -0.836445>, 
      <-0.058394, -0.390850, -0.926666>, <0.032020, -0.391398, -0.924170>, <0.153249, -0.363665, -0.869621>, <0.231487, -0.340406, -0.830647>, 
      <-0.057460, -0.387059, -0.933706>, <0.032953, -0.387607, -0.931209>, <0.147813, -0.353826, -0.887055>, <0.226051, -0.330567, -0.848081>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.047304, -0.410460, -0.925382>, <-0.048314, -0.407524, -0.932809>, <-0.058394, -0.390850, -0.926666>, <-0.057460, -0.387059, -0.933706>, 
      <-0.120066, -0.410037, -0.925578>, <-0.121076, -0.407101, -0.933006>, <-0.124533, -0.390449, -0.928492>, <-0.123600, -0.386658, -0.935532>, 
      <-0.205235, -0.405976, -0.859516>, <-0.208683, -0.394329, -0.878377>, <-0.206995, -0.357624, -0.874560>, <-0.202207, -0.346168, -0.893244>, 
      <-0.266171, -0.390967, -0.822690>, <-0.269619, -0.379321, -0.841551>, <-0.261968, -0.339094, -0.842740>, <-0.257180, -0.327638, -0.861424>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.523397, -0.372642, -0.589067>, <-0.459946, -0.379453, -0.664853>, <-0.322589, -0.387557, -0.702650>, <-0.237262, -0.394924, -0.752459>, 
      <-0.528368, -0.348021, -0.601711>, <-0.464917, -0.354832, -0.677497>, <-0.327287, -0.375545, -0.721469>, <-0.241960, -0.382912, -0.771279>, 
      <-0.521111, -0.318416, -0.626041>, <-0.470209, -0.340483, -0.706730>, <-0.344669, -0.382614, -0.753950>, <-0.262665, -0.402812, -0.803508>, 
      <-0.519012, -0.294275, -0.640310>, <-0.468110, -0.316342, -0.720999>, <-0.348175, -0.370769, -0.773132>, <-0.266171, -0.390967, -0.822690>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.523397, -0.372642, -0.589067>, <-0.514261, -0.417892, -0.565828>, <-0.491061, -0.484327, -0.551225>, <-0.472766, -0.523332, -0.522676>, 
      <-0.459946, -0.379453, -0.664853>, <-0.450810, -0.424703, -0.641614>, <-0.430431, -0.484428, -0.611859>, <-0.412137, -0.523433, -0.583310>, 
      <-0.322589, -0.387557, -0.702650>, <-0.314487, -0.408272, -0.670192>, <-0.307596, -0.486835, -0.658025>, <-0.300675, -0.502555, -0.622624>, 
      <-0.237262, -0.394924, -0.752459>, <-0.229160, -0.415640, -0.720002>, <-0.233651, -0.476094, -0.700086>, <-0.226730, -0.491813, -0.664685>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.664488, -0.349066, -0.242182>, <-0.637247, -0.361357, -0.350709>, <-0.595488, -0.364904, -0.502961>, <-0.523397, -0.372642, -0.589067>, 
      <-0.669385, -0.308249, -0.231884>, <-0.642143, -0.320540, -0.340411>, <-0.600459, -0.340283, -0.515606>, <-0.528368, -0.348021, -0.601711>, 
      <-0.667386, -0.259772, -0.195877>, <-0.632396, -0.287181, -0.332794>, <-0.595939, -0.285975, -0.507424>, <-0.521111, -0.318416, -0.626041>, 
      <-0.665430, -0.217877, -0.189790>, <-0.630440, -0.245286, -0.326707>, <-0.593841, -0.261835, -0.521692>, <-0.519012, -0.294275, -0.640310>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.664488, -0.349066, -0.242182>, <-0.659409, -0.391404, -0.252864>, <-0.658847, -0.457518, -0.247961>, <-0.632650, -0.491135, -0.258732>, 
      <-0.637247, -0.361357, -0.350709>, <-0.632168, -0.403695, -0.361391>, <-0.629555, -0.473735, -0.334811>, <-0.603358, -0.507352, -0.345582>, 
      <-0.595488, -0.364904, -0.502961>, <-0.586353, -0.410154, -0.479723>, <-0.556875, -0.484217, -0.485404>, <-0.538581, -0.523222, -0.456856>, 
      <-0.523397, -0.372642, -0.589067>, <-0.514261, -0.417892, -0.565828>, <-0.491061, -0.484327, -0.551225>, <-0.472766, -0.523332, -0.522676>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.746711, -0.271886, 0.300587>, <-0.750584, -0.269040, 0.134348>, <-0.704735, -0.330907, -0.081842>, <-0.664488, -0.349066, -0.242182>, 
      <-0.756264, -0.227257, 0.325767>, <-0.760137, -0.224410, 0.159528>, <-0.709632, -0.290090, -0.071544>, <-0.669385, -0.308249, -0.231884>, 
      <-0.762196, -0.152939, 0.323570>, <-0.758852, -0.175803, 0.163933>, <-0.706593, -0.229060, -0.042458>, <-0.667386, -0.259772, -0.195877>, 
      <-0.765789, -0.100967, 0.325329>, <-0.762445, -0.123831, 0.165692>, <-0.704638, -0.187165, -0.036371>, <-0.665430, -0.217877, -0.189790>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.746711, -0.271886, 0.300587>, <-0.736070, -0.321600, 0.272539>, <-0.729092, -0.369671, 0.203259>, <-0.702622, -0.396074, 0.158833>, 
      <-0.750584, -0.269040, 0.134348>, <-0.739943, -0.318754, 0.106300>, <-0.742046, -0.342966, 0.076509>, <-0.715576, -0.369369, 0.032083>, 
      <-0.704735, -0.330907, -0.081842>, <-0.699656, -0.373245, -0.092524>, <-0.699814, -0.434837, -0.126496>, <-0.673617, -0.468454, -0.137267>, 
      <-0.664488, -0.349066, -0.242182>, <-0.659409, -0.391404, -0.252864>, <-0.658847, -0.457518, -0.247961>, <-0.632650, -0.491135, -0.258732>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.639800, -0.367209, 0.817509>, <-0.671873, -0.338612, 0.662432>, <-0.742964, -0.274640, 0.461440>, <-0.746711, -0.271886, 0.300587>, 
      <-0.659371, -0.282633, 0.868614>, <-0.691444, -0.254036, 0.713538>, <-0.752516, -0.230011, 0.486619>, <-0.756264, -0.227257, 0.325767>, 
      <-0.681480, -0.156098, 0.920921>, <-0.704516, -0.169376, 0.737870>, <-0.766031, -0.126719, 0.506634>, <-0.762196, -0.152939, 0.323570>, 
      <-0.689002, -0.056705, 0.935498>, <-0.712038, -0.069984, 0.752447>, <-0.769624, -0.074747, 0.508393>, <-0.765789, -0.100967, 0.325329>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.639800, -0.367209, 0.817509>, <-0.616516, -0.467833, 0.756707>, <-0.548183, -0.785121, 0.567772>, <-0.548183, -0.665270, 0.567772>, 
      <-0.671873, -0.338612, 0.662432>, <-0.648589, -0.439236, 0.601630>, <-0.594515, -0.704362, 0.445090>, <-0.594515, -0.584511, 0.445090>, 
      <-0.742964, -0.274640, 0.461440>, <-0.732322, -0.324354, 0.433391>, <-0.713767, -0.401264, 0.353213>, <-0.687297, -0.427668, 0.308788>, 
      <-0.746711, -0.271886, 0.300587>, <-0.736070, -0.321600, 0.272539>, <-0.729092, -0.369671, 0.203259>, <-0.702622, -0.396074, 0.158833>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.639800, -0.367209, 0.817509>, <-0.548183, -0.785121, 0.567772>, <-0.616516, -0.467833, 0.756707>, <-0.639800, -0.367209, 0.817509>, 
      <-0.639800, -0.367209, 0.817509>, <-0.548183, -0.785121, 0.567772>, <-0.593232, -0.568457, 0.695905>, <-0.616516, -0.467833, 0.756707>, 
      <-0.639800, -0.367209, 0.817509>, <-0.548183, -0.785121, 0.567772>, <-0.548183, -0.785121, 0.567772>, <-0.548183, -0.785121, 0.567772>, 
      <-0.639800, -0.367209, 0.817509>, <-0.639800, -0.367209, 0.817509>, <-0.639800, -0.367209, 0.817509>, <-0.639800, -0.367209, 0.817509>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.639800, -0.367209, 0.817509>, <-0.639800, -0.367209, 0.817509>, <-0.639800, -0.367209, 0.817509>, <-0.639800, -0.367209, 0.817509>, 
      <-0.659371, -0.282633, 0.868614>, <-0.659371, -0.282633, 0.868614>, <-0.659371, -0.282633, 0.868614>, <-0.659371, -0.282633, 0.868614>, 
      <-0.681480, -0.156098, 0.920921>, <-0.681480, -0.156098, 0.920921>, <-0.681480, -0.156098, 0.920921>, <-0.681480, -0.156098, 0.920921>, 
      <-0.689002, -0.056705, 0.935498>, <-0.689002, -0.056705, 0.935498>, <-0.689002, -0.056705, 0.935498>, <-0.689002, -0.056705, 0.935498>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.355191, -0.508594, 1.122124>, <-0.464809, -0.480461, 1.054058>, <-0.554417, -0.409625, 0.908894>, <-0.639800, -0.367209, 0.817509>, 
      <-0.361281, -0.384279, 1.200595>, <-0.470898, -0.356146, 1.132529>, <-0.573988, -0.325048, 0.959999>, <-0.659371, -0.282633, 0.868614>, 
      <-0.358649, -0.189807, 1.259573>, <-0.479247, -0.191997, 1.180643>, <-0.580953, -0.152323, 1.024161>, <-0.681480, -0.156098, 0.920921>, 
      <-0.353913, -0.044122, 1.279634>, <-0.474511, -0.046312, 1.200704>, <-0.588475, -0.052930, 1.038739>, <-0.689002, -0.056705, 0.935498>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.355191, -0.508594, 1.122124>, <-0.349994, -0.614682, 1.055159>, <-0.330717, -0.715300, 0.913962>, <-0.317561, -0.786235, 0.811194>, 
      <-0.464809, -0.480461, 1.054058>, <-0.459612, -0.586549, 0.987093>, <-0.420492, -0.690054, 0.861620>, <-0.407336, -0.760989, 0.758853>, 
      <-0.554417, -0.409625, 0.908894>, <-0.531133, -0.510248, 0.848091>, <-0.478996, -0.821410, 0.640799>, <-0.478996, -0.701560, 0.640799>, 
      <-0.639800, -0.367209, 0.817509>, <-0.616516, -0.467833, 0.756707>, <-0.548183, -0.785121, 0.567772>, <-0.548183, -0.665270, 0.567772>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.020995, -0.526021, 1.201748>, <-0.124192, -0.525799, 1.201375>, <-0.269532, -0.530578, 1.175313>, <-0.355191, -0.508594, 1.122124>, 
      <-0.021570, -0.397332, 1.284636>, <-0.124767, -0.397110, 1.284263>, <-0.275622, -0.406262, 1.253784>, <-0.361281, -0.384279, 1.200595>, 
      <-0.022294, -0.196732, 1.353758>, <-0.124942, -0.193772, 1.350345>, <-0.272688, -0.188246, 1.315833>, <-0.358649, -0.189807, 1.259573>, 
      <-0.023797, -0.044625, 1.370866>, <-0.126445, -0.041665, 1.367452>, <-0.267952, -0.042561, 1.335895>, <-0.353913, -0.044122, 1.279634>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.020995, -0.526021, 1.201748>, <-0.020505, -0.635723, 1.131089>, <-0.019249, -0.745288, 0.986619>, <-0.020359, -0.813702, 0.875507>, 
      <-0.124192, -0.525799, 1.201375>, <-0.123701, -0.635501, 1.130717>, <-0.110778, -0.747609, 0.989239>, <-0.111888, -0.816023, 0.878127>, 
      <-0.269532, -0.530578, 1.175313>, <-0.264336, -0.636666, 1.108347>, <-0.253824, -0.736923, 0.958792>, <-0.240669, -0.807858, 0.856024>, 
      <-0.355191, -0.508594, 1.122124>, <-0.349994, -0.614682, 1.055159>, <-0.330717, -0.715300, 0.913962>, <-0.317561, -0.786235, 0.811194>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.304149, -0.510014, 1.124505>, <0.220805, -0.532212, 1.175844>, <0.079377, -0.526237, 1.202111>, <-0.020995, -0.526021, 1.201748>, 
      <0.310581, -0.392974, 1.208800>, <0.227236, -0.415172, 1.260139>, <0.078802, -0.397548, 1.284998>, <-0.021570, -0.397332, 1.284636>, 
      <0.334220, -0.207034, 1.282925>, <0.242417, -0.205600, 1.343283>, <0.087476, -0.199898, 1.357409>, <-0.022294, -0.196732, 1.353758>, 
      <0.335510, -0.064002, 1.302562>, <0.243707, -0.062568, 1.362920>, <0.085973, -0.047790, 1.374516>, <-0.023797, -0.044625, 1.370866>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.304149, -0.510014, 1.124505>, <0.298519, -0.612468, 1.050716>, <0.304053, -0.703986, 0.900727>, <0.296678, -0.770660, 0.793612>, 
      <0.220805, -0.532212, 1.175844>, <0.215175, -0.634666, 1.102055>, <0.221097, -0.727495, 0.949533>, <0.213722, -0.794170, 0.842419>, 
      <0.079377, -0.526237, 1.202111>, <0.079867, -0.635939, 1.131452>, <0.079757, -0.742778, 0.983785>, <0.078647, -0.811192, 0.872673>, 
      <-0.020995, -0.526021, 1.201748>, <-0.020505, -0.635723, 1.131089>, <-0.019249, -0.745288, 0.986619>, <-0.020359, -0.813702, 0.875507>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.614562, -0.356749, 0.810254>, <0.521438, -0.402728, 0.904529>, <0.420617, -0.478994, 1.052762>, <0.304149, -0.510014, 1.124505>, 
      <0.631971, -0.273836, 0.860874>, <0.538847, -0.319816, 0.955149>, <0.427049, -0.361954, 1.137057>, <0.310581, -0.392974, 1.208800>, 
      <0.627158, -0.152348, 0.925149>, <0.538273, -0.155089, 1.033967>, <0.451636, -0.208868, 1.205727>, <0.334220, -0.207034, 1.282925>, 
      <0.631792, -0.054865, 0.939833>, <0.542907, -0.057606, 1.048652>, <0.452926, -0.065836, 1.225364>, <0.335510, -0.064002, 1.302562>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.614562, -0.356749, 0.810254>, <0.592968, -0.459595, 0.747464>, <0.503644, -0.787616, 0.567212>, <0.503644, -0.665198, 0.567212>, 
      <0.521438, -0.402728, 0.904529>, <0.499844, -0.505575, 0.841740>, <0.441554, -0.819255, 0.635132>, <0.441554, -0.696837, 0.635132>, 
      <0.420617, -0.478994, 1.052762>, <0.414987, -0.581448, 0.978973>, <0.385529, -0.680895, 0.852791>, <0.378154, -0.747570, 0.745676>, 
      <0.304149, -0.510014, 1.124505>, <0.298519, -0.612468, 1.050716>, <0.304053, -0.703986, 0.900727>, <0.296678, -0.770660, 0.793612>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.614562, -0.356749, 0.810254>, <0.503644, -0.787616, 0.567212>, <0.592968, -0.459595, 0.747464>, <0.614562, -0.356749, 0.810254>, 
      <0.614562, -0.356749, 0.810254>, <0.503644, -0.787616, 0.567212>, <0.571374, -0.562441, 0.684675>, <0.592968, -0.459595, 0.747464>, 
      <0.614562, -0.356749, 0.810254>, <0.503644, -0.787616, 0.567212>, <0.503644, -0.787616, 0.567212>, <0.503644, -0.787616, 0.567212>, 
      <0.614562, -0.356749, 0.810254>, <0.614562, -0.356749, 0.810254>, <0.614562, -0.356749, 0.810254>, <0.614562, -0.356749, 0.810254>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.614562, -0.356749, 0.810254>, <0.614562, -0.356749, 0.810254>, <0.614562, -0.356749, 0.810254>, <0.614562, -0.356749, 0.810254>, 
      <0.631971, -0.273836, 0.860874>, <0.631971, -0.273836, 0.860874>, <0.631971, -0.273836, 0.860874>, <0.631971, -0.273836, 0.860874>, 
      <0.627158, -0.152348, 0.925149>, <0.627158, -0.152348, 0.925149>, <0.627158, -0.152348, 0.925149>, <0.627158, -0.152348, 0.925149>, 
      <0.631792, -0.054865, 0.939833>, <0.631792, -0.054865, 0.939833>, <0.631792, -0.054865, 0.939833>, <0.631792, -0.054865, 0.939833>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.683385, -0.260156, 0.317186>, <0.683992, -0.261300, 0.469320>, <0.635209, -0.327771, 0.662334>, <0.614562, -0.356749, 0.810254>, 
      <0.697626, -0.212779, 0.340235>, <0.698233, -0.213922, 0.492369>, <0.652618, -0.244859, 0.712954>, <0.631971, -0.273836, 0.860874>, 
      <0.746860, -0.146697, 0.321813>, <0.749249, -0.118555, 0.509338>, <0.663884, -0.163676, 0.739444>, <0.627158, -0.152348, 0.925149>, 
      <0.754214, -0.092627, 0.320817>, <0.756603, -0.064485, 0.508342>, <0.668519, -0.066194, 0.754128>, <0.631792, -0.054865, 0.939833>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.683385, -0.260156, 0.317186>, <0.667528, -0.312910, 0.291521>, <0.675707, -0.367569, 0.221536>, <0.662015, -0.399365, 0.171590>, 
      <0.683992, -0.261300, 0.469320>, <0.668136, -0.314053, 0.443656>, <0.659453, -0.400675, 0.367630>, <0.645761, -0.432471, 0.317685>, 
      <0.635209, -0.327771, 0.662334>, <0.613615, -0.430617, 0.599544>, <0.551155, -0.707866, 0.448525>, <0.551155, -0.585448, 0.448525>, 
      <0.614562, -0.356749, 0.810254>, <0.592968, -0.459595, 0.747464>, <0.503644, -0.787616, 0.567212>, <0.503644, -0.665198, 0.567212>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.610352, -0.348821, -0.244412>, <0.645933, -0.328084, -0.077449>, <0.682699, -0.258863, 0.145225>, <0.683385, -0.260156, 0.317186>, 
      <0.613608, -0.310329, -0.233987>, <0.649189, -0.289591, -0.067024>, <0.696939, -0.211486, 0.168273>, <0.697626, -0.212779, 0.340235>, 
      <0.615650, -0.264430, -0.202428>, <0.659493, -0.230629, -0.047049>, <0.744781, -0.171175, 0.158706>, <0.746860, -0.146697, 0.321813>, 
      <0.617333, -0.225162, -0.194937>, <0.661176, -0.191361, -0.039558>, <0.752136, -0.117105, 0.157710>, <0.754214, -0.092627, 0.320817>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.610352, -0.348821, -0.244412>, <0.607170, -0.386444, -0.254602>, <0.614511, -0.443529, -0.255053>, <0.596030, -0.477030, -0.263151>, 
      <0.645933, -0.328084, -0.077449>, <0.642751, -0.365707, -0.087638>, <0.652663, -0.423296, -0.128247>, <0.634182, -0.456797, -0.136345>, 
      <0.682699, -0.258863, 0.145225>, <0.666842, -0.311617, 0.119560>, <0.690158, -0.338136, 0.091653>, <0.676466, -0.369932, 0.041707>, 
      <0.683385, -0.260156, 0.317186>, <0.667528, -0.312910, 0.291521>, <0.675707, -0.367569, 0.221536>, <0.662015, -0.399365, 0.171590>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.487157, -0.374521, -0.603601>, <0.557460, -0.362655, -0.514418>, <0.586727, -0.362590, -0.355269>, <0.610352, -0.348821, -0.244412>, 
      <0.490328, -0.353515, -0.614722>, <0.560631, -0.341649, -0.525539>, <0.589983, -0.324098, -0.344844>, <0.613608, -0.310329, -0.233987>, 
      <0.486736, -0.321938, -0.622875>, <0.557457, -0.290839, -0.507410>, <0.578724, -0.292899, -0.333297>, <0.615650, -0.264430, -0.202428>, 
      <0.485240, -0.299998, -0.632433>, <0.555960, -0.268899, -0.516968>, <0.580407, -0.253631, -0.325806>, <0.617333, -0.225162, -0.194937>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.487157, -0.374521, -0.603601>, <0.480731, -0.417090, -0.581063>, <0.470704, -0.478928, -0.554558>, <0.453550, -0.509920, -0.521292>, 
      <0.557460, -0.362655, -0.514418>, <0.551033, -0.405224, -0.491880>, <0.534435, -0.473208, -0.492692>, <0.517281, -0.504200, -0.459426>, 
      <0.586727, -0.362590, -0.355269>, <0.583545, -0.400213, -0.365458>, <0.589163, -0.456972, -0.339306>, <0.570681, -0.490473, -0.347403>, 
      <0.610352, -0.348821, -0.244412>, <0.607170, -0.386444, -0.254602>, <0.614511, -0.443529, -0.255053>, <0.596030, -0.477030, -0.263151>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.208160, -0.416706, -0.754618>, <0.294166, -0.410419, -0.712408>, <0.428041, -0.384499, -0.678594>, <0.487157, -0.374521, -0.603601>, 
      <0.212144, -0.404014, -0.772761>, <0.298150, -0.397727, -0.730552>, <0.431212, -0.363493, -0.689715>, <0.490328, -0.353515, -0.614722>, 
      <0.230535, -0.408973, -0.804958>, <0.315441, -0.391362, -0.758252>, <0.436599, -0.343986, -0.704733>, <0.486736, -0.321938, -0.622875>, 
      <0.233671, -0.393875, -0.821340>, <0.318577, -0.376263, -0.774634>, <0.435103, -0.322045, -0.714292>, <0.485240, -0.299998, -0.632433>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.208160, -0.416706, -0.754618>, <0.200629, -0.440697, -0.720322>, <0.202676, -0.498892, -0.690824>, <0.196305, -0.512907, -0.651182>, 
      <0.294166, -0.410419, -0.712408>, <0.286635, -0.434410, -0.678113>, <0.280572, -0.506176, -0.654026>, <0.274201, -0.520191, -0.614384>, 
      <0.428041, -0.384499, -0.678594>, <0.421614, -0.427068, -0.656056>, <0.408797, -0.484485, -0.614654>, <0.391643, -0.515477, -0.581388>, 
      <0.487157, -0.374521, -0.603601>, <0.480731, -0.417090, -0.581063>, <0.470704, -0.478928, -0.554558>, <0.453550, -0.509920, -0.521292>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.048311, -0.413662, -0.866396>, <0.035524, -0.417762, -0.866802>, <0.132971, -0.422202, -0.791519>, <0.208160, -0.416706, -0.754618>, 
      <-0.047641, -0.408319, -0.883283>, <0.036194, -0.412419, -0.883689>, <0.136955, -0.409510, -0.809662>, <0.212144, -0.404014, -0.772761>, 
      <-0.045081, -0.416923, -0.909029>, <0.044940, -0.417447, -0.908785>, <0.152930, -0.425070, -0.847649>, <0.230535, -0.408973, -0.804958>, 
      <-0.047304, -0.410460, -0.925382>, <0.042717, -0.410984, -0.925139>, <0.156065, -0.409972, -0.864030>, <0.233671, -0.393875, -0.821340>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.048311, -0.413662, -0.866396>, <-0.049630, -0.424179, -0.833154>, <-0.054129, -0.460598, -0.795815>, <-0.053827, -0.462474, -0.760976>, 
      <0.035524, -0.417762, -0.866802>, <0.034205, -0.428279, -0.833560>, <0.029060, -0.464746, -0.793160>, <0.029363, -0.466622, -0.758321>, 
      <0.132971, -0.422202, -0.791519>, <0.125440, -0.446193, -0.757224>, <0.127593, -0.491870, -0.726293>, <0.121222, -0.505886, -0.686651>, 
      <0.208160, -0.416706, -0.754618>, <0.200629, -0.440697, -0.720322>, <0.202676, -0.498892, -0.690824>, <0.196305, -0.512907, -0.651182>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.048311, -0.413662, -0.866396>, <-0.047641, -0.408319, -0.883283>, <-0.045081, -0.416923, -0.909029>, <-0.047304, -0.410460, -0.925382>, 
      <-0.114663, -0.410417, -0.866074>, <-0.113993, -0.405075, -0.882961>, <-0.117843, -0.416500, -0.909225>, <-0.120066, -0.410037, -0.925578>, 
      <-0.180049, -0.399864, -0.785857>, <-0.184747, -0.387852, -0.804677>, <-0.201729, -0.417821, -0.840334>, <-0.205235, -0.405976, -0.859516>, 
      <-0.237262, -0.394924, -0.752459>, <-0.241960, -0.382912, -0.771279>, <-0.262665, -0.402812, -0.803508>, <-0.266171, -0.390967, -0.822690>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.048311, -0.413662, -0.866396>, <-0.114663, -0.410417, -0.866074>, <-0.180049, -0.399864, -0.785857>, <-0.237262, -0.394924, -0.752459>, 
      <-0.049630, -0.424179, -0.833154>, <-0.115982, -0.420934, -0.832832>, <-0.171947, -0.420580, -0.753400>, <-0.229160, -0.415640, -0.720002>, 
      <-0.054129, -0.460598, -0.795815>, <-0.114045, -0.457610, -0.797728>, <-0.181891, -0.468575, -0.729529>, <-0.233651, -0.476094, -0.700086>, 
      <-0.053827, -0.462474, -0.760976>, <-0.113743, -0.459486, -0.762888>, <-0.174970, -0.484294, -0.694127>, <-0.226730, -0.491813, -0.664685>
    }
  }
  material {
    Wrinkled_Fabric
  }
}
#declare sPatchObj3 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.121909, -0.846735, -0.302626>, <0.121300, -0.843626, -0.305634>, <0.122496, -0.838816, -0.309018>, <0.122748, -0.835422, -0.311757>, 
      <0.145521, -0.834855, -0.301024>, <0.144911, -0.831746, -0.304032>, <0.145479, -0.828085, -0.305771>, <0.145731, -0.824691, -0.308510>, 
      <0.175135, -0.816481, -0.294252>, <0.174868, -0.815698, -0.295012>, <0.175316, -0.811561, -0.297911>, <0.175372, -0.810609, -0.298505>, 
      <0.197904, -0.803296, -0.291254>, <0.197636, -0.802514, -0.292014>, <0.198036, -0.801076, -0.292639>, <0.198092, -0.800125, -0.293232>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.071137, -0.875800, -0.336542>, <0.066503, -0.874372, -0.328719>, <0.057593, -0.870645, -0.320694>, <0.051789, -0.868435, -0.313902>, 
      <0.051158, -0.883471, -0.339592>, <0.046524, -0.882044, -0.331769>, <0.042841, -0.875404, -0.321118>, <0.037036, -0.873195, -0.314327>, 
      <0.022134, -0.889180, -0.341776>, <0.022134, -0.886434, -0.333174>, <0.016024, -0.879175, -0.323226>, <0.016024, -0.874893, -0.315276>, 
      <0.000517, -0.889133, -0.341772>, <0.000517, -0.886387, -0.333170>, <0.000517, -0.879141, -0.323223>, <0.000517, -0.874859, -0.315274>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.075112, -0.875482, -0.336518>, <-0.069638, -0.874031, -0.328450>, <-0.059234, -0.870390, -0.320677>, <-0.052429, -0.868208, -0.313888>, 
      <-0.053499, -0.883093, -0.339514>, <-0.048024, -0.881642, -0.331447>, <-0.043892, -0.874963, -0.321085>, <-0.037087, -0.872781, -0.314296>, 
      <-0.022592, -0.889083, -0.341768>, <-0.022592, -0.886337, -0.333167>, <-0.015497, -0.879106, -0.323221>, <-0.015497, -0.874824, -0.315272>, 
      <0.000517, -0.889133, -0.341772>, <0.000517, -0.886387, -0.333170>, <0.000517, -0.879141, -0.323223>, <0.000517, -0.874859, -0.315274>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.214808, -0.792941, -0.290392>, <0.210004, -0.795580, -0.291086>, <0.203000, -0.797860, -0.292093>, <0.198092, -0.800125, -0.293232>, 
      <0.214808, -0.792941, -0.290392>, <0.204933, -0.798686, -0.291344>, <0.202944, -0.798811, -0.291500>, <0.198036, -0.801076, -0.292639>, 
      <0.214808, -0.792941, -0.290392>, <0.204933, -0.798686, -0.291344>, <0.202755, -0.799550, -0.291340>, <0.197636, -0.802514, -0.292014>, 
      <0.214808, -0.792941, -0.290392>, <0.209737, -0.796048, -0.290651>, <0.203022, -0.800332, -0.290580>, <0.197904, -0.803296, -0.291254>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.214808, -0.792941, -0.290392>, <0.209737, -0.796048, -0.290651>, <0.203022, -0.800332, -0.290580>, <0.197904, -0.803296, -0.291254>, 
      <0.211425, -0.794133, -0.291478>, <0.206353, -0.797240, -0.291737>, <0.202755, -0.799550, -0.291340>, <0.197636, -0.802514, -0.292014>, 
      <0.206651, -0.795201, -0.292843>, <0.204907, -0.795364, -0.292086>, <0.199667, -0.800113, -0.292873>, <0.198036, -0.801076, -0.292639>, 
      <0.203530, -0.796915, -0.294012>, <0.201786, -0.797079, -0.293255>, <0.199723, -0.799162, -0.293466>, <0.198092, -0.800125, -0.293232>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.214808, -0.792941, -0.290392>, <0.210004, -0.795580, -0.291086>, <0.203000, -0.797860, -0.292093>, <0.198092, -0.800125, -0.293232>, 
      <0.214808, -0.792941, -0.290392>, <0.206621, -0.796772, -0.292171>, <0.204632, -0.796897, -0.292327>, <0.199723, -0.799162, -0.293466>, 
      <0.214808, -0.792941, -0.290392>, <0.206621, -0.796772, -0.292171>, <0.204907, -0.795364, -0.292086>, <0.201786, -0.797079, -0.293255>, 
      <0.214808, -0.792941, -0.290392>, <0.211425, -0.794133, -0.291478>, <0.206651, -0.795201, -0.292843>, <0.203530, -0.796915, -0.294012>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.219334, -0.792694, -0.290438>, <-0.215577, -0.793861, -0.291463>, <-0.210096, -0.794609, -0.292501>, <-0.206811, -0.796585, -0.293855>, 
      <-0.219334, -0.792694, -0.290438>, <-0.209346, -0.796952, -0.292246>, <-0.207244, -0.794868, -0.291489>, <-0.203959, -0.796844, -0.292843>, 
      <-0.219334, -0.792694, -0.290438>, <-0.209346, -0.796952, -0.292246>, <-0.206390, -0.796190, -0.291778>, <-0.200246, -0.799189, -0.293274>, 
      <-0.219334, -0.792694, -0.290438>, <-0.213104, -0.795785, -0.291221>, <-0.203577, -0.797306, -0.291529>, <-0.197432, -0.800305, -0.293025>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.081719, -0.877656, -0.364428>, <0.080851, -0.880694, -0.356038>, <0.075651, -0.877191, -0.344162>, <0.071137, -0.875800, -0.336542>, 
      <0.058607, -0.885928, -0.368684>, <0.057738, -0.888966, -0.360294>, <0.055672, -0.884862, -0.347212>, <0.051158, -0.883471, -0.339592>, 
      <0.025431, -0.893166, -0.372453>, <0.025431, -0.895989, -0.363613>, <0.022134, -0.892002, -0.350616>, <0.022134, -0.889180, -0.341776>, 
      <0.000517, -0.893112, -0.372447>, <0.000517, -0.895936, -0.363607>, <0.000517, -0.891955, -0.350612>, <0.000517, -0.889133, -0.341772>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.086699, -0.877291, -0.364390>, <-0.061585, -0.885355, -0.368539>, <-0.026184, -0.893054, -0.372441>, <0.000517, -0.893112, -0.372447>, 
      <-0.085189, -0.880316, -0.355972>, <-0.060075, -0.888380, -0.360121>, <-0.026184, -0.895878, -0.363601>, <0.000517, -0.895936, -0.363607>, 
      <-0.080150, -0.876817, -0.343943>, <-0.058537, -0.884428, -0.346939>, <-0.022592, -0.891905, -0.350608>, <0.000517, -0.891955, -0.350612>, 
      <-0.075112, -0.875482, -0.336518>, <-0.053499, -0.883093, -0.339514>, <-0.022592, -0.889083, -0.341768>, <0.000517, -0.889133, -0.341772>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.126552, -0.854822, -0.292982>, <0.125745, -0.853716, -0.296766>, <0.122471, -0.849599, -0.299855>, <0.121909, -0.846735, -0.302626>, 
      <0.149948, -0.842298, -0.293687>, <0.149141, -0.841192, -0.297471>, <0.146083, -0.837718, -0.298253>, <0.145521, -0.834855, -0.301024>, 
      <0.178279, -0.820989, -0.288634>, <0.177870, -0.820385, -0.289887>, <0.175481, -0.817490, -0.293271>, <0.175135, -0.816481, -0.294252>, 
      <0.200035, -0.805804, -0.287715>, <0.199625, -0.805201, -0.288968>, <0.198250, -0.804306, -0.290273>, <0.197904, -0.803296, -0.291254>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.230142, -0.782521, -0.288605>, <0.221110, -0.789506, -0.288338>, <0.209395, -0.799271, -0.287320>, <0.200035, -0.805804, -0.287715>, 
      <0.225004, -0.784686, -0.288969>, <0.215972, -0.791671, -0.288702>, <0.208985, -0.798668, -0.288573>, <0.199625, -0.805201, -0.288968>, 
      <0.219667, -0.790272, -0.289691>, <0.214595, -0.793379, -0.289949>, <0.203368, -0.801342, -0.289599>, <0.198250, -0.804306, -0.290273>, 
      <0.214808, -0.792941, -0.290392>, <0.209737, -0.796048, -0.290651>, <0.203022, -0.800332, -0.290580>, <0.197904, -0.803296, -0.291254>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.230142, -0.782521, -0.288605>, <0.225004, -0.784686, -0.288969>, <0.219667, -0.790272, -0.289691>, <0.214808, -0.792941, -0.290392>, 
      <0.224679, -0.787412, -0.291795>, <0.219540, -0.789577, -0.292159>, <0.216283, -0.791465, -0.290777>, <0.211425, -0.794133, -0.291478>, 
      <0.217670, -0.794836, -0.295352>, <0.217081, -0.795218, -0.292412>, <0.209414, -0.794941, -0.294042>, <0.206651, -0.795201, -0.292843>, 
      <0.211931, -0.798825, -0.299239>, <0.211342, -0.799206, -0.296299>, <0.206293, -0.796655, -0.295211>, <0.203530, -0.796915, -0.294012>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.233445, -0.782438, -0.288498>, <-0.228661, -0.784616, -0.288816>, <-0.224021, -0.790369, -0.289849>, <-0.219334, -0.792694, -0.290438>, 
      <-0.227970, -0.787314, -0.291747>, <-0.223186, -0.789492, -0.292066>, <-0.220264, -0.791536, -0.290874>, <-0.215577, -0.793861, -0.291463>, 
      <-0.220487, -0.794377, -0.295123>, <-0.219565, -0.794734, -0.292216>, <-0.212978, -0.794347, -0.293524>, <-0.210096, -0.794609, -0.292501>, 
      <-0.215195, -0.798692, -0.299329>, <-0.214273, -0.799049, -0.296423>, <-0.209693, -0.796323, -0.294878>, <-0.206811, -0.796585, -0.293855>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.130664, -0.839161, -0.321905>, <0.128420, -0.838611, -0.318614>, <0.125123, -0.836544, -0.314801>, <0.122748, -0.835422, -0.311757>, 
      <0.152706, -0.826027, -0.314824>, <0.150463, -0.825478, -0.311533>, <0.148106, -0.825813, -0.311554>, <0.145731, -0.824691, -0.308510>, 
      <0.181364, -0.809091, -0.302314>, <0.179619, -0.809255, -0.301556>, <0.177003, -0.809646, -0.298739>, <0.175372, -0.810609, -0.298505>, 
      <0.203530, -0.796915, -0.294012>, <0.201786, -0.797079, -0.293255>, <0.199723, -0.799162, -0.293466>, <0.198092, -0.800125, -0.293232>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.130664, -0.839161, -0.321905>, <0.135400, -0.840321, -0.328851>, <0.144615, -0.843212, -0.337559>, <0.145876, -0.841087, -0.345678>, 
      <0.152706, -0.826027, -0.314824>, <0.157442, -0.827187, -0.321770>, <0.166115, -0.830196, -0.326795>, <0.167376, -0.828071, -0.334914>, 
      <0.181364, -0.809091, -0.302314>, <0.184127, -0.808831, -0.303513>, <0.191721, -0.812843, -0.309588>, <0.192310, -0.812462, -0.312528>, 
      <0.203530, -0.796915, -0.294012>, <0.206293, -0.796655, -0.295211>, <0.211342, -0.799206, -0.296299>, <0.211931, -0.798825, -0.299239>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.130664, -0.839161, -0.321905>, <0.135400, -0.840321, -0.328851>, <0.144615, -0.843212, -0.337559>, <0.145876, -0.841087, -0.345678>, 
      <0.112922, -0.849732, -0.327604>, <0.117658, -0.850892, -0.334551>, <0.126640, -0.854094, -0.346558>, <0.127902, -0.851969, -0.354677>, 
      <0.090938, -0.868197, -0.333519>, <0.095452, -0.869588, -0.341139>, <0.102055, -0.873105, -0.352133>, <0.102923, -0.870067, -0.360523>, 
      <0.071137, -0.875800, -0.336542>, <0.075651, -0.877191, -0.344162>, <0.080851, -0.880694, -0.356038>, <0.081719, -0.877656, -0.364428>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.130664, -0.839161, -0.321905>, <0.112922, -0.849732, -0.327604>, <0.090938, -0.868197, -0.333519>, <0.071137, -0.875800, -0.336542>, 
      <0.128420, -0.838611, -0.318614>, <0.110678, -0.849183, -0.324314>, <0.086304, -0.866770, -0.325697>, <0.066503, -0.874372, -0.328719>, 
      <0.125123, -0.836544, -0.314801>, <0.104013, -0.846400, -0.317784>, <0.079938, -0.863435, -0.320051>, <0.057593, -0.870645, -0.320694>, 
      <0.122748, -0.835422, -0.311757>, <0.101638, -0.845278, -0.314739>, <0.074134, -0.861226, -0.313259>, <0.051789, -0.868435, -0.313902>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.143077, -0.838566, -0.321865>, <-0.140040, -0.837987, -0.318400>, <-0.135171, -0.836365, -0.314789>, <-0.131782, -0.835422, -0.311757>, 
      <-0.123558, -0.850259, -0.328188>, <-0.120521, -0.849681, -0.324723>, <-0.112032, -0.847201, -0.318119>, <-0.108644, -0.846257, -0.315086>, 
      <-0.097199, -0.867704, -0.333456>, <-0.091725, -0.866253, -0.325389>, <-0.083918, -0.863032, -0.320021>, <-0.077113, -0.860850, -0.313232>, 
      <-0.075112, -0.875482, -0.336518>, <-0.069638, -0.874031, -0.328450>, <-0.059234, -0.870390, -0.320677>, <-0.052429, -0.868208, -0.313888>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.143077, -0.838566, -0.321865>, <-0.149006, -0.839696, -0.328630>, <-0.159624, -0.843283, -0.337087>, <-0.161514, -0.841087, -0.345678>, 
      <-0.123558, -0.850259, -0.328188>, <-0.129488, -0.851389, -0.334953>, <-0.139608, -0.855526, -0.347222>, <-0.141498, -0.853330, -0.355812>, 
      <-0.097199, -0.867704, -0.333456>, <-0.102237, -0.869039, -0.340881>, <-0.109228, -0.872597, -0.352000>, <-0.110738, -0.869572, -0.360418>, 
      <-0.075112, -0.875482, -0.336518>, <-0.080150, -0.876817, -0.343943>, <-0.085189, -0.880316, -0.355972>, <-0.086699, -0.877291, -0.364390>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.143077, -0.838566, -0.321865>, <-0.163235, -0.826490, -0.315335>, <-0.187105, -0.808439, -0.301976>, <-0.206811, -0.796585, -0.293855>, 
      <-0.140040, -0.837987, -0.318400>, <-0.160198, -0.825911, -0.311870>, <-0.184253, -0.808698, -0.300964>, <-0.203959, -0.796844, -0.292843>, 
      <-0.135171, -0.836365, -0.314789>, <-0.155854, -0.826680, -0.311814>, <-0.180026, -0.809057, -0.298198>, <-0.200246, -0.799189, -0.293274>, 
      <-0.131782, -0.835422, -0.311757>, <-0.152465, -0.825736, -0.308781>, <-0.177212, -0.810173, -0.297949>, <-0.197432, -0.800305, -0.293025>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.143077, -0.838566, -0.321865>, <-0.149006, -0.839696, -0.328630>, <-0.159624, -0.843283, -0.337087>, <-0.161514, -0.841087, -0.345678>, 
      <-0.163235, -0.826490, -0.315335>, <-0.169164, -0.827620, -0.322100>, <-0.179036, -0.831408, -0.327258>, <-0.180926, -0.829213, -0.335849>, 
      <-0.187105, -0.808439, -0.301976>, <-0.189987, -0.808177, -0.302999>, <-0.197917, -0.812385, -0.309425>, <-0.198839, -0.812028, -0.312331>, 
      <-0.206811, -0.796585, -0.293855>, <-0.209693, -0.796323, -0.294878>, <-0.214273, -0.799049, -0.296423>, <-0.215195, -0.798692, -0.299329>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.197705, -0.803155, -0.291281>, <-0.197430, -0.802477, -0.291971>, <-0.197514, -0.801160, -0.292502>, <-0.197432, -0.800305, -0.293025>, 
      <-0.203860, -0.799488, -0.290448>, <-0.203585, -0.798810, -0.291138>, <-0.200328, -0.800044, -0.292751>, <-0.200246, -0.799189, -0.293274>, 
      <-0.212845, -0.795832, -0.290691>, <-0.209088, -0.797000, -0.291716>, <-0.207244, -0.794868, -0.291489>, <-0.203959, -0.796844, -0.292843>, 
      <-0.219334, -0.792694, -0.290438>, <-0.215577, -0.793861, -0.291463>, <-0.210096, -0.794609, -0.292501>, <-0.206811, -0.796585, -0.293855>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.197705, -0.803155, -0.291281>, <-0.197430, -0.802477, -0.291971>, <-0.197514, -0.801160, -0.292502>, <-0.197432, -0.800305, -0.293025>, 
      <-0.197705, -0.803155, -0.291281>, <-0.203585, -0.798810, -0.291138>, <-0.203659, -0.798161, -0.291006>, <-0.203577, -0.797306, -0.291529>, 
      <-0.197705, -0.803155, -0.291281>, <-0.203585, -0.798810, -0.291138>, <-0.206615, -0.798924, -0.291474>, <-0.213104, -0.795785, -0.291221>, 
      <-0.197705, -0.803155, -0.291281>, <-0.203860, -0.799488, -0.290448>, <-0.212845, -0.795832, -0.290691>, <-0.219334, -0.792694, -0.290438>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.197705, -0.803155, -0.291281>, <-0.203860, -0.799488, -0.290448>, <-0.212845, -0.795832, -0.290691>, <-0.219334, -0.792694, -0.290438>, 
      <-0.198111, -0.804157, -0.290263>, <-0.204266, -0.800490, -0.289430>, <-0.217533, -0.793507, -0.290102>, <-0.224021, -0.790369, -0.289849>, 
      <-0.199387, -0.805090, -0.288834>, <-0.209566, -0.798161, -0.288406>, <-0.218517, -0.791602, -0.288521>, <-0.228661, -0.784616, -0.288816>, 
      <-0.199630, -0.805726, -0.287514>, <-0.209809, -0.798797, -0.287086>, <-0.223301, -0.789424, -0.288203>, <-0.233445, -0.782438, -0.288498>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.197705, -0.803155, -0.291281>, <-0.198111, -0.804157, -0.290263>, <-0.199387, -0.805090, -0.288834>, <-0.199630, -0.805726, -0.287514>, 
      <-0.176866, -0.815570, -0.294101>, <-0.177272, -0.816572, -0.293083>, <-0.177809, -0.819780, -0.289741>, <-0.178052, -0.820416, -0.288421>, 
      <-0.151535, -0.835672, -0.301176>, <-0.150951, -0.838377, -0.298501>, <-0.150102, -0.841567, -0.297214>, <-0.150976, -0.842661, -0.293629>, 
      <-0.129541, -0.846190, -0.302590>, <-0.128957, -0.848895, -0.299914>, <-0.126800, -0.853348, -0.296530>, <-0.127674, -0.854443, -0.292944>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.197705, -0.803155, -0.291281>, <-0.176866, -0.815570, -0.294101>, <-0.151535, -0.835672, -0.301176>, <-0.129541, -0.846190, -0.302590>, 
      <-0.197430, -0.802477, -0.291971>, <-0.176591, -0.814892, -0.294791>, <-0.152187, -0.832654, -0.304162>, <-0.130193, -0.843171, -0.305576>, 
      <-0.197514, -0.801160, -0.292502>, <-0.177294, -0.811028, -0.297425>, <-0.151793, -0.828967, -0.306031>, <-0.131110, -0.838652, -0.309007>, 
      <-0.197432, -0.800305, -0.293025>, <-0.177212, -0.810173, -0.297949>, <-0.152465, -0.825736, -0.308781>, <-0.131782, -0.835422, -0.311757>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.034744, -0.881085, -0.301755>, <-0.063683, -0.872089, -0.301972>, <-0.102247, -0.859243, -0.304344>, <-0.129541, -0.846190, -0.302590>, 
      <-0.032776, -0.884004, -0.296755>, <-0.061715, -0.875008, -0.296972>, <-0.101662, -0.861948, -0.301669>, <-0.128957, -0.848895, -0.299914>, 
      <-0.039057, -0.885188, -0.288727>, <-0.065685, -0.876854, -0.292013>, <-0.101736, -0.866021, -0.295793>, <-0.126800, -0.853348, -0.296530>, 
      <-0.040204, -0.886336, -0.282831>, <-0.066833, -0.878001, -0.286117>, <-0.102610, -0.867116, -0.292208>, <-0.127674, -0.854443, -0.292944>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.034744, -0.881085, -0.301755>, <-0.037159, -0.877503, -0.307891>, <-0.047123, -0.872071, -0.310248>, <-0.052429, -0.868208, -0.313888>, 
      <-0.063683, -0.872089, -0.301972>, <-0.066098, -0.868507, -0.308109>, <-0.071807, -0.864713, -0.309592>, <-0.077113, -0.860850, -0.313232>, 
      <-0.102247, -0.859243, -0.304344>, <-0.102899, -0.856224, -0.307330>, <-0.107971, -0.849488, -0.312336>, <-0.108644, -0.846257, -0.315086>, 
      <-0.129541, -0.846190, -0.302590>, <-0.130193, -0.843171, -0.305576>, <-0.131110, -0.838652, -0.309007>, <-0.131782, -0.835422, -0.311757>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000517, -0.886621, -0.301615>, <-0.010191, -0.886598, -0.301613>, <-0.024519, -0.884264, -0.301678>, <-0.034744, -0.881085, -0.301755>, 
      <0.000517, -0.890166, -0.294753>, <-0.010191, -0.890143, -0.294751>, <-0.022551, -0.887182, -0.296678>, <-0.032776, -0.884004, -0.296755>, 
      <0.000517, -0.893706, -0.284801>, <-0.012063, -0.893683, -0.284753>, <-0.027133, -0.888920, -0.287256>, <-0.039057, -0.885188, -0.288727>, 
      <0.000517, -0.894566, -0.277125>, <-0.012063, -0.894543, -0.277077>, <-0.028280, -0.890068, -0.281360>, <-0.040204, -0.886336, -0.282831>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000517, -0.886621, -0.301615>, <0.000517, -0.884139, -0.306419>, <0.000517, -0.878388, -0.311176>, <0.000517, -0.874859, -0.315274>, 
      <-0.010191, -0.886598, -0.301613>, <-0.010191, -0.884116, -0.306418>, <-0.015497, -0.878353, -0.311174>, <-0.015497, -0.874824, -0.315272>, 
      <-0.024519, -0.884264, -0.301678>, <-0.026935, -0.880682, -0.307815>, <-0.031782, -0.876644, -0.310656>, <-0.037087, -0.872781, -0.314296>, 
      <-0.034744, -0.881085, -0.301755>, <-0.037159, -0.877503, -0.307891>, <-0.047123, -0.872071, -0.310248>, <-0.052429, -0.868208, -0.313888>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.042966, -0.881253, -0.301766>, <0.030772, -0.885260, -0.301665>, <0.013353, -0.886649, -0.301617>, <0.000517, -0.886621, -0.301615>, 
      <0.042539, -0.884335, -0.296523>, <0.030344, -0.888342, -0.296421>, <0.013353, -0.890194, -0.294754>, <0.000517, -0.890166, -0.294753>, 
      <0.048732, -0.885333, -0.289134>, <0.034585, -0.889794, -0.287354>, <0.015457, -0.893733, -0.284858>, <0.000517, -0.893706, -0.284801>, 
      <0.049285, -0.886498, -0.283175>, <0.035138, -0.890959, -0.281395>, <0.015457, -0.894593, -0.277182>, <0.000517, -0.894566, -0.277125>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.042966, -0.881253, -0.301766>, <0.043381, -0.878260, -0.306857>, <0.049142, -0.872280, -0.310261>, <0.051789, -0.868435, -0.313902>, 
      <0.030772, -0.885260, -0.301665>, <0.031186, -0.882267, -0.306756>, <0.034389, -0.877040, -0.310686>, <0.037036, -0.873195, -0.314327>, 
      <0.013353, -0.886649, -0.301617>, <0.013353, -0.884167, -0.306421>, <0.016024, -0.878421, -0.311178>, <0.016024, -0.874893, -0.315276>, 
      <0.000517, -0.886621, -0.301615>, <0.000517, -0.884139, -0.306419>, <0.000517, -0.878388, -0.311176>, <0.000517, -0.874859, -0.315274>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.042966, -0.881253, -0.301766>, <0.067523, -0.873184, -0.301971>, <0.098860, -0.858332, -0.304190>, <0.121909, -0.846735, -0.302626>, 
      <0.043381, -0.878260, -0.306857>, <0.067938, -0.870192, -0.307062>, <0.098251, -0.855223, -0.307198>, <0.121300, -0.843626, -0.305634>, 
      <0.049142, -0.872280, -0.310261>, <0.071487, -0.865071, -0.309618>, <0.101387, -0.848672, -0.312000>, <0.122496, -0.838816, -0.309018>, 
      <0.051789, -0.868435, -0.313902>, <0.074134, -0.861226, -0.313259>, <0.101638, -0.845278, -0.314739>, <0.122748, -0.835422, -0.311757>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.042966, -0.881253, -0.301766>, <0.042539, -0.884335, -0.296523>, <0.048732, -0.885333, -0.289134>, <0.049285, -0.886498, -0.283175>, 
      <0.067523, -0.873184, -0.301971>, <0.067096, -0.876267, -0.296727>, <0.072618, -0.877801, -0.292139>, <0.073170, -0.878966, -0.286180>, 
      <0.098860, -0.858332, -0.304190>, <0.099422, -0.861196, -0.301418>, <0.103514, -0.865616, -0.296097>, <0.104321, -0.866722, -0.292312>, 
      <0.121909, -0.846735, -0.302626>, <0.122471, -0.849599, -0.299855>, <0.125745, -0.853716, -0.296766>, <0.126552, -0.854822, -0.292982>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.219617, 0.629897, -0.357664>, <0.193242, 0.593653, -0.611573>, <0.206751, 0.601955, -0.958494>, <0.201237, 0.589980, -1.215992>, 
      <0.183717, 0.643038, -0.358372>, <0.157342, 0.606793, -0.612281>, <0.173787, 0.614010, -0.958494>, <0.168273, 0.602035, -1.215992>, 
      <0.136845, 0.663731, -0.358854>, <0.115485, 0.628017, -0.612600>, <0.127818, 0.634065, -0.959201>, <0.125239, 0.621004, -1.215992>, 
      <0.099950, 0.673699, -0.360023>, <0.078590, 0.637985, -0.613769>, <0.093934, 0.643223, -0.959201>, <0.091356, 0.630162, -1.215992>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.287459, 0.574592, -0.359450>, <0.251815, 0.539035, -0.611758>, <0.270709, 0.549807, -0.959029>, <0.263531, 0.539185, -1.215992>, 
      <0.268484, 0.592587, -0.357018>, <0.232840, 0.557031, -0.609326>, <0.253227, 0.566415, -0.959029>, <0.246049, 0.555793, -1.215992>, 
      <0.239970, 0.613305, -0.358200>, <0.213595, 0.577061, -0.612109>, <0.225439, 0.586717, -0.958494>, <0.219925, 0.574742, -1.215992>, 
      <0.219617, 0.629897, -0.357664>, <0.193242, 0.593653, -0.611573>, <0.206751, 0.601955, -0.958494>, <0.201237, 0.589980, -1.215992>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.401858, 0.457063, -0.381021>, <0.367742, 0.438095, -0.628777>, <0.378561, 0.438828, -0.965501>, <0.368576, 0.431013, -1.215992>, 
      <0.375272, 0.497844, -0.371380>, <0.341156, 0.478876, -0.619136>, <0.353910, 0.476756, -0.965501>, <0.343925, 0.468941, -1.215992>, 
      <0.323313, 0.540588, -0.364045>, <0.287669, 0.505032, -0.616353>, <0.303505, 0.518652, -0.959029>, <0.296327, 0.508030, -1.215992>, 
      <0.287459, 0.574592, -0.359450>, <0.251815, 0.539035, -0.611758>, <0.270709, 0.549807, -0.959029>, <0.263531, 0.539185, -1.215992>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.477269, 0.283437, -0.428282>, <0.447288, 0.283554, -0.663014>, <0.449658, 0.274738, -0.979679>, <0.437825, 0.271010, -1.215992>, 
      <0.460591, 0.337579, -0.413570>, <0.430610, 0.337696, -0.648301>, <0.434309, 0.324739, -0.979679>, <0.422476, 0.321011, -1.215992>, 
      <0.433214, 0.408965, -0.392392>, <0.399098, 0.389996, -0.640148>, <0.407063, 0.394973, -0.965501>, <0.397079, 0.387158, -1.215992>, 
      <0.401858, 0.457063, -0.381021>, <0.367742, 0.438095, -0.628777>, <0.378561, 0.438828, -0.965501>, <0.368576, 0.431013, -1.215992>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.490079, 0.170677, -0.458841>, <0.462000, 0.182590, -0.684259>, <0.461737, 0.168173, -0.988847>, <0.449590, 0.167100, -1.215992>, 
      <0.489588, 0.204491, -0.448866>, <0.461509, 0.216405, -0.674284>, <0.461282, 0.199542, -0.988847>, <0.449136, 0.198469, -1.215992>, 
      <0.487316, 0.250823, -0.437144>, <0.457335, 0.250940, -0.671876>, <0.458865, 0.244747, -0.979679>, <0.447031, 0.241019, -1.215992>, 
      <0.477269, 0.283437, -0.428282>, <0.447288, 0.283554, -0.663014>, <0.449658, 0.274738, -0.979679>, <0.437825, 0.271010, -1.215992>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.480615, 0.052883, -0.496291>, <0.449917, 0.076379, -0.709053>, <0.452817, 0.056800, -1.000082>, <0.440904, 0.058479, -1.215992>, 
      <0.487356, 0.087064, -0.483279>, <0.456658, 0.110559, -0.696041>, <0.459110, 0.088879, -1.000082>, <0.447197, 0.090558, -1.215992>, 
      <0.490597, 0.135010, -0.469362>, <0.462518, 0.146924, -0.694780>, <0.462210, 0.135486, -0.988847>, <0.450064, 0.134413, -1.215992>, 
      <0.490079, 0.170677, -0.458841>, <0.462000, 0.182590, -0.684259>, <0.461737, 0.168173, -0.988847>, <0.449590, 0.167100, -1.215992>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.444215, -0.061871, -0.547365>, <0.421740, 0.014109, -0.732020>, <0.418505, -0.051829, -1.015404>, <0.407486, -0.047525, -1.215992>, 
      <0.459961, -0.029710, -0.531337>, <0.437487, 0.046270, -0.715992>, <0.432559, -0.021591, -1.015404>, <0.421540, -0.017287, -1.215992>, 
      <0.473504, 0.016825, -0.510017>, <0.442805, 0.040320, -0.722779>, <0.446398, 0.024080, -1.000082>, <0.434485, 0.025759, -1.215992>, 
      <0.480615, 0.052883, -0.496291>, <0.449917, 0.076379, -0.709053>, <0.452817, 0.056800, -1.000082>, <0.440904, 0.058479, -1.215992>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.351813, -0.210187, -0.627398>, <0.336100, -0.132721, -0.786080>, <0.343387, -0.174428, -1.039414>, <0.339776, -0.159102, -1.215992>, 
      <0.381454, -0.167325, -0.602721>, <0.365741, -0.089860, -0.761402>, <0.364818, -0.141659, -1.039414>, <0.361207, -0.126333, -1.215992>, 
      <0.421072, -0.109138, -0.570922>, <0.398598, -0.033158, -0.755577>, <0.402002, -0.087335, -1.015404>, <0.390983, -0.083032, -1.215992>, 
      <0.444215, -0.061871, -0.547365>, <0.421740, 0.014109, -0.732020>, <0.418505, -0.051829, -1.015404>, <0.407486, -0.047525, -1.215992>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.283412, -0.294394, -0.681239>, <0.270067, -0.219998, -0.823528>, <0.279890, -0.259773, -1.055566>, <0.278381, -0.244935, -1.215992>, 
      <0.306582, -0.270814, -0.666162>, <0.293237, -0.196418, -0.808451>, <0.300677, -0.235893, -1.055566>, <0.299167, -0.221056, -1.215992>, 
      <0.333135, -0.237196, -0.642948>, <0.317422, -0.159730, -0.801630>, <0.326059, -0.200923, -1.039414>, <0.322448, -0.185598, -1.215992>, 
      <0.351813, -0.210187, -0.627398>, <0.336100, -0.132721, -0.786080>, <0.343387, -0.174428, -1.039414>, <0.339776, -0.159102, -1.215992>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.225173, -0.339069, -0.709803>, <0.213395, -0.262287, -0.841028>, <0.223982, -0.306621, -1.064135>, <0.223471, -0.292714, -1.215992>, 
      <0.244036, -0.327079, -0.702138>, <0.232258, -0.250297, -0.833363>, <0.241351, -0.293387, -1.064135>, <0.240840, -0.279481, -1.215992>, 
      <0.268344, -0.309729, -0.691044>, <0.255000, -0.235333, -0.833332>, <0.265554, -0.276243, -1.055566>, <0.264044, -0.261405, -1.215992>, 
      <0.283412, -0.294394, -0.681239>, <0.270067, -0.219998, -0.823528>, <0.279890, -0.259773, -1.055566>, <0.278381, -0.244935, -1.215992>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.161040, -0.372179, -0.730963>, <0.150083, -0.293934, -0.853970>, <0.168496, -0.340006, -1.070483>, <0.171692, -0.326218, -1.215992>, 
      <0.181442, -0.364007, -0.725852>, <0.170485, -0.285762, -0.848859>, <0.185213, -0.332077, -1.070483>, <0.188409, -0.318288, -1.215992>, 
      <0.207160, -0.350519, -0.717122>, <0.195382, -0.273737, -0.848347>, <0.209264, -0.317833, -1.064135>, <0.208754, -0.303927, -1.215992>, 
      <0.225173, -0.339069, -0.709803>, <0.213395, -0.262287, -0.841028>, <0.223982, -0.306621, -1.064135>, <0.223471, -0.292714, -1.215992>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.107291, -0.386289, -0.739335>, <0.095005, -0.304046, -0.856349>, <0.111842, -0.357205, -1.072995>, <0.113792, -0.344741, -1.215992>, 
      <0.123570, -0.382587, -0.736983>, <0.111284, -0.300344, -0.853997>, <0.129500, -0.352648, -1.072995>, <0.131451, -0.340183, -1.215992>, 
      <0.145797, -0.378285, -0.734782>, <0.134840, -0.300040, -0.857789>, <0.152019, -0.347822, -1.070483>, <0.155215, -0.334034, -1.215992>, 
      <0.161040, -0.372179, -0.730963>, <0.150083, -0.293934, -0.853970>, <0.168496, -0.340006, -1.070483>, <0.171692, -0.326218, -1.215992>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.065445, -0.393917, -0.744775>, <0.056447, -0.308222, -0.857466>, <0.062428, -0.366501, -1.074627>, <0.061135, -0.354752, -1.215992>, 
      <0.078133, -0.392142, -0.743611>, <0.069135, -0.306447, -0.856302>, <0.078332, -0.364127, -1.074627>, <0.077039, -0.352377, -1.215992>, 
      <0.094869, -0.389114, -0.741130>, <0.082583, -0.306870, -0.858144>, <0.096272, -0.361224, -1.072995>, <0.098222, -0.348760, -1.215992>, 
      <0.107291, -0.386289, -0.739335>, <0.095005, -0.304046, -0.856349>, <0.111842, -0.357205, -1.072995>, <0.113792, -0.344741, -1.215992>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000517, -0.401224, -0.749129>, <0.000517, -0.312794, -0.858388>, <0.000517, -0.373525, -1.075933>, <0.000517, -0.361654, -1.215992>, 
      <0.020162, -0.401267, -0.749132>, <0.020162, -0.312837, -0.858391>, <0.018820, -0.373525, -1.075933>, <0.018820, -0.361654, -1.215992>, 
      <0.046069, -0.396627, -0.746552>, <0.037071, -0.310932, -0.859243>, <0.044326, -0.369204, -1.074627>, <0.043033, -0.357455, -1.215992>, 
      <0.065445, -0.393917, -0.744775>, <0.056447, -0.308222, -0.857466>, <0.062428, -0.366501, -1.074627>, <0.061135, -0.354752, -1.215992>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.072261, -0.393615, -0.744755>, <-0.062614, -0.307944, -0.857414>, <-0.068390, -0.366411, -1.074621>, <-0.066731, -0.354752, -1.215992>, 
      <-0.050507, -0.396337, -0.746487>, <-0.040860, -0.310666, -0.859146>, <-0.048285, -0.369068, -1.074621>, <-0.046626, -0.357409, -1.215992>, 
      <-0.021475, -0.401176, -0.749126>, <-0.021475, -0.312746, -0.858385>, <-0.019763, -0.373525, -1.075933>, <-0.019763, -0.361654, -1.215992>, 
      <0.000517, -0.401224, -0.749129>, <0.000517, -0.312794, -0.858388>, <0.000517, -0.373525, -1.075933>, <0.000517, -0.361654, -1.215992>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.122890, -0.385783, -0.739302>, <-0.111587, -0.303520, -0.856389>, <-0.126075, -0.357054, -1.072985>, <-0.127440, -0.344741, -1.215992>, 
      <-0.107917, -0.389007, -0.741375>, <-0.096614, -0.306744, -0.858463>, <-0.108180, -0.361581, -1.072985>, <-0.109545, -0.349268, -1.215992>, 
      <-0.087550, -0.391702, -0.743538>, <-0.077903, -0.306031, -0.856196>, <-0.086690, -0.363992, -1.074621>, <-0.085030, -0.352333, -1.215992>, 
      <-0.072261, -0.393615, -0.744755>, <-0.062614, -0.307944, -0.857414>, <-0.068390, -0.366411, -1.074621>, <-0.066731, -0.354752, -1.215992>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.171877, -0.372165, -0.730962>, <-0.159952, -0.293989, -0.853903>, <-0.177228, -0.340002, -1.070483>, <-0.179521, -0.326218, -1.215992>, 
      <-0.157829, -0.377617, -0.734405>, <-0.145903, -0.299440, -0.857345>, <-0.162260, -0.347140, -1.070483>, <-0.164553, -0.333356, -1.215992>, 
      <-0.137864, -0.382559, -0.737229>, <-0.126562, -0.300295, -0.854316>, <-0.142152, -0.352986, -1.072985>, <-0.143517, -0.340674, -1.215992>, 
      <-0.122890, -0.385783, -0.739302>, <-0.111587, -0.303520, -0.856389>, <-0.126075, -0.357054, -1.072985>, <-0.127440, -0.344741, -1.215992>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.243267, -0.339069, -0.709803>, <-0.232479, -0.262302, -0.841136>, <-0.238554, -0.306621, -1.064135>, <-0.236534, -0.292714, -1.215992>, 
      <-0.223345, -0.351005, -0.717434>, <-0.212557, -0.274237, -0.848767>, <-0.222566, -0.318366, -1.064135>, <-0.220546, -0.304459, -1.215992>, 
      <-0.194094, -0.363543, -0.725518>, <-0.182168, -0.285367, -0.848458>, <-0.195134, -0.331462, -1.070483>, <-0.197428, -0.317678, -1.215992>, 
      <-0.171877, -0.372165, -0.730962>, <-0.159952, -0.293989, -0.853903>, <-0.177228, -0.340002, -1.070483>, <-0.179521, -0.326218, -1.215992>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.301686, -0.294394, -0.681239>, <-0.288348, -0.219984, -0.823555>, <-0.293621, -0.259773, -1.055566>, <-0.290164, -0.244935, -1.215992>, 
      <-0.286800, -0.309897, -0.691152>, <-0.273462, -0.235487, -0.833468>, <-0.278990, -0.275593, -1.055566>, <-0.275534, -0.260755, -1.215992>, 
      <-0.262556, -0.327513, -0.702414>, <-0.251768, -0.250745, -0.833747>, <-0.255919, -0.293863, -1.064135>, <-0.253900, -0.279957, -1.215992>, 
      <-0.243267, -0.339069, -0.709803>, <-0.232479, -0.262302, -0.841136>, <-0.238554, -0.306621, -1.064135>, <-0.236534, -0.292714, -1.215992>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.367014, -0.210187, -0.627398>, <-0.354131, -0.132632, -0.786264>, <-0.362171, -0.174428, -1.039414>, <-0.360096, -0.159102, -1.215992>, 
      <-0.349728, -0.237377, -0.643053>, <-0.336845, -0.159821, -0.801918>, <-0.344608, -0.202618, -1.039414>, <-0.342533, -0.187293, -1.215992>, 
      <-0.324215, -0.270930, -0.666237>, <-0.310877, -0.196520, -0.808553>, <-0.316172, -0.235387, -1.055566>, <-0.312715, -0.220550, -1.215992>, 
      <-0.301686, -0.294394, -0.681239>, <-0.288348, -0.219984, -0.823555>, <-0.293621, -0.259773, -1.055566>, <-0.290164, -0.244935, -1.215992>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.449516, -0.061871, -0.547365>, <-0.426818, 0.014097, -0.731991>, <-0.424063, -0.051829, -1.015404>, <-0.413154, -0.047525, -1.215992>, 
      <-0.428485, -0.108605, -0.570656>, <-0.405788, -0.032637, -0.755282>, <-0.410437, -0.086298, -1.015404>, <-0.399528, -0.081994, -1.215992>, 
      <-0.394179, -0.167459, -0.602797>, <-0.381296, -0.089903, -0.761663>, <-0.381771, -0.142969, -1.039414>, <-0.379696, -0.127643, -1.215992>, 
      <-0.367014, -0.210187, -0.627398>, <-0.354131, -0.132632, -0.786264>, <-0.362171, -0.174428, -1.039414>, <-0.360096, -0.159102, -1.215992>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.485397, 0.052883, -0.496291>, <-0.454709, 0.076378, -0.709047>, <-0.457894, 0.056800, -1.000082>, <-0.446107, 0.058479, -1.215992>, 
      <-0.478450, 0.016838, -0.510012>, <-0.447762, 0.040333, -0.722769>, <-0.451622, 0.024094, -1.000082>, <-0.439835, 0.025773, -1.215992>, 
      <-0.464157, -0.029336, -0.531150>, <-0.441460, 0.046632, -0.715777>, <-0.436305, -0.020858, -1.015404>, <-0.425397, -0.016555, -1.215992>, 
      <-0.449516, -0.061871, -0.547365>, <-0.426818, 0.014097, -0.731991>, <-0.424063, -0.051829, -1.015404>, <-0.413154, -0.047525, -1.215992>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.494335, 0.170677, -0.458841>, <-0.466315, 0.182585, -0.684259>, <-0.466321, 0.168173, -0.988847>, <-0.454315, 0.167100, -1.215992>, 
      <-0.495012, 0.135024, -0.469358>, <-0.466992, 0.146932, -0.694776>, <-0.466938, 0.135500, -0.988847>, <-0.454932, 0.134427, -1.215992>, 
      <-0.491988, 0.087078, -0.483274>, <-0.461300, 0.110573, -0.696030>, <-0.464049, 0.088895, -1.000082>, <-0.452262, 0.090573, -1.215992>, 
      <-0.485397, 0.052883, -0.496291>, <-0.454709, 0.076378, -0.709047>, <-0.457894, 0.056800, -1.000082>, <-0.446107, 0.058479, -1.215992>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.481021, 0.283437, -0.428282>, <-0.451152, 0.283554, -0.663020>, <-0.453773, 0.274738, -0.979679>, <-0.442095, 0.271010, -1.215992>, 
      <-0.491206, 0.250846, -0.437138>, <-0.461337, 0.250963, -0.671876>, <-0.463104, 0.244769, -0.979679>, <-0.451426, 0.241041, -1.215992>, 
      <-0.493693, 0.204505, -0.448862>, <-0.465673, 0.216414, -0.674280>, <-0.465729, 0.199555, -0.988847>, <-0.453723, 0.198482, -1.215992>, 
      <-0.494335, 0.170677, -0.458841>, <-0.466315, 0.182585, -0.684259>, <-0.466321, 0.168173, -0.988847>, <-0.454315, 0.167100, -1.215992>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.404834, 0.457063, -0.381021>, <-0.370972, 0.438093, -0.628804>, <-0.381951, 0.438828, -0.965501>, <-0.372144, 0.431013, -1.215992>, 
      <-0.436392, 0.408985, -0.392387>, <-0.402530, 0.390014, -0.640171>, <-0.410635, 0.394991, -0.965501>, <-0.400828, 0.387176, -1.215992>, 
      <-0.464095, 0.337598, -0.413565>, <-0.434225, 0.337715, -0.648303>, <-0.438199, 0.324757, -0.979679>, <-0.426521, 0.321029, -1.215992>, 
      <-0.481021, 0.283437, -0.428282>, <-0.451152, 0.283554, -0.663020>, <-0.453773, 0.274738, -0.979679>, <-0.442095, 0.271010, -1.215992>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.289912, 0.574592, -0.359450>, <-0.260456, 0.538926, -0.612534>, <-0.273609, 0.549807, -0.959029>, <-0.266622, 0.539185, -1.215992>, 
      <-0.325917, 0.540589, -0.364045>, <-0.296460, 0.504922, -0.617130>, <-0.306542, 0.518652, -0.959029>, <-0.299555, 0.508030, -1.215992>, 
      <-0.378060, 0.497853, -0.371378>, <-0.344198, 0.478883, -0.619161>, <-0.357129, 0.476764, -0.965501>, <-0.347322, 0.468949, -1.215992>, 
      <-0.404834, 0.457063, -0.381021>, <-0.370972, 0.438093, -0.628804>, <-0.381951, 0.438828, -0.965501>, <-0.372144, 0.431013, -1.215992>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.221828, 0.629897, -0.357664>, <-0.196559, 0.592744, -0.611550>, <-0.209422, 0.601955, -0.958494>, <-0.204105, 0.589980, -1.215992>, 
      <-0.242253, 0.613305, -0.358200>, <-0.216984, 0.576152, -0.612086>, <-0.228177, 0.586717, -0.958494>, <-0.222860, 0.574742, -1.215992>, 
      <-0.270858, 0.592587, -0.357018>, <-0.241402, 0.556920, -0.610102>, <-0.256054, 0.566414, -0.959029>, <-0.249067, 0.555792, -1.215992>, 
      <-0.289912, 0.574592, -0.359450>, <-0.260456, 0.538926, -0.612534>, <-0.273609, 0.549807, -0.959029>, <-0.266622, 0.539185, -1.215992>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.101969, 0.673699, -0.360023>, <-0.079753, 0.637093, -0.613566>, <-0.096424, 0.643223, -0.959201>, <-0.094048, 0.630162, -1.215992>, 
      <-0.138954, 0.663853, -0.358868>, <-0.116737, 0.627247, -0.612412>, <-0.130399, 0.634215, -0.959201>, <-0.128023, 0.621154, -1.215992>, 
      <-0.185870, 0.643038, -0.358372>, <-0.160601, 0.605885, -0.612258>, <-0.176405, 0.614010, -0.958494>, <-0.171088, 0.602035, -1.215992>, 
      <-0.221828, 0.629897, -0.357664>, <-0.196559, 0.592744, -0.611550>, <-0.209422, 0.601955, -0.958494>, <-0.204105, 0.589980, -1.215992>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000517, 0.689090, -0.364606>, <0.000517, 0.650551, -0.617456>, <0.000517, 0.657690, -0.960576>, <0.000517, 0.644233, -1.215992>, 
      <-0.030604, 0.689090, -0.364606>, <-0.030604, 0.650551, -0.617456>, <-0.028165, 0.657690, -0.960576>, <-0.028165, 0.644233, -1.215992>, 
      <-0.071909, 0.681702, -0.360961>, <-0.049693, 0.645096, -0.614505>, <-0.068700, 0.650574, -0.959201>, <-0.066324, 0.637513, -1.215992>, 
      <-0.101969, 0.673699, -0.360023>, <-0.079753, 0.637093, -0.613566>, <-0.096424, 0.643223, -0.959201>, <-0.094048, 0.630162, -1.215992>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000517, 0.689090, -0.364606>, <0.030733, 0.689090, -0.364606>, <0.070793, 0.681576, -0.360947>, <0.099950, 0.673699, -0.360023>, 
      <0.000517, 0.650551, -0.617456>, <0.030733, 0.650551, -0.617456>, <0.049433, 0.645862, -0.614693>, <0.078590, 0.637985, -0.613769>, 
      <0.000517, 0.657690, -0.960576>, <0.028094, 0.657690, -0.960576>, <0.067313, 0.650419, -0.959201>, <0.093934, 0.643223, -0.959201>, 
      <0.000517, 0.644233, -1.215992>, <0.028094, 0.644233, -1.215992>, <0.064735, 0.637358, -1.215992>, <0.091356, 0.630162, -1.215992>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.147380, -0.876019, -0.045413>, <-0.145475, -0.876174, -0.030502>, <-0.138440, -0.869768, -0.011976>, <-0.135831, -0.865499, 0.002201>, 
      <-0.148666, -0.875914, -0.055481>, <-0.146761, -0.876069, -0.040569>, <-0.148390, -0.864497, -0.025505>, <-0.145781, -0.860229, -0.011328>, 
      <-0.147442, -0.867814, -0.067716>, <-0.154609, -0.863105, -0.062844>, <-0.159487, -0.854000, -0.042098>, <-0.158237, -0.854101, -0.032315>, 
      <-0.145980, -0.864673, -0.077256>, <-0.153147, -0.859964, -0.072385>, <-0.161717, -0.853818, -0.059556>, <-0.160467, -0.853920, -0.049774>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.147380, -0.876019, -0.045413>, <-0.145475, -0.876174, -0.030502>, <-0.138440, -0.869768, -0.011976>, <-0.135831, -0.865499, 0.002201>, 
      <-0.147380, -0.876019, -0.045413>, <-0.151406, -0.871660, -0.032854>, <-0.148390, -0.864497, -0.025505>, <-0.145781, -0.860229, -0.011328>, 
      <-0.147380, -0.876019, -0.045413>, <-0.151406, -0.871660, -0.032854>, <-0.154503, -0.860928, -0.033053>, <-0.158237, -0.854101, -0.032315>, 
      <-0.147380, -0.876019, -0.045413>, <-0.153310, -0.871505, -0.047765>, <-0.156734, -0.860746, -0.050512>, <-0.160467, -0.853920, -0.049774>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.147380, -0.876019, -0.045413>, <-0.148666, -0.875914, -0.055481>, <-0.147442, -0.867814, -0.067716>, <-0.145980, -0.864673, -0.077256>, 
      <-0.147380, -0.876019, -0.045413>, <-0.154596, -0.871401, -0.057833>, <-0.154609, -0.863105, -0.062844>, <-0.153147, -0.859964, -0.072385>, 
      <-0.147380, -0.876019, -0.045413>, <-0.154596, -0.871401, -0.057833>, <-0.157983, -0.860645, -0.060294>, <-0.161717, -0.853818, -0.059556>, 
      <-0.147380, -0.876019, -0.045413>, <-0.153310, -0.871505, -0.047765>, <-0.156734, -0.860746, -0.050512>, <-0.160467, -0.853920, -0.049774>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.037896, -0.883401, -0.049223>, <0.038069, -0.886451, -0.034449>, <0.047787, -0.917354, -0.072886>, <0.050716, -0.929560, -0.064517>, 
      <0.020307, -0.886150, -0.045759>, <0.020480, -0.889200, -0.030985>, <0.033459, -0.926743, -0.069381>, <0.036387, -0.938949, -0.061012>, 
      <0.018653, -0.883451, -0.096738>, <0.018653, -0.891512, -0.072592>, <0.018003, -0.941261, -0.075435>, <0.018003, -0.958045, -0.056296>, 
      <0.000517, -0.883421, -0.096735>, <0.000517, -0.891482, -0.072589>, <0.000517, -0.941232, -0.075432>, <0.000517, -0.958016, -0.056293>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.213828, -0.790251, -0.345421>, <0.224845, -0.786584, -0.330256>, <0.232945, -0.784370, -0.305596>, <0.241138, -0.781849, -0.288528>, 
      <0.213252, -0.794111, -0.331869>, <0.224268, -0.790444, -0.316704>, <0.229837, -0.785493, -0.305528>, <0.238030, -0.782972, -0.288460>, 
      <0.214679, -0.797047, -0.312957>, <0.220418, -0.793058, -0.309070>, <0.227718, -0.786132, -0.291580>, <0.233181, -0.781241, -0.288390>, 
      <0.211931, -0.798825, -0.299239>, <0.217670, -0.794836, -0.295352>, <0.224679, -0.787412, -0.291795>, <0.230142, -0.782521, -0.288605>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.213828, -0.790251, -0.345421>, <0.213252, -0.794111, -0.331869>, <0.214679, -0.797047, -0.312957>, <0.211931, -0.798825, -0.299239>, 
      <0.195946, -0.796204, -0.370036>, <0.195369, -0.800064, -0.356484>, <0.195058, -0.810684, -0.326246>, <0.192310, -0.812462, -0.312528>, 
      <0.168959, -0.805953, -0.400465>, <0.166790, -0.812963, -0.377943>, <0.170897, -0.822139, -0.357575>, <0.167376, -0.828071, -0.334914>, 
      <0.145856, -0.813566, -0.419685>, <0.143687, -0.820575, -0.397162>, <0.149397, -0.835155, -0.368339>, <0.145876, -0.841087, -0.345678>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.083294, -0.833262, -0.454013>, <0.103913, -0.828138, -0.447545>, <0.129305, -0.819020, -0.433453>, <0.145856, -0.813566, -0.419685>, 
      <0.080988, -0.842803, -0.425666>, <0.101606, -0.837679, -0.419198>, <0.127136, -0.826029, -0.410931>, <0.143687, -0.820575, -0.397162>, 
      <0.084624, -0.867490, -0.392501>, <0.105828, -0.859901, -0.388596>, <0.131423, -0.846037, -0.377337>, <0.149397, -0.835155, -0.368339>, 
      <0.081719, -0.877656, -0.364428>, <0.102923, -0.870067, -0.360523>, <0.127902, -0.851969, -0.354677>, <0.145876, -0.841087, -0.345678>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000517, -0.849683, -0.465280>, <0.026059, -0.849683, -0.465280>, <0.059581, -0.839155, -0.461452>, <0.083294, -0.833262, -0.454013>, 
      <0.000517, -0.858659, -0.435873>, <0.026059, -0.858659, -0.435873>, <0.057274, -0.848695, -0.433105>, <0.080988, -0.842803, -0.425666>, 
      <0.000517, -0.883757, -0.401736>, <0.025431, -0.883811, -0.401742>, <0.061512, -0.875762, -0.396758>, <0.084624, -0.867490, -0.392501>, 
      <0.000517, -0.893112, -0.372447>, <0.025431, -0.893166, -0.372453>, <0.058607, -0.885928, -0.368684>, <0.081719, -0.877656, -0.364428>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.096191, -0.833262, -0.454013>, <-0.068253, -0.839373, -0.461728>, <-0.029104, -0.849683, -0.465280>, <0.000517, -0.849683, -0.465280>, 
      <-0.093508, -0.842789, -0.425596>, <-0.065570, -0.848901, -0.433311>, <-0.029104, -0.858659, -0.435873>, <0.000517, -0.858659, -0.435873>, 
      <-0.091708, -0.867257, -0.392313>, <-0.066594, -0.875321, -0.396462>, <-0.026184, -0.883699, -0.401730>, <0.000517, -0.883757, -0.401736>, 
      <-0.086699, -0.877291, -0.364390>, <-0.061585, -0.885355, -0.368539>, <-0.026184, -0.893054, -0.372441>, <0.000517, -0.893112, -0.372447>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.096191, -0.833262, -0.454013>, <-0.093508, -0.842789, -0.425596>, <-0.091708, -0.867257, -0.392313>, <-0.086699, -0.877291, -0.364390>, 
      <-0.118554, -0.828371, -0.447838>, <-0.115872, -0.837898, -0.419421>, <-0.115748, -0.859539, -0.388342>, <-0.110738, -0.869572, -0.360418>, 
      <-0.147151, -0.819477, -0.434609>, <-0.145503, -0.826515, -0.412032>, <-0.146441, -0.847589, -0.378275>, <-0.141498, -0.853330, -0.355812>, 
      <-0.164602, -0.813566, -0.419685>, <-0.162954, -0.820604, -0.397108>, <-0.166457, -0.835346, -0.368141>, <-0.161514, -0.841087, -0.345678>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.223169, -0.790251, -0.345421>, <-0.222181, -0.794149, -0.331740>, <-0.219477, -0.797034, -0.312829>, <-0.215195, -0.798692, -0.299329>, 
      <-0.208433, -0.796201, -0.369945>, <-0.207445, -0.800099, -0.356264>, <-0.203121, -0.810370, -0.325831>, <-0.198839, -0.812028, -0.312331>, 
      <-0.186110, -0.806281, -0.401291>, <-0.184462, -0.813319, -0.378715>, <-0.185869, -0.823472, -0.358312>, <-0.180926, -0.829213, -0.335849>, 
      <-0.164602, -0.813566, -0.419685>, <-0.162954, -0.820604, -0.397108>, <-0.166457, -0.835346, -0.368141>, <-0.161514, -0.841087, -0.345678>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.223169, -0.790251, -0.345421>, <-0.232337, -0.786549, -0.330162>, <-0.237202, -0.784351, -0.305821>, <-0.243216, -0.781823, -0.288849>, 
      <-0.222181, -0.794149, -0.331740>, <-0.231349, -0.790447, -0.316481>, <-0.234429, -0.785324, -0.305759>, <-0.240443, -0.782795, -0.288787>, 
      <-0.219477, -0.797034, -0.312829>, <-0.224769, -0.792719, -0.308623>, <-0.230640, -0.786099, -0.291570>, <-0.236115, -0.781223, -0.288320>, 
      <-0.215195, -0.798692, -0.299329>, <-0.220487, -0.794377, -0.295123>, <-0.227970, -0.787314, -0.291747>, <-0.233445, -0.782438, -0.288498>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.200487, -0.810441, -0.276162>, <-0.201638, -0.809503, -0.279547>, <-0.200235, -0.807309, -0.284229>, <-0.199630, -0.805726, -0.287514>, 
      <-0.212899, -0.801144, -0.279630>, <-0.214050, -0.800205, -0.283015>, <-0.210413, -0.800380, -0.283801>, <-0.209809, -0.798797, -0.287086>, 
      <-0.230397, -0.790408, -0.285043>, <-0.227625, -0.791381, -0.284981>, <-0.225970, -0.788209, -0.288025>, <-0.223301, -0.789424, -0.288203>, 
      <-0.243216, -0.781823, -0.288849>, <-0.240443, -0.782795, -0.288787>, <-0.236115, -0.781223, -0.288320>, <-0.233445, -0.782438, -0.288498>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.139925, -0.859195, -0.259989>, <-0.141642, -0.858336, -0.270458>, <-0.130091, -0.857469, -0.283030>, <-0.127674, -0.854443, -0.292944>, 
      <-0.160482, -0.848151, -0.264789>, <-0.162198, -0.847293, -0.275257>, <-0.153392, -0.845688, -0.283715>, <-0.150976, -0.842661, -0.293629>, 
      <-0.181879, -0.824380, -0.270963>, <-0.183031, -0.823441, -0.274348>, <-0.178656, -0.821999, -0.285136>, <-0.178052, -0.820416, -0.288421>, 
      <-0.200487, -0.810441, -0.276162>, <-0.201638, -0.809503, -0.279547>, <-0.200235, -0.807309, -0.284229>, <-0.199630, -0.805726, -0.287514>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.046710, -0.893055, -0.240258>, <-0.046525, -0.893227, -0.253332>, <-0.042657, -0.888790, -0.270223>, <-0.040204, -0.886336, -0.282831>, 
      <-0.076230, -0.886175, -0.241463>, <-0.076046, -0.886346, -0.254537>, <-0.069286, -0.880455, -0.273509>, <-0.066833, -0.878001, -0.286117>, 
      <-0.113750, -0.873257, -0.253878>, <-0.115466, -0.872398, -0.264347>, <-0.105027, -0.870142, -0.282294>, <-0.102610, -0.867116, -0.292208>, 
      <-0.139925, -0.859195, -0.259989>, <-0.141642, -0.858336, -0.270458>, <-0.130091, -0.857469, -0.283030>, <-0.127674, -0.854443, -0.292944>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.046710, -0.893055, -0.240258>, <-0.032326, -0.896408, -0.239671>, <-0.014264, -0.891898, -0.254233>, <0.000517, -0.891928, -0.254255>, 
      <-0.046525, -0.893227, -0.253332>, <-0.032142, -0.896579, -0.252745>, <-0.014264, -0.892324, -0.261126>, <0.000517, -0.892354, -0.261148>, 
      <-0.042657, -0.888790, -0.270223>, <-0.030734, -0.892522, -0.268752>, <-0.012063, -0.895312, -0.270213>, <0.000517, -0.895335, -0.270261>, 
      <-0.040204, -0.886336, -0.282831>, <-0.028280, -0.890068, -0.281360>, <-0.012063, -0.894543, -0.277077>, <0.000517, -0.894566, -0.277125>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.048658, -0.893250, -0.240399>, <0.034089, -0.896905, -0.239759>, <0.015551, -0.891959, -0.254277>, <0.000517, -0.891928, -0.254255>, 
      <0.045861, -0.892490, -0.182952>, <0.031293, -0.896144, -0.182312>, <0.015551, -0.889041, -0.207042>, <0.000517, -0.889010, -0.207020>, 
      <0.037237, -0.871772, -0.105551>, <0.019648, -0.874521, -0.102087>, <0.018653, -0.868465, -0.141627>, <0.000517, -0.868435, -0.141624>, 
      <0.037896, -0.883401, -0.049223>, <0.020307, -0.886150, -0.045759>, <0.018653, -0.883451, -0.096738>, <0.000517, -0.883421, -0.096735>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.048658, -0.893250, -0.240399>, <0.049290, -0.893422, -0.253375>, <0.050463, -0.888981, -0.270476>, <0.049285, -0.886498, -0.283175>, 
      <0.034089, -0.896905, -0.239759>, <0.034721, -0.897076, -0.252735>, <0.036316, -0.893442, -0.268696>, <0.035138, -0.890959, -0.281395>, 
      <0.015551, -0.891959, -0.254277>, <0.015551, -0.892385, -0.261171>, <0.015457, -0.895362, -0.270319>, <0.015457, -0.894593, -0.277182>, 
      <0.000517, -0.891928, -0.254255>, <0.000517, -0.892354, -0.261148>, <0.000517, -0.895335, -0.270261>, <0.000517, -0.894566, -0.277125>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.048658, -0.893250, -0.240399>, <0.075182, -0.886596, -0.241565>, <0.107371, -0.871870, -0.254508>, <0.131003, -0.859195, -0.259989>, 
      <0.049290, -0.893422, -0.253375>, <0.075814, -0.886768, -0.254541>, <0.109372, -0.871066, -0.264347>, <0.133005, -0.858392, -0.269829>, 
      <0.050463, -0.888981, -0.270476>, <0.074348, -0.881449, -0.273481>, <0.106341, -0.869490, -0.282840>, <0.128572, -0.857590, -0.283510>, 
      <0.049285, -0.886498, -0.283175>, <0.073170, -0.878966, -0.286180>, <0.104321, -0.866722, -0.292312>, <0.126552, -0.854822, -0.292982>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.202837, -0.810560, -0.276161>, <0.204123, -0.809595, -0.279650>, <0.201120, -0.807402, -0.284394>, <0.200035, -0.805804, -0.287715>, 
      <0.181644, -0.825444, -0.270669>, <0.182930, -0.824479, -0.274158>, <0.179365, -0.822587, -0.285314>, <0.178279, -0.820989, -0.288634>, 
      <0.153860, -0.846936, -0.265291>, <0.155862, -0.846133, -0.275131>, <0.151969, -0.845067, -0.284214>, <0.149948, -0.842298, -0.293687>, 
      <0.131003, -0.859195, -0.259989>, <0.133005, -0.858392, -0.269829>, <0.128572, -0.857590, -0.283510>, <0.126552, -0.854822, -0.292982>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.202837, -0.810560, -0.276161>, <0.204123, -0.809595, -0.279650>, <0.201120, -0.807402, -0.284394>, <0.200035, -0.805804, -0.287715>, 
      <0.214711, -0.802221, -0.279238>, <0.215997, -0.801257, -0.282727>, <0.210480, -0.800869, -0.283999>, <0.209395, -0.799271, -0.287320>, 
      <0.229648, -0.790462, -0.284818>, <0.226540, -0.791585, -0.284750>, <0.224149, -0.788226, -0.288123>, <0.221110, -0.789506, -0.288338>, 
      <0.241138, -0.781849, -0.288528>, <0.238030, -0.782972, -0.288460>, <0.233181, -0.781241, -0.288390>, <0.230142, -0.782521, -0.288605>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.225319, -0.709183, -0.613940>, <0.210271, -0.721539, -0.621910>, <0.191563, -0.739366, -0.633768>, <0.174246, -0.749422, -0.640220>, 
      <0.215268, -0.629583, -0.687347>, <0.200220, -0.641938, -0.695317>, <0.183296, -0.647764, -0.702297>, <0.165978, -0.657820, -0.708749>, 
      <0.169190, -0.430381, -0.639465>, <0.153947, -0.436487, -0.643284>, <0.133386, -0.448299, -0.643489>, <0.117108, -0.452001, -0.645841>, 
      <0.161040, -0.372179, -0.730963>, <0.145797, -0.378285, -0.734782>, <0.123570, -0.382587, -0.736983>, <0.107291, -0.386289, -0.739335>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.225319, -0.709183, -0.613940>, <0.233103, -0.770829, -0.557091>, <0.217271, -0.767199, -0.426349>, <0.213828, -0.790251, -0.345421>, 
      <0.210271, -0.721539, -0.621910>, <0.218055, -0.783185, -0.565061>, <0.199389, -0.773151, -0.450964>, <0.195946, -0.796204, -0.370036>, 
      <0.191563, -0.739366, -0.633768>, <0.196568, -0.794813, -0.592288>, <0.175317, -0.785410, -0.466477>, <0.168959, -0.805953, -0.400465>, 
      <0.174246, -0.749422, -0.640220>, <0.179251, -0.804869, -0.598739>, <0.152214, -0.793022, -0.485697>, <0.145856, -0.813566, -0.419685>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.237924, -0.709074, -0.613909>, <-0.245493, -0.770769, -0.557016>, <-0.229010, -0.767220, -0.426266>, <-0.223169, -0.790251, -0.345421>, 
      <-0.222321, -0.721978, -0.622218>, <-0.229890, -0.783673, -0.565325>, <-0.214274, -0.773170, -0.450790>, <-0.208433, -0.796201, -0.369945>, 
      <-0.201205, -0.739012, -0.633654>, <-0.206590, -0.794230, -0.592398>, <-0.190918, -0.785754, -0.467137>, <-0.186110, -0.806281, -0.401291>, 
      <-0.183020, -0.749264, -0.640226>, <-0.188404, -0.804482, -0.598970>, <-0.169410, -0.793039, -0.485531>, <-0.164602, -0.813566, -0.419685>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.237924, -0.709074, -0.613909>, <-0.228150, -0.629401, -0.687380>, <-0.180755, -0.430361, -0.639442>, <-0.171877, -0.372165, -0.730962>, 
      <-0.222321, -0.721978, -0.622218>, <-0.212547, -0.642305, -0.695689>, <-0.166706, -0.435813, -0.642885>, <-0.157829, -0.377617, -0.734405>, 
      <-0.201205, -0.739012, -0.633654>, <-0.192292, -0.647602, -0.701950>, <-0.146876, -0.448151, -0.643869>, <-0.137864, -0.382559, -0.737229>, 
      <-0.183020, -0.749264, -0.640226>, <-0.174107, -0.657855, -0.708522>, <-0.131902, -0.451375, -0.645943>, <-0.122890, -0.385783, -0.739302>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.237924, -0.709074, -0.613909>, <-0.254000, -0.695779, -0.605348>, <-0.273674, -0.676951, -0.592407>, <-0.288441, -0.662079, -0.584087>, 
      <-0.245493, -0.770769, -0.557016>, <-0.261569, -0.757474, -0.548455>, <-0.273666, -0.746914, -0.525889>, <-0.288433, -0.732042, -0.517569>, 
      <-0.229010, -0.767220, -0.426266>, <-0.238179, -0.763518, -0.411007>, <-0.257066, -0.755315, -0.395719>, <-0.263080, -0.752787, -0.378748>, 
      <-0.223169, -0.790251, -0.345421>, <-0.232337, -0.786549, -0.330162>, <-0.237202, -0.784351, -0.305821>, <-0.243216, -0.781823, -0.288849>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.237924, -0.709074, -0.613909>, <-0.228150, -0.629401, -0.687380>, <-0.180755, -0.430361, -0.639442>, <-0.171877, -0.372165, -0.730962>, 
      <-0.254000, -0.695779, -0.605348>, <-0.244226, -0.616105, -0.678820>, <-0.202971, -0.421739, -0.633998>, <-0.194094, -0.363543, -0.725518>, 
      <-0.273674, -0.676951, -0.592407>, <-0.273683, -0.600955, -0.664662>, <-0.230763, -0.403790, -0.627129>, <-0.223345, -0.351005, -0.717434>, 
      <-0.288441, -0.662079, -0.584087>, <-0.288450, -0.586082, -0.656342>, <-0.250685, -0.391854, -0.619498>, <-0.243267, -0.339069, -0.709803>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.138035, -0.855936, -0.106417>, <-0.152336, -0.841707, -0.158604>, <-0.183061, -0.824646, -0.224927>, <-0.200487, -0.810441, -0.276162>, 
      <-0.152754, -0.849284, -0.091061>, <-0.167055, -0.835055, -0.143248>, <-0.195472, -0.815349, -0.228395>, <-0.212899, -0.801144, -0.279630>, 
      <-0.169419, -0.838182, -0.063496>, <-0.163535, -0.844133, -0.142416>, <-0.214067, -0.814279, -0.211138>, <-0.230397, -0.790408, -0.285043>, 
      <-0.168496, -0.837411, -0.041242>, <-0.162612, -0.843362, -0.120162>, <-0.226886, -0.805693, -0.214944>, <-0.243216, -0.781823, -0.288849>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.138035, -0.855936, -0.106417>, <-0.152754, -0.849284, -0.091061>, <-0.169419, -0.838182, -0.063496>, <-0.168496, -0.837411, -0.041242>, 
      <-0.135623, -0.858336, -0.097613>, <-0.150341, -0.851685, -0.082257>, <-0.163837, -0.840206, -0.064770>, <-0.162914, -0.839435, -0.042516>, 
      <-0.144621, -0.861752, -0.086128>, <-0.151788, -0.857044, -0.081256>, <-0.164618, -0.848514, -0.058983>, <-0.163368, -0.848615, -0.049201>, 
      <-0.145980, -0.864673, -0.077256>, <-0.153147, -0.859964, -0.072385>, <-0.161717, -0.853818, -0.059556>, <-0.160467, -0.853920, -0.049774>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.141058, -0.876019, -0.045413>, <0.138939, -0.876173, -0.030463>, <0.131473, -0.869772, -0.011990>, <0.128581, -0.865499, 0.002201>, 
      <0.142482, -0.875915, -0.055459>, <0.140363, -0.876069, -0.040510>, <0.141866, -0.864495, -0.025541>, <0.138974, -0.860223, -0.011350>, 
      <0.141074, -0.867830, -0.067690>, <0.148066, -0.862842, -0.062579>, <0.154210, -0.854025, -0.041975>, <0.152807, -0.854127, -0.032080>, 
      <0.139841, -0.864680, -0.077257>, <0.146833, -0.859692, -0.072146>, <0.156717, -0.853843, -0.059671>, <0.155315, -0.853945, -0.049776>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.141058, -0.876019, -0.045413>, <0.142482, -0.875915, -0.055459>, <0.141074, -0.867830, -0.067690>, <0.139841, -0.864680, -0.077257>, 
      <0.141058, -0.876019, -0.045413>, <0.148289, -0.871046, -0.057995>, <0.148066, -0.862842, -0.062579>, <0.146833, -0.859692, -0.072146>, 
      <0.141058, -0.876019, -0.045413>, <0.148289, -0.871046, -0.057995>, <0.152893, -0.860819, -0.060425>, <0.156717, -0.853843, -0.059671>, 
      <0.141058, -0.876019, -0.045413>, <0.146865, -0.871150, -0.047949>, <0.151491, -0.860921, -0.050530>, <0.155315, -0.853945, -0.049776>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.141058, -0.876019, -0.045413>, <0.146865, -0.871150, -0.047949>, <0.151491, -0.860921, -0.050530>, <0.155315, -0.853945, -0.049776>, 
      <0.141058, -0.876019, -0.045413>, <0.144746, -0.871304, -0.032999>, <0.148983, -0.861104, -0.032833>, <0.152807, -0.854127, -0.032080>, 
      <0.141058, -0.876019, -0.045413>, <0.144746, -0.871304, -0.032999>, <0.141866, -0.864495, -0.025541>, <0.138974, -0.860223, -0.011350>, 
      <0.141058, -0.876019, -0.045413>, <0.138939, -0.876173, -0.030463>, <0.131473, -0.869772, -0.011990>, <0.128581, -0.865499, 0.002201>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.133196, -0.855936, -0.106417>, <0.149767, -0.841699, -0.158740>, <0.183852, -0.824799, -0.224665>, <0.202837, -0.810560, -0.276161>, 
      <0.148004, -0.849357, -0.091369>, <0.164575, -0.835120, -0.143692>, <0.195726, -0.816461, -0.227742>, <0.214711, -0.802221, -0.279238>, 
      <0.163613, -0.838175, -0.063298>, <0.158741, -0.844014, -0.142570>, <0.213519, -0.814386, -0.210592>, <0.229648, -0.790462, -0.284818>, 
      <0.162220, -0.837411, -0.041242>, <0.157348, -0.843250, -0.120514>, <0.225009, -0.805773, -0.214303>, <0.241138, -0.781849, -0.288528>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.133196, -0.855936, -0.106417>, <0.130464, -0.858283, -0.097791>, <0.138705, -0.861779, -0.086070>, <0.139841, -0.864680, -0.077257>, 
      <0.148004, -0.849357, -0.091369>, <0.145272, -0.851704, -0.082743>, <0.145698, -0.856791, -0.080960>, <0.146833, -0.859692, -0.072146>, 
      <0.163613, -0.838175, -0.063298>, <0.158174, -0.840226, -0.064588>, <0.159566, -0.848645, -0.059110>, <0.156717, -0.853843, -0.059671>, 
      <0.162220, -0.837411, -0.041242>, <0.156781, -0.839461, -0.042532>, <0.158164, -0.848747, -0.049215>, <0.155315, -0.853945, -0.049776>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.352649, -0.593532, -0.549270>, <-0.334762, -0.614872, -0.560569>, <-0.308120, -0.642260, -0.572999>, <-0.288441, -0.662079, -0.584087>, 
      <-0.347884, -0.518363, -0.613936>, <-0.329997, -0.539704, -0.625235>, <-0.308129, -0.566263, -0.645254>, <-0.288450, -0.586082, -0.656342>, 
      <-0.309902, -0.340232, -0.593569>, <-0.295017, -0.355736, -0.603482>, <-0.269974, -0.380298, -0.612110>, <-0.250685, -0.391854, -0.619498>, 
      <-0.301686, -0.294394, -0.681239>, <-0.286800, -0.309897, -0.691152>, <-0.262556, -0.327513, -0.702414>, <-0.243267, -0.339069, -0.709803>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.677951, -0.194697, 0.458256>, <-0.679664, -0.135888, 0.496637>, <-0.673951, -0.044485, 0.528023>, <-0.671937, 0.024754, 0.539703>, 
      <-0.683603, -0.101230, 0.425490>, <-0.685316, -0.042421, 0.463872>, <-0.672769, -0.003841, 0.534879>, <-0.670755, 0.065399, 0.546559>, 
      <-0.674563, 0.036440, 0.446151>, <-0.673458, 0.043119, 0.469587>, <-0.668207, 0.110543, 0.502040>, <-0.668916, 0.119735, 0.524626>, 
      <-0.673111, 0.135499, 0.440963>, <-0.672007, 0.142178, 0.464400>, <-0.666912, 0.151249, 0.495578>, <-0.667621, 0.160441, 0.518164>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.668869, -0.194697, 0.458256>, <0.674260, -0.101222, 0.425488>, <0.666668, 0.036440, 0.446151>, <0.665725, 0.135499, 0.440963>, 
      <0.670848, -0.136016, 0.496572>, <0.676239, -0.042541, 0.463804>, <0.665975, 0.043108, 0.469549>, <0.665032, 0.142167, 0.464361>, 
      <0.667884, -0.044775, 0.528015>, <0.667556, -0.004018, 0.534891>, <0.665210, 0.110452, 0.502101>, <0.664813, 0.151277, 0.495647>, 
      <0.667327, 0.024357, 0.539677>, <0.666998, 0.065114, 0.546552>, <0.666402, 0.119616, 0.524618>, <0.666006, 0.160441, 0.518164>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.352307, -0.779682, -0.003063>, <0.297234, -0.801177, -0.016775>, <0.217659, -0.816511, -0.028096>, <0.162220, -0.837411, -0.041242>, 
      <0.339194, -0.784233, -0.089137>, <0.284121, -0.805728, -0.102849>, <0.212787, -0.822350, -0.107368>, <0.157348, -0.843250, -0.120514>, 
      <0.326276, -0.776528, -0.208152>, <0.303440, -0.790749, -0.210046>, <0.250367, -0.796610, -0.214855>, <0.225009, -0.805773, -0.214303>, 
      <0.324554, -0.748408, -0.290661>, <0.301718, -0.762629, -0.292556>, <0.266496, -0.772687, -0.289080>, <0.241138, -0.781849, -0.288528>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.330468, -0.748408, -0.290661>, <-0.306515, -0.762841, -0.292625>, <-0.269665, -0.772546, -0.289439>, <-0.243216, -0.781823, -0.288849>, 
      <-0.328497, -0.719164, -0.376469>, <-0.304544, -0.733598, -0.378434>, <-0.289529, -0.743510, -0.379337>, <-0.263080, -0.752787, -0.378748>, 
      <-0.357002, -0.662193, -0.490203>, <-0.339115, -0.683533, -0.501502>, <-0.308112, -0.712222, -0.506481>, <-0.288433, -0.732042, -0.517569>, 
      <-0.352649, -0.593532, -0.549270>, <-0.334762, -0.614872, -0.560569>, <-0.308120, -0.642260, -0.572999>, <-0.288441, -0.662079, -0.584087>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.365195, -0.779682, -0.003063>, <-0.308690, -0.802311, -0.017497>, <-0.225997, -0.816560, -0.028123>, <-0.168496, -0.837411, -0.041242>, 
      <-0.352781, -0.784331, -0.089463>, <-0.296276, -0.806960, -0.103898>, <-0.220113, -0.822511, -0.107043>, <-0.162612, -0.843362, -0.120162>, 
      <-0.332368, -0.776599, -0.207942>, <-0.308415, -0.791032, -0.209907>, <-0.253335, -0.796417, -0.215534>, <-0.226886, -0.805693, -0.214944>, 
      <-0.330468, -0.748408, -0.290661>, <-0.306515, -0.762841, -0.292625>, <-0.269665, -0.772546, -0.289439>, <-0.243216, -0.781823, -0.288849>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.043502, -0.883268, -0.049212>, <-0.044076, -0.886280, -0.034641>, <-0.050386, -0.917407, -0.072724>, <-0.053631, -0.929389, -0.064501>, 
      <-0.024562, -0.886012, -0.045834>, <-0.025136, -0.889024, -0.031263>, <-0.035090, -0.927229, -0.069080>, <-0.038335, -0.939210, -0.060857>, 
      <-0.018916, -0.883389, -0.096732>, <-0.018916, -0.891450, -0.072587>, <-0.018022, -0.941202, -0.075429>, <-0.018022, -0.957986, -0.056290>, 
      <0.000517, -0.883421, -0.096735>, <0.000517, -0.891482, -0.072589>, <0.000517, -0.941232, -0.075432>, <0.000517, -0.958016, -0.056293>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.043502, -0.883268, -0.049212>, <-0.024562, -0.886012, -0.045834>, <-0.018916, -0.883389, -0.096732>, <0.000517, -0.883421, -0.096735>, 
      <-0.041290, -0.871657, -0.105379>, <-0.022351, -0.874401, -0.102001>, <-0.018916, -0.868403, -0.141622>, <0.000517, -0.868435, -0.141624>, 
      <-0.047520, -0.892301, -0.182872>, <-0.033136, -0.895654, -0.182284>, <-0.014264, -0.888980, -0.206998>, <0.000517, -0.889010, -0.207020>, 
      <-0.046710, -0.893055, -0.240258>, <-0.032326, -0.896408, -0.239671>, <-0.014264, -0.891898, -0.254233>, <0.000517, -0.891928, -0.254255>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.091931, -0.907094, -0.022097>, <0.104972, -0.895349, -0.028809>, <0.127404, -0.887468, -0.039451>, <0.141058, -0.876019, -0.045413>, 
      <0.086123, -0.908473, 0.001011>, <0.099164, -0.896728, -0.005701>, <0.125286, -0.887622, -0.024501>, <0.138939, -0.876173, -0.030463>, 
      <0.078404, -0.900891, 0.031869>, <0.093934, -0.890841, 0.016431>, <0.117463, -0.876885, 0.006276>, <0.131473, -0.869772, -0.011990>, 
      <0.075203, -0.894616, 0.054673>, <0.090733, -0.884566, 0.039234>, <0.114571, -0.872612, 0.020467>, <0.128581, -0.865499, 0.002201>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.091931, -0.907094, -0.022097>, <0.096807, -0.905937, -0.041498>, <0.110158, -0.893974, -0.064484>, <0.109815, -0.886400, -0.083032>, 
      <0.104972, -0.895349, -0.028809>, <0.109848, -0.894192, -0.048210>, <0.119194, -0.887396, -0.065776>, <0.118852, -0.879822, -0.084324>, 
      <0.127404, -0.887468, -0.039451>, <0.128828, -0.887364, -0.049497>, <0.133202, -0.873445, -0.073444>, <0.131969, -0.870295, -0.083011>, 
      <0.141058, -0.876019, -0.045413>, <0.142482, -0.875915, -0.055459>, <0.141074, -0.867830, -0.067690>, <0.139841, -0.864680, -0.077257>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.355611, 0.462296, 1.090388>, <-0.390686, 0.452966, 1.070550>, <-0.433891, 0.437125, 1.038279>, <-0.460369, 0.422607, 1.010012>, 
      <-0.356708, 0.582608, 1.018007>, <-0.391784, 0.573279, 0.998169>, <-0.432209, 0.554077, 0.964799>, <-0.458688, 0.539559, 0.936533>, 
      <-0.338017, 0.706603, 0.859554>, <-0.377228, 0.692868, 0.838243>, <-0.433562, 0.679350, 0.802613>, <-0.461941, 0.654402, 0.775180>, 
      <-0.337234, 0.759978, 0.729686>, <-0.376445, 0.746243, 0.708375>, <-0.429226, 0.730912, 0.674541>, <-0.457605, 0.705964, 0.647108>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.132050, -0.850936, 0.037892>, <-0.130736, -0.855671, 0.027362>, <-0.133815, -0.862200, 0.013159>, <-0.135831, -0.865499, 0.002201>, 
      <-0.145421, -0.845376, 0.015758>, <-0.144107, -0.850111, 0.005228>, <-0.143765, -0.856930, -0.000371>, <-0.145781, -0.860229, -0.011328>, 
      <-0.167401, -0.836496, -0.014830>, <-0.161818, -0.838520, -0.016104>, <-0.161138, -0.848797, -0.031742>, <-0.158237, -0.854101, -0.032315>, 
      <-0.168496, -0.837411, -0.041242>, <-0.162914, -0.839435, -0.042516>, <-0.163368, -0.848615, -0.049201>, <-0.160467, -0.853920, -0.049774>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.082473, -0.873179, 0.101158>, <-0.080659, -0.880963, 0.088042>, <-0.082666, -0.890547, 0.069455>, <-0.083650, -0.894607, 0.054674>, 
      <-0.096729, -0.864354, 0.082588>, <-0.094915, -0.872138, 0.069471>, <-0.098010, -0.880581, 0.054146>, <-0.098994, -0.884642, 0.039365>, 
      <-0.119402, -0.856195, 0.058829>, <-0.118089, -0.860930, 0.048299>, <-0.120329, -0.869343, 0.031495>, <-0.122345, -0.872642, 0.020538>, 
      <-0.132050, -0.850936, 0.037892>, <-0.130736, -0.855671, 0.027362>, <-0.133815, -0.862200, 0.013159>, <-0.135831, -0.865499, 0.002201>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.044655, -0.905039, 0.151737>, <-0.033770, -0.911552, 0.160806>, <-0.015076, -0.922832, 0.170299>, <0.000517, -0.922832, 0.170299>, 
      <-0.045746, -0.890091, 0.217683>, <-0.034860, -0.896604, 0.226752>, <-0.015076, -0.906284, 0.238610>, <0.000517, -0.906284, 0.238610>, 
      <-0.039919, -0.875083, 0.307625>, <-0.028914, -0.887666, 0.313989>, <-0.017371, -0.891286, 0.331450>, <0.000517, -0.891315, 0.331447>, 
      <-0.051480, -0.859515, 0.372413>, <-0.040474, -0.872098, 0.378777>, <-0.017371, -0.871654, 0.398939>, <0.000517, -0.871683, 0.398936>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.044655, -0.905039, 0.151737>, <-0.044348, -0.909247, 0.133172>, <-0.044715, -0.917576, 0.109033>, <-0.046826, -0.923303, 0.090999>, 
      <-0.033770, -0.911552, 0.160806>, <-0.033463, -0.915760, 0.142241>, <-0.032410, -0.924479, 0.117030>, <-0.034522, -0.930206, 0.098996>, 
      <-0.015076, -0.922832, 0.170299>, <-0.015076, -0.927339, 0.151693>, <-0.015701, -0.935846, 0.127565>, <-0.015701, -0.941827, 0.109379>, 
      <0.000517, -0.922832, 0.170299>, <0.000517, -0.927339, 0.151693>, <0.000517, -0.935846, 0.127565>, <0.000517, -0.941827, 0.109379>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.044655, -0.905039, 0.151737>, <-0.045746, -0.890091, 0.217683>, <-0.039919, -0.875083, 0.307625>, <-0.051480, -0.859515, 0.372413>, 
      <-0.059469, -0.896176, 0.139395>, <-0.060559, -0.881228, 0.205342>, <-0.067947, -0.843037, 0.291418>, <-0.079508, -0.827469, 0.356206>, 
      <-0.070382, -0.880664, 0.116909>, <-0.079956, -0.839577, 0.186142>, <-0.056674, -0.760518, 0.238920>, <-0.080725, -0.747691, 0.315275>, 
      <-0.082473, -0.873179, 0.101158>, <-0.092047, -0.832092, 0.170392>, <-0.097451, -0.745002, 0.252024>, <-0.121501, -0.732175, 0.328379>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.044655, -0.905039, 0.151737>, <-0.059469, -0.896176, 0.139395>, <-0.070382, -0.880664, 0.116909>, <-0.082473, -0.873179, 0.101158>, 
      <-0.044348, -0.909247, 0.133172>, <-0.059162, -0.900384, 0.120830>, <-0.068568, -0.888448, 0.103792>, <-0.080659, -0.880963, 0.088042>, 
      <-0.044715, -0.917576, 0.109033>, <-0.058178, -0.910022, 0.100282>, <-0.071252, -0.897960, 0.080842>, <-0.082666, -0.890547, 0.069455>, 
      <-0.046826, -0.923303, 0.090999>, <-0.060290, -0.915749, 0.082248>, <-0.072236, -0.902020, 0.066061>, <-0.083650, -0.894607, 0.054674>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.588565, 0.539033, 0.486731>, <-0.594700, 0.504232, 0.603163>, <-0.594439, 0.430623, 0.764929>, <-0.594951, 0.331069, 0.834885>, 
      <-0.623896, 0.462172, 0.412946>, <-0.630031, 0.427371, 0.529378>, <-0.629748, 0.395055, 0.699633>, <-0.630261, 0.295501, 0.769589>, 
      <-0.644313, 0.359383, 0.303257>, <-0.659493, 0.346563, 0.416179>, <-0.660786, 0.306584, 0.583734>, <-0.662022, 0.241326, 0.678000>, 
      <-0.656388, 0.273520, 0.231970>, <-0.671568, 0.260700, 0.344892>, <-0.677084, 0.268317, 0.512703>, <-0.678320, 0.203059, 0.606969>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.588565, 0.539033, 0.486731>, <-0.594700, 0.504232, 0.603163>, <-0.594439, 0.430623, 0.764929>, <-0.594951, 0.331069, 0.834885>, 
      <-0.563451, 0.593667, 0.539179>, <-0.569587, 0.558866, 0.655610>, <-0.563671, 0.461616, 0.821826>, <-0.564183, 0.362062, 0.891782>, 
      <-0.506098, 0.663334, 0.600231>, <-0.510434, 0.611772, 0.728303>, <-0.504603, 0.514385, 0.887517>, <-0.506284, 0.397432, 0.960996>, 
      <-0.457605, 0.705964, 0.647108>, <-0.461941, 0.654402, 0.775180>, <-0.458688, 0.539559, 0.936533>, <-0.460369, 0.422607, 1.010012>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.417975, -0.507535, -0.502258>, <-0.399266, -0.532356, -0.519065>, <-0.373682, -0.568439, -0.535983>, <-0.352649, -0.593532, -0.549270>, 
      <-0.407413, -0.430377, -0.561720>, <-0.388704, -0.455198, -0.578526>, <-0.368916, -0.493270, -0.600649>, <-0.347884, -0.518363, -0.613936>, 
      <-0.374135, -0.253058, -0.539581>, <-0.356849, -0.280248, -0.555235>, <-0.332431, -0.316769, -0.578567>, <-0.309902, -0.340232, -0.593569>, 
      <-0.367014, -0.210187, -0.627398>, <-0.349728, -0.237377, -0.643053>, <-0.324215, -0.270930, -0.666237>, <-0.301686, -0.294394, -0.681239>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.090679, -0.907037, -0.022092>, <-0.086030, -0.908463, 0.000822>, <-0.085151, -0.900799, 0.032132>, <-0.083650, -0.894607, 0.054674>, 
      <-0.104873, -0.894069, -0.029525>, <-0.100224, -0.895495, -0.006610>, <-0.100495, -0.890834, 0.016824>, <-0.098994, -0.884642, 0.039365>, 
      <-0.131738, -0.887924, -0.039209>, <-0.129834, -0.888079, -0.024297>, <-0.124954, -0.876911, 0.006361>, <-0.122345, -0.872642, 0.020538>, 
      <-0.147380, -0.876019, -0.045413>, <-0.145475, -0.876174, -0.030502>, <-0.138440, -0.869768, -0.011976>, <-0.135831, -0.865499, 0.002201>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.090679, -0.907037, -0.022092>, <-0.094712, -0.905800, -0.041969>, <-0.110016, -0.893742, -0.064263>, <-0.111583, -0.886037, -0.083000>, 
      <-0.104873, -0.894069, -0.029525>, <-0.108906, -0.892831, -0.049402>, <-0.120000, -0.886745, -0.065642>, <-0.121567, -0.879041, -0.084379>, 
      <-0.131738, -0.887924, -0.039209>, <-0.133024, -0.887819, -0.049276>, <-0.138526, -0.873672, -0.073776>, <-0.137064, -0.870531, -0.083316>, 
      <-0.147380, -0.876019, -0.045413>, <-0.148666, -0.875914, -0.055481>, <-0.147442, -0.867814, -0.067716>, <-0.145980, -0.864673, -0.077256>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.062536, -0.953539, -0.000984>, <-0.061250, -0.952389, 0.028393>, <-0.050090, -0.932155, 0.063125>, <-0.046826, -0.923303, 0.090999>, 
      <-0.076010, -0.943358, -0.005545>, <-0.074724, -0.942208, 0.023832>, <-0.063553, -0.924601, 0.054374>, <-0.060290, -0.915749, 0.082248>, 
      <-0.078634, -0.918043, -0.015784>, <-0.073984, -0.919469, 0.007130>, <-0.073737, -0.908212, 0.043520>, <-0.072236, -0.902020, 0.066061>, 
      <-0.090679, -0.907037, -0.022092>, <-0.086030, -0.908463, 0.000822>, <-0.085151, -0.900799, 0.032132>, <-0.083650, -0.894607, 0.054674>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.062536, -0.953539, -0.000984>, <-0.063434, -0.954342, -0.021509>, <-0.058112, -0.945933, -0.053146>, <-0.053631, -0.929389, -0.064501>, 
      <-0.076010, -0.943358, -0.005545>, <-0.076908, -0.944161, -0.026070>, <-0.076602, -0.934061, -0.057551>, <-0.072120, -0.917517, -0.068906>, 
      <-0.078634, -0.918043, -0.015784>, <-0.082667, -0.916805, -0.035662>, <-0.091780, -0.906521, -0.061744>, <-0.093347, -0.898816, -0.080481>, 
      <-0.090679, -0.907037, -0.022092>, <-0.094712, -0.905800, -0.041969>, <-0.110016, -0.893742, -0.064263>, <-0.111583, -0.886037, -0.083000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000517, -0.975950, 0.008779>, <0.000517, -0.972851, 0.040497>, <0.000517, -0.951783, 0.079105>, <0.000517, -0.941827, 0.109379>, 
      <-0.019771, -0.975917, 0.008782>, <-0.019771, -0.972817, 0.040500>, <-0.015701, -0.951783, 0.079105>, <-0.015701, -0.941827, 0.109379>, 
      <-0.046910, -0.965347, 0.004306>, <-0.045624, -0.964197, 0.033682>, <-0.037785, -0.939058, 0.071122>, <-0.034522, -0.930206, 0.098996>, 
      <-0.062536, -0.953539, -0.000984>, <-0.061250, -0.952389, 0.028393>, <-0.050090, -0.932155, 0.063125>, <-0.046826, -0.923303, 0.090999>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000517, -0.975950, 0.008779>, <-0.019771, -0.975917, 0.008782>, <-0.046910, -0.965347, 0.004306>, <-0.062536, -0.953539, -0.000984>, 
      <0.000517, -0.977919, -0.011374>, <-0.019771, -0.977886, -0.011372>, <-0.047808, -0.966150, -0.016219>, <-0.063434, -0.954342, -0.021509>, 
      <0.000517, -0.971367, -0.041068>, <-0.018022, -0.971337, -0.041065>, <-0.042817, -0.955755, -0.049502>, <-0.058112, -0.945933, -0.053146>, 
      <0.000517, -0.958016, -0.056293>, <-0.018022, -0.957986, -0.056290>, <-0.038335, -0.939210, -0.060857>, <-0.053631, -0.929389, -0.064501>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.662598, -0.054363, 0.705599>, <-0.667774, 0.028306, 0.706503>, <-0.679213, 0.155912, 0.675073>, <-0.678320, 0.203059, 0.606969>, 
      <-0.673147, -0.038444, 0.653797>, <-0.678323, 0.044225, 0.654701>, <-0.685098, 0.142094, 0.649422>, <-0.684205, 0.189240, 0.581319>, 
      <-0.669135, 0.001019, 0.589472>, <-0.667953, 0.041664, 0.596328>, <-0.669779, 0.130935, 0.552146>, <-0.668485, 0.171641, 0.545684>, 
      <-0.671937, 0.024754, 0.539703>, <-0.670755, 0.065399, 0.546559>, <-0.668916, 0.119735, 0.524626>, <-0.667621, 0.160441, 0.518164>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.586542, -0.049039, -0.242370>, <-0.563115, -0.003191, -0.313135>, <-0.497817, 0.043375, -0.410187>, <-0.485397, 0.052883, -0.496291>, 
      <-0.596120, 0.007131, -0.204464>, <-0.572692, 0.052979, -0.275229>, <-0.504407, 0.077570, -0.397170>, <-0.491988, 0.087078, -0.483274>, 
      <-0.593993, 0.053520, -0.118922>, <-0.562331, 0.069969, -0.233841>, <-0.509835, 0.128724, -0.350110>, <-0.495012, 0.135024, -0.469358>, 
      <-0.596005, 0.106883, -0.076120>, <-0.564343, 0.123332, -0.191039>, <-0.509158, 0.164377, -0.339593>, <-0.494335, 0.170677, -0.458841>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.586542, -0.049039, -0.242370>, <-0.596120, 0.007131, -0.204464>, <-0.593993, 0.053520, -0.118922>, <-0.596005, 0.106883, -0.076120>, 
      <-0.605931, -0.086983, -0.183804>, <-0.615508, -0.030813, -0.145898>, <-0.609622, 0.045401, -0.062198>, <-0.611634, 0.098764, -0.019396>, 
      <-0.614758, -0.181021, -0.136291>, <-0.630300, -0.086450, -0.084838>, <-0.629012, -0.000432, -0.001120>, <-0.637190, 0.092088, 0.055499>, 
      <-0.624614, -0.219568, -0.075771>, <-0.640155, -0.124997, -0.024319>, <-0.643697, -0.003688, 0.056339>, <-0.651876, 0.088832, 0.112958>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.308122, -0.768745, 0.390475>, <-0.302710, -0.754985, 0.378003>, <-0.301536, -0.727194, 0.406825>, <-0.298714, -0.709387, 0.413832>, 
      <-0.240222, -0.777008, 0.385165>, <-0.234809, -0.763249, 0.372693>, <-0.240656, -0.730575, 0.402452>, <-0.237833, -0.712768, 0.409459>, 
      <-0.194810, -0.742172, 0.346444>, <-0.202630, -0.737796, 0.346486>, <-0.199571, -0.715139, 0.353867>, <-0.205258, -0.708221, 0.354179>, 
      <-0.146247, -0.730783, 0.327574>, <-0.154068, -0.726407, 0.327616>, <-0.159518, -0.714640, 0.328301>, <-0.165206, -0.707721, 0.328613>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.491248, -0.688797, 0.354552>, <-0.485777, -0.690549, 0.354119>, <-0.478146, -0.690097, 0.351846>, <-0.472531, -0.690654, 0.350686>, 
      <-0.436310, -0.712781, 0.365329>, <-0.430840, -0.714534, 0.364896>, <-0.426001, -0.695717, 0.370790>, <-0.420386, -0.696274, 0.369630>, 
      <-0.385668, -0.759308, 0.396539>, <-0.380256, -0.745548, 0.384067>, <-0.372980, -0.723227, 0.411956>, <-0.370158, -0.705419, 0.418963>, 
      <-0.308122, -0.768745, 0.390475>, <-0.302710, -0.754985, 0.378003>, <-0.301536, -0.727194, 0.406825>, <-0.298714, -0.709387, 0.413832>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.491248, -0.688797, 0.354552>, <-0.485777, -0.690549, 0.354119>, <-0.478146, -0.690097, 0.351846>, <-0.472531, -0.690654, 0.350686>, 
      <-0.470585, -0.698590, 0.343631>, <-0.465115, -0.700342, 0.343198>, <-0.463075, -0.689785, 0.345487>, <-0.457460, -0.690342, 0.344327>, 
      <-0.445810, -0.713480, 0.323576>, <-0.447520, -0.709034, 0.332523>, <-0.438200, -0.696495, 0.328972>, <-0.438176, -0.686947, 0.332374>, 
      <-0.422373, -0.721441, 0.318149>, <-0.424083, -0.716995, 0.327097>, <-0.422317, -0.699161, 0.326088>, <-0.422293, -0.689613, 0.329490>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.491248, -0.688797, 0.354552>, <-0.502220, -0.685283, 0.355420>, <-0.515943, -0.677990, 0.354836>, <-0.526527, -0.673359, 0.354958>, 
      <-0.470585, -0.698590, 0.343631>, <-0.481557, -0.695076, 0.344499>, <-0.483694, -0.708573, 0.350669>, <-0.494278, -0.703942, 0.350791>, 
      <-0.445810, -0.713480, 0.323576>, <-0.443407, -0.719726, 0.311006>, <-0.453199, -0.704583, 0.303710>, <-0.450742, -0.707085, 0.289908>, 
      <-0.422373, -0.721441, 0.318149>, <-0.419970, -0.727687, 0.305579>, <-0.413781, -0.715625, 0.285907>, <-0.411324, -0.718127, 0.272105>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.281475, -0.760049, 0.305981>, <-0.325179, -0.755857, 0.303418>, <-0.381696, -0.735257, 0.308731>, <-0.422373, -0.721441, 0.318149>, 
      <-0.281265, -0.757068, 0.317196>, <-0.324969, -0.752877, 0.314634>, <-0.383407, -0.730811, 0.317678>, <-0.424083, -0.716995, 0.327097>, 
      <-0.281623, -0.733897, 0.313016>, <-0.324897, -0.729523, 0.311506>, <-0.380068, -0.706253, 0.318416>, <-0.422317, -0.699161, 0.326088>, 
      <-0.281686, -0.722689, 0.316031>, <-0.324960, -0.718315, 0.314521>, <-0.380044, -0.696705, 0.321818>, <-0.422293, -0.689613, 0.329490>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.192925, -0.743448, 0.331604>, <-0.227834, -0.751003, 0.326030>, <-0.253551, -0.762727, 0.307619>, <-0.281475, -0.760049, 0.305981>, 
      <-0.197361, -0.739495, 0.339447>, <-0.232269, -0.747050, 0.333873>, <-0.253341, -0.759747, 0.318834>, <-0.281265, -0.757068, 0.317196>, 
      <-0.198213, -0.721457, 0.335543>, <-0.230413, -0.725595, 0.332065>, <-0.256386, -0.736448, 0.313897>, <-0.281623, -0.733897, 0.313016>, 
      <-0.200479, -0.712033, 0.337231>, <-0.232680, -0.716171, 0.333753>, <-0.256449, -0.725240, 0.316912>, <-0.281686, -0.722689, 0.316031>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.192925, -0.743448, 0.331604>, <-0.197361, -0.739495, 0.339447>, <-0.198213, -0.721457, 0.335543>, <-0.200479, -0.712033, 0.337231>, 
      <-0.174837, -0.739533, 0.334492>, <-0.179273, -0.735581, 0.342335>, <-0.184296, -0.719669, 0.337046>, <-0.186562, -0.710245, 0.338734>, 
      <-0.160250, -0.734583, 0.328783>, <-0.168071, -0.730207, 0.328825>, <-0.170100, -0.715933, 0.330887>, <-0.175788, -0.709015, 0.331198>, 
      <-0.146247, -0.730783, 0.327574>, <-0.154068, -0.726407, 0.327616>, <-0.159518, -0.714640, 0.328301>, <-0.165206, -0.707721, 0.328613>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.171160, -0.738158, 0.285392>, <-0.153603, -0.737137, 0.294458>, <-0.131451, -0.735120, 0.311533>, <-0.121501, -0.732175, 0.328379>, 
      <-0.155411, -0.765967, 0.209405>, <-0.137854, -0.764945, 0.218470>, <-0.107400, -0.747947, 0.235177>, <-0.097451, -0.745002, 0.252024>, 
      <-0.141369, -0.817345, 0.112593>, <-0.128721, -0.822604, 0.133530>, <-0.106303, -0.823267, 0.151821>, <-0.092047, -0.832092, 0.170392>, 
      <-0.132050, -0.850936, 0.037892>, <-0.119402, -0.856195, 0.058829>, <-0.096729, -0.864354, 0.082588>, <-0.082473, -0.873179, 0.101158>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.171160, -0.738158, 0.285392>, <-0.174103, -0.732961, 0.299593>, <-0.185979, -0.749637, 0.319324>, <-0.192925, -0.743448, 0.331604>, 
      <-0.153603, -0.737137, 0.294458>, <-0.156547, -0.731939, 0.308659>, <-0.167891, -0.745722, 0.322212>, <-0.174837, -0.739533, 0.334492>, 
      <-0.131451, -0.735120, 0.311533>, <-0.127710, -0.734013, 0.317867>, <-0.153758, -0.738215, 0.328748>, <-0.160250, -0.734583, 0.328783>, 
      <-0.121501, -0.732175, 0.328379>, <-0.117760, -0.731068, 0.334713>, <-0.139755, -0.734416, 0.327539>, <-0.146247, -0.730783, 0.327574>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.283018, -0.741572, 0.244978>, <-0.322786, -0.738255, 0.242778>, <-0.376032, -0.728013, 0.256166>, <-0.411324, -0.718127, 0.272105>, 
      <-0.288808, -0.737607, 0.262772>, <-0.328576, -0.734291, 0.260572>, <-0.378489, -0.725511, 0.269967>, <-0.413781, -0.715625, 0.285907>, 
      <-0.281822, -0.764961, 0.287498>, <-0.325526, -0.760769, 0.284935>, <-0.379294, -0.741503, 0.296161>, <-0.419970, -0.727687, 0.305579>, 
      <-0.281475, -0.760049, 0.305981>, <-0.325179, -0.755857, 0.303418>, <-0.381696, -0.735257, 0.308731>, <-0.422373, -0.721441, 0.318149>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.283018, -0.741572, 0.244978>, <-0.253702, -0.761646, 0.154880>, <-0.175677, -0.830149, 0.055068>, <-0.168496, -0.837411, -0.041242>, 
      <-0.322786, -0.738255, 0.242778>, <-0.293470, -0.758329, 0.152680>, <-0.233178, -0.809298, 0.068188>, <-0.225997, -0.816560, -0.028123>, 
      <-0.376032, -0.728013, 0.256166>, <-0.361244, -0.743076, 0.173090>, <-0.320862, -0.797752, 0.067226>, <-0.308690, -0.802311, -0.017497>, 
      <-0.411324, -0.718127, 0.272105>, <-0.396536, -0.733190, 0.189030>, <-0.377368, -0.775123, 0.081661>, <-0.365195, -0.779682, -0.003063>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.283018, -0.741572, 0.244978>, <-0.288808, -0.737607, 0.262772>, <-0.281822, -0.764961, 0.287498>, <-0.281475, -0.760049, 0.305981>, 
      <-0.247500, -0.744534, 0.246943>, <-0.253290, -0.740570, 0.264737>, <-0.253898, -0.767639, 0.289136>, <-0.253551, -0.762727, 0.307619>, 
      <-0.202834, -0.740001, 0.269037>, <-0.205778, -0.734804, 0.283238>, <-0.220888, -0.757192, 0.313749>, <-0.227834, -0.751003, 0.326030>, 
      <-0.171160, -0.738158, 0.285392>, <-0.174103, -0.732961, 0.299593>, <-0.185979, -0.749637, 0.319324>, <-0.192925, -0.743448, 0.331604>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.283018, -0.741572, 0.244978>, <-0.247500, -0.744534, 0.246943>, <-0.202834, -0.740001, 0.269037>, <-0.171160, -0.738158, 0.285392>, 
      <-0.253702, -0.761646, 0.154880>, <-0.218184, -0.764608, 0.156845>, <-0.187085, -0.767809, 0.193049>, <-0.155411, -0.765967, 0.209405>, 
      <-0.175677, -0.830149, 0.055068>, <-0.174582, -0.829234, 0.081480>, <-0.154740, -0.811786, 0.090459>, <-0.141369, -0.817345, 0.112593>, 
      <-0.168496, -0.837411, -0.041242>, <-0.167401, -0.836496, -0.014830>, <-0.145421, -0.845376, 0.015758>, <-0.132050, -0.850936, 0.037892>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.225283, 0.846401, 0.281739>, <-0.206667, 0.825362, 0.080913>, <-0.119489, 0.702567, -0.160073>, <-0.101969, 0.673699, -0.360023>, 
      <-0.158565, 0.859942, 0.291787>, <-0.139948, 0.838903, 0.090962>, <-0.089429, 0.710570, -0.161012>, <-0.071909, 0.681702, -0.360961>, 
      <-0.068294, 0.877440, 0.308512>, <-0.068294, 0.854655, 0.100107>, <-0.030604, 0.720679, -0.157352>, <-0.030604, 0.689090, -0.364606>, 
      <0.000517, 0.876606, 0.308590>, <0.000517, 0.853821, 0.100185>, <0.000517, 0.720679, -0.157352>, <0.000517, 0.689090, -0.364606>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.225283, 0.846401, 0.281739>, <-0.239169, 0.862094, 0.431531>, <-0.211637, 0.850318, 0.642721>, <-0.207910, 0.793428, 0.782815>, 
      <-0.158565, 0.859942, 0.291787>, <-0.172450, 0.875635, 0.441579>, <-0.150671, 0.860961, 0.659575>, <-0.146945, 0.804070, 0.799669>, 
      <-0.068294, 0.877440, 0.308512>, <-0.068294, 0.894319, 0.462898>, <-0.063624, 0.879506, 0.680047>, <-0.063624, 0.818937, 0.823055>, 
      <0.000517, 0.876606, 0.308590>, <0.000517, 0.893485, 0.462976>, <0.000517, 0.879506, 0.680047>, <0.000517, 0.818937, 0.823055>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.202024, 0.491323, 1.156127>, <-0.250959, 0.485169, 1.143667>, <-0.312473, 0.473770, 1.114786>, <-0.355611, 0.462296, 1.090388>, 
      <-0.204983, 0.616506, 1.084852>, <-0.253918, 0.610352, 1.072392>, <-0.313570, 0.594082, 1.042405>, <-0.356708, 0.582608, 1.018007>, 
      <-0.204360, 0.739234, 0.916270>, <-0.245352, 0.732078, 0.904938>, <-0.301800, 0.719289, 0.879237>, <-0.338017, 0.706603, 0.859554>, 
      <-0.207910, 0.793428, 0.782815>, <-0.248902, 0.786272, 0.771483>, <-0.301018, 0.772664, 0.749369>, <-0.337234, 0.759978, 0.729686>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.202024, 0.491323, 1.156127>, <-0.142956, 0.498752, 1.171166>, <-0.060886, 0.507086, 1.181063>, <0.000517, 0.507086, 1.181063>, 
      <-0.204983, 0.616506, 1.084852>, <-0.145915, 0.623935, 1.099891>, <-0.060886, 0.632809, 1.114118>, <0.000517, 0.632809, 1.114118>, 
      <-0.204360, 0.739234, 0.916270>, <-0.143395, 0.749876, 0.933123>, <-0.063624, 0.763388, 0.954212>, <0.000517, 0.763388, 0.954212>, 
      <-0.207910, 0.793428, 0.782815>, <-0.146945, 0.804070, 0.799669>, <-0.063624, 0.818937, 0.823055>, <0.000517, 0.818937, 0.823055>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.512806, -0.381058, -0.405403>, <-0.495863, -0.427143, -0.431526>, <-0.447424, -0.468467, -0.475805>, <-0.417975, -0.507535, -0.502258>, 
      <-0.492414, -0.299735, -0.471086>, <-0.475470, -0.345821, -0.497209>, <-0.436862, -0.391309, -0.535266>, <-0.407413, -0.430377, -0.561720>, 
      <-0.461547, -0.102139, -0.449502>, <-0.440516, -0.148873, -0.472793>, <-0.401301, -0.210330, -0.514980>, <-0.374135, -0.253058, -0.539581>, 
      <-0.449516, -0.061871, -0.547365>, <-0.428485, -0.108605, -0.570656>, <-0.394179, -0.167459, -0.602797>, <-0.367014, -0.210187, -0.627398>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.512806, -0.381058, -0.405403>, <-0.492414, -0.299735, -0.471086>, <-0.461547, -0.102139, -0.449502>, <-0.449516, -0.061871, -0.547365>, 
      <-0.547276, -0.287301, -0.352259>, <-0.526884, -0.205978, -0.417942>, <-0.476188, -0.069604, -0.433287>, <-0.464157, -0.029336, -0.531150>, 
      <-0.570707, -0.141907, -0.305041>, <-0.547280, -0.096059, -0.375806>, <-0.490870, 0.007329, -0.423909>, <-0.478450, 0.016838, -0.510012>, 
      <-0.586542, -0.049039, -0.242370>, <-0.563115, -0.003191, -0.313135>, <-0.497817, 0.043375, -0.410187>, <-0.485397, 0.052883, -0.496291>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.556800, -0.489710, -0.201805>, <-0.546126, -0.468421, -0.268139>, <-0.526300, -0.434873, -0.361938>, <-0.512806, -0.381058, -0.405403>, 
      <-0.590593, -0.411661, -0.167487>, <-0.579920, -0.390372, -0.233821>, <-0.560770, -0.341116, -0.308794>, <-0.547276, -0.287301, -0.352259>, 
      <-0.611510, -0.299304, -0.119152>, <-0.601654, -0.260757, -0.179672>, <-0.590096, -0.179851, -0.246475>, <-0.570707, -0.141907, -0.305041>, 
      <-0.624614, -0.219568, -0.075771>, <-0.614758, -0.181021, -0.136291>, <-0.605931, -0.086983, -0.183804>, <-0.586542, -0.049039, -0.242370>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.591808, -0.538630, 0.085570>, <-0.598016, -0.544183, 0.148684>, <-0.600091, -0.543723, 0.234661>, <-0.605886, -0.533619, 0.297248>, 
      <-0.621843, -0.465918, 0.099784>, <-0.628051, -0.471471, 0.162898>, <-0.623323, -0.473493, 0.213577>, <-0.629118, -0.463389, 0.276164>, 
      <-0.636462, -0.358187, 0.106586>, <-0.639707, -0.365837, 0.141574>, <-0.643280, -0.365394, 0.205825>, <-0.646110, -0.364973, 0.241672>, 
      <-0.645577, -0.279927, 0.120129>, <-0.648822, -0.287577, 0.155117>, <-0.651014, -0.288898, 0.203562>, <-0.653844, -0.288477, 0.239409>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.591808, -0.538630, 0.085570>, <-0.583219, -0.530947, -0.001754>, <-0.570139, -0.516316, -0.118905>, <-0.556800, -0.489710, -0.201805>, 
      <-0.621843, -0.465918, 0.099784>, <-0.613254, -0.458235, 0.012460>, <-0.603933, -0.438267, -0.084586>, <-0.590593, -0.411661, -0.167487>, 
      <-0.636462, -0.358187, 0.106586>, <-0.630884, -0.345038, 0.046442>, <-0.619923, -0.332204, -0.067498>, <-0.611510, -0.299304, -0.119152>, 
      <-0.645577, -0.279927, 0.120129>, <-0.639999, -0.266777, 0.059985>, <-0.633026, -0.252468, -0.024117>, <-0.624614, -0.219568, -0.075771>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.621533, -0.486799, 0.406624>, <-0.617710, -0.507271, 0.377260>, <-0.609163, -0.527905, 0.332640>, <-0.605886, -0.533619, 0.297248>, 
      <-0.644179, -0.429372, 0.380856>, <-0.640356, -0.449844, 0.351492>, <-0.632395, -0.457675, 0.311556>, <-0.629118, -0.463389, 0.276164>, 
      <-0.657283, -0.343811, 0.346881>, <-0.654135, -0.356057, 0.318303>, <-0.648569, -0.364607, 0.272824>, <-0.646110, -0.364973, 0.241672>, 
      <-0.663137, -0.277314, 0.342560>, <-0.659989, -0.289560, 0.313982>, <-0.656303, -0.288111, 0.270560>, <-0.653844, -0.288477, 0.239409>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.645465, -0.321685, 0.601232>, <-0.652181, -0.250959, 0.650130>, <-0.657209, -0.140434, 0.704658>, <-0.662598, -0.054363, 0.705599>, 
      <-0.660091, -0.287900, 0.556168>, <-0.666807, -0.217175, 0.605066>, <-0.667758, -0.124516, 0.652856>, <-0.673147, -0.038444, 0.653797>, 
      <-0.674636, -0.249522, 0.477475>, <-0.676349, -0.190713, 0.515857>, <-0.671149, -0.068221, 0.577792>, <-0.669135, 0.001019, 0.589472>, 
      <-0.677951, -0.194697, 0.458256>, <-0.679664, -0.135888, 0.496637>, <-0.673951, -0.044485, 0.528023>, <-0.671937, 0.024754, 0.539703>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.645465, -0.321685, 0.601232>, <-0.639477, -0.384748, 0.557632>, <-0.629700, -0.443067, 0.469350>, <-0.621533, -0.486799, 0.406624>, 
      <-0.660091, -0.287900, 0.556168>, <-0.654103, -0.350963, 0.512568>, <-0.652346, -0.385640, 0.443582>, <-0.644179, -0.429372, 0.380856>, 
      <-0.674636, -0.249522, 0.477475>, <-0.673590, -0.285421, 0.454046>, <-0.661603, -0.327007, 0.386095>, <-0.657283, -0.343811, 0.346881>, 
      <-0.677951, -0.194697, 0.458256>, <-0.676905, -0.230596, 0.434827>, <-0.667457, -0.260510, 0.381774>, <-0.663137, -0.277314, 0.342560>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.598586, 0.270397, 0.013847>, <-0.602859, 0.221036, -0.012242>, <-0.597651, 0.150544, -0.041100>, <-0.596005, 0.106883, -0.076120>, 
      <-0.563343, 0.272390, -0.118842>, <-0.567617, 0.223029, -0.144931>, <-0.565989, 0.166993, -0.156019>, <-0.564343, 0.123332, -0.191039>, 
      <-0.498352, 0.283369, -0.292077>, <-0.508538, 0.250778, -0.300933>, <-0.508516, 0.198206, -0.329615>, <-0.509158, 0.164377, -0.339593>, 
      <-0.481021, 0.283437, -0.428282>, <-0.491206, 0.250846, -0.437138>, <-0.493693, 0.204505, -0.448862>, <-0.494335, 0.170677, -0.458841>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.598586, 0.270397, 0.013847>, <-0.615964, 0.269414, 0.079273>, <-0.647424, 0.281090, 0.165292>, <-0.656388, 0.273520, 0.231970>, 
      <-0.602859, 0.221036, -0.012242>, <-0.620237, 0.220054, 0.053184>, <-0.654516, 0.230660, 0.123424>, <-0.663480, 0.223090, 0.190101>, 
      <-0.597651, 0.150544, -0.041100>, <-0.613280, 0.142425, 0.015624>, <-0.638544, 0.147494, 0.091203>, <-0.653230, 0.144238, 0.148662>, 
      <-0.596005, 0.106883, -0.076120>, <-0.611634, 0.098764, -0.019396>, <-0.637190, 0.092088, 0.055499>, <-0.651876, 0.088832, 0.112958>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.665203, 0.091543, 0.194622>, <-0.659315, -0.019898, 0.172274>, <-0.658553, -0.168513, 0.139409>, <-0.645577, -0.279927, 0.120129>, 
      <-0.662557, 0.090329, 0.169957>, <-0.656669, -0.021112, 0.147609>, <-0.652975, -0.155363, 0.079265>, <-0.639999, -0.266777, 0.059985>, 
      <-0.658017, 0.087471, 0.136985>, <-0.649838, -0.005049, 0.080366>, <-0.648568, -0.157898, 0.027336>, <-0.633026, -0.252468, -0.024117>, 
      <-0.651876, 0.088832, 0.112958>, <-0.643697, -0.003688, 0.056339>, <-0.640155, -0.124997, -0.024319>, <-0.624614, -0.219568, -0.075771>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.669643, 0.096985, 0.278592>, <-0.664903, -0.018654, 0.266837>, <-0.665541, -0.172786, 0.235986>, <-0.653844, -0.288477, 0.239409>, 
      <-0.668267, 0.093239, 0.253630>, <-0.663527, -0.022400, 0.241875>, <-0.662711, -0.173207, 0.200139>, <-0.651014, -0.288898, 0.203562>, 
      <-0.667896, 0.092779, 0.219727>, <-0.662008, -0.018662, 0.197379>, <-0.661798, -0.176163, 0.174398>, <-0.648822, -0.287577, 0.155117>, 
      <-0.665203, 0.091543, 0.194622>, <-0.659315, -0.019898, 0.172274>, <-0.658553, -0.168513, 0.139409>, <-0.645577, -0.279927, 0.120129>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.674728, 0.117465, 0.367358>, <-0.675200, 0.122712, 0.389479>, <-0.674141, 0.129273, 0.419116>, <-0.673111, 0.135499, 0.440963>, 
      <-0.671251, -0.000969, 0.359919>, <-0.671723, 0.004278, 0.382040>, <-0.675593, 0.030214, 0.424304>, <-0.674563, 0.036440, 0.446151>, 
      <-0.673526, -0.159300, 0.334891>, <-0.677846, -0.142496, 0.374105>, <-0.682557, -0.137129, 0.402061>, <-0.683603, -0.101230, 0.425490>, 
      <-0.663137, -0.277314, 0.342560>, <-0.667457, -0.260510, 0.381774>, <-0.676905, -0.230596, 0.434827>, <-0.677951, -0.194697, 0.458256>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.674728, 0.117465, 0.367358>, <-0.671251, -0.000969, 0.359919>, <-0.673526, -0.159300, 0.334891>, <-0.663137, -0.277314, 0.342560>, 
      <-0.674159, 0.111149, 0.340731>, <-0.670682, -0.007285, 0.333291>, <-0.670378, -0.171547, 0.306313>, <-0.659989, -0.289560, 0.313982>, 
      <-0.671133, 0.101041, 0.305621>, <-0.666394, -0.014597, 0.293866>, <-0.668000, -0.172420, 0.267138>, <-0.656303, -0.288111, 0.270560>, 
      <-0.669643, 0.096985, 0.278592>, <-0.664903, -0.018654, 0.266837>, <-0.665541, -0.172786, 0.235986>, <-0.653844, -0.288477, 0.239409>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.429867, -0.669354, -0.273542>, <-0.405358, -0.697368, -0.283164>, <-0.363316, -0.728615, -0.287967>, <-0.330468, -0.748408, -0.290661>, 
      <-0.423143, -0.638608, -0.351561>, <-0.398634, -0.666622, -0.361183>, <-0.361345, -0.699371, -0.373775>, <-0.328497, -0.719164, -0.376469>, 
      <-0.427043, -0.573782, -0.451205>, <-0.408334, -0.598603, -0.468011>, <-0.378034, -0.637099, -0.476916>, <-0.357002, -0.662193, -0.490203>, 
      <-0.417975, -0.507535, -0.502258>, <-0.399266, -0.532356, -0.519065>, <-0.373682, -0.568439, -0.535983>, <-0.352649, -0.593532, -0.549270>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.429867, -0.669354, -0.273542>, <-0.423143, -0.638608, -0.351561>, <-0.427043, -0.573782, -0.451205>, <-0.417975, -0.507535, -0.502258>, 
      <-0.474116, -0.618777, -0.256170>, <-0.467392, -0.588032, -0.334189>, <-0.456492, -0.534714, -0.424751>, <-0.447424, -0.468467, -0.475805>, 
      <-0.531225, -0.548778, -0.227777>, <-0.520551, -0.527489, -0.294111>, <-0.509357, -0.480958, -0.388060>, <-0.495863, -0.427143, -0.431526>, 
      <-0.556800, -0.489710, -0.201805>, <-0.546126, -0.468421, -0.268139>, <-0.526300, -0.434873, -0.361938>, <-0.512806, -0.381058, -0.405403>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.464216, -0.718984, 0.034301>, <-0.479256, -0.719607, 0.132097>, <-0.515743, -0.687844, 0.257672>, <-0.526527, -0.673359, 0.354958>, 
      <-0.509231, -0.671100, 0.051908>, <-0.524272, -0.671724, 0.149703>, <-0.552750, -0.652749, 0.262454>, <-0.563534, -0.638265, 0.359740>, 
      <-0.566246, -0.600513, 0.073473>, <-0.572454, -0.606066, 0.136587>, <-0.584620, -0.590494, 0.248703>, <-0.590414, -0.580390, 0.311289>, 
      <-0.591808, -0.538630, 0.085570>, <-0.598016, -0.544183, 0.148684>, <-0.600091, -0.543723, 0.234661>, <-0.605886, -0.533619, 0.297248>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.464216, -0.718984, 0.034301>, <-0.449911, -0.718391, -0.058715>, <-0.437389, -0.703749, -0.186265>, <-0.429867, -0.669354, -0.273542>, 
      <-0.509231, -0.671100, 0.051908>, <-0.494926, -0.670508, -0.041108>, <-0.481637, -0.653172, -0.168893>, <-0.474116, -0.618777, -0.256170>, 
      <-0.566246, -0.600513, 0.073473>, <-0.557657, -0.592830, -0.013851>, <-0.544564, -0.575384, -0.144877>, <-0.531225, -0.548778, -0.227777>, 
      <-0.591808, -0.538630, 0.085570>, <-0.583219, -0.530947, -0.001754>, <-0.570139, -0.516316, -0.118905>, <-0.556800, -0.489710, -0.201805>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.464216, -0.718984, 0.034301>, <-0.479256, -0.719607, 0.132097>, <-0.515743, -0.687844, 0.257672>, <-0.526527, -0.673359, 0.354958>, 
      <-0.440000, -0.744743, 0.024830>, <-0.455040, -0.745367, 0.122626>, <-0.483494, -0.718426, 0.253505>, <-0.494278, -0.703942, 0.350791>, 
      <-0.398257, -0.766442, 0.005383>, <-0.410429, -0.761883, 0.090107>, <-0.435954, -0.722148, 0.206833>, <-0.450742, -0.707085, 0.289908>, 
      <-0.365195, -0.779682, -0.003063>, <-0.377368, -0.775123, 0.081661>, <-0.396536, -0.733190, 0.189030>, <-0.411324, -0.718127, 0.272105>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.464216, -0.718984, 0.034301>, <-0.440000, -0.744743, 0.024830>, <-0.398257, -0.766442, 0.005383>, <-0.365195, -0.779682, -0.003063>, 
      <-0.449911, -0.718391, -0.058715>, <-0.425694, -0.744151, -0.068186>, <-0.385843, -0.771091, -0.081018>, <-0.352781, -0.784331, -0.089463>, 
      <-0.437389, -0.703749, -0.186265>, <-0.412880, -0.731762, -0.195886>, <-0.365216, -0.756806, -0.205249>, <-0.332368, -0.776599, -0.207942>, 
      <-0.429867, -0.669354, -0.273542>, <-0.405358, -0.697368, -0.283164>, <-0.363316, -0.728615, -0.287967>, <-0.330468, -0.748408, -0.290661>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.516840, -0.648302, 0.509025>, <-0.559612, -0.603701, 0.487602>, <-0.599391, -0.542948, 0.431818>, <-0.621533, -0.486799, 0.406624>, 
      <-0.512408, -0.670877, 0.468135>, <-0.555180, -0.626276, 0.446712>, <-0.595568, -0.563420, 0.402454>, <-0.617710, -0.507271, 0.377260>, 
      <-0.531641, -0.666491, 0.401087>, <-0.568647, -0.631396, 0.405870>, <-0.593691, -0.574676, 0.346682>, <-0.609163, -0.527905, 0.332640>, 
      <-0.526527, -0.673359, 0.354958>, <-0.563534, -0.638265, 0.359740>, <-0.590414, -0.580390, 0.311289>, <-0.605886, -0.533619, 0.297248>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.572832, -0.437511, 0.782138>, <-0.605951, -0.408674, 0.730184>, <-0.628367, -0.361181, 0.653914>, <-0.645465, -0.321685, 0.601232>, 
      <-0.561602, -0.520195, 0.718644>, <-0.594722, -0.491358, 0.666690>, <-0.622378, -0.424243, 0.610314>, <-0.639477, -0.384748, 0.557632>, 
      <-0.526745, -0.597850, 0.600407>, <-0.569518, -0.553249, 0.578984>, <-0.607558, -0.499216, 0.494544>, <-0.629700, -0.443067, 0.469350>, 
      <-0.516840, -0.648302, 0.509025>, <-0.559612, -0.603701, 0.487602>, <-0.599391, -0.542948, 0.431818>, <-0.621533, -0.486799, 0.406624>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.591833, -0.096123, 0.933049>, <-0.595607, 0.035015, 0.942049>, <-0.595505, 0.223476, 0.910489>, <-0.594951, 0.331069, 0.834885>, 
      <-0.621171, -0.091815, 0.866834>, <-0.624945, 0.039324, 0.875834>, <-0.630814, 0.187908, 0.845193>, <-0.630261, 0.295501, 0.769589>, 
      <-0.648735, -0.075282, 0.773672>, <-0.653911, 0.007387, 0.774575>, <-0.662915, 0.194179, 0.746104>, <-0.662022, 0.241326, 0.678000>, 
      <-0.662598, -0.054363, 0.705599>, <-0.667774, 0.028306, 0.706503>, <-0.679213, 0.155912, 0.675073>, <-0.678320, 0.203059, 0.606969>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.591833, -0.096123, 0.933049>, <-0.621171, -0.091815, 0.866834>, <-0.648735, -0.075282, 0.773672>, <-0.662598, -0.054363, 0.705599>, 
      <-0.588615, -0.207936, 0.925375>, <-0.617953, -0.203627, 0.859161>, <-0.643346, -0.161354, 0.772731>, <-0.657209, -0.140434, 0.704658>, 
      <-0.584840, -0.349095, 0.850033>, <-0.617959, -0.320259, 0.798080>, <-0.635083, -0.290455, 0.702812>, <-0.652181, -0.250959, 0.650130>, 
      <-0.572832, -0.437511, 0.782138>, <-0.605951, -0.408674, 0.730184>, <-0.628367, -0.361181, 0.653914>, <-0.645465, -0.321685, 0.601232>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.558886, 0.535632, 0.150492>, <-0.586517, 0.456780, 0.116247>, <-0.591695, 0.349997, 0.055919>, <-0.598586, 0.270397, 0.013847>, 
      <-0.524300, 0.520202, -0.012856>, <-0.551931, 0.441350, -0.047101>, <-0.556452, 0.351990, -0.076769>, <-0.563343, 0.272390, -0.118842>, 
      <-0.427473, 0.469746, -0.215360>, <-0.459031, 0.421668, -0.226726>, <-0.481426, 0.337531, -0.277359>, <-0.498352, 0.283369, -0.292077>, 
      <-0.404834, 0.457063, -0.381021>, <-0.436392, 0.408985, -0.392387>, <-0.464095, 0.337598, -0.413565>, <-0.481021, 0.283437, -0.428282>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.558886, 0.535632, 0.150492>, <-0.579774, 0.544951, 0.249144>, <-0.583458, 0.567997, 0.389827>, <-0.588565, 0.539033, 0.486731>, 
      <-0.586517, 0.456780, 0.116247>, <-0.607405, 0.466099, 0.214899>, <-0.618789, 0.491137, 0.316042>, <-0.623896, 0.462172, 0.412946>, 
      <-0.591695, 0.349997, 0.055919>, <-0.609072, 0.349015, 0.121346>, <-0.635350, 0.366953, 0.236579>, <-0.644313, 0.359383, 0.303257>, 
      <-0.598586, 0.270397, 0.013847>, <-0.615964, 0.269414, 0.079273>, <-0.647424, 0.281090, 0.165292>, <-0.656388, 0.273520, 0.231970>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.317892, -0.758142, 0.458025>, <-0.391267, -0.747487, 0.462840>, <-0.463936, -0.698794, 0.385878>, <-0.526527, -0.673359, 0.354958>, 
      <-0.313181, -0.757220, 0.437867>, <-0.386555, -0.746564, 0.442682>, <-0.453353, -0.703425, 0.385756>, <-0.515943, -0.677990, 0.354836>, 
      <-0.313920, -0.783485, 0.403836>, <-0.391466, -0.774048, 0.409899>, <-0.447282, -0.709267, 0.366197>, <-0.502220, -0.685283, 0.355420>, 
      <-0.308122, -0.768745, 0.390475>, <-0.385668, -0.759308, 0.396539>, <-0.436310, -0.712781, 0.365329>, <-0.491248, -0.688797, 0.354552>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.317892, -0.758142, 0.458025>, <-0.313181, -0.757220, 0.437867>, <-0.313920, -0.783485, 0.403836>, <-0.308122, -0.768745, 0.390475>, 
      <-0.247751, -0.768328, 0.453422>, <-0.243040, -0.767405, 0.433265>, <-0.246020, -0.791748, 0.398526>, <-0.240222, -0.777008, 0.385165>, 
      <-0.185078, -0.707983, 0.348810>, <-0.181337, -0.706876, 0.355144>, <-0.188317, -0.745804, 0.346410>, <-0.194810, -0.742172, 0.346444>, 
      <-0.121501, -0.732175, 0.328379>, <-0.117760, -0.731068, 0.334713>, <-0.139755, -0.734416, 0.327539>, <-0.146247, -0.730783, 0.327574>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.344344, -0.775838, 0.545457>, <-0.402307, -0.746246, 0.540365>, <-0.474150, -0.692817, 0.530407>, <-0.516840, -0.648302, 0.509025>, 
      <-0.339669, -0.787349, 0.520461>, <-0.397632, -0.757757, 0.515369>, <-0.469717, -0.715393, 0.489517>, <-0.512408, -0.670877, 0.468135>, 
      <-0.324238, -0.759385, 0.485179>, <-0.397613, -0.748730, 0.489994>, <-0.469050, -0.691926, 0.432008>, <-0.531641, -0.666491, 0.401087>, 
      <-0.317892, -0.758142, 0.458025>, <-0.391267, -0.747487, 0.462840>, <-0.463936, -0.698794, 0.385878>, <-0.526527, -0.673359, 0.354958>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.412901, -0.524179, 0.966055>, <-0.467275, -0.500559, 0.915976>, <-0.535050, -0.470408, 0.841406>, <-0.572832, -0.437511, 0.782138>, 
      <-0.392865, -0.635623, 0.870019>, <-0.447239, -0.612003, 0.819940>, <-0.523821, -0.553092, 0.777912>, <-0.561602, -0.520195, 0.718644>, 
      <-0.369208, -0.714609, 0.678411>, <-0.427171, -0.685017, 0.673319>, <-0.484055, -0.642365, 0.621789>, <-0.526745, -0.597850, 0.600407>, 
      <-0.344344, -0.775838, 0.545457>, <-0.402307, -0.746246, 0.540365>, <-0.474150, -0.692817, 0.530407>, <-0.516840, -0.648302, 0.509025>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.468943, -0.082802, 1.142677>, <-0.476785, 0.073614, 1.149939>, <-0.462277, 0.289864, 1.093412>, <-0.460369, 0.422607, 1.010012>, 
      <-0.517387, -0.088196, 1.088325>, <-0.525229, 0.068219, 1.095587>, <-0.508192, 0.264689, 1.044397>, <-0.506284, 0.397432, 0.960996>, 
      <-0.562311, -0.100459, 0.999680>, <-0.566085, 0.030680, 1.008680>, <-0.564737, 0.254470, 0.967386>, <-0.564183, 0.362062, 0.891782>, 
      <-0.591833, -0.096123, 0.933049>, <-0.595607, 0.035015, 0.942049>, <-0.595505, 0.223476, 0.910489>, <-0.594951, 0.331069, 0.834885>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.468943, -0.082802, 1.142677>, <-0.517387, -0.088196, 1.088325>, <-0.562311, -0.100459, 0.999680>, <-0.591833, -0.096123, 0.933049>, 
      <-0.461760, -0.226077, 1.136025>, <-0.510204, -0.231471, 1.081673>, <-0.559093, -0.212271, 0.992007>, <-0.588615, -0.207936, 0.925375>, 
      <-0.432281, -0.416386, 1.058945>, <-0.486655, -0.392766, 1.008867>, <-0.547058, -0.381992, 0.909301>, <-0.584840, -0.349095, 0.850033>, 
      <-0.412901, -0.524179, 0.966055>, <-0.467275, -0.500559, 0.915976>, <-0.535050, -0.470408, 0.841406>, <-0.572832, -0.437511, 0.782138>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.433567, 0.741324, 0.218367>, <-0.477412, 0.684553, 0.196220>, <-0.535914, 0.601188, 0.178963>, <-0.558886, 0.535632, 0.150492>, 
      <-0.403333, 0.717639, 0.036893>, <-0.447179, 0.660868, 0.014746>, <-0.501328, 0.585758, 0.015614>, <-0.524300, 0.520202, -0.012856>, 
      <-0.311150, 0.600307, -0.176980>, <-0.347154, 0.566303, -0.181575>, <-0.400699, 0.510536, -0.205717>, <-0.427473, 0.469746, -0.215360>, 
      <-0.289912, 0.574592, -0.359450>, <-0.325917, 0.540589, -0.364045>, <-0.378060, 0.497853, -0.371378>, <-0.404834, 0.457063, -0.381021>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.433567, 0.741324, 0.218367>, <-0.454635, 0.757829, 0.344826>, <-0.453547, 0.754215, 0.527260>, <-0.457605, 0.705964, 0.647108>, 
      <-0.477412, 0.684553, 0.196220>, <-0.498480, 0.701058, 0.322679>, <-0.502041, 0.711585, 0.480383>, <-0.506098, 0.663334, 0.600231>, 
      <-0.535914, 0.601188, 0.178963>, <-0.556802, 0.610507, 0.277615>, <-0.558345, 0.622632, 0.442275>, <-0.563451, 0.593667, 0.539179>, 
      <-0.558886, 0.535632, 0.150492>, <-0.579774, 0.544951, 0.249144>, <-0.583458, 0.567997, 0.389827>, <-0.588565, 0.539033, 0.486731>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.114467, -0.778674, -0.658526>, <-0.080879, -0.788238, -0.664435>, <-0.034902, -0.801524, -0.672515>, <0.000517, -0.801524, -0.672515>, 
      <-0.117358, -0.831784, -0.623404>, <-0.083770, -0.841348, -0.629313>, <-0.034902, -0.855456, -0.638379>, <0.000517, -0.855456, -0.638379>, 
      <-0.101873, -0.813081, -0.514204>, <-0.073935, -0.819192, -0.521919>, <-0.029104, -0.831050, -0.526327>, <0.000517, -0.831050, -0.526327>, 
      <-0.096191, -0.833262, -0.454013>, <-0.068253, -0.839373, -0.461728>, <-0.029104, -0.849683, -0.465280>, <0.000517, -0.849683, -0.465280>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.114467, -0.778674, -0.658526>, <-0.109068, -0.679472, -0.724129>, <-0.080357, -0.465513, -0.650208>, <-0.072261, -0.393615, -0.744755>, 
      <-0.080879, -0.788238, -0.664435>, <-0.075480, -0.689036, -0.730038>, <-0.058603, -0.468234, -0.651941>, <-0.050507, -0.396337, -0.746487>, 
      <-0.034902, -0.801524, -0.672515>, <-0.034902, -0.698210, -0.737907>, <-0.021475, -0.478098, -0.654085>, <-0.021475, -0.401176, -0.749126>, 
      <0.000517, -0.801524, -0.672515>, <0.000517, -0.698210, -0.737907>, <0.000517, -0.478147, -0.654088>, <0.000517, -0.401224, -0.749129>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.114467, -0.778674, -0.658526>, <-0.117358, -0.831784, -0.623404>, <-0.101873, -0.813081, -0.514204>, <-0.096191, -0.833262, -0.454013>, 
      <-0.136318, -0.772452, -0.654682>, <-0.139209, -0.825562, -0.619560>, <-0.124237, -0.808190, -0.508029>, <-0.118554, -0.828371, -0.447838>, 
      <-0.163874, -0.760058, -0.647145>, <-0.169258, -0.815276, -0.605889>, <-0.151959, -0.798950, -0.500454>, <-0.147151, -0.819477, -0.434609>, 
      <-0.183020, -0.749264, -0.640226>, <-0.188404, -0.804482, -0.598970>, <-0.169410, -0.793039, -0.485531>, <-0.164602, -0.813566, -0.419685>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.114467, -0.778674, -0.658526>, <-0.136318, -0.772452, -0.654682>, <-0.163874, -0.760058, -0.647145>, <-0.183020, -0.749264, -0.640226>, 
      <-0.109068, -0.679472, -0.724129>, <-0.130918, -0.673251, -0.720285>, <-0.154961, -0.668648, -0.715442>, <-0.174107, -0.657855, -0.708522>, 
      <-0.080357, -0.465513, -0.650208>, <-0.095646, -0.463600, -0.648991>, <-0.116929, -0.454600, -0.648016>, <-0.131902, -0.451375, -0.645943>, 
      <-0.072261, -0.393615, -0.744755>, <-0.087550, -0.391702, -0.743538>, <-0.107917, -0.389007, -0.741375>, <-0.122890, -0.385783, -0.739302>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.350582, 0.805346, 0.255711>, <-0.365558, 0.822227, 0.396816>, <-0.336438, 0.814299, 0.597517>, <-0.337234, 0.759978, 0.729686>, 
      <-0.379342, 0.790837, 0.246961>, <-0.394318, 0.807718, 0.388066>, <-0.375649, 0.800564, 0.576206>, <-0.376445, 0.746243, 0.708375>, 
      <-0.414072, 0.766566, 0.228214>, <-0.435140, 0.783071, 0.354674>, <-0.425169, 0.779163, 0.554693>, <-0.429226, 0.730912, 0.674541>, 
      <-0.433567, 0.741324, 0.218367>, <-0.454635, 0.757829, 0.344826>, <-0.453547, 0.754215, 0.527260>, <-0.457605, 0.705964, 0.647108>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.350582, 0.805346, 0.255711>, <-0.379342, 0.790837, 0.246961>, <-0.414072, 0.766566, 0.228214>, <-0.433567, 0.741324, 0.218367>, 
      <-0.330119, 0.782281, 0.062910>, <-0.358879, 0.767772, 0.054160>, <-0.383839, 0.742881, 0.046740>, <-0.403333, 0.717639, 0.036893>, 
      <-0.240964, 0.658032, -0.165401>, <-0.261389, 0.641441, -0.165936>, <-0.292096, 0.618301, -0.174548>, <-0.311150, 0.600307, -0.176980>, 
      <-0.221828, 0.629897, -0.357664>, <-0.242253, 0.613305, -0.358200>, <-0.270858, 0.592587, -0.357018>, <-0.289912, 0.574592, -0.359450>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.350582, 0.805346, 0.255711>, <-0.330119, 0.782281, 0.062910>, <-0.240964, 0.658032, -0.165401>, <-0.221828, 0.629897, -0.357664>, 
      <-0.315843, 0.822871, 0.266281>, <-0.295380, 0.799806, 0.073480>, <-0.205006, 0.671173, -0.166108>, <-0.185870, 0.643038, -0.358372>, 
      <-0.264373, 0.838467, 0.275852>, <-0.245757, 0.817428, 0.075026>, <-0.156474, 0.692721, -0.158919>, <-0.138954, 0.663853, -0.358868>, 
      <-0.225283, 0.846401, 0.281739>, <-0.206667, 0.825362, 0.080913>, <-0.119489, 0.702567, -0.160073>, <-0.101969, 0.673699, -0.360023>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.350582, 0.805346, 0.255711>, <-0.315843, 0.822871, 0.266281>, <-0.264373, 0.838467, 0.275852>, <-0.225283, 0.846401, 0.281739>, 
      <-0.365558, 0.822227, 0.396816>, <-0.330819, 0.839752, 0.407386>, <-0.278259, 0.854160, 0.425643>, <-0.239169, 0.862094, 0.431531>, 
      <-0.336438, 0.814299, 0.597517>, <-0.300221, 0.826985, 0.617200>, <-0.252629, 0.843163, 0.631389>, <-0.211637, 0.850318, 0.642721>, 
      <-0.337234, 0.759978, 0.729686>, <-0.301018, 0.772664, 0.749369>, <-0.248902, 0.786272, 0.771483>, <-0.207910, 0.793428, 0.782815>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.329692, -0.066933, 1.227160>, <-0.336821, 0.096718, 1.238067>, <-0.354328, 0.321626, 1.175016>, <-0.355611, 0.462296, 1.090388>, 
      <-0.374204, -0.069463, 1.206606>, <-0.381333, 0.094188, 1.217512>, <-0.389404, 0.312296, 1.155178>, <-0.390686, 0.452966, 1.070550>, 
      <-0.436367, -0.079175, 1.179226>, <-0.444209, 0.077241, 1.186488>, <-0.435799, 0.304382, 1.121679>, <-0.433891, 0.437125, 1.038279>, 
      <-0.468943, -0.082802, 1.142677>, <-0.476785, 0.073614, 1.149939>, <-0.462277, 0.289864, 1.093412>, <-0.460369, 0.422607, 1.010012>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.311468, -0.551045, 1.022853>, <-0.328653, -0.437007, 1.130461>, <-0.322843, -0.224167, 1.216681>, <-0.329692, -0.066933, 1.227160>, 
      <-0.343958, -0.543482, 1.009874>, <-0.361144, -0.429444, 1.117482>, <-0.367355, -0.226698, 1.196127>, <-0.374204, -0.069463, 1.206606>, 
      <-0.387821, -0.535074, 0.989154>, <-0.407200, -0.427281, 1.082044>, <-0.429184, -0.222449, 1.172574>, <-0.436367, -0.079175, 1.179226>, 
      <-0.412901, -0.524179, 0.966055>, <-0.432281, -0.416386, 1.058945>, <-0.461760, -0.226077, 1.136025>, <-0.468943, -0.082802, 1.142677>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.219180, -0.800267, 0.535177>, <-0.256246, -0.793183, 0.542184>, <-0.310264, -0.793237, 0.548451>, <-0.344344, -0.775838, 0.545457>, 
      <-0.200862, -0.817732, 0.468212>, <-0.237928, -0.810648, 0.475219>, <-0.305589, -0.804748, 0.523455>, <-0.339669, -0.787349, 0.520461>, 
      <-0.142737, -0.720849, 0.395800>, <-0.206314, -0.696657, 0.416231>, <-0.254097, -0.769570, 0.480576>, <-0.324238, -0.759385, 0.485179>, 
      <-0.121501, -0.732175, 0.328379>, <-0.185078, -0.707983, 0.348810>, <-0.247751, -0.768328, 0.453422>, <-0.317892, -0.758142, 0.458025>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.219180, -0.800267, 0.535177>, <-0.261813, -0.759617, 0.691033>, <-0.293315, -0.671506, 0.909184>, <-0.311468, -0.551045, 1.022853>, 
      <-0.256246, -0.793183, 0.542184>, <-0.298879, -0.752533, 0.698040>, <-0.325805, -0.663943, 0.896205>, <-0.343958, -0.543482, 1.009874>, 
      <-0.310264, -0.793237, 0.548451>, <-0.335128, -0.732008, 0.681406>, <-0.367784, -0.646518, 0.893118>, <-0.387821, -0.535074, 0.989154>, 
      <-0.344344, -0.775838, 0.545457>, <-0.369208, -0.714609, 0.678411>, <-0.392865, -0.635623, 0.870019>, <-0.412901, -0.524179, 0.966055>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.098396, -0.869090, -0.114376>, <-0.108989, -0.866027, -0.120786>, <-0.129611, -0.859743, -0.115205>, <-0.138035, -0.855936, -0.106417>, 
      <-0.096612, -0.870779, -0.103238>, <-0.107206, -0.867717, -0.109648>, <-0.127199, -0.862143, -0.106402>, <-0.135623, -0.858336, -0.097613>, 
      <-0.112463, -0.881712, -0.093518>, <-0.122446, -0.874716, -0.094897>, <-0.135705, -0.867610, -0.092188>, <-0.144621, -0.861752, -0.086128>, 
      <-0.111583, -0.886037, -0.083000>, <-0.121567, -0.879041, -0.084379>, <-0.137064, -0.870531, -0.083316>, <-0.145980, -0.864673, -0.077256>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.098396, -0.869090, -0.114376>, <-0.105515, -0.862348, -0.158830>, <-0.132583, -0.862868, -0.215213>, <-0.139925, -0.859195, -0.259989>, 
      <-0.108989, -0.866027, -0.120786>, <-0.116108, -0.859285, -0.165241>, <-0.153140, -0.851824, -0.220012>, <-0.160482, -0.848151, -0.264789>, 
      <-0.129611, -0.859743, -0.115205>, <-0.143912, -0.845514, -0.167393>, <-0.164453, -0.838585, -0.219728>, <-0.181879, -0.824380, -0.270963>, 
      <-0.138035, -0.855936, -0.106417>, <-0.152336, -0.841707, -0.158604>, <-0.183061, -0.824646, -0.224927>, <-0.200487, -0.810441, -0.276162>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.098396, -0.869090, -0.114376>, <-0.096612, -0.870779, -0.103238>, <-0.112463, -0.881712, -0.093518>, <-0.111583, -0.886037, -0.083000>, 
      <-0.076875, -0.875312, -0.101353>, <-0.075092, -0.877002, -0.090215>, <-0.094227, -0.894491, -0.090999>, <-0.093347, -0.898816, -0.080481>, 
      <-0.068756, -0.879609, -0.053716>, <-0.069330, -0.882621, -0.039145>, <-0.068875, -0.905535, -0.077129>, <-0.072120, -0.917517, -0.068906>, 
      <-0.043502, -0.883268, -0.049212>, <-0.044076, -0.886280, -0.034641>, <-0.050386, -0.917407, -0.072724>, <-0.053631, -0.929389, -0.064501>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.098396, -0.869090, -0.114376>, <-0.076875, -0.875312, -0.101353>, <-0.068756, -0.879609, -0.053716>, <-0.043502, -0.883268, -0.049212>, 
      <-0.105515, -0.862348, -0.158830>, <-0.083994, -0.868570, -0.145807>, <-0.066545, -0.867998, -0.109883>, <-0.041290, -0.871657, -0.105379>, 
      <-0.132583, -0.862868, -0.215213>, <-0.106408, -0.876930, -0.209101>, <-0.077040, -0.885421, -0.184077>, <-0.047520, -0.892301, -0.182872>, 
      <-0.139925, -0.859195, -0.259989>, <-0.113750, -0.873257, -0.253878>, <-0.076230, -0.886175, -0.241463>, <-0.046710, -0.893055, -0.240258>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.187575, -0.066809, 1.272605>, <-0.191200, 0.103560, 1.288009>, <-0.198510, 0.342664, 1.240768>, <-0.202024, 0.491323, 1.156127>, 
      <-0.231452, -0.067056, 1.263753>, <-0.235077, 0.103313, 1.279157>, <-0.247445, 0.336510, 1.228309>, <-0.250959, 0.485169, 1.143667>, 
      <-0.289108, -0.064626, 1.245901>, <-0.296237, 0.099025, 1.256807>, <-0.311190, 0.333100, 1.199413>, <-0.312473, 0.473770, 1.114786>, 
      <-0.329692, -0.066933, 1.227160>, <-0.336821, 0.096718, 1.238067>, <-0.354328, 0.321626, 1.175016>, <-0.355611, 0.462296, 1.090388>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.179259, -0.578567, 1.059389>, <-0.191656, -0.462637, 1.178027>, <-0.184051, -0.232434, 1.257629>, <-0.187575, -0.066809, 1.272605>, 
      <-0.220299, -0.572904, 1.052673>, <-0.232696, -0.456974, 1.171311>, <-0.227928, -0.232681, 1.248777>, <-0.231452, -0.067056, 1.263753>, 
      <-0.273373, -0.559913, 1.038071>, <-0.290559, -0.445875, 1.145679>, <-0.282258, -0.221861, 1.235422>, <-0.289108, -0.064626, 1.245901>, 
      <-0.311468, -0.551045, 1.022853>, <-0.328653, -0.437007, 1.130461>, <-0.322843, -0.224167, 1.216681>, <-0.329692, -0.066933, 1.227160>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.106900, -0.821220, 0.500570>, <-0.138127, -0.752560, 0.668458>, <-0.165541, -0.706843, 0.928116>, <-0.179259, -0.578567, 1.059389>, 
      <-0.140359, -0.815418, 0.511917>, <-0.171586, -0.746758, 0.679805>, <-0.206581, -0.701180, 0.921400>, <-0.220299, -0.572904, 1.052673>, 
      <-0.184604, -0.806875, 0.528641>, <-0.227237, -0.766226, 0.684497>, <-0.255220, -0.680374, 0.924402>, <-0.273373, -0.559913, 1.038071>, 
      <-0.219180, -0.800267, 0.535177>, <-0.261813, -0.759617, 0.691033>, <-0.293315, -0.671506, 0.909184>, <-0.311468, -0.551045, 1.022853>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.106900, -0.821220, 0.500570>, <-0.140359, -0.815418, 0.511917>, <-0.184604, -0.806875, 0.528641>, <-0.219180, -0.800267, 0.535177>, 
      <-0.099531, -0.837423, 0.460950>, <-0.132989, -0.831621, 0.472297>, <-0.166286, -0.824341, 0.461676>, <-0.200862, -0.817732, 0.468212>, 
      <-0.058905, -0.849517, 0.414024>, <-0.086933, -0.817471, 0.397817>, <-0.101961, -0.736365, 0.382697>, <-0.142737, -0.720849, 0.395800>, 
      <-0.051480, -0.859515, 0.372413>, <-0.079508, -0.827469, 0.356206>, <-0.080725, -0.747691, 0.315275>, <-0.121501, -0.732175, 0.328379>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000517, -0.065075, 1.293777>, <0.000517, 0.109050, 1.310721>, <0.000517, 0.352666, 1.263289>, <0.000517, 0.507086, 1.181063>, 
      <-0.056269, -0.065075, 1.293777>, <-0.056269, 0.109050, 1.310721>, <-0.060886, 0.352666, 1.263289>, <-0.060886, 0.507086, 1.181063>, 
      <-0.131911, -0.066496, 1.283835>, <-0.135536, 0.103873, 1.299239>, <-0.139442, 0.350093, 1.255808>, <-0.142956, 0.498752, 1.171166>, 
      <-0.187575, -0.066809, 1.272605>, <-0.191200, 0.103560, 1.288009>, <-0.198510, 0.342664, 1.240768>, <-0.202024, 0.491323, 1.156127>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000517, -0.065075, 1.293777>, <-0.056269, -0.065075, 1.293777>, <-0.131911, -0.066496, 1.283835>, <-0.187575, -0.066809, 1.272605>, 
      <0.000517, -0.236136, 1.277131>, <-0.056269, -0.236136, 1.277131>, <-0.128387, -0.232121, 1.268859>, <-0.184051, -0.232434, 1.257629>, 
      <0.000517, -0.477176, 1.199875>, <-0.053792, -0.477176, 1.199875>, <-0.138551, -0.469966, 1.186717>, <-0.191656, -0.462637, 1.178027>, 
      <0.000517, -0.594099, 1.073907>, <-0.053792, -0.594099, 1.073907>, <-0.126154, -0.585896, 1.068079>, <-0.179259, -0.578567, 1.059389>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000517, -0.838364, 0.460669>, <0.000517, -0.765084, 0.644640>, <0.000517, -0.728819, 0.928766>, <0.000517, -0.594099, 1.073907>, 
      <-0.034242, -0.838364, 0.460669>, <-0.034242, -0.765084, 0.644640>, <-0.053792, -0.728819, 0.928766>, <-0.053792, -0.594099, 1.073907>, 
      <-0.074417, -0.826853, 0.489554>, <-0.105645, -0.758193, 0.657441>, <-0.112436, -0.714172, 0.936806>, <-0.126154, -0.585896, 1.068079>, 
      <-0.106900, -0.821220, 0.500570>, <-0.138127, -0.752560, 0.668458>, <-0.165541, -0.706843, 0.928116>, <-0.179259, -0.578567, 1.059389>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000517, -0.838364, 0.460669>, <-0.034242, -0.838364, 0.460669>, <-0.074417, -0.826853, 0.489554>, <-0.106900, -0.821220, 0.500570>, 
      <0.000517, -0.848360, 0.442149>, <-0.034242, -0.848360, 0.442149>, <-0.067048, -0.843056, 0.449934>, <-0.099531, -0.837423, 0.460950>, 
      <0.000517, -0.865805, 0.419144>, <-0.017371, -0.865775, 0.419146>, <-0.047899, -0.862100, 0.420388>, <-0.058905, -0.849517, 0.414024>, 
      <0.000517, -0.871683, 0.398936>, <-0.017371, -0.871654, 0.398939>, <-0.040474, -0.872098, 0.378777>, <-0.051480, -0.859515, 0.372413>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.124083, -0.850936, 0.037892>, <0.123128, -0.855683, 0.027304>, <0.126351, -0.862204, 0.013143>, <0.128581, -0.865499, 0.002201>, 
      <0.137744, -0.845358, 0.015683>, <0.136789, -0.850105, 0.005095>, <0.136745, -0.856928, -0.000408>, <0.138974, -0.860223, -0.011350>, 
      <0.160541, -0.836490, -0.014647>, <0.155102, -0.838540, -0.015937>, <0.155656, -0.848930, -0.031518>, <0.152807, -0.854127, -0.032080>, 
      <0.162220, -0.837411, -0.041242>, <0.156781, -0.839461, -0.042532>, <0.158164, -0.848747, -0.049215>, <0.155315, -0.853945, -0.049776>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.074627, -0.873179, 0.101158>, <0.073380, -0.881013, 0.088007>, <0.073143, -0.890578, 0.069347>, <0.075203, -0.894616, 0.054673>, 
      <0.088875, -0.864363, 0.082606>, <0.087628, -0.872196, 0.069456>, <0.088673, -0.880528, 0.053908>, <0.090733, -0.884566, 0.039234>, 
      <0.111276, -0.856166, 0.058713>, <0.110321, -0.860913, 0.048125>, <0.112341, -0.869317, 0.031409>, <0.114571, -0.872612, 0.020467>, 
      <0.124083, -0.850936, 0.037892>, <0.123128, -0.855683, 0.027304>, <0.126351, -0.862204, 0.013143>, <0.128581, -0.865499, 0.002201>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.036647, -0.905039, 0.151737>, <0.036021, -0.909236, 0.133172>, <0.037122, -0.917555, 0.109028>, <0.039261, -0.923303, 0.090999>, 
      <0.050598, -0.895692, 0.138721>, <0.049972, -0.899889, 0.120157>, <0.049757, -0.909569, 0.099773>, <0.051896, -0.915316, 0.081744>, 
      <0.062517, -0.880672, 0.116926>, <0.061270, -0.888506, 0.103775>, <0.061811, -0.897912, 0.080612>, <0.063871, -0.901949, 0.065938>, 
      <0.074627, -0.873179, 0.101158>, <0.073380, -0.881013, 0.088007>, <0.073143, -0.890578, 0.069347>, <0.075203, -0.894616, 0.054673>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.036647, -0.905039, 0.151737>, <0.038871, -0.890122, 0.217715>, <0.036586, -0.875234, 0.307662>, <0.048747, -0.859679, 0.372398>, 
      <0.027911, -0.910892, 0.159887>, <0.030135, -0.895974, 0.225865>, <0.027459, -0.887941, 0.314060>, <0.039620, -0.872386, 0.378796>, 
      <0.013821, -0.922832, 0.170299>, <0.013821, -0.906284, 0.238610>, <0.017420, -0.891343, 0.331444>, <0.017420, -0.871711, 0.398934>, 
      <0.000517, -0.922832, 0.170299>, <0.000517, -0.906284, 0.238610>, <0.000517, -0.891315, 0.331447>, <0.000517, -0.871683, 0.398936>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.036647, -0.905039, 0.151737>, <0.027911, -0.910892, 0.159887>, <0.013821, -0.922832, 0.170299>, <0.000517, -0.922832, 0.170299>, 
      <0.036021, -0.909236, 0.133172>, <0.027286, -0.915089, 0.141322>, <0.013821, -0.927339, 0.151693>, <0.000517, -0.927339, 0.151693>, 
      <0.037122, -0.917555, 0.109028>, <0.027050, -0.923922, 0.116405>, <0.014531, -0.935846, 0.127565>, <0.000517, -0.935846, 0.127565>, 
      <0.039261, -0.923303, 0.090999>, <0.029190, -0.929669, 0.098376>, <0.014531, -0.941827, 0.109379>, <0.000517, -0.941827, 0.109379>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.586202, 0.539033, 0.486731>, <0.592163, 0.504231, 0.603168>, <0.591681, 0.430621, 0.764931>, <0.591777, 0.331069, 0.834885>, 
      <0.621188, 0.462141, 0.412916>, <0.627149, 0.427339, 0.529353>, <0.625389, 0.394729, 0.699040>, <0.625485, 0.295177, 0.768994>, 
      <0.641111, 0.359364, 0.303241>, <0.656269, 0.346544, 0.416163>, <0.656920, 0.306525, 0.583626>, <0.657897, 0.241267, 0.677891>, 
      <0.652785, 0.273520, 0.231970>, <0.667942, 0.260700, 0.344892>, <0.673542, 0.268317, 0.512704>, <0.674519, 0.203059, 0.606969>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.410452, -0.507535, -0.502258>, <0.390933, -0.532634, -0.519253>, <0.362422, -0.567953, -0.535753>, <0.340910, -0.593532, -0.549270>, 
      <0.398665, -0.430181, -0.561871>, <0.379147, -0.455280, -0.578866>, <0.355596, -0.492632, -0.600550>, <0.334085, -0.518211, -0.614067>, 
      <0.360532, -0.253171, -0.539349>, <0.341854, -0.280180, -0.554899>, <0.314831, -0.316800, -0.578210>, <0.291661, -0.340380, -0.593286>, 
      <0.351813, -0.210187, -0.627398>, <0.333135, -0.237196, -0.642948>, <0.306582, -0.270814, -0.666162>, <0.283412, -0.294394, -0.681239>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.054770, -0.953731, -0.001001>, <0.052609, -0.952551, 0.028336>, <0.042568, -0.932188, 0.063127>, <0.039261, -0.923303, 0.090999>, 
      <0.041019, -0.964089, 0.003644>, <0.038858, -0.962908, 0.032981>, <0.032497, -0.938555, 0.070504>, <0.029190, -0.929669, 0.098376>, 
      <0.018348, -0.975979, 0.008776>, <0.018348, -0.972880, 0.040494>, <0.014531, -0.951783, 0.079105>, <0.014531, -0.941827, 0.109379>, 
      <0.000517, -0.975950, 0.008779>, <0.000517, -0.972851, 0.040497>, <0.000517, -0.951783, 0.079105>, <0.000517, -0.941827, 0.109379>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.054770, -0.953731, -0.001001>, <0.041019, -0.964089, 0.003644>, <0.018348, -0.975979, 0.008776>, <0.000517, -0.975950, 0.008779>, 
      <0.056269, -0.954550, -0.021354>, <0.042518, -0.964908, -0.016709>, <0.018348, -0.977949, -0.011377>, <0.000517, -0.977919, -0.011374>, 
      <0.054681, -0.946084, -0.053187>, <0.040352, -0.955473, -0.049682>, <0.018003, -0.971396, -0.041071>, <0.000517, -0.971367, -0.041068>, 
      <0.050716, -0.929560, -0.064517>, <0.036387, -0.938949, -0.061012>, <0.018003, -0.958045, -0.056296>, <0.000517, -0.958016, -0.056293>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.054770, -0.953731, -0.001001>, <0.056269, -0.954550, -0.021354>, <0.054681, -0.946084, -0.053187>, <0.050716, -0.929560, -0.064517>, 
      <0.069404, -0.942708, -0.005944>, <0.070903, -0.943527, -0.026296>, <0.073238, -0.933925, -0.057727>, <0.069274, -0.917400, -0.069057>, 
      <0.078761, -0.918955, -0.015318>, <0.083637, -0.917798, -0.034719>, <0.091970, -0.907214, -0.061885>, <0.091627, -0.899640, -0.080432>, 
      <0.091931, -0.907094, -0.022097>, <0.096807, -0.905937, -0.041498>, <0.110158, -0.893974, -0.064484>, <0.109815, -0.886400, -0.083032>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.054770, -0.953731, -0.001001>, <0.069404, -0.942708, -0.005944>, <0.078761, -0.918955, -0.015318>, <0.091931, -0.907094, -0.022097>, 
      <0.052609, -0.952551, 0.028336>, <0.067243, -0.941528, 0.023393>, <0.072953, -0.920334, 0.007790>, <0.086123, -0.908473, 0.001011>, 
      <0.042568, -0.932188, 0.063127>, <0.055203, -0.924202, 0.053872>, <0.067073, -0.908224, 0.043135>, <0.078404, -0.900891, 0.031869>, 
      <0.039261, -0.923303, 0.090999>, <0.051896, -0.915316, 0.081744>, <0.063871, -0.901949, 0.065938>, <0.075203, -0.894616, 0.054673>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.657695, -0.054363, 0.705599>, <0.668291, -0.038507, 0.653829>, <0.664437, 0.000741, 0.589454>, <0.667327, 0.024357, 0.539677>, 
      <0.663234, 0.028302, 0.706503>, <0.673830, 0.044157, 0.654733>, <0.664109, 0.041498, 0.596329>, <0.666998, 0.065114, 0.546552>, 
      <0.675225, 0.155900, 0.675090>, <0.681219, 0.142123, 0.649516>, <0.667856, 0.130783, 0.552058>, <0.666402, 0.119616, 0.524618>, 
      <0.674519, 0.203059, 0.606969>, <0.680513, 0.189282, 0.581395>, <0.667460, 0.171608, 0.545604>, <0.666006, 0.160441, 0.518164>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.581382, -0.049039, -0.242370>, <0.591212, 0.007103, -0.204481>, <0.589319, 0.053498, -0.118921>, <0.591578, 0.106858, -0.076121>, 
      <0.600622, -0.086987, -0.183798>, <0.610452, -0.030845, -0.145909>, <0.604929, 0.045378, -0.062194>, <0.607188, 0.098738, -0.019394>, 
      <0.609048, -0.181028, -0.136280>, <0.625013, -0.086482, -0.084842>, <0.626376, -0.000068, -0.002010>, <0.632736, 0.092082, 0.055502>, 
      <0.618751, -0.219568, -0.075771>, <0.634715, -0.125023, -0.024332>, <0.641063, -0.003318, 0.055446>, <0.647423, 0.088832, 0.112958>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.581382, -0.049039, -0.242370>, <0.558134, -0.003186, -0.313142>, <0.493033, 0.043379, -0.410227>, <0.480615, 0.052883, -0.496291>, 
      <0.591212, 0.007103, -0.204481>, <0.567965, 0.052956, -0.275253>, <0.499774, 0.077560, -0.397215>, <0.487356, 0.087064, -0.483279>, 
      <0.589319, 0.053498, -0.118921>, <0.557697, 0.069947, -0.233838>, <0.505449, 0.128709, -0.350131>, <0.490597, 0.135010, -0.469362>, 
      <0.591578, 0.106858, -0.076121>, <0.559956, 0.123307, -0.191038>, <0.504931, 0.164376, -0.339610>, <0.490079, 0.170677, -0.458841>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.300821, -0.766848, 0.389825>, <0.229053, -0.774982, 0.384696>, <0.179608, -0.741194, 0.346262>, <0.127660, -0.730200, 0.327592>, 
      <0.294991, -0.753209, 0.377336>, <0.223223, -0.761343, 0.372207>, <0.187800, -0.736941, 0.346302>, <0.135852, -0.725947, 0.327632>, 
      <0.293994, -0.725150, 0.406002>, <0.230152, -0.728485, 0.401819>, <0.184849, -0.714126, 0.353606>, <0.141951, -0.714104, 0.328311>, 
      <0.291068, -0.707279, 0.412935>, <0.227226, -0.710614, 0.408752>, <0.190974, -0.707227, 0.353914>, <0.148076, -0.707205, 0.328619>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.501139, -0.687870, 0.354284>, <0.441044, -0.711563, 0.364946>, <0.384301, -0.757386, 0.395791>, <0.300821, -0.766848, 0.389825>, 
      <0.495418, -0.689828, 0.353806>, <0.435323, -0.713522, 0.364468>, <0.378472, -0.743748, 0.383302>, <0.294991, -0.753209, 0.377336>, 
      <0.487307, -0.689215, 0.351606>, <0.430214, -0.694461, 0.370349>, <0.371322, -0.721110, 0.411069>, <0.293994, -0.725150, 0.406002>, 
      <0.481379, -0.689792, 0.350458>, <0.424286, -0.695038, 0.369201>, <0.368396, -0.703239, 0.418002>, <0.291068, -0.707279, 0.412935>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.501139, -0.687870, 0.354284>, <0.495418, -0.689828, 0.353806>, <0.487307, -0.689215, 0.351606>, <0.481379, -0.689792, 0.350458>, 
      <0.478046, -0.697830, 0.343479>, <0.472325, -0.699788, 0.343001>, <0.470856, -0.689023, 0.345315>, <0.464928, -0.689599, 0.344167>, 
      <0.449767, -0.713025, 0.323645>, <0.452259, -0.708479, 0.332401>, <0.443004, -0.696038, 0.328952>, <0.443718, -0.686462, 0.332318>, 
      <0.424162, -0.721069, 0.318268>, <0.426654, -0.716523, 0.327024>, <0.425828, -0.698725, 0.326122>, <0.426542, -0.689149, 0.329488>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.501139, -0.687870, 0.354284>, <0.478046, -0.697830, 0.343479>, <0.449767, -0.713025, 0.323645>, <0.424162, -0.721069, 0.318268>, 
      <0.510884, -0.684534, 0.355099>, <0.487791, -0.694494, 0.344294>, <0.446265, -0.719412, 0.311343>, <0.420660, -0.727456, 0.305965>, 
      <0.522706, -0.677098, 0.354565>, <0.490688, -0.709996, 0.350202>, <0.454673, -0.704933, 0.303836>, <0.413454, -0.716118, 0.286449>, 
      <0.531949, -0.672482, 0.354686>, <0.499931, -0.705380, 0.350323>, <0.451601, -0.707438, 0.290099>, <0.410382, -0.718624, 0.272712>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.272324, -0.759757, 0.306229>, <0.319221, -0.755637, 0.303698>, <0.380061, -0.734924, 0.309006>, <0.424162, -0.721069, 0.318268>, 
      <0.272212, -0.756559, 0.317394>, <0.319109, -0.752439, 0.314864>, <0.382553, -0.730379, 0.317762>, <0.426654, -0.716523, 0.327024>, 
      <0.272992, -0.733573, 0.313189>, <0.319988, -0.729278, 0.311707>, <0.379786, -0.705929, 0.318536>, <0.425828, -0.698725, 0.326122>, 
      <0.273278, -0.722352, 0.316172>, <0.320274, -0.718057, 0.314690>, <0.380500, -0.696353, 0.321902>, <0.426542, -0.689149, 0.329488>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.177472, -0.742743, 0.331579>, <0.214762, -0.750362, 0.326072>, <0.242588, -0.762370, 0.307833>, <0.272324, -0.759757, 0.306229>, 
      <0.181906, -0.738698, 0.339265>, <0.219196, -0.746317, 0.333758>, <0.242476, -0.759172, 0.318999>, <0.272212, -0.756559, 0.317394>, 
      <0.181869, -0.720761, 0.335477>, <0.217179, -0.725033, 0.331966>, <0.245339, -0.736101, 0.314061>, <0.272992, -0.733573, 0.313189>, 
      <0.183754, -0.711340, 0.337147>, <0.219064, -0.715612, 0.333637>, <0.245625, -0.724880, 0.317044>, <0.273278, -0.722352, 0.316172>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.177472, -0.742743, 0.331579>, <0.181906, -0.738698, 0.339265>, <0.181869, -0.720761, 0.335477>, <0.183754, -0.711340, 0.337147>, 
      <0.158191, -0.738804, 0.334426>, <0.162625, -0.734759, 0.342112>, <0.167794, -0.719058, 0.336876>, <0.169679, -0.709637, 0.338546>, 
      <0.142604, -0.733963, 0.328788>, <0.150795, -0.729709, 0.328828>, <0.152655, -0.715344, 0.330869>, <0.158779, -0.708445, 0.331177>, 
      <0.127660, -0.730200, 0.327592>, <0.135852, -0.725947, 0.327632>, <0.141951, -0.714104, 0.328311>, <0.148076, -0.707205, 0.328619>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.101150, -0.731571, 0.328388>, <0.077822, -0.744373, 0.252184>, <0.081179, -0.832008, 0.170275>, <0.074627, -0.873179, 0.101158>, 
      <0.111989, -0.734897, 0.311320>, <0.088661, -0.747698, 0.235117>, <0.095427, -0.823192, 0.151723>, <0.088875, -0.864363, 0.082606>, 
      <0.135703, -0.737166, 0.294671>, <0.121881, -0.765176, 0.218639>, <0.118018, -0.822653, 0.133465>, <0.111276, -0.856166, 0.058713>, 
      <0.154164, -0.738332, 0.285857>, <0.140342, -0.766342, 0.209825>, <0.130825, -0.817424, 0.112644>, <0.124083, -0.850936, 0.037892>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.101150, -0.731571, 0.328388>, <0.111989, -0.734897, 0.311320>, <0.135703, -0.737166, 0.294671>, <0.154164, -0.738332, 0.285857>, 
      <0.096935, -0.730278, 0.335025>, <0.107775, -0.733604, 0.317957>, <0.138301, -0.731900, 0.308965>, <0.156762, -0.733066, 0.300151>, 
      <0.120589, -0.733872, 0.327557>, <0.135533, -0.737634, 0.328753>, <0.151165, -0.745213, 0.322247>, <0.170446, -0.749153, 0.319400>, 
      <0.127660, -0.730200, 0.327592>, <0.142604, -0.733963, 0.328788>, <0.158191, -0.738804, 0.334426>, <0.177472, -0.742743, 0.331579>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.101150, -0.731571, 0.328388>, <0.062356, -0.747023, 0.315946>, <0.072274, -0.826923, 0.355905>, <0.048747, -0.859679, 0.372398>, 
      <0.077822, -0.744373, 0.252184>, <0.039028, -0.759825, 0.239743>, <0.060113, -0.842478, 0.291169>, <0.036586, -0.875234, 0.307662>, 
      <0.081179, -0.832008, 0.170275>, <0.069069, -0.839501, 0.186042>, <0.052822, -0.880774, 0.204699>, <0.038871, -0.890122, 0.217715>, 
      <0.074627, -0.873179, 0.101158>, <0.062517, -0.880672, 0.116926>, <0.050598, -0.895692, 0.138721>, <0.036647, -0.905039, 0.151737>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.273984, -0.742486, 0.245872>, <0.316118, -0.739245, 0.243710>, <0.372559, -0.728888, 0.256758>, <0.410382, -0.718624, 0.272712>, 
      <0.279550, -0.738560, 0.263438>, <0.321684, -0.735319, 0.261276>, <0.375631, -0.726382, 0.270494>, <0.413454, -0.716118, 0.286449>, 
      <0.272506, -0.764944, 0.288118>, <0.319403, -0.760824, 0.285587>, <0.376559, -0.741311, 0.296703>, <0.420660, -0.727456, 0.305965>, 
      <0.272324, -0.759757, 0.306229>, <0.319221, -0.755637, 0.303698>, <0.380061, -0.734924, 0.309006>, <0.424162, -0.721069, 0.318268>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.273984, -0.742486, 0.245872>, <0.245410, -0.762639, 0.155696>, <0.168137, -0.830319, 0.055033>, <0.162220, -0.837411, -0.041242>, 
      <0.316118, -0.739245, 0.243710>, <0.287544, -0.759398, 0.153535>, <0.223576, -0.809420, 0.068180>, <0.217659, -0.816511, -0.028096>, 
      <0.372559, -0.728888, 0.256758>, <0.353973, -0.744049, 0.173641>, <0.310245, -0.796662, 0.068631>, <0.297234, -0.801177, -0.016775>, 
      <0.410382, -0.718624, 0.272712>, <0.391796, -0.733785, 0.189595>, <0.365318, -0.775167, 0.082342>, <0.352307, -0.779682, -0.003063>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.273984, -0.742486, 0.245872>, <0.279550, -0.738560, 0.263438>, <0.272506, -0.764944, 0.288118>, <0.272324, -0.759757, 0.306229>, 
      <0.236230, -0.745390, 0.247809>, <0.241796, -0.741464, 0.265375>, <0.242770, -0.767557, 0.289722>, <0.242588, -0.762370, 0.307833>, 
      <0.188324, -0.740489, 0.269548>, <0.190923, -0.735224, 0.283842>, <0.207735, -0.756771, 0.313893>, <0.214762, -0.750362, 0.326072>, 
      <0.154164, -0.738332, 0.285857>, <0.156762, -0.733066, 0.300151>, <0.170446, -0.749153, 0.319400>, <0.177472, -0.742743, 0.331579>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.273984, -0.742486, 0.245872>, <0.236230, -0.745390, 0.247809>, <0.188324, -0.740489, 0.269548>, <0.154164, -0.738332, 0.285857>, 
      <0.245410, -0.762639, 0.155696>, <0.207656, -0.765543, 0.157633>, <0.174503, -0.768499, 0.193516>, <0.140342, -0.766342, 0.209825>, 
      <0.168137, -0.830319, 0.055033>, <0.166458, -0.829398, 0.081628>, <0.144486, -0.811845, 0.090436>, <0.130825, -0.817424, 0.112644>, 
      <0.162220, -0.837411, -0.041242>, <0.160541, -0.836490, -0.014647>, <0.137744, -0.845358, 0.015683>, <0.124083, -0.850936, 0.037892>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.217475, 0.841036, 0.282240>, <0.198762, 0.820057, 0.081995>, <0.116747, 0.701785, -0.160480>, <0.099950, 0.673699, -0.360023>, 
      <0.153208, 0.854925, 0.291707>, <0.134495, 0.833947, 0.091462>, <0.087590, 0.709662, -0.161404>, <0.070793, 0.681576, -0.360947>, 
      <0.066941, 0.875801, 0.308665>, <0.066941, 0.853016, 0.100260>, <0.030733, 0.720679, -0.157352>, <0.030733, 0.689090, -0.364606>, 
      <0.000517, 0.876606, 0.308590>, <0.000517, 0.853821, 0.100185>, <0.000517, 0.720679, -0.157352>, <0.000517, 0.689090, -0.364606>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.217475, 0.841036, 0.282240>, <0.153208, 0.854925, 0.291707>, <0.066941, 0.875801, 0.308665>, <0.000517, 0.876606, 0.308590>, 
      <0.231438, 0.856690, 0.431659>, <0.167172, 0.870579, 0.441126>, <0.066941, 0.892680, 0.463051>, <0.000517, 0.893485, 0.462976>, 
      <0.208509, 0.849483, 0.642741>, <0.148194, 0.860086, 0.659531>, <0.064016, 0.879506, 0.680047>, <0.000517, 0.879506, 0.680047>, 
      <0.206749, 0.793428, 0.782815>, <0.146435, 0.804031, 0.799606>, <0.064016, 0.818937, 0.823055>, <0.000517, 0.818937, 0.823055>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.206497, 0.491323, 1.156127>, <0.209984, 0.616487, 1.084863>, <0.205069, 0.739904, 0.916565>, <0.206749, 0.793428, 0.782815>, 
      <0.146451, 0.498883, 1.171431>, <0.149939, 0.624046, 1.100167>, <0.144755, 0.750506, 0.933355>, <0.146435, 0.804031, 0.799606>, 
      <0.062941, 0.507086, 1.181063>, <0.062941, 0.632809, 1.114118>, <0.064016, 0.763388, 0.954212>, <0.064016, 0.818937, 0.823055>, 
      <0.000517, 0.507086, 1.181063>, <0.000517, 0.632809, 1.114118>, <0.000517, 0.763388, 0.954212>, <0.000517, 0.818937, 0.823055>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.506145, -0.381058, -0.405403>, <0.486090, -0.299742, -0.471081>, <0.456120, -0.102117, -0.449555>, <0.444215, -0.061871, -0.547365>, 
      <0.541080, -0.287350, -0.352287>, <0.521024, -0.206034, -0.417965>, <0.471866, -0.069956, -0.433527>, <0.459961, -0.029710, -0.531337>, 
      <0.565117, -0.141929, -0.305059>, <0.541869, -0.096076, -0.375831>, <0.485921, 0.007321, -0.423953>, <0.473504, 0.016825, -0.510017>, 
      <0.581382, -0.049039, -0.242370>, <0.558134, -0.003186, -0.313142>, <0.493033, 0.043379, -0.410227>, <0.480615, 0.052883, -0.496291>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.506145, -0.381058, -0.405403>, <0.488946, -0.427193, -0.431554>, <0.440636, -0.468722, -0.475978>, <0.410452, -0.507535, -0.502258>, 
      <0.486090, -0.299742, -0.471081>, <0.468890, -0.345877, -0.497232>, <0.428849, -0.391368, -0.535591>, <0.398665, -0.430181, -0.561871>, 
      <0.456120, -0.102117, -0.449555>, <0.432977, -0.149384, -0.473112>, <0.390173, -0.210310, -0.514671>, <0.360532, -0.253171, -0.539349>, 
      <0.444215, -0.061871, -0.547365>, <0.421072, -0.109138, -0.570922>, <0.381454, -0.167325, -0.602721>, <0.351813, -0.210187, -0.627398>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.549735, -0.489710, -0.201805>, <0.539241, -0.468419, -0.268143>, <0.519421, -0.434888, -0.361926>, <0.506145, -0.381058, -0.405403>, 
      <0.583892, -0.411714, -0.167510>, <0.573398, -0.390423, -0.233848>, <0.554356, -0.341180, -0.308809>, <0.541080, -0.287350, -0.352287>, 
      <0.605283, -0.299329, -0.119166>, <0.595581, -0.260788, -0.179675>, <0.584357, -0.179877, -0.246487>, <0.565117, -0.141929, -0.305059>, 
      <0.618751, -0.219568, -0.075771>, <0.609048, -0.181028, -0.136280>, <0.600622, -0.086987, -0.183798>, <0.581382, -0.049039, -0.242370>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.583809, -0.538630, 0.085570>, <0.612812, -0.465391, 0.099887>, <0.629941, -0.358253, 0.106575>, <0.639508, -0.279927, 0.120129>, 
      <0.588956, -0.544182, 0.148670>, <0.617959, -0.470943, 0.162987>, <0.633162, -0.365903, 0.141565>, <0.642730, -0.287577, 0.155119>, 
      <0.585174, -0.543706, 0.234723>, <0.606681, -0.472399, 0.213317>, <0.635802, -0.365782, 0.205838>, <0.644931, -0.288861, 0.203562>, 
      <0.590441, -0.533619, 0.297248>, <0.611949, -0.462312, 0.275842>, <0.638645, -0.365399, 0.241685>, <0.647773, -0.288477, 0.239409>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.583809, -0.538630, 0.085570>, <0.576678, -0.530938, -0.001851>, <0.562849, -0.516316, -0.118904>, <0.549735, -0.489710, -0.201805>, 
      <0.612812, -0.465391, 0.099887>, <0.605682, -0.457699, 0.012466>, <0.597005, -0.438320, -0.084609>, <0.583892, -0.411714, -0.167510>, 
      <0.629941, -0.358253, 0.106575>, <0.624403, -0.345104, 0.046433>, <0.613567, -0.332235, -0.067502>, <0.605283, -0.299329, -0.119166>, 
      <0.639508, -0.279927, 0.120129>, <0.633970, -0.266778, 0.059987>, <0.627035, -0.252474, -0.024107>, <0.618751, -0.219568, -0.075771>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.610854, -0.486838, 0.406621>, <0.606115, -0.507368, 0.377174>, <0.593442, -0.527872, 0.332872>, <0.590441, -0.533619, 0.297248>, 
      <0.634011, -0.429312, 0.380946>, <0.629272, -0.449843, 0.351499>, <0.614950, -0.456566, 0.311466>, <0.611949, -0.462312, 0.275842>, 
      <0.650568, -0.344200, 0.346876>, <0.647811, -0.356457, 0.318272>, <0.641114, -0.365065, 0.272826>, <0.638645, -0.365399, 0.241685>, 
      <0.657144, -0.277547, 0.342545>, <0.654387, -0.289804, 0.313942>, <0.650242, -0.288144, 0.270550>, <0.647773, -0.288477, 0.239409>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.639358, -0.321685, 0.601232>, <0.653910, -0.287977, 0.556271>, <0.665714, -0.249395, 0.477431>, <0.668869, -0.194697, 0.458256>, 
      <0.647014, -0.251004, 0.650095>, <0.661566, -0.217296, 0.605134>, <0.667694, -0.190714, 0.515747>, <0.670848, -0.136016, 0.496572>, 
      <0.651928, -0.140432, 0.704658>, <0.662524, -0.124577, 0.652888>, <0.664995, -0.068391, 0.577792>, <0.667884, -0.044775, 0.528015>, 
      <0.657695, -0.054363, 0.705599>, <0.668291, -0.038507, 0.653829>, <0.664437, 0.000741, 0.589454>, <0.667327, 0.024357, 0.539677>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.639358, -0.321685, 0.601232>, <0.632521, -0.384813, 0.557590>, <0.620937, -0.443152, 0.469282>, <0.610854, -0.486838, 0.406621>, 
      <0.653910, -0.287977, 0.556271>, <0.647073, -0.351106, 0.512629>, <0.644094, -0.385626, 0.443607>, <0.634011, -0.429312, 0.380946>, 
      <0.665714, -0.249395, 0.477431>, <0.664505, -0.285250, 0.454019>, <0.654349, -0.327392, 0.386098>, <0.650568, -0.344200, 0.346876>, 
      <0.668869, -0.194697, 0.458256>, <0.667660, -0.230552, 0.434844>, <0.660925, -0.260740, 0.381767>, <0.657144, -0.277547, 0.342545>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.594905, 0.270397, 0.013847>, <0.612298, 0.269414, 0.079275>, <0.643834, 0.281091, 0.165285>, <0.652785, 0.273520, 0.231970>, 
      <0.598918, 0.221010, -0.012255>, <0.616311, 0.220027, 0.053174>, <0.650695, 0.230638, 0.123397>, <0.659646, 0.223067, 0.190082>, 
      <0.593426, 0.150522, -0.041099>, <0.609036, 0.142402, 0.015628>, <0.636590, 0.147920, 0.090351>, <0.651277, 0.144670, 0.147807>, 
      <0.591578, 0.106858, -0.076121>, <0.607188, 0.098738, -0.019394>, <0.632736, 0.092082, 0.055502>, <0.647423, 0.088832, 0.112958>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.594905, 0.270397, 0.013847>, <0.598918, 0.221010, -0.012255>, <0.593426, 0.150522, -0.041099>, <0.591578, 0.106858, -0.076121>, 
      <0.559633, 0.272390, -0.118839>, <0.563645, 0.223003, -0.144941>, <0.561804, 0.166971, -0.156016>, <0.559956, 0.123307, -0.191038>, 
      <0.494665, 0.283369, -0.292079>, <0.504712, 0.250755, -0.300942>, <0.504440, 0.198190, -0.329635>, <0.504931, 0.164376, -0.339610>, 
      <0.477269, 0.283437, -0.428282>, <0.487316, 0.250823, -0.437144>, <0.489588, 0.204491, -0.448866>, <0.490079, 0.170677, -0.458841>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.660785, 0.091543, 0.194622>, <0.654402, -0.019898, 0.172274>, <0.653112, -0.168559, 0.139401>, <0.639508, -0.279927, 0.120129>, 
      <0.658127, 0.090329, 0.169956>, <0.651744, -0.021112, 0.147608>, <0.647574, -0.155410, 0.079260>, <0.633970, -0.266778, 0.059987>, 
      <0.653565, 0.087473, 0.136987>, <0.647205, -0.004677, 0.079475>, <0.642999, -0.157929, 0.027331>, <0.627035, -0.252474, -0.024107>, 
      <0.647423, 0.088832, 0.112958>, <0.641063, -0.003318, 0.055446>, <0.634715, -0.125023, -0.024332>, <0.618751, -0.219568, -0.075771>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.665274, 0.096985, 0.278592>, <0.660024, -0.018654, 0.266837>, <0.661478, -0.172985, 0.235992>, <0.647773, -0.288477, 0.239409>, 
      <0.663874, 0.093239, 0.253631>, <0.658623, -0.022399, 0.241876>, <0.658636, -0.173368, 0.200145>, <0.644931, -0.288861, 0.203562>, 
      <0.663491, 0.092779, 0.219726>, <0.657107, -0.018662, 0.197378>, <0.656334, -0.176209, 0.174392>, <0.642730, -0.287577, 0.155119>, 
      <0.660785, 0.091543, 0.194622>, <0.654402, -0.019898, 0.172274>, <0.653112, -0.168559, 0.139401>, <0.639508, -0.279927, 0.120129>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.670476, 0.117465, 0.367358>, <0.670538, 0.122722, 0.389522>, <0.666374, 0.129259, 0.419065>, <0.665725, 0.135499, 0.440963>, 
      <0.666477, -0.001039, 0.359914>, <0.666538, 0.004219, 0.382078>, <0.667317, 0.030200, 0.424253>, <0.666668, 0.036440, 0.446151>, 
      <0.668785, -0.159563, 0.334879>, <0.672566, -0.142756, 0.374101>, <0.673051, -0.137077, 0.402076>, <0.674260, -0.101222, 0.425488>, 
      <0.657144, -0.277547, 0.342545>, <0.660925, -0.260740, 0.381767>, <0.667660, -0.230552, 0.434844>, <0.668869, -0.194697, 0.458256>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.670476, 0.117465, 0.367358>, <0.666477, -0.001039, 0.359914>, <0.668785, -0.159563, 0.334879>, <0.657144, -0.277547, 0.342545>, 
      <0.670402, 0.111147, 0.340723>, <0.666403, -0.007356, 0.333279>, <0.666027, -0.171820, 0.306276>, <0.654387, -0.289804, 0.313942>, 
      <0.666790, 0.101041, 0.305621>, <0.661540, -0.014597, 0.293866>, <0.663948, -0.172651, 0.267134>, <0.650242, -0.288144, 0.270550>, 
      <0.665274, 0.096985, 0.278592>, <0.660024, -0.018654, 0.266837>, <0.661478, -0.172985, 0.235992>, <0.647773, -0.288477, 0.239409>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.421777, -0.669354, -0.273542>, <0.413764, -0.638652, -0.351449>, <0.420531, -0.573685, -0.451280>, <0.410452, -0.507535, -0.502258>, 
      <0.465999, -0.618549, -0.256092>, <0.457986, -0.587848, -0.333998>, <0.450715, -0.534872, -0.424999>, <0.440636, -0.468722, -0.475978>, 
      <0.523845, -0.548830, -0.227800>, <0.513351, -0.527540, -0.294138>, <0.502222, -0.481023, -0.388076>, <0.488946, -0.427193, -0.431554>, 
      <0.549735, -0.489710, -0.201805>, <0.539241, -0.468419, -0.268143>, <0.519421, -0.434888, -0.361926>, <0.506145, -0.381058, -0.405403>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.421777, -0.669354, -0.273542>, <0.397663, -0.697058, -0.283058>, <0.356681, -0.728401, -0.287996>, <0.324554, -0.748408, -0.290661>, 
      <0.413764, -0.638652, -0.351449>, <0.389650, -0.666356, -0.360964>, <0.354893, -0.699191, -0.373702>, <0.322766, -0.719199, -0.376367>, 
      <0.420531, -0.573685, -0.451280>, <0.401013, -0.598784, -0.468274>, <0.368628, -0.636447, -0.476830>, <0.347117, -0.662026, -0.490346>, 
      <0.410452, -0.507535, -0.502258>, <0.390933, -0.532634, -0.519253>, <0.362422, -0.567953, -0.535753>, <0.340910, -0.593532, -0.549270>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.465639, -0.718984, 0.034301>, <0.482763, -0.719470, 0.131949>, <0.523054, -0.687500, 0.257096>, <0.531949, -0.672482, 0.354686>, 
      <0.438748, -0.746985, 0.024005>, <0.455872, -0.747471, 0.121653>, <0.491036, -0.720397, 0.252733>, <0.499931, -0.705380, 0.350323>, 
      <0.388755, -0.765456, 0.006012>, <0.401766, -0.760941, 0.091417>, <0.433015, -0.722599, 0.206982>, <0.451601, -0.707438, 0.290099>, 
      <0.352307, -0.779682, -0.003063>, <0.365318, -0.775167, 0.082342>, <0.391796, -0.733785, 0.189595>, <0.410382, -0.718624, 0.272712>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.465639, -0.718984, 0.034301>, <0.438748, -0.746985, 0.024005>, <0.388755, -0.765456, 0.006012>, <0.352307, -0.779682, -0.003063>, 
      <0.449322, -0.718521, -0.058744>, <0.422430, -0.746522, -0.069040>, <0.375642, -0.770007, -0.080063>, <0.339194, -0.784233, -0.089137>, 
      <0.430775, -0.703832, -0.186054>, <0.406661, -0.731536, -0.195569>, <0.358403, -0.756520, -0.205486>, <0.326276, -0.776528, -0.208152>, 
      <0.421777, -0.669354, -0.273542>, <0.397663, -0.697058, -0.283058>, <0.356681, -0.728401, -0.287996>, <0.324554, -0.748408, -0.290661>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.465639, -0.718984, 0.034301>, <0.449322, -0.718521, -0.058744>, <0.430775, -0.703832, -0.186054>, <0.421777, -0.669354, -0.273542>, 
      <0.510156, -0.672631, 0.051345>, <0.493838, -0.672168, -0.041701>, <0.474998, -0.653027, -0.168604>, <0.465999, -0.618549, -0.256092>, 
      <0.559723, -0.599452, 0.073680>, <0.552593, -0.591760, -0.013741>, <0.536958, -0.575436, -0.144899>, <0.523845, -0.548830, -0.227800>, 
      <0.583809, -0.538630, 0.085570>, <0.576678, -0.530938, -0.001851>, <0.562849, -0.516316, -0.118904>, <0.549735, -0.489710, -0.201805>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.465639, -0.718984, 0.034301>, <0.510156, -0.672631, 0.051345>, <0.559723, -0.599452, 0.073680>, <0.583809, -0.538630, 0.085570>, 
      <0.482763, -0.719470, 0.131949>, <0.527280, -0.673117, 0.148992>, <0.564870, -0.605004, 0.136780>, <0.588956, -0.544182, 0.148670>, 
      <0.523054, -0.687500, 0.257096>, <0.556643, -0.652987, 0.261673>, <0.571748, -0.588219, 0.248086>, <0.585174, -0.543706, 0.234723>, 
      <0.531949, -0.672482, 0.354686>, <0.565539, -0.637970, 0.359263>, <0.577015, -0.578133, 0.310611>, <0.590441, -0.533619, 0.297248>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.508734, -0.646229, 0.507096>, <0.505654, -0.668781, 0.466071>, <0.536159, -0.665375, 0.400869>, <0.531949, -0.672482, 0.354686>, 
      <0.550339, -0.602046, 0.485871>, <0.547259, -0.624598, 0.444845>, <0.569748, -0.630863, 0.405446>, <0.565539, -0.637970, 0.359263>, 
      <0.588672, -0.541944, 0.431216>, <0.583933, -0.562474, 0.401769>, <0.580016, -0.572386, 0.346235>, <0.577015, -0.578133, 0.310611>, 
      <0.610854, -0.486838, 0.406621>, <0.606115, -0.507368, 0.377174>, <0.593442, -0.527872, 0.332872>, <0.590441, -0.533619, 0.297248>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.564041, -0.437511, 0.782138>, <0.552342, -0.519937, 0.718315>, <0.515621, -0.595805, 0.598826>, <0.508734, -0.646229, 0.507096>, 
      <0.595828, -0.408179, 0.729293>, <0.584129, -0.490605, 0.665470>, <0.557226, -0.551622, 0.577600>, <0.550339, -0.602046, 0.485871>, 
      <0.622238, -0.361340, 0.654126>, <0.615401, -0.424468, 0.610484>, <0.598755, -0.498258, 0.493877>, <0.588672, -0.541944, 0.431216>, 
      <0.639358, -0.321685, 0.601232>, <0.632521, -0.384813, 0.557590>, <0.620937, -0.443152, 0.469282>, <0.610854, -0.486838, 0.406621>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.586813, -0.096123, 0.933049>, <0.582777, -0.207972, 0.925373>, <0.576552, -0.349362, 0.850393>, <0.564041, -0.437511, 0.782138>, 
      <0.616154, -0.091814, 0.866825>, <0.612118, -0.203663, 0.859149>, <0.608340, -0.320031, 0.797547>, <0.595828, -0.408179, 0.729293>, 
      <0.643759, -0.075217, 0.773688>, <0.637992, -0.161286, 0.772747>, <0.629894, -0.290658, 0.702990>, <0.622238, -0.361340, 0.654126>, 
      <0.657695, -0.054363, 0.705599>, <0.651928, -0.140432, 0.704658>, <0.647014, -0.251004, 0.650095>, <0.639358, -0.321685, 0.601232>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.586813, -0.096123, 0.933049>, <0.616154, -0.091814, 0.866825>, <0.643759, -0.075217, 0.773688>, <0.657695, -0.054363, 0.705599>, 
      <0.591545, 0.034990, 0.942047>, <0.620886, 0.039299, 0.875823>, <0.649298, 0.007448, 0.774591>, <0.663234, 0.028302, 0.706503>, 
      <0.591881, 0.223471, 0.910493>, <0.625588, 0.187579, 0.844602>, <0.658604, 0.194108, 0.746012>, <0.675225, 0.155900, 0.675090>, 
      <0.591777, 0.331069, 0.834885>, <0.625485, 0.295177, 0.768994>, <0.657897, 0.241267, 0.677891>, <0.674519, 0.203059, 0.606969>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.556742, 0.535632, 0.150492>, <0.577695, 0.544949, 0.249125>, <0.581241, 0.567998, 0.389825>, <0.586202, 0.539033, 0.486731>, 
      <0.578689, 0.455348, 0.115625>, <0.599643, 0.464665, 0.214258>, <0.616228, 0.491106, 0.316011>, <0.621188, 0.462141, 0.412916>, 
      <0.588440, 0.349973, 0.055904>, <0.605833, 0.348991, 0.121333>, <0.632160, 0.366935, 0.236556>, <0.641111, 0.359364, 0.303241>, 
      <0.594905, 0.270397, 0.013847>, <0.612298, 0.269414, 0.079275>, <0.643834, 0.281091, 0.165285>, <0.652785, 0.273520, 0.231970>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.556742, 0.535632, 0.150492>, <0.578689, 0.455348, 0.115625>, <0.588440, 0.349973, 0.055904>, <0.594905, 0.270397, 0.013847>, 
      <0.522031, 0.520198, -0.012900>, <0.543979, 0.439913, -0.047767>, <0.553168, 0.351966, -0.076782>, <0.559633, 0.272390, -0.118839>, 
      <0.424676, 0.469750, -0.215315>, <0.456032, 0.421651, -0.226686>, <0.477987, 0.337511, -0.277367>, <0.494665, 0.283369, -0.292079>, 
      <0.401858, 0.457063, -0.381021>, <0.433214, 0.408965, -0.392392>, <0.460591, 0.337579, -0.413570>, <0.477269, 0.283437, -0.428282>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.280183, -0.662438, -0.584111>, <0.299556, -0.643055, -0.573272>, <0.323326, -0.614441, -0.560319>, <0.340910, -0.593532, -0.549270>, 
      <0.282699, -0.732220, -0.517719>, <0.302072, -0.712837, -0.506880>, <0.329533, -0.682935, -0.501395>, <0.347117, -0.662026, -0.490346>, 
      <0.260652, -0.752903, -0.378334>, <0.286011, -0.743741, -0.378886>, <0.299930, -0.733420, -0.378262>, <0.322766, -0.719199, -0.376367>, 
      <0.241138, -0.781849, -0.288528>, <0.266496, -0.772687, -0.289080>, <0.301718, -0.762629, -0.292556>, <0.324554, -0.748408, -0.290661>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.280183, -0.662438, -0.584111>, <0.277431, -0.586117, -0.656725>, <0.233312, -0.392130, -0.619119>, <0.225173, -0.339069, -0.709803>, 
      <0.299556, -0.643055, -0.573272>, <0.296804, -0.566734, -0.645887>, <0.252175, -0.380140, -0.611454>, <0.244036, -0.327079, -0.702138>, 
      <0.323326, -0.614441, -0.560319>, <0.316500, -0.539120, -0.625116>, <0.276593, -0.355715, -0.603091>, <0.268344, -0.309729, -0.691044>, 
      <0.340910, -0.593532, -0.549270>, <0.334085, -0.518211, -0.614067>, <0.291661, -0.340380, -0.593286>, <0.283412, -0.294394, -0.681239>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.280183, -0.662438, -0.584111>, <0.282699, -0.732220, -0.517719>, <0.260652, -0.752903, -0.378334>, <0.241138, -0.781849, -0.288528>, 
      <0.264799, -0.677830, -0.592718>, <0.267315, -0.747611, -0.526325>, <0.252459, -0.755424, -0.395402>, <0.232945, -0.784370, -0.305596>, 
      <0.242057, -0.695439, -0.605075>, <0.249841, -0.757085, -0.548226>, <0.228288, -0.763532, -0.411184>, <0.224845, -0.786584, -0.330256>, 
      <0.225319, -0.709183, -0.613940>, <0.233103, -0.770829, -0.557091>, <0.217271, -0.767199, -0.426349>, <0.213828, -0.790251, -0.345421>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.280183, -0.662438, -0.584111>, <0.264799, -0.677830, -0.592718>, <0.242057, -0.695439, -0.605075>, <0.225319, -0.709183, -0.613940>, 
      <0.277431, -0.586117, -0.656725>, <0.262047, -0.601509, -0.665332>, <0.232006, -0.615839, -0.678481>, <0.215268, -0.629583, -0.687347>, 
      <0.233312, -0.392130, -0.619119>, <0.215299, -0.403580, -0.626438>, <0.189592, -0.422209, -0.634354>, <0.169190, -0.430381, -0.639465>, 
      <0.225173, -0.339069, -0.709803>, <0.207160, -0.350519, -0.717122>, <0.181442, -0.364007, -0.725852>, <0.161040, -0.372179, -0.730963>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.311478, -0.755028, 0.456659>, <0.238060, -0.765098, 0.452177>, <0.167250, -0.705242, 0.349587>, <0.101150, -0.731571, 0.328388>, 
      <0.306610, -0.753873, 0.436665>, <0.233192, -0.763943, 0.432183>, <0.163035, -0.703949, 0.356223>, <0.096935, -0.730278, 0.335025>, 
      <0.307018, -0.781345, 0.403100>, <0.235250, -0.789480, 0.397971>, <0.172538, -0.744866, 0.346227>, <0.120589, -0.733872, 0.327557>, 
      <0.300821, -0.766848, 0.389825>, <0.229053, -0.774982, 0.384696>, <0.179608, -0.741194, 0.346262>, <0.127660, -0.730200, 0.327592>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.311478, -0.755028, 0.456659>, <0.306610, -0.753873, 0.436665>, <0.307018, -0.781345, 0.403100>, <0.300821, -0.766848, 0.389825>, 
      <0.387591, -0.744588, 0.461305>, <0.382723, -0.743433, 0.441311>, <0.390498, -0.771884, 0.409067>, <0.384301, -0.757386, 0.395791>, 
      <0.465808, -0.697246, 0.385278>, <0.456565, -0.701862, 0.385157>, <0.450789, -0.708228, 0.365761>, <0.441044, -0.711563, 0.364946>, 
      <0.531949, -0.672482, 0.354686>, <0.522706, -0.677098, 0.354565>, <0.510884, -0.684534, 0.355099>, <0.501139, -0.687870, 0.354284>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.338714, -0.775838, 0.545457>, <0.333279, -0.787409, 0.519923>, <0.318223, -0.756628, 0.484360>, <0.311478, -0.755028, 0.456659>, 
      <0.396531, -0.746274, 0.540068>, <0.391096, -0.757845, 0.514534>, <0.394336, -0.746188, 0.489006>, <0.387591, -0.744588, 0.461305>, 
      <0.466568, -0.691008, 0.528608>, <0.463487, -0.713560, 0.487583>, <0.470017, -0.690139, 0.431461>, <0.465808, -0.697246, 0.385278>, 
      <0.508734, -0.646229, 0.507096>, <0.505654, -0.668781, 0.466071>, <0.536159, -0.665375, 0.400869>, <0.531949, -0.672482, 0.354686>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.419912, -0.524179, 0.966055>, <0.399683, -0.636041, 0.869659>, <0.367084, -0.715441, 0.678731>, <0.338714, -0.775838, 0.545457>, 
      <0.472951, -0.501691, 0.918400>, <0.452722, -0.613553, 0.822003>, <0.424901, -0.685877, 0.673341>, <0.396531, -0.746274, 0.540068>, 
      <0.529239, -0.469625, 0.839995>, <0.517540, -0.552050, 0.776172>, <0.473454, -0.640584, 0.620337>, <0.466568, -0.691008, 0.528608>, 
      <0.564041, -0.437511, 0.782138>, <0.552342, -0.519937, 0.718315>, <0.515621, -0.595805, 0.598826>, <0.508734, -0.646229, 0.507096>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.464043, -0.082802, 1.142677>, <0.456735, -0.225696, 1.136043>, <0.439352, -0.416679, 1.058693>, <0.419912, -0.524179, 0.966055>, 
      <0.512456, -0.088162, 1.088318>, <0.505148, -0.231056, 1.081684>, <0.492392, -0.394191, 1.011038>, <0.472951, -0.501691, 0.918400>, 
      <0.557299, -0.100457, 0.999664>, <0.553262, -0.212307, 0.991988>, <0.541751, -0.381476, 0.908250>, <0.529239, -0.469625, 0.839995>, 
      <0.586813, -0.096123, 0.933049>, <0.582777, -0.207972, 0.925373>, <0.576552, -0.349362, 0.850393>, <0.564041, -0.437511, 0.782138>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.468335, 0.422607, 1.010012>, <0.469685, 0.289872, 1.093407>, <0.472042, 0.073590, 1.149938>, <0.464043, -0.082802, 1.142677>, 
      <0.512652, 0.397911, 0.961929>, <0.514002, 0.265177, 1.045324>, <0.520454, 0.068230, 1.095579>, <0.512456, -0.088162, 1.088318>, 
      <0.563133, 0.361569, 0.890877>, <0.563237, 0.253971, 0.966485>, <0.562030, 0.030655, 1.008662>, <0.557299, -0.100457, 0.999664>, 
      <0.591777, 0.331069, 0.834885>, <0.591881, 0.223471, 0.910493>, <0.591545, 0.034990, 0.942047>, <0.586813, -0.096123, 0.933049>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.468335, 0.422607, 1.010012>, <0.512652, 0.397911, 0.961929>, <0.563133, 0.361569, 0.890877>, <0.591777, 0.331069, 0.834885>, 
      <0.467145, 0.539603, 0.936505>, <0.511462, 0.514908, 0.888422>, <0.563038, 0.461121, 0.820923>, <0.591681, 0.430621, 0.764931>, 
      <0.456372, 0.654359, 0.775286>, <0.504669, 0.611725, 0.728405>, <0.567315, 0.558841, 0.655592>, <0.592163, 0.504231, 0.603168>, 
      <0.456021, 0.705964, 0.647108>, <0.504317, 0.663330, 0.600227>, <0.561354, 0.593643, 0.539156>, <0.586202, 0.539033, 0.486731>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.466167, 0.741324, 0.218367>, <0.487314, 0.757806, 0.344647>, <0.455693, 0.754177, 0.527354>, <0.456021, 0.705964, 0.647108>, 
      <0.506970, 0.688033, 0.197014>, <0.528118, 0.704515, 0.323294>, <0.503990, 0.711543, 0.480473>, <0.504317, 0.663330, 0.600227>, 
      <0.539612, 0.598296, 0.177706>, <0.560565, 0.607613, 0.276339>, <0.556393, 0.622608, 0.442250>, <0.561354, 0.593643, 0.539156>, 
      <0.556742, 0.535632, 0.150492>, <0.577695, 0.544949, 0.249125>, <0.581241, 0.567998, 0.389825>, <0.586202, 0.539033, 0.486731>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.466167, 0.741324, 0.218367>, <0.506970, 0.688033, 0.197014>, <0.539612, 0.598296, 0.177706>, <0.556742, 0.535632, 0.150492>, 
      <0.435335, 0.717295, 0.034256>, <0.476139, 0.664004, 0.012903>, <0.504901, 0.582861, 0.014314>, <0.522031, 0.520198, -0.012900>, 
      <0.313535, 0.600604, -0.174874>, <0.349389, 0.566600, -0.179470>, <0.398090, 0.510531, -0.205674>, <0.424676, 0.469750, -0.215315>, 
      <0.287459, 0.574592, -0.359450>, <0.323313, 0.540588, -0.364045>, <0.375272, 0.497844, -0.371380>, <0.401858, 0.457063, -0.381021>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.105648, -0.778674, -0.658526>, <0.101622, -0.679574, -0.724111>, <0.072987, -0.465746, -0.650318>, <0.065445, -0.393917, -0.744775>, 
      <0.127372, -0.772159, -0.654488>, <0.123346, -0.673059, -0.720073>, <0.085676, -0.463971, -0.649154>, <0.078133, -0.392142, -0.743611>, 
      <0.155284, -0.760433, -0.647285>, <0.147017, -0.668830, -0.715813>, <0.104686, -0.454826, -0.647636>, <0.094869, -0.389114, -0.741130>, 
      <0.174246, -0.749422, -0.640220>, <0.165978, -0.657820, -0.708749>, <0.117108, -0.452001, -0.645841>, <0.107291, -0.386289, -0.739335>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.105648, -0.778674, -0.658526>, <0.127372, -0.772159, -0.654488>, <0.155284, -0.760433, -0.647285>, <0.174246, -0.749422, -0.640220>, 
      <0.107810, -0.831893, -0.623305>, <0.129534, -0.825378, -0.619267>, <0.160289, -0.815880, -0.605804>, <0.179251, -0.804869, -0.598739>, 
      <0.088204, -0.812954, -0.514353>, <0.108822, -0.807830, -0.507885>, <0.135664, -0.798476, -0.499466>, <0.152214, -0.793022, -0.485697>, 
      <0.083294, -0.833262, -0.454013>, <0.103913, -0.828138, -0.447545>, <0.129305, -0.819020, -0.433453>, <0.145856, -0.813566, -0.419685>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.105648, -0.778674, -0.658526>, <0.107810, -0.831893, -0.623305>, <0.088204, -0.812954, -0.514353>, <0.083294, -0.833262, -0.454013>, 
      <0.074955, -0.787879, -0.664232>, <0.077117, -0.841098, -0.629011>, <0.064490, -0.818847, -0.521792>, <0.059581, -0.839155, -0.461452>, 
      <0.033064, -0.801524, -0.672515>, <0.033064, -0.855456, -0.638379>, <0.026059, -0.831050, -0.526327>, <0.026059, -0.849683, -0.465280>, 
      <0.000517, -0.801524, -0.672515>, <0.000517, -0.855456, -0.638379>, <0.000517, -0.831050, -0.526327>, <0.000517, -0.849683, -0.465280>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.105648, -0.778674, -0.658526>, <0.074955, -0.787879, -0.664232>, <0.033064, -0.801524, -0.672515>, <0.000517, -0.801524, -0.672515>, 
      <0.101622, -0.679574, -0.724111>, <0.070929, -0.688779, -0.729817>, <0.033064, -0.698210, -0.737907>, <0.000517, -0.698210, -0.737907>, 
      <0.072987, -0.465746, -0.650318>, <0.053612, -0.468456, -0.652096>, <0.020162, -0.478190, -0.654091>, <0.000517, -0.478147, -0.654088>, 
      <0.065445, -0.393917, -0.744775>, <0.046069, -0.396627, -0.746552>, <0.020162, -0.401267, -0.749132>, <0.000517, -0.401224, -0.749129>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.354191, 0.800171, 0.256492>, <0.314917, 0.815918, 0.266579>, <0.259559, 0.831941, 0.276041>, <0.217475, 0.841036, 0.282240>, 
      <0.369247, 0.817012, 0.397266>, <0.329973, 0.832759, 0.407353>, <0.273522, 0.847595, 0.425460>, <0.231438, 0.856690, 0.431659>, 
      <0.335580, 0.813518, 0.597546>, <0.299418, 0.826206, 0.617233>, <0.249432, 0.842289, 0.631348>, <0.208509, 0.849483, 0.642741>, 
      <0.335912, 0.759978, 0.729686>, <0.299750, 0.772666, 0.749373>, <0.247672, 0.786234, 0.771423>, <0.206749, 0.793428, 0.782815>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.354191, 0.800171, 0.256492>, <0.333555, 0.777089, 0.063548>, <0.239606, 0.657367, -0.165227>, <0.219617, 0.629897, -0.357664>, 
      <0.314917, 0.815918, 0.266579>, <0.294281, 0.792836, 0.073635>, <0.203706, 0.670507, -0.165935>, <0.183717, 0.643038, -0.358372>, 
      <0.259559, 0.831941, 0.276041>, <0.240845, 0.810963, 0.075796>, <0.153643, 0.691817, -0.159311>, <0.136845, 0.663731, -0.358854>, 
      <0.217475, 0.841036, 0.282240>, <0.198762, 0.820057, 0.081995>, <0.116747, 0.701785, -0.160480>, <0.099950, 0.673699, -0.360023>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.354191, 0.800171, 0.256492>, <0.369247, 0.817012, 0.397266>, <0.335580, 0.813518, 0.597546>, <0.335912, 0.759978, 0.729686>, 
      <0.389977, 0.785823, 0.247301>, <0.405033, 0.802664, 0.388075>, <0.374720, 0.799784, 0.576237>, <0.375053, 0.746244, 0.708377>, 
      <0.443205, 0.771313, 0.230383>, <0.464353, 0.787794, 0.356663>, <0.427425, 0.779130, 0.554794>, <0.427753, 0.730918, 0.674547>, 
      <0.466167, 0.741324, 0.218367>, <0.487314, 0.757806, 0.344647>, <0.455693, 0.754177, 0.527354>, <0.456021, 0.705964, 0.647108>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.354191, 0.800171, 0.256492>, <0.389977, 0.785823, 0.247301>, <0.443205, 0.771313, 0.230383>, <0.466167, 0.741324, 0.218367>, 
      <0.333555, 0.777089, 0.063548>, <0.369341, 0.762741, 0.054357>, <0.412374, 0.747283, 0.046273>, <0.435335, 0.717295, 0.034256>, 
      <0.239606, 0.657367, -0.165227>, <0.259959, 0.640775, -0.165763>, <0.294560, 0.618599, -0.172442>, <0.313535, 0.600604, -0.174874>, 
      <0.219617, 0.629897, -0.357664>, <0.239970, 0.613305, -0.358200>, <0.268484, 0.592587, -0.357018>, <0.287459, 0.574592, -0.359450>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.356288, 0.462296, 1.090388>, <0.357892, 0.582634, 1.018011>, <0.336239, 0.707241, 0.859843>, <0.335912, 0.759978, 0.729686>, 
      <0.313865, 0.473430, 1.114062>, <0.315469, 0.593767, 1.041684>, <0.300078, 0.719930, 0.879530>, <0.299750, 0.772666, 0.749373>, 
      <0.254439, 0.485287, 1.143908>, <0.257926, 0.610451, 1.072644>, <0.245992, 0.732710, 0.905172>, <0.247672, 0.786234, 0.771423>, 
      <0.206497, 0.491323, 1.156127>, <0.209984, 0.616487, 1.084863>, <0.205069, 0.739904, 0.916565>, <0.206749, 0.793428, 0.782815>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.356288, 0.462296, 1.090388>, <0.392929, 0.452680, 1.069941>, <0.441042, 0.437816, 1.039625>, <0.468335, 0.422607, 1.010012>, 
      <0.357892, 0.582634, 1.018011>, <0.394533, 0.573018, 0.997564>, <0.439852, 0.554812, 0.966118>, <0.467145, 0.539603, 0.936505>, 
      <0.336239, 0.707241, 0.859843>, <0.375380, 0.693508, 0.838535>, <0.428104, 0.679313, 0.802725>, <0.456372, 0.654359, 0.775286>, 
      <0.335912, 0.759978, 0.729686>, <0.375053, 0.746244, 0.708377>, <0.427753, 0.730918, 0.674547>, <0.456021, 0.705964, 0.647108>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.324885, -0.067123, 1.227148>, <0.369366, -0.069652, 1.206600>, <0.431500, -0.079199, 1.179217>, <0.464043, -0.082802, 1.142677>, 
      <0.334599, 0.096536, 1.238055>, <0.379080, 0.094007, 1.217508>, <0.439499, 0.077193, 1.186478>, <0.472042, 0.073590, 1.149938>, 
      <0.354411, 0.321501, 1.175069>, <0.391052, 0.311885, 1.154622>, <0.442392, 0.305081, 1.123020>, <0.469685, 0.289872, 1.093407>, 
      <0.356288, 0.462296, 1.090388>, <0.392929, 0.452680, 1.069941>, <0.441042, 0.437816, 1.039625>, <0.468335, 0.422607, 1.010012>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.296137, -0.551099, 1.022849>, <0.334312, -0.542719, 1.008468>, <0.390369, -0.536705, 0.992600>, <0.419912, -0.524179, 0.966055>, 
      <0.314393, -0.437087, 1.130458>, <0.352567, -0.428707, 1.116077>, <0.409809, -0.429205, 1.085238>, <0.439352, -0.416679, 1.058693>, 
      <0.315554, -0.224333, 1.216671>, <0.360034, -0.226862, 1.196123>, <0.424192, -0.222093, 1.172582>, <0.456735, -0.225696, 1.136043>, 
      <0.324885, -0.067123, 1.227148>, <0.369366, -0.069652, 1.206600>, <0.431500, -0.079199, 1.179217>, <0.464043, -0.082802, 1.142677>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.207492, -0.800267, 0.535177>, <0.188417, -0.817922, 0.467240>, <0.122173, -0.720034, 0.397061>, <0.101150, -0.731571, 0.328388>, 
      <0.246267, -0.792828, 0.542535>, <0.227191, -0.810483, 0.474598>, <0.188272, -0.693706, 0.418260>, <0.167250, -0.705242, 0.349587>, 
      <0.303079, -0.794060, 0.548779>, <0.297643, -0.805631, 0.523245>, <0.244804, -0.766698, 0.479878>, <0.238060, -0.765098, 0.452177>, 
      <0.338714, -0.775838, 0.545457>, <0.333279, -0.787409, 0.519923>, <0.318223, -0.756628, 0.484360>, <0.311478, -0.755028, 0.456659>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.207492, -0.800267, 0.535177>, <0.246267, -0.792828, 0.542535>, <0.303079, -0.794060, 0.548779>, <0.338714, -0.775838, 0.545457>, 
      <0.251136, -0.759872, 0.690620>, <0.289911, -0.752432, 0.697978>, <0.331448, -0.733663, 0.682052>, <0.367084, -0.715441, 0.678731>, 
      <0.276887, -0.671320, 0.909380>, <0.315061, -0.662940, 0.894998>, <0.370139, -0.648567, 0.896204>, <0.399683, -0.636041, 0.869659>, 
      <0.296137, -0.551099, 1.022849>, <0.334312, -0.542719, 1.008468>, <0.390369, -0.536705, 0.992600>, <0.419912, -0.524179, 0.966055>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.090226, -0.869399, -0.114403>, <0.095569, -0.862539, -0.159024>, <0.121970, -0.862820, -0.215583>, <0.131003, -0.859195, -0.259989>, 
      <0.069062, -0.875498, -0.101701>, <0.074404, -0.868639, -0.146322>, <0.098338, -0.875494, -0.210102>, <0.107371, -0.871870, -0.254508>, 
      <0.062554, -0.879547, -0.054079>, <0.061895, -0.867918, -0.110407>, <0.072386, -0.885836, -0.184118>, <0.075182, -0.886596, -0.241565>, 
      <0.037896, -0.883401, -0.049223>, <0.037237, -0.871772, -0.105551>, <0.045861, -0.892490, -0.182952>, <0.048658, -0.893250, -0.240399>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.090226, -0.869399, -0.114403>, <0.069062, -0.875498, -0.101701>, <0.062554, -0.879547, -0.054079>, <0.037896, -0.883401, -0.049223>, 
      <0.088791, -0.871242, -0.102417>, <0.067627, -0.877341, -0.089715>, <0.062727, -0.882597, -0.039305>, <0.038069, -0.886451, -0.034449>, 
      <0.109606, -0.881784, -0.094336>, <0.091419, -0.895024, -0.091736>, <0.066345, -0.905195, -0.077426>, <0.047787, -0.917354, -0.072886>, 
      <0.109815, -0.886400, -0.083032>, <0.091627, -0.899640, -0.080432>, <0.069274, -0.917400, -0.069057>, <0.050716, -0.929560, -0.064517>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.090226, -0.869399, -0.114403>, <0.088791, -0.871242, -0.102417>, <0.109606, -0.881784, -0.094336>, <0.109815, -0.886400, -0.083032>, 
      <0.101646, -0.866108, -0.121257>, <0.100211, -0.867950, -0.109271>, <0.118643, -0.875206, -0.095627>, <0.118852, -0.879822, -0.084324>, 
      <0.124009, -0.860018, -0.115753>, <0.121277, -0.862365, -0.107127>, <0.130833, -0.867394, -0.091824>, <0.131969, -0.870295, -0.083011>, 
      <0.133196, -0.855936, -0.106417>, <0.130464, -0.858283, -0.097791>, <0.138705, -0.861779, -0.086070>, <0.139841, -0.864680, -0.077257>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.090226, -0.869399, -0.114403>, <0.101646, -0.866108, -0.121257>, <0.124009, -0.860018, -0.115753>, <0.133196, -0.855936, -0.106417>, 
      <0.095569, -0.862539, -0.159024>, <0.106989, -0.859248, -0.165877>, <0.140580, -0.845781, -0.168076>, <0.149767, -0.841699, -0.158740>, 
      <0.121970, -0.862820, -0.215583>, <0.144827, -0.850561, -0.220885>, <0.162659, -0.839683, -0.219174>, <0.183852, -0.824799, -0.224665>, 
      <0.131003, -0.859195, -0.259989>, <0.153860, -0.846936, -0.265291>, <0.181644, -0.825444, -0.270669>, <0.202837, -0.810560, -0.276161>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.182782, -0.066809, 1.272605>, <0.226625, -0.067086, 1.263599>, <0.284306, -0.064816, 1.245894>, <0.324885, -0.067123, 1.227148>, 
      <0.188251, 0.103603, 1.288013>, <0.232094, 0.103327, 1.279008>, <0.294020, 0.098844, 1.256801>, <0.334599, 0.096536, 1.238055>, 
      <0.202353, 0.342596, 1.240807>, <0.250295, 0.336560, 1.228588>, <0.311988, 0.332635, 1.198743>, <0.354411, 0.321501, 1.175069>, 
      <0.206497, 0.491323, 1.156127>, <0.254439, 0.485287, 1.143908>, <0.313865, 0.473430, 1.114062>, <0.356288, 0.462296, 1.090388>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.182782, -0.066809, 1.272605>, <0.188251, 0.103603, 1.288013>, <0.202353, 0.342596, 1.240807>, <0.206497, 0.491323, 1.156127>, 
      <0.128859, -0.066469, 1.283681>, <0.134329, 0.103944, 1.299090>, <0.142308, 0.350155, 1.256111>, <0.146451, 0.498883, 1.171431>, 
      <0.055567, -0.065075, 1.293777>, <0.055567, 0.109050, 1.310721>, <0.062941, 0.352666, 1.263289>, <0.062941, 0.507086, 1.181063>, 
      <0.000517, -0.065075, 1.293777>, <0.000517, 0.109050, 1.310721>, <0.000517, 0.352666, 1.263289>, <0.000517, 0.507086, 1.181063>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.172158, -0.578567, 1.059389>, <0.210826, -0.572943, 1.052710>, <0.259800, -0.559076, 1.036538>, <0.296137, -0.551099, 1.022849>, 
      <0.184545, -0.462629, 1.178036>, <0.223213, -0.457004, 1.171357>, <0.278055, -0.445064, 1.144147>, <0.314393, -0.437087, 1.130458>, 
      <0.177467, -0.232399, 1.257632>, <0.221310, -0.232675, 1.248627>, <0.274975, -0.222025, 1.235416>, <0.315554, -0.224333, 1.216671>, 
      <0.182782, -0.066809, 1.272605>, <0.226625, -0.067086, 1.263599>, <0.284306, -0.064816, 1.245894>, <0.324885, -0.067123, 1.227148>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.172158, -0.578567, 1.059389>, <0.184545, -0.462629, 1.178036>, <0.177467, -0.232399, 1.257632>, <0.182782, -0.066809, 1.272605>, 
      <0.121546, -0.585929, 1.068130>, <0.133934, -0.469990, 1.186777>, <0.123545, -0.232058, 1.268709>, <0.128859, -0.066469, 1.283681>, 
      <0.052403, -0.594099, 1.073907>, <0.052403, -0.477176, 1.199875>, <0.055567, -0.236136, 1.277131>, <0.055567, -0.065075, 1.293777>, 
      <0.000517, -0.594099, 1.073907>, <0.000517, -0.477176, 1.199875>, <0.000517, -0.236136, 1.277131>, <0.000517, -0.065075, 1.293777>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.102178, -0.821220, 0.500570>, <0.095088, -0.837369, 0.461104>, <0.056514, -0.849744, 0.413745>, <0.048747, -0.859679, 0.372398>, 
      <0.133555, -0.815445, 0.511865>, <0.126466, -0.831593, 0.472400>, <0.080041, -0.816988, 0.397251>, <0.072274, -0.826923, 0.355905>, 
      <0.174816, -0.806536, 0.528976>, <0.155741, -0.824191, 0.461039>, <0.083379, -0.735487, 0.384620>, <0.062356, -0.747023, 0.315946>, 
      <0.207492, -0.800267, 0.535177>, <0.188417, -0.817922, 0.467240>, <0.122173, -0.720034, 0.397061>, <0.101150, -0.731571, 0.328388>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.102178, -0.821220, 0.500570>, <0.133555, -0.815445, 0.511865>, <0.174816, -0.806536, 0.528976>, <0.207492, -0.800267, 0.535177>, 
      <0.132351, -0.752491, 0.668531>, <0.163728, -0.746716, 0.679827>, <0.218460, -0.766141, 0.684419>, <0.251136, -0.759872, 0.690620>, 
      <0.158459, -0.706786, 0.928175>, <0.197127, -0.701162, 0.921496>, <0.240549, -0.679297, 0.923068>, <0.276887, -0.671320, 0.909380>, 
      <0.172158, -0.578567, 1.059389>, <0.210826, -0.572943, 1.052710>, <0.259800, -0.559076, 1.036538>, <0.296137, -0.551099, 1.022849>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.102178, -0.821220, 0.500570>, <0.132351, -0.752491, 0.668531>, <0.158459, -0.706786, 0.928175>, <0.172158, -0.578567, 1.059389>, 
      <0.071431, -0.826879, 0.489502>, <0.101604, -0.758151, 0.657463>, <0.107847, -0.714148, 0.936916>, <0.121546, -0.585929, 1.068130>, 
      <0.033682, -0.838364, 0.460669>, <0.033682, -0.765084, 0.644640>, <0.052403, -0.728819, 0.928766>, <0.052403, -0.594099, 1.073907>, 
      <0.000517, -0.838364, 0.460669>, <0.000517, -0.765084, 0.644640>, <0.000517, -0.728819, 0.928766>, <0.000517, -0.594099, 1.073907>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.102178, -0.821220, 0.500570>, <0.071431, -0.826879, 0.489502>, <0.033682, -0.838364, 0.460669>, <0.000517, -0.838364, 0.460669>, 
      <0.095088, -0.837369, 0.461104>, <0.064342, -0.843028, 0.450036>, <0.033682, -0.848360, 0.442149>, <0.000517, -0.848360, 0.442149>, 
      <0.056514, -0.849744, 0.413745>, <0.047388, -0.862451, 0.420143>, <0.017420, -0.865832, 0.419141>, <0.000517, -0.865805, 0.419144>, 
      <0.048747, -0.859679, 0.372398>, <0.039620, -0.872386, 0.378796>, <0.017420, -0.871711, 0.398934>, <0.000517, -0.871683, 0.398936>
    }
  }
}
#declare sPatchObj4 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.276280, -0.800267, 0.582295>, <0.276280, -0.802915, 0.576494>, <0.276280, -0.809093, 0.569335>, <0.276280, -0.809093, 0.562959>, 
      <0.222701, -0.808746, 0.562007>, <0.222701, -0.811393, 0.556206>, <0.223011, -0.815864, 0.553190>, <0.223011, -0.815864, 0.546814>, 
      <0.154131, -0.815004, 0.526382>, <0.153205, -0.815115, 0.525936>, <0.153205, -0.817612, 0.516358>, <0.154178, -0.817544, 0.516702>, 
      <0.102259, -0.821220, 0.501386>, <0.101333, -0.821331, 0.500940>, <0.100458, -0.821288, 0.497695>, <0.101431, -0.821220, 0.498039>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.389040, -0.775838, 0.609980>, <0.389040, -0.778486, 0.602549>, <0.389040, -0.784664, 0.593099>, <0.389040, -0.784664, 0.585210>, 
      <0.359988, -0.794411, 0.618814>, <0.359988, -0.797059, 0.611383>, <0.360374, -0.804054, 0.599798>, <0.360374, -0.804054, 0.591910>, 
      <0.309210, -0.795056, 0.594764>, <0.309210, -0.797704, 0.588964>, <0.309768, -0.804836, 0.579485>, <0.309768, -0.804836, 0.573109>, 
      <0.276280, -0.800267, 0.582295>, <0.276280, -0.802915, 0.576494>, <0.276280, -0.809093, 0.569335>, <0.276280, -0.809093, 0.562959>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.513990, -0.648302, 0.510013>, <0.513990, -0.648302, 0.509230>, <0.513990, -0.648302, 0.508187>, <0.513990, -0.648302, 0.507404>, 
      <0.476505, -0.686563, 0.540003>, <0.476505, -0.686563, 0.539220>, <0.476505, -0.689211, 0.531528>, <0.476505, -0.689211, 0.530746>, 
      <0.439143, -0.743808, 0.594745>, <0.439143, -0.746455, 0.587314>, <0.437991, -0.751552, 0.581658>, <0.437991, -0.751552, 0.573770>, 
      <0.389040, -0.775838, 0.609980>, <0.389040, -0.778486, 0.602549>, <0.389040, -0.784664, 0.593099>, <0.389040, -0.784664, 0.585210>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.276280, -0.800267, 0.541269>, <0.223837, -0.808566, 0.529607>, <0.154678, -0.814938, 0.508261>, <0.102259, -0.821220, 0.495301>, 
      <0.276280, -0.802915, 0.547776>, <0.223837, -0.811214, 0.536114>, <0.153851, -0.815038, 0.508057>, <0.101431, -0.821319, 0.495096>, 
      <0.276280, -0.809093, 0.555934>, <0.223011, -0.815864, 0.539789>, <0.154426, -0.817544, 0.515881>, <0.101679, -0.821220, 0.497218>, 
      <0.276280, -0.809093, 0.562959>, <0.223011, -0.815864, 0.546814>, <0.154178, -0.817544, 0.516702>, <0.101431, -0.821220, 0.498039>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.389040, -0.775838, 0.559073>, <0.359769, -0.794550, 0.563506>, <0.310067, -0.794920, 0.548782>, <0.276280, -0.800267, 0.541269>, 
      <0.389040, -0.778486, 0.566914>, <0.359769, -0.797198, 0.571347>, <0.310067, -0.797568, 0.555289>, <0.276280, -0.802915, 0.547776>, 
      <0.389040, -0.784664, 0.576934>, <0.360374, -0.804054, 0.583633>, <0.309768, -0.804836, 0.566084>, <0.276280, -0.809093, 0.555934>, 
      <0.389040, -0.784664, 0.585210>, <0.360374, -0.804054, 0.591910>, <0.309768, -0.804836, 0.573109>, <0.276280, -0.809093, 0.562959>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.513990, -0.648302, 0.505268>, <0.476505, -0.686563, 0.521409>, <0.435795, -0.745948, 0.551992>, <0.389040, -0.775838, 0.559073>, 
      <0.513990, -0.648302, 0.505909>, <0.476505, -0.686563, 0.522050>, <0.435795, -0.748596, 0.559833>, <0.389040, -0.778486, 0.566914>, 
      <0.513990, -0.648302, 0.506763>, <0.476505, -0.689211, 0.530105>, <0.437991, -0.751552, 0.565494>, <0.389040, -0.784664, 0.576934>, 
      <0.513990, -0.648302, 0.507404>, <0.476505, -0.689211, 0.530746>, <0.437991, -0.751552, 0.573770>, <0.389040, -0.784664, 0.585210>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.279130, -0.800267, 0.582295>, <-0.279130, -0.802915, 0.576494>, <-0.279130, -0.809093, 0.569335>, <-0.279130, -0.809093, 0.562959>, 
      <-0.225551, -0.808746, 0.562007>, <-0.225551, -0.811393, 0.556206>, <-0.225861, -0.815864, 0.553190>, <-0.225861, -0.815864, 0.546814>, 
      <-0.156981, -0.815004, 0.526382>, <-0.156055, -0.815115, 0.525936>, <-0.156055, -0.817612, 0.516358>, <-0.157028, -0.817544, 0.516702>, 
      <-0.105109, -0.821220, 0.501386>, <-0.104183, -0.821331, 0.500940>, <-0.103308, -0.821288, 0.497695>, <-0.104281, -0.821220, 0.498039>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.391890, -0.775838, 0.609980>, <-0.391890, -0.778486, 0.602549>, <-0.391890, -0.784664, 0.593099>, <-0.391890, -0.784664, 0.585210>, 
      <-0.362838, -0.794411, 0.618814>, <-0.362838, -0.797059, 0.611383>, <-0.363224, -0.804054, 0.599798>, <-0.363224, -0.804054, 0.591910>, 
      <-0.312060, -0.795056, 0.594764>, <-0.312060, -0.797704, 0.588964>, <-0.312618, -0.804836, 0.579485>, <-0.312618, -0.804836, 0.573109>, 
      <-0.279130, -0.800267, 0.582295>, <-0.279130, -0.802915, 0.576494>, <-0.279130, -0.809093, 0.569335>, <-0.279130, -0.809093, 0.562959>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.516840, -0.648302, 0.510013>, <-0.516840, -0.648302, 0.509230>, <-0.516840, -0.648302, 0.508187>, <-0.516840, -0.648302, 0.507404>, 
      <-0.479355, -0.686563, 0.540003>, <-0.479355, -0.686563, 0.539220>, <-0.479355, -0.689211, 0.531528>, <-0.479355, -0.689211, 0.530746>, 
      <-0.441993, -0.743808, 0.594745>, <-0.441993, -0.746455, 0.587314>, <-0.440841, -0.751552, 0.581658>, <-0.440841, -0.751552, 0.573770>, 
      <-0.391890, -0.775838, 0.609980>, <-0.391890, -0.778486, 0.602549>, <-0.391890, -0.784664, 0.593099>, <-0.391890, -0.784664, 0.585210>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.279130, -0.800267, 0.541269>, <-0.226687, -0.808566, 0.529607>, <-0.157528, -0.814938, 0.508261>, <-0.105109, -0.821220, 0.495301>, 
      <-0.279130, -0.802915, 0.547776>, <-0.226687, -0.811214, 0.536114>, <-0.156701, -0.815038, 0.508057>, <-0.104282, -0.821319, 0.495096>, 
      <-0.279130, -0.809093, 0.555934>, <-0.225861, -0.815864, 0.539789>, <-0.157276, -0.817544, 0.515881>, <-0.104529, -0.821220, 0.497218>, 
      <-0.279130, -0.809093, 0.562959>, <-0.225861, -0.815864, 0.546814>, <-0.157028, -0.817544, 0.516702>, <-0.104281, -0.821220, 0.498039>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.391890, -0.775838, 0.559073>, <-0.362619, -0.794550, 0.563506>, <-0.312917, -0.794920, 0.548782>, <-0.279130, -0.800267, 0.541269>, 
      <-0.391890, -0.778486, 0.566914>, <-0.362619, -0.797198, 0.571347>, <-0.312917, -0.797568, 0.555289>, <-0.279130, -0.802915, 0.547776>, 
      <-0.391890, -0.784664, 0.576934>, <-0.363224, -0.804054, 0.583633>, <-0.312618, -0.804836, 0.566084>, <-0.279130, -0.809093, 0.555934>, 
      <-0.391890, -0.784664, 0.585210>, <-0.363224, -0.804054, 0.591910>, <-0.312618, -0.804836, 0.573109>, <-0.279130, -0.809093, 0.562959>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.516840, -0.648302, 0.505268>, <-0.479355, -0.686563, 0.521409>, <-0.438645, -0.745948, 0.551992>, <-0.391890, -0.775838, 0.559073>, 
      <-0.516840, -0.648302, 0.505909>, <-0.479355, -0.686563, 0.522050>, <-0.438645, -0.748596, 0.559833>, <-0.391890, -0.778486, 0.566914>, 
      <-0.516840, -0.648302, 0.506763>, <-0.479355, -0.689211, 0.530105>, <-0.440841, -0.751552, 0.565494>, <-0.391890, -0.784664, 0.576934>, 
      <-0.516840, -0.648302, 0.507404>, <-0.479355, -0.689211, 0.530746>, <-0.440841, -0.751552, 0.573770>, <-0.391890, -0.784664, 0.585210>
    }
  }
  material {
    Eyebrows
  }
}
union { // Head
  object { Mouth }
  object { Hood }
  object { sPatchObj3 }
  sphere { // Eye_2
    <0,0,0>,1
    material {
      Eye
      rotate 90.0*x
      translate <-0.100000, 0.000000, 0.100000>
    }
    scale 0.1875
    translate  <-0.3125, -0.5375, 0.328125>
  }
  sphere { // Eye_1
    <0,0,0>,1
    material {
      Eye
      rotate 90.0*x
      translate <0.100000, 0.000000, 0.100000>
    }
    scale 0.1875
    translate  <0.2875, -0.5375, 0.328125>
  }
  object { sPatchObj4 }
  material {
    Skin
  }
  scale <8.0, 8.0, 6.4>
  translate  -1.5*z
}


#declare sPatchObj = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.525680, -0.467157, -1.143925>, <0.530735, -0.528228, -1.077128>, <0.534544, -0.642717, -1.007110>, <0.542528, -0.670728, -0.921269>, 
      <0.576786, -0.467406, -1.137558>, <0.581841, -0.528478, -1.070761>, <0.591445, -0.634059, -1.007074>, <0.599429, -0.662069, -0.921233>, 
      <0.593025, -0.469510, -1.044425>, <0.592841, -0.477157, -1.022947>, <0.595673, -0.548235, -0.950225>, <0.597651, -0.548423, -0.927513>, 
      <0.621887, -0.470519, -1.001782>, <0.621703, -0.478165, -0.980304>, <0.619297, -0.495819, -0.952901>, <0.621275, -0.496007, -0.930189>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.620031, -0.464454, -1.156511>, <-0.625536, -0.531421, -1.088852>, <-0.629002, -0.655076, -1.020098>, <-0.638381, -0.687677, -0.930982>, 
      <-0.278280, -0.463779, -1.193379>, <-0.283785, -0.530746, -1.125720>, <-0.277559, -0.700051, -1.017176>, <-0.286938, -0.732652, -0.928059>, 
      <0.184586, -0.465491, -1.186421>, <0.189641, -0.526562, -1.119624>, <0.184255, -0.696017, -1.007331>, <0.192239, -0.724028, -0.921489>, 
      <0.525680, -0.467157, -1.143925>, <0.530735, -0.528228, -1.077128>, <0.534544, -0.642717, -1.007110>, <0.542528, -0.670728, -0.921269>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.747706, -0.469672, -1.006552>, <-0.748591, -0.480341, -0.984193>, <-0.748645, -0.504787, -0.956726>, <-0.750656, -0.505234, -0.932022>, 
      <-0.709404, -0.468107, -1.051540>, <-0.710289, -0.478775, -1.029181>, <-0.714962, -0.559520, -0.956414>, <-0.716973, -0.559967, -0.931710>, 
      <-0.678796, -0.464570, -1.150172>, <-0.684300, -0.531537, -1.082513>, <-0.692747, -0.646918, -1.020628>, <-0.702126, -0.679519, -0.931512>, 
      <-0.620031, -0.464454, -1.156511>, <-0.625536, -0.531421, -1.088852>, <-0.629002, -0.655076, -1.020098>, <-0.638381, -0.687677, -0.930982>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.582420, -0.666222, -0.533870>, <0.644024, -0.656476, -0.533692>, <0.637977, -0.531888, -0.540720>, <0.661787, -0.474317, -0.543656>, 
      <0.581569, -0.667001, -0.650706>, <0.643173, -0.657256, -0.650528>, <0.638359, -0.533635, -0.657483>, <0.662169, -0.476063, -0.660418>, 
      <0.552819, -0.706832, -0.810623>, <0.609720, -0.698174, -0.810587>, <0.607783, -0.549388, -0.811180>, <0.631407, -0.496972, -0.813856>, 
      <0.542528, -0.670728, -0.921269>, <0.599429, -0.662069, -0.921233>, <0.597651, -0.548423, -0.927513>, <0.621275, -0.496007, -0.930189>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.684121, -0.687227, -0.547552>, <-0.307704, -0.739130, -0.540861>, <0.207053, -0.725601, -0.534957>, <0.582420, -0.666222, -0.533870>, 
      <-0.683673, -0.687807, -0.663394>, <-0.307256, -0.739710, -0.656704>, <0.206202, -0.726381, -0.651793>, <0.581569, -0.667001, -0.650706>, 
      <-0.649775, -0.727283, -0.822716>, <-0.298332, -0.772259, -0.819793>, <0.202530, -0.760132, -0.810843>, <0.552819, -0.706832, -0.810623>, 
      <-0.638381, -0.687677, -0.930982>, <-0.286938, -0.732652, -0.928059>, <0.192239, -0.724028, -0.921489>, <0.542528, -0.670728, -0.921269>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.784217, -0.477781, -0.558160>, <-0.754188, -0.540615, -0.554978>, <-0.753170, -0.677706, -0.548779>, <-0.684121, -0.687227, -0.547552>, 
      <-0.784635, -0.478733, -0.671066>, <-0.754606, -0.541566, -0.667883>, <-0.752722, -0.678286, -0.664621>, <-0.683673, -0.687807, -0.663394>, 
      <-0.759818, -0.507269, -0.819503>, <-0.726136, -0.562002, -0.819191>, <-0.713520, -0.719126, -0.823246>, <-0.649775, -0.727283, -0.822716>, 
      <-0.750656, -0.505234, -0.932022>, <-0.716973, -0.559967, -0.931710>, <-0.702126, -0.679519, -0.931512>, <-0.638381, -0.687677, -0.930982>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.548253, -0.665483, -0.135627>, <0.605896, -0.656358, -0.135948>, <0.597557, -0.538570, -0.138198>, <0.618687, -0.484179, -0.139300>, 
      <0.555467, -0.702754, -0.249371>, <0.613110, -0.693629, -0.249692>, <0.599950, -0.544540, -0.260058>, <0.621080, -0.490149, -0.261160>, 
      <0.583294, -0.665421, -0.413964>, <0.644897, -0.655676, -0.413786>, <0.637578, -0.530064, -0.418704>, <0.661388, -0.472492, -0.421640>, 
      <0.582420, -0.666222, -0.533870>, <0.644024, -0.656476, -0.533692>, <0.637977, -0.531888, -0.540720>, <0.661787, -0.474317, -0.543656>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.641468, -0.683677, -0.132289>, <-0.287434, -0.729280, -0.131429>, <0.195689, -0.721298, -0.133666>, <0.548253, -0.665483, -0.135627>, 
      <-0.648293, -0.725551, -0.250122>, <-0.294260, -0.771155, -0.249263>, <0.202904, -0.758569, -0.247410>, <0.555467, -0.702754, -0.249371>, 
      <-0.684605, -0.686600, -0.422315>, <-0.308188, -0.738502, -0.415625>, <0.207926, -0.724801, -0.415051>, <0.583294, -0.665421, -0.413964>, 
      <-0.684121, -0.687227, -0.547552>, <-0.307704, -0.739130, -0.540861>, <0.207053, -0.725601, -0.534957>, <0.582420, -0.666222, -0.533870>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.747723, -0.498547, -0.138775>, <-0.715847, -0.554086, -0.136829>, <-0.705009, -0.675492, -0.132443>, <-0.641468, -0.683677, -0.132289>, 
      <-0.745286, -0.503657, -0.265093>, <-0.713409, -0.559196, -0.263147>, <-0.711835, -0.717366, -0.250277>, <-0.648293, -0.725551, -0.250122>, 
      <-0.783750, -0.476715, -0.431721>, <-0.753721, -0.539549, -0.428539>, <-0.753654, -0.677079, -0.423543>, <-0.684605, -0.686600, -0.422315>, 
      <-0.784217, -0.477781, -0.558160>, <-0.754188, -0.540615, -0.554978>, <-0.753170, -0.677706, -0.548779>, <-0.684121, -0.687227, -0.547552>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.544078, -0.468135, 0.070651>, <0.599401, -0.467866, 0.063100>, <0.620094, -0.456549, -0.034525>, <0.652672, -0.451583, -0.079600>, 
      <0.543869, -0.544282, 0.031435>, <0.599193, -0.544013, 0.023884>, <0.615700, -0.478432, -0.039234>, <0.648278, -0.473466, -0.084309>, 
      <0.543099, -0.638861, -0.054381>, <0.600742, -0.629735, -0.054702>, <0.597109, -0.537455, -0.115419>, <0.618239, -0.483063, -0.116521>, 
      <0.548253, -0.665483, -0.135627>, <0.605896, -0.656358, -0.135948>, <0.597557, -0.538570, -0.138198>, <0.618687, -0.484179, -0.139300>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.646739, -0.457904, 0.097757>, <-0.291386, -0.460577, 0.135391>, <0.190014, -0.469858, 0.118977>, <0.544078, -0.468135, 0.070651>, 
      <-0.645724, -0.543726, 0.053186>, <-0.290370, -0.546399, 0.090820>, <0.189805, -0.546005, 0.079761>, <0.543869, -0.544282, 0.031435>, 
      <-0.636197, -0.651341, -0.041297>, <-0.282163, -0.696945, -0.040437>, <0.190536, -0.694676, -0.052420>, <0.543099, -0.638861, -0.054381>, 
      <-0.641468, -0.683677, -0.132289>, <-0.287434, -0.729280, -0.131429>, <0.195689, -0.721298, -0.133666>, <0.548253, -0.665483, -0.135627>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.793618, -0.458073, -0.071020>, <-0.749554, -0.458023, -0.020387>, <-0.713485, -0.457402, 0.090688>, <-0.646739, -0.457904, 0.097757>, 
      <-0.790159, -0.484388, -0.077785>, <-0.746096, -0.484337, -0.027152>, <-0.712470, -0.543224, 0.046117>, <-0.645724, -0.543726, 0.053186>, 
      <-0.748251, -0.497440, -0.111414>, <-0.716375, -0.552979, -0.109468>, <-0.699738, -0.643156, -0.041451>, <-0.636197, -0.651341, -0.041297>, 
      <-0.747723, -0.498547, -0.138775>, <-0.715847, -0.554086, -0.136829>, <-0.705009, -0.675492, -0.132443>, <-0.641468, -0.683677, -0.132289>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.549361, -0.261129, 0.072616>, <0.608707, -0.260388, 0.064657>, <0.632150, -0.246629, -0.039005>, <0.667631, -0.240415, -0.086842>, 
      <0.547776, -0.323231, 0.072026>, <0.607122, -0.322490, 0.064067>, <0.627662, -0.309980, -0.036832>, <0.663143, -0.303766, -0.084669>, 
      <0.544229, -0.412905, 0.099095>, <0.599553, -0.412635, 0.091544>, <0.632334, -0.395588, -0.021406>, <0.664912, -0.390623, -0.066481>, 
      <0.544078, -0.468135, 0.070651>, <0.599401, -0.467866, 0.063100>, <0.620094, -0.456549, -0.034525>, <0.652672, -0.451583, -0.079600>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.646517, -0.256817, 0.089398>, <-0.289893, -0.260936, 0.128644>, <0.193770, -0.265567, 0.120304>, <0.549361, -0.261129, 0.072616>, 
      <-0.646584, -0.317143, 0.091905>, <-0.289960, -0.321262, 0.131152>, <0.192185, -0.327669, 0.119714>, <0.547776, -0.323231, 0.072026>, 
      <-0.647373, -0.404324, 0.125584>, <-0.292019, -0.406997, 0.163218>, <0.190165, -0.414627, 0.147421>, <0.544229, -0.412905, 0.099095>, 
      <-0.646739, -0.457904, 0.097757>, <-0.291386, -0.460577, 0.135391>, <0.190014, -0.469858, 0.118977>, <0.544078, -0.468135, 0.070651>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.780945, -0.245763, -0.073785>, <-0.740617, -0.249079, -0.024830>, <-0.709646, -0.256088, 0.082450>, <-0.646517, -0.256817, 0.089398>, 
      <-0.784747, -0.309456, -0.072956>, <-0.744418, -0.312772, -0.024001>, <-0.709712, -0.316414, 0.084958>, <-0.646584, -0.317143, 0.091905>, 
      <-0.801675, -0.396766, -0.055258>, <-0.757611, -0.396715, -0.004625>, <-0.714119, -0.403822, 0.118515>, <-0.647373, -0.404324, 0.125584>, 
      <-0.793618, -0.458073, -0.071020>, <-0.749554, -0.458023, -0.020387>, <-0.713485, -0.457402, 0.090688>, <-0.646739, -0.457904, 0.097757>
    }
  }
  material {
    Plastic_1
  }
}
#declare sPatchObj1 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.488857, -0.369275, -1.291640>, <-1.479889, -0.369601, -1.185691>, <-1.479311, -0.369609, -1.042837>, <-1.458965, -0.370362, -0.938476>, 
      <-1.571435, -0.362911, -1.276603>, <-1.562468, -0.363237, -1.170654>, <-1.560978, -0.364118, -1.027614>, <-1.540631, -0.364870, -0.923253>, 
      <-1.681259, -0.314571, -1.251665>, <-1.671052, -0.315056, -1.144307>, <-1.669298, -0.315850, -1.000786>, <-1.649180, -0.316670, -0.894839>, 
      <-1.741001, -0.255768, -1.243990>, <-1.730794, -0.256253, -1.136633>, <-1.727095, -0.256564, -0.992078>, <-1.706977, -0.257384, -0.886132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.914433, -0.319472, -1.394498>, <-0.902214, -0.317655, -1.288584>, <-0.894520, -0.314625, -1.146025>, <-0.873703, -0.313415, -1.041452>, 
      <-1.059438, -0.415677, -1.370203>, <-1.047219, -0.413860, -1.264289>, <-1.043390, -0.411983, -1.125211>, <-1.022573, -0.410773, -1.020639>, 
      <-1.316490, -0.382560, -1.323026>, <-1.307522, -0.382886, -1.217076>, <-1.303635, -0.381422, -1.075583>, <-1.283288, -0.382174, -0.971222>, 
      <-1.488857, -0.369275, -1.291640>, <-1.479889, -0.369601, -1.185691>, <-1.479311, -0.369609, -1.042837>, <-1.458965, -0.370362, -0.938476>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.870963, 0.040676, -1.395167>, <-0.858871, 0.040635, -1.284514>, <-0.847019, 0.042820, -1.136401>, <-0.830656, 0.040541, -1.026321>, 
      <-0.876408, -0.067998, -1.397137>, <-0.864316, -0.068039, -1.286483>, <-0.851440, -0.064124, -1.138958>, <-0.835077, -0.066403, -1.028878>, 
      <-0.824620, -0.259883, -1.409546>, <-0.812400, -0.258066, -1.303633>, <-0.805523, -0.256422, -1.158468>, <-0.784705, -0.255212, -1.053895>, 
      <-0.914433, -0.319472, -1.394498>, <-0.902214, -0.317655, -1.288584>, <-0.894520, -0.314625, -1.146025>, <-0.873703, -0.313415, -1.041452>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.877687, 0.413889, -1.381207>, <-0.867501, 0.413161, -1.274081>, <-0.862514, 0.408659, -1.130043>, <-0.843731, 0.411461, -1.024121>, 
      <-0.781952, 0.359131, -1.401050>, <-0.771765, 0.358402, -1.293924>, <-0.766154, 0.355432, -1.146770>, <-0.747371, 0.358234, -1.040847>, 
      <-0.865356, 0.152578, -1.393139>, <-0.853264, 0.152537, -1.282485>, <-0.842420, 0.154041, -1.133742>, <-0.826057, 0.151761, -1.023662>, 
      <-0.870963, 0.040676, -1.395167>, <-0.858871, 0.040635, -1.284514>, <-0.847019, 0.042820, -1.136401>, <-0.830656, 0.040541, -1.026321>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.474941, 0.386136, -1.269979>, <-1.465393, 0.383951, -1.164987>, <-1.464374, 0.378332, -1.023287>, <-1.443114, 0.378852, -0.920006>, 
      <-1.297343, 0.415247, -1.299954>, <-1.287795, 0.413061, -1.194962>, <-1.286571, 0.407845, -1.053613>, <-1.265311, 0.408365, -0.950332>, 
      <-1.033556, 0.503042, -1.348900>, <-1.023369, 0.502313, -1.241774>, <-1.020682, 0.496029, -1.102587>, <-1.001900, 0.498831, -0.996664>, 
      <-0.877687, 0.413889, -1.381207>, <-0.867501, 0.413161, -1.274081>, <-0.862514, 0.408659, -1.130043>, <-0.843731, 0.411461, -1.024121>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.748077, 0.271223, -1.234302>, <-1.734407, 0.270530, -1.127306>, <-1.725611, 0.268941, -0.983014>, <-1.702509, 0.268914, -0.877649>, 
      <-1.682787, 0.332327, -1.238866>, <-1.669117, 0.331635, -1.131871>, <-1.663687, 0.327544, -0.989015>, <-1.640585, 0.327518, -0.883650>, 
      <-1.562101, 0.371850, -1.255268>, <-1.552553, 0.369665, -1.150276>, <-1.547521, 0.364530, -1.009106>, <-1.526261, 0.365051, -0.905825>, 
      <-1.474941, 0.386136, -1.269979>, <-1.465393, 0.383951, -1.164987>, <-1.464374, 0.378332, -1.023287>, <-1.443114, 0.378852, -0.920006>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.875480, 0.011274, -1.241975>, <-1.862214, 0.011348, -1.134099>, <-1.851544, 0.012001, -0.989167>, <-1.831260, 0.011520, -0.882389>, 
      <-1.876647, 0.098129, -1.240378>, <-1.863380, 0.098203, -1.132502>, <-1.850811, 0.098338, -0.987776>, <-1.830527, 0.097858, -0.880998>, 
      <-1.811426, 0.211935, -1.229873>, <-1.797756, 0.211242, -1.122877>, <-1.788174, 0.209733, -0.976951>, <-1.765073, 0.209706, -0.871586>, 
      <-1.748077, 0.271223, -1.234302>, <-1.734407, 0.270530, -1.127306>, <-1.725611, 0.268941, -0.983014>, <-1.702509, 0.268914, -0.877649>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.875480, 0.011274, -1.241975>, <-1.874276, -0.078403, -1.243624>, <-1.804662, -0.193107, -1.235813>, <-1.741001, -0.255768, -1.243990>, 
      <-1.862214, 0.011348, -1.134099>, <-1.861010, -0.078328, -1.135748>, <-1.794455, -0.193592, -1.128455>, <-1.730794, -0.256253, -1.136633>, 
      <-1.851544, 0.012001, -0.989167>, <-1.852298, -0.076862, -0.990599>, <-1.788797, -0.193273, -0.982783>, <-1.727095, -0.256564, -0.992078>, 
      <-1.831260, 0.011520, -0.882389>, <-1.832014, -0.077343, -0.883822>, <-1.768679, -0.194093, -0.876836>, <-1.706977, -0.257384, -0.886132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.391558, -0.372873, -0.792582>, <-1.472065, -0.367365, -0.762166>, <-1.577907, -0.319805, -0.713907>, <-1.636290, -0.260036, -0.692558>, 
      <-1.409707, -0.366992, -0.836867>, <-1.490213, -0.361484, -0.806452>, <-1.596518, -0.315971, -0.772743>, <-1.654902, -0.256202, -0.751394>, 
      <-1.449738, -0.370703, -0.891148>, <-1.531404, -0.365211, -0.875926>, <-1.637645, -0.317140, -0.834098>, <-1.695443, -0.257854, -0.825391>, 
      <-1.458965, -0.370362, -0.938476>, <-1.540631, -0.364870, -0.923253>, <-1.649180, -0.316670, -0.894839>, <-1.706977, -0.257384, -0.886132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.834964, -0.314852, -0.995299>, <-0.974755, -0.412919, -0.943103>, <-1.224864, -0.384276, -0.855559>, <-1.391558, -0.372873, -0.792582>, 
      <-0.847416, -0.309393, -1.007221>, <-0.987207, -0.407460, -0.955024>, <-1.243012, -0.378395, -0.899845>, <-1.409707, -0.366992, -0.836867>, 
      <-0.870173, -0.313210, -1.023719>, <-1.019043, -0.410568, -1.002906>, <-1.274061, -0.382516, -0.923894>, <-1.449738, -0.370703, -0.891148>, 
      <-0.873703, -0.313415, -1.041452>, <-1.022573, -0.410773, -1.020639>, <-1.283288, -0.382174, -0.971222>, <-1.458965, -0.370362, -0.938476>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.813476, 0.032669, -1.008432>, <-0.817203, -0.071793, -1.008959>, <-0.753130, -0.257443, -1.025856>, <-0.834964, -0.314852, -0.995299>, 
      <-0.819332, 0.032901, -1.013589>, <-0.823059, -0.071560, -1.014117>, <-0.765581, -0.251984, -1.037777>, <-0.847416, -0.309393, -1.007221>, 
      <-0.829508, 0.040381, -1.018601>, <-0.833930, -0.066563, -1.021158>, <-0.781175, -0.255007, -1.036163>, <-0.870173, -0.313210, -1.023719>, 
      <-0.830656, 0.040541, -1.026321>, <-0.835077, -0.066403, -1.028878>, <-0.784705, -0.255212, -1.053895>, <-0.873703, -0.313415, -1.041452>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.808597, 0.424197, -0.991568>, <-0.714550, 0.364560, -1.029290>, <-0.809284, 0.150169, -1.007839>, <-0.813476, 0.032669, -1.008432>, 
      <-0.820146, 0.418961, -0.999331>, <-0.726100, 0.359324, -1.037053>, <-0.815140, 0.150401, -1.012996>, <-0.819332, 0.032901, -1.013589>, 
      <-0.841136, 0.411849, -1.009486>, <-0.744776, 0.358621, -1.026213>, <-0.824909, 0.151601, -1.015942>, <-0.829508, 0.040381, -1.018601>, 
      <-0.843731, 0.411461, -1.024121>, <-0.747371, 0.358234, -1.040847>, <-0.826057, 0.151761, -1.023662>, <-0.830656, 0.040541, -1.026321>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.374760, 0.388589, -0.783303>, <-1.207371, 0.419864, -0.845508>, <-0.953607, 0.516151, -0.933404>, <-0.808597, 0.424197, -0.991568>, 
      <-1.391164, 0.383888, -0.825961>, <-1.223776, 0.415163, -0.888166>, <-0.965156, 0.510914, -0.941168>, <-0.820146, 0.418961, -0.999331>, 
      <-1.433851, 0.379079, -0.875005>, <-1.256048, 0.408592, -0.905331>, <-0.999305, 0.499218, -0.982029>, <-0.841136, 0.411849, -1.009486>, 
      <-1.443114, 0.378852, -0.920006>, <-1.265311, 0.408365, -0.950332>, <-1.001900, 0.498831, -0.996664>, <-0.843731, 0.411461, -1.024121>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.628087, 0.271084, -0.687028>, <-1.566317, 0.331345, -0.707169>, <-1.456579, 0.373302, -0.752897>, <-1.374760, 0.388589, -0.783303>, 
      <-1.646045, 0.267110, -0.745602>, <-1.584275, 0.327371, -0.765743>, <-1.472983, 0.368601, -0.795555>, <-1.391164, 0.383888, -0.825961>, 
      <-1.689361, 0.268899, -0.817680>, <-1.627437, 0.327503, -0.823681>, <-1.516998, 0.365277, -0.860824>, <-1.433851, 0.379079, -0.875005>, 
      <-1.702509, 0.268914, -0.877649>, <-1.640585, 0.327518, -0.883650>, <-1.526261, 0.365051, -0.905825>, <-1.443114, 0.378852, -0.920006>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.764225, 0.008637, -0.656309>, <-1.762848, 0.097796, -0.655380>, <-1.690247, 0.210443, -0.666759>, <-1.628087, 0.271084, -0.687028>, 
      <-1.786684, 0.009782, -0.723388>, <-1.785307, 0.098940, -0.722459>, <-1.708205, 0.206469, -0.725333>, <-1.646045, 0.267110, -0.745602>, 
      <-1.818057, 0.011208, -0.812885>, <-1.817324, 0.097545, -0.811493>, <-1.751924, 0.209691, -0.811617>, <-1.689361, 0.268899, -0.817680>, 
      <-1.831260, 0.011520, -0.882389>, <-1.830527, 0.097858, -0.880998>, <-1.765073, 0.209706, -0.871586>, <-1.702509, 0.268914, -0.877649>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.764225, 0.008637, -0.656309>, <-1.786684, 0.009782, -0.723388>, <-1.818057, 0.011208, -0.812885>, <-1.831260, 0.011520, -0.882389>, 
      <-1.765614, -0.081280, -0.657245>, <-1.788073, -0.080136, -0.724324>, <-1.818811, -0.077656, -0.814317>, <-1.832014, -0.077343, -0.883822>, 
      <-1.697176, -0.197705, -0.670294>, <-1.715788, -0.193871, -0.729129>, <-1.757145, -0.194563, -0.816095>, <-1.768679, -0.194093, -0.876836>, 
      <-1.636290, -0.260036, -0.692558>, <-1.654902, -0.256202, -0.751394>, <-1.695443, -0.257854, -0.825391>, <-1.706977, -0.257384, -0.886132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.318171, -0.415986, -0.594909>, <-1.398740, -0.408791, -0.543361>, <-1.510007, -0.355003, -0.476870>, <-1.565605, -0.286502, -0.439230>, 
      <-1.346099, -0.403617, -0.651793>, <-1.426668, -0.396422, -0.600245>, <-1.538852, -0.345303, -0.550098>, <-1.594450, -0.276802, -0.512458>, 
      <-1.367258, -0.380747, -0.733284>, <-1.447765, -0.375240, -0.702869>, <-1.554035, -0.324721, -0.638446>, <-1.612419, -0.264952, -0.617096>, 
      <-1.391558, -0.372873, -0.792582>, <-1.472065, -0.367365, -0.762166>, <-1.577907, -0.319805, -0.713907>, <-1.636290, -0.260036, -0.692558>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.773810, -0.357211, -0.945814>, <-0.911705, -0.465900, -0.860759>, <-1.154294, -0.430620, -0.699756>, <-1.318171, -0.415986, -0.594909>, 
      <-0.791870, -0.345463, -0.961761>, <-0.929765, -0.454152, -0.876706>, <-1.182222, -0.418252, -0.756640>, <-1.346099, -0.403617, -0.651793>, 
      <-0.816507, -0.322945, -0.977628>, <-0.956298, -0.421012, -0.925431>, <-1.200564, -0.392150, -0.796261>, <-1.367258, -0.380747, -0.733284>, 
      <-0.834964, -0.314852, -0.995299>, <-0.974755, -0.412919, -0.943103>, <-1.224864, -0.384276, -0.855559>, <-1.391558, -0.372873, -0.792582>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.743371, 0.037074, -0.949452>, <-0.749621, -0.081404, -0.949130>, <-0.689953, -0.291115, -0.997538>, <-0.773810, -0.357211, -0.945814>, 
      <-0.766012, 0.036642, -0.965084>, <-0.772262, -0.081835, -0.964762>, <-0.708013, -0.279367, -1.013484>, <-0.791870, -0.345463, -0.961761>, 
      <-0.792835, 0.031849, -0.990254>, <-0.796562, -0.072613, -0.990781>, <-0.734672, -0.265535, -1.008184>, <-0.816507, -0.322945, -0.977628>, 
      <-0.813476, 0.032669, -1.008432>, <-0.817203, -0.071793, -1.008959>, <-0.753130, -0.257443, -1.025856>, <-0.834964, -0.314852, -0.995299>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.730554, 0.462776, -0.948040>, <-0.637119, 0.400433, -1.008936>, <-0.736640, 0.164665, -0.949798>, <-0.743371, 0.037074, -0.949452>, 
      <-0.751715, 0.450782, -0.964195>, <-0.658280, 0.388439, -1.025090>, <-0.759281, 0.164233, -0.965430>, <-0.766012, 0.036642, -0.965084>, 
      <-0.785916, 0.434480, -0.976321>, <-0.691870, 0.374844, -1.014043>, <-0.788643, 0.149349, -0.989661>, <-0.792835, 0.031849, -0.990254>, 
      <-0.808597, 0.424197, -0.991568>, <-0.714550, 0.364560, -1.029290>, <-0.809284, 0.150169, -1.007839>, <-0.813476, 0.032669, -1.008432>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.311938, 0.416444, -0.578896>, <-1.139547, 0.450191, -0.688535>, <-0.881980, 0.563813, -0.849351>, <-0.730554, 0.462776, -0.948040>, 
      <-1.337997, 0.407463, -0.637425>, <-1.165606, 0.441211, -0.747064>, <-0.903141, 0.551820, -0.865506>, <-0.751715, 0.450782, -0.964195>, 
      <-1.351660, 0.395209, -0.723236>, <-1.184272, 0.426483, -0.785441>, <-0.930926, 0.526434, -0.918158>, <-0.785916, 0.434480, -0.976321>, 
      <-1.374760, 0.388589, -0.783303>, <-1.207371, 0.419864, -0.845508>, <-0.953607, 0.516151, -0.933404>, <-0.808597, 0.424197, -0.991568>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.561973, 0.300016, -0.419266>, <-1.504963, 0.368180, -0.454529>, <-1.391529, 0.400863, -0.528277>, <-1.311938, 0.416444, -0.578896>, 
      <-1.592226, 0.292127, -0.496363>, <-1.535216, 0.360291, -0.531626>, <-1.417588, 0.391882, -0.586806>, <-1.337997, 0.407463, -0.637425>, 
      <-1.603752, 0.276470, -0.607654>, <-1.541982, 0.336731, -0.627795>, <-1.433480, 0.379922, -0.692830>, <-1.351660, 0.395209, -0.723236>, 
      <-1.628087, 0.271084, -0.687028>, <-1.566317, 0.331345, -0.707169>, <-1.456579, 0.373302, -0.752897>, <-1.374760, 0.388589, -0.783303>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.657985, 0.002693, -0.364855>, <-1.657396, 0.097779, -0.361618>, <-1.618709, 0.232180, -0.384173>, <-1.561973, 0.300016, -0.419266>, 
      <-1.694188, 0.003324, -0.450605>, <-1.693599, 0.098410, -0.447368>, <-1.648961, 0.224291, -0.461270>, <-1.592226, 0.292127, -0.496363>, 
      <-1.734677, 0.007132, -0.568055>, <-1.733300, 0.096291, -0.567126>, <-1.665911, 0.215829, -0.587385>, <-1.603752, 0.276470, -0.607654>, 
      <-1.764225, 0.008637, -0.656309>, <-1.762848, 0.097796, -0.655380>, <-1.690247, 0.210443, -0.666759>, <-1.628087, 0.271084, -0.687028>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.657985, 0.002693, -0.364855>, <-1.694188, 0.003324, -0.450605>, <-1.734677, 0.007132, -0.568055>, <-1.764225, 0.008637, -0.656309>, 
      <-1.658565, -0.091022, -0.368045>, <-1.694768, -0.090391, -0.453794>, <-1.736066, -0.082785, -0.568991>, <-1.765614, -0.081280, -0.657245>, 
      <-1.619958, -0.219534, -0.402433>, <-1.648803, -0.209835, -0.475661>, <-1.673305, -0.202621, -0.594832>, <-1.697176, -0.197705, -0.670294>, 
      <-1.565605, -0.286502, -0.439230>, <-1.594450, -0.276802, -0.512458>, <-1.612419, -0.264952, -0.617096>, <-1.636290, -0.260036, -0.692558>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.207077, -0.454574, -0.416832>, <-1.281346, -0.448042, -0.346232>, <-1.394454, -0.397264, -0.259651>, <-1.445968, -0.324035, -0.209384>, 
      <-1.246273, -0.443306, -0.466183>, <-1.320542, -0.436774, -0.395583>, <-1.439454, -0.389383, -0.323545>, <-1.490968, -0.316153, -0.273278>, 
      <-1.290478, -0.428250, -0.538504>, <-1.371047, -0.421055, -0.486957>, <-1.481436, -0.364610, -0.404337>, <-1.537034, -0.296109, -0.366697>, 
      <-1.318171, -0.415986, -0.594909>, <-1.398740, -0.408791, -0.543361>, <-1.510007, -0.355003, -0.476870>, <-1.565605, -0.286502, -0.439230>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.723109, -0.387611, -0.896533>, <-0.846223, -0.502536, -0.778936>, <-1.058500, -0.467642, -0.558069>, <-1.207077, -0.454574, -0.416832>, 
      <-0.741683, -0.378982, -0.907195>, <-0.864797, -0.493908, -0.789597>, <-1.097696, -0.456373, -0.607421>, <-1.246273, -0.443306, -0.466183>, 
      <-0.758253, -0.367330, -0.932078>, <-0.896148, -0.476019, -0.847023>, <-1.126602, -0.442885, -0.643351>, <-1.290478, -0.428250, -0.538504>, 
      <-0.773810, -0.357211, -0.945814>, <-0.911705, -0.465900, -0.860759>, <-1.154294, -0.430620, -0.699756>, <-1.318171, -0.415986, -0.594909>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.682441, 0.035168, -0.917961>, <-0.687389, -0.092316, -0.917423>, <-0.646644, -0.316231, -0.969573>, <-0.723109, -0.387611, -0.896533>, 
      <-0.701751, 0.034947, -0.925087>, <-0.706699, -0.092537, -0.924549>, <-0.665217, -0.307602, -0.980235>, <-0.741683, -0.378982, -0.907195>, 
      <-0.726434, 0.037397, -0.937759>, <-0.732684, -0.081081, -0.937437>, <-0.674396, -0.301234, -0.983801>, <-0.758253, -0.367330, -0.932078>, 
      <-0.743371, 0.037074, -0.949452>, <-0.749621, -0.081404, -0.949130>, <-0.689953, -0.291115, -0.997538>, <-0.773810, -0.357211, -0.945814>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.688972, 0.491997, -0.900245>, <-0.604351, 0.424927, -0.984834>, <-0.677122, 0.172229, -0.918540>, <-0.682441, 0.035168, -0.917961>, 
      <-0.705574, 0.482206, -0.908406>, <-0.620952, 0.415137, -0.992995>, <-0.696432, 0.172008, -0.925665>, <-0.701751, 0.034947, -0.925087>, 
      <-0.715386, 0.471373, -0.936461>, <-0.621951, 0.409029, -0.997356>, <-0.719703, 0.164988, -0.938105>, <-0.726434, 0.037397, -0.937759>, 
      <-0.730554, 0.462776, -0.948040>, <-0.637119, 0.400433, -1.008936>, <-0.736640, 0.164665, -0.949798>, <-0.743371, 0.037074, -0.949452>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.203023, 0.447774, -0.397577>, <-1.048130, 0.483186, -0.544045>, <-0.822290, 0.597663, -0.766978>, <-0.688972, 0.491997, -0.900245>, 
      <-1.243248, 0.437400, -0.446457>, <-1.088354, 0.472813, -0.592925>, <-0.838892, 0.587872, -0.775139>, <-0.705574, 0.482206, -0.908406>, 
      <-1.286099, 0.425348, -0.520862>, <-1.113709, 0.459096, -0.630501>, <-0.866812, 0.572410, -0.837772>, <-0.715386, 0.471373, -0.936461>, 
      <-1.311938, 0.416444, -0.578896>, <-1.139547, 0.450191, -0.688535>, <-0.881980, 0.563813, -0.849351>, <-0.730554, 0.462776, -0.948040>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.434955, 0.321446, -0.194839>, <-1.382712, 0.392249, -0.242109>, <-1.274617, 0.431406, -0.329877>, <-1.203023, 0.447774, -0.397577>, 
      <-1.480685, 0.315217, -0.257260>, <-1.428442, 0.386019, -0.304530>, <-1.314842, 0.421032, -0.378757>, <-1.243248, 0.437400, -0.446457>, 
      <-1.533744, 0.307377, -0.347326>, <-1.476734, 0.375541, -0.382588>, <-1.365691, 0.409767, -0.470243>, <-1.286099, 0.425348, -0.520862>, 
      <-1.561973, 0.300016, -0.419266>, <-1.504963, 0.368180, -0.454529>, <-1.391529, 0.400863, -0.528277>, <-1.311938, 0.416444, -0.578896>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.530057, 0.004557, -0.101670>, <-1.528299, 0.107632, -0.099347>, <-1.488888, 0.248353, -0.146039>, <-1.434955, 0.321446, -0.194839>, 
      <-1.579137, 0.005110, -0.174457>, <-1.577379, 0.108184, -0.172135>, <-1.534618, 0.242123, -0.208460>, <-1.480685, 0.315217, -0.257260>, 
      <-1.623839, 0.002098, -0.283979>, <-1.623250, 0.097184, -0.280743>, <-1.590480, 0.239541, -0.312233>, <-1.533744, 0.307377, -0.347326>, 
      <-1.657985, 0.002693, -0.364855>, <-1.657396, 0.097779, -0.361618>, <-1.618709, 0.232180, -0.384173>, <-1.561973, 0.300016, -0.419266>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.530057, 0.004557, -0.101670>, <-1.579137, 0.005110, -0.174457>, <-1.623839, 0.002098, -0.283979>, <-1.657985, 0.002693, -0.364855>, 
      <-1.531878, -0.102162, -0.104075>, <-1.580958, -0.101610, -0.176862>, <-1.624419, -0.091617, -0.287169>, <-1.658565, -0.091022, -0.368045>, 
      <-1.499530, -0.247893, -0.157118>, <-1.544530, -0.240012, -0.221012>, <-1.591387, -0.229142, -0.329900>, <-1.619958, -0.219534, -0.402433>, 
      <-1.445968, -0.324035, -0.209384>, <-1.490968, -0.316153, -0.273278>, <-1.537034, -0.296109, -0.366697>, <-1.565605, -0.286502, -0.439230>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.002865, -0.506635, -0.197907>, <-1.061710, -0.498560, -0.100351>, <-1.147004, -0.433981, 0.028068>, <-1.187910, -0.352649, 0.097038>, 
      <-1.075033, -0.499530, -0.253152>, <-1.133878, -0.491456, -0.155596>, <-1.240860, -0.429940, -0.047379>, <-1.281766, -0.348608, 0.021591>, 
      <-1.151266, -0.470620, -0.346559>, <-1.225535, -0.464088, -0.275959>, <-1.325424, -0.409353, -0.161639>, <-1.376937, -0.336124, -0.111372>, 
      <-1.207077, -0.454574, -0.416832>, <-1.281346, -0.448042, -0.346232>, <-1.394454, -0.397264, -0.259651>, <-1.445968, -0.324035, -0.209384>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.614154, -0.431380, -0.854164>, <-0.714441, -0.559720, -0.691867>, <-0.884402, -0.522891, -0.394302>, <-1.002865, -0.506635, -0.197907>, 
      <-0.646606, -0.422835, -0.870785>, <-0.746893, -0.551175, -0.708488>, <-0.956569, -0.515786, -0.449547>, <-1.075033, -0.499530, -0.253152>, 
      <-0.692985, -0.401605, -0.879240>, <-0.816098, -0.516531, -0.761643>, <-1.002688, -0.483688, -0.487797>, <-1.151266, -0.470620, -0.346559>, 
      <-0.723109, -0.387611, -0.896533>, <-0.846223, -0.502536, -0.778936>, <-1.058500, -0.467642, -0.558069>, <-1.207077, -0.454574, -0.416832>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.576513, 0.038982, -0.887884>, <-0.580355, -0.102846, -0.884459>, <-0.552254, -0.352165, -0.954339>, <-0.614154, -0.431380, -0.854164>, 
      <-0.607610, 0.040491, -0.898988>, <-0.611452, -0.101336, -0.895564>, <-0.584707, -0.343620, -0.970959>, <-0.646606, -0.422835, -0.870785>, 
      <-0.651432, 0.035522, -0.906520>, <-0.656380, -0.091962, -0.905982>, <-0.616519, -0.330225, -0.952280>, <-0.692985, -0.401605, -0.879240>, 
      <-0.682441, 0.035168, -0.917961>, <-0.687389, -0.092316, -0.917423>, <-0.646644, -0.316231, -0.969573>, <-0.723109, -0.387611, -0.896533>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.587649, 0.547052, -0.877791>, <-0.519721, 0.471900, -0.991767>, <-0.572385, 0.191369, -0.891564>, <-0.576513, 0.038982, -0.887884>, 
      <-0.619147, 0.535696, -0.888793>, <-0.551219, 0.460543, -1.002769>, <-0.603482, 0.192879, -0.902668>, <-0.607610, 0.040491, -0.898988>, 
      <-0.661017, 0.508483, -0.886503>, <-0.576396, 0.441414, -0.971092>, <-0.646113, 0.172584, -0.907098>, <-0.651432, 0.035522, -0.906520>, 
      <-0.688972, 0.491997, -0.900245>, <-0.604351, 0.424927, -0.984834>, <-0.677122, 0.172229, -0.918540>, <-0.682441, 0.035168, -0.917961>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.992218, 0.498897, -0.190383>, <-0.870370, 0.539068, -0.392883>, <-0.694438, 0.665198, -0.698613>, <-0.587649, 0.547052, -0.877791>, 
      <-1.065700, 0.490070, -0.241576>, <-0.943852, 0.530242, -0.444077>, <-0.725936, 0.653842, -0.709615>, <-0.619147, 0.535696, -0.888793>, 
      <-1.146593, 0.462326, -0.329004>, <-0.991699, 0.497739, -0.475473>, <-0.794335, 0.614149, -0.753235>, <-0.661017, 0.508483, -0.886503>, 
      <-1.203023, 0.447774, -0.397577>, <-1.048130, 0.483186, -0.544045>, <-0.822290, 0.597663, -0.766978>, <-0.688972, 0.491997, -0.900245>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.178508, 0.352255, 0.104159>, <-1.135968, 0.432773, 0.036530>, <-1.049874, 0.479888, -0.094564>, <-0.992218, 0.498897, -0.190383>, 
      <-1.272356, 0.347115, 0.031934>, <-1.229816, 0.427634, -0.035694>, <-1.123356, 0.471062, -0.145758>, <-1.065700, 0.490070, -0.241576>, 
      <-1.365129, 0.330958, -0.099528>, <-1.312886, 0.401761, -0.146798>, <-1.218187, 0.445958, -0.261305>, <-1.146593, 0.462326, -0.329004>, 
      <-1.434955, 0.321446, -0.194839>, <-1.382712, 0.392249, -0.242109>, <-1.274617, 0.431406, -0.329877>, <-1.203023, 0.447774, -0.397577>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.256761, -0.001821, 0.230178>, <-1.255225, 0.113331, 0.231341>, <-1.221699, 0.270503, 0.172823>, <-1.178508, 0.352255, 0.104159>, 
      <-1.357734, -0.000460, 0.149932>, <-1.356198, 0.114692, 0.151095>, <-1.315547, 0.265364, 0.100599>, <-1.272356, 0.347115, 0.031934>, 
      <-1.457948, 0.003746, 0.005272>, <-1.456189, 0.106821, 0.007595>, <-1.419062, 0.257865, -0.050728>, <-1.365129, 0.330958, -0.099528>, 
      <-1.530057, 0.004557, -0.101670>, <-1.528299, 0.107632, -0.099347>, <-1.488888, 0.248353, -0.146039>, <-1.434955, 0.321446, -0.194839>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.256761, -0.001821, 0.230178>, <-1.357734, -0.000460, 0.149932>, <-1.457948, 0.003746, 0.005272>, <-1.530057, 0.004557, -0.101670>, 
      <-1.258287, -0.116257, 0.229022>, <-1.359261, -0.114896, 0.148776>, <-1.459769, -0.102973, 0.002867>, <-1.531878, -0.102162, -0.104075>, 
      <-1.228900, -0.271148, 0.166152>, <-1.322757, -0.267107, 0.090704>, <-1.430500, -0.259983, -0.059106>, <-1.499530, -0.247893, -0.157118>, 
      <-1.187910, -0.352649, 0.097038>, <-1.281766, -0.348608, 0.021591>, <-1.376937, -0.336124, -0.111372>, <-1.445968, -0.324035, -0.209384>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.772648, -0.497342, -0.084274>, <-0.802352, -0.489417, 0.026608>, <-0.845765, -0.429661, 0.177358>, <-0.865884, -0.349011, 0.256924>, 
      <-0.843423, -0.499745, -0.114688>, <-0.873127, -0.491820, -0.003805>, <-0.943150, -0.427443, 0.131031>, <-0.963269, -0.346793, 0.210598>, 
      <-0.941854, -0.512641, -0.151202>, <-1.000698, -0.504567, -0.053646>, <-1.062981, -0.437599, 0.095611>, <-1.103887, -0.356267, 0.164581>, 
      <-1.002865, -0.506635, -0.197907>, <-1.061710, -0.498560, -0.100351>, <-1.147004, -0.433981, 0.028068>, <-1.187910, -0.352649, 0.097038>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.576950, -0.426097, -0.821678>, <-0.629573, -0.550516, -0.635685>, <-0.713308, -0.513173, -0.305793>, <-0.772648, -0.497342, -0.084274>, 
      <-0.588886, -0.426154, -0.830598>, <-0.641510, -0.550572, -0.644606>, <-0.784083, -0.515576, -0.336206>, <-0.843423, -0.499745, -0.114688>, 
      <-0.601240, -0.434781, -0.847551>, <-0.701527, -0.563121, -0.685254>, <-0.823390, -0.528897, -0.347597>, <-0.941854, -0.512641, -0.151202>, 
      <-0.614154, -0.431380, -0.854164>, <-0.714441, -0.559720, -0.691867>, <-0.884402, -0.522891, -0.394302>, <-1.002865, -0.506635, -0.197907>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.550139, 0.028745, -0.870717>, <-0.554668, -0.108601, -0.866715>, <-0.545478, -0.351687, -0.932913>, <-0.576950, -0.426097, -0.821678>, 
      <-0.558198, 0.028819, -0.876515>, <-0.562726, -0.108528, -0.872513>, <-0.557415, -0.351744, -0.941833>, <-0.588886, -0.426154, -0.830598>, 
      <-0.567174, 0.038528, -0.884549>, <-0.571016, -0.103299, -0.881124>, <-0.539341, -0.355565, -0.947725>, <-0.601240, -0.434781, -0.847551>, 
      <-0.576513, 0.038982, -0.887884>, <-0.580355, -0.102846, -0.884459>, <-0.552254, -0.352165, -0.954339>, <-0.614154, -0.431380, -0.854164>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.544968, 0.543915, -0.849946>, <-0.511937, 0.466105, -0.979490>, <-0.545044, 0.183280, -0.875221>, <-0.550139, 0.028745, -0.870717>, 
      <-0.558093, 0.544410, -0.857827>, <-0.525062, 0.466599, -0.987371>, <-0.553103, 0.183353, -0.881019>, <-0.558198, 0.028819, -0.876515>, 
      <-0.573960, 0.551988, -0.873010>, <-0.506031, 0.476835, -0.986985>, <-0.563046, 0.190916, -0.888229>, <-0.567174, 0.038528, -0.884549>, 
      <-0.587649, 0.547052, -0.877791>, <-0.519721, 0.471900, -0.991767>, <-0.572385, 0.191369, -0.891564>, <-0.576513, 0.038982, -0.887884>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.751066, 0.502062, -0.082705>, <-0.689320, 0.541062, -0.309920>, <-0.595932, 0.663969, -0.650072>, <-0.544968, 0.543915, -0.849946>, 
      <-0.824530, 0.502571, -0.112389>, <-0.762784, 0.541570, -0.339603>, <-0.609057, 0.664463, -0.657953>, <-0.558093, 0.544410, -0.857827>, 
      <-0.927518, 0.506668, -0.145307>, <-0.805670, 0.546840, -0.347808>, <-0.680749, 0.670134, -0.693831>, <-0.573960, 0.551988, -0.873010>, 
      <-0.992218, 0.498897, -0.190383>, <-0.870370, 0.539068, -0.392883>, <-0.694438, 0.665198, -0.698613>, <-0.587649, 0.547052, -0.877791>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.846139, 0.353692, 0.258306>, <-0.822868, 0.435102, 0.180258>, <-0.780859, 0.483245, 0.026926>, <-0.751066, 0.502062, -0.082705>, 
      <-0.945925, 0.354752, 0.212234>, <-0.922653, 0.436162, 0.134186>, <-0.854322, 0.483753, -0.002757>, <-0.824530, 0.502571, -0.112389>, 
      <-1.091485, 0.357020, 0.171130>, <-1.048945, 0.437539, 0.103501>, <-0.985174, 0.487660, -0.049489>, <-0.927518, 0.506668, -0.145307>, 
      <-1.178508, 0.352255, 0.104159>, <-1.135968, 0.432773, 0.036530>, <-1.049874, 0.479888, -0.094564>, <-0.992218, 0.498897, -0.190383>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.895722, -0.003993, 0.402450>, <-0.892446, 0.112604, 0.402680>, <-0.869711, 0.271229, 0.337363>, <-0.846139, 0.353692, 0.258306>, 
      <-1.004390, -0.005296, 0.351534>, <-1.001114, 0.111301, 0.351764>, <-0.969497, 0.272289, 0.291291>, <-0.945925, 0.354752, 0.212234>, 
      <-1.162811, -0.003087, 0.304842>, <-1.161275, 0.112065, 0.306005>, <-1.134676, 0.275269, 0.239795>, <-1.091485, 0.357020, 0.171130>, 
      <-1.256761, -0.001821, 0.230178>, <-1.255225, 0.113331, 0.231341>, <-1.221699, 0.270503, 0.172823>, <-1.178508, 0.352255, 0.104159>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.895722, -0.003993, 0.402450>, <-1.004390, -0.005296, 0.351534>, <-1.162811, -0.003087, 0.304842>, <-1.256761, -0.001821, 0.230178>, 
      <-0.898888, -0.116640, 0.402229>, <-1.007555, -0.117944, 0.351313>, <-1.164337, -0.117523, 0.303686>, <-1.258287, -0.116257, 0.229022>, 
      <-0.885589, -0.270025, 0.334850>, <-0.982974, -0.267807, 0.288523>, <-1.144878, -0.274766, 0.233694>, <-1.228900, -0.271148, 0.166152>, 
      <-0.865884, -0.349011, 0.256924>, <-0.963269, -0.346793, 0.210598>, <-1.103887, -0.356267, 0.164581>, <-1.187910, -0.352649, 0.097038>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.635732, -0.494168, -0.040142>, <-0.654721, -0.487123, 0.076181>, <-0.695954, -0.444933, 0.239220>, <-0.712947, -0.363466, 0.322979>, 
      <-0.678193, -0.494147, -0.047915>, <-0.697182, -0.487103, 0.068408>, <-0.745261, -0.444018, 0.230026>, <-0.762254, -0.362551, 0.313785>, 
      <-0.733008, -0.495995, -0.067240>, <-0.762711, -0.488071, 0.043643>, <-0.800473, -0.430692, 0.198903>, <-0.820592, -0.350043, 0.278469>, 
      <-0.772648, -0.497342, -0.084274>, <-0.802352, -0.489417, 0.026608>, <-0.845765, -0.429661, 0.177358>, <-0.865884, -0.349011, 0.256924>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.530935, -0.430988, -0.791975>, <-0.560977, -0.556652, -0.603490>, <-0.598980, -0.507802, -0.265273>, <-0.635732, -0.494168, -0.040142>, 
      <-0.546550, -0.430610, -0.797279>, <-0.576593, -0.556274, -0.608794>, <-0.641441, -0.507781, -0.273046>, <-0.678193, -0.494147, -0.047915>, 
      <-0.563736, -0.426035, -0.811803>, <-0.616359, -0.550454, -0.625811>, <-0.673668, -0.511827, -0.288758>, <-0.733008, -0.495995, -0.067240>, 
      <-0.576950, -0.426097, -0.821678>, <-0.629573, -0.550516, -0.635685>, <-0.713308, -0.513173, -0.305793>, <-0.772648, -0.497342, -0.084274>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.508420, 0.038363, -0.838891>, <-0.512003, -0.103158, -0.833529>, <-0.512310, -0.353083, -0.908824>, <-0.530935, -0.430988, -0.791975>, 
      <-0.523146, 0.038056, -0.845152>, <-0.526729, -0.103466, -0.839789>, <-0.527926, -0.352706, -0.914128>, <-0.546550, -0.430610, -0.797279>, 
      <-0.537149, 0.028627, -0.861370>, <-0.541677, -0.108719, -0.857368>, <-0.532264, -0.351625, -0.923038>, <-0.563736, -0.426035, -0.811803>, 
      <-0.550139, 0.028745, -0.870717>, <-0.554668, -0.108601, -0.866715>, <-0.545478, -0.351687, -0.932913>, <-0.576950, -0.426097, -0.821678>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.506250, 0.543984, -0.828916>, <-0.488930, 0.469188, -0.959773>, <-0.504583, 0.189923, -0.844633>, <-0.508420, 0.038363, -0.838891>, 
      <-0.518796, 0.543437, -0.833042>, <-0.501476, 0.468641, -0.963899>, <-0.519308, 0.189615, -0.850894>, <-0.523146, 0.038056, -0.845152>, 
      <-0.533642, 0.543488, -0.843145>, <-0.500611, 0.465678, -0.972689>, <-0.532054, 0.183162, -0.865874>, <-0.537149, 0.028627, -0.861370>, 
      <-0.544968, 0.543915, -0.849946>, <-0.511937, 0.466105, -0.979490>, <-0.545044, 0.183280, -0.875221>, <-0.550139, 0.028745, -0.870717>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.614462, 0.496284, -0.037750>, <-0.575185, 0.536092, -0.271130>, <-0.533648, 0.662296, -0.621925>, <-0.506250, 0.543984, -0.828916>, 
      <-0.656770, 0.496137, -0.046372>, <-0.617493, 0.535946, -0.279752>, <-0.546194, 0.661750, -0.626051>, <-0.518796, 0.543437, -0.833042>, 
      <-0.711033, 0.501786, -0.066530>, <-0.649287, 0.540785, -0.293744>, <-0.584606, 0.663542, -0.643271>, <-0.533642, 0.543488, -0.843145>, 
      <-0.751066, 0.502062, -0.082705>, <-0.689320, 0.541062, -0.309920>, <-0.595932, 0.663969, -0.650072>, <-0.544968, 0.543915, -0.849946>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.700433, 0.347176, 0.324890>, <-0.679474, 0.429485, 0.239521>, <-0.634171, 0.476309, 0.079359>, <-0.614462, 0.496284, -0.037750>, 
      <-0.747709, 0.347760, 0.316047>, <-0.726750, 0.430069, 0.230679>, <-0.676479, 0.476162, 0.070736>, <-0.656770, 0.496137, -0.046372>, 
      <-0.802472, 0.353228, 0.278467>, <-0.779200, 0.434638, 0.200419>, <-0.740826, 0.482968, 0.043101>, <-0.711033, 0.501786, -0.066530>, 
      <-0.846139, 0.353692, 0.258306>, <-0.822868, 0.435102, 0.180258>, <-0.780859, 0.483245, 0.026926>, <-0.751066, 0.502062, -0.082705>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.739721, 0.004379, 0.472436>, <-0.737739, 0.116940, 0.472738>, <-0.720027, 0.270228, 0.404697>, <-0.700433, 0.347176, 0.324890>, 
      <-0.790362, 0.003029, 0.464004>, <-0.788380, 0.115591, 0.464306>, <-0.767303, 0.270812, 0.395854>, <-0.747709, 0.347760, 0.316047>, 
      <-0.849221, -0.003435, 0.424238>, <-0.845945, 0.113162, 0.424468>, <-0.826044, 0.270765, 0.357524>, <-0.802472, 0.353228, 0.278467>, 
      <-0.895722, -0.003993, 0.402450>, <-0.892446, 0.112604, 0.402680>, <-0.869711, 0.271229, 0.337363>, <-0.846139, 0.353692, 0.258306>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.739721, 0.004379, 0.472436>, <-0.790362, 0.003029, 0.464004>, <-0.849221, -0.003435, 0.424238>, <-0.895722, -0.003993, 0.402450>, 
      <-0.741823, -0.114987, 0.472115>, <-0.792464, -0.116337, 0.463683>, <-0.852386, -0.116083, 0.424017>, <-0.898888, -0.116640, 0.402229>, 
      <-0.730128, -0.281094, 0.407670>, <-0.779436, -0.280180, 0.398475>, <-0.840297, -0.271056, 0.356395>, <-0.885589, -0.270025, 0.334850>, 
      <-0.712947, -0.363466, 0.322979>, <-0.762254, -0.362551, 0.313785>, <-0.820592, -0.350043, 0.278469>, <-0.865884, -0.349011, 0.256924>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.442387, -0.497502, -0.023818>, <-0.440978, -0.490034, 0.091758>, <-0.444618, -0.438960, 0.254055>, <-0.443240, -0.356850, 0.335734>, 
      <-0.500486, -0.497668, -0.027533>, <-0.499077, -0.490199, 0.088042>, <-0.525540, -0.441219, 0.250615>, <-0.524162, -0.359109, 0.332294>, 
      <-0.578465, -0.494196, -0.029659>, <-0.597454, -0.487151, 0.086664>, <-0.616313, -0.446410, 0.254070>, <-0.633306, -0.364943, 0.337830>, 
      <-0.635732, -0.494168, -0.040142>, <-0.654721, -0.487123, 0.076181>, <-0.695954, -0.444933, 0.239220>, <-0.712947, -0.363466, 0.322979>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.456853, -0.429004, -0.780887>, <-0.453151, -0.553814, -0.590011>, <-0.445161, -0.512209, -0.251416>, <-0.442387, -0.497502, -0.023818>, 
      <-0.479327, -0.428767, -0.781373>, <-0.475625, -0.553577, -0.590497>, <-0.503261, -0.512374, -0.255132>, <-0.500486, -0.497668, -0.027533>, 
      <-0.509655, -0.431503, -0.784747>, <-0.539697, -0.557167, -0.596262>, <-0.541713, -0.507830, -0.254790>, <-0.578465, -0.494196, -0.029659>, 
      <-0.530935, -0.430988, -0.791975>, <-0.560977, -0.556652, -0.603490>, <-0.598980, -0.507802, -0.265273>, <-0.635732, -0.494168, -0.040142>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.458052, 0.030667, -0.831565>, <-0.459991, -0.107965, -0.826518>, <-0.459105, -0.353087, -0.896989>, <-0.456853, -0.429004, -0.780887>, 
      <-0.473486, 0.030608, -0.832113>, <-0.475424, -0.108024, -0.827065>, <-0.481578, -0.352850, -0.897475>, <-0.479327, -0.428767, -0.781373>, 
      <-0.494211, 0.038659, -0.832850>, <-0.497794, -0.102862, -0.827488>, <-0.491030, -0.353598, -0.901597>, <-0.509655, -0.431503, -0.784747>, 
      <-0.508420, 0.038363, -0.838891>, <-0.512003, -0.103158, -0.833529>, <-0.512310, -0.353083, -0.908824>, <-0.530935, -0.430988, -0.791975>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.443188, 0.548346, -0.816472>, <-0.448978, 0.470490, -0.950876>, <-0.455881, 0.185983, -0.837221>, <-0.458052, 0.030667, -0.831565>, 
      <-0.462480, 0.547830, -0.817537>, <-0.468270, 0.469973, -0.951941>, <-0.471314, 0.185924, -0.837768>, <-0.473486, 0.030608, -0.832113>, 
      <-0.487906, 0.544782, -0.822882>, <-0.470585, 0.469986, -0.953739>, <-0.490374, 0.190219, -0.838592>, <-0.494211, 0.038659, -0.832850>, 
      <-0.506250, 0.543984, -0.828916>, <-0.488930, 0.469188, -0.959773>, <-0.504583, 0.189923, -0.844633>, <-0.508420, 0.038363, -0.838891>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.422911, 0.503200, -0.015828>, <-0.426881, 0.544271, -0.252915>, <-0.434223, 0.668889, -0.608379>, <-0.443188, 0.548346, -0.816472>, 
      <-0.480704, 0.501997, -0.018708>, <-0.484674, 0.543068, -0.255796>, <-0.453515, 0.668372, -0.609444>, <-0.462480, 0.547830, -0.817537>, 
      <-0.557751, 0.496480, -0.026192>, <-0.518473, 0.536289, -0.259572>, <-0.515304, 0.663095, -0.615892>, <-0.487906, 0.544782, -0.822882>, 
      <-0.614462, 0.496284, -0.037750>, <-0.575185, 0.536092, -0.271130>, <-0.533648, 0.662296, -0.621925>, <-0.506250, 0.543984, -0.828916>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.423869, 0.348477, 0.337290>, <-0.422054, 0.430226, 0.255493>, <-0.421003, 0.483461, 0.098118>, <-0.422911, 0.503200, -0.015828>, 
      <-0.506882, 0.346973, 0.335163>, <-0.505067, 0.428722, 0.253366>, <-0.478797, 0.482258, 0.095237>, <-0.480704, 0.501997, -0.018708>, 
      <-0.618801, 0.346168, 0.340158>, <-0.597842, 0.428477, 0.254790>, <-0.577460, 0.476505, 0.090916>, <-0.557751, 0.496480, -0.026192>, 
      <-0.700433, 0.347176, 0.324890>, <-0.679474, 0.429485, 0.239521>, <-0.634171, 0.476309, 0.079359>, <-0.614462, 0.496284, -0.037750>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.433898, 0.008317, 0.479349>, <-0.430861, 0.118905, 0.479593>, <-0.425605, 0.270282, 0.415531>, <-0.423869, 0.348477, 0.337290>, 
      <-0.525665, 0.009633, 0.478793>, <-0.522628, 0.120222, 0.479037>, <-0.508617, 0.268778, 0.413404>, <-0.506882, 0.346973, 0.335163>, 
      <-0.649221, 0.006791, 0.487505>, <-0.647239, 0.119353, 0.487808>, <-0.638396, 0.269220, 0.419966>, <-0.618801, 0.346168, 0.340158>, 
      <-0.739721, 0.004379, 0.472436>, <-0.737739, 0.116940, 0.472738>, <-0.720027, 0.270228, 0.404697>, <-0.700433, 0.347176, 0.324890>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.433898, 0.008317, 0.479349>, <-0.525665, 0.009633, 0.478793>, <-0.649221, 0.006791, 0.487505>, <-0.739721, 0.004379, 0.472436>, 
      <-0.437130, -0.109390, 0.479089>, <-0.528897, -0.108074, 0.478533>, <-0.651323, -0.112575, 0.487184>, <-0.741823, -0.114987, 0.472115>, 
      <-0.441839, -0.273375, 0.418772>, <-0.522761, -0.275634, 0.415332>, <-0.650488, -0.282571, 0.422520>, <-0.730128, -0.281094, 0.407670>, 
      <-0.443240, -0.356850, 0.335734>, <-0.524162, -0.359109, 0.332294>, <-0.633306, -0.364943, 0.337830>, <-0.712947, -0.363466, 0.322979>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.306163, -0.493229, -0.019065>, <-0.305679, -0.484962, 0.096334>, <-0.320334, -0.433963, 0.257742>, <-0.317642, -0.352431, 0.339783>, 
      <-0.346824, -0.494130, -0.023497>, <-0.346341, -0.485862, 0.091902>, <-0.358021, -0.433988, 0.256124>, <-0.355329, -0.352456, 0.338166>, 
      <-0.401558, -0.497386, -0.021207>, <-0.400149, -0.489918, 0.094369>, <-0.406944, -0.437908, 0.255656>, <-0.405566, -0.355798, 0.337336>, 
      <-0.442387, -0.497502, -0.023818>, <-0.440978, -0.490034, 0.091758>, <-0.444618, -0.438960, 0.254055>, <-0.443240, -0.356850, 0.335734>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.322364, -0.433187, -0.787464>, <-0.320649, -0.559884, -0.593990>, <-0.307129, -0.509755, -0.249746>, <-0.306163, -0.493229, -0.019065>, 
      <-0.362699, -0.431744, -0.789548>, <-0.360984, -0.558441, -0.596074>, <-0.347791, -0.510656, -0.254177>, <-0.346824, -0.494130, -0.023497>, 
      <-0.416451, -0.429430, -0.780013>, <-0.412749, -0.554240, -0.589137>, <-0.404333, -0.512093, -0.248805>, <-0.401558, -0.497386, -0.021207>, 
      <-0.456853, -0.429004, -0.780887>, <-0.453151, -0.553814, -0.590011>, <-0.445161, -0.512209, -0.251416>, <-0.442387, -0.497502, -0.023818>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.313371, 0.039107, -0.831975>, <-0.316039, -0.103142, -0.827591>, <-0.323420, -0.355209, -0.906542>, <-0.322364, -0.433187, -0.787464>, 
      <-0.356731, 0.037374, -0.834676>, <-0.359399, -0.104875, -0.830291>, <-0.363755, -0.353766, -0.908625>, <-0.362699, -0.431744, -0.789548>, 
      <-0.414602, 0.030832, -0.830025>, <-0.416540, -0.107799, -0.824977>, <-0.418702, -0.353513, -0.896115>, <-0.416451, -0.429430, -0.780013>, 
      <-0.458052, 0.030667, -0.831565>, <-0.459991, -0.107965, -0.826518>, <-0.459105, -0.353087, -0.896989>, <-0.456853, -0.429004, -0.780887>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.303935, 0.549405, -0.817751>, <-0.308086, 0.473334, -0.950637>, <-0.310500, 0.192182, -0.836694>, <-0.313371, 0.039107, -0.831975>, 
      <-0.345639, 0.550682, -0.819902>, <-0.349789, 0.474611, -0.952788>, <-0.353860, 0.190449, -0.839394>, <-0.356731, 0.037374, -0.834676>, 
      <-0.401488, 0.549464, -0.814171>, <-0.407278, 0.471608, -0.948575>, <-0.412430, 0.186148, -0.835680>, <-0.414602, 0.030832, -0.830025>, 
      <-0.443188, 0.548346, -0.816472>, <-0.448978, 0.470490, -0.950876>, <-0.455881, 0.185983, -0.837221>, <-0.458052, 0.030667, -0.831565>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.288059, 0.503077, -0.021480>, <-0.288977, 0.542983, -0.257460>, <-0.297451, 0.668264, -0.610120>, <-0.303935, 0.549405, -0.817751>, 
      <-0.328456, 0.503664, -0.024173>, <-0.329374, 0.543570, -0.260153>, <-0.339155, 0.669540, -0.612271>, <-0.345639, 0.550682, -0.819902>, 
      <-0.382479, 0.504041, -0.013812>, <-0.386449, 0.545113, -0.250900>, <-0.392523, 0.670006, -0.606078>, <-0.401488, 0.549464, -0.814171>, 
      <-0.422911, 0.503200, -0.015828>, <-0.426881, 0.544271, -0.252915>, <-0.434223, 0.668889, -0.608379>, <-0.443188, 0.548346, -0.816472>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.299449, 0.354440, 0.335162>, <-0.299141, 0.437131, 0.253863>, <-0.287614, 0.483742, 0.092859>, <-0.288059, 0.503077, -0.021480>, 
      <-0.336778, 0.353292, 0.333721>, <-0.336469, 0.435984, 0.252422>, <-0.328011, 0.484329, 0.090166>, <-0.328456, 0.503664, -0.024173>, 
      <-0.386513, 0.349154, 0.338247>, <-0.384698, 0.430902, 0.256450>, <-0.380571, 0.484302, 0.100133>, <-0.382479, 0.504041, -0.013812>, 
      <-0.423869, 0.348477, 0.337290>, <-0.422054, 0.430226, 0.255493>, <-0.421003, 0.483461, 0.098118>, <-0.422911, 0.503200, -0.015828>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.289946, -0.002072, 0.475160>, <-0.286989, 0.112827, 0.474409>, <-0.299756, 0.272478, 0.415743>, <-0.299449, 0.354440, 0.335162>, 
      <-0.333019, 0.000363, 0.471275>, <-0.330062, 0.115262, 0.470524>, <-0.337084, 0.271331, 0.414302>, <-0.336778, 0.353292, 0.333721>, 
      <-0.390587, 0.007696, 0.479611>, <-0.387550, 0.118284, 0.479855>, <-0.388249, 0.270959, 0.416488>, <-0.386513, 0.349154, 0.338247>, 
      <-0.433898, 0.008317, 0.479349>, <-0.430861, 0.118905, 0.479593>, <-0.425605, 0.270282, 0.415531>, <-0.423869, 0.348477, 0.337290>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.289946, -0.002072, 0.475160>, <-0.333019, 0.000363, 0.471275>, <-0.390587, 0.007696, 0.479611>, <-0.433898, 0.008317, 0.479349>, 
      <-0.292853, -0.115019, 0.475899>, <-0.335926, -0.112585, 0.472013>, <-0.393820, -0.110011, 0.479351>, <-0.437130, -0.109390, 0.479089>, 
      <-0.315013, -0.272807, 0.419904>, <-0.352700, -0.272833, 0.418286>, <-0.404165, -0.272323, 0.420373>, <-0.441839, -0.273375, 0.418772>, 
      <-0.317642, -0.352431, 0.339783>, <-0.355329, -0.352456, 0.338166>, <-0.405566, -0.355798, 0.337336>, <-0.443240, -0.356850, 0.335734>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.184498, -0.491793, 0.004288>, <-0.184033, -0.483677, 0.114501>, <-0.184024, -0.433677, 0.267749>, <-0.181376, -0.356674, 0.346973>, 
      <-0.221438, -0.490540, 0.000369>, <-0.220973, -0.482424, 0.110582>, <-0.224928, -0.434230, 0.265759>, <-0.222280, -0.357227, 0.344983>, 
      <-0.269222, -0.492412, -0.015039>, <-0.268739, -0.484144, 0.100360>, <-0.279415, -0.433935, 0.259498>, <-0.276723, -0.352403, 0.341539>, 
      <-0.306163, -0.493229, -0.019065>, <-0.305679, -0.484962, 0.096334>, <-0.320334, -0.433963, 0.257742>, <-0.317642, -0.352431, 0.339783>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.186068, -0.438694, -0.766895>, <-0.187642, -0.565359, -0.572646>, <-0.185472, -0.508823, -0.226987>, <-0.184498, -0.491793, 0.004288>, 
      <-0.227221, -0.439450, -0.771204>, <-0.228795, -0.566114, -0.576955>, <-0.222412, -0.507570, -0.230906>, <-0.221438, -0.490540, 0.000369>, 
      <-0.281061, -0.434665, -0.785330>, <-0.279345, -0.561362, -0.591856>, <-0.270189, -0.508938, -0.245720>, <-0.269222, -0.492412, -0.015039>, 
      <-0.322364, -0.433187, -0.787464>, <-0.320649, -0.559884, -0.593990>, <-0.307129, -0.509755, -0.249746>, <-0.306163, -0.493229, -0.019065>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.177867, 0.041863, -0.814116>, <-0.181634, -0.102878, -0.808938>, <-0.185085, -0.359561, -0.888254>, <-0.186068, -0.438694, -0.766895>, 
      <-0.218718, 0.042434, -0.817696>, <-0.222484, -0.102307, -0.812518>, <-0.226238, -0.360316, -0.892563>, <-0.227221, -0.439450, -0.771204>, 
      <-0.272472, 0.040741, -0.829428>, <-0.275140, -0.101508, -0.825044>, <-0.282117, -0.356687, -0.904407>, <-0.281061, -0.434665, -0.785330>, 
      <-0.313371, 0.039107, -0.831975>, <-0.316039, -0.103142, -0.827591>, <-0.323420, -0.355209, -0.906542>, <-0.322364, -0.433187, -0.787464>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.160606, 0.539698, -0.801898>, <-0.164297, 0.466634, -0.932259>, <-0.173981, 0.191203, -0.819459>, <-0.177867, 0.041863, -0.814116>, 
      <-0.203822, 0.540569, -0.805301>, <-0.207513, 0.467506, -0.935661>, <-0.214831, 0.191773, -0.823039>, <-0.218718, 0.042434, -0.817696>, 
      <-0.260654, 0.548080, -0.815519>, <-0.264804, 0.472010, -0.948405>, <-0.269601, 0.193817, -0.834146>, <-0.272472, 0.040741, -0.829428>, 
      <-0.303935, 0.549405, -0.817751>, <-0.308086, 0.473334, -0.950637>, <-0.310500, 0.192182, -0.836694>, <-0.313371, 0.039107, -0.831975>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.154759, 0.499301, 0.002046>, <-0.154196, 0.537319, -0.236436>, <-0.154643, 0.657733, -0.591300>, <-0.160606, 0.539698, -0.801898>, 
      <-0.195188, 0.499006, -0.001916>, <-0.194625, 0.537024, -0.240398>, <-0.197860, 0.658604, -0.594703>, <-0.203822, 0.540569, -0.805301>, 
      <-0.247529, 0.502488, -0.018779>, <-0.248447, 0.542394, -0.254759>, <-0.254170, 0.666940, -0.607888>, <-0.260654, 0.548080, -0.815519>, 
      <-0.288059, 0.503077, -0.021480>, <-0.288977, 0.542983, -0.257460>, <-0.297451, 0.668264, -0.610120>, <-0.303935, 0.549405, -0.817751>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.163320, 0.356487, 0.347347>, <-0.161265, 0.436132, 0.268445>, <-0.155021, 0.481648, 0.112777>, <-0.154759, 0.499301, 0.002046>, 
      <-0.204214, 0.356026, 0.344334>, <-0.202158, 0.435672, 0.265432>, <-0.195450, 0.481353, 0.108815>, <-0.195188, 0.499006, -0.001916>, 
      <-0.258493, 0.355699, 0.336743>, <-0.258184, 0.438391, 0.255444>, <-0.247084, 0.483152, 0.095560>, <-0.247529, 0.502488, -0.018779>, 
      <-0.299449, 0.354440, 0.335162>, <-0.299141, 0.437131, 0.253863>, <-0.287614, 0.483742, 0.092859>, <-0.288059, 0.503077, -0.021480>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.167819, -0.006723, 0.503350>, <-0.164817, 0.111835, 0.503412>, <-0.165494, 0.272249, 0.430799>, <-0.163320, 0.356487, 0.347347>, 
      <-0.205285, -0.007223, 0.499905>, <-0.202283, 0.111335, 0.499967>, <-0.206388, 0.271788, 0.427786>, <-0.204214, 0.356026, 0.344334>, 
      <-0.252530, -0.004187, 0.478535>, <-0.249573, 0.110713, 0.477784>, <-0.258799, 0.273737, 0.417324>, <-0.258493, 0.355699, 0.336743>, 
      <-0.289946, -0.002072, 0.475160>, <-0.286989, 0.112827, 0.474409>, <-0.299756, 0.272478, 0.415743>, <-0.299449, 0.354440, 0.335162>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.167819, -0.006723, 0.503350>, <-0.205285, -0.007223, 0.499905>, <-0.252530, -0.004187, 0.478535>, <-0.289946, -0.002072, 0.475160>, 
      <-0.170731, -0.121749, 0.503290>, <-0.208197, -0.122249, 0.499845>, <-0.255437, -0.117134, 0.479274>, <-0.292853, -0.115019, 0.475899>, 
      <-0.178620, -0.276501, 0.429459>, <-0.219524, -0.277054, 0.427469>, <-0.274094, -0.272780, 0.421660>, <-0.315013, -0.272807, 0.419904>, 
      <-0.181376, -0.356674, 0.346973>, <-0.222280, -0.357227, 0.344983>, <-0.276723, -0.352403, 0.341539>, <-0.317642, -0.352431, 0.339783>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.419804, -0.366642, -1.296251>, <1.505106, -0.360147, -1.281022>, <1.622321, -0.318499, -1.254076>, <1.682847, -0.256850, -1.244775>, 
      <1.407937, -0.367059, -1.188064>, <1.493240, -0.360565, -1.172834>, <1.608951, -0.319978, -1.146098>, <1.669477, -0.258328, -1.136797>, 
      <1.401651, -0.367399, -1.042337>, <1.485368, -0.361154, -1.028448>, <1.600648, -0.320428, -0.999253>, <1.661809, -0.261836, -0.991087>, 
      <1.380250, -0.368035, -0.935626>, <1.463967, -0.361790, -0.921738>, <1.577121, -0.320371, -0.893015>, <1.638282, -0.261778, -0.884849>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.840253, -0.320999, -1.395209>, <0.987593, -0.415977, -1.371376>, <1.246132, -0.379864, -1.327258>, <1.419804, -0.366642, -1.296251>, 
      <0.828249, -0.321987, -1.283808>, <0.975590, -0.416965, -1.259976>, <1.234266, -0.380282, -1.219070>, <1.407937, -0.367059, -1.188064>, 
      <0.819318, -0.323466, -1.134285>, <0.966614, -0.417787, -1.110673>, <1.228007, -0.380352, -1.071143>, <1.401651, -0.367399, -1.042337>, 
      <0.800242, -0.324293, -1.023875>, <0.947538, -0.418614, -1.000263>, <1.206606, -0.380988, -0.964433>, <1.380250, -0.368035, -0.935626>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.804245, 0.030159, -1.395820>, <0.809612, -0.075601, -1.396643>, <0.752054, -0.264145, -1.409475>, <0.840253, -0.320999, -1.395209>, 
      <0.790504, 0.030153, -1.287665>, <0.795871, -0.075608, -1.288487>, <0.740051, -0.265133, -1.298075>, <0.828249, -0.321987, -1.283808>, 
      <0.779462, 0.028306, -1.142266>, <0.782282, -0.078779, -1.142205>, <0.729919, -0.266219, -1.148616>, <0.819318, -0.323466, -1.134285>, 
      <0.758444, 0.030139, -1.035302>, <0.761264, -0.076945, -1.035241>, <0.710842, -0.267046, -1.038205>, <0.800242, -0.324293, -1.023875>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.802783, 0.417347, -1.389467>, <0.703196, 0.360511, -1.408121>, <0.798357, 0.146179, -1.394918>, <0.804245, 0.030159, -1.395820>, 
      <0.796154, 0.417619, -1.279916>, <0.696566, 0.360782, -1.298570>, <0.784617, 0.146173, -1.286763>, <0.790504, 0.030153, -1.287665>, 
      <0.797751, 0.418954, -1.132712>, <0.697934, 0.361400, -1.151055>, <0.776390, 0.144937, -1.142332>, <0.779462, 0.028306, -1.142266>, 
      <0.780687, 0.418253, -1.024297>, <0.680870, 0.360698, -1.042640>, <0.755373, 0.146770, -1.035369>, <0.758444, 0.030139, -1.035302>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.402943, 0.371848, -1.283675>, <1.225000, 0.401948, -1.315939>, <0.959943, 0.507042, -1.360029>, <0.802783, 0.417347, -1.389467>, 
      <1.393717, 0.375501, -1.175326>, <1.215774, 0.405601, -1.207591>, <0.953314, 0.507313, -1.250478>, <0.796154, 0.417619, -1.279916>, 
      <1.391044, 0.382455, -1.029657>, <1.215983, 0.413273, -1.060165>, <0.952048, 0.507921, -1.104356>, <0.797751, 0.418954, -1.132712>, 
      <1.372190, 0.384023, -0.922512>, <1.197130, 0.414842, -0.953020>, <0.934984, 0.507220, -0.995941>, <0.780687, 0.418253, -1.024297>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.670988, 0.270487, -1.232047>, <1.607063, 0.329569, -1.239379>, <1.487731, 0.357506, -1.268302>, <1.402943, 0.371848, -1.283675>, 
      <1.660968, 0.269561, -1.124923>, <1.597043, 0.328644, -1.132254>, <1.478505, 0.361159, -1.159953>, <1.393717, 0.375501, -1.175326>, 
      <1.659341, 0.268646, -0.980333>, <1.596316, 0.329938, -0.986475>, <1.476588, 0.367396, -1.014750>, <1.391044, 0.382455, -1.029657>, 
      <1.637587, 0.267401, -0.874966>, <1.574562, 0.328694, -0.881109>, <1.457734, 0.368964, -0.907605>, <1.372190, 0.384023, -0.922512>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.791896, 0.012361, -1.239069>, <1.789973, 0.097852, -1.237006>, <1.733584, 0.212634, -1.224869>, <1.670988, 0.270487, -1.232047>, 
      <1.784053, 0.009037, -1.132595>, <1.782131, 0.094528, -1.130532>, <1.723563, 0.211708, -1.117744>, <1.660968, 0.269561, -1.124923>, 
      <1.783000, 0.002115, -0.989565>, <1.782883, 0.090756, -0.987910>, <1.722743, 0.206987, -0.974154>, <1.659341, 0.268646, -0.980333>, 
      <1.765754, 0.001280, -0.884156>, <1.765637, 0.089920, -0.882501>, <1.700989, 0.205742, -0.868787>, <1.637587, 0.267401, -0.874966>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.791896, 0.012361, -1.239069>, <1.784053, 0.009037, -1.132595>, <1.783000, 0.002115, -0.989565>, <1.765754, 0.001280, -0.884156>, 
      <1.793854, -0.074746, -1.241172>, <1.786012, -0.078070, -1.134698>, <1.783115, -0.085564, -0.991203>, <1.765869, -0.086400, -0.885793>, 
      <1.743554, -0.195015, -1.235445>, <1.730184, -0.196494, -1.127468>, <1.724841, -0.201450, -0.982672>, <1.701315, -0.201392, -0.876433>, 
      <1.682847, -0.256850, -1.244775>, <1.669477, -0.258328, -1.136797>, <1.661809, -0.261836, -0.991087>, <1.638282, -0.261778, -0.884849>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.318382, -0.369657, -0.790551>, <1.335536, -0.362952, -0.834137>, <1.370945, -0.368312, -0.889234>, <1.380250, -0.368035, -0.935626>, 
      <1.397674, -0.362885, -0.759960>, <1.414829, -0.356181, -0.803545>, <1.454663, -0.362067, -0.875345>, <1.463967, -0.361790, -0.921738>, 
      <1.502814, -0.314938, -0.716843>, <1.521217, -0.311810, -0.775187>, <1.563876, -0.320339, -0.833207>, <1.577121, -0.320371, -0.893015>, 
      <1.561276, -0.256554, -0.695808>, <1.579678, -0.253426, -0.754152>, <1.625037, -0.261746, -0.825041>, <1.638282, -0.261778, -0.884849>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.772024, -0.323955, -1.000310>, <0.780469, -0.321196, -1.006846>, <0.798364, -0.324374, -1.013006>, <0.800242, -0.324293, -1.023875>, 
      <0.911338, -0.419669, -0.950872>, <0.919782, -0.416910, -0.957409>, <0.945660, -0.418695, -0.989395>, <0.947538, -0.418614, -1.000263>, 
      <1.154599, -0.383643, -0.853741>, <1.171753, -0.376939, -0.897326>, <1.197301, -0.381265, -0.918040>, <1.206606, -0.380988, -0.964433>, 
      <1.318382, -0.369657, -0.790551>, <1.335536, -0.362952, -0.834137>, <1.370945, -0.368312, -0.889234>, <1.380250, -0.368035, -0.935626>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.726579, 0.036934, -1.000559>, <0.737683, 0.035961, -1.009500>, <0.755690, 0.030379, -1.021283>, <0.758444, 0.030139, -1.035302>, 
      <0.731266, -0.072081, -1.001750>, <0.742370, -0.073053, -1.010691>, <0.758510, -0.076705, -1.021222>, <0.761264, -0.076945, -1.035241>, 
      <0.685700, -0.264648, -1.030942>, <0.694145, -0.261889, -1.037479>, <0.708965, -0.267127, -1.027337>, <0.710842, -0.267046, -1.038205>, 
      <0.772024, -0.323955, -1.000310>, <0.780469, -0.321196, -1.006846>, <0.798364, -0.324374, -1.013006>, <0.800242, -0.324293, -1.023875>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.740262, 0.414779, -0.992239>, <0.752191, 0.409671, -1.000740>, <0.778275, 0.418154, -1.008973>, <0.780687, 0.418253, -1.024297>, 
      <0.647094, 0.360486, -1.027510>, <0.659023, 0.355378, -1.036011>, <0.678458, 0.360599, -1.027316>, <0.680870, 0.360698, -1.042640>, 
      <0.721706, 0.150278, -0.999321>, <0.732809, 0.149305, -1.008262>, <0.752618, 0.147011, -1.021349>, <0.755373, 0.146770, -1.035369>, 
      <0.726579, 0.036934, -1.000559>, <0.737683, 0.035961, -1.009500>, <0.755690, 0.030379, -1.021283>, <0.758444, 0.030139, -1.035302>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.313993, 0.379247, -0.778177>, <1.331063, 0.375308, -0.821478>, <1.364096, 0.384697, -0.876514>, <1.372190, 0.384023, -0.922512>, 
      <1.143486, 0.410571, -0.839892>, <1.160556, 0.406631, -0.883193>, <1.189035, 0.415515, -0.907022>, <1.197130, 0.414842, -0.953020>, 
      <0.891375, 0.502839, -0.935030>, <0.903304, 0.497732, -0.943532>, <0.932572, 0.507121, -0.980617>, <0.934984, 0.507220, -0.995941>, 
      <0.740262, 0.414779, -0.992239>, <0.752191, 0.409671, -1.000740>, <0.778275, 0.418154, -1.008973>, <0.780687, 0.418253, -1.024297>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.560204, 0.264150, -0.695462>, <1.578882, 0.260210, -0.750919>, <1.625729, 0.266723, -0.817531>, <1.637587, 0.267401, -0.874966>, 
      <1.500664, 0.322014, -0.714712>, <1.519342, 0.318074, -0.770169>, <1.562704, 0.328016, -0.823674>, <1.574562, 0.328694, -0.881109>, 
      <1.392964, 0.364740, -0.749594>, <1.410034, 0.360800, -0.792894>, <1.449640, 0.369637, -0.861607>, <1.457734, 0.368964, -0.907605>, 
      <1.313993, 0.379247, -0.778177>, <1.331063, 0.375308, -0.821478>, <1.364096, 0.384697, -0.876514>, <1.372190, 0.384023, -0.922512>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.696269, 0.007730, -0.654584>, <1.718073, 0.007894, -0.723185>, <1.754131, 0.000717, -0.813119>, <1.765754, 0.001280, -0.884156>, 
      <1.696088, 0.095674, -0.654525>, <1.717892, 0.095838, -0.723127>, <1.754015, 0.089358, -0.811464>, <1.765637, 0.089920, -0.882501>, 
      <1.621641, 0.204441, -0.675599>, <1.640319, 0.200501, -0.731055>, <1.689131, 0.205064, -0.811352>, <1.700989, 0.205742, -0.868787>, 
      <1.560204, 0.264150, -0.695462>, <1.578882, 0.260210, -0.750919>, <1.625729, 0.266723, -0.817531>, <1.637587, 0.267401, -0.874966>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.696269, 0.007730, -0.654584>, <1.696454, -0.082154, -0.654644>, <1.622910, -0.195002, -0.673632>, <1.561276, -0.256554, -0.695808>, 
      <1.718073, 0.007894, -0.723185>, <1.718258, -0.081990, -0.723245>, <1.641312, -0.191874, -0.731976>, <1.579678, -0.253426, -0.754152>, 
      <1.754131, 0.000717, -0.813119>, <1.754247, -0.086962, -0.814757>, <1.688070, -0.201360, -0.816625>, <1.625037, -0.261746, -0.825041>, 
      <1.765754, 0.001280, -0.884156>, <1.765869, -0.086400, -0.885793>, <1.701315, -0.201392, -0.876433>, <1.638282, -0.261778, -0.884849>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.248128, -0.419671, -0.599931>, <1.273552, -0.406983, -0.655898>, <1.295627, -0.378550, -0.732735>, <1.318382, -0.369657, -0.790551>, 
      <1.330335, -0.412340, -0.547077>, <1.355759, -0.399653, -0.603043>, <1.374919, -0.371778, -0.702144>, <1.397674, -0.362885, -0.759960>, 
      <1.438643, -0.354803, -0.474031>, <1.467222, -0.346071, -0.549411>, <1.478455, -0.319078, -0.639613>, <1.502814, -0.314938, -0.716843>, 
      <1.496415, -0.285890, -0.435061>, <1.524994, -0.277158, -0.510441>, <1.536917, -0.260694, -0.618577>, <1.561276, -0.256554, -0.695808>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.700581, -0.356855, -0.946734>, <0.722947, -0.347642, -0.961900>, <0.750165, -0.331097, -0.983390>, <0.772024, -0.323955, -1.000310>, 
      <0.838624, -0.465423, -0.861180>, <0.860990, -0.456210, -0.876345>, <0.889479, -0.426811, -0.933953>, <0.911338, -0.419669, -0.950872>, 
      <1.084269, -0.434282, -0.705283>, <1.109693, -0.421595, -0.761249>, <1.131844, -0.392537, -0.795924>, <1.154599, -0.383643, -0.853741>, 
      <1.248128, -0.419671, -0.599931>, <1.273552, -0.406983, -0.655898>, <1.295627, -0.378550, -0.732735>, <1.318382, -0.369657, -0.790551>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.665897, 0.038246, -0.960779>, <0.685219, 0.038873, -0.970793>, <0.709662, 0.038416, -0.986936>, <0.726579, 0.036934, -1.000559>, 
      <0.669393, -0.080762, -0.960298>, <0.688715, -0.080135, -0.970311>, <0.714349, -0.070598, -0.988127>, <0.731266, -0.072081, -1.001750>, 
      <0.616449, -0.290685, -0.998877>, <0.638815, -0.281473, -1.014042>, <0.663841, -0.271790, -1.014023>, <0.685700, -0.264648, -1.030942>, 
      <0.700581, -0.356855, -0.946734>, <0.722947, -0.347642, -0.961900>, <0.750165, -0.331097, -0.983390>, <0.772024, -0.323955, -1.000310>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.676502, 0.462860, -0.950049>, <0.697607, 0.451374, -0.962572>, <0.719427, 0.423699, -0.977390>, <0.740262, 0.414779, -0.992239>, 
      <0.583697, 0.401523, -1.012275>, <0.604802, 0.390037, -1.024798>, <0.626259, 0.369406, -1.012662>, <0.647094, 0.360486, -1.027510>, 
      <0.662155, 0.165655, -0.961295>, <0.681476, 0.166282, -0.971308>, <0.704788, 0.151760, -0.985698>, <0.721706, 0.150278, -0.999321>, 
      <0.665897, 0.038246, -0.960779>, <0.685219, 0.038873, -0.970793>, <0.709662, 0.038416, -0.986936>, <0.726579, 0.036934, -1.000559>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.236460, 0.415350, -0.578212>, <1.265130, 0.403554, -0.635622>, <1.290150, 0.384751, -0.717694>, <1.313993, 0.379247, -0.778177>, 
      <1.068754, 0.449222, -0.685888>, <1.097425, 0.437426, -0.743298>, <1.119642, 0.416074, -0.779409>, <1.143486, 0.410571, -0.839892>, 
      <0.823688, 0.560140, -0.851360>, <0.844792, 0.548654, -0.863883>, <0.870540, 0.511760, -0.920182>, <0.891375, 0.502839, -0.935030>, 
      <0.676502, 0.462860, -0.950049>, <0.697607, 0.451374, -0.962572>, <0.719427, 0.423699, -0.977390>, <0.740262, 0.414779, -0.992239>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.487502, 0.299059, -0.429345>, <1.518176, 0.289967, -0.506387>, <1.533638, 0.269753, -0.616583>, <1.560204, 0.264150, -0.695462>, 
      <1.429680, 0.365120, -0.463642>, <1.460355, 0.356028, -0.540684>, <1.474098, 0.327618, -0.635833>, <1.500664, 0.322014, -0.714712>, 
      <1.314651, 0.399557, -0.528009>, <1.343322, 0.387761, -0.585420>, <1.369120, 0.370243, -0.689110>, <1.392964, 0.364740, -0.749594>, 
      <1.236460, 0.415350, -0.578212>, <1.265130, 0.403554, -0.635622>, <1.290150, 0.384751, -0.717694>, <1.313993, 0.379247, -0.778177>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.599978, 0.000035, -0.362588>, <1.635096, 0.001846, -0.447892>, <1.668320, 0.007520, -0.566651>, <1.696269, 0.007730, -0.654584>, 
      <1.598486, 0.097933, -0.361631>, <1.633604, 0.099743, -0.446935>, <1.668139, 0.095464, -0.566593>, <1.696088, 0.095674, -0.654525>, 
      <1.547569, 0.230433, -0.393715>, <1.578243, 0.221341, -0.470757>, <1.595075, 0.210045, -0.596720>, <1.621641, 0.204441, -0.675599>, 
      <1.487502, 0.299059, -0.429345>, <1.518176, 0.289967, -0.506387>, <1.533638, 0.269753, -0.616583>, <1.560204, 0.264150, -0.695462>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.599978, 0.000035, -0.362588>, <1.601407, -0.093735, -0.363504>, <1.551698, -0.219944, -0.397769>, <1.496415, -0.285890, -0.435061>, 
      <1.635096, 0.001846, -0.447892>, <1.636525, -0.091924, -0.448808>, <1.580278, -0.211213, -0.473149>, <1.524994, -0.277158, -0.510441>, 
      <1.668320, 0.007520, -0.566651>, <1.668505, -0.082364, -0.566711>, <1.598550, -0.199142, -0.596401>, <1.536917, -0.260694, -0.618577>, 
      <1.696269, 0.007730, -0.654584>, <1.696454, -0.082154, -0.654644>, <1.622910, -0.195002, -0.673632>, <1.561276, -0.256554, -0.695808>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.150175, -0.453597, -0.420270>, <1.189163, -0.442768, -0.467543>, <1.222923, -0.432249, -0.544445>, <1.248128, -0.419671, -0.599931>, 
      <1.225166, -0.446532, -0.349984>, <1.264155, -0.435704, -0.397257>, <1.305130, -0.424918, -0.491591>, <1.330335, -0.412340, -0.547077>, 
      <1.321690, -0.386765, -0.251253>, <1.368364, -0.379134, -0.316066>, <1.410364, -0.363443, -0.399445>, <1.438643, -0.354803, -0.474031>, 
      <1.373079, -0.314053, -0.199428>, <1.419753, -0.306422, -0.264242>, <1.468136, -0.294530, -0.360474>, <1.496415, -0.285890, -0.435061>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.624967, -0.384529, -0.900599>, <0.648285, -0.375325, -0.912708>, <0.678771, -0.365838, -0.931946>, <0.700581, -0.356855, -0.946734>, 
      <0.761034, -0.499771, -0.781332>, <0.784353, -0.490567, -0.793440>, <0.816814, -0.474407, -0.846392>, <0.838624, -0.465423, -0.861180>, 
      <0.994022, -0.468307, -0.566624>, <1.033011, -0.457478, -0.613897>, <1.059063, -0.446860, -0.649797>, <1.084269, -0.434282, -0.705283>, 
      <1.150175, -0.453597, -0.420270>, <1.189163, -0.442768, -0.467543>, <1.222923, -0.432249, -0.544445>, <1.248128, -0.419671, -0.599931>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.576738, 0.032073, -0.922904>, <0.603826, 0.030886, -0.933526>, <0.640054, 0.037408, -0.947386>, <0.665897, 0.038246, -0.960779>, 
      <0.582092, -0.093806, -0.922768>, <0.609180, -0.094993, -0.933389>, <0.643550, -0.081601, -0.946905>, <0.669393, -0.080762, -0.960298>, 
      <0.545052, -0.316845, -0.970647>, <0.568370, -0.307641, -0.982756>, <0.594639, -0.299669, -0.984089>, <0.616449, -0.290685, -0.998877>, 
      <0.624967, -0.384529, -0.900599>, <0.648285, -0.375325, -0.912708>, <0.678771, -0.365838, -0.931946>, <0.700581, -0.356855, -0.946734>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.587435, 0.497955, -0.901554>, <0.615375, 0.484844, -0.910712>, <0.651426, 0.476508, -0.935169>, <0.676502, 0.462860, -0.950049>, 
      <0.497886, 0.429541, -0.984535>, <0.525827, 0.416429, -0.993694>, <0.558621, 0.415170, -0.997395>, <0.583697, 0.401523, -1.012275>, 
      <0.570792, 0.171895, -0.923056>, <0.597879, 0.170708, -0.933677>, <0.636311, 0.164817, -0.947901>, <0.662155, 0.165655, -0.961295>, 
      <0.576738, 0.032073, -0.922904>, <0.603826, 0.030886, -0.933526>, <0.640054, 0.037408, -0.947386>, <0.665897, 0.038246, -0.960779>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.130159, 0.454883, -0.410067>, <1.168324, 0.445124, -0.456439>, <1.209723, 0.426350, -0.524674>, <1.236460, 0.415350, -0.578212>, 
      <0.969654, 0.491154, -0.556146>, <1.007819, 0.481395, -0.602519>, <1.042018, 0.460223, -0.632350>, <1.068754, 0.449222, -0.685888>, 
      <0.728231, 0.605522, -0.771083>, <0.756171, 0.592411, -0.780241>, <0.798612, 0.573788, -0.836480>, <0.823688, 0.560140, -0.851360>, 
      <0.587435, 0.497955, -0.901554>, <0.615375, 0.484844, -0.910712>, <0.651426, 0.476508, -0.935169>, <0.676502, 0.462860, -0.950049>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.361695, 0.322990, -0.196885>, <1.407913, 0.315649, -0.261301>, <1.458225, 0.307737, -0.355813>, <1.487502, 0.299059, -0.429345>, 
      <1.308401, 0.395407, -0.245835>, <1.354619, 0.388066, -0.310251>, <1.400403, 0.373798, -0.390110>, <1.429680, 0.365120, -0.463642>, 
      <1.204836, 0.438008, -0.342102>, <1.243001, 0.428249, -0.388475>, <1.287915, 0.410558, -0.474471>, <1.314651, 0.399557, -0.528009>, 
      <1.130159, 0.454883, -0.410067>, <1.168324, 0.445124, -0.456439>, <1.209723, 0.426350, -0.524674>, <1.236460, 0.415350, -0.578212>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.467898, -0.004047, -0.099857>, <1.518078, -0.003876, -0.172425>, <1.566398, -0.001697, -0.281019>, <1.599978, 0.000035, -0.362588>, 
      <1.465983, 0.103118, -0.099429>, <1.516162, 0.103289, -0.171997>, <1.564906, 0.096201, -0.280063>, <1.598486, 0.097933, -0.361631>, 
      <1.417492, 0.247171, -0.145636>, <1.463710, 0.239831, -0.210052>, <1.518292, 0.239111, -0.320183>, <1.547569, 0.230433, -0.393715>, 
      <1.361695, 0.322990, -0.196885>, <1.407913, 0.315649, -0.261301>, <1.458225, 0.307737, -0.355813>, <1.487502, 0.299059, -0.429345>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.467898, -0.004047, -0.099857>, <1.469716, -0.105769, -0.100263>, <1.423829, -0.242248, -0.148249>, <1.373079, -0.314053, -0.199428>, 
      <1.518078, -0.003876, -0.172425>, <1.519895, -0.105598, -0.172831>, <1.470503, -0.234616, -0.213063>, <1.419753, -0.306422, -0.264242>, 
      <1.566398, -0.001697, -0.281019>, <1.567827, -0.095467, -0.281936>, <1.523420, -0.228584, -0.323182>, <1.468136, -0.294530, -0.360474>, 
      <1.599978, 0.000035, -0.362588>, <1.601407, -0.093735, -0.363504>, <1.551698, -0.219944, -0.397769>, <1.496415, -0.285890, -0.435061>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.929233, -0.508240, -0.213275>, <1.003140, -0.500638, -0.268031>, <1.092346, -0.469658, -0.350154>, <1.150175, -0.453597, -0.420270>, 
      <0.991891, -0.499839, -0.113871>, <1.065798, -0.492237, -0.168628>, <1.167338, -0.462593, -0.279868>, <1.225166, -0.446532, -0.349984>, 
      <1.073895, -0.430719, 0.020176>, <1.166666, -0.423458, -0.050719>, <1.253638, -0.397892, -0.156753>, <1.321690, -0.386765, -0.251253>, 
      <1.116615, -0.347988, 0.092346>, <1.209385, -0.340728, 0.021451>, <1.305027, -0.325180, -0.104928>, <1.373079, -0.314053, -0.199428>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.520569, -0.427906, -0.853255>, <0.551656, -0.419456, -0.870979>, <0.594170, -0.396685, -0.884606>, <0.624967, -0.384529, -0.900599>, 
      <0.624407, -0.557350, -0.695346>, <0.655494, -0.548899, -0.713070>, <0.730237, -0.511926, -0.765339>, <0.761034, -0.499771, -0.781332>, 
      <0.807394, -0.524576, -0.406566>, <0.881301, -0.516974, -0.461323>, <0.936194, -0.484368, -0.496508>, <0.994022, -0.468307, -0.566624>, 
      <0.929233, -0.508240, -0.213275>, <1.003140, -0.500638, -0.268031>, <1.092346, -0.469658, -0.350154>, <1.150175, -0.453597, -0.420270>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.484470, 0.046198, -0.889640>, <0.511318, 0.043649, -0.902146>, <0.549085, 0.033286, -0.912061>, <0.576738, 0.032073, -0.922904>, 
      <0.489110, -0.096694, -0.884492>, <0.515958, -0.099243, -0.896999>, <0.554438, -0.092594, -0.911925>, <0.582092, -0.093806, -0.922768>, 
      <0.455720, -0.347066, -0.951874>, <0.486807, -0.338615, -0.969598>, <0.514255, -0.329001, -0.954654>, <0.545052, -0.316845, -0.970647>, 
      <0.520569, -0.427906, -0.853255>, <0.551656, -0.419456, -0.870979>, <0.594170, -0.396685, -0.884606>, <0.624967, -0.384529, -0.900599>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.488784, 0.550950, -0.888520>, <0.519556, 0.540722, -0.898133>, <0.558081, 0.511730, -0.891932>, <0.587435, 0.497955, -0.901554>, 
      <0.418047, 0.478152, -1.000895>, <0.448819, 0.467924, -1.010508>, <0.468533, 0.443315, -0.974914>, <0.497886, 0.429541, -0.984535>, 
      <0.479558, 0.197452, -0.895089>, <0.506407, 0.194903, -0.907596>, <0.543138, 0.173107, -0.912212>, <0.570792, 0.171895, -0.923056>, 
      <0.484470, 0.046198, -0.889640>, <0.511318, 0.043649, -0.902146>, <0.549085, 0.033286, -0.912061>, <0.576738, 0.032073, -0.922904>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.921444, 0.495902, -0.195449>, <0.994373, 0.488479, -0.248776>, <1.073300, 0.469422, -0.340979>, <1.130159, 0.454883, -0.410067>, 
      <0.792296, 0.535818, -0.400581>, <0.865226, 0.528395, -0.453908>, <0.912794, 0.505693, -0.487059>, <0.969654, 0.491154, -0.556146>, 
      <0.603540, 0.669049, -0.706215>, <0.634312, 0.658821, -0.715828>, <0.698877, 0.619297, -0.761461>, <0.728231, 0.605522, -0.771083>, 
      <0.488784, 0.550950, -0.888520>, <0.519556, 0.540722, -0.898133>, <0.558081, 0.511730, -0.891932>, <0.587435, 0.497955, -0.901554>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.109533, 0.359091, 0.097448>, <1.201969, 0.354379, 0.026243>, <1.293908, 0.333756, -0.102408>, <1.361695, 0.322990, -0.196885>, 
      <1.066764, 0.437996, 0.030111>, <1.159200, 0.433284, -0.041094>, <1.240615, 0.406174, -0.151358>, <1.308401, 0.395407, -0.245835>, 
      <0.980430, 0.477671, -0.101759>, <1.053359, 0.470248, -0.155086>, <1.147977, 0.452547, -0.273014>, <1.204836, 0.438008, -0.342102>, 
      <0.921444, 0.495902, -0.195449>, <0.994373, 0.488479, -0.248776>, <1.073300, 0.469422, -0.340979>, <1.130159, 0.454883, -0.410067>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.190973, -0.001357, 0.228905>, <1.293304, -0.001980, 0.150431>, <1.394554, -0.004296, 0.006212>, <1.467898, -0.004047, -0.099857>, 
      <1.189794, 0.116300, 0.229754>, <1.292126, 0.115677, 0.151280>, <1.392639, 0.102869, 0.006640>, <1.465983, 0.103118, -0.099429>, 
      <1.154384, 0.276344, 0.168063>, <1.246821, 0.271631, 0.096858>, <1.349705, 0.257938, -0.051159>, <1.417492, 0.247171, -0.145636>, 
      <1.109533, 0.359091, 0.097448>, <1.201969, 0.354379, 0.026243>, <1.293908, 0.333756, -0.102408>, <1.361695, 0.322990, -0.196885>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.190973, -0.001357, 0.228905>, <1.192114, -0.115321, 0.228082>, <1.157945, -0.267949, 0.162168>, <1.116615, -0.347988, 0.092346>, 
      <1.293304, -0.001980, 0.150431>, <1.294445, -0.115944, 0.149609>, <1.250716, -0.260688, 0.091273>, <1.209385, -0.340728, 0.021451>, 
      <1.394554, -0.004296, 0.006212>, <1.396372, -0.106018, 0.005806>, <1.355777, -0.253375, -0.053749>, <1.305027, -0.325180, -0.104928>, 
      <1.467898, -0.004047, -0.099857>, <1.469716, -0.105769, -0.100263>, <1.423829, -0.242248, -0.148249>, <1.373079, -0.314053, -0.199428>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.702959, -0.499593, -0.088934>, <0.773069, -0.501169, -0.121923>, <0.867173, -0.514622, -0.167296>, <0.929233, -0.508240, -0.213275>, 
      <0.733853, -0.493063, 0.019709>, <0.803963, -0.494639, -0.013280>, <0.929831, -0.506221, -0.067892>, <0.991891, -0.499839, -0.113871>, 
      <0.761356, -0.440662, 0.175534>, <0.863859, -0.441239, 0.131674>, <0.985479, -0.437639, 0.087744>, <1.073895, -0.430719, 0.020176>, 
      <0.781539, -0.360352, 0.252627>, <0.884041, -0.360929, 0.208767>, <1.028199, -0.354909, 0.159913>, <1.116615, -0.347988, 0.092346>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.477514, -0.424612, -0.816533>, <0.492261, -0.424581, -0.825002>, <0.506192, -0.431815, -0.845058>, <0.520569, -0.427906, -0.853255>, 
      <0.535143, -0.551814, -0.634256>, <0.549890, -0.551783, -0.642725>, <0.610029, -0.561258, -0.687149>, <0.624407, -0.557350, -0.695346>, 
      <0.640259, -0.512846, -0.309432>, <0.710369, -0.514422, -0.342421>, <0.745335, -0.530959, -0.360588>, <0.807394, -0.524576, -0.406566>, 
      <0.702959, -0.499593, -0.088934>, <0.773069, -0.501169, -0.121923>, <0.867173, -0.514622, -0.167296>, <0.929233, -0.508240, -0.213275>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.456935, 0.043449, -0.867098>, <0.466226, 0.044504, -0.872315>, <0.474799, 0.047117, -0.885135>, <0.484470, 0.046198, -0.889640>, 
      <0.460137, -0.097740, -0.860693>, <0.469428, -0.096685, -0.865910>, <0.479439, -0.095776, -0.879987>, <0.489110, -0.096694, -0.884492>, 
      <0.442035, -0.346298, -0.928754>, <0.456781, -0.346267, -0.937223>, <0.441342, -0.350974, -0.943677>, <0.455720, -0.347066, -0.951874>, 
      <0.477514, -0.424612, -0.816533>, <0.492261, -0.424581, -0.825002>, <0.506192, -0.431815, -0.845058>, <0.520569, -0.427906, -0.853255>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.455598, 0.541777, -0.860369>, <0.466631, 0.541661, -0.867870>, <0.476645, 0.554985, -0.884728>, <0.488784, 0.550950, -0.888520>, 
      <0.420115, 0.468785, -0.985936>, <0.431148, 0.468669, -0.993437>, <0.405908, 0.482187, -0.997103>, <0.418047, 0.478152, -1.000895>, 
      <0.453549, 0.192770, -0.873871>, <0.462839, 0.193824, -0.879088>, <0.469888, 0.198370, -0.890584>, <0.479558, 0.197452, -0.895089>, 
      <0.456935, 0.043449, -0.867098>, <0.466226, 0.044504, -0.872315>, <0.474799, 0.047117, -0.885135>, <0.484470, 0.046198, -0.889640>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.679256, 0.500779, -0.080363>, <0.753627, 0.499908, -0.111044>, <0.856716, 0.502490, -0.148120>, <0.921444, 0.495902, -0.195449>, 
      <0.613617, 0.539877, -0.311821>, <0.687988, 0.539007, -0.342502>, <0.727569, 0.542407, -0.353252>, <0.792296, 0.535818, -0.400581>, 
      <0.513445, 0.660772, -0.655664>, <0.524478, 0.660656, -0.663165>, <0.591401, 0.673084, -0.702423>, <0.603540, 0.669049, -0.706215>, 
      <0.455598, 0.541777, -0.860369>, <0.466631, 0.541661, -0.867870>, <0.476645, 0.554985, -0.884728>, <0.488784, 0.550950, -0.888520>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.772469, 0.353028, 0.257002>, <0.876078, 0.353025, 0.214756>, <1.020964, 0.363606, 0.165673>, <1.109533, 0.359091, 0.097448>, 
      <0.748295, 0.434185, 0.180718>, <0.851904, 0.434182, 0.138472>, <0.978195, 0.442512, 0.098336>, <1.066764, 0.437996, 0.030111>, 
      <0.709948, 0.482496, 0.027867>, <0.784319, 0.481625, -0.002814>, <0.915702, 0.484259, -0.054430>, <0.980430, 0.477671, -0.101759>, 
      <0.679256, 0.500779, -0.080363>, <0.753627, 0.499908, -0.111044>, <0.856716, 0.502490, -0.148120>, <0.921444, 0.495902, -0.195449>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.828468, -0.000158, 0.390495>, <0.939328, -0.001621, 0.347078>, <1.096490, -0.000783, 0.301360>, <1.190973, -0.001357, 0.228905>, 
      <0.827012, 0.114341, 0.391197>, <0.937872, 0.112878, 0.347781>, <1.095312, 0.116874, 0.302209>, <1.189794, 0.116300, 0.229754>, 
      <0.796757, 0.271489, 0.333645>, <0.900366, 0.271486, 0.291399>, <1.065815, 0.280859, 0.236289>, <1.154384, 0.276344, 0.168063>, 
      <0.772469, 0.353028, 0.257002>, <0.876078, 0.353025, 0.214756>, <1.020964, 0.363606, 0.165673>, <1.109533, 0.359091, 0.097448>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.828468, -0.000158, 0.390495>, <0.829950, -0.116703, 0.389780>, <0.802330, -0.277616, 0.332049>, <0.781539, -0.360352, 0.252627>, 
      <0.939328, -0.001621, 0.347078>, <0.940809, -0.118166, 0.346363>, <0.904833, -0.278193, 0.288190>, <0.884041, -0.360929, 0.208767>, 
      <1.096490, -0.000783, 0.301360>, <1.097631, -0.114747, 0.300537>, <1.069529, -0.274869, 0.229736>, <1.028199, -0.354909, 0.159913>, 
      <1.190973, -0.001357, 0.228905>, <1.192114, -0.115321, 0.228082>, <1.157945, -0.267949, 0.162168>, <1.116615, -0.347988, 0.092346>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.570143, -0.500167, -0.044311>, <0.611220, -0.501018, -0.053186>, <0.664933, -0.498738, -0.071042>, <0.702959, -0.499593, -0.088934>, 
      <0.590054, -0.491655, 0.069064>, <0.631131, -0.492506, 0.060189>, <0.695826, -0.492208, 0.037602>, <0.733853, -0.493063, 0.019709>, 
      <0.613136, -0.427480, 0.223548>, <0.662578, -0.428511, 0.213231>, <0.714913, -0.440401, 0.195406>, <0.761356, -0.440662, 0.175534>, 
      <0.621903, -0.345205, 0.304026>, <0.671344, -0.346236, 0.293708>, <0.735096, -0.360091, 0.272499>, <0.781539, -0.360352, 0.252627>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.427993, -0.428103, -0.800089>, <0.443124, -0.426792, -0.804025>, <0.463909, -0.424641, -0.808719>, <0.477514, -0.424612, -0.816533>, 
      <0.464920, -0.555202, -0.609888>, <0.480051, -0.553890, -0.613824>, <0.521538, -0.551843, -0.626443>, <0.535143, -0.551814, -0.634256>, 
      <0.530170, -0.517257, -0.271916>, <0.571247, -0.518107, -0.280792>, <0.602232, -0.511991, -0.291539>, <0.640259, -0.512846, -0.309432>, 
      <0.570143, -0.500167, -0.044311>, <0.611220, -0.501018, -0.053186>, <0.664933, -0.498738, -0.071042>, <0.702959, -0.499593, -0.088934>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.413735, 0.038169, -0.849922>, <0.427344, 0.038653, -0.853324>, <0.444756, 0.042066, -0.860259>, <0.456935, 0.043449, -0.867098>, 
      <0.416784, -0.102463, -0.845235>, <0.430393, -0.101979, -0.848637>, <0.447957, -0.099122, -0.853854>, <0.460137, -0.097740, -0.860693>, 
      <0.405564, -0.350905, -0.915614>, <0.420695, -0.349594, -0.919550>, <0.428430, -0.346327, -0.920941>, <0.442035, -0.346298, -0.928754>, 
      <0.427993, -0.428103, -0.800089>, <0.443124, -0.426792, -0.804025>, <0.463909, -0.424641, -0.808719>, <0.477514, -0.424612, -0.816533>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.406750, 0.551815, -0.832745>, <0.423142, 0.552801, -0.837522>, <0.441456, 0.541926, -0.850753>, <0.455598, 0.541777, -0.860369>, 
      <0.383622, 0.475984, -0.964997>, <0.400014, 0.476970, -0.969774>, <0.405972, 0.468934, -0.976320>, <0.420115, 0.468785, -0.985936>, 
      <0.410395, 0.192241, -0.855056>, <0.424004, 0.192725, -0.858458>, <0.441369, 0.191387, -0.867032>, <0.453549, 0.192770, -0.873871>, 
      <0.413735, 0.038169, -0.849922>, <0.427344, 0.038653, -0.853324>, <0.444756, 0.042066, -0.860259>, <0.456935, 0.043449, -0.867098>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.554651, 0.500197, -0.044133>, <0.592946, 0.499816, -0.051128>, <0.643270, 0.501200, -0.065518>, <0.679256, 0.500779, -0.080363>, 
      <0.513670, 0.539960, -0.278483>, <0.551964, 0.539578, -0.285478>, <0.577632, 0.540299, -0.296976>, <0.613617, 0.539877, -0.311821>, 
      <0.442929, 0.670438, -0.625863>, <0.459321, 0.671424, -0.630641>, <0.499302, 0.660921, -0.646048>, <0.513445, 0.660772, -0.655664>, 
      <0.406750, 0.551815, -0.832745>, <0.423142, 0.552801, -0.837522>, <0.441456, 0.541926, -0.850753>, <0.455598, 0.541777, -0.860369>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.605364, 0.359106, 0.303020>, <0.656500, 0.358389, 0.293443>, <0.724291, 0.353029, 0.276647>, <0.772469, 0.353028, 0.257002>, 
      <0.594156, 0.438852, 0.223117>, <0.645292, 0.438134, 0.213540>, <0.700117, 0.434186, 0.200363>, <0.748295, 0.434185, 0.180718>, 
      <0.573925, 0.481496, 0.066086>, <0.612220, 0.481114, 0.059091>, <0.673963, 0.482917, 0.042713>, <0.709948, 0.482496, 0.027867>, 
      <0.554651, 0.500197, -0.044133>, <0.592946, 0.499816, -0.051128>, <0.643270, 0.501200, -0.065518>, <0.679256, 0.500779, -0.080363>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.624088, 0.006124, 0.450917>, <0.686990, 0.006173, 0.439304>, <0.768912, 0.000628, 0.413819>, <0.828468, -0.000158, 0.390495>, 
      <0.621389, 0.121044, 0.450753>, <0.684291, 0.121092, 0.439140>, <0.767456, 0.115127, 0.414521>, <0.827012, 0.114341, 0.391197>, 
      <0.616720, 0.278301, 0.383985>, <0.667856, 0.277583, 0.374408>, <0.748579, 0.271490, 0.353290>, <0.796757, 0.271489, 0.333645>, 
      <0.605364, 0.359106, 0.303020>, <0.656500, 0.358389, 0.293443>, <0.724291, 0.353029, 0.276647>, <0.772469, 0.353028, 0.257002>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.624088, 0.006124, 0.450917>, <0.626770, -0.108086, 0.451080>, <0.630579, -0.263772, 0.383679>, <0.621903, -0.345205, 0.304026>, 
      <0.686990, 0.006173, 0.439304>, <0.689672, -0.108038, 0.439467>, <0.680021, -0.264803, 0.373362>, <0.671344, -0.346236, 0.293708>, 
      <0.768912, 0.000628, 0.413819>, <0.770394, -0.115917, 0.413104>, <0.755887, -0.277355, 0.351921>, <0.735096, -0.360091, 0.272499>, 
      <0.828468, -0.000158, 0.390495>, <0.829950, -0.116703, 0.389780>, <0.802330, -0.277616, 0.332049>, <0.781539, -0.360352, 0.252627>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.377140, -0.492845, -0.018535>, <0.435487, -0.493367, -0.022065>, <0.513017, -0.498984, -0.031968>, <0.570143, -0.500167, -0.044311>, 
      <0.377958, -0.484296, 0.096702>, <0.436305, -0.484818, 0.093171>, <0.532928, -0.490472, 0.081407>, <0.590054, -0.491655, 0.069064>, 
      <0.365558, -0.433279, 0.257831>, <0.443208, -0.431298, 0.251381>, <0.536853, -0.425889, 0.239466>, <0.613136, -0.427480, 0.223548>, 
      <0.364626, -0.351658, 0.339626>, <0.442276, -0.349678, 0.333177>, <0.545620, -0.343614, 0.319944>, <0.621903, -0.345205, 0.304026>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.356641, -0.435090, -0.785094>, <0.378526, -0.434962, -0.787061>, <0.406802, -0.429940, -0.794577>, <0.427993, -0.428103, -0.800089>, 
      <0.363260, -0.560506, -0.591574>, <0.385145, -0.560378, -0.593540>, <0.443729, -0.557039, -0.604376>, <0.464920, -0.555202, -0.609888>, 
      <0.375507, -0.509911, -0.248599>, <0.433854, -0.510433, -0.252129>, <0.473044, -0.516073, -0.259573>, <0.530170, -0.517257, -0.271916>, 
      <0.377140, -0.492845, -0.018535>, <0.435487, -0.493367, -0.022065>, <0.513017, -0.498984, -0.031968>, <0.570143, -0.500167, -0.044311>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.349038, 0.039612, -0.840128>, <0.368531, 0.039560, -0.842485>, <0.394697, 0.037492, -0.845163>, <0.413735, 0.038169, -0.849922>, 
      <0.351668, -0.103617, -0.834037>, <0.371161, -0.103669, -0.836394>, <0.397746, -0.103140, -0.840476>, <0.416784, -0.102463, -0.845235>, 
      <0.352527, -0.357143, -0.905368>, <0.374412, -0.357014, -0.907335>, <0.384373, -0.352742, -0.910103>, <0.405564, -0.350905, -0.915614>, 
      <0.356641, -0.435090, -0.785094>, <0.378526, -0.434962, -0.787061>, <0.406802, -0.429940, -0.794577>, <0.427993, -0.428103, -0.800089>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.338830, 0.534751, -0.826337>, <0.359873, 0.535597, -0.827585>, <0.386529, 0.550598, -0.826852>, <0.406750, 0.551815, -0.832745>, 
      <0.337686, 0.461427, -0.955618>, <0.358729, 0.462273, -0.956865>, <0.363401, 0.474767, -0.959104>, <0.383622, 0.475984, -0.964997>, 
      <0.346311, 0.188084, -0.846441>, <0.365804, 0.188032, -0.848799>, <0.391357, 0.191565, -0.850298>, <0.410395, 0.192241, -0.855056>, 
      <0.349038, 0.039612, -0.840128>, <0.368531, 0.039560, -0.842485>, <0.394697, 0.037492, -0.845163>, <0.413735, 0.038169, -0.849922>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.356281, 0.503993, -0.021364>, <0.416064, 0.503801, -0.025289>, <0.495717, 0.500783, -0.033367>, <0.554651, 0.500197, -0.044133>, 
      <0.353037, 0.540174, -0.260344>, <0.412821, 0.539982, -0.264269>, <0.454735, 0.540546, -0.267717>, <0.513670, 0.539960, -0.278483>, 
      <0.340690, 0.654002, -0.616083>, <0.361733, 0.654848, -0.617331>, <0.422709, 0.669221, -0.619970>, <0.442929, 0.670438, -0.625863>, 
      <0.338830, 0.534751, -0.826337>, <0.359873, 0.535597, -0.827585>, <0.386529, 0.550598, -0.826852>, <0.406750, 0.551815, -0.832745>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.354594, 0.358891, 0.335262>, <0.430161, 0.359891, 0.328796>, <0.530817, 0.360152, 0.316981>, <0.605364, 0.359106, 0.303020>, 
      <0.352107, 0.441220, 0.254285>, <0.427674, 0.442220, 0.247818>, <0.519609, 0.439898, 0.237078>, <0.594156, 0.438852, 0.223117>, 
      <0.357830, 0.486705, 0.092830>, <0.417614, 0.486513, 0.088905>, <0.514991, 0.482082, 0.076852>, <0.573925, 0.481496, 0.066086>, 
      <0.356281, 0.503993, -0.021364>, <0.416064, 0.503801, -0.025289>, <0.495717, 0.500783, -0.033367>, <0.554651, 0.500197, -0.044133>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.371519, -0.000510, 0.474855>, <0.447471, -0.001191, 0.469599>, <0.549217, 0.006067, 0.464739>, <0.624088, 0.006124, 0.450917>, 
      <0.369885, 0.115255, 0.474144>, <0.445836, 0.114574, 0.468888>, <0.546518, 0.120986, 0.464575>, <0.621389, 0.121044, 0.450753>, 
      <0.357086, 0.276367, 0.416430>, <0.432654, 0.277367, 0.409964>, <0.542173, 0.279347, 0.397946>, <0.616720, 0.278301, 0.383985>, 
      <0.354594, 0.358891, 0.335262>, <0.430161, 0.359891, 0.328796>, <0.530817, 0.360152, 0.316981>, <0.605364, 0.359106, 0.303020>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.371519, -0.000510, 0.474855>, <0.373113, -0.113402, 0.475548>, <0.363715, -0.271911, 0.419545>, <0.364626, -0.351658, 0.339626>, 
      <0.447471, -0.001191, 0.469599>, <0.449064, -0.114083, 0.470292>, <0.441365, -0.269930, 0.413095>, <0.442276, -0.349678, 0.333177>, 
      <0.549217, 0.006067, 0.464739>, <0.551899, -0.108144, 0.464902>, <0.554296, -0.262181, 0.399597>, <0.545620, -0.343614, 0.319944>, 
      <0.624088, 0.006124, 0.450917>, <0.626770, -0.108086, 0.451080>, <0.630579, -0.263772, 0.383679>, <0.621903, -0.345205, 0.304026>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.242843, -0.497239, -0.024507>, <0.283162, -0.496512, -0.025923>, <0.336865, -0.492484, -0.016098>, <0.377140, -0.492845, -0.018535>, 
      <0.244274, -0.489529, 0.091532>, <0.284593, -0.488802, 0.090116>, <0.337683, -0.483936, 0.099139>, <0.377958, -0.484296, 0.096702>, 
      <0.237642, -0.437631, 0.254211>, <0.276190, -0.438138, 0.251437>, <0.327052, -0.434261, 0.261029>, <0.365558, -0.433279, 0.257831>, 
      <0.235882, -0.355050, 0.336088>, <0.274430, -0.355557, 0.333313>, <0.326120, -0.352641, 0.342824>, <0.364626, -0.351658, 0.339626>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.222103, -0.429310, -0.781590>, <0.262399, -0.430350, -0.784468>, <0.316391, -0.435326, -0.781478>, <0.356641, -0.435090, -0.785094>, 
      <0.227157, -0.556006, -0.591953>, <0.267453, -0.557046, -0.594831>, <0.323010, -0.560742, -0.587958>, <0.363260, -0.560506, -0.591574>, 
      <0.240037, -0.512361, -0.252110>, <0.280356, -0.511634, -0.253526>, <0.335232, -0.509550, -0.246162>, <0.375507, -0.509911, -0.248599>, 
      <0.242843, -0.497239, -0.024507>, <0.283162, -0.496512, -0.025923>, <0.336865, -0.492484, -0.016098>, <0.377140, -0.492845, -0.018535>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.221467, 0.038683, -0.826669>, <0.259677, 0.038359, -0.831242>, <0.310831, 0.039714, -0.835507>, <0.349038, 0.039612, -0.840128>, 
      <0.223114, -0.102239, -0.820944>, <0.261325, -0.102563, -0.825518>, <0.313462, -0.103515, -0.829416>, <0.351668, -0.103617, -0.834037>, 
      <0.218978, -0.350974, -0.898843>, <0.259274, -0.352014, -0.901721>, <0.312277, -0.357378, -0.901752>, <0.352527, -0.357143, -0.905368>, 
      <0.222103, -0.429310, -0.781590>, <0.262399, -0.430350, -0.784468>, <0.316391, -0.435326, -0.781478>, <0.356641, -0.435090, -0.785094>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.210724, 0.543936, -0.821125>, <0.248944, 0.542439, -0.826026>, <0.300366, 0.533206, -0.824057>, <0.338830, 0.534751, -0.826337>, 
      <0.209832, 0.468331, -0.952546>, <0.248052, 0.466834, -0.957447>, <0.299223, 0.459881, -0.953338>, <0.337686, 0.461427, -0.955618>, 
      <0.219696, 0.190167, -0.832822>, <0.257906, 0.189843, -0.837395>, <0.308105, 0.188186, -0.841821>, <0.346311, 0.188084, -0.846441>, 
      <0.221467, 0.038683, -0.826669>, <0.259677, 0.038359, -0.831242>, <0.310831, 0.039714, -0.835507>, <0.349038, 0.039612, -0.840128>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.226923, 0.501248, -0.022615>, <0.265612, 0.501770, -0.025730>, <0.317546, 0.504118, -0.018821>, <0.356281, 0.503993, -0.021364>, 
      <0.223640, 0.540110, -0.259369>, <0.262329, 0.540632, -0.262484>, <0.314303, 0.540298, -0.257801>, <0.353037, 0.540174, -0.260344>, 
      <0.212135, 0.663585, -0.613146>, <0.250356, 0.662088, -0.618047>, <0.302226, 0.652456, -0.613803>, <0.340690, 0.654002, -0.616083>, 
      <0.210724, 0.543936, -0.821125>, <0.248944, 0.542439, -0.826026>, <0.300366, 0.533206, -0.824057>, <0.338830, 0.534751, -0.826337>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.226762, 0.354096, 0.335416>, <0.265043, 0.355108, 0.332903>, <0.316360, 0.358385, 0.338533>, <0.354594, 0.358891, 0.335262>, 
      <0.225915, 0.435456, 0.252558>, <0.264196, 0.436468, 0.250045>, <0.313874, 0.440714, 0.257556>, <0.352107, 0.441220, 0.254285>, 
      <0.228512, 0.482440, 0.091968>, <0.267201, 0.482962, 0.088853>, <0.319096, 0.486829, 0.095373>, <0.357830, 0.486705, 0.092830>, 
      <0.226923, 0.501248, -0.022615>, <0.265612, 0.501770, -0.025730>, <0.317546, 0.504118, -0.018821>, <0.356281, 0.503993, -0.021364>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.232043, 0.009641, 0.478049>, <0.273763, 0.008819, 0.473603>, <0.329657, -0.000134, 0.477752>, <0.371519, -0.000510, 0.474855>, 
      <0.230605, 0.121488, 0.477943>, <0.272325, 0.120667, 0.473497>, <0.328022, 0.115631, 0.477041>, <0.369885, 0.115255, 0.474144>, 
      <0.227579, 0.275729, 0.415227>, <0.265859, 0.276741, 0.412715>, <0.318853, 0.275861, 0.419702>, <0.357086, 0.276367, 0.416430>, 
      <0.226762, 0.354096, 0.335416>, <0.265043, 0.355108, 0.332903>, <0.316360, 0.358385, 0.338533>, <0.354594, 0.358891, 0.335262>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.232043, 0.009641, 0.478049>, <0.233553, -0.107759, 0.478160>, <0.234106, -0.271683, 0.418743>, <0.235882, -0.355050, 0.336088>, 
      <0.273763, 0.008819, 0.473603>, <0.275273, -0.108581, 0.473714>, <0.272654, -0.272191, 0.415968>, <0.274430, -0.355557, 0.333313>, 
      <0.329657, -0.000134, 0.477752>, <0.331250, -0.113026, 0.478446>, <0.325209, -0.272892, 0.422743>, <0.326120, -0.352641, 0.342824>, 
      <0.371519, -0.000510, 0.474855>, <0.373113, -0.113402, 0.475548>, <0.363715, -0.271911, 0.419545>, <0.364626, -0.351658, 0.339626>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.106574, -0.497723, -0.009028>, <0.147539, -0.497244, -0.012827>, <0.201731, -0.497980, -0.023062>, <0.242843, -0.497239, -0.024507>, 
      <0.108169, -0.489281, 0.109770>, <0.149135, -0.488802, 0.105971>, <0.203162, -0.490270, 0.092977>, <0.244274, -0.489529, 0.091532>, 
      <0.100303, -0.431559, 0.273646>, <0.141706, -0.432326, 0.271639>, <0.196294, -0.437086, 0.257187>, <0.237642, -0.437631, 0.254211>, 
      <0.099722, -0.348171, 0.358692>, <0.141125, -0.348937, 0.356685>, <0.194534, -0.354505, 0.339064>, <0.235882, -0.355050, 0.336088>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.084621, -0.428072, -0.765668>, <0.126075, -0.428114, -0.768046>, <0.180700, -0.428242, -0.778633>, <0.222103, -0.429310, -0.781590>, 
      <0.091182, -0.555680, -0.576781>, <0.132636, -0.555723, -0.579159>, <0.185754, -0.554938, -0.588996>, <0.227157, -0.556006, -0.591953>, 
      <0.103519, -0.513887, -0.236481>, <0.144484, -0.513408, -0.240280>, <0.198925, -0.513103, -0.250665>, <0.240037, -0.512361, -0.252110>, 
      <0.106574, -0.497723, -0.009028>, <0.147539, -0.497244, -0.012827>, <0.201731, -0.497980, -0.023062>, <0.242843, -0.497239, -0.024507>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.078830, 0.041902, -0.807786>, <0.121955, 0.042285, -0.809817>, <0.178599, 0.039046, -0.821538>, <0.221467, 0.038683, -0.826669>, 
      <0.079632, -0.099607, -0.803806>, <0.122758, -0.099224, -0.805837>, <0.180247, -0.101876, -0.815813>, <0.223114, -0.102239, -0.820944>, 
      <0.080549, -0.348854, -0.882926>, <0.122002, -0.348897, -0.885305>, <0.177576, -0.349906, -0.895886>, <0.218978, -0.350974, -0.898843>, 
      <0.084621, -0.428072, -0.765668>, <0.126075, -0.428114, -0.768046>, <0.180700, -0.428242, -0.778633>, <0.222103, -0.429310, -0.781590>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.079104, 0.544925, -0.793032>, <0.119365, 0.544808, -0.796078>, <0.170706, 0.545504, -0.815993>, <0.210724, 0.543936, -0.821125>, 
      <0.078683, 0.470469, -0.924366>, <0.118944, 0.470352, -0.927412>, <0.169814, 0.469898, -0.947414>, <0.209832, 0.468331, -0.952546>, 
      <0.077974, 0.192812, -0.812030>, <0.121100, 0.193195, -0.814061>, <0.176828, 0.190530, -0.827691>, <0.219696, 0.190167, -0.832822>, 
      <0.078830, 0.041902, -0.807786>, <0.121955, 0.042285, -0.809817>, <0.178599, 0.039046, -0.821538>, <0.221467, 0.038683, -0.826669>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.081419, 0.500285, 0.000766>, <0.125471, 0.499737, -0.002949>, <0.182858, 0.500654, -0.019067>, <0.226923, 0.501248, -0.022615>, 
      <0.080217, 0.539928, -0.234430>, <0.124270, 0.539380, -0.238145>, <0.179575, 0.539516, -0.255821>, <0.223640, 0.540110, -0.259369>, 
      <0.079768, 0.662555, -0.585541>, <0.120030, 0.662438, -0.588587>, <0.172117, 0.665152, -0.608014>, <0.212135, 0.663585, -0.613146>, 
      <0.079104, 0.544925, -0.793032>, <0.119365, 0.544808, -0.796078>, <0.170706, 0.545504, -0.815993>, <0.210724, 0.543936, -0.821125>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.084960, 0.351764, 0.352961>, <0.127761, 0.351341, 0.350560>, <0.183999, 0.352966, 0.338223>, <0.226762, 0.354096, 0.335416>, 
      <0.081444, 0.432226, 0.271331>, <0.124246, 0.431804, 0.268930>, <0.183151, 0.434326, 0.255365>, <0.225915, 0.435456, 0.252558>, 
      <0.081997, 0.481225, 0.113843>, <0.126049, 0.480677, 0.110129>, <0.184447, 0.481846, 0.095516>, <0.228512, 0.482440, 0.091968>, 
      <0.081419, 0.500285, 0.000766>, <0.125471, 0.499737, -0.002949>, <0.182858, 0.500654, -0.019067>, <0.226923, 0.501248, -0.022615>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.103069, 0.004778, 0.503462>, <0.142450, 0.005923, 0.501192>, <0.192810, 0.010413, 0.482230>, <0.232043, 0.009641, 0.478049>, 
      <0.100674, 0.118344, 0.502532>, <0.140055, 0.119490, 0.500262>, <0.191371, 0.122261, 0.482124>, <0.230605, 0.121488, 0.477943>, 
      <0.088442, 0.272057, 0.433824>, <0.131244, 0.271635, 0.431423>, <0.184815, 0.274599, 0.418034>, <0.227579, 0.275729, 0.415227>, 
      <0.084960, 0.351764, 0.352961>, <0.127761, 0.351341, 0.350560>, <0.183999, 0.352966, 0.338223>, <0.226762, 0.354096, 0.335416>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.103069, 0.004778, 0.503462>, <0.105483, -0.109643, 0.504399>, <0.099163, -0.268044, 0.440412>, <0.099722, -0.348171, 0.358692>, 
      <0.142450, 0.005923, 0.501192>, <0.144864, -0.108498, 0.502129>, <0.140566, -0.268810, 0.438404>, <0.141125, -0.348937, 0.356685>, 
      <0.192810, 0.010413, 0.482230>, <0.194319, -0.106986, 0.482341>, <0.192758, -0.271139, 0.421719>, <0.194534, -0.354505, 0.339064>, 
      <0.232043, 0.009641, 0.478049>, <0.233553, -0.107759, 0.478160>, <0.234106, -0.271683, 0.418743>, <0.235882, -0.355050, 0.336088>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.077453, -0.500984, 0.005200>, <-0.076032, -0.492891, 0.118299>, <-0.080662, -0.430324, 0.272141>, <-0.079376, -0.349212, 0.351375>, 
      <-0.109645, -0.500328, 0.006673>, <-0.108224, -0.492235, 0.119771>, <-0.111331, -0.431252, 0.270863>, <-0.110045, -0.350140, 0.350096>, 
      <-0.152463, -0.492879, 0.007687>, <-0.151999, -0.484763, 0.117900>, <-0.153353, -0.433263, 0.269241>, <-0.150705, -0.356260, 0.348465>, 
      <-0.184498, -0.491793, 0.004288>, <-0.184033, -0.483677, 0.114501>, <-0.184024, -0.433677, 0.267749>, <-0.181376, -0.356674, 0.346973>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.077453, -0.500984, 0.005200>, <-0.022141, -0.502111, 0.002670>, <0.051433, -0.498368, -0.003913>, <0.106574, -0.497723, -0.009028>, 
      <-0.076032, -0.492891, 0.118299>, <-0.020720, -0.494018, 0.115768>, <0.053028, -0.489925, 0.114885>, <0.108169, -0.489281, 0.109770>, 
      <-0.080662, -0.430324, 0.272141>, <-0.026958, -0.428700, 0.274380>, <0.046601, -0.430565, 0.276250>, <0.100303, -0.431559, 0.273646>, 
      <-0.079376, -0.349212, 0.351375>, <-0.025672, -0.347587, 0.353614>, <0.046019, -0.347176, 0.361296>, <0.099722, -0.348171, 0.358692>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.093382, -0.428985, -0.763488>, <-0.091111, -0.556174, -0.569874>, <-0.080355, -0.517517, -0.225856>, <-0.077453, -0.500984, 0.005200>, 
      <-0.121337, -0.430082, -0.763615>, <-0.119066, -0.557271, -0.570001>, <-0.112548, -0.516861, -0.224383>, <-0.109645, -0.500328, 0.006673>, 
      <-0.158248, -0.438184, -0.763983>, <-0.159822, -0.564848, -0.569733>, <-0.153437, -0.509909, -0.223588>, <-0.152463, -0.492879, 0.007687>, 
      <-0.186068, -0.438694, -0.766895>, <-0.187642, -0.565359, -0.572646>, <-0.185472, -0.508823, -0.226987>, <-0.184498, -0.491793, 0.004288>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.093382, -0.428985, -0.763488>, <-0.040018, -0.426891, -0.763246>, <0.031303, -0.428017, -0.762609>, <0.084621, -0.428072, -0.765668>, 
      <-0.091111, -0.556174, -0.569874>, <-0.037747, -0.554080, -0.569632>, <0.037864, -0.555625, -0.573721>, <0.091182, -0.555680, -0.576781>, 
      <-0.080355, -0.517517, -0.225856>, <-0.025044, -0.518644, -0.228386>, <0.048378, -0.514531, -0.231366>, <0.103519, -0.513887, -0.236481>, 
      <-0.077453, -0.500984, 0.005200>, <-0.022141, -0.502111, 0.002670>, <0.051433, -0.498368, -0.003913>, <0.106574, -0.497723, -0.009028>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.087038, 0.035944, -0.812140>, <-0.089887, -0.104184, -0.806941>, <-0.094757, -0.351983, -0.880705>, <-0.093382, -0.428985, -0.763488>, 
      <-0.114343, 0.035940, -0.812813>, <-0.117191, -0.104188, -0.807615>, <-0.122711, -0.353080, -0.880832>, <-0.121337, -0.430082, -0.763615>, 
      <-0.150661, 0.041483, -0.811732>, <-0.154428, -0.103258, -0.806554>, <-0.157265, -0.359050, -0.885341>, <-0.158248, -0.438184, -0.763983>, 
      <-0.177867, 0.041863, -0.814116>, <-0.181634, -0.102878, -0.808938>, <-0.185085, -0.359561, -0.888254>, <-0.186068, -0.438694, -0.766895>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.087038, 0.035944, -0.812140>, <-0.037244, 0.035951, -0.810912>, <0.029077, 0.041461, -0.805443>, <0.078830, 0.041902, -0.807786>, 
      <-0.089887, -0.104184, -0.806941>, <-0.040092, -0.104177, -0.805713>, <0.029880, -0.100049, -0.801464>, <0.079632, -0.099607, -0.803806>, 
      <-0.094757, -0.351983, -0.880705>, <-0.041392, -0.349889, -0.880463>, <0.027231, -0.348799, -0.879867>, <0.080549, -0.348854, -0.882926>, 
      <-0.093382, -0.428985, -0.763488>, <-0.040018, -0.426891, -0.763246>, <0.031303, -0.428017, -0.762609>, <0.084621, -0.428072, -0.765668>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.073590, 0.544760, -0.799615>, <-0.078620, 0.468526, -0.931879>, <-0.083936, 0.188552, -0.817802>, <-0.087038, 0.035944, -0.812140>, 
      <-0.099724, 0.544191, -0.800582>, <-0.104754, 0.467956, -0.932846>, <-0.111241, 0.188548, -0.818476>, <-0.114343, 0.035940, -0.812813>, 
      <-0.134534, 0.539172, -0.799845>, <-0.138225, 0.466108, -0.930206>, <-0.146775, 0.190822, -0.817074>, <-0.150661, 0.041483, -0.811732>, 
      <-0.160606, 0.539698, -0.801898>, <-0.164297, 0.466634, -0.932259>, <-0.173981, 0.191203, -0.819459>, <-0.177867, 0.041863, -0.814116>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.073590, 0.544760, -0.799615>, <-0.027781, 0.545759, -0.797921>, <0.033384, 0.545057, -0.789573>, <0.079104, 0.544925, -0.793032>, 
      <-0.078620, 0.468526, -0.931879>, <-0.032812, 0.469524, -0.930185>, <0.032963, 0.470602, -0.920907>, <0.078683, 0.470469, -0.924366>, 
      <-0.083936, 0.188552, -0.817802>, <-0.034142, 0.188559, -0.816574>, <0.028221, 0.192370, -0.809687>, <0.077974, 0.192812, -0.812030>, 
      <-0.087038, 0.035944, -0.812140>, <-0.037244, 0.035951, -0.810912>, <0.029077, 0.041461, -0.805443>, <0.078830, 0.041902, -0.807786>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.056105, 0.504768, 0.001251>, <-0.056836, 0.543480, -0.236230>, <-0.065666, 0.664852, -0.591261>, <-0.073590, 0.544760, -0.799615>, 
      <-0.085747, 0.504644, 0.001412>, <-0.086478, 0.543356, -0.236069>, <-0.091800, 0.664282, -0.592228>, <-0.099724, 0.544191, -0.800582>, 
      <-0.125259, 0.499516, 0.004937>, <-0.124695, 0.537534, -0.233545>, <-0.128571, 0.657207, -0.589247>, <-0.134534, 0.539172, -0.799845>, 
      <-0.154759, 0.499301, 0.002046>, <-0.154196, 0.537319, -0.236436>, <-0.154643, 0.657733, -0.591300>, <-0.160606, 0.539698, -0.801898>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.056105, 0.504768, 0.001251>, <-0.014826, 0.504940, 0.001027>, <0.040289, 0.500796, 0.004234>, <0.081419, 0.500285, 0.000766>, 
      <-0.056836, 0.543480, -0.236230>, <-0.015557, 0.543652, -0.236453>, <0.039087, 0.540439, -0.230962>, <0.080217, 0.539928, -0.234430>, 
      <-0.065666, 0.664852, -0.591261>, <-0.019858, 0.665851, -0.589567>, <0.034048, 0.662688, -0.582082>, <0.079768, 0.662555, -0.585541>, 
      <-0.073590, 0.544760, -0.799615>, <-0.027781, 0.545759, -0.797921>, <0.033384, 0.545057, -0.789573>, <0.079104, 0.544925, -0.793032>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.070044, 0.357024, 0.352064>, <-0.067876, 0.438595, 0.272066>, <-0.055757, 0.486383, 0.114035>, <-0.056105, 0.504768, 0.001251>, 
      <-0.098051, 0.357557, 0.351431>, <-0.095883, 0.439128, 0.271433>, <-0.085399, 0.486259, 0.114196>, <-0.085747, 0.504644, 0.001412>, 
      <-0.135379, 0.356802, 0.349406>, <-0.133323, 0.436447, 0.270503>, <-0.125520, 0.481863, 0.115668>, <-0.125259, 0.499516, 0.004937>, 
      <-0.163320, 0.356487, 0.347347>, <-0.161265, 0.436132, 0.268445>, <-0.155021, 0.481648, 0.112777>, <-0.154759, 0.499301, 0.002046>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.070044, 0.357024, 0.352064>, <-0.023536, 0.356139, 0.353116>, <0.038506, 0.352222, 0.355567>, <0.084960, 0.351764, 0.352961>, 
      <-0.067876, 0.438595, 0.272066>, <-0.021368, 0.437711, 0.273118>, <0.034991, 0.432685, 0.273936>, <0.081444, 0.432226, 0.271331>, 
      <-0.055757, 0.486383, 0.114035>, <-0.014479, 0.486555, 0.113811>, <0.040867, 0.481736, 0.117312>, <0.081997, 0.481225, 0.113843>, 
      <-0.056105, 0.504768, 0.001251>, <-0.014826, 0.504940, 0.001027>, <0.040289, 0.500796, 0.004234>, <0.081419, 0.500285, 0.000766>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.069497, 0.000872, 0.495431>, <-0.067976, 0.116039, 0.495543>, <-0.072229, 0.274807, 0.432696>, <-0.070044, 0.357024, 0.352064>, 
      <-0.099150, -0.000387, 0.495418>, <-0.097629, 0.114780, 0.495531>, <-0.100236, 0.275340, 0.432063>, <-0.098051, 0.357557, 0.351431>, 
      <-0.138267, -0.006329, 0.506067>, <-0.135265, 0.112230, 0.506130>, <-0.137553, 0.272564, 0.432858>, <-0.135379, 0.356802, 0.349406>, 
      <-0.167819, -0.006723, 0.503350>, <-0.164817, 0.111835, 0.503412>, <-0.165494, 0.272249, 0.430799>, <-0.163320, 0.356487, 0.347347>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.069497, 0.000872, 0.495431>, <-0.017705, 0.003071, 0.495452>, <0.051338, 0.003273, 0.506444>, <0.103069, 0.004778, 0.503462>, 
      <-0.067976, 0.116039, 0.495543>, <-0.016183, 0.118238, 0.495565>, <0.048943, 0.116840, 0.505514>, <0.100674, 0.118344, 0.502532>, 
      <-0.072229, 0.274807, 0.432696>, <-0.025721, 0.273922, 0.433748>, <0.041989, 0.272515, 0.436429>, <0.088442, 0.272057, 0.433824>, 
      <-0.070044, 0.357024, 0.352064>, <-0.023536, 0.356139, 0.353116>, <0.038506, 0.352222, 0.355567>, <0.084960, 0.351764, 0.352961>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.069497, 0.000872, 0.495431>, <-0.099150, -0.000387, 0.495418>, <-0.138267, -0.006329, 0.506067>, <-0.167819, -0.006723, 0.503350>, 
      <-0.070998, -0.112726, 0.495320>, <-0.100651, -0.113985, 0.495308>, <-0.141179, -0.121354, 0.506007>, <-0.170731, -0.121749, 0.503290>, 
      <-0.078088, -0.267949, 0.430756>, <-0.108757, -0.268877, 0.429477>, <-0.147948, -0.276087, 0.430951>, <-0.178620, -0.276501, 0.429459>, 
      <-0.079376, -0.349212, 0.351375>, <-0.110045, -0.350140, 0.350096>, <-0.150705, -0.356260, 0.348465>, <-0.181376, -0.356674, 0.346973>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.069497, 0.000872, 0.495431>, <-0.070998, -0.112726, 0.495320>, <-0.078088, -0.267949, 0.430756>, <-0.079376, -0.349212, 0.351375>, 
      <-0.017705, 0.003071, 0.495452>, <-0.019206, -0.110527, 0.495341>, <-0.024384, -0.266324, 0.432995>, <-0.025672, -0.347587, 0.353614>, 
      <0.051338, 0.003273, 0.506444>, <0.053751, -0.111147, 0.507381>, <0.045460, -0.267049, 0.443016>, <0.046019, -0.347176, 0.361296>, 
      <0.103069, 0.004778, 0.503462>, <0.105483, -0.109643, 0.504399>, <0.099163, -0.268044, 0.440412>, <0.099722, -0.348171, 0.358692>
    }
  }
}
union { // Shoulder_and_Arms
  object { sPatchObj }
  object { sPatchObj1 }
  material {
    Wrinkled_Fabric_1
  }
  scale 10.0
  translate  -10.4*z
}


