/*  
Name: Mike Robertson
Email: mad_dawg00@hotmail.com
Topic: First Encounters
Title: One Small Step
Country: USA
Hardware: P200 with 64M Ram
Tools: Moray for Windows and POV-Ray 3.1a for Windows
*/


global_settings {
  adc_bailout 0.003922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 2.2
  hf_gray_16 off
  irid_wavelength <0.247059,0.176471,0.137255>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
  radiosity {
    brightness       3.3
    count            100
    distance_maximum 0.0
    error_bound      0.4
    gray_threshold   0.5
    low_error_factor 0.8
    minimum_reuse    0.015
    nearest_count    6
    recursion_limit  1
  }
}

background { color <0.000,0.000,0.000> }

camera {  //  Camera StdCam
  location  <-7.945, -21.183, 6.878>
  direction <0.0,     0.0,  1.7997>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333,  0.0,  0.0>
  look_at   <3.278, -3.450, -0.456>
}

// *******  L I G H T S *******
//

light_source {   // Light001
  <-51.376, -127.608, 111.895>
  color rgb <1.000, 1.000, 1.000>
  shadowless
}

light_source { // AreaLite001
  <-6.245, -23.048, 23.307>
  color  rgb<1.000, 1.000, 1.000>
  area_light <-0.054, 0.000, 0.000>, <-0.000, -0.033, -0.000>, 3, 3
  adaptive 4
  jitter
}

// ********  TEXTURES  *******

#include "astronut1.inc"

// ********  OBJECTS  *******

#declare HFsurfacerough = object { 
  height_field {
    tga "C:\Download\heightfields\surface.tga"
    water_level 0.0
  }
  rotate    <-90, 0, 0>
  scale     <  2, 2,-2>
  translate < -1,-1,-1> 
  texture {
    Mountains1
  }
  scale <29.868221, 49.113701, 1.0>
  rotate -0.501897*x
  translate  <22.757664, 8.066599, -0.560411>
}

#declare HFSurface = object { 
  height_field {
    tga "C:\Download\heightfields\surface.tga"
    water_level 0.0
  }
  rotate    <-90, 0, 0> 
  scale     <  2, 2,-2> 
  translate < -1,-1,-1> 
  texture {
    landareatex
  }
  scale <53.441647, 52.98534, 1.0>
  translate  <13.832689, 11.599397, -0.475608>
}                 

#declare surface =

union { // surface
  object { HFsurfacerough }
  object { HFSurface }
  disc { // surfdisc
    <0,0,0>, <0,0,1>, 1.0
    texture {
      landareatex
    }
    scale 37.989735
    translate  <4.650732, 10.123507, -0.519745>
  }
}

union { // brief
  cone { 
    <0,0,0>, 0.0, <0,0,1>, 1.0
    texture {
      glove_boot
    }
    scale <0.174452, 0.233125, 0.363634>
    rotate <166.575577, 79.872543, 177.221054>
    translate  <0.876155, -0.259007, -0.500042>
  }
  torus {
    1.5, 0.5  rotate -x*90
    texture {
      paneltex
    }
    scale -0.075158
    rotate <0.690231, -0.621678, 29.116846>
    translate  <0.875512, -0.246402, -0.625106>
  }
  box { 
    <-1, -1, -1>, <1, 1, 1>
    texture {
      paneltex
    }
    scale <0.057683, 0.483251, 0.38752>
    rotate <149.762512, 86.024239, 158.229355>
    translate  <1.258285, -0.193307, -0.692666>
  }
  box {
    <-1, -1, -1>, <1, 1, 1>
    texture {
      paneltex
    }
    scale <0.056569, 0.47913, 0.390739>
    rotate <-42.486332, 87.258644, 146.837708>
    translate  <1.25911, -0.201833, -0.547211>
  }
  rotate <-1.509834, -4.506162, -45.713699>
  translate  <3.311886, -4.066414, 0.299402>
}


text {   // MRobertson'98
  ttf    "C:\WINDOWS\Fonts\Technicn.ttf",
  "MRobertson'98",
  1.0, 
  <0.0,   0.0, 0.0>
  texture {
    Mountains1
  }
  scale 0.199001
  rotate <62.956009, 4.081382, -27.980013>
  translate  <-4.677723, -12.024911, 0.47489>
}

object {   // HgtFld002
  height_field {
    tga "C:\Download\images\foremon.tga"
    water_level 0.0
  }
  rotate    <-90, 0, 0> 
  scale     <  2, 2,-2> 
  translate < -1,-1,-1> 
  texture {
    landareatex
  }
  scale <2.919404, 6.408909, 0.8202>
  rotate <-0.148577, -3.285999, -149.632294>
  translate  <-0.259512, -13.864845, -0.508456>
}

object { // rock3
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.000000, -2.000000, 0.010828>, <-1.000000, -2.000000, -0.378981>, <0.433121, -2.010828, 1.245223>, <0.248983, -2.243918, 1.245223>, 
      <-3.053928, -0.884501, -0.378981>, <-1.151592, -1.000000, 3.031847>, <0.389809, -0.989172, 3.226752>, <1.991155, -0.580574, 0.974522>, 
      <-3.053928, 0.115499, 0.000000>, <-1.225768, 0.093991, 0.292357>, <0.389809, 0.000000, 1.819108>, <0.343513, -1.151165, 1.385987>, 
      <-2.000000, 1.000000, 0.000000>, <-1.000000, 1.000000, -0.422293>, <3.007697, 1.493450, 0.000000>, <1.771114, -1.066954, 0.000000>
    }
  }
  texture {
    landareatex
  }
  scale <2.015414, 2.633732, 2.123271>
  rotate 106.007851*z
  translate  <28.255174, 8.664885, -1.578157>
}

#declare flag = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.985563, -2.274310, 0.119108>, <-1.129936, -1.321444, 0.000000>, <-0.129936, -1.321444, 0.000000>, <0.913376, -1.740127, 0.205732>, 
      <-2.584347, -1.132493, 0.119108>, <-1.054140, -1.000000, 0.184076>, <-0.097452, -1.000000, 0.173248>, <0.408068, -0.711253, 0.000000>, 
      <-2.584347, -0.132493, 0.119108>, <-0.978344, 0.064968, 2.014013>, <-0.314013, -0.032484, -0.638854>, <0.408068, 0.288747, 0.000000>, 
      <-1.985563, 0.725690, 0.119108>, <-1.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <0.682378, 0.725690, 0.000000>
    }
  }
  texture {
    flagtex
  }
  scale 0.243071
  rotate -25.033321*z
  translate  <3.089764, -4.41147, -0.050733>
}
union { // flagpole
  cylinder { // pole
    <0,0,1>, <0,0,0>, 1 
    texture {
      Copper_Texture
    }
    scale <-0.058161, -0.039219, -2.296065>
    rotate <0.0, -88.681999, 65.298363>
    translate  <2.356938, -4.679718, 0.0>
  }
  object { flag }
  rotate <0.973995, -1.103193, -24.659889>
  translate  <1.559256, 1.211723, -0.308449>
}

union { // backhill
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-5.000000, -11.087635, 0.000000>, <-4.000000, -11.087635, 0.000000>, <-3.000000, -11.759052, 0.014287>, <-2.000000, -13.491683, 0.027350>, 
      <-5.000000, -10.087635, 0.000000>, <-4.000000, -10.087635, 0.000000>, <-2.797877, -12.274976, 0.014287>, <-1.898938, -13.249645, 0.027350>, 
      <-6.111677, -9.505308, 0.000000>, <-2.888323, -10.603559, 0.000000>, <-2.797877, -9.303185, 1.591720>, <-1.898938, -11.150055, 1.649824>, 
      <-6.111677, -8.505308, 0.000000>, <-3.444161, -8.801779, 0.000000>, <-2.797877, -8.303185, 1.591720>, <-1.898938, -9.416110, 2.416632>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-6.111677, -8.505308, 0.000000>, <-3.444161, -8.801779, 0.000000>, <-2.797877, -8.303185, 1.591720>, <-1.898938, -9.416110, 2.416632>, 
      <-6.111677, -7.505308, 0.000000>, <-4.000000, -7.000000, 0.000000>, <-2.797877, -7.303185, 1.591720>, <-1.898938, -7.682166, 3.183439>, 
      <-6.111677, -6.505308, 0.000000>, <-4.000000, -6.000000, 0.000000>, <-3.000000, -4.787261, 1.591720>, <-2.000000, -5.924204, 3.183439>, 
      <-5.555839, -5.252654, 0.000000>, <-4.000000, -5.000000, 0.000000>, <-1.938854, -3.357749, 4.358280>, <-1.469427, -4.444161, 3.372930>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-5.555839, -5.252654, 0.000000>, <-4.000000, -5.000000, 0.000000>, <-1.938854, -3.357749, 4.358280>, <-1.469427, -4.444161, 3.372930>, 
      <-5.000000, -4.000000, 0.000000>, <-4.000000, -4.000000, 0.000000>, <-0.877707, -1.928238, 7.124841>, <-0.938854, -2.964119, 3.562420>, 
      <-10.154140, -3.404246, 0.000000>, <-5.718047, -4.414862, 0.000000>, <0.132909, -0.776645, 9.474522>, <-0.433546, -1.888323, 4.737261>, 
      <-10.154140, -2.404246, 0.000000>, <-5.718047, -3.414862, 0.000000>, <0.132909, 0.223355, 9.474522>, <-0.433546, -0.907272, 4.737261>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-10.154140, -2.404246, 0.000000>, <-5.718047, -3.414862, 0.000000>, <0.132909, 0.223355, 9.474522>, <-0.433546, -0.907272, 4.737261>, 
      <-10.154140, -1.404246, 0.000000>, <-5.718047, -2.414862, 0.000000>, <0.132909, 1.223355, 9.474522>, <-0.433546, 0.073779, 4.737261>, 
      <-10.154140, -0.404246, 0.000000>, <-9.154140, -0.404246, 0.000000>, <-1.989384, 1.970701, 8.261783>, <-1.494692, 0.947452, 4.130892>, 
      <-7.577070, 0.797877, 0.000000>, <-6.577070, 0.759979, 0.000000>, <0.116667, 3.147558, 5.901274>, <-0.096072, 2.282219, 3.421656>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-7.577070, 0.797877, 0.000000>, <-6.577070, 0.759979, 0.000000>, <0.116667, 3.147558, 5.901274>, <-0.096072, 2.282219, 3.421656>, 
      <-5.000000, 2.000000, 0.000000>, <-4.000000, 1.924204, 0.000000>, <2.222718, 4.324416, 3.540764>, <1.302548, 3.616985, 2.712420>, 
      <-4.090446, 4.212739, 0.000000>, <-3.090446, 4.212739, 0.000000>, <2.222718, 5.324416, 3.540764>, <1.302548, 4.616985, 2.712420>, 
      <-4.090446, 5.212739, 0.000000>, <-3.090446, 5.212739, 0.000000>, <1.296921, 6.400212, 4.423248>, <0.839650, 5.844374, 3.911624>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-4.090446, 5.212739, 0.000000>, <-3.090446, 5.212739, 0.000000>, <1.296921, 6.400212, 4.423248>, <0.839650, 5.844374, 3.911624>, 
      <-4.090446, 6.212739, 0.000000>, <-3.090446, 6.212739, 0.000000>, <0.371125, 7.476008, 5.305732>, <0.376752, 7.071762, 5.110828>, 
      <-3.079830, 6.303185, 0.000000>, <-4.000000, 6.000000, 0.000000>, <-3.000000, 7.970701, 4.623567>, <-1.308811, 7.819108, 4.769745>, 
      <-4.039915, 7.151592, 0.000000>, <-4.000000, 7.000000, 0.000000>, <-2.366561, 8.970701, 4.834713>, <-0.992091, 8.819108, 4.875318>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-4.039915, 7.151592, 0.000000>, <-4.000000, 7.000000, 0.000000>, <-2.366561, 8.970701, 4.834713>, <-0.992091, 8.819108, 4.875318>, 
      <-5.000000, 8.000000, 0.000000>, <-4.000000, 8.000000, 0.000000>, <-1.733121, 9.970701, 5.045860>, <-0.675372, 9.819108, 4.980892>, 
      <-5.000000, 9.000000, 0.000000>, <-4.000000, 9.000000, 0.000000>, <-3.000000, 10.819108, 3.714013>, <-1.308811, 10.743312, 4.314968>, 
      <-5.000000, 10.000000, 0.000000>, <-4.000000, 10.000000, 0.000000>, <-0.877707, 10.783227, 8.034395>, <-0.247665, 10.846391, 4.959236>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.000000, -13.491683, 0.027350>, <-1.000000, -15.224313, 0.040412>, <0.000000, -15.224313, 0.040412>, <1.000000, -13.112157, 0.020206>, 
      <-1.898938, -13.249645, 0.027350>, <-1.000000, -14.224313, 0.040412>, <0.000000, -14.224313, 0.040412>, <1.000000, -12.112157, 0.020206>, 
      <-1.898938, -11.150055, 1.649824>, <-1.000000, -12.996925, 1.707928>, <0.000000, -13.224313, 0.040412>, <1.000000, -11.112157, 0.020206>, 
      <-1.898938, -9.416110, 2.416632>, <-1.000000, -10.529036, 3.241544>, <0.000000, -10.756424, 1.574028>, <1.000000, -9.378212, 0.787014>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.898938, -9.416110, 2.416632>, <-1.000000, -10.529036, 3.241544>, <0.000000, -10.756424, 1.574028>, <1.000000, -9.378212, 0.787014>, 
      <-1.898938, -7.682166, 3.183439>, <-1.000000, -8.061146, 4.775159>, <0.000000, -8.288535, 3.107643>, <1.000000, -7.644268, 1.553822>, 
      <-2.000000, -5.924204, 3.183439>, <-1.000000, -7.061146, 4.775159>, <0.000000, -7.288535, 3.107643>, <1.000000, -6.644268, 1.553822>, 
      <-1.469427, -4.444161, 3.372930>, <-1.000000, -5.530573, 2.387580>, <0.000000, -5.644268, 1.553822>, <1.000000, -5.322134, 0.776911>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.469427, -4.444161, 3.372930>, <-1.000000, -5.530573, 2.387580>, <0.000000, -5.644268, 1.553822>, <1.000000, -5.322134, 0.776911>, 
      <-0.938854, -2.964119, 3.562420>, <-1.000000, -4.000000, 0.000000>, <0.000000, -4.000000, 0.000000>, <1.000000, -4.000000, 0.000000>, 
      <-0.433546, -1.888323, 4.737261>, <-1.000000, -3.000000, 0.000000>, <0.000000, -3.000000, 0.000000>, <1.000000, -3.000000, 0.000000>, 
      <-0.433546, -0.907272, 4.737261>, <-1.000000, -2.037898, 0.000000>, <0.000000, -2.000000, 0.000000>, <1.000000, -2.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.433546, -0.907272, 4.737261>, <-1.000000, -2.037898, 0.000000>, <0.000000, -2.000000, 0.000000>, <1.000000, -2.000000, 0.000000>, 
      <-0.433546, 0.073779, 4.737261>, <-1.000000, -1.075796, 0.000000>, <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, 
      <-1.494692, 0.947452, 4.130892>, <-1.000000, -0.075796, 0.000000>, <0.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, 
      <-0.096072, 2.282219, 3.421656>, <-0.308811, 1.416879, 0.942038>, <0.691189, 1.454777, 0.942038>, <1.345594, 1.227389, 0.471019>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.096072, 2.282219, 3.421656>, <-0.308811, 1.416879, 0.942038>, <0.691189, 1.454777, 0.942038>, <1.345594, 1.227389, 0.471019>, 
      <1.302548, 3.616985, 2.712420>, <0.382378, 2.909554, 1.884076>, <1.382378, 2.909554, 1.884076>, <1.691189, 2.454777, 0.942038>, 
      <1.302548, 4.616985, 2.712420>, <0.382378, 3.909554, 1.884076>, <1.382378, 3.909554, 1.884076>, <1.691189, 3.454777, 0.942038>, 
      <0.839650, 5.844374, 3.911624>, <0.382378, 5.288535, 3.400000>, <1.382378, 5.288535, 3.400000>, <1.691189, 4.644268, 1.700000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.839650, 5.844374, 3.911624>, <0.382378, 5.288535, 3.400000>, <1.382378, 5.288535, 3.400000>, <1.691189, 4.644268, 1.700000>, 
      <0.376752, 7.071762, 5.110828>, <0.382378, 6.667516, 4.915924>, <1.382378, 6.667516, 4.915924>, <1.691189, 5.833758, 2.457962>, 
      <-1.308811, 7.819108, 4.769745>, <0.382378, 7.667516, 4.915924>, <1.382378, 7.667516, 4.915924>, <1.691189, 6.833758, 2.457962>, 
      <-0.992091, 8.819108, 4.875318>, <0.382378, 8.667516, 4.915924>, <1.382378, 8.667516, 4.915924>, <1.691189, 7.833758, 2.457962>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.992091, 8.819108, 4.875318>, <0.382378, 8.667516, 4.915924>, <1.382378, 8.667516, 4.915924>, <1.691189, 7.833758, 2.457962>, 
      <-0.675372, 9.819108, 4.980892>, <0.382378, 9.667516, 4.915924>, <1.382378, 9.667516, 4.915924>, <1.691189, 8.833758, 2.457962>, 
      <-1.308811, 10.743312, 4.314968>, <0.382378, 10.667516, 4.915924>, <1.382378, 10.667516, 4.915924>, <1.691189, 9.833758, 2.457962>, 
      <-0.247665, 10.846391, 4.959236>, <0.382378, 10.909554, 1.884076>, <1.382378, 10.909554, 1.884076>, <1.691189, 10.454777, 0.942038>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.000000, -13.112157, 0.020206>, <2.000000, -11.000000, 0.000000>, <3.000000, -11.000000, 0.000000>, <4.000000, -11.000000, 0.000000>, 
      <1.000000, -12.112157, 0.020206>, <2.000000, -10.000000, 0.000000>, <3.000000, -10.000000, 0.000000>, <4.000000, -10.000000, 0.000000>, 
      <1.000000, -11.112157, 0.020206>, <2.000000, -9.000000, 0.000000>, <3.000000, -9.000000, 0.000000>, <4.000000, -9.000000, 0.000000>, 
      <1.000000, -9.378212, 0.787014>, <2.000000, -8.000000, 0.000000>, <3.000000, -8.000000, 0.000000>, <4.000000, -8.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.000000, -9.378212, 0.787014>, <2.000000, -8.000000, 0.000000>, <3.000000, -8.000000, 0.000000>, <4.000000, -8.000000, 0.000000>, 
      <1.000000, -7.644268, 1.553822>, <2.000000, -7.000000, 0.000000>, <3.000000, -7.000000, 0.000000>, <4.000000, -7.000000, 0.000000>, 
      <1.000000, -6.644268, 1.553822>, <2.000000, -6.000000, 0.000000>, <3.000000, -6.000000, 0.000000>, <4.000000, -6.000000, 0.000000>, 
      <1.000000, -5.322134, 0.776911>, <2.000000, -5.000000, 0.000000>, <3.000000, -5.000000, 0.000000>, <4.000000, -5.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.000000, -5.322134, 0.776911>, <2.000000, -5.000000, 0.000000>, <3.000000, -5.000000, 0.000000>, <4.000000, -5.000000, 0.000000>, 
      <1.000000, -4.000000, 0.000000>, <2.000000, -4.000000, 0.000000>, <3.000000, -4.000000, 0.000000>, <4.000000, -4.000000, 0.000000>, 
      <1.000000, -3.000000, 0.000000>, <2.000000, -3.000000, 0.000000>, <3.000000, -3.000000, 0.000000>, <4.000000, -3.000000, 0.000000>, 
      <1.000000, -2.000000, 0.000000>, <2.000000, -2.000000, 0.000000>, <3.000000, -2.000000, 0.000000>, <4.000000, -2.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.000000, -2.000000, 0.000000>, <2.000000, -2.000000, 0.000000>, <3.000000, -2.000000, 0.000000>, <4.000000, -2.000000, 0.000000>, 
      <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.000000, -1.000000, 0.000000>, <4.000000, -1.000000, 0.000000>, 
      <1.000000, 0.000000, 0.000000>, <2.000000, 0.000000, 0.000000>, <3.000000, 0.000000, 0.000000>, <4.000000, 0.000000, 0.000000>, 
      <1.345594, 1.227389, 0.471019>, <2.000000, 1.000000, 0.000000>, <3.000000, 1.000000, 0.000000>, <4.000000, 1.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.345594, 1.227389, 0.471019>, <2.000000, 1.000000, 0.000000>, <3.000000, 1.000000, 0.000000>, <4.000000, 1.000000, 0.000000>, 
      <1.691189, 2.454777, 0.942038>, <2.000000, 2.000000, 0.000000>, <3.000000, 2.000000, 0.000000>, <4.000000, 2.000000, 0.000000>, 
      <1.691189, 3.454777, 0.942038>, <2.000000, 3.000000, 0.000000>, <3.000000, 3.000000, 0.000000>, <4.000000, 3.000000, 0.000000>, 
      <1.691189, 4.644268, 1.700000>, <2.000000, 4.000000, 0.000000>, <3.000000, 4.000000, 0.000000>, <4.000000, 4.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.691189, 4.644268, 1.700000>, <2.000000, 4.000000, 0.000000>, <3.000000, 4.000000, 0.000000>, <4.000000, 4.000000, 0.000000>, 
      <1.691189, 5.833758, 2.457962>, <2.000000, 5.000000, 0.000000>, <3.000000, 5.000000, 0.000000>, <4.000000, 5.000000, 0.000000>, 
      <1.691189, 6.833758, 2.457962>, <2.000000, 6.000000, 0.000000>, <3.000000, 6.000000, 0.000000>, <4.000000, 6.000000, 0.000000>, 
      <1.691189, 7.833758, 2.457962>, <2.000000, 7.000000, 0.000000>, <3.000000, 7.000000, 0.000000>, <4.000000, 7.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.691189, 7.833758, 2.457962>, <2.000000, 7.000000, 0.000000>, <3.000000, 7.000000, 0.000000>, <4.000000, 7.000000, 0.000000>, 
      <1.691189, 8.833758, 2.457962>, <2.000000, 8.000000, 0.000000>, <3.000000, 8.000000, 0.000000>, <4.000000, 8.000000, 0.000000>, 
      <1.691189, 9.833758, 2.457962>, <2.000000, 9.000000, 0.000000>, <3.000000, 9.000000, 0.000000>, <4.000000, 9.000000, 0.000000>, 
      <1.691189, 10.454777, 0.942038>, <2.000000, 10.000000, 0.000000>, <3.000000, 10.000000, 0.000000>, <4.000000, 10.000000, 0.000000>
    }
  }
  texture {
    Mountains1
  }
  scale <2.31169, 2.967063, 1.890146>
  rotate 47.942192*z
  translate  <31.655234, 34.472584, -0.505684>
}
           
#declare footprint =     

union { // footprint
  sphere { // paw1
    <0,0,0>,1
    scale <1.349995, 2.39998, 1.0>
    rotate -1.264359*z
    translate  <1.374373, -8.589526, -0.199954>
  }
  sphere { // paw2
    <0,0,0>,1
    scale <1.349995, 2.39998, 1.0>
    rotate 16.241461*z
    translate  <5.480065, -7.769141, -0.224948>
  }
  sphere { // paw3
    <0,0,0>,1
    scale <1.349995, 2.39998, 1.0>
    rotate 36.041908*z
    translate  <9.326855, -5.614299, -0.274936>
  }
  sphere { // paw4
    <0,0,0>,1
    scale <3.810439, 6.774082, 2.822558>
    rotate 13.293941*z
    translate  <1.2999, 6.071634, -1.14332>
  }
  cone { // claw1
    <0,0,0>, 0.0, <0,0,1>, 1.0
    scale <0.531291, 0.837411, 2.922982>
    rotate <-68.529877, 0.0, -0.0>
    translate  <1.399231, -13.062882, -0.961994>
  }
  cone { // claw2
    <0,0,0>, 0.0, <0,0,1>, 1.0
    scale <0.428697, 0.813252, 2.378177>
    rotate <-45.233223, 0.872462, 20.974051>
    translate  <6.941295, -11.599492, -1.669237>
  }
  cone { // claw3
    <0,0,0>, 0.0, <0,0,1>, 1.0
    scale <0.428697, 0.813252, 2.378177>
    rotate <-38.297718, -7.941469, 21.030481>
    translate  <11.610986, -8.951238, -1.629078>
  }
  texture {
    Mountains1
  }
  translate  -0.224097*z
}

union { // monster
  superellipsoid { // monstheadtop
    <0.1, 0.1>
    scale <3.065562, 1.510161, 0.959986>
    rotate 22.749809*z
    translate  <14.906857, -29.513775, 8.534071>
  }
  cone { // monstheadmid
    <0,0,0>, 1.0, <0,0,1>, 1.5
    scale <0.822417, 0.710873, 2.37698>
    rotate <-178.294098, 10.701119, -152.816757>
    translate  <12.996296, -30.231548, 7.401544>
  }
  superellipsoid { // monstheadtop1
    <0.1, 1.0>
    scale <2.019161, 1.798778, 0.426618>
    rotate <0.275287, -3.216009, 31.322283>
    translate  <14.429446, -29.827081, 5.17139>
  }
  cone { // monstneck
    <0,0,0>, 0.5, <0,0,1>, 1.0
    scale <1.791624, 1.557374, 8.135999>
    rotate <-180.0, 1.772014, -180.0>
    translate  <12.684297, -30.302424, 6.310054>
  }
  cone { // tooth1
    <0,0,0>, 0.0, <0,0,1>, 1.0
    texture {
      monstertex
    }
    scale <0.208128, 0.22274, 0.897645>
    rotate <0.519136, -3.76768, 37.267902>
    translate  <14.928001, -29.370848, 6.525316>
  }
  cone { // tooth2
    <0,0,0>, 0.0, <0,0,1>, 1.0
    texture {
      monstertex
    }
    scale <0.227183, 0.195373, 1.061709>
    rotate <0.519136, -3.76768, 37.267902>
    translate  <15.246711, -29.667988, 6.396256>
  }
  cone { // tooth3
    <0,0,0>, 0.0, <0,0,1>, 1.0
    texture {
      monstertex
    }
    scale <0.246239, 0.256247, 1.12604>
    rotate <0.519136, -3.76768, 37.267902>
    translate  <14.820783, -28.581948, 6.641204>
  }
  cone { // tooth4
    <0,0,0>, 0.0, <0,0,1>, 1.0
    texture {
      monstertex
    }
    scale <0.246239, 0.256247, 1.12604>
    rotate <0.519136, -3.76768, 37.267902>
    translate  <15.833046, -28.994432, 6.611083>
  }
  cone { // tooth5
    <0,0,0>, 0.0, <0,0,1>, 1.0
    texture {
      monstertex
    }
    scale <0.246239, 0.256247, 1.12604>
    rotate <0.519136, -3.76768, 37.267902>
    translate  <16.767112, -27.796055, 6.633192>
  }
  cone { // tooth6
    <0,0,0>, 0.0, <0,0,1>, 1.0
    texture {
      monstertex
    }
    scale <0.246239, 0.256247, 1.12604>
    rotate <0.519136, -3.76768, 37.267902>
    translate  <16.250736, -28.261638, 6.714869>
  }
  cone { // tooth7
    <0,0,0>, 0.0, <0,0,1>, 1.0
    texture {
      monstertex
    }
    scale <0.246239, 0.256247, 1.12604>
    rotate <0.519136, -3.76768, 37.267902>
    translate  <14.4284, -30.08983, 6.466775>
  }
  cone { // tooth8
    <0,0,0>, 0.0, <0,0,1>, 1.0
    texture {
      monstertex
    }
    scale <0.246239, 0.256247, 1.12604>
    rotate <0.519136, -3.76768, 37.267902>
    translate  <15.796371, -28.308018, 6.832326>
  }
  cone { // tooth9
    <0,0,0>, 0.0, <0,0,1>, 1.0
    texture {
      monstertex
    }
    scale <0.246239, 0.256247, 1.12604>
    rotate <0.519136, -3.76768, 37.267902>
    translate  <15.588057, -29.319038, 6.466696>
  }
  cone { // tooth10
    <0,0,0>, 0.0, <0,0,1>, 1.0
    texture {
      monstertex
    }
    scale <0.246239, 0.256247, 1.12604>
    rotate <0.519136, -3.76768, 37.267902>
    translate  <14.709202, -29.823044, 6.352243>
  }
  cone { // tooth12
    <0,0,0>, 0.0, <0,0,1>, 1.0
    texture {
      monstertex
    }
    scale <0.246239, 0.256247, 1.12604>
    rotate <0.519136, -3.76768, 37.267902>
    translate  <16.555413, -28.062406, 6.710803>
  }
  cone { // tooth13
    <0,0,0>, 0.0, <0,0,1>, 1.0
    texture {
      monstertex
    }
    scale <0.246239, 0.256247, 1.12604>
    rotate <0.519136, -3.76768, 37.267902>
    translate  <15.479081, -28.691593, 6.943947>
  }
  cone { // tooth14
    <0,0,0>, 0.0, <0,0,1>, 1.0
    texture {
      monstertex
    }
    scale <0.246239, 0.256247, 1.12604>
    rotate <179.844772, -3.76768, 37.267902>
    translate  <15.879505, -27.718999, 6.211307>
  }
  cone { // tooth15
    <0,0,0>, 0.0, <0,0,1>, 1.0
    texture {
      monstertex
    }
    scale <0.246239, 0.256247, 1.12604>
    rotate <179.844772, -3.76768, 37.267902>
    translate  <15.55687, -27.829063, 6.192442>
  }
  cone { // tooth16
    <0,0,0>, 0.0, <0,0,1>, 1.0
    texture {
      monstertex
    }
    scale <0.246239, 0.256247, 1.12604>
    rotate <179.844772, -3.76768, 37.267902>
    translate  <15.260642, -28.006756, 6.476323>
  }
  cone { // tooth17
    <0,0,0>, 0.0, <0,0,1>, 1.0
    texture {
      monstertex
    }
    scale <0.246239, 0.256247, 1.12604>
    rotate <179.844772, -3.76768, 37.267902>
    translate  <14.972982, -28.159036, 6.132992>
  }
  cone { // tooth18
    <0,0,0>, 0.0, <0,0,1>, 1.0
    texture {
      monstertex
    }
    scale <0.246239, 0.256247, 1.12604>
    rotate <179.844772, -3.76768, 37.267902>
    translate  <14.665682, -28.439055, 6.331619>
  }
  cone { // tooth19
    <0,0,0>, 0.0, <0,0,1>, 1.0
    texture {
      monstertex
    }
    scale <0.246239, 0.256247, 1.12604>
    rotate <0.519136, -3.76768, 37.267902>
    translate  <15.258658, -28.027049, 6.686896>
  }
  cone { // tooth20
    <0,0,0>, 0.0, <0,0,1>, 1.0
    texture {
      monstertex
    }
    scale <0.246239, 0.256247, 1.12604>
    rotate <179.844772, -3.76768, 37.267902>
    translate  <14.366873, -28.57247, 6.239536>
  }
  cone { // tooth21
    <0,0,0>, 0.0, <0,0,1>, 1.0
    texture {
      monstertex
    }
    scale <0.198464, 0.206531, 0.907569>
    rotate <179.844772, -3.76768, 37.267902>
    translate  <16.101739, -27.615804, 6.056701>
  }
  cone { // tooth22
    <0,0,0>, 0.0, <0,0,1>, 1.0
    texture {
      monstertex
    }
    scale <0.213147, 0.248474, 1.045934>
    rotate <0.651258, -8.600798, 72.844048>
    translate  <15.778531, -27.504363, 6.907635>
  }
  cone { // tooth23
    <0,0,0>, 0.0, <0,0,1>, 1.0
    texture {
      monstertex
    }
    scale <0.269894, 0.280864, 1.234212>
    rotate <178.035034, -7.062707, 72.626816>
    translate  <14.097737, -28.781547, 6.396767>
  }
  cone { // tooth24
    <0,0,0>, 0.0, <0,0,1>, 1.0
    texture {
      monstertex
    }
    scale <0.151813, 0.148095, 0.862308>
    rotate <175.696182, -3.032032, 75.486389>
    translate  <14.900636, -28.38712, 6.031969>
  }
  cone { // tooth25
    <0,0,0>, 0.0, <0,0,1>, 1.0
    texture {
      monstertex
    }
    scale <0.166967, 0.173753, 0.763532>
    rotate <-2.203745, -6.508134, 72.852539>
    translate  <13.985722, -29.982292, 6.555637>
  }
  cone { // tooth26
    <0,0,0>, 0.0, <0,0,1>, 1.0
    texture {
      monstertex
    }
    scale <0.166967, 0.173753, 0.763532>
    rotate <-178.970016, -5.80091, 3.70367>
    translate  <13.764018, -28.887507, 6.02421>
  }
  superellipsoid { // monstshoulder
    <1.0, 3.0>
    texture {
      monstertex
    }
    scale 1.561997
    rotate <-7.289917, 4.429589, 46.07246>
    translate  <13.878042, -29.297618, -0.572307>
  }
  sphere { // paw5
    <0,0,0>,1
    texture {
      monsterlegtex
    }
    scale <2.108687, 3.74876, 1.561997>
    rotate <43.089897, 21.547569, 12.337901>
    translate  <14.874505, -14.586562, -23.02184>
  }
  sphere { // paw6
    <0,0,0>,1
    texture {
      monsterlegtex
    }
    scale <2.108687, 3.74876, 1.561997>
    rotate <46.996956, 5.185894, 28.955212>
    translate  <11.452756, -15.40699, -21.703413>
  }
  sphere { // paw7
    <0,0,0>,1
    texture {
      monsterlegtex
    }
    scale <2.108687, 3.74876, 1.561997>
    rotate <44.404026, -18.054863, 51.333275>
    translate  <8.456541, -17.637987, -22.309808>
  }
  cylinder { // monsterleg
    <0,0,1>, <0,0,0>, 1 
    texture {
      monsterlegtex
    }
    scale <2.487955, 2.205183, 23.130339>
    rotate <48.044106, -10.602451, 29.746262>
    translate  <10.302468, -15.336055, -25.51577>
  }
  superellipsoid { // monstbody
    <1.0, 1.0>
    texture {
      monsterlegtex
    }
    scale <-7.306665, -3.941673, -9.462197>
    rotate <6.193376, -16.470125, 4.47518>
    translate  <13.207505, -30.266593, -9.036275>
  }
  cylinder { // monsttailmain
    <0,0,1>, <0,0,0>, 1 
    texture {
      monsterlegtex
    }
    scale <1.561997, 1.813385, 14.456771>
    rotate <11.869734, -3.76768, 37.267902>
    translate  <12.279769, -28.373725, -32.114766>
  }
  cone { // monsttail
    <0,0,0>, 0.0, <0,0,1>, 1.0
    texture {
      monsterlegtex
    }
    scale <1.561997, 2.25983, 14.368539>
    rotate <-19.499769, -3.76768, 37.267902>
    translate  <16.040939, -32.007362, -44.275826>
  }
  cylinder { // monsterleg1
    <0,0,1>, <0,0,0>, 1 
    texture {
      monsterlegtex
    }
    scale <2.634985, 1.806289, 23.634632>
    rotate <42.106655, -21.537003, 75.329712>
    translate  <-0.591404, -23.789098, -26.236446>
  }
  torus { // monshoulders
    1.5, 0.5  rotate -x*90
    texture {
      monsterlegtex
    }
    scale <3.21505, 1.68825, 0.441553>
    rotate <82.828827, 7.494238, 29.093679>
    translate  <12.220811, -30.091253, -2.418057>
  }
  texture {
    flagtex
  }
  scale 0.640206
  rotate <-41.92823, -24.078705, -29.567427>
  translate  <-0.805819, -7.62858, 0.429058>
}

#declare bottmain = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  9  // control points
  <-1.0, -0.490446>,
  <-0.483227, -1.0>,
  <0.501062, -1.0>,
  <1.0, -0.50276>,
  <1.0, 0.511677>,
  <0.521231, 1.0>,
  <-0.501062, 1.0>,
  <-1.0, 0.493843>,
  <-1.0, -0.490446>
  rotate -x*90
  texture {
    Streaky_Gold_Metal
  }
}

#declare bottommain = union {
  sphere { // mainsphere1
    <0,0,0>,1
    texture {
      Gold_Metal_Tex
    }
    scale 0.220382
    translate  <0.941249, 0.0, 0.511877>
  }
  sphere { // mainsphere2
    <0,0,0>,1
    texture {
      Gold_Metal_Tex
    }
    scale 0.220382
    translate  <0.0, 0.941249, 0.511877>
  }
  sphere { // mainsphere3
    <0,0,0>,1
    texture {
      Gold_Metal_Tex
    }
    scale 0.220382
    translate  <-0.941249, 0.0, 0.511877>
  }
  sphere { // mainsphere4
    <0,0,0>,1
    texture {
      Gold_Metal_Tex
    }
    scale 0.220382
    translate  <0.0, -0.901421, 0.511877>
  }
  object { bottmain }
  texture {
    bottmaintex
  }
}

#declare jetpack1 = union {
  cone { // jetout4
    <0,0,0>, 0.0, <0,0,1>, 1.0
    open
    texture {
      Aluminum
    }
    scale <-0.058621, -0.0702, -0.206035>
    rotate -180.0*x
    translate  <-0.003391, -0.837979, 1.585043>
  }
  box { // jetbox1
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Gold_Texture
    }
    scale <0.111879, 0.111313, 0.08077>
    rotate <0.0, -0.0, -46.248398>
    translate  <-0.003336, -0.841049, 1.570689>
  }
  cone { // jetout5
    <0,0,0>, 0.0, <0,0,1>, 1.0
    open
    texture {
      Aluminum
    }
    scale <-0.058621, -0.0702, -0.206035>
    rotate <-123.117622, 89.843262, 9.422668>
    translate  <0.034543, -0.8893, 1.585043>
  }
  cone { // jetout6
    <0,0,0>, 0.0, <0,0,1>, 1.0
    open
    texture {
      Aluminum
    }
    scale <-0.058621, -0.0702, -0.206035>
    rotate <-1.685944, 89.738129, 42.610893>
    translate  <-0.043555, -0.8893, 1.585043>
  }
  cone { // jetout7
    <0,0,0>, 0.0, <0,0,1>, 1.0
    open
    texture {
      Aluminum
    }
    scale <-0.058621, -0.0702, -0.206035>
    rotate <0.0, -0.497253, -180.0>
    translate  <-0.003391, -0.837979, 1.559112>
  }
  scale <0.996334, 1.0, 1.003666>
}

#declare jetpack = union {
  cone { // jetout
    <0,0,0>, 0.0, <0,0,1>, 1.0
    texture {
      Aluminum
    }
    scale <-0.058621, -0.0702, -0.206035>
    rotate -180.0*x
    translate  <-0.003391, -0.837979, 1.585043>
  }
  box { // jetbox
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Gold_Texture
    }
    scale <0.111879, 0.111313, 0.08077>
    rotate <0.0, -0.0, -46.248398>
    translate  <-0.003336, -0.841049, 1.570689>
  }
  cone { // jetout1
    <0,0,0>, 0.0, <0,0,1>, 1.0
    texture {
      Aluminum
    }
    scale <-0.058621, -0.0702, -0.206035>
    rotate <-123.117622, 89.843262, 9.422668>
    translate  <0.034543, -0.8893, 1.585043>
  }
  cone { // jetout2
    <0,0,0>, 0.0, <0,0,1>, 1.0
    texture {
      Aluminum
    }
    scale <-0.058621, -0.0702, -0.206035>
    rotate <-1.685944, 89.738129, 42.610893>
    translate  <-0.043555, -0.8893, 1.585043>
  }
  cone { // jetout3
    <0,0,0>, 0.0, <0,0,1>, 1.0
    texture {
      Aluminum
    }
    scale <-0.058621, -0.0702, -0.206035>
    rotate <0.0, -0.497253, -180.0>
    translate  <-0.003391, -0.837979, 1.559112>
  }
  object { jetpack1 }
  scale <0.996334, 1.0, 1.003666>
  rotate -90.482819*z
  translate  <-0.0, 0.030788, 0.0>
}

#declare jetpack2 = union {
  cone { // jetout8
    <0,0,0>, 0.0, <0,0,1>, 1.0
    open
    texture {
      Aluminum
    }
    scale <-0.058621, -0.0702, -0.206035>
    rotate -180.0*x
    translate  <-0.003391, -0.837979, 1.585043>
  }
  box { // jetbox2
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Gold_Texture
    }
    scale <0.111879, 0.111313, 0.08077>
    rotate <0.0, -0.0, -46.248398>
    translate  <-0.003336, -0.841049, 1.570689>
  }
  cone { // jetout9
    <0,0,0>, 0.0, <0,0,1>, 1.0
    open
    texture {
      Aluminum
    }
    scale <-0.058621, -0.0702, -0.206035>
    rotate <-123.117622, 89.843262, 9.422668>
    translate  <0.034543, -0.8893, 1.585043>
  }
  cone { // jetout10
    <0,0,0>, 0.0, <0,0,1>, 1.0
    open
    texture {
      Aluminum
    }
    scale <-0.058621, -0.0702, -0.206035>
    rotate <-1.685944, 89.738129, 42.610893>
    translate  <-0.043555, -0.8893, 1.585043>
  }
  cone { // jetout11
    <0,0,0>, 0.0, <0,0,1>, 1.0
    open
    texture {
      Aluminum
    }
    scale <-0.058621, -0.0702, -0.206035>
    rotate <0.0, -0.497253, -180.0>
    translate  <-0.003391, -0.837979, 1.559112>
  }
  scale <0.996334, 1.0, 1.003666>
}

#declare jetpack3 = union {
  cone { // jetout12
    <0,0,0>, 0.0, <0,0,1>, 1.0
    open
    texture {
      Aluminum
    }
    scale <-0.058621, -0.0702, -0.206035>
    rotate -180.0*x
    translate  <-0.003391, -0.837979, 1.585043>
  }
  box { // jetbox3
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Gold_Texture
    }
    scale <0.111879, 0.111313, 0.08077>
    rotate <0.0, -0.0, -46.248398>
    translate  <-0.003336, -0.841049, 1.570689>
  }
  cone { // jetout13
    <0,0,0>, 0.0, <0,0,1>, 1.0
    open
    texture {
      Aluminum
    }
    scale <-0.058621, -0.0702, -0.206035>
    rotate <-123.117622, 89.843262, 9.422668>
    translate  <0.034543, -0.8893, 1.585043>
  }
  cone { // jetout14
    <0,0,0>, 0.0, <0,0,1>, 1.0
    open
    texture {
      Aluminum
    }
    scale <-0.058621, -0.0702, -0.206035>
    rotate <-1.685944, 89.738129, 42.610893>
    translate  <-0.043555, -0.8893, 1.585043>
  }
  cone { // jetout15
    <0,0,0>, 0.0, <0,0,1>, 1.0
    open
    texture {
      Aluminum
    }
    scale <-0.058621, -0.0702, -0.206035>
    rotate <0.0, -0.497253, -180.0>
    translate  <-0.003391, -0.837979, 1.559112>
  }
  scale <0.996334, 1.0, 1.003666>
  rotate 91.164627*z
  translate  <0.109596, 0.036264, 0.0>
}

#declare jetpack4 = union {
  cone { // jetout16
    <0,0,0>, 0.0, <0,0,1>, 1.0
    open
    texture {
      Aluminum
    }
    scale <-0.058621, -0.0702, -0.206035>
    rotate -180.0*x
    translate  <-0.003391, -0.837979, 1.585043>
  }
  box { // jetbox4
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Gold_Texture
    }
    scale <0.111879, 0.111313, 0.08077>
    rotate <0.0, -0.0, -46.248398>
    translate  <-0.003336, -0.841049, 1.570689>
  }
  cone { // jetout17
    <0,0,0>, 0.0, <0,0,1>, 1.0
    open
    texture {
      Aluminum
    }
    scale <-0.058621, -0.0702, -0.206035>
    rotate <-123.117622, 89.843262, 9.422668>
    translate  <0.034543, -0.8893, 1.585043>
  }
  cone { // jetout18
    <0,0,0>, 0.0, <0,0,1>, 1.0
    open
    texture {
      Aluminum
    }
    scale <-0.058621, -0.0702, -0.206035>
    rotate <-1.685944, 89.738129, 42.610893>
    translate  <-0.043555, -0.8893, 1.585043>
  }
  cone { // jetout19
    <0,0,0>, 0.0, <0,0,1>, 1.0
    open
    texture {
      Aluminum
    }
    scale <-0.058621, -0.0702, -0.206035>
    rotate <0.0, -0.497253, -180.0>
    translate  <-0.003391, -0.837979, 1.559112>
  }
  scale <0.996334, 1.0, 1.003666>
  rotate 177.704117*z
  translate  <-0.022734, 0.090934, 0.0>
}

#declare uppermain = union {
  box { // window
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Vicks_Bottle_Glass
    }
    scale 0.206035
    rotate <0.0, 0.0, 45.529827>
    translate  <-0.631782, -0.598079, 1.710079>
  }
  box { // maintubewindowbox
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Silver_Texture
    }
    scale <0.125603, 0.247839, 0.511406>
    rotate 42.196861*z
    translate  <-0.659154, -0.635459, 1.567573>
  }
  box { // maintubesmallbox
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Silver_Texture
    }
    scale <-0.45131, -0.234868, -0.249698>
    rotate <0.560481, -2.501844, 44.299122>
    translate  <-0.383665, -0.346731, 1.934018>
  }
  box { // maintubebox
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Silver_Texture
    }
    scale <0.601389, 0.321668, 0.246751>
    rotate -47.542309*z
    translate  <0.019137, 0.059853, 1.954377>
  }
  cylinder { // maintubeleft
    <0,0,1>, <0,0,0>, 1 
    texture {
      Silver_Texture
    }
    scale <0.429355, 0.395365, 1.065802>
    rotate <171.205231, 89.333862, 36.23167>
    translate  <0.061074, 0.817988, 1.465782>
  }
  cylinder { // maintoptube
    <0,0,1>, <0,0,0>, 1 
    texture {
      Silver_Texture
    }
    scale <0.549566, 0.52055, 1.949984>
    rotate <70.317261, 89.83577, -64.828751>
    translate  <0.682633, 0.678332, 1.588013>
  }
  cylinder { // maintubeleft1
    <0,0,1>, <0,0,0>, 1 
    texture {
      Silver_Texture
    }
    scale <0.429355, 0.395365, 1.065802>
    rotate <171.205231, 89.333862, 36.23167>
    translate  <0.81921, 0.019951, 1.465782>
  }
  sphere { // satalliteball
    <0,0,0>,1
    texture {
      Aluminum
    }
    scale 0.070305
    translate  <0.247491, -0.140034, 2.501891>
  }
  cone { // radar
    <0,0,0>, 0.0, <0,0,1>, 1.0
    open
    texture {
      Aluminum
    }
    hollow
    scale 0.25451
    rotate <0.0, 88.997795, -108.830948>
    translate  <0.290349, 0.0, 2.50253>
  }

  object { jetpack }
  object { jetpack2 }
  object { jetpack3 }
  object { jetpack4 }
  cylinder { // satallitepost
    <0,0,1>, <0,0,0>, 1 
    texture {
      Aluminum
    }
    scale <0.030134, 0.032768, 0.280389>
    translate  <0.295177, -0.00775, 2.202447>
  }
}

#declare landinggear = union {
  cone { // bottomlandpad
    <0,0,0>, 0.9, <0,0,1>, 1.2
    texture {
      bottmaintex
    }
    scale <0.223698, 0.223673, 0.061963>
    rotate <180.0, -0.008978, 180.0>
    translate  <-1.52794, -1.595587, -0.468957>
  }
  cone { // landpad
    <0,0,0>, 0.7, <0,0,1>, 1.0
    texture {
      Copper_Texture
    }
    scale <0.223677, 0.223653, 0.094286>
    rotate <-180.0, -0.01041, -180.0>
    translate  <-1.525447, -1.590172, -0.420445>
  }
  sphere { // supportball
    <0,0,0>,1
    texture {
      bottmaintex
    }
    scale 0.094427
    translate  <-0.934597, -0.971098, 0.85706>
  }
  cylinder { // supportmainleg1
    <0,0,1>, <0,0,0>, 1 
    texture {
      Aluminum
    }
    scale <0.058304, 0.076374, 1.519703>
    rotate <20.465012, -26.048319, -175.066544>
    translate  <-1.523025, -1.575533, -0.432308>
  }
  cylinder { // supporttop1
    <0,0,1>, <0,0,0>, 1 
    texture {
      Aluminum
    }
    scale <-0.033771, -0.036256, -0.558057>
    rotate <89.565277, 0.0, -180.0>
    translate  <-0.942904, -0.435737, 0.843394>
  }
  cylinder { // supporttop2
    <0,0,1>, <0,0,0>, 1 
    texture {
      Aluminum
    }
    scale <-0.033771, -0.036256, -0.558057>
    rotate <90.094711, 0.458157, -81.746552>
    translate  <-0.95696, -1.012034, 0.843394>
  }
  cylinder { // supportmid2
    <0,0,1>, <0,0,0>, 1 
    texture {
      Aluminum
    }
    scale <-0.056168, -0.060301, -0.928156>
    rotate <30.384003, 2.055007, -81.596481>
    translate  <-0.95696, -1.012034, 0.843394>
  }
  cylinder { // supportmid1
    <0,0,1>, <0,0,0>, 1 
    texture {
      Aluminum
    }
    scale <-0.056168, -0.060301, -0.928156>
    rotate <173.281769, -32.461605, 100.440788>
    translate  <-0.900813, -0.507834, 0.008827>
  }
  cylinder { // supportbottom1
    <0,0,1>, <0,0,0>, 1 
    texture {
      Aluminum
    }
    scale <-0.056168, -0.060301, -0.928156>
    rotate <-24.849274, -83.188217, -90.332809>
    translate  <-0.900813, -0.507834, 0.008827>
  }
  cylinder { // supportbottom2
    <0,0,1>, <0,0,0>, 1 
    texture {
      Aluminum
    }
    scale <-0.056168, -0.060301, -0.928156>
    rotate <-70.947487, -84.479706, -80.300819>
    translate  <-0.484233, -0.876804, 0.008827>
  }
}

#declare landinggear1 = union {
  cone { // bottomlandpad1
    <0,0,0>, 0.9, <0,0,1>, 1.2
    texture {
      bottmaintex
    }
    scale <0.223698, 0.223673, 0.061963>
    rotate <180.0, -0.008978, 180.0>
    translate  <-1.52794, -1.595587, -0.468957>
  }
  cone { // landpad1
    <0,0,0>, 0.7, <0,0,1>, 1.0
    texture {
      Copper_Texture
    }
    scale <0.223677, 0.223653, 0.094286>
    rotate <-180.0, -0.01041, -180.0>
    translate  <-1.525447, -1.590172, -0.420445>
  }
  sphere { // supportball1
    <0,0,0>,1
    texture {
      bottmaintex
    }
    scale 0.094427
    translate  <-0.934597, -0.971098, 0.85706>
  }
  cylinder { // supportmainleg2
    <0,0,1>, <0,0,0>, 1 
    texture {
      Aluminum
    }
    scale <0.058304, 0.076374, 1.519703>
    rotate <20.465012, -26.048319, -175.066544>
    translate  <-1.523025, -1.575533, -0.432308>
  }
  cylinder { // supporttop3
    <0,0,1>, <0,0,0>, 1 
    texture {
      Aluminum
    }
    scale <-0.033771, -0.036256, -0.558057>
    rotate <89.565277, 0.0, -180.0>
    translate  <-0.942904, -0.435737, 0.843394>
  }
  cylinder { // supporttop4
    <0,0,1>, <0,0,0>, 1 
    texture {
      Aluminum
    }
    scale <-0.033771, -0.036256, -0.558057>
    rotate <90.094711, 0.458157, -81.746552>
    translate  <-0.95696, -1.012034, 0.843394>
  }
  cylinder { // supportmid3
    <0,0,1>, <0,0,0>, 1 
    texture {
      Aluminum
    }
    scale <-0.056168, -0.060301, -0.928156>
    rotate <30.384003, 2.055007, -81.596481>
    translate  <-0.95696, -1.012034, 0.843394>
  }
  cylinder { // supportmid4
    <0,0,1>, <0,0,0>, 1 
    texture {
      Aluminum
    }
    scale <-0.056168, -0.060301, -0.928156>
    rotate <173.281769, -32.461605, 100.440788>
    translate  <-0.900813, -0.507834, 0.008827>
  }
  cylinder { // supportbottom3
    <0,0,1>, <0,0,0>, 1 
    texture {
      Aluminum
    }
    scale <-0.056168, -0.060301, -0.928156>
    rotate <-24.849274, -83.188217, -90.332809>
    translate  <-0.900813, -0.507834, 0.008827>
  }
  cylinder { // supportbottom4
    <0,0,1>, <0,0,0>, 1 
    texture {
      Aluminum
    }
    scale <-0.056168, -0.060301, -0.928156>
    rotate <-70.947487, -84.479706, -80.300819>
    translate  <-0.484233, -0.876804, 0.008827>
  }
  rotate 90.27372*z
}

#declare landinggear2 = union {
  cone { // bottomlandpad2
    <0,0,0>, 0.9, <0,0,1>, 1.2
    texture {
      bottmaintex
    }
    scale <0.223698, 0.223673, 0.061963>
    rotate <180.0, -0.008978, 180.0>
    translate  <-1.52794, -1.595587, -0.468957>
  }
  cone { // landpad2
    <0,0,0>, 0.7, <0,0,1>, 1.0
    texture {
      Copper_Texture
    }
    scale <0.223677, 0.223653, 0.094286>
    rotate <-180.0, -0.01041, -180.0>
    translate  <-1.525447, -1.590172, -0.420445>
  }
  sphere { // supportball2
    <0,0,0>,1
    texture {
      bottmaintex
    }
    scale 0.094427
    translate  <-0.934597, -0.971098, 0.85706>
  }
  cylinder { // supportmainleg3
    <0,0,1>, <0,0,0>, 1 
    texture {
      Aluminum
    }
    scale <0.058304, 0.076374, 1.519703>
    rotate <20.465012, -26.048319, -175.066544>
    translate  <-1.523025, -1.575533, -0.432308>
  }
  cylinder { // supporttop5
    <0,0,1>, <0,0,0>, 1 
    texture {
      Aluminum
    }
    scale <-0.033771, -0.036256, -0.558057>
    rotate <89.565277, 0.0, -180.0>
    translate  <-0.942904, -0.435737, 0.843394>
  }
  cylinder { // supporttop6
    <0,0,1>, <0,0,0>, 1 
    texture {
      Aluminum
    }
    scale <-0.033771, -0.036256, -0.558057>
    rotate <90.094711, 0.458157, -81.746552>
    translate  <-0.95696, -1.012034, 0.843394>
  }
  cylinder { // supportmid5
    <0,0,1>, <0,0,0>, 1 
    texture {
      Aluminum
    }
    scale <-0.056168, -0.060301, -0.928156>
    rotate <30.384003, 2.055007, -81.596481>
    translate  <-0.95696, -1.012034, 0.843394>
  }
  cylinder { // supportmid6
    <0,0,1>, <0,0,0>, 1 
    texture {
      Aluminum
    }
    scale <-0.056168, -0.060301, -0.928156>
    rotate <173.281769, -32.461605, 100.440788>
    translate  <-0.900813, -0.507834, 0.008827>
  }
  cylinder { // supportbottom5
    <0,0,1>, <0,0,0>, 1 
    texture {
      Aluminum
    }
    scale <-0.056168, -0.060301, -0.928156>
    rotate <-24.849274, -83.188217, -90.332809>
    translate  <-0.900813, -0.507834, 0.008827>
  }
  cylinder { // supportbottom6
    <0,0,1>, <0,0,0>, 1 
    texture {
      Aluminum
    }
    scale <-0.056168, -0.060301, -0.928156>
    rotate <-70.947487, -84.479706, -80.300819>
    translate  <-0.484233, -0.876804, 0.008827>
  }
  rotate -90.077377*z
}

#declare landinggear3 = union {
  cone { // bottomlandpad3
    <0,0,0>, 0.9, <0,0,1>, 1.2
    texture {
      bottmaintex
    }
    scale <0.223698, 0.223673, 0.061963>
    rotate <180.0, -0.008978, 180.0>
    translate  <-1.52794, -1.595587, -0.468957>
  }
  cone { // landpad3
    <0,0,0>, 0.7, <0,0,1>, 1.0
    texture {
      Copper_Texture
    }
    scale <0.223677, 0.223653, 0.094286>
    rotate <-180.0, -0.01041, -180.0>
    translate  <-1.525447, -1.590172, -0.420445>
  }
  sphere { // supportball3
    <0,0,0>,1
    texture {
      bottmaintex
    }
    scale 0.094427
    translate  <-0.934597, -0.971098, 0.85706>
  }
  cylinder { // supportmainleg4
    <0,0,1>, <0,0,0>, 1 
    texture {
      Aluminum
    }
    scale <0.058304, 0.076374, 1.519703>
    rotate <20.465012, -26.048319, -175.066544>
    translate  <-1.523025, -1.575533, -0.432308>
  }
  cylinder { // supporttop7
    <0,0,1>, <0,0,0>, 1 
    texture {
      Aluminum
    }
    scale <-0.033771, -0.036256, -0.558057>
    rotate <89.565277, 0.0, -180.0>
    translate  <-0.942904, -0.435737, 0.843394>
  }
  cylinder { // supporttop8
    <0,0,1>, <0,0,0>, 1 
    texture {
      Aluminum
    }
    scale <-0.033771, -0.036256, -0.558057>
    rotate <90.094711, 0.458157, -81.746552>
    translate  <-0.95696, -1.012034, 0.843394>
  }
  cylinder { // supportmid7
    <0,0,1>, <0,0,0>, 1 
    texture {
      Aluminum
    }
    scale <-0.056168, -0.060301, -0.928156>
    rotate <30.384003, 2.055007, -81.596481>
    translate  <-0.95696, -1.012034, 0.843394>
  }
  cylinder { // supportmid8
    <0,0,1>, <0,0,0>, 1 
    texture {
      Aluminum
    }
    scale <-0.056168, -0.060301, -0.928156>
    rotate <173.281769, -32.461605, 100.440788>
    translate  <-0.900813, -0.507834, 0.008827>
  }
  cylinder { // supportbottom7
    <0,0,1>, <0,0,0>, 1 
    texture {
      Aluminum
    }
    scale <-0.056168, -0.060301, -0.928156>
    rotate <-24.849274, -83.188217, -90.332809>
    translate  <-0.900813, -0.507834, 0.008827>
  }
  cylinder { // supportbottom8
    <0,0,1>, <0,0,0>, 1 
    texture {
      Aluminum
    }
    scale <-0.056168, -0.060301, -0.928156>
    rotate <-70.947487, -84.479706, -80.300819>
    translate  <-0.484233, -0.876804, 0.008827>
  }
  rotate -179.984406*z
}

union { // Lem
  object { bottommain }
  object { uppermain }
  object { landinggear }
  object { landinggear1 }
  object { landinggear2 }
  object { landinggear3 }
  scale 1.186372
  rotate 20.56443*z
  translate  <-1.840037, -4.023359, 0.08685>
}

#declare helmut = union {
  sphere { // head
    <0,0,0>,1
    texture {
      astrotex
    }
    scale <0.258897, 0.297903, 0.271899>
    translate  0.949132*z
  }
  sphere { // visor
    <0,0,0>,1
    texture {
      Aluminum_1
    }
    scale <0.228091, 0.252124, 0.228753>
    translate  <-0.0, -0.07511, 0.997006>
  }
  superellipsoid { // backpack
    <0.1, 0.1>
    texture {
      astrotex
    }
    scale <0.394658, 0.164196, 0.583942>
    translate  <0.0, 0.377456, 0.585081>
  }
  torus { // visorrim
    1.5, 0.5  rotate -x*90
    texture {
      glove_boot
    }
    scale <0.13155, 0.125384, 0.050559>
    rotate <0.863994, 32.684887, -87.772148>
    translate  <0.003544, -0.081168, 1.015874>
  }
  translate  -0.102737*z
}

#declare shoulder1 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.153651, -1.387952, -1.803490>, <-1.030153, -1.952427, -1.765754>, <0.659564, -1.674932, -1.749169>, <2.673343, -1.707662, -1.733756>, 
      <-1.686839, -0.655008, -1.772018>, <-1.761143, -2.241802, 1.458761>, <-0.980905, -2.726720, 1.100776>, <2.194234, -1.811340, 1.198728>, 
      <-1.463851, -0.173952, -1.621530>, <-1.618600, 0.240815, 1.216633>, <0.087961, 0.824840, 0.884747>, <2.194231, 0.285403, 0.898837>, 
      <-1.022837, 0.018903, -1.762849>, <-0.973134, 0.074622, -1.749374>, <0.194969, 0.062747, -1.749175>, <2.673340, -0.015363, -1.744666>
    }
  }
  texture {
    astrotex
  }
  scale <0.132795, 0.223106, 0.152206>
  rotate <0.0, -0.0, 1.417288>
  translate  <-0.346648, 0.239996, 0.683506>
}

#declare shoulder2 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.079494, -1.127009, -2.171291>, <-0.957697, -1.602915, -2.030303>, <0.932376, -1.178336, -2.095367>, <2.668113, -1.968970, -1.998304>, 
      <-1.242289, -0.673904, -2.822332>, <-1.763852, -1.735111, 1.240315>, <0.102398, -2.162330, 0.862859>, <2.194234, -1.617554, 0.960810>, 
      <-1.093256, 0.615157, -2.217582>, <-1.665299, 0.102010, 1.063442>, <0.087961, 0.824840, 0.884747>, <2.194231, 0.285403, 0.898837>, 
      <-0.951289, -0.169206, -2.233024>, <-0.978365, 0.074622, -2.013922>, <0.233003, 0.062747, -2.013724>, <2.668109, -0.015363, -2.009214>
    }
  }
  texture {
    astrotex
  }
  scale <0.11482, 0.192908, 0.131604>
  rotate <0.0, -0.0, -177.962875>
  translate  <0.374186, -0.089998, 0.702174>
}

#declare strap1 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.506753, -0.000002, -0.999939>, <0.506753, -1.333333, -0.999939>, <0.528796, -1.333333, 0.999939>, <0.528796, -0.000000, 0.999939>, 
      <-1.791017, -0.000002, 2.024366>, <-1.791017, -1.333333, 2.024366>, <-0.982430, -1.333333, 2.164231>, <-0.982430, -0.000000, 2.164231>, 
      <0.119220, -0.000002, 4.837685>, <0.119220, -1.333333, 4.837685>, <0.907056, -1.333333, 4.697820>, <0.907056, -0.000000, 4.697820>, 
      <1.500348, -0.000002, 6.298708>, <1.500348, -1.333333, 6.298708>, <2.288184, -1.333333, 6.158843>, <2.288184, -0.000000, 6.158843>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.528796, -0.000000, 0.999939>, <0.528796, 1.333333, 0.999939>, <0.506753, 1.333330, -0.999939>, <0.506753, -0.000002, -0.999939>, 
      <-0.982430, -0.000000, 2.164231>, <-0.982430, 1.333333, 2.164231>, <-1.791017, 1.333330, 2.024366>, <-1.791017, -0.000002, 2.024366>, 
      <0.907056, -0.000000, 4.697820>, <0.907056, 1.333333, 4.697820>, <0.119220, 1.333330, 4.837685>, <0.119220, -0.000002, 4.837685>, 
      <2.288184, -0.000000, 6.158843>, <2.288184, 1.333333, 6.158843>, <1.500348, 1.333330, 6.298708>, <1.500348, -0.000002, 6.298708>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.500348, -0.000002, 6.298708>, <1.500348, -1.333333, 6.298708>, <2.288184, -1.333333, 6.158843>, <2.288184, -0.000000, 6.158843>, 
      <2.881475, -0.000002, 7.759732>, <2.881475, -1.333333, 7.759732>, <3.669312, -1.333333, 7.619867>, <3.669312, -0.000000, 7.619867>, 
      <4.063888, -0.000002, 7.499712>, <4.063888, -1.333333, 7.499712>, <6.137727, -1.333333, 7.484977>, <6.137727, -0.000000, 7.484977>, 
      <9.087578, -0.000002, 6.302904>, <9.087578, -1.333333, 6.302904>, <8.718236, -1.333333, 6.781845>, <8.718236, -0.000000, 6.781845>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <2.288184, -0.000000, 6.158843>, <2.288184, 1.333333, 6.158843>, <1.500348, 1.333330, 6.298708>, <1.500348, -0.000002, 6.298708>, 
      <3.669312, -0.000000, 7.619867>, <3.669312, 1.333333, 7.619867>, <2.881475, 1.333330, 7.759732>, <2.881475, -0.000002, 7.759732>, 
      <6.137727, -0.000000, 7.484977>, <6.137727, 1.333333, 7.484977>, <4.063888, 1.333330, 7.499712>, <4.063888, -0.000002, 7.499712>, 
      <8.718236, -0.000000, 6.781845>, <8.718236, 1.333333, 6.781845>, <9.087578, 1.333330, 6.302904>, <9.087578, -0.000002, 6.302904>
    }
  }
  texture {
    astrotex
  }
  scale 0.056425
  rotate <8.953092, 0.027304, 89.826874>
  translate  <0.233343, -0.284087, 0.349836>
}

#declare strap = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.506753, -0.000002, -0.999939>, <0.506753, -1.333333, -0.999939>, <0.528796, -1.333333, 0.999939>, <0.528796, -0.000000, 0.999939>, 
      <-1.791017, -0.000002, 2.024366>, <-1.791017, -1.333333, 2.024366>, <-0.982430, -1.333333, 2.164231>, <-0.982430, -0.000000, 2.164231>, 
      <0.119220, -0.000002, 4.837685>, <0.119220, -1.333333, 4.837685>, <0.907056, -1.333333, 4.697820>, <0.907056, -0.000000, 4.697820>, 
      <1.500348, -0.000002, 6.298708>, <1.500348, -1.333333, 6.298708>, <2.288184, -1.333333, 6.158843>, <2.288184, -0.000000, 6.158843>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.528796, -0.000000, 0.999939>, <0.528796, 1.333333, 0.999939>, <0.506753, 1.333330, -0.999939>, <0.506753, -0.000002, -0.999939>, 
      <-0.982430, -0.000000, 2.164231>, <-0.982430, 1.333333, 2.164231>, <-1.791017, 1.333330, 2.024366>, <-1.791017, -0.000002, 2.024366>, 
      <0.907056, -0.000000, 4.697820>, <0.907056, 1.333333, 4.697820>, <0.119220, 1.333330, 4.837685>, <0.119220, -0.000002, 4.837685>, 
      <2.288184, -0.000000, 6.158843>, <2.288184, 1.333333, 6.158843>, <1.500348, 1.333330, 6.298708>, <1.500348, -0.000002, 6.298708>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.500348, -0.000002, 6.298708>, <1.500348, -1.333333, 6.298708>, <2.288184, -1.333333, 6.158843>, <2.288184, -0.000000, 6.158843>, 
      <2.881475, -0.000002, 7.759732>, <2.881475, -1.333333, 7.759732>, <3.669312, -1.333333, 7.619867>, <3.669312, -0.000000, 7.619867>, 
      <4.063888, -0.000002, 7.499712>, <4.063888, -1.333333, 7.499712>, <6.137727, -1.333333, 7.484977>, <6.137727, -0.000000, 7.484977>, 
      <9.087578, -0.000002, 6.302904>, <9.087578, -1.333333, 6.302904>, <8.718236, -1.333333, 6.781845>, <8.718236, -0.000000, 6.781845>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <2.288184, -0.000000, 6.158843>, <2.288184, 1.333333, 6.158843>, <1.500348, 1.333330, 6.298708>, <1.500348, -0.000002, 6.298708>, 
      <3.669312, -0.000000, 7.619867>, <3.669312, 1.333333, 7.619867>, <2.881475, 1.333330, 7.759732>, <2.881475, -0.000002, 7.759732>, 
      <6.137727, -0.000000, 7.484977>, <6.137727, 1.333333, 7.484977>, <4.063888, 1.333330, 7.499712>, <4.063888, -0.000002, 7.499712>, 
      <8.718236, -0.000000, 6.781845>, <8.718236, 1.333333, 6.781845>, <9.087578, 1.333330, 6.302904>, <9.087578, -0.000002, 6.302904>
    }
  }
  texture {
    astrotex
  }
  scale 0.056425
  rotate <-12.601233, -0.038227, 89.828918>
  translate  <-0.22401, -0.284087, 0.349836>
}

#declare frontpanel = union {
  object { strap1 }
  cylinder { // dial4
    <0,0,1>, <0,0,0>, 1 
    texture {
      glove_boot
    }
    scale <0.11324, 0.066571, 0.066571>
    translate  <-0.009334, -0.233357, 0.112817>
  }
  object { strap }
  cylinder { // dial1
    <0,0,1>, <0,0,0>, 1 
    texture {
      glove_boot
    }
    scale 0.044467
    rotate 90.109009*x
    translate  <-0.07467, -0.243503, 0.4955>
  }
  cylinder { // dial2
    <0,0,1>, <0,0,0>, 1 
    texture {
      glove_boot
    }
    scale <0.044467, 0.064759, 0.044428>
    rotate 90.109009*x
    translate  <-0.093337, -0.243503, 0.299492>
  }
  cylinder { // dial3
    <0,0,1>, <0,0,0>, 1 
    texture {
      glove_boot
    }
    scale <0.044467, 0.095196, 0.04437>
    rotate 90.109009*x
    translate  <0.056002, -0.243503, 0.364828>
  }
  superellipsoid { // backpack1
    <0.1, 0.1>
    texture {
      astrotex
    }
    scale <0.189211, 0.07183, 0.289391>
    translate  <0.0, -0.200864, 0.353358>
  }
  superellipsoid { // belt
    <1.0, 0.1>
    texture {
      astrotex
    }
    scale <0.308925, 0.225983, 0.068196>
    translate  <0.0, -0.040584, 0.096999>
  }
  box { // dial6
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Copper_Texture
    }
    scale 0.043171
    rotate 46.135902*y
    translate  <0.092004, -0.246368, 0.539489>
  }
}

#declare foot2 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.514547, -1.132137, -1.036710>, <-1.000000, -1.396205, -1.013596>, <0.168107, -1.396205, -1.013596>, <2.646481, -1.493536, -0.981597>, 
      <-1.674930, -1.149338, -1.005239>, <-1.580224, -1.776453, 1.197051>, <0.102398, -2.162330, 0.862859>, <2.194234, -1.617554, 0.960810>, 
      <-1.548980, -0.143680, -1.004419>, <-1.580221, 0.126783, 1.216633>, <0.087961, 0.824840, 0.884747>, <2.194231, 0.285403, 0.898837>, 
      <-1.510368, -0.121872, -1.019861>, <-0.999997, 0.074622, -0.997215>, <0.168107, 0.062747, -0.997017>, <2.646477, -0.015363, -0.992507>
    }
  }
  texture {
    glove_boot
  }
  scale <0.131935, 0.188381, 0.152206>
  rotate 90.047646*z
  translate  <0.028001, -0.223211, -0.654866>
}

#declare lowerbody2 = union {
  cylinder { // boottop2
    <0,0,1>, <0,0,0>, 1 
    texture {
      glove_boot
    }
    scale 0.153066
    translate  <0.121339, -0.040584, -0.627384>
  }
  cone { // leg3
    <0,0,0>, 0.13, <0,0,1>, 0.15
    texture {
      astrotex
    }
    scale <1.003667, 1.01033, 0.839656>
    translate  <0.12635, -0.040584, -0.650432>
  }
  object { foot2 }
  translate  <-0.020358, 0.0, -0.020358>
}

#declare foot1 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.514547, -1.132137, -1.036710>, <-1.000000, -1.396205, -1.013596>, <0.168107, -1.396205, -1.013596>, <2.646481, -1.493536, -0.981597>, 
      <-1.674930, -1.149338, -1.005239>, <-1.580224, -1.776453, 1.197051>, <0.102398, -2.162330, 0.862859>, <2.194234, -1.617554, 0.960810>, 
      <-1.548980, -0.143680, -1.004419>, <-1.580221, 0.126783, 1.216633>, <0.087961, 0.824840, 0.884747>, <2.194231, 0.285403, 0.898837>, 
      <-1.510368, -0.121872, -1.019861>, <-0.999997, 0.074622, -0.997215>, <0.168107, 0.062747, -0.997017>, <2.646477, -0.015363, -0.992507>
    }
  }
  texture {
    glove_boot
  }
  scale <0.131935, 0.188381, 0.152206>
  rotate 90.047646*z
  translate  <-0.295373, -0.223211, -0.651218>
}

#declare lowerbody1 = union {
  object { foot1 }
  cone { // leg1
    <0,0,0>, 0.13, <0,0,1>, 0.15
    texture {
      astrotex
    }
    scale <1.04417, 0.997827, 0.839656>
    translate  <-0.146688, -0.040584, -0.646784>
  }
  cylinder { // boottop1
    <0,0,1>, <0,0,0>, 1 
    texture {
      glove_boot
    }
    scale 0.1624
    translate  <-0.14934, -0.040584, -0.63307>
  }
  translate  <-0.020358, 0.0, -0.030537>
}

#declare arm1 = union {
  cylinder { // upperarm1
    <0,0,1>, <0,0,0>, 1 
    texture {
      astrotex
    }
    scale <0.10626, 0.121919, 0.328241>
    rotate <-2.010988, 0.0, -0.0>
    translate  <-0.400157, 0.013499, 0.21955>
  }
  sphere { // elbow1
    <0,0,0>,1
    texture {
      Texture1
    }
    scale <0.106595, 0.106595, 0.102615>
    translate  <-0.398253, 0.015404, 0.232945>
  }
  cone { // forearm1
    <0,0,0>, 0.07, <0,0,1>, 0.1
    texture {
      astrotex
    }
    scale <1.080471, 1.112311, 0.262399>
    rotate -4.051146*x
    translate  <-0.400654, -0.014244, -0.021869>
  }
  superellipsoid { // glove
    <0.1, 1.0>
    texture {
      glove_boot
    }
    scale <0.101374, 0.123909, 0.078149>
    rotate -55.21328*y
    translate  <-0.442061, 0.0, -0.058986>
  }
  sphere { // thumb
    <0,0,0>,1
    texture {
      glove_boot
    }
    scale <0.052185, 0.036285, 0.065544>
    translate  <-0.353345, 0.0, -0.050262>
  }
  translate  <-0.010179, 0.0, -0.010179>
}

#declare arm2 = union {
  cylinder { // upperarm2
    <0,0,1>, <0,0,0>, 1 
    texture {
      astrotex
    }
    scale <0.103034, 0.118331, 0.315277>
    rotate <-2.010988, 0.0, -0.0>
    translate  <0.396621, 0.008199, 0.235249>
  }
  cone { // forearm2
    <0,0,0>, 0.07, <0,0,1>, 0.1
    texture {
      astrotex
    }
    scale <1.084078, 1.114011, 0.254917>
    rotate -4.051146*x
    translate  <0.396124, -0.014244, -0.019827>
  }
  sphere { // elbow2
    <0,0,0>,1
    texture {
      Texture1
    }
    scale <0.106595, 0.106595, 0.102615>
    translate  <0.398525, 0.004803, 0.223611>
  }
  superellipsoid { // glove1
    <0.1, 1.0>
    texture {
      glove_boot
    }
    scale <0.108728, 0.123909, 0.079554>
    rotate <180.0, -51.051094, 180.0>
    translate  <0.432728, 0.0, -0.069461>
  }
  sphere { // thumb1
    <0,0,0>,1
    texture {
      glove_boot
    }
    scale <0.052185, 0.036285, 0.065544>
    translate  <0.328414, 0.0, -0.060737>
  }
  translate  0.010179*z
}

union { // astronut
  object { helmut }
  object { shoulder1 }
  object { shoulder2 }
  superellipsoid { // bodysuper
    <1.0, 1.0>
    texture {
      astrotex
    }
    scale <0.318129, 0.228052, 0.53022>
    translate  0.351049*z
  }

  object { frontpanel }
  object { lowerbody2 }
  object { lowerbody1 }
  object { arm1 }
  object { arm2 }
  rotate -32.577255*z
  translate  <3.430676, -3.929058, 0.244932>
}

union { // rock2
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-3.000000, -3.000000, 0.000000>, <-2.000000, -3.000000, 0.000000>, <-1.000000, -3.000000, 0.000000>, <-0.054140, -2.989172, 0.682166>, 
      <-3.000000, -2.000000, 0.000000>, <-2.000000, -2.000000, 0.000000>, <-1.000000, -2.000000, 0.000000>, <-0.054140, -1.989172, 0.682166>, 
      <-3.000000, -1.000000, 0.000000>, <-1.870064, -0.978344, -0.389809>, <2.797028, -1.267091, 1.624204>, <2.905520, -1.220170, 1.039490>, 
      <-3.000000, 0.000000, 0.000000>, <-1.870064, 0.010828, -0.703822>, <1.245011, -0.122718, 2.620382>, <0.898726, -0.220170, 1.521338>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-3.000000, 0.000000, 0.000000>, <-1.870064, 0.010828, -0.703822>, <1.245011, -0.122718, 2.620382>, <0.898726, -0.220170, 1.521338>, 
      <-3.000000, 1.000000, 0.000000>, <-1.870064, 1.000000, -1.017834>, <-0.307006, 1.021656, 3.616561>, <-1.108068, 0.779830, 2.003185>, 
      <-3.000000, 2.000000, 0.000000>, <-1.285350, 2.000000, 0.628025>, <-0.285350, 2.000000, 0.628025>, <-1.086412, 1.292569, 0.314013>, 
      <-3.000000, 3.000000, 0.000000>, <-2.000000, 3.000000, 0.000000>, <-1.000000, 3.000000, 0.000000>, <0.000000, 3.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.054140, -2.989172, 0.682166>, <0.891720, -2.978344, 1.364331>, <1.891720, -2.978344, 1.364331>, <2.891720, -2.978344, 1.364331>, 
      <-0.054140, -1.989172, 0.682166>, <0.891720, -1.978344, 1.364331>, <1.891720, -1.978344, 1.364331>, <2.891720, -1.978344, 1.364331>, 
      <2.905520, -1.220170, 1.039490>, <3.014013, -1.173248, 0.454777>, <2.000000, -1.000000, 0.000000>, <3.000000, -1.000000, 0.000000>, 
      <0.898726, -0.220170, 1.521338>, <0.552442, -0.317622, 0.422293>, <2.000000, 0.476433, -0.508917>, <3.000000, 0.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.898726, -0.220170, 1.521338>, <0.552442, -0.317622, 0.422293>, <2.000000, 0.476433, -0.508917>, <3.000000, 0.000000, 0.000000>, 
      <-1.108068, 0.779830, 2.003185>, <-1.909130, 0.538004, 0.389809>, <2.000000, 1.952866, -1.017834>, <3.000000, 1.000000, 0.000000>, 
      <-1.086412, 1.292569, 0.314013>, <-1.887473, 0.585138, 0.000000>, <2.000000, 2.000000, 0.000000>, <3.000000, 2.000000, 0.000000>, 
      <0.000000, 3.000000, 0.000000>, <1.000000, 3.000000, 0.000000>, <2.000000, 3.000000, 0.000000>, <3.000000, 3.000000, 0.000000>
    }
  }
  texture {
    landareatex
  }
  scale <1.643964, 1.047652, 1.0>
  rotate 174.035858*z
  translate  <6.484057, 28.865025, -1.143942>
}

union { // rock5
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-3.000000, -3.000000, 0.000000>, <-2.000000, -3.000000, 0.000000>, <-1.000000, -3.000000, 0.000000>, <-0.030899, -2.989172, 0.356795>, 
      <-3.000000, -2.000000, 0.000000>, <-2.000000, -2.000000, 0.000000>, <-1.000000, -2.000000, 0.000000>, <-0.030899, -1.989172, 0.356795>, 
      <-3.000000, -1.000000, 0.000000>, <-2.000000, -0.978344, 0.628025>, <0.327894, -3.100637, 2.131801>, <0.643876, -2.635032, 1.314415>, 
      <-3.000000, 0.000000, 0.000000>, <-2.000000, 0.010828, 0.314013>, <0.320236, -2.100637, 2.140777>, <0.656289, -1.104459, 1.135222>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-3.000000, 0.000000, 0.000000>, <-2.000000, 0.010828, 0.314013>, <0.320236, -2.100637, 2.140777>, <0.656289, -1.104459, 1.135222>, 
      <-3.000000, 1.000000, 0.000000>, <-2.000000, 1.000000, 0.000000>, <0.312577, -1.100637, 2.149752>, <0.668701, 0.426115, 0.944409>, 
      <-3.000000, 2.000000, 0.000000>, <-2.000000, 2.000000, 0.000000>, <-1.000000, 2.000000, 0.000000>, <0.023241, 2.000000, -0.325371>, 
      <-3.000000, 3.000000, 0.000000>, <-2.000000, 3.000000, 0.000000>, <-1.000000, 3.000000, 0.000000>, <0.023241, 3.000000, -0.325371>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.030899, -2.989172, 0.356795>, <0.938201, -2.978344, 0.713589>, <1.519867, -2.978344, 3.084150>, <2.938201, -2.978344, 1.898869>, 
      <-0.030899, -1.989172, 0.356795>, <0.938201, -1.978344, 0.713589>, <1.496626, -1.978344, 3.223594>, <2.938201, -1.978344, 1.898869>, 
      <0.643876, -2.635032, 1.314415>, <0.959857, -2.169427, 0.497029>, <2.000000, -1.000000, 0.000000>, <3.000000, -1.000000, 0.000000>, 
      <0.656289, -1.104459, 1.135222>, <0.992341, -0.108280, 0.118048>, <1.767592, 0.476433, -0.055722>, <2.825694, 0.000000, -0.383473>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.656289, -1.104459, 1.135222>, <0.992341, -0.108280, 0.118048>, <1.767592, 0.476433, -0.055722>, <2.825694, 0.000000, -0.383473>, 
      <0.668701, 0.426115, 0.944409>, <1.024826, 1.952866, -0.260933>, <1.535184, 1.952866, -0.111444>, <2.651388, 1.000000, -0.766946>, 
      <0.023241, 2.000000, -0.325371>, <1.046482, 2.000000, -0.650742>, <1.535184, 2.000000, 0.906391>, <2.628147, 2.000000, -0.766946>, 
      <0.023241, 3.000000, -0.325371>, <1.046482, 3.000000, -0.650742>, <1.511943, 3.000000, 0.976113>, <2.558425, 3.000000, -0.046482>
    }
  }
  texture {
    landareatex
  }
  scale <1.643964, 1.047652, 1.0>
  rotate 96.20034*z
  translate  <10.535187, 17.567151, -0.57344>
}

object {   // HgtFld3
  height_field {
    tga "C:\Download\images\foremon.tga"
    water_level 0.0
  }
  rotate    <-90, 0, 0> 
  scale     <  2, 2,-2> 
  translate < -1,-1,-1>
  texture {
    landareatex
  }
  scale <1.963001, 2.496896, 0.553867>
  rotate <-0.842153, 6.259073, 173.330902>
  translate  <4.329488, -13.191529, -0.200592>
}

object {   // HgtFld4
  height_field {
    tga "C:\Download\images\foremon.tga"
    water_level 0.0
  }
  rotate    <-90, 0, 0> 
  scale     <  2, 2,-2> 
  translate < -1,-1,-1> 
  texture {
    landareatex
  }
  scale <5.645158, 11.669089, 1.791486>
  rotate <7.141755, 7.504114, -167.330048>
  translate  <16.657765, -3.355822, 0.366307>
}

object {   // HgtFld5
  height_field {
    tga "C:\Download\images\foremon.tga"
    water_level 0.0
  }
  rotate    <-90, 0, 0> 
  scale     <  2, 2,-2> 
  translate < -1,-1,-1> 
  texture {
    landareatex
  }
  scale <3.656526, 5.815247, 0.789376>
  rotate <-10.905691, 4.22901, -148.23262>
  translate  <-5.941241, -10.195711, 0.416052>
}

object {   // HgtFld6
  height_field {
    tga "C:\Download\images\foremon.tga"
    water_level 0.0
  }
  rotate    <-90, 0, 0> 
  scale     <  2, 2,-2> 
  translate < -1,-1,-1> 
  texture {
    landareatex
  }
  scale <2.337182, 3.28093, 0.432001>
  rotate <4.520303, -2.982094, 165.688843>
  translate  <-2.056618, -7.836693, -0.519019>
}

object {   // HgtFld7
  height_field {
    tga "C:\Download\images\foremon.tga"
    water_level 0.0
  }
  rotate    <-90, 0, 0> 
  scale     <  2, 2,-2> 
  translate < -1,-1,-1> 
  texture {
    landareatex
  }
  scale <3.119317, 5.414073, 0.841135>
  rotate <-3.898479, 5.732248, -88.516647>
  translate  <3.795818, 22.306297, 0.118734>
}

object {   // HgtFld8
  height_field {
    tga "C:\Download\images\foremon.tga"
    water_level 0.0
  }
  rotate    <-90, 0, 0>
  scale     <  2, 2,-2> 
  translate < -1,-1,-1> 
  texture {
    landareatex
  }
  scale <2.012549, 2.349286, 0.568079>
  rotate <0.332521, 0.1899, 23.547632>
  translate  <-3.303734, 0.526027, -0.146416>
}

object {   // HgtFld10
  height_field {
    tga "C:\Download\images\foremon.tga"
    water_level 0.0
  }
  rotate    <-90, 0, 0>
  scale     <  2, 2,-2> 
  translate < -1,-1,-1> 
  texture {
    landareatex
  }
  scale <8.928083, 11.511168, 1.569309>
  rotate <0.219743, -13.26494, 49.612118>
  translate  <19.360017, 13.071064, -0.73561>
}

object {   // HgtFld11
  height_field {
    tga "C:\Download\images\foremon.tga"
    water_level 0.0
  }
  rotate    <-90, 0, 0> 
  scale     <  2, 2,-2> 
  translate < -1,-1,-1> 
  texture {
    landareatex
  }
  scale <4.031843, 4.462183, 1.242583>
  rotate <-0.892756, 9.331489, -111.110199>
  translate  <4.868842, 18.690009, -0.541554>
}

object {   // HgtFld12
  height_field {
    tga "C:\Download\images\foremon.tga"
    water_level 0.0
  }
  rotate    <-90, 0, 0>
  scale     <  2, 2,-2> 
  translate < -1,-1,-1> 
  texture {
    landareatex
  }
  scale <1.915486, 2.529857, 0.918673>
  rotate <10.711421, 1.668094, 43.466503>
  translate  <8.473028, 5.868753, -0.551918>
}

union { // rock4
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-3.000000, -3.000000, 0.000000>, <-2.000000, -3.000000, 0.000000>, <-1.000000, -3.000000, 0.000000>, <-0.054140, -2.989172, 0.682166>, 
      <-3.000000, -2.000000, 0.000000>, <-2.000000, -2.000000, 0.000000>, <-1.000000, -2.000000, 0.000000>, <-0.054140, -1.989172, 0.682166>, 
      <-3.000000, -1.000000, 0.000000>, <-1.870064, -0.978344, -0.389809>, <-0.169851, -0.978344, 2.793631>, <0.689384, -0.454989, 2.208917>, 
      <-3.000000, 0.000000, 0.000000>, <-1.870064, 0.010828, -0.703822>, <-0.238429, 0.021656, 3.205096>, <0.512527, 0.516136, 2.106051>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-3.000000, 0.000000, 0.000000>, <-1.870064, 0.010828, -0.703822>, <-0.238429, 0.021656, 3.205096>, <0.512527, 0.516136, 2.106051>, 
      <-3.000000, 1.000000, 0.000000>, <-1.870064, 1.000000, -1.017834>, <-0.307006, 1.021656, 3.616561>, <0.335669, 1.487261, 2.003185>, 
      <-3.000000, 2.000000, 0.000000>, <-1.285350, 2.000000, 0.628025>, <-0.285350, 2.000000, 0.628025>, <0.357325, 2.000000, 0.314013>, 
      <-3.000000, 3.000000, 0.000000>, <-2.000000, 3.000000, 0.000000>, <-1.000000, 3.000000, 0.000000>, <0.000000, 3.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.054140, -2.989172, 0.682166>, <0.891720, -2.978344, 1.364331>, <1.891720, -2.978344, 1.364331>, <2.891720, -2.978344, 1.364331>, 
      <-0.054140, -1.989172, 0.682166>, <0.891720, -1.978344, 1.364331>, <1.891720, -1.978344, 1.364331>, <2.891720, -1.978344, 1.364331>, 
      <0.689384, -0.454989, 2.208917>, <1.548620, 0.068365, 1.624204>, <2.000000, -1.000000, 0.000000>, <3.000000, -1.000000, 0.000000>, 
      <0.512527, 0.516136, 2.106051>, <1.263482, 1.010616, 1.007006>, <2.000000, 0.476433, -0.508917>, <3.000000, 0.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.512527, 0.516136, 2.106051>, <1.263482, 1.010616, 1.007006>, <2.000000, 0.476433, -0.508917>, <3.000000, 0.000000, 0.000000>, 
      <0.335669, 1.487261, 2.003185>, <0.978344, 1.952866, 0.389809>, <2.000000, 1.952866, -1.017834>, <3.000000, 1.000000, 0.000000>, 
      <0.357325, 2.000000, 0.314013>, <1.000000, 2.000000, 0.000000>, <2.000000, 2.000000, 0.000000>, <3.000000, 2.000000, 0.000000>, 
      <0.000000, 3.000000, 0.000000>, <1.000000, 3.000000, 0.000000>, <2.000000, 3.000000, 0.000000>, <3.000000, 3.000000, 0.000000>
    }
  }
  texture {
    landareatex
  }
  scale <1.677884, 1.946057, 1.0>
  rotate 92.162193*z
  translate  <9.780554, 40.252923, -1.143942>
}

union { // rock6
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-3.000000, -3.000000, 0.000000>, <-2.000000, -3.000000, 0.000000>, <-1.000000, -3.000000, 0.000000>, <-0.054140, -2.989172, 0.682166>, 
      <-3.000000, -2.000000, 0.000000>, <-2.000000, -2.000000, 0.000000>, <-1.000000, -2.000000, 0.000000>, <-0.054140, -1.989172, 0.682166>, 
      <-3.000000, -1.000000, 0.000000>, <-1.870064, -0.978344, -0.389809>, <-0.169851, -0.978344, 2.793631>, <0.689384, -0.454989, 2.208917>, 
      <-3.000000, 0.000000, 0.000000>, <-1.870064, 0.010828, -0.703822>, <-0.238429, 0.021656, 3.205096>, <0.512527, 0.516136, 2.106051>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-3.000000, 0.000000, 0.000000>, <-1.870064, 0.010828, -0.703822>, <-0.238429, 0.021656, 3.205096>, <0.512527, 0.516136, 2.106051>, 
      <-3.000000, 1.000000, 0.000000>, <-1.870064, 1.000000, -1.017834>, <-0.307006, 1.021656, 3.616561>, <0.335669, 1.487261, 2.003185>, 
      <-3.000000, 2.000000, 0.000000>, <-1.285350, 2.000000, 0.628025>, <-0.285350, 2.000000, 0.628025>, <0.357325, 2.000000, 0.314013>, 
      <-3.000000, 3.000000, 0.000000>, <-2.000000, 3.000000, 0.000000>, <-1.000000, 3.000000, 0.000000>, <0.000000, 3.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.054140, -2.989172, 0.682166>, <0.891720, -2.978344, 1.364331>, <1.891720, -2.978344, 1.364331>, <2.891720, -2.978344, 1.364331>, 
      <-0.054140, -1.989172, 0.682166>, <0.891720, -1.978344, 1.364331>, <1.891720, -1.978344, 1.364331>, <2.891720, -1.978344, 1.364331>, 
      <0.689384, -0.454989, 2.208917>, <1.548620, 0.068365, 1.624204>, <2.000000, -1.000000, 0.000000>, <3.000000, -1.000000, 0.000000>, 
      <0.512527, 0.516136, 2.106051>, <1.263482, 1.010616, 1.007006>, <2.000000, 0.476433, -0.508917>, <3.000000, 0.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.512527, 0.516136, 2.106051>, <1.263482, 1.010616, 1.007006>, <2.000000, 0.476433, -0.508917>, <3.000000, 0.000000, 0.000000>, 
      <0.335669, 1.487261, 2.003185>, <0.978344, 1.952866, 0.389809>, <2.000000, 1.952866, -1.017834>, <3.000000, 1.000000, 0.000000>, 
      <0.357325, 2.000000, 0.314013>, <1.000000, 2.000000, 0.000000>, <2.000000, 2.000000, 0.000000>, <3.000000, 2.000000, 0.000000>, 
      <0.000000, 3.000000, 0.000000>, <1.000000, 3.000000, 0.000000>, <2.000000, 3.000000, 0.000000>, <3.000000, 3.000000, 0.000000>
    }
  }
  texture {
    landareatex
  }
  scale <2.971945, 1.654525, 1.501708>
  rotate -40.475628*z
  translate  <21.199581, 27.644325, -1.22756>
}

difference {
        
        object { surface }
        object { footprint }
        
        }