/* dpnstars.inc.  A starfield of luminous spheres (made small enough that
they don't look odd).  Tweaked a bit for newvenus scene to make sure the area 
around the origin (to about 1000 units out) was free of stars.   */


#declare Seed1 = seed(1)  //for diameters
#declare Seed2 = seed(2)  //for color 
#declare Seed3 = seed(3)  //for position
#declare Seed4 = seed(4)  //for sign changes
#declare Pi = 3.14159265
#declare BaseDistance = 5000
#declare Count = 0
#declare FallOff = -2.5

#declare StarGroup = union {


 #while (Count < 10000) 
 #declare SizeParam = rand(Seed1)

 #declare StarObject =

/* want a distribution of different sizes, don't want really big ones
(they look like disks) or really small ones (many won't show up)
function I'm using here is sin (180*x) for x a random number between
0 and 1, times a decaying exponential.  Max is around x = 0.3 or so
*/

  sphere{<0,0,0>, 10*sin(Pi*SizeParam)*(exp(FallOff*SizeParam))
  texture {

   pigment{color rgb   
    <0.8+(0.2*rand(Seed2)),
    0.8+(0.2*rand(Seed2)),
    0.8+(0.2*rand(Seed2))> 
    }

   finish {ambient 1} 
   }
  }

  #declare StarDistance = 0

   #while (StarDistance < 1000)  //prevent stars from getting close in

   #declare Star_X = (rand(Seed3)*BaseDistance)
   #if (rand(Seed4) < 0.5)
    #declare Star_X = -Star_X
    #end

   #declare Star_Y = (rand(Seed3)*BaseDistance)
   #if (rand(Seed4) < 0.5)
    #declare Star_Y = -Star_Y
    #end

   #declare Star_Z = (rand(Seed3)*BaseDistance)
   #if (rand(Seed4) < 0.5)
    #declare Star_Z = -Star_Z
    #end

   #declare StarDistance = sqrt(Star_X*Star_X + Star_Y*Star_Y + Star_Z*Star_Z)
   #end
 
 object {StarObject translate <Star_X, Star_Y, Star_Z>}

 #declare Count=Count+1
 #end

}

