/* dpntxtr.inc -- custom textures for the newvenus scene, and later ones ... */

/* some pigments, normals, and finishes first */

/* dark blue for the telescope.  Kind of like old Coulters or new Meades :-) */

#declare TelescopeBlue = pigment {
 color rgb <0.075,0.075,0.4> }

/*for when Dull is a bit too shiny ... */

#declare VeryDull = finish {
 specular 0.4 roughness 0.25
 }

/*FlatMatte is like Dull but a little bit shinier */

#declare FlatMatte = finish {
 specular 0.6 roughness 0.1  
 }

/*FlatGlossy is like Shiny */

#declare FlatGlossy = finish {
 specular 0.95 roughness 0.0005 
 }

/*PolishedGlossy = FlatGlossy + some reflection */

#declare PolishedGlossy = finish {
 specular 0.95 roughness 0.0005
 reflection 0.05
 }

/*PolishedMetal = PolishedGlossy + metallic and more reflection */


#declare PolishedMetal = finish {
 specular 0.95 roughness 0.0001 
 reflection 0.5 metallic 
 }

#declare DPNBrass1 = texture {
 pigment {color rgb <0.6,0.4,0.2>}
 finish {PolishedMetal}
 }

#declare DPNSteel1 = texture {
 pigment {color rgb <0.95,0.95,0.95>}
 finish {PolishedMetal}
 }

/* Glassy is a simple refracting finish, ior typical for glass */

#declare Glassy = finish {
   ambient 0 diffuse 0 
   reflection 0.1 specular 0.25 roughness 0.0005 
   refraction 1 ior 1.5} 

/* Similar but different ior, more like that of water */

#declare LiquidFinish = finish {
   ambient 0 diffuse 0 
   reflection 0.1 specular 0.25 roughness 0.001
   refraction 1 ior 1.35 }

/* "Glass" with no reflection */

#declare NoReflectGlassy = finish {
   ambient 0 diffuse 0 
   reflection 0 specular 0.25 roughness 0.0005 
   refraction 1 ior 1.5}
 
/* Similar, but for ice, particularly for ice cubes.  */

#declare IceTexture = texture {
 pigment {color rgbf <1,1,1,1>}
  normal {dents 5 scale 0.2}
  finish {ambient 0.025 diffuse 0.1 
          specular 0.1 roughness 0.5 reflection 0.05
          refraction 1 ior 1.3 
          fade_distance 0.25 fade_power 1}
 }

/* a wood, which I'd like to be fairly light with 1 or 2 thin, medium-dark grain "veins"  */

#declare DPNWood1 = texture {
 pigment {
 wood 
  turbulence 0.02
  color_map {
  [0 color rgb <0.9,0.9,0.7>]
  [0.24 color rgb <0.8,0.8,0.6>]
  [0.25 color rgb <0.65,0.65,0.2>]  // first vein
  [0.27 color rgb <0.8,0.8,0.6>]
  [0.35 color rgb <0.85,0.85,0.8>]
  [0.4 color rgb <0.9,0.9,0.7>]
  [0.68 color rgb <0.8,0.8,0.6>]
  [0.7 color rgb <0.6,0.6,0.2>]  // second vein
  [0.73 color rgb <0.8,0.8,0.6>]
  [0.75 color rgb <0.85,0.85,0.6>]
  [0.8 color rgb <0.9,0.9,0.7>]
  [1 color rgb <0.9,0.9,0.7>]
  }
 }
 finish {FlatMatte}
}

/* a much darker wood  */

#declare DPNWood2 = texture {
 pigment {
 wood 
  turbulence 0.03
  color_map {
  [0 color rgb <0.5,0.4,0.2>]
  [0.24 color rgb <0.4,0.3,0.1>]
  [0.25 color rgb <0.2,0.2,0.05>]  // first vein
  [0.27 color rgb <0.4,0.3,0.1>]
  [0.35 color rgb <0.5,0.4,0.2>]
  [0.4 color rgb <0.4,0.3,0.1>]
  [0.68 color rgb <0.3,0.2,0.05>]
  [0.7 color rgb <0.15,0.05,0.01>] // second vein
  [0.73 color rgb <0.3,0.2,0.05>]
  [0.75 color rgb <0.35,0.25,0.1>]
  [0.8 color rgb <0.4,0.3,0.12>]
  [1 color rgb <0.5,0.4,0.2>]
  }
 }
 finish {FlatMatte}
}



/* deep, almost ruby red with fine red-purple veins */

#declare DPNRedStone = texture {
 pigment {
  agate
  agate_turb 0.75
  color_map {
  [0 color rgb <0.6,0,0>]
  [0.3 color rgb <0.55,0,0.025>]
  [0.4 color rgb <0.5,0,0.05>]
  [0.45 color rgb <0.35,0,0.075>]
  [0.5 color rgb <0.2,0,0.1>]
  [0.55 color rgb <0.35,0,0.075>]
  [0.6 color rgb <0.5,0,0.05>]
  [0.7 color rgb <0.55,0,0.025>]
  [1 color rgb <0.6,0,0.0>]

  }
 }
 finish {PolishedGlossy}
}

/* similar, but lighter (pinker)  */

#declare DPNLightRedStone = texture {
 pigment {
  agate
  agate_turb 0.75
  color_map {
  [0 color rgb <0.8,0.3,0.2>]
  [0.3 color rgb <0.75,0.3,0.225>]
  [0.4 color rgb <0.7,0.3,0.25>]
  [0.45 color rgb <0.65,0.3,0.275>]
  [0.5 color rgb <0.5,0.3,0.3>]
  [0.55 color rgb <0.6,0.3,0.275>]
  [0.6 color rgb <0.7,0.3,0.25>]
  [0.7 color rgb <0.75,0.3,0.225>]
  [1 color rgb <0.8,0.3,0.3>]

  }
 }
 finish {PolishedGlossy}
}


/* similar, only dark blue with whitish veins */

#declare DPNBlueStone = texture {
 pigment {
  agate
  agate_turb 0.75
  color_map {
  [0 color rgb <0,0,0.6>]
  [0.3 color rgb <0.1,0.1,0.65>]
  [0.4 color rgb <0.2,0.2,0.7>]
  [0.45 color rgb <0.25,0.25,0.75>]
  [0.5 color rgb <0.7,0.7,0.8>]
  [0.55 color rgb <0.25,0.25,0.75>]
  [0.6 color rgb <0.2,0.2,0.7>]
  [0.7 color rgb <0.1,0.1,0.65>]
  [1 color rgb <0,0,0.6>]

  }
 }
 finish {PolishedGlossy}
}
/* similar, only dark green with whitish veins */

#declare DPNGreenStone = texture {
 pigment {
  agate
  agate_turb 0.75
  color_map {
  [0 color rgb <0,0.6,0>]
  [0.3 color rgb <0.1,0.65,0.1>]
  [0.4 color rgb <0.2,0.7,0.2>]
  [0.45 color rgb <0.25,0.75,0.25>]
  [0.5 color rgb <0.7,0.8,0.7>]
  [0.55 color rgb <0.25,0.75,0.25>]
  [0.6 color rgb <0.2,0.7,0.2>]
  [0.7 color rgb <0.1,0.65,0.1>]
  [1 color rgb <0,0.6,0>]

  }
 }
 finish {PolishedGlossy}
}
/* similar, lighter blue with whitish veins */

#declare DPNLightBlueStone = texture {
 pigment {
  agate
  agate_turb 0.75
  color_map {
  [0 color rgb <0.3,0.3,0.7>]
  [0.3 color rgb <0.35,0.35,0.65>]
  [0.4 color rgb <0.45,0.45,0.7>]
  [0.45 color rgb <0.5,0.5,0.75>]
  [0.5 color rgb <0.8,0.8,0.8>]
  [0.55 color rgb <0.5,0.5,0.75>]
  [0.6 color rgb <0.45,0.45,0.7>]
  [0.7 color rgb <0.35,0.35,0.65>]
  [1 color rgb <0.3,0.3,0.7>]

  }
 }
 finish {PolishedGlossy}
}

/* just plain wacky.  kind of like luminous spider webs @ turbulence ~ 0.2,
   and a sort of bizarre agate at turbulence ~ 1 */

#declare DPNCrackleWeb = texture {
 pigment {
  crackle
  turbulence 0.9
  color_map {
  [0 color rgb <1,0,1>]
  [0.5 color rgb <0,0,0>]
  [1 color rgb <1,0,1>]
  }

 }
 finish {FlatGlossy}
}

/* this looks sort of like conglomerate  */

#declare DPNCrackleStone = texture {
 pigment {
  crackle
  turbulence 1.25
  color_map {
  [0 color rgb <1,1,1>]
  [0.35 color rgb <0.8,0.8,0.9>]
  [0.5 color rgb <0.6,0.6,0.7>]
  [0.65 color rgb <0.8,0.8,0.9>]
  [1 color rgb <1,1,1>]
  }

 }
 finish {PolishedGlossy}
}

/* another deep red stone, as a granite instead of an agate */

#declare DPNRedStone2 = texture {
 pigment {
  granite
  turbulence 0.5
  color_map {
  [0 color rgb <0.6,0,0>]
  [0.3 color rgb <0.55,0,0.025>]
  [0.4 color rgb <0.5,0,0.05>]
  [0.45 color rgb <0.35,0,0.075>]
  [0.5 color rgb <0.2,0,0.1>]
  [0.55 color rgb <0.35,0,0.075>]
  [0.6 color rgb <0.5,0,0.05>]
  [0.7 color rgb <0.55,0,0.025>]
  [1 color rgb <0.6,0,0.0>]

  }
 }
 finish {PolishedGlossy}
}

/* your basic, classic granite -- white with dark inclusions */

#declare DPNWhiteStone = texture {
 pigment {
  granite
  turbulence 0.5
  color_map {
  [0 color rgb <1,1,1>]
  [0.45 color rgb <0.7,0.7,0.7>]
  [0.5 color rgb <0.3,0.3,0.3>]
  [0.55 color rgb <0.7,0.7,0.7>]
  [1 color rgb <1,1,1>]
  }

 }
 finish {PolishedGlossy}
}

/* same idea, but for a different material */

#declare DPNAcousticTile = texture {
 pigment {
  granite
  turbulence 0
  color_map {
  [0 color rgb <1,1,1>]
  [0.15 color rgb <1,1,1>]
  [0.18 color rgb <0.1,0.1,0.1>]
  [0.2 color rgb <0.1,0.1,0.1>]
  [0.23 color rgb <0.1,0.1,0.1>]
  [0.25 color rgb <1,1,1>]
  [0.75 color rgb <1,1,1>]
  [0.78 color rgb <0.1,0.1,0.1>]
  [0.8 color rgb <0.1,0.1,0.1>]
  [0.83 color rgb <0.1,0.1,0.1>]
  [0.85 color rgb <1,1,1>]
  [1 color rgb <1,1,1>]}
  }


 finish {FlatMatte}

 scale <8,1,1>   // give it a direction
}

