/* furnish.inc Furnishings of various sorts for the Venus ship lounge  ... */

/* Spotting scope.  */

//Tube dimensions

#declare TubeRad = 0.05
#declare TubeLen = 0.75
#declare TubeAngle = 0

//EndThick is for capping open cylinders at one end

#declare EndThick = 0.005

//Focuser drawtube dimensions

#declare DrawRad = 0.02
#declare DrawLen = 0.04

//Eyepiece dimensions

#declare EyeRad = 0.015
#declare EyeLen = 0.025

//Tripod dimensions

#declare HeadHeight = 0.04
#declare HeadRadius = 0.1
#declare HeadHeight2 = 0.02
#declare HeadRadius2 = 0.03
#declare LegLength = 1.25
#declare LegAngle = 15

//Tube proper ...

#declare Tube = 
 union {
  cylinder { <0,0,0>, <0,0, TubeLen>, TubeRad
   open }
  difference {
   cylinder {<0,0,0>, <0,0,EndThick>, TubeRad+CS}
   cylinder {<0,0,-CS>, <0,0,EndThick+CS>, DrawRad}  
  }

  texture {
   pigment {TelescopeBlue} 
   finish {PolishedGlossy}
   }
 }

 //Drawtube ...

#declare Drawtube =  union {

  cylinder { <0,0,0>, <0,0,DrawLen>, DrawRad
   open }
  difference {
   cylinder {<0,0,0>, <0,0,EndThick>, DrawRad+CS}
   cylinder {<0,0,-CS>, <0,0,EndThick+CS>, EyeRad}
   } 
  texture {DPNSteel1}
  translate <0,0,-(DrawLen+CS)>
  }

//Eyepiece

#declare Eyepiece =  cylinder { 

  <0,0,0>, <0,0,EyeLen>, EyeRad
   open
  texture {pigment {color Gray10} finish {PolishedMetal}}
  translate <0,0,-(DrawLen+EyeLen+CS)> }

//Focusing knobs

#declare Knob = union {
 
  cylinder {
  <0,0,0>, <0.025,0,0>, 0.01
  texture {pigment {color rgb <0.05,0.05,0.05> }} 
  } 

  cylinder {
   <0.025,0,0>,<0.0251,0,0>, 0.02
   texture {pigment {color Black} finish {FlatGlossy}} 
  } 

  translate <(0.05-CS), 0, 0> }
 
#declare MainTube = union {
 object {Tube}
 object {Drawtube}
 object {Eyepiece}
 object {Knob}
 object {Knob rotate z*180}
 }

/*

Optics...More for completeness's sake since they aren't likely to be seen
in the final scene

 Lens maker's eqn:  1/f = (n-1) (1/r' - 1/r''), 

for simple spherical lenses r' = -r'' so 1/f = (n-1) (2/r).
and for an n (index of refraction, ior in POV-Ray talk) of 1.5  
 1/f = 1/r

*/


#declare EyeSphereRad = DrawLen + EyeLen
#declare MainSphereRad = TubeLen

/* Figure out how large to make each lens, from the intersection of two spheres.    Have to make a lens-shaped segment of the same radius as the telescope tube      (and of the eyepiece).

*/

#declare EyeDist = EyeSphereRad * cos (asin(EyeRad/EyeSphereRad))
#declare MainDist = MainSphereRad * cos (asin(TubeRad/MainSphereRad))

#declare Eyesphere = 
  sphere { <0,0,0>, EyeSphereRad
  texture {
   pigment {color rgbf <1,1,1,1>}           
   finish {Glassy}
  } 
 }

#declare Objectsphere = 
 sphere { <0,0,0>, MainSphereRad
 texture {
  pigment {color rgbf <1,1,1,1>} 
  finish {Glassy}
  } 
 }

#declare Eyelens = intersection {
  object {Eyesphere translate <0,0,-EyeDist>}
  object {Eyesphere translate <0,0,EyeDist>} 
  }

#declare Mainlens = intersection {
  object {Objectsphere translate <0,0,-MainDist>}
  object {Objectsphere translate <0,0,MainDist>} 
  }

//put everthing together.

#declare OpticalTube = union {
   object {MainTube}
   object {Eyelens translate <0,0,-(DrawLen+EyeLen+CS)> }
   object {Mainlens translate <0,0,TubeLen-CS> }
} 

// Make simple tripod and mount ... first the fork

#declare ForkHeight = 0.15
#declare ForkWidth = 2*TubeRad+0.04
#declare ForkPieceSep = 2*TubeRad + 0.02

#declare ForkPiece = union {

//Fork prongs ...

  prism {
   linear_sweep linear_spline -0.01 0.01
   5, <0, -0.03>, <0,0.03>, <ForkHeight, 0.01>, <ForkHeight, -0.01>, <0, -0.03>
   texture {
    pigment {TelescopeBlue} 
    finish {FlatGlossy}
    }
   rotate z*90 translate <ForkPieceSep/2, 0, 0> }

//Fork bearings...

  cylinder { <0,0,0>, <0.01,0,0>, 0.02
   texture {
    pigment {color White*0.85} 
    finish {PolishedGlossy}
    } 
   translate <ForkPieceSep/2 - 0.01, ForkHeight, 0> 
   }

} // ForkPiece union

//Put the fork together

#declare Fork = union {
 object {ForkPiece }
 object {ForkPiece rotate y*180}
 box {<-ForkWidth/2, 0, -0.03>, <ForkWidth/2, 0.02, 0.03>}
}

//Add the tube to the fork, tilting it by an angle wrt. vertical as desired

#declare TubeAndFork = union {
 object {OpticalTube translate <0,0,-TubeLen/2> rotate -x*TubeAngle}
 object {Fork translate <0,-(ForkHeight), 0>}
}

//Make the rest of the tripod

#declare TripodHead = union {

 cylinder {<0,CS,0>, <0,HeadHeight,0>, HeadRadius
  texture {
   pigment {TelescopeBlue} 
   finish {FlatMatte}
  }
 }

 cylinder {<0,HeadHeight-CS,0>, <0,HeadHeight+HeadHeight2,0>, HeadRadius2
  texture {
   pigment {TelescopeBlue} 
   finish {FlatMatte}
  } 
 }

} //TripodHead union

//Tripod legs...

#declare TripodLeg = 

 cylinder {<0,CS*2,0>, <0,-LegLength,0>, 0.015
  texture {DPNSteel1}
  rotate z*15
  translate <HeadRadius*0.8,0,0>
 }

//assemble the tripod

#declare Tripod = union {
  object {TripodHead}
  object {TripodLeg rotate y*0}
  object {TripodLeg rotate y*120}
  object {TripodLeg rotate y*240}
 }

//and the entire scope

#declare Scope = union {
  object {Tripod translate <0,-(HeadHeight+HeadHeight2), 0>}
  object {TubeAndFork translate <0,ForkHeight,0>}
  translate <0,LegLength/cos(radians(LegAngle)),0>
 }

//just in case we want to look at a target (provided tube is horizontal ...
//...don't feel like figuring it out for arbitrary tube angle)

#declare OpticalAxisHeight = LegLength/cos(radians(LegAngle))+ForkHeight

/* Table... */

#declare TableHeight = 0.8
#declare TableRadius = 0.75
#declare TableThickness = 0.05
#declare BracketThickness = 0.005

#declare TableBaseTexture = texture {DPNWhiteStone scale 0.2}
#declare TableBracketTexture = texture {DPNBrass1}
#declare TableTopTexture = texture {DPNWhiteStone scale 0.1}

//make the base -- a smoothly tapering thing:

#declare TableBase = lathe {
 cubic_spline 9,
 <0.35*TableRadius, 0*TableHeight>,     //ctrl point
 <0.5*TableRadius, 0*TableHeight>,
 <0.5*TableRadius, 0.05*TableHeight>,
 <0.35*TableRadius, 0.1*TableHeight>,
 <0.2*TableRadius, 0.2*TableHeight>,
 <0.1*TableRadius, 0.4*TableHeight>,
 <0.08*TableRadius, 0.5*TableHeight>,
 <0.05*TableRadius, 1.01*TableHeight>,
 <0*TableRadius, 1.01*TableHeight>     // ctrl point
 texture {TableBaseTexture}
}

//and the support brackets.

#declare TableBracket = prism {

 linear_spline 0, BracketThickness, 11

  <0.01*TableRadius,0*TableHeight>,
  <0.03*TableRadius,0*TableHeight>,
  <0.13*TableRadius, 0.05*TableHeight>,
  <0.3*TableRadius, 0.06*TableHeight>,
  <0.5*TableRadius, 0.07*TableHeight>,
  <0.7*TableRadius, 0.075*TableHeight>,
  <0.9*TableRadius, 0.08*TableHeight>,
  <0.9*TableRadius, 0.1*TableHeight>,
  <0.5*TableRadius,0.1*TableHeight>,
  <0.01*TableRadius, 0.1*TableHeight>,
  <0.01*TableRadius, 0*TableHeight>

  texture {TableBracketTexture}
  translate <0,-BracketThickness/2,0>
  rotate <-90,0,0> 
  translate <0,TableHeight*0.91,0>
 }

//collect the brackets together

#declare TableBracketSet = union {
 #declare Count = 0
 #declare Brackets = 4

 #while (Count < Brackets)

  object {TableBracket rotate y*Count*360/Brackets}
  #declare Count = Count + 1

 #end 

 } // TableBracketSet union

//Table top -- a simple cylinder

#declare TableTop = cylinder {
 <0,0,0>, <0,TableThickness, 0>, TableRadius
 texture {TableTopTexture}
 translate <0,TableHeight,0>
 }

//put 'em all together

#declare Table = union {
 object {TableBase}
 object {TableBracketSet}
 object {TableTop}
}

/*Chairs ... */

//Phi and SeatHeight determine the overall shape:  Phi the angle the diagonals
//of the X-frame legs make with the seat, and SeatHeight for the overall height
//of the legs.

#declare Phi = 50
#declare SeatHeight = 0.5

#declare SeatLength = SeatHeight / tan(radians(Phi))
#declare SeatWidth = SeatHeight
#declare AngleBarLength = SeatHeight / sin(radians(Phi))
#declare XBlobThick = 0.025
#declare FrameThick = 0.01
#declare SeatThick = 0.025

#declare BackHeight = 0.55
#declare BackWidth = SeatWidth
#declare BackThickness = 0.025

//"Blobbing" cylinders together is easier than trying to make a special
//"weld" object at the intersection

#declare XBlob = blob {
 threshold 0.7
 cylinder {<-SeatLength/2,SeatHeight/2,0>,<SeatLength/2,SeatHeight/2,0>, 
    XBlobThick, 0.9}
 cylinder {<-SeatLength/2,-SeatHeight/2,0>,<SeatLength/2,-SeatHeight/2,0>,
    XBlobThick, 0.9 }
 cylinder {<-AngleBarLength/2,0,0>,<AngleBarLength/2,0,0>, 
            XBlobThick, 0.9 rotate z*Phi}
 cylinder {<-AngleBarLength/2,0,0>,<AngleBarLength/2,0,0>, 
            XBlobThick, 0.9 rotate z*-Phi}

 texture {DPNSteel1}
  
 }  //XBlob union

#declare Legs = union {
  object {XBlob translate <0,0,-SeatWidth/2>}
  object {XBlob translate <0,0,SeatWidth/2>}
 }

//Frame underneath the seat:

#declare Counter = 0
#declare Increments = 8
#declare Frame = union {
#declare Ratio = SeatLength/SeatWidth

  #while (Counter <= (SeatWidth))
   cylinder {<-SeatLength/2+(Counter*Ratio), 0, -SeatWidth/2>, 
             <-SeatLength/2+(Counter*Ratio), 0, SeatWidth/2>, FrameThick}
   cylinder {<-SeatLength/2, 0,-SeatWidth/2+(Counter)>, 
             <SeatLength/2, 0, -SeatWidth/2+(Counter)>, FrameThick}
  #declare Counter = Counter + SeatWidth/Increments
  #end
  texture {DPNSteel1} 
  translate <0,SeatHeight/2+FrameThick, 0>
 }

//Seat proper

#declare Seat =  object {
  box {<-SeatLength/2, 0, -SeatWidth/2>, <SeatLength/2, SeatThick, SeatWidth/2>

   texture { 
    pigment {color Red*0.5} 
    finish {FlatGlossy}
   }
  translate <0,SeatHeight/2+FrameThick, 0>}
}


//Seatback:

#declare Back = difference {

 box {<0,-CS,-(BackWidth/2 - CS)>, <BackThickness, BackHeight, BackWidth/2 - CS>
  texture {DPNWood1 translate <50,0,0> scale 0.1 rotate 90*y}
  }

 cylinder { <0,0,0>, <0,BackHeight+CS,0>, 2 

  texture { 
   pigment {color Red*0.5 } 
   finish {FlatGlossy}

 }

 translate <2+0.01,0,0> 
 }

 rotate z*10
 translate <-SeatLength/2, SeatHeight/2+FrameThick, 0>
}

//put it all together

#declare Chair = union {
 object {Legs}
 object {Frame}
 object {Seat}
 object {Back}
 translate <0,SeatHeight/2, 0>
}

/* stuff to put on tables ... */

/*The scrabble game is pretty complex, so it gets its own
  include file, game.inc ... */

/* Glassware ... */

#declare TumblerHeight = 0.15
#declare TumblerOuterRadius1 = 0.05
#declare TumblerOuterRadius2 = 0.045
#declare TumblerInnerRadius1 = 0.0475
#declare TumblerInnerRadius2 = 0.0425
#declare TumblerBase = 0.02
#declare LiquidHeight = 0.10


#declare TumblerTexture = texture {
 pigment {color rgbf <1,1,1,0.99> }
 finish {ambient 0 diffuse 0 reflection 0.05 specular 0.5 roughness 0.001
         refraction 1 ior 1.5 }
 }

//Several different liquids...


//A red wine or cherry juice ...
#declare LiquidColor1 = pigment {color rgbf <1,0.1,0.3,0.8> }

//Cola?

#declare LiquidColor2 = pigment {color rgbf <0.4,0.3,0,0.9> }

//White wine or lemonade?

#declare LiquidColor3 = pigment {color rgbf <1,1,0.6,0.95> }



#declare LiquidTexture1 = texture {
 pigment {LiquidColor1} finish {LiquidFinish }
}

#declare LiquidTexture2 = texture {
 pigment {LiquidColor2 }  finish {LiquidFinish } 
}

#declare LiquidTexture3 = texture {
 pigment {LiquidColor3 }  finish {LiquidFinish }
}


#declare OuterCone = cone { <0,TumblerHeight,0>,TumblerOuterRadius1,       
       <0,CS,0>,TumblerOuterRadius2 }

#declare InnerCone = cone {<0,TumblerHeight+CS,0>,TumblerInnerRadius1,
       <0,TumblerBase,0>,TumblerInnerRadius2 }

#declare Tumbler = difference {

  object {OuterCone texture {TumblerTexture}}
  object {InnerCone texture {TumblerTexture}}
  }

#declare Liquid1 = intersection {
 object {InnerCone}
 plane {y, LiquidHeight}
 scale 1-CS  
 texture {LiquidTexture1}
 }

#declare Liquid2 = intersection {
 object {InnerCone}
 plane {y, LiquidHeight}
 scale 1-CS  
 texture {LiquidTexture2}
 }

#declare Liquid3 = intersection {
 object {InnerCone}
 plane {y, LiquidHeight}
 scale 1-CS  
 texture {LiquidTexture3}
 }

#declare FilledGlass1 = union {
 object {Tumbler}
 object {Liquid1}
}
#declare FilledGlass2 = union {
 object {Tumbler}
 object {Liquid2}
 }
#declare FilledGlass3 = union {
 object {Tumbler}
 object {Liquid3}
}

