/* lights.inc:  declare some realistic light fixtures for newvenus.pov
Each fixture contains one "fluorescent tube", FluorLight, simulated by a long area light.  Use TestLight (a point source) for test renderings

*/

#declare LightRodLength = 1
#declare LightRodRadius = 0.01
#declare LightBoxLength = LightRodLength*1.2
#declare LightBoxWidth = 0.25
#declare LightBoxDepth = 0.05
#declare PaneDepth = 0.02

//shape of the fluorescent bulb

#declare LightRod = cylinder {
  <-LightRodLength/2,0,0> <LightRodLength/2,0,0>, LightRodRadius
  texture {
   pigment {color rgb <0.9,0.9,1>}
   finish {ambient 1 diffuse 0.8}
   }
  }



//lighting parameters of the fluorescent bulb

#declare FluorLight =
   light_source {<0,0,0> color rgb <0.8,0.9,1>*0.5 
   area_light 
   <LightRodLength,0,0>, <0,0,LightRodRadius>, 
   3, 1
   adaptive 1 jitter 
   looks_like {LightRod}
  }

//test light -- same shape as real thing but no area light

#declare TestLight = 
   light_source {<0,0,0> color rgb <0.9,0.9,1>*0.5 
   looks_like {LightRod}
 }

//fill light:  weak, shadowless?

#declare FillLight =
   light_source {<0,0,0> color White*0.25 shadowless
    translate <MainRoomLength/2, MainRoomHeight/2, MainRoomDepth/2>
   }

//fixture.  make walls translucent

#declare LightBox = box {
  <-LightBoxLength/2, 0, -LightBoxWidth/2>, 
  <LightRodLength/2, LightBoxDepth, LightBoxWidth/2>
  texture {
   pigment {color rgbf <1,1,1,0.2>}
   finish {ambient 0.8 diffuse 0.8 phong 0.5 phong_size 10
           refraction 1 ior 1.5 fade_distance 0.01*LightBoxDepth}
   }
  }

/* Will make the fixture  hollow by differencing it with a slightly smaller
   version of itself

*/

#declare LightBox2 = object {LightBox scale <0.99,1,0.99>}

/* want the light to get out, but for variety (and more diffuse lighting) will
   make the texture of the glass pane highly irregular.

*/

#declare Pane = box { <-LightBoxLength/2-CS,-CS,-LightBoxWidth/2-CS>,   
  <LightBoxLength/2+CS,PaneDepth+CS,LightBoxWidth/2+CS>
  texture {
   pigment {color rgbf <1,1,1,1>}
   normal {ripples 0.5 scale 0.01 turbulence 0.5}
   finish {ambient 0 diffuse 0 reflection 0.1 specular 0.5 roughness 0.01
    refraction 1 ior 1.25}
   }
  }

//put it all together

#declare LightFixtureBox = merge {
 difference {
  object {LightBox}
  object {LightBox2 translate <0,-CS,0>}
  }
 object {Pane translate <0,-PaneDepth, 0>}
 }

#declare LightFixture = union {
 object {LightFixtureBox}
 object {FluorLight translate <0,(LightBoxDepth/2-LightRodRadius),0>}
 }

