/* roomwall.inc:  objects making up most of the newvenus scene lounge
   area */

//Basic dimensions of the lounge.

#declare MainRoomHeight = 3
#declare MainRoomLength = 15
#declare MainRoomDepth = 6

//The octagons are used to cut holes in one wall for windows.

#declare Octagons = 3
#declare OctaSep = MainRoomLength/Octagons
#declare OctaHeight1 = MainRoomHeight*0.90
#declare OctaHeight2 = MainRoomHeight*0.85
#declare OctaWidth1 = OctaSep * 0.98
#declare OctaWidth2 = OctaSep * 0.95

//Window parameters:

#declare FrameThickness = 0.5
#declare GlassThickness = 0.2

//Floor, wall, and ceiling textures:

#declare FloorTexture = 
  texture {pigment{color White} finish {VeryDull}}
#declare LeftWallTexture = 
  texture {pigment {color rgb <0.5,0.5,0.4>} finish {VeryDull}}
#declare RightWallTexture = 
  texture {pigment {color rgb <0.5,0.5,0.4>} finish {VeryDull}}
#declare BackWallTexture = 
  texture {pigment {color rgb <0.5,0.5,0.4>} finish {VeryDull}} 

#declare CeilingTexture = 

 texture {
  checker 
   texture {DPNAcousticTile scale 0.2}, 
   texture {DPNAcousticTile scale 0.2 rotate y*90}
   scale 0.5
 }

//Window area textures:

#declare WindowFrameTexture = 
  texture { 
   pigment {color Gray50} finish {FlatGlossy}
   }  
#declare OctagonTexture = 
  texture {
   pigment {color White} 
   finish {FlatGlossy} 
   }
#declare WindowGlassTexture = 
  texture {
   pigment {color rgbt <1,1,1,1>}
   finish {NoReflectGlassy} 
   }

#declare CarpetTexture = texture {
  pigment {color Tan}
  normal {bumps 0.9 scale 0.0005}
  }

/* Make the octagons, which will define the windows. */

#declare Octagon = prism {
 linear_sweep linear_spline 
 -FrameThickness-CS, FrameThickness+CS 

  9 <-OctaWidth2/2, OctaHeight1/2>, <-OctaWidth1/2,OctaHeight2/2>,
    <-OctaWidth1/2, -OctaHeight2/2>, <-OctaWidth2/2,-OctaHeight1/2>,
    <OctaWidth2/2, -OctaHeight1/2>, <OctaWidth1/2,-OctaHeight2/2>,
    <OctaWidth1/2, OctaHeight2/2>, <OctaWidth2/2,OctaHeight1/2>,
    <-OctaWidth2/2, OctaHeight1/2>
  texture {OctagonTexture}
  rotate -x*90 translate <OctaSep/2, MainRoomHeight/2,0>
 }


#declare WindowFrame = difference {
  box {<0,0,0>, <MainRoomLength,MainRoomHeight+0.01,FrameThickness>
   texture {WindowFrameTexture}
  }
 
 #declare Count = 0
 #while (Count < Octagons)

  object {Octagon translate <Count*OctaSep,0,0>}
  #declare Count = Count + 1

 #end

} //window frame difference

#declare WindowPane = box {
 <-CS, -CS, -CS>, <MainRoomLength+CS,MainRoomHeight+CS, GlassThickness>
 texture {WindowGlassTexture}
 }
 
#declare Window = merge {
 object {WindowFrame}
 object {WindowPane translate <0,0,0.05>}
 }

//for test renderings, just render the frame, without glass

//object {WindowFrame translate <0,0,MainRoomDepth>}
object {Window translate <0,0,MainRoomDepth>}


//Define the walls, floors, and ceilings:  simple infinitesimally-thick
//planes are fine for this (except the back wall)


#declare LeftWall = object {
 Square_X 
  scale <1,0.5,0.5> 
  translate <0,0.5,0.5>
  scale <1, MainRoomHeight, MainRoomDepth>
  texture {LeftWallTexture}
 }

#declare RightWall = object {
 Square_X 
  scale <1,0.5,0.5>
  translate <0,0.5,0.5>
  scale <1, MainRoomHeight, MainRoomDepth>
  translate <MainRoomLength,0,0>
  texture {RightWallTexture}
 }

#declare Floor = object {
 Square_Y texture {FloorTexture}
  scale <0.5,1,0.5>
  translate <0.5,0,0.5>
  scale <MainRoomLength, 1, MainRoomDepth>
  texture {FloorTexture}
 }
 

#declare Ceiling = object {
 Square_Y
  scale <0.5,1,0.5>
  translate <0.5,0,0.5>
  scale <MainRoomLength, 1, MainRoomDepth>
  translate <0,MainRoomHeight,0>
  texture {CeilingTexture}
  }

//make the floor a little more interesting.  Edge controls how far
//the carpet is from the walls

#declare Edge = 0.90

#declare Carpet = box {
 <0,0,-CS>, <1,1,CS>     
 texture {CarpetTexture}
 rotate x*90 
 scale <MainRoomLength,1,MainRoomDepth>*Edge 
 translate <MainRoomLength*(1-Edge)/2, 0, MainRoomDepth*(1-Edge)/2>
 }


/* Back wall -- has thickness -- there's an open doorway in it and two walls
behind it to make a "hallway".  This isn't part of the scene in newvenus but
is put in there for (a) later ideas involving more rooms and (b) protection against unwanted light sources getting into the room (e.g., with a Sun object
behind the room -- only want it to illuminate the planet) */

#declare Back = box {
 <0,0,-0.15>,<MainRoomLength, MainRoomHeight, 0> 
}

#declare Doorway = 
 box { <0,0,-(0.15+CS)>, <1,2.25,CS> translate <6,0,0>  
 }


#declare BackWall = union {
  object {LeftWall translate <5.5-CS, 0, -MainRoomDepth-CS>}
  object {RightWall translate <-7.5+CS, 0, -MainRoomDepth-CS>}

   difference {
  object {Back}
  object {Doorway}
   }

  texture {BackWallTexture}
  }

//Assemble the room... 

#declare Room = union {
  object {WindowFrame translate <0,0,MainRoomDepth>}
  object {LeftWall} 
  object {RightWall}
  object {Floor} 
  object {Carpet}
  object {Ceiling}
  object {BackWall}
 }
