/* scrbrd2.inc... */

/*original scrabbleboard.inc used a difference to make raised edges around
each square.  Most of the time this isn't necessary.  Use this with scrbtile.inc, rack.inc, and dpntxtr.inc.

The board is four-fold symmetric about the center, so only need to make a quarter of it, then rotate that 4 times to get the final result.

*/

#declare SquareSize = 1.5
#declare TopSquareSize = 1.4  
#declare Border = (SquareSize-TopSquareSize)/2 
#declare SquareThickness = 0.05

#declare BottomThickness = 0.2
#declare BottomTexture = 
 texture {
  pigment  {color Gray20}
  finish {Dull}
  }

/*Back of the board. Give it a 1-square margin on all sides */

#declare BottomLayer = 
  box {
   <-SquareSize,-SquareSize,-CS>, 
   <SquareSize*16, SquareSize*16,BottomThickness+CS> 
   texture {BottomTexture}
  }


/* Square colors.  
   "Normal" values:  Regular: Tan; DLS:  rgb 0.5,0.5,1; TLS:  Blue;
                     DWS and Center: rgb 1,0.5,0.5;  TWS: Red

   Textures for newvenus are nice appropriately-colored stones.

*/

#declare TopRegularTexture = 
 texture{DPNWhiteStone
 }

#declare TopDLSTexture = 
 texture {DPNLightBlueStone
 }

#declare TopDWSTexture = 
 texture {DPNLightRedStone
 }

//the center square is a special DWS...

#declare TopCenterTexture = 
 texture {DPNLightRedStone
 }


#declare TopTLSTexture = 
 texture {DPNBlueStone
 }

#declare TopTWSTexture = 
 texture {DPNRedStone
 }



/*  This is a mess.  POV-Ray isn't really a programming language. 
    Here, I'm making each column of a quarter of the board.  POV-Ray 3.1
    supports two-dimensional arrays, which would make this much    
    cleaner and easier... */

#declare Count = 0
#declare Quadrant = union {
 #while (Count < 7)

   #switch (Count)
   #case (0)
  
      object {
      box {<(Count*SquareSize+Border),(SquareSize*0+Border), 0>,
           <((Count+1)*SquareSize-Border),((SquareSize*1)-Border), 0.01>
           texture {TopDLSTexture}}
      }

      object {
      box {<(Count*SquareSize+Border),(SquareSize*1+Border), 0>,
           <((Count+1)*SquareSize-Border),((SquareSize*2)-Border), 0.01>
           texture {TopRegularTexture}}
      }

      object {
      box {<(Count*SquareSize+Border),(SquareSize*2+Border), 0>,
           <((Count+1)*SquareSize-Border),((SquareSize*3)-Border), 0.01>
           texture {TopRegularTexture}}
      }

      object {
      box {<(Count*SquareSize+Border),(SquareSize*3+Border), 0>,
           <((Count+1)*SquareSize-Border),((SquareSize*4)-Border), 0.01>
           texture {TopRegularTexture}}
      }
  
      object { 
      box {<(Count*SquareSize+Border),(SquareSize*4+Border), 0>,
           <((Count+1)*SquareSize-Border),((SquareSize*5)-Border), 0.01>
           texture {TopDLSTexture}}
      }

      object {
      box {<(Count*SquareSize+Border),(SquareSize*5+Border), 0>,
           <((Count+1)*SquareSize-Border),((SquareSize*6)-Border), 0.01>
           texture {TopRegularTexture}} 
      }

      object {
      box {<(Count*SquareSize+Border),(SquareSize*6+Border), 0>,
           <((Count+1)*SquareSize-Border),((SquareSize*7)-Border), 0.01>
           texture {TopRegularTexture}}

      }
   #break
   #case (1)  
      object {
      box {<(Count*SquareSize+Border),(SquareSize*0+Border), 0>,
           <((Count+1)*SquareSize-Border),((SquareSize*1)-Border), 0.01>
           texture {TopRegularTexture}}
      }

      object {
      box {<(Count*SquareSize+Border),(SquareSize*1+Border), 0>,
           <((Count+1)*SquareSize-Border),((SquareSize*2)-Border), 0.01>
           texture {TopTLSTexture}}
      }

      object {
      box {<(Count*SquareSize+Border),(SquareSize*2+Border), 0>,
           <((Count+1)*SquareSize-Border),((SquareSize*3)-Border), 0.01>
           texture {TopRegularTexture}}
      }

      object {
      box {<(Count*SquareSize+Border),(SquareSize*3+Border), 0>,
           <((Count+1)*SquareSize-Border),((SquareSize*4)-Border), 0.01>
           texture {TopRegularTexture}}
      }
  
      object { 
      box {<(Count*SquareSize+Border),(SquareSize*4+Border), 0>,
           <((Count+1)*SquareSize-Border),((SquareSize*5)-Border), 0.01>
           texture {TopRegularTexture}}
      }

      object {
      box {<(Count*SquareSize+Border),(SquareSize*5+Border), 0>,
           <((Count+1)*SquareSize-Border),((SquareSize*6)-Border), 0.01>
           texture {TopTLSTexture}} 
      }

      object {
      box {<(Count*SquareSize+Border),(SquareSize*6+Border), 0>,
           <((Count+1)*SquareSize-Border),((SquareSize*7)-Border), 0.01>
           texture {TopRegularTexture}}

      }

   #break
   #case(2) 
      object {
      box {<(Count*SquareSize+Border),(SquareSize*0+Border), 0>,
           <((Count+1)*SquareSize-Border),((SquareSize*1)-Border), 0.01>
           texture {TopRegularTexture}}
      }

      object {
      box {<(Count*SquareSize+Border),(SquareSize*1+Border), 0>,
           <((Count+1)*SquareSize-Border),((SquareSize*2)-Border), 0.01>
           texture {TopRegularTexture}}
      }

      object {
      box {<(Count*SquareSize+Border),(SquareSize*2+Border), 0>,
           <((Count+1)*SquareSize-Border),((SquareSize*3)-Border), 0.01>
           texture {TopDWSTexture}}
      }

      object {
      box {<(Count*SquareSize+Border),(SquareSize*3+Border), 0>,
           <((Count+1)*SquareSize-Border),((SquareSize*4)-Border), 0.01>
           texture {TopRegularTexture}}
      }
  
      object { 
      box {<(Count*SquareSize+Border),(SquareSize*4+Border), 0>,
           <((Count+1)*SquareSize-Border),((SquareSize*5)-Border), 0.01>
           texture {TopRegularTexture}}
      }

      object {
      box {<(Count*SquareSize+Border),(SquareSize*5+Border), 0>,
           <((Count+1)*SquareSize-Border),((SquareSize*6)-Border), 0.01>
           texture {TopRegularTexture}} 
      }

      object {
      box {<(Count*SquareSize+Border),(SquareSize*6+Border), 0>,
           <((Count+1)*SquareSize-Border),((SquareSize*7)-Border), 0.01>
           texture{TopRegularTexture}}

      }
      #break

      #case (3) 
      object {
      box {<(Count*SquareSize+Border),(SquareSize*0+Border), 0>,
           <((Count+1)*SquareSize-Border),((SquareSize*1)-Border), 0.01>
           texture {TopRegularTexture}}
      }

      object {
      box {<(Count*SquareSize+Border),(SquareSize*1+Border), 0>,
           <((Count+1)*SquareSize-Border),((SquareSize*2)-Border), 0.01>
           texture {TopRegularTexture}}
      }

      object {
      box {<(Count*SquareSize+Border),(SquareSize*2+Border), 0>,
           <((Count+1)*SquareSize-Border),((SquareSize*3)-Border), 0.01>
           texture {TopRegularTexture}}
      }

      object {
      box {<(Count*SquareSize+Border),(SquareSize*3+Border), 0>,
           <((Count+1)*SquareSize-Border),((SquareSize*4)-Border), 0.01>
           texture {TopDWSTexture}}
      }
  
      object { 
      box {<(Count*SquareSize+Border),(SquareSize*4+Border), 0>,
           <((Count+1)*SquareSize-Border),((SquareSize*5)-Border), 0.01>
           texture {TopRegularTexture}}
      }

      object {
      box {<(Count*SquareSize+Border),(SquareSize*5+Border), 0>,
           <((Count+1)*SquareSize-Border),((SquareSize*6)-Border), 0.01>
           texture {TopRegularTexture}} 
      }

      object {
      box {<(Count*SquareSize+Border),(SquareSize*6+Border), 0>,
           <((Count+1)*SquareSize-Border),((SquareSize*7)-Border), 0.01>
           texture {TopDLSTexture}}

      }
     #break 
     #case (4) 
      object {
      box {<(Count*SquareSize+Border),(SquareSize*0+Border), 0>,
           <((Count+1)*SquareSize-Border),((SquareSize*1)-Border), 0.01>
           texture {TopDLSTexture}}
      }

      object {
      box {<(Count*SquareSize+Border),(SquareSize*1+Border), 0>,
           <((Count+1)*SquareSize-Border),((SquareSize*2)-Border), 0.01>
           texture {TopRegularTexture}}
      }

      object {
      box {<(Count*SquareSize+Border),(SquareSize*2+Border), 0>,
           <((Count+1)*SquareSize-Border),((SquareSize*3)-Border), 0.01>
           texture {TopRegularTexture}}
      }

      object {
      box {<(Count*SquareSize+Border),(SquareSize*3+Border), 0>,
           <((Count+1)*SquareSize-Border),((SquareSize*4)-Border), 0.01>
           texture {TopRegularTexture}}
      }
  
      object { 
      box {<(Count*SquareSize+Border),(SquareSize*4+Border), 0>,
           <((Count+1)*SquareSize-Border),((SquareSize*5)-Border), 0.01>
           texture {TopDWSTexture}}
      }

      object {
      box {<(Count*SquareSize+Border),(SquareSize*5+Border), 0>,
           <((Count+1)*SquareSize-Border),((SquareSize*6)-Border), 0.01>
           texture {TopRegularTexture}} 
      }

      object {
      box {<(Count*SquareSize+Border),(SquareSize*6+Border), 0>,
           <((Count+1)*SquareSize-Border),((SquareSize*7)-Border), 0.01>
           texture {TopRegularTexture}}

      }
   
    #break
    #case (5) 

     object {
      box {<(Count*SquareSize+Border),(SquareSize*0+Border), 0>,
           <((Count+1)*SquareSize-Border),((SquareSize*1)-Border), 0.01>
           texture {TopRegularTexture}}
      }

      object {
      box {<(Count*SquareSize+Border),(SquareSize*1+Border), 0>,
           <((Count+1)*SquareSize-Border),((SquareSize*2)-Border), 0.01>
           texture {TopTLSTexture}}
      }

      object {
      box {<(Count*SquareSize+Border),(SquareSize*2+Border), 0>,
           <((Count+1)*SquareSize-Border),((SquareSize*3)-Border), 0.01>
           texture {TopRegularTexture}}
      }

      object {
      box {<(Count*SquareSize+Border),(SquareSize*3+Border), 0>,
           <((Count+1)*SquareSize-Border),((SquareSize*4)-Border), 0.01>
           texture {TopRegularTexture}}
      }
  
      object { 
      box {<(Count*SquareSize+Border),(SquareSize*4+Border), 0>,
           <((Count+1)*SquareSize-Border),((SquareSize*5)-Border), 0.01>
           texture {TopRegularTexture}}
      }

      object {
      box {<(Count*SquareSize+Border),(SquareSize*5+Border), 0>,
           <((Count+1)*SquareSize-Border),((SquareSize*6)-Border), 0.01>
           texture {TopDWSTexture}} 
      }

      object { 
      box {<(Count*SquareSize+Border),(SquareSize*6+Border), 0>,
           <((Count+1)*SquareSize-Border),((SquareSize*7)-Border), 0.01>
           texture {TopRegularTexture}}

      }
     #break   
     #case(6)

      object {
      box {<(Count*SquareSize+Border),(SquareSize*0+Border), 0>,
           <((Count+1)*SquareSize-Border),((SquareSize*1)-Border), 0.01>
           texture {TopRegularTexture}}
      }

      object {
      box {<(Count*SquareSize+Border),(SquareSize*1+Border), 0>,
           <((Count+1)*SquareSize-Border),((SquareSize*2)-Border), 0.01>
           texture {TopRegularTexture}}
      }

      object {
      box {<(Count*SquareSize+Border),(SquareSize*2+Border), 0>,
           <((Count+1)*SquareSize-Border),((SquareSize*3)-Border), 0.01>
           texture {TopRegularTexture}}
      }

      object {
      box {<(Count*SquareSize+Border),(SquareSize*3+Border), 0>,
           <((Count+1)*SquareSize-Border),((SquareSize*4)-Border), 0.01>
           texture {TopDLSTexture}}
      }
  
      object { 
      box {<(Count*SquareSize+Border),(SquareSize*4+Border), 0>,
           <((Count+1)*SquareSize-Border),((SquareSize*5)-Border), 0.01>
           texture {TopRegularTexture}}
      }

      object {
      box {<(Count*SquareSize+Border),(SquareSize*5+Border), 0>,
           <((Count+1)*SquareSize-Border),((SquareSize*6)-Border), 0.01>
           texture {TopRegularTexture}} 
      }

      object {
      box {<(Count*SquareSize+Border),(SquareSize*6+Border), 0>,
           <((Count+1)*SquareSize-Border),((SquareSize*7)-Border), 0.01>
           texture {TopTWSTexture}}

      }
      #break

   #end // #switch...

 #declare Count = Count + 1
 #end //Count...

}

/* A Scrabble board is 15x15, so there's an odd column and row passing through the center.  They have to be made separately.  */

#declare Column = union {

     object {     
      box {<(Border),(SquareSize*0+Border), 0>,
           <(SquareSize-Border),((SquareSize*1)-Border), 0.01>
           texture {TopRegularTexture}}
      }
    
     object {       
      box {<(Border),(SquareSize*1+Border), 0>,
           <(SquareSize-Border),((SquareSize*2)-Border), 0.01>
           texture {TopRegularTexture}}
      }
      
     object {     
      box {<(Border),(SquareSize*2+Border), 0>,
           <(SquareSize-Border),((SquareSize*3)-Border), 0.01>
           texture {TopRegularTexture}}
      }
     object {     
      box {<(Border),(SquareSize*3+Border), 0>,
           <(SquareSize-Border),((SquareSize*4)-Border), 0.01>
           texture {TopDLSTexture}}
      }
   
     object { 
      box {<(Border),(SquareSize*4+Border), 0>,
           <(SquareSize-Border),((SquareSize*5)-Border), 0.01>
           texture {TopRegularTexture}}
      }
 
     object {
      box {<(Border),(SquareSize*5+Border), 0>,
           <(SquareSize-Border),((SquareSize*6)-Border), 0.01>
           texture {TopRegularTexture}}
      }
   
     object { 
      box {<(Border),(SquareSize*6+Border), 0>,
           <(SquareSize-Border),((SquareSize*7)-Border), 0.01>
           texture {TopTWSTexture}}
      }
  }


#declare Board = union {

  object {BottomLayer translate   
     <-SquareSize*15/2,-SquareSize*15/2,-BottomThickness>}

  object {Quadrant translate <SquareSize/2, SquareSize/2, 0>}
  object {Quadrant translate <SquareSize/2, SquareSize/2, 0> rotate z*90}
  object {Quadrant translate <SquareSize/2, SquareSize/2, 0> rotate z*180}
  object {Quadrant translate <SquareSize/2, SquareSize/2, 0> rotate z*270}

  object {Column translate <-SquareSize/2,SquareSize/2,0>}
  object {Column translate <-SquareSize/2,SquareSize/2,0> rotate z*90}
  object {Column translate <-SquareSize/2,SquareSize/2,0> rotate z*180}
  object {Column translate <-SquareSize/2,SquareSize/2,0> rotate z*270}

  box {<((-SquareSize+Border)/2),((-SquareSize+Border)/2), 0>,
           <((SquareSize-Border)/2),((SquareSize-Border)/2), 0.01>
           texture {TopCenterTexture}}
 
  rotate -x*90 // flip it to x-z plane
  translate <0,BottomThickness,0>
 
}

