/* venus.inc: creates a realistic terraformed Venus from a spherical heightfield.  Heightfield generated by ORB, by J. Beale.  Settings:

 orb venus-terra.gif venus-orb2.inc 1.03 8

then a "#declare VenusSurface = mesh { ... }" added around the Orb
output to make it acceptable to POV-Ray. Renamed to venusorb.inc

load venusorb.inc in, or before, this (venus.inc) file

*/

#include "include/venusorb.inc"

// special texture for the Venusian surface.  Brown with some green

#declare LandTexture = texture { 
 pigment {
  granite
   turbulence 0.5
   color_map
   {[0.0  color rgb <0.025, 0.05, 0>]
    [0.2  color rgb <0.05, 0.05, 0>]    
    [0.4   color rgb <0.1, 0.1, 0.05> ]                
    [0.55   color rgb <0.15, 0.1, 0.1> ]                 
    [0.6   color rgb <0.2, 0.15, 0.1>]                  
    [0.65   color rgb <0.2, 0.1, 0.05>]                  
    [0.8  color rgb <0.1, 0.1, 0.05>]
    [1 color rgb <0.1, 0.05, 0>]                   
   }
  }
 finish {diffuse 0.6 specular 0.2 roughness 0.5}
 }


#declare TestSphere = sphere {<0,0,0>, 1 
  texture {LandTexture scale 0.25}}

//Need a light source.  We'll make a Sunlike one.  

#declare Sun = sphere {
  <0,0,-1000000>, 10000
  pigment {color rgb <1.0 1.0 0.8>}
  finish {ambient 1 diffuse .6}
 }

light_source { <-600,0,-200> color rgb <1.0 1.0 0.8>*1.75 looks_like {Sun} }


//Clouds.  Inspired by some of the POV-Ray 3.0 docs, then heavily
//modified.


#declare Clouds1 = pigment {
  
  agate
  agate_turb 0.5
  color_map {
    [0.0 color White filter 1]
    [0.1 color White filter 0.75]
    [0.2 color White filter 0.5]
    [0.3 color White filter 0.25]
    [0.4 color White filter 0.5]
    [0.5 color White filter 0.75]
    [0.6 color White filter 1]
    [0.7 color White filter 0.5]
    [0.8 color White filter 0.25]
    [0.9 color White filter 0.75]
    [1.0 color White filter 1]
    }
     
  scale 1
  }
 
#declare Clouds2 = pigment {
  marble
  turbulence 0.75
  color_map {
    [0.0 color White filter 1]
    [0.05 color White filter 1]
    [0.1 color White filter 0.85]
    [0.2 color White filter 0.6]
    [0.35 color White filter 0.85]
    [0.45 color White filter 1]
    [0.5 color White filter 1]
    [0.6 color White filter 0.85]
    [0.7 color White filter 0.6]
    [0.8 color White filter 0.85]
    [0.9 color White filter 1]
    [1.0 color White filter 1]
    }
  scale 2
  }

#declare Clouds3 = pigment {
  granite
  turbulence 0.5
  color_map {
    [0.0 color White filter 0.95]
    [0.15 color White filter 0.65]
    [0.2 color White filter 0.35]
    [0.25 color White filter 0.65]
    [0.4 color White filter 0.95]
    [0.5 color White filter 0.95]
    [0.65 color White filter 0.65]
    [0.7 color White filter 0.35]
    [0.75 color White filter 0.65]
    [1.0 color White filter 0.95]
    }
  scale 3
  }

#declare CloudLayer = texture {
  pigment {
    gradient y
     pigment_map {
      [0.00 Clouds3]    
      [0.50 Clouds2]       
      [1.00 Clouds3]
      }
     }
   }

//Venus is just a bunch of layered objects and textures.

#declare Venus = union {

//First an ocean, slightly larger than the minimum radius of the spherical
//heightfield.  "Floods" about 2/3 of the planet, so it looks like Earth
//(more or less)

sphere {<0,0,0>, 1.06
  texture {
  pigment {color rgb <0,0.1,0.2>} 
  finish {specular 0.2 roughness 0.05 ambient 0.05 diffuse 0.9}}
 }

//Add an atmosphere (sort of).  Make it a little hazy...

sphere {<0,0,0>, 1.1
  hollow
  texture {CloudLayer}
  halo {
   attenuating 
   spherical_mapping linear
   color_map {
   [0 color rgbt <1,1,1,1>]
   [1 color rgbt <1,1,1,0.6>]
   }
  samples 10
  } 
 }

//Finally add the land.

/* the x-rotation of 90 degrees is necessary to get the Orb spherical 
heightfield to have its north pole along +y.  the y-rotation is needed to
get the "venusmap" topographic map to line up with the heightfield, if this
image map is used as a pigment.   */


object {VenusSurface 
 rotate <90,180,0>
 texture {LandTexture scale 0.2} 
 }

//end union

}
