#include "colors.inc"
#include "textures.inc"
#include "finish.inc"
#include "include/dpntxtr.inc"
#include "include/dpnstars.inc"

background {color Black}

camera {location <0,0,-50> look_at <0,0,0>}

light_source {<0,0,-100> color White*2}

#declare Earth = sphere { <0,0,0>, 6
  pigment {image_map {gif "earthmap.gif" map_type 1}}
  finish {FlatGlossy}
  }

#declare Venus = sphere { <0,0,0>,6 
  pigment {image_map {gif "ventopo.gif" map_type 1}}
  finish {FlatGlossy}
  }

#declare TextInfo = union {

#declare Title = text {
 ttf "timrom.ttf", "ISHTAR LINES", 0.1, 0
 translate <-3.4,2,0>
 scale 8
 pigment {color Red}
 }
 object {Title}

#declare SubTitle = union {
 text {
  ttf "cyrvetic.ttf", "Maiden", 0.1, 0
  translate <-2,0,-10>
  scale 2.5
  pigment {color Turquoise*0.4}
  }
 text {
  ttf "cyrvetic.ttf", "Earth-Venus Voyage", 0.1, 0
  translate <-4.3,-1,-10>
  scale 2.5
  pigment {color Turquoise*0.4}
  }
text {
  ttf "cyrvetic.ttf", "Arrival:  July 20, 2969", 0.1, 0
  translate <-5.5,-3,-10>
  scale 2
  pigment {color rgb <0,0.3,0.2>}
  }


 }
 object {SubTitle}
} 

object {Earth rotate y*150 translate <-24,0,0>}
object {Venus rotate -y*100 translate <24,0,0>}
object {StarGroup}
object {TextInfo}
