//  Persistance of Vision Raytracer V3.0
//  World definition file.
//
//  Contains 2 lights, 12 textures and 39 primitives.
//
//  This file was generated for POV-Ray V3.0 by
//  MORAY.EXE V2.5b.wat(c) 1991-1995 Lutz + Kretzschmar
//

//  Date : 12/18/1998    (18.12.1998)
//

//
//  This is the standard include file for POV-Ray. It is included with
//  every scene that Moray exports for POV-Ray.
//





global_settings {
  adc_bailout 0.003922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 1.8
  hf_gray_16 off
  irid_wavelength <0.25,0.18,0.14>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
  radiosity {
    brightness       3.3
    count            100
    distance_maximum 0.0
    error_bound      0.4
    gray_threshold   0.5
    low_error_factor 0.8
    minimum_reuse    0.015
    nearest_count    6
    recursion_limit  1
  }
}

background { color <0.000,0.000,0.000> }

fog {
  fog_type 2    // Ground Fog
  distance     10.0
  color <0.925,0.634,0.601,0.082,0.87>
  turbulence   <5.0,2.0,1.0>
    omega      0.2
    lambda     3.0
    octaves    4
    turb_depth 3.0
  up           <0,0,1>
  fog_offset   0.0
  fog_alt      5.0
}

camera {  //  Camera StdCam
  location  <-3.517, -8.293, 3.587>
  direction <0.0,     0.0,  1.8317>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333, 0.0,  0.0>
  look_at   <-0.387, 0.242, 0.182>
}

// *******  L I G H T S *******
light_source {   // Light1
  <32.722, -17.150, 31.408>
  color rgb <1.067, 1.067, 1.067>
}


// ********  TEXTURES  *******
//

#include "oh.inc"



// ********  REFERENCED OBJECTS  *******



// ********  OBJECTS  *******

sphere { // Sphere003
  <0,0,0>,1
  texture {
    Chrome_Textur1
  }
  scale <1.0, 1.34909, 2.234951>
  rotate <3.857782, 1.024943, -121.557587>
  translate  <-2.2, -5.02298, -1.001494>
}


cylinder { // Cylndr2
  <0,0,1>, <0,0,0>, 1 
  texture {
    Chrome_Textur1
  }
  scale <0.5, 0.5, 5.0>
  rotate <1.785027, 3.056472, -6.793169>
  translate  <-3.0, -4.570084, -6.351509>
}


cylinder { // Cylndr001
  <0,0,1>, <0,0,0>, 1 
  texture {
    Chrome_Textur1
  }
  scale <0.5, 0.5, 5.0>
  rotate <-1.471339, -1.83674, 0.00472>
  translate  <-1.5, -4.919678, -6.351509>
}


sphere { // Sphere002
  <0,0,0>,1
  texture {
    stars
  }
  hollow
  scale 1000.0
}


torus { // Torus001
  1.5, 0.5  rotate -x*90
  texture {
    Chrome_Textur1
  }
  scale 0.387904
  translate  <-2.082698, -4.938361, 1.023116>
}


#declare CSG003 = difference {
  box { // Cube003
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Chrome_Textur1
    }
    scale 1.520668
    translate  <-1.992832, -4.934973, 1.951081>
  }
  sphere { // Sphere5
    <0,0,0>,1
    texture {
      Chrome_Textur1
    }
    scale <2.115343, 1.076998, 0.669717>
    rotate -30.537348*z
    translate  <-2.344365, -5.418062, 2.328668>
  }
}
#declare Kopf = intersection {
  sphere { // Sphere3
    <0,0,0>,1
    texture {
      Chrome_Textur1
    }
    scale 1.05
    translate  <-2.07008, -4.929279, 2.106465>
  }
  object { CSG003 }
}
union { // Group001
  object { Kopf }
  sphere { // Sphere001
    <0,0,0>,1
    texture {
      Glass1
    }
    translate  <-2.07008, -4.929279, 2.106465>
  }
}


union { // BzPtch001
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-3.000000, -3.000000, 0.000000>, <-2.000000, -3.000000, 0.000000>, <-1.000000, -3.000000, 0.000000>, <0.000000, -3.000000, 0.000000>, 
      <-3.000000, -2.000000, 0.000000>, <-2.000000, -2.000000, 0.000000>, <-1.000000, -2.000000, 0.000000>, <0.000000, -2.000000, 0.000000>, 
      <-3.000000, -1.000000, 0.000000>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.000000, 0.000000, 0.000000>, <-2.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <0.000000, 0.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-3.000000, 0.000000, 0.000000>, <-2.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <0.000000, 0.000000, 0.000000>, 
      <-3.000000, 1.000000, 0.000000>, <-2.000000, 1.000000, 0.000000>, <-1.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, 
      <-3.000000, 2.000000, 0.000000>, <-2.000000, 2.000000, 0.000000>, <-1.000000, 2.000000, 0.000000>, <0.000000, 2.000000, 0.000000>, 
      <-3.000000, 3.000000, 0.000000>, <-2.000000, 3.000000, 0.000000>, <-1.000000, 3.000000, 0.000000>, <0.000000, 3.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.000000, -3.000000, 0.000000>, <1.000000, -3.000000, 0.000000>, <2.000000, -3.000000, 0.000000>, <3.000000, -3.000000, 0.000000>, 
      <0.000000, -2.000000, 0.000000>, <1.000000, -2.000000, 0.000000>, <2.000000, -2.000000, 0.000000>, <3.000000, -2.000000, 0.000000>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.000000, -1.000000, 0.000000>, 
      <0.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <2.000000, 0.000000, 0.000000>, <3.000000, 0.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <2.000000, 0.000000, 0.000000>, <3.000000, 0.000000, 0.000000>, 
      <0.000000, 1.000000, 0.000000>, <1.000000, 1.000000, 0.000000>, <2.000000, 1.000000, 0.000000>, <3.000000, 1.000000, 0.000000>, 
      <0.000000, 2.000000, 0.000000>, <1.000000, 2.000000, 0.000000>, <2.000000, 2.000000, 0.000000>, <3.000000, 2.000000, 0.000000>, 
      <0.000000, 3.000000, 0.000000>, <1.000000, 3.000000, 0.000000>, <2.000000, 3.000000, 0.000000>, <3.000000, 3.000000, 0.000000>
    }
  }
  texture {
    Cork2
  }
  scale 159.184113
  translate  <-9.332553, 0.0, -5.977655>
}






#declare Koerper = union { 
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 4 v_steps 4,
      <-0.530446, 0.000000, 0.507725>, <-0.530446, 0.000000, 0.507725>, <-0.530446, 0.000000, 0.507725>, <-0.530446, 0.000000, 0.507725>, 
      <-1.469176, 0.000000, 0.852379>, <-1.469176, -0.550000, 0.852379>, <-1.046748, -1.000000, 0.697285>, <-0.530446, -1.000000, 0.507725>, 
      <-1.229308, 0.000000, 1.807883>, <-1.229308, -0.613158, 1.807883>, <-0.737855, -1.114833, 1.619687>, <-0.137190, -1.114833, 1.389670>, 
      <-0.911595, 0.000000, 2.138277>, <-0.904455, -0.471123, 2.138277>, <-0.523255, -0.856588, 2.026084>, <-0.018072, -0.856588, 1.835406>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 4 v_steps 4,
      <-0.530446, 0.000000, 0.507725>, <-0.530446, 0.000000, 0.507725>, <-0.530446, 0.000000, 0.507725>, <-0.530446, 0.000000, 0.507725>, 
      <-0.530446, -1.000000, 0.507725>, <-0.014145, -1.000000, 0.318165>, <0.408283, -0.550000, 0.163071>, <0.408283, 0.000000, 0.163071>, 
      <-0.137190, -1.114833, 1.389670>, <0.463475, -1.114833, 1.159653>, <0.954928, -0.613158, 0.971457>, <0.954928, 0.000000, 0.971457>, 
      <-0.018072, -0.856588, 1.835406>, <0.494251, -0.856588, 1.644729>, <0.875451, -0.471123, 1.532536>, <0.875451, 0.000000, 1.532536>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 4 v_steps 4,
      <-0.530446, 0.000000, 0.507725>, <-0.530446, 0.000000, 0.507725>, <-0.530446, 0.000000, 0.507725>, <-0.530446, 0.000000, 0.507725>, 
      <0.408283, 0.000000, 0.163071>, <0.408283, 0.550000, 0.163071>, <-0.014145, 1.000000, 0.318165>, <-0.530446, 1.000000, 0.507725>, 
      <0.954928, 0.000000, 0.971457>, <0.954928, 0.613158, 0.971457>, <0.463475, 1.114833, 1.159653>, <-0.137190, 1.114833, 1.389670>, 
      <0.875451, 0.000000, 1.532536>, <0.875451, 0.471123, 1.532536>, <0.494251, 0.856588, 1.644729>, <-0.018072, 0.856588, 1.835406>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 4 v_steps 4,
      <-0.530446, 0.000000, 0.507725>, <-0.530446, 0.000000, 0.507725>, <-0.530446, 0.000000, 0.507725>, <-0.530446, 0.000000, 0.507725>, 
      <-0.530446, 1.000000, 0.507725>, <-1.046748, 1.000000, 0.697285>, <-1.469176, 0.550000, 0.852379>, <-1.469176, 0.000000, 0.852379>, 
      <-0.137190, 1.114833, 1.389670>, <-0.737855, 1.114833, 1.619687>, <-1.229308, 0.613158, 1.807883>, <-1.229308, 0.000000, 1.807883>, 
      <-0.018072, 0.856588, 1.835406>, <-0.523255, 0.856588, 2.026084>, <-0.904455, 0.471123, 2.138277>, <-0.911595, 0.000000, 2.138277>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 4 v_steps 4,
      <-0.911595, 0.000000, 2.138277>, <-0.904455, -0.471123, 2.138277>, <-0.523255, -0.856588, 2.026084>, <-0.018072, -0.856588, 1.835406>, 
      <-0.579602, 0.000000, 2.468670>, <-0.579602, -0.329089, 2.468670>, <-0.308655, -0.598343, 2.432480>, <0.108186, -0.598343, 2.281143>, 
      <0.023961, 0.000000, 2.445108>, <0.023961, -0.258126, 2.445108>, <0.228327, -0.469320, 2.459007>, <0.478109, -0.469320, 2.475994>, 
      <-0.258479, 0.000000, 2.663879>, <-0.258479, -0.400474, 2.663879>, <0.065736, -0.728135, 2.685928>, <0.461999, -0.728135, 2.712878>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 4 v_steps 4,
      <-0.018072, -0.856588, 1.835406>, <0.494251, -0.856588, 1.644729>, <0.875451, -0.471123, 1.532536>, <0.875451, 0.000000, 1.532536>, 
      <0.108186, -0.598343, 2.281143>, <0.525026, -0.598343, 2.129805>, <0.795973, -0.329089, 2.093615>, <0.795973, 0.000000, 2.093615>, 
      <0.478109, -0.469320, 2.475994>, <0.727890, -0.469320, 2.492981>, <0.932257, -0.258126, 2.506879>, <0.932257, 0.000000, 2.506879>, 
      <0.461999, -0.728135, 2.712878>, <0.858261, -0.728135, 2.739827>, <1.182476, -0.400474, 2.761876>, <1.182476, 0.000000, 2.761876>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 4 v_steps 4,
      <0.875451, 0.000000, 1.532536>, <0.875451, 0.471123, 1.532536>, <0.494251, 0.856588, 1.644729>, <-0.018072, 0.856588, 1.835406>, 
      <0.795973, 0.000000, 2.093615>, <0.795973, 0.329089, 2.093615>, <0.525026, 0.598343, 2.129805>, <0.108186, 0.598343, 2.281143>, 
      <0.932257, 0.000000, 2.506879>, <0.932257, 0.258126, 2.506879>, <0.727890, 0.469320, 2.492981>, <0.478109, 0.469320, 2.475994>, 
      <1.182476, 0.000000, 2.761876>, <1.182476, 0.400474, 2.761876>, <0.858261, 0.728135, 2.739827>, <0.461999, 0.728135, 2.712878>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 4 v_steps 4,
      <-0.018072, 0.856588, 1.835406>, <-0.523255, 0.856588, 2.026084>, <-0.904455, 0.471123, 2.138277>, <-0.911595, 0.000000, 2.138277>, 
      <0.108186, 0.598343, 2.281143>, <-0.308655, 0.598343, 2.432480>, <-0.579602, 0.329089, 2.468670>, <-0.579602, 0.000000, 2.468670>, 
      <0.478109, 0.469320, 2.475994>, <0.228327, 0.469320, 2.459007>, <0.023961, 0.258126, 2.445108>, <0.023961, 0.000000, 2.445108>, 
      <0.461999, 0.728135, 2.712878>, <0.065736, 0.728135, 2.685928>, <-0.258479, 0.400474, 2.663879>, <-0.258479, 0.000000, 2.663879>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 4 v_steps 4,
      <-0.258479, 0.000000, 2.663879>, <-0.258479, -0.400474, 2.663879>, <0.065736, -0.728135, 2.685928>, <0.461999, -0.728135, 2.712878>, 
      <-0.540918, 0.000000, 2.882651>, <-0.540918, -0.542822, 2.882651>, <-0.096855, -0.986949, 2.912850>, <0.445889, -0.986949, 2.949761>, 
      <-0.579810, 0.000000, 4.024893>, <-0.579810, -0.550000, 4.024893>, <-0.130847, -1.000000, 4.055426>, <0.417885, -1.000000, 4.092744>, 
      <0.417885, 0.000000, 4.092744>, <0.417885, 0.000000, 4.092744>, <0.417885, 0.000000, 4.092744>, <0.417885, 0.000000, 4.092744>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 4 v_steps 4,
      <0.461999, -0.728135, 2.712878>, <0.858261, -0.728135, 2.739827>, <1.182476, -0.400474, 2.761876>, <1.182476, 0.000000, 2.761876>, 
      <0.445889, -0.986949, 2.949761>, <0.988632, -0.986949, 2.986672>, <1.432695, -0.542822, 3.016872>, <1.432695, 0.000000, 3.016872>, 
      <0.417885, -1.000000, 4.092744>, <0.966618, -1.000000, 4.130063>, <1.415581, -0.550000, 4.160596>, <1.415581, 0.000000, 4.160596>, 
      <0.417885, 0.000000, 4.092744>, <0.417885, 0.000000, 4.092744>, <0.417885, 0.000000, 4.092744>, <0.417885, 0.000000, 4.092744>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 4 v_steps 4,
      <1.182476, 0.000000, 2.761876>, <1.182476, 0.400474, 2.761876>, <0.858261, 0.728135, 2.739827>, <0.461999, 0.728135, 2.712878>, 
      <1.432695, 0.000000, 3.016872>, <1.432695, 0.542822, 3.016872>, <0.988632, 0.986949, 2.986672>, <0.445889, 0.986949, 2.949761>, 
      <1.415581, 0.000000, 4.160596>, <1.415581, 0.550000, 4.160596>, <0.966618, 1.000000, 4.130063>, <0.417885, 1.000000, 4.092744>, 
      <0.417885, 0.000000, 4.092744>, <0.417885, 0.000000, 4.092744>, <0.417885, 0.000000, 4.092744>, <0.417885, 0.000000, 4.092744>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 4 v_steps 4,
      <0.461999, 0.728135, 2.712878>, <0.065736, 0.728135, 2.685928>, <-0.258479, 0.400474, 2.663879>, <-0.258479, 0.000000, 2.663879>, 
      <0.445889, 0.986949, 2.949761>, <-0.096855, 0.986949, 2.912850>, <-0.540918, 0.542822, 2.882651>, <-0.540918, 0.000000, 2.882651>, 
      <0.417885, 1.000000, 4.092744>, <-0.130847, 1.000000, 4.055426>, <-0.579810, 0.550000, 4.024893>, <-0.579810, 0.000000, 4.024893>, 
      <0.417885, 0.000000, 4.092744>, <0.417885, 0.000000, 4.092744>, <0.417885, 0.000000, 4.092744>, <0.417885, 0.000000, 4.092744>
    }
  }
  texture {
    braun
  }
}
#declare Scbnurhaar2 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 3 v_steps 3,
      <-1.000000, 0.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, 
      <1.552469, 0.000000, 2.021837>, <1.552469, -0.472527, 2.021837>, <2.710364, -0.472527, 2.021837>, <2.710364, 0.000000, 2.021837>, 
      <1.915731, 0.000000, 4.064891>, <1.915731, -0.157509, 4.064891>, <2.347103, -0.157509, 4.064891>, <2.347103, 0.000000, 4.064891>, 
      <0.000000, 0.000000, 6.000000>, <0.000000, 0.000000, 6.000000>, <0.000000, 0.000000, 6.000000>, <0.000000, 0.000000, 6.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 3 v_steps 3,
      <1.000000, 0.000000, 0.000000>, <1.000000, 1.000000, 0.000000>, <-1.000000, 1.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, 
      <2.710364, 0.000000, 2.021837>, <2.710364, 0.472527, 2.021837>, <1.552469, 0.472527, 2.021837>, <1.552469, 0.000000, 2.021837>, 
      <2.347103, 0.000000, 4.064891>, <2.347103, 0.157509, 4.064891>, <1.915731, 0.157509, 4.064891>, <1.915731, 0.000000, 4.064891>, 
      <0.000000, 0.000000, 6.000000>, <0.000000, 0.000000, 6.000000>, <0.000000, 0.000000, 6.000000>, <0.000000, 0.000000, 6.000000>
    }
  }
  texture {
    schwarz
  }
  scale <0.02, 0.02, 0.2>
  rotate <-179.389984, 85.000916, -94.253403>
  translate  <1.35, 0.15, 1.85>
}
#declare Scbnurhaar1 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 3 v_steps 3,
      <-1.000000, 0.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, 
      <1.552469, 0.000000, 2.021837>, <1.552469, -0.472527, 2.021837>, <2.710364, -0.472527, 2.021837>, <2.710364, 0.000000, 2.021837>, 
      <1.915731, 0.000000, 4.064891>, <1.915731, -0.157509, 4.064891>, <2.347103, -0.157509, 4.064891>, <2.347103, 0.000000, 4.064891>, 
      <0.000000, 0.000000, 6.000000>, <0.000000, 0.000000, 6.000000>, <0.000000, 0.000000, 6.000000>, <0.000000, 0.000000, 6.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 3 v_steps 3,
      <1.000000, 0.000000, 0.000000>, <1.000000, 1.000000, 0.000000>, <-1.000000, 1.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, 
      <2.710364, 0.000000, 2.021837>, <2.710364, 0.472527, 2.021837>, <1.552469, 0.472527, 2.021837>, <1.552469, 0.000000, 2.021837>, 
      <2.347103, 0.000000, 4.064891>, <2.347103, 0.157509, 4.064891>, <1.915731, 0.157509, 4.064891>, <1.915731, 0.000000, 4.064891>, 
      <0.000000, 0.000000, 6.000000>, <0.000000, 0.000000, 6.000000>, <0.000000, 0.000000, 6.000000>, <0.000000, 0.000000, 6.000000>
    }
  }
  texture {
    schwarz
  }
  scale <0.02, 0.02, 0.2>
  rotate <0.405737, 84.999535, 85.473923>
  translate  <1.35, 0.2, 1.95>
}
#declare Scbnurhaar = union { 
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 3 v_steps 3,
      <-1.000000, 0.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, 
      <1.552469, 0.000000, 2.021837>, <1.552469, -0.472527, 2.021837>, <2.710364, -0.472527, 2.021837>, <2.710364, 0.000000, 2.021837>, 
      <1.915731, 0.000000, 4.064891>, <1.915731, -0.157509, 4.064891>, <2.347103, -0.157509, 4.064891>, <2.347103, 0.000000, 4.064891>, 
      <0.000000, 0.000000, 6.000000>, <0.000000, 0.000000, 6.000000>, <0.000000, 0.000000, 6.000000>, <0.000000, 0.000000, 6.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 3 v_steps 3,
      <1.000000, 0.000000, 0.000000>, <1.000000, 1.000000, 0.000000>, <-1.000000, 1.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, 
      <2.710364, 0.000000, 2.021837>, <2.710364, 0.472527, 2.021837>, <1.552469, 0.472527, 2.021837>, <1.552469, 0.000000, 2.021837>, 
      <2.347103, 0.000000, 4.064891>, <2.347103, 0.157509, 4.064891>, <1.915731, 0.157509, 4.064891>, <1.915731, 0.000000, 4.064891>, 
      <0.000000, 0.000000, 6.000000>, <0.000000, 0.000000, 6.000000>, <0.000000, 0.000000, 6.000000>, <0.000000, 0.000000, 6.000000>
    }
  }
  texture {
    schwarz
  }
  scale <0.02, 0.02, 0.2>
  rotate <0.556147, 75.000465, 85.487434>
  translate  <1.3, 0.05, 2.05>
}
#declare Schnurhaare = union {
  object { Scbnurhaar2 }
  object { Scbnurhaar1 }
  object { Scbnurhaar }
  translate  1.1*z
}
#declare Scbnurhaar3 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 3 v_steps 3,
      <-1.000000, 0.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, 
      <1.552469, 0.000000, 2.021837>, <1.552469, -0.472527, 2.021837>, <2.710364, -0.472527, 2.021837>, <2.710364, 0.000000, 2.021837>, 
      <1.915731, 0.000000, 4.064891>, <1.915731, -0.157509, 4.064891>, <2.347103, -0.157509, 4.064891>, <2.347103, 0.000000, 4.064891>, 
      <0.000000, 0.000000, 6.000000>, <0.000000, 0.000000, 6.000000>, <0.000000, 0.000000, 6.000000>, <0.000000, 0.000000, 6.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 3 v_steps 3,
      <1.000000, 0.000000, 0.000000>, <1.000000, 1.000000, 0.000000>, <-1.000000, 1.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, 
      <2.710364, 0.000000, 2.021837>, <2.710364, 0.472527, 2.021837>, <1.552469, 0.472527, 2.021837>, <1.552469, 0.000000, 2.021837>, 
      <2.347103, 0.000000, 4.064891>, <2.347103, 0.157509, 4.064891>, <1.915731, 0.157509, 4.064891>, <1.915731, 0.000000, 4.064891>, 
      <0.000000, 0.000000, 6.000000>, <0.000000, 0.000000, 6.000000>, <0.000000, 0.000000, 6.000000>, <0.000000, 0.000000, 6.000000>
    }
  }
  texture {
    schwarz
  }
  scale <0.02, 0.02, 0.2>
  rotate <-179.389984, 85.000916, -94.253403>
  translate  <1.35, 0.15, 1.85>
}
#declare Scbnurhaar4 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 3 v_steps 3,
      <-1.000000, 0.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, 
      <1.552469, 0.000000, 2.021837>, <1.552469, -0.472527, 2.021837>, <2.710364, -0.472527, 2.021837>, <2.710364, 0.000000, 2.021837>, 
      <1.915731, 0.000000, 4.064891>, <1.915731, -0.157509, 4.064891>, <2.347103, -0.157509, 4.064891>, <2.347103, 0.000000, 4.064891>, 
      <0.000000, 0.000000, 6.000000>, <0.000000, 0.000000, 6.000000>, <0.000000, 0.000000, 6.000000>, <0.000000, 0.000000, 6.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 3 v_steps 3,
      <1.000000, 0.000000, 0.000000>, <1.000000, 1.000000, 0.000000>, <-1.000000, 1.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, 
      <2.710364, 0.000000, 2.021837>, <2.710364, 0.472527, 2.021837>, <1.552469, 0.472527, 2.021837>, <1.552469, 0.000000, 2.021837>, 
      <2.347103, 0.000000, 4.064891>, <2.347103, 0.157509, 4.064891>, <1.915731, 0.157509, 4.064891>, <1.915731, 0.000000, 4.064891>, 
      <0.000000, 0.000000, 6.000000>, <0.000000, 0.000000, 6.000000>, <0.000000, 0.000000, 6.000000>, <0.000000, 0.000000, 6.000000>
    }
  }
  texture {
    schwarz
  }
  scale <0.02, 0.02, 0.2>
  rotate <0.405737, 84.999535, 85.473923>
  translate  <1.35, 0.2, 1.95>
}
#declare Scbnurhaar5 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 3 v_steps 3,
      <-1.000000, 0.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, 
      <1.552469, 0.000000, 2.021837>, <1.552469, -0.472527, 2.021837>, <2.710364, -0.472527, 2.021837>, <2.710364, 0.000000, 2.021837>, 
      <1.915731, 0.000000, 4.064891>, <1.915731, -0.157509, 4.064891>, <2.347103, -0.157509, 4.064891>, <2.347103, 0.000000, 4.064891>, 
      <0.000000, 0.000000, 6.000000>, <0.000000, 0.000000, 6.000000>, <0.000000, 0.000000, 6.000000>, <0.000000, 0.000000, 6.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 3 v_steps 3,
      <1.000000, 0.000000, 0.000000>, <1.000000, 1.000000, 0.000000>, <-1.000000, 1.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, 
      <2.710364, 0.000000, 2.021837>, <2.710364, 0.472527, 2.021837>, <1.552469, 0.472527, 2.021837>, <1.552469, 0.000000, 2.021837>, 
      <2.347103, 0.000000, 4.064891>, <2.347103, 0.157509, 4.064891>, <1.915731, 0.157509, 4.064891>, <1.915731, 0.000000, 4.064891>, 
      <0.000000, 0.000000, 6.000000>, <0.000000, 0.000000, 6.000000>, <0.000000, 0.000000, 6.000000>, <0.000000, 0.000000, 6.000000>
    }
  }
  texture {
    schwarz
  }
  scale <0.02, 0.02, 0.2>
  rotate <0.556147, 75.000465, 85.487434>
  translate  <1.3, 0.05, 2.05>
}
#declare Schnurhaare1 = union {
  object { Scbnurhaar3 }
  object { Scbnurhaar4 }
  object { Scbnurhaar5 }
  scale -1.0
  rotate <-180.0, 0.0, -180.0>
  translate  1.1*z
}
#declare Blume1 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 4 v_steps 4,
      <2.058938, -0.000793, 0.626362>, <2.058938, -0.155099, 0.626362>, <1.301969, -0.281349, 0.667563>, <0.969838, -0.281349, 0.646709>, 
      <0.236254, -0.001155, 0.449373>, <0.236254, -0.385602, 0.449373>, <0.744094, -0.700149, 0.530253>, <0.461831, -0.615269, 0.537603>, 
      <-1.681303, 0.448878, 0.678735>, <-1.681303, 0.063458, 0.678735>, <-1.225811, -0.251885, 0.731419>, <-0.975884, -0.239814, 0.790427>, 
      <-1.171996, -0.066493, 1.571338>, <-1.170454, -0.504246, 1.571338>, <-0.672294, -0.862408, 1.597680>, <-0.582435, -0.821386, 1.624493>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 4 v_steps 4,
      <0.969838, -0.281349, 0.646709>, <0.637707, -0.281349, 0.625856>, <0.681587, -0.155099, 0.698462>, <0.681587, -0.000793, 0.698462>, 
      <0.461831, -0.615269, 0.537603>, <0.179567, -0.530388, 0.544954>, <0.411801, -0.292070, 0.625833>, <0.411801, -0.000793, 0.625833>, 
      <-0.975884, -0.239814, 0.790427>, <-0.725957, -0.227744, 0.849435>, <-0.517662, 0.057693, 0.902118>, <-0.517662, 0.406560, 0.902118>, 
      <-0.582435, -0.821386, 1.624493>, <-0.473581, -0.780365, 1.651306>, <-0.245774, -0.456171, 1.677648>, <-0.245774, -0.059934, 1.677648>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 4 v_steps 4,
      <0.681587, -0.000793, 0.698462>, <0.681587, 0.153513, 0.698462>, <0.637707, 0.279763, 0.625856>, <0.969838, 0.279763, 0.646709>, 
      <0.411801, -0.000793, 0.625833>, <0.411801, 0.290484, 0.625833>, <0.179567, 0.528802, 0.544954>, <0.461831, 0.613320, 0.537603>, 
      <-0.517662, 0.406560, 0.902118>, <-0.517662, 0.755427, 0.902118>, <-0.725957, 1.040863, 0.849435>, <-0.975884, 1.095252, 0.790427>, 
      <-0.245774, -0.059934, 1.677648>, <-0.245774, 0.336303, 1.677648>, <-0.473581, 0.660498, 1.651306>, <-0.582435, 0.694960, 1.624493>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 4 v_steps 4,
      <0.969838, 0.279763, 0.646709>, <1.301969, 0.279763, 0.667563>, <2.058938, 0.153513, 0.626362>, <2.058938, -0.000793, 0.626362>, 
      <0.461831, 0.613320, 0.537603>, <0.744094, 0.697839, 0.530253>, <0.236254, 0.383291, 0.449373>, <0.236254, -0.001155, 0.449373>, 
      <-0.975884, 1.095252, 0.790427>, <-1.225811, 1.149641, 0.731419>, <-1.681303, 0.834297, 0.678735>, <-1.681303, 0.448878, 0.678735>, 
      <-0.582435, 0.694960, 1.624493>, <-0.672294, 0.729422, 1.597680>, <-1.170454, 0.371260, 1.571338>, <-1.171996, -0.066493, 1.571338>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 4 v_steps 4,
      <-1.171996, -0.066493, 1.571338>, <-1.170454, -0.504246, 1.571338>, <-0.672294, -0.862408, 1.597680>, <-0.582435, -0.821386, 1.624493>, 
      <-0.659606, -0.581863, 2.463942>, <-0.659606, -1.071950, 2.463942>, <-0.118777, -1.472930, 2.463942>, <-0.169991, -1.402959, 2.458559>, 
      <-1.688736, 0.144801, 3.564340>, <-1.688736, -0.172853, 3.564340>, <-1.265272, -0.432752, 3.535908>, <-1.044068, -0.412105, 3.415036>, 
      <-0.725829, 0.131321, 3.501157>, <-0.725829, 0.131321, 3.501157>, <-0.725829, 0.131321, 3.501157>, <-0.725829, 0.131321, 3.501157>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 4 v_steps 4,
      <-0.582435, -0.821386, 1.624493>, <-0.473581, -0.780365, 1.651306>, <-0.245774, -0.456171, 1.677648>, <-0.245774, -0.059934, 1.677648>, 
      <-0.169991, -1.402959, 2.458559>, <-0.221205, -1.332987, 2.453177>, <0.026114, -0.970035, 2.453177>, <0.026114, -0.526428, 2.453177>, 
      <-1.044068, -0.412105, 3.415036>, <-0.822864, -0.391458, 3.294165>, <-0.629215, -0.156207, 3.265732>, <-0.629215, 0.131321, 3.265732>, 
      <-0.725829, 0.131321, 3.501157>, <-0.725829, 0.131321, 3.501157>, <-0.725829, 0.131321, 3.501157>, <-0.725829, 0.131321, 3.501157>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 4 v_steps 4,
      <-0.245774, -0.059934, 1.677648>, <-0.245774, 0.336303, 1.677648>, <-0.473581, 0.660498, 1.651306>, <-0.582435, 0.694960, 1.624493>, 
      <0.026114, -0.526428, 2.453177>, <0.026114, -0.082820, 2.453177>, <-0.221205, 0.280132, 2.453177>, <-0.169991, 0.294668, 2.458559>, 
      <-0.629215, 0.131321, 3.265732>, <-0.629215, 0.418850, 3.265732>, <-0.822864, 0.654100, 3.294165>, <-1.044068, 0.688228, 3.415036>, 
      <-0.725829, 0.131321, 3.501157>, <-0.725829, 0.131321, 3.501157>, <-0.725829, 0.131321, 3.501157>, <-0.725829, 0.131321, 3.501157>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 4 v_steps 4,
      <-0.582435, 0.694960, 1.624493>, <-0.672294, 0.729422, 1.597680>, <-1.170454, 0.371260, 1.571338>, <-1.171996, -0.066493, 1.571338>, 
      <-0.169991, 0.294668, 2.458559>, <-0.118777, 0.309204, 2.463942>, <-0.659606, -0.091777, 2.463942>, <-0.659606, -0.581863, 2.463942>, 
      <-1.044068, 0.688228, 3.415036>, <-1.265272, 0.722355, 3.535908>, <-1.688736, 0.462456, 3.564340>, <-1.688736, 0.144801, 3.564340>, 
      <-0.725829, 0.131321, 3.501157>, <-0.725829, 0.131321, 3.501157>, <-0.725829, 0.131321, 3.501157>, <-0.725829, 0.131321, 3.501157>
    }
  }
  texture {
    weiss
  }
  scale 0.5
  rotate 20.0*y
  translate  <-1.55, 0.0, -0.1>
}
#declare Blume = union { 
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 4 v_steps 4,
      <1.988043, 0.000000, 0.669170>, <1.988043, -0.149275, 0.669170>, <1.255750, -0.271410, 0.709028>, <1.101072, -0.271410, 0.777374>, 
      <-0.270650, 0.000000, 0.497951>, <-0.270650, -0.336642, 0.497951>, <-0.045987, -0.612077, 0.576195>, <0.228601, -0.562204, 0.671825>, 
      <-1.118957, 0.394073, 0.719836>, <-1.118957, 0.056579, 0.719836>, <-0.917452, -0.219552, 0.770802>, <-0.671169, -0.219552, 0.833094>, 
      <-0.892963, -0.057213, 1.583341>, <-0.892963, -0.440533, 1.583341>, <-0.672582, -0.754159, 1.608824>, <-0.403228, -0.754159, 1.639970>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 4 v_steps 4,
      <1.101072, -0.271410, 0.777374>, <0.946394, -0.271410, 0.845720>, <0.988844, -0.149275, 0.915960>, <0.988844, 0.000000, 0.915960>, 
      <0.228601, -0.562204, 0.671825>, <0.503189, -0.512331, 0.767456>, <0.727852, -0.281782, 0.845699>, <0.727852, 0.000000, 0.845699>, 
      <-0.671169, -0.219552, 0.833094>, <-0.424886, -0.219552, 0.895385>, <-0.223382, 0.056579, 0.946351>, <-0.223382, 0.394073, 0.946351>, 
      <-0.403228, -0.754159, 1.639970>, <-0.133874, -0.754159, 1.671116>, <0.086507, -0.440533, 1.696599>, <0.086507, -0.057213, 1.696599>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 4 v_steps 4,
      <0.988844, 0.000000, 0.915960>, <0.988844, 0.149275, 0.915960>, <0.946394, 0.271410, 0.845720>, <1.101072, 0.271410, 0.777374>, 
      <0.727852, 0.000000, 0.845699>, <0.727852, 0.281782, 0.845699>, <0.503189, 0.512331, 0.767456>, <0.228601, 0.562204, 0.671825>, 
      <-0.223382, 0.394073, 0.946351>, <-0.223382, 0.731568, 0.946351>, <-0.424886, 1.007699, 0.895385>, <-0.671169, 1.007699, 0.833094>, 
      <0.086507, -0.057213, 1.696599>, <0.086507, 0.326107, 1.696599>, <-0.133874, 0.639733, 1.671116>, <-0.403228, 0.639733, 1.639970>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 4 v_steps 4,
      <1.101072, 0.271410, 0.777374>, <1.255750, 0.271410, 0.709028>, <1.988043, 0.149275, 0.669170>, <1.988043, 0.000000, 0.669170>, 
      <0.228601, 0.562204, 0.671825>, <-0.045987, 0.612077, 0.576195>, <-0.270650, 0.336642, 0.497951>, <-0.270650, 0.000000, 0.497951>, 
      <-0.671169, 1.007699, 0.833094>, <-0.917452, 1.007699, 0.770802>, <-1.118957, 0.731568, 0.719836>, <-1.118957, 0.394073, 0.719836>, 
      <-0.403228, 0.639733, 1.639970>, <-0.672582, 0.639733, 1.608824>, <-0.892963, 0.326107, 1.583341>, <-0.892963, -0.057213, 1.583341>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 4 v_steps 4,
      <-0.892963, -0.057213, 1.583341>, <-0.892963, -0.440533, 1.583341>, <-0.672582, -0.754159, 1.608824>, <-0.403228, -0.754159, 1.639970>, 
      <-0.666969, -0.508499, 2.446847>, <-0.666969, -0.937646, 2.446847>, <-0.427712, -1.288766, 2.446847>, <-0.135287, -1.288766, 2.446847>, 
      <-1.122245, 0.127808, 3.511373>, <-1.122245, -0.150348, 3.511373>, <-0.934909, -0.377929, 3.483868>, <-0.705943, -0.377929, 3.450249>, 
      <-0.705943, 0.127808, 3.450249>, <-0.705943, 0.127808, 3.450249>, <-0.705943, 0.127808, 3.450249>, <-0.705943, 0.127808, 3.450249>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 4 v_steps 4,
      <-0.403228, -0.754159, 1.639970>, <-0.133874, -0.754159, 1.671116>, <0.086507, -0.440533, 1.696599>, <0.086507, -0.057213, 1.696599>, 
      <-0.135287, -1.288766, 2.446847>, <0.157138, -1.288766, 2.446847>, <0.396395, -0.937646, 2.446847>, <0.396395, -0.508499, 2.446847>, 
      <-0.705943, -0.377929, 3.450249>, <-0.476977, -0.377929, 3.416631>, <-0.289642, -0.150348, 3.389125>, <-0.289642, 0.127808, 3.389125>, 
      <-0.705943, 0.127808, 3.450249>, <-0.705943, 0.127808, 3.450249>, <-0.705943, 0.127808, 3.450249>, <-0.705943, 0.127808, 3.450249>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 4 v_steps 4,
      <0.086507, -0.057213, 1.696599>, <0.086507, 0.326107, 1.696599>, <-0.133874, 0.639733, 1.671116>, <-0.403228, 0.639733, 1.639970>, 
      <0.396395, -0.508499, 2.446847>, <0.396395, -0.079353, 2.446847>, <0.157138, 0.271767, 2.446847>, <-0.135287, 0.271767, 2.446847>, 
      <-0.289642, 0.127808, 3.389125>, <-0.289642, 0.405963, 3.389125>, <-0.476977, 0.633545, 3.416631>, <-0.705943, 0.633545, 3.450249>, 
      <-0.705943, 0.127808, 3.450249>, <-0.705943, 0.127808, 3.450249>, <-0.705943, 0.127808, 3.450249>, <-0.705943, 0.127808, 3.450249>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 4 v_steps 4,
      <-0.403228, 0.639733, 1.639970>, <-0.672582, 0.639733, 1.608824>, <-0.892963, 0.326107, 1.583341>, <-0.892963, -0.057213, 1.583341>, 
      <-0.135287, 0.271767, 2.446847>, <-0.427712, 0.271767, 2.446847>, <-0.666969, -0.079353, 2.446847>, <-0.666969, -0.508499, 2.446847>, 
      <-0.705943, 0.633545, 3.450249>, <-0.934909, 0.633545, 3.483868>, <-1.122245, 0.405963, 3.511373>, <-1.122245, 0.127808, 3.511373>, 
      <-0.705943, 0.127808, 3.450249>, <-0.705943, 0.127808, 3.450249>, <-0.705943, 0.127808, 3.450249>, <-0.705943, 0.127808, 3.450249>
    }
  }
  texture {
    braun
  }
  scale 0.5
  rotate 20.0*y
  translate  <-1.55, 0.0, -0.1>
}
#declare Schaenzchen = union {
  object { Blume1 }
  object { Blume }
  translate  1.0*z
}
#declare Fuss_gesamt1 = difference {
  sphere { // Fuss1
    <0,0,0>,1
    scale 0.5
    translate  <0.45, 0.6, -0.7>
  }
  box { // Fuss_clip1
    <-1, -1, -1>, <1, 1, 1>
    scale 0.55
    translate  <0.45, 0.6, -1.1>
  }
  texture {
    schwarz
  }
  translate  <-0.1, -1.25, -0.03>
}
#declare Fuss_gesamt = difference {
  sphere { // Fuss
    <0,0,0>,1
    scale 0.5
    translate  <0.45, 0.6, -0.7>
  }
  box { // Fuss_clip
    <-1, -1, -1>, <1, 1, 1>
    scale 0.55
    translate  <0.45, 0.6, -1.1>
  }
  texture {
    schwarz
  }
  translate  <-0.1, 0.05, -0.03>
}
#declare Fuesse = union {
  object { Fuss_gesamt1 }
  object { Fuss_gesamt }
  scale 0.8
  translate  0.89*z
}
#declare Aug_1 = difference {
  sphere { // Aug1
    <0,0,0>,1
    texture {
      weiss
    }
    scale <0.1, 0.25, 0.3>
    rotate <0.0, -19.0, -12.0>
    translate  <1.18, -0.2, 2.12>
  }
  sphere { // Aug__2
    <0,0,0>,1
    texture {
      schwarz
    }
    scale <0.1, 0.1, 0.15>
    translate  <1.37, -0.22, 2.1>
  }
  translate  -0.02*z
}
#declare Aug_2 = difference {
  sphere { // Aug
    <0,0,0>,1
    texture {
      weiss
    }
    scale <0.1, 0.25, 0.3>
    rotate <0.0, -19.0, 12.0>
    translate  <1.18, 0.2, 2.12>
  }
  sphere { // Aug__1
    <0,0,0>,1
    texture {
      schwarz
    }
    scale <0.1, 0.1, 0.15>
    translate  <1.37, 0.22, 2.1>
  }
  translate  -0.02*z
}
#declare Augen = union {
  object { Aug_1 }
  object { Aug_2 }
  translate  1.45*z
}
#declare Ohr2 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 4 v_steps 4,
      <-1.000000, -1.599553, -3.399235>, <-1.000000, -1.610835, -3.566361>, <1.000000, -1.610835, -3.566361>, <1.000000, -1.599553, -3.399235>, 
      <0.447445, -1.023705, 2.270778>, <0.447445, -1.983382, 2.551884>, <2.447445, -1.983382, 2.551884>, <2.447445, -1.023705, 2.270778>, 
      <-0.379666, 0.543270, 3.407296>, <-0.379666, -0.223299, 3.152189>, <1.620334, -0.223299, 3.152189>, <1.620334, 0.543270, 3.407296>, 
      <-2.170666, 1.066541, 5.886131>, <-2.170666, -0.164117, 6.006788>, <1.722289, -0.164117, 8.161830>, <1.485036, 1.066541, 6.963652>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 4 v_steps 4,
      <1.000000, -1.599553, -3.399235>, <1.000000, -1.588272, -3.232109>, <-1.000000, -1.588272, -3.232109>, <-1.000000, -1.599553, -3.399235>, 
      <2.447445, -1.023705, 2.270778>, <2.447445, -0.064028, 1.989672>, <0.447445, -0.064028, 1.989672>, <0.447445, -1.023705, 2.270778>, 
      <1.620334, 0.543270, 3.407296>, <1.620334, 1.309838, 3.662404>, <-0.379666, 1.309838, 3.662404>, <-0.379666, 0.543270, 3.407296>, 
      <1.485036, 1.066541, 6.963652>, <1.188471, 2.297200, 5.765474>, <-2.170666, 2.297200, 5.765474>, <-2.170666, 1.066541, 5.886131>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 4 v_steps 4,
      <-2.170666, 1.066541, 5.886131>, <-2.170666, -0.164117, 6.006788>, <1.722289, -0.164117, 8.161830>, <1.485036, 1.066541, 6.963652>, 
      <-3.961665, 1.589813, 8.364966>, <-3.961665, -0.104935, 8.861387>, <1.824244, -0.104935, 13.171471>, <1.290426, 1.589813, 10.520008>, 
      <0.067636, 0.022915, 14.642989>, <0.067636, -0.797769, 14.071606>, <2.067636, -0.797769, 14.071606>, <2.067636, 0.022915, 14.642989>, 
      <1.067636, 0.022915, 14.642989>, <1.067636, 0.022915, 14.642989>, <1.067636, 0.022915, 14.642989>, <1.067636, 0.022915, 14.642989>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 4 v_steps 4,
      <1.485036, 1.066541, 6.963652>, <1.188471, 2.297200, 5.765474>, <-2.170666, 2.297200, 5.765474>, <-2.170666, 1.066541, 5.886131>, 
      <1.290426, 1.589813, 10.520008>, <0.756608, 3.284561, 7.868545>, <-3.961665, 3.284561, 7.868545>, <-3.961665, 1.589813, 8.364966>, 
      <2.067636, 0.022915, 14.642989>, <2.067636, 0.843598, 15.214373>, <0.067636, 0.843598, 15.214373>, <0.067636, 0.022915, 14.642989>, 
      <1.067636, 0.022915, 14.642989>, <1.067636, 0.022915, 14.642989>, <1.067636, 0.022915, 14.642989>, <1.067636, 0.022915, 14.642989>
    }
  }
  texture {
    braun
  }
  scale <-0.2, -0.2, -0.133>
  rotate <-135.0, -30.0, 45.0>
  translate  <0.3, -0.25, 2.3>
}
#declare Ohr1 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 4 v_steps 4,
      <-1.000000, -1.599553, -3.399235>, <-1.000000, -1.610835, -3.566361>, <1.000000, -1.610835, -3.566361>, <1.000000, -1.599553, -3.399235>, 
      <0.447445, -1.023705, 2.270778>, <0.447445, -1.983382, 2.551884>, <2.447445, -1.983382, 2.551884>, <2.447445, -1.023705, 2.270778>, 
      <-0.379666, 0.543270, 3.407296>, <-0.379666, -0.223299, 3.152189>, <1.620334, -0.223299, 3.152189>, <1.620334, 0.543270, 3.407296>, 
      <-2.170666, 1.066541, 5.886131>, <-2.170666, -0.164117, 6.006788>, <1.188471, -0.164117, 6.006788>, <1.188471, 1.066541, 5.886131>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 4 v_steps 4,
      <1.000000, -1.599553, -3.399235>, <1.000000, -1.588272, -3.232109>, <-1.000000, -1.588272, -3.232109>, <-1.000000, -1.599553, -3.399235>, 
      <2.447445, -1.023705, 2.270778>, <2.447445, -0.064028, 1.989672>, <0.447445, -0.064028, 1.989672>, <0.447445, -1.023705, 2.270778>, 
      <1.620334, 0.543270, 3.407296>, <1.620334, 1.309838, 3.662404>, <-0.379666, 1.309838, 3.662404>, <-0.379666, 0.543270, 3.407296>, 
      <1.188471, 1.066541, 5.886131>, <1.188471, 2.297200, 5.765474>, <-2.170666, 2.297200, 5.765474>, <-2.170666, 1.066541, 5.886131>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 4 v_steps 4,
      <-2.170666, 1.066541, 5.886131>, <-2.170666, -0.164117, 6.006788>, <1.188471, -0.164117, 6.006788>, <1.188471, 1.066541, 5.886131>, 
      <-3.961665, 1.589813, 8.364966>, <-3.961665, -0.104935, 8.861387>, <0.756608, -0.104935, 8.861387>, <0.756608, 1.589813, 8.364966>, 
      <0.383972, 0.022915, 16.303756>, <0.383972, -0.797769, 15.732373>, <2.383972, -0.797769, 15.732373>, <2.383972, 0.022915, 16.303756>, 
      <1.383972, 0.022915, 16.303756>, <1.383972, 0.022915, 16.303756>, <1.383972, 0.022915, 16.303756>, <1.383972, 0.022915, 16.303756>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 4 v_steps 4,
      <1.188471, 1.066541, 5.886131>, <1.188471, 2.297200, 5.765474>, <-2.170666, 2.297200, 5.765474>, <-2.170666, 1.066541, 5.886131>, 
      <0.756608, 1.589813, 8.364966>, <0.756608, 3.284561, 7.868545>, <-3.961665, 3.284561, 7.868545>, <-3.961665, 1.589813, 8.364966>, 
      <2.383972, 0.022915, 16.303756>, <2.383972, 0.843598, 16.875139>, <0.383972, 0.843598, 16.875139>, <0.383972, 0.022915, 16.303756>, 
      <1.383972, 0.022915, 16.303756>, <1.383972, 0.022915, 16.303756>, <1.383972, 0.022915, 16.303756>, <1.383972, 0.022915, 16.303756>
    }
  }
  texture {
    braun
  }
  scale <0.2, 0.2, 0.133>
  rotate <45.0, 30.0, 135.0>
  translate  <0.3, 0.25, 2.3>
}
#declare Ohren = union {
  object { Ohr2 }
  object { Ohr1 }
  translate  1.43*z
}
#declare Pfote = union { 
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 4 v_steps 4,
      <-0.598872, 0.000000, -1.476085>, <-0.598872, -0.544712, -1.476085>, <-0.416379, -0.907854, -1.360835>, <-0.016865, -0.907854, -0.790441>, 
      <-1.184515, 0.000000, 0.374569>, <-1.184515, -0.796890, 0.374569>, <-0.875465, -1.328149, 0.374569>, <-0.119392, -1.328149, 0.374569>, 
      <-0.814638, 0.009848, 0.962239>, <-0.814638, -0.857606, 0.962239>, <-0.500603, -1.435909, 0.974174>, <0.140010, -1.435909, 0.935328>, 
      <-0.499009, 0.005325, 1.477979>, <-0.499009, -0.509931, 1.477979>, <-0.561908, -1.451360, 1.456528>, <0.160978, -1.493637, 1.466672>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 4 v_steps 4,
      <-0.016865, -0.907854, -0.790441>, <0.382648, -0.907854, -0.220046>, <0.565141, -0.544712, -0.104796>, <0.565141, 0.000000, -0.104796>, 
      <-0.119392, -1.328149, 0.374569>, <0.636682, -1.328149, 0.374569>, <0.945732, -0.796890, 0.374569>, <0.945732, 0.000000, 0.374569>, 
      <0.140010, -1.435909, 0.935328>, <0.780624, -1.435909, 0.896483>, <1.094659, -0.857606, 0.908418>, <1.094659, 0.009848, 0.908418>, 
      <0.160978, -1.493637, 1.466672>, <0.883864, -1.535914, 1.476815>, <1.182372, -0.907201, 1.493508>, <1.182372, 0.005325, 1.493508>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 4 v_steps 4,
      <0.565141, 0.000000, -0.104796>, <0.565141, 0.544712, -0.104796>, <0.382648, 0.907854, -0.220046>, <-0.016865, 0.907854, -0.790441>, 
      <0.945732, 0.000000, 0.374569>, <0.945732, 0.796890, 0.374569>, <0.636682, 1.328149, 0.374569>, <-0.119392, 1.328149, 0.374569>, 
      <1.094659, 0.009848, 0.908418>, <1.094659, 0.877302, 0.908418>, <0.780624, 1.455605, 0.896483>, <0.140010, 1.455605, 0.935328>, 
      <1.182372, 0.005325, 1.493508>, <1.182372, 0.917851, 1.493508>, <0.883864, 1.526202, 1.476815>, <0.160978, 1.508916, 1.466672>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 4 v_steps 4,
      <-0.016865, 0.907854, -0.790441>, <-0.416379, 0.907854, -1.360835>, <-0.598872, 0.544712, -1.476085>, <-0.598872, 0.000000, -1.476085>, 
      <-0.119392, 1.328149, 0.374569>, <-0.875465, 1.328149, 0.374569>, <-1.184515, 0.796890, 0.374569>, <-1.184515, 0.000000, 0.374569>, 
      <0.140010, 1.455605, 0.935328>, <-0.500603, 1.455605, 0.974174>, <-0.814638, 0.877302, 0.962239>, <-0.814638, 0.009848, 0.962239>, 
      <0.160978, 1.508916, 1.466672>, <-0.561908, 1.491629, 1.456528>, <-0.499009, 0.520581, 1.477979>, <-0.499009, 0.005325, 1.477979>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 4 v_steps 4,
      <-0.499009, 0.005325, 1.477979>, <-0.499009, -0.509931, 1.477979>, <-0.561908, -1.451360, 1.456528>, <0.160978, -1.493637, 1.466672>, 
      <-0.183379, 0.000802, 1.993720>, <-0.183379, -0.162256, 1.993720>, <-0.623213, -1.466811, 1.938883>, <0.181945, -1.551365, 1.998015>, 
      <0.270350, -0.044398, 2.524283>, <0.270350, -0.214385, 2.524283>, <-0.781453, -1.696758, 2.433469>, <0.119249, -1.702484, 2.510839>, 
      <0.287092, -0.043882, 3.012782>, <0.287092, -0.209693, 3.012782>, <-0.821054, -1.655656, 2.895142>, <0.075240, -1.661241, 2.990965>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 4 v_steps 4,
      <0.160978, -1.493637, 1.466672>, <0.883864, -1.535914, 1.476815>, <1.182372, -0.907201, 1.493508>, <1.182372, 0.005325, 1.493508>, 
      <0.181945, -1.551365, 1.998015>, <0.987103, -1.635919, 2.057148>, <1.270086, -0.956796, 2.078599>, <1.270086, 0.000802, 2.078599>, 
      <0.119249, -1.702484, 2.510839>, <1.019951, -1.708210, 2.588208>, <1.302560, -1.042685, 2.613245>, <1.302560, -0.044398, 2.613245>, 
      <0.075240, -1.661241, 2.990965>, <0.971535, -1.666827, 3.086789>, <1.253510, -1.017649, 3.117299>, <1.253510, -0.043882, 3.117299>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 4 v_steps 4,
      <1.182372, 0.005325, 1.493508>, <1.182372, 0.917851, 1.493508>, <0.883864, 1.526202, 1.476815>, <0.160978, 1.508916, 1.466672>, 
      <1.270086, 0.000802, 2.078599>, <1.270086, 0.958400, 2.078599>, <0.987103, 1.596799, 2.057148>, <0.181945, 1.562226, 1.998015>, 
      <1.302560, -0.044398, 2.613245>, <1.302560, 0.953890, 2.613245>, <1.019951, 1.619414, 2.588208>, <0.119249, 1.625140, 2.510839>, 
      <1.253510, -0.043882, 3.117299>, <1.253510, 0.929885, 3.117299>, <0.971535, 1.579063, 3.086789>, <0.075240, 1.584649, 2.990965>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 4 v_steps 4,
      <0.160978, 1.508916, 1.466672>, <-0.561908, 1.491629, 1.456528>, <-0.499009, 0.520581, 1.477979>, <-0.499009, 0.005325, 1.477979>, 
      <0.181945, 1.562226, 1.998015>, <-0.623213, 1.527653, 1.938883>, <-0.183379, 0.163861, 1.993720>, <-0.183379, 0.000802, 1.993720>, 
      <0.119249, 1.625140, 2.510839>, <-0.781453, 1.630866, 2.433469>, <0.270350, 0.125589, 2.524283>, <0.270350, -0.044398, 2.524283>, 
      <0.075240, 1.584649, 2.990965>, <-0.821054, 1.590234, 2.895142>, <0.287092, 0.121930, 3.012782>, <0.287092, -0.043882, 3.012782>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 4 v_steps 4,
      <0.287092, -0.043882, 3.012782>, <0.287092, -0.209693, 3.012782>, <-0.821054, -1.655656, 2.895142>, <0.075240, -1.661241, 2.990965>, 
      <0.303835, -0.043366, 3.501282>, <0.303835, -0.205002, 3.501282>, <-0.860655, -1.614554, 3.356814>, <0.031232, -1.619999, 3.471092>, 
      <-0.064880, -0.000386, 3.973360>, <-0.064880, -0.155435, 3.973360>, <-0.860070, -1.507535, 3.835205>, <-0.004835, -1.512758, 3.983793>, 
      <-0.333885, 0.034997, 4.407205>, <-0.333885, -0.102339, 4.411940>, <-0.858488, -1.303800, 4.335941>, <-0.110889, -1.300592, 4.509368>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 4 v_steps 4,
      <0.075240, -1.661241, 2.990965>, <0.971535, -1.666827, 3.086789>, <1.253510, -1.017649, 3.117299>, <1.253510, -0.043882, 3.117299>, 
      <0.031232, -1.619999, 3.471092>, <0.923119, -1.625443, 3.585369>, <1.204459, -0.992612, 3.621353>, <1.204459, -0.043366, 3.621353>, 
      <-0.004835, -1.512758, 3.983793>, <0.850401, -1.517981, 4.132380>, <1.130006, -0.910943, 4.180958>, <1.130006, -0.000386, 4.180958>, 
      <-0.110889, -1.300592, 4.509368>, <0.636710, -1.297383, 4.682795>, <0.901793, -0.756795, 4.725120>, <0.901793, 0.049745, 4.697316>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 4 v_steps 4,
      <1.253510, -0.043882, 3.117299>, <1.253510, 0.929885, 3.117299>, <0.971535, 1.579063, 3.086789>, <0.075240, 1.584649, 2.990965>, 
      <1.204459, -0.043366, 3.621353>, <1.204459, 0.905881, 3.621353>, <0.923119, 1.538712, 3.585369>, <0.031232, 1.544157, 3.471092>, 
      <1.130006, -0.000386, 4.180958>, <1.130006, 0.910170, 4.180958>, <0.850401, 1.517208, 4.132380>, <-0.004835, 1.522431, 3.983793>, 
      <0.901793, 0.049745, 4.697316>, <0.901793, 0.856285, 4.669512>, <0.636710, 1.391084, 4.590115>, <-0.110889, 1.387876, 4.416688>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 4 v_steps 4,
      <0.075240, 1.584649, 2.990965>, <-0.821054, 1.590234, 2.895142>, <0.287092, 0.121930, 3.012782>, <0.287092, -0.043882, 3.012782>, 
      <0.031232, 1.544157, 3.471092>, <-0.860655, 1.549601, 3.356814>, <0.303835, 0.118271, 3.501282>, <0.303835, -0.043366, 3.501282>, 
      <-0.004835, 1.522431, 3.983793>, <-0.860070, 1.527653, 3.835205>, <-0.064880, 0.154662, 3.973360>, <-0.064880, -0.000386, 3.973360>, 
      <-0.110889, 1.387876, 4.416688>, <-0.858488, 1.384667, 4.243260>, <-0.333885, 0.172334, 4.402471>, <-0.333885, 0.034997, 4.407205>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 4 v_steps 4,
      <-0.333885, 0.034997, 4.407205>, <-0.333885, -0.102339, 4.411940>, <-0.858488, -1.303800, 4.335941>, <-0.110889, -1.300592, 4.509368>, 
      <-0.602889, 0.070381, 4.841050>, <-0.602889, -0.049244, 4.850519>, <-0.856906, -1.100065, 4.836676>, <-0.216943, -1.088425, 5.034944>, 
      <-0.832402, 0.106836, 5.293372>, <-0.832402, 0.025610, 5.299802>, <-0.806810, -0.682122, 5.363340>, <-0.329562, -0.673830, 5.502873>, 
      <-0.265473, 0.121424, 5.488486>, <-0.265473, 0.121424, 5.488486>, <-0.265473, 0.121424, 5.488486>, <-0.265473, 0.121424, 5.488486>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 4 v_steps 4,
      <-0.110889, -1.300592, 4.509368>, <0.636710, -1.297383, 4.682795>, <0.901793, -0.756795, 4.725120>, <0.901793, 0.049745, 4.697316>, 
      <-0.216943, -1.088425, 5.034944>, <0.423020, -1.076786, 5.233211>, <0.673581, -0.602648, 5.269282>, <0.673581, 0.099876, 5.213674>, 
      <-0.329562, -0.673830, 5.502873>, <0.147685, -0.665539, 5.642406>, <0.333976, -0.343226, 5.671616>, <0.333976, 0.133787, 5.633858>, 
      <-0.265473, 0.121424, 5.488486>, <-0.265473, 0.121424, 5.488486>, <-0.265473, 0.121424, 5.488486>, <-0.265473, 0.121424, 5.488486>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 4 v_steps 4,
      <0.901793, 0.049745, 4.697316>, <0.901793, 0.856285, 4.669512>, <0.636710, 1.391084, 4.590115>, <-0.110889, 1.387876, 4.416688>, 
      <0.673581, 0.099876, 5.213674>, <0.673581, 0.802400, 5.158066>, <0.423020, 1.264960, 5.047850>, <-0.216943, 1.253320, 4.849583>, 
      <0.333976, 0.133787, 5.633858>, <0.333976, 0.610799, 5.596100>, <0.147685, 0.924503, 5.516547>, <-0.329562, 0.916211, 5.377014>, 
      <-0.265473, 0.121424, 5.488486>, <-0.265473, 0.121424, 5.488486>, <-0.265473, 0.121424, 5.488486>, <-0.265473, 0.121424, 5.488486>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 4 v_steps 4,
      <-0.110889, 1.387876, 4.416688>, <-0.858488, 1.384667, 4.243260>, <-0.333885, 0.172334, 4.402471>, <-0.333885, 0.034997, 4.407205>, 
      <-0.216943, 1.253320, 4.849583>, <-0.856906, 1.241681, 4.651316>, <-0.602889, 0.190006, 4.831581>, <-0.602889, 0.070381, 4.841050>, 
      <-0.329562, 0.916211, 5.377014>, <-0.806810, 0.907920, 5.237480>, <-0.832402, 0.188061, 5.286943>, <-0.832402, 0.106836, 5.293372>, 
      <-0.265473, 0.121424, 5.488486>, <-0.265473, 0.121424, 5.488486>, <-0.265473, 0.121424, 5.488486>, <-0.265473, 0.121424, 5.488486>
    }
  }
  texture {
    hellbraun
  }
  scale <0.2, 0.2, 0.11>
  rotate 90.0*z
  translate  <1.0, 1.0, 1.5>
}
#declare Arm = union { 
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 4 v_steps 4,
      <-2.472374, -2.401335, 2.075995>, <-2.322572, -2.929019, 2.116099>, <-1.980624, -3.328239, 1.757358>, <-1.267322, -3.159215, 1.316935>, 
      <-0.738186, -1.064680, 2.235563>, <-0.588384, -1.421441, 2.265613>, <-0.145552, -2.127582, 2.009697>, <0.245884, -2.045146, 1.632229>, 
      <-0.665393, -1.038976, 2.301864>, <-0.515590, -1.395737, 2.331914>, <0.017566, -1.722413, 2.213477>, <0.519399, -1.593999, 2.028616>, 
      <-0.568791, -0.871838, 2.493412>, <-0.418988, -1.314061, 2.528489>, <0.125229, -1.632809, 2.473046>, <0.640581, -1.494705, 2.365177>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 4 v_steps 4,
      <-1.267322, -3.159215, 1.316935>, <-0.554020, -2.990190, 0.876513>, <-0.457204, -2.525927, 0.452147>, <-0.607007, -1.998243, 0.412042>, 
      <0.245884, -2.045146, 1.632229>, <0.637320, -1.962710, 1.254761>, <0.835020, -1.463521, 0.913110>, <0.685217, -0.935837, 0.873006>, 
      <0.519399, -1.593999, 2.028616>, <1.021232, -1.465584, 1.843755>, <1.309257, -0.928776, 1.659693>, <1.159454, -0.401092, 1.619588>, 
      <0.640581, -1.494705, 2.365177>, <1.155932, -1.356602, 2.257309>, <1.455018, -0.811866, 2.136240>, <1.305215, -0.284182, 2.096136>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 4 v_steps 4,
      <-0.607007, -1.998243, 0.412042>, <-0.756810, -1.470558, 0.371938>, <-1.098757, -1.071338, 0.730679>, <-1.812059, -1.240363, 1.171102>, 
      <0.685217, -0.935837, 0.873006>, <0.535415, -0.408152, 0.832902>, <0.092583, -0.043858, 1.108927>, <-0.298853, -0.126294, 1.486395>, 
      <1.159454, -0.401092, 1.619588>, <1.009652, 0.126592, 1.579484>, <0.476495, 0.453268, 1.697921>, <-0.025338, 0.324854, 1.882782>, 
      <1.305215, -0.284182, 2.096136>, <1.155412, 0.243502, 2.056031>, <0.611195, 0.562250, 2.111475>, <0.095844, 0.424147, 2.219343>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 4 v_steps 4,
      <-1.812059, -1.240363, 1.171102>, <-2.525361, -1.409387, 1.611524>, <-2.622177, -1.873650, 2.035890>, <-2.472374, -2.401335, 2.075995>, 
      <-0.298853, -0.126294, 1.486395>, <-0.690289, -0.208729, 1.863863>, <-0.887989, -0.707919, 2.205513>, <-0.738186, -1.064680, 2.235563>, 
      <-0.025338, 0.324854, 1.882782>, <-0.527171, 0.196439, 2.067643>, <-0.815195, -0.682215, 2.271814>, <-0.665393, -1.038976, 2.301864>, 
      <0.095844, 0.424147, 2.219343>, <-0.419508, 0.286043, 2.327212>, <-0.718594, -0.429615, 2.458335>, <-0.568791, -0.871838, 2.493412>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 4 v_steps 4,
      <-0.568791, -0.871838, 2.493412>, <-0.418988, -1.314061, 2.528489>, <0.125229, -1.632809, 2.473046>, <0.640581, -1.494705, 2.365177>, 
      <-0.472189, -0.704700, 2.684960>, <-0.322387, -1.232385, 2.725065>, <0.232891, -1.543205, 2.732615>, <0.761762, -1.395412, 2.701738>, 
      <-0.519427, -0.604400, 3.022469>, <-0.365975, -1.132085, 3.044868>, <0.190701, -1.437378, 3.088543>, <0.717631, -1.282831, 3.119526>, 
      <-0.591576, -0.339774, 3.586310>, <-0.514850, -0.848000, 3.597510>, <-0.058289, -1.221090, 3.619347>, <0.423004, -1.143816, 3.634838>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 4 v_steps 4,
      <0.640581, -1.494705, 2.365177>, <1.155932, -1.356602, 2.257309>, <1.455018, -0.811866, 2.136240>, <1.305215, -0.284182, 2.096136>, 
      <0.761762, -1.395412, 2.701738>, <1.290632, -1.247619, 2.670862>, <1.600779, -0.694956, 2.612787>, <1.450976, -0.167272, 2.572683>, 
      <0.717631, -1.282831, 3.119526>, <1.244561, -1.128283, 3.150508>, <1.550134, -0.570093, 3.157532>, <1.396682, -0.042409, 3.135133>, 
      <0.423004, -1.143816, 3.634838>, <0.904298, -1.066542, 3.650330>, <1.235307, -0.567004, 3.653841>, <1.158581, -0.058778, 3.642642>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 4 v_steps 4,
      <1.305215, -0.284182, 2.096136>, <1.155412, 0.243502, 2.056031>, <0.611195, 0.562250, 2.111475>, <0.095844, 0.424147, 2.219343>, 
      <1.450976, -0.167272, 2.572683>, <1.301173, 0.360413, 2.532578>, <0.745895, 0.671233, 2.525028>, <0.217025, 0.523440, 2.555905>, 
      <1.396682, -0.042409, 3.135133>, <1.243230, 0.485276, 3.112735>, <0.686553, 0.790569, 3.069060>, <0.159624, 0.636022, 3.038077>, 
      <1.158581, -0.058778, 3.642642>, <1.081855, 0.449448, 3.631443>, <0.625294, 0.822538, 3.609605>, <0.144001, 0.745264, 3.594114>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 4 v_steps 4,
      <0.095844, 0.424147, 2.219343>, <-0.419508, 0.286043, 2.327212>, <-0.718594, -0.429615, 2.458335>, <-0.568791, -0.871838, 2.493412>, 
      <0.217025, 0.523440, 2.555905>, <-0.311846, 0.375647, 2.586781>, <-0.621992, -0.177016, 2.644856>, <-0.472189, -0.704700, 2.684960>, 
      <0.159624, 0.636022, 3.038077>, <-0.367306, 0.481474, 3.007094>, <-0.672879, -0.076716, 3.000071>, <-0.519427, -0.604400, 3.022469>, 
      <0.144001, 0.745264, 3.594114>, <-0.337293, 0.667990, 3.578623>, <-0.668302, 0.168452, 3.575111>, <-0.591576, -0.339774, 3.586310>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 4 v_steps 4,
      <-0.591576, -0.339774, 3.586310>, <-0.514850, -0.848000, 3.597510>, <-0.058289, -1.221090, 3.619347>, <0.423004, -1.143816, 3.634838>, 
      <-0.663726, -0.075147, 4.150151>, <-0.663726, -0.563916, 4.150151>, <-0.307279, -1.004802, 4.150151>, <0.128378, -1.004802, 4.150151>, 
      <-0.655836, -0.010019, 4.629179>, <-0.655836, -0.498787, 4.629179>, <-0.319590, -0.939673, 4.629179>, <0.091377, -0.939673, 4.629179>, 
      <-0.630407, -0.005009, 4.814589>, <-0.630407, -0.518824, 4.814589>, <-0.309312, -0.959710, 4.814589>, <0.083139, -0.959710, 4.814589>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 4 v_steps 4,
      <0.423004, -1.143816, 3.634838>, <0.904298, -1.066542, 3.650330>, <1.235307, -0.567004, 3.653841>, <1.158581, -0.058778, 3.642642>, 
      <0.128378, -1.004802, 4.150151>, <0.564035, -1.004802, 4.150151>, <0.920481, -0.563916, 4.150151>, <0.920481, -0.075147, 4.150151>, 
      <0.091377, -0.939673, 4.629179>, <0.502345, -0.939673, 4.629179>, <0.838591, -0.498787, 4.629179>, <0.838591, -0.010019, 4.629179>, 
      <0.083139, -0.959710, 4.814589>, <0.475589, -0.959710, 4.814589>, <0.796684, -0.518824, 4.814589>, <0.796684, -0.005009, 4.814589>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 4 v_steps 4,
      <1.158581, -0.058778, 3.642642>, <1.081855, 0.449448, 3.631443>, <0.625294, 0.822538, 3.609605>, <0.144001, 0.745264, 3.594114>, 
      <0.920481, -0.075147, 4.150151>, <0.920481, 0.413621, 4.150151>, <0.564035, 0.854507, 4.150151>, <0.128378, 0.854507, 4.150151>, 
      <0.838591, -0.010019, 4.629179>, <0.838591, 0.478750, 4.629179>, <0.502345, 0.919636, 4.629179>, <0.091377, 0.919636, 4.629179>, 
      <0.796684, -0.005009, 4.814589>, <0.796684, 0.508805, 4.814589>, <0.475589, 0.949691, 4.814589>, <0.083139, 0.949691, 4.814589>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 4 v_steps 4,
      <0.144001, 0.745264, 3.594114>, <-0.337293, 0.667990, 3.578623>, <-0.668302, 0.168452, 3.575111>, <-0.591576, -0.339774, 3.586310>, 
      <0.128378, 0.854507, 4.150151>, <-0.307279, 0.854507, 4.150151>, <-0.663726, 0.413621, 4.150151>, <-0.663726, -0.075147, 4.150151>, 
      <0.091377, 0.919636, 4.629179>, <-0.319590, 0.919636, 4.629179>, <-0.655836, 0.478750, 4.629179>, <-0.655836, -0.010019, 4.629179>, 
      <0.083139, 0.949691, 4.814589>, <-0.309312, 0.949691, 4.814589>, <-0.630407, 0.508805, 4.814589>, <-0.630407, -0.005009, 4.814589>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 4 v_steps 4,
      <-0.630407, -0.005009, 4.814589>, <-0.630407, -0.518824, 4.814589>, <-0.309312, -0.959710, 4.814589>, <0.083139, -0.959710, 4.814589>, 
      <-0.604978, 0.000000, 5.000000>, <-0.604978, -0.538861, 5.000000>, <-0.299033, -0.979747, 5.000000>, <0.074900, -0.979747, 5.000000>, 
      <-0.762669, 0.000000, 5.500000>, <-0.762669, -0.617575, 5.500000>, <-0.419468, -1.122863, 5.500000>, <0.000000, -1.122863, 5.500000>, 
      <-0.791945, 0.000000, 6.020973>, <-0.791945, -0.750000, 6.020973>, <-0.541945, -1.250000, 6.020973>, <-0.041945, -1.250000, 6.020973>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 4 v_steps 4,
      <0.083139, -0.959710, 4.814589>, <0.475589, -0.959710, 4.814589>, <0.796684, -0.518824, 4.814589>, <0.796684, -0.005009, 4.814589>, 
      <0.074900, -0.979747, 5.000000>, <0.448833, -0.979747, 5.000000>, <0.754778, -0.538861, 5.000000>, <0.754778, 0.000000, 5.000000>, 
      <0.000000, -1.122863, 5.500000>, <0.419468, -1.122863, 5.500000>, <0.762669, -0.617575, 5.500000>, <0.762669, 0.000000, 5.500000>, 
      <-0.041945, -1.250000, 6.020973>, <0.458055, -1.250000, 6.020973>, <0.708055, -0.750000, 6.020973>, <0.708055, 0.000000, 6.020973>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 4 v_steps 4,
      <0.796684, -0.005009, 4.814589>, <0.796684, 0.508805, 4.814589>, <0.475589, 0.949691, 4.814589>, <0.083139, 0.949691, 4.814589>, 
      <0.754778, 0.000000, 5.000000>, <0.754778, 0.538861, 5.000000>, <0.448833, 0.979747, 5.000000>, <0.074900, 0.979747, 5.000000>, 
      <0.762669, 0.000000, 5.500000>, <0.762669, 0.617575, 5.500000>, <0.419468, 1.122863, 5.500000>, <0.000000, 1.122863, 5.500000>, 
      <0.708055, 0.000000, 6.020973>, <0.708055, 0.750000, 6.020973>, <0.458055, 1.250000, 6.020973>, <-0.041945, 1.250000, 6.020973>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 4 v_steps 4,
      <0.083139, 0.949691, 4.814589>, <-0.309312, 0.949691, 4.814589>, <-0.630407, 0.508805, 4.814589>, <-0.630407, -0.005009, 4.814589>, 
      <0.074900, 0.979747, 5.000000>, <-0.299033, 0.979747, 5.000000>, <-0.604978, 0.538861, 5.000000>, <-0.604978, 0.000000, 5.000000>, 
      <0.000000, 1.122863, 5.500000>, <-0.419468, 1.122863, 5.500000>, <-0.762669, 0.617575, 5.500000>, <-0.762669, 0.000000, 5.500000>, 
      <-0.041945, 1.250000, 6.020973>, <-0.541945, 1.250000, 6.020973>, <-0.791945, 0.750000, 6.020973>, <-0.791945, 0.000000, 6.020973>
    }
  }
  texture {
    braun
  }
  scale -0.2
  rotate <-180.0, 0.0, -90.0>
  translate  <1.0, 1.0, 0.4>
}
#declare Arm_gesamt = union {
  object { Pfote }
  object { Arm }
  rotate <-10.0, 25.0, -15.0>
  translate  <-0.85, -0.1, 2.08>
}
#declare Pfote1 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 4 v_steps 4,
      <-0.598872, 0.000000, -1.476085>, <-0.598872, -0.544712, -1.476085>, <-0.416379, -0.907854, -1.360835>, <-0.016865, -0.907854, -0.790441>, 
      <-1.184515, 0.000000, 0.374569>, <-1.184515, -0.796890, 0.374569>, <-0.875465, -1.328149, 0.374569>, <-0.119392, -1.328149, 0.374569>, 
      <-0.814638, 0.009848, 0.962239>, <-0.814638, -0.857606, 0.962239>, <-0.500603, -1.435909, 0.974174>, <0.140010, -1.435909, 0.935328>, 
      <-0.499009, 0.005325, 1.477979>, <-0.499009, -0.509931, 1.477979>, <-0.561908, -1.451360, 1.456528>, <0.160978, -1.493637, 1.466672>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 4 v_steps 4,
      <-0.016865, -0.907854, -0.790441>, <0.382648, -0.907854, -0.220046>, <0.565141, -0.544712, -0.104796>, <0.565141, 0.000000, -0.104796>, 
      <-0.119392, -1.328149, 0.374569>, <0.636682, -1.328149, 0.374569>, <0.945732, -0.796890, 0.374569>, <0.945732, 0.000000, 0.374569>, 
      <0.140010, -1.435909, 0.935328>, <0.780624, -1.435909, 0.896483>, <1.094659, -0.857606, 0.908418>, <1.094659, 0.009848, 0.908418>, 
      <0.160978, -1.493637, 1.466672>, <0.883864, -1.535914, 1.476815>, <1.182372, -0.907201, 1.493508>, <1.182372, 0.005325, 1.493508>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 4 v_steps 4,
      <0.565141, 0.000000, -0.104796>, <0.565141, 0.544712, -0.104796>, <0.382648, 0.907854, -0.220046>, <-0.016865, 0.907854, -0.790441>, 
      <0.945732, 0.000000, 0.374569>, <0.945732, 0.796890, 0.374569>, <0.636682, 1.328149, 0.374569>, <-0.119392, 1.328149, 0.374569>, 
      <1.094659, 0.009848, 0.908418>, <1.094659, 0.877302, 0.908418>, <0.780624, 1.455605, 0.896483>, <0.140010, 1.455605, 0.935328>, 
      <1.182372, 0.005325, 1.493508>, <1.182372, 0.917851, 1.493508>, <0.883864, 1.526202, 1.476815>, <0.160978, 1.508916, 1.466672>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 4 v_steps 4,
      <-0.016865, 0.907854, -0.790441>, <-0.416379, 0.907854, -1.360835>, <-0.598872, 0.544712, -1.476085>, <-0.598872, 0.000000, -1.476085>, 
      <-0.119392, 1.328149, 0.374569>, <-0.875465, 1.328149, 0.374569>, <-1.184515, 0.796890, 0.374569>, <-1.184515, 0.000000, 0.374569>, 
      <0.140010, 1.455605, 0.935328>, <-0.500603, 1.455605, 0.974174>, <-0.814638, 0.877302, 0.962239>, <-0.814638, 0.009848, 0.962239>, 
      <0.160978, 1.508916, 1.466672>, <-0.561908, 1.491629, 1.456528>, <-0.499009, 0.520581, 1.477979>, <-0.499009, 0.005325, 1.477979>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 4 v_steps 4,
      <-0.499009, 0.005325, 1.477979>, <-0.499009, -0.509931, 1.477979>, <-0.561908, -1.451360, 1.456528>, <0.160978, -1.493637, 1.466672>, 
      <-0.183379, 0.000802, 1.993720>, <-0.183379, -0.162256, 1.993720>, <-0.623213, -1.466811, 1.938883>, <0.181945, -1.551365, 1.998015>, 
      <0.270350, -0.044398, 2.524283>, <0.270350, -0.214385, 2.524283>, <-0.781453, -1.696758, 2.433469>, <0.119249, -1.702484, 2.510839>, 
      <0.287092, -0.043882, 3.012782>, <0.287092, -0.209693, 3.012782>, <-0.821054, -1.655656, 2.895142>, <0.075240, -1.661241, 2.990965>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 4 v_steps 4,
      <0.160978, -1.493637, 1.466672>, <0.883864, -1.535914, 1.476815>, <1.182372, -0.907201, 1.493508>, <1.182372, 0.005325, 1.493508>, 
      <0.181945, -1.551365, 1.998015>, <0.987103, -1.635919, 2.057148>, <1.270086, -0.956796, 2.078599>, <1.270086, 0.000802, 2.078599>, 
      <0.119249, -1.702484, 2.510839>, <1.019951, -1.708210, 2.588208>, <1.302560, -1.042685, 2.613245>, <1.302560, -0.044398, 2.613245>, 
      <0.075240, -1.661241, 2.990965>, <0.971535, -1.666827, 3.086789>, <1.253510, -1.017649, 3.117299>, <1.253510, -0.043882, 3.117299>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 4 v_steps 4,
      <1.182372, 0.005325, 1.493508>, <1.182372, 0.917851, 1.493508>, <0.883864, 1.526202, 1.476815>, <0.160978, 1.508916, 1.466672>, 
      <1.270086, 0.000802, 2.078599>, <1.270086, 0.958400, 2.078599>, <0.987103, 1.596799, 2.057148>, <0.181945, 1.562226, 1.998015>, 
      <1.302560, -0.044398, 2.613245>, <1.302560, 0.953890, 2.613245>, <1.019951, 1.619414, 2.588208>, <0.119249, 1.625140, 2.510839>, 
      <1.253510, -0.043882, 3.117299>, <1.253510, 0.929885, 3.117299>, <0.971535, 1.579063, 3.086789>, <0.075240, 1.584649, 2.990965>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 4 v_steps 4,
      <0.160978, 1.508916, 1.466672>, <-0.561908, 1.491629, 1.456528>, <-0.499009, 0.520581, 1.477979>, <-0.499009, 0.005325, 1.477979>, 
      <0.181945, 1.562226, 1.998015>, <-0.623213, 1.527653, 1.938883>, <-0.183379, 0.163861, 1.993720>, <-0.183379, 0.000802, 1.993720>, 
      <0.119249, 1.625140, 2.510839>, <-0.781453, 1.630866, 2.433469>, <0.270350, 0.125589, 2.524283>, <0.270350, -0.044398, 2.524283>, 
      <0.075240, 1.584649, 2.990965>, <-0.821054, 1.590234, 2.895142>, <0.287092, 0.121930, 3.012782>, <0.287092, -0.043882, 3.012782>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 4 v_steps 4,
      <0.287092, -0.043882, 3.012782>, <0.287092, -0.209693, 3.012782>, <-0.821054, -1.655656, 2.895142>, <0.075240, -1.661241, 2.990965>, 
      <0.303835, -0.043366, 3.501282>, <0.303835, -0.205002, 3.501282>, <-0.860655, -1.614554, 3.356814>, <0.031232, -1.619999, 3.471092>, 
      <-0.064880, -0.000386, 3.973360>, <-0.064880, -0.155435, 3.973360>, <-0.860070, -1.507535, 3.835205>, <-0.004835, -1.512758, 3.983793>, 
      <-0.333885, 0.034997, 4.407205>, <-0.333885, -0.102339, 4.411940>, <-0.858488, -1.303800, 4.335941>, <-0.110889, -1.300592, 4.509368>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 4 v_steps 4,
      <0.075240, -1.661241, 2.990965>, <0.971535, -1.666827, 3.086789>, <1.253510, -1.017649, 3.117299>, <1.253510, -0.043882, 3.117299>, 
      <0.031232, -1.619999, 3.471092>, <0.923119, -1.625443, 3.585369>, <1.204459, -0.992612, 3.621353>, <1.204459, -0.043366, 3.621353>, 
      <-0.004835, -1.512758, 3.983793>, <0.850401, -1.517981, 4.132380>, <1.130006, -0.910943, 4.180958>, <1.130006, -0.000386, 4.180958>, 
      <-0.110889, -1.300592, 4.509368>, <0.636710, -1.297383, 4.682795>, <0.901793, -0.756795, 4.725120>, <0.901793, 0.049745, 4.697316>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 4 v_steps 4,
      <1.253510, -0.043882, 3.117299>, <1.253510, 0.929885, 3.117299>, <0.971535, 1.579063, 3.086789>, <0.075240, 1.584649, 2.990965>, 
      <1.204459, -0.043366, 3.621353>, <1.204459, 0.905881, 3.621353>, <0.923119, 1.538712, 3.585369>, <0.031232, 1.544157, 3.471092>, 
      <1.130006, -0.000386, 4.180958>, <1.130006, 0.910170, 4.180958>, <0.850401, 1.517208, 4.132380>, <-0.004835, 1.522431, 3.983793>, 
      <0.901793, 0.049745, 4.697316>, <0.901793, 0.856285, 4.669512>, <0.636710, 1.391084, 4.590115>, <-0.110889, 1.387876, 4.416688>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 4 v_steps 4,
      <0.075240, 1.584649, 2.990965>, <-0.821054, 1.590234, 2.895142>, <0.287092, 0.121930, 3.012782>, <0.287092, -0.043882, 3.012782>, 
      <0.031232, 1.544157, 3.471092>, <-0.860655, 1.549601, 3.356814>, <0.303835, 0.118271, 3.501282>, <0.303835, -0.043366, 3.501282>, 
      <-0.004835, 1.522431, 3.983793>, <-0.860070, 1.527653, 3.835205>, <-0.064880, 0.154662, 3.973360>, <-0.064880, -0.000386, 3.973360>, 
      <-0.110889, 1.387876, 4.416688>, <-0.858488, 1.384667, 4.243260>, <-0.333885, 0.172334, 4.402471>, <-0.333885, 0.034997, 4.407205>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 4 v_steps 4,
      <-0.333885, 0.034997, 4.407205>, <-0.333885, -0.102339, 4.411940>, <-0.858488, -1.303800, 4.335941>, <-0.110889, -1.300592, 4.509368>, 
      <-0.602889, 0.070381, 4.841050>, <-0.602889, -0.049244, 4.850519>, <-0.856906, -1.100065, 4.836676>, <-0.216943, -1.088425, 5.034944>, 
      <-0.832402, 0.106836, 5.293372>, <-0.832402, 0.025610, 5.299802>, <-0.806810, -0.682122, 5.363340>, <-0.329562, -0.673830, 5.502873>, 
      <-0.265473, 0.121424, 5.488486>, <-0.265473, 0.121424, 5.488486>, <-0.265473, 0.121424, 5.488486>, <-0.265473, 0.121424, 5.488486>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 4 v_steps 4,
      <-0.110889, -1.300592, 4.509368>, <0.636710, -1.297383, 4.682795>, <0.901793, -0.756795, 4.725120>, <0.901793, 0.049745, 4.697316>, 
      <-0.216943, -1.088425, 5.034944>, <0.423020, -1.076786, 5.233211>, <0.673581, -0.602648, 5.269282>, <0.673581, 0.099876, 5.213674>, 
      <-0.329562, -0.673830, 5.502873>, <0.147685, -0.665539, 5.642406>, <0.333976, -0.343226, 5.671616>, <0.333976, 0.133787, 5.633858>, 
      <-0.265473, 0.121424, 5.488486>, <-0.265473, 0.121424, 5.488486>, <-0.265473, 0.121424, 5.488486>, <-0.265473, 0.121424, 5.488486>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 4 v_steps 4,
      <0.901793, 0.049745, 4.697316>, <0.901793, 0.856285, 4.669512>, <0.636710, 1.391084, 4.590115>, <-0.110889, 1.387876, 4.416688>, 
      <0.673581, 0.099876, 5.213674>, <0.673581, 0.802400, 5.158066>, <0.423020, 1.264960, 5.047850>, <-0.216943, 1.253320, 4.849583>, 
      <0.333976, 0.133787, 5.633858>, <0.333976, 0.610799, 5.596100>, <0.147685, 0.924503, 5.516547>, <-0.329562, 0.916211, 5.377014>, 
      <-0.265473, 0.121424, 5.488486>, <-0.265473, 0.121424, 5.488486>, <-0.265473, 0.121424, 5.488486>, <-0.265473, 0.121424, 5.488486>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 4 v_steps 4,
      <-0.110889, 1.387876, 4.416688>, <-0.858488, 1.384667, 4.243260>, <-0.333885, 0.172334, 4.402471>, <-0.333885, 0.034997, 4.407205>, 
      <-0.216943, 1.253320, 4.849583>, <-0.856906, 1.241681, 4.651316>, <-0.602889, 0.190006, 4.831581>, <-0.602889, 0.070381, 4.841050>, 
      <-0.329562, 0.916211, 5.377014>, <-0.806810, 0.907920, 5.237480>, <-0.832402, 0.188061, 5.286943>, <-0.832402, 0.106836, 5.293372>, 
      <-0.265473, 0.121424, 5.488486>, <-0.265473, 0.121424, 5.488486>, <-0.265473, 0.121424, 5.488486>, <-0.265473, 0.121424, 5.488486>
    }
  }
  texture {
    hellbraun
  }
  scale <0.2, 0.2, 0.11>
  rotate 90.0*z
  translate  <1.0, 1.0, 1.5>
}
#declare Arm1 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 4 v_steps 4,
      <-2.472374, -2.401335, 2.075995>, <-2.322572, -2.929019, 2.116099>, <-1.980624, -3.328239, 1.757358>, <-1.267322, -3.159215, 1.316935>, 
      <-0.738186, -1.064680, 2.235563>, <-0.588384, -1.421441, 2.265613>, <-0.145552, -2.127582, 2.009697>, <0.245884, -2.045146, 1.632229>, 
      <-0.665393, -1.038976, 2.301864>, <-0.515590, -1.395737, 2.331914>, <0.017566, -1.722413, 2.213477>, <0.519399, -1.593999, 2.028616>, 
      <-0.568791, -0.871838, 2.493412>, <-0.418988, -1.314061, 2.528489>, <0.125229, -1.632809, 2.473046>, <0.640581, -1.494705, 2.365177>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 4 v_steps 4,
      <-1.267322, -3.159215, 1.316935>, <-0.554020, -2.990190, 0.876513>, <-0.457204, -2.525927, 0.452147>, <-0.607007, -1.998243, 0.412042>, 
      <0.245884, -2.045146, 1.632229>, <0.637320, -1.962710, 1.254761>, <0.835020, -1.463521, 0.913110>, <0.685217, -0.935837, 0.873006>, 
      <0.519399, -1.593999, 2.028616>, <1.021232, -1.465584, 1.843755>, <1.309257, -0.928776, 1.659693>, <1.159454, -0.401092, 1.619588>, 
      <0.640581, -1.494705, 2.365177>, <1.155932, -1.356602, 2.257309>, <1.455018, -0.811866, 2.136240>, <1.305215, -0.284182, 2.096136>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 4 v_steps 4,
      <-0.607007, -1.998243, 0.412042>, <-0.756810, -1.470558, 0.371938>, <-1.098757, -1.071338, 0.730679>, <-1.812059, -1.240363, 1.171102>, 
      <0.685217, -0.935837, 0.873006>, <0.535415, -0.408152, 0.832902>, <0.092583, -0.043858, 1.108927>, <-0.298853, -0.126294, 1.486395>, 
      <1.159454, -0.401092, 1.619588>, <1.009652, 0.126592, 1.579484>, <0.476495, 0.453268, 1.697921>, <-0.025338, 0.324854, 1.882782>, 
      <1.305215, -0.284182, 2.096136>, <1.155412, 0.243502, 2.056031>, <0.611195, 0.562250, 2.111475>, <0.095844, 0.424147, 2.219343>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 4 v_steps 4,
      <-1.812059, -1.240363, 1.171102>, <-2.525361, -1.409387, 1.611524>, <-2.622177, -1.873650, 2.035890>, <-2.472374, -2.401335, 2.075995>, 
      <-0.298853, -0.126294, 1.486395>, <-0.690289, -0.208729, 1.863863>, <-0.887989, -0.707919, 2.205513>, <-0.738186, -1.064680, 2.235563>, 
      <-0.025338, 0.324854, 1.882782>, <-0.527171, 0.196439, 2.067643>, <-0.815195, -0.682215, 2.271814>, <-0.665393, -1.038976, 2.301864>, 
      <0.095844, 0.424147, 2.219343>, <-0.419508, 0.286043, 2.327212>, <-0.718594, -0.429615, 2.458335>, <-0.568791, -0.871838, 2.493412>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 4 v_steps 4,
      <-0.568791, -0.871838, 2.493412>, <-0.418988, -1.314061, 2.528489>, <0.125229, -1.632809, 2.473046>, <0.640581, -1.494705, 2.365177>, 
      <-0.472189, -0.704700, 2.684960>, <-0.322387, -1.232385, 2.725065>, <0.232891, -1.543205, 2.732615>, <0.761762, -1.395412, 2.701738>, 
      <-0.519427, -0.604400, 3.022469>, <-0.365975, -1.132085, 3.044868>, <0.190701, -1.437378, 3.088543>, <0.717631, -1.282831, 3.119526>, 
      <-0.591576, -0.339774, 3.586310>, <-0.514850, -0.848000, 3.597510>, <-0.058289, -1.221090, 3.619347>, <0.423004, -1.143816, 3.634838>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 4 v_steps 4,
      <0.640581, -1.494705, 2.365177>, <1.155932, -1.356602, 2.257309>, <1.455018, -0.811866, 2.136240>, <1.305215, -0.284182, 2.096136>, 
      <0.761762, -1.395412, 2.701738>, <1.290632, -1.247619, 2.670862>, <1.600779, -0.694956, 2.612787>, <1.450976, -0.167272, 2.572683>, 
      <0.717631, -1.282831, 3.119526>, <1.244561, -1.128283, 3.150508>, <1.550134, -0.570093, 3.157532>, <1.396682, -0.042409, 3.135133>, 
      <0.423004, -1.143816, 3.634838>, <0.904298, -1.066542, 3.650330>, <1.235307, -0.567004, 3.653841>, <1.158581, -0.058778, 3.642642>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 4 v_steps 4,
      <1.305215, -0.284182, 2.096136>, <1.155412, 0.243502, 2.056031>, <0.611195, 0.562250, 2.111475>, <0.095844, 0.424147, 2.219343>, 
      <1.450976, -0.167272, 2.572683>, <1.301173, 0.360413, 2.532578>, <0.745895, 0.671233, 2.525028>, <0.217025, 0.523440, 2.555905>, 
      <1.396682, -0.042409, 3.135133>, <1.243230, 0.485276, 3.112735>, <0.686553, 0.790569, 3.069060>, <0.159624, 0.636022, 3.038077>, 
      <1.158581, -0.058778, 3.642642>, <1.081855, 0.449448, 3.631443>, <0.625294, 0.822538, 3.609605>, <0.144001, 0.745264, 3.594114>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 4 v_steps 4,
      <0.095844, 0.424147, 2.219343>, <-0.419508, 0.286043, 2.327212>, <-0.718594, -0.429615, 2.458335>, <-0.568791, -0.871838, 2.493412>, 
      <0.217025, 0.523440, 2.555905>, <-0.311846, 0.375647, 2.586781>, <-0.621992, -0.177016, 2.644856>, <-0.472189, -0.704700, 2.684960>, 
      <0.159624, 0.636022, 3.038077>, <-0.367306, 0.481474, 3.007094>, <-0.672879, -0.076716, 3.000071>, <-0.519427, -0.604400, 3.022469>, 
      <0.144001, 0.745264, 3.594114>, <-0.337293, 0.667990, 3.578623>, <-0.668302, 0.168452, 3.575111>, <-0.591576, -0.339774, 3.586310>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 4 v_steps 4,
      <-0.591576, -0.339774, 3.586310>, <-0.514850, -0.848000, 3.597510>, <-0.058289, -1.221090, 3.619347>, <0.423004, -1.143816, 3.634838>, 
      <-0.663726, -0.075147, 4.150151>, <-0.663726, -0.563916, 4.150151>, <-0.307279, -1.004802, 4.150151>, <0.128378, -1.004802, 4.150151>, 
      <-0.655836, -0.010019, 4.629179>, <-0.655836, -0.498787, 4.629179>, <-0.319590, -0.939673, 4.629179>, <0.091377, -0.939673, 4.629179>, 
      <-0.630407, -0.005009, 4.814589>, <-0.630407, -0.518824, 4.814589>, <-0.309312, -0.959710, 4.814589>, <0.083139, -0.959710, 4.814589>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 4 v_steps 4,
      <0.423004, -1.143816, 3.634838>, <0.904298, -1.066542, 3.650330>, <1.235307, -0.567004, 3.653841>, <1.158581, -0.058778, 3.642642>, 
      <0.128378, -1.004802, 4.150151>, <0.564035, -1.004802, 4.150151>, <0.920481, -0.563916, 4.150151>, <0.920481, -0.075147, 4.150151>, 
      <0.091377, -0.939673, 4.629179>, <0.502345, -0.939673, 4.629179>, <0.838591, -0.498787, 4.629179>, <0.838591, -0.010019, 4.629179>, 
      <0.083139, -0.959710, 4.814589>, <0.475589, -0.959710, 4.814589>, <0.796684, -0.518824, 4.814589>, <0.796684, -0.005009, 4.814589>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 4 v_steps 4,
      <1.158581, -0.058778, 3.642642>, <1.081855, 0.449448, 3.631443>, <0.625294, 0.822538, 3.609605>, <0.144001, 0.745264, 3.594114>, 
      <0.920481, -0.075147, 4.150151>, <0.920481, 0.413621, 4.150151>, <0.564035, 0.854507, 4.150151>, <0.128378, 0.854507, 4.150151>, 
      <0.838591, -0.010019, 4.629179>, <0.838591, 0.478750, 4.629179>, <0.502345, 0.919636, 4.629179>, <0.091377, 0.919636, 4.629179>, 
      <0.796684, -0.005009, 4.814589>, <0.796684, 0.508805, 4.814589>, <0.475589, 0.949691, 4.814589>, <0.083139, 0.949691, 4.814589>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 4 v_steps 4,
      <0.144001, 0.745264, 3.594114>, <-0.337293, 0.667990, 3.578623>, <-0.668302, 0.168452, 3.575111>, <-0.591576, -0.339774, 3.586310>, 
      <0.128378, 0.854507, 4.150151>, <-0.307279, 0.854507, 4.150151>, <-0.663726, 0.413621, 4.150151>, <-0.663726, -0.075147, 4.150151>, 
      <0.091377, 0.919636, 4.629179>, <-0.319590, 0.919636, 4.629179>, <-0.655836, 0.478750, 4.629179>, <-0.655836, -0.010019, 4.629179>, 
      <0.083139, 0.949691, 4.814589>, <-0.309312, 0.949691, 4.814589>, <-0.630407, 0.508805, 4.814589>, <-0.630407, -0.005009, 4.814589>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 4 v_steps 4,
      <-0.630407, -0.005009, 4.814589>, <-0.630407, -0.518824, 4.814589>, <-0.309312, -0.959710, 4.814589>, <0.083139, -0.959710, 4.814589>, 
      <-0.604978, 0.000000, 5.000000>, <-0.604978, -0.538861, 5.000000>, <-0.299033, -0.979747, 5.000000>, <0.074900, -0.979747, 5.000000>, 
      <-0.762669, 0.000000, 5.500000>, <-0.762669, -0.617575, 5.500000>, <-0.419468, -1.122863, 5.500000>, <0.000000, -1.122863, 5.500000>, 
      <-0.791945, 0.000000, 6.020973>, <-0.791945, -0.750000, 6.020973>, <-0.541945, -1.250000, 6.020973>, <-0.041945, -1.250000, 6.020973>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 4 v_steps 4,
      <0.083139, -0.959710, 4.814589>, <0.475589, -0.959710, 4.814589>, <0.796684, -0.518824, 4.814589>, <0.796684, -0.005009, 4.814589>, 
      <0.074900, -0.979747, 5.000000>, <0.448833, -0.979747, 5.000000>, <0.754778, -0.538861, 5.000000>, <0.754778, 0.000000, 5.000000>, 
      <0.000000, -1.122863, 5.500000>, <0.419468, -1.122863, 5.500000>, <0.762669, -0.617575, 5.500000>, <0.762669, 0.000000, 5.500000>, 
      <-0.041945, -1.250000, 6.020973>, <0.458055, -1.250000, 6.020973>, <0.708055, -0.750000, 6.020973>, <0.708055, 0.000000, 6.020973>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 4 v_steps 4,
      <0.796684, -0.005009, 4.814589>, <0.796684, 0.508805, 4.814589>, <0.475589, 0.949691, 4.814589>, <0.083139, 0.949691, 4.814589>, 
      <0.754778, 0.000000, 5.000000>, <0.754778, 0.538861, 5.000000>, <0.448833, 0.979747, 5.000000>, <0.074900, 0.979747, 5.000000>, 
      <0.762669, 0.000000, 5.500000>, <0.762669, 0.617575, 5.500000>, <0.419468, 1.122863, 5.500000>, <0.000000, 1.122863, 5.500000>, 
      <0.708055, 0.000000, 6.020973>, <0.708055, 0.750000, 6.020973>, <0.458055, 1.250000, 6.020973>, <-0.041945, 1.250000, 6.020973>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 4 v_steps 4,
      <0.083139, 0.949691, 4.814589>, <-0.309312, 0.949691, 4.814589>, <-0.630407, 0.508805, 4.814589>, <-0.630407, -0.005009, 4.814589>, 
      <0.074900, 0.979747, 5.000000>, <-0.299033, 0.979747, 5.000000>, <-0.604978, 0.538861, 5.000000>, <-0.604978, 0.000000, 5.000000>, 
      <0.000000, 1.122863, 5.500000>, <-0.419468, 1.122863, 5.500000>, <-0.762669, 0.617575, 5.500000>, <-0.762669, 0.000000, 5.500000>, 
      <-0.041945, 1.250000, 6.020973>, <-0.541945, 1.250000, 6.020973>, <-0.791945, 0.750000, 6.020973>, <-0.791945, 0.000000, 6.020973>
    }
  }
  texture {
    braun
  }
  scale -0.2
  rotate <-180.0, 0.0, -90.0>
  translate  <1.0, 1.0, 0.4>
}
#declare Arm_gesamt1 = union {
  object { Pfote1 }
  object { Arm1 }
  scale -1.0
  rotate <170.0, -25.0, -165.0>
  translate  <-0.85, 0.1, 2.08>
}
#declare Hals = union { 
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 4 v_steps 4,
      <-0.147384, 0.000000, 0.926228>, <-0.147384, 0.000000, 0.926228>, <-0.147384, 0.000000, 0.926228>, <-0.147384, 0.000000, 0.926228>, 
      <-0.080433, 0.000000, 1.263533>, <-0.080433, -0.415935, 1.263533>, <-0.074666, -0.756246, 1.543187>, <0.037338, -0.756246, 1.037068>, 
      <-0.590739, 0.000000, 1.660988>, <-0.590739, -0.463698, 1.660988>, <-0.111167, -0.843087, 1.501299>, <0.174680, -0.843087, 1.306100>, 
      <-0.461927, 0.000000, 1.875426>, <-0.461927, -0.356285, 1.875426>, <-0.129796, -0.647791, 1.803734>, <0.174703, -0.647791, 1.687368>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 4 v_steps 4,
      <-0.147384, 0.000000, 0.926228>, <-0.147384, 0.000000, 0.926228>, <-0.147384, 0.000000, 0.926228>, <-0.147384, 0.000000, 0.926228>, 
      <0.037338, -0.756246, 1.037068>, <0.149342, -0.756246, 0.530949>, <0.164222, -0.526195, 0.199876>, <0.164222, 0.000000, 0.199876>, 
      <0.174680, -0.843087, 1.306100>, <0.460528, -0.843087, 1.110901>, <1.016129, -0.637088, 0.874449>, <1.016129, 0.040107, 0.874449>, 
      <0.174703, -0.647791, 1.687368>, <0.479203, -0.647791, 1.571002>, <0.913008, -0.475966, 1.484032>, <0.913008, 0.020054, 1.484032>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 4 v_steps 4,
      <-0.147384, 0.000000, 0.926228>, <-0.147384, 0.000000, 0.926228>, <-0.147384, 0.000000, 0.926228>, <-0.147384, 0.000000, 0.926228>, 
      <0.164222, 0.000000, 0.199876>, <0.164222, 0.526195, 0.199876>, <0.149342, 0.756246, 0.530949>, <0.037338, 0.756246, 1.037068>, 
      <1.016129, 0.040107, 0.874449>, <1.016129, 0.717302, 0.874449>, <0.460528, 0.843087, 1.110901>, <0.174680, 0.843087, 1.306100>, 
      <0.913008, 0.020054, 1.484032>, <0.913008, 0.516073, 1.484032>, <0.479203, 0.647791, 1.571002>, <0.174703, 0.647791, 1.687368>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 4 v_steps 4,
      <-0.147384, 0.000000, 0.926228>, <-0.147384, 0.000000, 0.926228>, <-0.147384, 0.000000, 0.926228>, <-0.147384, 0.000000, 0.926228>, 
      <0.037338, 0.756246, 1.037068>, <-0.074666, 0.756246, 1.543187>, <-0.080433, 0.415935, 1.263533>, <-0.080433, 0.000000, 1.263533>, 
      <0.174680, 0.843087, 1.306100>, <-0.111167, 0.843087, 1.501299>, <-0.590739, 0.463698, 1.660988>, <-0.590739, 0.000000, 1.660988>, 
      <0.174703, 0.647791, 1.687368>, <-0.129796, 0.647791, 1.803734>, <-0.461927, 0.356285, 1.875426>, <-0.461927, 0.000000, 1.875426>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 4 v_steps 4,
      <-0.461927, 0.000000, 1.875426>, <-0.461927, -0.356285, 1.875426>, <-0.129796, -0.647791, 1.803734>, <0.174703, -0.647791, 1.687368>, 
      <-0.333116, 0.000000, 2.089865>, <-0.333116, -0.248872, 2.089865>, <-0.148424, -0.452494, 2.106169>, <0.174727, -0.452494, 2.068636>, 
      <0.100238, 0.000000, 2.445108>, <0.100238, -0.246954, 2.445108>, <0.308177, -0.449007, 2.459007>, <0.562324, -0.388432, 2.475994>, 
      <0.063894, 0.000000, 3.174181>, <0.063894, -0.337542, 3.174181>, <0.358033, -0.613712, 3.004941>, <0.801561, -0.587453, 2.936967>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 4 v_steps 4,
      <0.174703, -0.647791, 1.687368>, <0.479203, -0.647791, 1.571002>, <0.913008, -0.475966, 1.484032>, <0.913008, 0.020054, 1.484032>, 
      <0.174727, -0.452494, 2.068636>, <0.497878, -0.452494, 2.031104>, <0.809886, -0.314845, 2.093615>, <0.809886, 0.000000, 2.093615>, 
      <0.562324, -0.388432, 2.475994>, <0.816472, -0.327856, 2.492981>, <1.024411, -0.234228, 2.506879>, <1.024411, 0.000000, 2.506879>, 
      <0.801561, -0.587453, 2.936967>, <1.245090, -0.561194, 2.855762>, <1.182490, -0.112643, 2.625471>, <1.182490, 0.004471, 2.625471>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 4 v_steps 4,
      <0.913008, 0.020054, 1.484032>, <0.913008, 0.516073, 1.484032>, <0.479203, 0.647791, 1.571002>, <0.174703, 0.647791, 1.687368>, 
      <0.809886, 0.000000, 2.093615>, <0.809886, 0.314845, 2.093615>, <0.497878, 0.452494, 2.031104>, <0.174727, 0.452494, 2.068636>, 
      <1.024411, 0.000000, 2.506879>, <1.024411, 0.234228, 2.506879>, <0.816472, 0.327856, 2.492981>, <0.562324, 0.388432, 2.475994>, 
      <1.182490, 0.004471, 2.625471>, <1.182490, 0.121585, 2.625471>, <1.237089, 0.547329, 2.864582>, <0.797561, 0.580521, 2.941376>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 4 v_steps 4,
      <0.174703, 0.647791, 1.687368>, <-0.129796, 0.647791, 1.803734>, <-0.461927, 0.356285, 1.875426>, <-0.461927, 0.000000, 1.875426>, 
      <0.174727, 0.452494, 2.068636>, <-0.148424, 0.452494, 2.106169>, <-0.333116, 0.248872, 2.089865>, <-0.333116, 0.000000, 2.089865>, 
      <0.562324, 0.388432, 2.475994>, <0.308177, 0.449007, 2.459007>, <0.100238, 0.246954, 2.445108>, <0.100238, 0.000000, 2.445108>, 
      <0.797561, 0.580521, 2.941376>, <0.358033, 0.613712, 3.004941>, <0.063894, 0.337542, 3.174181>, <0.063894, 0.000000, 3.174181>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 4 v_steps 4,
      <0.063894, 0.000000, 3.174181>, <0.063894, -0.337542, 3.174181>, <0.358033, -0.613712, 3.004941>, <0.801561, -0.587453, 2.936967>, 
      <0.027551, 0.000000, 3.903253>, <0.027551, -0.428129, 3.903253>, <0.407889, -0.778417, 3.550875>, <1.040799, -0.786475, 3.384710>, 
      <1.075006, -0.017900, 3.742157>, <1.076368, -0.150843, 3.740655>, <1.066306, -0.260753, 3.830045>, <1.386029, -0.253021, 3.419217>, 
      <1.218638, -0.021638, 3.280275>, <1.218638, -0.021638, 3.280275>, <1.218638, -0.021638, 3.280275>, <1.218638, -0.021638, 3.280275>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 4 v_steps 4,
      <0.801561, -0.587453, 2.936967>, <1.245090, -0.561194, 2.855762>, <1.182490, -0.112643, 2.625471>, <1.182490, 0.004471, 2.625471>, 
      <1.040799, -0.786475, 3.384710>, <1.673709, -0.794532, 3.218544>, <1.340569, 0.008942, 2.744062>, <1.340569, 0.008942, 2.744062>, 
      <1.386029, -0.253021, 3.419217>, <1.705751, -0.245288, 3.008388>, <1.693988, -0.137101, 3.099654>, <1.693276, -0.004147, 3.100438>, 
      <1.218638, -0.021638, 3.280275>, <1.218638, -0.021638, 3.280275>, <1.218638, -0.021638, 3.280275>, <1.218638, -0.021638, 3.280275>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 4 v_steps 4,
      <1.182490, 0.004471, 2.625471>, <1.182490, 0.121585, 2.625471>, <1.237089, 0.547329, 2.864582>, <0.797561, 0.580521, 2.941376>, 
      <1.340569, 0.008942, 2.744062>, <1.340569, 0.008942, 2.744062>, <1.657706, 0.766802, 3.236184>, <1.032798, 0.772610, 3.393529>, 
      <1.693276, -0.004147, 3.100438>, <1.692565, 0.128808, 3.101222>, <1.703164, 0.238183, 3.011240>, <1.382258, 0.230430, 3.423373>, 
      <1.218638, -0.021638, 3.280275>, <1.218638, -0.021638, 3.280275>, <1.218638, -0.021638, 3.280275>, <1.218638, -0.021638, 3.280275>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 4 v_steps 4,
      <0.797561, 0.580521, 2.941376>, <0.358033, 0.613712, 3.004941>, <0.063894, 0.337542, 3.174181>, <0.063894, 0.000000, 3.174181>, 
      <1.032798, 0.772610, 3.393529>, <0.407889, 0.778417, 3.550875>, <0.027551, 0.428129, 3.903253>, <0.027551, 0.000000, 3.903253>, 
      <1.382258, 0.230430, 3.423373>, <1.061351, 0.222677, 3.835507>, <1.073643, 0.115044, 3.743659>, <1.075006, -0.017900, 3.742157>, 
      <1.218638, -0.021638, 3.280275>, <1.218638, -0.021638, 3.280275>, <1.218638, -0.021638, 3.280275>, <1.218638, -0.021638, 3.280275>
    }
  }
  texture {
    hellbraun
  }
  translate  -1.43*z
}
#declare Hals_gesamt = difference {
  object { Hals }
  sphere { // Mund
    <0,0,0>,1
    texture {
      schwarz
    }
    scale <0.1, 0.1, 0.15>
    rotate 40.0*y
    translate  <1.455, 0.0, 1.35>
  }
  translate  1.43*z
}
union { // Haeschen
  object { Koerper }
  sphere { // Nase
    <0,0,0>,1
    texture {
      schwarz
    }
    scale 0.2
    translate  <1.3, 0.0, 3.2>
  }
  object { Schnurhaare }
  object { Schnurhaare1 }
  object { Schaenzchen }
  object { Fuesse }
  object { Augen }
  object { Ohren }
  object { Arm_gesamt }
  object { Arm_gesamt1 }
  object { Hals_gesamt }
  scale 3.051059
  rotate 109.002296*z
  translate  <0.157597, -13.299813, -6.933202>
}


