#include "colors.inc"
#include "woods.inc"
#include "stones.inc"
#include "textures.inc"

//*************************************************************************

camera{
    location <0,10,-30>
    look_at <0,10,0> 
    }
     
light_source{<10,80,-80> color White}

cone{<-1,0,-6>,10,<9,40,-3>,3 pigment{White filter 0.9} finish {ambient 1} no_shadow}

//************************************************************************
//Constants

#declare Length=35;
#declare Height=0.1;
#declare Width=5;
#declare WalkWay_Width=Width+3; 
#declare Fence_Length=3;
#declare Fence_Depth=15;
#declare Snow_Dim=12;
#declare Snow_num=20;

//*************************************************************************
//Snowpeople Stuff
          
#declare Snow_Body=
union{    
 sphere { <0, 1, 0>, 2 }   
 sphere { <0, 3.8, 0>, 1.5 }
 sphere { <0, 5.8, 0>, 1 }    
 texture { 
      pigment { color White*1.5 }
      normal { wrinkles 0.4 scale 0.2 }
      finish { phong 0.5}
    }
 }

#declare Face=
union{
//Eyes
 sphere{<-0.25,6.1,-1>,0.1 pigment{Black}}
 sphere{<0.25,6.1,-1>,0.1 pigment{Black}}  
//Nose
 cone{<0,5.8,-2>,0,<0,5.8,-1>,0.15 pigment{Orange*1.5}}
//Mouth 
 sphere{<-0.4,5.5,-0.85>,0.1 pigment{Black}}
 sphere{<-0.2,5.4,-0.9>,0.1 pigment{Black}}
 sphere{<0,5.4,-1>,0.1 pigment{Black}}
 sphere{<0.2,5.4,-0.9>,0.1 pigment{Black}}
 sphere{<0.4,5.5,-0.85>,0.1 pigment{Black}}
}

#declare Accesories=
union{
 sphere{<0,3.3,-1.4>,0.1}
 sphere{<0,3.8,-1.5>,0.1}
 sphere{<0,4.3,-1.4>,0.1}
}  

#declare Wire=
difference{
 cylinder{<0,0,-0.1>,<0,0,0.1>,1 pigment {Black}}
 cylinder{<0,0,-0.2>,<0,0,0.2>,0.9}
 box{<-1.1,0,-0.2>,<1.1,-1.1,0.2>}
}

#declare Earmuffs=                   
union{
 object{Wire scale <1,1.5,1>}
 sphere{<1,0,0>,0.2 scale <1.2,1.5,1> pigment{Red}}
 sphere{<-1,0,0>,0.2 scale <1.2,1.5,1> pigment{Red}}
}

#declare Scarf=
union{
 difference{
  cylinder{<0,0,0>,<0,1,0>,1 }
  cylinder{<0,-0.1,0>,<0,1.1,0>,0.9 }
 }
 difference{ 
  box{<-0.3,1,-0.9>,<0.3,-1,-1.5> }
  difference{
   cylinder{<-0.4,0,0>,<0.4,0,0>,2 }
   cylinder{<-0.5,0,0>,<0.5,0,0>,1.5 }
   box{<-0.6,0,-4>,<0.6,-3,4> }  
  }                                                  
 } 
 cylinder{<-0.2,-1,-1.5>,<-0.2,-1.4,-1.5>,0.05}
 cylinder{<0,-1,-1.5>,<0,-1.4,-1.5>,0.05}
 cylinder{<0.2,-1,-1.5>,<0.2,-1.4,-1.5>,0.05}
 texture{
       pigment{checker color Light_Purple, color Yellow  scale 0.3}
       normal{wrinkles 0.6 scale 0.1}
 } 
} 

#declare Right_Arm=
union{
 cylinder{<-1,4.5,0>,<-2,4,-2>, 0.075}
 sphere{<-2,4,-2>,0.075}
 cylinder{<-2,4,-2>,<-1,3.5,-3>, 0.075}
 sphere{<-1,3.5,-3>,0.075}
 cone{<-0.5,3.8,-3.3>,0,<-1,3.5,-3>, 0.05}
 cone{<-0.5,3.2,-3.3>,0,<-1,3.5,-3>, 0.05}
 pigment{DarkWood}
} 
 
#declare Left_Arm=
union{
 cylinder{<1,4.5,0>,<2,4,-2>,0.075}
 sphere{<2,4,-2>,0.075}
 cylinder{<2,4,-2>,<2,4.5,-4>, 0.075}
 sphere{<2,4.5,-4>,0.075}
 cone{<2,4.8,-4.3>,0,<2,4.5,-4>, 0.05}
 cone{<2,4.2,-4.3>,0,<2,4.5,-4>, 0.05} 
 pigment{DarkWood}
}

#declare Buckle=
difference{
 superellipsoid { <0.5, 0.1>
    scale <.2, .1, .1>
  }
 cylinder { <0,0,-1>,<0,0,1>,0.1 }
 pigment{Gold}
}   

#declare Top_Hat=
union{
 sor {
    5,
    <1.2,6.7>,
    <1,6.4>,
    <0.8,6.5>,
    <0.8,7.6>,
    <0,7.7>
    pigment {Black}
  }
 object {Buckle pigment {Gold} translate <0,6.6,-0.7>}
  } 

#declare Bonnett=
sor {
   5,
   <2,7>,
   <1.5,6.6>,
   <0.8,6.7>,
   <0.7,7.2>,
   <0,7.8>
   pigment{Yellow}
   }

#declare Snow_Man=
union{
 object{Snow_Body}
 object{Earmuffs rotate -50*y translate 5.8*y}
 object{Face rotate -50*y}
 object{Accesories pigment{Blue}}
 object{Top_Hat rotate -50*y}
 object{Right_Arm}
 object{Left_Arm}
}

#declare Snow_Woman=
union{
 object{Snow_Body}
 object{Face rotate 50*y}
 object{Accesories pigment{Red}}
 object{Scarf rotate 30*y translate 4.3*y}
 object{Bonnett rotate 50*y}
 object{Right_Arm}
 object{Left_Arm}
}
        
//*************************************************************************
//Snow Stuff
       
#declare Snow_Flake=
mesh{
 triangle{<-0.02,0,0>,<0.02,0,0>,<0,0.02,0>}
 triangle{<0,0.04,0>,<-0.02,0.06,0>,<0.02,0.06,0>}
 triangle{<-0.02,0,0>,<0.02,0,0>,<0,-0.02,0>}
 triangle{<0,-0.04,0>,<-0.02,-0.06,0>,<0.02,-0.06,0>}
 triangle{<0.04,0,0>,<0.06,0.02,0>,<0.06,-0.02,0>}
 triangle{<-0.04,0,0>,<-0.06,0.02,0>,<-0.06,-0.02,0>}
 triangle{<-0.02,0.02,0>,<0.02,0.02,0>,<0,0.08,0>}
 triangle{<0.02,-0.02,0>,<0.02,0.02,0>,<0.08,0,0>} 
 triangle{<-0.02,-0.02,0>,<0.02,-0.02,0>,<0,-0.08,0>}
 triangle{<-0.02,-0.02,0>,<-0.02,0.02,0>,<-0.08,0,0>}                 
}

#declare Snow_in_Air=
union{
 #declare R1=seed(0);
 #declare R2=seed(1);
 #declare R3=seed(2);
 #declare i=1;
 #while (i<10)
  #declare j=1;
  #while (j<10)
   #declare k=1;
   #while (k<10)
    object {Snow_Flake translate <rand(R1)*30,rand(R1)*20,rand(R1)*30> pigment{White*3}}
    #declare k=k+1;
   #end 
   #declare j=j+1;
  #end 
  #declare i=i+1;
 #end
}
            
//*************************************************************************
//Snow Heart
  
#declare Snow_Heart=
union{
 object{Snow_Flake translate <0,8.8,0>}
 object{Snow_Flake translate <0.2,9,0>}
 object{Snow_Flake translate <0.4,9.1,0>}
 object{Snow_Flake translate <0.6,9.2,0>}
 object{Snow_Flake translate <0.8,9.25,0>}
 object{Snow_Flake translate <1,9.2,0>}
 object{Snow_Flake translate <1.2,9.12,0>}
 object{Snow_Flake translate <1.4,9.02,0>}
 object{Snow_Flake translate <1.6,8.9,0>}
 object{Snow_Flake translate <1.75,8.7,0>}
 object{Snow_Flake translate <1.85,8.5,0>}
 object{Snow_Flake translate <1.95,8.3,0>}
 object{Snow_Flake translate <2,8.1,0>}
 object{Snow_Flake translate <2,7.9,0>}
 object{Snow_Flake translate <1.95,7.7,0>}
 object{Snow_Flake translate <1.9,7.5,0>}
 object{Snow_Flake translate <1.71,7.3,0>}
 object{Snow_Flake translate <1.52,7.1,0>}
 object{Snow_Flake translate <1.33,6.9,0>}
 object{Snow_Flake translate <1.14,6.7,0>}
 object{Snow_Flake translate <0.95,6.5,0>}
 object{Snow_Flake translate <0.76,6.3,0>}
 object{Snow_Flake translate <0.57,6.1,0>}
 object{Snow_Flake translate <0.4,5.9,0>} 
 object{Snow_Flake translate <0.21,5.7,0>}
 object{Snow_Flake translate <0,5.5,0>}
 object{Snow_Flake translate <-0.2,9,0>}
 object{Snow_Flake translate <-0.4,9.1,0>}
 object{Snow_Flake translate <-0.6,9.2,0>}
 object{Snow_Flake translate <-0.8,9.25,0>}
 object{Snow_Flake translate <-1,9.2,0>}
 object{Snow_Flake translate <-1.2,9.12,0>}
 object{Snow_Flake translate <-1.4,9.02,0>}
 object{Snow_Flake translate <-1.6,8.9,0>}
 object{Snow_Flake translate <-1.75,8.7,0>}
 object{Snow_Flake translate <-1.85,8.5,0>}
 object{Snow_Flake translate <-1.95,8.3,0>}
 object{Snow_Flake translate <-2,8.1,0>}
 object{Snow_Flake translate <-2,7.9,0>}
 object{Snow_Flake translate <-1.95,7.7,0>}
 object{Snow_Flake translate <-1.9,7.5,0>}
 object{Snow_Flake translate <-1.71,7.3,0>}
 object{Snow_Flake translate <-1.52,7.1,0>}
 object{Snow_Flake translate <-1.33,6.9,0>}      
 object{Snow_Flake translate <-1.14,6.7,0>}
 object{Snow_Flake translate <-0.95,6.5,0>}
 object{Snow_Flake translate <-0.76,6.3,0>}
 object{Snow_Flake translate <-0.57,6.1,0>}
 object{Snow_Flake translate <-0.4,5.9,0>} 
 object{Snow_Flake translate <-0.21,5.7,0>}   
  pigment{White*3}
}
                         
//************************************************************************
// Tree
               
#declare XZ=0.08;
#declare Y1=0.5;
#declare Y2=1;
#declare branch_rad=0.1;
#declare tree_rad=1; 
#declare tree_height=20;
#declare branch_length=1;
          
#declare Needle_Tex=
 texture{
  pigment{
   gradient y
   pigment_map{
   [0 Green]
   [0.5 Green]
   [0.6 White*2]
   [1 White*3]
   }          
 } 
}    

#declare Tree_Tex=
 texture{T_Wood1   rotate <85,45,0>
        normal {wrinkles}
        }
        
#declare Needle=
mesh{
 triangle{<0,0,0>,<-XZ,Y1,0>,<0,Y1,-XZ>}
 triangle{<0,0,0>,<XZ,Y1,0>,<0,Y1,-XZ>} 
 triangle{<0,0,0>,<-XZ,Y1,0>,<0,Y1,XZ>}
 triangle{<0,0,0>,<XZ,Y1,0>,<0,Y1,XZ>}
 triangle{<0,Y2,0>,<-XZ,Y1,0>,<0,Y1,-XZ>}
 triangle{<0,Y2,0>,<XZ,Y1,0>,<0,Y1,-XZ>} 
 triangle{<0,Y2,0>,<-XZ,Y1,0>,<0,Y1,XZ>}
 triangle{<0,Y2,0>,<XZ,Y1,0>,<0,Y1,XZ>}
 texture{Needle_Tex}
 rotate 45*z
 translate branch_rad*y
}

#declare Needles=
union{
 #declare j=0;
 #while (j<360)
  object{Needle rotate j*x}
  #declare j=j+45;
 #end
}                

#declare small_branch=
union{
 cylinder{<0,0,0>,<-branch_length,0,0>,branch_rad pigment{DarkWood} } 
 #declare i=0;
 #while (i<=branch_length)
  object{Needles rotate 10*i*x translate -i*x}
  #declare i=i+0.5;
 #end 
} 
    
#declare Tree=
union{
 cone{<0,0,0>,1,<0,tree_height,0>,0.3 texture{Tree_Tex} }
 #declare i=tree_height;
 #while (i>4) 
 #declare k=0;
  #while (k<360)
   object{small_branch rotate 25*z translate -(tree_height-i)/3*x rotate (k+10*i)*y translate i*y}
   #declare k=k+20;
  #end                
  #declare i=i-1;
 #end
 #declare j=-130;
 #while (j<-40)
  object{small_branch rotate j*z translate (tree_height-branch_length/2)*y }
  #declare j=j+20;
 #end  
 #declare k=0;
 #while (k<360)
  object{small_branch rotate 25*z translate -(tree_height-6)/3*x rotate (k+10)*y translate 6*y}
  object{small_branch rotate 25*z translate -(tree_height-5)/3*x rotate (k)*y translate 5*y}
  #declare k=k+20;
 #end
} 
  
#declare Trees=
union{
 object {Tree translate <-25,0,10>} 
 object {Tree translate <18,0,0>}        
 object {Tree translate <-40,0,60>} 
 }
                
//*************************************************************************
//Fence
                  
#declare Half_Bar=
union{
 cylinder{<0,0,0>,<4,0,0>,0.3}
 cylinder{<4,0,0>,<4.5,0,0>,0.15}
 cone{<4.25,0,0>,0.15,<4,0,0>,0.3}
}

#declare Bar=
union{
 object{Half_Bar}
 object{Half_Bar rotate 180*y}
 texture{      
     gradient y
   texture_map{
      [0  T_Wood3]    
      [0.1  T_Wood3]
      [0.7  pigment{White*3} normal{wrinkles 0.4 scale 0.2}]
       }
    }   
 }
 
#declare Post=
difference{
 object{Half_Bar}
 cylinder{<2,-2,0>,<2,2,0>,0.2}
 cylinder{<3,-2,0>,<3,2,0>,0.2}
  texture{      
     gradient x
   texture_map{
      [0  T_Wood3]    
      [0.8  T_Wood3]
      [1  pigment{White*3} normal{wrinkles 0.4 scale 0.2}]
       }
       scale 5
    }   

}

#declare Fence_Piece=               
union{
 object{Post rotate 90*z translate -4.6*x} 
 object{Bar translate 2*y}    
 object{Bar translate 3*y}  
}                    

#declare i=0;
#declare j=0;

#declare Fence=
union{
 #while (i<Fence_Length)
  object{Fence_Piece translate x*(WalkWay_Width+i*9.2)}
  object{Fence_Piece rotate 180*y translate x*-(WalkWay_Width+i*9.2)}
  object{Fence_Piece rotate 180*y translate <(WalkWay_Width+i*9.2),0,Fence_Depth*9.2>}
  object{Fence_Piece translate <-(WalkWay_Width+i*9.2),0,Fence_Depth*9.2>}   
  #declare i=i+1;   
 #end
 #while (j<Fence_Depth)
  object{Fence_Piece translate 4.6*x rotate -90*y translate <(WalkWay_Width+(i-1/2)*9.2),0,j*9.2>}
  object{Fence_Piece translate 4.6*x rotate -90*y translate <-(WalkWay_Width+(i-1/2)*9.2),0,j*9.2>}
  #declare j=j+1;
 #end 
}
                 
//*************************************************************************
//Icicles
                       
#declare Icicle_tex=
texture{
        NBglass
        normal { bumps 0.4 scale 0.2 }
        finish { phong 1 diffuse 1}}

#declare Icicle1=
 cone{<0,0,0>,0.5,<0,-4,0>,0 texture{Icicle_tex}}                           
 
#declare Icicle2=
 cone{<0,0,0>,0.4,<0,-3,0>,0 texture{Icicle_tex}}
         
#declare Icicle3=
 cone{<0,0,0>,0.2,<0,-2,0>,0 texture{Icicle_tex}}

#declare Icicles=array[3] {Icicle1,Icicle2,Icicle3}

#declare R10=seed(15);

#declare House_Icicles=
union{
 #declare i=-14;
 #while (i<14) 
  object {Icicles[3*rand(R10)] translate <i,12,-10.5>}
  #declare i=i+1;
 #end
 #declare i=-21;
 #while (i<-10)
  object {Icicles[3*rand(R10)] translate <13.5,12,i>}
  #declare i=i+1;
 #end
}  
                   
//*************************************************************************
//Christmas Lights
                                                                       
#declare Cord=
union{
 cylinder{<-14.5,0,-10.5>,<-14.5,12,-10.5>,0.05}
 cylinder{<13.5,0,-10.5>,<13.5,12,-10.5>,0.05}
 cylinder{<13.5,0,-20.5>,<13.5,12,-20.5>,0.05}
 cylinder{<30.5,0,-20.5>,<30.5,12,-20.5>,0.05}
 cylinder{<-15,12,-11>,<13,12,-11>,0.05}
 cylinder{<13,12,-11>,<13,12,-21>,0.05}
 cylinder{<-4,12,-14>,<0,16,-14>,0.05}
 cylinder{<0,16,-14>,<4,12,-14>,0.05}
 cylinder{<13,12,-21>,<22,16.5,-21>,0.05}
 cylinder{<22,16.5,-21>,<31,12,-21>,0.05}
 pigment{DarkGreen}
}

#declare Light_Colors=array[4] {Blue,Red,Green,Orange}
#declare Light_Number=0;
 
#declare Fixture=
 cylinder{<0,0,0>,<0,0,-0.5>,0.05 pigment{DarkGreen}}

#declare Bulb=
 sphere{<0,0,-0.6>,0.1 finish {ambient 3}}
 
 
#declare All_Lights=
union{
 #declare Light_Number=0;
 #declare i=0;
 #while (i<13)   
   object{Fixture rotate 45*y translate <-14.5,i,-10.5>}
   object{Bulb rotate 45*y translate <-14.5,i,-10.5> pigment{Light_Colors[Light_Number]}}
   object{Fixture rotate 45*y translate <13.5,i,-10.5>}
   object{Bulb rotate 45*y translate <13.5,i,-10.5> pigment{Light_Colors[Light_Number]}}
   object{Fixture rotate 45*y translate <13.5,i,-20.5>}
   object{Bulb rotate 45*y translate <13.5,i,-20.5> pigment{Light_Colors[Light_Number]}}
   object{Fixture rotate 45*y translate <30.5,i,-20.5>}
   object{Bulb rotate 45*y translate <30.5,i,-20.5> pigment{Light_Colors[Light_Number]}}
   #if (Light_Number<3) 
    #declare Light_Number=Light_Number+1;
   #else
    #declare Light_Number=0;
   #end  
  #declare i=i+1;                                                                             
 #end

 #declare Light_Number=0;
 #declare i=-15;
 #while (i<14)   
   object{Fixture rotate -45*z translate <i,12,-11>}
   object{Bulb rotate -45*z translate <i,12,-11> pigment{Light_Colors[Light_Number]}}
   #if (Light_Number<3) 
    #declare Light_Number=Light_Number+1;
   #else
    #declare Light_Number=0;
   #end  
  #declare i=i+1;                                                                             
 #end

 #declare Light_Number=0;
 #declare i=-21;
 #while (i<-10)   
   object{Fixture rotate -45*z translate <13,12,i>}
   object{Bulb rotate -45*z translate <13,12,i> pigment{Light_Colors[Light_Number]}}
   #if (Light_Number<3) 
    #declare Light_Number=Light_Number+1;
   #else
    #declare Light_Number=0;
   #end  
  #declare i=i+1;                                                                             
 #end
 
 #declare Light_Number=0;
 #declare i=0;
 #while (i<5)   
   object{Fixture rotate -45*z translate <i,16-i,-13>}
   object{Bulb rotate -45*z translate <i,16-i,-13> pigment{Light_Colors[Light_Number]}}
   object{Fixture rotate -45*z translate <-i,16-i,-13>}
   object{Bulb rotate -45*z translate <-i,16-i,-13> pigment{Light_Colors[Light_Number]}}
   #if (Light_Number<3) 
    #declare Light_Number=Light_Number+1;
   #else
    #declare Light_Number=0;
   #end  
  #declare i=i+1;                                                                             
 #end

 #declare Light_Number=0;
 #declare i=0;
 #while (i<12)   
   object{Fixture rotate -45*z translate <-15,17.5-i/2,i>}
   object{Bulb rotate -45*z translate <-15,17.5-i/2,i> pigment{Light_Colors[Light_Number]}}
   object{Fixture rotate -45*z translate <-15,17.5-i/2,-i>}
   object{Bulb rotate -45*z translate <-15,17.5-i/2,-i> pigment{Light_Colors[Light_Number]}}
   #if (Light_Number<3) 
    #declare Light_Number=Light_Number+1;
   #else
    #declare Light_Number=0;
   #end  
  #declare i=i+1;                                                                             
 #end

 #declare Light_Number=0;
 #declare i=0;
 #while (i<10)   
   object{Fixture rotate -45*z translate <22-i,16.5-i/2,-21>}
   object{Bulb rotate -45*z translate <22-i,16.5-i/2,-21> pigment{Light_Colors[Light_Number]}}
   object{Fixture rotate -45*z translate <22+i,16.5-i/2,-21>}
   object{Bulb rotate -45*z translate <22+i,16.5-i/2,-21> pigment{Light_Colors[Light_Number]}}
   #if (Light_Number<3) 
    #declare Light_Number=Light_Number+1;
   #else
    #declare Light_Number=0;
   #end  
  #declare i=i+1;                                                                             
 #end
}

#declare Christmas_Lights=
union{  
 object{Cord}
 object{All_Lights}
}                                                                            
                  
//*************************************************************************
//House
                  
#declare Outer_Tex=
texture{                            
  gradient y        
  texture_map{ 
   [0 pigment{Black}] 
   [0.2 T_Wood1]
   [1 T_Wood1]
   }
 }  

#declare Brick_Tex=
 texture {brick 
          texture {pigment {White}}
          texture {T_Stone21}
          scale 0.2 }  

#declare Inner_Tex=
 texture{pigment {Blue}}
 
#declare Smoke_Pig=
 pigment {
    wrinkles
    turbulence 0.1
    color_map {
        [0.1, 0.2   color White 
                    color rgbt 1]
        [0.3, 0.5   color White*0.75
                    color rgbt 1]  
        [0.5, 1.001 color rgbt 1 color rgbt 1]
      }
    scale 0.5
}

#declare Roof_Snow=
texture { pigment { color White*2.5 }
        normal { bumps 1 }
    } 
         
#declare Window_Box=
 box{<-2,-3,-0.6>,<2,3,0.6>}
 
#declare Pane=
 box{<-1.5,-2.5,-0.61>,<-0.25,-0.25,0.61>}
 
#declare Panes=
 union{
  object{Pane}
  object{Pane translate <2,0,0>}
  object{Pane translate <0,3,0>}
  object{Pane translate <2,3,0>}
 }
 
#declare Window_Empty_Box=
difference{
 object{Window_Box texture {T_Wood7}}
 object{Panes}
 }  

#declare Shutter_Frame=
difference{
 box{<-4.1,-3,-0.6>,<-2.1,3,0.6> pigment{ForestGreen}}
 box{<-3.8,-2.3,-0.61>,<-2.3,-0.1,0.61> pigment{Clear}} 
 box{<-3.8,2.6,-0.61>,<-2.3,0.4,0.61> pigment{Clear}}
 }
 
#declare Blind=
 box{<-3.8,-0.25,-0.6>,<-2.3,0.25,0.65> pigment{ForestGreen}} 

#declare Shutter=
union{
 object{Shutter_Frame}
 object{Blind rotate 20*x translate 2.4*y}
 object{Blind rotate 20*x translate 1.9*y}
 object{Blind rotate 20*x translate 1.4*y}
 object{Blind rotate 20*x translate 0.9*y}
 object{Blind rotate 20*x translate 0.4*y}
 object{Blind rotate 20*x translate -2.3*y}
 object{Blind rotate 20*x translate -1.8*y}
 object{Blind rotate 20*x translate -1.3*y}
 object{Blind rotate 20*x translate -0.8*y}
 object{Blind rotate 20*x translate -0.3*y}
}

#declare Window=
 union{
  object{Window_Empty_Box}
  object{Panes texture {NBglass}}
  object{Shutter}
  object{Shutter translate 6.2*x}
 }
 
#declare Double_Window=
 union{
  object{Window_Empty_Box}
  object{Panes texture {NBglass}}
  object{Shutter}
  object{Window_Empty_Box translate 4*x}
  object{Panes translate 4*x texture {NBglass}}
  object{Shutter translate 10.2*x}
 }  

#declare Window_boxes=
 union{
  object{Window_Box translate <-8,6,-10>}
  object{Window_Box translate <8,6,-10>}
  object{Window_Box rotate 90*y translate <14,6,-15>}
  object{Double_Window translate <20,6,-20>}
 } 
 
#declare Windows=
 union{
  object{Window translate <-8,6,-10>}
  object{Window translate <8,6,-10>}
  object{Window rotate 90*y translate <14,6,-15>}
  object{Double_Window translate <20,6,-20>}
 }

#declare Room_Box=
union{
 #declare i=0;
 #declare r=0.5;                                     
 #while (i<12)
  cylinder{<-15,r+i,10>,<31,r+i,10>,r}
  cylinder{<-15,r+i,-10>,<14,r+i,-10>,r}
  cylinder{<13,r+i,-20>,<31,r+i,-20>,r}
  cylinder{<-14,r+i,-11>,<-14,r+i,11>,r}
  cylinder{<14,r+i,-21>,<14,r+i,-10>,r}
  cylinder{<30,r+i,-21>,<30,r+i,11>,r}
  cylinder{<-3,r+i,-10>,<-3,r+i,-14>,r}
  cylinder{<3,r+i,-10>,<3,r+i,-14>,r}
  cylinder{<-4,r+i,-13>,<4,r+i,-13>,r}
  #declare i=i+1;
 #end 
 texture{T_Wood1}
}

#declare Room_Base=
difference{
 object{Room_Box}            
 object{Window_boxes}
} 

#declare Room=
union{
 object{Room_Base}
 object{Windows}                  
}
  
#declare Chimney=
union{
 box{<29.5,22,0.5>,<33.5,23,-5> texture{T_Stone13}}
 box{<30,22,0>,<33,0,-4.5> texture{Brick_Tex}}
}

#declare Smoke=
union{
 cylinder{<31.5,23,-2.5>,<31.5,25,-2.5>,2 open no_shadow }
 cylinder{<32.5,24,-2.5>,<32.5,26,-2.5>,2  open no_shadow }
 cylinder{<33.5,25,-2.5>,<33.5,27,-2.5>,2  open no_shadow }
 cylinder{<34.5,26,-2.5>,<34.5,28,-2.5>,2.5  open no_shadow  }
 cylinder{<33.5,27,-2.5>,<33.5,29,-2.5>,2.5  open no_shadow }
 cylinder{<32.5,28,-2.5>,<32.5,30,-2.5>,3  open no_shadow }
 cylinder{<31.5,29,-2.5>,<31.5,31,-2.5>,3.5  open no_shadow  }
 cylinder{<30.5,30,-2.5>,<30.5,32,-2.5>,3.5  open no_shadow }
 cylinder{<32.5,31,-2.5>,<32.5,33,-2.5>,4  open no_shadow }
 cylinder{<34.5,32,-2.5>,<34.5,34,-2.5>,4.5  open no_shadow }
 cylinder{<35.5,33,-2.5>,<35.5,35,-2.5>,5  open no_shadow }
 cylinder{<37.5,34,-2.5>,<37.5,36,-2.5>,5.5  open no_shadow }
 cylinder{<39.5,35,-2.5>,<39.5,37,-2.5>,6  open no_shadow }
 cylinder{<41.5,36,-2.5>,<41.5,38,-2.5>,6 open no_shadow }
 pigment{Smoke_Pig}
}
  
#declare Door_Wood=
  union{
   box{<-2,0,-0.6>,<2,9,0.2> texture{T_Wood14}}
   box{<-1.5,7,-0.61>,<-.25,8.5,0.2> texture{T_Wood4}}
   box{<1.5,7,-0.61>,<.25,8.5,0.2> texture{T_Wood4}}
   box{<-1.5,0.5,-0.61>,<-.2,6.5,0.2> texture{T_Wood4}}
   box{<1.5,0.5,-0.61>,<.2,6.5,0.2> texture{T_Wood4}}
  }

#declare Door=
union{
 object{Door_Wood}  
//Knob
 sphere{<-1.7,3.5,-0.9>, 0.2 texture{Gold_Nugget}}
 cylinder{<-1.7,3.5,-0.9>,<-1.7,3.5,-0.6>,0.1 texture{Gold_Nugget}} 
//Stair
 box{<-3,-1,-4>,<3,0,0> texture{T_Stone13}}
}

#declare Roof=
union{
 mesh{
  triangle{<-15,12,11>,<31,12,11>,<-15,17.5,0>}
  triangle{<-15,17.5,0>,<31,17.5,0>,<31,12,0>}
  triangle{<-15,17.5,0>,<31,17.5,0>,<-15,12,-11>}
  triangle{<-15,12,-11>,<31,17.5,0>,<31,12,-11>}
  triangle{<13,12,-10>,<13,12,-21>,<22,16.5,-21>}
  triangle{<22,16.5,-21>,<22,17.5,0>,<13,12,-10>}
  triangle{<22,16.5,-21>,<22,17.5,0>,<31,12,-21>}
  triangle{<31,12,-21>,<31,12,-10>,<22,17.5,0>}
  triangle{<-4,12,-14>,<-4,12,-10>,<0,16,0>}
  triangle{<0,16,0>,<0,16,-14>,<-4,12,-14>}
  triangle{<0,16,-14>,<0,16,0>,<4,12,-10>}
  triangle{<4,12,-10>,<4,12,-14>,<0,16,-14>}
  texture{Roof_Snow}
 }
 mesh{
  triangle{<-4,12,-13>,<0,16,-13>,<4,12,-13>}
  triangle{<13,12,-20>,<22,16.5,-20>,<31,12,-20>}
  triangle{<30,12,-11>,<30,17.5,0>,<30,12,11>}
  triangle{<-14,12,-11>,<-14,17.5,0>,<-14,12,11>}
  texture{Outer_Tex}
 }
 box{<-15,12,-11>,<14,12,-10> pigment{White}}
 box{<13,12,-10>,<14,12,-21> pigment{White}}
 box{<30,12,-10>,<31,12,-21> pigment{White}}
 box{<-15,12,10>,<31,12,11> pigment{White}}          
}

#declare House=
union{         
 object{Room}
 object{Door translate <0,1,-13>}
 object{Roof}
 object{House_Icicles}
 object{Christmas_Lights}
 object{Chimney}
 object{Smoke}
 } 
                  
//*************************************************************************
//Sidewalk
                   
//Produces a curb of height,Height which runs the length of the created patch of cobble stones 
#declare i=0;
#declare r=1;
#declare j=0;
#declare Curb=
union{
 #while (i<Length)
  box { <0,0,0>,<r,Height,1> texture {T_Stone13} translate r*i*x}
  box { <0,0,0+Width>,<r,Height,1+Width> texture {T_Stone13} translate r*i*x}
  #declare i=i+1;
 #end 
}

//Produces a walkway length of the curb      
#declare i=0;
#declare Walk=
union{
 #while (i<Length)
  box { <0,0,1>,<r,0.01,Width>
           texture {hexagon texture{T_Stone21},
                            texture{T_Stone23},
                            texture{T_Stone12}
                    scale 0.4        
                    }
        translate r*i*x            
      } 
   #declare i=i+1;
  #end
}

//Puts curb and walk together         
#declare Sidewalk=
union{
 object {Curb}
 object {Walk} 
 }
 
#declare Walkway=
 object{Sidewalk rotate 90*y translate <-3,0,13>}
                  
//*************************************************************************
//Ground Snow
                      
#declare Ground_Snow_Piece=
height_field {
    tga "snow_field.tga"
    smooth
    pigment { White*2 }
    translate <0, -0.45, 0>
    scale <Snow_num, 1, Snow_num>
  }

#declare Grass=
box{<0,-1,0>,<Snow_num,-0.1,Snow_num> pigment{GreenYellow}}                    

#declare Ground_Snow=
union{
 #declare i=0;
 #while (i<Snow_Dim)
  #declare j=0;
  #while (j<Snow_Dim)
   object{Ground_Snow_Piece translate <i*Snow_num,0,j*Snow_num>}
   object{Grass translate <i*Snow_num,0,j*Snow_num>}
   #declare j=j+1;
  #end 
  #declare i=i+1;
 #end
}  
                        
//**************************************************************
//Sky

#declare Cloud1 =
pigment {
    wrinkles
    turbulence 0.65
    octaves 6
    omega 0.7
    lambda 2
    color_map {
        [0.0, 0.1   color red 0.85 green 0.85 blue 0.85
                    color red 0.75 green 0.75 blue 0.75]
        [0.1, 0.5   color red 0.75 green 0.75 blue 0.75
                    color MidnightBlue]
        [0.5, 1.001 color MidnightBlue color MidnightBlue]
      }
    scale <6, 1, 6>
}

#declare Cloud2 =
pigment {
    bozo
    color_map {
        [0.0, 0.1   color red 0.85 green 0.85 blue 0.85
                    color red 0.55 green 0.60 blue 0.65]
        [0.1, 0.5   color red 0.55 green 0.60 blue 0.65
                    color rgb <0.184, 0.184, 0.309> ]
        [0.5, 1.001 color rgb <0.184, 0.184, 0.309>
                    color rgb <0.1, 0.1, 0.2>]
    }
    turbulence 0.65
    octaves 6
    omega 0.707
    lambda 2
    scale <6, 4, 6>
}

#declare Scene_Clouds =
sky_sphere {
    pigment {
        gradient y
        pigment_map {
            [0.01 rgb <0.847, 0.749, 0.847> ] // horizon
            [0.25 Cloud1 scale 0.25 rotate z*5]
            [0.60 Cloud2 scale <0.25, 0.15, 0.25> rotate z*10]
        }
    }
}
//*************************************************************************
//Hearts
                                  /*
#declare Heart_Color=pigment { Red filter 0.7}

#declare Spheres=
merge{
 sphere{<-0.4,0,0>,0.5}
 sphere{<0.4,0,0>,0.5}
 pigment {Heart_Color}
}

#declare Heart=
merge{
 cone{<0,-0.25,0>,0.83,<0,-1.2,0>,0 pigment {Heart_Color}}
 object{Spheres}
} 

#declare Final_Heart=
difference{ 
 object{Heart no_shadow}
 box{<-1,-2,0>,<1,1,-1> pigment {Heart_Color} no_shadow}
 box{<-1,-2,0.2>,<1,1,1> pigment {Heart_Color} no_shadow}
}

#declare Scene_Hearts=
union{
 object{Final_Heart translate <0,8,-3>}
 object{Final_Heart scale 0.75 translate <-4,7,-3>}
 object{Final_Heart scale 0.75 translate <4,7,-3>}
 object{Final_Heart scale 0.5 translate <-9,8,-3>}
 object{Final_Heart scale 0.5 translate <9,8,-3>}
 object{Final_Heart scale 0.5 translate <-7,8,-5>}
 object{Final_Heart scale 0.5 translate <7,8,-5>}
 object{Final_Heart scale 0.5 translate <-5,8,-3>}
 object{Final_Heart scale 0.5 translate <5,8,-3>}
 object{Final_Heart scale 0.5 translate <-7,8,-1>}
 object{Final_Heart scale 0.5 translate <7,8,-1>}
}
                                    */
//*************************************************************************
//Rendering Section
sky_sphere { Scene_Clouds } 
object{Ground_Snow translate <-Snow_Dim*Snow_num/2+10,0,-Snow_Dim*Snow_num/2-Length/2>}
object{Snow_in_Air translate -15*x translate -30*z}
object{Snow_Man rotate <0,-5,-3> translate <-7,0,-6>}   
object{Snow_Woman rotate <0,5,-3> translate <7,0,-6>}
object{Fence translate -20*z}
object{Walkway}
object{House rotate -25*y translate <-7,0,25>}
//object{Scene_Hearts}
object{Snow_Heart scale 2.2 translate <3.2,0,-6>}   
object{Trees}