
// POV-Ray Object File - Airplanes
// created 26-Nov-98
// last update 29-Nov-98
// 1998 Glenn McCarter and N.B.
// This file does not render.  #include "Airplanes.inc" in another .pov file
// Required #include files: "GUnits.inc"
//
// Objects:
// ZeroFighter
// Torpedo
//
// Intended scale is metric system (centimeters)
// Uses LH coordinate reference system (Y=up)
// Airplane lies in XZ plane, origin at propeller, plane extends into +X


//===============================================
//             Variables
//===============================================


//===============================================
//             Textures
//===============================================

#declare WhitePaint =
	texture {
		pigment { color rgb<.99,.98,.92> }
		normal { bumps .02 scale 1*cm }
		finish { ambient .2 diffuse .7 specular .6 roughness .05 }
	}

#declare BlackPaint =
	texture {
		pigment { color rgb<.03,.04,.05> }
		normal { bumps .12 scale 4*cm }
		finish { ambient .08 diffuse .7 specular .1 roughness .25 }
	}
#declare FighterSkinTex =
	texture {
		pigment { color rgb<.80,.80,.86> }
		normal { bumps .1 scale <13*cm,13*cm,13*cm> }
		finish { specular .2 roughness .2 reflection .2 }
	}
#declare CanopyTex =
	texture {
		pigment { color rgb<.80,.80,.86> }
		normal { bumps .1 scale <13*cm,13*cm,13*cm> }
		finish { specular .2 roughness .2 reflection .8 }
	}



//===============================================
//						 Objects
//===============================================


//----------------- Airplanes ---------------------

// ZeroFighter origin at center of propeller
#declare ZFWing =
	cone { // RHwing
		<0,0,0>,7*Feet,<0,0,26*Feet>,4*Feet
		scale <1,.12,1>
	}
#declare ZeroFighter =
	union {
		cylinder { // propeller
			<0,0,0>,<10*cm,0,0>8*Feet
			texture { pigment { color rgbt<1,1,1,.92> } }
		}
		cone { // fuselage
			<3*Feet,0,0>,4*Feet,<48*Feet,0,0>,1.5*Feet
			scale <1,1,.6>
		}
		sphere { // front end fuselage
			<0,0,0>4*Feet
			scale <1,1,.7>
			translate <3*Feet,0,0>
			texture { BlackPaint }
		}
		sphere { // cockpit
			<0,0,0>,22*Inches
			scale <6,1,1>
			translate <18*Feet,2.5*Feet,0>
			texture { CanopyTex }
		}
		object { ZFWing translate <16*Feet,-2.3*Feet,0> }
		object { ZFWing scale <1,1,-1> translate <16*Feet,-2.3*Feet,0> }
		cylinder { // TailElevator
			<0,0,0>,<0,3*Inches,0>,11*Feet
			scale <.2,1,1>
			translate <48*Feet,0,0>
		}
		cylinder { // Rudder
			<0,0,-2*Inches>,<0,0,2*Inches>,6*Feet
			scale <.4,1,1>
			clipped_by { box{<8*Feet,0,-8*Inches>,<-8*Feet,12*Feet,8*Inches>}}
			translate <48*Feet,0,0>
		}
		texture { FighterSkinTex }
	}

#declare Torpedo =
	union {
		sphere { <0,0,0>,16 } // front
		cylinder { <0,0,0>,<24*Feet,0,0>,16 } // body
		cone { <0,0,0>,16,<3*Feet,0,0>,4 translate <24*Feet,0,0> } // tail
		box { <0,0,-18>,<12,2,18> translate <26.5*Feet,0,0> } // tailfin
		box { <0,-18,-1>,<12,18,1> translate <26.5*Feet,0,0> } // tailfin
		texture { WhitePaint }
	}

