
// POV-Ray Object File - Docks
// created 26-Nov-98
// last update 27-Dec-98
// 1998 Glenn McCarter and NB
// This file does not render.  #include "Docks.inc" in another .pov file
// Required #include files: "GUnits.inc", "DockmapL.png", "DockmapR.png", "DockmapF.png"
//
// Objects:
// SimpleDocks
// DryDock
// Fences
// MooringRope(Length,DoubleWidth,ElevAngle,ClockAngle) where ClockAngle 0 = -x direction
// MooringGroup collection of capstans and lines for all Pennsylvania and Cachalot
//
//
// Intended scale is metric system (centimeters)
// Uses LH coordinate reference system (Y=up)
// Top of SimpleDocks is at y=0


//===============================================
//             Variables
//===============================================

#declare DHeight = 2*Feet; // dry dock wall height above sea level
#declare GroundLevel = 8*Feet; // this must equal value in main scene

//===============================================
//             Textures
//===============================================

#declare WhitePaint =
	texture {
		pigment { color rgb<.99,.98,.92> }
		normal { bumps .02 scale 1*cm }
		finish { ambient .2 diffuse .7 specular .6 roughness .05 }
	}
#declare ConcreteTex =
	texture {
		pigment { color rgb<.92,.95,.88> }
		normal { bumps .08 scale 1*cm }
		finish { ambient .10 diffuse .7 specular .1 crand .1 roughness .2 }
	}
#declare DullIronTex =
	texture {
		pigment { color rgb<.52,.55,.58> }
		normal { bumps .08 scale 1*cm }
		finish { ambient .08 diffuse .7 specular .4 crand .1 roughness .06 }
	}
#declare DryDockFloorTex =
	texture {
		pigment {
			bozo
			color_map {
				[ 0.0 color rgb<.24,.24,.26,> ]
				[ 1.0 color rgb<.72,.75,.68> ]
			}
			scale 20*Feet
		}
		normal { bumps .08 scale 1*cm }
		finish { ambient .10 diffuse .7 specular .1 crand .1 roughness .2 }
	}
#declare SupportTex = // ship supports in drydock
	texture {
		pigment {
			gradient y
			color_map {
//				[ 0.0 color rgb<.30,.33,.26,>*3 ]
				[ 0.0 color rgb<.10,.13,.16,>*3 ]
				[ 1.0 color rgb<.52,.55,.62>*3 ]
			}
			scale 20*Feet
			translate <0,-60*Feet,0>
		}
		normal { bumps .12 scale 14*cm }
		finish { ambient .08 diffuse .7 specular .4 crand .1 roughness .06 }
	}
#declare ShadowTex = // underneath ship supports in drydock
	texture {
		pigment { color rgb<.18,.15,.13>*3 }
		finish { ambient .08 diffuse .7 specular .4 crand .1 roughness .06 }
	}

#declare GreyPaint =
	texture {
		pigment { color rgb<.72,.75,.78> }
		normal { bumps .08 scale 1*cm }
		finish { ambient .08 diffuse .7 specular .7 roughness .06 }
	}
#macro Stripe(Direction,Thickness,Scale,Color)
pigment {
	gradient Direction
		color_map {
			[ Thickness/Scale color Color ]
			[ Thickness/Scale color rgbt<1,1,1,1> ]
		}
		scale Scale
}
#end

#macro Grid(Direction1,Thickness1,Scale1,Direction2,Thickness2,Scale2,Color)
//note no texture statement here, it is in the object itself
	pigment { gradient Direction1
		color_map {
			[ Thickness1/Scale1 color Color ] // first portion is user's color...
			[ Thickness1/Scale1 color rgbt<1,1,1,1> ] // ...but the rest is clear
		}
		scale Scale1
	}
} // this brace closes the first layer texture
texture { // this is the second layer texture
	pigment { gradient Direction2
		color_map {
			[ Thickness2/Scale2 color Color ] // first portion is user's color...
			[ Thickness2/Scale2 color rgbt<1,1,1,1> ] // ...but the rest is clear
		}
		scale Scale2
	}
// note no closing brace here, it is in the object itself
#end


//===============================================
//						 Objects
//===============================================

//---------------- Image Maps -------------------
#declare DockMapL = // left side
	box {
		<0,0,0>,<1,1,1>
		texture {
			pigment {
				image_map { // image is always projected from -z, with front facing +z, top to +Y
				png "DockmapL.png"
					once
				}
				rotate x*90 // align map to face-up on box
			}
		}
	}
#declare DockMapR = // right side
	box {
		<0,0,0>,<1,1,1>
		texture {
			pigment {
				image_map { // image is always projected from -z, with front facing +z, top to +Y
				png "DockmapR.png"
					once
				}
				rotate x*90 // align map to face-up on box
			}
		}
	}
#declare DockMapF = // far side
	box {
		<0,0,0>,<1,1,1>
		texture {
			pigment {
				image_map { // image is always projected from -z, with front facing +z, top to +Y
				png "DockmapF.png"
					once
				}
				rotate x*90 // align map to face-up on box
			}
		}
	}

//---------------- Simple Docks -------------------

#declare SimpleDocks =
	union {
		box { <-890*Feet,-80*Feet,-1000*Feet><-593*Feet,0,198*Feet> } // box1 drydock3 base
		box { <-615*Feet,-80*Feet,-1000*Feet><-549*Feet,0,1033*Feet> } // box2 drydock2 left
		box { <-626*Feet,-80*Feet,-1000*Feet><-286*Feet,0,44*Feet> } // box3 drydock2 base
		box { <-209*Feet,-80*Feet,-1000*Feet><99*Feet,0,264*Feet> } // box4 main drydock base
		box { <-341*Feet,-80*Feet,-1000*Feet><-121*Feet,0,1275*Feet> } // box5 main drydock left
		object { DockMapL scale <(341-121)*Feet,1,1275*Feet> translate <-341*Feet,0,0> }
		box { <66*Feet,-80*Feet,-1000*Feet><231*Feet,0,1275*Feet> } // box6 main drydock right
		object { DockMapR scale <440*Feet,1,1275*Feet> translate <66*Feet,0,0> }
		box { <154*Feet,-80*Feet,2835*Feet-165*Feet><286*Feet,0,2835*Feet> } // box7 short box
		box { <187*Feet,-80*Feet,-1000*Feet><1033*Feet,0,2835*Feet> } // box8 long line
		object { DockMapF scale <(2835-1275)*Feet,1,(2835-1275)*Feet> translate <187*Feet,0,1275*Feet> }
		box { <187*Feet,-80*Feet,-1000*Feet><253*Feet,0,3341*Feet> } // box9 far pier 1
		box { <549*Feet,-80*Feet,-1000*Feet><648*Feet,0,3319*Feet> } // box10 far pier 2
		box { <604*Feet,-80*Feet,-1000*Feet><692*Feet,0,3495*Feet> } // box11 far pier ext
		box { <1000*Feet,-80*Feet,-1000*Feet><1088*Feet,0,3462*Feet> } // box12 far pier 3
		box { <1374*Feet,-80*Feet,-1000*Feet><1484*Feet,0,3330*Feet> } // box13 far pier 4
		box { <1802*Feet,-80*Feet,-1000*Feet><2692*Feet,0,3132*Feet> } // box14 far pier 5
		box { <1033*Feet,-80*Feet,-1000*Feet><1901*Feet,0,2231*Feet> } // box15 far land
		translate <28*Feet,0,-30*Feet> // align to scene origin
		texture { ConcreteTex }
	} // end union

//---------------- DryDock -------------------

#declare DFloor =
	difference {
		union {
			box { <-200*Feet,-70*Feet,200*Feet>,<200*Feet,-40*Feet,1300*Feet>
				texture { DryDockFloorTex }
			}
			box { <-8*Feet,-40*Feet,200*Feet>,<-3*Feet,-37*Feet,1300*Feet> texture { DullIronTex } } // bottom rail
			box { < 3*Feet,-40*Feet,200*Feet>,< 8*Feet,-37*Feet,1300*Feet> texture { DullIronTex } } // bottom rail
			#local SupC = 0;
			#while ( SupC < 12 )
				box { <-35*Feet,-40*Feet,0>,<35*Feet,-24*Feet,8*Feet> translate <0,0,500*Feet+SupC*60*Feet> texture { SupportTex } } // ship supports
				#local SupC=SupC+1;
			#end
		} // end union
		box { <-12*Feet,-6*Feet,0>,<12*Feet,6*Feet,1400*Feet> rotate z*26 translate <15*Feet,-40*Feet,0> texture { ShadowTex } }
		box { <-12*Feet,-6*Feet,0>,<12*Feet,6*Feet,1400*Feet> rotate z*-26 translate <-15*Feet,-40*Feet,0> texture { ShadowTex } }
	} // end difference
#declare DWall =
	union {
		box { <-1,-12*Feet,0>,<8*Feet,DHeight,1070*Feet> texture { ConcreteTex } } // walkway
		box { <2*Feet,0,0>,<4*Feet,5*Feet,35*Feet> rotate z*12 translate <0,DHeight,400*Feet> texture { ConcreteTex } } // misc
	}
#declare DDoor =
	union {
		box { <0,-80*Feet,0>,<120*Feet,8*Feet,8*Feet> texture { DullIronTex } } // main
		box { <0,2*Feet,-2*Feet>,<120*Feet,5*Feet,1*Feet> texture { ConcreteTex } } // walkway
		rotate y*-30
	}
#declare DDoorGroup =
	union {
		object { DDoor translate <-90*Feet,0,1250*Feet> }
		object { DDoor scale <-1,1,1> translate <90*Feet,0,1250*Feet> }
	}
#declare DryDock = // top surface at 2 feet above sea level, 0 width at outside edge
	union {
		object { DFloor }
		object { DDoorGroup }
		object { DWall translate <-90*Feet,0,200*Feet> }
		object { DWall scale <-1,1,1> translate <90*Feet,0,200*Feet> }
	}


//---------------- Fences -------------------

#macro RestrainingFence(XLength) // this is a short restraining fence
	box {
		<0,0,0>,<XLength,4*Feet,.1>
		texture {
			Grid(x,3*Inch,6*Feet,y,3*Inch,1.8*Feet,rgb<.93,.93,.78>)
			finish { ambient .1 diffuse 0.7 specular .97 roughness .005 }
		}
	}
#end
#macro ChainLinkFence(XLength)
	union {
		box { // poles
			<0,0,0>,<XLength,8*Feet,6*inch>
			texture {
				Stripe(x,8*Inch,12*Feet,rgb<.67,.67,.73>)
				finish { ambient .1 diffuse 0.7 specular .97 roughness .005 }
			}
		}
		box { // grating
			<0,0,0>,<XLength,7*Feet,.1>
			texture {
				Grid(x,.25*Inch,3*Inch,y,.25*Inch,3*Inch,rgb<.46,.43,.38>)
				finish { ambient .1 diffuse 0.7 specular .4 roughness .005 }
			}
		}
	}
#end

#declare Fences =
	union {
		object { RestrainingFence(240*Feet) translate <-130*Feet,0,230*Feet> }
		object {	ChainLinkFence(-600*Feet) rotate y*-90 translate <-153*Feet,0,580*Feet> }
	}

// MooringRope macro creates an image of a hanging rope.
// DoubleWidth creates a free second copy of the mooring rope, offset from the first.
// (This is available because the mooring rope is an image map, mapped onto both sides of a box.)
// ClockAngle the clockwise angle from -x, when viewed from above.
#macro MooringRope(Length,DoubleWidth,ElevAngle,ClockAngle)
	box {
		<0,0,0>,<1,1,1>
		texture {
//			WhitePaint // test
			pigment {
				image_map { // image is always projected from -z, with front facing +z, top to +Y
					png "Rope01.png"
					once
				}
			}
			finish { ambient .2 }
		}
		scale <-Length,Length*.2,DoubleWidth>
		translate <0,-Length*.2,0>
		rotate <0,0,-ElevAngle>
		rotate <0,ClockAngle,0>
	}
#end

#declare Capstan =
	union {
		cylinder { // main
			<0,0,0>,<0,3.5*Feet,0>,12*Inches
		}
		sphere { // top
			<0,0,0>,12*Inches
			scale <1,.2,1>
			translate <0,3.5*Feet,0>
		}
		cylinder { // ring
			<0,2*Feet,0>,<0,2.3*Feet,0>,14*Inches
		}
		texture { GreyPaint }
	}

#macro LoadingRamp(LLength,UpAngle)
	union {
		box { // ramp
			<-LLength,0,-2*Feet>,<1*Feet,0,2*Feet>
			texture { GreyPaint }
			rotate z*-UpAngle
		}
		object { MooringRope(LLength,1,UpAngle,0)
			scale <1,.5,1> // flatter
			translate <0,4*Feet,-2*Feet>
		}
		object { MooringRope(LLength,1,UpAngle,0)
			scale <1,.5,1> // flatter
			translate <0,4*Feet, 2*Feet>
		}
	}
#end

#declare MooringGroup =
	union {
  // ----------------- Pennsylvania -----------------
		//#macro MooringRope(Length,DoubleWidth,ElevAngle,ClockAngle)
		object { MooringRope(77*Feet,1,16,24) translate <84*Feet,DHeight+18*Inches,650*Feet> } // Pennsylvania port bow
		object { Capstan translate <84*Feet,DHeight,646*Feet> } // Pennsylvania port bow
		object { Capstan translate <84*Feet,DHeight,654*Feet> } // Pennsylvania port bow
		object { MooringRope(62*Feet,6*Feet,21,35) translate <84*Feet,DHeight+18*Inches,720*Feet> } // Pennsylvania port bow 2
		object { Capstan translate <84*Feet,DHeight,716*Feet> } // Pennsylvania port bow 2
		object { Capstan translate <84*Feet,DHeight,724*Feet> } // Pennsylvania port bow 2
		object { MooringRope(40*Feet,6*Feet,15.5,-12) translate <84*Feet,DHeight+18*Inches,1100*Feet> } // Pennsylvania port stern
		object { Capstan translate <84*Feet,DHeight,1102*Feet> } // Pennsylvania port bow 2

		object { MooringRope(77*Feet,1,16,180-24) translate <-84*Feet,DHeight+18*Inches,650*Feet> } // Pennsylvania starboard bow
		object { Capstan translate <-84*Feet,DHeight,646*Feet> } // Pennsylvania port bow
		object { Capstan translate <-84*Feet,DHeight,654*Feet> } // Pennsylvania port bow
		object { MooringRope(62*Feet,6*Feet,21,180-35) translate <-84*Feet,DHeight+18*Inches,720*Feet> } // Pennsylvania starboard bow 2
		object { Capstan translate <-84*Feet,DHeight,716*Feet> } // Pennsylvania port bow 2
		object { Capstan translate <-84*Feet,DHeight,724*Feet> } // Pennsylvania port bow 2
		object { MooringRope(40*Feet,6*Feet,15.5,180+12) translate <-84*Feet,DHeight+18*Inches,1100*Feet> } // Pennsylvania starboard stern
		object { Capstan translate <-84*Feet,DHeight,1102*Feet> } // Pennsylvania port bow 2

  // ----------------- Cachalot -----------------
		object { LoadingRamp(40*Feet,4) translate <222*Feet,GroundLevel+6*Inches,470*Meters> }
		object { MooringRope(55*Feet,3*Feet,4,38) translate <218*Feet,GroundLevel+18*Inches,450*Meters> } // Cachalot port bow
		object { Capstan translate <218*Feet,GroundLevel,450*Meters-4*Feet> } // Pennsylvania port bow
		object { Capstan translate <218*Feet,GroundLevel,450*Meters+4*Feet> } // Pennsylvania port bow
		object { MooringRope(25*Feet,6*Feet,12,16) translate <218*Feet,GroundLevel+18*Inches,490*Meters> } // Cachalot port stern
		object { Capstan translate <218*Feet,GroundLevel,490*Meters+2*Feet> } // Pennsylvania port bow 2

	}

