// Persistence of Vision Ray Tracer Scene Description File
// File: .pov
// Vers: 3.1
// Desc: Mitsubishi A6M2b model 21
// Date: 14.12.1998
// Auth: copyright 1998 NB & Glenn McCarter

//===============================================
//             Variables
//===============================================

#declare Zero_Scale = 7.24;
#declare Zero_Translate = x*18*Zero_Scale;
#declare Rad01 = Zero_Scale *0.07;
#declare Propeller_Turn = -23;

//===============================================
//             Textures
//===============================================

#include "metals.inc"

// airplane textures

#declare Zero_Finish01=
finish {
	ambient <1, .75, .5> *0.17
	diffuse 0.7
	brilliance 1.3
	}

#declare Ame_iro=
pigment {
	color rgb < 140, 148, 123 > / 255
}

#declare Ame_iro01=
pigment {
	color rgbt < 140/ 255, 148/ 255, 123/ 255, .7 > 
}

#declare Mark_Texture01=
texture {
	finish {
		Zero_Finish01
	}
	pigment {
		image_map { gif "sun01.gif" transmit 87 1 once}
		translate <-.5,-.5>
	}
}
#declare Mark_Texture02=
texture {
	finish {
		Zero_Finish01
	}
	pigment {
		//image_map { gif "stripe01.gif" once}
		image_map { gif "stripe02.gif" once}
		translate <-.5,0>
	}
}
#declare Mark_Texture03=
texture {
	finish {
		Zero_Finish01
	}
	pigment {
		//image_map { gif "fin01.gif" transmit 17 1 once}
		image_map { gif "fin02.gif" transmit 17 1 once}
		translate <-.5,-.5>
	}
}
#declare Mark_Texture04=
texture {
	finish {
		Zero_Finish01
	}
	pigment {
		image_map { gif "left.gif" once}
	}
}
#declare Mark_Texture05=
texture {
	finish {
		Zero_Finish01
	}
	pigment {
		image_map { gif "right.gif" once}
	}
}

#macro Zero_Texture00 ( Z_Side )

	texture {
		finish {
			Zero_Finish01
		}
		pigment {
			Ame_iro
		}
	}

	texture {
		Mark_Texture01
		scale 10
		translate < 51, 1, 0 >
	}

	texture {
		Mark_Texture01
		scale 14
		rotate x*97
		translate <18,0,-64>
	}

	texture {
		Mark_Texture01
		scale 14
		rotate x*-97
		translate <18,0,64>
	}

	texture {
		Mark_Texture02
		scale <4, 20, 1>
		translate <63, -4, 0>
	}

	texture {
		Mark_Texture03
		//scale <15, 4.5, 1>*.9
		scale <20, 7, 1>*.82
		rotate y*Z_Side
		//translate <93, 13, 0>
		translate <93.5, 16, 0>
	}
	#if ( Z_Side = 0 )
		texture {
			Mark_Texture04
			scale 3
			rotate x*97
			translate <12,0,-84>
		} 
	#end

	#if ( Z_Side = 180 )
		texture {
			Mark_Texture05
			scale 3
			rotate x*97
			translate <12,0,84>
		} 
	#end

	texture {
		finish {
			Zero_Finish01
			specular 0.70
			roughness 1/50
			reflection 0.1
		}
		normal { dents 0.2 }
		pigment {
			Ame_iro01
		}
	}
#end

#declare Zero_Texture01 =
texture {
	T_Chrome_5B
}

#declare Zero_Texture12 =
texture {
	finish {
		Zero_Finish01
		specular 0.70
		roughness 1/50
		reflection 0.1
	}
	normal { dents 0.1 }
	pigment {
		Ame_iro
	}
}

#declare Zero_Texture22 =
texture {
	Zero_Texture12  
	pigment {
		color rgb .1
	}
}

#declare Zero_Glass_Texture=
texture {
	finish {
		specular 0.5
		roughness 1/1000
		brilliance 5
		ambient 0.05
		diffuse 0.05
      	reflection 0.2
	}
	pigment { color rgbt < 1, 1, 1, .7 > }
}

#declare Propeller_Texture =
texture {
	Zero_Texture01
}

#declare Propeller_Texture01 =
texture {
	Propeller_Texture
	pigment { color rgbt <1, 1, 1, .5> }
}

#declare Propeller_Texture02 =
texture {
	pigment { color rgbt <1, 1, 1, 1> }
}

#declare Prop_Const = 1/12;
#declare Propeller_Texture03 =
texture {
	radial
	texture_map {
		[ 0					Propeller_Texture01 ]
		[ 1/6 - Prop_Const	Propeller_Texture02 ]
		[ 1/6 + Prop_Const	Propeller_Texture02 ]
		[ 2/6				Propeller_Texture01 ]
		[ 3/6 - Prop_Const	Propeller_Texture02 ]
		[ 3/6 + Prop_Const	Propeller_Texture02 ]
		[ 4/6				Propeller_Texture01 ]
		[ 5/6 - Prop_Const	Propeller_Texture02 ]
		[ 5/6 + Prop_Const	Propeller_Texture02 ]
		[ 1					Propeller_Texture01 ]
	}
}

#declare Propeller_Texture04 =
texture {
	gradient y
	texture_map {
		[ 0		Propeller_Texture ]
		[ .5	Propeller_Texture02 ]
		[ 1		Propeller_Texture02 ]
	}
}

// pilot textures:

#declare SuitTex =
	texture {
		pigment {color rgb <.5,.3,.2> }
		normal { bumps .3 scale <3, 1, 3> }
		finish {
			ambient .2
			diffuse 1
			phong .2
			phong_size 30
		}
	}
#declare SkinTex =
	texture {
		pigment {color rgb <.9,.8,.7> }
		finish {
			ambient .2
			diffuse 1
			phong .2
			phong_size 1
		}
	}

   
//===============================================
//             Airplane model
//===============================================

// fuselage + wings + fin + rudder:
#include "zero_fu01_1.inc"        
#include "zero_m02.inc"

// rudder
#include "zero_ru01_1.inc"

// ailerons:
#include "zero_ai11_1.inc"
#include "zero_ai21_1.inc"
#include "zero_ai02_1.inc"

// wheels:
#include "zero_wh01_1.inc"
#include "zero_wh02_1.inc"

#declare Zero_Fuselage =
union {
	union{
		object { Zero_fu01_1 }
		object { Zero_ru01_1 }
		object { Zero_ai11_1 }
		object { Zero_ai21_1 }
		object { Zero_ai02_1 }
		object { Zero_wh01_1 }
		object { Zero_wh02_1 }
		object { Zero_misc02
			rotate x*-90
			scale < 1, 1, -1 >/Zero_Scale
		}
		Zero_Texture00 ( 0 )
	}
	union{
		object { Zero_fu01_1 }
		object { Zero_ru01_1 }
		object { Zero_ai11_1 }
		object { Zero_ai21_1 }
		object { Zero_ai02_1 }
		object { Zero_wh01_1 }
		object { Zero_wh02_1 }
		object { Zero_misc02
			rotate x*-90
			scale < 1, 1, -1 >/Zero_Scale
		}
		scale < 1, 1, -1 >
		Zero_Texture00 ( 180 )
	}
}

// cockpit:

#include "zero_ca01_1.inc"
#include "zero_ca02_1.inc"
#include "zero_ca03_1.inc"

#declare Zero_Cabin =
union {
	object { Zero_ca01_1 }
	object { Zero_ca01_1 scale < 1, 1, -1 > }
	object { Zero_ca02_1 }
	object { Zero_ca02_1 scale < 1, 1, -1 > }
	object { Zero_ca03_1 }
	object { Zero_ca03_1 scale < 1, 1, -1 > }

	cylinder { < 31, 8.2, -4.9 > < 38.9, 8, -4.2 > 0.3 }
	sphere { < 31, 8.2, -4.9 > 0.3 }
	sphere { < 38.9, 8, -4.2 > 0.3 }
	cylinder { < 31, 8.2, -4.9 > < 31, 8.2, -3.9 > 0.3 }
	cylinder { < 38.9, 8, -4.2 > < 38.9, 8, -3.2 > 0.3 }

	cylinder { < 31, 8.2, 4.9 > < 38.9, 8, 4.2 > 0.3 }
	sphere { < 31, 8.2, 4.9 > 0.3 }
	sphere { < 38.9, 8, 4.2 > 0.3 }
	cylinder { < 31, 8.2, 4.9 > < 31, 8.2, 3.9 > 0.3 }
	cylinder { < 38.9, 8, 4.2 > < 38.9, 8, 3.2 > 0.3 }

	prism {
		linear_sweep
		linear_spline
		-.9, .9, 6
		< 0, 0 >, < 0, 5.5 >, < 3, 4.8 >, < 3, 4.3 >, < 4.5, 0 >, < 0, 0 >
		rotate x*-90 
    	translate < 31.2, 9, 0 >
    }

	texture { Zero_Texture12 }
}

#include "zero_gl01_1.inc"
#include "zero_gl02_1.inc"
#include "zero_gl03_1.inc"

#declare Zero_Cabin_Glass =
union {
	object { Zero_gl01_1 }
	object { Zero_gl01_1 scale < 1, 1, -1 > }
	object { Zero_gl02_1 }
	object { Zero_gl02_1 scale < 1, 1, -1 > }
	object { Zero_gl03_1 }
	object { Zero_gl03_1 scale < 1, 1, -1 > }

	texture { Zero_Glass_Texture }
}

// nose:

#include "zero_no01_1.inc"
#include "zero_no02_1.inc"
#include "zero_m01.inc"

#declare Zero_Nose =
union {
	object { Zero_no01_1 }
	object { Zero_no02_1 }
	object { Zero_no02_1 scale < 1, 1, -1 > }
	object { Zero_misc01
		rotate x*-90
		scale 1/Zero_Scale
	}
	object { Zero_misc01
		rotate x*-90
		scale < 1, 1, -1 >/Zero_Scale
	}

	texture { Zero_Texture22 }
}


// tail light:
#include "zero_ta01_1.inc"
#declare Zero_Tail =
union {
	object { Zero_ta01_1 }
	object { Zero_ta01_1 scale < 1, 1, -1 > }

	texture { T_Chrome_3D }
}

// antenna (aerial):

#declare Zero_Antenna=
union{
	cone { < 41.3, 8.9, 0 > 1 < 39, 23.1, 0 > .3 scale < 1, 1, 0.5 > }
	cylinder { < 39, 23.1, 0 > < 93.6, 23.4, 0 > 0.07 texture { Zero_Texture22 } }
	sphere { < 39, 23.1, 0 > 0.1 }
	sphere { < 93.6, 23.4, 0 > 0.1 }

	texture { Zero_Texture12 }
}

// guns:

#declare Zero_Guns=
union{
	// wings:
	difference {
		cylinder { < 0.9, -2.8, -26.3 > < 7.3, -2.8, -26.3 > 0.3 }
		sphere { < 0.9, -2.8, -26.3 > 0.25 }
	}
	difference {
		cylinder { < 0.9, -2.8, 26.3 > < 7.3, -2.8, 26.3 > 0.3 }
		sphere { < 0.9, -2.8, 26.3 > 0.25 }
	}
	// nose:
	difference {
		cylinder { < 2.1, 8.9, -2.54 > < 4.7, 8.9, -2.54 > 0.25 }
		sphere { < 2.1, 8.9, -2.54 > 0.2 }
	}
	difference {
		cylinder { < 2.1, 8.9, 2.54 > < 4.7, 8.9, 2.54 > 0.25 }
		sphere { < 2.1, 8.9, 2.54 > 0.2 }
	}

	texture { Zero_Texture22 }
}

#declare Zero_Exhausts=
union{
	difference {
		cylinder { < -0.2, -6.2, -1.8 > < 2.8, -7.5, -5 > 1 }
		sphere { < 2.8, -7.5, -5 > .8 }
	}
	difference {
		cylinder { < -0.2, -6.2, 1.8 > < 2.8, -7.5, 5 > 1 }
		sphere { < 2.8, -7.5, 5 > .8 }
	}

	texture { Zero_Texture01 }
}

#declare Zero_Propeller=
union {
	union{
		cylinder { < 0, 0, 0 > < 4.5, 0, 0 > 3.2 }
		sphere { 0, 1 scale < 7, 3.2, 3.2 > no_shadow}

		texture { Propeller_Texture }
     }
	torus { 13.5, 8.5 
		texture { Propeller_Texture03 }
		rotate z*90
		scale < .2, 1, 1 >
		translate x*-2
	}
	#declare Count = 2;
	#while ( Count >= 0 )
		merge{
			cone { < 0, 0, 0 >1.1 < 0, 13.5, 0 > .2 }
			sphere { 0 8.5 scale < .2, 1, .25 >*.99 translate < 0, 13.5, 0 > }

 			texture { Propeller_Texture04 scale 22.5 }
			rotate x*120*Count
			translate x*-2
		}
		#declare Count = Count -1
	#end
}

//===============================================
//             Pilot_Dummy
//===============================================

#declare Head = // center at center!
	union {
		difference {
			sphere { // helmet
				<0,0,0> 4.5
				scale < 1.1, 1, .9 >
			}
			box {
				< 0, 1, -3.2 > < 5, -5, 3.2 >
			}
		}
		cylinder {
			<0,0,-4.2> <0,0,4.2> 1.5
		}
		// goggles
		union{
			cylinder {
				<4.5,0,0> <3,0,0> 1.4
				scale < 1, .8, 1 >
				rotate y*-23
			}
			cylinder {
				<4.5,0,0> <3,0,0> 1.4
				scale < 1, .8, 1 >
				rotate y*23
			}
			texture { T_Chrome_3D }
		}
		union{
			cone {
				<0,1,0> 4 <0,-4.2,0> 3
				scale < 1, 1, .8 >
				rotate z*7
				translate < .7, 0, 0 >
			}
			sphere {
				<0,0,0> 3
				scale < 1, .5, .8 >
				translate <0,-4.2,0>
				rotate z*7
				translate < .7, 0, 0 >
			}
			sphere {
				<0,0,0> 3.1
				scale < 1, .3, .6 >
				translate <.5,-3.6,0>
				rotate z*7
				translate < .7, 0, 0 >
			}
			cone {
				<0,-.5,0> 1 <0,-2.5,0> 1.7
				scale < 1, 1, .5 >
				translate < 2.7, .3, 0 >
				rotate z*7
				translate < .7, 0, 0 >
			}
		texture { SkinTex }
		}
		translate < 1, 9, 0 >
		texture { SuitTex }
	}

#declare Torso = //center where neck/shoulder join each other
	union {
		cylinder { //neck
			<0,0,0> <0,8,0> 2
			rotate z*-20
			translate x*.5
			texture { SkinTex }
		}
		cone { //torso
			<0,-16,0> 6 <0,0,0> 8
			scale <.4,1,1>
		}
		sphere {
			<0,0,0> 8
			scale <.4,.3,1>
		}
		cylinder { //shoulder
			<0,-1,-8> <0,-1,8> 2.2
		}
		texture { SuitTex }
	}

#macro Arm ( Arm_Side, Pos01, Rot_up, Rot_low, Rot_hnd ) //center at shoulder
	#declare Pos01 = Pos01 * < 1, 1, Arm_Side >;
    #declare Rot_up = Rot_up * < Arm_Side, Arm_Side, 1 >;
	#declare Rot_low = Rot_low * < Arm_Side, Arm_Side, 1 >;
	#declare Rot_hnd = Rot_hnd * < Arm_Side, Arm_Side, 1 >;
	union {
		sphere { //shoulder end
			<0,0,0> 2.4
			translate Pos01
		}
		cone { //upper arm
			<0,0,0> 2.4 <11,0,0> 1.9
			rotate Rot_up
			translate Pos01
		}
		sphere {
			<11,0,0> 1.9
			rotate Rot_up
			translate Pos01
		}
		cone { //lower arm
			<0,0,0> 1.9 <10,0,0> 1.7
			rotate Rot_low
			translate <11,0,0>
			rotate Rot_up
			translate Pos01
		}
		sphere {
			<10,0,0> 1.6
			rotate Rot_low
			translate <11,0,0>
			rotate Rot_up
			translate Pos01
		}
		sphere { //hand
			<0,0,0>,2.5
			scale <1,.7,.6>
			translate <2.5,0,.5*Arm_Side>
			rotate Rot_hnd
			translate <10,0,0>
			rotate Rot_low
			translate <11,0,0>
			rotate Rot_up
			translate Pos01
			texture { SkinTex }
		}
     texture { SuitTex }
	}
#end

#declare Pilot_Dummy =
	union {
		object { Head rotate <0,12,0> }
		object { Torso rotate <0,0,20> }
		Arm ( 1, <0,-1,8>, <0,0,-60>, <0,29,53>, <0,0,24> ) //left arm
		Arm ( -1, <0,-1,8>, <0,0,-60>, <0,31,52>, <0,0,24> ) //right arm
		rotate <0,180,0>
		scale .4
	}


#declare Zero_Fighter =
union {
	object { Zero_Fuselage }
	object { Zero_Nose }
	object { Zero_Cabin }
	object { Zero_Cabin_Glass }
	object { Zero_Tail }
	object { Zero_Antenna }
	object { Zero_Guns }
	object { Zero_Exhausts }
	object { Zero_Propeller
		rotate x*Propeller_Turn
		translate < -11.1, 0.75, 0 >
	}
	object { Pilot_Dummy translate < 28, 9, 0 > }

	scale Zero_Scale
	translate Zero_Translate   // propeller tip starts at <0, 0, 0>

}


