#include "leptirko.pov"

object {
   leptirko
   scale 0.05
   rotate -75*x
   rotate 90*y
   rotate 15*y
   translate <10,2.4,-3.5>
}

#ifndef (IMPORT_SPATCH)

#declare oko =
   texture {
      pigment {
         onion
         pigment_map {
            [ 0.00 color rgb <0.0,0.0,0.0> ]
            [ 0.60 color rgb <0.0,0.0,0.0> ]
            [ 0.65 color rgb <0.9,0.9,0.2> ]
            [ 0.80
                  bumps
                  color_map {
                     [ 0 color rgb <0.6,0.9,0.6>*0.9 ]
                     [ 1 color rgb <0.6,0.9,0.6>*0.6 ]
                  } scale 0.05 scale <3,1,1>
            ]
            [ 1.00
                  bumps
                  color_map {
                     [ 0 color rgb <0.6,0.9,0.6> ]
                     [ 1 color rgb <0.6,0.9,0.6>/1.5 ]
                  } scale 0.1 scale <3,1,1>
            ]
         }
         turbulence 0.1
         octaves 8
         lambda 5
         omega 0.4
         triangle_wave
         translate <0,1,0>
      }
      finish {
         ambient 0.2
         diffuse 0.6
         phong 0.9
         phong_size 60
         brilliance 2
         reflection 0.4
      }
      normal {
         bumps 0.1
      }
   }

#end

#declare fishy =
union {
sphere {
   <0,0,0>,1
   texture {
      oko
      scale 0.9
      rotate -65*z
   }
   scale 0.28
   translate <0.36,0.525,-1.425>
}
union {
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.035, 1.060, -1.032> <-0.035, 1.048, -1.114> <-0.035, 0.996, -1.477> <-0.035, 0.992, -1.498> 
		<0.191, 1.053, -1.028> <0.191, 1.042, -1.110> <0.222, 0.990, -1.480> <0.222, 0.986, -1.501> 
		<0.434, 0.817, -1.180> <0.404, 0.859, -1.266> <0.333, 0.867, -1.277> <0.333, 0.865, -1.453> 
		<0.586, 0.653, -1.150> <0.556, 0.696, -1.236> <0.484, 0.797, -1.261> <0.484, 0.795, -1.437> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.035, 1.060, -1.032> <0.191, 1.053, -1.028> <0.434, 0.817, -1.180> <0.586, 0.653, -1.150> 
		<-0.034, 1.084, -0.851> <0.191, 1.078, -0.847> <0.432, 0.852, -0.834> <0.584, 0.688, -0.804> 
		<-0.033, 1.172, -0.212> <0.189, 1.176, -0.211> <0.464, 0.952, -0.349> <0.607, 0.782, -0.346> 
		<-0.034, 1.198, 0.000> <0.188, 1.202, 0.001> <0.435, 0.951, -0.004> <0.578, 0.781, 0.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.035, 1.060, -1.032> <-0.246, 1.066, -1.035> <-0.501, 0.860, -1.203> <-0.620, 0.688, -1.169> 
		<-0.035, 1.048, -1.114> <-0.246, 1.054, -1.117> <-0.475, 0.899, -1.279> <-0.594, 0.727, -1.246> 
		<-0.035, 0.996, -1.477> <-0.280, 1.002, -1.474> <-0.389, 0.891, -1.284> <-0.535, 0.826, -1.268> 
		<-0.035, 0.992, -1.498> <-0.280, 0.997, -1.495> <-0.389, 0.884, -1.441> <-0.535, 0.819, -1.424> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.035, 1.060, -1.032> <-0.034, 1.084, -0.851> <-0.033, 1.172, -0.212> <-0.034, 1.198, 0.000> 
		<-0.246, 1.066, -1.035> <-0.246, 1.091, -0.854> <-0.252, 1.168, -0.213> <-0.253, 1.194, -0.001> 
		<-0.501, 0.860, -1.203> <-0.505, 0.882, -0.853> <-0.494, 0.940, -0.349> <-0.478, 0.928, 0.000> 
		<-0.620, 0.688, -1.169> <-0.624, 0.710, -0.820> <-0.637, 0.774, -0.354> <-0.620, 0.761, -0.004> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.658, 0.156, -0.857> <-0.632, 0.155, -0.977> <-0.658, 0.149, -1.144> <-0.658, 0.147, -1.267> 
		<-0.605, 0.316, -0.933> <-0.579, 0.315, -1.053> <-0.644, 0.252, -1.186> <-0.644, 0.250, -1.309> 
		<-0.724, 0.537, -1.140> <-0.742, 0.476, -1.216> <-0.682, 0.389, -1.208> <-0.682, 0.381, -1.381> 
		<-0.620, 0.688, -1.169> <-0.638, 0.627, -1.245> <-0.681, 0.492, -1.250> <-0.681, 0.484, -1.423> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.658, 0.156, -0.857> <-0.605, 0.316, -0.933> <-0.724, 0.537, -1.140> <-0.620, 0.688, -1.169> 
		<-0.714, 0.157, -0.601> <-0.660, 0.318, -0.677> <-0.728, 0.559, -0.790> <-0.624, 0.710, -0.820> 
		<-0.934, 0.156, -0.288> <-0.887, 0.354, -0.305> <-0.770, 0.619, -0.357> <-0.637, 0.774, -0.354> 
		<-0.928, 0.155, -0.026> <-0.881, 0.352, -0.043> <-0.753, 0.606, -0.008> <-0.620, 0.761, -0.004> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.658, 0.156, -0.857> <-0.711, -0.001, -0.782> <-1.059, -0.184, -0.673> <-0.961, -0.337, -0.682> 
		<-0.632, 0.155, -0.977> <-0.684, -0.002, -0.903> <-1.046, -0.167, -0.802> <-0.948, -0.319, -0.810> 
		<-0.658, 0.149, -1.144> <-0.680, 0.002, -1.083> <-0.933, -0.220, -0.937> <-0.841, -0.349, -0.962> 
		<-0.658, 0.147, -1.267> <-0.680, -0.000, -1.206> <-0.892, -0.208, -1.059> <-0.799, -0.337, -1.084> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.658, 0.156, -0.857> <-0.714, 0.157, -0.601> <-0.934, 0.156, -0.288> <-0.928, 0.155, -0.026> 
		<-0.711, -0.001, -0.782> <-0.766, 0.001, -0.526> <-0.981, -0.037, -0.271> <-0.974, -0.039, -0.009> 
		<-1.059, -0.184, -0.673> <-1.083, -0.216, -0.436> <-1.194, -0.334, -0.092> <-1.048, -0.343, 0.101> 
		<-0.961, -0.337, -0.682> <-0.986, -0.368, -0.444> <-1.066, -0.487, -0.088> <-0.921, -0.497, 0.104> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.961, -0.337, -0.682> <-0.986, -0.368, -0.444> <-1.066, -0.487, -0.088> <-0.921, -0.497, 0.104> 
		<-0.788, -0.608, -0.697> <-0.813, -0.640, -0.460> <-0.876, -0.716, -0.082> <-0.731, -0.726, 0.110> 
		<-0.355, -0.826, -0.910> <-0.355, -0.863, -0.637> <-0.333, -0.902, -0.276> <-0.329, -0.925, -0.002> 
		<-0.032, -0.826, -0.913> <-0.032, -0.863, -0.640> <-0.035, -0.901, -0.274> <-0.031, -0.924, 0.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.961, -0.337, -0.682> <-0.788, -0.608, -0.697> <-0.355, -0.826, -0.910> <-0.032, -0.826, -0.913> 
		<-0.948, -0.319, -0.810> <-0.775, -0.591, -0.826> <-0.355, -0.804, -1.068> <-0.032, -0.804, -1.070> 
		<-0.841, -0.349, -0.962> <-0.680, -0.573, -1.004> <-0.311, -0.745, -1.274> <-0.032, -0.745, -1.276> 
		<-0.799, -0.337, -1.084> <-0.639, -0.561, -1.127> <-0.311, -0.726, -1.433> <-0.032, -0.726, -1.434> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.032, -0.826, -0.913> <-0.032, -0.863, -0.640> <-0.035, -0.901, -0.274> <-0.031, -0.924, 0.000> 
		<0.266, -0.826, -0.915> <0.267, -0.864, -0.643> <0.271, -0.899, -0.272> <0.275, -0.922, 0.002> 
		<0.613, -0.563, -0.709> <0.648, -0.593, -0.464> <0.817, -0.715, -0.102> <0.687, -0.723, 0.112> 
		<0.808, -0.337, -0.698> <0.843, -0.367, -0.453> <1.013, -0.480, -0.097> <0.884, -0.488, 0.116> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.032, -0.826, -0.913> <0.266, -0.826, -0.915> <0.613, -0.563, -0.709> <0.808, -0.337, -0.698> 
		<-0.032, -0.804, -1.070> <0.266, -0.804, -1.073> <0.596, -0.548, -0.829> <0.791, -0.322, -0.818> 
		<-0.032, -0.745, -1.276> <0.239, -0.745, -1.277> <0.552, -0.550, -1.009> <0.730, -0.349, -0.973> 
		<-0.032, -0.726, -1.434> <0.239, -0.726, -1.436> <0.531, -0.538, -1.129> <0.710, -0.338, -1.092> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.808, -0.337, -0.698> <0.843, -0.367, -0.453> <1.013, -0.480, -0.097> <0.884, -0.488, 0.116> 
		<0.909, -0.220, -0.692> <0.944, -0.250, -0.447> <1.135, -0.334, -0.094> <1.006, -0.342, 0.119> 
		<0.841, 0.013, -0.802> <0.865, 0.013, -0.537> <0.979, -0.041, -0.216> <0.902, -0.045, 0.039> 
		<0.810, 0.151, -0.865> <0.834, 0.150, -0.599> <0.935, 0.144, -0.233> <0.858, 0.140, 0.022> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.808, -0.337, -0.698> <0.909, -0.220, -0.692> <0.841, 0.013, -0.802> <0.810, 0.151, -0.865> 
		<0.791, -0.322, -0.818> <0.892, -0.205, -0.812> <0.830, 0.014, -0.926> <0.799, 0.151, -0.989> 
		<0.730, -0.349, -0.973> <0.832, -0.235, -0.952> <0.771, 0.005, -1.093> <0.762, 0.148, -1.152> 
		<0.710, -0.338, -1.092> <0.812, -0.223, -1.071> <0.751, 0.001, -1.216> <0.741, 0.143, -1.275> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.810, 0.151, -0.865> <0.773, 0.317, -0.941> <0.712, 0.519, -1.125> <0.586, 0.653, -1.150> 
		<0.799, 0.151, -0.989> <0.762, 0.317, -1.065> <0.733, 0.461, -1.207> <0.608, 0.595, -1.232> 
		<0.762, 0.148, -1.152> <0.755, 0.248, -1.194> <0.685, 0.366, -1.205> <0.658, 0.463, -1.245> 
		<0.741, 0.143, -1.275> <0.735, 0.243, -1.317> <0.685, 0.364, -1.385> <0.658, 0.461, -1.424> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.810, 0.151, -0.865> <0.834, 0.150, -0.599> <0.935, 0.144, -0.233> <0.858, 0.140, 0.022> 
		<0.773, 0.317, -0.941> <0.797, 0.316, -0.675> <0.886, 0.347, -0.252> <0.809, 0.343, 0.004> 
		<0.712, 0.519, -1.125> <0.710, 0.554, -0.780> <0.743, 0.622, -0.342> <0.713, 0.620, 0.003> 
		<0.586, 0.653, -1.150> <0.584, 0.688, -0.804> <0.607, 0.782, -0.346> <0.578, 0.781, 0.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.799, -0.337, -1.084> <-0.773, -0.330, -1.159> <-0.777, -0.279, -1.266> <-0.738, -0.272, -1.335> 
		<-0.892, -0.208, -1.059> <-0.866, -0.200, -1.135> <-0.851, -0.178, -1.218> <-0.812, -0.171, -1.287> 
		<-0.680, -0.000, -1.206> <-0.680, -0.001, -1.267> <-0.683, 0.034, -1.366> <-0.674, 0.021, -1.425> 
		<-0.658, 0.147, -1.267> <-0.658, 0.146, -1.328> <-0.667, 0.159, -1.411> <-0.658, 0.146, -1.470> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.799, -0.337, -1.084> <-0.639, -0.561, -1.127> <-0.311, -0.726, -1.433> <-0.032, -0.726, -1.434> 
		<-0.773, -0.330, -1.159> <-0.613, -0.553, -1.202> <-0.311, -0.710, -1.564> <-0.032, -0.710, -1.565> 
		<-0.777, -0.279, -1.266> <-0.613, -0.503, -1.372> <-0.329, -0.714, -1.743> <-0.032, -0.715, -1.743> 
		<-0.738, -0.272, -1.335> <-0.574, -0.496, -1.441> <-0.329, -0.710, -1.875> <-0.032, -0.710, -1.875> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.032, -0.726, -1.434> <0.239, -0.726, -1.436> <0.531, -0.538, -1.129> <0.710, -0.338, -1.092> 
		<-0.032, -0.710, -1.565> <0.239, -0.710, -1.567> <0.519, -0.531, -1.203> <0.697, -0.330, -1.166> 
		<-0.032, -0.715, -1.743> <0.270, -0.715, -1.743> <0.530, -0.494, -1.360> <0.719, -0.280, -1.263> 
		<-0.032, -0.710, -1.875> <0.270, -0.710, -1.875> <0.510, -0.489, -1.433> <0.699, -0.274, -1.335> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.710, -0.338, -1.092> <0.812, -0.223, -1.071> <0.751, 0.001, -1.216> <0.741, 0.143, -1.275> 
		<0.697, -0.330, -1.166> <0.799, -0.216, -1.145> <0.740, -0.002, -1.282> <0.730, 0.141, -1.341> 
		<0.719, -0.280, -1.263> <0.800, -0.188, -1.221> <0.733, 0.021, -1.384> <0.718, 0.141, -1.430> 
		<0.699, -0.274, -1.335> <0.780, -0.182, -1.293> <0.720, 0.007, -1.448> <0.705, 0.127, -1.494> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.035, 0.889, -1.858> <0.172, 0.886, -1.859> <0.450, 0.787, -1.756> <0.586, 0.647, -1.689> 
		<-0.035, 0.906, -1.808> <0.172, 0.903, -1.810> <0.420, 0.831, -1.680> <0.556, 0.692, -1.613> 
		<-0.035, 0.988, -1.514> <0.222, 0.982, -1.517> <0.333, 0.863, -1.615> <0.484, 0.793, -1.599> 
		<-0.035, 0.992, -1.498> <0.222, 0.986, -1.501> <0.333, 0.865, -1.453> <0.484, 0.795, -1.437> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.035, 0.889, -1.858> <-0.035, 0.860, -1.941> <-0.037, 0.727, -2.336> <-0.035, 0.659, -2.447> 
		<0.172, 0.886, -1.859> <0.172, 0.857, -1.943> <0.195, 0.727, -2.335> <0.197, 0.659, -2.446> 
		<0.450, 0.787, -1.756> <0.434, 0.644, -1.971> <0.528, 0.411, -2.311> <0.382, 0.280, -2.481> 
		<0.586, 0.647, -1.689> <0.570, 0.504, -1.904> <0.670, 0.260, -2.207> <0.524, 0.129, -2.377> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.035, 0.889, -1.858> <-0.035, 0.906, -1.808> <-0.035, 0.988, -1.514> <-0.035, 0.992, -1.498> 
		<-0.230, 0.892, -1.856> <-0.230, 0.909, -1.807> <-0.280, 0.994, -1.511> <-0.280, 0.997, -1.495> 
		<-0.503, 0.804, -1.752> <-0.477, 0.850, -1.675> <-0.389, 0.877, -1.603> <-0.389, 0.884, -1.441> 
		<-0.620, 0.665, -1.679> <-0.594, 0.711, -1.603> <-0.535, 0.812, -1.586> <-0.535, 0.819, -1.424> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.035, 0.889, -1.858> <-0.230, 0.892, -1.856> <-0.503, 0.804, -1.752> <-0.620, 0.665, -1.679> 
		<-0.035, 0.860, -1.941> <-0.230, 0.863, -1.940> <-0.477, 0.652, -1.970> <-0.593, 0.513, -1.897> 
		<-0.037, 0.727, -2.336> <-0.251, 0.727, -2.338> <-0.535, 0.418, -2.306> <-0.650, 0.269, -2.205> 
		<-0.035, 0.659, -2.447> <-0.248, 0.659, -2.448> <-0.392, 0.278, -2.483> <-0.507, 0.129, -2.382> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.658, 0.146, -1.470> <-0.638, 0.303, -1.528> <-0.720, 0.545, -1.617> <-0.620, 0.665, -1.679> 
		<-0.667, 0.159, -1.411> <-0.647, 0.316, -1.469> <-0.738, 0.491, -1.540> <-0.638, 0.611, -1.602> 
		<-0.658, 0.146, -1.328> <-0.644, 0.249, -1.370> <-0.682, 0.374, -1.548> <-0.681, 0.477, -1.590> 
		<-0.658, 0.147, -1.267> <-0.644, 0.250, -1.309> <-0.682, 0.381, -1.381> <-0.681, 0.484, -1.423> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.658, 0.146, -1.470> <-0.636, 0.110, -1.630> <-0.676, 0.020, -1.880> <-0.555, -0.014, -1.988> 
		<-0.638, 0.303, -1.528> <-0.616, 0.267, -1.688> <-0.680, 0.083, -1.990> <-0.560, 0.048, -2.098> 
		<-0.720, 0.545, -1.617> <-0.694, 0.393, -1.835> <-0.718, 0.181, -2.145> <-0.575, 0.041, -2.322> 
		<-0.620, 0.665, -1.679> <-0.593, 0.513, -1.897> <-0.650, 0.269, -2.205> <-0.507, 0.129, -2.382> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.658, 0.146, -1.470> <-0.674, 0.021, -1.425> <-0.812, -0.171, -1.287> <-0.738, -0.272, -1.335> 
		<-0.636, 0.110, -1.630> <-0.651, -0.015, -1.585> <-0.752, -0.162, -1.395> <-0.678, -0.263, -1.443> 
		<-0.676, 0.020, -1.880> <-0.671, -0.044, -1.766> <-0.664, -0.195, -1.546> <-0.597, -0.281, -1.618> 
		<-0.555, -0.014, -1.988> <-0.551, -0.079, -1.875> <-0.546, -0.199, -1.585> <-0.479, -0.285, -1.656> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.738, -0.272, -1.335> <-0.574, -0.496, -1.441> <-0.329, -0.710, -1.875> <-0.032, -0.710, -1.875> 
		<-0.678, -0.263, -1.443> <-0.514, -0.487, -1.549> <-0.329, -0.703, -2.076> <-0.032, -0.703, -2.076> 
		<-0.597, -0.281, -1.618> <-0.431, -0.494, -1.793> <-0.356, -0.728, -2.345> <-0.035, -0.730, -2.348> 
		<-0.479, -0.285, -1.656> <-0.314, -0.498, -1.832> <-0.354, -0.684, -2.541> <-0.032, -0.686, -2.544> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.032, -0.710, -1.875> <0.270, -0.710, -1.875> <0.510, -0.489, -1.433> <0.699, -0.274, -1.335> 
		<-0.032, -0.703, -2.076> <0.270, -0.703, -2.076> <0.481, -0.481, -1.537> <0.670, -0.266, -1.439> 
		<-0.035, -0.730, -2.348> <0.303, -0.733, -2.351> <0.459, -0.502, -1.807> <0.656, -0.290, -1.631> 
		<-0.032, -0.686, -2.544> <0.306, -0.689, -2.547> <0.356, -0.505, -1.840> <0.553, -0.293, -1.664> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.699, -0.274, -1.335> <0.780, -0.182, -1.293> <0.720, 0.007, -1.448> <0.705, 0.127, -1.494> 
		<0.670, -0.266, -1.439> <0.751, -0.174, -1.397> <0.689, -0.025, -1.598> <0.674, 0.095, -1.644> 
		<0.656, -0.290, -1.631> <0.730, -0.209, -1.565> <0.724, -0.049, -1.783> <0.719, 0.017, -1.894> 
		<0.553, -0.293, -1.664> <0.627, -0.212, -1.597> <0.599, -0.076, -1.874> <0.595, -0.011, -1.985> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.705, 0.127, -1.494> <0.718, 0.141, -1.430> <0.730, 0.141, -1.341> <0.741, 0.143, -1.275> 
		<0.686, 0.285, -1.555> <0.699, 0.299, -1.491> <0.724, 0.240, -1.382> <0.735, 0.243, -1.317> 
		<0.698, 0.532, -1.634> <0.720, 0.476, -1.555> <0.685, 0.362, -1.558> <0.685, 0.364, -1.385> 
		<0.586, 0.647, -1.689> <0.608, 0.591, -1.610> <0.658, 0.459, -1.598> <0.658, 0.461, -1.424> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.705, 0.127, -1.494> <0.686, 0.285, -1.555> <0.698, 0.532, -1.634> <0.586, 0.647, -1.689> 
		<0.674, 0.095, -1.644> <0.655, 0.253, -1.705> <0.682, 0.388, -1.849> <0.570, 0.504, -1.904> 
		<0.719, 0.017, -1.894> <0.715, 0.081, -2.003> <0.747, 0.177, -2.150> <0.670, 0.260, -2.207> 
		<0.595, -0.011, -1.985> <0.591, 0.054, -2.094> <0.601, 0.046, -2.320> <0.524, 0.129, -2.377> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.484, 0.795, -1.437> <0.484, 0.793, -1.599> <0.556, 0.692, -1.613> <0.586, 0.647, -1.689> 
		<0.484, 0.797, -1.261> <0.484, 0.795, -1.423> <0.577, 0.636, -1.534> <0.608, 0.591, -1.610> 
		<0.556, 0.696, -1.236> <0.577, 0.638, -1.318> <0.658, 0.461, -1.418> <0.658, 0.459, -1.598> 
		<0.586, 0.653, -1.150> <0.608, 0.595, -1.232> <0.658, 0.463, -1.245> <0.658, 0.461, -1.424> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.484, 0.795, -1.437> <0.484, 0.793, -1.599> <0.556, 0.692, -1.613> <0.586, 0.647, -1.689> 
		<0.505, 0.786, -1.434> <0.505, 0.784, -1.597> <0.558, 0.708, -1.588> <0.588, 0.664, -1.664> 
		<0.539, 0.780, -1.437> <0.539, 0.780, -1.548> <0.582, 0.709, -1.622> <0.602, 0.668, -1.621> 
		<0.529, 0.733, -1.437> <0.529, 0.734, -1.548> <0.563, 0.694, -1.588> <0.584, 0.653, -1.587> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.484, 0.795, -1.437> <0.505, 0.786, -1.434> <0.539, 0.780, -1.437> <0.529, 0.733, -1.437> 
		<0.484, 0.797, -1.261> <0.505, 0.788, -1.259> <0.540, 0.779, -1.310> <0.529, 0.733, -1.309> 
		<0.556, 0.696, -1.236> <0.556, 0.693, -1.267> <0.578, 0.714, -1.220> <0.561, 0.700, -1.256> 
		<0.586, 0.653, -1.150> <0.586, 0.650, -1.181> <0.602, 0.667, -1.219> <0.584, 0.653, -1.256> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.658, 0.461, -1.424> <0.658, 0.463, -1.245> <0.608, 0.595, -1.232> <0.586, 0.653, -1.150> 
		<0.653, 0.479, -1.432> <0.653, 0.481, -1.253> <0.608, 0.592, -1.264> <0.586, 0.650, -1.181> 
		<0.676, 0.517, -1.427> <0.676, 0.517, -1.288> <0.627, 0.615, -1.218> <0.602, 0.667, -1.219> 
		<0.634, 0.525, -1.433> <0.634, 0.525, -1.294> <0.610, 0.602, -1.255> <0.584, 0.653, -1.256> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.658, 0.461, -1.424> <0.653, 0.479, -1.432> <0.676, 0.517, -1.427> <0.634, 0.525, -1.433> 
		<0.658, 0.459, -1.598> <0.653, 0.477, -1.606> <0.675, 0.517, -1.555> <0.633, 0.526, -1.561> 
		<0.608, 0.591, -1.610> <0.610, 0.608, -1.584> <0.626, 0.621, -1.620> <0.607, 0.606, -1.586> 
		<0.586, 0.647, -1.689> <0.588, 0.664, -1.664> <0.602, 0.668, -1.621> <0.584, 0.653, -1.587> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.529, 0.733, -1.437> <0.516, 0.677, -1.436> <0.478, 0.691, -1.435> <0.457, 0.673, -1.435> 
		<0.529, 0.733, -1.309> <0.516, 0.677, -1.308> <0.478, 0.692, -1.393> <0.456, 0.674, -1.392> 
		<0.561, 0.700, -1.256> <0.540, 0.683, -1.302> <0.507, 0.644, -1.308> <0.482, 0.624, -1.331> 
		<0.584, 0.653, -1.256> <0.563, 0.636, -1.301> <0.526, 0.606, -1.309> <0.502, 0.586, -1.332> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.529, 0.733, -1.437> <0.529, 0.734, -1.548> <0.563, 0.694, -1.588> <0.584, 0.653, -1.587> 
		<0.516, 0.677, -1.436> <0.516, 0.677, -1.547> <0.542, 0.678, -1.550> <0.562, 0.637, -1.549> 
		<0.478, 0.691, -1.435> <0.479, 0.691, -1.480> <0.508, 0.643, -1.555> <0.528, 0.604, -1.556> 
		<0.457, 0.673, -1.435> <0.457, 0.673, -1.480> <0.484, 0.622, -1.542> <0.504, 0.582, -1.543> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.634, 0.525, -1.433> <0.579, 0.536, -1.441> <0.579, 0.494, -1.437> <0.555, 0.481, -1.439> 
		<0.633, 0.526, -1.561> <0.579, 0.536, -1.569> <0.579, 0.493, -1.483> <0.555, 0.480, -1.485> 
		<0.607, 0.606, -1.586> <0.586, 0.589, -1.548> <0.549, 0.563, -1.557> <0.525, 0.541, -1.544> 
		<0.584, 0.653, -1.587> <0.562, 0.637, -1.549> <0.528, 0.604, -1.556> <0.504, 0.582, -1.543> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.634, 0.525, -1.433> <0.634, 0.525, -1.294> <0.610, 0.602, -1.255> <0.584, 0.653, -1.256> 
		<0.579, 0.536, -1.441> <0.579, 0.536, -1.302> <0.589, 0.585, -1.300> <0.563, 0.636, -1.301> 
		<0.579, 0.494, -1.437> <0.578, 0.495, -1.389> <0.548, 0.564, -1.310> <0.526, 0.606, -1.309> 
		<0.555, 0.481, -1.439> <0.554, 0.482, -1.391> <0.523, 0.543, -1.333> <0.502, 0.586, -1.332> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.535, 0.819, -1.424> <-0.535, 0.826, -1.268> <-0.594, 0.727, -1.246> <-0.620, 0.688, -1.169> 
		<-0.535, 0.812, -1.586> <-0.535, 0.819, -1.430> <-0.612, 0.666, -1.322> <-0.638, 0.627, -1.245> 
		<-0.594, 0.711, -1.603> <-0.612, 0.657, -1.526> <-0.681, 0.485, -1.417> <-0.681, 0.492, -1.250> 
		<-0.620, 0.665, -1.679> <-0.638, 0.611, -1.602> <-0.681, 0.477, -1.590> <-0.681, 0.484, -1.423> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.535, 0.819, -1.424> <-0.535, 0.826, -1.268> <-0.594, 0.727, -1.246> <-0.620, 0.688, -1.169> 
		<-0.551, 0.812, -1.422> <-0.551, 0.819, -1.266> <-0.594, 0.725, -1.273> <-0.619, 0.686, -1.196> 
		<-0.565, 0.796, -1.435> <-0.565, 0.796, -1.308> <-0.597, 0.742, -1.229> <-0.621, 0.695, -1.229> 
		<-0.548, 0.763, -1.439> <-0.548, 0.763, -1.311> <-0.580, 0.729, -1.259> <-0.604, 0.682, -1.258> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.535, 0.819, -1.424> <-0.551, 0.812, -1.422> <-0.565, 0.796, -1.435> <-0.548, 0.763, -1.439> 
		<-0.535, 0.812, -1.586> <-0.551, 0.805, -1.584> <-0.564, 0.796, -1.546> <-0.548, 0.763, -1.550> 
		<-0.594, 0.711, -1.603> <-0.597, 0.727, -1.580> <-0.603, 0.735, -1.619> <-0.582, 0.724, -1.590> 
		<-0.620, 0.665, -1.679> <-0.622, 0.681, -1.657> <-0.624, 0.694, -1.619> <-0.603, 0.683, -1.589> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.681, 0.484, -1.423> <-0.680, 0.506, -1.432> <-0.698, 0.544, -1.427> <-0.653, 0.555, -1.435> 
		<-0.681, 0.492, -1.250> <-0.680, 0.513, -1.259> <-0.699, 0.544, -1.289> <-0.653, 0.555, -1.296> 
		<-0.638, 0.627, -1.245> <-0.638, 0.625, -1.272> <-0.647, 0.644, -1.228> <-0.629, 0.631, -1.257> 
		<-0.620, 0.688, -1.169> <-0.619, 0.686, -1.196> <-0.621, 0.695, -1.229> <-0.604, 0.682, -1.258> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.681, 0.484, -1.423> <-0.681, 0.477, -1.590> <-0.638, 0.611, -1.602> <-0.620, 0.665, -1.679> 
		<-0.680, 0.506, -1.432> <-0.680, 0.498, -1.599> <-0.641, 0.627, -1.580> <-0.622, 0.681, -1.657> 
		<-0.698, 0.544, -1.427> <-0.698, 0.544, -1.555> <-0.648, 0.647, -1.618> <-0.624, 0.694, -1.619> 
		<-0.653, 0.555, -1.435> <-0.652, 0.555, -1.563> <-0.627, 0.635, -1.589> <-0.603, 0.683, -1.589> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.548, 0.763, -1.439> <-0.548, 0.763, -1.311> <-0.580, 0.729, -1.259> <-0.604, 0.682, -1.258> 
		<-0.522, 0.711, -1.444> <-0.522, 0.711, -1.317> <-0.554, 0.711, -1.301> <-0.578, 0.664, -1.300> 
		<-0.498, 0.721, -1.438> <-0.497, 0.721, -1.395> <-0.526, 0.673, -1.310> <-0.546, 0.635, -1.311> 
		<-0.476, 0.703, -1.437> <-0.475, 0.703, -1.394> <-0.501, 0.653, -1.333> <-0.521, 0.615, -1.334> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.548, 0.763, -1.439> <-0.522, 0.711, -1.444> <-0.498, 0.721, -1.438> <-0.476, 0.703, -1.437> 
		<-0.548, 0.763, -1.550> <-0.522, 0.711, -1.556> <-0.498, 0.720, -1.482> <-0.476, 0.702, -1.482> 
		<-0.582, 0.724, -1.590> <-0.556, 0.709, -1.554> <-0.527, 0.673, -1.557> <-0.503, 0.651, -1.544> 
		<-0.603, 0.683, -1.589> <-0.577, 0.668, -1.553> <-0.547, 0.633, -1.558> <-0.523, 0.611, -1.545> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.653, 0.555, -1.435> <-0.652, 0.555, -1.563> <-0.627, 0.635, -1.589> <-0.603, 0.683, -1.589> 
		<-0.599, 0.568, -1.444> <-0.599, 0.568, -1.572> <-0.601, 0.621, -1.552> <-0.577, 0.668, -1.553> 
		<-0.598, 0.523, -1.439> <-0.598, 0.522, -1.486> <-0.568, 0.592, -1.559> <-0.547, 0.633, -1.558> 
		<-0.574, 0.510, -1.441> <-0.575, 0.509, -1.488> <-0.544, 0.570, -1.546> <-0.523, 0.611, -1.545> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.653, 0.555, -1.435> <-0.599, 0.568, -1.444> <-0.598, 0.523, -1.439> <-0.574, 0.510, -1.441> 
		<-0.653, 0.555, -1.296> <-0.599, 0.567, -1.306> <-0.597, 0.524, -1.392> <-0.574, 0.511, -1.394> 
		<-0.629, 0.631, -1.257> <-0.604, 0.612, -1.299> <-0.567, 0.593, -1.312> <-0.543, 0.573, -1.335> 
		<-0.604, 0.682, -1.258> <-0.578, 0.664, -1.300> <-0.546, 0.635, -1.311> <-0.521, 0.615, -1.334> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.032, -0.686, -2.544> <0.306, -0.689, -2.547> <0.356, -0.505, -1.840> <0.553, -0.293, -1.664> 
		<-0.354, -0.684, -2.541> <-0.016, -0.687, -2.544> <0.187, -0.511, -1.893> <0.384, -0.299, -1.718> 
		<-0.314, -0.498, -1.832> <-0.183, -0.503, -1.875> <0.010, -0.299, -1.568> <0.147, -0.300, -1.569> 
		<-0.479, -0.285, -1.656> <-0.349, -0.290, -1.699> <-0.168, -0.298, -1.566> <-0.031, -0.299, -1.567> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.032, -0.686, -2.544> <-0.354, -0.684, -2.541> <-0.314, -0.498, -1.832> <-0.479, -0.285, -1.656> 
		<-0.032, -0.677, -2.584> <-0.353, -0.675, -2.581> <-0.183, -0.503, -1.875> <-0.349, -0.290, -1.699> 
		<-0.025, -0.594, -2.498> <-0.024, -0.491, -2.237> <-0.165, -0.519, -1.739> <-0.168, -0.298, -1.566> 
		<-0.025, -0.579, -2.460> <-0.024, -0.476, -2.199> <-0.027, -0.520, -1.740> <-0.031, -0.299, -1.567> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.032, -0.686, -2.544> <0.306, -0.689, -2.547> <0.356, -0.505, -1.840> <0.553, -0.293, -1.664> 
		<-0.032, -0.677, -2.584> <0.306, -0.680, -2.586> <0.187, -0.511, -1.893> <0.384, -0.299, -1.718> 
		<-0.025, -0.594, -2.498> <-0.024, -0.491, -2.237> <0.150, -0.521, -1.741> <0.147, -0.300, -1.569> 
		<-0.025, -0.579, -2.460> <-0.024, -0.476, -2.199> <-0.027, -0.520, -1.740> <-0.031, -0.299, -1.567> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.035, 0.659, -2.447> <-0.248, 0.659, -2.448> <-0.392, 0.278, -2.483> <-0.507, 0.129, -2.382> 
		<0.197, 0.659, -2.446> <-0.016, 0.659, -2.447> <-0.243, 0.326, -2.618> <-0.358, 0.177, -2.516> 
		<0.382, 0.280, -2.481> <0.221, 0.328, -2.617> <0.000, 0.289, -2.829> <-0.254, 0.289, -2.831> 
		<0.524, 0.129, -2.377> <0.363, 0.177, -2.512> <0.242, 0.289, -2.828> <-0.011, 0.289, -2.829> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.035, 0.659, -2.447> <-0.035, 0.659, -2.447> <-0.035, 0.659, -2.447> <-0.035, 0.659, -2.447> 
		<-0.032, 0.601, -2.540> <0.200, 0.601, -2.538> <0.200, 0.601, -2.538> <0.197, 0.659, -2.446> 
		<-0.012, 0.448, -2.840> <0.242, 0.448, -2.839> <0.221, 0.328, -2.617> <0.382, 0.280, -2.481> 
		<-0.011, 0.289, -2.829> <0.242, 0.289, -2.828> <0.363, 0.177, -2.512> <0.524, 0.129, -2.377> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.035, 0.659, -2.447> <-0.248, 0.659, -2.448> <-0.392, 0.278, -2.483> <-0.507, 0.129, -2.382> 
		<0.197, 0.659, -2.446> <-0.016, 0.659, -2.447> <-0.315, 0.203, -2.579> <-0.431, 0.054, -2.477> 
		<0.382, 0.280, -2.481> <0.288, 0.195, -2.590> <-0.008, 0.092, -2.408> <-0.175, 0.092, -2.409> 
		<0.524, 0.129, -2.377> <0.430, 0.044, -2.486> <0.135, 0.092, -2.408> <-0.032, 0.092, -2.409> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.035, 0.659, -2.447> <0.197, 0.659, -2.446> <0.382, 0.280, -2.481> <0.524, 0.129, -2.377> 
		<-0.032, 0.601, -2.540> <0.200, 0.601, -2.538> <0.288, 0.195, -2.590> <0.430, 0.044, -2.486> 
		<-0.012, 0.448, -2.840> <-0.012, 0.309, -2.831> <0.139, 0.144, -2.537> <0.135, 0.092, -2.408> 
		<-0.011, 0.289, -2.829> <-0.011, 0.149, -2.820> <-0.029, 0.144, -2.538> <-0.032, 0.092, -2.409> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.035, 0.659, -2.447> <-0.035, 0.659, -2.447> <-0.035, 0.659, -2.447> <-0.035, 0.659, -2.447> 
		<-0.032, 0.601, -2.540> <-0.246, 0.601, -2.541> <-0.246, 0.601, -2.541> <-0.248, 0.659, -2.448> 
		<-0.012, 0.448, -2.840> <-0.254, 0.448, -2.841> <-0.243, 0.326, -2.618> <-0.392, 0.278, -2.483> 
		<-0.011, 0.289, -2.829> <-0.254, 0.289, -2.831> <-0.358, 0.177, -2.516> <-0.507, 0.129, -2.382> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.035, 0.659, -2.447> <-0.248, 0.659, -2.448> <-0.392, 0.278, -2.483> <-0.507, 0.129, -2.382> 
		<-0.032, 0.601, -2.540> <-0.246, 0.601, -2.541> <-0.315, 0.203, -2.579> <-0.431, 0.054, -2.477> 
		<-0.012, 0.448, -2.840> <-0.012, 0.309, -2.831> <-0.172, 0.144, -2.538> <-0.175, 0.092, -2.409> 
		<-0.011, 0.289, -2.829> <-0.011, 0.149, -2.820> <-0.029, 0.144, -2.538> <-0.032, 0.092, -2.409> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.032, 0.092, -2.409> <0.135, 0.092, -2.408> <0.430, 0.044, -2.486> <0.524, 0.129, -2.377> 
		<-0.175, 0.092, -2.409> <-0.008, 0.092, -2.408> <0.269, 0.092, -2.622> <0.363, 0.177, -2.512> 
		<-0.431, 0.054, -2.477> <-0.282, 0.102, -2.611> <0.000, 0.289, -2.829> <0.242, 0.289, -2.828> 
		<-0.507, 0.129, -2.382> <-0.358, 0.177, -2.516> <-0.254, 0.289, -2.831> <-0.011, 0.289, -2.829> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.032, 0.092, -2.409> <-0.032, 0.092, -2.409> <-0.032, 0.092, -2.409> <-0.032, 0.092, -2.409> 
		<-0.029, 0.144, -2.538> <0.139, 0.144, -2.537> <0.139, 0.144, -2.537> <0.135, 0.092, -2.408> 
		<-0.011, 0.149, -2.820> <0.243, 0.149, -2.819> <0.269, 0.092, -2.622> <0.430, 0.044, -2.486> 
		<-0.011, 0.289, -2.829> <0.242, 0.289, -2.828> <0.363, 0.177, -2.512> <0.524, 0.129, -2.377> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.032, 0.092, -2.409> <-0.035, 0.047, -2.299> <-0.033, 0.014, -2.143> <-0.032, -0.036, -2.036> 
		<0.135, 0.092, -2.408> <0.132, 0.047, -2.298> <0.156, 0.015, -2.143> <0.157, -0.035, -2.036> 
		<0.430, 0.044, -2.486> <0.507, -0.038, -2.429> <0.441, 0.020, -2.204> <0.445, -0.044, -2.095> 
		<0.524, 0.129, -2.377> <0.601, 0.046, -2.320> <0.591, 0.054, -2.094> <0.595, -0.011, -1.985> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.032, 0.092, -2.409> <-0.032, 0.092, -2.409> <-0.032, 0.092, -2.409> <-0.032, 0.092, -2.409> 
		<-0.029, 0.144, -2.538> <-0.172, 0.144, -2.538> <-0.172, 0.144, -2.538> <-0.175, 0.092, -2.409> 
		<-0.011, 0.149, -2.820> <-0.253, 0.149, -2.821> <-0.282, 0.102, -2.611> <-0.431, 0.054, -2.477> 
		<-0.011, 0.289, -2.829> <-0.254, 0.289, -2.831> <-0.358, 0.177, -2.516> <-0.507, 0.129, -2.382> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.032, 0.092, -2.409> <-0.175, 0.092, -2.409> <-0.431, 0.054, -2.477> <-0.507, 0.129, -2.382> 
		<-0.035, 0.047, -2.299> <-0.178, 0.047, -2.300> <-0.499, -0.034, -2.417> <-0.575, 0.041, -2.322> 
		<-0.033, 0.014, -2.143> <-0.190, 0.013, -2.144> <-0.445, 0.015, -2.202> <-0.560, 0.048, -2.098> 
		<-0.032, -0.036, -2.036> <-0.190, -0.036, -2.037> <-0.441, -0.048, -2.092> <-0.555, -0.014, -1.988> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.555, -0.014, -1.988> <-0.551, -0.079, -1.875> <-0.546, -0.199, -1.585> <-0.479, -0.285, -1.656> 
		<-0.441, -0.048, -2.092> <-0.437, -0.112, -1.978> <-0.416, -0.204, -1.628> <-0.349, -0.290, -1.699> 
		<-0.190, -0.036, -2.037> <-0.190, -0.104, -1.890> <-0.170, -0.171, -1.467> <-0.168, -0.298, -1.566> 
		<-0.032, -0.036, -2.036> <-0.032, -0.104, -1.890> <-0.032, -0.172, -1.468> <-0.031, -0.299, -1.567> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.595, -0.011, -1.985> <0.445, -0.044, -2.095> <0.157, -0.035, -2.036> <-0.032, -0.036, -2.036> 
		<0.599, -0.076, -1.874> <0.450, -0.110, -1.984> <0.157, -0.103, -1.889> <-0.032, -0.104, -1.890> 
		<0.627, -0.212, -1.597> <0.459, -0.218, -1.651> <0.145, -0.173, -1.470> <-0.032, -0.172, -1.468> 
		<0.553, -0.293, -1.664> <0.384, -0.299, -1.718> <0.147, -0.300, -1.569> <-0.031, -0.299, -1.567> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.571, 0.148, -0.090> <0.600, 0.149, 0.509> <0.737, 0.149, 1.311> <0.670, 0.149, 1.907> 
		<0.563, 0.833, -0.090> <0.593, 0.833, 0.509> <0.729, 0.887, 1.310> <0.662, 0.887, 1.906> 
		<0.338, 1.214, 0.206> <0.317, 1.229, 0.675> <0.362, 1.253, 1.377> <0.290, 1.257, 1.841> 
		<-0.040, 1.211, 0.208> <-0.061, 1.226, 0.676> <-0.040, 1.251, 1.306> <-0.112, 1.255, 1.770> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.571, 0.148, -0.090> <0.578, -0.533, -0.090> <0.360, -0.917, 0.206> <-0.017, -0.920, 0.208> 
		<0.600, 0.149, 0.509> <0.608, -0.532, 0.509> <0.345, -0.928, 0.676> <-0.032, -0.931, 0.678> 
		<0.737, 0.149, 1.311> <0.745, -0.585, 1.313> <0.358, -0.959, 1.550> <-0.042, -0.961, 1.480> 
		<0.670, 0.149, 1.907> <0.678, -0.585, 1.909> <0.312, -0.962, 1.845> <-0.088, -0.964, 1.775> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.640, 0.140, -0.085> <-0.722, 0.140, 0.430> <-0.817, 0.139, 1.118> <-0.914, 0.139, 1.630> 
		<-0.632, -0.546, -0.085> <-0.715, -0.546, 0.430> <-0.808, -0.613, 1.120> <-0.906, -0.613, 1.631> 
		<-0.396, -0.923, 0.209> <-0.411, -0.933, 0.680> <-0.452, -0.964, 1.408> <-0.498, -0.967, 1.703> 
		<-0.017, -0.920, 0.208> <-0.032, -0.931, 0.678> <-0.042, -0.961, 1.480> <-0.088, -0.964, 1.775> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.640, 0.140, -0.085> <-0.647, 0.824, -0.085> <-0.419, 1.208, 0.209> <-0.040, 1.211, 0.208> 
		<-0.722, 0.140, 0.430> <-0.730, 0.824, 0.430> <-0.440, 1.223, 0.678> <-0.061, 1.226, 0.676> 
		<-0.817, 0.139, 1.118> <-0.825, 0.889, 1.117> <-0.448, 1.248, 1.235> <-0.040, 1.251, 1.306> 
		<-0.914, 0.139, 1.630> <-0.922, 0.889, 1.628> <-0.520, 1.253, 1.699> <-0.112, 1.255, 1.770> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.112, 1.255, 1.770> <-0.244, 1.263, 2.620> <-0.653, 1.295, 3.715> <-0.719, 1.251, 4.571> 
		<-0.520, 1.253, 1.699> <-0.652, 1.261, 2.548> <-1.036, 1.292, 3.560> <-1.101, 1.249, 4.416> 
		<-0.922, 0.889, 1.628> <-1.074, 0.889, 2.422> <-1.455, 0.886, 3.455> <-1.479, 0.886, 4.263> 
		<-0.914, 0.139, 1.630> <-1.066, 0.139, 2.424> <-1.447, 0.139, 3.458> <-1.471, 0.139, 4.266> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.112, 1.255, 1.770> <0.290, 1.257, 1.841> <0.662, 0.887, 1.906> <0.670, 0.149, 1.907> 
		<-0.244, 1.263, 2.620> <0.158, 1.265, 2.690> <0.561, 0.887, 2.810> <0.569, 0.149, 2.811> 
		<-0.653, 1.295, 3.715> <-0.276, 1.297, 3.867> <0.123, 0.885, 3.962> <0.130, 0.149, 3.965> 
		<-0.719, 1.251, 4.571> <-0.341, 1.254, 4.723> <0.007, 0.885, 4.864> <0.015, 0.149, 4.867> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.670, 0.149, 1.907> <0.678, -0.585, 1.909> <0.312, -0.962, 1.845> <-0.088, -0.964, 1.775> 
		<0.569, 0.149, 2.811> <0.577, -0.585, 2.813> <0.228, -0.967, 2.384> <-0.172, -0.969, 2.313> 
		<0.130, 0.149, 3.965> <0.138, -0.583, 3.968> <-0.254, -1.002, 3.874> <-0.630, -1.004, 3.722> 
		<0.015, 0.149, 4.867> <0.022, -0.583, 4.870> <-0.321, -0.958, 4.731> <-0.696, -0.961, 4.580> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.088, -0.964, 1.775> <-0.498, -0.967, 1.703> <-0.906, -0.613, 1.631> <-0.914, 0.139, 1.630> 
		<-0.172, -0.969, 2.313> <-0.581, -0.972, 2.242> <-1.058, -0.613, 2.425> <-1.066, 0.139, 2.424> 
		<-0.630, -1.004, 3.722> <-1.014, -1.006, 3.567> <-1.439, -0.610, 3.461> <-1.447, 0.139, 3.458> 
		<-0.696, -0.961, 4.580> <-1.080, -0.963, 4.424> <-1.464, -0.610, 4.269> <-1.471, 0.139, 4.266> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.719, 1.251, 4.571> <-0.773, 1.215, 5.291> <-0.689, 1.106, 6.268> <-0.507, 0.993, 6.959> 
		<-1.101, 1.249, 4.416> <-1.156, 1.213, 5.136> <-0.981, 1.104, 6.390> <-0.799, 0.991, 7.081> 
		<-1.479, 0.886, 4.263> <-1.505, 0.887, 5.150> <-1.369, 0.714, 6.360> <-1.086, 0.713, 7.201> 
		<-1.471, 0.139, 4.266> <-1.498, 0.140, 5.154> <-1.363, 0.141, 6.358> <-1.081, 0.141, 7.199> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.719, 1.251, 4.571> <-0.341, 1.254, 4.723> <0.007, 0.885, 4.864> <0.015, 0.149, 4.867> 
		<-0.773, 1.215, 5.291> <-0.396, 1.217, 5.444> <-0.063, 0.885, 5.417> <-0.056, 0.148, 5.420> 
		<-0.689, 1.106, 6.268> <-0.401, 1.108, 6.147> <-0.047, 0.714, 6.178> <-0.042, 0.149, 6.175> 
		<-0.507, 0.993, 6.959> <-0.219, 0.995, 6.838> <0.047, 0.712, 6.727> <0.053, 0.148, 6.724> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.015, 0.149, 4.867> <0.022, -0.583, 4.870> <-0.321, -0.958, 4.731> <-0.696, -0.961, 4.580> 
		<-0.056, 0.148, 5.420> <-0.048, -0.583, 5.423> <-0.376, -0.922, 5.447> <-0.751, -0.924, 5.295> 
		<-0.042, 0.149, 6.175> <-0.036, -0.412, 6.173> <-0.383, -0.811, 6.145> <-0.669, -0.813, 6.265> 
		<0.053, 0.148, 6.724> <0.059, -0.413, 6.722> <-0.203, -0.701, 6.832> <-0.489, -0.703, 6.951> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.696, -0.961, 4.580> <-1.080, -0.963, 4.424> <-1.464, -0.610, 4.269> <-1.471, 0.139, 4.266> 
		<-0.751, -0.924, 5.295> <-1.136, -0.927, 5.140> <-1.490, -0.610, 5.157> <-1.498, 0.140, 5.154> 
		<-0.669, -0.813, 6.265> <-0.962, -0.815, 6.387> <-1.357, -0.433, 6.355> <-1.363, 0.141, 6.358> 
		<-0.489, -0.703, 6.951> <-0.782, -0.704, 7.074> <-1.075, -0.434, 7.197> <-1.081, 0.141, 7.199> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.040, 1.211, 0.208> <-0.038, 1.209, 0.145> <-0.034, 1.203, 0.042> <-0.034, 1.198, 0.000> 
		<0.189, 1.214, 0.208> <0.191, 1.212, 0.145> <0.188, 1.207, 0.043> <0.188, 1.202, 0.001> 
		<0.348, 0.840, 0.392> <0.384, 0.880, 0.291> <0.425, 0.950, 0.110> <0.435, 0.951, -0.004> 
		<0.459, 0.648, 0.335> <0.495, 0.688, 0.235> <0.568, 0.781, 0.113> <0.578, 0.781, 0.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.040, 1.211, 0.208> <-0.274, 1.207, 0.208> <-0.436, 0.830, 0.394> <-0.548, 0.633, 0.335> 
		<-0.038, 1.209, 0.145> <-0.272, 1.205, 0.145> <-0.458, 0.868, 0.292> <-0.570, 0.671, 0.233> 
		<-0.034, 1.203, 0.042> <-0.254, 1.199, 0.042> <-0.472, 0.924, 0.111> <-0.615, 0.757, 0.107> 
		<-0.034, 1.198, 0.000> <-0.253, 1.194, -0.001> <-0.478, 0.928, 0.000> <-0.620, 0.761, -0.004> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.548, 0.633, 0.335> <-0.642, 0.466, 0.285> <-0.644, 0.333, -0.027> <-0.640, 0.152, -0.107> 
		<-0.570, 0.671, 0.233> <-0.664, 0.504, 0.184> <-0.730, 0.334, -0.003> <-0.726, 0.153, -0.083> 
		<-0.615, 0.757, 0.107> <-0.748, 0.602, 0.103> <-0.879, 0.352, 0.047> <-0.926, 0.154, 0.064> 
		<-0.620, 0.761, -0.004> <-0.753, 0.606, -0.008> <-0.881, 0.352, -0.043> <-0.928, 0.155, -0.026> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.640, 0.152, -0.107> <-0.637, 0.007, -0.172> <-0.604, -0.231, -0.146> <-0.527, -0.364, -0.107> 
		<-0.726, 0.153, -0.083> <-0.723, 0.008, -0.147> <-0.722, -0.271, -0.083> <-0.645, -0.404, -0.044> 
		<-0.926, 0.154, 0.064> <-0.972, -0.039, 0.080> <-0.964, -0.349, 0.212> <-0.837, -0.502, 0.216> 
		<-0.928, 0.155, -0.026> <-0.974, -0.039, -0.009> <-1.048, -0.343, 0.101> <-0.921, -0.497, 0.104> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.527, -0.364, -0.107> <-0.407, -0.570, -0.047> <-0.262, -0.922, 0.208> <-0.017, -0.920, 0.208> 
		<-0.645, -0.404, -0.044> <-0.526, -0.609, 0.016> <-0.260, -0.920, 0.145> <-0.015, -0.919, 0.145> 
		<-0.837, -0.502, 0.216> <-0.646, -0.731, 0.221> <-0.328, -0.931, 0.060> <-0.030, -0.929, 0.062> 
		<-0.921, -0.497, 0.104> <-0.731, -0.726, 0.110> <-0.329, -0.925, -0.002> <-0.031, -0.924, 0.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.017, -0.920, 0.208> <0.222, -0.918, 0.208> <0.335, -0.558, -0.048> <0.449, -0.357, -0.107> 
		<-0.015, -0.919, 0.145> <0.224, -0.917, 0.145> <0.466, -0.598, 0.020> <0.579, -0.396, -0.040> 
		<-0.030, -0.929, 0.062> <0.276, -0.928, 0.064> <0.608, -0.727, 0.241> <0.805, -0.492, 0.246> 
		<-0.031, -0.924, 0.000> <0.275, -0.922, 0.002> <0.687, -0.723, 0.112> <0.884, -0.488, 0.116> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.449, -0.357, -0.107> <0.522, -0.227, -0.146> <0.579, -0.001, -0.170> <0.581, 0.140, -0.107> 
		<0.579, -0.396, -0.040> <0.653, -0.266, -0.079> <0.662, -0.001, -0.131> <0.664, 0.140, -0.069> 
		<0.805, -0.492, 0.246> <0.927, -0.346, 0.249> <0.876, -0.046, 0.127> <0.831, 0.139, 0.110> 
		<0.884, -0.488, 0.116> <1.006, -0.342, 0.119> <0.902, -0.045, 0.039> <0.858, 0.140, 0.022> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.581, 0.140, -0.107> <0.583, 0.328, -0.025> <0.559, 0.476, 0.284> <0.459, 0.648, 0.335> 
		<0.664, 0.140, -0.069> <0.666, 0.328, 0.014> <0.595, 0.516, 0.184> <0.495, 0.688, 0.235> 
		<0.831, 0.139, 0.110> <0.782, 0.342, 0.091> <0.704, 0.620, 0.117> <0.568, 0.781, 0.113> 
		<0.858, 0.140, 0.022> <0.809, 0.343, 0.004> <0.713, 0.620, 0.003> <0.578, 0.781, 0.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.445, 0.531, 8.982> <0.372, 0.531, 9.032> <0.172, 0.290, 9.167> <0.173, 0.136, 9.166> 
		<0.160, 0.670, 8.375> <0.087, 0.669, 8.425> <-0.205, 0.291, 8.577> <-0.203, 0.137, 8.576> 
		<-0.334, 0.886, 7.613> <-0.626, 0.885, 7.735> <-0.864, 0.713, 7.865> <-0.858, 0.140, 7.862> 
		<-0.507, 0.993, 6.959> <-0.799, 0.991, 7.081> <-1.086, 0.713, 7.201> <-1.081, 0.141, 7.199> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.445, 0.531, 8.982> <0.160, 0.670, 8.375> <-0.334, 0.886, 7.613> <-0.507, 0.993, 6.959> 
		<0.516, 0.532, 8.934> <0.230, 0.670, 8.327> <-0.046, 0.888, 7.492> <-0.219, 0.995, 6.838> 
		<0.694, 0.287, 8.814> <0.501, 0.290, 8.187> <0.159, 0.711, 7.373> <0.047, 0.712, 6.727> 
		<0.696, 0.139, 8.813> <0.503, 0.142, 8.186> <0.164, 0.146, 7.370> <0.053, 0.148, 6.724> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.455, -0.256, 8.976> <0.524, -0.255, 8.929> <0.697, -0.008, 8.811> <0.696, 0.139, 8.813> 
		<0.171, -0.390, 8.368> <0.241, -0.389, 8.321> <0.505, -0.006, 8.185> <0.503, 0.142, 8.186> 
		<-0.318, -0.598, 7.605> <-0.032, -0.596, 7.485> <0.170, -0.415, 7.368> <0.164, 0.146, 7.370> 
		<-0.489, -0.703, 6.951> <-0.203, -0.701, 6.832> <0.059, -0.413, 6.722> <0.053, 0.148, 6.724> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.455, -0.256, 8.976> <0.171, -0.390, 8.368> <-0.318, -0.598, 7.605> <-0.489, -0.703, 6.951> 
		<0.381, -0.256, 9.026> <0.098, -0.390, 8.418> <-0.611, -0.600, 7.727> <-0.782, -0.704, 7.074> 
		<0.175, -0.020, 9.165> <-0.201, -0.018, 8.575> <-0.852, -0.435, 7.860> <-1.075, -0.434, 7.197> 
		<0.173, 0.136, 9.166> <-0.203, 0.137, 8.576> <-0.858, 0.140, 7.862> <-1.081, 0.141, 7.199> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.424, 1.349, 10.436> <1.259, 1.232, 10.197> <1.087, 0.917, 9.944> <0.928, 0.784, 9.708> 
		<1.347, 1.334, 10.488> <1.181, 1.217, 10.249> <0.996, 0.902, 10.005> <0.837, 0.770, 9.769> 
		<1.168, 0.535, 10.236> <1.049, 0.535, 10.067> <0.906, 0.364, 9.818> <0.765, 0.359, 9.667> 
		<1.164, 0.167, 10.228> <1.046, 0.167, 10.059> <0.907, 0.172, 9.817> <0.767, 0.167, 9.666> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.424, 1.349, 10.436> <1.347, 1.334, 10.488> <1.168, 0.535, 10.236> <1.164, 0.167, 10.228> 
		<1.634, 1.497, 10.738> <1.557, 1.483, 10.790> <1.201, 0.535, 10.284> <1.198, 0.167, 10.276> 
		<2.123, 1.698, 11.437> <2.043, 1.678, 11.520> <1.263, 0.778, 10.393> <1.231, 0.165, 10.349> 
		<2.162, 1.658, 11.488> <2.082, 1.639, 11.571> <1.305, 0.781, 10.434> <1.273, 0.168, 10.390> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.424, 1.349, 10.436> <1.634, 1.497, 10.738> <2.123, 1.698, 11.437> <2.162, 1.658, 11.488> 
		<1.500, 1.363, 10.385> <1.709, 1.512, 10.687> <2.203, 1.717, 11.354> <2.242, 1.677, 11.405> 
		<1.322, 0.556, 10.131> <1.348, 0.556, 10.171> <1.418, 0.814, 10.254> <1.438, 0.814, 10.297> 
		<1.318, 0.196, 10.123> <1.344, 0.197, 10.162> <1.386, 0.200, 10.210> <1.406, 0.199, 10.253> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.424, 1.349, 10.436> <1.500, 1.363, 10.385> <1.322, 0.556, 10.131> <1.318, 0.196, 10.123> 
		<1.259, 1.232, 10.197> <1.334, 1.246, 10.146> <1.210, 0.555, 9.958> <1.206, 0.196, 9.950> 
		<1.087, 0.917, 9.944> <1.173, 0.931, 9.886> <1.033, 0.388, 9.732> <1.034, 0.205, 9.731> 
		<0.928, 0.784, 9.708> <1.014, 0.798, 9.650> <0.944, 0.380, 9.546> <0.946, 0.197, 9.545> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.318, 0.196, 10.123> <1.315, -0.148, 10.115> <1.474, -0.906, 10.335> <1.401, -0.920, 10.384> 
		<1.206, 0.196, 9.950> <1.202, -0.149, 9.942> <1.322, -0.817, 10.113> <1.250, -0.830, 10.161> 
		<1.034, 0.205, 9.731> <1.036, 0.003, 9.730> <1.181, -0.547, 9.856> <1.086, -0.563, 9.920> 
		<0.946, 0.197, 9.545> <0.948, -0.006, 9.544> <1.033, -0.444, 9.637> <0.938, -0.459, 9.701> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.318, 0.196, 10.123> <1.344, 0.197, 10.162> <1.386, 0.200, 10.210> <1.406, 0.199, 10.253> 
		<1.315, -0.148, 10.115> <1.340, -0.148, 10.155> <1.359, -0.329, 10.172> <1.378, -0.330, 10.215> 
		<1.474, -0.906, 10.335> <1.651, -1.011, 10.597> <2.101, -1.062, 11.252> <2.083, -1.082, 11.224> 
		<1.401, -0.920, 10.384> <1.579, -1.025, 10.645> <2.037, -1.078, 11.318> <2.018, -1.098, 11.290> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.401, -0.920, 10.384> <1.331, -0.933, 10.432> <1.161, -0.170, 10.220> <1.164, 0.167, 10.228> 
		<1.250, -0.830, 10.161> <1.179, -0.844, 10.209> <1.042, -0.170, 10.051> <1.046, 0.167, 10.059> 
		<1.086, -0.563, 9.920> <0.994, -0.577, 9.982> <0.909, -0.023, 9.816> <0.907, 0.172, 9.817> 
		<0.938, -0.459, 9.701> <0.847, -0.474, 9.763> <0.768, -0.028, 9.665> <0.767, 0.167, 9.666> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.401, -0.920, 10.384> <1.579, -1.025, 10.645> <2.037, -1.078, 11.318> <2.018, -1.098, 11.290> 
		<1.331, -0.933, 10.432> <1.508, -1.038, 10.693> <1.975, -1.093, 11.383> <1.956, -1.112, 11.355> 
		<1.161, -0.170, 10.220> <1.194, -0.170, 10.268> <1.205, -0.350, 10.312> <1.247, -0.347, 10.353> 
		<1.164, 0.167, 10.228> <1.198, 0.167, 10.276> <1.231, 0.165, 10.349> <1.273, 0.168, 10.390> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.162, 1.658, 11.488> <2.082, 1.639, 11.571> <1.305, 0.781, 10.434> <1.273, 0.168, 10.390> 
		<2.189, 1.630, 11.524> <2.109, 1.611, 11.607> <1.376, 0.786, 10.502> <1.344, 0.172, 10.458> 
		<2.052, 1.031, 11.279> <1.957, 0.809, 11.142> <1.509, 0.327, 10.630> <1.499, 0.184, 10.622> 
		<1.955, 0.804, 11.139> <1.860, 0.582, 11.002> <1.544, 0.336, 10.594> <1.533, 0.192, 10.586> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.162, 1.658, 11.488> <2.189, 1.630, 11.524> <2.052, 1.031, 11.279> <1.955, 0.804, 11.139> 
		<2.242, 1.677, 11.405> <2.269, 1.649, 11.442> <1.957, 0.809, 11.142> <1.860, 0.582, 11.002> 
		<1.438, 0.814, 10.297> <1.483, 0.813, 10.394> <1.583, 0.345, 10.554> <1.544, 0.336, 10.594> 
		<1.406, 0.199, 10.253> <1.451, 0.198, 10.350> <1.572, 0.201, 10.547> <1.533, 0.192, 10.586> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.162, 1.658, 11.488> <2.082, 1.639, 11.571> <1.305, 0.781, 10.434> <1.273, 0.168, 10.390> 
		<2.242, 1.677, 11.405> <2.162, 1.658, 11.488> <1.376, 0.786, 10.502> <1.344, 0.172, 10.458> 
		<1.438, 0.814, 10.297> <1.483, 0.813, 10.394> <1.537, 0.193, 10.583> <1.499, 0.184, 10.622> 
		<1.406, 0.199, 10.253> <1.451, 0.198, 10.350> <1.572, 0.201, 10.547> <1.533, 0.192, 10.586> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.533, 0.192, 10.586> <1.523, 0.059, 10.579> <1.779, -0.222, 10.955> <1.860, -0.437, 11.073> 
		<1.572, 0.201, 10.547> <1.561, 0.068, 10.540> <1.846, -0.401, 11.053> <1.927, -0.616, 11.170> 
		<1.451, 0.198, 10.350> <1.424, -0.331, 10.312> <2.071, -1.095, 11.205> <2.006, -1.110, 11.272> 
		<1.406, 0.199, 10.253> <1.378, -0.330, 10.215> <2.083, -1.082, 11.224> <2.018, -1.098, 11.290> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.533, 0.192, 10.586> <1.499, 0.184, 10.622> <1.344, 0.172, 10.458> <1.273, 0.168, 10.390> 
		<1.523, 0.059, 10.579> <1.488, 0.050, 10.615> <1.317, -0.342, 10.421> <1.247, -0.347, 10.353> 
		<1.779, -0.222, 10.955> <1.846, -0.401, 11.053> <1.944, -1.125, 11.337> <1.956, -1.112, 11.355> 
		<1.860, -0.437, 11.073> <1.927, -0.616, 11.170> <2.006, -1.110, 11.272> <2.018, -1.098, 11.290> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.533, 0.192, 10.586> <1.499, 0.184, 10.622> <1.344, 0.172, 10.458> <1.273, 0.168, 10.390> 
		<1.572, 0.201, 10.547> <1.537, 0.193, 10.583> <1.317, -0.342, 10.421> <1.247, -0.347, 10.353> 
		<1.451, 0.198, 10.350> <1.424, -0.331, 10.312> <2.020, -1.097, 11.288> <1.956, -1.112, 11.355> 
		<1.406, 0.199, 10.253> <1.378, -0.330, 10.215> <2.083, -1.082, 11.224> <2.018, -1.098, 11.290> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.928, 0.784, 9.708> <0.790, 0.669, 9.504> <0.590, 0.607, 9.200> <0.445, 0.531, 8.982> 
		<0.837, 0.770, 9.769> <0.700, 0.654, 9.565> <0.517, 0.607, 9.250> <0.372, 0.531, 9.032> 
		<0.765, 0.359, 9.667> <0.606, 0.354, 9.497> <0.350, 0.299, 9.317> <0.172, 0.290, 9.167> 
		<0.767, 0.167, 9.666> <0.608, 0.162, 9.496> <0.351, 0.145, 9.316> <0.173, 0.136, 9.166> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.928, 0.784, 9.708> <1.014, 0.798, 9.650> <0.944, 0.380, 9.546> <0.946, 0.197, 9.545> 
		<0.790, 0.669, 9.504> <0.876, 0.683, 9.445> <0.844, 0.370, 9.336> <0.846, 0.187, 9.335> 
		<0.590, 0.607, 9.200> <0.660, 0.608, 9.152> <0.769, 0.305, 9.034> <0.771, 0.156, 9.032> 
		<0.445, 0.531, 8.982> <0.516, 0.532, 8.934> <0.694, 0.287, 8.814> <0.696, 0.139, 8.813> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.455, -0.256, 8.976> <0.524, -0.255, 8.929> <0.697, -0.008, 8.811> <0.696, 0.139, 8.813> 
		<0.600, -0.317, 9.193> <0.670, -0.316, 9.146> <0.772, 0.009, 9.031> <0.771, 0.156, 9.032> 
		<0.799, -0.361, 9.494> <0.894, -0.346, 9.429> <0.848, -0.015, 9.334> <0.846, 0.187, 9.335> 
		<0.938, -0.459, 9.701> <1.033, -0.444, 9.637> <0.948, -0.006, 9.544> <0.946, 0.197, 9.545> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.455, -0.256, 8.976> <0.600, -0.317, 9.193> <0.799, -0.361, 9.494> <0.938, -0.459, 9.701> 
		<0.381, -0.256, 9.026> <0.526, -0.317, 9.243> <0.707, -0.376, 9.556> <0.847, -0.474, 9.763> 
		<0.175, -0.020, 9.165> <0.353, -0.010, 9.315> <0.609, -0.033, 9.495> <0.768, -0.028, 9.665> 
		<0.173, 0.136, 9.166> <0.351, 0.145, 9.316> <0.608, 0.162, 9.496> <0.767, 0.167, 9.666> 
	}
	#ifndef (IMPORT_SPATCH)
	pigment {
	   gradient y
	   pigment_map {
         [ 0.0
            bumps
            color_map {
               [ 0 color rgb <.1,.5,.1> ]
               [ 1 color rgb <.0,.4,.0> ]
            }
            scale 0.1
         ]   	   
         [ 0.0
            bumps
            color_map {
               [ 0 color rgb <.1,.5,.1> ]
               [ 1 color rgb <.0,.4,.0> ]
            }
            scale 0.1
         ]   	   
         [ 0.6 color rgb <.9,.9,.95> ]	   
         [ 1.0 color rgb <.9,.9,.95> ]
	   }
	   turbulence 0.2
	   omega .2
	   lambda 2
	   octaves 6
      scale 2
      translate <0,1,0>	   
	}
	finish { phong 0.9 reflection 0.1 }
	normal {
	   leopard
	   slope_map {
	      [ 0.0 <.0,0> ]
	      [ 0.1 <.03,.5> ]
	      [ 1.0 <.03,.5> ]
	   }
	   scale 0.02
	}
	#end
}
// Layer 2
union {
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.044, 1.168, 0.582> <-0.056, 1.168, 0.791> <-0.066, 1.168, 1.071> <-0.083, 1.168, 1.281> 
		<-0.030, 1.176, 0.555> <-0.042, 1.176, 0.765> <-0.045, 1.319, 0.958> <-0.062, 1.319, 1.168> 
		<-0.007, 1.196, 0.495> <-0.011, 1.339, 0.617> <-0.054, 1.550, 0.759> <-0.061, 1.675, 0.900> 
		<0.001, 1.196, 0.495> <-0.003, 1.339, 0.617> <-0.004, 1.548, 0.763> <-0.011, 1.673, 0.903> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.001, 1.196, 0.495> <-0.003, 1.339, 0.617> <-0.004, 1.548, 0.763> <-0.011, 1.673, 0.903> 
		<0.009, 1.195, 0.495> <0.005, 1.339, 0.617> <0.046, 1.546, 0.766> <0.040, 1.671, 0.907> 
		<0.034, 1.173, 0.555> <0.023, 1.173, 0.767> <0.020, 1.315, 0.961> <0.003, 1.317, 1.172> 
		<0.049, 1.164, 0.582> <0.037, 1.164, 0.793> <0.026, 1.162, 1.076> <0.009, 1.164, 1.288> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.083, 1.168, 1.281> <-0.094, 1.168, 1.417> <-0.116, 1.168, 1.598> <-0.136, 1.168, 1.732> 
		<-0.062, 1.319, 1.168> <-0.072, 1.319, 1.304> <-0.088, 1.429, 1.510> <-0.109, 1.429, 1.645> 
		<-0.061, 1.675, 0.900> <-0.068, 1.805, 1.045> <-0.066, 2.040, 1.412> <-0.069, 2.037, 1.443> 
		<-0.011, 1.673, 0.903> <-0.018, 1.803, 1.049> <-0.040, 2.041, 1.409> <-0.044, 2.038, 1.440> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.009, 1.164, 1.288> <0.003, 1.317, 1.172> <0.040, 1.671, 0.907> <-0.011, 1.673, 0.903> 
		<-0.001, 1.165, 1.418> <-0.007, 1.318, 1.303> <0.033, 1.801, 1.052> <-0.018, 1.803, 1.049> 
		<-0.021, 1.172, 1.592> <-0.022, 1.432, 1.508> <-0.015, 2.043, 1.406> <-0.040, 2.041, 1.409> 
		<-0.041, 1.172, 1.722> <-0.042, 1.432, 1.637> <-0.019, 2.039, 1.437> <-0.044, 2.038, 1.440> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.136, 1.168, 1.732> <-0.168, 1.168, 1.941> <-0.208, 1.168, 2.220> <-0.256, 1.168, 2.426> 
		<-0.109, 1.429, 1.645> <-0.140, 1.429, 1.853> <-0.185, 1.267, 2.203> <-0.232, 1.267, 2.408> 
		<-0.069, 2.037, 1.443> <-0.075, 2.031, 1.493> <-0.137, 1.624, 2.062> <-0.202, 1.501, 2.355> 
		<-0.044, 2.038, 1.440> <-0.050, 2.032, 1.490> <-0.113, 1.622, 2.074> <-0.178, 1.500, 2.367> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.041, 1.172, 1.722> <-0.042, 1.432, 1.637> <-0.019, 2.039, 1.437> <-0.044, 2.038, 1.440> 
		<-0.075, 1.172, 1.946> <-0.076, 1.432, 1.861> <-0.025, 2.033, 1.488> <-0.050, 2.032, 1.490> 
		<-0.121, 1.165, 2.246> <-0.123, 1.266, 2.216> <-0.088, 1.621, 2.087> <-0.113, 1.622, 2.074> 
		<-0.173, 1.164, 2.467> <-0.174, 1.264, 2.437> <-0.153, 1.498, 2.380> <-0.178, 1.500, 2.367> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.505, 1.168, 3.316> <-0.491, 1.192, 3.318> <-0.467, 1.248, 3.322> <-0.460, 1.248, 3.324> 
		<-0.430, 1.168, 3.049> <-0.417, 1.192, 3.051> <-0.382, 1.324, 3.034> <-0.375, 1.323, 3.037> 
		<-0.319, 1.168, 2.696> <-0.295, 1.267, 2.678> <-0.264, 1.384, 2.634> <-0.239, 1.383, 2.646> 
		<-0.256, 1.168, 2.426> <-0.232, 1.267, 2.408> <-0.202, 1.501, 2.355> <-0.178, 1.500, 2.367> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.460, 1.248, 3.324> <-0.453, 1.248, 3.327> <-0.431, 1.189, 3.343> <-0.419, 1.164, 3.350> 
		<-0.375, 1.323, 3.037> <-0.368, 1.323, 3.040> <-0.357, 1.189, 3.077> <-0.345, 1.164, 3.085> 
		<-0.239, 1.383, 2.646> <-0.215, 1.381, 2.659> <-0.236, 1.263, 2.705> <-0.235, 1.162, 2.735> 
		<-0.178, 1.500, 2.367> <-0.153, 1.498, 2.380> <-0.174, 1.264, 2.437> <-0.173, 1.164, 2.467> 
	}
	#ifndef (IMPORT_SPATCH)
	pigment {
      bumps
      color_map {
         [ 0 color rgb <.1,.5,.1> ]
         [ 1 color rgb <.0,.4,.0> ]
      }
      scale 0.1
	   turbulence 0.2
	   omega .2
	   lambda 2
	   octaves 6
      scale 2
	}
	finish { phong 0.9 reflection 0.1 }
	normal {
	   leopard
	   slope_map {
	      [ 0.0 <.0,0> ]
	      [ 0.1 <.03,.5> ]
	      [ 1.0 <.03,.5> ]
	   }
	   scale 0.02
	}
	#end
} 
/*
// Layer 3
union {
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.336, 0.806, -1.419> <0.336, 0.806, -1.261> <0.340, 0.671, -1.126> <0.346, 0.513, -1.126> 
		<0.336, 0.806, -1.578> <0.336, 0.806, -1.419> <0.182, 0.666, -1.126> <0.187, 0.507, -1.126> 
		<0.340, 0.671, -1.713> <0.182, 0.666, -1.713> <0.052, 0.503, -1.419> <0.052, 0.503, -1.261> 
		<0.346, 0.513, -1.713> <0.187, 0.507, -1.713> <0.052, 0.503, -1.578> <0.052, 0.503, -1.419> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.336, 0.806, -1.419> <0.336, 0.806, -1.419> <0.336, 0.806, -1.419> <0.336, 0.806, -1.419> 
		<0.177, 0.801, -1.419> <0.177, 0.801, -1.578> <0.177, 0.801, -1.578> <0.336, 0.806, -1.578> 
		<0.047, 0.661, -1.419> <0.047, 0.661, -1.578> <0.182, 0.666, -1.713> <0.340, 0.671, -1.713> 
		<0.052, 0.503, -1.419> <0.052, 0.503, -1.578> <0.187, 0.507, -1.713> <0.346, 0.513, -1.713> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.336, 0.806, -1.419> <0.336, 0.806, -1.578> <0.340, 0.671, -1.713> <0.346, 0.513, -1.713> 
		<0.336, 0.806, -1.261> <0.336, 0.806, -1.419> <0.499, 0.677, -1.713> <0.504, 0.518, -1.713> 
		<0.340, 0.671, -1.126> <0.499, 0.677, -1.126> <0.639, 0.523, -1.419> <0.639, 0.523, -1.578> 
		<0.346, 0.513, -1.126> <0.504, 0.518, -1.126> <0.639, 0.523, -1.261> <0.639, 0.523, -1.419> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.336, 0.806, -1.419> <0.336, 0.806, -1.419> <0.336, 0.806, -1.419> <0.336, 0.806, -1.419> 
		<0.494, 0.812, -1.419> <0.494, 0.812, -1.578> <0.494, 0.812, -1.578> <0.336, 0.806, -1.578> 
		<0.634, 0.681, -1.419> <0.634, 0.681, -1.578> <0.499, 0.677, -1.713> <0.340, 0.671, -1.713> 
		<0.639, 0.523, -1.419> <0.639, 0.523, -1.578> <0.504, 0.518, -1.713> <0.346, 0.513, -1.713> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.336, 0.806, -1.419> <0.336, 0.806, -1.578> <0.340, 0.671, -1.713> <0.346, 0.513, -1.713> 
		<0.494, 0.812, -1.419> <0.494, 0.812, -1.578> <0.346, 0.513, -1.713> <0.351, 0.354, -1.713> 
		<0.634, 0.681, -1.419> <0.639, 0.523, -1.419> <0.514, 0.224, -1.578> <0.356, 0.219, -1.578> 
		<0.639, 0.523, -1.419> <0.645, 0.364, -1.419> <0.514, 0.224, -1.419> <0.356, 0.219, -1.419> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.336, 0.806, -1.419> <0.336, 0.806, -1.578> <0.340, 0.671, -1.713> <0.346, 0.513, -1.713> 
		<0.177, 0.801, -1.419> <0.177, 0.801, -1.578> <0.346, 0.513, -1.713> <0.351, 0.354, -1.713> 
		<0.047, 0.661, -1.419> <0.052, 0.503, -1.419> <0.197, 0.213, -1.578> <0.356, 0.219, -1.578> 
		<0.052, 0.503, -1.419> <0.057, 0.344, -1.419> <0.197, 0.213, -1.419> <0.356, 0.219, -1.419> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.336, 0.806, -1.419> <0.336, 0.806, -1.419> <0.336, 0.806, -1.419> <0.336, 0.806, -1.419> 
		<0.494, 0.812, -1.419> <0.494, 0.812, -1.261> <0.494, 0.812, -1.261> <0.336, 0.806, -1.261> 
		<0.634, 0.681, -1.419> <0.634, 0.681, -1.261> <0.499, 0.677, -1.126> <0.340, 0.671, -1.126> 
		<0.639, 0.523, -1.419> <0.639, 0.523, -1.261> <0.504, 0.518, -1.126> <0.346, 0.513, -1.126> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.336, 0.806, -1.419> <0.336, 0.806, -1.419> <0.336, 0.806, -1.419> <0.336, 0.806, -1.419> 
		<0.336, 0.806, -1.261> <0.177, 0.801, -1.261> <0.177, 0.801, -1.261> <0.177, 0.801, -1.419> 
		<0.340, 0.671, -1.126> <0.182, 0.666, -1.126> <0.047, 0.661, -1.261> <0.047, 0.661, -1.419> 
		<0.346, 0.513, -1.126> <0.187, 0.507, -1.126> <0.052, 0.503, -1.261> <0.052, 0.503, -1.419> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.336, 0.806, -1.419> <0.494, 0.812, -1.419> <0.634, 0.681, -1.419> <0.639, 0.523, -1.419> 
		<0.336, 0.806, -1.261> <0.494, 0.812, -1.261> <0.639, 0.523, -1.419> <0.645, 0.364, -1.419> 
		<0.340, 0.671, -1.126> <0.346, 0.513, -1.126> <0.514, 0.224, -1.261> <0.514, 0.224, -1.419> 
		<0.346, 0.513, -1.126> <0.351, 0.354, -1.126> <0.356, 0.219, -1.261> <0.356, 0.219, -1.419> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.336, 0.806, -1.419> <0.336, 0.806, -1.261> <0.340, 0.671, -1.126> <0.346, 0.513, -1.126> 
		<0.177, 0.801, -1.419> <0.177, 0.801, -1.261> <0.346, 0.513, -1.126> <0.351, 0.354, -1.126> 
		<0.047, 0.661, -1.419> <0.052, 0.503, -1.419> <0.197, 0.213, -1.261> <0.356, 0.219, -1.261> 
		<0.052, 0.503, -1.419> <0.057, 0.344, -1.419> <0.197, 0.213, -1.419> <0.356, 0.219, -1.419> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.336, 0.806, -1.419> <0.177, 0.801, -1.419> <0.047, 0.661, -1.419> <0.052, 0.503, -1.419> 
		<0.494, 0.812, -1.419> <0.336, 0.806, -1.419> <0.047, 0.661, -1.261> <0.052, 0.503, -1.261> 
		<0.634, 0.681, -1.419> <0.634, 0.681, -1.261> <0.346, 0.513, -1.126> <0.187, 0.507, -1.126> 
		<0.639, 0.523, -1.419> <0.639, 0.523, -1.261> <0.504, 0.518, -1.126> <0.346, 0.513, -1.126> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.336, 0.806, -1.419> <0.177, 0.801, -1.419> <0.047, 0.661, -1.419> <0.052, 0.503, -1.419> 
		<0.494, 0.812, -1.419> <0.336, 0.806, -1.419> <0.047, 0.661, -1.578> <0.052, 0.503, -1.578> 
		<0.634, 0.681, -1.419> <0.634, 0.681, -1.578> <0.346, 0.513, -1.713> <0.187, 0.507, -1.713> 
		<0.639, 0.523, -1.419> <0.639, 0.523, -1.578> <0.504, 0.518, -1.713> <0.346, 0.513, -1.713> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.356, 0.219, -1.419> <0.356, 0.219, -1.261> <0.351, 0.354, -1.126> <0.346, 0.513, -1.126> 
		<0.356, 0.219, -1.578> <0.356, 0.219, -1.419> <0.510, 0.359, -1.126> <0.504, 0.518, -1.126> 
		<0.351, 0.354, -1.713> <0.510, 0.359, -1.713> <0.639, 0.523, -1.419> <0.639, 0.523, -1.261> 
		<0.346, 0.513, -1.713> <0.504, 0.518, -1.713> <0.639, 0.523, -1.578> <0.639, 0.523, -1.419> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.356, 0.219, -1.419> <0.356, 0.219, -1.419> <0.356, 0.219, -1.419> <0.356, 0.219, -1.419> 
		<0.514, 0.224, -1.419> <0.514, 0.224, -1.261> <0.514, 0.224, -1.261> <0.356, 0.219, -1.261> 
		<0.645, 0.364, -1.419> <0.645, 0.364, -1.261> <0.510, 0.359, -1.126> <0.351, 0.354, -1.126> 
		<0.639, 0.523, -1.419> <0.639, 0.523, -1.261> <0.504, 0.518, -1.126> <0.346, 0.513, -1.126> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.356, 0.219, -1.419> <0.356, 0.219, -1.578> <0.351, 0.354, -1.713> <0.346, 0.513, -1.713> 
		<0.356, 0.219, -1.261> <0.356, 0.219, -1.419> <0.192, 0.348, -1.713> <0.187, 0.507, -1.713> 
		<0.351, 0.354, -1.126> <0.192, 0.348, -1.126> <0.052, 0.503, -1.419> <0.052, 0.503, -1.578> 
		<0.346, 0.513, -1.126> <0.187, 0.507, -1.126> <0.052, 0.503, -1.261> <0.052, 0.503, -1.419> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.356, 0.219, -1.419> <0.356, 0.219, -1.419> <0.356, 0.219, -1.419> <0.356, 0.219, -1.419> 
		<0.197, 0.213, -1.419> <0.197, 0.213, -1.261> <0.197, 0.213, -1.261> <0.356, 0.219, -1.261> 
		<0.057, 0.344, -1.419> <0.057, 0.344, -1.261> <0.192, 0.348, -1.126> <0.351, 0.354, -1.126> 
		<0.052, 0.503, -1.419> <0.052, 0.503, -1.261> <0.187, 0.507, -1.126> <0.346, 0.513, -1.126> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.356, 0.219, -1.419> <0.356, 0.219, -1.419> <0.356, 0.219, -1.419> <0.356, 0.219, -1.419> 
		<0.197, 0.213, -1.419> <0.197, 0.213, -1.578> <0.197, 0.213, -1.578> <0.356, 0.219, -1.578> 
		<0.057, 0.344, -1.419> <0.057, 0.344, -1.578> <0.192, 0.348, -1.713> <0.351, 0.354, -1.713> 
		<0.052, 0.503, -1.419> <0.052, 0.503, -1.578> <0.187, 0.507, -1.713> <0.346, 0.513, -1.713> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.356, 0.219, -1.419> <0.356, 0.219, -1.419> <0.356, 0.219, -1.419> <0.356, 0.219, -1.419> 
		<0.514, 0.224, -1.419> <0.514, 0.224, -1.578> <0.514, 0.224, -1.578> <0.356, 0.219, -1.578> 
		<0.645, 0.364, -1.419> <0.645, 0.364, -1.578> <0.510, 0.359, -1.713> <0.351, 0.354, -1.713> 
		<0.639, 0.523, -1.419> <0.639, 0.523, -1.578> <0.504, 0.518, -1.713> <0.346, 0.513, -1.713> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.356, 0.219, -1.419> <0.514, 0.224, -1.419> <0.645, 0.364, -1.419> <0.639, 0.523, -1.419> 
		<0.197, 0.213, -1.419> <0.356, 0.219, -1.419> <0.645, 0.364, -1.578> <0.639, 0.523, -1.578> 
		<0.057, 0.344, -1.419> <0.057, 0.344, -1.578> <0.346, 0.513, -1.713> <0.504, 0.518, -1.713> 
		<0.052, 0.503, -1.419> <0.052, 0.503, -1.578> <0.187, 0.507, -1.713> <0.346, 0.513, -1.713> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.356, 0.219, -1.419> <0.514, 0.224, -1.419> <0.645, 0.364, -1.419> <0.639, 0.523, -1.419> 
		<0.197, 0.213, -1.419> <0.356, 0.219, -1.419> <0.645, 0.364, -1.261> <0.639, 0.523, -1.261> 
		<0.057, 0.344, -1.419> <0.057, 0.344, -1.261> <0.346, 0.513, -1.126> <0.504, 0.518, -1.126> 
		<0.052, 0.503, -1.419> <0.052, 0.503, -1.261> <0.187, 0.507, -1.126> <0.346, 0.513, -1.126> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.356, 0.855, -1.419> <-0.356, 0.855, -1.261> <-0.365, 0.720, -1.126> <-0.376, 0.561, -1.126> 
		<-0.356, 0.855, -1.578> <-0.356, 0.855, -1.419> <-0.524, 0.730, -1.126> <-0.534, 0.572, -1.126> 
		<-0.365, 0.720, -1.713> <-0.524, 0.730, -1.713> <-0.669, 0.581, -1.419> <-0.669, 0.581, -1.261> 
		<-0.376, 0.561, -1.713> <-0.534, 0.572, -1.713> <-0.669, 0.581, -1.578> <-0.669, 0.581, -1.419> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.356, 0.855, -1.419> <-0.356, 0.855, -1.419> <-0.356, 0.855, -1.419> <-0.356, 0.855, -1.419> 
		<-0.515, 0.865, -1.419> <-0.515, 0.865, -1.578> <-0.515, 0.865, -1.578> <-0.356, 0.855, -1.578> 
		<-0.658, 0.739, -1.419> <-0.658, 0.739, -1.578> <-0.524, 0.730, -1.713> <-0.365, 0.720, -1.713> 
		<-0.669, 0.581, -1.419> <-0.669, 0.581, -1.578> <-0.534, 0.572, -1.713> <-0.376, 0.561, -1.713> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.356, 0.855, -1.419> <-0.356, 0.855, -1.578> <-0.365, 0.720, -1.713> <-0.376, 0.561, -1.713> 
		<-0.356, 0.855, -1.261> <-0.356, 0.855, -1.419> <-0.207, 0.709, -1.713> <-0.217, 0.551, -1.713> 
		<-0.365, 0.720, -1.126> <-0.207, 0.709, -1.126> <-0.082, 0.542, -1.419> <-0.082, 0.542, -1.578> 
		<-0.376, 0.561, -1.126> <-0.217, 0.551, -1.126> <-0.082, 0.542, -1.261> <-0.082, 0.542, -1.419> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.356, 0.855, -1.419> <-0.356, 0.855, -1.419> <-0.356, 0.855, -1.419> <-0.356, 0.855, -1.419> 
		<-0.198, 0.844, -1.419> <-0.198, 0.844, -1.578> <-0.198, 0.844, -1.578> <-0.356, 0.855, -1.578> 
		<-0.072, 0.701, -1.419> <-0.072, 0.701, -1.578> <-0.207, 0.709, -1.713> <-0.365, 0.720, -1.713> 
		<-0.082, 0.542, -1.419> <-0.082, 0.542, -1.578> <-0.217, 0.551, -1.713> <-0.376, 0.561, -1.713> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.356, 0.855, -1.419> <-0.356, 0.855, -1.578> <-0.365, 0.720, -1.713> <-0.376, 0.561, -1.713> 
		<-0.198, 0.844, -1.419> <-0.198, 0.844, -1.578> <-0.376, 0.561, -1.713> <-0.386, 0.403, -1.713> 
		<-0.072, 0.701, -1.419> <-0.082, 0.542, -1.419> <-0.236, 0.258, -1.578> <-0.395, 0.268, -1.578> 
		<-0.082, 0.542, -1.419> <-0.093, 0.384, -1.419> <-0.236, 0.258, -1.419> <-0.395, 0.268, -1.419> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.356, 0.855, -1.419> <-0.356, 0.855, -1.578> <-0.365, 0.720, -1.713> <-0.376, 0.561, -1.713> 
		<-0.515, 0.865, -1.419> <-0.515, 0.865, -1.578> <-0.376, 0.561, -1.713> <-0.386, 0.403, -1.713> 
		<-0.658, 0.739, -1.419> <-0.669, 0.581, -1.419> <-0.553, 0.279, -1.578> <-0.395, 0.268, -1.578> 
		<-0.669, 0.581, -1.419> <-0.679, 0.422, -1.419> <-0.553, 0.279, -1.419> <-0.395, 0.268, -1.419> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.356, 0.855, -1.419> <-0.356, 0.855, -1.419> <-0.356, 0.855, -1.419> <-0.356, 0.855, -1.419> 
		<-0.198, 0.844, -1.419> <-0.198, 0.844, -1.261> <-0.198, 0.844, -1.261> <-0.356, 0.855, -1.261> 
		<-0.072, 0.701, -1.419> <-0.072, 0.701, -1.261> <-0.207, 0.709, -1.126> <-0.365, 0.720, -1.126> 
		<-0.082, 0.542, -1.419> <-0.082, 0.542, -1.261> <-0.217, 0.551, -1.126> <-0.376, 0.561, -1.126> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.356, 0.855, -1.419> <-0.356, 0.855, -1.419> <-0.356, 0.855, -1.419> <-0.356, 0.855, -1.419> 
		<-0.356, 0.855, -1.261> <-0.515, 0.865, -1.261> <-0.515, 0.865, -1.261> <-0.515, 0.865, -1.419> 
		<-0.365, 0.720, -1.126> <-0.524, 0.730, -1.126> <-0.658, 0.739, -1.261> <-0.658, 0.739, -1.419> 
		<-0.376, 0.561, -1.126> <-0.534, 0.572, -1.126> <-0.669, 0.581, -1.261> <-0.669, 0.581, -1.419> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.356, 0.855, -1.419> <-0.198, 0.844, -1.419> <-0.072, 0.701, -1.419> <-0.082, 0.542, -1.419> 
		<-0.356, 0.855, -1.261> <-0.198, 0.844, -1.261> <-0.082, 0.542, -1.419> <-0.093, 0.384, -1.419> 
		<-0.365, 0.720, -1.126> <-0.376, 0.561, -1.126> <-0.236, 0.258, -1.261> <-0.236, 0.258, -1.419> 
		<-0.376, 0.561, -1.126> <-0.386, 0.403, -1.126> <-0.395, 0.268, -1.261> <-0.395, 0.268, -1.419> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.356, 0.855, -1.419> <-0.356, 0.855, -1.261> <-0.365, 0.720, -1.126> <-0.376, 0.561, -1.126> 
		<-0.515, 0.865, -1.419> <-0.515, 0.865, -1.261> <-0.376, 0.561, -1.126> <-0.386, 0.403, -1.126> 
		<-0.658, 0.739, -1.419> <-0.669, 0.581, -1.419> <-0.553, 0.279, -1.261> <-0.395, 0.268, -1.261> 
		<-0.669, 0.581, -1.419> <-0.679, 0.422, -1.419> <-0.553, 0.279, -1.419> <-0.395, 0.268, -1.419> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.356, 0.855, -1.419> <-0.515, 0.865, -1.419> <-0.658, 0.739, -1.419> <-0.669, 0.581, -1.419> 
		<-0.198, 0.844, -1.419> <-0.356, 0.855, -1.419> <-0.658, 0.739, -1.261> <-0.669, 0.581, -1.261> 
		<-0.072, 0.701, -1.419> <-0.072, 0.701, -1.261> <-0.376, 0.561, -1.126> <-0.534, 0.572, -1.126> 
		<-0.082, 0.542, -1.419> <-0.082, 0.542, -1.261> <-0.217, 0.551, -1.126> <-0.376, 0.561, -1.126> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.356, 0.855, -1.419> <-0.515, 0.865, -1.419> <-0.658, 0.739, -1.419> <-0.669, 0.581, -1.419> 
		<-0.198, 0.844, -1.419> <-0.356, 0.855, -1.419> <-0.658, 0.739, -1.578> <-0.669, 0.581, -1.578> 
		<-0.072, 0.701, -1.419> <-0.072, 0.701, -1.578> <-0.376, 0.561, -1.713> <-0.534, 0.572, -1.713> 
		<-0.082, 0.542, -1.419> <-0.082, 0.542, -1.578> <-0.217, 0.551, -1.713> <-0.376, 0.561, -1.713> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.395, 0.268, -1.419> <-0.395, 0.268, -1.261> <-0.386, 0.403, -1.126> <-0.376, 0.561, -1.126> 
		<-0.395, 0.268, -1.578> <-0.395, 0.268, -1.419> <-0.227, 0.393, -1.126> <-0.217, 0.551, -1.126> 
		<-0.386, 0.403, -1.713> <-0.227, 0.393, -1.713> <-0.082, 0.542, -1.419> <-0.082, 0.542, -1.261> 
		<-0.376, 0.561, -1.713> <-0.217, 0.551, -1.713> <-0.082, 0.542, -1.578> <-0.082, 0.542, -1.419> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.395, 0.268, -1.419> <-0.395, 0.268, -1.419> <-0.395, 0.268, -1.419> <-0.395, 0.268, -1.419> 
		<-0.236, 0.258, -1.419> <-0.236, 0.258, -1.261> <-0.236, 0.258, -1.261> <-0.395, 0.268, -1.261> 
		<-0.093, 0.384, -1.419> <-0.093, 0.384, -1.261> <-0.227, 0.393, -1.126> <-0.386, 0.403, -1.126> 
		<-0.082, 0.542, -1.419> <-0.082, 0.542, -1.261> <-0.217, 0.551, -1.126> <-0.376, 0.561, -1.126> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.395, 0.268, -1.419> <-0.395, 0.268, -1.578> <-0.386, 0.403, -1.713> <-0.376, 0.561, -1.713> 
		<-0.395, 0.268, -1.261> <-0.395, 0.268, -1.419> <-0.544, 0.413, -1.713> <-0.534, 0.572, -1.713> 
		<-0.386, 0.403, -1.126> <-0.544, 0.413, -1.126> <-0.669, 0.581, -1.419> <-0.669, 0.581, -1.578> 
		<-0.376, 0.561, -1.126> <-0.534, 0.572, -1.126> <-0.669, 0.581, -1.261> <-0.669, 0.581, -1.419> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.395, 0.268, -1.419> <-0.395, 0.268, -1.419> <-0.395, 0.268, -1.419> <-0.395, 0.268, -1.419> 
		<-0.553, 0.279, -1.419> <-0.553, 0.279, -1.261> <-0.553, 0.279, -1.261> <-0.395, 0.268, -1.261> 
		<-0.679, 0.422, -1.419> <-0.679, 0.422, -1.261> <-0.544, 0.413, -1.126> <-0.386, 0.403, -1.126> 
		<-0.669, 0.581, -1.419> <-0.669, 0.581, -1.261> <-0.534, 0.572, -1.126> <-0.376, 0.561, -1.126> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.395, 0.268, -1.419> <-0.395, 0.268, -1.419> <-0.395, 0.268, -1.419> <-0.395, 0.268, -1.419> 
		<-0.553, 0.279, -1.419> <-0.553, 0.279, -1.578> <-0.553, 0.279, -1.578> <-0.395, 0.268, -1.578> 
		<-0.679, 0.422, -1.419> <-0.679, 0.422, -1.578> <-0.544, 0.413, -1.713> <-0.386, 0.403, -1.713> 
		<-0.669, 0.581, -1.419> <-0.669, 0.581, -1.578> <-0.534, 0.572, -1.713> <-0.376, 0.561, -1.713> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.395, 0.268, -1.419> <-0.395, 0.268, -1.419> <-0.395, 0.268, -1.419> <-0.395, 0.268, -1.419> 
		<-0.236, 0.258, -1.419> <-0.236, 0.258, -1.578> <-0.236, 0.258, -1.578> <-0.395, 0.268, -1.578> 
		<-0.093, 0.384, -1.419> <-0.093, 0.384, -1.578> <-0.227, 0.393, -1.713> <-0.386, 0.403, -1.713> 
		<-0.082, 0.542, -1.419> <-0.082, 0.542, -1.578> <-0.217, 0.551, -1.713> <-0.376, 0.561, -1.713> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.395, 0.268, -1.419> <-0.236, 0.258, -1.419> <-0.093, 0.384, -1.419> <-0.082, 0.542, -1.419> 
		<-0.553, 0.279, -1.419> <-0.395, 0.268, -1.419> <-0.093, 0.384, -1.578> <-0.082, 0.542, -1.578> 
		<-0.679, 0.422, -1.419> <-0.679, 0.422, -1.578> <-0.376, 0.561, -1.713> <-0.217, 0.551, -1.713> 
		<-0.669, 0.581, -1.419> <-0.669, 0.581, -1.578> <-0.534, 0.572, -1.713> <-0.376, 0.561, -1.713> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.395, 0.268, -1.419> <-0.236, 0.258, -1.419> <-0.093, 0.384, -1.419> <-0.082, 0.542, -1.419> 
		<-0.553, 0.279, -1.419> <-0.395, 0.268, -1.419> <-0.093, 0.384, -1.261> <-0.082, 0.542, -1.261> 
		<-0.679, 0.422, -1.419> <-0.679, 0.422, -1.261> <-0.376, 0.561, -1.126> <-0.217, 0.551, -1.126> 
		<-0.669, 0.581, -1.419> <-0.669, 0.581, -1.261> <-0.534, 0.572, -1.126> <-0.376, 0.561, -1.126> 
	}
	#ifndef (IMPORT_SPATCH)
	pigment {
      bumps
      color_map {
         [ 0 color rgb <.9,.9,.95> ]
         [ 1 color rgb <.9,.9,.95>/0.96 ]
      }
      scale 0.1
	   turbulence 0.2
	   omega .2
	   lambda 2
	   octaves 6
      scale 2
	}
	finish { phong 0.9 }
	normal {
	   leopard
	   slope_map {
	      [ 0.0 <.0,0> ]
	      [ 0.1 <.05,.5> ]
	      [ 1.0 <.05,.5> ]
	   }
	   scale 0.02
	   scale <1,1,3>
	}
	#end
}*/
// Layer 4
union {
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.390, -1.211, 1.107> <1.268, -1.081, 0.990> <1.068, -0.893, 0.896> <0.915, -0.756, 0.838> 
		<1.397, -1.185, 1.108> <1.275, -1.055, 0.990> <1.076, -0.840, 0.896> <0.923, -0.703, 0.837> 
		<1.287, -1.122, 1.313> <1.168, -1.025, 1.241> <0.986, -0.879, 1.135> <0.889, -0.766, 1.055> 
		<1.242, -1.093, 1.405> <1.123, -0.997, 1.333> <0.959, -0.880, 1.225> <0.861, -0.767, 1.144> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.390, -1.211, 1.107> <1.397, -1.185, 1.108> <1.287, -1.122, 1.313> <1.242, -1.093, 1.405> 
		<1.501, -1.329, 1.214> <1.508, -1.303, 1.215> <1.401, -1.215, 1.382> <1.356, -1.186, 1.474> 
		<1.659, -1.547, 1.541> <1.667, -1.543, 1.540> <1.553, -1.334, 1.526> <1.528, -1.295, 1.552> 
		<1.674, -1.563, 1.570> <1.683, -1.558, 1.569> <1.662, -1.436, 1.589> <1.637, -1.398, 1.614> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.390, -1.211, 1.107> <1.501, -1.329, 1.214> <1.659, -1.547, 1.541> <1.674, -1.563, 1.570> 
		<1.384, -1.237, 1.107> <1.495, -1.355, 1.214> <1.650, -1.552, 1.541> <1.665, -1.568, 1.571> 
		<1.273, -1.177, 1.315> <1.378, -1.263, 1.381> <1.513, -1.370, 1.531> <1.622, -1.456, 1.592> 
		<1.229, -1.149, 1.404> <1.334, -1.235, 1.470> <1.488, -1.333, 1.556> <1.597, -1.419, 1.617> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.390, -1.211, 1.107> <1.384, -1.237, 1.107> <1.273, -1.177, 1.315> <1.229, -1.149, 1.404> 
		<1.268, -1.081, 0.990> <1.262, -1.107, 0.989> <1.155, -1.079, 1.240> <1.111, -1.051, 1.328> 
		<1.068, -0.893, 0.896> <1.059, -0.946, 0.897> <1.001, -0.895, 1.141> <0.973, -0.896, 1.232> 
		<0.915, -0.756, 0.838> <0.906, -0.810, 0.838> <0.883, -0.808, 1.054> <0.855, -0.809, 1.145> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.229, -1.149, 1.404> <1.181, -1.118, 1.501> <1.079, -1.043, 1.725> <1.085, -1.016, 1.726> 
		<1.111, -1.051, 1.328> <1.063, -1.021, 1.426> <1.048, -1.023, 1.706> <1.055, -0.996, 1.707> 
		<0.973, -0.896, 1.232> <0.950, -0.896, 1.303> <0.806, -0.846, 1.452> <0.810, -0.824, 1.452> 
		<0.855, -0.809, 1.145> <0.832, -0.809, 1.217> <0.746, -0.783, 1.368> <0.750, -0.761, 1.368> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.229, -1.149, 1.404> <1.334, -1.235, 1.470> <1.488, -1.333, 1.556> <1.597, -1.419, 1.617> 
		<1.181, -1.118, 1.501> <1.286, -1.204, 1.568> <1.445, -1.267, 1.600> <1.554, -1.353, 1.661> 
		<1.079, -1.043, 1.725> <1.103, -1.059, 1.740> <1.408, -1.216, 1.798> <1.433, -1.236, 1.796> 
		<1.085, -1.016, 1.726> <1.109, -1.032, 1.740> <1.428, -1.206, 1.797> <1.452, -1.226, 1.794> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.085, -1.016, 1.726> <1.091, -0.989, 1.726> <1.195, -1.064, 1.499> <1.242, -1.093, 1.405> 
		<1.055, -0.996, 1.707> <1.061, -0.969, 1.708> <1.076, -0.967, 1.427> <1.123, -0.997, 1.333> 
		<0.810, -0.824, 1.452> <0.813, -0.802, 1.452> <0.936, -0.881, 1.296> <0.959, -0.880, 1.225> 
		<0.750, -0.761, 1.368> <0.754, -0.738, 1.368> <0.839, -0.767, 1.216> <0.861, -0.767, 1.144> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.085, -1.016, 1.726> <1.109, -1.032, 1.740> <1.428, -1.206, 1.797> <1.452, -1.226, 1.794> 
		<1.091, -0.989, 1.726> <1.115, -1.005, 1.741> <1.448, -1.195, 1.795> <1.473, -1.215, 1.793> 
		<1.195, -1.064, 1.499> <1.309, -1.156, 1.568> <1.483, -1.227, 1.597> <1.592, -1.330, 1.659> 
		<1.242, -1.093, 1.405> <1.356, -1.186, 1.474> <1.528, -1.295, 1.552> <1.637, -1.398, 1.614> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.674, -1.563, 1.570> <1.677, -1.566, 1.575> <1.694, -1.525, 1.640> <1.679, -1.503, 1.655> 
		<1.665, -1.568, 1.571> <1.668, -1.570, 1.576> <1.639, -1.441, 1.696> <1.624, -1.419, 1.711> 
		<1.622, -1.456, 1.592> <1.578, -1.390, 1.636> <1.455, -1.254, 1.793> <1.475, -1.244, 1.791> 
		<1.597, -1.419, 1.617> <1.554, -1.353, 1.661> <1.433, -1.236, 1.796> <1.452, -1.226, 1.794> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.674, -1.563, 1.570> <1.683, -1.558, 1.569> <1.662, -1.436, 1.589> <1.637, -1.398, 1.614> 
		<1.677, -1.566, 1.575> <1.685, -1.561, 1.574> <1.618, -1.368, 1.634> <1.592, -1.330, 1.659> 
		<1.694, -1.525, 1.640> <1.639, -1.441, 1.696> <1.495, -1.233, 1.790> <1.473, -1.215, 1.793> 
		<1.679, -1.503, 1.655> <1.624, -1.419, 1.711> <1.475, -1.244, 1.791> <1.452, -1.226, 1.794> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.674, -1.563, 1.570> <1.674, -1.563, 1.570> <1.674, -1.563, 1.570> <1.674, -1.563, 1.570> 
		<1.677, -1.566, 1.575> <1.685, -1.561, 1.574> <1.685, -1.561, 1.574> <1.683, -1.558, 1.569> 
		<1.694, -1.525, 1.640> <1.699, -1.523, 1.639> <1.686, -1.459, 1.602> <1.662, -1.436, 1.589> 
		<1.679, -1.503, 1.655> <1.684, -1.500, 1.655> <1.661, -1.420, 1.628> <1.637, -1.398, 1.614> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.674, -1.563, 1.570> <1.674, -1.563, 1.570> <1.674, -1.563, 1.570> <1.674, -1.563, 1.570> 
		<1.665, -1.568, 1.571> <1.668, -1.570, 1.576> <1.668, -1.570, 1.576> <1.677, -1.566, 1.575> 
		<1.622, -1.456, 1.592> <1.648, -1.477, 1.607> <1.689, -1.528, 1.640> <1.694, -1.525, 1.640> 
		<1.597, -1.419, 1.617> <1.624, -1.439, 1.632> <1.674, -1.505, 1.655> <1.679, -1.503, 1.655> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.674, -1.563, 1.570> <1.683, -1.558, 1.569> <1.662, -1.436, 1.589> <1.637, -1.398, 1.614> 
		<1.665, -1.568, 1.571> <1.674, -1.563, 1.570> <1.686, -1.459, 1.602> <1.661, -1.420, 1.628> 
		<1.622, -1.456, 1.592> <1.648, -1.477, 1.607> <1.679, -1.503, 1.655> <1.684, -1.500, 1.655> 
		<1.597, -1.419, 1.617> <1.624, -1.439, 1.632> <1.674, -1.505, 1.655> <1.679, -1.503, 1.655> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.679, -1.503, 1.655> <1.679, -1.503, 1.655> <1.679, -1.503, 1.655> <1.679, -1.503, 1.655> 
		<1.674, -1.505, 1.655> <1.619, -1.421, 1.711> <1.619, -1.421, 1.711> <1.624, -1.419, 1.711> 
		<1.624, -1.439, 1.632> <1.581, -1.374, 1.675> <1.455, -1.254, 1.793> <1.475, -1.244, 1.791> 
		<1.597, -1.419, 1.617> <1.554, -1.353, 1.661> <1.433, -1.236, 1.796> <1.452, -1.226, 1.794> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.679, -1.503, 1.655> <1.679, -1.503, 1.655> <1.679, -1.503, 1.655> <1.679, -1.503, 1.655> 
		<1.624, -1.419, 1.711> <1.628, -1.416, 1.710> <1.628, -1.416, 1.710> <1.684, -1.500, 1.655> 
		<1.475, -1.244, 1.791> <1.495, -1.233, 1.790> <1.617, -1.352, 1.673> <1.661, -1.420, 1.628> 
		<1.452, -1.226, 1.794> <1.473, -1.215, 1.793> <1.592, -1.330, 1.659> <1.637, -1.398, 1.614> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.679, -1.503, 1.655> <1.684, -1.500, 1.655> <1.661, -1.420, 1.628> <1.637, -1.398, 1.614> 
		<1.674, -1.505, 1.655> <1.679, -1.503, 1.655> <1.617, -1.352, 1.673> <1.592, -1.330, 1.659> 
		<1.624, -1.439, 1.632> <1.581, -1.374, 1.675> <1.453, -1.225, 1.794> <1.473, -1.215, 1.793> 
		<1.597, -1.419, 1.617> <1.554, -1.353, 1.661> <1.433, -1.236, 1.796> <1.452, -1.226, 1.794> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.915, -0.756, 0.838> <0.828, -0.679, 0.804> <0.694, -0.582, 0.814> <0.600, -0.508, 0.804> 
		<0.923, -0.703, 0.837> <0.836, -0.626, 0.804> <0.703, -0.556, 0.814> <0.608, -0.481, 0.804> 
		<0.889, -0.766, 1.055> <0.805, -0.668, 0.986> <0.712, -0.512, 0.933> <0.647, -0.401, 0.863> 
		<0.861, -0.767, 1.144> <0.777, -0.669, 1.075> <0.709, -0.507, 0.981> <0.644, -0.396, 0.911> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.915, -0.756, 0.838> <0.906, -0.810, 0.838> <0.883, -0.808, 1.054> <0.855, -0.809, 1.145> 
		<0.828, -0.679, 0.804> <0.819, -0.733, 0.805> <0.798, -0.745, 0.992> <0.770, -0.746, 1.083> 
		<0.694, -0.582, 0.814> <0.684, -0.613, 0.814> <0.652, -0.705, 0.926> <0.648, -0.700, 0.982> 
		<0.600, -0.508, 0.804> <0.590, -0.538, 0.804> <0.563, -0.659, 0.856> <0.560, -0.653, 0.912> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.587, -0.486, 1.021> <0.576, -0.519, 1.021> <0.557, -0.647, 0.972> <0.560, -0.653, 0.912> 
		<0.636, -0.568, 1.125> <0.625, -0.601, 1.125> <0.645, -0.694, 1.042> <0.648, -0.700, 0.982> 
		<0.699, -0.706, 1.296> <0.696, -0.729, 1.296> <0.748, -0.747, 1.155> <0.770, -0.746, 1.083> 
		<0.750, -0.761, 1.368> <0.746, -0.783, 1.368> <0.832, -0.809, 1.217> <0.855, -0.809, 1.145> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.587, -0.486, 1.021> <0.636, -0.568, 1.125> <0.699, -0.706, 1.296> <0.750, -0.761, 1.368> 
		<0.595, -0.461, 1.021> <0.644, -0.543, 1.125> <0.703, -0.684, 1.296> <0.754, -0.738, 1.368> 
		<0.641, -0.391, 0.957> <0.707, -0.503, 1.027> <0.755, -0.669, 1.147> <0.839, -0.767, 1.216> 
		<0.644, -0.396, 0.911> <0.709, -0.507, 0.981> <0.777, -0.669, 1.075> <0.861, -0.767, 1.144> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.489, -1.211, 0.800> <-1.342, -1.081, 0.715> <-1.125, -0.893, 0.674> <-0.962, -0.756, 0.655> 
		<-1.496, -1.185, 0.799> <-1.348, -1.055, 0.714> <-1.133, -0.840, 0.672> <-0.970, -0.703, 0.652> 
		<-1.440, -1.122, 1.025> <-1.307, -1.025, 0.984> <-1.105, -0.879, 0.926> <-0.991, -0.766, 0.872> 
		<-1.419, -1.093, 1.124> <-1.286, -0.997, 1.084> <-1.100, -0.880, 1.019> <-0.986, -0.767, 0.965> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.489, -1.211, 0.800> <-1.496, -1.185, 0.799> <-1.440, -1.122, 1.025> <-1.419, -1.093, 1.124> 
		<-1.623, -1.329, 0.876> <-1.629, -1.303, 0.875> <-1.567, -1.215, 1.064> <-1.546, -1.186, 1.163> 
		<-1.856, -1.547, 1.154> <-1.864, -1.543, 1.151> <-1.750, -1.334, 1.166> <-1.732, -1.295, 1.197> 
		<-1.878, -1.563, 1.179> <-1.886, -1.558, 1.176> <-1.871, -1.436, 1.199> <-1.853, -1.398, 1.230> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.489, -1.211, 0.800> <-1.623, -1.329, 0.876> <-1.856, -1.547, 1.154> <-1.878, -1.563, 1.179> 
		<-1.483, -1.237, 0.800> <-1.617, -1.355, 0.877> <-1.848, -1.552, 1.157> <-1.870, -1.568, 1.181> 
		<-1.426, -1.177, 1.030> <-1.544, -1.263, 1.068> <-1.712, -1.370, 1.181> <-1.833, -1.456, 1.213> 
		<-1.406, -1.149, 1.126> <-1.524, -1.235, 1.165> <-1.694, -1.333, 1.211> <-1.815, -1.419, 1.243> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.489, -1.211, 0.800> <-1.483, -1.237, 0.800> <-1.426, -1.177, 1.030> <-1.406, -1.149, 1.126> 
		<-1.342, -1.081, 0.715> <-1.336, -1.107, 0.716> <-1.293, -1.079, 0.986> <-1.273, -1.051, 1.083> 
		<-1.125, -0.893, 0.674> <-1.117, -0.946, 0.677> <-1.120, -0.895, 0.928> <-1.115, -0.896, 1.023> 
		<-0.962, -0.756, 0.655> <-0.954, -0.810, 0.658> <-0.984, -0.808, 0.872> <-0.979, -0.809, 0.967> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.406, -1.149, 1.126> <-1.383, -1.118, 1.233> <-1.339, -1.043, 1.475> <-1.345, -1.016, 1.474> 
		<-1.273, -1.051, 1.083> <-1.250, -1.021, 1.189> <-1.305, -1.023, 1.464> <-1.311, -0.996, 1.463> 
		<-1.115, -0.896, 1.023> <-1.111, -0.896, 1.098> <-1.008, -0.846, 1.278> <-1.011, -0.824, 1.276> 
		<-0.979, -0.809, 0.967> <-0.975, -0.809, 1.043> <-0.929, -0.783, 1.211> <-0.933, -0.761, 1.209> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.406, -1.149, 1.126> <-1.524, -1.235, 1.165> <-1.694, -1.333, 1.211> <-1.815, -1.419, 1.243> 
		<-1.383, -1.118, 1.233> <-1.501, -1.204, 1.272> <-1.663, -1.267, 1.264> <-1.784, -1.353, 1.296> 
		<-1.339, -1.043, 1.475> <-1.366, -1.059, 1.483> <-1.676, -1.216, 1.465> <-1.699, -1.236, 1.456> 
		<-1.345, -1.016, 1.474> <-1.372, -1.032, 1.482> <-1.695, -1.206, 1.459> <-1.718, -1.226, 1.450> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.345, -1.016, 1.474> <-1.352, -0.989, 1.473> <-1.397, -1.064, 1.228> <-1.419, -1.093, 1.124> 
		<-1.311, -0.996, 1.463> <-1.317, -0.969, 1.463> <-1.263, -0.967, 1.187> <-1.286, -0.997, 1.084> 
		<-1.011, -0.824, 1.276> <-1.014, -0.802, 1.275> <-1.096, -0.881, 1.094> <-1.100, -0.880, 1.019> 
		<-0.933, -0.761, 1.209> <-0.936, -0.738, 1.208> <-0.982, -0.767, 1.040> <-0.986, -0.767, 0.965> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.345, -1.016, 1.474> <-1.372, -1.032, 1.482> <-1.695, -1.206, 1.459> <-1.718, -1.226, 1.450> 
		<-1.352, -0.989, 1.473> <-1.378, -1.005, 1.481> <-1.714, -1.195, 1.453> <-1.738, -1.215, 1.444> 
		<-1.397, -1.064, 1.228> <-1.524, -1.156, 1.267> <-1.699, -1.227, 1.251> <-1.821, -1.330, 1.285> 
		<-1.419, -1.093, 1.124> <-1.546, -1.186, 1.163> <-1.732, -1.295, 1.197> <-1.853, -1.398, 1.230> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.878, -1.563, 1.179> <-1.882, -1.566, 1.183> <-1.914, -1.525, 1.241> <-1.903, -1.503, 1.260> 
		<-1.870, -1.568, 1.181> <-1.873, -1.570, 1.185> <-1.874, -1.441, 1.309> <-1.864, -1.419, 1.327> 
		<-1.833, -1.456, 1.213> <-1.801, -1.390, 1.266> <-1.720, -1.254, 1.448> <-1.739, -1.244, 1.442> 
		<-1.815, -1.419, 1.243> <-1.784, -1.353, 1.296> <-1.699, -1.236, 1.456> <-1.718, -1.226, 1.450> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.878, -1.563, 1.179> <-1.886, -1.558, 1.176> <-1.871, -1.436, 1.199> <-1.853, -1.398, 1.230> 
		<-1.882, -1.566, 1.183> <-1.890, -1.561, 1.180> <-1.839, -1.368, 1.254> <-1.821, -1.330, 1.285> 
		<-1.914, -1.525, 1.241> <-1.874, -1.441, 1.309> <-1.758, -1.233, 1.436> <-1.738, -1.215, 1.444> 
		<-1.903, -1.503, 1.260> <-1.864, -1.419, 1.327> <-1.739, -1.244, 1.442> <-1.718, -1.226, 1.450> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.878, -1.563, 1.179> <-1.878, -1.563, 1.179> <-1.878, -1.563, 1.179> <-1.878, -1.563, 1.179> 
		<-1.882, -1.566, 1.183> <-1.890, -1.561, 1.180> <-1.890, -1.561, 1.180> <-1.886, -1.558, 1.176> 
		<-1.914, -1.525, 1.241> <-1.919, -1.523, 1.240> <-1.898, -1.459, 1.207> <-1.871, -1.436, 1.199> 
		<-1.903, -1.503, 1.260> <-1.908, -1.500, 1.258> <-1.880, -1.420, 1.238> <-1.853, -1.398, 1.230> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.878, -1.563, 1.179> <-1.878, -1.563, 1.179> <-1.878, -1.563, 1.179> <-1.878, -1.563, 1.179> 
		<-1.870, -1.568, 1.181> <-1.873, -1.570, 1.185> <-1.873, -1.570, 1.185> <-1.882, -1.566, 1.183> 
		<-1.833, -1.456, 1.213> <-1.862, -1.477, 1.221> <-1.910, -1.528, 1.243> <-1.914, -1.525, 1.241> 
		<-1.815, -1.419, 1.243> <-1.844, -1.439, 1.251> <-1.899, -1.505, 1.261> <-1.903, -1.503, 1.260> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.878, -1.563, 1.179> <-1.886, -1.558, 1.176> <-1.871, -1.436, 1.199> <-1.853, -1.398, 1.230> 
		<-1.870, -1.568, 1.181> <-1.878, -1.563, 1.179> <-1.898, -1.459, 1.207> <-1.880, -1.420, 1.238> 
		<-1.833, -1.456, 1.213> <-1.862, -1.477, 1.221> <-1.903, -1.503, 1.260> <-1.908, -1.500, 1.258> 
		<-1.815, -1.419, 1.243> <-1.844, -1.439, 1.251> <-1.899, -1.505, 1.261> <-1.903, -1.503, 1.260> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.903, -1.503, 1.260> <-1.903, -1.503, 1.260> <-1.903, -1.503, 1.260> <-1.903, -1.503, 1.260> 
		<-1.899, -1.505, 1.261> <-1.859, -1.421, 1.329> <-1.859, -1.421, 1.329> <-1.864, -1.419, 1.327> 
		<-1.844, -1.439, 1.251> <-1.813, -1.374, 1.304> <-1.720, -1.254, 1.448> <-1.739, -1.244, 1.442> 
		<-1.815, -1.419, 1.243> <-1.784, -1.353, 1.296> <-1.699, -1.236, 1.456> <-1.718, -1.226, 1.450> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.903, -1.503, 1.260> <-1.903, -1.503, 1.260> <-1.903, -1.503, 1.260> <-1.903, -1.503, 1.260> 
		<-1.864, -1.419, 1.327> <-1.868, -1.416, 1.326> <-1.868, -1.416, 1.326> <-1.908, -1.500, 1.258> 
		<-1.739, -1.244, 1.442> <-1.758, -1.233, 1.436> <-1.848, -1.352, 1.293> <-1.880, -1.420, 1.238> 
		<-1.718, -1.226, 1.450> <-1.738, -1.215, 1.444> <-1.821, -1.330, 1.285> <-1.853, -1.398, 1.230> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.903, -1.503, 1.260> <-1.908, -1.500, 1.258> <-1.880, -1.420, 1.238> <-1.853, -1.398, 1.230> 
		<-1.899, -1.505, 1.261> <-1.903, -1.503, 1.260> <-1.848, -1.352, 1.293> <-1.821, -1.330, 1.285> 
		<-1.844, -1.439, 1.251> <-1.813, -1.374, 1.304> <-1.719, -1.225, 1.450> <-1.738, -1.215, 1.444> 
		<-1.815, -1.419, 1.243> <-1.784, -1.353, 1.296> <-1.699, -1.236, 1.456> <-1.718, -1.226, 1.450> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.962, -0.756, 0.655> <-0.870, -0.679, 0.644> <-0.743, -0.582, 0.686> <-0.648, -0.508, 0.700> 
		<-0.970, -0.703, 0.652> <-0.878, -0.626, 0.641> <-0.751, -0.556, 0.684> <-0.657, -0.481, 0.697> 
		<-0.991, -0.766, 0.872> <-0.892, -0.668, 0.825> <-0.789, -0.512, 0.797> <-0.709, -0.401, 0.745> 
		<-0.986, -0.767, 0.965> <-0.887, -0.669, 0.919> <-0.798, -0.507, 0.844> <-0.718, -0.396, 0.792> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.962, -0.756, 0.655> <-0.954, -0.810, 0.658> <-0.984, -0.808, 0.872> <-0.979, -0.809, 0.967> 
		<-0.870, -0.679, 0.644> <-0.862, -0.733, 0.647> <-0.887, -0.745, 0.833> <-0.882, -0.746, 0.928> 
		<-0.743, -0.582, 0.686> <-0.733, -0.613, 0.689> <-0.729, -0.705, 0.805> <-0.739, -0.700, 0.860> 
		<-0.648, -0.508, 0.700> <-0.639, -0.538, 0.702> <-0.626, -0.659, 0.759> <-0.637, -0.653, 0.814> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.689, -0.486, 0.913> <-0.679, -0.519, 0.916> <-0.648, -0.647, 0.873> <-0.637, -0.653, 0.814> 
		<-0.762, -0.568, 1.002> <-0.752, -0.601, 1.005> <-0.751, -0.694, 0.919> <-0.739, -0.700, 0.860> 
		<-0.866, -0.706, 1.152> <-0.862, -0.729, 1.153> <-0.878, -0.747, 1.003> <-0.882, -0.746, 0.928> 
		<-0.933, -0.761, 1.209> <-0.929, -0.783, 1.211> <-0.975, -0.809, 1.043> <-0.979, -0.809, 0.967> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.689, -0.486, 0.913> <-0.762, -0.568, 1.002> <-0.866, -0.706, 1.152> <-0.933, -0.761, 1.209> 
		<-0.697, -0.461, 0.911> <-0.770, -0.543, 1.000> <-0.869, -0.684, 1.151> <-0.936, -0.738, 1.208> 
		<-0.726, -0.391, 0.837> <-0.807, -0.503, 0.889> <-0.883, -0.669, 0.993> <-0.982, -0.767, 1.040> 
		<-0.718, -0.396, 0.792> <-0.798, -0.507, 0.844> <-0.887, -0.669, 0.919> <-0.986, -0.767, 0.965> 
	}
	#ifndef (IMPORT_SPATCH)
	pigment {
      bumps
      color_map {
         [ 0 color rgb <.9,.9,.95> ]
         [ 1 color rgb <.9,.9,.95>/0.96 ]
      }
      scale 0.1
	   turbulence 0.2
	   omega .2
	   lambda 2
	   octaves 6
      scale 2
	}
	finish { phong 0.9 reflection 0.1 }
	normal {
	   leopard
	   slope_map {
	      [ 0.0 <.0,0> ]
	      [ 0.1 <.05,.5> ]
	      [ 1.0 <.05,.5> ]
	   }
	   scale 0.02
	}
	#end
}
}

object {
   fishy
   rotate 90*y
   rotate -35*z
   rotate 15*y
   translate <13,1,-4>

}
