global_settings {
   max_trace_level 20
   assumed_gamma 2.0
}

#include "bloby01.pov"

camera {
   location <12,10,-10>
   look_at  <12,0,0>
}

light_source {
   <50,100,-40>
   color rgb <1,1,1>*1.1
}

#declare StrengthVal = .8 ; 
#declare RadiusVal   = 2;
#declare counter = 1;
#declare bnum = 50;
#declare details = .1;

#declare ranseed = seed (123); 
#declare nsin = 360;
#declare sinsize = 2;

#declare nsin2 = 360*6;
#declare sinsize2 = .2;

#declare ncos2 = 360*3;
#declare cossize2 = .4;

#declare sinsizey = 4;
#declare nsiny = 180;

#declare bloby01=
blob
{
  threshold 0.3
  #while (counter<bnum)
     
     #declare mrnd1 = rand(ranseed); 
     
     #declare szmov  = (sin(radians(counter*(nsin/bnum)))*sinsize); 
     #declare symov  = (sin(radians(counter*(nsiny/bnum)))*sinsizey)-(5*counter/bnum); 
     #declare szmov2 = (sin(radians(counter*(nsin2/bnum)))*sinsize2); 
     #declare czmov2 = (cos(radians(counter*(ncos2/bnum)))*cossize2); 
     #declare czmov  = (cos(radians(counter*(nsin/bnum)))*sinsize); 
     
     #declare sphx = (counter/2);
     #declare sphz = szmov+szmov2+czmov2;
     #declare sphy = symov+szmov2+czmov2;

     sphere {
        <sphx,0,0>,
        StrengthVal-(0.5*counter/bnum)-(abs(-1+(counter/bnum)+(mrnd1))/6),
        RadiusVal
        translate <0,sphy,sphz>
     }
     #switch (counter)
        #case ( 24 )
           #declare xbrn1a = sphx;
           #declare ybrn1a = sphy;
           #declare zbrn1a = sphz;
        #break
        #case ( 40 )
           #declare xbrn1b = sphx;
           #declare ybrn1b = sphy;
           #declare zbrn1b = sphz;
        #break
        #case ( 30 )
           #declare xbrn1c = sphx;
           #declare ybrn1c = sphy;
           #declare zbrn1c = sphz;
        #break
        #case ( 45 )
           #declare xbrn1d = sphx;
           #declare ybrn1d = sphy;
           #declare zbrn1d = sphz;
        #break
        #case ( 20 )
           #declare xbrn2a = sphx;
           #declare ybrn2a = sphy;
           #declare zbrn2a = sphz;
        #break
        #case ( 43 )
           #declare xbrn2b = sphx;
           #declare ybrn2b = sphy;
           #declare zbrn2b = sphz;
        #break
         #case ( 36 )
           #declare xbrn2c = sphx;
           #declare ybrn2c = sphy;
           #declare zbrn2c = sphz;
        #break
        #case ( 28 )
           #declare xbrn2d = sphx;
           #declare ybrn2d = sphy;
           #declare zbrn2d = sphz;
        #break
    #end
     #declare counter = counter + details;
  #end
  texture {
     pigment { color rgb <.7,.5,0> }
     normal { granite 0.4 scale <3,1,1>/2 }
  }
  texture {
     pigment {
        bumps
        color_map {
           [ 0 color rgbt <.5,.3,0,0.65> ]
           [ 1 color rgbt <.9,.7,0.1,0.5> ]
        }
        scale 2
     }
     normal {
        crackle 0.8
        slope_map {
           [ 0.00 <0,0>]
           [ 0.05 <1,0>]
           [ 1.00 <1,0>]
        }
        turbulence 0.5
        octaves 6
        lambda 5
        omega 0.4
        scale <1.5,0.8,0.8>/1.5
     }
  }
}

#declare position = <-3,3,2>; 
#declare rotation = <0,-5,5>; 
#declare position1 = <-3,0,3>; 
#declare rotation1 = <0,-20,0>; 

union {
   object { bloby01 translate <0,0,0> rotate rotation }
   object { bloby01 translate <0,0,0> rotate rotation1 translate position1 }
   object { bloby01 translate <0,0,0> scale 1.2 rotate x*-30 rotate 35*y }
   translate position
}

#declare bdetail = 2;
#declare maxcount = 50; 
#declare yadd02 = .45;
#declare degre = 180*2;
#declare fscal = 0.25;
#declare see02 = seed (163);
#include "branch01.pov"

object {
   branch01
   scale 1
   rotate 90*y
   rotate 10*y
   translate <xbrn1a,ybrn1a,zbrn1a>
   rotate rotation
   translate position
}
union {
object {
   branch01
   scale 1
   rotate 90*y
   rotate 10*y
   translate <xbrn1a,ybrn1a,zbrn1a>
}
   rotate rotation1 translate position1
   translate position
}

#declare bdetail = 2.5;
#declare maxcount = 50; 
#declare yadd02 = .45;
#declare degre = 180*1.5;
#declare fscal = 0.25;
#declare see02 = seed (163);
#include "branch01.pov"

object {
   branch01
   scale .8
   rotate 90*y
   rotate 20*y
   translate <xbrn1d,ybrn1d,zbrn1d>
   rotate rotation
   translate position
}
union{
object {
   branch01
   scale .8
   rotate 90*y
   rotate 20*y
   translate <xbrn1d,ybrn1d,zbrn1d>
}
   rotate rotation1 translate position1
   translate position
}

#declare bdetail = 2;
#declare maxcount = 50; 
#declare yadd02 = .45;
#declare degre = 180*.5;
#declare fscal = 0.25;
#declare see02 = seed (163);
#include "branch01.pov"

object {
   branch01
   scale .7
   rotate 90*y
   rotate -10*y
   translate <xbrn1b,ybrn1b,zbrn1b>
   rotate rotation
   translate position
}
union {
object {
   branch01
   scale .7
   rotate 90*y
   rotate -10*y
   translate <xbrn1b,ybrn1b,zbrn1b>
}
   rotate rotation1 translate position1
   translate position
}

#declare bdetail = 5;
#declare bdetail = 4;
#declare maxcount = 40; 
#declare yadd02 = .45;
#declare degre = 180*2;
#declare fscal = 0.25;
#declare see02 = seed (163);
#include "branch01.pov"

object {
   branch01
   scale .7
   rotate 90*y
   rotate 10*y
   translate <xbrn1c,ybrn1c,zbrn1c>
   rotate rotation
   translate position
}
union {
object {
   branch01
   scale .7
   rotate 90*y
   rotate 10*y
   translate <xbrn1c,ybrn1c,zbrn1c>
}
   rotate rotation1 translate position1
   translate position
}

#declare bdetail = 2;
#declare maxcount = 50; 
#declare yadd02 = .45;
#declare degre = 180*2;
#declare fscal = 0.25;
#declare see02 = seed (163);
#include "branch01.pov"

object {
   branch01
   scale 1
   rotate -90*y
   rotate 15*y
   translate <xbrn2a,ybrn2a,zbrn2a>
   rotate rotation
   translate position
}
union {
object {
   branch01
   scale 1
   rotate -90*y
   rotate 15*y
   translate <xbrn2a,ybrn2a,zbrn2a>
}
   rotate rotation1 translate position1
   translate position
}

#declare bdetail = 4;
#declare maxcount = 20; 
#declare yadd02 = .45;
#declare degre = 180*1.1;
#declare fscal = 0.25;
#declare see02 = seed (538);
#include "branch01.pov"

object {
   branch01
   scale .85
   rotate -90*y
   rotate -20*y
   translate <xbrn2b,ybrn2b,zbrn2b>
   rotate rotation
   translate position
}
union {
object {
   branch01
   scale .85
   rotate -90*y
   rotate -20*y
   translate <xbrn2b,ybrn2b,zbrn2b>
}
   rotate rotation1 translate position1
   translate position
}

#declare bdetail = 3;
#declare maxcount = 50; 
#declare yadd02 = .45;
#declare degre = 180*2.2;
#declare fscal = 0.25;
#declare see02 = seed (627);
#include "branch01.pov"

object {
   branch01
   scale .8
   rotate -90*y
   rotate -2*y
   translate <xbrn2c,ybrn2c,zbrn2c>
   rotate rotation
   translate position
}
union {
object {
   branch01
   scale .8
   rotate -90*y
   rotate -2*y
   translate <xbrn2c,ybrn2c,zbrn2c>
}
   rotate rotation1 translate position1
   translate position
}

#declare bdetail = 2;
#declare maxcount = 40; 
#declare yadd02 = .45;
#declare degre = 180;
#declare fscal = 0.25;
#declare see02 = seed (245);
#include "branch01.pov"

object {
   branch01
   scale .9
   rotate -90*y
   rotate 3*y
   translate <xbrn2d,ybrn2d,zbrn2d>
   rotate rotation
   translate position
}
union {
object {
   branch01
   scale .9
   rotate -90*y
   rotate 3*y
   translate <xbrn2d,ybrn2d,zbrn2d>
}
   rotate rotation1 translate position1
   translate position
}




