//  Persistance of Vision Raytracer V3.0
//  World definition file.
//
//  Contains 20 lights, 13 textures and 280 primitives.
//
//  This file was generated for POV-Ray V3.0 by
//  Moray V3.0 For Windows (c) 1991-1998 Lutz + Kretzschmar
//

//  Date : 03/20/1998    (20.03.1998)
//

/*
  The text between these two comments is in MorayPOV.INC and is
  automatically included in all POV files that Moray exports.
*/


/* // Scene Comment

This scene was created with Moray For Windows.

*/ // End Scene Comment

global_settings {
  adc_bailout 0.003922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 1.9
  hf_gray_16 off
  irid_wavelength <0.247059,0.176471,0.137255>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
  radiosity {
    brightness       3.3
    count            100
    distance_maximum 0.0
    error_bound      0.4
    gray_threshold   0.5
    low_error_factor 0.8
    minimum_reuse    0.015
    nearest_count    6
    recursion_limit  1
  }
}
// ==== Standard POV-Ray Includes ====




background { color <0.000,0.000,0.000> }

camera {  //  Camera StdCam
  location  <-415.479, -268.742, 77.222>
  direction <0.0,     0.0,  1.8317>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333,  0.0,  0.0>
  look_at   <-53.948, -29.411, 63.595>
  // Focal blur settings
  focal_point  <-53.948, -29.411, 63.595> // Always Lookat
  aperture     1.0
  blur_samples 20
  confidence   0.5
  variance     0.02
}

//    Other cameras are commented out.
/*
camera {  //  Camera SpotCam001
  location  <37.357, 77.230, 166.337> // Attached to Light Standard Lamp
  direction <0.0,     0.0,  1.8660>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333,  0.0,  0.0>
  look_at   <37.357, 41.967, 69.724> // Following Light Standard Lamp
}

*/

//
// *******  L I G H T S *******
//

light_source {   // Spotlight Light_Standard_Lamp1
  <-187.376, -90.995, 0.901>
  color  rgb <1.000, 1.000, 1.000>
  spotlight
    point_at  <-226.871, -91.298, -12.947>
    falloff   15.00  // outer radius (in deg)
      radius    7.50  // inner radius
}

light_source {   // Spotlight Light_Standard_Lamp2
  <-187.478, -118.399, 0.536>
  color  rgb <1.000, 1.000, 1.000>
  spotlight
    point_at  <-225.770, -124.129, -13.121>
    falloff   15.00  // outer radius (in deg)
      radius    7.50  // inner radius
}

light_source {   // Spotlight Light_Standard_Lamp
  <37.357, 77.230, 166.337>
  color  rgb <1.000, 1.000, 1.000>
  spotlight
    point_at  <37.357, 41.967, 69.724>
    falloff   15.00  // outer radius (in deg)
      radius    7.50  // inner radius
}

light_source {   // Spotlight Light_Standard_Lamp3
  <151.745, 77.230, 166.668>
  color  rgb <1.000, 1.000, 1.000>
  spotlight
    point_at  <152.299, 0.811, 92.664>
    falloff   15.00  // outer radius (in deg)
      radius    7.50  // inner radius
}

light_source {   // Spotlight Light_Standard_Lamp4
  <297.483, 77.230, 163.114>
  color  rgb <1.000, 1.000, 1.000>
  spotlight
    point_at  <297.483, 40.291, 61.912>
    falloff   15.00  // outer radius (in deg)
      radius    7.50  // inner radius
}

light_source {   // Spotlight Light_Standard_Lamp5
  <453.885, 77.230, 163.114>
  color  rgb <1.000, 1.000, 1.000>
  spotlight
    point_at  <453.924, 47.152, 45.039>
    falloff   15.00  // outer radius (in deg)
      radius    7.50  // inner radius
}

light_source {   // Spotlight Light_Standard_Lamp6
  <628.060, 77.230, 166.668>
  color  rgb <1.000, 1.000, 1.000>
  spotlight
    point_at  <628.060, 39.112, 62.235>
    falloff   15.00  // outer radius (in deg)
      radius    7.50  // inner radius
}

light_source {   // Spotlight Light_Standard_Lamp7
  <-125.514, 77.230, 163.114>
  color  rgb <1.000, 1.000, 1.000>
  spotlight
    point_at  <-125.102, 2.158, 91.683>
    falloff   15.00  // outer radius (in deg)
      radius    7.50  // inner radius
}

light_source {   // Spotlight Light_Standard_Lamp8
  <916.554, 77.230, 161.570>
  color  rgb <1.000, 1.000, 1.000>
  spotlight
    point_at  <916.554, 39.702, 58.752>
    falloff   15.00  // outer radius (in deg)
      radius    7.50  // inner radius
}

light_source {   // Spotlight Light_Standard_Lamp9
  <1026.175, 77.230, 166.668>
  color  rgb <1.000, 1.000, 1.000>
  spotlight
    point_at  <1026.175, 39.112, 62.235>
    falloff   15.00  // outer radius (in deg)
      radius    7.50  // inner radius
}

light_source {   // Spotlight Light_Standard_Lamp10
  <1171.913, 77.230, 163.114>
  color  rgb <1.000, 1.000, 1.000>
  spotlight
    point_at  <1171.913, 39.702, 60.296>
    falloff   15.00  // outer radius (in deg)
      radius    7.50  // inner radius
}

light_source {   // Spotlight Light_Standard_Lamp11
  <1328.315, 77.230, 163.114>
  color  rgb <1.000, 1.000, 1.000>
  spotlight
    point_at  <1328.315, 39.702, 60.296>
    falloff   15.00  // outer radius (in deg)
      radius    7.50  // inner radius
}

light_source {   // Spotlight Light_Standard_Lamp12
  <1502.490, 77.230, 166.668>
  color  rgb <1.000, 1.000, 1.000>
  spotlight
    point_at  <1502.490, 46.780, 83.242>
    falloff   15.00  // outer radius (in deg)
      radius    7.50  // inner radius
}

light_source {   // Spotlight Light_Standard_Lamp13
  <748.917, 77.230, 163.114>
  color  rgb <1.000, 1.000, 1.000>
  spotlight
    point_at  <748.917, 39.112, 58.680>
    falloff   15.00  // outer radius (in deg)
      radius    7.50  // inner radius
}

light_source { // AreaLite001
  <0.000, -120.932, 120.157>
  color  rgb<0.194, 0.194, 0.194>
  area_light <2.000, 0.000, 0.000>, <0.000, 2.000, 0.000>, 8, 8
  adaptive 1
  jitter
  
}


light_source {   // Light1
  <51.056, -78.869, 68.590>
  color rgb <1.000, 1.000, 1.000>
}

light_source {   // Spotlight Light_Standard_Lamp14
  <20.428, 89.010, 0.107>
  color  rgb <1.000, 1.000, 1.000>
  spotlight
    point_at  <-39.297, 88.553, -20.833>
    falloff   15.00  // outer radius (in deg)
      radius    7.50  // inner radius
}

light_source {   // Spotlight Light_Standard_Lamp15
  <20.367, 61.497, 0.536>
  color  rgb <1.000, 1.000, 1.000>
  spotlight
    point_at  <-38.082, 52.752, -20.311>
    falloff   15.00  // outer radius (in deg)
      radius    7.50  // inner radius
}

light_source {   // Spotlight Light_Standard_Lamp16
  <384.107, 40.374, 0.901>
  color  rgb <1.000, 1.000, 1.000>
  spotlight
    point_at  <344.612, 40.072, -12.947>
    falloff   15.00  // outer radius (in deg)
      radius    7.50  // inner radius
}

light_source {   // Spotlight Light_Standard_Lamp17
  <384.005, 12.970, 0.536>
  color  rgb <1.000, 1.000, 1.000>
  spotlight
    point_at  <345.714, 7.241, -13.121>
    falloff   15.00  // outer radius (in deg)
      radius    7.50  // inner radius
}


//
// ********  TEXTURES  *******
//

#include "wheel.inc"


//
// ********  REFERENCED OBJECTS  *******
//

#declare Driver_Helmet = union {
  cylinder { // Cylndr002
    <0,0,1>, <0,0,0>, 1 
    texture {
      Black
    }
    scale <2.191674, 2.329102, 1.10387>
    rotate <180.0, 85.018524, 180.0>
    translate  <71.078084, 31.232488, 14.71926>
  }
  sphere { // Sphere001
    <0,0,0>,1
    texture {
      Chrome_Metal
    }
    scale 5.851791
    translate  <77.028665, 29.028671, 14.137637>
  }
  cylinder { // Cylndr63
    <0,0,1>, <0,0,0>, 1 
    texture {
      Black
    }
    scale <2.191674, 2.329102, 1.10387>
    rotate <180.0, 85.018524, 180.0>
    translate  <71.078084, 26.979361, 14.71926>
  }
  translate  <2.047486, -0.273502, 0.0>
}
#declare Driver_Helmet1 = object {
  object { // Driver_Helmet1->Driver Helmet
    Driver_Helmet
    rotate -180.0*x
    translate  <-1.17452, 57.105185, 29.449164>
  }
}
#declare Rear_Airfoil = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.272644, -2.019840, -0.242708>, <-0.897207, -2.019840, 0.004411>, <0.000000, -2.019840, 0.004411>, <1.000000, -2.019840, -0.138877>, 
      <-2.272644, -1.000000, -0.242708>, <-0.897207, -1.000000, 0.004411>, <0.000000, -1.000000, 0.004411>, <1.000000, -1.000000, -0.138877>, 
      <-2.272644, 0.000000, -0.242708>, <-0.897207, 0.000000, 0.004411>, <0.000000, 0.000000, 0.004411>, <1.000000, 0.000000, -0.138877>, 
      <-2.272644, 0.960321, -0.242708>, <-0.897207, 0.960321, 0.004411>, <0.000000, 0.960321, 0.004411>, <1.000000, 0.960321, -0.138877>
    }
  }
  texture {
    CYAN_METALIC
  }
  scale <13.229007, 26.100262, 3.490387>
  rotate -19.071161*y
  translate  <138.014412, 44.618855, 34.333835>
}
#declare Cylndr008 = object {
  cylinder { // Cylndr008
    <0,0,1>, <0,0,0>, 1 
    texture {
      CYAN_METALIC
    }
    scale <-2.982107, -3.027318, -24.046894>
    rotate <-179.999969, 82.584129, 0.000061>
    translate  <-2.633584, 43.454963, 0.41468>
  }
}
#declare Cylndr65 = object {
  object { // Cylndr65->Cylndr008
    Cylndr008
    texture {
      CYAN_METALIC
    }
    rotate 0.0*x
    translate  <-1.415352, -27.377088, -0.721838>
  }
}


#declare Cylndr66 = object {
  object { // Cylndr66->Cylndr65
    Cylndr65
    texture {
      Solarized
    }
    translate  <188.464603, 162.312702, 0.778495>
  }
}




//
// ********  OBJECTS  *******
//

object { // Driver_Helmet2->Driver Helmet1
  Driver_Helmet1
  rotate <0.0, 0.0, 0.0>
  translate  <386.217513, -3.072615, -0.920286>
}


object { // Rear_Airfoil3->Rear Airfoil
  Rear_Airfoil
  texture {
    CYAN_METALIC
  }
  rotate <180.0, 0.000006, 180.0>
  translate  <75.966188, -134.902729, 61.907425>
}


cylinder { // Cylndr007
  <0,0,1>, <0,0,0>, 1 
  texture {
    Chrome_Metal
  }
  scale <-0.923452, 1.020257, -1760.673828>
  rotate <180.0, -89.888672, -180.0>
  translate  <-607.06894, 150.372411, 78.348255>
}


#declare Lug_Nuts2 = union {
  cylinder { // Cylndr8
    <0,0,1>, <0,0,0>, 1 
    texture {
      Chrome_Metal
    }
    rotate 88.838684*x
    translate  <0.0, -3.567831, -5.676096>
  }
  cylinder { // Cylndr9
    <0,0,1>, <0,0,0>, 1 
    texture {
      Chrome_Metal
    }
    rotate -90.0*x
    translate  <-0.185073, -4.340293, 5.671>
  }
  cylinder { // Cylndr10
    <0,0,1>, <0,0,0>, 1 
    texture {
      Chrome_Metal
    }
    rotate -90.0*x
    translate  <-5.334255, -4.320147, 0.0>
  }
  cylinder { // Cylndr11
    <0,0,1>, <0,0,0>, 1 
    texture {
      Chrome_Metal
    }
    rotate -90.0*x
    translate  <5.715273, -4.441761, 0.0>
  }
}
#declare CSG4 = union {
  superellipsoid { // Tire2
    <1.0, 0.25>
    texture {
      Dark_Gray_tex
    }
    scale <12.420939, 11.937156, 5.310634>
    rotate <-179.931274, -89.75322, 90.998634>
  }
  cylinder { // Wheel_rim2
    <0,0,1>, <0,0,0>, 1 
    scale <8.101168, 7.91326, 9.986228>
    rotate <0.000001, 89.875404, -90.0>
    translate  <-0.0, 4.378702, -0.070336>
  }
  rotate <0.089221, 0.001363, -0.875066>
}
#declare Tire_and_Wheel_Rim_Assembly2 = difference {
  object { CSG4 }
  cylinder { // wheel_rim_diffd2
    <0,0,1>, <0,0,0>, 1 
    scale <7.275869, 7.656919, 6.530165>
    rotate <89.858345, 0.0, -0.0>
    translate  <-0.0, -3.405657, -0.162174>
  }
  texture {
    Chrome_Metal
  }
  rotate <-0.089232, -0.0, 0.875067>
}
#declare Right_Rear_Wheel = union {
  object { Lug_Nuts2 }
  object { Tire_and_Wheel_Rim_Assembly2 }
  cone { // Center_Cone2
    <0,0,0>, 0.0, <0,0,1>, 1.0
    texture {
      Chrome_Metal
    }
    scale 2.535048
    rotate -92.532188*x
    translate  <0.0, -6.140191, 0.341122>
  }
  scale <1.446718, 2.179572, 1.444009>
  rotate <0.0, 9.405326, -179.74382>
  translate  <125.852212, 69.312146, 4.472049>
}
#declare Lug_Nuts3 = union {
  cylinder { // Cylndr12
    <0,0,1>, <0,0,0>, 1 
    texture {
      Chrome_Metal
    }
    rotate 88.838684*x
    translate  <0.0, -3.567831, -5.676096>
  }
  cylinder { // Cylndr13
    <0,0,1>, <0,0,0>, 1 
    texture {
      Chrome_Metal
    }
    rotate -90.0*x
    translate  <-0.185073, -4.340293, 5.671>
  }
  cylinder { // Cylndr14
    <0,0,1>, <0,0,0>, 1 
    texture {
      Chrome_Metal
    }
    rotate -90.0*x
    translate  <-5.334255, -4.320147, 0.0>
  }
  cylinder { // Cylndr15
    <0,0,1>, <0,0,0>, 1 
    texture {
      Chrome_Metal
    }
    rotate -90.0*x
    translate  <5.715273, -4.441761, 0.0>
  }
}
#declare CSG5 = union {
  superellipsoid { // Tire3
    <1.0, 0.25>
    texture {
      Dark_Gray_tex
    }
    scale <12.420939, 11.937156, 5.310634>
    rotate <-179.931274, -89.75322, 90.998634>
  }
  cylinder { // Wheel_rim3
    <0,0,1>, <0,0,0>, 1 
    scale <8.101168, 7.91326, 9.986228>
    rotate <0.000001, 89.875404, -90.0>
    translate  <-0.0, 4.378702, -0.070336>
  }
  rotate <0.089221, 0.001363, -0.875066>
}
#declare Tire_and_Wheel_Rim_Assembly3 = difference {
  object { CSG5 }
  cylinder { // wheel_rim_diffd3
    <0,0,1>, <0,0,0>, 1 
    scale <7.275869, 7.656919, 6.530165>
    rotate <89.858345, 0.0, -0.0>
    translate  <-0.0, -3.405657, -0.162174>
  }
  texture {
    Chrome_Metal
  }
  rotate <-0.089232, -0.0, 0.875067>
}
#declare Left_Rear_Wheel = union {
  object { Lug_Nuts3 }
  object { Tire_and_Wheel_Rim_Assembly3 }
  cone { // Center_Cone3
    <0,0,0>, 0.0, <0,0,1>, 1.0
    texture {
      Chrome_Metal
    }
    scale 2.535048
    rotate -92.532188*x
    translate  <0.0, -6.140191, 0.341122>
  }
  scale <1.460582, 2.179375, 1.446306>
  rotate <-0.001906, 9.405306, 0.157043>
  translate  <126.475178, -10.187498, 4.472049>
}
#declare Lug_Nuts1 = union {
  cylinder { // Cylndr4
    <0,0,1>, <0,0,0>, 1 
    texture {
      Chrome_Metal
    }
    rotate 88.838684*x
    translate  <0.0, -3.567831, -5.676096>
  }
  cylinder { // Cylndr5
    <0,0,1>, <0,0,0>, 1 
    texture {
      Chrome_Metal
    }
    rotate -90.0*x
    translate  <-0.185073, -4.340293, 5.671>
  }
  cylinder { // Cylndr6
    <0,0,1>, <0,0,0>, 1 
    texture {
      Chrome_Metal
    }
    rotate -90.0*x
    translate  <-5.334255, -4.320147, 0.0>
  }
  cylinder { // Cylndr7
    <0,0,1>, <0,0,0>, 1 
    texture {
      Chrome_Metal
    }
    rotate -90.0*x
    translate  <5.715273, -4.441761, 0.0>
  }
}
#declare CSG3 = union {
  superellipsoid { // Tire1
    <1.0, 0.25>
    texture {
      Dark_Gray_tex
    }
    scale <12.420939, 11.937156, 5.310634>
    rotate <-179.931274, -89.75322, 90.998634>
  }
  cylinder { // Wheel_rim1
    <0,0,1>, <0,0,0>, 1 
    scale <8.101168, 7.91326, 9.986228>
    rotate <0.000001, 89.875404, -90.0>
    translate  <-0.0, 4.378702, -0.070336>
  }
  rotate <0.089221, 0.001363, -0.875066>
}
#declare Tire_and_Wheel_Rim_Assembly1 = difference {
  object { CSG3 }
  cylinder { // wheel_rim_diffd1
    <0,0,1>, <0,0,0>, 1 
    scale <7.275869, 7.656919, 6.530165>
    rotate <89.858345, 0.0, -0.0>
    translate  <-0.0, -3.405657, -0.162174>
  }
  texture {
    Chrome_Metal
  }
  rotate <-0.089232, -0.0, 0.875067>
}
#declare Right_Front_Wheel = union {
  object { Lug_Nuts1 }
  object { Tire_and_Wheel_Rim_Assembly1 }
  cone { // Center_Cone1
    <0,0,0>, 0.0, <0,0,1>, 1.0
    texture {
      Chrome_Metal
    }
    scale 2.535048
    rotate -92.532188*x
    translate  <0.0, -6.140191, 0.341122>
  }
  rotate <-0.0, 9.405326, 179.129059>
  translate  <8.833294, 66.015772, -0.511683>
}
#declare Lug_Nuts = union {
  cylinder { // Cylndr003
    <0,0,1>, <0,0,0>, 1 
    texture {
      Chrome_Metal
    }
    rotate 88.838684*x
    translate  <0.0, -3.567831, -5.676096>
  }
  cylinder { // Cylndr004
    <0,0,1>, <0,0,0>, 1 
    texture {
      Chrome_Metal
    }
    rotate -90.0*x
    translate  <-0.185073, -4.340293, 5.671>
  }
  cylinder { // Cylndr005
    <0,0,1>, <0,0,0>, 1 
    texture {
      Chrome_Metal
    }
    rotate -90.0*x
    translate  <-5.334255, -4.320147, 0.0>
  }
  cylinder { // Cylndr006
    <0,0,1>, <0,0,0>, 1 
    texture {
      Chrome_Metal
    }
    rotate -90.0*x
    translate  <5.715273, -4.441761, 0.0>
  }
}
#declare CSG002 = union {
  superellipsoid { // Tire
    <1.0, 0.25>
    texture {
      Dark_Gray_tex
    }
    scale <12.420939, 11.937156, 5.310634>
    rotate <-179.931274, -89.75322, 90.998634>
  }
  cylinder { // Wheel_rim
    <0,0,1>, <0,0,0>, 1 
    scale <8.101168, 7.91326, 9.986228>
    rotate <0.000001, 89.875404, -90.0>
    translate  <-0.0, 4.378702, -0.070336>
  }
  rotate <0.089221, 0.001363, -0.875066>
}
#declare Tire_and_Wheel_Rim_Assembly = difference {
  object { CSG002 }
  cylinder { // wheel_rim_diffd
    <0,0,1>, <0,0,0>, 1 
    scale <7.275869, 7.656919, 6.530165>
    rotate <89.858345, 0.0, -0.0>
    translate  <-0.0, -3.405657, -0.162174>
  }
  texture {
    Chrome_Metal
  }
  rotate <-0.089232, -0.0, 0.875067>
}
#declare Left_Front_Wheel = union {
  object { Lug_Nuts }
  object { Tire_and_Wheel_Rim_Assembly }
  cone { // Center_Cone
    <0,0,0>, 0.0, <0,0,1>, 1.0
    texture {
      Chrome_Metal
    }
    scale 2.535048
    rotate -92.532188*x
    translate  <0.0, -6.140191, 0.341122>
  }
  rotate -1.954782*z
  translate  <8.833294, -6.62497, 0.0>
}
#declare Wheel_Group = union {
  object { Right_Rear_Wheel }
  object { Left_Rear_Wheel }
  object { Right_Front_Wheel }
  object { Left_Front_Wheel }
}
#declare Steering_Geometry_pieces = union {
  cylinder { // Cylndr2
    <0,0,1>, <0,0,0>, 1 
    texture {
      Chrome_Metal
    }
    scale <-0.423613, -1.0, -19.506973>
    rotate 86.71125*x
    translate  <13.013945, 43.59829, -2.461566>
  }
  cylinder { // Cylndr3
    <0,0,1>, <0,0,0>, 1 
    texture {
      Chrome_Metal
    }
    scale <-0.423613, -1.0, -19.506973>
    rotate 86.71125*x
    translate  <5.375476, 46.660395, 0.741564>
  }
  cylinder { // Cylndr16
    <0,0,1>, <0,0,0>, 1 
    texture {
      Chrome_Metal
    }
    scale <-0.423613, -1.0, -19.506973>
    rotate 86.71125*x
    translate  <8.804512, 46.769756, 2.343129>
  }
  cylinder { // Cylndr17
    <0,0,1>, <0,0,0>, 1 
    texture {
      Chrome_Metal
    }
    scale <-0.423613, -1.0, -19.506973>
    rotate <95.487236, -0.0, -0.0>
    translate  <3.499548, -4.266967, -3.692349>
  }
  cylinder { // Cylndr18
    <0,0,1>, <0,0,0>, 1 
    texture {
      Chrome_Metal
    }
    scale <-0.423613, -1.0, -19.506973>
    rotate <95.487236, -0.0, -0.0>
    translate  <6.346775, -4.266967, -1.023074>
  }
  cylinder { // Cylndr001
    <0,0,1>, <0,0,0>, 1 
    texture {
      Chrome_Metal
    }
    scale <-0.423613, -1.0, -19.506973>
    rotate 86.71125*x
    translate  <1.20297, 46.769756, -2.461566>
  }
}
#declare Airfoil_Bracket = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.000000, -2.000000, 0.000000>, <-1.000000, -2.000000, 0.000000>, <0.000000, -2.000000, 0.000000>, <1.000000, -2.000000, 0.000000>, 
      <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, 
      <-2.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <0.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, 
      <-2.000000, 1.000000, 0.000000>, <-1.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <1.000000, 1.000000, 0.000000>
    }
  }
  texture {
    Chrome_Metal
  }
  scale <8.690467, 2.747581, 3.575782>
  rotate <84.24408, -18.144842, 1.803238>
  translate  <132.495949, 12.067434, 28.598859>
}
#declare Airfoil_Bracket_right = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.000000, -2.000000, 0.000000>, <-1.000000, -2.000000, 0.000000>, <0.000000, -2.000000, 0.000000>, <1.000000, -2.000000, 0.000000>, 
      <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, 
      <-2.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <0.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, 
      <-2.000000, 1.000000, 0.000000>, <-1.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <1.000000, 1.000000, 0.000000>
    }
  }
  texture {
    Chrome_Metal
  }
  scale <8.690467, 2.747581, 3.575782>
  rotate <84.544968, -18.172415, 0.390501>
  translate  <133.461344, 44.890853, 28.598859>
}
#declare Airfoil = union {
  object { Airfoil_Bracket }
  object { Rear_Airfoil }
  object { Airfoil_Bracket_right }
}
#declare Left_Side_of_Car = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-4.915074, -5.278436, 1.188960>, <-3.915074, -5.013289, 0.000000>, <-2.741220, -4.919645, 0.000000>, <-1.873442, -4.948791, 0.000000>, 
      <-4.830149, -4.849257, 0.000000>, <-3.915074, -4.472011, 0.000000>, <-2.834151, -4.397917, 0.000000>, <-1.919908, -4.330276, 0.000000>, 
      <-5.000000, -4.976950, 1.188960>, <-3.915074, -4.252513, 0.000000>, <-2.741220, -3.662695, 0.000000>, <-1.873442, -3.605014, 0.000000>, 
      <-4.934003, -4.703423, 1.188960>, <-4.180082, -3.452975, 0.000000>, <-2.787686, -3.327775, 0.000000>, <-1.918345, -3.246958, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-4.934003, -4.703423, 1.188960>, <-4.180082, -3.452975, 0.000000>, <-2.787686, -3.327775, 0.000000>, <-1.918345, -3.246958, 0.000000>, 
      <-4.868007, -4.429896, 1.188960>, <-4.445090, -2.653437, 0.000000>, <-2.834151, -2.992855, 0.000000>, <-1.963248, -2.888903, 0.000000>, 
      <-5.037858, -4.449004, 1.188960>, <-4.530015, -2.250065, 0.000000>, <-2.834151, -2.364380, 0.000000>, <-1.963248, -2.217014, 0.000000>, 
      <-5.018929, -4.718285, 1.188960>, <-4.445090, -1.777740, 0.000000>, <-2.834151, -1.735905, 0.000000>, <-1.963248, -1.545125, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-5.018929, -4.718285, 1.188960>, <-4.445090, -1.777740, 0.000000>, <-2.834151, -1.735905, 0.000000>, <-1.963248, -1.545125, 0.000000>, 
      <-5.000000, -4.987565, 1.188960>, <-4.360164, -1.305415, 0.000000>, <-2.834151, -1.107430, 0.000000>, <-1.963248, -0.873237, 0.000000>, 
      <-4.952933, -4.081700, 1.188960>, <-4.530015, -0.810106, 0.000000>, <-2.741220, -0.532329, 0.000000>, <-1.873442, -0.258408, 0.000000>, 
      <-4.830149, -4.940856, 1.188960>, <-4.339378, 0.190794, 0.000000>, <-2.741220, 0.096146, 0.000000>, <-1.873442, 0.413480, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.873442, -4.948791, 0.000000>, <-1.005664, -4.977937, 0.000000>, <0.014998, -4.977937, 0.000000>, <1.049962, -4.948481, 0.000000>, 
      <-1.919908, -4.330276, 0.000000>, <-1.005664, -4.262635, 0.000000>, <0.014998, -4.190946, 0.000000>, <1.049962, -4.148008, 0.000000>, 
      <-1.873442, -3.605014, 0.000000>, <-1.005664, -3.547332, 0.000000>, <0.014998, -3.496415, 0.000000>, <1.049962, -3.393766, 0.000000>, 
      <-1.918345, -3.246958, 0.000000>, <-1.049004, -3.166142, 0.000000>, <-0.028343, -3.126293, 0.000000>, <1.028292, -2.801728, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.918345, -3.246958, 0.000000>, <-1.049004, -3.166142, 0.000000>, <-0.028343, -3.126293, 0.000000>, <1.028292, -2.801728, 0.000000>, 
      <-1.963248, -2.888903, 0.000000>, <-1.092345, -2.784951, 0.000000>, <-0.071683, -2.756172, 0.000000>, <1.006621, -2.209691, 0.000000>, 
      <-1.963248, -2.217014, 0.000000>, <-1.092345, -2.069648, 0.000000>, <-0.071683, -2.061641, 0.000000>, <1.006621, -1.455449, 0.000000>, 
      <-1.963248, -1.545125, 0.000000>, <-1.092345, -1.354346, 0.000000>, <-0.071683, -1.367110, 0.000000>, <1.006621, -0.701207, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.963248, -1.545125, 0.000000>, <-1.092345, -1.354346, 0.000000>, <-0.071683, -1.367110, 0.000000>, <1.006621, -0.701207, 0.000000>, 
      <-1.963248, -0.873237, 0.000000>, <-1.092345, -0.639043, 0.000000>, <-0.071683, -0.672579, 0.000000>, <1.006621, 0.053036, 0.000000>, 
      <-1.873442, -0.258408, 0.000000>, <-1.005664, 0.015512, 0.000000>, <0.014998, -0.037031, 0.000000>, <1.049962, 0.777786, 0.000000>, 
      <-1.873442, 0.413480, 0.000000>, <-1.005664, 0.730814, 0.000000>, <0.014998, 0.657499, 0.000000>, <1.057779, 1.485125, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.049962, -4.948481, 0.000000>, <2.084926, -4.919024, 0.000000>, <3.000000, -5.000000, 0.000000>, <4.084926, -4.952776, 0.000000>, 
      <1.049962, -4.148008, 0.000000>, <2.084926, -4.105071, 0.000000>, <3.000000, -4.000000, 0.000000>, <4.084926, -3.906653, 0.000000>, 
      <1.049962, -3.393766, 0.000000>, <2.084926, -3.291117, 0.000000>, <3.000000, -3.000000, 0.000000>, <4.084926, -2.860530, 0.000000>, 
      <1.028292, -2.801728, 0.000000>, <2.084926, -2.477164, 0.000000>, <3.000000, -2.000000, 0.000000>, <4.084926, -1.814407, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.028292, -2.801728, 0.000000>, <2.084926, -2.477164, 0.000000>, <3.000000, -2.000000, 0.000000>, <4.084926, -1.814407, 0.000000>, 
      <1.006621, -2.209691, 0.000000>, <2.084926, -1.663210, 0.000000>, <3.000000, -1.000000, 0.000000>, <4.084926, -0.768284, 0.000000>, 
      <1.006621, -1.455449, 0.000000>, <2.084926, -0.849257, 0.000000>, <3.000000, 0.000000, 0.000000>, <4.084926, 0.277838, 0.000000>, 
      <1.006621, -0.701207, 0.000000>, <2.084926, -0.035303, 0.000000>, <3.000000, 1.000000, 0.000000>, <4.084926, 1.323961, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.006621, -0.701207, 0.000000>, <2.084926, -0.035303, 0.000000>, <3.000000, 1.000000, 0.000000>, <4.084926, 1.323961, 0.000000>, 
      <1.006621, 0.053036, 0.000000>, <2.084926, 0.778650, 0.000000>, <3.000000, 2.000000, 0.000000>, <4.084926, 2.370084, 0.000000>, 
      <1.049962, 0.777786, 0.000000>, <2.084926, 1.592604, 0.000000>, <3.000000, 3.000000, 0.000000>, <4.100560, 3.697626, 0.000000>, 
      <1.057779, 1.485125, 0.000000>, <2.100560, 2.312751, 0.000000>, <3.031269, 3.656044, 0.000000>, <4.100560, 4.743748, 0.000000>
    }
  }
  scale <17.536554, 3.83129, 3.207767>
  rotate <90.051147, -0.0, -0.0>
  translate  <77.407219, 7.361078, 8.098565>
}
#declare Top_of_body = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.245097, -2.182966, -2.231704>, <-1.755184, -1.936129, 0.039852>, <-0.348694, -2.000000, -0.000000>, <0.466403, -2.000000, 0.119556>, 
      <-2.245097, -1.020258, -2.231704>, <-1.755184, -0.968064, 0.039852>, <-0.348694, -1.000000, -0.000000>, <0.466403, -1.000000, 0.119556>, 
      <-2.245097, 0.142450, -2.231704>, <-1.755184, 0.000000, 0.039852>, <-0.348694, 0.000000, -0.000000>, <0.466403, 0.000000, 0.119556>, 
      <-2.245097, 1.305159, -2.231704>, <-1.755184, 0.968064, 0.039852>, <-0.348694, 1.000000, -0.000000>, <0.466403, 1.000000, 0.119556>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.466403, -2.000000, 0.119556>, <1.281499, -2.000000, 0.239111>, <2.321160, -2.000000, 1.235408>, <2.699009, -1.936129, 1.594074>, 
      <0.466403, -1.000000, 0.119556>, <1.281499, -1.000000, 0.239111>, <2.321160, -1.000000, 1.235408>, <2.699009, -0.968064, 1.594074>, 
      <0.466403, 0.000000, 0.119556>, <1.281499, 0.000000, 0.239111>, <2.321160, 0.000000, 1.235408>, <2.699009, 0.000000, 1.594074>, 
      <0.466403, 1.000000, 0.119556>, <1.281499, 1.000000, 0.239111>, <2.321160, 1.000000, 1.235408>, <2.699009, 0.968064, 1.594074>
    }
  }
  texture {
    CYAN_METALIC
  }
  scale <32.652637, 15.722157, 9.833294>
  translate  <61.096949, 37.541499, 10.590431>
}
#declare Bottom_of_Body = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.000000, -2.000000, 0.000000>, <-1.000000, -2.000000, 0.000000>, <0.000000, -2.000000, 0.000000>, <1.000000, -2.000000, 0.000000>, 
      <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, 
      <-2.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <0.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, 
      <-2.000000, 1.000000, 0.000000>, <-1.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <1.000000, 1.000000, 0.000000>
    }
  }
  scale <53.209152, 15.667654, 13.459331>
  translate  <94.844767, 36.805391, -10.590431>
}
#declare Car_Body_Parts = union {
  object { Left_Side_of_Car }
  object { Top_of_body }
  object { Bottom_of_Body }
  cone { // Windshield
    <0,0,0>, 0.0, <0,0,1>, 1.0
    open
    scale 10.641703
    rotate <-180.0, 88.077217, -180.0>
    translate  <50.816398, 28.96184, 10.656848>
  }
  box { // Cube49
    <-1, -1, -1>, <1, 1, 1>
    texture {
      CYAN_METALIC
    }
    scale <40.537151, 12.93154, 9.550411>
    translate  <66.200165, 60.337168, -1.420913>
  }
  box { // Cube002
    <-1, -1, -1>, <1, 1, 1>
    texture {
      CYAN_METALIC
    }
    scale <40.779621, 14.379631, 9.188951>
    translate  <66.106108, -1.448092, -1.420913>
  }
  box { // Cube003
    <-1, -1, -1>, <1, 1, 1>
    texture {
      CYAN_METALIC
    }
    scale <-39.1735, -15.894406, -5.050315>
    rotate <180.0, 4.564932, 180.0>
    translate  <68.600413, 0.0, 6.448363>
  }
  box { // Cube50
    <-1, -1, -1>, <1, 1, 1>
    texture {
      CYAN_METALIC
    }
    scale <-40.881107, -15.894406, -4.946894>
    rotate <-180.0, 3.465884, -180.0>
    translate  <66.749127, 57.440984, 5.421921>
  }
  cylinder { // Cockpit_front_panel
    <0,0,1>, <0,0,0>, 1 
    texture {
      CYAN_METALIC
    }
    scale <8.225951, 9.205854, 39.260609>
    rotate <0.0, 76.983231, 0.0>
    translate  <20.057773, 28.96184, -2.168769>
  }
  cylinder { // Cockpit_Rear_piece
    <0,0,1>, <0,0,0>, 1 
    texture {
      CYAN_METALIC
    }
    scale <9.861854, 9.205854, 48.86237>
    rotate <180.0, 89.749306, 180.0>
    translate  <81.144752, 28.96184, 9.759458>
  }
  texture {
    CYAN_METALIC
  }
}
#declare Headlamp_right = union {
  sphere { // Lamp_housing1
    <0,0,0>,1
    texture {
      Plexiglas
    }
    hollow
    scale 2.691443
    translate  <35.862302, 76.399403, 161.491623>
  }
  translate  <-35.661688, -33.075543, -161.033505>
}
#declare Headlamp_left = union {
  sphere { // Lamp_housing2
    <0,0,0>,1
    texture {
      Plexiglas
    }
    hollow
    scale 3.055632
    translate  <34.405546, 76.399403, 160.763245>
  }
  translate  <-36.492117, -60.479676, -161.033505>
}
union { // Blue_Race_Car
  object { Wheel_Group }
  object { Steering_Geometry_pieces }
  object { Airfoil }
  object { Car_Body_Parts }
  object { Headlamp_right }
  object { Headlamp_left }
  object { Driver_Helmet1 }
  object { Cylndr008 }
  object { Cylndr65 }
  translate  <-185.017108, -135.149604, 0.0>
}


union { // Building
  box { // Roof_on_building
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Dark_Gray_tex
    }
    scale <266.937683, 167.058533, 4.843013>
    rotate -31.336412*z
    translate  <1004.101393, 637.293844, 119.000445>
  }
  box { // Background_Building
    <-1, -1, -1>, <1, 1, 1>
    texture {
      BROWN_BRICK
    }
    scale <253.497223, 144.720367, 119.491821>
    rotate -31.224781*z
    translate  <1011.984194, 646.901288, 0.0>
  }
}


#declare Lamp_Group = union {
  sphere { // Lamp_housing
    <0,0,0>,1
    texture {
      Plexiglas
    }
    hollow
    scale 4.512388
    translate  <35.498113, 76.399403, 160.399056>
  }
  cylinder { // Upright_tube
    <0,0,1>, <0,0,0>, 1 
    texture {
      Chrome_Metal
    }
    scale <0.599336, 1.0, 169.386017>
    translate  <36.53178, 150.516636, -12.816365>
  }
  cylinder { // Cross_member_tube
    <0,0,1>, <0,0,0>, 1 
    texture {
      Chrome_Metal
    }
    scale <-40.807064, -1.0, -1.341592>
    rotate -90.973305*z
    translate  <36.137866, 114.989163, 160.399056>
  }
}
#declare Lamp_Group1 = union {
  sphere { // Lamp_housing3
    <0,0,0>,1
    texture {
      Plexiglas
    }
    hollow
    scale 4.512388
    translate  <35.498113, 76.399403, 160.399056>
  }
}
#declare Light_Standards1 = union {
  cylinder { // Upright_tube1
    <0,0,1>, <0,0,0>, 1 
    texture {
      Chrome_Metal
    }
    scale <0.599336, 1.0, 169.386017>
    translate  <36.53178, 150.516636, -12.816365>
  }
  cylinder { // Cross_member_tube1
    <0,0,1>, <0,0,0>, 1 
    texture {
      Chrome_Metal
    }
    scale <-40.807064, -1.0, -1.341592>
    rotate -90.973305*z
    translate  <36.137866, 114.989163, 160.399056>
  }
  object { Lamp_Group1 }
  translate  <109.620914, 0.0, 5.098647>
}
#declare Lamp_Group2 = union {
  sphere { // Lamp_housing4
    <0,0,0>,1
    texture {
      Plexiglas
    }
    hollow
    scale 4.512388
    translate  <35.498113, 76.399403, 160.399056>
  }
}
#declare Light_Standards2 = union {
  cylinder { // Upright_tube2
    <0,0,1>, <0,0,0>, 1 
    texture {
      Chrome_Metal
    }
    scale <0.599336, 1.0, 169.386017>
    translate  <36.53178, 150.516636, -12.816365>
  }
  cylinder { // Cross_member_tube2
    <0,0,1>, <0,0,0>, 1 
    texture {
      Chrome_Metal
    }
    scale <-40.807064, -1.0, -1.341592>
    rotate -90.973305*z
    translate  <36.137866, 114.989163, 160.399056>
  }
  object { Lamp_Group2 }
  translate  <255.35925, 0.0, 1.544054>
}
#declare Lamp_Group3 = union {
  sphere { // Lamp_housing5
    <0,0,0>,1
    texture {
      Plexiglas
    }
    hollow
    scale 4.512388
    translate  <35.498113, 76.399403, 160.399056>
  }
}
#declare Light_Standards3 = union {
  cylinder { // Upright_tube3
    <0,0,1>, <0,0,0>, 1 
    texture {
      Chrome_Metal
    }
    scale <0.599336, 1.0, 169.386017>
    translate  <36.53178, 150.516636, -12.816365>
  }
  cylinder { // Cross_member_tube3
    <0,0,1>, <0,0,0>, 1 
    texture {
      Chrome_Metal
    }
    scale <-40.807064, -1.0, -1.341592>
    rotate -90.973305*z
    translate  <36.137866, 114.989163, 160.399056>
  }
  object { Lamp_Group3 }
  translate  <411.761367, 0.0, 1.544054>
}
#declare Lamp_Group4 = union {
  sphere { // Lamp_housing6
    <0,0,0>,1
    texture {
      Plexiglas
    }
    hollow
    scale 4.512388
    translate  <35.498113, 76.399403, 160.399056>
  }
}
#declare Light_Standards4 = union {
  cylinder { // Upright_tube4
    <0,0,1>, <0,0,0>, 1 
    texture {
      Chrome_Metal
    }
    scale <0.599336, 1.0, 169.386017>
    translate  <36.53178, 150.516636, -12.816365>
  }
  cylinder { // Cross_member_tube4
    <0,0,1>, <0,0,0>, 1 
    texture {
      Chrome_Metal
    }
    scale <-40.807064, -1.0, -1.341592>
    rotate -90.973305*z
    translate  <36.137866, 114.989163, 160.399056>
  }
  object { Lamp_Group4 }
  translate  <585.936451, 0.0, 5.098647>
}
#declare Lamp_Group5 = union {
  sphere { // Lamp_housing7
    <0,0,0>,1
    texture {
      Plexiglas
    }
    hollow
    scale 4.512388
    translate  <35.498113, 76.399403, 160.399056>
  }
}
#declare Light_Standards5 = union {
  cylinder { // Upright_tube5
    <0,0,1>, <0,0,0>, 1 
    texture {
      Chrome_Metal
    }
    scale <0.599336, 1.0, 169.386017>
    translate  <36.53178, 150.516636, -12.816365>
  }
  cylinder { // Cross_member_tube5
    <0,0,1>, <0,0,0>, 1 
    texture {
      Chrome_Metal
    }
    scale <-40.807064, -1.0, -1.341592>
    rotate -90.973305*z
    translate  <36.137866, 114.989163, 160.399056>
  }
  object { Lamp_Group5 }
  translate  <-167.637383, 0.0, 1.544054>
}
#declare Lamp_Group6 = union {
  sphere { // Lamp_housing8
    <0,0,0>,1
    texture {
      Plexiglas
    }
    hollow
    scale 4.512388
    translate  <35.498113, 76.399403, 160.399056>
  }
  cylinder { // Upright_tube6
    <0,0,1>, <0,0,0>, 1 
    texture {
      Chrome_Metal
    }
    scale <0.599336, 1.0, 169.386017>
    translate  <36.53178, 150.516636, -12.816365>
  }
  cylinder { // Cross_member_tube6
    <0,0,1>, <0,0,0>, 1 
    texture {
      Chrome_Metal
    }
    scale <-40.807064, -1.0, -1.341592>
    rotate -90.973305*z
    translate  <36.137866, 114.989163, 160.399056>
  }
}
#declare Lamp_Group7 = union {
  sphere { // Lamp_housing9
    <0,0,0>,1
    texture {
      Plexiglas
    }
    hollow
    scale 4.512388
    translate  <35.498113, 76.399403, 160.399056>
  }
}
#declare Light_Standards6 = union {
  cylinder { // Upright_tube7
    <0,0,1>, <0,0,0>, 1 
    texture {
      Chrome_Metal
    }
    scale <0.599336, 1.0, 169.386017>
    translate  <36.53178, 150.516636, -12.816365>
  }
  cylinder { // Cross_member_tube7
    <0,0,1>, <0,0,0>, 1 
    texture {
      Chrome_Metal
    }
    scale <-40.807064, -1.0, -1.341592>
    rotate -90.973305*z
    translate  <36.137866, 114.989163, 160.399056>
  }
  object { Lamp_Group7 }
  translate  <109.620914, 0.0, 5.098647>
}
#declare Lamp_Group8 = union {
  sphere { // Lamp_housing10
    <0,0,0>,1
    texture {
      Plexiglas
    }
    hollow
    scale 4.512388
    translate  <35.498113, 76.399403, 160.399056>
  }
}
#declare Light_Standards7 = union {
  cylinder { // Upright_tube8
    <0,0,1>, <0,0,0>, 1 
    texture {
      Chrome_Metal
    }
    scale <0.599336, 1.0, 169.386017>
    translate  <36.53178, 150.516636, -12.816365>
  }
  cylinder { // Cross_member_tube8
    <0,0,1>, <0,0,0>, 1 
    texture {
      Chrome_Metal
    }
    scale <-40.807064, -1.0, -1.341592>
    rotate -90.973305*z
    translate  <36.137866, 114.989163, 160.399056>
  }
  object { Lamp_Group8 }
  translate  <255.35925, 0.0, 1.544054>
}
#declare Lamp_Group9 = union {
  sphere { // Lamp_housing11
    <0,0,0>,1
    texture {
      Plexiglas
    }
    hollow
    scale 4.512388
    translate  <35.498113, 76.399403, 160.399056>
  }
}
#declare Light_Standards8 = union {
  cylinder { // Upright_tube9
    <0,0,1>, <0,0,0>, 1 
    texture {
      Chrome_Metal
    }
    scale <0.599336, 1.0, 169.386017>
    translate  <36.53178, 150.516636, -12.816365>
  }
  cylinder { // Cross_member_tube9
    <0,0,1>, <0,0,0>, 1 
    texture {
      Chrome_Metal
    }
    scale <-40.807064, -1.0, -1.341592>
    rotate -90.973305*z
    translate  <36.137866, 114.989163, 160.399056>
  }
  object { Lamp_Group9 }
  translate  <411.761367, 0.0, 1.544054>
}
#declare Lamp_Group10 = union {
  sphere { // Lamp_housing12
    <0,0,0>,1
    texture {
      Plexiglas
    }
    hollow
    scale 4.512388
    translate  <35.498113, 76.399403, 160.399056>
  }
}
#declare Light_Standards9 = union {
  cylinder { // Upright_tube10
    <0,0,1>, <0,0,0>, 1 
    texture {
      Chrome_Metal
    }
    scale <0.599336, 1.0, 169.386017>
    translate  <36.53178, 150.516636, -12.816365>
  }
  cylinder { // Cross_member_tube10
    <0,0,1>, <0,0,0>, 1 
    texture {
      Chrome_Metal
    }
    scale <-40.807064, -1.0, -1.341592>
    rotate -90.973305*z
    translate  <36.137866, 114.989163, 160.399056>
  }
  object { Lamp_Group10 }
  translate  <585.936451, 0.0, 5.098647>
}
#declare Lamp_Group11 = union {
  sphere { // Lamp_housing13
    <0,0,0>,1
    texture {
      Plexiglas
    }
    hollow
    scale 4.512388
    translate  <35.498113, 76.399403, 160.399056>
  }
}
#declare Light_Standards10 = union {
  cylinder { // Upright_tube11
    <0,0,1>, <0,0,0>, 1 
    texture {
      Chrome_Metal
    }
    scale <0.599336, 1.0, 169.386017>
    translate  <36.53178, 150.516636, -12.816365>
  }
  cylinder { // Cross_member_tube11
    <0,0,1>, <0,0,0>, 1 
    texture {
      Chrome_Metal
    }
    scale <-40.807064, -1.0, -1.341592>
    rotate -90.973305*z
    translate  <36.137866, 114.989163, 160.399056>
  }
  object { Lamp_Group11 }
  translate  <-167.637383, 0.0, 1.544054>
}
#declare Light_Standards11 = union {
  object { Lamp_Group6 }
  object { Light_Standards6 }
  object { Light_Standards7 }
  object { Light_Standards8 }
  object { Light_Standards9 }
  object { Light_Standards10 }
  translate  874.430015*x
}
union { // Light_Standards
  object { Lamp_Group }
  object { Light_Standards1 }
  object { Light_Standards2 }
  object { Light_Standards3 }
  object { Light_Standards4 }
  object { Light_Standards5 }
  object { Light_Standards11 }
  translate  7.0*x
}


#declare Wall1 = union {
  box { // Cube5
    <-1, -1, -1>, <1, 1, 1>
    texture {
      BROWN_BRICK
    }
    scale <12.557552, 3.865225, 13.073984>
    rotate 180.0*x
    translate  <74.071332, 150.89307, 0.162174>
  }
  box { // Cube6
    <-1, -1, -1>, <1, 1, 1>
    texture {
      BROWN_BRICK
    }
    scale <12.557552, 3.865225, 13.073984>
    rotate 180.0*x
    translate  <24.235487, 150.89307, 0.162174>
  }
  box { // Cube7
    <-1, -1, -1>, <1, 1, 1>
    texture {
      BROWN_BRICK
    }
    scale <12.557552, 3.865225, 13.073984>
    rotate 180.0*x
    translate  <49.387387, 150.89307, 0.162174>
  }
  box { // Cube8
    <-1, -1, -1>, <1, 1, 1>
    texture {
      BROWN_BRICK
    }
    scale <12.557552, 3.865225, 13.073984>
    rotate 180.0*x
    translate  <100.37011, 150.89307, 0.162174>
  }
  translate  <99.935356, 0.0, 0.0>
}
#declare Wall2 = union {
  box { // Cube13
    <-1, -1, -1>, <1, 1, 1>
    texture {
      BROWN_BRICK
    }
    scale <12.557552, 3.865225, 13.073984>
    rotate 180.0*x
    translate  <74.071332, 150.89307, 0.162174>
  }
  box { // Cube14
    <-1, -1, -1>, <1, 1, 1>
    texture {
      BROWN_BRICK
    }
    scale <12.557552, 3.865225, 13.073984>
    rotate 180.0*x
    translate  <25.541627, 150.89307, 0.162174>
  }
  box { // Cube15
    <-1, -1, -1>, <1, 1, 1>
    texture {
      BROWN_BRICK
    }
    scale <12.557552, 3.865225, 13.073984>
    rotate 180.0*x
    translate  <50.460287, 150.89307, 0.162174>
  }
  translate  <99.935356, 0.0, 0.0>
}
#declare Wall3 = union {
  box { // Cube9
    <-1, -1, -1>, <1, 1, 1>
    texture {
      BROWN_BRICK
    }
    scale <12.557552, 3.865225, 13.073984>
    rotate 180.0*x
    translate  <74.071332, 150.89307, 0.162174>
  }
  box { // Cube10
    <-1, -1, -1>, <1, 1, 1>
    texture {
      BROWN_BRICK
    }
    scale <12.557552, 3.865225, 13.073984>
    rotate 180.0*x
    translate  <25.541627, 150.89307, 0.162174>
  }
  box { // Cube11
    <-1, -1, -1>, <1, 1, 1>
    texture {
      BROWN_BRICK
    }
    scale <12.557552, 3.865225, 13.073984>
    rotate 180.0*x
    translate  <50.460287, 150.89307, 0.162174>
  }
  box { // Cube12
    <-1, -1, -1>, <1, 1, 1>
    texture {
      BROWN_BRICK
    }
    scale <12.557552, 3.865225, 13.073984>
    rotate 180.0*x
    translate  <100.37011, 150.89307, 0.162174>
  }
  object { Wall2 }
  translate  -199.119317*x
}
#declare Wall8 = union {
  box { // Cube37
    <-1, -1, -1>, <1, 1, 1>
    texture {
      BROWN_BRICK
    }
    scale <12.557552, 3.865225, 13.073984>
    rotate 180.0*x
    translate  <74.071332, 150.89307, 0.162174>
  }
  box { // Cube38
    <-1, -1, -1>, <1, 1, 1>
    texture {
      BROWN_BRICK
    }
    scale <12.557552, 3.865225, 13.073984>
    rotate 180.0*x
    translate  <25.541627, 150.89307, 0.162174>
  }
  box { // Cube39
    <-1, -1, -1>, <1, 1, 1>
    texture {
      BROWN_BRICK
    }
    scale <12.557552, 3.865225, 13.073984>
    rotate 180.0*x
    translate  <50.460287, 150.89307, 0.162174>
  }
  box { // Cube40
    <-1, -1, -1>, <1, 1, 1>
    texture {
      BROWN_BRICK
    }
    scale <12.557552, 3.865225, 13.073984>
    rotate 180.0*x
    translate  <100.37011, 150.89307, 0.162174>
  }
  translate  <99.935356, 0.0, 0.0>
}
#declare Wall9 = union {
  box { // Cube45
    <-1, -1, -1>, <1, 1, 1>
    texture {
      BROWN_BRICK
    }
    scale <12.557552, 3.865225, 13.073984>
    rotate 180.0*x
    translate  <74.071332, 150.89307, 0.162174>
  }
  box { // Cube46
    <-1, -1, -1>, <1, 1, 1>
    texture {
      BROWN_BRICK
    }
    scale <12.557552, 3.865225, 13.073984>
    rotate 180.0*x
    translate  <25.541627, 150.89307, 0.162174>
  }
  box { // Cube47
    <-1, -1, -1>, <1, 1, 1>
    texture {
      BROWN_BRICK
    }
    scale <12.557552, 3.865225, 13.073984>
    rotate 180.0*x
    translate  <50.460287, 150.89307, 0.162174>
  }
  box { // Cube48
    <-1, -1, -1>, <1, 1, 1>
    texture {
      BROWN_BRICK
    }
    scale <12.557552, 3.865225, 13.073984>
    rotate 180.0*x
    translate  <100.37011, 150.89307, 0.162174>
  }
  translate  <99.935356, 0.0, 0.0>
}
#declare Wall10 = union {
  box { // Cube41
    <-1, -1, -1>, <1, 1, 1>
    texture {
      BROWN_BRICK
    }
    scale <12.557552, 3.865225, 13.073984>
    rotate 180.0*x
    translate  <74.071332, 150.89307, 0.162174>
  }
  box { // Cube42
    <-1, -1, -1>, <1, 1, 1>
    texture {
      BROWN_BRICK
    }
    scale <12.557552, 3.865225, 13.073984>
    rotate 180.0*x
    translate  <25.541627, 150.89307, 0.162174>
  }
  box { // Cube43
    <-1, -1, -1>, <1, 1, 1>
    texture {
      BROWN_BRICK
    }
    scale <12.557552, 3.865225, 13.073984>
    rotate 180.0*x
    translate  <50.460287, 150.89307, 0.162174>
  }
  box { // Cube44
    <-1, -1, -1>, <1, 1, 1>
    texture {
      BROWN_BRICK
    }
    scale <12.557552, 3.865225, 13.073984>
    rotate 180.0*x
    translate  <100.37011, 150.89307, 0.162174>
  }
  object { Wall9 }
  translate  -199.119317*x
}
#declare Wall4 = union {
  box { // Cube21
    <-1, -1, -1>, <1, 1, 1>
    texture {
      BROWN_BRICK
    }
    scale <12.557552, 3.865225, 13.073984>
    rotate 180.0*x
    translate  <74.071332, 150.89307, 0.162174>
  }
  box { // Cube22
    <-1, -1, -1>, <1, 1, 1>
    texture {
      BROWN_BRICK
    }
    scale <12.557552, 3.865225, 13.073984>
    rotate 180.0*x
    translate  <25.541627, 150.89307, 0.162174>
  }
  box { // Cube23
    <-1, -1, -1>, <1, 1, 1>
    texture {
      BROWN_BRICK
    }
    scale <12.557552, 3.865225, 13.073984>
    rotate 180.0*x
    translate  <50.460287, 150.89307, 0.162174>
  }
  box { // Cube24
    <-1, -1, -1>, <1, 1, 1>
    texture {
      BROWN_BRICK
    }
    scale <12.557552, 3.865225, 13.073984>
    rotate 180.0*x
    translate  <100.37011, 150.89307, 0.162174>
  }
  translate  <99.935356, 0.0, 0.0>
}
#declare Wall5 = union {
  box { // Cube29
    <-1, -1, -1>, <1, 1, 1>
    texture {
      BROWN_BRICK
    }
    scale <12.557552, 3.865225, 13.073984>
    rotate 180.0*x
    translate  <74.071332, 150.89307, 0.162174>
  }
  box { // Cube30
    <-1, -1, -1>, <1, 1, 1>
    texture {
      BROWN_BRICK
    }
    scale <12.557552, 3.865225, 13.073984>
    rotate 180.0*x
    translate  <25.541627, 150.89307, 0.162174>
  }
  box { // Cube31
    <-1, -1, -1>, <1, 1, 1>
    texture {
      BROWN_BRICK
    }
    scale <12.557552, 3.865225, 13.073984>
    rotate 180.0*x
    translate  <50.460287, 150.89307, 0.162174>
  }
  box { // Cube32
    <-1, -1, -1>, <1, 1, 1>
    texture {
      BROWN_BRICK
    }
    scale <12.557552, 3.865225, 13.073984>
    rotate 180.0*x
    translate  <100.37011, 150.89307, 0.162174>
  }
  translate  <99.935356, 0.0, 0.0>
}
#declare Wall6 = union {
  box { // Cube25
    <-1, -1, -1>, <1, 1, 1>
    texture {
      BROWN_BRICK
    }
    scale <12.557552, 3.865225, 13.073984>
    rotate 180.0*x
    translate  <74.071332, 150.89307, 0.162174>
  }
  box { // Cube26
    <-1, -1, -1>, <1, 1, 1>
    texture {
      BROWN_BRICK
    }
    scale <12.557552, 3.865225, 13.073984>
    rotate 180.0*x
    translate  <25.541627, 150.89307, 0.162174>
  }
  box { // Cube27
    <-1, -1, -1>, <1, 1, 1>
    texture {
      BROWN_BRICK
    }
    scale <12.557552, 3.865225, 13.073984>
    rotate 180.0*x
    translate  <50.460287, 150.89307, 0.162174>
  }
  box { // Cube28
    <-1, -1, -1>, <1, 1, 1>
    texture {
      BROWN_BRICK
    }
    scale <12.557552, 3.865225, 13.073984>
    rotate 180.0*x
    translate  <100.37011, 150.89307, 0.162174>
  }
  object { Wall5 }
  translate  -199.119317*x
}
#declare Wall7 = union {
  box { // Cube17
    <-1, -1, -1>, <1, 1, 1>
    texture {
      BROWN_BRICK
    }
    scale <12.557552, 3.865225, 13.073984>
    rotate 180.0*x
    translate  <74.071332, 150.89307, 0.162174>
  }
  box { // Cube18
    <-1, -1, -1>, <1, 1, 1>
    texture {
      BROWN_BRICK
    }
    scale <12.557552, 3.865225, 13.073984>
    rotate 180.0*x
    translate  <25.541627, 150.89307, 0.162174>
  }
  box { // Cube19
    <-1, -1, -1>, <1, 1, 1>
    texture {
      BROWN_BRICK
    }
    scale <12.557552, 3.865225, 13.073984>
    rotate 180.0*x
    translate  <50.460287, 150.89307, 0.162174>
  }
  box { // Cube20
    <-1, -1, -1>, <1, 1, 1>
    texture {
      BROWN_BRICK
    }
    scale <12.557552, 3.865225, 13.073984>
    rotate 180.0*x
    translate  <100.37011, 150.89307, 0.162174>
  }
  object { Wall4 }
  object { Wall6 }
  translate  798.731451*x
}
#declare Wall11 = union {
  box { // Cube33
    <-1, -1, -1>, <1, 1, 1>
    texture {
      BROWN_BRICK
    }
    scale <12.557552, 3.865225, 13.073984>
    rotate 180.0*x
    translate  <74.071332, 150.89307, 0.162174>
  }
  box { // Cube34
    <-1, -1, -1>, <1, 1, 1>
    texture {
      BROWN_BRICK
    }
    scale <12.557552, 3.865225, 13.073984>
    rotate 180.0*x
    translate  <25.541627, 150.89307, 0.162174>
  }
  box { // Cube35
    <-1, -1, -1>, <1, 1, 1>
    texture {
      BROWN_BRICK
    }
    scale <12.557552, 3.865225, 13.073984>
    rotate 180.0*x
    translate  <50.460287, 150.89307, 0.162174>
  }
  box { // Cube36
    <-1, -1, -1>, <1, 1, 1>
    texture {
      BROWN_BRICK
    }
    scale <12.557552, 3.865225, 13.073984>
    rotate 180.0*x
    translate  <100.37011, 150.89307, 0.162174>
  }
  object { Wall8 }
  object { Wall10 }
  object { Wall7 }
  translate  <-399.741422, -0.0, 0.0>
}
#declare Wall = union {
  box { // Cube001
    <-1, -1, -1>, <1, 1, 1>
    texture {
      BROWN_BRICK
    }
    scale <12.557552, 3.865225, 13.073984>
    rotate 180.0*x
    translate  <74.071332, 150.89307, 0.162174>
  }
  box { // Cube2
    <-1, -1, -1>, <1, 1, 1>
    texture {
      BROWN_BRICK
    }
    scale <12.557552, 3.865225, 13.073984>
    rotate 180.0*x
    translate  <25.541627, 150.89307, 0.162174>
  }
  box { // Cube3
    <-1, -1, -1>, <1, 1, 1>
    texture {
      BROWN_BRICK
    }
    scale <12.557552, 3.865225, 13.073984>
    rotate 180.0*x
    translate  <50.460287, 150.89307, 0.162174>
  }
  box { // Cube4
    <-1, -1, -1>, <1, 1, 1>
    texture {
      BROWN_BRICK
    }
    scale <12.557552, 3.865225, 13.073984>
    rotate 180.0*x
    translate  <99.203914, 150.89307, 0.162174>
  }
  object { Wall1 }
  object { Wall3 }
  object { Wall11 }
  box { // Cube16
    <-1, -1, -1>, <1, 1, 1>
    texture {
      BROWN_BRICK
    }
    scale <-3.718779, -3.865225, -4.100488>
    rotate <0.0, -0.0, 0.0>
    translate  <-16.476549, 150.89307, -8.577483>
  }
  box { // Cube59
    <-1, -1, -1>, <1, 1, 1>
    texture {
      BROWN_BRICK
    }
    scale <-15.225883, -3.865225, -13.20058>
    rotate <0.0, -0.0, 0.0>
    translate  <-1.935423, 150.89307, 0.008338>
  }
  texture {
    MIRROR
  }
  scale <-3.376794, 1.0, 3.188397>
  translate  <-4.376794, 0.0, 27.510596>
}
union { // Scenery_Group
  object { Wall }
  plane { // Ground_Plane
    z,0
    texture {
      MIRROR
    }
    translate  <0.0, -1.846175, -12.923222>
  }
  plane { // Sky
    z,0
    texture {
      Starfield
    }
    scale <18.425602, -18.096556, 1.547263>
    translate  200.0*z
  }
}




#declare Lug_Nuts4 = union {
  cylinder { // Cylndr19
    <0,0,1>, <0,0,0>, 1 
    texture {
      Chrome_Metal
    }
    rotate 88.838684*x
    translate  <0.0, -3.567831, -5.676096>
  }
  cylinder { // Cylndr20
    <0,0,1>, <0,0,0>, 1 
    texture {
      Chrome_Metal
    }
    rotate -90.0*x
    translate  <-0.185073, -4.340293, 5.671>
  }
  cylinder { // Cylndr21
    <0,0,1>, <0,0,0>, 1 
    texture {
      Chrome_Metal
    }
    rotate -90.0*x
    translate  <-5.334255, -4.320147, 0.0>
  }
  cylinder { // Cylndr22
    <0,0,1>, <0,0,0>, 1 
    texture {
      Chrome_Metal
    }
    rotate -90.0*x
    translate  <5.715273, -4.441761, 0.0>
  }
}
#declare CSG6 = union {
  superellipsoid { // Tire4
    <1.0, 0.25>
    texture {
      Dark_Gray_tex
    }
    scale <12.420939, 11.937156, 5.310634>
    rotate <-179.931274, -89.75322, 90.998634>
  }
  cylinder { // Wheel_rim4
    <0,0,1>, <0,0,0>, 1 
    scale <8.101168, 7.91326, 9.986228>
    rotate <0.000001, 89.875404, -90.0>
    translate  <-0.0, 4.378702, -0.070336>
  }
  rotate <0.089221, 0.001363, -0.875066>
}
#declare Tire_and_Wheel_Rim_Assembly4 = difference {
  object { CSG6 }
  cylinder { // wheel_rim_diffd4
    <0,0,1>, <0,0,0>, 1 
    scale <7.275869, 7.656919, 6.530165>
    rotate <89.858345, 0.0, -0.0>
    translate  <-0.0, -3.405657, -0.162174>
  }
  texture {
    Chrome_Metal
  }
  rotate <-0.089232, -0.0, 0.875067>
}
#declare Right_Rear_Wheel1 = union {
  object { Lug_Nuts4 }
  object { Tire_and_Wheel_Rim_Assembly4 }
  cone { // Center_Cone4
    <0,0,0>, 0.0, <0,0,1>, 1.0
    texture {
      Chrome_Metal
    }
    scale 2.535048
    rotate -92.532188*x
    translate  <0.0, -6.140191, 0.341122>
  }
  scale <1.446718, 2.179572, 1.444009>
  rotate <0.0, 9.405326, -179.74382>
  translate  <125.852212, 69.312146, 4.472049>
}
#declare Lug_Nuts5 = union {
  cylinder { // Cylndr23
    <0,0,1>, <0,0,0>, 1 
    texture {
      Chrome_Metal
    }
    rotate 88.838684*x
    translate  <0.0, -3.567831, -5.676096>
  }
  cylinder { // Cylndr24
    <0,0,1>, <0,0,0>, 1 
    texture {
      Chrome_Metal
    }
    rotate -90.0*x
    translate  <-0.185073, -4.340293, 5.671>
  }
  cylinder { // Cylndr25
    <0,0,1>, <0,0,0>, 1 
    texture {
      Chrome_Metal
    }
    rotate -90.0*x
    translate  <-5.334255, -4.320147, 0.0>
  }
  cylinder { // Cylndr26
    <0,0,1>, <0,0,0>, 1 
    texture {
      Chrome_Metal
    }
    rotate -90.0*x
    translate  <5.715273, -4.441761, 0.0>
  }
}
#declare CSG7 = union {
  superellipsoid { // Tire5
    <1.0, 0.25>
    texture {
      Dark_Gray_tex
    }
    scale <12.420939, 11.937156, 5.310634>
    rotate <-179.931274, -89.75322, 90.998634>
  }
  cylinder { // Wheel_rim5
    <0,0,1>, <0,0,0>, 1 
    scale <8.101168, 7.91326, 9.986228>
    rotate <0.000001, 89.875404, -90.0>
    translate  <-0.0, 4.378702, -0.070336>
  }
  rotate <0.089221, 0.001363, -0.875066>
}
#declare Tire_and_Wheel_Rim_Assembly5 = difference {
  object { CSG7 }
  cylinder { // wheel_rim_diffd5
    <0,0,1>, <0,0,0>, 1 
    scale <7.275869, 7.656919, 6.530165>
    rotate <89.858345, 0.0, -0.0>
    translate  <-0.0, -3.405657, -0.162174>
  }
  texture {
    Chrome_Metal
  }
  rotate <-0.089232, -0.0, 0.875067>
}
#declare Left_Rear_Wheel1 = union {
  object { Lug_Nuts5 }
  object { Tire_and_Wheel_Rim_Assembly5 }
  cone { // Center_Cone5
    <0,0,0>, 0.0, <0,0,1>, 1.0
    texture {
      Chrome_Metal
    }
    scale 2.535048
    rotate -92.532188*x
    translate  <0.0, -6.140191, 0.341122>
  }
  scale <1.460582, 2.179375, 1.446306>
  rotate <-0.001906, 9.405306, 0.157043>
  translate  <126.475178, -10.187498, 4.472049>
}
#declare Lug_Nuts6 = union {
  cylinder { // Cylndr27
    <0,0,1>, <0,0,0>, 1 
    texture {
      Chrome_Metal
    }
    rotate 88.838684*x
    translate  <0.0, -3.567831, -5.676096>
  }
  cylinder { // Cylndr28
    <0,0,1>, <0,0,0>, 1 
    texture {
      Chrome_Metal
    }
    rotate -90.0*x
    translate  <-0.185073, -4.340293, 5.671>
  }
  cylinder { // Cylndr29
    <0,0,1>, <0,0,0>, 1 
    texture {
      Chrome_Metal
    }
    rotate -90.0*x
    translate  <-5.334255, -4.320147, 0.0>
  }
  cylinder { // Cylndr30
    <0,0,1>, <0,0,0>, 1 
    texture {
      Chrome_Metal
    }
    rotate -90.0*x
    translate  <5.715273, -4.441761, 0.0>
  }
}
#declare CSG8 = union {
  superellipsoid { // Tire6
    <1.0, 0.25>
    texture {
      Dark_Gray_tex
    }
    scale <12.420939, 11.937156, 5.310634>
    rotate <-179.931274, -89.75322, 90.998634>
  }
  cylinder { // Wheel_rim6
    <0,0,1>, <0,0,0>, 1 
    scale <8.101168, 7.91326, 9.986228>
    rotate <0.000001, 89.875404, -90.0>
    translate  <-0.0, 4.378702, -0.070336>
  }
  rotate <0.089221, 0.001363, -0.875066>
}
#declare Tire_and_Wheel_Rim_Assembly6 = difference {
  object { CSG8 }
  cylinder { // wheel_rim_diffd6
    <0,0,1>, <0,0,0>, 1 
    scale <7.275869, 7.656919, 6.530165>
    rotate <89.858345, 0.0, -0.0>
    translate  <-0.0, -3.405657, -0.162174>
  }
  texture {
    Chrome_Metal
  }
  rotate <-0.089232, -0.0, 0.875067>
}
#declare Right_Front_Wheel1 = union {
  object { Lug_Nuts6 }
  object { Tire_and_Wheel_Rim_Assembly6 }
  cone { // Center_Cone6
    <0,0,0>, 0.0, <0,0,1>, 1.0
    texture {
      Chrome_Metal
    }
    scale 2.535048
    rotate -92.532188*x
    translate  <0.0, -6.140191, 0.341122>
  }
  rotate <-0.0, 9.405326, 179.129059>
  translate  <8.833294, 66.015772, -0.511683>
}
#declare Lug_Nuts7 = union {
  cylinder { // Cylndr31
    <0,0,1>, <0,0,0>, 1 
    texture {
      Chrome_Metal
    }
    rotate 88.838684*x
    translate  <0.0, -3.567831, -5.676096>
  }
  cylinder { // Cylndr32
    <0,0,1>, <0,0,0>, 1 
    texture {
      Chrome_Metal
    }
    rotate -90.0*x
    translate  <-0.185073, -4.340293, 5.671>
  }
  cylinder { // Cylndr33
    <0,0,1>, <0,0,0>, 1 
    texture {
      Chrome_Metal
    }
    rotate -90.0*x
    translate  <-5.334255, -4.320147, 0.0>
  }
  cylinder { // Cylndr34
    <0,0,1>, <0,0,0>, 1 
    texture {
      Chrome_Metal
    }
    rotate -90.0*x
    translate  <5.715273, -4.441761, 0.0>
  }
}
#declare CSG9 = union {
  superellipsoid { // Tire7
    <1.0, 0.25>
    texture {
      Dark_Gray_tex
    }
    scale <12.420939, 11.937156, 5.310634>
    rotate <-179.931274, -89.75322, 90.998634>
  }
  cylinder { // Wheel_rim7
    <0,0,1>, <0,0,0>, 1 
    scale <8.101168, 7.91326, 9.986228>
    rotate <0.000001, 89.875404, -90.0>
    translate  <-0.0, 4.378702, -0.070336>
  }
  rotate <0.089221, 0.001363, -0.875066>
}
#declare Tire_and_Wheel_Rim_Assembly7 = difference {
  object { CSG9 }
  cylinder { // wheel_rim_diffd7
    <0,0,1>, <0,0,0>, 1 
    scale <7.275869, 7.656919, 6.530165>
    rotate <89.858345, 0.0, -0.0>
    translate  <-0.0, -3.405657, -0.162174>
  }
  texture {
    Chrome_Metal
  }
  rotate <-0.089232, -0.0, 0.875067>
}
#declare Left_Front_Wheel1 = union {
  object { Lug_Nuts7 }
  object { Tire_and_Wheel_Rim_Assembly7 }
  cone { // Center_Cone7
    <0,0,0>, 0.0, <0,0,1>, 1.0
    texture {
      Chrome_Metal
    }
    scale 2.535048
    rotate -92.532188*x
    translate  <0.0, -6.140191, 0.341122>
  }
  rotate -1.954782*z
  translate  <8.833294, -6.62497, 0.0>
}
#declare Wheel_Group1 = union {
  object { Right_Rear_Wheel1 }
  object { Left_Rear_Wheel1 }
  object { Right_Front_Wheel1 }
  object { Left_Front_Wheel1 }
}
#declare Steering_Geometry_pieces1 = union {
  cylinder { // Cylndr35
    <0,0,1>, <0,0,0>, 1 
    texture {
      Chrome_Metal
    }
    scale <-0.423613, -1.0, -19.506973>
    rotate 86.71125*x
    translate  <13.013945, 43.59829, -2.461566>
  }
  cylinder { // Cylndr36
    <0,0,1>, <0,0,0>, 1 
    texture {
      Chrome_Metal
    }
    scale <-0.423613, -1.0, -19.506973>
    rotate 86.71125*x
    translate  <5.375476, 46.660395, 0.741564>
  }
  cylinder { // Cylndr37
    <0,0,1>, <0,0,0>, 1 
    texture {
      Chrome_Metal
    }
    scale <-0.423613, -1.0, -19.506973>
    rotate 86.71125*x
    translate  <8.804512, 46.769756, 2.343129>
  }
  cylinder { // Cylndr38
    <0,0,1>, <0,0,0>, 1 
    texture {
      Chrome_Metal
    }
    scale <-0.423613, -1.0, -19.506973>
    rotate <95.487236, -0.0, -0.0>
    translate  <3.499548, -4.266967, -3.692349>
  }
  cylinder { // Cylndr39
    <0,0,1>, <0,0,0>, 1 
    texture {
      Chrome_Metal
    }
    scale <-0.423613, -1.0, -19.506973>
    rotate <95.487236, -0.0, -0.0>
    translate  <6.346775, -4.266967, -1.023074>
  }
  cylinder { // Cylndr40
    <0,0,1>, <0,0,0>, 1 
    texture {
      Chrome_Metal
    }
    scale <-0.423613, -1.0, -19.506973>
    rotate 86.71125*x
    translate  <1.20297, 46.769756, -2.461566>
  }
}
#declare Airfoil_Bracket1 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.000000, -2.000000, 0.000000>, <-1.000000, -2.000000, 0.000000>, <0.000000, -2.000000, 0.000000>, <1.000000, -2.000000, 0.000000>, 
      <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, 
      <-2.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <0.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, 
      <-2.000000, 1.000000, 0.000000>, <-1.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <1.000000, 1.000000, 0.000000>
    }
  }
  texture {
    Chrome_Metal
  }
  scale <8.690467, 2.747581, 3.575782>
  rotate <84.24408, -18.144842, 1.803238>
  translate  <132.495949, 12.067434, 28.598859>
}
#declare Rear_Airfoil1 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.000000, -2.000000, 0.000000>, <-1.000000, -2.000000, 0.000000>, <0.000000, -2.000000, 0.000000>, <1.000000, -2.000000, 0.000000>, 
      <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, 
      <-2.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <0.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, 
      <-2.000000, 1.000000, 0.000000>, <-1.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <1.000000, 1.000000, 0.000000>
    }
  }
  texture {
    Solarized
  }
  scale <13.229007, 26.100262, 3.490387>
  rotate -19.071161*y
  translate  <138.014412, 44.618855, 34.333835>
}
#declare Airfoil_Bracket_right1 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.000000, -2.000000, 0.000000>, <-1.000000, -2.000000, 0.000000>, <0.000000, -2.000000, 0.000000>, <1.000000, -2.000000, 0.000000>, 
      <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, 
      <-2.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <0.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, 
      <-2.000000, 1.000000, 0.000000>, <-1.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <1.000000, 1.000000, 0.000000>
    }
  }
  texture {
    Chrome_Metal
  }
  scale <8.690467, 2.747581, 3.575782>
  rotate <84.544968, -18.172415, 0.390501>
  translate  <133.461344, 44.890853, 28.598859>
}
#declare Airfoil1 = union {
  object { Airfoil_Bracket1 }
  object { Rear_Airfoil1 }
  object { Airfoil_Bracket_right1 }
}
#declare Left_Side_of_Car1 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-4.915074, -5.278436, 1.188960>, <-3.915074, -5.013289, 0.000000>, <-2.741220, -4.919645, 0.000000>, <-1.873442, -4.948791, 0.000000>, 
      <-4.830149, -4.849257, 0.000000>, <-3.915074, -4.472011, 0.000000>, <-2.834151, -4.397917, 0.000000>, <-1.919908, -4.330276, 0.000000>, 
      <-5.000000, -4.976950, 1.188960>, <-3.915074, -4.252513, 0.000000>, <-2.741220, -3.662695, 0.000000>, <-1.873442, -3.605014, 0.000000>, 
      <-4.934003, -4.703423, 1.188960>, <-4.180082, -3.452975, 0.000000>, <-2.787686, -3.327775, 0.000000>, <-1.918345, -3.246958, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-4.934003, -4.703423, 1.188960>, <-4.180082, -3.452975, 0.000000>, <-2.787686, -3.327775, 0.000000>, <-1.918345, -3.246958, 0.000000>, 
      <-4.868007, -4.429896, 1.188960>, <-4.445090, -2.653437, 0.000000>, <-2.834151, -2.992855, 0.000000>, <-1.963248, -2.888903, 0.000000>, 
      <-5.037858, -4.449004, 1.188960>, <-4.530015, -2.250065, 0.000000>, <-2.834151, -2.364380, 0.000000>, <-1.963248, -2.217014, 0.000000>, 
      <-5.018929, -4.718285, 1.188960>, <-4.445090, -1.777740, 0.000000>, <-2.834151, -1.735905, 0.000000>, <-1.963248, -1.545125, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-5.018929, -4.718285, 1.188960>, <-4.445090, -1.777740, 0.000000>, <-2.834151, -1.735905, 0.000000>, <-1.963248, -1.545125, 0.000000>, 
      <-5.000000, -4.987565, 1.188960>, <-4.360164, -1.305415, 0.000000>, <-2.834151, -1.107430, 0.000000>, <-1.963248, -0.873237, 0.000000>, 
      <-4.952933, -4.081700, 1.188960>, <-4.530015, -0.810106, 0.000000>, <-2.741220, -0.532329, 0.000000>, <-1.873442, -0.258408, 0.000000>, 
      <-4.830149, -4.940856, 1.188960>, <-4.339378, 0.190794, 0.000000>, <-2.741220, 0.096146, 0.000000>, <-1.873442, 0.413480, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.873442, -4.948791, 0.000000>, <-1.005664, -4.977937, 0.000000>, <0.014998, -4.977937, 0.000000>, <1.049962, -4.948481, 0.000000>, 
      <-1.919908, -4.330276, 0.000000>, <-1.005664, -4.262635, 0.000000>, <0.014998, -4.190946, 0.000000>, <1.049962, -4.148008, 0.000000>, 
      <-1.873442, -3.605014, 0.000000>, <-1.005664, -3.547332, 0.000000>, <0.014998, -3.496415, 0.000000>, <1.049962, -3.393766, 0.000000>, 
      <-1.918345, -3.246958, 0.000000>, <-1.049004, -3.166142, 0.000000>, <-0.028343, -3.126293, 0.000000>, <1.028292, -2.801728, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.918345, -3.246958, 0.000000>, <-1.049004, -3.166142, 0.000000>, <-0.028343, -3.126293, 0.000000>, <1.028292, -2.801728, 0.000000>, 
      <-1.963248, -2.888903, 0.000000>, <-1.092345, -2.784951, 0.000000>, <-0.071683, -2.756172, 0.000000>, <1.006621, -2.209691, 0.000000>, 
      <-1.963248, -2.217014, 0.000000>, <-1.092345, -2.069648, 0.000000>, <-0.071683, -2.061641, 0.000000>, <1.006621, -1.455449, 0.000000>, 
      <-1.963248, -1.545125, 0.000000>, <-1.092345, -1.354346, 0.000000>, <-0.071683, -1.367110, 0.000000>, <1.006621, -0.701207, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.963248, -1.545125, 0.000000>, <-1.092345, -1.354346, 0.000000>, <-0.071683, -1.367110, 0.000000>, <1.006621, -0.701207, 0.000000>, 
      <-1.963248, -0.873237, 0.000000>, <-1.092345, -0.639043, 0.000000>, <-0.071683, -0.672579, 0.000000>, <1.006621, 0.053036, 0.000000>, 
      <-1.873442, -0.258408, 0.000000>, <-1.005664, 0.015512, 0.000000>, <0.014998, -0.037031, 0.000000>, <1.049962, 0.777786, 0.000000>, 
      <-1.873442, 0.413480, 0.000000>, <-1.005664, 0.730814, 0.000000>, <0.014998, 0.657499, 0.000000>, <1.057779, 1.485125, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.049962, -4.948481, 0.000000>, <2.084926, -4.919024, 0.000000>, <3.000000, -5.000000, 0.000000>, <4.084926, -4.952776, 0.000000>, 
      <1.049962, -4.148008, 0.000000>, <2.084926, -4.105071, 0.000000>, <3.000000, -4.000000, 0.000000>, <4.084926, -3.906653, 0.000000>, 
      <1.049962, -3.393766, 0.000000>, <2.084926, -3.291117, 0.000000>, <3.000000, -3.000000, 0.000000>, <4.084926, -2.860530, 0.000000>, 
      <1.028292, -2.801728, 0.000000>, <2.084926, -2.477164, 0.000000>, <3.000000, -2.000000, 0.000000>, <4.084926, -1.814407, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.028292, -2.801728, 0.000000>, <2.084926, -2.477164, 0.000000>, <3.000000, -2.000000, 0.000000>, <4.084926, -1.814407, 0.000000>, 
      <1.006621, -2.209691, 0.000000>, <2.084926, -1.663210, 0.000000>, <3.000000, -1.000000, 0.000000>, <4.084926, -0.768284, 0.000000>, 
      <1.006621, -1.455449, 0.000000>, <2.084926, -0.849257, 0.000000>, <3.000000, 0.000000, 0.000000>, <4.084926, 0.277838, 0.000000>, 
      <1.006621, -0.701207, 0.000000>, <2.084926, -0.035303, 0.000000>, <3.000000, 1.000000, 0.000000>, <4.084926, 1.323961, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.006621, -0.701207, 0.000000>, <2.084926, -0.035303, 0.000000>, <3.000000, 1.000000, 0.000000>, <4.084926, 1.323961, 0.000000>, 
      <1.006621, 0.053036, 0.000000>, <2.084926, 0.778650, 0.000000>, <3.000000, 2.000000, 0.000000>, <4.084926, 2.370084, 0.000000>, 
      <1.049962, 0.777786, 0.000000>, <2.084926, 1.592604, 0.000000>, <3.000000, 3.000000, 0.000000>, <4.100560, 3.697626, 0.000000>, 
      <1.057779, 1.485125, 0.000000>, <2.100560, 2.312751, 0.000000>, <3.031269, 3.656044, 0.000000>, <4.100560, 4.743748, 0.000000>
    }
  }
  texture {
    Solarized
  }
  scale <17.536554, 3.83129, 3.207767>
  rotate <90.051147, -0.0, -0.0>
  translate  <77.407219, 7.361078, 8.098565>
}
#declare Top_of_body1 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.245097, -2.182966, -2.231704>, <-1.755184, -1.936129, 0.039852>, <-0.348694, -2.000000, -0.000000>, <0.466403, -2.000000, 0.119556>, 
      <-2.245097, -1.020258, -2.231704>, <-1.755184, -0.968064, 0.039852>, <-0.348694, -1.000000, -0.000000>, <0.466403, -1.000000, 0.119556>, 
      <-2.245097, 0.142450, -2.231704>, <-1.755184, 0.000000, 0.039852>, <-0.348694, 0.000000, -0.000000>, <0.466403, 0.000000, 0.119556>, 
      <-2.245097, 1.305159, -2.231704>, <-1.755184, 0.968064, 0.039852>, <-0.348694, 1.000000, -0.000000>, <0.466403, 1.000000, 0.119556>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.466403, -2.000000, 0.119556>, <1.281499, -2.000000, 0.239111>, <2.321160, -2.000000, 1.235408>, <2.699009, -1.936129, 1.594074>, 
      <0.466403, -1.000000, 0.119556>, <1.281499, -1.000000, 0.239111>, <2.321160, -1.000000, 1.235408>, <2.699009, -0.968064, 1.594074>, 
      <0.466403, 0.000000, 0.119556>, <1.281499, 0.000000, 0.239111>, <2.321160, 0.000000, 1.235408>, <2.699009, 0.000000, 1.594074>, 
      <0.466403, 1.000000, 0.119556>, <1.281499, 1.000000, 0.239111>, <2.321160, 1.000000, 1.235408>, <2.699009, 0.968064, 1.594074>
    }
  }
  texture {
    Solarized
  }
  scale <32.652637, 15.722157, 9.833294>
  translate  <61.096949, 37.541499, 10.590431>
}
#declare Bottom_of_Body1 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.000000, -2.000000, 0.000000>, <-1.000000, -2.000000, 0.000000>, <0.000000, -2.000000, 0.000000>, <1.000000, -2.000000, 0.000000>, 
      <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, 
      <-2.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <0.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, 
      <-2.000000, 1.000000, 0.000000>, <-1.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <1.000000, 1.000000, 0.000000>
    }
  }
  scale <53.209152, 15.667654, 13.459331>
  translate  <94.844767, 36.805391, -10.590431>
}
#declare Car_Body_Parts1 = union {
  object { Left_Side_of_Car1 }
  object { Top_of_body1 }
  object { Bottom_of_Body1 }
  cone { // Windshield1
    <0,0,0>, 0.0, <0,0,1>, 1.0
    open
    scale 10.641703
    rotate <-180.0, 88.077217, -180.0>
    translate  <50.816398, 28.96184, 10.656848>
  }
  box { // Cube51
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Solarized
    }
    scale <40.537151, 12.93154, 9.550411>
    translate  <66.200165, 60.337168, -1.420913>
  }
  box { // Cube52
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Solarized
    }
    scale <40.779621, 14.379631, 9.188951>
    translate  <66.106108, -1.448092, -1.420913>
  }
  box { // Cube53
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Solarized
    }
    scale <-39.1735, -15.894406, -5.050315>
    rotate <180.0, 4.564932, 180.0>
    translate  <68.600413, 0.0, 6.448363>
  }
  box { // Cube54
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Solarized
    }
    scale <-40.881107, -15.894406, -4.946894>
    rotate <-180.0, 3.465884, -180.0>
    translate  <66.749127, 57.440984, 5.421921>
  }
  cylinder { // Cockpit_front_panel1
    <0,0,1>, <0,0,0>, 1 
    texture {
      Solarized
    }
    scale <8.225951, 9.205854, 39.260609>
    rotate <0.0, 76.983231, 0.0>
    translate  <20.057773, 28.96184, -2.168769>
  }
  cylinder { // Cockpit_Rear_piece1
    <0,0,1>, <0,0,0>, 1 
    texture {
      Solarized
    }
    scale <9.861854, 9.205854, 48.86237>
    rotate <180.0, 89.749306, 180.0>
    translate  <81.144752, 28.96184, 9.759458>
  }
  texture {
    CYAN_METALIC
  }
}
#declare Headlamp_right1 = union {
  sphere { // Lamp_housing14
    <0,0,0>,1
    texture {
      Plexiglas
    }
    hollow
    scale 2.691443
    translate  <35.862302, 76.399403, 161.491623>
  }
  translate  <-35.661688, -33.075543, -161.033505>
}
#declare Headlamp_left1 = union {
  sphere { // Lamp_housing15
    <0,0,0>,1
    texture {
      Plexiglas
    }
    hollow
    scale 3.055632
    translate  <37.282767, 76.899915, 161.392496>
  }
  translate  <-36.492117, -60.479676, -161.033505>
}
union { // Red_Race_Car
  object { Wheel_Group1 }
  object { Steering_Geometry_pieces1 }
  object { Airfoil1 }
  object { Car_Body_Parts1 }
  object { Headlamp_right1 }
  object { Headlamp_left1 }
  object { Driver_Helmet }
  object { // Cylndr67->Cylndr66
    Cylndr66
    translate  <-22.967668, -73.225307, 0.0>
  }
  object { Cylndr66 }
  object { // Cylndr68->Cylndr66
    Cylndr66
    translate  <0.445646, -27.229264, 0.0>
  }
  translate  <20.075341, 45.748203, 0.0>
}


#declare Lug_Nuts8 = union {
  cylinder { // Cylndr41
    <0,0,1>, <0,0,0>, 1 
    texture {
      Chrome_Metal
    }
    rotate 88.838684*x
    translate  <0.0, -3.567831, -5.676096>
  }
  cylinder { // Cylndr42
    <0,0,1>, <0,0,0>, 1 
    texture {
      Chrome_Metal
    }
    rotate -90.0*x
    translate  <-0.185073, -4.340293, 5.671>
  }
  cylinder { // Cylndr43
    <0,0,1>, <0,0,0>, 1 
    texture {
      Chrome_Metal
    }
    rotate -90.0*x
    translate  <-5.334255, -4.320147, 0.0>
  }
  cylinder { // Cylndr44
    <0,0,1>, <0,0,0>, 1 
    texture {
      Chrome_Metal
    }
    rotate -90.0*x
    translate  <5.715273, -4.441761, 0.0>
  }
}
#declare CSG10 = union {
  superellipsoid { // Tire8
    <1.0, 0.25>
    texture {
      Dark_Gray_tex
    }
    scale <12.420939, 11.937156, 5.310634>
    rotate <-179.931274, -89.75322, 90.998634>
  }
  cylinder { // Wheel_rim8
    <0,0,1>, <0,0,0>, 1 
    scale <8.101168, 7.91326, 9.986228>
    rotate <0.000001, 89.875404, -90.0>
    translate  <-0.0, 4.378702, -0.070336>
  }
  rotate <0.089221, 0.001363, -0.875066>
}
#declare Tire_and_Wheel_Rim_Assembly8 = difference {
  object { CSG10 }
  cylinder { // wheel_rim_diffd8
    <0,0,1>, <0,0,0>, 1 
    scale <7.275869, 7.656919, 6.530165>
    rotate <89.858345, 0.0, -0.0>
    translate  <-0.0, -3.405657, -0.162174>
  }
  texture {
    Chrome_Metal
  }
  rotate <-0.089232, -0.0, 0.875067>
}
#declare Right_Rear_Wheel2 = union {
  object { Lug_Nuts8 }
  object { Tire_and_Wheel_Rim_Assembly8 }
  cone { // Center_Cone8
    <0,0,0>, 0.0, <0,0,1>, 1.0
    texture {
      Chrome_Metal
    }
    scale 2.535048
    rotate -92.532188*x
    translate  <0.0, -6.140191, 0.341122>
  }
  scale <1.446718, 2.179572, 1.444009>
  rotate <0.0, 9.405326, -179.74382>
  translate  <125.852212, 69.312146, 4.472049>
}
#declare Lug_Nuts9 = union {
  cylinder { // Cylndr45
    <0,0,1>, <0,0,0>, 1 
    texture {
      Chrome_Metal
    }
    rotate 88.838684*x
    translate  <0.0, -3.567831, -5.676096>
  }
  cylinder { // Cylndr46
    <0,0,1>, <0,0,0>, 1 
    texture {
      Chrome_Metal
    }
    rotate -90.0*x
    translate  <-0.185073, -4.340293, 5.671>
  }
  cylinder { // Cylndr47
    <0,0,1>, <0,0,0>, 1 
    texture {
      Chrome_Metal
    }
    rotate -90.0*x
    translate  <-5.334255, -4.320147, 0.0>
  }
  cylinder { // Cylndr48
    <0,0,1>, <0,0,0>, 1 
    texture {
      Chrome_Metal
    }
    rotate -90.0*x
    translate  <5.715273, -4.441761, 0.0>
  }
}
#declare CSG11 = union {
  superellipsoid { // Tire9
    <1.0, 0.25>
    texture {
      Dark_Gray_tex
    }
    scale <12.420939, 11.937156, 5.310634>
    rotate <-179.931274, -89.75322, 90.998634>
  }
  cylinder { // Wheel_rim9
    <0,0,1>, <0,0,0>, 1 
    scale <8.101168, 7.91326, 9.986228>
    rotate <0.000001, 89.875404, -90.0>
    translate  <-0.0, 4.378702, -0.070336>
  }
  rotate <0.089221, 0.001363, -0.875066>
}
#declare Tire_and_Wheel_Rim_Assembly9 = difference {
  object { CSG11 }
  cylinder { // wheel_rim_diffd9
    <0,0,1>, <0,0,0>, 1 
    scale <7.275869, 7.656919, 6.530165>
    rotate <89.858345, 0.0, -0.0>
    translate  <-0.0, -3.405657, -0.162174>
  }
  texture {
    Chrome_Metal
  }
  rotate <-0.089232, -0.0, 0.875067>
}
#declare Left_Rear_Wheel2 = union {
  object { Lug_Nuts9 }
  object { Tire_and_Wheel_Rim_Assembly9 }
  cone { // Center_Cone9
    <0,0,0>, 0.0, <0,0,1>, 1.0
    texture {
      Chrome_Metal
    }
    scale 2.535048
    rotate -92.532188*x
    translate  <0.0, -6.140191, 0.341122>
  }
  scale <1.460582, 2.179375, 1.446306>
  rotate <-0.001906, 9.405306, 0.157043>
  translate  <126.475178, -10.187498, 4.472049>
}
#declare Lug_Nuts10 = union {
  cylinder { // Cylndr49
    <0,0,1>, <0,0,0>, 1 
    texture {
      Chrome_Metal
    }
    rotate 88.838684*x
    translate  <0.0, -3.567831, -5.676096>
  }
  cylinder { // Cylndr50
    <0,0,1>, <0,0,0>, 1 
    texture {
      Chrome_Metal
    }
    rotate -90.0*x
    translate  <-0.185073, -4.340293, 5.671>
  }
  cylinder { // Cylndr51
    <0,0,1>, <0,0,0>, 1 
    texture {
      Chrome_Metal
    }
    rotate -90.0*x
    translate  <-5.334255, -4.320147, 0.0>
  }
  cylinder { // Cylndr52
    <0,0,1>, <0,0,0>, 1 
    texture {
      Chrome_Metal
    }
    rotate -90.0*x
    translate  <5.715273, -4.441761, 0.0>
  }
}
#declare CSG12 = union {
  superellipsoid { // Tire10
    <1.0, 0.25>
    texture {
      Dark_Gray_tex
    }
    scale <12.420939, 11.937156, 5.310634>
    rotate <-179.931274, -89.75322, 90.998634>
  }
  cylinder { // Wheel_rim10
    <0,0,1>, <0,0,0>, 1 
    scale <8.101168, 7.91326, 9.986228>
    rotate <0.000001, 89.875404, -90.0>
    translate  <-0.0, 4.378702, -0.070336>
  }
  rotate <0.089221, 0.001363, -0.875066>
}
#declare Tire_and_Wheel_Rim_Assembly10 = difference {
  object { CSG12 }
  cylinder { // wheel_rim_diffd10
    <0,0,1>, <0,0,0>, 1 
    scale <7.275869, 7.656919, 6.530165>
    rotate <89.858345, 0.0, -0.0>
    translate  <-0.0, -3.405657, -0.162174>
  }
  texture {
    Chrome_Metal
  }
  rotate <-0.089232, -0.0, 0.875067>
}
#declare Right_Front_Wheel2 = union {
  object { Lug_Nuts10 }
  object { Tire_and_Wheel_Rim_Assembly10 }
  cone { // Center_Cone10
    <0,0,0>, 0.0, <0,0,1>, 1.0
    texture {
      Chrome_Metal
    }
    scale 2.535048
    rotate -92.532188*x
    translate  <0.0, -6.140191, 0.341122>
  }
  rotate <-0.0, 9.405326, 179.129059>
  translate  <8.833294, 66.015772, -0.511683>
}
#declare Lug_Nuts11 = union {
  cylinder { // Cylndr53
    <0,0,1>, <0,0,0>, 1 
    texture {
      Chrome_Metal
    }
    rotate 88.838684*x
    translate  <0.0, -3.567831, -5.676096>
  }
  cylinder { // Cylndr54
    <0,0,1>, <0,0,0>, 1 
    texture {
      Chrome_Metal
    }
    rotate -90.0*x
    translate  <-0.185073, -4.340293, 5.671>
  }
  cylinder { // Cylndr55
    <0,0,1>, <0,0,0>, 1 
    texture {
      Chrome_Metal
    }
    rotate -90.0*x
    translate  <-5.334255, -4.320147, 0.0>
  }
  cylinder { // Cylndr56
    <0,0,1>, <0,0,0>, 1 
    texture {
      Chrome_Metal
    }
    rotate -90.0*x
    translate  <5.715273, -4.441761, 0.0>
  }
}
#declare CSG13 = union {
  superellipsoid { // Tire11
    <1.0, 0.25>
    texture {
      Dark_Gray_tex
    }
    scale <12.420939, 11.937156, 5.310634>
    rotate <-179.931274, -89.75322, 90.998634>
  }
  cylinder { // Wheel_rim11
    <0,0,1>, <0,0,0>, 1 
    scale <8.101168, 7.91326, 9.986228>
    rotate <0.000001, 89.875404, -90.0>
    translate  <-0.0, 4.378702, -0.070336>
  }
  rotate <0.089221, 0.001363, -0.875066>
}
#declare Tire_and_Wheel_Rim_Assembly11 = difference {
  object { CSG13 }
  cylinder { // wheel_rim_diffd11
    <0,0,1>, <0,0,0>, 1 
    scale <7.275869, 7.656919, 6.530165>
    rotate <89.858345, 0.0, -0.0>
    translate  <-0.0, -3.405657, -0.162174>
  }
  texture {
    Chrome_Metal
  }
  rotate <-0.089232, -0.0, 0.875067>
}
#declare Left_Front_Wheel2 = union {
  object { Lug_Nuts11 }
  object { Tire_and_Wheel_Rim_Assembly11 }
  cone { // Center_Cone11
    <0,0,0>, 0.0, <0,0,1>, 1.0
    texture {
      Chrome_Metal
    }
    scale 2.535048
    rotate -92.532188*x
    translate  <0.0, -6.140191, 0.341122>
  }
  rotate -1.954782*z
  translate  <8.833294, -6.62497, 0.0>
}
#declare Wheel_Group2 = union {
  object { Right_Rear_Wheel2 }
  object { Left_Rear_Wheel2 }
  object { Right_Front_Wheel2 }
  object { Left_Front_Wheel2 }
}
#declare Steering_Geometry_pieces2 = union {
  cylinder { // Cylndr57
    <0,0,1>, <0,0,0>, 1 
    texture {
      Chrome_Metal
    }
    scale <-0.423613, -1.0, -19.506973>
    rotate 86.71125*x
    translate  <13.013945, 43.59829, -2.461566>
  }
  cylinder { // Cylndr58
    <0,0,1>, <0,0,0>, 1 
    texture {
      Chrome_Metal
    }
    scale <-0.423613, -1.0, -19.506973>
    rotate 86.71125*x
    translate  <5.375476, 46.660395, 0.741564>
  }
  cylinder { // Cylndr59
    <0,0,1>, <0,0,0>, 1 
    texture {
      Chrome_Metal
    }
    scale <-0.423613, -1.0, -19.506973>
    rotate 86.71125*x
    translate  <8.804512, 46.769756, 2.343129>
  }
  cylinder { // Cylndr60
    <0,0,1>, <0,0,0>, 1 
    texture {
      Chrome_Metal
    }
    scale <-0.423613, -1.0, -19.506973>
    rotate <95.487236, -0.0, -0.0>
    translate  <3.499548, -4.266967, -3.692349>
  }
  cylinder { // Cylndr61
    <0,0,1>, <0,0,0>, 1 
    texture {
      Chrome_Metal
    }
    scale <-0.423613, -1.0, -19.506973>
    rotate <95.487236, -0.0, -0.0>
    translate  <6.346775, -4.266967, -1.023074>
  }
  cylinder { // Cylndr62
    <0,0,1>, <0,0,0>, 1 
    texture {
      Chrome_Metal
    }
    scale <-0.423613, -1.0, -19.506973>
    rotate 86.71125*x
    translate  <1.20297, 46.769756, -2.461566>
  }
}
#declare Airfoil_Bracket2 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.000000, -2.000000, 0.000000>, <-1.000000, -2.000000, 0.000000>, <0.000000, -2.000000, 0.000000>, <1.000000, -2.000000, 0.000000>, 
      <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, 
      <-2.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <0.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, 
      <-2.000000, 1.000000, 0.000000>, <-1.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <1.000000, 1.000000, 0.000000>
    }
  }
  texture {
    Chrome_Metal
  }
  scale <8.690467, 2.747581, 3.575782>
  rotate <84.24408, -18.144842, 1.803238>
  translate  <132.495949, 12.067434, 28.598859>
}
#declare Rear_Airfoil2 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.000000, -2.000000, 0.000000>, <-1.000000, -2.000000, 0.000000>, <0.000000, -2.000000, 0.000000>, <1.000000, -2.000000, 0.000000>, 
      <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, 
      <-2.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <0.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, 
      <-2.000000, 1.000000, 0.000000>, <-1.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <1.000000, 1.000000, 0.000000>
    }
  }
  texture {
    Yellow_Fever
  }
  scale <13.229007, 26.100262, 3.490387>
  rotate -19.071161*y
  translate  <138.014412, 44.618855, 34.333835>
}
#declare Airfoil_Bracket_right2 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.000000, -2.000000, 0.000000>, <-1.000000, -2.000000, 0.000000>, <0.000000, -2.000000, 0.000000>, <1.000000, -2.000000, 0.000000>, 
      <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, 
      <-2.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <0.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, 
      <-2.000000, 1.000000, 0.000000>, <-1.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <1.000000, 1.000000, 0.000000>
    }
  }
  texture {
    Chrome_Metal
  }
  scale <8.690467, 2.747581, 3.575782>
  rotate <84.544968, -18.172415, 0.390501>
  translate  <133.461344, 44.890853, 28.598859>
}
#declare Airfoil2 = union {
  object { Airfoil_Bracket2 }
  object { Rear_Airfoil2 }
  object { Airfoil_Bracket_right2 }
}
#declare Left_Side_of_Car2 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-4.915074, -5.278436, 1.188960>, <-3.915074, -5.013289, 0.000000>, <-2.741220, -4.919645, 0.000000>, <-1.873442, -4.948791, 0.000000>, 
      <-4.830149, -4.849257, 0.000000>, <-3.915074, -4.472011, 0.000000>, <-2.834151, -4.397917, 0.000000>, <-1.919908, -4.330276, 0.000000>, 
      <-5.000000, -4.976950, 1.188960>, <-3.915074, -4.252513, 0.000000>, <-2.741220, -3.662695, 0.000000>, <-1.873442, -3.605014, 0.000000>, 
      <-4.934003, -4.703423, 1.188960>, <-4.180082, -3.452975, 0.000000>, <-2.787686, -3.327775, 0.000000>, <-1.918345, -3.246958, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-4.934003, -4.703423, 1.188960>, <-4.180082, -3.452975, 0.000000>, <-2.787686, -3.327775, 0.000000>, <-1.918345, -3.246958, 0.000000>, 
      <-4.868007, -4.429896, 1.188960>, <-4.445090, -2.653437, 0.000000>, <-2.834151, -2.992855, 0.000000>, <-1.963248, -2.888903, 0.000000>, 
      <-5.037858, -4.449004, 1.188960>, <-4.530015, -2.250065, 0.000000>, <-2.834151, -2.364380, 0.000000>, <-1.963248, -2.217014, 0.000000>, 
      <-5.018929, -4.718285, 1.188960>, <-4.445090, -1.777740, 0.000000>, <-2.834151, -1.735905, 0.000000>, <-1.963248, -1.545125, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-5.018929, -4.718285, 1.188960>, <-4.445090, -1.777740, 0.000000>, <-2.834151, -1.735905, 0.000000>, <-1.963248, -1.545125, 0.000000>, 
      <-5.000000, -4.987565, 1.188960>, <-4.360164, -1.305415, 0.000000>, <-2.834151, -1.107430, 0.000000>, <-1.963248, -0.873237, 0.000000>, 
      <-4.952933, -4.081700, 1.188960>, <-4.530015, -0.810106, 0.000000>, <-2.741220, -0.532329, 0.000000>, <-1.873442, -0.258408, 0.000000>, 
      <-4.830149, -4.940856, 1.188960>, <-4.339378, 0.190794, 0.000000>, <-2.741220, 0.096146, 0.000000>, <-1.873442, 0.413480, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.873442, -4.948791, 0.000000>, <-1.005664, -4.977937, 0.000000>, <0.014998, -4.977937, 0.000000>, <1.049962, -4.948481, 0.000000>, 
      <-1.919908, -4.330276, 0.000000>, <-1.005664, -4.262635, 0.000000>, <0.014998, -4.190946, 0.000000>, <1.049962, -4.148008, 0.000000>, 
      <-1.873442, -3.605014, 0.000000>, <-1.005664, -3.547332, 0.000000>, <0.014998, -3.496415, 0.000000>, <1.049962, -3.393766, 0.000000>, 
      <-1.918345, -3.246958, 0.000000>, <-1.049004, -3.166142, 0.000000>, <-0.028343, -3.126293, 0.000000>, <1.028292, -2.801728, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.918345, -3.246958, 0.000000>, <-1.049004, -3.166142, 0.000000>, <-0.028343, -3.126293, 0.000000>, <1.028292, -2.801728, 0.000000>, 
      <-1.963248, -2.888903, 0.000000>, <-1.092345, -2.784951, 0.000000>, <-0.071683, -2.756172, 0.000000>, <1.006621, -2.209691, 0.000000>, 
      <-1.963248, -2.217014, 0.000000>, <-1.092345, -2.069648, 0.000000>, <-0.071683, -2.061641, 0.000000>, <1.006621, -1.455449, 0.000000>, 
      <-1.963248, -1.545125, 0.000000>, <-1.092345, -1.354346, 0.000000>, <-0.071683, -1.367110, 0.000000>, <1.006621, -0.701207, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.963248, -1.545125, 0.000000>, <-1.092345, -1.354346, 0.000000>, <-0.071683, -1.367110, 0.000000>, <1.006621, -0.701207, 0.000000>, 
      <-1.963248, -0.873237, 0.000000>, <-1.092345, -0.639043, 0.000000>, <-0.071683, -0.672579, 0.000000>, <1.006621, 0.053036, 0.000000>, 
      <-1.873442, -0.258408, 0.000000>, <-1.005664, 0.015512, 0.000000>, <0.014998, -0.037031, 0.000000>, <1.049962, 0.777786, 0.000000>, 
      <-1.873442, 0.413480, 0.000000>, <-1.005664, 0.730814, 0.000000>, <0.014998, 0.657499, 0.000000>, <1.057779, 1.485125, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.049962, -4.948481, 0.000000>, <2.084926, -4.919024, 0.000000>, <3.000000, -5.000000, 0.000000>, <4.084926, -4.952776, 0.000000>, 
      <1.049962, -4.148008, 0.000000>, <2.084926, -4.105071, 0.000000>, <3.000000, -4.000000, 0.000000>, <4.084926, -3.906653, 0.000000>, 
      <1.049962, -3.393766, 0.000000>, <2.084926, -3.291117, 0.000000>, <3.000000, -3.000000, 0.000000>, <4.084926, -2.860530, 0.000000>, 
      <1.028292, -2.801728, 0.000000>, <2.084926, -2.477164, 0.000000>, <3.000000, -2.000000, 0.000000>, <4.084926, -1.814407, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.028292, -2.801728, 0.000000>, <2.084926, -2.477164, 0.000000>, <3.000000, -2.000000, 0.000000>, <4.084926, -1.814407, 0.000000>, 
      <1.006621, -2.209691, 0.000000>, <2.084926, -1.663210, 0.000000>, <3.000000, -1.000000, 0.000000>, <4.084926, -0.768284, 0.000000>, 
      <1.006621, -1.455449, 0.000000>, <2.084926, -0.849257, 0.000000>, <3.000000, 0.000000, 0.000000>, <4.084926, 0.277838, 0.000000>, 
      <1.006621, -0.701207, 0.000000>, <2.084926, -0.035303, 0.000000>, <3.000000, 1.000000, 0.000000>, <4.084926, 1.323961, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.006621, -0.701207, 0.000000>, <2.084926, -0.035303, 0.000000>, <3.000000, 1.000000, 0.000000>, <4.084926, 1.323961, 0.000000>, 
      <1.006621, 0.053036, 0.000000>, <2.084926, 0.778650, 0.000000>, <3.000000, 2.000000, 0.000000>, <4.084926, 2.370084, 0.000000>, 
      <1.049962, 0.777786, 0.000000>, <2.084926, 1.592604, 0.000000>, <3.000000, 3.000000, 0.000000>, <4.100560, 3.697626, 0.000000>, 
      <1.057779, 1.485125, 0.000000>, <2.100560, 2.312751, 0.000000>, <3.031269, 3.656044, 0.000000>, <4.100560, 4.743748, 0.000000>
    }
  }
  texture {
    Yellow_Fever
  }
  scale <17.536554, 3.83129, 3.207767>
  rotate <90.051147, -0.0, -0.0>
  translate  <77.407219, 7.361078, 8.098565>
}
#declare Top_of_body2 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.245097, -2.182966, -2.231704>, <-1.755184, -1.936129, 0.039852>, <-0.348694, -2.000000, -0.000000>, <0.466403, -2.000000, 0.119556>, 
      <-2.245097, -1.020258, -2.231704>, <-1.755184, -0.968064, 0.039852>, <-0.348694, -1.000000, -0.000000>, <0.466403, -1.000000, 0.119556>, 
      <-2.245097, 0.142450, -2.231704>, <-1.755184, 0.000000, 0.039852>, <-0.348694, 0.000000, -0.000000>, <0.466403, 0.000000, 0.119556>, 
      <-2.245097, 1.305159, -2.231704>, <-1.755184, 0.968064, 0.039852>, <-0.348694, 1.000000, -0.000000>, <0.466403, 1.000000, 0.119556>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.466403, -2.000000, 0.119556>, <1.281499, -2.000000, 0.239111>, <2.321160, -2.000000, 1.235408>, <2.699009, -1.936129, 1.594074>, 
      <0.466403, -1.000000, 0.119556>, <1.281499, -1.000000, 0.239111>, <2.321160, -1.000000, 1.235408>, <2.699009, -0.968064, 1.594074>, 
      <0.466403, 0.000000, 0.119556>, <1.281499, 0.000000, 0.239111>, <2.321160, 0.000000, 1.235408>, <2.699009, 0.000000, 1.594074>, 
      <0.466403, 1.000000, 0.119556>, <1.281499, 1.000000, 0.239111>, <2.321160, 1.000000, 1.235408>, <2.699009, 0.968064, 1.594074>
    }
  }
  texture {
    Yellow_Fever
  }
  scale <32.652637, 15.722157, 9.833294>
  translate  <61.096949, 37.541499, 10.590431>
}
#declare Bottom_of_Body2 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.000000, -2.000000, 0.000000>, <-1.000000, -2.000000, 0.000000>, <0.000000, -2.000000, 0.000000>, <1.000000, -2.000000, 0.000000>, 
      <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, 
      <-2.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <0.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, 
      <-2.000000, 1.000000, 0.000000>, <-1.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <1.000000, 1.000000, 0.000000>
    }
  }
  scale <53.209152, 15.667654, 13.459331>
  translate  <94.844767, 36.805391, -10.590431>
}
#declare Car_Body_Parts2 = union {
  object { Left_Side_of_Car2 }
  object { Top_of_body2 }
  object { Bottom_of_Body2 }
  cone { // Windshield2
    <0,0,0>, 0.0, <0,0,1>, 1.0
    open
    scale 10.641703
    rotate <-180.0, 88.077217, -180.0>
    translate  <50.816398, 28.96184, 10.656848>
  }
  box { // Cube55
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Yellow_Fever
    }
    scale <40.537151, 12.93154, 9.550411>
    translate  <66.200165, 60.337168, -1.420913>
  }
  box { // Cube56
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Yellow_Fever
    }
    scale <40.779621, 14.379631, 9.188951>
    translate  <66.106108, -1.448092, -1.420913>
  }
  box { // Cube57
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Yellow_Fever
    }
    scale <-39.1735, -15.894406, -5.050315>
    rotate <180.0, 4.564932, 180.0>
    translate  <68.600413, 0.0, 6.448363>
  }
  box { // Cube58
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Yellow_Fever
    }
    scale <-40.881107, -15.894406, -4.946894>
    rotate <-180.0, 3.465884, -180.0>
    translate  <66.749127, 57.440984, 5.421921>
  }
  cylinder { // Cockpit_front_panel2
    <0,0,1>, <0,0,0>, 1 
    texture {
      Yellow_Fever
    }
    scale <8.225951, 9.205854, 39.260609>
    rotate <0.0, 76.983231, 0.0>
    translate  <20.057773, 28.96184, -2.168769>
  }
  cylinder { // Cockpit_Rear_piece2
    <0,0,1>, <0,0,0>, 1 
    texture {
      Yellow_Fever
    }
    scale <9.861854, 9.205854, 48.86237>
    rotate <180.0, 89.749306, 180.0>
    translate  <81.144752, 28.96184, 9.759458>
  }
  texture {
    CYAN_METALIC
  }
}
#declare Headlamp_right2 = union {
  sphere { // Lamp_housing16
    <0,0,0>,1
    texture {
      Plexiglas
    }
    hollow
    scale 2.691443
    translate  <35.862302, 76.399403, 161.491623>
  }
  translate  <-35.661688, -33.075543, -161.033505>
}
#declare Headlamp_left2 = union {
  sphere { // Lamp_housing17
    <0,0,0>,1
    texture {
      Plexiglas
    }
    hollow
    scale 3.055632
    translate  <34.405546, 76.399403, 160.763245>
  }
  translate  <-36.492117, -60.479676, -161.033505>
}
union { // Yellow_Race_Car
  object { Wheel_Group2 }
  object { Steering_Geometry_pieces2 }
  object { Airfoil2 }
  object { Car_Body_Parts2 }
  object { Headlamp_right2 }
  object { Headlamp_left2 }
  translate  <386.466191, -3.780048, 0.0>
}  

box { <0,0,0> <.1,36,36>
        pigment { checker pigment {color rgb 1},  pigment{color rgb .1} scale 8}
        scale 3
        translate <-050,50,50>
}
// An area light (creates soft shadows)
// WARNING: This special light can significantly slow down rendering times!
light_source
{
  0*x // light's position (translated below)
  color rgb 1.0*1  // light's color
  // <widthVector> <heightVector> nLightsWide mLightsHigh
  area_light
  <8, 0, 0> <0, 0, 8> // lights spread out across this distance (x * z)
  4, 4                // total number of lights in grid (4x*4z = 16 lights)
  adaptive 0          // 0,1,2,3... 
  jitter              // adds random softening of light
  translate <-70,70,50>
}
 



