// Persistence Of Vision raytracer version 3.0 file
// File by Patrick Dugan

#version 3.0
global_settings { assumed_gamma 2.2 }

#include "colors.inc"
#include "metals.inc"
#include "textures.inc"
#include "metals.inc"
#include "ufo5.inc"

   #declare galaxy_seed = 1;
   #include "GALAXY.INC"

// COMMON GALAXY OPTIONS
   #declare galaxy_colour1 = <1.3, 1.2, .9>;
   #declare galaxy_colour2 = <.4, .8, 1>;
   #declare galaxy_cluster_name = ""

// STARFIELD BACKGROUND
   #declare galaxy_bgstars = 2;
   #declare galaxy_bgnebula = false;
   #declare galaxy_nebula_sphere = false;
   #include "GALAXY.BG"

// A FEW LARGE STARS
   #declare galaxy_object_scale = 0.8;
   #declare galaxy_object_name = concat("Star", str(1, 0, 0))
   #declare galaxy_object_position = <18, 8, 0>;
   #include "GALAXY.OBJ"

   #declare galaxy_object_scale = 0.4;
   #declare galaxy_object_name = concat("Star", str(1, 0, 0))
   #declare galaxy_object_position = <15, 16, 0>;
   #include "GALAXY.OBJ"

   #declare galaxy_object_scale = 0.4;
   #declare galaxy_object_name = concat("Star", str(1, 0, 0))
   #declare galaxy_object_position = <-15, -25, 0>;
   #include "GALAXY.OBJ"


camera {
   location <0, 0, -4>
   look_at <0, 0, 0>
}


light_source {<-7, 7, -4> color red 2 blue 2 green 2}


object {UFO1
  rotate x*-40  // Ship tilted up to see underbelly
  rotate z*160
  translate <-0.6,-1.75,-2> // was -1.8 for y
}


light_source {<2.0,-1.8,-4> color White 4.5
    spotlight
    point_at <2.0,-1.8,0>
    radius 8
    falloff 16
}

