// Persistence of Vision Ray Tracer Scene Description File
// File: .pov
// Vers: 3.1
// Desc: BALUSTRADE MACRO SET
// Date: JAN 99
// Auth: Nathan O'Brien
// Mail: no13@no13.net
// Webp: www.no13.net
// Copyright: (C) Nathan G B O'Brien 1998 

#include "T_Balus.inc"

// TUSCUN BALUSTRADE

#macro BL_Tuscan (Origin,Size)

	box {((<-.15,.95,-.15> * Size) + Origin)((<.15,1,.15> * Size) + Origin)}	// top plate
	box {((<-.15,0,-.15> * Size) + Origin)((<.15,.05,.15> * Size) + Origin)}	// bottom plate 
	
	cylinder {((<0,.05,0> * Size) + Origin)((<0,.075,0> * Size) + Origin),(.1118 * Size)}
	cylinder {((<0,.925,0> * Size) + Origin)((<0,.95,0> * Size) + Origin),(.1118 * Size)}
	
	cylinder {((<0,.075,0> * Size) + Origin)((<0,.925,0> * Size) + Origin),(.0736 * Size)}

#end 

#macro BL_Doric (Origin,Size)

	box {((<-.15,.95,-.15> * Size) + Origin)((<.15,1,.15> * Size) + Origin)}	// top plate
	box {((<-.15,0,-.15> * Size) + Origin)((<.15,.05,.15> * Size) + Origin)}	// bottom plate 
	
	difference {
		cylinder {((<0,.05,0> * Size) + Origin)((<0,.1132,0> * Size) + Origin),(.1118 * Size)}
		torus {(.1118 * Size),(.0382 * Size) sturm translate ((<0,.1132,0> * Size) + Origin)}
	}
	difference {  
		cylinder {((<0,.8868,0> * Size) + Origin)((<0,.95,0> * Size) + Origin),(.1118 * Size)} 
		torus {(.1118 * Size),(.0382 * Size) sturm translate ((<0,.8868,0> * Size) + Origin)}
	} 
	
	cylinder {((<0,.075,0> * Size) + Origin)((<0,.925,0> * Size) + Origin),(.0736 * Size)}
	sphere {<0,0,0>,(.1 * Size) scale <1,3,1> translate ((<0,.5,0> * Size) + Origin)}

#end  

#macro BL_Ionic (Origin,Size)

	box {((<-.15,.95,-.15> * Size) + Origin)((<.15,1,.15> * Size) + Origin)}	// top plate
	box {((<-.15,0,-.15> * Size) + Origin)((<.15,.05,.15> * Size) + Origin)}	// bottom plate  
	
	cylinder {((<0,.05,0> * Size) + Origin)((<0,.1,0> * Size) + Origin),(.1118 * Size)}
	cylinder {((<0,.925,0> * Size) + Origin)((<0,.95,0> * Size) + Origin),(.1118 * Size)} 
	
	sphere {((<0,.2,0> * Size) + Origin),(.15 * Size)}
	cone {((<0,.2168,0> * Size) + Origin),(.1491 * Size),((<0,.875,0> * Size) + Origin),(.0749 * Size)} 
	cylinder {((<0,.875,0> * Size) + Origin)((<0,.925,0> * Size) + Origin),(.0868 * Size)}

#end

#macro BL_Corinth (Origin,Size)

	box {((<-.15,.95,-.15> * Size) + Origin)((<.15,1,.15> * Size) + Origin)}	// top plate
	box {((<-.15,0,-.15> * Size) + Origin)((<.15,.05,.15> * Size) + Origin)}	// bottom plate  
	
	cylinder {((<0,.05,0> * Size) + Origin)((<0,.075,0> * Size) + Origin),(.1118 * Size)}
	cylinder {((<0,.925,0> * Size) + Origin)((<0,.95,0> * Size) + Origin),(.1118 * Size)} 
	
	sphere {((<0,.175,0> * Size) + Origin),(.15 * Size)} 
	sphere {((<0,.825,0> * Size) + Origin),(.15 * Size)} 
	
	difference {
		cylinder {((<0,.275,0> * Size) + Origin)((<0,.725,0> * Size) + Origin),(.1118 * Size)}
		torus {(.3465 * Size),(.3083 * Size) sturm translate ((<0,.5,0> * Size) + Origin)}
	}

#end

#macro BL_Comp (Origin,Size)

	box {((<-.15,.95,-.15> * Size) + Origin)((<.15,1,.15> * Size) + Origin)}	// top plate
	box {((<-.15,0,-.15> * Size) + Origin)((<.15,.05,.15> * Size) + Origin)}	// bottom plate  
	
	difference {
		cylinder {((<0,.05,0> * Size) + Origin)((<0,.95,0> * Size) + Origin),(.1118 * Size)}
	
		torus {(.1957 * Size),(.1125 * Size) sturm translate ((<0,.15,0> * Size) + Origin)} 
		torus {(.1957 * Size),(.1125 * Size) sturm translate ((<0,.85,0> * Size) + Origin)}
		
		torus {(.1118 * Size),(.0125 * Size) sturm translate ((<0,.4625,0> * Size) + Origin)} 
		torus {(.1118 * Size),(.0125 * Size) sturm translate ((<0,.5375,0> * Size) + Origin)} 
	}
	
	sphere {((<0,.325,0> * Size) + Origin),(.15 * Size)}
	sphere {((<0,.675,0> * Size) + Origin),(.15 * Size)} 
	
	torus {(.125 * Size),(.025 * Size) sturm translate ((<0,.5,0> * Size) + Origin)}
		
#end

// BALUSTRADE DIVIDER

#macro BL_Divider (Origin,Size)   

	box {((<-.25,.95,-.15> * Size) + Origin)((<.25,1,.15> * Size) + Origin)}	// top plate
	box {((<-.25,0,-.15> * Size) + Origin)((<.25,.05,.15> * Size) + Origin)}	// bottom plate 
	
	difference {
		box {((<-.225,.05,-.125> * Size) + Origin)((<.225,.95,.125> * Size) + Origin)} 
		
		box {((<-.175,.1,-.2> * Size) + Origin)((<.175,.9,-.1> * Size) + Origin)}
		box {((<-.075,.2,-.2> * Size) + Origin)((<.075,.8,-.07> * Size) + Origin)}
		
		box {((<-.175,.1,.2> * Size) + Origin)((<.175,.9,.1> * Size) + Origin)}
		box {((<-.075,.2,.2> * Size) + Origin)((<.075,.8,.07> * Size) + Origin)}
		
		box {((<-.3,.1,-.075> * Size) + Origin)((<-.215,.8,.075> * Size) + Origin)} 
		
		box {((<.3,.1,-.075> * Size) + Origin)((<.215,.8,.075> * Size) + Origin)}
	}

#end 

// CIRCULAR BALUSTRADE

#macro BL_Circular (Rad,Style,Origin)
 
	#local Qty1 = int((Rad * 2 * pi) / .6);
	// NOTE QTY MUST BE DIVISIBLE BY 5
	#local Test1 = (Qty1 / 5);
	#local Test2 = int(Qty1 / 5);
	#if (Test1 != Test2)
		#local Qty2 = (Test2 * 5);
	#else
		#local Qty2 = Test1;
	#end
	
	#local Origin2 = (Origin + <0,0,Rad>);
	
	#local Count1 = 0;
	#local Count2 = 1;
	    
	#if (Style = 1) #local Balus1 = union {BL_Tuscan (Origin2,1)} #end
	#if (Style = 2) #local Balus1 = union {BL_Doric (Origin2,1)} #end
	#if (Style = 3) #local Balus1 = union {BL_Ionic (Origin2,1)} #end
	#if (Style = 4) #local Balus1 = union {BL_Corinth (Origin2,1)} #end
	#if (Style = 5) #local Balus1 = union {BL_Comp (Origin2,1)} #end  
		
	#local Balus2 = union {BL_Divider (Origin2,1)}    
	    
	#while (Count1 < Qty2)  
	
		#if (Count2 = 1)   
			object {Balus2 rotate <0,((360 / Qty2) * Count1),0> texture{T_Bal1}}
		#else
			object {Balus1 rotate <0,((360 / Qty2) * Count1),0> texture{T_Bal1}}
		#end
	
		#local Count1 = (Count1 + 1);
		#local Count2 = (Count2 + 1);
		#if (Count2 > 5)
			#local Count2 = 1;
		#end
	#end 
	
	difference {
		cylinder {(<0,1,0> + Origin)(<0,1.05,0> + Origin),(Rad + .2) texture{T_Bal1}} 
		cylinder {((<0,1,0> + Origin) + <0,-1,0>)((<0,1.05,0> + Origin) + <0,1,0>),(Rad - .2) texture{T_Bal1}}
	} 
	
	difference {
		cylinder {(<0,1.05,0> + Origin)(<0,1.15,0> + Origin),(Rad + .225) texture{T_Bal1}} 
		cylinder {((<0,1.05,0> + Origin) + <0,-1,0>)((<0,1.15,0> + Origin) + <0,1,0>),(Rad - .225) texture{T_Bal1}}
	}
	
	torus {(Rad + .225),.025 sturm translate (<0,1.125> + Origin) texture{T_Bal1}}
	torus {(Rad - .225),.025 sturm translate (<0,1.125> + Origin) texture{T_Bal1}}	

#end  

// LINEAR HANDRAIL MACRO

#macro BL_Hrail (Length,Size)
    
	box {(<0,0,.2> * Size)(<(Length / Size),.05,-.2> * Size) texture{T_Bal1}}
	box {(<0,.05,.225> * Size)(<(Length / Size),.15,-.225> * Size) texture{T_Bal1}}
	
	cylinder {(<0,.125,.225> * Size)(<(Length / Size),.125,.225> * Size)(.025 * Size) texture{T_Bal1}}
	cylinder {(<0,.125,-.225> * Size)(<(Length / Size),.125,-.225> * Size)(.025 * Size) texture{T_Bal1}}    
    
#end  

// BALUSTRADE STYLE RECTANGULAR WRAP AROUND HANDRAIL

#macro BL_Wrap (Length,Width,Size,Switch1)  

	#local Length2 = (Length + 1);
	#local Width2 = (Width + 1);

	#local Front_Rail =
	difference { 
		object {union {BL_Hrail (Length2,Size)} translate <-(Length2 / 2),0,0>}
		box {<0,-10,-10><-10,10,10> rotate <0,45,0> translate <-(Length / 2),0,0>}
		box {<0,-10,-10><10,10,10> rotate <0,-45,0> translate <(Length / 2),0,0>}
	}
	
	
	#local Side_Rail =
	difference { 
		object {union {BL_Hrail (Width2,Size)} translate <-(Width2 / 2),0,0>}
		box {<0,-10,-10><-10,10,10> rotate <0,45,0> translate <-(Width / 2),0,0>}
		box {<0,-10,-10><10,10,10> rotate <0,-45,0> translate <(Width / 2),0,0>}
	}
	
	
	object {Front_Rail texture{T_Bal1}}
	object {Side_Rail rotate <0,-90,0> translate <(Length / 2),0,(Width / 2)> texture{T_Bal1}} 
	object {Side_Rail rotate <0,90,0> translate <-(Length / 2),0,(Width / 2)> texture{T_Bal1}} 
	#if (Switch1 = 1)
		object {Front_Rail rotate <0,180,0> translate <0,0,Width> texture{T_Bal1}}
	#end

#end

// FULL RECTANGULAR BALUSTRADE & HANDRAIL 
#macro BL_Rectangular (Length,Width,Style,Scale,Switch1) 
	#local NH = (1 * Scale);
	object {union {BL_Wrap (Length,Width,Scale,Switch1)} translate <0,NH,0>}
	#local BL_Dist = .5;  
	#local Qty1 = int(Length / BL_Dist);
	#local Qty2 = int(Width / BL_Dist);
	#local Dist1 = (Length / Qty1);
	#local Dist2 = (Width / Qty2); 
	#local Count1 = 0;
	#while (Count1 < (Qty1 + 1)) 
	        
	    #local New_Origin1 = <((Length / -2) + (Count1 * Dist1)),0,0>;
		#local New_Origin2 = <((Length / -2) + (Count1 * Dist1)),0,Width>;
	        
		#if (Style = 1)  
			object {union {BL_Tuscan (New_Origin1,Scale)} texture{T_Bal1}}
			object {union {BL_Tuscan (New_Origin2,Scale)} texture{T_Bal1}}
		#end 
		#if (Style = 2)  
			object {union {BL_Doric (New_Origin1,Scale)} texture{T_Bal1}}
			object {union {BL_Doric (New_Origin2,Scale)} texture{T_Bal1}}
		#end
		#if (Style = 3)  
			object {union {BL_Ionic (New_Origin1,Scale)} texture{T_Bal1}}
			object {union {BL_Ionic (New_Origin2,Scale)} texture{T_Bal1}}
		#end
		#if (Style = 4)  
			object {union {BL_Corinth (New_Origin1,Scale)} texture{T_Bal1}}
			object {union {BL_Corinth (New_Origin2,Scale)} texture{T_Bal1}}
		#end
		#if (Style = 5)  
			object {union {BL_Comp (New_Origin1,Scale)} texture{T_Bal1}}
			object {union {BL_Comp (New_Origin2,Scale)} texture{T_Bal1}}
		#end
	
		#local Count1 = (Count1 + 1);
	#end 
	#local Count1 = 0;
	#while (Count1 < (Qty2 - 1)) 
	        
	    #local New_Origin1 = <(Length / 2),0,(Dist2 + (Dist2 * Count1))>;
		#local New_Origin2 = <(Length / -2),0,(Dist2 + (Dist2 * Count1))>;
	        
		#if (Style = 1)  
			object {union {BL_Tuscan (New_Origin1,Scale)} texture{T_Bal1}}
			object {union {BL_Tuscan (New_Origin2,Scale)} texture{T_Bal1}}
		#end 
		#if (Style = 2)  
			object {union {BL_Doric (New_Origin1,Scale)} texture{T_Bal1}}
			object {union {BL_Doric (New_Origin2,Scale)} texture{T_Bal1}}
		#end
		#if (Style = 3)  
			object {union {BL_Ionic (New_Origin1,Scale)} texture{T_Bal1}}
			object {union {BL_Ionic (New_Origin2,Scale)} texture{T_Bal1}}
		#end
		#if (Style = 4)  
			object {union {BL_Corinth (New_Origin1,Scale)} texture{T_Bal1}}
			object {union {BL_Corinth (New_Origin2,Scale)} texture{T_Bal1}}
		#end
		#if (Style = 5)  
			object {union {BL_Comp (New_Origin1,Scale)} texture{T_Bal1}}
			object {union {BL_Comp (New_Origin2,Scale)} texture{T_Bal1}}
		#end
	
		#local Count1 = (Count1 + 1);
	#end
	
#end  

// EOF