// Persistence of Vision Ray Tracer Scene Description File
// File: .pov
// Vers: 3.1
// Desc: Standard Macro Library
// Date: DEC 98
// Auth: Nathan O'Brien
// Mail: no13@no13.net
// Webp: www.no13.net
// Copyright: (C) Nathan G B O'Brien 1998  

// STANDARD SET OF MACRO FUNCTIONS 

// GLOBAL RAND FUNCTION
#declare GV_Rand = seed(13);

// VECTOR/FLOAT FUNCTIONS

// Vcom
// Returns the x, y or z component of a vector.
// Works similar to an array where entry 0 is the first entry 
// should use a dot operator (.x etc)

#macro Vcom (Vector,Position)
	#if (Position = 0) #local V2 = <0,-1,-1>; #local V3 = <0.0001,0,0>; #end
	#if (Position = 1) #local V2 = <-1,0,-1>; #local V3 = <0,0.0001,0>; #end
	#if (Position = 2) #local V2 = <-1,-1,0>; #local V3 = <0,0,0.0001>; #end
	#local Isolated = (Vector + (Vector * V2)); 
	#if (vlength(Isolated) > vlength(Isolated - V3))
		#local S1 = 1;
	#else
		#local S1 = -1;
	#end
	(vlength(Isolated) * S1);
#end

// S_Torus
// A SQUARE TORUS

#macro S_Torus (Rad1,Rad2,Origin,Texture)
	#local Pnt1 = (Rad1 + (Rad2 * 2));
	#local Pnt2 = (Pnt1 * -1); 
	#local Rad3 = (Rad1 * -1);    
	
	cylinder {(<Rad1,0,Rad1> + Origin)(<Rad1,0,Rad3> + Origin), Rad2 texture{Texture}}
	cylinder {(<Rad1,0,Rad1> + Origin)(<Rad3,0,Rad1> + Origin), Rad2 texture{Texture}}
	cylinder {(<Rad3,0,Rad3> + Origin)(<Rad3,0,Rad1> + Origin), Rad2 texture{Texture}} 
	cylinder {(<Rad3,0,Rad3> + Origin)(<Rad1,0,Rad3> + Origin), Rad2 texture{Texture}}
	
    intersection {
		union {
			cylinder {(<Rad1,0,Pnt1> + Origin)(<Rad1,0,Pnt2> + Origin), Rad2 texture{Texture}}
			cylinder {(<Rad3,0,Pnt1> + Origin)(<Rad3,0,Pnt2> + Origin), Rad2 texture{Texture}}
		}
		union {
			cylinder {(<Pnt1,0,Rad1> + Origin)(<Pnt2,0,Rad1> + Origin), Rad2 texture{Texture}} 
			cylinder {(<Pnt1,0,Rad3> + Origin)(<Pnt2,0,Rad3> + Origin), Rad2 texture{Texture}}
		}
	}
#end 

// S_Cone
// A SQUARE CONE

#macro S_Cone (Pnt1,Rad1,Pnt2,Rad2,Texture)
	#local Start_Y = Vcom(Pnt1,1)
	#local End_Y = Vcom(Pnt2,1)
	#local Nrad1 = (Rad1 * -1);
	#local Nrad2 = (Rad2 * -1);
	
	polygon {5,<Rad1,Start_Y,Rad1>,<Rad2,End_Y,Rad2>,<Rad2,End_Y,Nrad2>,<Rad1,Start_Y,Nrad1>,<Rad1,Start_Y,Rad1> texture{Texture}} 
	polygon {5,<Nrad1,Start_Y,Rad1>,<Nrad2,End_Y,Rad2>,<Nrad2,End_Y,Nrad2>,<Nrad1,Start_Y,Nrad1>,<Nrad1,Start_Y,Rad1> texture{Texture}}
	polygon {5,<Rad1,Start_Y,Rad1>,<Rad2,End_Y,Rad2>,<Nrad2,End_Y,Rad2>,<Nrad1,Start_Y,Rad1>,<Rad1,Start_Y,Rad1> texture{Texture}} 
	polygon {5,<Rad1,Start_Y,Nrad1>,<Rad2,End_Y,Nrad2>,<Nrad2,End_Y,Nrad2>,<Nrad1,Start_Y,Nrad1>,<Rad1,Start_Y,Nrad1> texture{Texture}}
	
#end
