// Persistence of Vision Ray Tracer Scene Description File
// File: .pov
// Vers: 3.1
// Desc: Square temple macro set
// Date: Dec 98
// Auth: Nathan O'Brien
// Mail: no13@no13.net
// Webp: www.no13.net
// Copyright: (C) Nathan G B O'Brien 1998   

// THE STANDARD RECTANGLE TEMPLE   

#include "T_Temple.inc" 

// DRAW THE ROLL ON THE END OF THE STEPS
#macro ST_Cylgroup (P1,P2) 

	#local Cyl_Rad = 0.025;    
	#local Old_Y = Vcom(P2,1)
	#local New_Y = (Old_Y - Cyl_Rad);
	#local PX1 = Vcom(P1,0)
	#local PX2 = Vcom(P2,0)
	#local PZ1 = Vcom(P1,2)
	#local PZ2 = Vcom(P2,2)
	#local Pnt1 = <PX1,New_Y,PZ1>;
	#local Pnt2 = <PX1,New_Y,PZ2>;
	#local Pnt3 = <PX2,New_Y,PZ2>;
	#local Pnt4 = <PX2,New_Y,PZ1>;
	
	cylinder {Pnt1,Pnt2,Cyl_Rad texture{T_Templ1}}
	cylinder {Pnt2,Pnt3,Cyl_Rad texture{T_Templ1}}
	cylinder {Pnt3,Pnt4,Cyl_Rad texture{T_Templ1}}
	cylinder {Pnt4,Pnt1,Cyl_Rad texture{T_Templ1}}
	sphere {Pnt1,Cyl_Rad texture{T_Templ1}} 
	sphere {Pnt2,Cyl_Rad texture{T_Templ1}}
	sphere {Pnt3,Cyl_Rad texture{T_Templ1}}
	sphere {Pnt4,Cyl_Rad texture{T_Templ1}}

#end

// The base 3 steps. Geometry 300mm wide, 200mm high
#macro ST_3step (Length,Width,Size)
    
    #local Corner_P = (-.25 * Size);
    #local Pnt1 = <Corner_P,.4,Corner_P>;
    #local Pnt2 = <Width,.6,Length>;
    #local Pnt3 = <(Corner_P - .3),.2,(Corner_P - .3)>;
    #local Pnt4 = <(Width + .3),.4,(Length + .3)>;
    #local Pnt5 = <(Corner_P - .6),0,(Corner_P - .6)>;
    #local Pnt6 = <(Width + .6),.2,(Length + .6)>;
    
	box {Pnt1,Pnt2 texture{T_Templ1}}
	box {Pnt3,Pnt4 texture{T_Templ1}}
	box {Pnt5,Pnt6 texture{T_Templ1}}
	
	ST_Cylgroup (Pnt1,Pnt2)
	ST_Cylgroup (Pnt3,Pnt4)
	ST_Cylgroup (Pnt5,Pnt6)

#end

// Arrange the columns
#macro ST_Main (Length,Width,Space,Style,Size,Endbay)

	#local Dia = (Size * .5);
	#if (Space = 1)			// standard spacing
		#local Cdist = (Dia * 2.25);
	#end
	#if (Space = 2)  		// wide spacing
		#local Cdist = (Dia * 3);
	#end 
	#if (Space = 3)			// double columns NOT YET IMPLEMENTED
		#local Cdist = (Dia * 4);
	#end 
	
	// draw the base 3 steps
	#local OAlength = (((Length -1) * Cdist) + (Dia / 2));
	#local OAwidth = (((Width -1) * Cdist) + (Dia / 2));
	ST_3step (OAlength,OAwidth,Size)
	
	// locate the columns 
	// Front row  
	#local Count1 = 0;
	#while (Count1 < Width)
		#local Ins_Point = <(Cdist * Count1),.6,0>;
		Classic_Column (Ins_Point,Style,Size)
        #local Count1 = (Count1 + 1);
    #end 
    // Rear row 
    #local Count1 = 0;
	#while (Count1 < Width)
		#local Ins_Point = <(Cdist * Count1),.6,(Cdist * (Length -1))>;
		Classic_Column (Ins_Point,Style,Size)
        #local Count1 = (Count1 + 1);
    #end  
    // Left side
    #local Count1 = 1;
    #while (Count1 < (Length - 1))
    	#local Ins_Point = <0,.6,(Count1 * Cdist)>; 
    	#if (Style = 3)
        	Classic_Column (Ins_Point,31,Size)
        #else 
        	Classic_Column (Ins_Point,Style,Size)
        #end
    	#local Count1 = (Count1 + 1);
    #end
    // Right Side 
    #local Count1 = 1;
    #while (Count1 < (Length - 1))
    	#local Ins_Point = <(Cdist * (Width -1)),.6,(Count1 * Cdist)>;
        #if (Style = 3)
        	Classic_Column (Ins_Point,31,Size)
        #else 
        	Classic_Column (Ins_Point,Style,Size)
        #end
    	#local Count1 = (Count1 + 1);
    #end
    
    // THE ENTABLATURE         
    
    #if (Style = 1) #local NH = ((2.2 * Size) + .6); #end  
	#if (Style = 2) #local NH = ((2.4 * Size) + .6); #end
	#if (Style = 3) #local NH = ((2.6 * Size) + .6); #end
	#if (Style = 4) #local NH = ((2.8 * Size) + .6); #end
	#if (Style = 5) #local NH = ((3.2 * Size) + .6); #end

    
    #local Ewidth = ((Width -1) * Cdist); 
    #local Elength = ((Length -1) * Cdist);   
    
    #local Etab = union {Pediment (Ewidth,Style,Size)}
    object {Etab translate <0,NH,0>}     
    #if (Endbay = 1)
    	object {Etab rotate <0,180,0> translate <Ewidth,NH,Elength>}
    #end
    
    #local Etab2 = union {E_Length (Elength,Style,Size)}
    object {Etab2 rotate <0,-90,0> translate <Ewidth,NH,0>}
    object {Etab2 rotate <0,90,0> translate <0,NH,Elength>}

	// THE ROOF 
	// PART ONE. THE CEILING
	box {<0,NH,0><Ewidth,(NH + .1),Elength> texture {T_Templ2}}
	// PART TWO. THE ROOF 
	#local Ridge_Factor = .28;
	
	#local Ridge = ((((Ewidth / 2) + (Ridge_Factor * Size)) * tan((25 * pi) / 180)) + (.6 * Size));
	
	difference {
		box {<((Ridge_Factor * -1) * Size),(NH + (.6 * Size)),0><(Ewidth + (Ridge_Factor * Size)),(NH + Ridge),Elength>}
		
		box {<100,0,100><-100,100,-100> texture {T_Templ4} rotate <0,0,25> translate <(Ewidth / 2),(NH + Ridge),0>}
		box {<100,0,100><-100,100,-100> texture {T_Templ4} rotate <0,0,-25> translate <(Ewidth / 2),(NH + Ridge),0>}
	}
	
	#local Count1 = 0;
	#local Roll_Set = .5;  
	#local Roll_Dia = .025;
	#local Roll_Qty = int(Elength / Roll_Set);	
	
	#local Roll_Space = (Elength / Roll_Qty);
	#while (Count1 < (Roll_Qty + 1))  
	
		#local PZ = (Roll_Space * Count1);
	
		#local P1 = <((Ridge_Factor * -1) * Size),(NH + (.6 * Size)),PZ>;
		#local P2 = <(Ewidth / 2),(NH + Ridge),PZ>;
		#local P3 = <(Ewidth + (Ridge_Factor * Size)),(NH + (.6 * Size)),PZ>; 
		
		cylinder {P1,P2,Roll_Dia texture{T_Templ3}}
		sphere {P2,Roll_Dia texture{T_Templ3}} 
		cylinder {P3,P2,Roll_Dia texture{T_Templ3}}
	
		#local Count1 = (Count1 + 1);
	#end
    
#end  

// EOF