// Persistence of Vision Ray Tracer Scene Description File
// File: .pov
// Vers: 3.1
// Desc: MASONRY TOWER MACRO
// Date: JAN 99
// Auth: Nathan O'Brien
// Mail: no13@no13.net
// Webp: www.no13.net
// Copyright: (C) Nathan G B O'Brien 1998 


#include "T_Tower.inc"

#macro TW_Base (Rad,Depth,Age)
    
	cylinder {<0,0,0><0,-Depth,0>,Rad T_Tower1 (Age,.2,Form)}		// main shaft    
    
#end  

#macro TW_One (Rad,Depth,Style,Age,Form)   

		

	TW_Base (Rad,Depth,Age)		// main shaft
	
	// upper tower section
	
	#local T_Cut =
	union {
		box {(<.2,-.39,0> * Rad)(<-.2,-10,-10> * Rad) T_Tower1 (Age,.2,Form)} 
		difference {
			cylinder {(<0,-.4,0> * Rad)(<0,-.4,-10> * Rad),(.3 * Rad) T_Tower1 (Age,.2,Form)}
			box {(<10,-.4,10> * Rad)(<-10,-10,-10> * Rad) T_Tower1 (Age,.2,Form)}
		}
	}  
	
	#local T_Infill = 
	difference { 
		cylinder {(<0,-.4,0> * Rad)(<0,-.4,-10> * Rad),(.3 * Rad) texture{T_Brick1 rotate <90,0,0> translate (<0,-.4,0> * Rad)}}
		cylinder {(<0,-.4,20> * Rad)(<0,-.4,-20> * Rad),(.2 * Rad) texture{T_Brick1 rotate <90,0,0> translate (<0,-.4,0> * Rad)}}
		box {(<20,-.4,20> * Rad)(<-20,-20,-20> * Rad) texture{T_Brick1 rotate <90,0,0> translate (<0,-.4,0> * Rad)}}
		
		box {(<20,20,0> * Rad)(<-20,-20,-20> * Rad) rotate <-15,0,0> translate (<0,0,-1.48> * Rad) texture{T_Brick1 rotate <90,0,0> translate (<0,-.4,0> * Rad)}}
	}
	
	#local Dia = (2 * pi);
	#local Qty = int(Dia / .6);
	
	difference {
		union {
			cylinder {<0,0,0>(<0,-1,0> * Rad),(Rad * 1.15) T_Tower1 (Age,.2,Form)}
			cylinder {<0,0,0>(<0,-.85,0> * Rad),(Rad *+ 1.3) T_Tower1 (Age,.2,Form)} 
			cylinder {<0,0,0>(<0,-.5,0> * Rad),(Rad * 1.35) T_Tower1 (Age,.2,Form)}
			cylinder {<0,0,0>(<0,-.35,0> * Rad),(Rad *+ 1.4) T_Tower1 (Age,.2,Form)}
			cylinder {<0,0,0>(<0,-.2,0> * Rad),(Rad * 1.45) T_Tower1 (Age,.2,Form)}
		}   
		#local Count1 = 0;
		#while (Count1 < Qty)
			object {T_Cut rotate <0,((360 / Qty) * Count1),0>}
			#local Count1 = (Count1 + 1);
		#end
	}
	#local Count1 = 0;
	#while (Count1 < Qty)
		object {T_Infill rotate <0,((360 / Qty) * Count1),0>}
		#local Count1 = (Count1 + 1);
	#end
	
	// balustrade ring  
	#local Rad2 = (Rad * 1.3);
	BL_Circular (Rad2,Style,<0,0,0>)			

#end

// EOF