// Persistence of Vision Ray Tracer Scene Description File
// File: .pov
// Vers: 3.1
// Desc: WINDOWS AND DOORS MACRO SET
// Date: JAN 99
// Auth: Nathan O'Brien
// Mail: no13@no13.net
// Webp: www.no13.net
// Copyright: (C) Nathan G B O'Brien 1998 

#include "T_13windor.inc"

// balcony macro
#macro WD_Balcony (Width,Style,Size,Floor)

	// step one create the entablatures 
	#local BL_Entab1 = union {
	
	#if (Style = 1)
		E_Base_TD (Width,0,Size)
		E_Base_TD (0,1,Size)
		object {union {E_Base_TD (0,1,Size)} scale <-1,1,1> translate <Width,0,0>}     
	#end
	
	#if (Style = 2)
		E_Base_TD (Width,0,Size)
		E_Base_TD (0,1,Size)
		object {union {E_Base_TD (0,1,Size)} scale <-1,1,1> translate <Width,0,0>}     
		E_Detail_Doric(Width,Size)
	#end
	
	#if (Style = 3) 
		E_Base_ICC (Width,0,Size)
		E_Base_ICC (0,1,Size)
		object {union {E_Base_ICC (0,1,Size)} scale <-1,1,1> translate <Width,0,0>}     
		E_Detail_Ionic(Width,Size)
	#end
	
	#if (Style = 4) 
		E_Base_ICC (Width,0,Size)
		E_Base_ICC (0,1,Size)
		object {union {E_Base_ICC (0,1,Size)} scale <-1,1,1> translate <Width,0,0>}     
		E_Detail_Corinth(Width,Size)
	#end
	
	#if (Style = 5) 
		E_Base_ICC (Width,0,Size)
		E_Base_ICC (0,1,Size)
		object {union {E_Base_ICC (0,1,Size)} scale <-1,1,1> translate <Width,0,0>}     
		E_Detail_Comp(Width,Size)
	#end
	
	}
	
	#local BL_Entab2 = union {E_Length (1,Style,Size)}   
	
	// step two assemble the entablatures
	
	object {BL_Entab1 translate <((Width / 2) * -1),(-.6 * Size),-1>} 
	object {BL_Entab2 rotate <0,90,0> translate <((Width / 2) * -1),(-.6 * Size),0>}  
	object {BL_Entab2 rotate <0,-90,0> translate <(Width / 2),(-.6 * Size),-1>} 
	
	// the floor 
	
	box {<(Width / 2),0,0><((Width / 2) * -1),-.25,-1> translate Floor texture {T_wind4}}
    
    // the balustrade
    
    #local Zset = (-1 - ((.325 * Size) /2));
    #local Xset = ((Width / 2) + ((.325 * Size) /2));
    #local Xmax = (Xset * 2);
    #local BL_Qty = int(Xmax / .25);
    #local BL_Dist = (Xmax / BL_Qty);
    
    #local Count1 = 0;
    #while (Count1 < (BL_Qty + 1)) 
    
    	#local Xpnt = ((-1 * Xset) + (BL_Dist * Count1));
    		#if (Style = 1) union {BL_Tuscan (<Xpnt,0,Zset>,.5) texture{T_Bal1}} #end
    	    #if (Style = 2) union {BL_Doric (<Xpnt,0,Zset>,.5) texture{T_Bal1}} #end
    	    #if (Style = 3) union {BL_Ionic (<Xpnt,0,Zset>,.5) texture{T_Bal1}} #end
    	    #if (Style = 4) union {BL_Corinth (<Xpnt,0,Zset>,.5) texture{T_Bal1}} #end
    	    #if (Style = 5) union {BL_Comp (<Xpnt,0,Zset>,.5) texture{T_Bal1}} #end
    	#local Count1 = (Count1 + 1); 
    	
    #end 
    
    #local Count1 = 0;
    #while (Count1 < 4)     
    
    	#local Zpnt = (Zset + .25 + (.25 * Count1));
    		#if (Style = 1) union {BL_Tuscan (<Xset,0,Zpnt>,.5) texture{T_Bal1}}  #end 
    		#if (Style = 1) union {BL_Tuscan (<-Xset,0,Zpnt>,.5) texture{T_Bal1}} #end 
    		
    		#if (Style = 2) union {BL_Doric (<Xset,0,Zpnt>,.5) texture{T_Bal1}}  #end 
    		#if (Style = 2) union {BL_Doric (<-Xset,0,Zpnt>,.5) texture{T_Bal1}} #end
    		
    		#if (Style = 3) union {BL_Ionic (<Xset,0,Zpnt>,.5) texture{T_Bal1}}  #end 
    		#if (Style = 3) union {BL_Ionic (<-Xset,0,Zpnt>,.5) texture{T_Bal1}} #end
    		
    		#if (Style = 4) union {BL_Corinth (<Xset,0,Zpnt>,.5) texture{T_Bal1}}  #end 
    		#if (Style = 4) union {BL_Corinth (<-Xset,0,Zpnt>,.5) texture{T_Bal1}} #end
    		
    		#if (Style = 5) union {BL_Comp (<Xset,0,Zpnt>,.5) texture{T_Bal1}}  #end 
    		#if (Style = 5) union {BL_Comp (<-Xset,0,Zpnt>,.5) texture{T_Bal1}} #end
    	#local Count1 = (Count1 + 1);
    #end
    
    // handrail
   
    #local Hwidth  = (1 + (.2 * Size));
    
    object {union {BL_Wrap (Xmax,Hwidth,.5,0)} translate <0,.5,Zset>}
    
#end

// window macro
#macro WD_Window (Width,Style,Size,Type,Balcony)
    
    // Step one the columns
	#local Origin1 = <(Width / 2),0,0>;
	#local Origin2 = <((Width / 2) * -1),0,0>;
	#if (Type = 1)
		Classic_Column (Origin1,Style,Size)
		Classic_Column (Origin2,Style,Size)
	#else
		S_Classic_Column (Origin1,Style,Size)
		S_Classic_Column (Origin2,Style,Size)
	#end
	
	// step two the pediment
	#local Win_Ped = union {Pediment (Width,Style,Size)}
	
    #if (Style = 1) #local NH1 = (2.2 * Size); #end  
	#if (Style = 2) #local NH1 = (2.4 * Size); #end
	#if (Style = 3) #local NH1 = (2.6 * Size); #end
	#if (Style = 4) #local NH1 = (2.8 * Size); #end
	#if (Style = 5) #local NH1 = (3.2 * Size); #end  
	
	object {Win_Ped translate (<0,NH1,0> + Origin2)}
	
	// step three the base 
	#local Width2 = (Width + (.5 * Size));
	#local Win_Base = union {E_Base_Pediment (Width2,Size)}
	
	#local NH2 = (.21 * Size * -1);
	object {Win_Base translate (<0,NH2,0> - <(Width2 / 2),0,0>)}
	
	// step four the window frame and glazing
	// masonry surrounds
	#local MaxX = ((Width2 / 2) - (.1 * Size));
	#local MinX = (.4 * Size);
	
	box {<MaxX,0,0><(MaxX - MinX),NH1,-.05> texture{T_wind1}}
	box {<MaxX,0,0><(MaxX - MinX),NH1,-.05> scale <-1,1,1> texture{T_wind1}} 
	
	// timber frame
	
    box {<(MaxX - MinX),0,-.025><(MaxX - MinX - .05),NH1,0> texture{T_wind2}} 
    box {<(MaxX - MinX),0,-.025><(MaxX - MinX - .05),NH1,0> scale <-1,1,1> texture{T_wind2}}
    
    #local TR_Qty = int(NH1 / .5);
    #local TR_Offset = (NH1 / TR_Qty);
    
    #local Transom = box {<(MaxX - MinX),.025,-.025><((MaxX - MinX) * -1),-.025,0>}
    
	#local Count1 = 0;
	#while (Count1 < (TR_Qty + 1))
		object {Transom translate <0,(TR_Offset * Count1),0> texture{T_wind2}}
		#local Count1 = (Count1 + 1);
	#end   
	
	box {<-.05,0,0><.05,NH1,-.025> texture{T_wind2}}
	
	// the glass
	
	box {<(MaxX - MinX),0,0><((MaxX - MinX) * -1),NH1,-.01> texture{T_wind3}} 
	
	// step five the balcony switch
	
	#if (Balcony = 1)     
	
		#local Fl_Offset = (-.21 * Size);
		WD_Balcony (Width2,Style,Size,<0,Fl_Offset,0>)
	
	#end

#end 

// door macro
#macro WD_Door (Width,Style,Size,Type)
    
    // Step one the columns
	#local Origin1 = <(Width / 2),0,0>;
	#local Origin2 = <((Width / 2) * -1),0,0>;
	#if (Type = 1)
		Classic_Column (Origin1,Style,Size)
		Classic_Column (Origin2,Style,Size)
	#else
		S_Classic_Column (Origin1,Style,Size)
		S_Classic_Column (Origin2,Style,Size)
	#end
	
	// step two the pediment
	#local Win_Ped = union {Pediment (Width,Style,Size)}
	
    #if (Style = 1) #local NH1 = (2.2 * Size); #end  
	#if (Style = 2) #local NH1 = (2.4 * Size); #end
	#if (Style = 3) #local NH1 = (2.6 * Size); #end
	#if (Style = 4) #local NH1 = (2.8 * Size); #end
	#if (Style = 5) #local NH1 = (3.2 * Size); #end  
	
	object {Win_Ped translate (<0,NH1,0> + Origin2)}
		
	// step four the window frame and glazing
	// masonry surrounds
	#local Width2 = (Width + (.5 * Size));
	#local NH2 = (.21 * Size * -1);
	
	#local MaxX = ((Width2 / 2) - (.1 * Size));
	#local MinX = (.4 * Size);
	
	box {<MaxX,0,0><(MaxX - MinX),NH1,-.05> texture{T_wind1}}
	box {<MaxX,0,0><(MaxX - MinX),NH1,-.05> scale <-1,1,1> texture{T_wind1}} 
	
	// timber frame
	
    box {<(MaxX - MinX),0,-.025><(MaxX - MinX - .05),NH1,0> texture{T_wind5}} 
    box {<(MaxX - MinX),0,-.025><(MaxX - MinX - .05),NH1,0> scale <-1,1,1> texture{T_wind5}}
    
    #local TR_Qty = int(NH1 / .5);
    #local TR_Offset = (NH1 / TR_Qty);
    
    #local Transom = box {<(MaxX - MinX),.025,-.025><((MaxX - MinX) * -1),-.025,0>}
    
	#local Count1 = 0;
	#while (Count1 < (TR_Qty + 1))
		object {Transom translate <0,(TR_Offset * Count1),0> texture{T_wind5}}
		#local Count1 = (Count1 + 1);
	#end   
	
	box {<-.05,0,0><.05,NH1,-.025> texture{T_wind5}}
	
	// the glass
	
	box {<(MaxX - MinX),0,0><((MaxX - MinX) * -1),NH1,-.01> texture{T_wind6}} 
	
#end 


// EOF