// Base Bozo Texture
#declare Bricks1 = 
  pigment
  {
    bozo
    turbulence 0.8
    color_map
    {
      [0.00 color rgb<0.000, 0.000, 0.000>]
      [0.07 color rgb<0.522, 0.435, 0.322>]
      [0.15 color rgb<0.741, 0.471, 0.251>]
      [0.24 color rgb<0.745, 0.486, 0.227>]
      [0.43 color rgb<0.380, 0.329, 0.118>]
      [0.49 color rgb<0.886, 0.584, 0.282>]
      [0.64 color rgb<0.694, 0.573, 0.416>]
      [0.68 color rgb<0.447, 0.369, 0.020>]
      [0.78 color rgb<0.573, 0.412, 0.251>]
      [1.00 color rgb<0.671, 0.302, 0.039>]
    }
    scale 100
}
  
 
#declare Bricks2 = pigment{
	Bricks1
	warp {repeat <8,0,0> offset <0,45,0>}
	warp {repeat <0,3,0> offset <60,0,0>} 
} 

#declare Bricks3 = texture {
	pigment {Bricks2 turbulence .05}
	normal {granite .1}
}

#declare Mortar = 
pigment{
	rgb <.8,.7,.6>
}
 
#declare Bricks4 =
texture{
 	pigment{brick pigment{Mortar} pigment{Bricks2}scale <.07,.03,.07>}
 	finish {phong .05} 
 	normal {brick .25 scale <.07,.03,.07>} 
}
 
#declare Bricks5 =
texture {
  pigment
  {
    granite
    color_map
    {
      [0.00 color rgb<0.000, 0.000, 0.000>]
      [0.07 color rgb<0.522, 0.435, 0.322>]
      [0.15 color rgb<0.741, 0.471, 0.251>]
      [0.24 color rgb<0.745, 0.486, 0.227>]
      [0.43 color rgb<0.380, 0.329, 0.118>]
      [0.49 color rgb<0.886, 0.584, 0.282>]
      [0.64 color rgb<0.694, 0.573, 0.416>]
      [0.68 color rgb<0.447, 0.369, 0.020>]
      [0.78 color rgb<0.573, 0.412, 0.251>]
      [1.00 color rgb<0.671, 0.302, 0.039>]
    }
    scale 1
  }
}
texture {
  pigment
  {
    bozo
    turbulence 0.8
    color_map
    {
      [0.00 color rgbf<0.843, 0.655, 0.482, 0.514>]
      [0.06 color rgbf<1.000, 1.000, 1.000, 1.000>]
      [0.12 color rgbf<0.616, 0.482, 0.224, 0.090>]
      [0.16 color rgbf<0.800, 0.784, 0.675, 0.337>]
      [0.36 color rgbf<0.667, 0.435, 0.114, 0.624>]
      [0.46 color rgbf<0.906, 0.722, 0.569, 0.416>]
      [0.55 color rgbf<0.910, 0.827, 0.608, 1.000>]
      [0.65 color rgbf<0.659, 0.490, 0.259, 0.741>]
      [0.79 color rgbf<0.886, 0.608, 0.349, 0.196>]
      [0.87 color rgbf<0.678, 0.439, 0.247, 0.188>]
      [0.92 color rgbf<0.973, 0.780, 0.565, 0.533>]
      [1.00 color rgbf<1.000, 1.000, 1.000, 1.000>]
    }   
    scale .5
  }
  finish {crand 0.2 phong .05}
  normal {brick .15 scale <.07,.03,.07>}
}
     
#macro Bricks7 (Div1,Div2,Size,Rtype)
texture{
	bozo
	texture_map {
		[0.0 Bricks4 scale (1 / Size)]
		[Div1 Bricks4 scale (1 / Size)]
		[(Div1 + Div2) Bricks5 scale (1 / Size)]
		[1.0 Bricks5 scale (1 / Size)]
	}
	scale Size 
	#if (Rtype = 1)
		rotate <0,90,0>
	#end
}
#end
          
#macro Render1 (Cbase) 

#local Cbase2 = <0.690, 0.533, 0.400>;
#local Cbase3 = (Cbase * <1,1,1>);

#if (Cbase3.x = 0)
	#local Cmultiply = Cbase2;
#else
	#local Cmultiply = Cbase3;
#end

texture{pigment{
	crackle
    color_map
    {
      [0.00 color rgb (<0.808, 0.592, 0.376> - Cbase2 + Cmultiply)]
      [0.27 color rgb (<0.937, 0.776, 0.663> - Cbase2 + Cmultiply)]
      [0.49 color rgb (<0.922, 0.749, 0.514> - Cbase2 + Cmultiply)]
      [0.79 color rgb Cmultiply]
      [1.00 color rgb (<0.835, 0.690, 0.604> - Cbase2 + Cmultiply)]
    }        
    turbulence 2  octaves 10  omega 0.2  lambda 5.0 
    scale 2
	}  
	normal {
		average
		normal_map {
			[crackle .2 scale .2 turbulence .5]
			[granite .3 poly_wave 0.5 scale <.7,.5,.5> turbulence 0.5]
		}
	}
	finish{phong .2}
}

#end

#macro Render2 (Cbase) 
	#declare Render3 = Render1 (Cbase)
#end

#macro Render4 (Div1,Div2,Size,Rtype)
	texture{
		bozo
		texture_map {
			[0.0 Render3 scale (1 / Size)]
			[Div1 Render3 scale (1 / Size)]
			[(Div1 + Div2) Bricks4 scale (1 / Size)]
			[1.0 Bricks4 scale (1 / Size)]
		}
		scale Size 
		#if (Rtype = 1)
			rotate <0,90,0>
		#end
	}

#end

#macro Combined1 (Div1,Div2,Size,Rtype)
	#declare Combined2 = Bricks7 (.5,.2,1,0)
#end

#macro Combined3 (Div1,Div2,Size,Rtype)
	#declare Combined4 = Render4 (.7,.15,1,0)
#end

#macro Combined5 (Scale,Ytrans,Rtype)
	texture {
		gradient y
		texture_map {
			[0.0 Combined2 scale (1 / Scale)]
			[0.2 Combined2 scale (1 / Scale)]
			[0.6 Combined4 scale (1 / Scale)]
			[1.0 Combined4 scale (1 / Scale)]
		}
		scale Scale
		translate <0,Ytrans,0>
		#if (Rtype = 1)
			rotate <0,90,0>
		#end
	}
#end  

// capping stone texture
#declare T_Boxcap = texture{pigment{White}}

// corner stone texture
#declare T_BXCstone = texture
{
  pigment
  {
    bozo
    turbulence 1.2
    color_map
    {
      [0.00 color rgb<0.506, 0.541, 0.635>]
      [0.28 color rgb<0.863, 0.882, 0.949>]
      [0.45 color rgb<0.663, 0.690, 0.761>]
      [0.65 color rgb<0.808, 0.839, 0.925>]
      [0.81 color rgb<0.600, 0.604, 0.616>]
      [1.00 color rgb<0.780, 0.780, 0.780>]
    }
  }
  finish {
    specular 0.4    roughness 0.01
    phong 1.0
    reflection 0.1
  }
}



// EOF