#include "colors.inc" 

background {rgb <1,1,1>} 
global_settings {max_trace_level 15}

camera {
	location <40,-1.5,-100>//<18,16,-50>
	look_at  <-10,-1.5,0>//<-10,16,0> 	
}

light_source {<-500,500,-500> color White} 
light_source {<200,50,-500> color Gray50}     

#declare Radiosity_effects 	= on;
#declare Effects_high 		= on; 
#declare Switch_Bridge		= on;
#declare Switch_Central		= on;
#declare Switch_Theatre		= on;
#declare Switch_Towers		= on; 
#declare Switch_Stairs		= on;
#declare Switch_Skies		= on;
#declare Switch_Smoke		= on;
#declare Switch_Speed 		= off;

// RADIOSITY
#if (Radiosity_effects = on)
// Constants used by 'rad_def.inc' are set in 'const.inc'
#include "consts.inc"
#if (Effects_high = off)
	#declare Rad_Quality = Radiosity_Debug;
	#else
	#declare Rad_Quality = Radiosity_Normal;
#end

#include "rad_def.inc"
#end    

#include "imagine.inc"

#include "13lib.inc" 
#include "13col3.inc"         
#include "13entab.inc"
#include "13sqtemple.inc" 
#include "13rntemple.inc" 
#include "13balus.inc"
#include "13dome.inc"
#include "13windor.inc"
#include "13tower.inc"
#include "13box.inc"

// THE SPECIAL WEIRD FEATURE
#declare Weird_Featue =
union {
	cylinder {<0,0,0><0,0,-.2>,1.5 texture{T_13Gold1}}
	
	cylinder {<0,.75,0><0,.75,-6>,.2 texture{T_13Gold1}} 
	cylinder {<0,0,0><0,0,-5>,.2 texture{T_13Gold1}}
	cylinder {<0,-.75,0><0,-.75,-4>,.2 texture{T_13Gold1}}
	
	
	sphere {<0,.75,-6>,.2 texture{T_13Gold1}} 
	sphere {<0,0,-5>,.2 texture{T_13Gold1}}
	sphere {<0,-.75,-4>,.2 texture{T_13Gold1}} 
	
	cone {<0,0,-.2>,1.25,<0,.75,-3>,.25 texture{T_13Gold1}}  
	cone {<0,0,-.2>,1,<0,0,-2>,.25 texture{T_13Gold1}} 
	cone {<0,0,-.2>,1,<0,-.75,-2>,.25 texture{T_13Gold1}} 
	sphere {<0,0,-.2>,1.25 texture{T_13Gold1}}   
	
	box {<.1,.75,0><-.1,2,-3> texture{T_13Gold1}} 
	box {<.1,2,-3><-.1,3,-2> texture{T_13Gold1}}
}

// water plane
plane {y,-5 pigment{rgb <.5,.5,.8>} finish{reflection .5 phong 1} normal{bumps .05 scale 2}}

#if (Switch_Bridge = on)
	#include "bridge.inc"
	object {Bridge}
	object {Bridge translate <7.5,0,50>} 
	
	#declare APanel_Frame = 
	difference { 
		union {
			box {<-2.75,4,-11><2.75,11,-11.1> texture{T_13Stone2}}
			box {<-2.5,4.25,-11><2.5,10.75,-11.2> texture{T_13Stone2}}
		}
		box {<-2.25,4.5,1><2.25,10.5,-12> texture{T_13Stone2}}
	}  

	#declare AFrame1 =
	union {
		object {APanel_Frame}
		box {<0,0,0><1,1,-.01> texture{pigment{image_map{gif "land4.gif"}}} scale <4.5,6,1> translate <-2.25,4.5,-11>}
	}
	
	#declare AFrame2 =
	union {
		object {APanel_Frame}
		box {<0,0,0><1,1,-.01> texture{pigment{image_map{gif "land5.gif"}}} scale <4.5,6,1> translate <-2.25,4.5,-11>}
	}  

	object {AFrame1} 
	object {AFrame2 translate <7.5,0,50>}
#end

#if (Switch_Central = on)
	#include "central.inc"
	object {Central_Arch translate <-60,0,60>} 
#end     

#if (Switch_Theatre = on)
	#include "theatre.inc"
	object {Theatre translate <-157,0,205>}
#end

#if (Switch_Towers = on)
	#include "towers.inc"
	object {Tower1 translate <-170,100,150>}  
	object {Tower2 translate <0,70,100>}
	
	object {Tower3 translate <120,120,0> rotate <0,-40,0> translate <-157,0,205>}   
#end

#include "skies.inc"
#if (Switch_Skies = on)
	
	box {<-1000,-500,800><1000,2000,801>
	pigment {
	        gradient y
	        pigment_map {
	            [0.01 rgb <0.847, 0.749, 0.847> ] // horizon
	            [0.25 P_Cloud2 scale 0.25 rotate z*5]
	            [0.60 P_Cloud3 scale <0.25, 0.15, 0.25> rotate z*10]
	        }
	        scale 800
	    }   
	} 

	fog {distance 800 color rgb<1,1,1> turbulence <.1,.05,.01>} 
#else
	sky_sphere {S_Cloud1}
#end

#if (Switch_Stairs = on)

	#include "stairs.inc"

#end    
    
#if (Switch_Smoke = on)    
    
	#include "smoke.inc" 

	#declare New_Smoke_Array1 = array[14]{
		<-70,20,20>,<10,0,0>
		<-60,30,30>,<20,0,0>
		<-65,40,35>,<15,0,0>
		<-55,50,45>,<10,0,0>
		<-75,60,55>,<11,0,0>
		<-75,70,65>,<12,0,0>
		<-75,80,65>,<15,0,0>
	} 
	
	#declare New_Smoke_Array2 = array[14]{
		<-180,80,160>,<20,0,0>
		<-190,90,160>,<20,0,0> 
		<-190,100,170>,<10,0,0> 
		<-200,120,160>,<20,0,0>  
		<-200,140,170>,<20,0,0>
		<-180,120,160>,<20,0,0> 
		<-170,100,170>,<20,0,0>
	}
	
	Smoke (New_Smoke_Array1,off) 
	Smoke (New_Smoke_Array2,off)

#end

// eof