// Persistence of Vision Ray Tracer Scene Description File
// File: .inc
// Vers: 3.1
// Desc: bridge
// Date: feb 99
// Auth: Nathan O'Brien
// Mail: no13@no13.net
// Webp: www.no13.net
// Copyright: (C) Nathan G B O'Brien 1998 

// arch texture
#declare T_Centre_Arch2 =
texture {
	radial
	texture_map {
		[0.0 T_13Stone1]
		[0.5 T_13Stone1]
		[0.5 T_13Stone2]
		[1.0 T_13Stone2]
	}
	rotate <90,0,0>
	frequency 13
}

#declare Steps_Length = 100;
#declare Steps_Depth = -5;


#declare Bridge =
union {



// MAIN BRIDGE PILLAR

BOX (<-7,0,-12>,<7,1.5,12>,0,0,1,.25,0)	// LOWER STEP
BOX (<-6,1.5,-11>,<6,3,11>,0,0,1,0,0)   // SECOND STEP 
BOX (<-5,3,-10>,<5,18,10>,1,5,5,.5,0)   // CENTRE PILLAR 

BOX (<-5,1.5,-11.75>,<5,2,-11>,0,0,1,1,0)   // THREE STEP 1
BOX (<-4.5,2,-11.5>,<4.5,2.5,-11>,0,0,1,1,0)   // THREE STEP 2 
BOX (<-4,2.5,-11.25>,<4,3,-11>,0,0,1,1,0)   // THREE STEP 3   

box {<-5.75,8.5,-10.75><5.75,11.5,10.75> texture{T_13Stone1 scale .25}} 
box {<-6,9,-11><6,11,11> texture{T_13Stone1 scale .25}}    

box {<-3.5,3,-10><3.5,9,-10.5> texture{T_13Stone1 scale .25}}
box {<-3,3,-10><3,9,-11> texture{T_13Stone1 scale .25}}

box {<5,3,-3.5><5.5,9,3.5> texture{T_13Stone1 scale .25}}
box {<5,3,-3><6,9,3> texture{T_13Stone1 scale .25}}

BOX (<-8,0,-13>,<8,Steps_Depth,Steps_Length>,0,0,1,.5,0)   // CENTRE PILLAR 

// sculptural feature

box {<0,11,-3><8.5,11.5,3> texture{T_13Stone1 scale .25}} 
box {<0,11.5,-3.5><9,13.5,3.5> texture{T_13Stone1 scale .25}}
box {<0,13.5,-3><8.5,14,3> texture{T_13Stone1 scale .25}}
box {<0,14,-2.5><8,14.5,2.5> texture{T_13Stone1 scale .25}}

difference {
	box {<0,8,2.5><7.75,11,-2.5> texture{T_13Stone1 scale .25}}
	box {<10,0,10><-10,-10,-10> rotate <0,0,45> translate <5.75,8,0> texture{T_13Stone1 scale .25}}
}

#include "beethovan.inc"
object {Beethovan scale .75 rotate <0,90,0> translate <7,18.5,0> texture{T_13Stone2}}  

#declare Sheild = 
union {
	cylinder {<0,0,-.1><0,0,.1>,2.25 pigment{Black}finish{phong 1}}
	#local Count1 = 0;
	#while (Count1 < 31)
		cylinder {<0,0,-.2><2,0,0>,.2 rotate <0,0,(Count1 * (360 / 31))> texture{T_13Gold1}}
		#local Count1 = (Count1 + 1);
	#end
	cylinder {<0,0,0><0,0,-.4>,1 texture{T_13Gold1}}
	text {ttf "artistik.ttf", "13", .5, 0 scale 2 translate <-.75,-.5,-.41> texture{T_13Stone2}}
}  

object {Sheild translate <6.5,16,-3.5>}
object {Sheild translate <6.5,16,3.5>}

// front feature

object {union {E_Arch_One (<0,11.5,-10>,2,3)}} 

// rings
#declare Pull_Ring =
union {
	cylinder {<0,0,.5><0,0,-.3>,.2 texture{T_13Iron}}
	torus {.5,.2 sturm rotate <0,0,90> translate <0,0,-.7> texture{T_13Iron}}
	torus {1,.25 sturm rotate <90,0,0> translate <0,-1,-.7> texture{T_13Iron}}
}

object {Pull_Ring translate <-4.5,10,-11>} 
object {Pull_Ring translate <4.5,10,-11>}  
object {Pull_Ring rotate <0,-90,0> translate <6.75,9,0>}
	

// top rail
object {union {BL_Rectangular (12,22,4,1,1)} translate <0,18,-11>} 
object {union {BL_Divider (<4,18,-11.25>,1.5)} texture{T_13Stone2}}
object {union {BL_Divider (<-4,18,-11.25>,1.5)} texture{T_13Stone2}} 

// step pyramid to top of pillar
#local Count1 = 0;
#local Steps = 15;
#local CSwitch = 0;
#while (Count1 < Steps) 
	#local Step_Up = .3;
	#local Step_Across = .15;
	
	box {<(-4.5 + (Count1 * Step_Across)),(18 + (Count1 * Step_Up)),(-9.5 + (Count1 * Step_Across))>
	     <(4.5 - (Count1 * Step_Across)),((18 + Step_Up) + (Count1 * Step_Up)),(9.5 - (Count1 * Step_Across))> 
		#if (CSwitch = 0)	  
			texture{T_13Copper1}
		#else
			texture{T_13Copper2}
		#end
	}	    
	#if (CSwitch = 0) #local CSwitch = 1; #else #local CSwitch = 0; #end		
	#local Count1 = (Count1 + 1);
#end   
object {union {BL_Rectangular (4.8,14.8,4,1,1)} translate <0,22.5,-7.4>}



// the pillar
object { 
	union {
		TW_One (2.1,10,5,0,2)
	} 
	translate <4,28,0>
}

// second pillar feature
#declare SP_Feature =
union {              
	cylinder {<0,0,0><0,2,0>,5 texture{T_13Stone2}}
	torus {5,.25 sturm translate <0,1.75,0> texture{T_13Gold1}}  
	cone {<0,6,0>,2.1,<0,12,0>,.5 texture{T_13Stone2}}
	
	#local Count1 = 0;
	#local Qty = 30;  
	#local Switch = 1; 
	
	#local SP_Rotate =
	union {
		cylinder {<0,1.8,4.8><0,5,1.5>,.4}
		sphere {<0,5,1.5>,.4}
		sphere {<0,1.8,4.8>,.4}
		
		cylinder {<0,5,2.5><0,6,2.5>,.4}
		sphere {<0,6,2.5>,.4}
		sphere {<0,5,2.5>,.4}  
		
		cylinder {<0,10,1.75><0,9,1.75>,.2} 
		sphere {<0,9,1.75>,.2}
		sphere {<0,10,1.75>,.2}
	}
	
	#while (Count1 < Qty)  
	
		object {SP_Rotate rotate <0,(Count1 * (360 / Qty)),0> 
			#if (Switch = 1) texture{T_13Copper1} #else texture{T_13Copper2} #end
		}
	
		#local Count1 = (Count1 + 1);
		#if (Switch = 1) #local Switch = 0; #else #local Switch = 1; #end
	#end 
	
	object {Weird_Featue rotate <0,-90,0> translate <4,3,0>}
	object {Weird_Featue rotate <0,90,0> translate <-4,3,0>} 
	
	BL_Circular (2.5,5,<0,6.4,0>)
	
	BL_Circular (1.75,3,<0,10.2,0>)
	
}

// second pillar
#declare Second_Pillar =
union {   
	BOX (<-7,0,-12>,<7,1.5,12>,0,0,1,.25,0)	// LOWER STEP
	BOX (<-6,1.5,-11>,<6,3,11>,0,0,1,0,0)   // SECOND STEP 
	BOX (<-5,3,-10>,<5,18,10>,1,5,5,.5,0)   // CENTRE PILLAR 

	BOX (<-5,1.5,-11.75>,<5,2,-11>,0,0,1,1,0)   // THREE STEP 1
	BOX (<-4.5,2,-11.5>,<4.5,2.5,-11>,0,0,1,1,0)   // THREE STEP 2 
	BOX (<-4,2.5,-11.25>,<4,3,-11>,0,0,1,1,0)   // THREE STEP 3  
	
	BOX (<-8,0,-13>,<8,-5,13>,0,0,1,.5,0) 		// base    
	
	#local PCol = union {S_Classic_Column (<0,0,0>,4,4.28)}
	object {PCol translate <3,3,-10>}
	object {PCol translate <-3,3,-10>}  
	
	// feature element on top of pillar
	object {SP_Feature translate <0,18,-5>}
	
}   
object {Second_Pillar translate <-35,0,0>}



// arch
        
difference {
	box {<-5,1.5,9><-35,15,-9> texture{T_Centre_Arch2 translate <-17.5,1.5,0>}} 
	cylinder {<-17.5,1.5,-50><-17.5,1.5,50>,10.5 texture{T_Centre_Arch2 translate <-17.5,1.5,0>}}  
	cylinder {<-17.5,1.5,-50><-17.5,1.5,-8.2>,12 texture{T_Centre_Arch2 translate <-17.5,1.5,0>}}  
}

object {union {E_Arch_One (<-17.5,1.5,-8.2>,10.5,5)}}
box {<-5,15.1,-8><-35,14,-9.1> texture{T_13Stone2}} 

difference {
	box {<-8.5,13.5,-9.2><-26.5,16,-8> texture{T_13Stone1}} 
	box {<-9.5,13.75,-10><-25.5,15.75,-7> texture{T_13Stone1}}
}  
box {<-8.5,15.75,-9.4><-26.5,16,-9.4> texture{T_13Stone2}}
box {<0,0,0><1,1,.01>
	texture{pigment{image_map{gif "land3.gif"}}}
	scale <16,2,1>
	translate <-25.5,13.75,-9.15>
}

}



// the returning wall 
	#local Wlen = -47;

	BOX (<-40,0,-11>,<Wlen,1.5,11>,0,0,1,.25,0)	// LOWER STEP
	BOX (<-40,1.5,-10>,<Wlen,3,10>,0,0,1,0,0)   // SECOND STEP 
	BOX (<-40,3,-9>,<Wlen,15,9>,1,0,1,.5,0)   // CENTRE PILLAR 
	BOX (<-40,0,-12>,<Wlen,-5,12>,0,0,1,.5,0) 	// BASE	 
	
	box {<-40,15.1,-8><Wlen,14,-9.1> texture{T_13Stone2}}
	
// returning wall 2    


	BOX (<-60,0,0>,<(Wlen + 2),1.5,-30>,0,0,1,.25,0)	// LOWER STEP
	BOX (<-60,1.5,0>,<(Wlen + 1),3,-30>,0,0,1,0,0)   // SECOND STEP 
	BOX (<-60,3,0>,<Wlen,18,-30>,1,5,5,.5,0)   // CENTRE PILLAR 
	BOX (<-60,0,0>,<(Wlen + 3),-5,-302>,0,0,1,.5,0) 	// BASE	

