// SMOKE MACRO

// global declares

#declare Smoke_Rand 			= seed(13); 
#declare Max_Spawned_Component 	= 10;
#declare Max_Spawned_Radius 	= .75;
#declare Min_Spawned_Radius 	= .25; 
#declare Recursion_Limit		= 5;
#declare Smoke_Threshold		= .75;

// resulting declare
#declare New_Rad_Range = (Max_Spawned_Radius - Min_Spawned_Radius); 

// density declares
#declare Density1 =
density {
	crackle
	color_map {
		[0.0 rgb <0,0,0>]
		[1.0 rgb <.5,.5,.5>]
	}
	turbulence .7
	scale 1
}

#declare Density2 =
density {
	bozo
	color_map {
		[0.0 rgb <0,0,0>]
		[1.0 rgb <.5,.5,.5>]
	}
	scale 1.5
}

// new point macro sequence

#macro Select_New_Point (Point,Radius)

	#local S1 = rand(Smoke_Rand);
	#if (S1 < .5) #local S1 = 1; #else #local S1 = -1; #end
	#local S2 = rand(Smoke_Rand);
	#if (S2 < .5) #local S2 = 1; #else #local S2 = -1; #end
	#local S3 = rand(Smoke_Rand);
	#if (S3 < .5) #local S3 = 1; #else #local S3 = -1; #end 
	
	#local New_Point = vnormalize (<(rand(Smoke_Rand) * S1),(rand(Smoke_Rand) * S2),(rand(Smoke_Rand) * S3)>); 
	
	((New_Point * Radius * Smoke_Threshold * .75) + Point);

#end 

// recursive component macro 

#macro Create_Component (Point,Radius,Recursion)

	// stage one. create initial component
	sphere {Point,Radius,1}
	
	#if (Recursion < Recursion_Limit)	// recursion test case
	
		#local Next_Recursion = (Recursion + 1);
		#local Spawned_Quantity = int(rand(Smoke_Rand) * Max_Spawned_Component);
		#local Count1 = 0;
		
		#while (Count1 < Spawned_Quantity) 
		
			#local Point2 = Select_New_Point (Point,Radius)
			#local Radius2 = ((New_Rad_Range * rand(Smoke_Rand) + Min_Spawned_Radius) * Radius);
			
			Create_Component (Point2,Radius2,Next_Recursion)
		
			#local Count1 = (Count1 + 1);
		#end
	
	#end

#end

// primary macro

#macro Smoke (Points_Array,Speed_Switch)

	// start blob object 

	#declare Smoke_Object =	
	blob {
	threshold Smoke_Threshold

	// start blob components
	
	#local Array_Length = dimension_size(Points_Array,1);
	#local Count1 = 0;
	#while (Count1 < (Array_Length / 2)) 
	
		#local New_Component = Points_Array[(Count1 * 2)];
		#local Component_Origin = <New_Component.x,New_Component.y,New_Component.z>; 
		
		#local Second_Component = Points_Array[((Count1 * 2) + 1)]; 
		#local Component_Radius = Second_Component.x; 
		
		Create_Component (Component_Origin,Component_Radius,0)		// start recursive function
	
		#local Count1 = (Count1 + 1);
	#end

	// end blob object
	} 
	
	#if (Speed_Switch = off)
	
	// emission definition
	object {Smoke_Object
	pigment{rgbt<1,1,1,1>}
	hollow
	interior {
		media {
			emission <.75,.75,.75>
			density{Density1}
			density{Density2}
		}
	}}
	
	// absorption definition
	object {Smoke_Object
	pigment{rgbt<1,1,1,1>}
	hollow
	interior {
		media {
			absorption <.75,.75,.75>
			density{Density1}
			density{Density2}
		}
	}
	scale .9
	translate <0,-1,0>
	}
	
	#else
	
	object {Smoke_Object pigment{White}}
	
	#end

#end

// eof