// Persistence of Vision Ray Tracer Scene Description File
// File: .inc
// Vers: 3.1
// Desc: curved theatre
// Date: Feb 99
// Auth: Nathan O'Brien
// Mail: no13@no13.net
// Webp: www.no13.net
// Copyright: (C) Nathan G B O'Brien 1998 

// SPEED SWITCHED


// BIG LOWER OPENINGS
#declare Big_Opening = union {WD_Door (15,4,15,1)}

// 	SMALL UPPER OPENING
#declare Small_Opening = union {WD_Window (7,4,7,1,1)}

// the curved theatre

#declare Theatre =  
union {

difference {
	cylinder {<0,-10,0>,<0,67,0>,100 texture{T_13Stone1}} 
	cylinder {<0,-20,0><0,120,0>,80 texture{T_13Stone1}}  
	box {<-500,-500,0><500,500,-500> texture{T_13Stone1}}
}  

	box {<100,-10,0><80,67,-50> texture{T_13Stone1}}
	box {<-100,-10,0><-80,67,-50> texture{T_13Stone1}}

difference {
	cylinder {<0,-10,0>,<0,67,0>,175 texture{T_13Stone1}} 
	cylinder {<0,-20,0><0,120,0>,155 texture{T_13Stone1}}  
	box {<-500,-500,0><500,500,-500> texture{T_13Stone1}}
}  

difference {
	cylinder {<0,67,0>,<0,110,0>,95 texture{T_13Stone1}} 
	cylinder {<0,-20,0><0,120,0>,85 texture{T_13Stone1}}  
	box {<-500,-500,0><500,500,-500> texture{T_13Stone1}}
}  

	box {<95,67,0><85,110,-50> texture{T_13Stone1}}
	box {<-95,67,0><-85,110,-50> texture{T_13Stone1}}

difference {
	cylinder {<0,67,0>,<0,110,0>,175 texture{T_13Stone1}} 
	cylinder {<0,-20,0><0,120,0>,160 texture{T_13Stone1}}  
	box {<-500,-500,0><500,500,-500> texture{T_13Stone1}}
}

difference {
	cylinder {<0,116,0>,<0,110,0>,100 texture{T_13Stone1}} 
	cylinder {<0,-20,0><0,120,0>,80 texture{T_13Stone1}}  
	box {<-500,-500,0><500,500,-500> texture{T_13Stone1}}
}  

	box {<100,116,0><80,110,-50> texture{T_13Stone1}}
	box {<-80,116,0><-100,110,-50> texture{T_13Stone1}}

difference {
	cylinder {<0,116,0>,<0,110,0>,175 texture{T_13Stone1}} 
	cylinder {<0,-20,0><0,120,0>,155 texture{T_13Stone1}}  
	box {<-500,-500,0><500,500,-500> texture{T_13Stone1}}
}

  

#local Qty = 8;
#local Count1 = 0;
#while (Count1 < Qty)
	object {Big_Opening rotate <0,90,0> translate <155,0,0> rotate <0,(Count1 * (-90 / Qty)),0>} 
	#local Count1 = (Count1 + 1);
#end


#local Qty = 10;
#local Count1 = 0;
#while (Count1 < (Qty + 1))
	object {Big_Opening rotate <0,90,0> translate <80,0,0> rotate <0,(Count1 * (-180 / Qty)),0>} 
	#local Count1 = (Count1 + 1);
#end


#local Qty = 6;
#local Count1 = 0;
#while (Count1 < Qty)
	object {Big_Opening rotate <0,-90,0> translate <100,0,0> rotate <0,(Count1 * (-90 / Qty)),0>} 
	#local Count1 = (Count1 + 1);
#end

object {Big_Opening rotate <0,-90,0> translate <100,0,-30>} 
object {Big_Opening rotate <0,-90,0> translate <-80,0,-30>} 

#if (Switch_Speed = off)
#declare TEntab_Set =
union {

difference {
	union {
		object {union {E_Circular (80,4,10,1,1)} translate <0,60,0>}	
		object {union {E_Circular (100,4,10,0,1)} translate <0,60,0>}  
		object {union {E_Circular (155,4,10,1,1)} translate <0,60,0>}
	}
	box {<-500,-500,0><500,500,-500> texture{T_13Stone1}}  
	bounded_by {
		difference {
			cylinder {<0,55,0><0,70,0>,200}   
			cylinder {<0,50,0><0,75,0>,60}
			box {<-200,40,0><200,80,-200>}
		}
	}
}

object {union {E_Length (50,4,10)} rotate <0,-90,0> translate <100,60,-50>}	
object {union {E_Length (50,4,10)} rotate <0,-90,0> translate <-80,60,-50>}	
object {union {E_Base_ICC (0,1,10)} scale <-1,1,1> translate <100,60,-50>}
}

object {TEntab_Set}   
object {TEntab_Set translate <0,50,0>}

#end



#local TColumn1 = union {Classic_Column (<97,67,0>,4,15)}
#local TColumn2 = union {Classic_Column (<83,67,0>,4,15)}
#local TColumn3 = union {Classic_Column (<158,67,0>,4,15)}

#local Qty = 5;
#local Count1 = 0; 
#while (Count1 < (Qty + 1))
	object {TColumn1 rotate <0,(Count1 * (-90 / Qty)),0>}
	#local Count1 = (Count1 + 1);
#end 

#local Qty = 14;
#local Count1 = 0; 
#while (Count1 < (Qty + 1))
	object {TColumn2 rotate <0,(Count1 * (-180 / Qty)),0>}
	object {Small_Opening rotate <0,90,0> translate <83,77,0> rotate <0,((Count1 * (-180 / Qty)) + (-90 / Qty)),0>}
	#local Count1 = (Count1 + 1);
#end

#local Qty = 10;
#local Count1 = 0; 
#while (Count1 < (Qty + 1))
	object {TColumn3 rotate <0,(Count1 * (-90 / Qty)),0>}  
	object {Small_Opening rotate <0,90,0> translate <158,77,0> rotate <0,((Count1 * (-90 / Qty)) + (-45 / Qty)),0>}
	#local Count1 = (Count1 + 1);
#end


object {TColumn1 translate <0,0,-30>} 
object {TColumn2 rotate <0,180,0> translate <0,0,-20>}
object {Small_Opening rotate <0,-90,0> translate <97,77,-15>}

}

